package latexDraw.ui.listeners;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

import latexDraw.filters.TeXFilter;
import latexDraw.lang.LaTeXDrawLang;
import latexDraw.ui.LaTeXDrawFrame;
import latexDraw.ui.dialog.PreferencesFrame;

/** 
 * This class allows the program to listen interaction with the menu items concerning
 * the recent files management.<br>
 * <br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE.  See the GNU General Public License for more details.<br>
 * <br>
 * 
 * 09/15/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 * @since 1.9<br>
 */
public class RecentFilesListener extends AbstractListener implements ActionListener
{
	public static final String ACTION_CMD_RECENT_CLEAR = "clearRecents";//$NON-NLS-1$
	
	/** The prefix of the action command of "recent files" menus. */
	public static final String RECENT_PREFIX_CMD = "RECENT_";//$NON-NLS-1$
	
	
	protected PreferencesFrame preferencesFrame;
	
	
	
	
	/**
	 * The constructor.
	 * @param prefFrame The frame of preferences.
	 * @param frame The main frame of the program.
	 */
	public RecentFilesListener(PreferencesFrame prefFrame, LaTeXDrawFrame frame)
	{
		super(frame);
		preferencesFrame = prefFrame;
		mainFrame = frame;
	}
	
	
	
	public void actionPerformed(ActionEvent e)
	{
    	Object src = e.getSource();

    	if(src instanceof JMenuItem)
    	{
    		AbstractButton ab = ((AbstractButton)src);
    		String label = ab.getActionCommand();
    		
    		if(label.equals(ACTION_CMD_RECENT_CLEAR))
    		{
    			preferencesFrame.getRecentFilesName().clear();
    			preferencesFrame.writeXMLPreferences(false);
    			mainFrame.getLMenuBar().updateRecentFilesMenu();
    			
    			return ;
    		}
    		
    		if(label.compareTo(RECENT_PREFIX_CMD)>0)
    		{
    			String path = label.substring(RECENT_PREFIX_CMD.length());
    			boolean ok = false;
    			
    			if(path.toLowerCase().endsWith(TeXFilter.TEX_EXTENSION))
    			{
    		    	if(mainFrame.getDrawPanel().isModified())
    		    		switch(JOptionPane.showConfirmDialog(mainFrame,
    							LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.156"), //$NON-NLS-1$
    							LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.110"),  //$NON-NLS-1$
    							JOptionPane.YES_NO_CANCEL_OPTION))
    					{
    		    			case JOptionPane.YES_OPTION:
    		    					boolean saved = mainFrame.save(true);
    		    					
    		    					ok = saved ? mainFrame.importPSTricksFile(path) : false;
    		    					break;
    		    					
    		    			case JOptionPane.NO_OPTION:
    		    					ok = mainFrame.importPSTricksFile(path);
    		    					break;
    		    					
    						case JOptionPane.CANCEL_OPTION:
    								ok = true;
    								break;				
    					}
    		    	else
    		    		ok = mainFrame.importPSTricksFile(path);
    			}
    			else
    		    	if(mainFrame.getDrawPanel().isModified())
    		    		switch(JOptionPane.showConfirmDialog(mainFrame,
    							LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.156"), //$NON-NLS-1$
    							LaTeXDrawLang.getStringLaTeXDrawFrame("LaTeXDrawFrame.110"),  //$NON-NLS-1$
    							JOptionPane.YES_NO_CANCEL_OPTION))
    					{
    		    			case JOptionPane.YES_OPTION:
    		    					boolean saved = mainFrame.save(true);
    		    					
    		    					ok = saved ? mainFrame.open(path, false) : false ;
    		    					break;
    		    					
    		    			case JOptionPane.NO_OPTION:
    		    					ok = mainFrame.open(path, false);
    								break;
    								
    						case JOptionPane.CANCEL_OPTION:
    								ok = true;
    								break;				
    					}
    		    	else
    		    		ok = mainFrame.open(path, false);
    			
    			if(!ok)
					JOptionPane.showMessageDialog(mainFrame, 
				 		   LaTeXDrawLang.getString1_9("RecentFilesListener.0"), //$NON-NLS-1$
				 		   LaTeXDrawLang.getString1_9("RecentFilesListener.1"),  //$NON-NLS-1$
				 		    JOptionPane.WARNING_MESSAGE); 
    			
    			return ;
    		}
    	}
	}
}
