.\" @(#)$RCSfile: Cns_getcomment.man,v $ $Revision: 4015 $ $Date: 2010-12-13 11:48:43 +0100 (Mon, 13 Dec 2010) $ CERN IT-PDP/DM Jean-Philippe Baud
.\" Copyright (C) 2000-2010 by CERN/IT/PDP/DM
.\" All rights reserved
.\"
.TH CNS_GETCOMMENT 3 "$Date: 2010-12-13 11:48:43 +0100 (Mon, 13 Dec 2010) $" CASTOR "Cns Library Functions"
.SH NAME
Cns_getcomment \- get the comment associated with a CASTOR file/directory in the name server
.SH SYNOPSIS
.B #include <sys/types.h>
.br
\fB#include "Cns_api.h"\fR
.sp
.BI "int Cns_getcomment (const char *" path ,
.BI "char *" comment )
.SH DESCRIPTION
.B Cns_getcomment
gets the comment associated with a CASTOR file/directory in the name server.
.TP
.I path
specifies the logical pathname relative to the current CASTOR directory or
the full CASTOR pathname.
.TP
.I comment
points at a buffer to receive the comment.
The buffer must be at least CA_MAXCOMMENTLEN+1 characters long.
.SH RETURN VALUE
This routine returns 0 if the operation was successful or -1 if the operation
failed. In the latter case,
.B serrno
is set appropriately.
.SH ERRORS
.TP 1.3i
.B ENOENT
The named directory does not exist or is a null pathname or there is no comment
associated with this path.
.TP
.B EACCES
Search permission is denied on a component of the
.I path
prefix or the caller effective user ID does not match the owner ID of the file
or read permission on the file/directory itself is denied.
.TP
.B EFAULT
.I path
or
.I comment
is a NULL pointer.
.TP
.B ENAMETOOLONG
The length of
.I path
exceeds
.B CA_MAXPATHLEN
or the length of a
.I path
component exceeds
.BR CA_MAXNAMELEN .
.TP
.B SENOSHOST
Host unknown.
.TP
.B SENOSSERV
Service unknown.
.TP
.B SECOMERR
Communication error.
.TP
.B ENSNACT
Name server is not running or is being shutdown.
.SH SEE ALSO
.BR Castor_limits(4) ,
.BR Cns_chdir(3)
.SH AUTHOR
\fBCASTOR\fP Team <castor.support@cern.ch>
