/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Gerben Venekamp <venekamp@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


/*!
    \file   lcmaps_gss_assist_gridmap.c
    \brief  legacy interface for LCMAPS
    \author Martijn Steenbakkers for the EU DataGrid.

    The legacy interface to the LCMAPS module is the original gridmap interface 
    provided by globus. Given the user distinguished name (DN) a username is returned, 
    based on the gridmap file
    -# globus_gss_assist_gridmap: the interface
*/

#ifndef LCMAPS_GSS_ASSIST_GRIDMAP_C
#define LCMAPS_GSS_ASSIST_GRIDMAP_C

#include "lcmaps_config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pwd.h>

/* LCMAPS includes */
#include "lcmaps.h"
#include "lcmaps_gss_assist_gridmap.h"

int
globus_gss_assist_gridmap(
    char *   globusidp,
    char **  useridp
)
{
    FILE *   usrlog_fp=stderr;
    int retval;

    fprintf(stderr,"Using globus_gss_assist_gridmap interface of LCMAPS\n");
    if (useridp == NULL)
        return 1;

    *useridp = NULL;

    /* Initialize, do user mapping and terminate LCMAPS */
    retval=lcmaps_init(usrlog_fp);
    if (retval)
    {
        fprintf(stderr,"LCMAPS initialization failure.\n");
        return 1;
    }
    retval = lcmaps_run_without_credentials_and_return_username(
            globusidp,
            NULL,
            useridp,
            0,
            NULL);
    if (retval)
    {
        fprintf(stderr,"LCMAPS failed to find a username\n");
        return 1;
    }

    retval=lcmaps_term();
    if (retval)
    {
        fprintf(stderr,"LCMAPS termination failure\n");
        return 1;
    }
    fprintf(stderr,"globus_gss_assist_gridmap interface of LCMAPS done\n");

    return 0;
}

#endif /* LCMAPS_GSS_ASSIST_GRIDMAP_C */

/******************************************************************************
CVS Information:
    $Source: /srv/home/dennisvd/svn/mw-security/lcmaps/src/lcmaps_gss_assist_gridmap.c,v $
    $Date: 2011-03-04 21:55:13 +0100 (Fri, 04 Mar 2011) $
    $Revision: 14868 $
    $Author: dennisvd $
******************************************************************************/
