%%
%%  Copyright 1994-2013 Olivier Girondel
%%
%%  This file is part of lebiniou.
%%
%%  lebiniou is free software: you can redistribute it and/or modify
%%  it under the terms of the GNU General Public License as published by
%%  the Free Software Foundation, either version 2 of the License, or
%%  (at your option) any later version.
%%
%%  lebiniou is distributed in the hope that it will be useful,
%%  but WITHOUT ANY WARRANTY; without even the implied warranty of
%%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%%  GNU General Public License for more details.
%%
%%  You should have received a copy of the GNU General Public License
%%  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
%%

%%
%% Automagically generated
%% DO NOT EDIT !!!
%%

-define(BT_NONE, 0).
-define(BT_PICTFADER, 1).
-define(BT_CMAPFADER, 2).
-define(BT_PLUGINS, 3).
-define(BT_CONTEXT, 4).
-define(BT_SEQMGR, 5).
-define(BT_LAST, 6).
-define(BC_NONE, 0).
-define(BC_QUIT, 1).
-define(BC_PREV, 2).
-define(BC_NEXT, 3).
-define(BC_RANDOM, 4).
-define(BC_SWITCH, 5).
-define(BC_RESET, 6).
-define(BC_SELECT, 7).
-define(BC_RELOAD, 8).
-define(BC_SET, 9).
-define(BC_INFO, 10).
-define(BC_MOVE, 11).
-define(BC_SAVE, 12).
-define(BC_USE_BANKSET, 13).
-define(BC_STORE_BANK, 14).
-define(BC_USE_BANK, 15).
-define(BC_CLEAR_BANK, 16).
-define(BC_SAVE_BANKS, 17).
-define(BC_SET_BANKMODE, 18).
-define(BC_LAST, 19).
-define(BA_NONE, 0).
-define(BA_RANDOM, 1).
-define(BA_SEQUENCE, 2).
-define(BA_SCHEME, 3).
-define(BA_COLORMAPS, 4).
-define(BA_PICTURES, 5).
-define(BA_FULLSCREEN, 6).
-define(BA_ROTATIONS, 7).
-define(BA_BOUNDARY, 8).
-define(BA_OSD, 9).
-define(BA_OSD_CMAP, 10).
-define(BA_CURSOR, 11).
-define(BA_UP, 12).
-define(BA_SAVE, 13).
-define(BA_SCREENSHOT, 14).
-define(BA_DOWN, 15).
-define(BA_PREV, 16).
-define(BA_NEXT, 17).
-define(BA_LAYER_MODE, 18).
-define(BA_FPS, 19).
-define(BA_SELECTED, 20).
-define(BA_LENS, 21).
-define(BA_OVERWRITE, 22).
-define(BA_BYPASS, 23).
-define(BA_WEBCAM, 24).
-define(BA_PULSE, 25).
-define(BA_LAST, 26).

cmd(To, Cmd, Arg) ->
    {biniou, node()} ! {cmd, <<To, Cmd, Arg>>}.


%% =============== Context ===============

%% Next OSD mode
cmd("C1") -> cmd(?BT_CONTEXT, ?BC_NEXT, ?BA_OSD);
%% Next 3D boundary
cmd("C2") -> cmd(?BT_CONTEXT, ?BC_NEXT, ?BA_BOUNDARY);
%% Toggle 3D auto rotations
cmd("C3") -> cmd(?BT_CONTEXT, ?BC_SWITCH, ?BA_ROTATIONS);
%% Display current colormap
cmd("C4") -> cmd(?BT_CONTEXT, ?BC_SWITCH, ?BA_OSD_CMAP);
%% Toggle full-screen on/off
cmd("C5") -> cmd(?BT_CONTEXT, ?BC_SWITCH, ?BA_FULLSCREEN);
%% Show/hide mouse cursor
cmd("C6") -> cmd(?BT_CONTEXT, ?BC_SWITCH, ?BA_CURSOR);
%% Increase fps
cmd("C7") -> cmd(?BT_CONTEXT, ?BC_NEXT, ?BA_FPS);
%% Decrease fps
cmd("C8") -> cmd(?BT_CONTEXT, ?BC_PREV, ?BA_FPS);
%% Quit
cmd("C9") -> cmd(?BT_CONTEXT, ?BC_QUIT, ?BA_NONE);
%% Save the current sequence then exit
cmd("C10") -> cmd(?BT_CONTEXT, ?BC_QUIT, ?BA_SAVE);
%% Fill current frame with random pixels
cmd("C11") -> cmd(?BT_CONTEXT, ?BC_RESET, ?BA_RANDOM);
%% Clear the current frame
cmd("C12") -> cmd(?BT_CONTEXT, ?BC_RESET, ?BA_SEQUENCE);
%% Turn off all auto changes
cmd("C13") -> cmd(?BT_CONTEXT, ?BC_RESET, ?BA_NONE);
%% Toggle selected plugin on/off
cmd("C14") -> cmd(?BT_CONTEXT, ?BC_SWITCH, ?BA_SELECTED);
%% Use previous sequence
cmd("C15") -> cmd(?BT_CONTEXT, ?BC_PREV, ?BA_SEQUENCE);
%% Use next sequence
cmd("C16") -> cmd(?BT_CONTEXT, ?BC_NEXT, ?BA_SEQUENCE);
%% Take a screenshot
cmd("C17") -> cmd(?BT_CONTEXT, ?BC_SAVE, ?BA_SCREENSHOT);
%% Make a sequence from system schemes
cmd("C18") -> cmd(?BT_CONTEXT, ?BC_RANDOM, ?BA_SCHEME);
%% Select a random user sequence
cmd("C19") -> cmd(?BT_CONTEXT, ?BC_RANDOM, ?BA_SEQUENCE);
%% Next random mode
cmd("C20") -> cmd(?BT_CONTEXT, ?BC_NEXT, ?BA_RANDOM);
%% Previous random mode
cmd("C21") -> cmd(?BT_CONTEXT, ?BC_PREV, ?BA_RANDOM);
%% Auto colormaps on/off
cmd("C22") -> cmd(?BT_CONTEXT, ?BC_SWITCH, ?BA_COLORMAPS);
%% Auto pictures on/off
cmd("C23") -> cmd(?BT_CONTEXT, ?BC_SWITCH, ?BA_PICTURES);
%% Use the most recent sequence
cmd("C24") -> cmd(?BT_CONTEXT, ?BC_RELOAD, ?BA_SEQUENCE);
%% Bypass mode on/off
cmd("C25") -> cmd(?BT_CONTEXT, ?BC_SWITCH, ?BA_BYPASS);
%% Set webcam reference picture
cmd("C26") -> cmd(?BT_CONTEXT, ?BC_SET, ?BA_WEBCAM);
%% Select next webcam
cmd("C29") -> cmd(?BT_CONTEXT, ?BC_NEXT, ?BA_WEBCAM);
%% Switch 3d cube on/off
cmd("C27") -> cmd(?BT_CONTEXT, ?BC_SWITCH, ?BA_BOUNDARY);
%% Toggle 3D world pulse on/off
cmd("C28") -> cmd(?BT_CONTEXT, ?BC_SWITCH, ?BA_PULSE);

%% =============== Plugins ===============

%% Select previous plugin
cmd("P1") -> cmd(?BT_PLUGINS, ?BC_PREV, ?BA_NONE);
%% Select next plugin
cmd("P2") -> cmd(?BT_PLUGINS, ?BC_NEXT, ?BA_NONE);
%% Scroll up in the plugins list
cmd("P3") -> cmd(?BT_PLUGINS, ?BC_SELECT, ?BA_UP);
%% Scroll down in the plugins list
cmd("P4") -> cmd(?BT_PLUGINS, ?BC_SELECT, ?BA_DOWN);

%% =============== Sequence ===============

%% Reset the current sequence
cmd("S1") -> cmd(?BT_SEQMGR, ?BC_RESET, ?BA_SEQUENCE);
%% Toggle selected plugin as a lens on/off
cmd("S2") -> cmd(?BT_SEQMGR, ?BC_SWITCH, ?BA_LENS);
%% Select previous plugin in the sequence
cmd("S3") -> cmd(?BT_SEQMGR, ?BC_PREV, ?BA_NONE);
%% Select next plugin in the sequence
cmd("S4") -> cmd(?BT_SEQMGR, ?BC_NEXT, ?BA_NONE);
%% Move selected plugin up in the sequence
cmd("S5") -> cmd(?BT_SEQMGR, ?BC_MOVE, ?BA_UP);
%% Move selected plugin down in the sequence
cmd("S6") -> cmd(?BT_SEQMGR, ?BC_MOVE, ?BA_DOWN);
%% Select default layer mode for the current plugin
cmd("S7") -> cmd(?BT_SEQMGR, ?BC_RESET, ?BA_LAYER_MODE);
%% Select next layer mode
cmd("S9") -> cmd(?BT_SEQMGR, ?BC_NEXT, ?BA_LAYER_MODE);
%% Save current sequence as new
cmd("S10") -> cmd(?BT_SEQMGR, ?BC_SAVE, ?BA_SEQUENCE);
%% Update current sequence
cmd("S11") -> cmd(?BT_SEQMGR, ?BC_SAVE, ?BA_OVERWRITE);

%% =============== Colormaps ===============

%% Select previous colormap
cmd("CO1") -> cmd(?BT_CMAPFADER, ?BC_SELECT, ?BA_PREV);
%% Select next colormap
cmd("CO2") -> cmd(?BT_CMAPFADER, ?BC_SELECT, ?BA_NEXT);
%% Select random colormap
cmd("CO3") -> cmd(?BT_CMAPFADER, ?BC_SELECT, ?BA_RANDOM);

%% =============== Pictures ===============

%% Select previous picture
cmd("PI1") -> cmd(?BT_PICTFADER, ?BC_SELECT, ?BA_PREV);
%% Select next picture
cmd("PI2") -> cmd(?BT_PICTFADER, ?BC_SELECT, ?BA_NEXT);
%% Select random picture
cmd("PI3") -> cmd(?BT_PICTFADER, ?BC_SELECT, ?BA_RANDOM);

%% =============== Banks ===============

%% Set bank mode to sequences
cmd("BM1") -> cmd(?BT_CONTEXT, ?BC_SET_BANKMODE, 0);
%% Set bank mode to colormaps
cmd("BM2") -> cmd(?BT_CONTEXT, ?BC_SET_BANKMODE, 1);
%% Set bank mode to pictures
cmd("BM3") -> cmd(?BT_CONTEXT, ?BC_SET_BANKMODE, 2);
%% Clear bank 1
cmd("CB1") -> cmd(?BT_CONTEXT, ?BC_CLEAR_BANK, 0);
%% Clear bank 2
cmd("CB2") -> cmd(?BT_CONTEXT, ?BC_CLEAR_BANK, 1);
%% Clear bank 3
cmd("CB3") -> cmd(?BT_CONTEXT, ?BC_CLEAR_BANK, 2);
%% Clear bank 4
cmd("CB4") -> cmd(?BT_CONTEXT, ?BC_CLEAR_BANK, 3);
%% Clear bank 5
cmd("CB5") -> cmd(?BT_CONTEXT, ?BC_CLEAR_BANK, 4);
%% Clear bank 6
cmd("CB6") -> cmd(?BT_CONTEXT, ?BC_CLEAR_BANK, 5);
%% Clear bank 7
cmd("CB7") -> cmd(?BT_CONTEXT, ?BC_CLEAR_BANK, 6);
%% Clear bank 8
cmd("CB8") -> cmd(?BT_CONTEXT, ?BC_CLEAR_BANK, 7);
%% Clear bank 9
cmd("CB9") -> cmd(?BT_CONTEXT, ?BC_CLEAR_BANK, 8);
%% Clear bank 10
cmd("CB10") -> cmd(?BT_CONTEXT, ?BC_CLEAR_BANK, 9);
%% Clear bank 11
cmd("CB11") -> cmd(?BT_CONTEXT, ?BC_CLEAR_BANK, 10);
%% Clear bank 12
cmd("CB12") -> cmd(?BT_CONTEXT, ?BC_CLEAR_BANK, 11);
%% Assign current sequence/colormap/picture to bank 1
cmd("SB1") -> cmd(?BT_CONTEXT, ?BC_STORE_BANK, 0);
%% Assign current sequence/colormap/picture to bank 2
cmd("SB2") -> cmd(?BT_CONTEXT, ?BC_STORE_BANK, 1);
%% Assign current sequence/colormap/picture to bank 3
cmd("SB3") -> cmd(?BT_CONTEXT, ?BC_STORE_BANK, 2);
%% Assign current sequence/colormap/picture to bank 4
cmd("SB4") -> cmd(?BT_CONTEXT, ?BC_STORE_BANK, 3);
%% Assign current sequence/colormap/picture to bank 5
cmd("SB5") -> cmd(?BT_CONTEXT, ?BC_STORE_BANK, 4);
%% Assign current sequence/colormap/picture to bank 6
cmd("SB6") -> cmd(?BT_CONTEXT, ?BC_STORE_BANK, 5);
%% Assign current sequence/colormap/picture to bank 7
cmd("SB7") -> cmd(?BT_CONTEXT, ?BC_STORE_BANK, 6);
%% Assign current sequence/colormap/picture to bank 8
cmd("SB8") -> cmd(?BT_CONTEXT, ?BC_STORE_BANK, 7);
%% Assign current sequence/colormap/picture to bank 9
cmd("SB9") -> cmd(?BT_CONTEXT, ?BC_STORE_BANK, 8);
%% Assign current sequence/colormap/picture to bank 10
cmd("SB10") -> cmd(?BT_CONTEXT, ?BC_STORE_BANK, 9);
%% Assign current sequence/colormap/picture to bank 11
cmd("SB11") -> cmd(?BT_CONTEXT, ?BC_STORE_BANK, 10);
%% Assign current sequence/colormap/picture to bank 12
cmd("SB12") -> cmd(?BT_CONTEXT, ?BC_STORE_BANK, 11);
%% Use sequence/colormap/picture in bank 1
cmd("UB1") -> cmd(?BT_CONTEXT, ?BC_USE_BANK, 0);
%% Use sequence/colormap/picture in bank 2
cmd("UB2") -> cmd(?BT_CONTEXT, ?BC_USE_BANK, 1);
%% Use sequence/colormap/picture in bank 3
cmd("UB3") -> cmd(?BT_CONTEXT, ?BC_USE_BANK, 2);
%% Use sequence/colormap/picture in bank 4
cmd("UB4") -> cmd(?BT_CONTEXT, ?BC_USE_BANK, 3);
%% Use sequence/colormap/picture in bank 5
cmd("UB5") -> cmd(?BT_CONTEXT, ?BC_USE_BANK, 4);
%% Use sequence/colormap/picture in bank 6
cmd("UB6") -> cmd(?BT_CONTEXT, ?BC_USE_BANK, 5);
%% Use sequence/colormap/picture in bank 7
cmd("UB7") -> cmd(?BT_CONTEXT, ?BC_USE_BANK, 6);
%% Use sequence/colormap/picture in bank 8
cmd("UB8") -> cmd(?BT_CONTEXT, ?BC_USE_BANK, 7);
%% Use sequence/colormap/picture in bank 9
cmd("UB9") -> cmd(?BT_CONTEXT, ?BC_USE_BANK, 8);
%% Use sequence/colormap/picture in bank 10
cmd("UB10") -> cmd(?BT_CONTEXT, ?BC_USE_BANK, 9);
%% Use sequence/colormap/picture in bank 11
cmd("UB11") -> cmd(?BT_CONTEXT, ?BC_USE_BANK, 10);
%% Use sequence/colormap/picture in bank 12
cmd("UB12") -> cmd(?BT_CONTEXT, ?BC_USE_BANK, 11);
%% Use bankset 1
cmd("B1") -> cmd(?BT_CONTEXT, ?BC_USE_BANKSET, 0);
%% Use bankset 2
cmd("B2") -> cmd(?BT_CONTEXT, ?BC_USE_BANKSET, 1);
%% Use bankset 3
cmd("B3") -> cmd(?BT_CONTEXT, ?BC_USE_BANKSET, 2);
%% Use bankset 4
cmd("B4") -> cmd(?BT_CONTEXT, ?BC_USE_BANKSET, 3);
%% Use bankset 5
cmd("B5") -> cmd(?BT_CONTEXT, ?BC_USE_BANKSET, 4);
%% Use bankset 6
cmd("B6") -> cmd(?BT_CONTEXT, ?BC_USE_BANKSET, 5);
%% Use bankset 7
cmd("B7") -> cmd(?BT_CONTEXT, ?BC_USE_BANKSET, 6);
%% Use bankset 8
cmd("B8") -> cmd(?BT_CONTEXT, ?BC_USE_BANKSET, 7);
%% Use bankset 9
cmd("B9") -> cmd(?BT_CONTEXT, ?BC_USE_BANKSET, 8);
%% Use bankset 10
cmd("B10") -> cmd(?BT_CONTEXT, ?BC_USE_BANKSET, 9);
%% Use bankset 11
cmd("B11") -> cmd(?BT_CONTEXT, ?BC_USE_BANKSET, 10);
%% Use bankset 12
cmd("B12") -> cmd(?BT_CONTEXT, ?BC_USE_BANKSET, 11);
%% Save the banks file
cmd("SB") -> cmd(?BT_CONTEXT, ?BC_SAVE_BANKS, ?BA_NONE);
cmd(_) -> ok.
