/* Wordpress.c generated by valac, the Vala compiler
 * generated from Wordpress.vala, do not modify */

/* Wordpress.vala
 *
 * Copyright (C) 2010  Kushal Das <kushal@fedoraproject.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libsoup/soup.h>


#define TYPE_WORDPRESS (wordpress_get_type ())
#define WORDPRESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORDPRESS, Wordpress))
#define WORDPRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORDPRESS, WordpressClass))
#define IS_WORDPRESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORDPRESS))
#define IS_WORDPRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORDPRESS))
#define WORDPRESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORDPRESS, WordpressClass))

typedef struct _Wordpress Wordpress;
typedef struct _WordpressClass WordpressClass;
typedef struct _WordpressPrivate WordpressPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

struct _Wordpress {
	GObject parent_instance;
	WordpressPrivate * priv;
	char* password;
	char* server;
};

struct _WordpressClass {
	GObjectClass parent_class;
};

struct _WordpressPrivate {
	char* _username;
};


static gpointer wordpress_parent_class = NULL;

GType wordpress_get_type (void);
#define WORDPRESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_WORDPRESS, WordpressPrivate))
enum  {
	WORDPRESS_DUMMY_PROPERTY,
	WORDPRESS_USERNAME
};
void wordpress_set_username (Wordpress* self, const char* value);
Wordpress* wordpress_new (void);
Wordpress* wordpress_construct (GType object_type);
const char* wordpress_get_username (Wordpress* self);
gboolean wordpress_set_details (Wordpress* self, const char* name, const char* pass, const char* serv);
char* wordpress_post (Wordpress* self, GHashTable* content, gboolean publish);
char* wordpress_update (Wordpress* self, const char* pid, GHashTable* content, gboolean publish);
static GValue* _g_value_dup (GValue* self);
char* wordpress_upload_file (Wordpress* self, GHashTable* data);
void wordpress_add_category (Wordpress* self, const char* category);
GHashTable* wordpress_get_last_post (Wordpress* self);
void wordpress_delete_post (Wordpress* self, gint id);
GHashTable* wordpress_get_post (Wordpress* self, const char* id);
gboolean wordpress_get_posts (Wordpress* self);
static void _vala_array_add1 (char*** array, int* length, int* size, char* value);
char** wordpress_get_categories (Wordpress* self, int* result_length1);
static void wordpress_finalize (GObject* obj);
static void wordpress_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void wordpress_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

Wordpress* wordpress_construct (GType object_type) {
	Wordpress * self;
	char* _tmp0_;
	char* _tmp1_;
	self = (Wordpress*) g_object_new (object_type, NULL);
	wordpress_set_username (self, "");
	self->password = (_tmp0_ = g_strdup (""), _g_free0 (self->password), _tmp0_);
	self->server = (_tmp1_ = g_strdup (""), _g_free0 (self->server), _tmp1_);
	return self;
}


Wordpress* wordpress_new (void) {
	return wordpress_construct (TYPE_WORDPRESS);
}


gboolean wordpress_set_details (Wordpress* self, const char* name, const char* pass, const char* serv) {
	gboolean result = FALSE;
	char* _tmp0_;
	char* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	g_return_val_if_fail (pass != NULL, FALSE);
	g_return_val_if_fail (serv != NULL, FALSE);
	if (((_vala_strcmp0 (self->priv->_username, name) == 0) & (_vala_strcmp0 (self->password, pass) == 0)) & (_vala_strcmp0 (self->server, serv) == 0)) {
		result = FALSE;
		return result;
	}
	wordpress_set_username (self, name);
	self->password = (_tmp0_ = g_strdup (pass), _g_free0 (self->password), _tmp0_);
	self->server = (_tmp1_ = g_strdup (serv), _g_free0 (self->server), _tmp1_);
	result = TRUE;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


char* wordpress_post (Wordpress* self, GHashTable* content, gboolean publish) {
	char* result = NULL;
	GError * _inner_error_;
	SoupMessage* message;
	SoupSessionAsync* session;
	char* data;
	GValue v = {0};
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (content != NULL, NULL);
	_inner_error_ = NULL;
	message = _g_object_ref0 (soup_xmlrpc_request_new (self->server, "metaWeblog.newPost", G_TYPE_INT, 1, G_TYPE_STRING, self->priv->_username, G_TYPE_STRING, self->password, G_TYPE_HASH_TABLE, content, G_TYPE_BOOLEAN, publish, G_TYPE_INVALID));
	session = (SoupSessionAsync*) soup_session_async_new ();
	soup_session_send_message ((SoupSession*) session, message);
	data = g_strdup (soup_message_body_flatten (message->response_body)->data);
	g_value_init (&v, G_TYPE_STRING);
	{
		soup_xmlrpc_parse_method_response (data, -1, &v, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_signal_emit_by_name (self, "password-error", e->message);
			result = g_strdup ("None");
			_g_error_free0 (e);
			_g_object_unref0 (message);
			_g_object_unref0 (session);
			_g_free0 (data);
			G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
			return result;
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (message);
		_g_object_unref0 (session);
		_g_free0 (data);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = g_strdup (g_value_get_string (&v));
	_g_object_unref0 (message);
	_g_object_unref0 (session);
	_g_free0 (data);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	return result;
}


char* wordpress_update (Wordpress* self, const char* pid, GHashTable* content, gboolean publish) {
	char* result = NULL;
	GError * _inner_error_;
	SoupMessage* message;
	SoupSessionAsync* session;
	char* data;
	GValue v = {0};
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (pid != NULL, NULL);
	g_return_val_if_fail (content != NULL, NULL);
	_inner_error_ = NULL;
	message = _g_object_ref0 (soup_xmlrpc_request_new (self->server, "metaWeblog.editPost", G_TYPE_STRING, pid, G_TYPE_STRING, self->priv->_username, G_TYPE_STRING, self->password, G_TYPE_HASH_TABLE, content, G_TYPE_BOOLEAN, publish, G_TYPE_INVALID));
	session = (SoupSessionAsync*) soup_session_async_new ();
	soup_session_send_message ((SoupSession*) session, message);
	data = g_strdup (soup_message_body_flatten (message->response_body)->data);
	g_value_init (&v, G_TYPE_BOOLEAN);
	{
		soup_xmlrpc_parse_method_response (data, -1, &v, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_signal_emit_by_name (self, "password-error", e->message);
			result = g_strdup ("None");
			_g_error_free0 (e);
			_g_object_unref0 (message);
			_g_object_unref0 (session);
			_g_free0 (data);
			G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
			return result;
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (message);
		_g_object_unref0 (session);
		_g_free0 (data);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	if (g_value_get_boolean (&v)) {
		result = g_strdup ("Post updated");
		_g_object_unref0 (message);
		_g_object_unref0 (session);
		_g_free0 (data);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		return result;
	} else {
		result = g_strdup ("None");
		_g_object_unref0 (message);
		_g_object_unref0 (session);
		_g_free0 (data);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		return result;
	}
	_g_object_unref0 (message);
	_g_object_unref0 (session);
	_g_free0 (data);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


char* wordpress_upload_file (Wordpress* self, GHashTable* data) {
	char* result = NULL;
	GError * _inner_error_;
	SoupMessage* message;
	SoupSessionAsync* session;
	char* returndata;
	GValue v = {0};
	GHashTable* hash;
	GValue* x;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	_inner_error_ = NULL;
	message = _g_object_ref0 (soup_xmlrpc_request_new (self->server, "wp.uploadFile", G_TYPE_INT, 1, G_TYPE_STRING, self->priv->_username, G_TYPE_STRING, self->password, G_TYPE_HASH_TABLE, data, G_TYPE_INVALID));
	session = (SoupSessionAsync*) soup_session_async_new ();
	soup_session_send_message ((SoupSession*) session, message);
	returndata = g_strdup (soup_message_body_flatten (message->response_body)->data);
	g_value_init (&v, G_TYPE_HASH_TABLE);
	{
		soup_xmlrpc_parse_method_response (returndata, -1, &v, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_signal_emit_by_name (self, "password-error", e->message);
			result = g_strdup ("");
			_g_error_free0 (e);
			_g_object_unref0 (message);
			_g_object_unref0 (session);
			_g_free0 (returndata);
			G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
			return result;
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (message);
		_g_object_unref0 (session);
		_g_free0 (returndata);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	hash = _g_hash_table_ref0 (g_value_get_boxed (&v));
	x = __g_value_dup0 ((GValue*) g_hash_table_lookup (hash, "url"));
	result = g_strdup (g_value_get_string (x));
	_g_object_unref0 (message);
	_g_object_unref0 (session);
	_g_free0 (returndata);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	_g_hash_table_unref0 (hash);
	_g_free0 (x);
	return result;
}


void wordpress_add_category (Wordpress* self, const char* category) {
	GHashTable* hash;
	GValue* _tmp0_ = NULL;
	SoupMessage* message;
	SoupSessionSync* session;
	g_return_if_fail (self != NULL);
	g_return_if_fail (category != NULL);
	hash = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	g_hash_table_insert (hash, g_strdup ("name"), (_tmp0_ = g_new0 (GValue, 1), g_value_init (_tmp0_, G_TYPE_STRING), g_value_set_string (_tmp0_, category), _tmp0_));
	message = _g_object_ref0 (soup_xmlrpc_request_new (self->server, "wp.newCategory", G_TYPE_INT, 1, G_TYPE_STRING, self->priv->_username, G_TYPE_STRING, self->password, G_TYPE_HASH_TABLE, hash, G_TYPE_INVALID));
	session = (SoupSessionSync*) soup_session_sync_new ();
	soup_session_send_message ((SoupSession*) session, message);
	_g_hash_table_unref0 (hash);
	_g_object_unref0 (message);
	_g_object_unref0 (session);
}


GHashTable* wordpress_get_last_post (Wordpress* self) {
	GHashTable* result = NULL;
	GError * _inner_error_;
	SoupMessage* message;
	SoupSessionAsync* session;
	guint return_code;
	char* data;
	GValueArray* v3;
	GValue v = {0};
	GHashTable* hash;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	message = _g_object_ref0 (soup_xmlrpc_request_new (self->server, "metaWeblog.getRecentPosts", G_TYPE_INT, 1, G_TYPE_STRING, self->priv->_username, G_TYPE_STRING, self->password, G_TYPE_INT, 1, G_TYPE_INVALID));
	session = (SoupSessionAsync*) soup_session_async_new ();
	return_code = soup_session_send_message ((SoupSession*) session, message);
	if (return_code == 2) {
		g_signal_emit_by_name (self, "password-error", "Please check your network");
		result = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
		_g_object_unref0 (message);
		_g_object_unref0 (session);
		return result;
	}
	data = g_strdup (soup_message_body_flatten (message->response_body)->data);
	v3 = NULL;
	g_value_init (&v, G_TYPE_VALUE_ARRAY);
	{
		soup_xmlrpc_parse_method_response (data, -1, &v, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_signal_emit_by_name (self, "password-error", e->message);
			result = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
			_g_error_free0 (e);
			_g_object_unref0 (message);
			_g_object_unref0 (session);
			_g_free0 (data);
			G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
			return result;
		}
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (message);
		_g_object_unref0 (session);
		_g_free0 (data);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	v3 = g_value_get_boxed (&v);
	hash = _g_hash_table_ref0 (g_value_get_boxed (g_value_array_get_nth (v3, (guint) 0)));
	result = hash;
	_g_object_unref0 (message);
	_g_object_unref0 (session);
	_g_free0 (data);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	return result;
}


void wordpress_delete_post (Wordpress* self, gint id) {
	SoupMessage* message;
	SoupSessionAsync* session;
	guint return_code;
	g_return_if_fail (self != NULL);
	message = _g_object_ref0 (soup_xmlrpc_request_new (self->server, "metaWeblog.deletePost", G_TYPE_INT, 1, G_TYPE_INT, id, G_TYPE_STRING, self->priv->_username, G_TYPE_STRING, self->password, G_TYPE_BOOLEAN, FALSE, G_TYPE_INVALID));
	g_debug ("Wordpress.vala:144: %s", soup_message_body_flatten (message->request_body)->data);
	session = (SoupSessionAsync*) soup_session_async_new ();
	return_code = soup_session_send_message ((SoupSession*) session, message);
	if (return_code == 2) {
		g_signal_emit_by_name (self, "password-error", "Please check your network");
		_g_object_unref0 (message);
		_g_object_unref0 (session);
		return;
	}
	_g_object_unref0 (message);
	_g_object_unref0 (session);
}


GHashTable* wordpress_get_post (Wordpress* self, const char* id) {
	GHashTable* result = NULL;
	GError * _inner_error_;
	SoupMessage* message;
	SoupSessionAsync* session;
	guint return_code;
	char* data;
	GValue v = {0};
	GHashTable* hash;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	_inner_error_ = NULL;
	message = _g_object_ref0 (soup_xmlrpc_request_new (self->server, "metaWeblog.getPost", G_TYPE_STRING, id, G_TYPE_STRING, self->priv->_username, G_TYPE_STRING, self->password, G_TYPE_INVALID));
	session = (SoupSessionAsync*) soup_session_async_new ();
	return_code = soup_session_send_message ((SoupSession*) session, message);
	if (return_code == 2) {
		g_signal_emit_by_name (self, "password-error", "Please check your network");
		result = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
		_g_object_unref0 (message);
		_g_object_unref0 (session);
		return result;
	}
	data = g_strdup (soup_message_body_flatten (message->response_body)->data);
	g_value_init (&v, G_TYPE_VALUE);
	{
		soup_xmlrpc_parse_method_response (data, -1, &v, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_signal_emit_by_name (self, "password-error", e->message);
			result = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
			_g_error_free0 (e);
			_g_object_unref0 (message);
			_g_object_unref0 (session);
			_g_free0 (data);
			G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
			return result;
		}
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (message);
		_g_object_unref0 (session);
		_g_free0 (data);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	hash = _g_hash_table_ref0 (g_value_get_boxed (&v));
	result = hash;
	_g_object_unref0 (message);
	_g_object_unref0 (session);
	_g_free0 (data);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	return result;
}


gboolean wordpress_get_posts (Wordpress* self) {
	gboolean result = FALSE;
	GError * _inner_error_;
	SoupMessage* message;
	SoupSessionAsync* session;
	guint return_code;
	char* data;
	GValueArray* v3;
	GValue v = {0};
	g_return_val_if_fail (self != NULL, FALSE);
	_inner_error_ = NULL;
	message = _g_object_ref0 (soup_xmlrpc_request_new (self->server, "metaWeblog.getRecentPosts", G_TYPE_INT, 1, G_TYPE_STRING, self->priv->_username, G_TYPE_STRING, self->password, G_TYPE_INT, 10, G_TYPE_INVALID));
	session = (SoupSessionAsync*) soup_session_async_new ();
	return_code = soup_session_send_message ((SoupSession*) session, message);
	if (return_code == 2) {
		g_signal_emit_by_name (self, "password-error", "Please check your network");
		result = FALSE;
		_g_object_unref0 (message);
		_g_object_unref0 (session);
		return result;
	}
	data = g_strdup (soup_message_body_flatten (message->response_body)->data);
	v3 = NULL;
	g_value_init (&v, G_TYPE_VALUE_ARRAY);
	{
		soup_xmlrpc_parse_method_response (data, -1, &v, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_signal_emit_by_name (self, "password-error", e->message);
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (message);
			_g_object_unref0 (session);
			_g_free0 (data);
			G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
			return result;
		}
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (message);
		_g_object_unref0 (session);
		_g_free0 (data);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	v3 = g_value_get_boxed (&v);
	if (v3 != NULL) {
		g_signal_emit_by_name (self, "get-old-posts", v3);
		result = FALSE;
		_g_object_unref0 (message);
		_g_object_unref0 (session);
		_g_free0 (data);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		return result;
	}
	result = TRUE;
	_g_object_unref0 (message);
	_g_object_unref0 (session);
	_g_free0 (data);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	return result;
}


static gboolean string_contains (const char* self, const char* needle) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	result = strstr (self, needle) != NULL;
	return result;
}


static void _vala_array_add1 (char*** array, int* length, int* size, char* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (char*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


char** wordpress_get_categories (Wordpress* self, int* result_length1) {
	char** result = NULL;
	GError * _inner_error_;
	SoupMessage* message;
	SoupSessionAsync* session;
	guint return_code;
	char* data;
	GValueArray* v3;
	GValue v = {0};
	char** _tmp9_;
	gint __result__size_;
	gint _result__length1;
	char** _tmp8_ = NULL;
	char** _result_;
	char** _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	message = _g_object_ref0 (soup_xmlrpc_request_new (self->server, "wp.getCategories", G_TYPE_INT, 1, G_TYPE_STRING, self->priv->_username, G_TYPE_STRING, self->password, G_TYPE_INVALID));
	session = (SoupSessionAsync*) soup_session_async_new ();
	return_code = soup_session_send_message ((SoupSession*) session, message);
	if (return_code == 2) {
		char** _tmp0_ = NULL;
		char** _tmp1_;
		g_signal_emit_by_name (self, "password-error", "Please check your network");
		result = (_tmp1_ = (_tmp0_ = g_new0 (char*, 0 + 1), _tmp0_), *result_length1 = 0, _tmp1_);
		_g_object_unref0 (message);
		_g_object_unref0 (session);
		return result;
	} else {
		if (return_code == 302) {
			char** _tmp2_ = NULL;
			char** _tmp3_;
			g_signal_emit_by_name (self, "password-error", "Error 302: may want to check username or url");
			result = (_tmp3_ = (_tmp2_ = g_new0 (char*, 0 + 1), _tmp2_), *result_length1 = 0, _tmp3_);
			_g_object_unref0 (message);
			_g_object_unref0 (session);
			return result;
		}
	}
	data = g_strdup (soup_message_body_flatten (message->response_body)->data);
	if (string_contains (data, "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"htt" \
"p://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">")) {
		char** _tmp4_ = NULL;
		char** _tmp5_;
		g_signal_emit_by_name (self, "password-error", "Error 302: may want to check username or url");
		result = (_tmp5_ = (_tmp4_ = g_new0 (char*, 0 + 1), _tmp4_), *result_length1 = 0, _tmp5_);
		_g_object_unref0 (message);
		_g_object_unref0 (session);
		_g_free0 (data);
		return result;
	}
	v3 = NULL;
	g_value_init (&v, G_TYPE_VALUE_ARRAY);
	{
		soup_xmlrpc_parse_method_response (data, -1, &v, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			char** _tmp6_ = NULL;
			char** _tmp7_;
			g_signal_emit_by_name (self, "password-error", e->message);
			result = (_tmp7_ = (_tmp6_ = g_new0 (char*, 0 + 1), _tmp6_), *result_length1 = 0, _tmp7_);
			_g_error_free0 (e);
			_g_object_unref0 (message);
			_g_object_unref0 (session);
			_g_free0 (data);
			G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
			return result;
			_g_error_free0 (e);
		}
	}
	__finally8:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (message);
		_g_object_unref0 (session);
		_g_free0 (data);
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	v3 = g_value_get_boxed (&v);
	_result_ = (_tmp9_ = (_tmp8_ = g_new0 (char*, 0 + 1), _tmp8_), _result__length1 = 0, __result__size_ = _result__length1, _tmp9_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp10_;
			_tmp10_ = TRUE;
			while (TRUE) {
				GHashTable* hash;
				GValue* x;
				if (!_tmp10_) {
					i++;
				}
				_tmp10_ = FALSE;
				if (!(i < v3->n_values)) {
					break;
				}
				hash = _g_hash_table_ref0 (g_value_get_boxed (g_value_array_get_nth (v3, (guint) i)));
				x = __g_value_dup0 ((GValue*) g_hash_table_lookup (hash, "description"));
				_vala_array_add1 (&_result_, &_result__length1, &__result__size_, g_strdup (g_value_get_string (x)));
				_g_hash_table_unref0 (hash);
				_g_free0 (x);
			}
		}
	}
	result = (_tmp11_ = _result_, *result_length1 = _result__length1, _tmp11_);
	_g_object_unref0 (message);
	_g_object_unref0 (session);
	_g_free0 (data);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	return result;
	_g_object_unref0 (message);
	_g_object_unref0 (session);
	_g_free0 (data);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) g_free), NULL);
}


const char* wordpress_get_username (Wordpress* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_username;
	return result;
}


void wordpress_set_username (Wordpress* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_username = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_username), _tmp0_);
	g_object_notify ((GObject *) self, "username");
}


static void wordpress_class_init (WordpressClass * klass) {
	wordpress_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (WordpressPrivate));
	G_OBJECT_CLASS (klass)->get_property = wordpress_get_property;
	G_OBJECT_CLASS (klass)->set_property = wordpress_set_property;
	G_OBJECT_CLASS (klass)->finalize = wordpress_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORDPRESS_USERNAME, g_param_spec_string ("username", "username", "username", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("password_error", TYPE_WORDPRESS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	g_signal_new ("get_old_posts", TYPE_WORDPRESS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED, G_TYPE_NONE, 1, G_TYPE_VALUE_ARRAY);
}


static void wordpress_instance_init (Wordpress * self) {
	self->priv = WORDPRESS_GET_PRIVATE (self);
}


static void wordpress_finalize (GObject* obj) {
	Wordpress * self;
	self = WORDPRESS (obj);
	_g_free0 (self->priv->_username);
	_g_free0 (self->password);
	_g_free0 (self->server);
	G_OBJECT_CLASS (wordpress_parent_class)->finalize (obj);
}


GType wordpress_get_type (void) {
	static volatile gsize wordpress_type_id__volatile = 0;
	if (g_once_init_enter (&wordpress_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WordpressClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wordpress_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Wordpress), 0, (GInstanceInitFunc) wordpress_instance_init, NULL };
		GType wordpress_type_id;
		wordpress_type_id = g_type_register_static (G_TYPE_OBJECT, "Wordpress", &g_define_type_info, 0);
		g_once_init_leave (&wordpress_type_id__volatile, wordpress_type_id);
	}
	return wordpress_type_id__volatile;
}


static void wordpress_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Wordpress * self;
	self = WORDPRESS (object);
	switch (property_id) {
		case WORDPRESS_USERNAME:
		g_value_set_string (value, wordpress_get_username (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void wordpress_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Wordpress * self;
	self = WORDPRESS (object);
	switch (property_id) {
		case WORDPRESS_USERNAME:
		wordpress_set_username (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__BOXED callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), data2);
}



