// Reconcile DEP-5 debian/copyright to licensecheck report on source tree
//
// Copyright : 2024 P Blackman
// License   : BSD-2-clause
//
// Exclude files and folders likely to lead to false positives

unit exclude;
{$mode delphi}

interface

function IgnoreFile (Fname : AnsiString) : Boolean;
function CompareEnd (FileName : AnsiString; TestName : String) : Boolean;


implementation uses StrUtils, SysUtils;
{$warn 6058 off} // Don't need to hear about inlining issues

// Check whether the test string is the start of the file name
function CompareBegin (FileName : AnsiString; TestName : String) : Boolean;
var EStr : String;

begin
    EStr   := LeftBStr (FileName, Length (TestName));
    result := AnsiCompareText (Testname, EStr) = 0;
end;

// Check whether the test String is the end of the file name
function CompareEnd (FileName : AnsiString; TestName : String) : Boolean;
var EStr : String;

begin
    EStr   := RightBStr (FileName, Length (TestName));
    result := AnsiCompareText (Testname, EStr) = 0;
end;


function IgnoreFile (Fname : AnsiString) : Boolean;
var FullName, Path : AnsiString;
begin
    FullName := ExtractFileName(Fname);
    Path     := ExtractFilePath(Fname);

    // These files often contain licenses for other files
    result := CompareBegin (FullName, 'about')      or
              CompareBegin (FullName, 'authors')    or
              CompareBegin (FullName, 'copying')    or
              CompareBegin (FullName, 'copyright')  or
              CompareBegin (FullName, 'dep5')       or
              CompareBegin (FullName, 'license')    or
              CompareBegin (FullName, 'readme')     or

    // autogenerated files often excluded from d/copyright
              CompareBegin (FullName, 'aclocal.m4')     or
              CompareBegin (FullName, 'config.guess')   or
              CompareBegin (FullName, 'config.status')  or
              CompareBegin (FullName, 'config.sub')     or
              CompareBegin (FullName, 'configure')      or
              CompareBegin (FullName, 'install-sh')     or
              CompareBegin (FullName, 'ltmain.sh')      or

              CompareBegin (Path,     'build-aux/')     or
              CompareBegin (Path,     'm4/')            or
              CompareBegin (Path,     'config/');
end;

end.
