/*
 * =======================================================================================
 *
 *      Filename:  pci_types.h
 *
 *      Description:  Types file for pci module.
 *
 *      Version:   5.3
 *      Released:  10.11.2023
 *
 *      Author:   Jan Treibig (jt), jan.treibig@gmail.com
 *                Thomas Gruber (tr), thomas.roehl@googlemail.com
 *      Project:  likwid
 *
 *      Copyright (C) 2023 RRZE, University Erlangen-Nuremberg
 *
 *      This program is free software: you can redistribute it and/or modify it under
 *      the terms of the GNU General Public License as published by the Free Software
 *      Foundation, either version 3 of the License, or (at your option) any later
 *      version.
 *
 *      This program is distributed in the hope that it will be useful, but WITHOUT ANY
 *      WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 *      PARTICULAR PURPOSE.  See the GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License along with
 *      this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * =======================================================================================
 */
#ifndef PCI_TYPES_H
#define PCI_TYPES_H

#include <stdint.h>

typedef enum {
    NODEVTYPE = 0,
    R3QPI,
    R2PCIE,
    IMC,
    HA,
    QPI,
    IRP,
    EDC,
    IIO,
    PCU,
    MAX_NUM_PCI_TYPES
} PciDeviceType;

typedef enum {
    MSR_DEV = 0,
    PCI_R3QPI_DEVICE_LINK_0,
    PCI_R3QPI_DEVICE_LINK_1,
    PCI_R3QPI_DEVICE_LINK_2,
    PCI_R3QPI_DEVICE_LINK_3,
    PCI_R2PCIE_DEVICE0,
    PCI_R2PCIE_DEVICE1,
    PCI_R2PCIE_DEVICE2,
    PCI_R2PCIE_DEVICE3,
    PCI_R2PCIE_DEVICE4,
    PCI_R2PCIE_DEVICE5,
    PCI_R2PCIE_DEVICE6,
    PCI_R2PCIE_DEVICE7,
    PCI_R2PCIE_DEVICE8,
    PCI_R2PCIE_DEVICE9,
    PCI_R2PCIE_DEVICE10,
    PCI_R2PCIE_DEVICE11,
    PCI_R2PCIE_DEVICE12,
    PCI_R2PCIE_DEVICE13,
    PCI_R2PCIE_DEVICE14,
    PCI_R2PCIE_DEVICE15,
    PCI_IMC_DEVICE_0_CH_0,
    PCI_IMC_DEVICE_0_CH_1,
    PCI_IMC_DEVICE_0_CH_2,
    PCI_IMC_DEVICE_0_CH_3,
    PCI_IMC_DEVICE_1_CH_0,
    PCI_IMC_DEVICE_1_CH_1,
    PCI_IMC_DEVICE_1_CH_2,
    PCI_IMC_DEVICE_1_CH_3,
    PCI_HA_DEVICE_0,
    PCI_HA_DEVICE_1,
    PCI_HA_DEVICE_2,
    PCI_HA_DEVICE_3,
    PCI_HA_DEVICE_4,
    PCI_HA_DEVICE_5,
    PCI_HA_DEVICE_6,
    PCI_HA_DEVICE_7,
    PCI_HA_DEVICE_8,
    PCI_HA_DEVICE_9,
    PCI_HA_DEVICE_10,
    PCI_HA_DEVICE_11,
    PCI_HA_DEVICE_12,
    PCI_HA_DEVICE_13,
    PCI_HA_DEVICE_14,
    PCI_HA_DEVICE_15,
    PCI_HA_DEVICE_16,
    PCI_HA_DEVICE_17,
    PCI_HA_DEVICE_18,
    PCI_HA_DEVICE_19,
    PCI_HA_DEVICE_20,
    PCI_HA_DEVICE_21,
    PCI_HA_DEVICE_22,
    PCI_HA_DEVICE_23,
    PCI_HA_DEVICE_24,
    PCI_HA_DEVICE_25,
    PCI_HA_DEVICE_26,
    PCI_HA_DEVICE_27,
    PCI_HA_DEVICE_28,
    PCI_HA_DEVICE_29,
    PCI_HA_DEVICE_30,
    PCI_HA_DEVICE_31,
    PCI_QPI_DEVICE_PORT_0,
    PCI_QPI_DEVICE_PORT_1,
    PCI_QPI_DEVICE_PORT_2,
    PCI_QPI_DEVICE_PORT_3,
    PCI_QPI_MASK_DEVICE_PORT_0,
    PCI_QPI_MASK_DEVICE_PORT_1,
    PCI_QPI_MASK_DEVICE_PORT_2,
    PCI_QPI_MASK_DEVICE_PORT_3,
    PCI_QPI_MISC_DEVICE_PORT_0,
    PCI_QPI_MISC_DEVICE_PORT_1,
    PCI_QPI_MISC_DEVICE_PORT_2,
    PCI_QPI_MISC_DEVICE_PORT_3,
    PCI_IRP_DEVICE,
    PCI_EDC0_UCLK_DEVICE,
    PCI_EDC0_DCLK_DEVICE,
    PCI_EDC1_UCLK_DEVICE,
    PCI_EDC1_DCLK_DEVICE,
    PCI_EDC2_UCLK_DEVICE,
    PCI_EDC2_DCLK_DEVICE,
    PCI_EDC3_UCLK_DEVICE,
    PCI_EDC3_DCLK_DEVICE,
    PCI_EDC4_UCLK_DEVICE,
    PCI_EDC4_DCLK_DEVICE,
    PCI_EDC5_UCLK_DEVICE,
    PCI_EDC5_DCLK_DEVICE,
    PCI_EDC6_UCLK_DEVICE,
    PCI_EDC6_DCLK_DEVICE,
    PCI_EDC7_UCLK_DEVICE,
    PCI_EDC7_DCLK_DEVICE,
    MMIO_IMC_DEVICE_0_CH_0,
    MMIO_IMC_DEVICE_0_CH_1,
    MMIO_IMC_DEVICE_0_CH_2,
    MMIO_IMC_DEVICE_0_CH_3,
    MMIO_IMC_DEVICE_0_CH_4,
    MMIO_IMC_DEVICE_0_CH_5,
    MMIO_IMC_DEVICE_0_CH_6,
    MMIO_IMC_DEVICE_0_CH_7,
    MMIO_IMC_DEVICE_1_CH_0,
    MMIO_IMC_DEVICE_1_CH_1,
    MMIO_IMC_DEVICE_1_CH_2,
    MMIO_IMC_DEVICE_1_CH_3,
    MMIO_IMC_DEVICE_1_CH_4,
    MMIO_IMC_DEVICE_1_CH_5,
    MMIO_IMC_DEVICE_1_CH_6,
    MMIO_IMC_DEVICE_1_CH_7,
    MMIO_IMC_DEVICE_2_CH_0,
    MMIO_IMC_DEVICE_2_CH_1,
    MMIO_IMC_DEVICE_3_CH_0,
    MMIO_IMC_DEVICE_3_CH_1,
    MMIO_IMC_DEVICE_0_FREERUN,
    MMIO_IMC_DEVICE_1_FREERUN,
    MMIO_IMC_DEVICE_2_FREERUN,
    MMIO_IMC_DEVICE_3_FREERUN,
    MMIO_IMC_DEVICE_4_FREERUN,
    MMIO_IMC_DEVICE_5_FREERUN,
    MMIO_IMC_DEVICE_6_FREERUN,
    MMIO_IMC_DEVICE_7_FREERUN,
    MMIO_IMC_DEVICE_8_FREERUN,
    MMIO_IMC_DEVICE_9_FREERUN,
    MMIO_IMC_DEVICE_10_FREERUN,
    MMIO_IMC_DEVICE_11_FREERUN,
    MMIO_IMC_DEVICE_12_FREERUN,
    MMIO_IMC_DEVICE_13_FREERUN,
    MMIO_IMC_DEVICE_14_FREERUN,
    MMIO_IMC_DEVICE_15_FREERUN,
    MMIO_HBM_DEVICE_0,
    MMIO_HBM_DEVICE_1,
    MMIO_HBM_DEVICE_2,
    MMIO_HBM_DEVICE_3,
    MMIO_HBM_DEVICE_4,
    MMIO_HBM_DEVICE_5,
    MMIO_HBM_DEVICE_6,
    MMIO_HBM_DEVICE_7,
    MMIO_HBM_DEVICE_8,
    MMIO_HBM_DEVICE_9,
    MMIO_HBM_DEVICE_10,
    MMIO_HBM_DEVICE_11,
    MMIO_HBM_DEVICE_12,
    MMIO_HBM_DEVICE_13,
    MMIO_HBM_DEVICE_14,
    MMIO_HBM_DEVICE_15,
    MMIO_HBM_DEVICE_16,
    MMIO_HBM_DEVICE_17,
    MMIO_HBM_DEVICE_18,
    MMIO_HBM_DEVICE_19,
    MMIO_HBM_DEVICE_20,
    MMIO_HBM_DEVICE_21,
    MMIO_HBM_DEVICE_22,
    MMIO_HBM_DEVICE_23,
    MMIO_HBM_DEVICE_24,
    MMIO_HBM_DEVICE_25,
    MMIO_HBM_DEVICE_26,
    MMIO_HBM_DEVICE_27,
    MMIO_HBM_DEVICE_28,
    MMIO_HBM_DEVICE_29,
    MMIO_HBM_DEVICE_30,
    MMIO_HBM_DEVICE_31,
    MSR_CBOX_DEVICE_C0,
    MSR_CBOX_DEVICE_C1,
    MSR_CBOX_DEVICE_C2,
    MSR_CBOX_DEVICE_C3,
    MSR_CBOX_DEVICE_C4,
    MSR_CBOX_DEVICE_C5,
    MSR_CBOX_DEVICE_C6,
    MSR_CBOX_DEVICE_C7,
    MSR_CBOX_DEVICE_C8,
    MSR_CBOX_DEVICE_C9,
    MSR_CBOX_DEVICE_C10,
    MSR_CBOX_DEVICE_C11,
    MSR_CBOX_DEVICE_C12,
    MSR_CBOX_DEVICE_C13,
    MSR_CBOX_DEVICE_C14,
    MSR_CBOX_DEVICE_C15,
    MSR_CBOX_DEVICE_C16,
    MSR_CBOX_DEVICE_C17,
    MSR_CBOX_DEVICE_C18,
    MSR_CBOX_DEVICE_C19,
    MSR_CBOX_DEVICE_C20,
    MSR_CBOX_DEVICE_C21,
    MSR_CBOX_DEVICE_C22,
    MSR_CBOX_DEVICE_C23,
    MSR_CBOX_DEVICE_C24,
    MSR_CBOX_DEVICE_C25,
    MSR_CBOX_DEVICE_C26,
    MSR_CBOX_DEVICE_C27,
    MSR_CBOX_DEVICE_C28,
    MSR_CBOX_DEVICE_C29,
    MSR_CBOX_DEVICE_C30,
    MSR_CBOX_DEVICE_C31,
    MSR_CBOX_DEVICE_C32,
    MSR_CBOX_DEVICE_C33,
    MSR_CBOX_DEVICE_C34,
    MSR_CBOX_DEVICE_C35,
    MSR_CBOX_DEVICE_C36,
    MSR_CBOX_DEVICE_C37,
    MSR_CBOX_DEVICE_C38,
    MSR_CBOX_DEVICE_C39,
    MSR_CBOX_DEVICE_C40,
    MSR_CBOX_DEVICE_C41,
    MSR_CBOX_DEVICE_C42,
    MSR_CBOX_DEVICE_C43,
    MSR_CBOX_DEVICE_C44,
    MSR_CBOX_DEVICE_C45,
    MSR_CBOX_DEVICE_C46,
    MSR_CBOX_DEVICE_C47,
    MSR_CBOX_DEVICE_C48,
    MSR_CBOX_DEVICE_C49,
    MSR_CBOX_DEVICE_C50,
    MSR_CBOX_DEVICE_C51,
    MSR_CBOX_DEVICE_C52,
    MSR_CBOX_DEVICE_C53,
    MSR_CBOX_DEVICE_C54,
    MSR_CBOX_DEVICE_C55,
    MSR_CBOX_DEVICE_C56,
    MSR_CBOX_DEVICE_C57,
    MSR_CBOX_DEVICE_C58,
    MSR_CBOX_DEVICE_C59,
    MSR_PBOX_DEVICE,
    MSR_PBOX_DEVICE_1,
    MSR_PBOX_DEVICE_2,
    MSR_PBOX_DEVICE_3,
    MSR_PBOX_DEVICE_4,
    MSR_PBOX_DEVICE_5,
    MSR_PCU_DEVICE,
    MSR_IIO_DEVICE,
    MSR_MDF_DEVICE_0,
    MSR_MDF_DEVICE_1,
    MSR_MDF_DEVICE_2,
    MSR_MDF_DEVICE_3,
    MSR_MDF_DEVICE_4,
    MSR_MDF_DEVICE_5,
    MSR_MDF_DEVICE_6,
    MSR_MDF_DEVICE_7,
    MSR_MDF_DEVICE_8,
    MSR_MDF_DEVICE_9,
    MSR_MDF_DEVICE_10,
    MSR_MDF_DEVICE_11,
    MSR_MDF_DEVICE_12,
    MSR_MDF_DEVICE_13,
    MSR_MDF_DEVICE_14,
    MSR_MDF_DEVICE_15,
    MSR_MDF_DEVICE_16,
    MSR_MDF_DEVICE_17,
    MSR_MDF_DEVICE_18,
    MSR_MDF_DEVICE_19,
    MSR_MDF_DEVICE_20,
    MSR_MDF_DEVICE_21,
    MSR_MDF_DEVICE_22,
    MSR_MDF_DEVICE_23,
    MSR_MDF_DEVICE_24,
    MSR_MDF_DEVICE_25,
    MSR_MDF_DEVICE_26,
    MSR_MDF_DEVICE_27,
    MSR_MDF_DEVICE_28,
    MSR_MDF_DEVICE_29,
    MSR_MDF_DEVICE_30,
    MSR_MDF_DEVICE_31,
    MSR_MDF_DEVICE_32,
    MSR_MDF_DEVICE_33,
    MSR_MDF_DEVICE_34,
    MSR_MDF_DEVICE_35,
    MSR_MDF_DEVICE_36,
    MSR_MDF_DEVICE_37,
    MSR_MDF_DEVICE_38,
    MSR_MDF_DEVICE_39,
    MSR_MDF_DEVICE_40,
    MSR_MDF_DEVICE_41,
    MSR_MDF_DEVICE_42,
    MSR_MDF_DEVICE_43,
    MSR_MDF_DEVICE_44,
    MSR_MDF_DEVICE_45,
    MSR_MDF_DEVICE_46,
    MSR_MDF_DEVICE_47,
    MSR_MDF_DEVICE_48,
    MSR_MDF_DEVICE_49,
    MSR_UBOX_DEVICE,
    MSR_IIO_DEVICE_0,
    MSR_IIO_DEVICE_1,
    MSR_IIO_DEVICE_2,
    MSR_IIO_DEVICE_3,
    MSR_IIO_DEVICE_4,
    MSR_IIO_DEVICE_5,
    MSR_IIO_DEVICE_6,
    MSR_IIO_DEVICE_7,
    MSR_IIO_DEVICE_8,
    MSR_IIO_DEVICE_9,
    MSR_IIO_DEVICE_10,
    MSR_IIO_DEVICE_11,
    MSR_IIO_DEVICE_12,
    MSR_IIO_DEVICE_13,
    MSR_IIO_DEVICE_14,
    MSR_IIO_DEVICE_15,
    MSR_IRP_DEVICE_0,
    MSR_IRP_DEVICE_1,
    MSR_IRP_DEVICE_2,
    MSR_IRP_DEVICE_3,
    MSR_IRP_DEVICE_4,
    MSR_IRP_DEVICE_5,
    MSR_IRP_DEVICE_6,
    MSR_IRP_DEVICE_7,
    MSR_IRP_DEVICE_8,
    MSR_IRP_DEVICE_9,
    MSR_IRP_DEVICE_10,
    MSR_IRP_DEVICE_11,
    MSR_IRP_DEVICE_12,
    MSR_IRP_DEVICE_13,
    MSR_IRP_DEVICE_14,
    MSR_IRP_DEVICE_15,
    MSR_M2IOSF_DEVICE_0,
    MSR_M2IOSF_DEVICE_1,
    MSR_M2IOSF_DEVICE_2,
    MSR_M2IOSF_DEVICE_3,
    MSR_M2IOSF_DEVICE_4,
    MSR_M2IOSF_DEVICE_5,
    MSR_M2IOSF_DEVICE_6,
    MSR_M2IOSF_DEVICE_7,
    MAX_NUM_PCI_DEVICES
} PciDeviceIndex;

#define MSR_PBOX_DEVICE_0 MSR_PBOX_DEVICE
#define PCI_R2PCIE_DEVICE PCI_R2PCIE_DEVICE0

typedef struct {
    PciDeviceType type;
    char *path;
    char *name;
    char *likwid_name;
    uint32_t devid;
    int  online;
} PciDevice;

typedef struct {
    char* name;
    char* desc;
} PciType;

static PciType pci_types[MAX_NUM_PCI_TYPES] = {
    [R3QPI] = {"R3QPI", "R3QPI is the interface between the Intel QPI Link Layer and the Ring."},
    [R2PCIE] = {"R2PCIE", "R2PCIe represents the interface between the Ring and IIO traffic to/from PCIe."},
    [IMC] = {"IMC", "The integrated Memory Controller provides the interface to DRAM and communicates to the rest of the uncore through the Home Agent."},
    [HA] = {"HA", "The HA is responsible for the protocol side of memory interactions."},
    [QPI] = {"QPI", "The Intel QPI Link Layer is responsible for packetizing requests from the caching agent on the way out to the system interface."},
    [IRP] = {"IRP", "IRP is responsible for maintaining coherency for IIO traffic e.g. crosssocket P2P."},
    [EDC] = {"EDC", "The Embedded DRAM controller is used for high bandwidth memory on the Xeon Phi (KNL)."},
};

#define _MYSTRING(x) #x
#define MYSTRING(x) _MYSTRING((x))

static char* pci_device_names[MAX_NUM_PCI_DEVICES] = {
    [MSR_DEV] = MYSTRING(MSR_DEV),
    [MMIO_IMC_DEVICE_0_CH_0] = MYSTRING(MMIO_IMC_DEVICE_0_CH_0),
    [MMIO_IMC_DEVICE_0_CH_1] = MYSTRING(MMIO_IMC_DEVICE_0_CH_1),
    [MMIO_IMC_DEVICE_0_CH_2] = MYSTRING(MMIO_IMC_DEVICE_0_CH_2),
    [MMIO_IMC_DEVICE_0_CH_3] = MYSTRING(MMIO_IMC_DEVICE_0_CH_3),
    [MMIO_IMC_DEVICE_0_CH_4] = MYSTRING(MMIO_IMC_DEVICE_0_CH_4),
    [MMIO_IMC_DEVICE_0_CH_5] = MYSTRING(MMIO_IMC_DEVICE_0_CH_5),
    [MMIO_IMC_DEVICE_0_CH_6] = MYSTRING(MMIO_IMC_DEVICE_0_CH_6),
    [MMIO_IMC_DEVICE_0_CH_7] = MYSTRING(MMIO_IMC_DEVICE_0_CH_7),
    [MMIO_IMC_DEVICE_1_CH_0] = MYSTRING(MMIO_IMC_DEVICE_1_CH_0),
    [MMIO_IMC_DEVICE_1_CH_1] = MYSTRING(MMIO_IMC_DEVICE_1_CH_1),
    [MMIO_IMC_DEVICE_1_CH_2] = MYSTRING(MMIO_IMC_DEVICE_1_CH_2),
    [MMIO_IMC_DEVICE_1_CH_3] = MYSTRING(MMIO_IMC_DEVICE_1_CH_3),
    [MMIO_IMC_DEVICE_1_CH_4] = MYSTRING(MMIO_IMC_DEVICE_1_CH_4),
    [MMIO_IMC_DEVICE_1_CH_5] = MYSTRING(MMIO_IMC_DEVICE_1_CH_5),
    [MMIO_IMC_DEVICE_1_CH_6] = MYSTRING(MMIO_IMC_DEVICE_1_CH_6),
    [MMIO_IMC_DEVICE_1_CH_7] = MYSTRING(MMIO_IMC_DEVICE_1_CH_7),
    [MMIO_HBM_DEVICE_0] = MYSTRING(MMIO_HBM_DEVICE_0),
    [MMIO_HBM_DEVICE_1] = MYSTRING(MMIO_HBM_DEVICE_1),
    [MMIO_HBM_DEVICE_2] = MYSTRING(MMIO_HBM_DEVICE_2),
    [MMIO_HBM_DEVICE_3] = MYSTRING(MMIO_HBM_DEVICE_3),
    [MMIO_HBM_DEVICE_4] = MYSTRING(MMIO_HBM_DEVICE_4),
    [MMIO_HBM_DEVICE_5] = MYSTRING(MMIO_HBM_DEVICE_5),
    [MMIO_HBM_DEVICE_6] = MYSTRING(MMIO_HBM_DEVICE_6),
    [MMIO_HBM_DEVICE_7] = MYSTRING(MMIO_HBM_DEVICE_7),
    [MMIO_HBM_DEVICE_8] = MYSTRING(MMIO_HBM_DEVICE_8),
    [MMIO_HBM_DEVICE_9] = MYSTRING(MMIO_HBM_DEVICE_9),
    [MMIO_HBM_DEVICE_10] = MYSTRING(MMIO_HBM_DEVICE_10),
    [MMIO_HBM_DEVICE_11] = MYSTRING(MMIO_HBM_DEVICE_11),
    [MMIO_HBM_DEVICE_12] = MYSTRING(MMIO_HBM_DEVICE_12),
    [MMIO_HBM_DEVICE_13] = MYSTRING(MMIO_HBM_DEVICE_13),
    [MMIO_HBM_DEVICE_14] = MYSTRING(MMIO_HBM_DEVICE_14),
    [MMIO_HBM_DEVICE_15] = MYSTRING(MMIO_HBM_DEVICE_15),
    [MMIO_HBM_DEVICE_16] = MYSTRING(MMIO_HBM_DEVICE_16),
    [MMIO_HBM_DEVICE_17] = MYSTRING(MMIO_HBM_DEVICE_17),
    [MMIO_HBM_DEVICE_18] = MYSTRING(MMIO_HBM_DEVICE_18),
    [MMIO_HBM_DEVICE_19] = MYSTRING(MMIO_HBM_DEVICE_19),
    [MMIO_HBM_DEVICE_20] = MYSTRING(MMIO_HBM_DEVICE_20),
    [MMIO_HBM_DEVICE_21] = MYSTRING(MMIO_HBM_DEVICE_21),
    [MMIO_HBM_DEVICE_22] = MYSTRING(MMIO_HBM_DEVICE_22),
    [MMIO_HBM_DEVICE_23] = MYSTRING(MMIO_HBM_DEVICE_23),
    [MMIO_HBM_DEVICE_24] = MYSTRING(MMIO_HBM_DEVICE_24),
    [MMIO_HBM_DEVICE_25] = MYSTRING(MMIO_HBM_DEVICE_25),
    [MMIO_HBM_DEVICE_26] = MYSTRING(MMIO_HBM_DEVICE_26),
    [MMIO_HBM_DEVICE_27] = MYSTRING(MMIO_HBM_DEVICE_27),
    [MMIO_HBM_DEVICE_28] = MYSTRING(MMIO_HBM_DEVICE_28),
    [MMIO_HBM_DEVICE_29] = MYSTRING(MMIO_HBM_DEVICE_29),
    [MMIO_HBM_DEVICE_30] = MYSTRING(MMIO_HBM_DEVICE_30),
    [MMIO_HBM_DEVICE_31] = MYSTRING(MMIO_HBM_DEVICE_31),
    [MSR_CBOX_DEVICE_C0] = MYSTRING(MSR_CBOX_DEVICE_C0),
    [MSR_CBOX_DEVICE_C1] = MYSTRING(MSR_CBOX_DEVICE_C1),
    [MSR_CBOX_DEVICE_C2] = MYSTRING(MSR_CBOX_DEVICE_C2),
    [MSR_CBOX_DEVICE_C3] = MYSTRING(MSR_CBOX_DEVICE_C3),
    [MSR_CBOX_DEVICE_C4] = MYSTRING(MSR_CBOX_DEVICE_C4),
    [MSR_CBOX_DEVICE_C5] = MYSTRING(MSR_CBOX_DEVICE_C5),
    [MSR_CBOX_DEVICE_C6] = MYSTRING(MSR_CBOX_DEVICE_C6),
    [MSR_CBOX_DEVICE_C7] = MYSTRING(MSR_CBOX_DEVICE_C7),
    [MSR_CBOX_DEVICE_C8] = MYSTRING(MSR_CBOX_DEVICE_C8),
    [MSR_CBOX_DEVICE_C9] = MYSTRING(MSR_CBOX_DEVICE_C9),
    [MSR_CBOX_DEVICE_C10] = MYSTRING(MSR_CBOX_DEVICE_C10),
    [MSR_CBOX_DEVICE_C11] = MYSTRING(MSR_CBOX_DEVICE_C11),
    [MSR_CBOX_DEVICE_C12] = MYSTRING(MSR_CBOX_DEVICE_C12),
    [MSR_CBOX_DEVICE_C13] = MYSTRING(MSR_CBOX_DEVICE_C13),
    [MSR_CBOX_DEVICE_C14] = MYSTRING(MSR_CBOX_DEVICE_C14),
    [MSR_CBOX_DEVICE_C15] = MYSTRING(MSR_CBOX_DEVICE_C15),
    [MSR_CBOX_DEVICE_C16] = MYSTRING(MSR_CBOX_DEVICE_C16),
    [MSR_CBOX_DEVICE_C17] = MYSTRING(MSR_CBOX_DEVICE_C17),
    [MSR_CBOX_DEVICE_C18] = MYSTRING(MSR_CBOX_DEVICE_C18),
    [MSR_CBOX_DEVICE_C19] = MYSTRING(MSR_CBOX_DEVICE_C19),
    [MSR_CBOX_DEVICE_C20] = MYSTRING(MSR_CBOX_DEVICE_C20),
    [MSR_CBOX_DEVICE_C21] = MYSTRING(MSR_CBOX_DEVICE_C21),
    [MSR_CBOX_DEVICE_C22] = MYSTRING(MSR_CBOX_DEVICE_C22),
    [MSR_CBOX_DEVICE_C23] = MYSTRING(MSR_CBOX_DEVICE_C23),
    [MSR_CBOX_DEVICE_C24] = MYSTRING(MSR_CBOX_DEVICE_C24),
    [MSR_CBOX_DEVICE_C25] = MYSTRING(MSR_CBOX_DEVICE_C25),
    [MSR_CBOX_DEVICE_C26] = MYSTRING(MSR_CBOX_DEVICE_C26),
    [MSR_CBOX_DEVICE_C27] = MYSTRING(MSR_CBOX_DEVICE_C27),
    [MSR_CBOX_DEVICE_C28] = MYSTRING(MSR_CBOX_DEVICE_C28),
    [MSR_CBOX_DEVICE_C29] = MYSTRING(MSR_CBOX_DEVICE_C29),
    [MSR_CBOX_DEVICE_C30] = MYSTRING(MSR_CBOX_DEVICE_C30),
    [MSR_CBOX_DEVICE_C31] = MYSTRING(MSR_CBOX_DEVICE_C31),
    [MSR_CBOX_DEVICE_C32] = MYSTRING(MSR_CBOX_DEVICE_C32),
    [MSR_CBOX_DEVICE_C33] = MYSTRING(MSR_CBOX_DEVICE_C33),
    [MSR_CBOX_DEVICE_C34] = MYSTRING(MSR_CBOX_DEVICE_C34),
    [MSR_CBOX_DEVICE_C35] = MYSTRING(MSR_CBOX_DEVICE_C35),
    [MSR_CBOX_DEVICE_C36] = MYSTRING(MSR_CBOX_DEVICE_C36),
    [MSR_CBOX_DEVICE_C37] = MYSTRING(MSR_CBOX_DEVICE_C37),
    [MSR_CBOX_DEVICE_C38] = MYSTRING(MSR_CBOX_DEVICE_C38),
    [MSR_CBOX_DEVICE_C39] = MYSTRING(MSR_CBOX_DEVICE_C39),
    [MSR_CBOX_DEVICE_C40] = MYSTRING(MSR_CBOX_DEVICE_C40),
    [MSR_CBOX_DEVICE_C41] = MYSTRING(MSR_CBOX_DEVICE_C41),
    [MSR_CBOX_DEVICE_C42] = MYSTRING(MSR_CBOX_DEVICE_C42),
    [MSR_CBOX_DEVICE_C43] = MYSTRING(MSR_CBOX_DEVICE_C43),
    [MSR_CBOX_DEVICE_C44] = MYSTRING(MSR_CBOX_DEVICE_C44),
    [MSR_CBOX_DEVICE_C45] = MYSTRING(MSR_CBOX_DEVICE_C45),
    [MSR_CBOX_DEVICE_C46] = MYSTRING(MSR_CBOX_DEVICE_C46),
    [MSR_CBOX_DEVICE_C47] = MYSTRING(MSR_CBOX_DEVICE_C47),
    [MSR_CBOX_DEVICE_C48] = MYSTRING(MSR_CBOX_DEVICE_C48),
    [MSR_CBOX_DEVICE_C49] = MYSTRING(MSR_CBOX_DEVICE_C49),
    [MSR_CBOX_DEVICE_C50] = MYSTRING(MSR_CBOX_DEVICE_C50),
    [MSR_CBOX_DEVICE_C51] = MYSTRING(MSR_CBOX_DEVICE_C51),
    [MSR_CBOX_DEVICE_C52] = MYSTRING(MSR_CBOX_DEVICE_C52),
    [MSR_CBOX_DEVICE_C53] = MYSTRING(MSR_CBOX_DEVICE_C53),
    [MSR_CBOX_DEVICE_C54] = MYSTRING(MSR_CBOX_DEVICE_C54),
    [MSR_CBOX_DEVICE_C55] = MYSTRING(MSR_CBOX_DEVICE_C55),
    [MSR_UBOX_DEVICE] = MYSTRING(MSR_UBOX_DEVICE),
    [MSR_MDF_DEVICE_0] = MYSTRING(MSR_MDF_DEVICE_0),
    [MSR_MDF_DEVICE_1] = MYSTRING(MSR_MDF_DEVICE_1),
    [MSR_MDF_DEVICE_2] = MYSTRING(MSR_MDF_DEVICE_2),
    [MSR_MDF_DEVICE_3] = MYSTRING(MSR_MDF_DEVICE_3),
    [MSR_MDF_DEVICE_4] = MYSTRING(MSR_MDF_DEVICE_4),
    [MSR_MDF_DEVICE_5] = MYSTRING(MSR_MDF_DEVICE_5),
    [MSR_MDF_DEVICE_6] = MYSTRING(MSR_MDF_DEVICE_6),
    [MSR_MDF_DEVICE_7] = MYSTRING(MSR_MDF_DEVICE_7),
    [MSR_MDF_DEVICE_8] = MYSTRING(MSR_MDF_DEVICE_8),
    [MSR_MDF_DEVICE_9] = MYSTRING(MSR_MDF_DEVICE_9),
    [MSR_MDF_DEVICE_10] = MYSTRING(MSR_MDF_DEVICE_10),
    [MSR_MDF_DEVICE_11] = MYSTRING(MSR_MDF_DEVICE_11),
    [MSR_MDF_DEVICE_12] = MYSTRING(MSR_MDF_DEVICE_12),
    [MSR_MDF_DEVICE_13] = MYSTRING(MSR_MDF_DEVICE_13),
    [MSR_MDF_DEVICE_14] = MYSTRING(MSR_MDF_DEVICE_14),
    [MSR_MDF_DEVICE_15] = MYSTRING(MSR_MDF_DEVICE_15),
    [MSR_MDF_DEVICE_16] = MYSTRING(MSR_MDF_DEVICE_16),
    [MSR_MDF_DEVICE_17] = MYSTRING(MSR_MDF_DEVICE_17),
    [MSR_MDF_DEVICE_18] = MYSTRING(MSR_MDF_DEVICE_18),
    [MSR_MDF_DEVICE_19] = MYSTRING(MSR_MDF_DEVICE_19),
    [MSR_MDF_DEVICE_20] = MYSTRING(MSR_MDF_DEVICE_20),
    [MSR_MDF_DEVICE_21] = MYSTRING(MSR_MDF_DEVICE_21),
    [MSR_MDF_DEVICE_22] = MYSTRING(MSR_MDF_DEVICE_22),
    [MSR_MDF_DEVICE_23] = MYSTRING(MSR_MDF_DEVICE_23),
    [MSR_MDF_DEVICE_24] = MYSTRING(MSR_MDF_DEVICE_24),
    [MSR_MDF_DEVICE_25] = MYSTRING(MSR_MDF_DEVICE_25),
    [MSR_MDF_DEVICE_26] = MYSTRING(MSR_MDF_DEVICE_26),
    [MSR_MDF_DEVICE_27] = MYSTRING(MSR_MDF_DEVICE_27),
    [MSR_MDF_DEVICE_28] = MYSTRING(MSR_MDF_DEVICE_28),
    [MSR_MDF_DEVICE_29] = MYSTRING(MSR_MDF_DEVICE_29),
    [MSR_MDF_DEVICE_30] = MYSTRING(MSR_MDF_DEVICE_30),
    [MSR_MDF_DEVICE_31] = MYSTRING(MSR_MDF_DEVICE_31),
    [MSR_MDF_DEVICE_32] = MYSTRING(MSR_MDF_DEVICE_32),
    [MSR_MDF_DEVICE_33] = MYSTRING(MSR_MDF_DEVICE_33),
    [MSR_MDF_DEVICE_34] = MYSTRING(MSR_MDF_DEVICE_34),
    [MSR_MDF_DEVICE_35] = MYSTRING(MSR_MDF_DEVICE_35),
    [MSR_MDF_DEVICE_36] = MYSTRING(MSR_MDF_DEVICE_36),
    [MSR_MDF_DEVICE_37] = MYSTRING(MSR_MDF_DEVICE_37),
    [MSR_MDF_DEVICE_38] = MYSTRING(MSR_MDF_DEVICE_38),
    [MSR_MDF_DEVICE_39] = MYSTRING(MSR_MDF_DEVICE_39),
    [MSR_MDF_DEVICE_40] = MYSTRING(MSR_MDF_DEVICE_40),
    [MSR_MDF_DEVICE_41] = MYSTRING(MSR_MDF_DEVICE_41),
    [MSR_MDF_DEVICE_42] = MYSTRING(MSR_MDF_DEVICE_42),
    [MSR_MDF_DEVICE_43] = MYSTRING(MSR_MDF_DEVICE_43),
    [MSR_MDF_DEVICE_44] = MYSTRING(MSR_MDF_DEVICE_44),
    [MSR_MDF_DEVICE_45] = MYSTRING(MSR_MDF_DEVICE_45),
    [MSR_MDF_DEVICE_46] = MYSTRING(MSR_MDF_DEVICE_46),
    [MSR_MDF_DEVICE_47] = MYSTRING(MSR_MDF_DEVICE_47),
    [MSR_MDF_DEVICE_48] = MYSTRING(MSR_MDF_DEVICE_48),
    [MSR_MDF_DEVICE_49] = MYSTRING(MSR_MDF_DEVICE_49),
    [PCI_HA_DEVICE_0] = MYSTRING(PCI_HA_DEVICE_0),
    [PCI_HA_DEVICE_1] = MYSTRING(PCI_HA_DEVICE_1),
    [PCI_HA_DEVICE_2] = MYSTRING(PCI_HA_DEVICE_2),
    [PCI_HA_DEVICE_3] = MYSTRING(PCI_HA_DEVICE_3),
    [PCI_HA_DEVICE_4] = MYSTRING(PCI_HA_DEVICE_4),
    [PCI_HA_DEVICE_5] = MYSTRING(PCI_HA_DEVICE_5),
    [PCI_HA_DEVICE_6] = MYSTRING(PCI_HA_DEVICE_6),
    [PCI_HA_DEVICE_7] = MYSTRING(PCI_HA_DEVICE_7),
    [PCI_HA_DEVICE_8] = MYSTRING(PCI_HA_DEVICE_8),
    [PCI_HA_DEVICE_9] = MYSTRING(PCI_HA_DEVICE_9),
    [PCI_HA_DEVICE_10] = MYSTRING(PCI_HA_DEVICE_10),
    [PCI_HA_DEVICE_11] = MYSTRING(PCI_HA_DEVICE_11),
    [PCI_HA_DEVICE_12] = MYSTRING(PCI_HA_DEVICE_12),
    [PCI_HA_DEVICE_13] = MYSTRING(PCI_HA_DEVICE_13),
    [PCI_HA_DEVICE_14] = MYSTRING(PCI_HA_DEVICE_14),
    [PCI_HA_DEVICE_15] = MYSTRING(PCI_HA_DEVICE_15),
    [PCI_HA_DEVICE_16] = MYSTRING(PCI_HA_DEVICE_16),
    [PCI_HA_DEVICE_17] = MYSTRING(PCI_HA_DEVICE_17),
    [PCI_HA_DEVICE_18] = MYSTRING(PCI_HA_DEVICE_18),
    [PCI_HA_DEVICE_19] = MYSTRING(PCI_HA_DEVICE_19),
    [PCI_HA_DEVICE_20] = MYSTRING(PCI_HA_DEVICE_20),
    [PCI_HA_DEVICE_21] = MYSTRING(PCI_HA_DEVICE_21),
    [PCI_HA_DEVICE_22] = MYSTRING(PCI_HA_DEVICE_22),
    [PCI_HA_DEVICE_23] = MYSTRING(PCI_HA_DEVICE_23),
    [PCI_HA_DEVICE_24] = MYSTRING(PCI_HA_DEVICE_24),
    [PCI_HA_DEVICE_25] = MYSTRING(PCI_HA_DEVICE_25),
    [PCI_HA_DEVICE_26] = MYSTRING(PCI_HA_DEVICE_26),
    [PCI_HA_DEVICE_27] = MYSTRING(PCI_HA_DEVICE_27),
    [PCI_HA_DEVICE_28] = MYSTRING(PCI_HA_DEVICE_28),
    [PCI_HA_DEVICE_29] = MYSTRING(PCI_HA_DEVICE_29),
    [PCI_HA_DEVICE_30] = MYSTRING(PCI_HA_DEVICE_30),
    [PCI_HA_DEVICE_31] = MYSTRING(PCI_HA_DEVICE_31),
    [PCI_QPI_DEVICE_PORT_0] = MYSTRING(PCI_QPI_DEVICE_PORT_0),
    [PCI_QPI_DEVICE_PORT_1] = MYSTRING(PCI_QPI_DEVICE_PORT_1),
    [PCI_QPI_DEVICE_PORT_2] = MYSTRING(PCI_QPI_DEVICE_PORT_2),
    [PCI_QPI_DEVICE_PORT_3] = MYSTRING(PCI_QPI_DEVICE_PORT_3),
    [PCI_R3QPI_DEVICE_LINK_0] = MYSTRING(PCI_R3QPI_DEVICE_LINK_0),
    [PCI_R3QPI_DEVICE_LINK_1] = MYSTRING(PCI_R3QPI_DEVICE_LINK_1),
    [PCI_R3QPI_DEVICE_LINK_2] = MYSTRING(PCI_R3QPI_DEVICE_LINK_2),
    [PCI_R3QPI_DEVICE_LINK_3] = MYSTRING(PCI_R3QPI_DEVICE_LINK_3),
    [MSR_PCU_DEVICE] = MYSTRING(MSR_PCU_DEVICE),
    [MSR_IRP_DEVICE_0] = MYSTRING(MSR_IRP_DEVICE_0),
    [MSR_IRP_DEVICE_1] = MYSTRING(MSR_IRP_DEVICE_1),
    [MSR_IRP_DEVICE_2] = MYSTRING(MSR_IRP_DEVICE_2),
    [MSR_IRP_DEVICE_3] = MYSTRING(MSR_IRP_DEVICE_3),
    [MSR_IRP_DEVICE_4] = MYSTRING(MSR_IRP_DEVICE_4),
    [MSR_IRP_DEVICE_5] = MYSTRING(MSR_IRP_DEVICE_5),
    [MSR_IRP_DEVICE_6] = MYSTRING(MSR_IRP_DEVICE_6),
    [MSR_IRP_DEVICE_7] = MYSTRING(MSR_IRP_DEVICE_7),
    [MSR_IRP_DEVICE_8] = MYSTRING(MSR_IRP_DEVICE_8),
    [MSR_IRP_DEVICE_9] = MYSTRING(MSR_IRP_DEVICE_9),
    [MSR_IRP_DEVICE_10] = MYSTRING(MSR_IRP_DEVICE_10),
    [MSR_IRP_DEVICE_11] = MYSTRING(MSR_IRP_DEVICE_11),
    [MSR_IRP_DEVICE_12] = MYSTRING(MSR_IRP_DEVICE_12),
    [MSR_IRP_DEVICE_13] = MYSTRING(MSR_IRP_DEVICE_13),
    [MSR_IRP_DEVICE_14] = MYSTRING(MSR_IRP_DEVICE_14),
    [MSR_IRP_DEVICE_15] = MYSTRING(MSR_IRP_DEVICE_15),
    [MSR_IIO_DEVICE_0] = MYSTRING(MSR_IIO_DEVICE_0),
    [MSR_IIO_DEVICE_1] = MYSTRING(MSR_IIO_DEVICE_1),
    [MSR_IIO_DEVICE_2] = MYSTRING(MSR_IIO_DEVICE_2),
    [MSR_IIO_DEVICE_3] = MYSTRING(MSR_IIO_DEVICE_3),
    [MSR_IIO_DEVICE_4] = MYSTRING(MSR_IIO_DEVICE_4),
    [MSR_IIO_DEVICE_5] = MYSTRING(MSR_IIO_DEVICE_5),
    [MSR_IIO_DEVICE_6] = MYSTRING(MSR_IIO_DEVICE_6),
    [MSR_IIO_DEVICE_7] = MYSTRING(MSR_IIO_DEVICE_7),
    [MSR_IIO_DEVICE_8] = MYSTRING(MSR_IIO_DEVICE_8),
    [MSR_IIO_DEVICE_9] = MYSTRING(MSR_IIO_DEVICE_9),
    [MSR_IIO_DEVICE_10] = MYSTRING(MSR_IIO_DEVICE_10),
    [MSR_IIO_DEVICE_11] = MYSTRING(MSR_IIO_DEVICE_11),
    [MSR_IIO_DEVICE_12] = MYSTRING(MSR_IIO_DEVICE_12),
    [MSR_IIO_DEVICE_13] = MYSTRING(MSR_IIO_DEVICE_13),
    [MSR_IIO_DEVICE_14] = MYSTRING(MSR_IIO_DEVICE_14),
    [MSR_IIO_DEVICE_15] = MYSTRING(MSR_IIO_DEVICE_15),
    [PCI_R2PCIE_DEVICE0] = MYSTRING(PCI_R2PCIE_DEVICE0),
    [PCI_R2PCIE_DEVICE1] = MYSTRING(PCI_R2PCIE_DEVICE1),
    [PCI_R2PCIE_DEVICE2] = MYSTRING(PCI_R2PCIE_DEVICE2),
    [PCI_R2PCIE_DEVICE3] = MYSTRING(PCI_R2PCIE_DEVICE3),
    [PCI_R2PCIE_DEVICE4] = MYSTRING(PCI_R2PCIE_DEVICE4),
    [PCI_R2PCIE_DEVICE5] = MYSTRING(PCI_R2PCIE_DEVICE5),
    [PCI_R2PCIE_DEVICE6] = MYSTRING(PCI_R2PCIE_DEVICE6),
    [PCI_R2PCIE_DEVICE7] = MYSTRING(PCI_R2PCIE_DEVICE7),
    [PCI_R2PCIE_DEVICE8] = MYSTRING(PCI_R2PCIE_DEVICE8),
    [PCI_R2PCIE_DEVICE9] = MYSTRING(PCI_R2PCIE_DEVICE9),
    [PCI_R2PCIE_DEVICE10] = MYSTRING(PCI_R2PCIE_DEVICE10),
    [PCI_R2PCIE_DEVICE11] = MYSTRING(PCI_R2PCIE_DEVICE11),
    [PCI_R2PCIE_DEVICE12] = MYSTRING(PCI_R2PCIE_DEVICE12),
    [PCI_R2PCIE_DEVICE13] = MYSTRING(PCI_R2PCIE_DEVICE13),
    [PCI_R2PCIE_DEVICE14] = MYSTRING(PCI_R2PCIE_DEVICE14),
    [PCI_R2PCIE_DEVICE15] = MYSTRING(PCI_R2PCIE_DEVICE15),

};

#endif /*PCI_TYPES_H*/
