package tests::UIReportSectionWidgetTest;

use strict;

use base qw/ Lire::Test::TestCase tests::TestStoreFixture /;

use Lire::Config::TypeSpec;
use Lire::Test::CursesUIDriver;
use Curses::UI;

sub new {
    my $self = shift->SUPER::new ( @_ );

    $self->init();

    $self->{'driver'} = new Lire::Test::CursesUIDriver();

    return $self;
}

sub set_up {
    my $self = $_[0];

    $self->SUPER::set_up();

    $self->set_up_test_schema();
    $self->{'driver'}->setup_curses_ui();
    $self->{'ui'} = new Curses::UI();
    $self->{'driver'}->set_curses_ui( $self->{'ui'} );
    $self->{'window'} = $self->{'ui'}->add( 'window', 'Window' );

    $self->{'section'} = new Lire::Config::ReportSectionSpec( 'name' => 'section' )->instance();
    $self->{'section'}->get( 'superservice' )->set( 'test' );

    $self->{'cfg'}{'lr_reports_path'} = [];
    $self->{'cfg'}{'lr_filters_path'} = [];
    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    $self->{'driver'}->teardown_curses_ui();

    return;
}

sub test_new {
    my $self = $_[0];

    $self->assert_dies( qr{'value' parameter's spec should be a 'Lire::Config::ReportSectionSpec' instance, not 'Lire::Config::RecordSpec},
                        sub { $self->{'window'}->add( 'widget',
                                                      'Lire::UI::ReportSectionWidget',
                                                      'Value' => new Lire::Config::RecordSpec( 'name' => 'string' )->instance() ) } );
    my $widget = $self->{'window'}->add( 'widget', 'Lire::UI::Widget',
                                         'value' => $self->{'section'} );
    $self->assert_isa( 'Lire::UI::ReportSectionWidget', $widget );
    $self->assert_isa( 'CODE', $widget->getobj( 'superservice_widget' )->{'onvaluechanged'} );

    my $filters = $widget->getobj( 'filters_widget' );
    $self->assert_isa( 'Lire::UI::XMLSpecListWidget', $filters );
    $self->assert_str_equals( 'test', $filters->superservice_filter() );

    my $specs = $widget->getobj( 'specs_widget' );
    $self->assert_isa( 'Lire::UI::XMLSpecListWidget', $specs );
    $self->assert_str_equals( 'test', $specs->superservice_filter() );
}

sub test_update_spec_widgets {
    my $self = $_[0];

    $self->{'section'}->get( 'superservice' )->set( undef );
    my $widget = $self->{'window'}->add( 'widget',
                                         'Lire::UI::ReportSectionWidget',
                                         'value' => $self->{'section'} );

    my $filters = $widget->getobj( 'filters_widget' );
    my $specs = $widget->getobj( 'specs_widget' );
    $self->assert_null( $filters->superservice_filter() );
    $self->assert_null( $specs->superservice_filter() );

    $self->{'section'}->get( 'superservice' )->set( 'test' );
    $widget->update_spec_widgets();
    $self->assert_str_equals( 'test', $filters->superservice_filter() );
    $self->assert_str_equals( 'test', $specs->superservice_filter() );
}


1;
