/*! 
* This Source Code Form is subject to the terms of the Mozilla Public
* License, v. 2.0. If a copy of the MPL was not distributed with this file,
* You can obtain one at http://mozilla.org/MPL/2.0/.
*
* Copyright(c) 2012 Apogee Imaging Systems, Inc. 
* \class AspenUsbIo 
* \brief usb io class for alta-g, aka aspen, aka ??, cameras  
* 
*/ 

#include "AspenUsbIo.h" 
#include "ApnUsbSys.h"
#include "apgHelper.h" 
#include "IUsb.h"
#include "PromFx2Io.h" 
#include "CameraInfo.h" 

#include <cstring>  //for memset

namespace
{
    // Number of requested bytes in a single transfer - limit imposed by 
    // WinUSB.
    const uint32_t MAX_USB_BUFFER_SIZE =  0x1FF000;

    const uint32_t ASPEN_EEPROM_MAX_BANKS = 1;
    const uint32_t ASPEN_EEPROM_MAX_BLOCKS = 4;
    const uint32_t ASPEN_FLASH_SIZE = 2*1024*1024;
    const uint32_t MAX_FLASH_XFER_SIZE = 4096;
    
    
    const uint32_t FPGA_BIN_FLASH_ADDR = 0x0;
    const uint32_t WEBSERVER_BIN_FLASH_ADDR = 0x100000;
    const uint32_t WEBPAGE_BIN_FLASH_ADDR = 0x180000;
    const uint32_t NETCONF_BIN_FLASH_ADDR = 0x1FC000;
    const uint32_t NETCONF_BIN_FLASH_ADDR_FACTORY = 0x1FD00C;
    const uint32_t NETCONF_BIN_FLASH_ADDR_USER = 0x1FD000;
    const uint32_t STR_DB_FLASH_ADDR = 0x1F8000;
    
    const uint8_t FX2_PROM_BANK = 0;
    const uint8_t FX2_PROM_BLOCK = 0;
    const uint16_t FX2_PROM_ADDR = 0;

    const uint16_t HEADER_PROM_BLOCK = 0;
    const uint16_t HEADER_PROM_BANK = 0;
    const uint16_t HEADER_PROM_ADDR = 0x4000;

    const uint8_t DSCR_PROM_BANK = 0;
    const uint8_t DSCR_PROM_BLOCK = 0;
    const uint16_t DSCR_PROM_ADDR = 0x4200;

    UsbFrmwr::INTEL_HEX_RECORD firmware[] = {
        {
            9, 0x1ca3, 0,
            {0xf0,0x90,0x23,0x88,0xf0,0x90,0x23,0xcd,0x22}
        },
        {
            6, 0x1d05, 0,
            {0x90,0x23,0x89,0xef,0xf0,0x22}
        },
        {
            16, 0x16e9, 0,
            {0xef,0x14,0x60,0x14,0x14,0x60,0x1e,0x14,0x60,0x2a,0x24,0x03,0x70,0x2f,0xe4,0x90}
        },
        {
            16, 0x16f9, 0,
            {0x23,0x8a,0x12,0x1c,0xa3,0x04,0xf0,0x22,0x90,0x23,0x8a,0x74,0x01,0xf0,0xe4,0x12}
        },
        {
            16, 0x1709, 0,
            {0x1c,0xa4,0x04,0xf0,0x22,0xe4,0x90,0x23,0x8a,0xf0,0x90,0x23,0x88,0x04,0xf0,0x90}
        },
        {
            14, 0x1719, 0,
            {0x23,0xcd,0xf0,0x22,0x90,0x23,0x8a,0x74,0x01,0x12,0x1c,0xa3,0xf0,0x22}
        },
        {
            6, 0x1137, 0,
            {0x8e,0x1a,0x8f,0x1b,0xa9,0x05}
        },
        {
            16, 0x113d, 0,
            {0x75,0x1c,0x50,0x90,0x23,0x89,0xe0,0x60,0x03,0x43,0x1c,0x04,0x90,0x23,0x88,0xe0}
        },
        {
            16, 0x114d, 0,
            {0x60,0x03,0x43,0x1c,0x02,0x90,0x23,0xcd,0xe0,0x60,0x03,0x43,0x1c,0x01,0x53,0x1a}
        },
        {
            16, 0x115d, 0,
            {0x7f,0x90,0x23,0x8a,0xe0,0x60,0x03,0x43,0x1a,0x80,0xe5,0x1a,0x90,0x23,0x8b,0xf0}
        },
        {
            16, 0x116d, 0,
            {0xe5,0x1b,0xa3,0xf0,0xe4,0xff,0xfe,0xe9,0xfd,0xc3,0xef,0x9d,0x74,0x80,0xf8,0x6e}
        },
        {
            16, 0x117d, 0,
            {0x98,0x50,0x1e,0x8b,0x82,0x8a,0x83,0xe0,0xfd,0x74,0x8d,0x2f,0xf5,0x82,0xe4,0x34}
        },
        {
            16, 0x118d, 0,
            {0x23,0xf5,0x83,0xed,0xf0,0x0f,0xbf,0x00,0x01,0x0e,0x0b,0xbb,0x00,0x01,0x0a,0x80}
        },
        {
            16, 0x119d, 0,
            {0xd6,0xe9,0x24,0x02,0xfd,0x7a,0x23,0x7b,0x8b,0xaf,0x1c,0x12,0x1b,0x52,0xaf,0x1c}
        },
        {
            3, 0x11ad, 0,
            {0x02,0x17,0xd2}
        },
        {
            10, 0x10b3, 0,
            {0x8e,0x1a,0x8f,0x1b,0x8d,0x1c,0x8a,0x1d,0x8b,0x1e}
        },
        {
            16, 0x10bd, 0,
            {0x75,0x1f,0x50,0x90,0x23,0x89,0xe0,0x60,0x03,0x43,0x1f,0x04,0x90,0x23,0x88,0xe0}
        },
        {
            16, 0x10cd, 0,
            {0x60,0x03,0x43,0x1f,0x02,0x90,0x23,0xcd,0xe0,0x60,0x03,0x43,0x1f,0x01,0x53,0x1a}
        },
        {
            16, 0x10dd, 0,
            {0x7f,0x90,0x23,0x8a,0xe0,0x60,0x03,0x43,0x1a,0x80,0xe5,0x1a,0x90,0x23,0x8b,0xf0}
        },
        {
            16, 0x10ed, 0,
            {0xe5,0x1b,0xa3,0xf0,0x7a,0x23,0x7b,0x8b,0x7d,0x02,0xaf,0x1f,0x12,0x1b,0x52,0x7a}
        },
        {
            16, 0x10fd, 0,
            {0x23,0x7b,0x8b,0xad,0x1c,0xaf,0x1f,0x12,0x1b,0x36,0xe4,0xff,0xfe,0xc3,0xef,0x95}
        },
        {
            16, 0x110d, 0,
            {0x1c,0x74,0x80,0xf8,0x6e,0x98,0x50,0x21,0x74,0x8b,0x2f,0xf5,0x82,0xe4,0x34,0x23}
        },
        {
            16, 0x111d, 0,
            {0xf5,0x83,0xe0,0x85,0x1e,0x82,0x85,0x1d,0x83,0xf0,0x0f,0xbf,0x00,0x01,0x0e,0x05}
        },
        {
            9, 0x112d, 0,
            {0x1e,0xe5,0x1e,0x70,0xd8,0x05,0x1d,0x80,0xd4}
        },
        {
            1, 0x1136, 0,
            {0x22}
        },
        {
            16, 0x179c, 0,
            {0x75,0x12,0x70,0xef,0x54,0x7f,0x90,0x23,0xe5,0xf0,0x7a,0x23,0x7b,0xe5,0x7d,0x01}
        },
        {
            16, 0x17ac, 0,
            {0xaf,0x12,0x12,0x1b,0x52,0x7a,0x23,0x7b,0xe5,0x7d,0x02,0xaf,0x12,0x12,0x1b,0x36}
        },
        {
            16, 0x17bc, 0,
            {0x90,0x23,0xe6,0xe0,0xfe,0x90,0x23,0xe5,0xe0,0xfd,0xee,0xed,0xff,0x90,0x23,0xe3}
        },
        {
            5, 0x17cc, 0,
            {0xee,0xf0,0xa3,0xef,0xf0}
        },
        {
            1, 0x17d1, 0,
            {0x22}
        },
        {
            16, 0x1b88, 0,
            {0xef,0x54,0x7f,0x90,0x23,0xe3,0xf0,0xed,0xa3,0xf0,0xec,0xa3,0xf0,0x7f,0x70,0x7a}
        },
        {
            8, 0x1b98, 0,
            {0x23,0x7b,0xe3,0x7d,0x03,0x02,0x1b,0x52}
        },
        {
            2, 0x1b6e, 0,
            {0xae,0x07}
        },
        {
            16, 0x1b70, 0,
            {0x7f,0x70,0xee,0x44,0x80,0x90,0x23,0xe3,0xf0,0xa3,0xed,0xf0,0xe4,0xa3,0xf0,0x7a}
        },
        {
            8, 0x1b80, 0,
            {0x23,0x7b,0xe3,0x7d,0x03,0x02,0x1b,0x52}
        },
        {
            16, 0x1ac8, 0,
            {0x75,0x13,0x70,0xef,0x44,0x80,0x90,0x23,0xe3,0xf0,0x7a,0x23,0x7b,0xe3,0x7d,0x01}
        },
        {
            16, 0x1ad8, 0,
            {0xaf,0x13,0x12,0x1b,0x52,0x7a,0x23,0x7b,0xe3,0x7d,0x02,0xaf,0x13,0x12,0x1b,0x36}
        },
        {
            5, 0x1ae8, 0,
            {0x90,0x23,0xe3,0xe0,0xff}
        },
        {
            1, 0x1aed, 0,
            {0x22}
        },
        {
            16, 0x1588, 0,
            {0x75,0x38,0x23,0x75,0x39,0xcf,0xe4,0xff,0x12,0x1d,0x05,0xe4,0xff,0x12,0x16,0xe9}
        },
        {
            16, 0x1598, 0,
            {0xab,0x39,0xaa,0x38,0x7d,0x13,0x7f,0x00,0x7e,0x40,0x12,0x10,0xb3,0xe4,0xf9,0x7f}
        },
        {
            16, 0x15a8, 0,
            {0x01,0xfe,0xe5,0x39,0x2f,0xf5,0x82,0xe5,0x38,0x3e,0xf5,0x83,0xe0,0x29,0xf9,0x0f}
        },
        {
            16, 0x15b8, 0,
            {0xbf,0x00,0x01,0x0e,0xef,0x64,0x13,0x4e,0x70,0xe8,0x90,0x23,0xcf,0xe0,0xb5,0x01}
        },
        {
            12, 0x15c8, 0,
            {0x04,0x7f,0x01,0x80,0x02,0x7f,0x00,0x90,0x23,0xce,0xef,0xf0}
        },
        {
            1, 0x15d4, 0,
            {0x22}
        },
        {
            7, 0x1cf7, 0,
            {0x90,0x23,0xce,0xe0,0x24,0xff,0x22}
        },
        {
            7, 0x1cfe, 0,
            {0x75,0x80,0xfe,0x75,0xb2,0x01,0x22}
        },
        {
            4, 0x1d11, 0,
            {0xe4,0xf5,0xb2,0x22}
        },
        {
            16, 0x18a1, 0,
            {0x90,0xe6,0x00,0x74,0x10,0xf0,0xe4,0x90,0xe6,0x70,0xf0,0x75,0x80,0xfe,0xf5,0xb2}
        },
        {
            16, 0x18b1, 0,
            {0xf5,0xb3,0xf5,0xb5,0xc2,0xaf,0xc2,0x8c,0xc2,0xa9,0x53,0x89,0xfc,0x43,0x89,0x01}
        },
        {
            16, 0x18c1, 0,
            {0x53,0x89,0xfb,0x53,0x8e,0xf7,0x75,0x8a,0xa0,0x75,0x8c,0x0f,0xd2,0xa9,0xd2,0xaf}
        },
        {
            1, 0x18d1, 0,
            {0x22}
        },
        {
            10, 0x1c85, 0,
            {0x90,0xe6,0x7a,0xe0,0x44,0x01,0xf0,0x02,0x1c,0xdf}
        },
        {
            16, 0x1a9f, 0,
            {0xe4,0x90,0xe6,0x10,0xf0,0x00,0x00,0x00,0x90,0xe6,0x11,0xf0,0x00,0x00,0x00,0x90}
        },
        {
            16, 0x1aaf, 0,
            {0xe6,0x12,0xf0,0x00,0x00,0x00,0x90,0xe6,0x13,0xf0,0x00,0x00,0x00,0x90,0xe6,0x15}
        },
        {
            9, 0x1abf, 0,
            {0xf0,0x00,0x00,0x00,0x90,0xe6,0x14,0xf0,0x22}
        },
        {
            16, 0x1ba0, 0,
            {0x12,0x18,0xa1,0x12,0x1c,0x85,0x90,0xe6,0x01,0x74,0xf6,0xf0,0x75,0xb2,0xff,0x75}
        },
        {
            7, 0x1bb0, 0,
            {0xb2,0x01,0xc2,0x80,0x02,0x1a,0x9f}
        },
        {
            16, 0x1c0c, 0,
            {0x53,0x91,0xef,0x90,0xe6,0x5d,0x22,0xf0,0xe4,0x90,0xe6,0x8a,0xf0,0x90,0xe6,0x8b}
        },
        {
            4, 0x1c1c, 0,
            {0x04,0xf0,0xd3,0x22}
        },
        {
            3, 0x1d19, 0,
            {0x02,0x1b,0xa0}
        },
        {
            3, 0x1d1c, 0,
            {0x02,0x1d,0x4e}
        },
        {
            2, 0x1d1f, 0,
            {0xd3,0x22}
        },
        {
            2, 0x1d21, 0,
            {0xd3,0x22}
        },
        {
            2, 0x1d23, 0,
            {0xd3,0x22}
        },
        {
            8, 0x1cc7, 0,
            {0x90,0xe6,0xba,0xe0,0xf5,0x3b,0xd3,0x22}
        },
        {
            9, 0x1cac, 0,
            {0x90,0xe7,0x40,0xe5,0x3b,0x12,0x1c,0x13,0x22}
        },
        {
            8, 0x1ccf, 0,
            {0x90,0xe6,0xba,0xe0,0xf5,0x3a,0xd3,0x22}
        },
        {
            9, 0x1cb5, 0,
            {0x90,0xe7,0x40,0xe5,0x3a,0x12,0x1c,0x13,0x22}
        },
        {
            2, 0x1d25, 0,
            {0xd3,0x22}
        },
        {
            2, 0x1d27, 0,
            {0xd3,0x22}
        },
        {
            2, 0x1d29, 0,
            {0xd3,0x22}
        },
        {
            16, 0x1c5a, 0,
            {0xc2,0x04,0x90,0xe6,0xb8,0xe0,0x54,0x60,0xf5,0x09,0x12,0x0a,0x3d,0x92,0x04,0xa2}
        },
        {
            1, 0x1c6a, 0,
            {0x04}
        },
        {
            1, 0x1c6b, 0,
            {0x22}
        },
        {
            16, 0x1bcd, 0,
            {0xc0,0xe0,0xc0,0x83,0xc0,0x82,0xd2,0x01,0x12,0x1c,0x0c,0x74,0x01,0xf0,0xd0,0x82}
        },
        {
            5, 0x1bdd, 0,
            {0xd0,0x83,0xd0,0xe0,0x32}
        },
        {
            16, 0x1c34, 0,
            {0xc0,0xe0,0xc0,0x83,0xc0,0x82,0x12,0x1c,0x0c,0x74,0x04,0xf0,0xd0,0x82,0xd0,0x83}
        },
        {
            3, 0x1c44, 0,
            {0xd0,0xe0,0x32}
        },
        {
            16, 0x1c47, 0,
            {0xc0,0xe0,0xc0,0x83,0xc0,0x82,0x12,0x1c,0x0c,0x74,0x02,0xf0,0xd0,0x82,0xd0,0x83}
        },
        {
            3, 0x1c57, 0,
            {0xd0,0xe0,0x32}
        },
        {
            16, 0x183c, 0,
            {0xc0,0xe0,0xc0,0x83,0xc0,0x82,0x85,0x29,0x25,0x85,0x2a,0x26,0x85,0x26,0x82,0x85}
        },
        {
            16, 0x184c, 0,
            {0x25,0x83,0xa3,0x74,0x02,0xf0,0x85,0x21,0x27,0x85,0x22,0x28,0x85,0x28,0x82,0x85}
        },
        {
            16, 0x185c, 0,
            {0x27,0x83,0xa3,0x74,0x07,0xf0,0x12,0x1c,0x0c,0x74,0x10,0xf0,0xd0,0x82,0xd0,0x83}
        },
        {
            3, 0x186c, 0,
            {0xd0,0xe0,0x32}
        },
        {
            16, 0x1be2, 0,
            {0xc0,0xe0,0xc0,0x83,0xc0,0x82,0xd2,0x03,0x12,0x1c,0x0c,0x74,0x08,0xf0,0xd0,0x82}
        },
        {
            5, 0x1bf2, 0,
            {0xd0,0x83,0xd0,0xe0,0x32}
        },
        {
            16, 0x1762, 0,
            {0xc0,0xe0,0xc0,0x83,0xc0,0x82,0x90,0xe6,0x80,0xe0,0x30,0xe7,0x20,0x85,0x21,0x25}
        },
        {
            16, 0x1772, 0,
            {0x85,0x22,0x26,0x85,0x29,0x27,0x85,0x2a,0x28,0x85,0x26,0x82,0x85,0x25,0x83,0xa3}
        },
        {
            16, 0x1782, 0,
            {0x74,0x07,0xf0,0x85,0x28,0x82,0x85,0x27,0x83,0xa3,0x74,0x02,0xf0,0x12,0x1c,0x0c}
        },
        {
            10, 0x1792, 0,
            {0x74,0x20,0xf0,0xd0,0x82,0xd0,0x83,0xd0,0xe0,0x32}
        },
        {
            1, 0xcff, 0,
            {0x32}
        },
        {
            1, 0x1d2b, 0,
            {0x32}
        },
        {
            1, 0x1d2c, 0,
            {0x32}
        },
        {
            1, 0x1d2d, 0,
            {0x32}
        },
        {
            1, 0x1d2e, 0,
            {0x32}
        },
        {
            1, 0x1d2f, 0,
            {0x32}
        },
        {
            1, 0x1d30, 0,
            {0x32}
        },
        {
            1, 0x1d31, 0,
            {0x32}
        },
        {
            1, 0x1d32, 0,
            {0x32}
        },
        {
            1, 0x1d33, 0,
            {0x32}
        },
        {
            1, 0x1d34, 0,
            {0x32}
        },
        {
            1, 0x1d35, 0,
            {0x32}
        },
        {
            1, 0x1d36, 0,
            {0x32}
        },
        {
            1, 0x1d37, 0,
            {0x32}
        },
        {
            1, 0x1d38, 0,
            {0x32}
        },
        {
            1, 0x1d39, 0,
            {0x32}
        },
        {
            1, 0x1d3a, 0,
            {0x32}
        },
        {
            1, 0x1d3b, 0,
            {0x32}
        },
        {
            1, 0x1d3c, 0,
            {0x32}
        },
        {
            1, 0x1d3d, 0,
            {0x32}
        },
        {
            1, 0x1d3e, 0,
            {0x32}
        },
        {
            1, 0x1d3f, 0,
            {0x32}
        },
        {
            1, 0x1d40, 0,
            {0x32}
        },
        {
            1, 0x1d41, 0,
            {0x32}
        },
        {
            1, 0x1d42, 0,
            {0x32}
        },
        {
            1, 0x1d43, 0,
            {0x32}
        },
        {
            1, 0x1d44, 0,
            {0x32}
        },
        {
            1, 0x1d45, 0,
            {0x32}
        },
        {
            1, 0x1d46, 0,
            {0x32}
        },
        {
            1, 0x1d47, 0,
            {0x32}
        },
        {
            1, 0x1d48, 0,
            {0x32}
        },
        {
            1, 0x1d49, 0,
            {0x32}
        },
        {
            1, 0x1d4a, 0,
            {0x32}
        },
        {
            1, 0x1d4b, 0,
            {0x32}
        },
        {
            1, 0x1d4c, 0,
            {0x32}
        },
        {
            1, 0x1d4d, 0,
            {0x32}
        },
        {
            1, 0x1d4e, 0,
            {0x22}
        },
        {
            16, 0x1c20, 0,
            {0x4e,0x6f,0x76,0x20,0x31,0x32,0x20,0x32,0x30,0x30,0x38,0x31,0x38,0x3a,0x32,0x37}
        },
        {
            4, 0x1c30, 0,
            {0x3a,0x32,0x34,0x00}
        },
        {
            16, 0x1b13, 0,
            {0x44,0x22,0x1a,0x61,0x30,0x30,0x00,0x58,0x21,0x02,0x41,0x73,0x63,0x65,0x6e,0x74}
        },
        {
            16, 0x1b23, 0,
            {0x20,0x47,0x69,0x67,0x61,0x62,0x69,0x74,0x20,0x46,0x69,0x72,0x6d,0x77,0x61,0x72}
        },
        {
            2, 0x1b33, 0,
            {0x65,0x00}
        },
        {
            16, 0x1301, 0,
            {0x90,0x22,0x1e,0xe0,0xfe,0xa3,0xe0,0xff,0xe4,0xfc,0xfd,0x78,0x10,0x12,0x02,0xf0}
        },
        {
            16, 0x1311, 0,
            {0xa8,0x04,0xa9,0x05,0xaa,0x06,0xab,0x07,0xa3,0xe0,0xfe,0xa3,0xe0,0xff,0xe4,0x22}
        },
        {
            16, 0x1321, 0,
            {0x74,0x1a,0x2f,0xf5,0x82,0xe4,0x34,0x21,0xf5,0x83,0xe0,0xfd,0x74,0x40,0x2f,0xf5}
        },
        {
            16, 0x1331, 0,
            {0x82,0xe4,0x34,0xe7,0xf5,0x83,0x22,0xe4,0x90,0xe6,0x8a,0xf0,0x90,0xe6,0x8b,0x22}
        },
        {
            16, 0x1341, 0,
            {0x90,0xe6,0xa0,0xe0,0x44,0x01,0xf0,0x22,0x74,0x1a,0x2f,0xf5,0x82,0xe4,0x34,0x21}
        },
        {
            16, 0x1351, 0,
            {0xf5,0x83,0x22,0x7a,0xe7,0x79,0x40,0x78,0x40,0x7c,0xe7,0x7d,0x01,0x22,0xc3,0xe5}
        },
        {
            8, 0x1361, 0,
            {0x18,0x95,0x16,0xe5,0x17,0x95,0x15,0x22}
        },
        {
            16, 0x839, 0,
            {0xe4,0xf5,0x19,0x90,0x22,0x20,0xe0,0xf5,0x0d,0xa3,0xe0,0xf5,0x0e,0xaf,0x0e,0xe5}
        },
        {
            16, 0x849, 0,
            {0x0e,0x12,0x16,0xe9,0xe5,0x0d,0xff,0x12,0x1d,0x05,0x90,0x21,0x00,0x12,0x13,0x1a}
        },
        {
            16, 0x859, 0,
            {0x8f,0x12,0x8e,0x11,0xf5,0x10,0xf5,0x0f,0x90,0x22,0x1e,0xe0,0xf5,0x13,0xa3,0xe0}
        },
        {
            16, 0x869, 0,
            {0xf5,0x14,0xaf,0x12,0xae,0x11,0xad,0x10,0xac,0x0f,0xec,0x4d,0x4e,0x4f,0x70,0x03}
        },
        {
            16, 0x879, 0,
            {0x02,0x09,0x3f,0x12,0x13,0x38,0xf0,0x00,0x00,0x00,0x90,0xe6,0xa0,0xe0,0x20,0xe1}
        },
        {
            16, 0x889, 0,
            {0xf9,0x90,0xe6,0x8b,0xe0,0x75,0x15,0x00,0xf5,0x16,0xe4,0xf5,0x17,0xf5,0x18,0x12}
        },
        {
            16, 0x899, 0,
            {0x13,0x5f,0x50,0x16,0xaf,0x18,0x12,0x13,0x2d,0xe0,0xfe,0x12,0x13,0x49,0xee,0xf0}
        },
        {
            16, 0x8a9, 0,
            {0x05,0x18,0xe5,0x18,0x70,0xe9,0x05,0x17,0x80,0xe5,0xe5,0x19,0xc3,0x94,0x03,0x50}
        },
        {
            16, 0x8b9, 0,
            {0x4e,0xad,0x16,0x7a,0x21,0x7b,0x1a,0xaf,0x14,0xae,0x13,0x12,0x11,0x37,0xad,0x16}
        },
        {
            16, 0x8c9, 0,
            {0x7a,0x22,0x7b,0x22,0xaf,0x14,0xae,0x13,0x12,0x10,0xb3,0xc2,0x06,0xe4,0xf5,0x17}
        },
        {
            16, 0x8d9, 0,
            {0xf5,0x18,0x12,0x13,0x5f,0x50,0x21,0xaf,0x18,0x74,0x22,0x2f,0xf5,0x82,0xe4,0x34}
        },
        {
            16, 0x8e9, 0,
            {0x22,0xf5,0x83,0xe0,0xfe,0x12,0x13,0x49,0xe0,0x6e,0x60,0x02,0xd2,0x06,0x05,0x18}
        },
        {
            16, 0x8f9, 0,
            {0xe5,0x18,0x70,0xde,0x05,0x17,0x80,0xda,0x30,0x06,0x04,0x05,0x19,0x80,0xab,0xe5}
        },
        {
            16, 0x909, 0,
            {0x16,0x25,0x14,0xf5,0x14,0xe5,0x15,0x35,0x13,0xf5,0x13,0xae,0x15,0xaf,0x16,0xe4}
        },
        {
            16, 0x919, 0,
            {0xfc,0xfd,0xaa,0x06,0xab,0x07,0xc3,0xe5,0x12,0x9b,0xf5,0x12,0xe5,0x11,0x9a,0xf5}
        },
        {
            16, 0x929, 0,
            {0x11,0xe5,0x10,0x94,0x00,0xf5,0x10,0xe5,0x0f,0x94,0x00,0xf5,0x0f,0x20,0x06,0x03}
        },
        {
            6, 0x939, 0,
            {0x02,0x08,0x6b,0x12,0x13,0x41}
        },
        {
            1, 0x93f, 0,
            {0x22}
        },
        {
            16, 0xb2b, 0,
            {0x90,0x21,0x00,0x12,0x13,0x1a,0x8f,0x16,0x8e,0x15,0xf5,0x14,0xf5,0x13,0x90,0x22}
        },
        {
            16, 0xb3b, 0,
            {0x1e,0xe0,0xf5,0x11,0xa3,0xe0,0xf5,0x12,0xa3,0xe0,0xf5,0x0d,0xa3,0xe0,0xf5,0x0e}
        },
        {
            16, 0xb4b, 0,
            {0xaf,0x0e,0xe5,0x0e,0x12,0x16,0xe9,0xe5,0x0d,0xff,0x12,0x1d,0x05,0xaf,0x16,0xae}
        },
        {
            16, 0xb5b, 0,
            {0x15,0xad,0x14,0xac,0x13,0xec,0x4d,0x4e,0x4f,0x70,0x03,0x02,0x0b,0xf8,0xe4,0x7f}
        },
        {
            16, 0xb6b, 0,
            {0x40,0xfe,0xfd,0xfc,0xab,0x16,0xaa,0x15,0xa9,0x14,0xa8,0x13,0xc3,0x12,0x02,0xcc}
        },
        {
            16, 0xb7b, 0,
            {0x50,0x06,0xae,0x15,0xaf,0x16,0x80,0x04,0x7e,0x00,0x7f,0x40,0x8e,0x0f,0x8f,0x10}
        },
        {
            16, 0xb8b, 0,
            {0xad,0x10,0x7a,0x21,0x7b,0x1a,0xaf,0x12,0xae,0x11,0x12,0x10,0xb3,0xe4,0xff,0xfe}
        },
        {
            16, 0xb9b, 0,
            {0xc3,0xef,0x95,0x10,0xee,0x95,0x0f,0x50,0x0c,0x12,0x13,0x21,0xed,0xf0,0x0f,0xbf}
        },
        {
            16, 0xbab, 0,
            {0x00,0x01,0x0e,0x80,0xeb,0xe5,0x10,0x25,0x12,0xf5,0x12,0xe5,0x0f,0x35,0x11,0xf5}
        },
        {
            16, 0xbbb, 0,
            {0x11,0xae,0x0f,0xaf,0x10,0xe4,0xfc,0xfd,0xaa,0x06,0xab,0x07,0xc3,0xe5,0x16,0x9b}
        },
        {
            16, 0xbcb, 0,
            {0xf5,0x16,0xe5,0x15,0x9a,0xf5,0x15,0xe5,0x14,0x94,0x00,0xf5,0x14,0xe5,0x13,0x94}
        },
        {
            16, 0xbdb, 0,
            {0x00,0xf5,0x13,0xe5,0x0f,0x90,0xe6,0x8a,0xf0,0xef,0x90,0xe6,0x8b,0xf0,0x00,0x00}
        },
        {
            13, 0xbeb, 0,
            {0x00,0x90,0xe6,0xa0,0xe0,0x20,0xe1,0x03,0x02,0x0b,0x58,0x80,0xf4}
        },
        {
            1, 0xbf8, 0,
            {0x22}
        },
        {
            16, 0x18d2, 0,
            {0x90,0x21,0x00,0xe0,0x70,0x02,0xa3,0xe0,0x60,0x23,0xe4,0x90,0xe6,0x8a,0xf0,0x00}
        },
        {
            16, 0x18e2, 0,
            {0x00,0x00,0x90,0xe6,0x8b,0xf0,0x00,0x00,0x00,0x90,0xe6,0xa0,0xe0,0x20,0xe1,0xf9}
        },
        {
            16, 0x18f2, 0,
            {0x90,0x22,0x1f,0xe0,0xff,0x90,0xe7,0x40,0xe0,0xfd,0x02,0x1b,0x6e,0x12,0x13,0x41}
        },
        {
            1, 0x1902, 0,
            {0x22}
        },
        {
            16, 0x1295, 0,
            {0xd3,0x90,0x21,0x01,0xe0,0x94,0x40,0x90,0x21,0x00,0xe0,0x94,0x00,0x40,0x06,0xe4}
        },
        {
            16, 0x12a5, 0,
            {0xf0,0xa3,0x74,0x40,0xf0,0x90,0x21,0x00,0xe0,0xf5,0x11,0xa3,0xe0,0xf5,0x12,0x90}
        },
        {
            16, 0x12b5, 0,
            {0x22,0x1f,0xe0,0xf5,0x10,0x7a,0xe7,0x79,0x40,0x75,0x0d,0x01,0x75,0x0e,0xe7,0x75}
        },
        {
            16, 0x12c5, 0,
            {0x0f,0x40,0xe5,0x12,0x15,0x12,0xae,0x11,0x70,0x02,0x15,0x11,0x4e,0x60,0x16,0xaf}
        },
        {
            16, 0x12d5, 0,
            {0x10,0x05,0x10,0x12,0x1a,0xc8,0x78,0x0d,0xe4,0x75,0xf0,0x01,0x12,0x03,0x1b,0xef}
        },
        {
            16, 0x12e5, 0,
            {0x12,0x02,0x3c,0x80,0xdd,0x90,0x21,0x00,0xe0,0x90,0xe6,0x8a,0xf0,0x00,0x00,0x00}
        },
        {
            11, 0x12f5, 0,
            {0x90,0x21,0x01,0xe0,0x90,0xe6,0x8b,0xf0,0x00,0x00,0x00}
        },
        {
            1, 0x1300, 0,
            {0x22}
        },
        {
            16, 0x1a75, 0,
            {0x90,0x21,0x00,0xe0,0x70,0x02,0xa3,0xe0,0x60,0x1f,0x12,0x13,0x38,0xf0,0x00,0x00}
        },
        {
            16, 0x1a85, 0,
            {0x00,0x90,0xe6,0xa0,0xe0,0x20,0xe1,0xf9,0x90,0x22,0x1e,0xe0,0xfe,0xa3,0xe0,0xff}
        },
        {
            9, 0x1a95, 0,
            {0x90,0xe7,0x40,0xe0,0x8f,0x82,0x8e,0x83,0xf0}
        },
        {
            1, 0x1a9e, 0,
            {0x22}
        },
        {
            16, 0x13cc, 0,
            {0x90,0x22,0x1e,0xe0,0xfe,0xa3,0xe0,0x8e,0x10,0xf5,0x11,0x90,0x21,0x00,0xe0,0xfe}
        },
        {
            16, 0x13dc, 0,
            {0xa3,0xe0,0xff,0x7a,0xe7,0x79,0x40,0x75,0x0d,0x01,0x75,0x0e,0xe7,0x75,0x0f,0x40}
        },
        {
            16, 0x13ec, 0,
            {0xef,0x1f,0xac,0x06,0x70,0x01,0x1e,0x4c,0x60,0x20,0x05,0x11,0xe5,0x11,0xac,0x10}
        },
        {
            16, 0x13fc, 0,
            {0x70,0x02,0x05,0x10,0x14,0xf5,0x82,0x8c,0x83,0xe0,0xfd,0x78,0x0d,0xe4,0x75,0xf0}
        },
        {
            16, 0x140c, 0,
            {0x01,0x12,0x03,0x1b,0xed,0x12,0x02,0x3c,0x80,0xd6,0x90,0x21,0x00,0xe0,0x90,0xe6}
        },
        {
            13, 0x141c, 0,
            {0x8a,0xf0,0x00,0x00,0x00,0x90,0x21,0x01,0xe0,0x90,0xe6,0x8b,0xf0}
        },
        {
            1, 0x1429, 0,
            {0x22}
        },
        {
            16, 0xdb8, 0,
            {0x12,0x13,0x01,0xfc,0xfd,0x12,0x02,0x70,0x8f,0x12,0x8e,0x11,0x8d,0x10,0x8c,0x0f}
        },
        {
            16, 0xdc8, 0,
            {0x90,0x21,0x00,0xe0,0xf5,0x13,0xa3,0xe0,0xf5,0x14,0xe5,0x14,0x45,0x13,0x70,0x03}
        },
        {
            16, 0xdd8, 0,
            {0x02,0x0e,0x5e,0xc3,0xe5,0x14,0x94,0x40,0xe5,0x13,0x94,0x00,0x50,0x06,0xae,0x13}
        },
        {
            16, 0xde8, 0,
            {0xaf,0x14,0x80,0x04,0x7e,0x00,0x7f,0x40,0x8e,0x0d,0x8f,0x0e,0xaf,0x12,0xae,0x11}
        },
        {
            16, 0xdf8, 0,
            {0xad,0x10,0xac,0x0f,0x85,0x0d,0x19,0x85,0x0e,0x1a,0x75,0x1b,0x21,0x75,0x1c,0x1a}
        },
        {
            16, 0xe08, 0,
            {0x12,0x14,0x2a,0xe4,0xff,0xfe,0xc3,0xef,0x95,0x0e,0xee,0x95,0x0d,0x50,0x0c,0x12}
        },
        {
            16, 0xe18, 0,
            {0x13,0x21,0xed,0xf0,0x0f,0xbf,0x00,0x01,0x0e,0x80,0xeb,0x12,0x13,0x38,0xe5,0x0e}
        },
        {
            16, 0xe28, 0,
            {0xf0,0x00,0x00,0x00,0xc3,0xe5,0x14,0x95,0x0e,0xf5,0x14,0xe5,0x13,0x95,0x0d,0xf5}
        },
        {
            16, 0xe38, 0,
            {0x13,0xe4,0xfc,0xfd,0xe5,0x12,0x25,0x0e,0xf5,0x12,0xe5,0x11,0x35,0x0d,0xf5,0x11}
        },
        {
            16, 0xe48, 0,
            {0xed,0x35,0x10,0xf5,0x10,0xec,0x35,0x0f,0xf5,0x0f,0x90,0xe6,0xa0,0xe0,0x20,0xe1}
        },
        {
            6, 0xe58, 0,
            {0x03,0x02,0x0d,0xd2,0x80,0xf4}
        },
        {
            1, 0xe5e, 0,
            {0x22}
        },
        {
            16, 0xbf9, 0,
            {0x12,0x13,0x01,0xfc,0xfd,0x12,0x02,0x70,0x8f,0x10,0x8e,0x0f,0x8d,0x0e,0x8c,0x0d}
        },
        {
            16, 0xc09, 0,
            {0x90,0x21,0x00,0xe0,0xf5,0x11,0xa3,0xe0,0xf5,0x12,0xe4,0xf5,0x14,0xf5,0x15,0xf5}
        },
        {
            16, 0xc19, 0,
            {0x13,0xe5,0x12,0x45,0x11,0x70,0x03,0x02,0x0c,0xbf,0x12,0x13,0x38,0xf0,0x00,0x00}
        },
        {
            16, 0xc29, 0,
            {0x00,0x90,0xe6,0xa0,0xe0,0x20,0xe1,0xf9,0xe4,0xff,0xfe,0x90,0xe6,0x8b,0xe0,0xfd}
        },
        {
            16, 0xc39, 0,
            {0xc3,0xef,0x9d,0xee,0x94,0x00,0x50,0x2a,0x12,0x13,0x2d,0xe0,0xfd,0x05,0x15,0xe5}
        },
        {
            16, 0xc49, 0,
            {0x15,0xaa,0x14,0x70,0x02,0x05,0x14,0x14,0x24,0x1a,0xf5,0x82,0x74,0x21,0x3a,0xf5}
        },
        {
            16, 0xc59, 0,
            {0x83,0xed,0xf0,0xe5,0x12,0x15,0x12,0x70,0x02,0x15,0x11,0x0f,0xbf,0x00,0x01,0x0e}
        },
        {
            16, 0xc69, 0,
            {0x80,0xc9,0x05,0x13,0xe5,0x13,0x64,0x04,0x60,0x0c,0xe5,0x12,0x45,0x11,0x60,0x06}
        },
        {
            16, 0xc79, 0,
            {0x90,0xe6,0x8b,0xe0,0x70,0x9b,0x12,0x1c,0xe7,0xaf,0x10,0xae,0x0f,0xad,0x0e,0xac}
        },
        {
            16, 0xc89, 0,
            {0x0d,0x85,0x14,0x1a,0x85,0x15,0x1b,0x75,0x1c,0x21,0x75,0x1d,0x1a,0x12,0x14,0x87}
        },
        {
            16, 0xc99, 0,
            {0x12,0x1c,0xbe,0xe4,0xfc,0xfd,0xe5,0x10,0x25,0x15,0xf5,0x10,0xe5,0x0f,0x35,0x14}
        },
        {
            16, 0xca9, 0,
            {0xf5,0x0f,0xed,0x35,0x0e,0xf5,0x0e,0xec,0x35,0x0d,0xf5,0x0d,0xe4,0xf5,0x14,0xf5}
        },
        {
            6, 0xcb9, 0,
            {0x15,0xf5,0x13,0x02,0x0c,0x1a}
        },
        {
            1, 0xcbf, 0,
            {0x22}
        },
        {
            16, 0x1727, 0,
            {0x90,0x22,0x20,0xe0,0xf5,0x0d,0xa3,0xe0,0xf5,0x0e,0x90,0x22,0x1e,0xe0,0xf5,0x0f}
        },
        {
            16, 0x1737, 0,
            {0xa3,0xe0,0xf5,0x10,0x12,0x1c,0xe7,0xe4,0xff,0x12,0x1c,0x79,0xe5,0x0e,0x15,0x0e}
        },
        {
            16, 0x1747, 0,
            {0xae,0x0d,0x70,0x02,0x15,0x0d,0x4e,0x60,0x11,0x05,0x10,0xe5,0x10,0xae,0x0f,0x70}
        },
        {
            10, 0x1757, 0,
            {0x02,0x05,0x0f,0x14,0xff,0x12,0x15,0x3a,0x80,0xe2}
        },
        {
            1, 0x1761, 0,
            {0x22}
        },
        {
            16, 0x161f, 0,
            {0x90,0x21,0x00,0xe0,0xfe,0xa3,0xe0,0xff,0xc3,0x94,0x05,0xee,0x94,0x00,0x50,0x02}
        },
        {
            16, 0x162f, 0,
            {0x80,0x04,0x7e,0x00,0x7f,0x05,0x8e,0x11,0x8f,0x12,0x12,0x11,0xb0,0x8f,0x10,0x8e}
        },
        {
            16, 0x163f, 0,
            {0x0f,0x8d,0x0e,0x8c,0x0d,0x12,0x13,0x54,0x7b,0x00,0x7a,0x00,0x79,0x0d,0x7e,0x00}
        },
        {
            16, 0x164f, 0,
            {0x7f,0x04,0x12,0x01,0xd0,0x12,0x1d,0x0b,0x90,0xe7,0x44,0xef,0xf0,0x12,0x13,0x38}
        },
        {
            6, 0x165f, 0,
            {0xe5,0x12,0xf0,0x00,0x00,0x00}
        },
        {
            1, 0x1665, 0,
            {0x22}
        },
        {
            8, 0x1cd7, 0,
            {0xe4,0xff,0x12,0x1c,0x79,0x02,0x1b,0xb7}
        },
        {
            16, 0x1903, 0,
            {0xe4,0x90,0xe6,0x8a,0xf0,0x00,0x00,0x00,0x90,0xe6,0x8b,0xf0,0x00,0x00,0x00,0x90}
        },
        {
            16, 0x1913, 0,
            {0xe6,0xa0,0xe0,0x20,0xe1,0xf9,0x90,0x22,0x1f,0xe0,0xfb,0x90,0xe7,0x41,0xe0,0xfe}
        },
        {
            16, 0x1923, 0,
            {0x90,0xe7,0x40,0xe0,0x24,0x00,0xff,0xe4,0x3e,0xad,0x07,0xfc,0xaf,0x03,0x02,0x1b}
        },
        {
            1, 0x1933, 0,
            {0x88}
        },
        {
            16, 0x940, 0,
            {0x90,0x22,0x1f,0xe0,0x75,0x0e,0x00,0xf5,0x0f,0xa3,0xe0,0xfe,0xa3,0xe0,0xff,0xee}
        },
        {
            16, 0x950, 0,
            {0x60,0x03,0x02,0x0a,0x00,0xef,0x24,0xfe,0x60,0x3b,0x14,0x60,0x55,0x14,0x60,0x75}
        },
        {
            16, 0x960, 0,
            {0x24,0x03,0x60,0x03,0x02,0x0a,0x00,0xe4,0xff,0x12,0x1d,0x05,0xe4,0xff,0x12,0x16}
        },
        {
            16, 0x970, 0,
            {0xe9,0xe4,0x25,0x0f,0xf5,0x0f,0x74,0x04,0x35,0x0e,0xf5,0x0e,0x90,0x21,0x01,0xe0}
        },
        {
            16, 0x980, 0,
            {0xfd,0x7a,0xe7,0x7b,0x40,0xaf,0x0f,0xae,0x0e,0x12,0x10,0xb3,0x90,0x21,0x01,0xe0}
        },
        {
            16, 0x990, 0,
            {0xf5,0x0d,0x02,0x0a,0x16,0x90,0x22,0x1a,0xe0,0x90,0xe7,0x40,0xf0,0x90,0x22,0x1b}
        },
        {
            16, 0x9a0, 0,
            {0xe0,0x90,0xe7,0x41,0xf0,0x90,0x22,0x1c,0xe0,0x90,0xe7,0x42,0xf0,0x75,0x0d,0x03}
        },
        {
            16, 0x9b0, 0,
            {0x80,0x64,0x7f,0x1a,0x12,0x1a,0xc8,0x90,0xe7,0x40,0xef,0xf0,0x7f,0x1b,0x12,0x1a}
        },
        {
            16, 0x9c0, 0,
            {0xc8,0x90,0xe7,0x41,0xef,0xf0,0x7f,0x1c,0x12,0x1a,0xc8,0x90,0xe7,0x42,0xef,0xf0}
        },
        {
            16, 0x9d0, 0,
            {0x75,0x0d,0x03,0x80,0x41,0x12,0x13,0x54,0x7b,0x01,0x7a,0x21,0x79,0x02,0x12,0x04}
        },
        {
            16, 0x9e0, 0,
            {0x1d,0x75,0x15,0xff,0x75,0x16,0x1c,0x75,0x17,0x20,0x7b,0x01,0x7a,0xe7,0x79,0x40}
        },
        {
            16, 0x9f0, 0,
            {0x12,0x14,0xe2,0x7b,0x01,0x7a,0xe7,0x79,0x40,0x12,0x1b,0xf7,0x8f,0x0d,0x80,0x16}
        },
        {
            16, 0xa00, 0,
            {0xaf,0x0f,0x12,0x17,0x9c,0x8e,0x10,0x8f,0x11,0x90,0xe7,0x40,0xe5,0x11,0xf0,0xa3}
        },
        {
            16, 0xa10, 0,
            {0xe5,0x10,0xf0,0x75,0x0d,0x02,0xe4,0x90,0xe6,0x8a,0xf0,0x00,0x00,0x00,0xc3,0x90}
        },
        {
            16, 0xa20, 0,
            {0x21,0x01,0xe0,0x95,0x0d,0x90,0x21,0x00,0xe0,0x94,0x00,0x50,0x05,0xa3,0xe0,0xff}
        },
        {
            12, 0xa30, 0,
            {0x80,0x02,0xaf,0x0d,0x90,0xe6,0x8b,0xef,0xf0,0x00,0x00,0x00}
        },
        {
            1, 0xa3c, 0,
            {0x22}
        },
        {
            16, 0x1934, 0,
            {0x90,0x21,0x00,0xe0,0x70,0x02,0xa3,0xe0,0x60,0x03,0x02,0x13,0x41,0x90,0x22,0x20}
        },
        {
            16, 0x1944, 0,
            {0xe0,0xfe,0xa3,0xe0,0xff,0xee,0x70,0x15,0xef,0x14,0x60,0x06,0x04,0x70,0x0e,0x02}
        },
        {
            16, 0x1954, 0,
            {0x1d,0x11,0x12,0x1c,0xfe,0x12,0x1c,0xe7,0xe4,0xff,0x02,0x1c,0x79,0x12,0x13,0x41}
        },
        {
            1, 0x1964, 0,
            {0x22}
        },
        {
            16, 0xa3d, 0,
            {0xe4,0xf5,0x0a,0xf5,0x0b,0x90,0xe6,0xbf,0xe0,0xfe,0x90,0xe6,0xbe,0xe0,0x7c,0x00}
        },
        {
            16, 0xa4d, 0,
            {0x24,0x00,0x90,0x21,0x01,0xf0,0xec,0x3e,0x90,0x21,0x00,0xf0,0x90,0xe6,0xbd,0xe0}
        },
        {
            16, 0xa5d, 0,
            {0xfe,0x90,0xe6,0xbc,0xe0,0x24,0x00,0x90,0x22,0x1f,0xf0,0xec,0x3e,0x90,0x22,0x1e}
        },
        {
            16, 0xa6d, 0,
            {0xf0,0x90,0xe6,0xbb,0xe0,0xfe,0x90,0xe6,0xba,0xe0,0x24,0x00,0x90,0x22,0x21,0xf0}
        },
        {
            16, 0xa7d, 0,
            {0xec,0x3e,0x90,0x22,0x20,0xf0,0x90,0xe6,0xb8,0xe0,0x33,0x92,0x05,0xa3,0xe0,0xf5}
        },
        {
            16, 0xa8d, 0,
            {0x0c,0x30,0x05,0x3c,0x24,0x3e,0x60,0x26,0x14,0x60,0x1e,0x24,0xfd,0x60,0x15,0x24}
        },
        {
            16, 0xa9d, 0,
            {0xfa,0x60,0x20,0x24,0xf9,0x60,0x08,0x14,0x70,0x1e,0x12,0x16,0x1f,0x80,0x70,0x12}
        },
        {
            16, 0xaad, 0,
            {0x0d,0xb8,0x80,0x6b,0x12,0x0b,0x2b,0x80,0x66,0x12,0x12,0x95,0x80,0x61,0x12,0x09}
        },
        {
            16, 0xabd, 0,
            {0x40,0x80,0x5c,0x12,0x13,0xcc,0x80,0x57,0x74,0xff,0xf5,0x0a,0xf5,0x0b,0x80,0x4f}
        },
        {
            16, 0xacd, 0,
            {0xe5,0x0c,0x12,0x03,0x2b,0x0b,0x02,0xc2,0x0a,0xfd,0xc3,0x0a,0xf8,0xc6,0x0b,0x0c}
        },
        {
            16, 0xadd, 0,
            {0xcc,0x0a,0xf3,0xd3,0x0a,0xee,0xd5,0x0b,0x07,0xd6,0x0b,0x11,0xd8,0x00,0x00,0x0b}
        },
        {
            16, 0xaed, 0,
            {0x16,0x12,0x17,0x27,0x80,0x29,0x12,0x0b,0xf9,0x80,0x24,0x12,0x08,0x39,0x80,0x1f}
        },
        {
            16, 0xafd, 0,
            {0x12,0x18,0xd2,0x80,0x1a,0x12,0x19,0x03,0x80,0x15,0x12,0x19,0x34,0x80,0x10,0x12}
        },
        {
            16, 0xb0d, 0,
            {0x1a,0x75,0x80,0x0b,0x12,0x1c,0xd7,0x80,0x06,0x74,0xff,0xf5,0x0a,0xf5,0x0b,0xae}
        },
        {
            13, 0xb1d, 0,
            {0x0a,0xaf,0x0b,0xbe,0xff,0x06,0xbf,0xff,0x03,0xd3,0x80,0x01,0xc3}
        },
        {
            1, 0xb2a, 0,
            {0x22}
        },
        {
            10, 0x1c8f, 0,
            {0x00,0x01,0x02,0x02,0x03,0x03,0x04,0x04,0x05,0x05}
        },
        {
            16, 0x15d5, 0,
            {0xec,0x4e,0xfe,0xed,0x4f,0x24,0x8f,0xf5,0x82,0x74,0x1c,0x3e,0xf5,0x83,0xe4,0x93}
        },
        {
            16, 0x15e5, 0,
            {0xff,0x33,0x95,0xe0,0xfe,0xef,0x24,0xa1,0xff,0xee,0x34,0xe6,0x8f,0x82,0xf5,0x83}
        },
        {
            16, 0x15f5, 0,
            {0xe0,0x22,0x90,0xe6,0xa0,0xe0,0x44,0x01,0xf0,0x22,0x90,0xe7,0x40,0xf0,0xe4,0xa3}
        },
        {
            16, 0x1605, 0,
            {0xf0,0x90,0xe6,0x8a,0xf0,0x90,0xe6,0x8b,0x74,0x02,0xf0,0x22,0x90,0xe6,0xbc,0xe0}
        },
        {
            10, 0x1615, 0,
            {0x54,0x7e,0xff,0x7e,0x00,0xe0,0xd3,0x94,0x80,0x22}
        },
        {
            16, 0x60a, 0,
            {0x7e,0x0f,0x7f,0x00,0x8e,0x23,0x8f,0x24,0x75,0x2b,0x0f,0x75,0x2c,0x12,0x75,0x21}
        },
        {
            16, 0x61a, 0,
            {0x0f,0x75,0x22,0x1c,0x75,0x29,0x0f,0x75,0x2a,0x2e,0x75,0x2d,0x0f,0x75,0x2e,0x40}
        },
        {
            16, 0x62a, 0,
            {0xee,0x54,0xe0,0x70,0x03,0x02,0x06,0xfd,0x90,0x23,0x80,0x74,0x22,0xf0,0xa3,0x74}
        },
        {
            16, 0x63a, 0,
            {0x80,0xf0,0xa3,0xee,0xf0,0xa3,0xef,0xf0,0xc3,0x74,0x98,0x9f,0xff,0x74,0x0f,0x9e}
        },
        {
            16, 0x64a, 0,
            {0xcf,0x24,0x02,0xcf,0x34,0x00,0xfe,0xe4,0xfc,0xfd,0xa3,0x12,0x03,0x0f,0xe4,0xf5}
        },
        {
            16, 0x65a, 0,
            {0x0b,0xf5,0x0a,0xf5,0x09,0xf5,0x08,0x90,0x23,0x84,0x12,0x03,0x03,0xab,0x0b,0xaa}
        },
        {
            16, 0x66a, 0,
            {0x0a,0xa9,0x09,0xa8,0x08,0xc3,0x12,0x02,0xcc,0x50,0x3a,0xae,0x0a,0xaf,0x0b,0x90}
        },
        {
            16, 0x67a, 0,
            {0x23,0x82,0xe0,0xfc,0xa3,0xe0,0x2f,0xf5,0x82,0xec,0x3e,0xf5,0x83,0xe4,0x93,0xfd}
        },
        {
            16, 0x68a, 0,
            {0x90,0x23,0x80,0xe0,0xfa,0xa3,0xe0,0x2f,0xf5,0x82,0xea,0x3e,0xf5,0x83,0xed,0xf0}
        },
        {
            16, 0x69a, 0,
            {0xef,0x24,0x01,0xf5,0x0b,0xe4,0x3e,0xf5,0x0a,0xe4,0x35,0x09,0xf5,0x09,0xe4,0x35}
        },
        {
            16, 0x6aa, 0,
            {0x08,0xf5,0x08,0x80,0xb2,0x90,0x23,0x80,0xe0,0xfe,0xa3,0xe0,0xff,0xc3,0x74,0x00}
        },
        {
            16, 0x6ba, 0,
            {0x9f,0xff,0x74,0x0f,0x9e,0xfe,0x90,0x22,0x7e,0xf0,0xa3,0xef,0xf0,0x90,0x23,0x80}
        },
        {
            16, 0x6ca, 0,
            {0xe0,0xf5,0x23,0xa3,0xe0,0xf5,0x24,0xc3,0xe5,0x2c,0x9f,0xf5,0x2c,0xe5,0x2b,0x9e}
        },
        {
            16, 0x6da, 0,
            {0xf5,0x2b,0xc3,0xe5,0x22,0x9f,0xf5,0x22,0xe5,0x21,0x9e,0xf5,0x21,0xc3,0xe5,0x2a}
        },
        {
            16, 0x6ea, 0,
            {0x9f,0xf5,0x2a,0xe5,0x29,0x9e,0xf5,0x29,0xc3,0xe5,0x2e,0x9f,0xf5,0x2e,0xe5,0x2d}
        },
        {
            16, 0x6fa, 0,
            {0x9e,0xf5,0x2d,0x85,0x29,0x25,0x85,0x2a,0x26,0x85,0x21,0x27,0x85,0x22,0x28,0x90}
        },
        {
            16, 0x70a, 0,
            {0xe6,0x80,0xe0,0x30,0xe7,0x0c,0x85,0x21,0x25,0x85,0x22,0x26,0x85,0x29,0x27,0x85}
        },
        {
            16, 0x71a, 0,
            {0x2a,0x28,0x85,0x26,0x82,0x85,0x25,0x83,0xa3,0x74,0x02,0xf0,0x85,0x28,0x82,0x85}
        },
        {
            6, 0x72a, 0,
            {0x27,0x83,0xa3,0x74,0x07,0xf0}
        },
        {
            1, 0x730, 0,
            {0x22}
        },
        {
            16, 0x43a, 0,
            {0x90,0xe6,0xb8,0xe0,0x54,0x60,0xf5,0x08,0xa3,0xe0,0x12,0x03,0x2b,0x05,0x00,0x00}
        },
        {
            16, 0x44a, 0,
            {0x05,0x55,0x01,0x05,0xba,0x03,0x04,0x63,0x06,0x04,0xfa,0x08,0x04,0xf4,0x09,0x04}
        },
        {
            16, 0x45a, 0,
            {0xe8,0x0a,0x04,0xee,0x0b,0x00,0x00,0x05,0xfa,0x12,0x1d,0x23,0x40,0x03,0x02,0x06}
        },
        {
            16, 0x46a, 0,
            {0x02,0x90,0xe6,0xbb,0xe0,0x24,0xfe,0x60,0x2c,0x14,0x60,0x47,0x24,0xfd,0x60,0x16}
        },
        {
            16, 0x47a, 0,
            {0x14,0x60,0x31,0x24,0x06,0x70,0x61,0xe5,0x23,0x90,0xe6,0xb3,0xf0,0xe5,0x24,0x90}
        },
        {
            16, 0x48a, 0,
            {0xe6,0xb4,0xf0,0x02,0x06,0x02,0xe5,0x2b,0x90,0xe6,0xb3,0xf0,0xe5,0x2c,0x90,0xe6}
        },
        {
            16, 0x49a, 0,
            {0xb4,0xf0,0x02,0x06,0x02,0xe5,0x25,0x90,0xe6,0xb3,0xf0,0xe5,0x26,0x90,0xe6,0xb4}
        },
        {
            16, 0x4aa, 0,
            {0xf0,0x02,0x06,0x02,0xe5,0x27,0x90,0xe6,0xb3,0xf0,0xe5,0x28,0x90,0xe6,0xb4,0xf0}
        },
        {
            16, 0x4ba, 0,
            {0x02,0x06,0x02,0x90,0xe6,0xba,0xe0,0xff,0x12,0x19,0xf2,0xaa,0x06,0xa9,0x07,0x7b}
        },
        {
            16, 0x4ca, 0,
            {0x01,0xea,0x49,0x60,0x0d,0xee,0x90,0xe6,0xb3,0xf0,0xef,0x90,0xe6,0xb4,0xf0,0x02}
        },
        {
            16, 0x4da, 0,
            {0x06,0x02,0x12,0x15,0xf7,0x02,0x06,0x02,0x12,0x15,0xf7,0x02,0x06,0x02,0x12,0x1c}
        },
        {
            16, 0x4ea, 0,
            {0xb5,0x02,0x06,0x02,0x12,0x1c,0xcf,0x02,0x06,0x02,0x12,0x1c,0xc7,0x02,0x06,0x02}
        },
        {
            16, 0x4fa, 0,
            {0x12,0x1c,0xac,0x02,0x06,0x02,0x12,0x1d,0x25,0x40,0x03,0x02,0x06,0x02,0x90,0xe6}
        },
        {
            16, 0x50a, 0,
            {0xb8,0xe0,0x24,0x7f,0x60,0x1a,0x14,0x60,0x22,0x24,0x02,0x70,0x38,0xa2,0x00,0xe4}
        },
        {
            16, 0x51a, 0,
            {0x33,0xff,0x25,0xe0,0xff,0xa2,0x02,0xe4,0x33,0x4f,0x12,0x15,0xff,0x02,0x06,0x02}
        },
        {
            16, 0x52a, 0,
            {0xe4,0x90,0xe7,0x40,0xf0,0x12,0x16,0x04,0x02,0x06,0x02,0x12,0x16,0x11,0x40,0x06}
        },
        {
            16, 0x53a, 0,
            {0x7c,0x00,0x7d,0x01,0x80,0x04,0x7c,0x00,0x7d,0x00,0x12,0x15,0xd5,0x54,0x01,0x12}
        },
        {
            16, 0x54a, 0,
            {0x15,0xff,0x02,0x06,0x02,0x12,0x15,0xf7,0x02,0x06,0x02,0x12,0x1d,0x27,0x40,0x03}
        },
        {
            16, 0x55a, 0,
            {0x02,0x06,0x02,0x90,0xe6,0xb8,0xe0,0x24,0xfe,0x60,0x19,0x24,0x02,0x60,0x03,0x02}
        },
        {
            16, 0x56a, 0,
            {0x06,0x02,0x90,0xe6,0xba,0xe0,0xb4,0x01,0x05,0xc2,0x00,0x02,0x06,0x02,0x12,0x15}
        },
        {
            16, 0x57a, 0,
            {0xf7,0x02,0x06,0x02,0x90,0xe6,0xba,0xe0,0x70,0x31,0x12,0x16,0x11,0x40,0x06,0x7c}
        },
        {
            16, 0x58a, 0,
            {0x00,0x7d,0x01,0x80,0x04,0x7c,0x00,0x7d,0x00,0x12,0x15,0xd5,0x54,0xfe,0xf0,0x90}
        },
        {
            16, 0x59a, 0,
            {0xe6,0xbc,0xe0,0x54,0x80,0xff,0x13,0x13,0x13,0x54,0x1f,0xff,0xe0,0x54,0x0f,0x2f}
        },
        {
            16, 0x5aa, 0,
            {0x90,0xe6,0x83,0xf0,0xe0,0x44,0x20,0xf0,0x02,0x06,0x02,0x12,0x15,0xf7,0x80,0x48}
        },
        {
            16, 0x5ba, 0,
            {0x12,0x1d,0x29,0x50,0x43,0x90,0xe6,0xb8,0xe0,0x24,0xfe,0x60,0x1c,0x24,0x02,0x70}
        },
        {
            16, 0x5ca, 0,
            {0x37,0x90,0xe6,0xba,0xe0,0xb4,0x01,0x04,0xd2,0x00,0x80,0x2c,0x90,0xe6,0xba,0xe0}
        },
        {
            16, 0x5da, 0,
            {0x64,0x02,0x60,0x24,0x12,0x15,0xf7,0x80,0x1f,0x12,0x16,0x11,0x40,0x06,0x7c,0x00}
        },
        {
            16, 0x5ea, 0,
            {0x7d,0x01,0x80,0x04,0x7c,0x00,0x7d,0x00,0x12,0x15,0xd5,0x44,0x01,0xf0,0x80,0x08}
        },
        {
            15, 0x5fa, 0,
            {0x12,0x1c,0x5a,0x50,0x03,0x12,0x15,0xf7,0x90,0xe6,0xa0,0xe0,0x44,0x80,0xf0}
        },
        {
            1, 0x609, 0,
            {0x22}
        },
        {
            16, 0x1223, 0,
            {0xc2,0x03,0xc2,0x00,0xc2,0x02,0xc2,0x01,0x12,0x1d,0x19,0x12,0x06,0x0a,0xd2,0xe8}
        },
        {
            16, 0x1233, 0,
            {0x43,0xd8,0x20,0x90,0xe6,0x68,0xe0,0x44,0x0b,0xf0,0x75,0xa2,0xff,0x90,0xe6,0x5c}
        },
        {
            16, 0x1243, 0,
            {0xe0,0x44,0x3d,0xf0,0xd2,0xaf,0x90,0xe6,0x80,0xe0,0x44,0x02,0xf0,0x00,0x00,0x00}
        },
        {
            16, 0x1253, 0,
            {0xe0,0x54,0xf7,0xf0,0x53,0x8e,0xf8,0xc2,0x03,0x30,0x01,0x05,0x12,0x04,0x3a,0xc2}
        },
        {
            16, 0x1263, 0,
            {0x01,0x30,0x03,0x29,0x12,0x1d,0x1f,0x50,0x24,0xc2,0x03,0x12,0x1a,0xee,0x20,0x00}
        },
        {
            16, 0x1273, 0,
            {0x16,0x90,0xe6,0x82,0xe0,0x30,0xe7,0x04,0xe0,0x20,0xe1,0xef,0x90,0xe6,0x82,0xe0}
        },
        {
            16, 0x1283, 0,
            {0x30,0xe6,0x04,0xe0,0x20,0xe0,0xe4,0x12,0x19,0xc6,0x12,0x1d,0x21,0x12,0x1d,0x1c}
        },
        {
            2, 0x1293, 0,
            {0x80,0xc7}
        },
        {
            3, 0x33, 0,
            {0x02,0x1d,0x15}
        },
        {
            4, 0x1d15, 0,
            {0x53,0xd8,0xef,0x32}
        },
        {
            3, 0x43, 0,
            {0x02,0x0d,0x00}
        },
        {
            3, 0x53, 0,
            {0x02,0x0d,0x00}
        },
        {
            16, 0xd00, 0,
            {0x02,0x1b,0xcd,0x00,0x02,0x1c,0x47,0x00,0x02,0x1c,0x34,0x00,0x02,0x1b,0xe2,0x00}
        },
        {
            16, 0xd10, 0,
            {0x02,0x18,0x3c,0x00,0x02,0x17,0x62,0x00,0x02,0x0c,0xff,0x00,0x02,0x1d,0x2b,0x00}
        },
        {
            16, 0xd20, 0,
            {0x02,0x1d,0x2c,0x00,0x02,0x1d,0x2d,0x00,0x02,0x1d,0x2e,0x00,0x02,0x1d,0x2f,0x00}
        },
        {
            16, 0xd30, 0,
            {0x02,0x1d,0x30,0x00,0x02,0x1d,0x31,0x00,0x02,0x1d,0x32,0x00,0x02,0x1d,0x33,0x00}
        },
        {
            16, 0xd40, 0,
            {0x02,0x1d,0x34,0x00,0x02,0x1d,0x2b,0x00,0x02,0x1d,0x35,0x00,0x02,0x1d,0x36,0x00}
        },
        {
            16, 0xd50, 0,
            {0x02,0x1d,0x37,0x00,0x02,0x1d,0x38,0x00,0x02,0x1d,0x39,0x00,0x02,0x1d,0x3a,0x00}
        },
        {
            16, 0xd60, 0,
            {0x02,0x1d,0x3b,0x00,0x02,0x1d,0x2b,0x00,0x02,0x1d,0x2b,0x00,0x02,0x1d,0x2b,0x00}
        },
        {
            16, 0xd70, 0,
            {0x02,0x1d,0x3c,0x00,0x02,0x1d,0x3d,0x00,0x02,0x1d,0x3e,0x00,0x02,0x1d,0x3f,0x00}
        },
        {
            16, 0xd80, 0,
            {0x02,0x1d,0x40,0x00,0x02,0x1d,0x41,0x00,0x02,0x1d,0x42,0x00,0x02,0x1d,0x43,0x00}
        },
        {
            16, 0xd90, 0,
            {0x02,0x1d,0x44,0x00,0x02,0x1d,0x45,0x00,0x02,0x1d,0x46,0x00,0x02,0x1d,0x47,0x00}
        },
        {
            16, 0xda0, 0,
            {0x02,0x1d,0x48,0x00,0x02,0x1d,0x49,0x00,0x02,0x1d,0x4a,0x00,0x02,0x1d,0x4b,0x00}
        },
        {
            8, 0xdb0, 0,
            {0x02,0x1d,0x4c,0x00,0x02,0x1d,0x4d,0x00}
        },
        {
            16, 0xf00, 0,
            {0x12,0x01,0x00,0x02,0xff,0xff,0xff,0x40,0xb4,0x04,0x13,0x86,0x00,0x00,0x01,0x02}
        },
        {
            16, 0xf10, 0,
            {0x00,0x01,0x0a,0x06,0x00,0x02,0xff,0xff,0xff,0x40,0x01,0x00,0x09,0x02,0x12,0x00}
        },
        {
            16, 0xf20, 0,
            {0x01,0x01,0x00,0x60,0x32,0x09,0x04,0x00,0x00,0x00,0xff,0xff,0xff,0x00,0x09,0x02}
        },
        {
            16, 0xf30, 0,
            {0x12,0x00,0x01,0x01,0x00,0x60,0x32,0x09,0x04,0x00,0x00,0x00,0xff,0xff,0xff,0x00}
        },
        {
            16, 0xf40, 0,
            {0x04,0x03,0x09,0x04,0x30,0x03,0x41,0x00,0x70,0x00,0x6f,0x00,0x67,0x00,0x65,0x00}
        },
        {
            16, 0xf50, 0,
            {0x65,0x00,0x2d,0x00,0x49,0x00,0x6e,0x00,0x73,0x00,0x74,0x00,0x72,0x00,0x75,0x00}
        },
        {
            16, 0xf60, 0,
            {0x6d,0x00,0x65,0x00,0x6e,0x00,0x74,0x00,0x73,0x00,0x20,0x00,0x49,0x00,0x6e,0x00}
        },
        {
            16, 0xf70, 0,
            {0x63,0x00,0x2e,0x00,0x24,0x03,0x41,0x00,0x73,0x00,0x63,0x00,0x65,0x00,0x6e,0x00}
        },
        {
            16, 0xf80, 0,
            {0x74,0x00,0x20,0x00,0x52,0x00,0x4f,0x00,0x4d,0x00,0x20,0x00,0x4e,0x00,0x45,0x00}
        },
        {
            10, 0xf90, 0,
            {0x54,0x00,0x30,0x00,0x30,0x00,0x31,0x00,0x00,0x00}
        },
        {
            16, 0x19c6, 0,
            {0x90,0xe6,0x82,0xe0,0x30,0xe0,0x04,0xe0,0x20,0xe6,0x0b,0x90,0xe6,0x82,0xe0,0x30}
        },
        {
            16, 0x19d6, 0,
            {0xe1,0x19,0xe0,0x30,0xe7,0x15,0x90,0xe6,0x80,0xe0,0x44,0x01,0xf0,0x7f,0x14,0x7e}
        },
        {
            12, 0x19e6, 0,
            {0x00,0x12,0x16,0xa8,0x90,0xe6,0x80,0xe0,0x54,0xfe,0xf0,0x22}
        },
        {
            16, 0x1aee, 0,
            {0x90,0xe6,0x82,0xe0,0x44,0xc0,0xf0,0x90,0xe6,0x81,0xf0,0x43,0x87,0x01,0x00,0x00}
        },
        {
            4, 0x1afe, 0,
            {0x00,0x00,0x00,0x22}
        },
        {
            8, 0x1cdf, 0,
            {0xe4,0xf5,0x34,0xd2,0xe9,0xd2,0xaf,0x22}
        },
        {
            16, 0x17d2, 0,
            {0x90,0xe6,0x78,0xe0,0x20,0xe6,0xf9,0xc2,0xe9,0x90,0xe6,0x78,0xe0,0x44,0x80,0xf0}
        },
        {
            16, 0x17e2, 0,
            {0xef,0x25,0xe0,0x90,0xe6,0x79,0xf0,0x90,0xe6,0x78,0xe0,0x30,0xe0,0xf9,0x90,0xe6}
        },
        {
            16, 0x17f2, 0,
            {0x78,0xe0,0x44,0x40,0xf0,0x90,0xe6,0x78,0xe0,0x20,0xe6,0xf9,0x90,0xe6,0x78,0xe0}
        },
        {
            6, 0x1802, 0,
            {0x30,0xe1,0xd6,0xd2,0xe9,0x22}
        },
        {
            16, 0x186f, 0,
            {0xa9,0x07,0x90,0xe6,0x78,0xe0,0x20,0xe6,0xf9,0xe5,0x34,0x70,0x23,0x90,0xe6,0x78}
        },
        {
            16, 0x187f, 0,
            {0xe0,0x44,0x80,0xf0,0xe9,0x25,0xe0,0x90,0xe6,0x79,0xf0,0x8d,0x2f,0xaf,0x03,0xa9}
        },
        {
            16, 0x188f, 0,
            {0x07,0x75,0x30,0x01,0x8a,0x31,0x89,0x32,0xe4,0xf5,0x33,0x75,0x34,0x01,0xd3,0x22}
        },
        {
            2, 0x189f, 0,
            {0xc3,0x22}
        },
        {
            16, 0x1808, 0,
            {0xa9,0x07,0x90,0xe6,0x78,0xe0,0x20,0xe6,0xf9,0xe5,0x34,0x70,0x25,0x90,0xe6,0x78}
        },
        {
            16, 0x1818, 0,
            {0xe0,0x44,0x80,0xf0,0xe9,0x25,0xe0,0x44,0x01,0x90,0xe6,0x79,0xf0,0x8d,0x2f,0xaf}
        },
        {
            16, 0x1828, 0,
            {0x03,0xa9,0x07,0x75,0x30,0x01,0x8a,0x31,0x89,0x32,0xe4,0xf5,0x33,0x75,0x34,0x03}
        },
        {
            4, 0x1838, 0,
            {0xd3,0x22,0xc3,0x22}
        },
        {
            3, 0x4b, 0,
            {0x02,0x07,0x31}
        },
        {
            16, 0x731, 0,
            {0xc0,0xe0,0xc0,0x83,0xc0,0x82,0xc0,0x85,0xc0,0x84,0xc0,0x86,0x75,0x86,0x00,0xc0}
        },
        {
            16, 0x741, 0,
            {0xd0,0x75,0xd0,0x00,0xc0,0x00,0xc0,0x01,0xc0,0x02,0xc0,0x03,0xc0,0x06,0xc0,0x07}
        },
        {
            16, 0x751, 0,
            {0x90,0xe6,0x78,0xe0,0x30,0xe2,0x06,0x75,0x34,0x06,0x02,0x08,0x1b,0x90,0xe6,0x78}
        },
        {
            16, 0x761, 0,
            {0xe0,0x20,0xe1,0x0c,0xe5,0x34,0x64,0x02,0x60,0x06,0x75,0x34,0x07,0x02,0x08,0x1b}
        },
        {
            16, 0x771, 0,
            {0xe5,0x34,0x24,0xfe,0x60,0x5f,0x14,0x60,0x36,0x24,0xfe,0x70,0x03,0x02,0x08,0x0c}
        },
        {
            16, 0x781, 0,
            {0x24,0xfc,0x70,0x03,0x02,0x08,0x18,0x24,0x08,0x60,0x03,0x02,0x08,0x1b,0xab,0x30}
        },
        {
            16, 0x791, 0,
            {0xaa,0x31,0xa9,0x32,0xaf,0x33,0x05,0x33,0x8f,0x82,0x75,0x83,0x00,0x12,0x02,0x0f}
        },
        {
            16, 0x7a1, 0,
            {0x90,0xe6,0x79,0xf0,0xe5,0x33,0x65,0x2f,0x70,0x70,0x75,0x34,0x05,0x80,0x6b,0x90}
        },
        {
            16, 0x7b1, 0,
            {0xe6,0x79,0xe0,0xab,0x30,0xaa,0x31,0xa9,0x32,0xae,0x33,0x8e,0x82,0x75,0x83,0x00}
        },
        {
            16, 0x7c1, 0,
            {0x12,0x02,0x4e,0x75,0x34,0x02,0xe5,0x2f,0x64,0x01,0x70,0x4e,0x90,0xe6,0x78,0xe0}
        },
        {
            16, 0x7d1, 0,
            {0x44,0x20,0xf0,0x80,0x45,0xe5,0x2f,0x24,0xfe,0xb5,0x33,0x07,0x90,0xe6,0x78,0xe0}
        },
        {
            16, 0x7e1, 0,
            {0x44,0x20,0xf0,0xe5,0x2f,0x14,0xb5,0x33,0x0a,0x90,0xe6,0x78,0xe0,0x44,0x40,0xf0}
        },
        {
            16, 0x7f1, 0,
            {0x75,0x34,0x00,0x90,0xe6,0x79,0xe0,0xab,0x30,0xaa,0x31,0xa9,0x32,0xae,0x33,0x8e}
        },
        {
            16, 0x801, 0,
            {0x82,0x75,0x83,0x00,0x12,0x02,0x4e,0x05,0x33,0x80,0x0f,0x90,0xe6,0x78,0xe0,0x44}
        },
        {
            16, 0x811, 0,
            {0x40,0xf0,0x75,0x34,0x00,0x80,0x03,0x75,0x34,0x00,0x53,0x91,0xdf,0xd0,0x07,0xd0}
        },
        {
            16, 0x821, 0,
            {0x06,0xd0,0x03,0xd0,0x02,0xd0,0x01,0xd0,0x00,0xd0,0xd0,0xd0,0x86,0xd0,0x84,0xd0}
        },
        {
            8, 0x831, 0,
            {0x85,0xd0,0x82,0xd0,0x83,0xd0,0xe0,0x32}
        },
        {
            2, 0x19f2, 0,
            {0xa9,0x07}
        },
        {
            16, 0x19f4, 0,
            {0xae,0x2d,0xaf,0x2e,0x8f,0x82,0x8e,0x83,0xa3,0xe0,0x64,0x03,0x70,0x17,0xad,0x01}
        },
        {
            16, 0x1a04, 0,
            {0x19,0xed,0x70,0x01,0x22,0x8f,0x82,0x8e,0x83,0xe0,0x7c,0x00,0x2f,0xfd,0xec,0x3e}
        },
        {
            9, 0x1a14, 0,
            {0xfe,0xaf,0x05,0x80,0xdf,0x7e,0x00,0x7f,0x00}
        },
        {
            1, 0x1a1d, 0,
            {0x22}
        },
        {
            16, 0x1b36, 0,
            {0x12,0x18,0x08,0xe5,0x34,0x24,0xfa,0x60,0x0e,0x14,0x60,0x06,0x24,0x07,0x70,0xf3}
        },
        {
            12, 0x1b46, 0,
            {0xd3,0x22,0xe4,0xf5,0x34,0xd3,0x22,0xe4,0xf5,0x34,0xd3,0x22}
        },
        {
            16, 0x1b52, 0,
            {0x12,0x18,0x6f,0xe5,0x34,0x24,0xfa,0x60,0x0e,0x14,0x60,0x06,0x24,0x07,0x70,0xf3}
        },
        {
            12, 0x1b62, 0,
            {0xd3,0x22,0xe4,0xf5,0x34,0xd3,0x22,0xe4,0xf5,0x34,0xd3,0x22}
        },
        {
            16, 0x16a8, 0,
            {0x8e,0x08,0x8f,0x09,0x90,0xe6,0x00,0xe0,0x54,0x18,0x70,0x0d,0xe5,0x08,0xc3,0x13}
        },
        {
            16, 0x16b8, 0,
            {0xf5,0x08,0xe5,0x09,0x13,0xf5,0x09,0x80,0x15,0x90,0xe6,0x00,0xe0,0x54,0x18,0xff}
        },
        {
            16, 0x16c8, 0,
            {0xbf,0x10,0x0b,0xe5,0x09,0x25,0xe0,0xf5,0x09,0xe5,0x08,0x33,0xf5,0x08,0xe5,0x09}
        },
        {
            16, 0x16d8, 0,
            {0x15,0x09,0xae,0x08,0x70,0x02,0x15,0x08,0x4e,0x60,0x05,0x12,0x1b,0x02,0x80,0xee}
        },
        {
            1, 0x16e8, 0,
            {0x22}
        },
        {
            16, 0x1b02, 0,
            {0x74,0x00,0xf5,0x86,0x90,0xfd,0xa5,0x7c,0x05,0xa3,0xe5,0x82,0x45,0x83,0x70,0xf9}
        },
        {
            1, 0x1b12, 0,
            {0x22}
        },
        {
            16, 0x1a1e, 0,
            {0xef,0x25,0xe0,0xff,0xed,0x24,0xff,0x92,0x86,0xe4,0x22,0xc2,0x83,0xd2,0x82,0xc2}
        },
        {
            16, 0x1a2e, 0,
            {0x80,0xe4,0xf5,0xb3,0x75,0xb2,0x6d,0x22,0x75,0xb2,0xfd,0xd2,0x82,0xc2,0x83,0xc2}
        },
        {
            12, 0x1a3e, 0,
            {0x86,0x22,0xab,0x07,0x78,0x08,0x12,0x02,0xdd,0xaa,0x07,0x22}
        },
        {
            3, 0xf9a, 0,
            {0x12,0x1a,0x29}
        },
        {
            16, 0xf9d, 0,
            {0xf5,0x1e,0xf5,0x1f,0x05,0x1f,0xe5,0x1f,0x70,0x02,0x05,0x1e,0x64,0x05,0x45,0x1e}
        },
        {
            2, 0xfad, 0,
            {0x70,0xf2}
        },
        {
            2, 0xfaf, 0,
            {0xc2,0x82}
        },
        {
            16, 0xfb1, 0,
            {0xe4,0xf5,0x1e,0xf5,0x1f,0x05,0x1f,0xe5,0x1f,0x70,0x02,0x05,0x1e,0x64,0x05,0x45}
        },
        {
            3, 0xfc1, 0,
            {0x1e,0x70,0xf2}
        },
        {
            12, 0xfc4, 0,
            {0xe4,0xfe,0xef,0x30,0xe7,0x04,0x7d,0x01,0x80,0x02,0x7d,0x00}
        },
        {
            16, 0xfd0, 0,
            {0x12,0x1a,0x1e,0xf5,0x1e,0xf5,0x1f,0x05,0x1f,0xe5,0x1f,0x70,0x02,0x05,0x1e,0x64}
        },
        {
            5, 0xfe0, 0,
            {0x05,0x45,0x1e,0x70,0xf2}
        },
        {
            2, 0xfe5, 0,
            {0xd2,0x83}
        },
        {
            16, 0xfe7, 0,
            {0xe4,0xf5,0x1e,0xf5,0x1f,0x05,0x1f,0xe5,0x1f,0x70,0x02,0x05,0x1e,0x64,0x05,0x45}
        },
        {
            3, 0xff7, 0,
            {0x1e,0x70,0xf2}
        },
        {
            6, 0xffa, 0,
            {0xc2,0x83,0x0e,0xbe,0x08,0xc6}
        },
        {
            16, 0x1000, 0,
            {0xe4,0xf5,0x1e,0xf5,0x1f,0x05,0x1f,0xe5,0x1f,0x70,0x02,0x05,0x1e,0x64,0x05,0x45}
        },
        {
            3, 0x1010, 0,
            {0x1e,0x70,0xf2}
        },
        {
            16, 0x1013, 0,
            {0xe4,0xf5,0x1e,0xf5,0x1f,0x05,0x1f,0xe5,0x1f,0x70,0x02,0x05,0x1e,0x64,0x05,0x45}
        },
        {
            3, 0x1023, 0,
            {0x1e,0x70,0xf2}
        },
        {
            1, 0x1026, 0,
            {0x22}
        },
        {
            5, 0x1666, 0,
            {0xe4,0xff,0xfe,0xd2,0x83}
        },
        {
            16, 0x166b, 0,
            {0xe4,0xf5,0x1d,0xf5,0x1e,0x05,0x1e,0xe5,0x1e,0x70,0x02,0x05,0x1d,0x64,0x05,0x45}
        },
        {
            3, 0x167b, 0,
            {0x1d,0x70,0xf2}
        },
        {
            8, 0x167e, 0,
            {0xa2,0x84,0xe4,0x33,0x42,0x07,0xc2,0x83}
        },
        {
            16, 0x1686, 0,
            {0xe4,0xf5,0x1d,0xf5,0x1e,0x05,0x1e,0xe5,0x1e,0x70,0x02,0x05,0x1d,0x64,0x05,0x45}
        },
        {
            3, 0x1696, 0,
            {0x1d,0x70,0xf2}
        },
        {
            14, 0x1699, 0,
            {0xee,0xc3,0x94,0x07,0x50,0x04,0xef,0x25,0xe0,0xff,0x0e,0xbe,0x08,0xc2}
        },
        {
            1, 0x16a7, 0,
            {0x22}
        },
        {
            16, 0xcc0, 0,
            {0xe4,0xf5,0x17,0xf5,0x18,0x05,0x18,0xe5,0x18,0x70,0x02,0x05,0x17,0x64,0x05,0x45}
        },
        {
            3, 0xcd0, 0,
            {0x17,0x70,0xf2}
        },
        {
            2, 0xcd3, 0,
            {0xd2,0x82}
        },
        {
            16, 0xcd5, 0,
            {0xe4,0xf5,0x17,0xf5,0x18,0x05,0x18,0xe5,0x18,0x70,0x02,0x05,0x17,0x64,0x05,0x45}
        },
        {
            3, 0xce5, 0,
            {0x17,0x70,0xf2}
        },
        {
            3, 0xce8, 0,
            {0x12,0x1a,0x36}
        },
        {
            16, 0xceb, 0,
            {0xe4,0xf5,0x17,0xf5,0x18,0x05,0x18,0xe5,0x18,0x70,0x02,0x05,0x17,0x64,0x05,0x45}
        },
        {
            3, 0xcfb, 0,
            {0x17,0x70,0xf2}
        },
        {
            1, 0xcfe, 0,
            {0x22}
        },
        {
            7, 0xe5f, 0,
            {0xc2,0x86,0x12,0x1a,0x29,0xc2,0x83}
        },
        {
            16, 0xe66, 0,
            {0xf5,0x19,0xf5,0x1a,0x05,0x1a,0xe5,0x1a,0x70,0x02,0x05,0x19,0x64,0x05,0x45,0x19}
        },
        {
            2, 0xe76, 0,
            {0x70,0xf2}
        },
        {
            2, 0xe78, 0,
            {0xc2,0x82}
        },
        {
            16, 0xe7a, 0,
            {0xe4,0xf5,0x19,0xf5,0x1a,0x05,0x1a,0xe5,0x1a,0x70,0x02,0x05,0x19,0x64,0x05,0x45}
        },
        {
            3, 0xe8a, 0,
            {0x19,0x70,0xf2}
        },
        {
            12, 0xe8d, 0,
            {0xe4,0xfe,0xef,0x30,0xe7,0x04,0x7d,0x01,0x80,0x02,0x7d,0x00}
        },
        {
            16, 0xe99, 0,
            {0x12,0x1a,0x1e,0xf5,0x19,0xf5,0x1a,0x05,0x1a,0xe5,0x1a,0x70,0x02,0x05,0x19,0x64}
        },
        {
            5, 0xea9, 0,
            {0x05,0x45,0x19,0x70,0xf2}
        },
        {
            2, 0xeae, 0,
            {0xd2,0x83}
        },
        {
            16, 0xeb0, 0,
            {0xe4,0xf5,0x19,0xf5,0x1a,0x05,0x1a,0xe5,0x1a,0x70,0x02,0x05,0x19,0x64,0x05,0x45}
        },
        {
            3, 0xec0, 0,
            {0x19,0x70,0xf2}
        },
        {
            6, 0xec3, 0,
            {0xc2,0x83,0x0e,0xbe,0x08,0xc6}
        },
        {
            16, 0xec9, 0,
            {0xe4,0xf5,0x19,0xf5,0x1a,0x05,0x1a,0xe5,0x1a,0x70,0x02,0x05,0x19,0x64,0x05,0x45}
        },
        {
            3, 0xed9, 0,
            {0x19,0x70,0xf2}
        },
        {
            16, 0xedc, 0,
            {0xe4,0xf5,0x19,0xf5,0x1a,0x05,0x1a,0xe5,0x1a,0x70,0x02,0x05,0x19,0x64,0x05,0x45}
        },
        {
            3, 0xeec, 0,
            {0x19,0x70,0xf2}
        },
        {
            1, 0xeef, 0,
            {0x22}
        },
        {
            12, 0x1369, 0,
            {0xe4,0xfe,0xef,0x30,0xe7,0x04,0x7d,0x01,0x80,0x02,0x7d,0x00}
        },
        {
            16, 0x1375, 0,
            {0x12,0x1a,0x1e,0xf5,0x1e,0xf5,0x1f,0x05,0x1f,0xe5,0x1f,0x70,0x02,0x05,0x1e,0x64}
        },
        {
            5, 0x1385, 0,
            {0x05,0x45,0x1e,0x70,0xf2}
        },
        {
            2, 0x138a, 0,
            {0xd2,0x83}
        },
        {
            16, 0x138c, 0,
            {0xe4,0xf5,0x1e,0xf5,0x1f,0x05,0x1f,0xe5,0x1f,0x70,0x02,0x05,0x1e,0x64,0x05,0x45}
        },
        {
            3, 0x139c, 0,
            {0x1e,0x70,0xf2}
        },
        {
            6, 0x139f, 0,
            {0xc2,0x83,0x0e,0xbe,0x08,0xc6}
        },
        {
            16, 0x13a5, 0,
            {0xe4,0xf5,0x1e,0xf5,0x1f,0x05,0x1f,0xe5,0x1f,0x70,0x02,0x05,0x1e,0x64,0x05,0x45}
        },
        {
            3, 0x13b5, 0,
            {0x1e,0x70,0xf2}
        },
        {
            16, 0x13b8, 0,
            {0xe4,0xf5,0x1e,0xf5,0x1f,0x05,0x1f,0xe5,0x1f,0x70,0x02,0x05,0x1e,0x64,0x05,0x45}
        },
        {
            3, 0x13c8, 0,
            {0x1e,0x70,0xf2}
        },
        {
            1, 0x13cb, 0,
            {0x22}
        },
        {
            16, 0x1a4a, 0,
            {0xe4,0xf5,0x1e,0xf5,0x1f,0x05,0x1f,0xe5,0x1f,0x70,0x02,0x05,0x1e,0x64,0x05,0x45}
        },
        {
            3, 0x1a5a, 0,
            {0x1e,0x70,0xf2}
        },
        {
            2, 0x1a5d, 0,
            {0xd2,0x82}
        },
        {
            16, 0x1a5f, 0,
            {0xe4,0xf5,0x1e,0xf5,0x1f,0x05,0x1f,0xe5,0x1f,0x70,0x02,0x05,0x1e,0x64,0x05,0x45}
        },
        {
            3, 0x1a6f, 0,
            {0x1e,0x70,0xf2}
        },
        {
            3, 0x1a72, 0,
            {0x02,0x1a,0x36}
        },
        {
            13, 0x1c6c, 0,
            {0xac,0x05,0x12,0x0e,0x5f,0xaf,0x04,0x12,0x13,0x69,0x02,0x1a,0x4a}
        },
        {
            9, 0x1c99, 0,
            {0x12,0x0f,0x9a,0x12,0x16,0x66,0x12,0x0c,0xc0}
        },
        {
            1, 0x1ca2, 0,
            {0x22}
        },
        {
            8, 0x1996, 0,
            {0x8b,0x35,0x8a,0x36,0x89,0x37,0xac,0x05}
        },
        {
            16, 0x199e, 0,
            {0x12,0x0f,0x9a,0xe4,0xfd,0xed,0xc3,0x9c,0x50,0x1b,0x12,0x16,0x66,0xab,0x35,0xaa}
        },
        {
            16, 0x19ae, 0,
            {0x36,0xa9,0x37,0xef,0x12,0x02,0x3c,0x0d,0x74,0x01,0x25,0x37,0xf5,0x37,0xe4,0x35}
        },
        {
            8, 0x19be, 0,
            {0x36,0xf5,0x36,0x80,0xe0,0x02,0x0c,0xc0}
        },
        {
            8, 0x1965, 0,
            {0x8d,0x15,0x8b,0x16,0x8a,0x17,0x89,0x18}
        },
        {
            16, 0x196d, 0,
            {0x12,0x0e,0x5f,0xe4,0xfc,0xec,0xc3,0x95,0x15,0x50,0x1b,0xab,0x16,0xaa,0x17,0xa9}
        },
        {
            16, 0x197d, 0,
            {0x18,0x12,0x01,0xf6,0xff,0x12,0x13,0x69,0x0c,0x74,0x01,0x25,0x18,0xf5,0x18,0xe4}
        },
        {
            9, 0x198d, 0,
            {0x35,0x17,0xf5,0x17,0x80,0xdf,0x02,0x1a,0x4a}
        },
        {
            15, 0xef0, 0,
            {0x7f,0x05,0x12,0x1c,0x99,0xef,0x30,0xe0,0x04,0x7f,0x01,0x80,0x02,0x7f,0x00}
        },
        {
            1, 0xeff, 0,
            {0x22}
        },
        {
            9, 0x1cbe, 0,
            {0x12,0x0e,0xf0,0xef,0x70,0xfa,0x7f,0x00,0x22}
        },
        {
            16, 0x11b0, 0,
            {0x7f,0x9f,0x12,0x0f,0x9a,0xe4,0xf5,0x16,0xf5,0x15,0xf5,0x14,0xf5,0x13,0x12,0x11}
        },
        {
            16, 0x11c0, 0,
            {0xe4,0xaf,0x16,0xae,0x15,0xad,0x14,0xfc,0x78,0x08,0x12,0x02,0xf0,0x8f,0x16,0x8e}
        },
        {
            16, 0x11d0, 0,
            {0x15,0x8d,0x14,0x8c,0x13,0x12,0x11,0xe4,0x12,0x0c,0xc0,0xaf,0x16,0xae,0x15,0xad}
        },
        {
            3, 0x11e0, 0,
            {0x14,0xac,0x13}
        },
        {
            16, 0x11e3, 0,
            {0x22,0x12,0x16,0x66,0xe4,0xe5,0x16,0x4f,0xf5,0x16,0xe5,0x15,0xf5,0x15,0xe5,0x14}
        },
        {
            16, 0x11f3, 0,
            {0xf5,0x14,0xe5,0x13,0xf5,0x13,0xaf,0x16,0xae,0x15,0xad,0x14,0xfc,0x78,0x08,0x12}
        },
        {
            16, 0x1203, 0,
            {0x02,0xf0,0x8f,0x16,0x8e,0x15,0x8d,0x14,0x8c,0x13,0x12,0x16,0x66,0xe4,0xe5,0x16}
        },
        {
            16, 0x1213, 0,
            {0x4f,0xf5,0x16,0xe5,0x15,0xf5,0x15,0xe5,0x14,0xf5,0x14,0xe5,0x13,0xf5,0x13,0x22}
        },
        {
            5, 0x1d0b, 0,
            {0x7f,0x05,0x12,0x1c,0x99}
        },
        {
            1, 0x1d10, 0,
            {0x22}
        },
        {
            12, 0x1c79, 0,
            {0xab,0x07,0xad,0x03,0x7f,0x01,0x12,0x1c,0x6c,0xaf,0x03,0x22}
        },
        {
            8, 0x1ce7, 0,
            {0x7f,0x06,0x12,0x0f,0x9a,0x02,0x1a,0x4a}
        },
        {
            8, 0x1cef, 0,
            {0x7f,0x04,0x12,0x0e,0x5f,0x02,0x1a,0x4a}
        },
        {
            16, 0x153a, 0,
            {0xe4,0xfc,0xfd,0xfb,0x7a,0x10,0xf9,0xf8,0x12,0x02,0x7d,0x8f,0x14,0x8e,0x13,0x8d}
        },
        {
            16, 0x154a, 0,
            {0x12,0x8c,0x11,0x78,0x10,0x12,0x02,0xdd,0xef,0xe4,0x90,0x23,0xe8,0xef,0xf0,0xaf}
        },
        {
            16, 0x155a, 0,
            {0x14,0xae,0x13,0xad,0x12,0xac,0x11,0x78,0x08,0x12,0x02,0xdd,0xef,0xe4,0xa3,0xef}
        },
        {
            16, 0x156a, 0,
            {0xf0,0xe5,0x14,0xff,0xe4,0xa3,0xef,0xf0,0x12,0x1c,0xe7,0x7a,0x23,0x79,0xe8,0x7b}
        },
        {
            13, 0x157a, 0,
            {0x01,0x7d,0x03,0x7f,0x20,0x12,0x19,0x65,0x12,0x1c,0xbe,0x7f,0x00}
        },
        {
            1, 0x1587, 0,
            {0x22}
        },
        {
            16, 0x1bb7, 0,
            {0x12,0x1c,0xe7,0xe4,0xff,0x12,0x1c,0x79,0x12,0x1c,0xe7,0x7f,0x60,0x12,0x0f,0x9a}
        },
        {
            6, 0x1bc7, 0,
            {0x12,0x1a,0x4a,0x02,0x1c,0xbe}
        },
        {
            8, 0x1487, 0,
            {0x8f,0x19,0x8e,0x18,0x8d,0x17,0x8c,0x16}
        },
        {
            16, 0x148f, 0,
            {0x12,0x1a,0x40,0xaf,0x19,0xae,0x18,0xad,0x17,0xac,0x16,0x78,0x10,0x12,0x02,0xdd}
        },
        {
            16, 0x149f, 0,
            {0xac,0x07,0x12,0x1c,0xe7,0x7f,0x02,0x12,0x0f,0x9a,0xaf,0x04,0x12,0x13,0x69,0xaf}
        },
        {
            16, 0x14af, 0,
            {0x02,0x12,0x13,0x69,0xaf,0x03,0x12,0x13,0x69,0xe4,0xfb,0xfa,0xc3,0xeb,0x95,0x1b}
        },
        {
            16, 0x14bf, 0,
            {0xea,0x95,0x1a,0x50,0x1b,0x05,0x1d,0xe5,0x1d,0xae,0x1c,0x70,0x02,0x05,0x1c,0x14}
        },
        {
            16, 0x14cf, 0,
            {0xf5,0x82,0x8e,0x83,0xe0,0xff,0x12,0x13,0x69,0x0b,0xbb,0x00,0x01,0x0a,0x80,0xdc}
        },
        {
            3, 0x14df, 0,
            {0x02,0x1a,0x4a}
        },
        {
            8, 0x142a, 0,
            {0x8f,0x18,0x8e,0x17,0x8d,0x16,0x8c,0x15}
        },
        {
            16, 0x1432, 0,
            {0x12,0x1a,0x40,0xaf,0x18,0xae,0x17,0xad,0x16,0xac,0x15,0x78,0x10,0x12,0x02,0xdd}
        },
        {
            16, 0x1442, 0,
            {0xac,0x07,0x7f,0x0b,0x12,0x0f,0x9a,0xaf,0x04,0x12,0x13,0x69,0xaf,0x02,0x12,0x13}
        },
        {
            16, 0x1452, 0,
            {0x69,0xaf,0x03,0x12,0x13,0x69,0xe4,0xff,0x12,0x13,0x69,0xe4,0xfd,0xfc,0xc3,0xed}
        },
        {
            16, 0x1462, 0,
            {0x95,0x1a,0xec,0x95,0x19,0x50,0x1b,0x12,0x16,0x66,0x05,0x1c,0xe5,0x1c,0xaa,0x1b}
        },
        {
            16, 0x1472, 0,
            {0x70,0x02,0x05,0x1b,0x14,0xf5,0x82,0x8a,0x83,0xef,0xf0,0x0d,0xbd,0x00,0x01,0x0c}
        },
        {
            5, 0x1482, 0,
            {0x80,0xdc,0x02,0x1a,0x4a}
        },
        {
            3, 0x0, 0,
            {0x02,0x10,0x27}
        },
        {
            12, 0x1027, 0,
            {0x78,0x7f,0xe4,0xf6,0xd8,0xfd,0x75,0x81,0x3b,0x02,0x10,0x6e}
        },
        {
            16, 0x100, 0,
            {0xe7,0x09,0xf6,0x08,0xdf,0xfa,0x80,0x46,0xe7,0x09,0xf2,0x08,0xdf,0xfa,0x80,0x3e}
        },
        {
            16, 0x110, 0,
            {0x88,0x82,0x8c,0x83,0xe7,0x09,0xf0,0xa3,0xdf,0xfa,0x80,0x32,0xe3,0x09,0xf6,0x08}
        },
        {
            16, 0x120, 0,
            {0xdf,0xfa,0x80,0x78,0xe3,0x09,0xf2,0x08,0xdf,0xfa,0x80,0x70,0x88,0x82,0x8c,0x83}
        },
        {
            16, 0x130, 0,
            {0xe3,0x09,0xf0,0xa3,0xdf,0xfa,0x80,0x64,0x89,0x82,0x8a,0x83,0xe0,0xa3,0xf6,0x08}
        },
        {
            16, 0x140, 0,
            {0xdf,0xfa,0x80,0x58,0x89,0x82,0x8a,0x83,0xe0,0xa3,0xf2,0x08,0xdf,0xfa,0x80,0x4c}
        },
        {
            16, 0x150, 0,
            {0x80,0xd2,0x80,0xfa,0x80,0xc6,0x80,0xd4,0x80,0x69,0x80,0xf2,0x80,0x33,0x80,0x10}
        },
        {
            16, 0x160, 0,
            {0x80,0xa6,0x80,0xea,0x80,0x9a,0x80,0xa8,0x80,0xda,0x80,0xe2,0x80,0xca,0x80,0x33}
        },
        {
            16, 0x170, 0,
            {0x89,0x82,0x8a,0x83,0xec,0xfa,0xe4,0x93,0xa3,0xc8,0xc5,0x82,0xc8,0xcc,0xc5,0x83}
        },
        {
            16, 0x180, 0,
            {0xcc,0xf0,0xa3,0xc8,0xc5,0x82,0xc8,0xcc,0xc5,0x83,0xcc,0xdf,0xe9,0xde,0xe7,0x80}
        },
        {
            16, 0x190, 0,
            {0x0d,0x89,0x82,0x8a,0x83,0xe4,0x93,0xa3,0xf6,0x08,0xdf,0xf9,0xec,0xfa,0xa9,0xf0}
        },
        {
            16, 0x1a0, 0,
            {0xed,0xfb,0x22,0x89,0x82,0x8a,0x83,0xec,0xfa,0xe0,0xa3,0xc8,0xc5,0x82,0xc8,0xcc}
        },
        {
            16, 0x1b0, 0,
            {0xc5,0x83,0xcc,0xf0,0xa3,0xc8,0xc5,0x82,0xc8,0xcc,0xc5,0x83,0xcc,0xdf,0xea,0xde}
        },
        {
            16, 0x1c0, 0,
            {0xe8,0x80,0xdb,0x89,0x82,0x8a,0x83,0xe4,0x93,0xa3,0xf2,0x08,0xdf,0xf9,0x80,0xcc}
        },
        {
            16, 0x1d0, 0,
            {0x88,0xf0,0xef,0x60,0x01,0x0e,0x4e,0x60,0xc3,0x88,0xf0,0xed,0x24,0x02,0xb4,0x04}
        },
        {
            16, 0x1e0, 0,
            {0x00,0x50,0xb9,0xf5,0x82,0xeb,0x24,0x02,0xb4,0x04,0x00,0x50,0xaf,0x23,0x23,0x45}
        },
        {
            6, 0x1f0, 0,
            {0x82,0x23,0x90,0x01,0x50,0x73}
        },
        {
            16, 0x1f6, 0,
            {0xbb,0x01,0x06,0x89,0x82,0x8a,0x83,0xe0,0x22,0x50,0x02,0xe7,0x22,0xbb,0xfe,0x02}
        },
        {
            9, 0x206, 0,
            {0xe3,0x22,0x89,0x82,0x8a,0x83,0xe4,0x93,0x22}
        },
        {
            16, 0x20f, 0,
            {0xbb,0x01,0x0c,0xe5,0x82,0x29,0xf5,0x82,0xe5,0x83,0x3a,0xf5,0x83,0xe0,0x22,0x50}
        },
        {
            16, 0x21f, 0,
            {0x06,0xe9,0x25,0x82,0xf8,0xe6,0x22,0xbb,0xfe,0x06,0xe9,0x25,0x82,0xf8,0xe2,0x22}
        },
        {
            13, 0x22f, 0,
            {0xe5,0x82,0x29,0xf5,0x82,0xe5,0x83,0x3a,0xf5,0x83,0xe4,0x93,0x22}
        },
        {
            16, 0x23c, 0,
            {0xbb,0x01,0x06,0x89,0x82,0x8a,0x83,0xf0,0x22,0x50,0x02,0xf7,0x22,0xbb,0xfe,0x01}
        },
        {
            2, 0x24c, 0,
            {0xf3,0x22}
        },
        {
            16, 0x24e, 0,
            {0xf8,0xbb,0x01,0x0d,0xe5,0x82,0x29,0xf5,0x82,0xe5,0x83,0x3a,0xf5,0x83,0xe8,0xf0}
        },
        {
            16, 0x25e, 0,
            {0x22,0x50,0x06,0xe9,0x25,0x82,0xc8,0xf6,0x22,0xbb,0xfe,0x05,0xe9,0x25,0x82,0xc8}
        },
        {
            2, 0x26e, 0,
            {0xf2,0x22}
        },
        {
            13, 0x270, 0,
            {0xef,0x2b,0xff,0xee,0x3a,0xfe,0xed,0x39,0xfd,0xec,0x38,0xfc,0x22}
        },
        {
            16, 0x27d, 0,
            {0xe8,0x8f,0xf0,0xa4,0xcc,0x8b,0xf0,0xa4,0x2c,0xfc,0xe9,0x8e,0xf0,0xa4,0x2c,0xfc}
        },
        {
            16, 0x28d, 0,
            {0x8a,0xf0,0xed,0xa4,0x2c,0xfc,0xea,0x8e,0xf0,0xa4,0xcd,0xa8,0xf0,0x8b,0xf0,0xa4}
        },
        {
            16, 0x29d, 0,
            {0x2d,0xcc,0x38,0x25,0xf0,0xfd,0xe9,0x8f,0xf0,0xa4,0x2c,0xcd,0x35,0xf0,0xfc,0xeb}
        },
        {
            16, 0x2ad, 0,
            {0x8e,0xf0,0xa4,0xfe,0xa9,0xf0,0xeb,0x8f,0xf0,0xa4,0xcf,0xc5,0xf0,0x2e,0xcd,0x39}
        },
        {
            15, 0x2bd, 0,
            {0xfe,0xe4,0x3c,0xfc,0xea,0xa4,0x2d,0xce,0x35,0xf0,0xfd,0xe4,0x3c,0xfc,0x22}
        },
        {
            16, 0x2cc, 0,
            {0xeb,0x9f,0xf5,0xf0,0xea,0x9e,0x42,0xf0,0xe9,0x9d,0x42,0xf0,0xe8,0x9c,0x45,0xf0}
        },
        {
            1, 0x2dc, 0,
            {0x22}
        },
        {
            16, 0x2dd, 0,
            {0xe8,0x60,0x0f,0xec,0xc3,0x13,0xfc,0xed,0x13,0xfd,0xee,0x13,0xfe,0xef,0x13,0xff}
        },
        {
            3, 0x2ed, 0,
            {0xd8,0xf1,0x22}
        },
        {
            16, 0x2f0, 0,
            {0xe8,0x60,0x0f,0xef,0xc3,0x33,0xff,0xee,0x33,0xfe,0xed,0x33,0xfd,0xec,0x33,0xfc}
        },
        {
            3, 0x300, 0,
            {0xd8,0xf1,0x22}
        },
        {
            12, 0x303, 0,
            {0xe0,0xfc,0xa3,0xe0,0xfd,0xa3,0xe0,0xfe,0xa3,0xe0,0xff,0x22}
        },
        {
            12, 0x30f, 0,
            {0xec,0xf0,0xa3,0xed,0xf0,0xa3,0xee,0xf0,0xa3,0xef,0xf0,0x22}
        },
        {
            16, 0x31b, 0,
            {0xfa,0xe6,0xfb,0x08,0x08,0xe6,0xf9,0x25,0xf0,0xf6,0x18,0xe6,0xca,0x3a,0xf6,0x22}
        },
        {
            16, 0x32b, 0,
            {0xd0,0x83,0xd0,0x82,0xf8,0xe4,0x93,0x70,0x12,0x74,0x01,0x93,0x70,0x0d,0xa3,0xa3}
        },
        {
            16, 0x33b, 0,
            {0x93,0xf8,0x74,0x01,0x93,0xf5,0x82,0x88,0x83,0xe4,0x73,0x74,0x02,0x93,0x68,0x60}
        },
        {
            6, 0x34b, 0,
            {0xef,0xa3,0xa3,0xa3,0x80,0xdf}
        },
        {
            16, 0x14e2, 0,
            {0x8b,0x12,0x8a,0x13,0x89,0x14,0x8b,0x18,0x8a,0x19,0x89,0x1a,0xab,0x12,0x05,0x14}
        },
        {
            16, 0x14f2, 0,
            {0xe5,0x14,0xaa,0x13,0x70,0x02,0x05,0x13,0x14,0xf9,0x12,0x01,0xf6,0x70,0xed,0x74}
        },
        {
            16, 0x1502, 0,
            {0xff,0x25,0x14,0xf5,0x14,0x74,0xff,0x35,0x13,0xf5,0x13,0xab,0x15,0x05,0x17,0xe5}
        },
        {
            16, 0x1512, 0,
            {0x17,0xaa,0x16,0x70,0x02,0x05,0x16,0x14,0xf9,0x12,0x01,0xf6,0xff,0xab,0x12,0x05}
        },
        {
            16, 0x1522, 0,
            {0x14,0xe5,0x14,0xaa,0x13,0x70,0x02,0x05,0x13,0x14,0xf9,0xef,0x12,0x02,0x3c,0x70}
        },
        {
            8, 0x1532, 0,
            {0xda,0xab,0x18,0xaa,0x19,0xa9,0x1a,0x22}
        },
        {
            16, 0x351, 0,
            {0xe7,0x09,0xf6,0x08,0x70,0xfa,0x80,0x46,0xe7,0x09,0xf2,0x08,0x70,0xfa,0x80,0x3e}
        },
        {
            16, 0x361, 0,
            {0x88,0x82,0x8c,0x83,0xe7,0x09,0xf0,0xa3,0x70,0xfa,0x80,0x7e,0xe3,0x09,0xf6,0x08}
        },
        {
            16, 0x371, 0,
            {0x70,0xfa,0x80,0x76,0xe3,0x09,0xf2,0x08,0x70,0xfa,0x80,0x6e,0x88,0x82,0x8c,0x83}
        },
        {
            16, 0x381, 0,
            {0xe3,0x09,0xf0,0xa3,0x70,0xfa,0x80,0x62,0x89,0x82,0x8a,0x83,0xe0,0xa3,0xf6,0x08}
        },
        {
            16, 0x391, 0,
            {0x70,0xfa,0x80,0x56,0x89,0x82,0x8a,0x83,0xe0,0xa3,0xf2,0x08,0x70,0xfa,0x80,0x4a}
        },
        {
            16, 0x3a1, 0,
            {0x80,0xd2,0x80,0xfa,0x80,0xc6,0x80,0xd4,0x80,0x65,0x80,0xf2,0x80,0x31,0x80,0x10}
        },
        {
            16, 0x3b1, 0,
            {0x80,0xa6,0x80,0xea,0x80,0x9a,0x80,0xa8,0x80,0xda,0x80,0xe2,0x80,0xca,0x80,0x31}
        },
        {
            16, 0x3c1, 0,
            {0x89,0x82,0x8a,0x83,0xec,0xfa,0xe4,0x93,0xa3,0xc8,0xc5,0x82,0xc8,0xcc,0xc5,0x83}
        },
        {
            16, 0x3d1, 0,
            {0xcc,0xf0,0xa3,0xc8,0xc5,0x82,0xc8,0xcc,0xc5,0x83,0xcc,0x70,0xe9,0x80,0x0d,0x89}
        },
        {
            16, 0x3e1, 0,
            {0x82,0x8a,0x83,0xe4,0x93,0xa3,0xf6,0x08,0x70,0xf9,0xec,0xfa,0xa9,0xf0,0xed,0xfb}
        },
        {
            16, 0x3f1, 0,
            {0x22,0x89,0x82,0x8a,0x83,0xec,0xfa,0xe0,0xa3,0xc8,0xc5,0x82,0xc8,0xcc,0xc5,0x83}
        },
        {
            16, 0x401, 0,
            {0xcc,0xf0,0xa3,0xc8,0xc5,0x82,0xc8,0xcc,0xc5,0x83,0xcc,0x70,0xea,0x80,0xdd,0x89}
        },
        {
            16, 0x411, 0,
            {0x82,0x8a,0x83,0xe4,0x93,0xa3,0xf2,0x08,0x70,0xf9,0x80,0xce,0x88,0xf0,0xed,0x24}
        },
        {
            16, 0x421, 0,
            {0x02,0xb4,0x04,0x00,0x50,0xc4,0xf5,0x82,0xeb,0x24,0x02,0xb4,0x04,0x00,0x50,0xba}
        },
        {
            9, 0x431, 0,
            {0x23,0x23,0x45,0x82,0x23,0x90,0x03,0xa1,0x73}
        },
        {
            16, 0x1bf7, 0,
            {0xe4,0xff,0xfe,0x12,0x01,0xf6,0x60,0x0c,0x0f,0xef,0x70,0x01,0x0e,0x09,0xe9,0x70}
        },
        {
            5, 0x1c07, 0,
            {0xf2,0x0a,0x80,0xef,0x22}
        },
        {
            16, 0x1033, 0,
            {0x02,0x12,0x23,0xe4,0x93,0xa3,0xf8,0xe4,0x93,0xa3,0x40,0x03,0xf6,0x80,0x01,0xf2}
        },
        {
            16, 0x1043, 0,
            {0x08,0xdf,0xf4,0x80,0x29,0xe4,0x93,0xa3,0xf8,0x54,0x07,0x24,0x0c,0xc8,0xc3,0x33}
        },
        {
            16, 0x1053, 0,
            {0xc4,0x54,0x0f,0x44,0x20,0xc8,0x83,0x40,0x04,0xf4,0x56,0x80,0x01,0x46,0xf6,0xdf}
        },
        {
            16, 0x1063, 0,
            {0xe4,0x80,0x0b,0x01,0x02,0x04,0x08,0x10,0x20,0x40,0x80,0x90,0x1b,0x13,0xe4,0x7e}
        },
        {
            16, 0x1073, 0,
            {0x01,0x93,0x60,0xbc,0xa3,0xff,0x54,0x3f,0x30,0xe5,0x09,0x54,0x1f,0xfe,0xe4,0x93}
        },
        {
            16, 0x1083, 0,
            {0xa3,0x60,0x01,0x0e,0xcf,0x54,0xc0,0x25,0xe0,0x60,0xa8,0x40,0xb8,0xe4,0x93,0xa3}
        },
        {
            16, 0x1093, 0,
            {0xfa,0xe4,0x93,0xa3,0xf8,0xe4,0x93,0xa3,0xc8,0xc5,0x82,0xc8,0xca,0xc5,0x83,0xca}
        },
        {
            16, 0x10a3, 0,
            {0xf0,0xa3,0xc8,0xc5,0x82,0xc8,0xca,0xc5,0x83,0xca,0xdf,0xe9,0xde,0xe7,0x80,0xbe}
        },
        {
            1, 0x1b35, 0,
            {0x00}
        },
        {
            0, 0x0, 1,
            {0}
        }
    };
}


//////////////////////////// 
// CTOR 
AspenUsbIo::AspenUsbIo( const std::string & DeviceEnum ) :
                                        CamUsbIo( DeviceEnum, MAX_USB_BUFFER_SIZE, false ),
                                        m_fileName( __FILE__)
{
}

//////////////////////////// 
// DTOR 
AspenUsbIo::~AspenUsbIo() 
{ 

} 

//////////////////////////// 
// DOWNLOAD    FIRMWARE
void AspenUsbIo::DownloadFirmware()
{
    std::vector<UsbFrmwr::IntelHexRec> frmwr = 
        UsbFrmwr::MakeRecVect( firmware );

    PromFx2Io pf( m_Usb,
        ASPEN_EEPROM_MAX_BLOCKS,
        ASPEN_EEPROM_MAX_BANKS );
    
    pf.FirmwareDownload( frmwr );
}

//////////////////////////// 
// ERASE      ENTIRE    FLASH
void AspenUsbIo::EraseEntireFlash()
{
     m_Usb->UsbReqOutWithExtendedTimeout(VND_APOGEE_DFERASE,
        0, 0, 0, 0);
}


//////////////////////////// 
// ENABLE   FLASH PROGRAM    MODE
void AspenUsbIo::EnableFlashProgramMode()
{
    m_Usb->UsbReqOutWithExtendedTimeout(VND_APOGEE_PROGMODE,
        0, 1, 0, 0);
}

//////////////////////////// 
// DISABLE   FLASH  PROGRAM    MODE
void AspenUsbIo::DisableFlashProgramMode()
{
    m_Usb->UsbReqOutWithExtendedTimeout(VND_APOGEE_PROGMODE,
        0, 0, 0, 0);

	// wait to return until the fpga configuration is loaded
	apgHelper::ApogeeSleep( 5000 ); 
}

//////////////////////////// 
// WRITE     FLASH
void AspenUsbIo::WriteFlash(const uint32_t StartAddr,
            const std::vector<uint8_t> & data)
{

    //make sure we have a enough space
    const uint32_t StopAddr = StartAddr + apgHelper::SizeT2Uint32( data.size() );

    if( StopAddr > ASPEN_FLASH_SIZE )
    {
        apgHelper::throwRuntimeException(m_fileName, 
            "File exceeds flash memory size", __LINE__,
            Apg::ErrorType_InvalidOperation );
    }

    EnableFlashProgramMode();

    const uint32_t chunk = std::min( 
        static_cast<uint32_t>(data.size()), MAX_FLASH_XFER_SIZE  );
    
    const uint32_t remainder = data.size() % chunk;

    uint32_t Addr = StartAddr;

    std::vector<uint8_t>::const_iterator iter;

    for(iter = data.begin(); iter != data.end() - remainder; iter += chunk, Addr += chunk)
    {
        const uint16_t Index = static_cast<uint16_t>( (Addr >> 16) );
	    const uint16_t Value =static_cast<uint16_t>( (Addr & 0x0000FFFF) );

        m_Usb->UsbRequestOut(VND_APOGEE_DFRW, Index, Value,
            &(*iter), chunk);
    }
  
	 if( remainder )
     {
        const uint16_t Index = static_cast<uint16_t>( (Addr >> 16) );
        const uint16_t Value =static_cast<uint16_t>( (Addr & 0x0000FFFF) );

        iter = data.end() - remainder;
        m_Usb->UsbRequestOut(VND_APOGEE_DFRW, Index, Value,
            &(*iter), remainder);
     }

     DisableFlashProgramMode();
}

//////////////////////////// 
//READ     FLASH
void AspenUsbIo::ReadFlash(const uint32_t StartAddr,
            std::vector<uint8_t> & data)
{
    uint32_t NumBytesExpected = 
        apgHelper::SizeT2Uint32( data.size() );

    std::vector<uint8_t>::iterator iter = data.begin();
    uint32_t Addr = StartAddr;

    EnableFlashProgramMode();

    while( NumBytesExpected > 0 )
    {
        uint32_t SizeToRead = std::min<uint32_t>(NumBytesExpected,
            MAX_FLASH_XFER_SIZE );

        const uint16_t Index = static_cast<uint16_t>( (Addr >> 16) );
	    const uint16_t Value =static_cast<uint16_t>( (Addr & 0x0000FFFF) );

        m_Usb->UsbRequestIn(VND_APOGEE_DFRW, Index, Value,
            &(*iter), SizeToRead);

        iter += SizeToRead;
        Addr += SizeToRead;
        NumBytesExpected -= SizeToRead;
    }

    DisableFlashProgramMode();
}

//////////////////////////// 
//      PROGRAM
void AspenUsbIo::Program(const std::string & FilenameFpga,
            const std::string & FilenameFx2, const std::string & FilenameDescriptor,
            const std::string & FilenameWebPage, const std::string & FilenameWebServer,
            const std::string & FilenameWebCfg, bool Print2StdOut)
{

    //read what is currently in the string db, b/c the whole flash memory
    //will be erased
    std::vector<uint8_t> StrDb( CamStrDb::MAX_STR_DB_BYTES );

    ReadFlash( STR_DB_FLASH_ADDR, StrDb );

   //now program the camera including the string database
   Program(FilenameFpga, FilenameFx2, FilenameDescriptor,
       FilenameWebPage, FilenameWebServer, FilenameWebCfg, 
       StrDb, Print2StdOut);

}

//////////////////////////// 
//      PROGRAM
void AspenUsbIo::Program(const std::string & FilenameFpga,
            const std::string & FilenameFx2, const std::string & FilenameDescriptor,
            const std::string & FilenameWebPage, const std::string & FilenameWebServer,
            const std::string & FilenameWebCfg, const std::vector<uint8_t> & StrDb,
            bool Print2StdOut)
{

    m_Print2StdOut = Print2StdOut;
    // STEP 1
    // download usb firmware if we have to
    uint16_t Vid = 0; 
    uint16_t Pid = 0;
    uint16_t Did = 0;
    GetUsbVendorInfo(Vid, Pid, Did );
    if ( UsbFrmwr::CYPRESS_VID == Vid )
	{
        DownloadFirmware();
    }

    Progress2StdOut( 10 );

    //STEP 2
    // initialize prom header information
	Eeprom::Header hdr;
    memset(&hdr, 0, sizeof( hdr ) );
    hdr.Size = sizeof( hdr );
    hdr.Version = Eeprom::HEADER_VERSION;

    Progress2StdOut( 20 );

    //STEP 3
    //erase entire the flash device
    EraseEntireFlash();

    Progress2StdOut( 30 );

    //STEP 4
    //program fpga bits
     PromFx2Io pf( m_Usb,
        ASPEN_EEPROM_MAX_BLOCKS,
        ASPEN_EEPROM_MAX_BANKS );

    std::vector<uint8_t> fpgaData = pf.ReadFirmwareFile( FilenameFpga );
    WriteFlash( FPGA_BIN_FLASH_ADDR, fpgaData );

    Progress2StdOut( 40 );

    //STEP 5
    //program webserver
    std::vector<uint8_t> serverData = pf.ReadFirmwareFile( FilenameWebServer );
    WriteFlash( WEBSERVER_BIN_FLASH_ADDR, serverData );

    Progress2StdOut( 50 );

    //STEP 6
    //program web page
    std::vector<uint8_t> pageData = pf.ReadFirmwareFile( FilenameWebPage );
    WriteFlash( WEBPAGE_BIN_FLASH_ADDR, pageData );

    Progress2StdOut( 60 );

    //STEP 7
    //program net config
    std::vector<uint8_t> cfgData = pf.ReadFirmwareFile( FilenameWebCfg );
    WriteFlash( NETCONF_BIN_FLASH_ADDR, cfgData );

    //STEP 8
    //download the string db - b/c of the full erase of the flash
    //earlier
    WriteFlash( STR_DB_FLASH_ADDR, StrDb );

    Progress2StdOut( 70 );

    //xlinix firmware bits programmed set the "buf con" size and
    //valid bits.  for the gee the buf con prom header is overloaded
    //to mean all xlinix firmware, since buf and cam con are in one package
    //now
    hdr.BufConSize = apgHelper::SizeT2Uint32(fpgaData.size());
    hdr.Fields |= Eeprom::HEADER_BUFCON_VALID_BIT;

    //STEP 9
    //download the fx2
    uint32_t DownloadSize = 0;
    pf.WriteFile2Eeprom( FilenameFx2, FX2_PROM_BANK,
        FX2_PROM_BLOCK, FX2_PROM_ADDR, DownloadSize );

    hdr.Fields |= Eeprom::HEADER_BOOTROM_VALID_BIT;

    Progress2StdOut( 80 );

    //STEP 10
    //download usb descriptors
     pf.WriteFile2Eeprom( FilenameDescriptor, DSCR_PROM_BANK,
        DSCR_PROM_BLOCK, DSCR_PROM_ADDR, DownloadSize );

     hdr.Fields |= Eeprom::HEADER_DESCRIPTOR_VALID_BIT;

     Progress2StdOut( 90 );

    //STEP 11
    //write the header
    hdr.CheckSum = Eeprom::CalcHdrCheckSum( hdr );

    pf.WriteEepromHdr( hdr, HEADER_PROM_BANK,
        HEADER_PROM_BLOCK, HEADER_PROM_ADDR);

    Progress2StdOut( 100 );

     //turn this off on exit
    m_Print2StdOut = false;
}

//////////////////////////// 
//      READ      HEADER
void AspenUsbIo::ReadHeader( Eeprom::Header & hdr )
{
    PromFx2Io pf( m_Usb,
        ASPEN_EEPROM_MAX_BLOCKS,
        ASPEN_EEPROM_MAX_BANKS );

    pf.ReadEepromHdr( hdr, HEADER_PROM_BANK,
        HEADER_PROM_BLOCK, HEADER_PROM_ADDR );
}


//////////////////////////// 
//      SET     SERIAL       NUMBER
void AspenUsbIo::SetSerialNumber(const std::string & num)
{
    std::vector< std::string > result = ReadStrDatabase();
    CamInfo::StrDb db =  CamInfo::MkStrDbFromStrVect( result );
    db.CustomerSn = num;
    WriteStrDatabase(  CamInfo::MkStrVectFromStrDb( db ) );
}

//////////////////////////// 
//  GET     SERIAL       NUMBER
std::string AspenUsbIo::GetSerialNumber()
{
    std::vector< std::string > result = ReadStrDatabase();

    CamInfo::StrDb infoStruct =  CamInfo::MkStrDbFromStrVect( result );

    return infoStruct.CustomerSn;
}

//////////////////////////// 
//      WRITE        STR     DATABASE
void AspenUsbIo::WriteStrDatabase( const std::vector<std::string> & info )
{
    std::vector<uint8_t> buffer =  CamStrDb::PackStrings( info );
    
    EraseStrDb();

    // write the string DB to flash
    WriteFlash( STR_DB_FLASH_ADDR, buffer );
}

//////////////////////////// 
//      ERASE     STR      DB
void AspenUsbIo::EraseStrDb()
{
    EnableFlashProgramMode();

    //erase the flash section we are going to write to
    const uint16_t ADDR = 0x01F8;
    const uint16_t NUM_4K_BLOCKS = 2;
    
    m_Usb->UsbRequestOut(VND_APOGEE_DFERA,
        ADDR, 
        NUM_4K_BLOCKS, 
        0, 
        0);

    DisableFlashProgramMode();

}

//////////////////////////// 
//      ERASE     NET      DB
void AspenUsbIo::EraseNetDb()
{
    EnableFlashProgramMode();

    //erase the flash section we are going to write to
    const uint16_t ADDR = 0x01FD;
    const uint16_t NUM_4K_BLOCKS = 1;
    
    m_Usb->UsbRequestOut(VND_APOGEE_DFERA,
        ADDR, 
        NUM_4K_BLOCKS, 
        0, 
        0);

    DisableFlashProgramMode();

}

//////////////////////////// 
//      READ       STR     DATABASE
std::vector<std::string> AspenUsbIo::ReadStrDatabase()
{
   std::vector<uint8_t> buffer( CamStrDb::MAX_STR_DB_BYTES );

   ReadFlash( STR_DB_FLASH_ADDR, buffer );

   std::vector<std::string> out = CamStrDb::UnpackStrings( buffer );

   return out;
}

//////////////////////////// 
//      GET      FLASH  BUFFER
 std::vector<uint8_t>  AspenUsbIo::GetFlashBuffer( const uint32_t StartAddr, const uint32_t numBytes )
 {
    std::vector<uint8_t> buffer( numBytes );

    ReadFlash( StartAddr, buffer );

    return buffer;
 }

//////////////////////////// 
//      READ       NET     DATABASE
CamInfo::NetDb AspenUsbIo::ReadNetDatabase()
{
	CamInfo::NetDb out;

	std::vector<uint8_t> buffer( sizeof(out) );

	ReadFlash( NETCONF_BIN_FLASH_ADDR_USER, buffer );
	out = CamInfo::MkNetDbFromU8Vect( buffer );
	if ( out.Magic != CamInfo::NET_MAGIC_VALID ) 
	{
		ReadFlash( NETCONF_BIN_FLASH_ADDR_FACTORY, buffer );
		out = CamInfo::MkNetDbFromU8Vect( buffer );
	}

	return out;
}

//////////////////////////// 
//      WRITE       NET     DATABASE
void AspenUsbIo::WriteNetDatabase( const CamInfo::NetDb & input )
{
    std::vector<uint8_t> buffer =  CamInfo::MkU8VectFromNetDb( input );
    
    EraseNetDb();

    // write the Net DB to flash
    WriteFlash( NETCONF_BIN_FLASH_ADDR_USER, buffer );
}

