#if   !defined(__STRINGUTF8_HPP)
#define  __STRINGUTF8_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   



#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#include <string>

namespace corelinux
{
   DECLARE_CLASS(StringUtf8);

   /**
   StringUtf8 is a temporary string implementation. This implementation is
   provided to address a short term requirement stated in AbstractString.
   */

   class StringUtf8 : public AbstractString, public std::string
   {
   
   public:
   
      //
      // Constructors and destructors
      //

               // Default constructor

               StringUtf8( void );

               // Char * copy constructor

               StringUtf8( CharCptr );

               // std::string copy constructor

               StringUtf8( const std::string & );

               // Copy constructor

               StringUtf8( StringUtf8Cref );

               // Copy from base constructor, this
               // allows other Utf8 string implementations
               // to be copied to StringUtf8

               StringUtf8( AbstractStringCref ) 
                     throw (Exception);

               // Destructor

      virtual  ~StringUtf8( void );

      //
      // Accessors
      //

      virtual  Byte     getElementByteCount( void ) const ;

      virtual  bool     supportsStandardInterface( void ) const ;

      virtual  bool     isUtf8( void ) const ;

      virtual  bool     isUcs2( void ) const ;

      virtual  bool     isUcs4( void ) const ;

      //
      // Mutators
      //

      //
      // Factory methods and conversions
      //
               // Default (calls cloneUtf8)

      virtual  AbstractStringPtr clone( void ) const 
                        throw ( Exception );

               // Clone ones self to a Utf8 implementation

      virtual  AbstractStringPtr cloneUtf8( void ) const 
                        throw ( Exception );

               // Clone ones self to a Ucs2 implementation

      virtual  AbstractStringPtr cloneUcs2( void ) const 
                        throw ( Exception );

               // Clone ones self to a Ucs4 implementation

      virtual  AbstractStringPtr cloneUcs4( void ) const 
                        throw ( Exception );

   protected:
   
   private:
   
   };

}

#endif // #if !defined(__STRINGUTF8_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.1 $
   $Date: 2000/04/23 20:43:13 $
   $Locker:  $
*/

