-----------------------------------------------------------------------
--               GtkAda - Ada95 binding for Gtk+/Gnome               --
--                                                                   --
--   Copyright (C) 1998-2000 E. Briot, J. Brobecker and A. Charlet   --
--                Copyright (C) 2000-2002 ACT-Europe                 --
--                                                                   --
-- This library is free software; you can redistribute it and/or     --
-- modify it under the terms of the GNU General Public               --
-- License as published by the Free Software Foundation; either      --
-- version 2 of the License, or (at your option) any later version.  --
--                                                                   --
-- This library is distributed in the hope that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of    --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details.                          --
--                                                                   --
-- You should have received a copy of the GNU General Public         --
-- License along with this library; if not, write to the             --
-- Free Software Foundation, Inc., 59 Temple Place - Suite 330,      --
-- Boston, MA 02111-1307, USA.                                       --
--                                                                   --
-----------------------------------------------------------------------

--  <group>Glib, the general-purpose library</group>

package Glib.Enums is

   type Glib_Traverse_Flags is mod 2 ** 32;
   Traverse_Leafs     : constant Glib_Traverse_Flags := 2 ** 0;
   Traverse_Non_Leafs : constant Glib_Traverse_Flags := 2 ** 1;
   Traverse_All       : constant Glib_Traverse_Flags :=
     Traverse_Leafs or Traverse_Non_Leafs;
   Traverse_Flags     : constant Glib_Traverse_Flags := 16#03#;

   type Glib_Traverse_Type is (In_Order, Pre_Order, Post_Order, Level_Order);
   pragma Convention (C, Glib_Traverse_Type);

end Glib.Enums;
