# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::GB;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20231210185945;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8001111',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '845464',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              3873|
              5(?:
                242|
                39[4-6]
              )|
              (?:
                697|
                768
              )[347]|
              9467
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{4,5})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              [2-69][02-9]|
              [78]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [25]|
            7(?:
              0|
              6(?:
                [03-9]|
                2[356]
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[1389]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1(?:
                3(?:
                  [0-58]\\d\\d|
                  73[0235]
                )|
                4(?:
                  [0-5]\\d\\d|
                  69[7-9]|
                  70[0-79]
                )|
                (?:
                  (?:
                    5[0-26-9]|
                    [78][0-49]
                  )\\d|
                  6(?:
                    [0-4]\\d|
                    50
                  )
                )\\d
              )|
              (?:
                2(?:
                  (?:
                    0[024-9]|
                    2[3-9]|
                    3[3-79]|
                    4[1-689]|
                    [58][02-9]|
                    6[0-47-9]|
                    7[013-9]|
                    9\\d
                  )\\d|
                  1(?:
                    [0-7]\\d|
                    8[0-2]
                  )
                )|
                (?:
                  3(?:
                    0\\d|
                    1[0-8]|
                    [25][02-9]|
                    3[02-579]|
                    [468][0-46-9]|
                    7[1-35-79]|
                    9[2-578]
                  )|
                  4(?:
                    0[03-9]|
                    [137]\\d|
                    [28][02-57-9]|
                    4[02-69]|
                    5[0-8]|
                    [69][0-79]
                  )|
                  5(?:
                    0[1-35-9]|
                    [16]\\d|
                    2[024-9]|
                    3[015689]|
                    4[02-9]|
                    5[03-9]|
                    7[0-35-9]|
                    8[0-468]|
                    9[0-57-9]
                  )|
                  6(?:
                    0[034689]|
                    1\\d|
                    2[0-35689]|
                    [38][013-9]|
                    4[1-467]|
                    5[0-69]|
                    6[13-9]|
                    7[0-8]|
                    9[0-24578]
                  )|
                  7(?:
                    0[0246-9]|
                    2\\d|
                    3[0236-8]|
                    4[03-9]|
                    5[0-46-9]|
                    6[013-9]|
                    7[0-35-9]|
                    8[024-9]|
                    9[02-9]
                  )|
                  8(?:
                    0[35-9]|
                    2[1-57-9]|
                    3[02-578]|
                    4[0-578]|
                    5[124-9]|
                    6[2-69]|
                    7\\d|
                    8[02-9]|
                    9[02569]
                  )|
                  9(?:
                    0[02-589]|
                    [18]\\d|
                    2[02-689]|
                    3[1-57-9]|
                    4[2-9]|
                    5[0-579]|
                    6[2-47-9]|
                    7[0-24578]|
                    9[2-57]
                  )
                )\\d
              )\\d
            )|
            2(?:
              0[013478]|
              3[0189]|
              4[017]|
              8[0-46-9]|
              9[0-2]
            )\\d{3}
          )\\d{4}|
          1(?:
            2(?:
              0(?:
                46[1-4]|
                87[2-9]
              )|
              545[1-79]|
              76(?:
                2\\d|
                3[1-8]|
                6[1-6]
              )|
              9(?:
                7(?:
                  2[0-4]|
                  3[2-5]
                )|
                8(?:
                  2[2-8]|
                  7[0-47-9]|
                  8[3-5]
                )
              )
            )|
            3(?:
              6(?:
                38[2-5]|
                47[23]
              )|
              8(?:
                47[04-9]|
                64[0157-9]
              )
            )|
            4(?:
              044[1-7]|
              20(?:
                2[23]|
                8\\d
              )|
              6(?:
                0(?:
                  30|
                  5[2-57]|
                  6[1-8]|
                  7[2-8]
                )|
                140
              )|
              8(?:
                052|
                87[1-3]
              )
            )|
            5(?:
              2(?:
                4(?:
                  3[2-79]|
                  6\\d
                )|
                76\\d
              )|
              6(?:
                26[06-9]|
                686
              )
            )|
            6(?:
              06(?:
                4\\d|
                7[4-79]
              )|
              295[5-7]|
              35[34]\\d|
              47(?:
                24|
                61
              )|
              59(?:
                5[08]|
                6[67]|
                74
              )|
              9(?:
                55[0-4]|
                77[23]
              )
            )|
            7(?:
              26(?:
                6[13-9]|
                7[0-7]
              )|
              (?:
                442|
                688
              )\\d|
              50(?:
                2[0-3]|
                [3-68]2|
                76
              )
            )|
            8(?:
              27[56]\\d|
              37(?:
                5[2-5]|
                8[239]
              )|
              843[2-58]
            )|
            9(?:
              0(?:
                0(?:
                  6[1-8]|
                  85
                )|
                52\\d
              )|
              3583|
              4(?:
                66[1-8]|
                9(?:
                  2[01]|
                  81
                )
              )|
              63(?:
                23|
                3[1-4]
              )|
              9561
            )
          )\\d{3}
        ',
                'geographic' => '
          (?:
            1(?:
              1(?:
                3(?:
                  [0-58]\\d\\d|
                  73[0235]
                )|
                4(?:
                  [0-5]\\d\\d|
                  69[7-9]|
                  70[0-79]
                )|
                (?:
                  (?:
                    5[0-26-9]|
                    [78][0-49]
                  )\\d|
                  6(?:
                    [0-4]\\d|
                    50
                  )
                )\\d
              )|
              (?:
                2(?:
                  (?:
                    0[024-9]|
                    2[3-9]|
                    3[3-79]|
                    4[1-689]|
                    [58][02-9]|
                    6[0-47-9]|
                    7[013-9]|
                    9\\d
                  )\\d|
                  1(?:
                    [0-7]\\d|
                    8[0-2]
                  )
                )|
                (?:
                  3(?:
                    0\\d|
                    1[0-8]|
                    [25][02-9]|
                    3[02-579]|
                    [468][0-46-9]|
                    7[1-35-79]|
                    9[2-578]
                  )|
                  4(?:
                    0[03-9]|
                    [137]\\d|
                    [28][02-57-9]|
                    4[02-69]|
                    5[0-8]|
                    [69][0-79]
                  )|
                  5(?:
                    0[1-35-9]|
                    [16]\\d|
                    2[024-9]|
                    3[015689]|
                    4[02-9]|
                    5[03-9]|
                    7[0-35-9]|
                    8[0-468]|
                    9[0-57-9]
                  )|
                  6(?:
                    0[034689]|
                    1\\d|
                    2[0-35689]|
                    [38][013-9]|
                    4[1-467]|
                    5[0-69]|
                    6[13-9]|
                    7[0-8]|
                    9[0-24578]
                  )|
                  7(?:
                    0[0246-9]|
                    2\\d|
                    3[0236-8]|
                    4[03-9]|
                    5[0-46-9]|
                    6[013-9]|
                    7[0-35-9]|
                    8[024-9]|
                    9[02-9]
                  )|
                  8(?:
                    0[35-9]|
                    2[1-57-9]|
                    3[02-578]|
                    4[0-578]|
                    5[124-9]|
                    6[2-69]|
                    7\\d|
                    8[02-9]|
                    9[02569]
                  )|
                  9(?:
                    0[02-589]|
                    [18]\\d|
                    2[02-689]|
                    3[1-57-9]|
                    4[2-9]|
                    5[0-579]|
                    6[2-47-9]|
                    7[0-24578]|
                    9[2-57]
                  )
                )\\d
              )\\d
            )|
            2(?:
              0[013478]|
              3[0189]|
              4[017]|
              8[0-46-9]|
              9[0-2]
            )\\d{3}
          )\\d{4}|
          1(?:
            2(?:
              0(?:
                46[1-4]|
                87[2-9]
              )|
              545[1-79]|
              76(?:
                2\\d|
                3[1-8]|
                6[1-6]
              )|
              9(?:
                7(?:
                  2[0-4]|
                  3[2-5]
                )|
                8(?:
                  2[2-8]|
                  7[0-47-9]|
                  8[3-5]
                )
              )
            )|
            3(?:
              6(?:
                38[2-5]|
                47[23]
              )|
              8(?:
                47[04-9]|
                64[0157-9]
              )
            )|
            4(?:
              044[1-7]|
              20(?:
                2[23]|
                8\\d
              )|
              6(?:
                0(?:
                  30|
                  5[2-57]|
                  6[1-8]|
                  7[2-8]
                )|
                140
              )|
              8(?:
                052|
                87[1-3]
              )
            )|
            5(?:
              2(?:
                4(?:
                  3[2-79]|
                  6\\d
                )|
                76\\d
              )|
              6(?:
                26[06-9]|
                686
              )
            )|
            6(?:
              06(?:
                4\\d|
                7[4-79]
              )|
              295[5-7]|
              35[34]\\d|
              47(?:
                24|
                61
              )|
              59(?:
                5[08]|
                6[67]|
                74
              )|
              9(?:
                55[0-4]|
                77[23]
              )
            )|
            7(?:
              26(?:
                6[13-9]|
                7[0-7]
              )|
              (?:
                442|
                688
              )\\d|
              50(?:
                2[0-3]|
                [3-68]2|
                76
              )
            )|
            8(?:
              27[56]\\d|
              37(?:
                5[2-5]|
                8[239]
              )|
              843[2-58]
            )|
            9(?:
              0(?:
                0(?:
                  6[1-8]|
                  85
                )|
                52\\d
              )|
              3583|
              4(?:
                66[1-8]|
                9(?:
                  2[01]|
                  81
                )
              )|
              63(?:
                23|
                3[1-4]
              )|
              9561
            )
          )\\d{3}
        ',
                'mobile' => '
          7(?:
            457[0-57-9]|
            700[01]|
            911[028]
          )\\d{5}|
          7(?:
            [1-3]\\d\\d|
            4(?:
              [0-46-9]\\d|
              5[0-689]
            )|
            5(?:
              0[0-8]|
              [13-9]\\d|
              2[0-35-9]
            )|
            7(?:
              0[1-9]|
              [1-7]\\d|
              8[02-9]|
              9[0-689]
            )|
            8(?:
              [014-9]\\d|
              [23][0-8]
            )|
            9(?:
              [024-9]\\d|
              1[02-9]|
              3[0-689]
            )
          )\\d{6}
        ',
                'pager' => '
          76(?:
            464|
            652
          )\\d{5}|
          76(?:
            0[0-28]|
            2[356]|
            34|
            4[01347]|
            5[49]|
            6[0-369]|
            77|
            8[14]|
            9[139]
          )\\d{6}
        ',
                'personal_number' => '70\\d{8}',
                'specialrate' => '(
          (?:
            8(?:
              4[2-5]|
              7[0-3]
            )|
            9(?:
              [01]\\d|
              8[2-49]
            )
          )\\d{7}|
          845464\\d
        )|(
          (?:
            3[0347]|
            55
          )\\d{8}
        )',
                'toll_free' => '
          80[08]\\d{7}|
          800\\d{6}|
          8001111
        ',
                'voip' => '56\\d{8}'
              };
my %areanames = ();
$areanames{en} = {"442829", "Kilrea",
"441463", "Inverness",
"441571", "Lochinver",
"441283", "Burton\-on\-Trent",
"441722", "Salisbury",
"442840", "Banbridge",
"441798", "Pulborough",
"441606", "Northwich",
"441235", "Abingdon",
"441435", "Heathfield",
"441872", "Truro",
"442893", "Ballyclare",
"4413397", "Ballater",
"441350", "Dunkeld",
"4416973", "Wigton",
"441579", "Liskeard",
"441394", "Felixstowe",
"441263", "Cromer",
"441483", "Guildford",
"4415075", "Spilsby\ \(Horncastle\)",
"441673", "Market\ Rasen",
"442821", "Martinstown",
"4415396", "Sedbergh",
"441445", "Gairloch",
"441476", "Grantham",
"441870", "Isle\ of\ Benbecula",
"44114704", "Sheffield",
"441352", "Mold",
"441397", "Fort\ William",
"441403", "Horsham",
"441720", "Isles\ of\ Scilly",
"442842", "Kircubbin",
"441986", "Bungay",
"442830", "Newry",
"4418473", "Thurso",
"441666", "Malmesbury",
"441749", "Shepton\ Mallet",
"441276", "Camberley",
"441245", "Chelmsford",
"441209", "Redruth",
"441754", "Skegness",
"441790", "Spilsby",
"441586", "Campbeltown",
"441346", "Fraserburgh",
"4413390", "Aboyne\/Ballater",
"442848", "Northern\ Ireland",
"441375", "Grays\ Thurrock",
"441864", "Abington\ \(Crawford\)",
"441807", "Ballindalloch",
"441884", "Tiverton",
"441358", "Ellon",
"441327", "Daventry",
"441566", "Launceston",
"441743", "Shrewsbury",
"441409", "Holsworthy",
"441506", "Bathgate",
"442891", "Bangor\ \(Co\.\ Down\)",
"441887", "Aberfeldy",
"441878", "Lochboisdale",
"4419753", "Strathdon",
"441324", "Falkirk",
"441733", "Peterborough",
"4416862", "Llanidloes",
"4418513", "Stornoway",
"442823", "Northern\ Ireland",
"441671", "Newton\ Stewart",
"441785", "Stafford",
"441481", "Guernsey",
"441261", "Banff",
"441289", "Berwick\-upon\-Tweed",
"4419645", "Hornsea",
"441469", "Killingholme",
"441489", "Bishops\ Waltham",
"441269", "Ammanford",
"441728", "Saxmundham",
"441757", "Selby",
"441573", "Kelso",
"441461", "Gretna",
"441765", "Ripon",
"441971", "Scourie",
"44238", "Southampton",
"441855", "Ballachulish",
"441792", "Swansea",
"442838", "Portadown",
"442899", "Northern\ Ireland",
"441863", "Ardgay",
"441695", "Skelmersdale",
"4414231", "Harrogate\/Boroughbridge",
"441600", "Monmouth",
"441577", "Kinross",
"441753", "Slough",
"441588", "Bishops\ Castle",
"4414373", "Clynderwen\ \(Clunderwen\)",
"441348", "Fishguard",
"4416864", "Llanidloes",
"441982", "Builth\ Wells",
"442846", "Northern\ Ireland",
"441356", "Brechin",
"442827", "Ballymoney",
"441962", "Winchester",
"4413395", "Aboyne",
"441472", "Grimsby",
"441568", "Leominster",
"441900", "Workington",
"441525", "Leighton\ Buzzard",
"441835", "St\ Boswells",
"441995", "Garstang",
"4415077", "Louth",
"441744", "St\ Helens",
"441883", "Caterham",
"4414306", "Market\ Weighton",
"4416868", "Newtown",
"441737", "Redhill",
"441508", "Brooke",
"441680", "Isle\ of\ Mull\ \-\ Craignure",
"441470", "Isle\ of\ Skye\ \-\ Edinbane",
"441902", "Wolverhampton",
"441876", "Lochmaddy",
"442824", "Northern\ Ireland",
"441845", "Thirsk",
"441323", "Eastbourne",
"441747", "Shaftesbury",
"4419640", "Hornsea\/Patrington",
"441726", "St\ Austell",
"441803", "Torquay",
"4414343", "Haltwhistle",
"4412296", "Barrow\-in\-Furness",
"441270", "Crewe",
"441980", "Amesbury",
"441329", "Fareham",
"4415070", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441464", "Insch",
"441407", "Holyhead",
"441284", "Bury\ St\ Edmunds",
"441340", "Craigellachie\ \(Aberlour\)",
"441332", "Derby",
"441796", "Pitlochry",
"441580", "Cranbrook",
"441974", "Llanon",
"4414236", "Harrogate",
"441608", "Chipping\ Norton",
"441674", "Montrose",
"441560", "Moscow",
"441908", "Milton\ Keynes",
"4416869", "Newtown",
"441502", "Lowestoft",
"4414301", "North\ Cave\/Market\ Weighton",
"441207", "Consett",
"441264", "Andover",
"441484", "Huddersfield",
"442894", "Antrim",
"441809", "Tomdoun",
"4418903", "Coldstream",
"441759", "Pocklington",
"441255", "Clacton\-on\-Sea",
"441562", "Kidderminster",
"441478", "Isle\ of\ Skye\ \-\ Portree",
"441487", "Warboys",
"441204", "Bolton",
"441267", "Carmarthen",
"441688", "Isle\ of\ Mull\ \-\ Tobermory",
"441677", "Bedale",
"441925", "Warrington",
"44291", "Cardiff",
"441968", "Penicuik",
"441869", "Bicester",
"44118", "Reading",
"441595", "Lerwick\,\ Foula\ \&\ Fair\ Isle",
"4419647", "Patrington",
"442897", "Saintfield",
"4412291", "Barrow\-in\-Furness\/Millom",
"441145", "Sheffield",
"44116", "Leicester",
"441889", "Rugeley",
"441988", "Wigtown",
"441977", "Pontefract",
"441625", "Macclesfield",
"441342", "East\ Grinstead",
"441668", "Bamburgh",
"441330", "Banchory",
"441287", "Guisborough",
"441751", "Pickering",
"441467", "Inverurie",
"441404", "Honiton",
"441582", "Luton",
"441278", "Bridgwater",
"441455", "Hinckley",
"441932", "Weybridge",
"441857", "Sanday",
"441865", "Oxford",
"441141", "Sheffield",
"441538", "Ipstones",
"441599", "Kyle",
"441828", "Coupar\ Angus",
"441929", "Wareham",
"441621", "Maldon",
"441892", "Tunbridge\ Wells",
"441451", "Stow\-on\-the\-Wold",
"441767", "Sandy",
"441704", "Southport",
"441259", "Alloa",
"4414307", "Market\ Weighton",
"441833", "Barnard\ Castle",
"441787", "Sudbury",
"441778", "Bourne",
"441629", "Matlock",
"4415076", "Louth",
"4414342", "Bellingham",
"441885", "Pencombe",
"4414230", "Harrogate\/Boroughbridge",
"441308", "Bridport",
"441591", "Llanwrtyd\ Wells",
"441993", "Witney",
"441843", "Thanet",
"441296", "Aylesbury",
"4414372", "Clynderwen\ \(Clunderwen\)",
"4418514", "Great\ Bernera",
"441784", "Staines",
"4415395", "Grange\-over\-Sands",
"4418479", "Tongue",
"441556", "Castle\ Douglas",
"4419641", "Hornsea\/Patrington",
"442866", "Enniskillen",
"441325", "Darlington",
"4419754", "Alford\ \(Aberdeen\)",
"44114703", "Sheffield",
"441642", "Middlesbrough",
"44287", "Northern\ Ireland",
"441630", "Market\ Drayton",
"441368", "Dunbar",
"441388", "Bishop\ Auckland",
"4418518", "Stornoway",
"441854", "Ullapool",
"441805", "Torrington",
"441377", "Driffield",
"441942", "Wigan",
"442886", "Cookstown",
"4412297", "Millom",
"4417687", "Keswick",
"441548", "Kingsbridge",
"441707", "Welwyn\ Garden\ City",
"441764", "Crieff",
"4419758", "Strathdon",
"441496", "Port\ Ellen",
"4414237", "Harrogate",
"441530", "Coalville",
"441542", "Keith",
"441948", "Whitchurch",
"441656", "Bridgend",
"441234", "Bedford",
"441382", "Dundee",
"4414300", "North\ Cave\/Market\ Weighton",
"441395", "Budleigh\ Salterton",
"4416974", "Raughton\ Head",
"441770", "Isle\ of\ Arran",
"441841", "Newquay\ \(Padstow\)",
"441362", "Dereham",
"441300", "Cerne\ Abbas",
"4415071", "Louth\/Alford\ \(Lincs\)\/Spilsby\ \(Horncastle\)",
"441226", "Barnsley",
"442879", "Magherafelt",
"4418478", "Thurso",
"441923", "Watford",
"441253", "Blackpool",
"441772", "Preston",
"44113", "Leeds",
"4419646", "Patrington",
"44141", "Glasgow",
"441638", "Newmarket",
"441360", "Killearn",
"441444", "Haywards\ Heath",
"441593", "Lybster",
"441302", "Doncaster",
"4412290", "Barrow\-in\-Furness\/Millom",
"441916", "Tyneside",
"441143", "Sheffield",
"4418902", "Coldstream",
"441237", "Bideford",
"4418474", "Thurso",
"441540", "Kingussie",
"441822", "Tavistock",
"441691", "Oswestry",
"441244", "Chester",
"441938", "Welshpool",
"441380", "Devizes",
"4419759", "Alford\ \(Aberdeen\)",
"44121", "Birmingham",
"441529", "Sleaford",
"4418519", "Great\ Bernera",
"441453", "Dursley",
"4413882", "Stanhope\ \(Eastgate\)",
"442871", "Londonderry",
"442311", "Southampton",
"441623", "Mansfield",
"441428", "Haslemere",
"441789", "Stratford\-upon\-Avon",
"441465", "Girvan",
"441285", "Cirencester",
"441457", "Glossop",
"441761", "Temple\ Cloud",
"442882", "Omagh",
"441946", "Whitehaven",
"4418908", "Coldstream",
"44115", "Nottingham",
"441233", "Ashford\ \(Kent\)",
"441492", "Colwyn\ Bay",
"4415242", "Hornby",
"442895", "Belfast",
"4418472", "Thurso",
"4414305", "North\ Cave",
"441292", "Ayr",
"4418904", "Coldstream",
"441597", "Llandrindod\ Wells",
"441433", "Hathersage",
"441859", "Harris",
"441646", "Milford\ Haven",
"4413396", "Ballater",
"441675", "Coleshill",
"441257", "Coppull",
"441485", "Hunstanton",
"441769", "South\ Molton",
"4414379", "Haverfordwest",
"441228", "Carlisle",
"441594", "Lydney",
"441379", "Diss",
"441290", "Cumnock",
"441443", "Pontypridd",
"44247", "Coventry",
"441254", "Blackburn",
"441636", "Newark\-on\-Trent",
"441205", "Boston",
"441709", "Rotherham",
"4414349", "Bellingham",
"441550", "Llandovery",
"441918", "Tyneside",
"441924", "Wakefield",
"4412295", "Barrow\-in\-Furness",
"441624", "Isle\ of\ Man",
"442880", "Carrickmore",
"441405", "Goole",
"441454", "Chipping\ Sodbury",
"441243", "Chichester",
"441896", "Galashiels",
"441490", "Corwen",
"441144", "Sheffield",
"441371", "Great\ Dunmow",
"441650", "Cemmaes\ Road",
"4414235", "Harrogate",
"4418512", "Stornoway",
"4416863", "Llanidloes",
"441420", "Alton",
"441536", "Kettering",
"4414374", "Clynderwen\ \(Clunderwen\)",
"441373", "Frome",
"4419752", "Alford\ \(Aberdeen\)",
"441449", "Stowmarket",
"4418909", "Ayton",
"441241", "Arbroath",
"441694", "Church\ Stretton",
"4413391", "Aboyne\/Ballater",
"441745", "Rhyl",
"441994", "St\ Clears",
"441249", "Chippenham",
"441776", "Stranraer",
"4414378", "Haverfordwest",
"4420", "London",
"441912", "Tyneside",
"441306", "Dorking",
"441524", "Lancaster",
"441834", "Narberth",
"441950", "Sandwick",
"441431", "Helmsdale",
"4414348", "Hexham",
"441298", "Buxton",
"441239", "Cardigan",
"441997", "Strathpeffer",
"441527", "Redditch",
"441910", "Tyneside\/Durham\/Sunderland",
"441837", "Okehampton",
"441558", "Llandeilo",
"441844", "Thame",
"442868", "Kesh",
"441952", "Telford",
"442825", "Ballymena",
"441366", "Downham\ Market",
"441386", "Evesham",
"441652", "Brigg",
"442888", "Northern\ Ireland",
"442877", "Limavady",
"4414344", "Bellingham",
"441575", "Kirriemuir",
"441763", "Royston",
"441422", "Halifax",
"441546", "Lochgilphead",
"441697", "Brampton",
"441439", "Helmsley",
"441224", "Aberdeen",
"441917", "Sunderland",
"441830", "Kirkwhelpington",
"441842", "Thetford",
"441520", "Lochcarron",
"441436", "Helensburgh",
"441905", "Worcester",
"441954", "Madingley",
"441389", "Dumbarton",
"441361", "Duns",
"441643", "Minehead",
"4412294", "Barrow\-in\-Furness",
"4417684", "Pooley\ Bridge",
"441549", "Lairg",
"4418470", "Thurso\/Tongue",
"4419757", "Strathdon",
"441381", "Fortrose",
"441943", "Guiseley",
"441690", "Betws\-y\-Coed",
"4419467", "Gosforth",
"441369", "Dunoon",
"4418517", "Stornoway",
"441236", "Coatbridge",
"441654", "Machynlleth",
"442310", "Portsmouth",
"4412298", "Barrow\-in\-Furness",
"442870", "Coleraine",
"441424", "Hastings",
"441821", "Kinrossie",
"4414239", "Boroughbridge",
"441309", "Forres",
"441531", "Ledbury",
"441933", "Wellingborough",
"441692", "North\ Walsham",
"4413885", "Stanhope\ \(Eastgate\)",
"441275", "Clevedon",
"441458", "Glastonbury",
"4414304", "North\ Cave",
"4418905", "Ayton",
"441246", "Chesterfield",
"441427", "Gainsborough",
"441779", "Peterhead",
"441628", "Maidenhead",
"441985", "Warminster",
"441665", "Alnwick",
"441928", "Runcorn",
"441914", "Tyneside",
"441685", "Merthyr\ Tydfil",
"441957", "Mid\ Yell",
"441832", "Clopton",
"441446", "Barry",
"441227", "Canterbury",
"441522", "Lincoln",
"441840", "Camelford",
"441771", "Maud",
"441475", "Greenock",
"441258", "Blandford",
"4414308", "Market\ Weighton",
"4416866", "Newtown",
"441633", "Newport",
"441992", "Lea\ Valley",
"441301", "Arrochar",
"441598", "Lynton",
"441539", "Kendal",
"441829", "Tarporley",
"441773", "Ripley",
"441557", "Kirkcudbright",
"441565", "Knutsford",
"441252", "Aldershot",
"441899", "Biggar",
"441838", "Dalmally",
"441528", "Laggan",
"4418510", "Great\ Bernera\/Stornoway",
"442867", "Lisnaskea",
"441922", "Walsall",
"441592", "Kirkcaldy",
"441303", "Folkestone",
"441297", "Axminster",
"4418477", "Tongue",
"441631", "Oban",
"4414345", "Haltwhistle",
"441939", "Wem",
"4419750", "Alford\ \(Aberdeen\)\/Strathdon",
"441931", "Shap",
"441639", "Neath",
"441698", "Motherwell",
"441706", "Rochdale",
"441823", "Taunton",
"441142", "Sheffield",
"441497", "Hay\-on\-Wye",
"4412299", "Millom",
"442887", "Dungannon",
"441376", "Braintree",
"441622", "Maidstone",
"441452", "Gloucester",
"441494", "High\ Wycombe",
"441383", "Dunfermline",
"441543", "Cannock",
"441140", "Sheffield",
"441766", "Porthmadog",
"4413393", "Aboyne",
"441335", "Ashbourne",
"4414238", "Harrogate",
"441620", "North\ Berwick",
"44114700", "Sheffield",
"442884", "Northern\ Ireland",
"441450", "Hawick",
"441856", "Orkney",
"4416861", "Newtown\/Llanidloes",
"441250", "Blairgowrie",
"4414309", "Market\ Weighton",
"441848", "Thornhill",
"441554", "Llanelli",
"441505", "Johnstone",
"441920", "Ware",
"441590", "Lymington",
"441786", "Stirling",
"4414375", "Clynderwen\ \(Clunderwen\)",
"4414234", "Boroughbridge",
"441363", "Crediton",
"441949", "Whatton",
"441294", "Ardrossan",
"441641", "Strathy",
"441442", "Hemel\ Hempstead",
"441526", "Martin",
"441367", "Faringdon",
"441304", "Dover",
"441355", "East\ Kilbride",
"441911", "Tyneside\/Durham\/Sunderland",
"4419755", "Alford\ \(Aberdeen\)",
"441708", "Romford",
"4414340", "Bellingham\/Haltwhistle\/Hexham",
"4415394", "Hawkshead",
"441919", "Durham",
"441824", "Ruthin",
"441534", "Jersey",
"44286", "Northern\ Ireland",
"4419643", "Patrington",
"442845", "Northern\ Ireland",
"441387", "Dumfries",
"441547", "Knighton",
"4418515", "Stornoway",
"441242", "Cheltenham",
"4414232", "Harrogate",
"44114705", "Sheffield",
"441959", "Westerham",
"442883", "Northern\ Ireland",
"441651", "Oldmeldrum",
"441725", "Rockbourne",
"441768", "Penrith",
"4414370", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441544", "Kington",
"44151", "Liverpool",
"441827", "Tamworth",
"441493", "Great\ Yarmouth",
"44280", "Northern\ Ireland",
"4418907", "Ayton",
"441858", "Market\ Harborough",
"441384", "Dudley",
"441364", "Ashburton",
"441307", "Forfar",
"441875", "Tranent",
"441293", "Crawley",
"441440", "Haverhill",
"441432", "Hereford",
"441553", "Kings\ Lynn",
"441777", "Retford",
"441429", "Hartlepool",
"441788", "Rugby",
"441659", "Sanquhar",
"441951", "Colonsay",
"441637", "Newquay",
"44161", "Manchester",
"441438", "Stevenage",
"441499", "Inveraray",
"441291", "Chepstow",
"441644", "New\ Galloway",
"4414347", "Hexham",
"442889", "Fivemiletown",
"441953", "Wymondham",
"441223", "Cambridge",
"4418475", "Thurso",
"44239", "Portsmouth",
"4414302", "North\ Cave",
"441782", "Stoke\-on\-Trent",
"44114707", "Sheffield",
"441559", "Llandysul",
"441700", "Rothesay",
"441653", "Malton",
"442881", "Newtownstewart",
"441491", "Henley\-on\-Thames",
"441852", "Kilmelford",
"441795", "Sittingbourne",
"441299", "Bewdley",
"441944", "West\ Heslerton",
"441937", "Wetherby",
"441760", "Swaffham",
"441146", "Sheffield",
"441702", "Southend\-on\-Sea",
"441456", "Glenurquhart",
"4415073", "Louth",
"441934", "Weston\-super\-Mare",
"4412292", "Barrow\-in\-Furness",
"441248", "Bangor\ \(Gwynedd\)",
"441372", "Esher",
"441626", "Newton\ Abbot",
"441947", "Whitby",
"441926", "Warwick",
"441647", "Moretonhampstead",
"4418900", "Coldstream\/Ayton",
"441634", "Medway",
"441256", "Basingstoke",
"4413880", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441913", "Durham",
"4414377", "Haverfordwest",
"441780", "Stamford",
"442890", "Belfast",
"441353", "Ely",
"441748", "Richmond",
"441670", "Morpeth",
"44283", "Northern\ Ireland",
"441202", "Bournemouth",
"441564", "Lapworth",
"441480", "Huntingdon",
"441260", "Congleton",
"4414341", "Bellingham\/Haltwhistle\/Hexham",
"441886", "Bromyard\ \(Knightwick\/Leigh\ Sinton\)",
"441866", "Kilchrenan",
"44131", "Edinburgh",
"441280", "Buckingham",
"441460", "Chard",
"441344", "Bracknell",
"441584", "Ludlow",
"441970", "Aberystwyth",
"441337", "Ladybank",
"44114702", "Sheffield",
"441756", "Skipton",
"442843", "Newcastle\ \(Co\.\ Down\)",
"441578", "Lauder",
"441462", "Hitchin",
"441282", "Burnley",
"4418906", "Ayton",
"441723", "Scarborough",
"441334", "St\ Andrews",
"441972", "Glenborrodale",
"441806", "Shetland",
"441400", "Honington",
"441347", "Easingwold",
"442885", "Ballygawley",
"441495", "Pontypool",
"4413394", "Ballater",
"4414233", "Boroughbridge",
"442892", "Lisburn",
"4416865", "Newtown",
"441738", "Perth",
"4419642", "Hornsea",
"441799", "Saffron\ Walden",
"441873", "Abergavenny",
"441295", "Banbury",
"441672", "Marlborough",
"441326", "Falmouth",
"441200", "Clitheroe",
"442828", "Larne",
"4414371", "Haverfordwest\/Clynderwen\ \(Clunderwen\)",
"441262", "Bridlington",
"441555", "Lanark",
"441482", "Kingston\-upon\-Hull",
"441567", "Killin",
"4413398", "Aboyne",
"441871", "Castlebay",
"44117", "Bristol",
"441732", "Sevenoaks",
"441740", "Sedgefield",
"4414346", "Hexham",
"4417683", "Appleby",
"44114701", "Sheffield",
"4412293", "Millom",
"4415072", "Spilsby\ \(Horncastle\)",
"442898", "Belfast",
"441488", "Hungerford",
"441268", "Basildon",
"441477", "Holmes\ Chapel",
"441729", "Settle",
"441225", "Bath",
"441967", "Strontian",
"441904", "York",
"442822", "Northern\ Ireland",
"441955", "Wick",
"441678", "Bala",
"441687", "Mallaig",
"441604", "Northampton",
"441667", "Nairn",
"441655", "Maybole",
"441978", "Wrexham",
"441987", "Ebbsfleet",
"441721", "Peebles",
"44241", "Coventry",
"441425", "Ringwood",
"441277", "Brentwood",
"441288", "Bude",
"441572", "Oakham",
"441879", "Scarinish",
"441793", "Swindon",
"4414303", "North\ Cave",
"441274", "Bradford",
"441408", "Golspie",
"441664", "Melton\ Mowbray",
"4413881", "Bishop\ Auckland\/Stanhope\ \(Eastgate\)",
"441570", "Lampeter",
"441984", "Watchet\ \(Williton\)",
"441359", "Pakenham",
"4418901", "Coldstream\/Ayton",
"442841", "Rostrevor",
"4414376", "Haverfordwest",
"441730", "Petersfield",
"4413399", "Ballater",
"442849", "Northern\ Ireland",
"4413873", "Langholm",
"44292", "Cardiff",
"441915", "Sunderland",
"441684", "Malvern",
"442820", "Ballycastle",
"441208", "Bodmin",
"441474", "Gravesend",
"441903", "Worthing",
"441398", "Dulverton",
"441501", "Harthill",
"442896", "Belfast",
"4419649", "Hornsea",
"441880", "Tarbert",
"4418471", "Thurso\/Tongue",
"441322", "Dartford",
"441676", "Meriden",
"441945", "Wisbech",
"441794", "Romsey",
"4418516", "Great\ Bernera",
"441286", "Caernarfon",
"441466", "Huntly",
"441509", "Loughborough",
"4419756", "Strathdon",
"441603", "Norwich",
"441750", "Selkirk",
"441935", "Yeovil",
"4415074", "Alford\ \(Lincs\)",
"441406", "Holbeach",
"441862", "Tain",
"44114709", "Sheffield",
"441797", "Rye",
"441663", "New\ Mills",
"441341", "Barmouth",
"441983", "Isle\ of\ Wight",
"441569", "Stonehaven",
"441273", "Brighton",
"441581", "New\ Luce",
"441895", "Uxbridge",
"441752", "Plymouth",
"4415078", "Alford\ \(Lincs\)",
"441561", "Laurencekirk",
"441473", "Ipswich",
"441349", "Dingwall",
"441963", "Wincanton",
"441683", "Moffat",
"4416867", "Llanidloes",
"441882", "Kinloch\ Rannoch",
"441206", "Colchester",
"441635", "Newbury",
"441320", "Fort\ Augustus",
"441989", "Ross\-on\-Wye",
"441681", "Isle\ of\ Mull\ \-\ Fionnphort",
"4419648", "Hornsea",
"441669", "Rothbury",
"441746", "Bridgnorth",
"441279", "Bishops\ Stortford",
"4418476", "Tongue",
"441775", "Spalding",
"441471", "Isle\ of\ Skye\ \-\ Broadford",
"441563", "Kilmarnock",
"4413392", "Aboyne",
"441877", "Callander",
"441305", "Dorchester",
"441354", "Chatteris",
"441888", "Turriff",
"442844", "Downpatrick",
"4419644", "Patrington",
"4419751", "Alford\ \(Aberdeen\)\/Strathdon",
"441825", "Uckfield",
"44281", "Northern\ Ireland",
"441535", "Keighley",
"442837", "Armagh",
"441583", "Carradale",
"441271", "Barnstaple",
"441758", "Pwllheli",
"441727", "St\ Albans",
"441479", "Grantown\-on\-Spey",
"441689", "Orpington",
"441981", "Wormbridge",
"441661", "Prudhoe",
"441969", "Leyburn",
"4418511", "Great\ Bernera\/Stornoway",
"441343", "Elgin",
"441576", "Lockerbie",
"441545", "Llanarth",
"441808", "Tomatin",
"442847", "Northern\ Ireland",
"441909", "Worksop",
"4416860", "Newtown\/Llanidloes",
"441724", "Scunthorpe",
"441333", "Peat\ Inn\ \(Leven\ \(Fife\)\)",
"441503", "Looe",
"441392", "Exeter",
"441736", "Penzance",
"441609", "Northallerton",
"441328", "Fakenham",
"442826", "Northern\ Ireland",
"441874", "Brecon",
"4415079", "Alford\ \(Lincs\)",
"441357", "Strathaven",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+44|\D)//g;
      my $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '44', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;