/*******************************************************************************
 * Copyright (c) 2023 Filippo Rusconi
 *<filippo.rusconi@universite-paris-saclay.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

#include "msrunreadconfig.h"

namespace pappso
{

MsRunReadConfig::MsRunReadConfig()
{
}

MsRunReadConfig::MsRunReadConfig(const MsRunReadConfig &other):
  m_retentionTimeStart(other.m_retentionTimeStart),
  m_retentionTimeEnd(other.m_retentionTimeEnd),
  m_msLevels(other.m_msLevels)
{

}

MsRunReadConfig::~MsRunReadConfig()
{
}

MsRunReadConfig &
MsRunReadConfig::operator=(const MsRunReadConfig &other)
{
  if(&other == this)
    return *this;

  m_retentionTimeStart = other.m_retentionTimeStart;
  m_retentionTimeEnd   = other.m_retentionTimeEnd;
  m_msLevels.assign(other.m_msLevels.begin(), other.m_msLevels.end());

  return *this;
}

void
MsRunReadConfig::setRetentionTimeStart(double retention_time_start)
{
  m_retentionTimeStart = retention_time_start;
}

double
MsRunReadConfig::getRetentionTimeStart() const
{
  return m_retentionTimeStart;
}

void
MsRunReadConfig::setRetentionTimeEnd(double retention_time_end)
{
  m_retentionTimeEnd = retention_time_end;
}

double
MsRunReadConfig::getRetentionTimeEnd() const
{
  return m_retentionTimeEnd;
}

void
MsRunReadConfig::setMsLevels(std::vector<std::size_t> ms_levels)
{
  m_msLevels.assign(ms_levels.begin(), ms_levels.end());
}

std::vector<std::size_t>
MsRunReadConfig::getMsLevels(void)
{
  return m_msLevels;
}

} // namespace pappso
