---
title: PostgreSQL JDBC Driver 42.2.2 Released
date: 2018-03-15 18:55:14 +0300
categories:
  - new_release
version: 42.2.2
---
**Notable changes**

### Added
- Documentation on server-side prepared statements [PR 1135](https://github.com/pgjdbc/pgjdbc/pull/1135)

### Fixed
- Avoid failure for `insert ... on conflict...update` for `reWriteBatchedInserts=true` case [PR 1130](https://github.com/pgjdbc/pgjdbc/pull/1130)
- fix: allowEncodingChanges should allow set client_encoding=... [PR 1125](https://github.com/pgjdbc/pgjdbc/pull/1125)
- Wrong data from Blob/Clob when mark/reset is used [PR 971](https://github.com/pgjdbc/pgjdbc/pull/971)
- Adjust XAException return codes for better compatibility with XA specification [PR 782](https://github.com/pgjdbc/pgjdbc/pull/782)
- Wrong results when single statement is used with different bind types[PR 1137](https://github.com/pgjdbc/pgjdbc/pull/1137)
- Support generated keys for WITH queries that miss RETURNING [PR 1138](https://github.com/pgjdbc/pgjdbc/pull/1138)
- Support generated keys when INSERT/UPDATE/DELETE keyword is followed by a comment [PR 1138](https://github.com/pgjdbc/pgjdbc/pull/1138)


<!--more-->

**Commits by author**

Dave Cramer (5):

* Update java8-date-time.md [643e5583](https://github.com/pgjdbc/pgjdbc/commit/643e5583fe34c28602af21eb766acbc56a7b26d7)
* Update about.html [6fe76a3c](https://github.com/pgjdbc/pgjdbc/commit/6fe76a3c9289c78b2a8875e101020747584c36a7)
* Update documentation.md [3b3fd8c9](https://github.com/pgjdbc/pgjdbc/commit/3b3fd8c90a4bdcde101f45ae255ca2fe30bac338)
* Update documentation.md [a8ef9f96](https://github.com/pgjdbc/pgjdbc/commit/a8ef9f96feb02246a3d7967ada2ffe146778f7ed)
* test: add Travis configuration to test SSL [PR 1095](https://github.com/pgjdbc/pgjdbc/pull/1095) [298683b1](https://github.com/pgjdbc/pgjdbc/commit/298683b1bd11a4b16cdba861c8ca93134cfb037b)

Jorge Solorzano (1):

* fix: improve DatabaseMetaData.getSQLKeywords() [PR 940](https://github.com/pgjdbc/pgjdbc/pull/940) [7a586b6e](https://github.com/pgjdbc/pgjdbc/commit/7a586b6e492e8911a928d50113a68569981fa731)

Pawel (1):

* Fixes #1096 [PR 1097](https://github.com/pgjdbc/pgjdbc/pull/1097) [df4e7fa0](https://github.com/pgjdbc/pgjdbc/commit/df4e7fa07c205e12f7fe5e3c80ab90ea63c1bc17)

Selene Feigl (1):

* fix: wrong data from Blob/Clob when mark/reset is used [PR 971](https://github.com/pgjdbc/pgjdbc/pull/971) [61e1c300](https://github.com/pgjdbc/pgjdbc/commit/61e1c300fb52237b05b7649d61603dd339fbdd9b)

Simon Stelling (1):

* fix: handle Timestamp values with fractional seconds < 1 microsecond correctly in PreparedStatement arguments [PR 1119](https://github.com/pgjdbc/pgjdbc/pull/1119) [8ff2a617](https://github.com/pgjdbc/pgjdbc/commit/8ff2a617c8a153eb364d8b762102b6b6b1cb53f8)

Vladimir Sitnikov (14):

* docs: reflect 42.2.1 release in readme.md [1a4256b9](https://github.com/pgjdbc/pgjdbc/commit/1a4256b973da36c0fc42f0268e58e1535073247b)
* chore: make sure TEST_CLIENTS performs regular tests as well [aa676bb3](https://github.com/pgjdbc/pgjdbc/commit/aa676bb39117dc47cbd51a236b232227e9128220)
* chore: remove unused variable lastKnownTime in ConnectionFactoryImpl [48b98971](https://github.com/pgjdbc/pgjdbc/commit/48b98971d085a7988b67a31cf5ff9fb52c5534e5)
* fix: ArrayIndexOutOfBoundsException when using the same SQL for regular and updateable resultset [PR 1123](https://github.com/pgjdbc/pgjdbc/pull/1123) [45c32bc6](https://github.com/pgjdbc/pgjdbc/commit/45c32bc6af2e140ff86dabd718344c74fc244394)
* fix: support insert ... on conflict...update for reWriteBatchedInserts=true [PR 1130](https://github.com/pgjdbc/pgjdbc/pull/1130) [1ca0c586](https://github.com/pgjdbc/pgjdbc/commit/1ca0c5864a8b6c575b32aee03e2e1e8848fee143)
* fix: allowEncodingChanges should allow set client_encoding=... [PR 1125](https://github.com/pgjdbc/pgjdbc/pull/1125) [af64ed2d](https://github.com/pgjdbc/pgjdbc/commit/af64ed2dac035c621b4aec4a0471730457725194)
* tests: UUID vs setString test [PR 1133](https://github.com/pgjdbc/pgjdbc/pull/1133) [5827858b](https://github.com/pgjdbc/pgjdbc/commit/5827858ba5b72b519feb86fc65301a7bffa10c4d)
* fix: UUID test for preferQueryMode=simple [44bb7f8d](https://github.com/pgjdbc/pgjdbc/commit/44bb7f8d66829705bf46a6cfcad8a179eb14e441)
* fix: wrong results when a single statement is used with UNSPECIFIED types [PR 1137](https://github.com/pgjdbc/pgjdbc/pull/1137) [fcd1ea14](https://github.com/pgjdbc/pgjdbc/commit/fcd1ea14545a113fe4a124e17132824e279f572e)
* test: workaround DST issue in StatementTest#testDateFunctions [af499625](https://github.com/pgjdbc/pgjdbc/commit/af499625fb99043fe0bf605ec4b23f3dd64c18d7)
* docs: improve documentation and tests for server-side prepared statements [PR 1135](https://github.com/pgjdbc/pgjdbc/pull/1135) [4204f094](https://github.com/pgjdbc/pgjdbc/commit/4204f09446edbc7caaecb4c8cd7c8f78abd9344e)
* test: make testAlternatingBindType Java 6-compatible [PR 1139](https://github.com/pgjdbc/pgjdbc/pull/1139) [bcdd4273](https://github.com/pgjdbc/pgjdbc/commit/bcdd4273bba7ae6b3348d47d4cdeb72e941d5acc)
* fix: better support for RETURNING for WITH queries and queries with comments [PR 1138](https://github.com/pgjdbc/pgjdbc/pull/1138) [04e76661](https://github.com/pgjdbc/pgjdbc/commit/04e76661586b54157a1220552c005569231388a9)
* chore: add contributor links to release script [2568d38e](https://github.com/pgjdbc/pgjdbc/commit/2568d38e5ff7c9b23f92011c7dc936c307f53008)

bpd0018 (3):

* docs: fix spelling and chapter, update sample code [PR 1098](https://github.com/pgjdbc/pgjdbc/pull/1098) [0cfffa84](https://github.com/pgjdbc/pgjdbc/commit/0cfffa841b9b8d2040fe6c576aa77edfd399bbc0)
* style: spelling in comment [PR 1121](https://github.com/pgjdbc/pgjdbc/pull/1121) [cc219aa7](https://github.com/pgjdbc/pgjdbc/commit/cc219aa79b37f03432db4fe61e06b5f27fcb7f83)
* docs: fix JavaDoc for getPreferQueryMode() [PR 1122](https://github.com/pgjdbc/pgjdbc/pull/1122) [43d80cd4](https://github.com/pgjdbc/pgjdbc/commit/43d80cd48a54ea91868d15bd2f3806b467519883)

chalda (1):

* Adjust XAException return codes for better compatibility with XA specification [PR 782](https://github.com/pgjdbc/pgjdbc/pull/782) [e5aab1cd](https://github.com/pgjdbc/pgjdbc/commit/e5aab1cd3e49051f46298d8f1fd9f66af1731299)

trtrmitya (1):

* fix: use Locale.Category.DISPLAY (~lc_messages) when selecting resource bundle. [PR 1115](https://github.com/pgjdbc/pgjdbc/pull/1115) [0e9dfce4](https://github.com/pgjdbc/pgjdbc/commit/0e9dfce42c80391d0eefa830600e0ac4c1baae50)

<a name="contributors_{{ page.version }}"></a>
### Contributors to this release

We thank the following people for their contributions to this release.

[Dave Cramer](davec@postgresintl.com)  
[Jorge Solorzano](https://github.com/jorsol)  
[Pawel](https://github.com/veselov)  
[Selene Feigl](https://github.com/sfeigl)  
[Simon Stelling](https://github.com/stellingsimon)  
[Vladimir Sitnikov](https://github.com/vlsi)  
[bpd0018](https://github.com/bpd0018)  
[chalda](https://github.com/ochaloup)  
[trtrmitya](https://github.com/trtrmitya)  
