# GYP project file for TDesktop

{
    'targets': [
      {
        'target_name': 'libtgvoip',
        'type': 'static_library',
        'dependencies': [],
        'defines': [
          'WEBRTC_APM_DEBUG_DUMP=0',
          'TGVOIP_USE_DESKTOP_DSP',
          'WEBRTC_NS_FLOAT',
        ],
        'variables': {
          'tgvoip_src_loc': '.',
          'official_build_target%': '',
          'linux_path_opus_include%': '<(DEPTH)/../../../Libraries/opus/include',
        },
        'include_dirs': [
          '<(tgvoip_src_loc)/webrtc_dsp',
          '<(linux_path_opus_include)',
        ],
        'direct_dependent_settings': {
          'include_dirs': [
            '<(tgvoip_src_loc)',
          ],
        },
        'export_dependent_settings': [],
        'sources': [
          '<(tgvoip_src_loc)/BlockingQueue.cpp',
          '<(tgvoip_src_loc)/BlockingQueue.h',
          '<(tgvoip_src_loc)/Buffers.cpp',
          '<(tgvoip_src_loc)/Buffers.h',
          '<(tgvoip_src_loc)/CongestionControl.cpp',
          '<(tgvoip_src_loc)/CongestionControl.h',
          '<(tgvoip_src_loc)/EchoCanceller.cpp',
          '<(tgvoip_src_loc)/EchoCanceller.h',
          '<(tgvoip_src_loc)/JitterBuffer.cpp',
          '<(tgvoip_src_loc)/JitterBuffer.h',
          '<(tgvoip_src_loc)/logging.cpp',
          '<(tgvoip_src_loc)/logging.h',
          '<(tgvoip_src_loc)/MediaStreamItf.cpp',
          '<(tgvoip_src_loc)/MediaStreamItf.h',
          '<(tgvoip_src_loc)/OpusDecoder.cpp',
          '<(tgvoip_src_loc)/OpusDecoder.h',
          '<(tgvoip_src_loc)/OpusEncoder.cpp',
          '<(tgvoip_src_loc)/OpusEncoder.h',
          '<(tgvoip_src_loc)/threading.h',
          '<(tgvoip_src_loc)/VoIPController.cpp',
          '<(tgvoip_src_loc)/VoIPGroupController.cpp',
          '<(tgvoip_src_loc)/VoIPController.h',
          '<(tgvoip_src_loc)/PrivateDefines.h',
          '<(tgvoip_src_loc)/VoIPServerConfig.cpp',
          '<(tgvoip_src_loc)/VoIPServerConfig.h',
          '<(tgvoip_src_loc)/audio/AudioInput.cpp',
          '<(tgvoip_src_loc)/audio/AudioInput.h',
          '<(tgvoip_src_loc)/audio/AudioOutput.cpp',
          '<(tgvoip_src_loc)/audio/AudioOutput.h',
          '<(tgvoip_src_loc)/audio/Resampler.cpp',
          '<(tgvoip_src_loc)/audio/Resampler.h',
          '<(tgvoip_src_loc)/NetworkSocket.cpp',
          '<(tgvoip_src_loc)/NetworkSocket.h',
          '<(tgvoip_src_loc)/PacketReassembler.cpp',
          '<(tgvoip_src_loc)/PacketReassembler.h',
          '<(tgvoip_src_loc)/MessageThread.cpp',
          '<(tgvoip_src_loc)/MessageThread.h',
          '<(tgvoip_src_loc)/audio/AudioIO.cpp',
          '<(tgvoip_src_loc)/audio/AudioIO.h',
          '<(tgvoip_src_loc)/video/ScreamCongestionController.cpp',
          '<(tgvoip_src_loc)/video/ScreamCongestionController.h',
          '<(tgvoip_src_loc)/video/VideoSource.cpp',
          '<(tgvoip_src_loc)/video/VideoSource.h',
          '<(tgvoip_src_loc)/video/VideoRenderer.cpp',
          '<(tgvoip_src_loc)/video/VideoRenderer.h',
          '<(tgvoip_src_loc)/json11.cpp',
          '<(tgvoip_src_loc)/json11.hpp',

          # Windows
          '<(tgvoip_src_loc)/os/windows/NetworkSocketWinsock.cpp',
          '<(tgvoip_src_loc)/os/windows/NetworkSocketWinsock.h',
          '<(tgvoip_src_loc)/os/windows/AudioInputWave.cpp',
          '<(tgvoip_src_loc)/os/windows/AudioInputWave.h',
          '<(tgvoip_src_loc)/os/windows/AudioOutputWave.cpp',
          '<(tgvoip_src_loc)/os/windows/AudioOutputWave.h',
          '<(tgvoip_src_loc)/os/windows/AudioOutputWASAPI.cpp',
          '<(tgvoip_src_loc)/os/windows/AudioOutputWASAPI.h',
          '<(tgvoip_src_loc)/os/windows/AudioInputWASAPI.cpp',
          '<(tgvoip_src_loc)/os/windows/AudioInputWASAPI.h',
          '<(tgvoip_src_loc)/os/windows/WindowsSpecific.cpp',
          '<(tgvoip_src_loc)/os/windows/WindowsSpecific.h',

          # macOS
          '<(tgvoip_src_loc)/os/darwin/AudioInputAudioUnit.cpp',
          '<(tgvoip_src_loc)/os/darwin/AudioInputAudioUnit.h',
          '<(tgvoip_src_loc)/os/darwin/AudioOutputAudioUnit.cpp',
          '<(tgvoip_src_loc)/os/darwin/AudioOutputAudioUnit.h',
          '<(tgvoip_src_loc)/os/darwin/AudioInputAudioUnitOSX.cpp',
          '<(tgvoip_src_loc)/os/darwin/AudioInputAudioUnitOSX.h',
          '<(tgvoip_src_loc)/os/darwin/AudioOutputAudioUnitOSX.cpp',
          '<(tgvoip_src_loc)/os/darwin/AudioOutputAudioUnitOSX.h',
          '<(tgvoip_src_loc)/os/darwin/AudioUnitIO.cpp',
          '<(tgvoip_src_loc)/os/darwin/AudioUnitIO.h',
          '<(tgvoip_src_loc)/os/darwin/DarwinSpecific.mm',
          '<(tgvoip_src_loc)/os/darwin/DarwinSpecific.h',

          # Linux
          '<(tgvoip_src_loc)/os/linux/AudioInputALSA.cpp',
          '<(tgvoip_src_loc)/os/linux/AudioInputALSA.h',
          '<(tgvoip_src_loc)/os/linux/AudioOutputALSA.cpp',
          '<(tgvoip_src_loc)/os/linux/AudioOutputALSA.h',
          '<(tgvoip_src_loc)/os/linux/AudioOutputPulse.cpp',
          '<(tgvoip_src_loc)/os/linux/AudioOutputPulse.h',
          '<(tgvoip_src_loc)/os/linux/AudioInputPulse.cpp',
          '<(tgvoip_src_loc)/os/linux/AudioInputPulse.h',
          '<(tgvoip_src_loc)/os/linux/AudioPulse.cpp',
          '<(tgvoip_src_loc)/os/linux/AudioPulse.h',

          # POSIX
          '<(tgvoip_src_loc)/os/posix/NetworkSocketPosix.cpp',
          '<(tgvoip_src_loc)/os/posix/NetworkSocketPosix.h',

          # WebRTC APM
          '<(tgvoip_src_loc)/webrtc_dsp/system_wrappers/include/field_trial.h',
          '<(tgvoip_src_loc)/webrtc_dsp/system_wrappers/include/cpu_features_wrapper.h',
          '<(tgvoip_src_loc)/webrtc_dsp/system_wrappers/include/asm_defines.h',
          '<(tgvoip_src_loc)/webrtc_dsp/system_wrappers/include/metrics.h',
          '<(tgvoip_src_loc)/webrtc_dsp/system_wrappers/include/compile_assert_c.h',
          '<(tgvoip_src_loc)/webrtc_dsp/system_wrappers/source/field_trial.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/system_wrappers/source/metrics.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/system_wrappers/source/cpu_features.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/typedefs.h',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/strings/internal/memutil.h',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/strings/internal/memutil.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/strings/string_view.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/strings/ascii.h',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/strings/ascii.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/strings/string_view.h',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/types/optional.h',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/types/bad_optional_access.h',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/types/bad_optional_access.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/types/optional.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/memory/memory.h',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/meta/type_traits.h',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/algorithm/algorithm.h',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/container/inlined_vector.h',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/base/policy_checks.h',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/base/port.h',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/base/config.h',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/base/internal/raw_logging.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/base/internal/throw_delegate.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/base/internal/invoke.h',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/base/internal/inline_variable.h',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/base/internal/atomic_hook.h',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/base/internal/identity.h',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/base/internal/raw_logging.h',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/base/internal/throw_delegate.h',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/base/attributes.h',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/base/macros.h',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/base/optimization.h',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/base/log_severity.h',
          '<(tgvoip_src_loc)/webrtc_dsp/absl/utility/utility.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/string_to_number.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/constructormagic.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/race_checker.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/strings/string_builder.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/strings/string_builder.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/event_tracer.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/stringencode.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/memory/aligned_malloc.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/memory/aligned_malloc.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/timeutils.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/event.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/ignore_wundef.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/stringutils.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/arraysize.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/platform_file.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/swap_queue.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/string_to_number.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/trace_event.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/checks.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/deprecation.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/thread_checker_impl.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/sanitizer.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/scoped_ref_ptr.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/logging.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/timeutils.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/atomicops.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/stringencode.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/stringutils.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/checks.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/numerics/safe_minmax.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/numerics/safe_conversions.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/numerics/safe_conversions_impl.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/numerics/safe_compare.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/system/unused.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/system/inline.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/system/ignore_warnings.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/system/asm_defines.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/system/rtc_export.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/system/arch.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/platform_thread.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/platform_thread.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/platform_thread_types.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/protobuf_utils.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/thread_annotations.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/gtest_prod_util.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/function_view.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/criticalsection.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/criticalsection.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/platform_thread_types.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/refcount.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/event.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/thread_checker_impl.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/event_tracer.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/compile_assert_c.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/logging_webrtc.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/type_traits.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/platform_file.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/refcounter.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/logging_mac.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/thread_checker.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/race_checker.h',
          '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/refcountedobject.h',
          '<(tgvoip_src_loc)/webrtc_dsp/third_party/rnnoise/src/rnn_vad_weights.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/third_party/rnnoise/src/rnn_activations.h',
          '<(tgvoip_src_loc)/webrtc_dsp/third_party/rnnoise/src/kiss_fft.h',
          '<(tgvoip_src_loc)/webrtc_dsp/third_party/rnnoise/src/kiss_fft.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/third_party/rnnoise/src/rnn_vad_weights.h',
          '<(tgvoip_src_loc)/webrtc_dsp/api/audio/audio_frame.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/api/audio/echo_canceller3_config.h',
          '<(tgvoip_src_loc)/webrtc_dsp/api/audio/echo_control.h',
          '<(tgvoip_src_loc)/webrtc_dsp/api/audio/audio_frame.h',
          '<(tgvoip_src_loc)/webrtc_dsp/api/audio/echo_canceller3_config.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/api/audio/echo_canceller3_factory.h',
          '<(tgvoip_src_loc)/webrtc_dsp/api/audio/echo_canceller3_factory.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/api/array_view.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/third_party/fft/fft.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/third_party/fft/fft.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/bandwidth_info.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/include/isac.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/pitch_estimator.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/lpc_shape_swb16_tables.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/pitch_gain_tables.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/arith_routines_logist.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/os_specific_inline.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/filterbanks.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/entropy_coding.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/isac_vad.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/settings.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/transform.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/lpc_shape_swb12_tables.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/arith_routines.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/crc.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/pitch_filter.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/encode_lpc_swb.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/filter_functions.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/decode.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/lattice.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/intialize.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/lpc_tables.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/lpc_gain_swb_tables.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/bandwidth_estimator.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/isac_float_type.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/pitch_lag_tables.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/encode.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/lpc_analysis.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/spectrum_ar_model_tables.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/arith_routines_hist.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/codec.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/pitch_gain_tables.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/lpc_shape_swb16_tables.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/pitch_estimator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/entropy_coding.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/isac_vad.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/structs.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/filter_functions.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/encode_lpc_swb.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/pitch_filter.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/arith_routines.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/crc.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/lpc_shape_swb12_tables.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/lpc_analysis.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/decode_bwe.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/spectrum_ar_model_tables.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/bandwidth_estimator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/pitch_lag_tables.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/isac.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/lpc_gain_swb_tables.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_coding/codecs/isac/main/source/lpc_tables.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/rms_level.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/echo_detector/moving_max.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/echo_detector/circular_buffer.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/echo_detector/normalized_covariance_estimator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/echo_detector/normalized_covariance_estimator.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/echo_detector/moving_max.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/echo_detector/circular_buffer.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/echo_detector/mean_variance_estimator.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/echo_detector/mean_variance_estimator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/gain_control_for_experimental_agc.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/splitting_filter.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/gain_control_impl.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/rms_level.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/ns/ns_core.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/ns/nsx_core.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/ns/noise_suppression_x.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/ns/nsx_core_c.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/ns/defines.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/ns/noise_suppression.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/ns/ns_core.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/ns/nsx_core.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/ns/windows_private.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/ns/noise_suppression_x.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/ns/noise_suppression.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/ns/nsx_defines.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/residual_echo_detector.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/audio_processing_impl.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/audio_buffer.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/typing_detection.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/render_queue_item_verifier.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/include/audio_generator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/include/config.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/include/audio_frame_view.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/include/mock_audio_processing.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/include/gain_control.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/include/audio_generator_factory.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/include/audio_processing_statistics.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/include/audio_generator_factory.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/include/aec_dump.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/include/aec_dump.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/include/audio_processing_statistics.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/include/audio_processing.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/include/audio_processing.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/include/config.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/interpolated_gain_curve.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/biquad_filter.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/interpolated_gain_curve.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/agc2_common.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/agc2_testing_common.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/adaptive_mode_level_estimator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/gain_applier.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/signal_classifier.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/adaptive_agc.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/adaptive_digital_gain_applier.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/limiter.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/saturation_protector.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/vector_float_frame.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/rnn_vad/spectral_features_internal.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/rnn_vad/sequence_buffer.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/rnn_vad/rnn.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/rnn_vad/rnn.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/rnn_vad/test_utils.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/rnn_vad/pitch_info.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/rnn_vad/lp_residual.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/rnn_vad/ring_buffer.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/rnn_vad/pitch_search_internal.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/rnn_vad/symmetric_matrix_buffer.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/rnn_vad/spectral_features.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/rnn_vad/features_extraction.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/rnn_vad/common.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/rnn_vad/spectral_features_internal.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/rnn_vad/fft_util.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/rnn_vad/spectral_features.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/rnn_vad/pitch_search_internal.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/rnn_vad/pitch_search.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/rnn_vad/pitch_search.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/rnn_vad/features_extraction.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/rnn_vad/fft_util.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/rnn_vad/lp_residual.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/fixed_gain_controller.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/adaptive_mode_level_estimator_agc.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/vector_float_frame.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/down_sampler.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/noise_level_estimator.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/agc2_testing_common.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/fixed_digital_level_estimator.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/fixed_gain_controller.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/saturation_protector.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/vad_with_level.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/limiter_db_gain_curve.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/agc2_common.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/adaptive_mode_level_estimator_agc.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/adaptive_digital_gain_applier.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/vad_with_level.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/limiter_db_gain_curve.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/fixed_digital_level_estimator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/adaptive_agc.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/gain_applier.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/down_sampler.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/noise_level_estimator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/signal_classifier.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/noise_spectrum_estimator.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/compute_interpolated_gain_curve.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/compute_interpolated_gain_curve.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/biquad_filter.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/noise_spectrum_estimator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/limiter.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc2/adaptive_mode_level_estimator.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/transient/moving_moments.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/transient/transient_detector.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/transient/wpd_tree.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/transient/transient_suppressor.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/transient/daubechies_8_wavelet_coeffs.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/transient/common.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/transient/wpd_node.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/transient/moving_moments.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/transient/wpd_tree.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/transient/wpd_node.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/transient/transient_suppressor.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/transient/transient_detector.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/transient/dyadic_decimator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/low_cut_filter.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/noise_suppression_impl.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/level_estimator_impl.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/three_band_filter_bank.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec/echo_cancellation.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec/aec_resampler.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec/aec_resampler.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec/echo_cancellation.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec/aec_core.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec/aec_core.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec/aec_core_optimized_methods.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec/aec_core_sse2.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec/aec_common.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/voice_detection_impl.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/voice_detection_impl.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/echo_cancellation_impl.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/gain_control_for_experimental_agc.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc/agc.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc/loudness_histogram.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc/agc_manager_direct.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc/legacy/analog_agc.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc/legacy/gain_control.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc/legacy/digital_agc.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc/legacy/analog_agc.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc/legacy/digital_agc.c',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc/utility.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc/mock_agc.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc/loudness_histogram.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc/gain_map_internal.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc/utility.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc/agc_manager_direct.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/agc/agc.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/common.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/audio_processing_impl.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/audio_buffer.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/echo_control_mobile_impl.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/splitting_filter.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/low_cut_filter.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/audio_generator/file_audio_generator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/audio_generator/file_audio_generator.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/gain_controller2.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/three_band_filter_bank.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/residual_echo_detector.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/echo_cancellation_impl.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/noise_suppression_impl.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/level_estimator_impl.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/gain_controller2.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aecm/aecm_core.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aecm/aecm_defines.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aecm/aecm_core.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aecm/aecm_core_c.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aecm/echo_control_mobile.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aecm/echo_control_mobile.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/render_reverb_model.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/downsampled_render_buffer.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/subtractor_output_analyzer.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/reverb_model_fallback.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/residual_echo_estimator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/shadow_filter_update_gain.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/echo_remover_metrics.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/matched_filter_lag_aggregator.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/render_delay_buffer2.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/aec_state.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/suppression_filter.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/echo_path_variability.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/frame_blocker.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/subtractor.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/block_delay_buffer.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/adaptive_fir_filter.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/cascaded_biquad_filter.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/matched_filter.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/subtractor_output.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/render_signal_analyzer.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/aec3_fft.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/aec3_fft.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/echo_remover_metrics.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/fullband_erle_estimator.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/suppression_filter.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/block_processor.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/filter_analyzer.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/subtractor.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/echo_path_delay_estimator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/subband_erle_estimator.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/render_delay_controller_metrics.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/render_delay_buffer.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/block_processor_metrics.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/vector_buffer.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/erl_estimator.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/aec_state.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/adaptive_fir_filter.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/fft_data.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/render_delay_controller.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/skew_estimator.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/render_delay_controller_metrics.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/comfort_noise_generator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/echo_path_delay_estimator.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/erl_estimator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/echo_remover.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/block_framer.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/erle_estimator.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/reverb_model.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/cascaded_biquad_filter.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/matrix_buffer.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/render_buffer.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/reverb_model_estimator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/subtractor_output.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/stationarity_estimator.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/render_signal_analyzer.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/echo_path_variability.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/moving_average.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/render_reverb_model.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/subtractor_output_analyzer.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/suppression_gain.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/echo_audibility.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/block_processor_metrics.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/render_delay_controller.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/suppression_gain.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/moving_average.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/erle_estimator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/subband_erle_estimator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/reverb_model_estimator.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/aec3_common.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/residual_echo_estimator.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/block_processor.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/fullband_erle_estimator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/matched_filter.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/stationarity_estimator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/echo_canceller3.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/skew_estimator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/reverb_decay_estimator.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/render_delay_controller2.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/render_buffer.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/suppression_gain_limiter.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/main_filter_update_gain.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/echo_remover.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/reverb_model_fallback.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/downsampled_render_buffer.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/vector_buffer.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/matrix_buffer.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/reverb_frequency_response.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/echo_audibility.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/fft_buffer.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/block_processor2.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/echo_canceller3.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/block_delay_buffer.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/aec3_common.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/fft_buffer.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/vector_math.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/decimator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/frame_blocker.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/block_framer.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/suppression_gain_limiter.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/delay_estimate.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/comfort_noise_generator.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/reverb_model.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/main_filter_update_gain.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/matched_filter_lag_aggregator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/shadow_filter_update_gain.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/filter_analyzer.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/reverb_decay_estimator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/reverb_frequency_response.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/decimator.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec3/render_delay_buffer.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/echo_control_mobile_impl.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/gain_control_impl.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/typing_detection.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/logging/apm_data_dumper.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/logging/apm_data_dumper.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/vad/voice_activity_detector.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/vad/standalone_vad.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/vad/vad_audio_proc_internal.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/vad/pitch_internal.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/vad/vad_circular_buffer.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/vad/vad_circular_buffer.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/vad/pitch_based_vad.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/vad/vad_audio_proc.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/vad/pole_zero_filter.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/vad/pole_zero_filter.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/vad/pitch_based_vad.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/vad/gmm.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/vad/common.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/vad/vad_audio_proc.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/vad/voice_gmm_tables.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/vad/noise_gmm_tables.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/vad/pitch_internal.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/vad/gmm.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/vad/standalone_vad.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/vad/voice_activity_detector.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/utility/delay_estimator_internal.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/utility/ooura_fft.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/utility/ooura_fft.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/utility/delay_estimator_wrapper.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/utility/ooura_fft_sse2.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/utility/delay_estimator.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/utility/block_mean_calculator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/utility/block_mean_calculator.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/utility/delay_estimator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/utility/ooura_fft_tables_common.h',
          '<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/utility/delay_estimator_wrapper.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/mocks/mock_smoothing_filter.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/wav_file.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/window_generator.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/channel_buffer.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/fir_filter_factory.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/sparse_fir_filter.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/fir_filter_sse.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/window_generator.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/ring_buffer.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/fir_filter.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/include/audio_util.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/wav_header.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/real_fourier_ooura.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/audio_util.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/real_fourier_ooura.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/fir_filter_sse.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/smoothing_filter.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/resampler/push_sinc_resampler.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/resampler/sinc_resampler.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/resampler/resampler.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/resampler/sinc_resampler_sse.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/resampler/include/push_resampler.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/resampler/include/resampler.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/resampler/push_sinc_resampler.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/resampler/push_resampler.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/resampler/sinusoidal_linear_chirp_source.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/resampler/sinc_resampler.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/resampler/sinusoidal_linear_chirp_source.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/fir_filter_factory.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/audio_converter.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/wav_file.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/third_party/spl_sqrt_floor/spl_sqrt_floor.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/third_party/spl_sqrt_floor/spl_sqrt_floor.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/third_party/fft4g/fft4g.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/third_party/fft4g/fft4g.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/audio_converter.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/real_fourier.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/channel_buffer.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/real_fourier.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/sparse_fir_filter.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/smoothing_filter.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/fir_filter_c.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/ring_buffer.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/fir_filter_c.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/complex_fft_tables.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/complex_fft.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/filter_ma_fast_q12.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/levinson_durbin.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/dot_product_with_scale.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/auto_corr_to_refl_coef.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/resample_by_2_internal.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/energy.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/sqrt_of_one_minus_x_squared.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/downsample_fast.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/splitting_filter1.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/filter_ar_fast_q12.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/spl_init.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/lpc_to_refl_coef.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/cross_correlation.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/include/signal_processing_library.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/include/real_fft.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/include/spl_inl.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/division_operations.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/auto_correlation.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/get_scaling_square.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/dot_product_with_scale.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/resample_by_2_internal.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/resample.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/min_max_operations.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/refl_coef_to_lpc.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/filter_ar.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/vector_scaling_operations.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/resample_fractional.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/real_fft.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/ilbc_specific_functions.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/complex_bit_reverse.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/randomization_functions.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/copy_set_operations.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/resample_by_2.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/get_hanning_window.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/resample_48khz.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/spl_inl.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/spl_sqrt.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/wav_header.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/vad/vad_sp.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/vad/vad.cc',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/vad/webrtc_vad.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/vad/vad_core.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/vad/include/vad.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/vad/include/webrtc_vad.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/vad/vad_gmm.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/vad/vad_filterbank.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/vad/vad_core.c',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/vad/vad_sp.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/vad/vad_filterbank.h',
          '<(tgvoip_src_loc)/webrtc_dsp/common_audio/vad/vad_gmm.c', 

          # ARM/NEON sources
          # TODO check if there's a good way to make these compile with ARM ports of TDesktop
          #'<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/ns/nsx_core_neon.c',
          #'<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aec/aec_core_neon.cc',
          #'<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/aecm/aecm_core_neon.cc',
          #'<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/utility/ooura_fft_tables_neon_sse2.h',
          #'<(tgvoip_src_loc)/webrtc_dsp/modules/audio_processing/utility/ooura_fft_neon.cc',
          #'<(tgvoip_src_loc)/webrtc_dsp/common_audio/fir_filter_neon.cc',
          #'<(tgvoip_src_loc)/webrtc_dsp/common_audio/resampler/sinc_resampler_neon.cc',
          #'<(tgvoip_src_loc)/webrtc_dsp/common_audio/third_party/spl_sqrt_floor/spl_sqrt_floor_arm.S',
          #'<(tgvoip_src_loc)/webrtc_dsp/common_audio/fir_filter_neon.h',
          #'<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/downsample_fast_neon.c',
          #'<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/complex_bit_reverse_arm.S',
          #'<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/include/spl_inl_armv7.h',
          #'<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/min_max_operations_neon.c',
          #'<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/cross_correlation_neon.c',
          #'<(tgvoip_src_loc)/webrtc_dsp/common_audio/signal_processing/filter_ar_fast_q12_armv7.S',


        ],
        'libraries': [],
        'configurations': {
          'Debug': {},
          'Release': {},
        },
        'conditions': [
          [
            '"<(OS)" != "win"', {
              'sources/': [['exclude', '<(tgvoip_src_loc)/os/windows/']],
            }, {
              'sources/': [['exclude', '<(tgvoip_src_loc)/os/posix/']],
            },
          ],
          [
            '"<(OS)" != "mac"', {
              'sources/': [['exclude', '<(tgvoip_src_loc)/os/darwin/']],
            },
          ],
          [
            '"<(OS)" != "linux"', {
              'sources/': [['exclude', '<(tgvoip_src_loc)/os/linux/']],
            },
          ],
          [
            '"<(OS)" == "mac"', {
              'xcode_settings': {
                'CLANG_CXX_LANGUAGE_STANDARD': 'c++11',
                'ALWAYS_SEARCH_USER_PATHS': 'NO',
              },
              'defines': [
                'WEBRTC_POSIX',
                'WEBRTC_MAC',
                'TARGET_OS_OSX',
              ],
              'sources': [
                '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/logging_mac.mm',
                '<(tgvoip_src_loc)/webrtc_dsp/rtc_base/logging_mac.h',
              ],
              'conditions': [
                [ '"<(official_build_target)" == "mac32"', {
                  'xcode_settings': {
                    'MACOSX_DEPLOYMENT_TARGET': '10.6',
                    'OTHER_CPLUSPLUSFLAGS': [ '-nostdinc++' ],
                  },
                  'include_dirs': [
                    '/usr/local/macold/include/c++/v1',
                    '<(DEPTH)/../../../Libraries/macold/openssl/include',
                  ],
                  'defines': [
                    'TARGET_OSX32',
                  ],
                }, {
                  'xcode_settings': {
                    'MACOSX_DEPLOYMENT_TARGET': '10.8',
                    'CLANG_CXX_LIBRARY': 'libc++',
                  },
                  'include_dirs': [
                    '<(DEPTH)/../../../Libraries/openssl/include',
                  ],
                  'direct_dependent_settings': {
                    'linkflags': [
                      '-framework VideoToolbox',
                    ],
                  },
                  'sources': [
                   '<(tgvoip_src_loc)/os/darwin/TGVVideoRenderer.mm',
                   '<(tgvoip_src_loc)/os/darwin/TGVVideoRenderer.h',
                   '<(tgvoip_src_loc)/os/darwin/TGVVideoSource.mm',
                   '<(tgvoip_src_loc)/os/darwin/TGVVideoSource.h',
                   '<(tgvoip_src_loc)/os/darwin/VideoToolboxEncoderSource.mm',
                   '<(tgvoip_src_loc)/os/darwin/VideoToolboxEncoderSource.h',
                   '<(tgvoip_src_loc)/os/darwin/SampleBufferDisplayLayerRenderer.mm',
                   '<(tgvoip_src_loc)/os/darwin/SampleBufferDisplayLayerRenderer.h',
                  ],
                }]
              ],
            },
          ],
          [
            '"<(OS)" == "win"', {
              'msbuild_toolset': 'v141',
              'defines': [
                'NOMINMAX',
                '_USING_V110_SDK71_',
                'TGVOIP_WINXP_COMPAT',
                'WEBRTC_WIN',
              ],
              'libraries': [
                'winmm',
                'ws2_32',
                'kernel32',
                'user32',
              ],
              'msvs_cygwin_shell': 0,
              'msvs_settings': {
                'VCCLCompilerTool': {
                  'ProgramDataBaseFileName': '$(OutDir)\\$(ProjectName).pdb',
                  'DebugInformationFormat': '3',          # Program Database (/Zi)
                  'AdditionalOptions': [
                    '/MP',   # Enable multi process build.
                    '/EHsc', # Catch C++ exceptions only, extern C functions never throw a C++ exception.
                    '/wd4068', # Disable "warning C4068: unknown pragma"
                  ],
                  'TreatWChar_tAsBuiltInType': 'false',
                },
              },
              'msvs_external_builder_build_cmd': [
                'ninja.exe',
                '-C',
                '$(OutDir)',
                '-k0',
                '$(ProjectName)',
              ],
              'configurations': {
                'Debug': {
                  'defines': [
                    '_DEBUG',
                  ],
                  'include_dirs': [
                    '<(DEPTH)/../../../Libraries/openssl/Debug/include',
                  ],
                  'msvs_settings': {
                    'VCCLCompilerTool': {
                      'Optimization': '0',                # Disabled (/Od)
                      'RuntimeLibrary': '1',              # Multi-threaded Debug (/MTd)
                      'RuntimeTypeInfo': 'true',
                    },
                    'VCLibrarianTool': {
                      'AdditionalOptions': [
                        '/NODEFAULTLIB:LIBCMT'
                      ]
                    }
                  },
                },
                'Release': {
                  'defines': [
                    'NDEBUG',
                  ],
                  'include_dirs': [
                     '<(DEPTH)/../../../Libraries/openssl/Release/include',
                  ],
                  'msvs_settings': {
                    'VCCLCompilerTool': {
                      'Optimization': '2',                 # Maximize Speed (/O2)
                      'InlineFunctionExpansion': '2',      # Any suitable (/Ob2)
                      'EnableIntrinsicFunctions': 'true',  # Yes (/Oi)
                      'FavorSizeOrSpeed': '1',             # Favor fast code (/Ot)
                      'RuntimeLibrary': '0',               # Multi-threaded (/MT)
                      'EnableEnhancedInstructionSet': '2', # Streaming SIMD Extensions 2 (/arch:SSE2)
                      'WholeProgramOptimization': 'true',  # /GL
                    },
                    'VCLibrarianTool': {
                      'AdditionalOptions': [
                        '/LTCG',
                      ]
                    },
                  },
                },
              },
            },
          ],
          [
            '"<(OS)" == "linux"', {
              'defines': [
                'WEBRTC_POSIX',
                'WEBRTC_LINUX',
              ],
              'conditions': [
                [ '"<!(uname -m)" == "i686"', {
                  'cflags_cc': [
                    '-msse2',
                  ],
                }]
              ],
              'direct_dependent_settings': {
                'libraries': [

                ],
              },
            },
          ],
        ],
      },
    ],
  }
