#!/bin/bash

set -eu

# http://pkg-perl.alioth.debian.org/howto/repacking.html ?
repo=https://github.com/wfeldt/libx86emu.git

if [ $# = 0 ]; then
    echo "Available tags:"
    git ls-remote $repo \
        | awk '{ print $2 }' | egrep 'refs/tags/[0-9]+' \
        | awk 'FS="/" { print $3 }' | xargs echo
    exit 0
fi

version=$1

tmp=$(mktemp -d)
name="libx86emu-${version}.tar.gz"

(
    cd $tmp
    git clone ${repo} libx86emu
    cd libx86emu
    git reset --hard ${version}
    # the build system needs this
    make changelog # this creates VERSION as well
    rm -rf ./.git ./.depend
    tar cfz ../${name} .
)

cp ${tmp}/${name} ../

rm -rf ${tmp}

echo "The archive saved as ../${name}"
