# Copyright 2013 Canonical Ltd.  This software is licensed under the
# GNU Affero General Public License version 3 (see the file LICENSE).

"""Enumerations copied from MAAS.

These don't have to be complete, but anything they do define must be consistent
with the matching enum definitions in the MAAS source tree itself.
"""

from __future__ import (
    absolute_import,
    print_function,
    unicode_literals,
    )

str = None

__metaclass__ = type
__all__ = [
    'NODEGROUPINTERFACE_MANAGEMENT',
    'NODE_STATUS',
    ]


class NODE_STATUS:
    """The vocabulary of a `Node`'s possible statuses."""
    DECLARED = 0
    COMMISSIONING = 1
    FAILED_TESTS = 2
    MISSING = 3
    READY = 4
    RESERVED = 5
    ALLOCATED = 6
    RETIRED = 7


class NODEGROUPINTERFACE_MANAGEMENT:
    """The vocabulary of a `NodeGroupInterface`'s possible statuses."""
    UNMANAGED = 0
    DHCP = 1
    DHCP_AND_DNS = 2
