#
# This include file is used by more than one test suite
# (currently rpl and binlog_encryption).
# Please check all dependent tests after modifying it
#

########################################################################################
# This test verifies the options --sync-relay-log-info and --relay-log-recovery by 
# crashing the slave in two different situations:
#  (case-1) - Corrupt the relay log with changes which were not processed by
#  the SQL Thread and crashes it.
#  (case-2) - Corrupt the master.info with wrong coordinates and crashes it.
#
#  Case 1:
#    1 - Stops the SQL Thread
#    2 - Inserts new records into the master.
#    3 - Corrupts the relay-log.bin* which most likely has such changes.
#    4 - Crashes the slave
#    5 - Verifies if the slave is sync with the master which means that the information
#    loss was circumvented by the recovery process.
#
#  Case 2:
#    1 - Stops the SQL/IO Threads
#    2 - Inserts new records into the master.
#    3 - Corrupts the master.info with wrong coordinates.
#    4 - Crashes the slave
#    5 - Verifies if the slave is sync with the master which means that the information
#    loss was circumvented by the recovery process.
########################################################################################

########################################################################################
#                                Configuring the environment
########################################################################################
--echo =====Configuring the enviroment=======;
--source include/not_embedded.inc
--source include/not_valgrind.inc
--source include/have_debug.inc
--source include/have_innodb.inc
--source include/not_crashrep.inc
--source include/master-slave.inc

call mtr.add_suppression('Attempting backtrace');
call mtr.add_suppression("Recovery from master pos .* and file master-bin.000001");
# Use innodb so we do not get "table should be repaired" issues.
ALTER TABLE mysql.gtid_slave_pos ENGINE=InnoDB;
flush tables;
CREATE TABLE t1(a INT, PRIMARY KEY(a)) engine=innodb;

insert into t1(a) values(1);
insert into t1(a) values(2);
insert into t1(a) values(3);

########################################################################################
#                             Case 1: Corrupt a relay-log.bin*
########################################################################################
--echo =====Inserting data on the master but without the SQL Thread being running=======;
sync_slave_with_master;

connection slave;
let $MYSQLD_SLAVE_DATADIR= `select @@datadir`;
--replace_result $MYSQLD_SLAVE_DATADIR MYSQLD_SLAVE_DATADIR
--copy_file $MYSQLD_SLAVE_DATADIR/master.info $MYSQLD_SLAVE_DATADIR/master.backup
--source include/stop_slave_sql.inc

connection master;
insert into t1(a) values(4);
insert into t1(a) values(5);
insert into t1(a) values(6);

--echo =====Removing relay log files and crashing/recoverying the slave=======;
connection slave;
--source include/stop_slave_io.inc

let $file= query_get_value("SHOW SLAVE STATUS", Relay_Log_File, 1);

--let FILE_TO_CORRUPT= $MYSQLD_SLAVE_DATADIR/$file
perl;
$file= $ENV{'FILE_TO_CORRUPT'};
open(FILE, ">$file") || die "Unable to open $file.";
truncate(FILE,0);
print FILE "failure";
close ($file);
EOF

--exec echo "restart" > $MYSQLTEST_VARDIR/tmp/mysqld.2.expect
SET SESSION debug_dbug="d,crash_before_rotate_relaylog";
--error 2013
FLUSH LOGS;

--let $rpl_server_number= 2
--source include/rpl_reconnect.inc

--echo =====Dumping and comparing tables=======;
--source include/start_slave.inc

connection master;
sync_slave_with_master;

let $diff_tables=master:t1,slave:t1;
source include/diff_tables.inc;

########################################################################################
#                             Case 2: Corrupt a master.info
########################################################################################
--echo =====Corrupting the master.info=======;
connection slave;
--source include/stop_slave.inc

connection master;
FLUSH LOGS;

insert into t1(a) values(7);
insert into t1(a) values(8);
insert into t1(a) values(9);

connection slave;
let MYSQLD_SLAVE_DATADIR=`select @@datadir`;

--perl
use strict;
use warnings;
my $src= "$ENV{'MYSQLD_SLAVE_DATADIR'}/master.backup";
my $dst= "$ENV{'MYSQLD_SLAVE_DATADIR'}/master.info";
open(FILE, "<", $src) or die;
my @content= <FILE>;
close FILE;
open(FILE, ">", $dst) or die;
binmode FILE;
print FILE @content;
close FILE;
EOF

--exec echo "restart" > $MYSQLTEST_VARDIR/tmp/mysqld.2.expect
SET SESSION debug_dbug="d,crash_before_rotate_relaylog";
--error 2013
FLUSH LOGS;

--let $rpl_server_number= 2
--source include/rpl_reconnect.inc

--echo =====Dumping and comparing tables=======;
--source include/start_slave.inc

connection master;
sync_slave_with_master;

let $diff_tables=master:t1,slave:t1;
source include/diff_tables.inc;

########################################################################################
#                                      Clean up
########################################################################################
--echo =====Clean up=======;
connection master;
drop table t1;

--remove_file $MYSQLD_SLAVE_DATADIR/master.backup
--source include/rpl_end.inc

