/* BEGIN software license
 *
 * msXpertSuite - mass spectrometry software suite
 * -----------------------------------------------
 * Copyright(C) 2009,...,2018 Filippo Rusconi
 *
 * http://www.msxpertsuite.org
 *
 * This file is part of the msXpertSuite project.
 *
 * The msXpertSuite project is the successor of the massXpert project. This
 * project now includes various independent modules:
 *
 * - massXpert, model polymer chemistries and simulate mass spectrometric data;
 * - mineXpert, a powerful TIC chromatogram/mass spectrum viewer/miner;
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * END software license
 */


#ifndef MZ_CALCULATION_TREEVIEW_HPP
#define MZ_CALCULATION_TREEVIEW_HPP


/////////////////////// Qt includes
#include <QTreeView>


namespace msxps
{

	namespace massxpert
	{



class MzCalculationDlg;


class MzCalculationTreeView : public QTreeView
{
  Q_OBJECT

  private:
  MzCalculationDlg *mp_parentDlg;


  public:
  MzCalculationTreeView(QWidget *parent = 0);
  ~MzCalculationTreeView();

  MzCalculationDlg *getParentDlg();
  void setParentDlg(MzCalculationDlg *);

  public slots:
};

} // namespace massxpert

} // namespace msxps


#endif // MZ_CALCULATION_TREEVIEW_HPP
