"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing_extensions.final
class ChannelSettings(google.protobuf.message.Message):
    """
    This information can be encoded as a QRcode/url so that other users can configure
    their radio to join the same channel.
    A note about how channel names are shown to users: channelname-X
    poundsymbol is a prefix used to indicate this is a channel name (idea from @professr).
    Where X is a letter from A-Z (base 26) representing a hash of the PSK for this
    channel - so that if the user changes anything about the channel (which does
    force a new PSK) this letter will also change. Thus preventing user confusion if
    two friends try to type in a channel name of "BobsChan" and then can't talk
    because their PSKs will be different.
    The PSK is hashed into this letter by "0x41 + [xor all bytes of the psk ] modulo 26"
    This also allows the option of someday if people have the PSK off (zero), the
    users COULD type in a channel name and be able to talk.
    FIXME: Add description of multi-channel support and how primary vs secondary channels are used.
    FIXME: explain how apps use channels for security.
    explain how remote settings and remote gpio are managed as an example
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    CHANNEL_NUM_FIELD_NUMBER: builtins.int
    PSK_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    ID_FIELD_NUMBER: builtins.int
    UPLINK_ENABLED_FIELD_NUMBER: builtins.int
    DOWNLINK_ENABLED_FIELD_NUMBER: builtins.int
    MODULE_SETTINGS_FIELD_NUMBER: builtins.int
    channel_num: builtins.int
    """
    Deprecated in favor of LoraConfig.channel_num
    """
    psk: builtins.bytes
    """
    A simple pre-shared key for now for crypto.
    Must be either 0 bytes (no crypto), 16 bytes (AES128), or 32 bytes (AES256).
    A special shorthand is used for 1 byte long psks.
    These psks should be treated as only minimally secure,
    because they are listed in this source code.
    Those bytes are mapped using the following scheme:
    `0` = No crypto
    `1` = The special "default" channel key: {0xd4, 0xf1, 0xbb, 0x3a, 0x20, 0x29, 0x07, 0x59, 0xf0, 0xbc, 0xff, 0xab, 0xcf, 0x4e, 0x69, 0x01}
    `2` through 10 = The default channel key, except with 1 through 9 added to the last byte.
    Shown to user as simple1 through 10
    """
    name: builtins.str
    """
    A SHORT name that will be packed into the URL.
    Less than 12 bytes.
    Something for end users to call the channel
    If this is the empty string it is assumed that this channel
    is the special (minimally secure) "Default"channel.
    In user interfaces it should be rendered as a local language translation of "X".
    For channel_num hashing empty string will be treated as "X".
    Where "X" is selected based on the English words listed above for ModemPreset
    """
    id: builtins.int
    """
    Used to construct a globally unique channel ID.
    The full globally unique ID will be: "name.id" where ID is shown as base36.
    Assuming that the number of meshtastic users is below 20K (true for a long time)
    the chance of this 64 bit random number colliding with anyone else is super low.
    And the penalty for collision is low as well, it just means that anyone trying to decrypt channel messages might need to
    try multiple candidate channels.
    Any time a non wire compatible change is made to a channel, this field should be regenerated.
    There are a small number of 'special' globally known (and fairly) insecure standard channels.
    Those channels do not have a numeric id included in the settings, but instead it is pulled from
    a table of well known IDs.
    (see Well Known Channels FIXME)
    """
    uplink_enabled: builtins.bool
    """
    If true, messages on the mesh will be sent to the *public* internet by any gateway ndoe
    """
    downlink_enabled: builtins.bool
    """
    If true, messages seen on the internet will be forwarded to the local mesh.
    """
    @property
    def module_settings(self) -> global___ModuleSettings:
        """
        Per-channel module settings.
        """
    def __init__(
        self,
        *,
        channel_num: builtins.int = ...,
        psk: builtins.bytes = ...,
        name: builtins.str = ...,
        id: builtins.int = ...,
        uplink_enabled: builtins.bool = ...,
        downlink_enabled: builtins.bool = ...,
        module_settings: global___ModuleSettings | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["module_settings", b"module_settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["channel_num", b"channel_num", "downlink_enabled", b"downlink_enabled", "id", b"id", "module_settings", b"module_settings", "name", b"name", "psk", b"psk", "uplink_enabled", b"uplink_enabled"]) -> None: ...

global___ChannelSettings = ChannelSettings

@typing_extensions.final
class ModuleSettings(google.protobuf.message.Message):
    """
    This message is specifically for modules to store per-channel configuration data.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    POSITION_PRECISION_FIELD_NUMBER: builtins.int
    IS_CLIENT_MUTED_FIELD_NUMBER: builtins.int
    position_precision: builtins.int
    """
    Bits of precision for the location sent in position packets.
    """
    is_client_muted: builtins.bool
    """
    Controls whether or not the phone / clients should mute the current channel
    Useful for noisy public channels you don't necessarily want to disable
    """
    def __init__(
        self,
        *,
        position_precision: builtins.int = ...,
        is_client_muted: builtins.bool = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["is_client_muted", b"is_client_muted", "position_precision", b"position_precision"]) -> None: ...

global___ModuleSettings = ModuleSettings

@typing_extensions.final
class Channel(google.protobuf.message.Message):
    """
    A pair of a channel number, mode and the (sharable) settings for that channel
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Role:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _RoleEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[Channel._Role.ValueType], builtins.type):
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        DISABLED: Channel._Role.ValueType  # 0
        """
        This channel is not in use right now
        """
        PRIMARY: Channel._Role.ValueType  # 1
        """
        This channel is used to set the frequency for the radio - all other enabled channels must be SECONDARY
        """
        SECONDARY: Channel._Role.ValueType  # 2
        """
        Secondary channels are only used for encryption/decryption/authentication purposes.
        Their radio settings (freq etc) are ignored, only psk is used.
        """

    class Role(_Role, metaclass=_RoleEnumTypeWrapper):
        """
        How this channel is being used (or not).
        Note: this field is an enum to give us options for the future.
        In particular, someday we might make a 'SCANNING' option.
        SCANNING channels could have different frequencies and the radio would
        occasionally check that freq to see if anything is being transmitted.
        For devices that have multiple physical radios attached, we could keep multiple PRIMARY/SCANNING channels active at once to allow
        cross band routing as needed.
        If a device has only a single radio (the common case) only one channel can be PRIMARY at a time
        (but any number of SECONDARY channels can't be sent received on that common frequency)
        """

    DISABLED: Channel.Role.ValueType  # 0
    """
    This channel is not in use right now
    """
    PRIMARY: Channel.Role.ValueType  # 1
    """
    This channel is used to set the frequency for the radio - all other enabled channels must be SECONDARY
    """
    SECONDARY: Channel.Role.ValueType  # 2
    """
    Secondary channels are only used for encryption/decryption/authentication purposes.
    Their radio settings (freq etc) are ignored, only psk is used.
    """

    INDEX_FIELD_NUMBER: builtins.int
    SETTINGS_FIELD_NUMBER: builtins.int
    ROLE_FIELD_NUMBER: builtins.int
    index: builtins.int
    """
    The index of this channel in the channel table (from 0 to MAX_NUM_CHANNELS-1)
    (Someday - not currently implemented) An index of -1 could be used to mean "set by name",
    in which case the target node will find and set the channel by settings.name.
    """
    @property
    def settings(self) -> global___ChannelSettings:
        """
        The new settings, or NULL to disable that channel
        """
    role: global___Channel.Role.ValueType
    """
    TODO: REPLACE
    """
    def __init__(
        self,
        *,
        index: builtins.int = ...,
        settings: global___ChannelSettings | None = ...,
        role: global___Channel.Role.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["settings", b"settings"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["index", b"index", "role", b"role", "settings", b"settings"]) -> None: ...

global___Channel = Channel
