# Contributing

Material for MkDocs is an actively maintained and constantly evolving project
serving a diverse user base with versatile backgrounds and needs. In order to
efficiently address the requirements of all our users, evaluate change requests,
and fix bugs, we put in a lot of work.

Our ever-growing community includes many active users, who open new
issues and discussions several times a day, evolving our [issue tracker] and
[discussion board] into a knowledge base – an important addition to
our [documentation] – yielding value to both new and experienced users.

  [discussion board]: https://github.com/squidfunk/mkdocs-material/discussions
  [issue tracker]: https://github.com/squidfunk/mkdocs-material/issues
  [documentation]: https://squidfunk.github.io/mkdocs-material/

## How you can contribute

We understand that reporting bugs, raising change requests, as well as engaging
in discussions can be time-consuming, which is why we've carefully optimized our
issue templates and defined guidelines to improve the overall interaction
within the project. We've invested a lot of time and effort into making our
[issue tracker] and [discussion board] as efficient as possible.

Our goal is to ensure that our documentation, as well as issue tracker and
discussion board, are __well-structured__, __easy to navigate__, and
__searchable__, so you can find what you need quickly and efficiently. Thus,
when you follow our guidelines, we can help you much faster.

In this section, we guide your through our processes.

### Creating an issue

<div class="grid cards" markdown>

-   :material-bug-outline: &nbsp;
    __Something is not working?__

    ---

    Report a bug in Material for MkDocs by creating an issue with a
    reproduction

    ---

    [:octicons-arrow-right-24: Report a bug][report a bug]

-   :material-file-document-remove-outline: &nbsp;
    __Missing information in our docs?__

    ---

    Report missing information or potential inconsistencies in our
    documentation

    ---

    [:octicons-arrow-right-24: Report a docs issue][report a docs issue]

-   :material-lightbulb-on-20: &nbsp;
    __Want to submit an idea?__

    ---

    Propose a change, feature request, or suggest an improvement

    ---

    [:octicons-arrow-right-24: Request a change][request a change]

-   :material-account-question-outline: &nbsp;
    __Have a question or need help?__

    ---

    Ask a question on our [discussion board] and get in touch with our
    community

    ---

    [:octicons-arrow-right-24: Ask a question][discussion board]

</div>

### Contributing

<div class="grid cards" markdown>

-   :material-translate: &nbsp;
    __Missing support for your language?__

    ---

    Add or improve translations for a new or already supported language

    ---

    [:octicons-arrow-right-24: Add translations][add translations]

-   :material-source-pull: &nbsp;
    __Want to create a pull request?__

    ---

    Learn how to create a comprehensive and useful pull request (PR)

    ---

    [:octicons-arrow-right-24: Create a pull request][create a pull request]

</div>

  [report a bug]: reporting-a-bug.md
  [report a docs issue]: reporting-a-docs-issue.md
  [request a change]: requesting-a-change.md
  [add translations]: https://github.com/squidfunk/mkdocs-material/adding-translations
  [create a pull request]: making-a-pull-request.md

## Checklist

Before interacting within the project, please take a moment to consider the
following questions. By doing so, you can ensure that you are using the correct
issue template and that you provide all necessary information when interacting
with our community.

!!! warning "Issues, discussions, and comments are forever"

    Please note that everything you write is permanent and will remain
    for everyone to read – forever. Therefore, please always be nice and
    constructive, follow our contribution guidelines, and comply with our
    [Code of Conduct].

### Before creating an issue

- Are you using the appropriate issue template, or is there another issue
  template that better fits the context of your request?

- Have you checked if a similar bug report or change request has already been
  created, or have you stumbled upon something that might be related?

- Did your fill out every field as requested and did you provide all additional
  information we maintainers need to comprehend your request?

### Before asking a question

- Is the topic a question for our [discussion board], or is it a bug report or
  change request that should better be raised on our [issue tracker]?

- Is there an open discussion on the topic of your request? If the answer is yes,
  does your question match the direction of the discussion, or should you open a
  new discussion?

- Did your provide our community with all the necessary information to
  understand your question and help you quickly, or can you make it easier to
  help you?

### Before commenting

- Is your comment relevant to the topic of the current page, post, issue, or
  discussion, or is it a better idea to create a new issue or discussion?

- Does your comment add value to the conversation? Is it constructive and
  respectful to our community and us maintainers? Could you just use a
  [:octicons-smiley-16: reaction][reaction] instead?

  [Code of Conduct]: https://github.com/squidfunk/mkdocs-material/blob/master/CODE_OF_CONDUCT.md
  [reaction]: https://github.blog/2016-03-10-add-reactions-to-pull-requests-issues-and-comments/

## Rights and responsibilities

As maintainers, we are entrusted with the __responsibility__ to moderate
communication within our community, including the authority to close, remove,
reject, or edit issues, discussions, comments, commits, and to block users who
__do not align__ with our contribution guidelines and our [Code of Conduct].
This role requires us to be actively involved in maintaining the integrity and
positive atmosphere of our community. Upholding these standards decisively
ensures a respectful and inclusive environment for all members.


### Code of Conduct

Our [Code of Conduct] outlines the expectation for all community members to
treat one another with respect, employing inclusive and welcoming language. Our
commitment is to foster a positive and supportive environment, free of
inappropriate, offensive, or harmful behavior.

We take any violations seriously and will take appropriate action in response to
uphold these values.[^1]

  [^1]:
    __Warning and blocking policy:__
    Given the increasing popularity of our project and our commitment to a
    healthy community, we've defined clear guidelines on how we proceed with
    violations:

    1.1. __First warning:__ Users displaying repeated inappropriate, offensive,
    or harmful behavior will receive a first warning. This warning serves as a
    formal notice that their behavior is not in alignment with our community
    standards and Code of Conduct. The first warning is permanent.

    1.2. __Second warning and opportunity for resolution:__ If the behavior
    persists, a second warning will be issued. Upon receiving the second
    warning, the user will be given a 5-day period for reflection, during which
    they are encouraged to publicly explain or apologize for their actions.
    This period is designed to offer an opportunity for openly clearing out any
    misunderstanding.

    1.3. __Blocking:__ Should there be no response or improvement in behavior
    following the second warning, we reserve the right to block the user from
    the community and repository. Blocking is considered a last resort, used
    only when absolutely necessary to protect the community's integrity and
    positive atmosphere.

    Blocking has been an exceptionally rare necessity in our overwhelmingly
    positive community, highlighting our preference for constructive dialogue
    and mutual respect. It aims to protect our community members and team.

### Incomplete issues and duplicates

We have invested significant time and effort in the setup of our contribution
process, ensuring that we assess the essential requirements for reviewing and
responding to issues effectively. Each field in our issue templates is
thoughtfully designed to help us fully understand your concerns and the nature
of your matter. We encourage all members to utilize the search function before
submitting new issues or starting discussions to help avoid duplicates. Your
cooperation is crucial in keeping our community's discussions constructive and
organized.

  - __Mandatory completion of issue templates:__ We need all of the information
  required in our issue templates because it ensures that every user and
  maintainer, regardless of their experience, can understand the content and
  severity of your bug report or change request.

  - __Closing incomplete issues:__
  We _reserve the right to close issues lacking essential information_, such as
  but not limited to [minimal reproductions] or those not adhering to the
  quality standards and requirements specified in our issue templates. Such
  issues can be reopened once the missing information has been provided.

  - __Handling duplicates:__ To maintain organized and efficient
  communication within our [issue tracker] and [discussion board], we
  _reserve the right to close any duplicated issues or lock duplicated
  discussions_. Opening multiple channels to ask the same question or report the
  same issue across different forums hinders our ability to manage and address
  community concerns effectively. This approach is vital for efficient time
  management, as duplicated questions can consume the time of multiple team
  members simultaneously. Ensuring that each issue or discussion is unique and
  progresses with new information helps us to maintain focus and support our
  community.

    We further _reserve the right to immediately close discussions or issues that
    are reopened without providing new information_ or simply because users have
    not yet received a response to their issue/question, as the issue is marked as
    incomplete.

  - __Limitations of automated tools:__  While we believe in the value and
  efficiency that automated tools bring to identifying potential issues (such
  as those identified by Lighthouse, Accessibility tools, and others), simply
  submitting an issue generated by these tools does not constitute a complete
  bug report. These tools sometimes produce verbose outputs and may include
  false positives, which necessitate a critical evaluation. You are of course
  welcome to attach generated reports to your issue. However, this does not
  substitute the requirement for a minimal reproduction or a thorough discussion
  of the findings. _We reserve the right to mark these issues as incomplete and
  close them._ This practice ensures that we are addressing genuine concerns
  with precision and clarity, rather than navigating through extensive automated
  outputs.

  [minimal reproductions]: ../guides/creating-a-reproduction.md
