#include <map>
#include <algorithm>
#include <functional>
#include <memory>
#include <stdexcept>
#include <string>

#include <pybind11/pybind11.h>

typedef std::function< pybind11::module & (std::string const &) > ModuleGetter;

void bind_std_chrono(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_core_Clock(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_core_Stringifyable(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_std_array(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_std_stl_vector(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_std_stl_deque(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_std_stl_deque_1(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_std_stl_deque_2(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_core_WorkerThreadsPool(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_core_backtrace(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_core_bits_math(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_core_bits_math_1(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_core_cpu(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_core_cpu_1(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_core_reverse_bytes(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_core_round(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_random_RandomGenerators(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_io_CStream(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_io_CFileInputStream(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_io_CFileStream(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_core_format(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_core_safe_pointers(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_core_safe_pointers_1(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_io_CMemoryStream(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_io_CTextFileLinesParser(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_io_zip(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_core_aligned_allocator(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_typemeta_static_string(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_rtti_CObject(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_rtti_CObject_1(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_rtti_CObject_2(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_rtti_CObject_3(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_serialization_CSerializable(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_std_stl_multimap(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_std_stl_map(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_typemeta_TEnumType(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_typemeta_TEnumType_1(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_typemeta_TEnumType_2(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_typemeta_TEnumType_3(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_typemeta_TEnumType_4(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_typemeta_TEnumType_5(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_typemeta_TEnumType_6(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_serialization_CArchive(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_serialization_CArchive_1(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_serialization_CArchive_2(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_unknown_unknown(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_config_CLoadableOptions(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_system_CTicTac(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_system_os(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_system_os_1(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_bayes_CParticleFilter(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_bayes_CParticleFilterCapable(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_system_datetime(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_CAction(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_TPoseOrPoint(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_TPoint3D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_homog_matrices(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_CPoseOrPoint(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_CPoseOrPoint_1(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_CPoseOrPoint_2(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_CPose2D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_CProbabilityDensityFunction(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_CProbabilityDensityFunction_1(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_CPosePDF(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_CActionRobotMovement2D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_CQuaternion(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_system_string_utils(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_CPose3D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_CPose3DPDF(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_CPose3DPDFGaussian(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_CActionCollection(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_wrap2pi(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_CObservation(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_system_mrptEvent(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_CMetricMapEvents(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_metric_map_types(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_Visualizable(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_system_CObservable(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_tfest_TMatchingPair(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_CMetricMap(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_CMetricMap_1(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_CSensoryFrame(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_apps_BaseAppDataSource(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_config_CConfigFileBase(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_hwdrivers_CGenericSensor(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_apps_ICP_SLAM_App(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_Lie_Euclidean(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_TPose2D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_Lie_SE(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_CPoseInterpolatorBase(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_CPose2DInterpolator(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_apps_MonteCarloLocalization_App(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_img_TColor(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_img_CCanvas(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_CMultiMetricMap(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_bayes_CProbabilityParticle(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_bayes_CParticleFilterData(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_bayes_CParticleFilterData_1(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_CPose3DPDFParticles(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_img_color_maps(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_TBoundingBox(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_T2DScanProperties(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_PLY_import_export(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_CPointsMap(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_CPointsMap_1(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_slam_CMetricMapsAlignmentAlgorithm(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_slam_TKLDParams(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_CMultiMetricMapPDF(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_rtti_CListOfClasses(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_slam_CMetricMapBuilder(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_apps_RBPF_SLAM_App(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_comms_CClientTCPSocket(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_comms_CServerTCPSocket(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_containers_CommentPosition(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_containers_yaml(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_comms_net_utils(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_config_CConfigFile(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_expr_CRuntimeCompiledExpression(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_gui_keycodes(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_img_TPixelCoord(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_gui_CBaseGUIWindow(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_img_DistortionModel(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_img_TCamera(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_img_CImage(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_gui_CDisplayWindow(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_DefaultShaders(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_CRenderizable(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_CCamera(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_TSegment2D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_TSegment3D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_Buffer(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_CSetOfObjects(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_TPolygon3D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_TTriangle(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_TPlane(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_TPolygon2D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_TPolygonWithPlane(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_Texture(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_CTexturedPlane(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_Viewport(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_gui_CDisplayWindow3D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_gui_CDisplayWindow3D_1(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_gui_CGlCanvasBase(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_nanogui_common(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_nanogui_common_1(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_nanogui_glcanvas(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_gui_MRPT2NanoguiGLCanvas(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_CPolygon(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_CObservation2DRangeScan(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_hwdrivers_C2DRangeFinderAbstract(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_containers_circular_buffer(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_comms_CInterfaceFTDI(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_CObservationGasSensors(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_hwdrivers_CBoardENoses(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_CObservationRange(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_CObservationCANBusJ1939(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_hwdrivers_CCANBusReader(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_CObservationIMU(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_TPose3DQuat(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_img_TStereoCamera(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_CPoint(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_CPose3DQuat(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_CObservationStereoImages(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_vision_CStereoRectifyMap(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_hwdrivers_CDUO3DCamera(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_CMatrixDynamic(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_CMatrixFixed(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_CMatrixFixed_1(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_CMatrixFixed_2(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_CMatrixFixed_3(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_CMatrixFixed_4(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_math_frwds(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_bayes_CProbabilityParticle_1(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_CMatrixF(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_CObservationImage(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_hwdrivers_CImageGrabber_FlyCapture2(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_hwdrivers_CImageGrabber_dc1394(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_T3DPointsProjectionParams(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_core_integer_select(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_TPixelLabelInfo(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_CObservation3DRangeScan(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_hwdrivers_CKinect(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_hwdrivers_CMyntEyeCamera(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_hwdrivers_CStereoGrabber_Bumblebee_libdc1394(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_hwdrivers_CCameraSensor(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_gnss_messages_type_list(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_unknown_unknown_1(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_unknown_unknown_2(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_unknown_unknown_3(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_unknown_unknown_4(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_unknown_unknown_5(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_unknown_unknown_6(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_unknown_unknown_7(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_unknown_unknown_8(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_CObservationGPS(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_hwdrivers_CGPSInterface(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_containers_MT_buffer(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_hwdrivers_CNTRIPClient(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_CObservationWindSensor(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_hwdrivers_CGillAnemometer(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_hwdrivers_CIMUXSens_MT4(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_CObservationRFID(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_hwdrivers_CImpinjRFID(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_io_CPipe(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_CObservationRawDAQ(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_hwdrivers_CNationalInstrumentsDAQ(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_CObservationRGBD360(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_hwdrivers_COpenNI2_RGBD360(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_hwdrivers_CPtuDPerception(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_hwdrivers_CRaePID(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_serialization_CMessage(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_hwdrivers_CSICKTim561Eth_2050101(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_CObservationSkeleton(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_hwdrivers_CSkeletonTracker(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_VelodyneCalibration(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_hwdrivers_CVelodyneScanner(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_CObservationWirelessPower(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_hwdrivers_CWirelessPower(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_kinematics_CKinematicChain(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_kinematics_CVehicleVelCmd(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_kinematics_CVehicleVelCmd_DiffDriven(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_CPointPDF(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_CMatrixDynamic_1(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_CPointPDFSOG(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_CBeacon(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_COctoMapVoxels(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_COctoMapBase(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_COctoMapBase_1(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_CColouredOctoMap(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_CColouredPointsMap(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_containers_CDynamicGrid(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_containers_CDynamicGrid_1(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_containers_CDynamicGrid_2(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_system_CTimeLogger(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_graphs_ScalarFactorGraph(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_CRandomFieldGridMap2D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_CGasConcentrationGridMap2D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_TLine3D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_TObject3D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_CHeightGridMap2D_Base(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_CHeightGridMap2D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_CHeightGridMap2D_MRF(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_CLogOddsGridMapLUT(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_containers_CDynamicGrid3D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_CLogOddsGridMap3D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_CObservation2DRangeScanWithUncertainty(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_CPosePDFGaussian(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_COccupancyGridMap2D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_COccupancyGridMap3D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_COctoMap(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_CSimplePointsMap(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_CPointCloudFilterByDistance(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_CPointsMapXYZI(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_CRandomFieldGridMap3D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_CReflectivityGridMap2D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_CWeightedPointsMap(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_CWirelessPowerGridMap2D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_CObservationPointCloud(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_CBox(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_COctreePointRenderer(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_CPointCloudColoured(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_customizable_obs_viz(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_CMatrixB(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_epsilon(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_geometry(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_geometry_1(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_geometry_2(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_CSetOfTriangles(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_CPlanarLaserScan(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_CAtan2LookUpTable(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_ops_containers(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_TTwist3D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_data_utils(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_fresnel(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_nav_holonomic_ClearanceDiagram(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_nav_tpspace_CParameterizedTrajectoryGenerator(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_nav_holonomic_CHolonomicFullEval(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_nav_holonomic_CHolonomicND(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_nav_holonomic_CHolonomicVFF(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_CGridPlaneXY(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_CPointCloud(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_stock_objects(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_containers_traits_map(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_graphs_CDirectedTree(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_nav_planners_TMoveTree(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_FrameTransformer(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_nav_reactive_CAbstractNavigator(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_nav_reactive_CLogFileRecord(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_nav_reactive_TWaypoint(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_nav_reactive_CAbstractPTGBasedReactive(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_nav_reactive_CMultiObjMotionOpt_Scalarization(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_nav_reactive_CReactiveNavigationSystem3D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_nav_tpspace_CPTG_DiffDrive_C(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_nav_tpspace_CPTG_DiffDrive_alpha(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_CActionRobotMovement3D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_CObservationBatteryState(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_CObservationOdometry(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_CRawlog(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_format_externals_filename(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_obs_stock_observations(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_CArrow(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_CAxis(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_CGeneralizedEllipsoidTemplate(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_CGridPlaneXZ(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_CMesh3D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_CSphere(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_CEllipsoidRangeBearing2D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_CUBE_TEXTURE_FACE(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_opengl_CVectorField3D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_CPoint2D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_CPose2DGridTemplate(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_CPose3DPDFGaussianInf(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_CPose3DPDFSOG(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_CPose3DQuatPDFGaussian(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_CPose3DQuatPDFGaussianInf(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_CPosePDFGrid(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_CPoses2DSequence(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_Lie_SO(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_poses_SO_SE_average(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_vision_types(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_vision_types_1(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_vision_TKeyPoint(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_CLandmark(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_vision_chessboard_camera_calib(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_maps_CLandmarksMap(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_system_CObserver(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_slam_COccupancyGridMapFeatureExtractor(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_slam_CIncrementalMapPartitioner(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_slam_CMetricMapBuilderICP(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_slam_CMonteCarloLocalization3D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_bayes_CKalmanFilterCapable(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_containers_bimap(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_slam_data_association(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_slam_CRangeBearingKFSLAM(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_bayes_CRejectionSamplingCapable(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_slam_CRejectionSamplingRangeOnlyLocalization(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_system_CRateTimer(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_system_crc(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_system_scheduler(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_tfest_indivcompatdecls(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_topography_data_types(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_topography_data_types_1(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_topography_conversions(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_TPoint2D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_TPoint3D_1(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_TTwist2D(std::function< pybind11::module &(std::string const &namespace_) > &M);
void bind_mrpt_math_CVectorDynamic(std::function< pybind11::module &(std::string const &namespace_) > &M);


PYBIND11_MODULE(pymrpt, root_module) {
	root_module.doc() = "pymrpt module";

	std::map <std::string, pybind11::module> modules;
	ModuleGetter M = [&](std::string const &namespace_) -> pybind11::module & {
		auto it = modules.find(namespace_);
		if( it == modules.end() ) throw std::runtime_error("Attempt to access pybind11::module for namespace " + namespace_ + " before it was created!!!");
		return it->second;
	};

	modules[""] = root_module;

	static std::vector<std::string> const reserved_python_words {"nonlocal", "global", };

	auto mangle_namespace_name(
		[](std::string const &ns) -> std::string {
			if ( std::find(reserved_python_words.begin(), reserved_python_words.end(), ns) == reserved_python_words.end() ) return ns;
			else return ns+'_';
		}
	);

	std::vector< std::pair<std::string, std::string> > sub_modules {
		{"", "mrpt"},
		{"mrpt", "apps"},
		{"mrpt", "bayes"},
		{"mrpt", "comms"},
		{"mrpt::comms", "net"},
		{"mrpt", "config"},
		{"mrpt", "containers"},
		{"mrpt", "cpu"},
		{"mrpt", "expr"},
		{"mrpt", "global_settings"},
		{"mrpt", "graphs"},
		{"mrpt", "gui"},
		{"mrpt", "hwdrivers"},
		{"mrpt", "img"},
		{"mrpt", "io"},
		{"mrpt::io", "zip"},
		{"mrpt", "kinematics"},
		{"mrpt", "maps"},
		{"mrpt", "math"},
		{"mrpt", "nav"},
		{"mrpt", "obs"},
		{"mrpt::obs", "gnss"},
		{"mrpt::obs::gnss", "nv_oem6_ins_status_type"},
		{"mrpt::obs::gnss", "nv_oem6_position_type"},
		{"mrpt::obs::gnss", "nv_oem6_solution_status"},
		{"mrpt::obs", "stock_observations"},
		{"mrpt", "opengl"},
		{"mrpt::opengl", "stock_objects"},
		{"mrpt", "poses"},
		{"mrpt::poses", "Lie"},
		{"mrpt", "pymrpt_internal"},
		{"mrpt", "random"},
		{"mrpt", "rtti"},
		{"mrpt::rtti", "internal"},
		{"mrpt", "serialization"},
		{"mrpt", "slam"},
		{"mrpt", "system"},
		{"mrpt::system", "os"},
		{"mrpt", "tfest"},
		{"mrpt", "topography"},
		{"mrpt", "typemeta"},
		{"mrpt::typemeta", "internal"},
		{"mrpt", "vision"},
		{"", "nanogui"},
		{"", "std"},
		{"std", "chrono"},
	};
	for(auto &p : sub_modules ) modules[p.first.size() ? p.first+"::"+p.second : p.second] = modules[p.first].def_submodule( mangle_namespace_name(p.second).c_str(), ("Bindings for " + p.first + "::" + p.second + " namespace").c_str() );

	//pybind11::class_<std::shared_ptr<void>>(M(""), "_encapsulated_data_");

	bind_std_chrono(M);
	bind_mrpt_core_Clock(M);
	bind_mrpt_core_Stringifyable(M);
	bind_std_array(M);
	bind_std_stl_vector(M);
	bind_std_stl_deque(M);
	bind_std_stl_deque_1(M);
	bind_std_stl_deque_2(M);
	bind_mrpt_core_WorkerThreadsPool(M);
	bind_mrpt_core_backtrace(M);
	bind_mrpt_core_bits_math(M);
	bind_mrpt_core_bits_math_1(M);
	bind_mrpt_core_cpu(M);
	bind_mrpt_core_cpu_1(M);
	bind_mrpt_core_reverse_bytes(M);
	bind_mrpt_core_round(M);
	bind_mrpt_random_RandomGenerators(M);
	bind_mrpt_io_CStream(M);
	bind_mrpt_io_CFileInputStream(M);
	bind_mrpt_io_CFileStream(M);
	bind_mrpt_core_format(M);
	bind_mrpt_core_safe_pointers(M);
	bind_mrpt_core_safe_pointers_1(M);
	bind_mrpt_io_CMemoryStream(M);
	bind_mrpt_io_CTextFileLinesParser(M);
	bind_mrpt_io_zip(M);
	bind_mrpt_core_aligned_allocator(M);
	bind_mrpt_typemeta_static_string(M);
	bind_mrpt_rtti_CObject(M);
	bind_mrpt_rtti_CObject_1(M);
	bind_mrpt_rtti_CObject_2(M);
	bind_mrpt_rtti_CObject_3(M);
	bind_mrpt_serialization_CSerializable(M);
	bind_std_stl_multimap(M);
	bind_std_stl_map(M);
	bind_mrpt_typemeta_TEnumType(M);
	bind_mrpt_typemeta_TEnumType_1(M);
	bind_mrpt_typemeta_TEnumType_2(M);
	bind_mrpt_typemeta_TEnumType_3(M);
	bind_mrpt_typemeta_TEnumType_4(M);
	bind_mrpt_typemeta_TEnumType_5(M);
	bind_mrpt_typemeta_TEnumType_6(M);
	bind_mrpt_serialization_CArchive(M);
	bind_mrpt_serialization_CArchive_1(M);
	bind_mrpt_serialization_CArchive_2(M);
	bind_unknown_unknown(M);
	bind_mrpt_config_CLoadableOptions(M);
	bind_mrpt_system_CTicTac(M);
	bind_mrpt_system_os(M);
	bind_mrpt_system_os_1(M);
	bind_mrpt_bayes_CParticleFilter(M);
	bind_mrpt_bayes_CParticleFilterCapable(M);
	bind_mrpt_system_datetime(M);
	bind_mrpt_obs_CAction(M);
	bind_mrpt_math_TPoseOrPoint(M);
	bind_mrpt_math_TPoint3D(M);
	bind_mrpt_math_homog_matrices(M);
	bind_mrpt_poses_CPoseOrPoint(M);
	bind_mrpt_poses_CPoseOrPoint_1(M);
	bind_mrpt_poses_CPoseOrPoint_2(M);
	bind_mrpt_poses_CPose2D(M);
	bind_mrpt_math_CProbabilityDensityFunction(M);
	bind_mrpt_math_CProbabilityDensityFunction_1(M);
	bind_mrpt_poses_CPosePDF(M);
	bind_mrpt_obs_CActionRobotMovement2D(M);
	bind_mrpt_math_CQuaternion(M);
	bind_mrpt_system_string_utils(M);
	bind_mrpt_poses_CPose3D(M);
	bind_mrpt_poses_CPose3DPDF(M);
	bind_mrpt_poses_CPose3DPDFGaussian(M);
	bind_mrpt_obs_CActionCollection(M);
	bind_mrpt_math_wrap2pi(M);
	bind_mrpt_obs_CObservation(M);
	bind_mrpt_system_mrptEvent(M);
	bind_mrpt_maps_CMetricMapEvents(M);
	bind_mrpt_maps_metric_map_types(M);
	bind_mrpt_opengl_Visualizable(M);
	bind_mrpt_system_CObservable(M);
	bind_mrpt_tfest_TMatchingPair(M);
	bind_mrpt_maps_CMetricMap(M);
	bind_mrpt_maps_CMetricMap_1(M);
	bind_mrpt_obs_CSensoryFrame(M);
	bind_mrpt_apps_BaseAppDataSource(M);
	bind_mrpt_config_CConfigFileBase(M);
	bind_mrpt_hwdrivers_CGenericSensor(M);
	bind_mrpt_apps_ICP_SLAM_App(M);
	bind_mrpt_poses_Lie_Euclidean(M);
	bind_mrpt_math_TPose2D(M);
	bind_mrpt_poses_Lie_SE(M);
	bind_mrpt_poses_CPoseInterpolatorBase(M);
	bind_mrpt_poses_CPose2DInterpolator(M);
	bind_mrpt_apps_MonteCarloLocalization_App(M);
	bind_mrpt_img_TColor(M);
	bind_mrpt_img_CCanvas(M);
	bind_mrpt_maps_CMultiMetricMap(M);
	bind_mrpt_bayes_CProbabilityParticle(M);
	bind_mrpt_bayes_CParticleFilterData(M);
	bind_mrpt_bayes_CParticleFilterData_1(M);
	bind_mrpt_poses_CPose3DPDFParticles(M);
	bind_mrpt_img_color_maps(M);
	bind_mrpt_math_TBoundingBox(M);
	bind_mrpt_obs_T2DScanProperties(M);
	bind_mrpt_opengl_PLY_import_export(M);
	bind_mrpt_maps_CPointsMap(M);
	bind_mrpt_maps_CPointsMap_1(M);
	bind_mrpt_slam_CMetricMapsAlignmentAlgorithm(M);
	bind_mrpt_slam_TKLDParams(M);
	bind_mrpt_maps_CMultiMetricMapPDF(M);
	bind_mrpt_rtti_CListOfClasses(M);
	bind_mrpt_slam_CMetricMapBuilder(M);
	bind_mrpt_apps_RBPF_SLAM_App(M);
	bind_mrpt_comms_CClientTCPSocket(M);
	bind_mrpt_comms_CServerTCPSocket(M);
	bind_mrpt_containers_CommentPosition(M);
	bind_mrpt_containers_yaml(M);
	bind_mrpt_comms_net_utils(M);
	bind_mrpt_config_CConfigFile(M);
	bind_mrpt_expr_CRuntimeCompiledExpression(M);
	bind_mrpt_gui_keycodes(M);
	bind_mrpt_img_TPixelCoord(M);
	bind_mrpt_gui_CBaseGUIWindow(M);
	bind_mrpt_img_DistortionModel(M);
	bind_mrpt_img_TCamera(M);
	bind_mrpt_img_CImage(M);
	bind_mrpt_gui_CDisplayWindow(M);
	bind_mrpt_opengl_DefaultShaders(M);
	bind_mrpt_opengl_CRenderizable(M);
	bind_mrpt_opengl_CCamera(M);
	bind_mrpt_math_TSegment2D(M);
	bind_mrpt_math_TSegment3D(M);
	bind_mrpt_opengl_Buffer(M);
	bind_mrpt_opengl_CSetOfObjects(M);
	bind_mrpt_math_TPolygon3D(M);
	bind_mrpt_opengl_TTriangle(M);
	bind_mrpt_math_TPlane(M);
	bind_mrpt_math_TPolygon2D(M);
	bind_mrpt_math_TPolygonWithPlane(M);
	bind_mrpt_opengl_Texture(M);
	bind_mrpt_opengl_CTexturedPlane(M);
	bind_mrpt_opengl_Viewport(M);
	bind_mrpt_gui_CDisplayWindow3D(M);
	bind_mrpt_gui_CDisplayWindow3D_1(M);
	bind_mrpt_gui_CGlCanvasBase(M);
	bind_nanogui_common(M);
	bind_nanogui_common_1(M);
	bind_nanogui_glcanvas(M);
	bind_mrpt_gui_MRPT2NanoguiGLCanvas(M);
	bind_mrpt_math_CPolygon(M);
	bind_mrpt_obs_CObservation2DRangeScan(M);
	bind_mrpt_hwdrivers_C2DRangeFinderAbstract(M);
	bind_mrpt_containers_circular_buffer(M);
	bind_mrpt_comms_CInterfaceFTDI(M);
	bind_mrpt_obs_CObservationGasSensors(M);
	bind_mrpt_hwdrivers_CBoardENoses(M);
	bind_mrpt_obs_CObservationRange(M);
	bind_mrpt_obs_CObservationCANBusJ1939(M);
	bind_mrpt_hwdrivers_CCANBusReader(M);
	bind_mrpt_obs_CObservationIMU(M);
	bind_mrpt_math_TPose3DQuat(M);
	bind_mrpt_img_TStereoCamera(M);
	bind_mrpt_poses_CPoint(M);
	bind_mrpt_poses_CPose3DQuat(M);
	bind_mrpt_obs_CObservationStereoImages(M);
	bind_mrpt_vision_CStereoRectifyMap(M);
	bind_mrpt_hwdrivers_CDUO3DCamera(M);
	bind_mrpt_math_CMatrixDynamic(M);
	bind_mrpt_math_CMatrixFixed(M);
	bind_mrpt_math_CMatrixFixed_1(M);
	bind_mrpt_math_CMatrixFixed_2(M);
	bind_mrpt_math_CMatrixFixed_3(M);
	bind_mrpt_math_CMatrixFixed_4(M);
	bind_mrpt_math_math_frwds(M);
	bind_mrpt_bayes_CProbabilityParticle_1(M);
	bind_mrpt_math_CMatrixF(M);
	bind_mrpt_obs_CObservationImage(M);
	bind_mrpt_hwdrivers_CImageGrabber_FlyCapture2(M);
	bind_mrpt_hwdrivers_CImageGrabber_dc1394(M);
	bind_mrpt_obs_T3DPointsProjectionParams(M);
	bind_mrpt_core_integer_select(M);
	bind_mrpt_obs_TPixelLabelInfo(M);
	bind_mrpt_obs_CObservation3DRangeScan(M);
	bind_mrpt_hwdrivers_CKinect(M);
	bind_mrpt_hwdrivers_CMyntEyeCamera(M);
	bind_mrpt_hwdrivers_CStereoGrabber_Bumblebee_libdc1394(M);
	bind_mrpt_hwdrivers_CCameraSensor(M);
	bind_mrpt_obs_gnss_messages_type_list(M);
	bind_unknown_unknown_1(M);
	bind_unknown_unknown_2(M);
	bind_unknown_unknown_3(M);
	bind_unknown_unknown_4(M);
	bind_unknown_unknown_5(M);
	bind_unknown_unknown_6(M);
	bind_unknown_unknown_7(M);
	bind_unknown_unknown_8(M);
	bind_mrpt_obs_CObservationGPS(M);
	bind_mrpt_hwdrivers_CGPSInterface(M);
	bind_mrpt_containers_MT_buffer(M);
	bind_mrpt_hwdrivers_CNTRIPClient(M);
	bind_mrpt_obs_CObservationWindSensor(M);
	bind_mrpt_hwdrivers_CGillAnemometer(M);
	bind_mrpt_hwdrivers_CIMUXSens_MT4(M);
	bind_mrpt_obs_CObservationRFID(M);
	bind_mrpt_hwdrivers_CImpinjRFID(M);
	bind_mrpt_io_CPipe(M);
	bind_mrpt_obs_CObservationRawDAQ(M);
	bind_mrpt_hwdrivers_CNationalInstrumentsDAQ(M);
	bind_mrpt_obs_CObservationRGBD360(M);
	bind_mrpt_hwdrivers_COpenNI2_RGBD360(M);
	bind_mrpt_hwdrivers_CPtuDPerception(M);
	bind_mrpt_hwdrivers_CRaePID(M);
	bind_mrpt_serialization_CMessage(M);
	bind_mrpt_hwdrivers_CSICKTim561Eth_2050101(M);
	bind_mrpt_obs_CObservationSkeleton(M);
	bind_mrpt_hwdrivers_CSkeletonTracker(M);
	bind_mrpt_obs_VelodyneCalibration(M);
	bind_mrpt_hwdrivers_CVelodyneScanner(M);
	bind_mrpt_obs_CObservationWirelessPower(M);
	bind_mrpt_hwdrivers_CWirelessPower(M);
	bind_mrpt_kinematics_CKinematicChain(M);
	bind_mrpt_kinematics_CVehicleVelCmd(M);
	bind_mrpt_kinematics_CVehicleVelCmd_DiffDriven(M);
	bind_mrpt_poses_CPointPDF(M);
	bind_mrpt_math_CMatrixDynamic_1(M);
	bind_mrpt_poses_CPointPDFSOG(M);
	bind_mrpt_maps_CBeacon(M);
	bind_mrpt_opengl_COctoMapVoxels(M);
	bind_mrpt_maps_COctoMapBase(M);
	bind_mrpt_maps_COctoMapBase_1(M);
	bind_mrpt_maps_CColouredOctoMap(M);
	bind_mrpt_maps_CColouredPointsMap(M);
	bind_mrpt_containers_CDynamicGrid(M);
	bind_mrpt_containers_CDynamicGrid_1(M);
	bind_mrpt_containers_CDynamicGrid_2(M);
	bind_mrpt_system_CTimeLogger(M);
	bind_mrpt_graphs_ScalarFactorGraph(M);
	bind_mrpt_maps_CRandomFieldGridMap2D(M);
	bind_mrpt_maps_CGasConcentrationGridMap2D(M);
	bind_mrpt_math_TLine3D(M);
	bind_mrpt_math_TObject3D(M);
	bind_mrpt_maps_CHeightGridMap2D_Base(M);
	bind_mrpt_maps_CHeightGridMap2D(M);
	bind_mrpt_maps_CHeightGridMap2D_MRF(M);
	bind_mrpt_maps_CLogOddsGridMapLUT(M);
	bind_mrpt_containers_CDynamicGrid3D(M);
	bind_mrpt_maps_CLogOddsGridMap3D(M);
	bind_mrpt_obs_CObservation2DRangeScanWithUncertainty(M);
	bind_mrpt_poses_CPosePDFGaussian(M);
	bind_mrpt_maps_COccupancyGridMap2D(M);
	bind_mrpt_maps_COccupancyGridMap3D(M);
	bind_mrpt_maps_COctoMap(M);
	bind_mrpt_maps_CSimplePointsMap(M);
	bind_mrpt_maps_CPointCloudFilterByDistance(M);
	bind_mrpt_maps_CPointsMapXYZI(M);
	bind_mrpt_maps_CRandomFieldGridMap3D(M);
	bind_mrpt_maps_CReflectivityGridMap2D(M);
	bind_mrpt_maps_CWeightedPointsMap(M);
	bind_mrpt_maps_CWirelessPowerGridMap2D(M);
	bind_mrpt_obs_CObservationPointCloud(M);
	bind_mrpt_opengl_CBox(M);
	bind_mrpt_opengl_COctreePointRenderer(M);
	bind_mrpt_opengl_CPointCloudColoured(M);
	bind_mrpt_obs_customizable_obs_viz(M);
	bind_mrpt_math_CMatrixB(M);
	bind_mrpt_math_epsilon(M);
	bind_mrpt_math_geometry(M);
	bind_mrpt_math_geometry_1(M);
	bind_mrpt_math_geometry_2(M);
	bind_mrpt_opengl_CSetOfTriangles(M);
	bind_mrpt_opengl_CPlanarLaserScan(M);
	bind_mrpt_math_CAtan2LookUpTable(M);
	bind_mrpt_math_ops_containers(M);
	bind_mrpt_math_TTwist3D(M);
	bind_mrpt_math_data_utils(M);
	bind_mrpt_math_fresnel(M);
	bind_mrpt_nav_holonomic_ClearanceDiagram(M);
	bind_mrpt_nav_tpspace_CParameterizedTrajectoryGenerator(M);
	bind_mrpt_nav_holonomic_CHolonomicFullEval(M);
	bind_mrpt_nav_holonomic_CHolonomicND(M);
	bind_mrpt_nav_holonomic_CHolonomicVFF(M);
	bind_mrpt_opengl_CGridPlaneXY(M);
	bind_mrpt_opengl_CPointCloud(M);
	bind_mrpt_opengl_stock_objects(M);
	bind_mrpt_containers_traits_map(M);
	bind_mrpt_graphs_CDirectedTree(M);
	bind_mrpt_nav_planners_TMoveTree(M);
	bind_mrpt_poses_FrameTransformer(M);
	bind_mrpt_nav_reactive_CAbstractNavigator(M);
	bind_mrpt_nav_reactive_CLogFileRecord(M);
	bind_mrpt_nav_reactive_TWaypoint(M);
	bind_mrpt_nav_reactive_CAbstractPTGBasedReactive(M);
	bind_mrpt_nav_reactive_CMultiObjMotionOpt_Scalarization(M);
	bind_mrpt_nav_reactive_CReactiveNavigationSystem3D(M);
	bind_mrpt_nav_tpspace_CPTG_DiffDrive_C(M);
	bind_mrpt_nav_tpspace_CPTG_DiffDrive_alpha(M);
	bind_mrpt_obs_CActionRobotMovement3D(M);
	bind_mrpt_obs_CObservationBatteryState(M);
	bind_mrpt_obs_CObservationOdometry(M);
	bind_mrpt_obs_CRawlog(M);
	bind_mrpt_obs_format_externals_filename(M);
	bind_mrpt_obs_stock_observations(M);
	bind_mrpt_opengl_CArrow(M);
	bind_mrpt_opengl_CAxis(M);
	bind_mrpt_opengl_CGeneralizedEllipsoidTemplate(M);
	bind_mrpt_opengl_CGridPlaneXZ(M);
	bind_mrpt_opengl_CMesh3D(M);
	bind_mrpt_opengl_CSphere(M);
	bind_mrpt_opengl_CEllipsoidRangeBearing2D(M);
	bind_mrpt_opengl_CUBE_TEXTURE_FACE(M);
	bind_mrpt_opengl_CVectorField3D(M);
	bind_mrpt_poses_CPoint2D(M);
	bind_mrpt_poses_CPose2DGridTemplate(M);
	bind_mrpt_poses_CPose3DPDFGaussianInf(M);
	bind_mrpt_poses_CPose3DPDFSOG(M);
	bind_mrpt_poses_CPose3DQuatPDFGaussian(M);
	bind_mrpt_poses_CPose3DQuatPDFGaussianInf(M);
	bind_mrpt_poses_CPosePDFGrid(M);
	bind_mrpt_poses_CPoses2DSequence(M);
	bind_mrpt_poses_Lie_SO(M);
	bind_mrpt_poses_SO_SE_average(M);
	bind_mrpt_vision_types(M);
	bind_mrpt_vision_types_1(M);
	bind_mrpt_vision_TKeyPoint(M);
	bind_mrpt_maps_CLandmark(M);
	bind_mrpt_vision_chessboard_camera_calib(M);
	bind_mrpt_maps_CLandmarksMap(M);
	bind_mrpt_system_CObserver(M);
	bind_mrpt_slam_COccupancyGridMapFeatureExtractor(M);
	bind_mrpt_slam_CIncrementalMapPartitioner(M);
	bind_mrpt_slam_CMetricMapBuilderICP(M);
	bind_mrpt_slam_CMonteCarloLocalization3D(M);
	bind_mrpt_bayes_CKalmanFilterCapable(M);
	bind_mrpt_containers_bimap(M);
	bind_mrpt_slam_data_association(M);
	bind_mrpt_slam_CRangeBearingKFSLAM(M);
	bind_mrpt_bayes_CRejectionSamplingCapable(M);
	bind_mrpt_slam_CRejectionSamplingRangeOnlyLocalization(M);
	bind_mrpt_system_CRateTimer(M);
	bind_mrpt_system_crc(M);
	bind_mrpt_system_scheduler(M);
	bind_mrpt_tfest_indivcompatdecls(M);
	bind_mrpt_topography_data_types(M);
	bind_mrpt_topography_data_types_1(M);
	bind_mrpt_topography_conversions(M);
	bind_mrpt_math_TPoint2D(M);
	bind_mrpt_math_TPoint3D_1(M);
	bind_mrpt_math_TTwist2D(M);
	bind_mrpt_math_CVectorDynamic(M);

}
