/*******************************************************************************
 * Copyright (c) 2012, 2020 Original authors and others.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     Original authors and others - initial API and implementation
 ******************************************************************************/
package org.eclipse.nebula.widgets.nattable.search.event;

import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.event.AbstractContextFreeEvent;

public class SearchEvent extends AbstractContextFreeEvent {

    private final PositionCoordinate cellCoordinate;

    public SearchEvent(PositionCoordinate cellCoordinate) {
        this.cellCoordinate = cellCoordinate;
    }

    public PositionCoordinate getCellCoordinate() {
        return this.cellCoordinate;
    }

    @Override
    public SearchEvent cloneEvent() {
        return new SearchEvent(this.cellCoordinate);
    }

}
