/* $Id: Item.cpp 416593 2013-10-29 18:09:10Z grichenk $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using the following specifications:
 *   'esummary.dtd'.
 */

// standard includes
#include <ncbi_pch.hpp>

// generated includes
#include <objtools/eutils/esummary/Item.hpp>

// generated classes

BEGIN_esummary_SCOPE // namespace esummary::

// destructor
CItem::~CItem(void)
{
}


const string& CItem::GetValue(void) const
{
    ITERATE(TItem, it, GetItem()) {
        const C_E_Item& item = **it;
        if ( item.Is_CharData() ) {
            return item.Get_CharData();
        }
    }
    return kEmptyStr;
}


const string& CItem::FindValue(const string& key) const
{
    ITERATE(TItem, it, GetItem()) {
        const C_E_Item& item = **it;
        if (!item.IsItem()  ||  item.GetItem().GetName() != key) {
            continue;
        }
        return item.GetItem().GetValue();
    }
    return kEmptyStr;
}


const CItem* CItem::FindItem(const string& key) const
{
    ITERATE(TItem, it, GetItem()) {
        const C_E_Item& item = **it;
        if (!item.IsItem()  ||  item.GetItem().GetName() != key) {
            continue;
        }
        return &item.GetItem();
    }
    return NULL;
}


END_esummary_SCOPE // namespace esummary::

/* Original file checksum: lines: 53, chars: 1681, CRC32: 9f8f7332 */
