/*
 * The authors hereby grant permission to use, copy, modify, distribute,
 * and license this software and its documentation for any purpose, provided
 * that existing copyright notices are retained in all copies and that this
 * notice is included verbatim in any distributions. No written agreement,
 * license, or royalty fee is required for any of the authorized uses.
 * Modifications to this software may be copyrighted by their authors
 * and need not follow the licensing terms described here, provided that
 * the new terms are clearly indicated on the first page of each file where
 * they apply.
 */

/*
** cdefBF50x_base.h
**
** This include file contains a list of macro "defines" to enable the programmer
** to use symbolic names for the system MMRs common to the ADSP-BF50x parts
** peripherals.
**
** Copyright (C) 2009 Analog Devices Inc., All Rights Reserved.
*/

#ifndef _CDEF_BF50X_H
#define _CDEF_BF50X_H

#include <defBF50x_base.h>
#include <stdint.h>

#ifdef _MISRA_RULES
#pragma diag(push)
#pragma diag(suppress:misra_rule_19_7:"ADI header allows function macros")
#endif /* _MISRA_RULES */

#ifndef _PTR_TO_VOL_VOID_PTR
# ifndef _USE_LEGACY_CDEF_BEHAVIOUR
#  define _PTR_TO_VOL_VOID_PTR _PTR_TO_VOL_VOID_PTR
# else
#  define _PTR_TO_VOL_VOID_PTR (volatile void **)
# endif
#endif


/* Clock and System Control (0xFFC00000 - 0xFFC000FF) */
#define pPLL_CTL            ((volatile uint16_t *)PLL_CTL)
#define pPLL_DIV            ((volatile uint16_t *)PLL_DIV)
#define pVR_CTL             ((volatile uint16_t *)VR_CTL)
#define pPLL_STAT       ((volatile uint16_t *)PLL_STAT)
#define pPLL_LOCKCNT        ((volatile uint16_t *)PLL_LOCKCNT)
#define pCHIPID         ((volatile uint32_t *)CHIPID)


/* System Interrupt Controller  (0xFFC00100 - 0xFFC001FF) */
#define pSWRST          ((volatile uint16_t *)SWRST)
#define pSYSCR          ((volatile uint16_t *)SYSCR)

#define pSIC_IMASK0         ((volatile uint32_t *)SIC_IMASK0)
/* legacy register name (below) provided for backwards code compatibility */
#define pSIC_IMASK      ((volatile uint32_t *)SIC_IMASK0)
#define pSIC_IAR0       ((volatile uint32_t *)SIC_IAR0)
#define pSIC_IAR1       ((volatile uint32_t *)SIC_IAR1)
#define pSIC_IAR2       ((volatile uint32_t *)SIC_IAR2)
#define pSIC_IAR3       ((volatile uint32_t *)SIC_IAR3)
#define pSIC_ISR0       ((volatile uint32_t *)SIC_ISR0)
/* legacy register name (below) provided for backwards code compatibility */
#define pSIC_ISR            ((volatile uint32_t *)SIC_ISR0)
#define pSIC_IWR0       ((volatile uint32_t *)SIC_IWR0)
/* legacy register name (below) provided for backwards code compatibility */
#define pSIC_IWR            ((volatile uint32_t *)SIC_IWR0)

/* SIC Additions to ADSP-BF50x  (0xFFC0014C - 0xFFC00162) */
#define pSIC_IMASK1     ((volatile uint32_t *)SIC_IMASK1)
#define pSIC_IAR4           ((volatile uint32_t *)SIC_IAR4)
#define pSIC_IAR5           ((volatile uint32_t *)SIC_IAR5)
#define pSIC_IAR6           ((volatile uint32_t *)SIC_IAR6)
#define pSIC_ISR1           ((volatile uint32_t *)SIC_ISR1)
#define pSIC_IWR1           ((volatile uint32_t *)SIC_IWR1)

/* Watchdog Timer           (0xFFC00200 - 0xFFC002FF) */
#define pWDOG_CTL       ((volatile uint16_t *)WDOG_CTL)
#define pWDOG_CNT       ((volatile uint32_t *)WDOG_CNT)
#define pWDOG_STAT      ((volatile uint32_t *)WDOG_STAT)


/* UART0 Controller         (0xFFC00400 - 0xFFC004FF) */
#define pUART0_DLL      ((volatile uint16_t *)UART0_DLL)
#define pUART0_DLH      ((volatile uint16_t *)UART0_DLH)
#define pUART0_GCTL     ((volatile uint16_t *)UART0_GCTL)
#define pUART0_LCR      ((volatile uint16_t *)UART0_LCR)
#define pUART0_MCR      ((volatile uint16_t *)UART0_MCR)
#define pUART0_LSR      ((volatile uint16_t *)UART0_LSR)
#define pUART0_MSR      ((volatile uint16_t *)UART0_MSR)
#define pUART0_SCR      ((volatile uint16_t *)UART0_SCR)
#define pUART0_IER_SET  ((volatile uint16_t *)UART0_IER_SET)
#define pUART0_IER_CLEAR    ((volatile uint16_t *)UART0_IER_CLEAR)
#define pUART0_THR      ((volatile uint16_t *)UART0_THR)
#define pUART0_RBR      ((volatile uint16_t *)UART0_RBR)


/* SPI0 Controller          (0xFFC00500 - 0xFFC005FF)*/
#define pSPI0_CTL       ((volatile uint16_t *)SPI0_CTL)
#define pSPI0_FLG       ((volatile uint16_t *)SPI0_FLG)
#define pSPI0_STAT      ((volatile uint16_t *)SPI0_STAT)
#define pSPI0_TDBR      ((volatile uint16_t *)SPI0_TDBR)
#define pSPI0_RDBR      ((volatile uint16_t *)SPI0_RDBR)
#define pSPI0_BAUD      ((volatile uint16_t *)SPI0_BAUD)
#define pSPI0_SHADOW        ((volatile uint16_t *)SPI0_SHADOW)
/* legacy register names (below) provided for backwards code compatibility */
#define pSPI_CTL            (pSPI0_CTL)
#define pSPI_FLG            (pSPI0_FLG)
#define pSPI_STAT           (pSPI0_STAT)
#define pSPI_TDBR           (pSPI0_TDBR)
#define pSPI_RDBR           (pSPI0_RDBR)
#define pSPI_BAUD           (pSPI0_BAUD)
#define pSPI_SHADOW     (pSPI0_SHADOW)


/* TIMER0-7 Registers       (0xFFC00600 - 0xFFC006FF) */
#define pTIMER0_CONFIG      ((volatile uint16_t *)TIMER0_CONFIG)
#define pTIMER0_COUNTER     ((volatile uint32_t *)TIMER0_COUNTER)
#define pTIMER0_PERIOD      ((volatile uint32_t *)TIMER0_PERIOD)
#define pTIMER0_WIDTH       ((volatile uint32_t *)TIMER0_WIDTH)

#define pTIMER1_CONFIG      ((volatile uint16_t *)TIMER1_CONFIG)
#define pTIMER1_COUNTER     ((volatile uint32_t *)TIMER1_COUNTER)
#define pTIMER1_PERIOD      ((volatile uint32_t *)TIMER1_PERIOD)
#define pTIMER1_WIDTH       ((volatile uint32_t *)TIMER1_WIDTH)

#define pTIMER2_CONFIG      ((volatile uint16_t *)TIMER2_CONFIG)
#define pTIMER2_COUNTER     ((volatile uint32_t *)TIMER2_COUNTER)
#define pTIMER2_PERIOD      ((volatile uint32_t *)TIMER2_PERIOD)
#define pTIMER2_WIDTH       ((volatile uint32_t *)TIMER2_WIDTH)

#define pTIMER3_CONFIG      ((volatile uint16_t *)TIMER3_CONFIG)
#define pTIMER3_COUNTER     ((volatile uint32_t *)TIMER3_COUNTER)
#define pTIMER3_PERIOD      ((volatile uint32_t *)TIMER3_PERIOD)
#define pTIMER3_WIDTH       ((volatile uint32_t *)TIMER3_WIDTH)

#define pTIMER4_CONFIG      ((volatile uint16_t *)TIMER4_CONFIG)
#define pTIMER4_COUNTER     ((volatile uint32_t *)TIMER4_COUNTER)
#define pTIMER4_PERIOD      ((volatile uint32_t *)TIMER4_PERIOD)
#define pTIMER4_WIDTH       ((volatile uint32_t *)TIMER4_WIDTH)

#define pTIMER5_CONFIG      ((volatile uint16_t *)TIMER5_CONFIG)
#define pTIMER5_COUNTER     ((volatile uint32_t *)TIMER5_COUNTER)
#define pTIMER5_PERIOD      ((volatile uint32_t *)TIMER5_PERIOD)
#define pTIMER5_WIDTH       ((volatile uint32_t *)TIMER5_WIDTH)

#define pTIMER6_CONFIG      ((volatile uint16_t *)TIMER6_CONFIG)
#define pTIMER6_COUNTER     ((volatile uint32_t *)TIMER6_COUNTER)
#define pTIMER6_PERIOD      ((volatile uint32_t *)TIMER6_PERIOD)
#define pTIMER6_WIDTH       ((volatile uint32_t *)TIMER6_WIDTH)

#define pTIMER7_CONFIG      ((volatile uint16_t *)TIMER7_CONFIG)
#define pTIMER7_COUNTER     ((volatile uint32_t *)TIMER7_COUNTER)
#define pTIMER7_PERIOD      ((volatile uint32_t *)TIMER7_PERIOD)
#define pTIMER7_WIDTH       ((volatile uint32_t *)TIMER7_WIDTH)

#define pTIMER_ENABLE       ((volatile uint16_t *)TIMER_ENABLE)
#define pTIMER_DISABLE      ((volatile uint16_t *)TIMER_DISABLE)
#define pTIMER_STATUS       ((volatile uint32_t *)TIMER_STATUS)


/* General Purpose I/O Port F (0xFFC00700 - 0xFFC007FF) */
#define pPORTFIO            ((volatile uint16_t *)PORTFIO)
#define pPORTFIO_CLEAR      ((volatile uint16_t *)PORTFIO_CLEAR)
#define pPORTFIO_SET        ((volatile uint16_t *)PORTFIO_SET)
#define pPORTFIO_TOGGLE     ((volatile uint16_t *)PORTFIO_TOGGLE)
#define pPORTFIO_MASKA      ((volatile uint16_t *)PORTFIO_MASKA)
#define pPORTFIO_MASKA_CLEAR    ((volatile uint16_t *)PORTFIO_MASKA_CLEAR)
#define pPORTFIO_MASKA_SET  ((volatile uint16_t *)PORTFIO_MASKA_SET)
#define pPORTFIO_MASKA_TOGGLE ((volatile uint16_t *)PORTFIO_MASKA_TOGGLE)
#define pPORTFIO_MASKB      ((volatile uint16_t *)PORTFIO_MASKB)
#define pPORTFIO_MASKB_CLEAR    ((volatile uint16_t *)PORTFIO_MASKB_CLEAR)
#define pPORTFIO_MASKB_SET  ((volatile uint16_t *)PORTFIO_MASKB_SET)
#define pPORTFIO_MASKB_TOGGLE ((volatile uint16_t *)PORTFIO_MASKB_TOGGLE)
#define pPORTFIO_DIR        ((volatile uint16_t *)PORTFIO_DIR)
#define pPORTFIO_POLAR      ((volatile uint16_t *)PORTFIO_POLAR)
#define pPORTFIO_EDGE       ((volatile uint16_t *)PORTFIO_EDGE)
#define pPORTFIO_BOTH       ((volatile uint16_t *)PORTFIO_BOTH)
#define pPORTFIO_INEN       ((volatile uint16_t *)PORTFIO_INEN)


/* SPORT0 Controller        (0xFFC00800 - 0xFFC008FF) */
#define pSPORT0_TCR1        ((volatile uint16_t *)SPORT0_TCR1)
#define pSPORT0_TCR2        ((volatile uint16_t *)SPORT0_TCR2)
#define pSPORT0_TCLKDIV     ((volatile uint16_t *)SPORT0_TCLKDIV)
#define pSPORT0_TFSDIV      ((volatile uint16_t *)SPORT0_TFSDIV)
#define pSPORT0_TX          ((volatile uint32_t *)SPORT0_TX)
#define pSPORT0_RX          ((volatile uint32_t *)SPORT0_RX)
#define pSPORT0_TX32        ((volatile uint32_t *)SPORT0_TX)
#define pSPORT0_RX32        ((volatile uint32_t *)SPORT0_RX)
#define pSPORT0_TX16        ((volatile uint16_t *)SPORT0_TX)
#define pSPORT0_RX16        ((volatile uint16_t *)SPORT0_RX)
#define pSPORT0_RCR1        ((volatile uint16_t *)SPORT0_RCR1)
#define pSPORT0_RCR2        ((volatile uint16_t *)SPORT0_RCR2)
#define pSPORT0_RCLKDIV     ((volatile uint16_t *)SPORT0_RCLKDIV)
#define pSPORT0_RFSDIV      ((volatile uint16_t *)SPORT0_RFSDIV)
#define pSPORT0_STAT        ((volatile uint16_t *)SPORT0_STAT)
#define pSPORT0_CHNL        ((volatile uint16_t *)SPORT0_CHNL)
#define pSPORT0_MCMC1       ((volatile uint16_t *)SPORT0_MCMC1)
#define pSPORT0_MCMC2       ((volatile uint16_t *)SPORT0_MCMC2)
#define pSPORT0_MTCS0       ((volatile uint32_t *)SPORT0_MTCS0)
#define pSPORT0_MTCS1       ((volatile uint32_t *)SPORT0_MTCS1)
#define pSPORT0_MTCS2       ((volatile uint32_t *)SPORT0_MTCS2)
#define pSPORT0_MTCS3       ((volatile uint32_t *)SPORT0_MTCS3)
#define pSPORT0_MRCS0       ((volatile uint32_t *)SPORT0_MRCS0)
#define pSPORT0_MRCS1       ((volatile uint32_t *)SPORT0_MRCS1)
#define pSPORT0_MRCS2       ((volatile uint32_t *)SPORT0_MRCS2)
#define pSPORT0_MRCS3       ((volatile uint32_t *)SPORT0_MRCS3)


/* SPORT1 Controller        (0xFFC00900 - 0xFFC009FF) */
#define pSPORT1_TCR1        ((volatile uint16_t *)SPORT1_TCR1)
#define pSPORT1_TCR2        ((volatile uint16_t *)SPORT1_TCR2)
#define pSPORT1_TCLKDIV     ((volatile uint16_t *)SPORT1_TCLKDIV)
#define pSPORT1_TFSDIV      ((volatile uint16_t *)SPORT1_TFSDIV)
#define pSPORT1_TX          ((volatile uint32_t *)SPORT1_TX)
#define pSPORT1_RX          ((volatile uint32_t *)SPORT1_RX)
#define pSPORT1_TX32        ((volatile uint32_t *)SPORT1_TX)
#define pSPORT1_RX32        ((volatile uint32_t *)SPORT1_RX)
#define pSPORT1_TX16        ((volatile uint16_t *)SPORT1_TX)
#define pSPORT1_RX16        ((volatile uint16_t *)SPORT1_RX)
#define pSPORT1_RCR1        ((volatile uint16_t *)SPORT1_RCR1)
#define pSPORT1_RCR2        ((volatile uint16_t *)SPORT1_RCR2)
#define pSPORT1_RCLKDIV     ((volatile uint16_t *)SPORT1_RCLKDIV)
#define pSPORT1_RFSDIV      ((volatile uint16_t *)SPORT1_RFSDIV)
#define pSPORT1_STAT        ((volatile uint16_t *)SPORT1_STAT)
#define pSPORT1_CHNL        ((volatile uint16_t *)SPORT1_CHNL)
#define pSPORT1_MCMC1       ((volatile uint16_t *)SPORT1_MCMC1)
#define pSPORT1_MCMC2       ((volatile uint16_t *)SPORT1_MCMC2)
#define pSPORT1_MTCS0       ((volatile uint32_t *)SPORT1_MTCS0)
#define pSPORT1_MTCS1       ((volatile uint32_t *)SPORT1_MTCS1)
#define pSPORT1_MTCS2       ((volatile uint32_t *)SPORT1_MTCS2)
#define pSPORT1_MTCS3       ((volatile uint32_t *)SPORT1_MTCS3)
#define pSPORT1_MRCS0       ((volatile uint32_t *)SPORT1_MRCS0)
#define pSPORT1_MRCS1       ((volatile uint32_t *)SPORT1_MRCS1)
#define pSPORT1_MRCS2       ((volatile uint32_t *)SPORT1_MRCS2)
#define pSPORT1_MRCS3       ((volatile uint32_t *)SPORT1_MRCS3)


/* External Bus Interface Unit (0xFFC00A00 - 0xFFC00AFF) */
#define pEBIU_AMGCTL        ((volatile uint16_t *)EBIU_AMGCTL)
#define pEBIU_AMBCTL        ((volatile uint32_t *)EBIU_AMBCTL)
#define pEBIU_MODE          ((volatile uint16_t *)EBIU_MODE)
#define pEBIU_FCTL          ((volatile uint16_t *)EBIU_FCTL)
#define pEBIU_AMBCTL0       ((volatile uint32_t *)EBIU_AMBCTL)


/* DMA Traffic Control Registers    (0xFFC00B00 - 0xFFC00BFF) */
#define pDMA_TC_PER     ((volatile uint16_t *)DMA_TC_PER)
#define pDMA_TC_CNT     ((volatile uint16_t *)DMA_TC_CNT)

/* Alternate deprecated register names (below) provided for backwards code compatibility */
#define pDMA_TCPER      ((volatile uint16_t *)DMA_TCPER)
#define pDMA_TCCNT      ((volatile uint16_t *)DMA_TCCNT)

/* DMA Controller           (0xFFC00C00 - FFC00FFF)*/
#define pDMA0_CONFIG        ((volatile uint16_t *)DMA0_CONFIG)
#define pDMA0_NEXT_DESC_PTR     (_PTR_TO_VOL_VOID_PTR DMA0_NEXT_DESC_PTR)
#define pDMA0_START_ADDR    (_PTR_TO_VOL_VOID_PTR DMA0_START_ADDR)
#define pDMA0_X_COUNT       ((volatile uint16_t *)DMA0_X_COUNT)
#define pDMA0_Y_COUNT       ((volatile uint16_t *)DMA0_Y_COUNT)
#define pDMA0_X_MODIFY      ((volatile int16_t *)DMA0_X_MODIFY)
#define pDMA0_Y_MODIFY      ((volatile int16_t *)DMA0_Y_MODIFY)
#define pDMA0_CURR_DESC_PTR     (_PTR_TO_VOL_VOID_PTR DMA0_CURR_DESC_PTR)
#define pDMA0_CURR_ADDR     (_PTR_TO_VOL_VOID_PTR DMA0_CURR_ADDR)
#define pDMA0_CURR_X_COUNT  ((volatile uint16_t *)DMA0_CURR_X_COUNT)
#define pDMA0_CURR_Y_COUNT  ((volatile uint16_t *)DMA0_CURR_Y_COUNT)
#define pDMA0_IRQ_STATUS    ((volatile uint16_t *)DMA0_IRQ_STATUS)
#define pDMA0_PERIPHERAL_MAP    ((volatile uint16_t *)DMA0_PERIPHERAL_MAP)

#define pDMA1_CONFIG        ((volatile uint16_t *)DMA1_CONFIG)
#define pDMA1_NEXT_DESC_PTR     (_PTR_TO_VOL_VOID_PTR DMA1_NEXT_DESC_PTR)
#define pDMA1_START_ADDR    (_PTR_TO_VOL_VOID_PTR DMA1_START_ADDR)
#define pDMA1_X_COUNT       ((volatile uint16_t *)DMA1_X_COUNT)
#define pDMA1_Y_COUNT       ((volatile uint16_t *)DMA1_Y_COUNT)
#define pDMA1_X_MODIFY      ((volatile int16_t *)DMA1_X_MODIFY)
#define pDMA1_Y_MODIFY      ((volatile int16_t *)DMA1_Y_MODIFY)
#define pDMA1_CURR_DESC_PTR     (_PTR_TO_VOL_VOID_PTR DMA1_CURR_DESC_PTR)
#define pDMA1_CURR_ADDR     (_PTR_TO_VOL_VOID_PTR DMA1_CURR_ADDR)
#define pDMA1_CURR_X_COUNT  ((volatile uint16_t *)DMA1_CURR_X_COUNT)
#define pDMA1_CURR_Y_COUNT  ((volatile uint16_t *)DMA1_CURR_Y_COUNT)
#define pDMA1_IRQ_STATUS    ((volatile uint16_t *)DMA1_IRQ_STATUS)
#define pDMA1_PERIPHERAL_MAP    ((volatile uint16_t *)DMA1_PERIPHERAL_MAP)

#define pDMA2_CONFIG        ((volatile uint16_t *)DMA2_CONFIG)
#define pDMA2_NEXT_DESC_PTR     (_PTR_TO_VOL_VOID_PTR DMA2_NEXT_DESC_PTR)
#define pDMA2_START_ADDR    (_PTR_TO_VOL_VOID_PTR DMA2_START_ADDR)
#define pDMA2_X_COUNT       ((volatile uint16_t *)DMA2_X_COUNT)
#define pDMA2_Y_COUNT       ((volatile uint16_t *)DMA2_Y_COUNT)
#define pDMA2_X_MODIFY      ((volatile int16_t *)DMA2_X_MODIFY)
#define pDMA2_Y_MODIFY      ((volatile int16_t *)DMA2_Y_MODIFY)
#define pDMA2_CURR_DESC_PTR     (_PTR_TO_VOL_VOID_PTR DMA2_CURR_DESC_PTR)
#define pDMA2_CURR_ADDR     (_PTR_TO_VOL_VOID_PTR DMA2_CURR_ADDR)
#define pDMA2_CURR_X_COUNT  ((volatile uint16_t *)DMA2_CURR_X_COUNT)
#define pDMA2_CURR_Y_COUNT  ((volatile uint16_t *)DMA2_CURR_Y_COUNT)
#define pDMA2_IRQ_STATUS    ((volatile uint16_t *)DMA2_IRQ_STATUS)
#define pDMA2_PERIPHERAL_MAP    ((volatile uint16_t *)DMA2_PERIPHERAL_MAP)

#define pDMA3_CONFIG        ((volatile uint16_t *)DMA3_CONFIG)
#define pDMA3_NEXT_DESC_PTR     (_PTR_TO_VOL_VOID_PTR DMA3_NEXT_DESC_PTR)
#define pDMA3_START_ADDR    (_PTR_TO_VOL_VOID_PTR DMA3_START_ADDR)
#define pDMA3_X_COUNT       ((volatile uint16_t *)DMA3_X_COUNT)
#define pDMA3_Y_COUNT       ((volatile uint16_t *)DMA3_Y_COUNT)
#define pDMA3_X_MODIFY      ((volatile int16_t *)DMA3_X_MODIFY)
#define pDMA3_Y_MODIFY      ((volatile int16_t *)DMA3_Y_MODIFY)
#define pDMA3_CURR_DESC_PTR     (_PTR_TO_VOL_VOID_PTR DMA3_CURR_DESC_PTR)
#define pDMA3_CURR_ADDR     (_PTR_TO_VOL_VOID_PTR DMA3_CURR_ADDR)
#define pDMA3_CURR_X_COUNT  ((volatile uint16_t *)DMA3_CURR_X_COUNT)
#define pDMA3_CURR_Y_COUNT  ((volatile uint16_t *)DMA3_CURR_Y_COUNT)
#define pDMA3_IRQ_STATUS    ((volatile uint16_t *)DMA3_IRQ_STATUS)
#define pDMA3_PERIPHERAL_MAP    ((volatile uint16_t *)DMA3_PERIPHERAL_MAP)

#define pDMA4_CONFIG        ((volatile uint16_t *)DMA4_CONFIG)
#define pDMA4_NEXT_DESC_PTR     (_PTR_TO_VOL_VOID_PTR DMA4_NEXT_DESC_PTR)
#define pDMA4_START_ADDR    (_PTR_TO_VOL_VOID_PTR DMA4_START_ADDR)
#define pDMA4_X_COUNT       ((volatile uint16_t *)DMA4_X_COUNT)
#define pDMA4_Y_COUNT       ((volatile uint16_t *)DMA4_Y_COUNT)
#define pDMA4_X_MODIFY      ((volatile int16_t *)DMA4_X_MODIFY)
#define pDMA4_Y_MODIFY      ((volatile int16_t *)DMA4_Y_MODIFY)
#define pDMA4_CURR_DESC_PTR     (_PTR_TO_VOL_VOID_PTR DMA4_CURR_DESC_PTR)
#define pDMA4_CURR_ADDR     (_PTR_TO_VOL_VOID_PTR DMA4_CURR_ADDR)
#define pDMA4_CURR_X_COUNT  ((volatile uint16_t *)DMA4_CURR_X_COUNT)
#define pDMA4_CURR_Y_COUNT  ((volatile uint16_t *)DMA4_CURR_Y_COUNT)
#define pDMA4_IRQ_STATUS    ((volatile uint16_t *)DMA4_IRQ_STATUS)
#define pDMA4_PERIPHERAL_MAP    ((volatile uint16_t *)DMA4_PERIPHERAL_MAP)

#define pDMA5_CONFIG        ((volatile uint16_t *)DMA5_CONFIG)
#define pDMA5_NEXT_DESC_PTR     (_PTR_TO_VOL_VOID_PTR DMA5_NEXT_DESC_PTR)
#define pDMA5_START_ADDR    (_PTR_TO_VOL_VOID_PTR DMA5_START_ADDR)
#define pDMA5_X_COUNT       ((volatile uint16_t *)DMA5_X_COUNT)
#define pDMA5_Y_COUNT       ((volatile uint16_t *)DMA5_Y_COUNT)
#define pDMA5_X_MODIFY      ((volatile int16_t *)DMA5_X_MODIFY)
#define pDMA5_Y_MODIFY      ((volatile int16_t *)DMA5_Y_MODIFY)
#define pDMA5_CURR_DESC_PTR     (_PTR_TO_VOL_VOID_PTR DMA5_CURR_DESC_PTR)
#define pDMA5_CURR_ADDR     (_PTR_TO_VOL_VOID_PTR DMA5_CURR_ADDR)
#define pDMA5_CURR_X_COUNT  ((volatile uint16_t *)DMA5_CURR_X_COUNT)
#define pDMA5_CURR_Y_COUNT  ((volatile uint16_t *)DMA5_CURR_Y_COUNT)
#define pDMA5_IRQ_STATUS    ((volatile uint16_t *)DMA5_IRQ_STATUS)
#define pDMA5_PERIPHERAL_MAP    ((volatile uint16_t *)DMA5_PERIPHERAL_MAP)

#define pDMA6_CONFIG        ((volatile uint16_t *)DMA6_CONFIG)
#define pDMA6_NEXT_DESC_PTR     (_PTR_TO_VOL_VOID_PTR DMA6_NEXT_DESC_PTR)
#define pDMA6_START_ADDR    (_PTR_TO_VOL_VOID_PTR DMA6_START_ADDR)
#define pDMA6_X_COUNT       ((volatile uint16_t *)DMA6_X_COUNT)
#define pDMA6_Y_COUNT       ((volatile uint16_t *)DMA6_Y_COUNT)
#define pDMA6_X_MODIFY      ((volatile int16_t *)DMA6_X_MODIFY)
#define pDMA6_Y_MODIFY      ((volatile int16_t *)DMA6_Y_MODIFY)
#define pDMA6_CURR_DESC_PTR     (_PTR_TO_VOL_VOID_PTR DMA6_CURR_DESC_PTR)
#define pDMA6_CURR_ADDR     (_PTR_TO_VOL_VOID_PTR DMA6_CURR_ADDR)
#define pDMA6_CURR_X_COUNT  ((volatile uint16_t *)DMA6_CURR_X_COUNT)
#define pDMA6_CURR_Y_COUNT  ((volatile uint16_t *)DMA6_CURR_Y_COUNT)
#define pDMA6_IRQ_STATUS    ((volatile uint16_t *)DMA6_IRQ_STATUS)
#define pDMA6_PERIPHERAL_MAP    ((volatile uint16_t *)DMA6_PERIPHERAL_MAP)

#define pDMA7_CONFIG        ((volatile uint16_t *)DMA7_CONFIG)
#define pDMA7_NEXT_DESC_PTR     (_PTR_TO_VOL_VOID_PTR DMA7_NEXT_DESC_PTR)
#define pDMA7_START_ADDR    (_PTR_TO_VOL_VOID_PTR DMA7_START_ADDR)
#define pDMA7_X_COUNT       ((volatile uint16_t *)DMA7_X_COUNT)
#define pDMA7_Y_COUNT       ((volatile uint16_t *)DMA7_Y_COUNT)
#define pDMA7_X_MODIFY      ((volatile int16_t *)DMA7_X_MODIFY)
#define pDMA7_Y_MODIFY      ((volatile int16_t *)DMA7_Y_MODIFY)
#define pDMA7_CURR_DESC_PTR     (_PTR_TO_VOL_VOID_PTR DMA7_CURR_DESC_PTR)
#define pDMA7_CURR_ADDR     (_PTR_TO_VOL_VOID_PTR DMA7_CURR_ADDR)
#define pDMA7_CURR_X_COUNT  ((volatile uint16_t *)DMA7_CURR_X_COUNT)
#define pDMA7_CURR_Y_COUNT  ((volatile uint16_t *)DMA7_CURR_Y_COUNT)
#define pDMA7_IRQ_STATUS    ((volatile uint16_t *)DMA7_IRQ_STATUS)
#define pDMA7_PERIPHERAL_MAP    ((volatile uint16_t *)DMA7_PERIPHERAL_MAP)

#define pDMA8_CONFIG        ((volatile uint16_t *)DMA8_CONFIG)
#define pDMA8_NEXT_DESC_PTR     (_PTR_TO_VOL_VOID_PTR DMA8_NEXT_DESC_PTR)
#define pDMA8_START_ADDR    (_PTR_TO_VOL_VOID_PTR DMA8_START_ADDR)
#define pDMA8_X_COUNT       ((volatile uint16_t *)DMA8_X_COUNT)
#define pDMA8_Y_COUNT       ((volatile uint16_t *)DMA8_Y_COUNT)
#define pDMA8_X_MODIFY      ((volatile int16_t *)DMA8_X_MODIFY)
#define pDMA8_Y_MODIFY      ((volatile int16_t *)DMA8_Y_MODIFY)
#define pDMA8_CURR_DESC_PTR     (_PTR_TO_VOL_VOID_PTR DMA8_CURR_DESC_PTR)
#define pDMA8_CURR_ADDR     (_PTR_TO_VOL_VOID_PTR DMA8_CURR_ADDR)
#define pDMA8_CURR_X_COUNT  ((volatile uint16_t *)DMA8_CURR_X_COUNT)
#define pDMA8_CURR_Y_COUNT  ((volatile uint16_t *)DMA8_CURR_Y_COUNT)
#define pDMA8_IRQ_STATUS    ((volatile uint16_t *)DMA8_IRQ_STATUS)
#define pDMA8_PERIPHERAL_MAP    ((volatile uint16_t *)DMA8_PERIPHERAL_MAP)

#define pDMA9_CONFIG        ((volatile uint16_t *)DMA9_CONFIG)
#define pDMA9_NEXT_DESC_PTR     (_PTR_TO_VOL_VOID_PTR DMA9_NEXT_DESC_PTR)
#define pDMA9_START_ADDR    (_PTR_TO_VOL_VOID_PTR DMA9_START_ADDR)
#define pDMA9_X_COUNT       ((volatile uint16_t *)DMA9_X_COUNT)
#define pDMA9_Y_COUNT       ((volatile uint16_t *)DMA9_Y_COUNT)
#define pDMA9_X_MODIFY      ((volatile int16_t *)DMA9_X_MODIFY)
#define pDMA9_Y_MODIFY      ((volatile int16_t *)DMA9_Y_MODIFY)
#define pDMA9_CURR_DESC_PTR     (_PTR_TO_VOL_VOID_PTR DMA9_CURR_DESC_PTR)
#define pDMA9_CURR_ADDR     (_PTR_TO_VOL_VOID_PTR DMA9_CURR_ADDR)
#define pDMA9_CURR_X_COUNT  ((volatile uint16_t *)DMA9_CURR_X_COUNT)
#define pDMA9_CURR_Y_COUNT  ((volatile uint16_t *)DMA9_CURR_Y_COUNT)
#define pDMA9_IRQ_STATUS    ((volatile uint16_t *)DMA9_IRQ_STATUS)
#define pDMA9_PERIPHERAL_MAP    ((volatile uint16_t *)DMA9_PERIPHERAL_MAP)

#define pDMA10_CONFIG       ((volatile uint16_t *)DMA10_CONFIG)
#define pDMA10_NEXT_DESC_PTR    (_PTR_TO_VOL_VOID_PTR DMA10_NEXT_DESC_PTR)
#define pDMA10_START_ADDR   (_PTR_TO_VOL_VOID_PTR DMA10_START_ADDR)
#define pDMA10_X_COUNT      ((volatile uint16_t *)DMA10_X_COUNT)
#define pDMA10_Y_COUNT      ((volatile uint16_t *)DMA10_Y_COUNT)
#define pDMA10_X_MODIFY     ((volatile int16_t *)DMA10_X_MODIFY)
#define pDMA10_Y_MODIFY     ((volatile int16_t *)DMA10_Y_MODIFY)
#define pDMA10_CURR_DESC_PTR    (_PTR_TO_VOL_VOID_PTR DMA10_CURR_DESC_PTR)
#define pDMA10_CURR_ADDR    (_PTR_TO_VOL_VOID_PTR DMA10_CURR_ADDR)
#define pDMA10_CURR_X_COUNT     ((volatile uint16_t *)DMA10_CURR_X_COUNT)
#define pDMA10_CURR_Y_COUNT     ((volatile uint16_t *)DMA10_CURR_Y_COUNT)
#define pDMA10_IRQ_STATUS   ((volatile uint16_t *)DMA10_IRQ_STATUS)
#define pDMA10_PERIPHERAL_MAP ((volatile uint16_t *)DMA10_PERIPHERAL_MAP)

#define pDMA11_CONFIG       ((volatile uint16_t *)DMA11_CONFIG)
#define pDMA11_NEXT_DESC_PTR    (_PTR_TO_VOL_VOID_PTR DMA11_NEXT_DESC_PTR)
#define pDMA11_START_ADDR   (_PTR_TO_VOL_VOID_PTR DMA11_START_ADDR)
#define pDMA11_X_COUNT      ((volatile uint16_t *)DMA11_X_COUNT)
#define pDMA11_Y_COUNT      ((volatile uint16_t *)DMA11_Y_COUNT)
#define pDMA11_X_MODIFY     ((volatile int16_t *)DMA11_X_MODIFY)
#define pDMA11_Y_MODIFY     ((volatile int16_t *)DMA11_Y_MODIFY)
#define pDMA11_CURR_DESC_PTR    (_PTR_TO_VOL_VOID_PTR DMA11_CURR_DESC_PTR)
#define pDMA11_CURR_ADDR    (_PTR_TO_VOL_VOID_PTR DMA11_CURR_ADDR)
#define pDMA11_CURR_X_COUNT     ((volatile uint16_t *)DMA11_CURR_X_COUNT)
#define pDMA11_CURR_Y_COUNT     ((volatile uint16_t *)DMA11_CURR_Y_COUNT)
#define pDMA11_IRQ_STATUS   ((volatile uint16_t *)DMA11_IRQ_STATUS)
#define pDMA11_PERIPHERAL_MAP ((volatile uint16_t *)DMA11_PERIPHERAL_MAP)

#define pMDMA_D0_CONFIG     ((volatile uint16_t *)MDMA_D0_CONFIG)
#define pMDMA_D0_NEXT_DESC_PTR  (_PTR_TO_VOL_VOID_PTR MDMA_D0_NEXT_DESC_PTR)
#define pMDMA_D0_START_ADDR     (_PTR_TO_VOL_VOID_PTR MDMA_D0_START_ADDR)
#define pMDMA_D0_X_COUNT    ((volatile uint16_t *)MDMA_D0_X_COUNT)
#define pMDMA_D0_Y_COUNT    ((volatile uint16_t *)MDMA_D0_Y_COUNT)
#define pMDMA_D0_X_MODIFY   ((volatile int16_t *)MDMA_D0_X_MODIFY)
#define pMDMA_D0_Y_MODIFY   ((volatile int16_t *)MDMA_D0_Y_MODIFY)
#define pMDMA_D0_CURR_DESC_PTR  (_PTR_TO_VOL_VOID_PTR MDMA_D0_CURR_DESC_PTR)
#define pMDMA_D0_CURR_ADDR    (_PTR_TO_VOL_VOID_PTR MDMA_D0_CURR_ADDR)
#define pMDMA_D0_CURR_X_COUNT ((volatile uint16_t *)MDMA_D0_CURR_X_COUNT)
#define pMDMA_D0_CURR_Y_COUNT ((volatile uint16_t *)MDMA_D0_CURR_Y_COUNT)
#define pMDMA_D0_IRQ_STATUS     ((volatile uint16_t *)MDMA_D0_IRQ_STATUS)
#define pMDMA_D0_PERIPHERAL_MAP ((volatile uint16_t *)MDMA_D0_PERIPHERAL_MAP)

#define pMDMA_S0_CONFIG     ((volatile uint16_t *)MDMA_S0_CONFIG)
#define pMDMA_S0_NEXT_DESC_PTR  (_PTR_TO_VOL_VOID_PTR MDMA_S0_NEXT_DESC_PTR)
#define pMDMA_S0_START_ADDR     (_PTR_TO_VOL_VOID_PTR MDMA_S0_START_ADDR)
#define pMDMA_S0_X_COUNT    ((volatile uint16_t *)MDMA_S0_X_COUNT)
#define pMDMA_S0_Y_COUNT    ((volatile uint16_t *)MDMA_S0_Y_COUNT)
#define pMDMA_S0_X_MODIFY   ((volatile int16_t *)MDMA_S0_X_MODIFY)
#define pMDMA_S0_Y_MODIFY   ((volatile int16_t *)MDMA_S0_Y_MODIFY)
#define pMDMA_S0_CURR_DESC_PTR  (_PTR_TO_VOL_VOID_PTR MDMA_S0_CURR_DESC_PTR)
#define pMDMA_S0_CURR_ADDR  (_PTR_TO_VOL_VOID_PTR MDMA_S0_CURR_ADDR)
#define pMDMA_S0_CURR_X_COUNT ((volatile uint16_t *)MDMA_S0_CURR_X_COUNT)
#define pMDMA_S0_CURR_Y_COUNT ((volatile uint16_t *)MDMA_S0_CURR_Y_COUNT)
#define pMDMA_S0_IRQ_STATUS     ((volatile uint16_t *)MDMA_S0_IRQ_STATUS)
#define pMDMA_S0_PERIPHERAL_MAP ((volatile uint16_t *)MDMA_S0_PERIPHERAL_MAP)

#define pMDMA_D1_CONFIG     ((volatile uint16_t *)MDMA_D1_CONFIG)
#define pMDMA_D1_NEXT_DESC_PTR  (_PTR_TO_VOL_VOID_PTR MDMA_D1_NEXT_DESC_PTR)
#define pMDMA_D1_START_ADDR     (_PTR_TO_VOL_VOID_PTR MDMA_D1_START_ADDR)
#define pMDMA_D1_X_COUNT    ((volatile uint16_t *)MDMA_D1_X_COUNT)
#define pMDMA_D1_Y_COUNT    ((volatile uint16_t *)MDMA_D1_Y_COUNT)
#define pMDMA_D1_X_MODIFY   ((volatile int16_t *)MDMA_D1_X_MODIFY)
#define pMDMA_D1_Y_MODIFY   ((volatile int16_t *)MDMA_D1_Y_MODIFY)
#define pMDMA_D1_CURR_DESC_PTR  (_PTR_TO_VOL_VOID_PTR MDMA_D1_CURR_DESC_PTR)
#define pMDMA_D1_CURR_ADDR  (_PTR_TO_VOL_VOID_PTR MDMA_D1_CURR_ADDR)
#define pMDMA_D1_CURR_X_COUNT ((volatile uint16_t *)MDMA_D1_CURR_X_COUNT)
#define pMDMA_D1_CURR_Y_COUNT ((volatile uint16_t *)MDMA_D1_CURR_Y_COUNT)
#define pMDMA_D1_IRQ_STATUS     ((volatile uint16_t *)MDMA_D1_IRQ_STATUS)
#define pMDMA_D1_PERIPHERAL_MAP ((volatile uint16_t *)MDMA_D1_PERIPHERAL_MAP)

#define pMDMA_S1_CONFIG     ((volatile uint16_t *)MDMA_S1_CONFIG)
#define pMDMA_S1_NEXT_DESC_PTR  (_PTR_TO_VOL_VOID_PTR MDMA_S1_NEXT_DESC_PTR)
#define pMDMA_S1_START_ADDR     (_PTR_TO_VOL_VOID_PTR MDMA_S1_START_ADDR)
#define pMDMA_S1_X_COUNT    ((volatile uint16_t *)MDMA_S1_X_COUNT)
#define pMDMA_S1_Y_COUNT    ((volatile uint16_t *)MDMA_S1_Y_COUNT)
#define pMDMA_S1_X_MODIFY   ((volatile int16_t *)MDMA_S1_X_MODIFY)
#define pMDMA_S1_Y_MODIFY   ((volatile int16_t *)MDMA_S1_Y_MODIFY)
#define pMDMA_S1_CURR_DESC_PTR  (_PTR_TO_VOL_VOID_PTR MDMA_S1_CURR_DESC_PTR)
#define pMDMA_S1_CURR_ADDR  (_PTR_TO_VOL_VOID_PTR MDMA_S1_CURR_ADDR)
#define pMDMA_S1_CURR_X_COUNT ((volatile uint16_t *)MDMA_S1_CURR_X_COUNT)
#define pMDMA_S1_CURR_Y_COUNT ((volatile uint16_t *)MDMA_S1_CURR_Y_COUNT)
#define pMDMA_S1_IRQ_STATUS     ((volatile uint16_t *)MDMA_S1_IRQ_STATUS)
#define pMDMA_S1_PERIPHERAL_MAP ((volatile uint16_t *)MDMA_S1_PERIPHERAL_MAP)


/* Parallel Peripheral Interface (0xFFC01000 - 0xFFC010FF) */
#define pPPI_CONTROL        ((volatile uint16_t *)PPI_CONTROL)
#define pPPI_STATUS         ((volatile uint16_t *)PPI_STATUS)
#define pPPI_DELAY      ((volatile uint16_t *)PPI_DELAY)
#define pPPI_COUNT      ((volatile uint16_t *)PPI_COUNT)
#define pPPI_FRAME      ((volatile uint16_t *)PPI_FRAME)


/* Two-Wire Interface       (0xFFC01400 - 0xFFC014FF) */
#define pTWI_CLKDIV     ((volatile uint16_t *)TWI_CLKDIV)
#define pTWI_CONTROL        ((volatile uint16_t *)TWI_CONTROL)
#define pTWI_SLAVE_CTL      ((volatile uint16_t *)TWI_SLAVE_CTL)
#define pTWI_SLAVE_STAT     ((volatile uint16_t *)TWI_SLAVE_STAT)
#define pTWI_SLAVE_ADDR     ((volatile uint16_t *)TWI_SLAVE_ADDR)
#define pTWI_MASTER_CTL     ((volatile uint16_t *)TWI_MASTER_CTL)
#define pTWI_MASTER_STAT    ((volatile uint16_t *)TWI_MASTER_STAT)
#define pTWI_MASTER_ADDR    ((volatile uint16_t *)TWI_MASTER_ADDR)
#define pTWI_INT_STAT       ((volatile uint16_t *)TWI_INT_STAT)
#define pTWI_INT_MASK       ((volatile uint16_t *)TWI_INT_MASK)
#define pTWI_FIFO_CTL       ((volatile uint16_t *)TWI_FIFO_CTL)
#define pTWI_FIFO_STAT      ((volatile uint16_t *)TWI_FIFO_STAT)
#define pTWI_XMT_DATA8      ((volatile uint16_t *)TWI_XMT_DATA8)
#define pTWI_XMT_DATA16     ((volatile uint16_t *)TWI_XMT_DATA16)
#define pTWI_RCV_DATA8      ((volatile uint16_t *)TWI_RCV_DATA8)
#define pTWI_RCV_DATA16     ((volatile uint16_t *)TWI_RCV_DATA16)


/* General Purpose I/O Port G (0xFFC01500 - 0xFFC015FF) */
#define pPORTGIO            ((volatile uint16_t *)PORTGIO)
#define pPORTGIO_CLEAR      ((volatile uint16_t *)PORTGIO_CLEAR)
#define pPORTGIO_SET        ((volatile uint16_t *)PORTGIO_SET)
#define pPORTGIO_TOGGLE     ((volatile uint16_t *)PORTGIO_TOGGLE)
#define pPORTGIO_MASKA      ((volatile uint16_t *)PORTGIO_MASKA)
#define pPORTGIO_MASKA_CLEAR    ((volatile uint16_t *)PORTGIO_MASKA_CLEAR)
#define pPORTGIO_MASKA_SET  ((volatile uint16_t *)PORTGIO_MASKA_SET)
#define pPORTGIO_MASKA_TOGGLE   ((volatile uint16_t *)PORTGIO_MASKA_TOGGLE)
#define pPORTGIO_MASKB      ((volatile uint16_t *)PORTGIO_MASKB)
#define pPORTGIO_MASKB_CLEAR    ((volatile uint16_t *)PORTGIO_MASKB_CLEAR)
#define pPORTGIO_MASKB_SET  ((volatile uint16_t *)PORTGIO_MASKB_SET)
#define pPORTGIO_MASKB_TOGGLE   ((volatile uint16_t *)PORTGIO_MASKB_TOGGLE)
#define pPORTGIO_DIR        ((volatile uint16_t *)PORTGIO_DIR)
#define pPORTGIO_POLAR      ((volatile uint16_t *)PORTGIO_POLAR)
#define pPORTGIO_EDGE       ((volatile uint16_t *)PORTGIO_EDGE)
#define pPORTGIO_BOTH       ((volatile uint16_t *)PORTGIO_BOTH)
#define pPORTGIO_INEN       ((volatile uint16_t *)PORTGIO_INEN)


/* General Purpose I/O Port H (0xFFC01700 - 0xFFC017FF) */
#define pPORTHIO            ((volatile uint16_t *)PORTHIO)
#define pPORTHIO_CLEAR      ((volatile uint16_t *)PORTHIO_CLEAR)
#define pPORTHIO_SET        ((volatile uint16_t *)PORTHIO_SET)
#define pPORTHIO_TOGGLE     ((volatile uint16_t *)PORTHIO_TOGGLE)
#define pPORTHIO_MASKA      ((volatile uint16_t *)PORTHIO_MASKA)
#define pPORTHIO_MASKA_CLEAR    ((volatile uint16_t *)PORTHIO_MASKA_CLEAR)
#define pPORTHIO_MASKA_SET  ((volatile uint16_t *)PORTHIO_MASKA_SET)
#define pPORTHIO_MASKA_TOGGLE   ((volatile uint16_t *)PORTHIO_MASKA_TOGGLE)
#define pPORTHIO_MASKB      ((volatile uint16_t *)PORTHIO_MASKB)
#define pPORTHIO_MASKB_CLEAR    ((volatile uint16_t *)PORTHIO_MASKB_CLEAR)
#define pPORTHIO_MASKB_SET  ((volatile uint16_t *)PORTHIO_MASKB_SET)
#define pPORTHIO_MASKB_TOGGLE   ((volatile uint16_t *)PORTHIO_MASKB_TOGGLE)
#define pPORTHIO_DIR        ((volatile uint16_t *)PORTHIO_DIR)
#define pPORTHIO_POLAR      ((volatile uint16_t *)PORTHIO_POLAR)
#define pPORTHIO_EDGE       ((volatile uint16_t *)PORTHIO_EDGE)
#define pPORTHIO_BOTH       ((volatile uint16_t *)PORTHIO_BOTH)
#define pPORTHIO_INEN       ((volatile uint16_t *)PORTHIO_INEN)


/* UART1 Controller         (0xFFC02000 - 0xFFC020FF) */
#define pUART1_DLL      ((volatile uint16_t *)UART1_DLL)
#define pUART1_DLH      ((volatile uint16_t *)UART1_DLH)
#define pUART1_GCTL     ((volatile uint16_t *)UART1_GCTL)
#define pUART1_LCR      ((volatile uint16_t *)UART1_LCR)
#define pUART1_MCR      ((volatile uint16_t *)UART1_MCR)
#define pUART1_LSR      ((volatile uint16_t *)UART1_LSR)
#define pUART1_MSR      ((volatile uint16_t *)UART1_MSR)
#define pUART1_SCR      ((volatile uint16_t *)UART1_SCR)
#define pUART1_IER_SET  ((volatile uint16_t *)UART1_IER_SET)
#define pUART1_IER_CLEAR    ((volatile uint16_t *)UART1_IER_CLEAR)
#define pUART1_THR      ((volatile uint16_t *)UART1_THR)
#define pUART1_RBR      ((volatile uint16_t *)UART1_RBR)


/* CAN Controller           (0xFFC02A00 - 0xFFC02FFF) */
/* For Mailboxes 0-15 */
#define pCAN_MC1            ((volatile uint16_t *)CAN_MC1)
#define pCAN_MD1            ((volatile uint16_t *)CAN_MD1)
#define pCAN_TRS1           ((volatile uint16_t *)CAN_TRS1)
#define pCAN_TRR1           ((volatile uint16_t *)CAN_TRR1)
#define pCAN_TA1            ((volatile uint16_t *)CAN_TA1)
#define pCAN_AA1            ((volatile uint16_t *)CAN_AA1)
#define pCAN_RMP1           ((volatile uint16_t *)CAN_RMP1)
#define pCAN_RML1           ((volatile uint16_t *)CAN_RML1)
#define pCAN_MBTIF1         ((volatile uint16_t *)CAN_MBTIF1)
#define pCAN_MBRIF1         ((volatile uint16_t *)CAN_MBRIF1)
#define pCAN_MBIM1          ((volatile uint16_t *)CAN_MBIM1)
#define pCAN_RFH1           ((volatile uint16_t *)CAN_RFH1)
#define pCAN_OPSS1          ((volatile uint16_t *)CAN_OPSS1)

/* For Mailboxes 16-31 */
#define pCAN_MC2            ((volatile uint16_t *)CAN_MC2)
#define pCAN_MD2            ((volatile uint16_t *)CAN_MD2)
#define pCAN_TRS2           ((volatile uint16_t *)CAN_TRS2)
#define pCAN_TRR2           ((volatile uint16_t *)CAN_TRR2)
#define pCAN_TA2            ((volatile uint16_t *)CAN_TA2)
#define pCAN_AA2            ((volatile uint16_t *)CAN_AA2)
#define pCAN_RMP2           ((volatile uint16_t *)CAN_RMP2)
#define pCAN_RML2           ((volatile uint16_t *)CAN_RML2)
#define pCAN_MBTIF2         ((volatile uint16_t *)CAN_MBTIF2)
#define pCAN_MBRIF2         ((volatile uint16_t *)CAN_MBRIF2)
#define pCAN_MBIM2          ((volatile uint16_t *)CAN_MBIM2)
#define pCAN_RFH2           ((volatile uint16_t *)CAN_RFH2)
#define pCAN_OPSS2          ((volatile uint16_t *)CAN_OPSS2)

#define pCAN_CLOCK          ((volatile uint16_t *)CAN_CLOCK)
#define pCAN_TIMING         ((volatile uint16_t *)CAN_TIMING)
#define pCAN_DEBUG          ((volatile uint16_t *)CAN_DEBUG)
#define pCAN_STATUS         ((volatile uint16_t *)CAN_STATUS)
#define pCAN_CEC            ((volatile uint16_t *)CAN_CEC)
#define pCAN_GIS            ((volatile uint16_t *)CAN_GIS)
#define pCAN_GIM            ((volatile uint16_t *)CAN_GIM)
#define pCAN_GIF            ((volatile uint16_t *)CAN_GIF)
#define pCAN_CONTROL        ((volatile uint16_t *)CAN_CONTROL)
#define pCAN_INTR           ((volatile uint16_t *)CAN_INTR)
#define pCAN_MBTD           ((volatile uint16_t *)CAN_MBTD)
#define pCAN_EWR            ((volatile uint16_t *)CAN_EWR)
#define pCAN_ESR            ((volatile uint16_t *)CAN_ESR)
#define pCAN_UCCNT          ((volatile uint16_t *)CAN_UCCNT)
#define pCAN_UCRC           ((volatile uint16_t *)CAN_UCRC)
#define pCAN_UCCNF          ((volatile uint16_t *)CAN_UCCNF)

/* Mailbox Acceptance Masks                                             */
#define pCAN_AM00L          ((volatile uint16_t *)CAN_AM00L)
#define pCAN_AM00H          ((volatile uint16_t *)CAN_AM00H)
#define pCAN_AM01L          ((volatile uint16_t *)CAN_AM01L)
#define pCAN_AM01H          ((volatile uint16_t *)CAN_AM01H)
#define pCAN_AM02L          ((volatile uint16_t *)CAN_AM02L)
#define pCAN_AM02H          ((volatile uint16_t *)CAN_AM02H)
#define pCAN_AM03L          ((volatile uint16_t *)CAN_AM03L)
#define pCAN_AM03H          ((volatile uint16_t *)CAN_AM03H)
#define pCAN_AM04L          ((volatile uint16_t *)CAN_AM04L)
#define pCAN_AM04H          ((volatile uint16_t *)CAN_AM04H)
#define pCAN_AM05L          ((volatile uint16_t *)CAN_AM05L)
#define pCAN_AM05H          ((volatile uint16_t *)CAN_AM05H)
#define pCAN_AM06L          ((volatile uint16_t *)CAN_AM06L)
#define pCAN_AM06H          ((volatile uint16_t *)CAN_AM06H)
#define pCAN_AM07L          ((volatile uint16_t *)CAN_AM07L)
#define pCAN_AM07H          ((volatile uint16_t *)CAN_AM07H)
#define pCAN_AM08L          ((volatile uint16_t *)CAN_AM08L)
#define pCAN_AM08H          ((volatile uint16_t *)CAN_AM08H)
#define pCAN_AM09L          ((volatile uint16_t *)CAN_AM09L)
#define pCAN_AM09H          ((volatile uint16_t *)CAN_AM09H)
#define pCAN_AM10L          ((volatile uint16_t *)CAN_AM10L)
#define pCAN_AM10H          ((volatile uint16_t *)CAN_AM10H)
#define pCAN_AM11L          ((volatile uint16_t *)CAN_AM11L)
#define pCAN_AM11H          ((volatile uint16_t *)CAN_AM11H)
#define pCAN_AM12L          ((volatile uint16_t *)CAN_AM12L)
#define pCAN_AM12H          ((volatile uint16_t *)CAN_AM12H)
#define pCAN_AM13L          ((volatile uint16_t *)CAN_AM13L)
#define pCAN_AM13H          ((volatile uint16_t *)CAN_AM13H)
#define pCAN_AM14L          ((volatile uint16_t *)CAN_AM14L)
#define pCAN_AM14H          ((volatile uint16_t *)CAN_AM14H)
#define pCAN_AM15L          ((volatile uint16_t *)CAN_AM15L)
#define pCAN_AM15H          ((volatile uint16_t *)CAN_AM15H)

#define pCAN_AM16L          ((volatile uint16_t *)CAN_AM16L)
#define pCAN_AM16H          ((volatile uint16_t *)CAN_AM16H)
#define pCAN_AM17L          ((volatile uint16_t *)CAN_AM17L)
#define pCAN_AM17H          ((volatile uint16_t *)CAN_AM17H)
#define pCAN_AM18L          ((volatile uint16_t *)CAN_AM18L)
#define pCAN_AM18H          ((volatile uint16_t *)CAN_AM18H)
#define pCAN_AM19L          ((volatile uint16_t *)CAN_AM19L)
#define pCAN_AM19H          ((volatile uint16_t *)CAN_AM19H)
#define pCAN_AM20L          ((volatile uint16_t *)CAN_AM20L)
#define pCAN_AM20H          ((volatile uint16_t *)CAN_AM20H)
#define pCAN_AM21L          ((volatile uint16_t *)CAN_AM21L)
#define pCAN_AM21H          ((volatile uint16_t *)CAN_AM21H)
#define pCAN_AM22L          ((volatile uint16_t *)CAN_AM22L)
#define pCAN_AM22H          ((volatile uint16_t *)CAN_AM22H)
#define pCAN_AM23L          ((volatile uint16_t *)CAN_AM23L)
#define pCAN_AM23H          ((volatile uint16_t *)CAN_AM23H)
#define pCAN_AM24L          ((volatile uint16_t *)CAN_AM24L)
#define pCAN_AM24H          ((volatile uint16_t *)CAN_AM24H)
#define pCAN_AM25L          ((volatile uint16_t *)CAN_AM25L)
#define pCAN_AM25H          ((volatile uint16_t *)CAN_AM25H)
#define pCAN_AM26L          ((volatile uint16_t *)CAN_AM26L)
#define pCAN_AM26H          ((volatile uint16_t *)CAN_AM26H)
#define pCAN_AM27L          ((volatile uint16_t *)CAN_AM27L)
#define pCAN_AM27H          ((volatile uint16_t *)CAN_AM27H)
#define pCAN_AM28L          ((volatile uint16_t *)CAN_AM28L)
#define pCAN_AM28H          ((volatile uint16_t *)CAN_AM28H)
#define pCAN_AM29L          ((volatile uint16_t *)CAN_AM29L)
#define pCAN_AM29H          ((volatile uint16_t *)CAN_AM29H)
#define pCAN_AM30L          ((volatile uint16_t *)CAN_AM30L)
#define pCAN_AM30H          ((volatile uint16_t *)CAN_AM30H)
#define pCAN_AM31L          ((volatile uint16_t *)CAN_AM31L)
#define pCAN_AM31H          ((volatile uint16_t *)CAN_AM31H)

/* CAN Acceptance Mask Area Macros  */
#define pCAN_AM_L(x)        ((volatile uint16_t *)CAN_AM_L(x))
#define pCAN_AM_H(x)        ((volatile uint16_t *)CAN_AM_H(x))

/* Mailbox Registers                                                        */
#define pCAN_MB00_DATA0     ((volatile uint16_t *)CAN_MB00_DATA0)
#define pCAN_MB00_DATA1     ((volatile uint16_t *)CAN_MB00_DATA1)
#define pCAN_MB00_DATA2     ((volatile uint16_t *)CAN_MB00_DATA2)
#define pCAN_MB00_DATA3     ((volatile uint16_t *)CAN_MB00_DATA3)
#define pCAN_MB00_LENGTH    ((volatile uint16_t *)CAN_MB00_LENGTH)
#define pCAN_MB00_TIMESTAMP ((volatile uint16_t *)CAN_MB00_TIMESTAMP)
#define pCAN_MB00_ID0       ((volatile uint16_t *)CAN_MB00_ID0)
#define pCAN_MB00_ID1       ((volatile uint16_t *)CAN_MB00_ID1)

#define pCAN_MB01_DATA0     ((volatile uint16_t *)CAN_MB01_DATA0)
#define pCAN_MB01_DATA1     ((volatile uint16_t *)CAN_MB01_DATA1)
#define pCAN_MB01_DATA2     ((volatile uint16_t *)CAN_MB01_DATA2)
#define pCAN_MB01_DATA3     ((volatile uint16_t *)CAN_MB01_DATA3)
#define pCAN_MB01_LENGTH    ((volatile uint16_t *)CAN_MB01_LENGTH)
#define pCAN_MB01_TIMESTAMP ((volatile uint16_t *)CAN_MB01_TIMESTAMP)
#define pCAN_MB01_ID0       ((volatile uint16_t *)CAN_MB01_ID0)
#define pCAN_MB01_ID1       ((volatile uint16_t *)CAN_MB01_ID1)

#define pCAN_MB02_DATA0     ((volatile uint16_t *)CAN_MB02_DATA0)
#define pCAN_MB02_DATA1     ((volatile uint16_t *)CAN_MB02_DATA1)
#define pCAN_MB02_DATA2     ((volatile uint16_t *)CAN_MB02_DATA2)
#define pCAN_MB02_DATA3     ((volatile uint16_t *)CAN_MB02_DATA3)
#define pCAN_MB02_LENGTH    ((volatile uint16_t *)CAN_MB02_LENGTH)
#define pCAN_MB02_TIMESTAMP ((volatile uint16_t *)CAN_MB02_TIMESTAMP)
#define pCAN_MB02_ID0       ((volatile uint16_t *)CAN_MB02_ID0)
#define pCAN_MB02_ID1       ((volatile uint16_t *)CAN_MB02_ID1)

#define pCAN_MB03_DATA0     ((volatile uint16_t *)CAN_MB03_DATA0)
#define pCAN_MB03_DATA1     ((volatile uint16_t *)CAN_MB03_DATA1)
#define pCAN_MB03_DATA2     ((volatile uint16_t *)CAN_MB03_DATA2)
#define pCAN_MB03_DATA3     ((volatile uint16_t *)CAN_MB03_DATA3)
#define pCAN_MB03_LENGTH    ((volatile uint16_t *)CAN_MB03_LENGTH)
#define pCAN_MB03_TIMESTAMP ((volatile uint16_t *)CAN_MB03_TIMESTAMP)
#define pCAN_MB03_ID0       ((volatile uint16_t *)CAN_MB03_ID0)
#define pCAN_MB03_ID1       ((volatile uint16_t *)CAN_MB03_ID1)

#define pCAN_MB04_DATA0     ((volatile uint16_t *)CAN_MB04_DATA0)
#define pCAN_MB04_DATA1     ((volatile uint16_t *)CAN_MB04_DATA1)
#define pCAN_MB04_DATA2     ((volatile uint16_t *)CAN_MB04_DATA2)
#define pCAN_MB04_DATA3     ((volatile uint16_t *)CAN_MB04_DATA3)
#define pCAN_MB04_LENGTH    ((volatile uint16_t *)CAN_MB04_LENGTH)
#define pCAN_MB04_TIMESTAMP ((volatile uint16_t *)CAN_MB04_TIMESTAMP)
#define pCAN_MB04_ID0       ((volatile uint16_t *)CAN_MB04_ID0)
#define pCAN_MB04_ID1       ((volatile uint16_t *)CAN_MB04_ID1)

#define pCAN_MB05_DATA0     ((volatile uint16_t *)CAN_MB05_DATA0)
#define pCAN_MB05_DATA1     ((volatile uint16_t *)CAN_MB05_DATA1)
#define pCAN_MB05_DATA2     ((volatile uint16_t *)CAN_MB05_DATA2)
#define pCAN_MB05_DATA3     ((volatile uint16_t *)CAN_MB05_DATA3)
#define pCAN_MB05_LENGTH    ((volatile uint16_t *)CAN_MB05_LENGTH)
#define pCAN_MB05_TIMESTAMP ((volatile uint16_t *)CAN_MB05_TIMESTAMP)
#define pCAN_MB05_ID0       ((volatile uint16_t *)CAN_MB05_ID0)
#define pCAN_MB05_ID1       ((volatile uint16_t *)CAN_MB05_ID1)

#define pCAN_MB06_DATA0     ((volatile uint16_t *)CAN_MB06_DATA0)
#define pCAN_MB06_DATA1     ((volatile uint16_t *)CAN_MB06_DATA1)
#define pCAN_MB06_DATA2     ((volatile uint16_t *)CAN_MB06_DATA2)
#define pCAN_MB06_DATA3     ((volatile uint16_t *)CAN_MB06_DATA3)
#define pCAN_MB06_LENGTH    ((volatile uint16_t *)CAN_MB06_LENGTH)
#define pCAN_MB06_TIMESTAMP ((volatile uint16_t *)CAN_MB06_TIMESTAMP)
#define pCAN_MB06_ID0       ((volatile uint16_t *)CAN_MB06_ID0)
#define pCAN_MB06_ID1       ((volatile uint16_t *)CAN_MB06_ID1)

#define pCAN_MB07_DATA0     ((volatile uint16_t *)CAN_MB07_DATA0)
#define pCAN_MB07_DATA1     ((volatile uint16_t *)CAN_MB07_DATA1)
#define pCAN_MB07_DATA2     ((volatile uint16_t *)CAN_MB07_DATA2)
#define pCAN_MB07_DATA3     ((volatile uint16_t *)CAN_MB07_DATA3)
#define pCAN_MB07_LENGTH    ((volatile uint16_t *)CAN_MB07_LENGTH)
#define pCAN_MB07_TIMESTAMP ((volatile uint16_t *)CAN_MB07_TIMESTAMP)
#define pCAN_MB07_ID0       ((volatile uint16_t *)CAN_MB07_ID0)
#define pCAN_MB07_ID1       ((volatile uint16_t *)CAN_MB07_ID1)

#define pCAN_MB08_DATA0     ((volatile uint16_t *)CAN_MB08_DATA0)
#define pCAN_MB08_DATA1     ((volatile uint16_t *)CAN_MB08_DATA1)
#define pCAN_MB08_DATA2     ((volatile uint16_t *)CAN_MB08_DATA2)
#define pCAN_MB08_DATA3     ((volatile uint16_t *)CAN_MB08_DATA3)
#define pCAN_MB08_LENGTH    ((volatile uint16_t *)CAN_MB08_LENGTH)
#define pCAN_MB08_TIMESTAMP ((volatile uint16_t *)CAN_MB08_TIMESTAMP)
#define pCAN_MB08_ID0       ((volatile uint16_t *)CAN_MB08_ID0)
#define pCAN_MB08_ID1       ((volatile uint16_t *)CAN_MB08_ID1)

#define pCAN_MB09_DATA0     ((volatile uint16_t *)CAN_MB09_DATA0)
#define pCAN_MB09_DATA1     ((volatile uint16_t *)CAN_MB09_DATA1)
#define pCAN_MB09_DATA2     ((volatile uint16_t *)CAN_MB09_DATA2)
#define pCAN_MB09_DATA3     ((volatile uint16_t *)CAN_MB09_DATA3)
#define pCAN_MB09_LENGTH    ((volatile uint16_t *)CAN_MB09_LENGTH)
#define pCAN_MB09_TIMESTAMP ((volatile uint16_t *)CAN_MB09_TIMESTAMP)
#define pCAN_MB09_ID0       ((volatile uint16_t *)CAN_MB09_ID0)
#define pCAN_MB09_ID1       ((volatile uint16_t *)CAN_MB09_ID1)

#define pCAN_MB10_DATA0     ((volatile uint16_t *)CAN_MB10_DATA0)
#define pCAN_MB10_DATA1     ((volatile uint16_t *)CAN_MB10_DATA1)
#define pCAN_MB10_DATA2     ((volatile uint16_t *)CAN_MB10_DATA2)
#define pCAN_MB10_DATA3     ((volatile uint16_t *)CAN_MB10_DATA3)
#define pCAN_MB10_LENGTH    ((volatile uint16_t *)CAN_MB10_LENGTH)
#define pCAN_MB10_TIMESTAMP ((volatile uint16_t *)CAN_MB10_TIMESTAMP)
#define pCAN_MB10_ID0       ((volatile uint16_t *)CAN_MB10_ID0)
#define pCAN_MB10_ID1       ((volatile uint16_t *)CAN_MB10_ID1)

#define pCAN_MB11_DATA0     ((volatile uint16_t *)CAN_MB11_DATA0)
#define pCAN_MB11_DATA1     ((volatile uint16_t *)CAN_MB11_DATA1)
#define pCAN_MB11_DATA2     ((volatile uint16_t *)CAN_MB11_DATA2)
#define pCAN_MB11_DATA3     ((volatile uint16_t *)CAN_MB11_DATA3)
#define pCAN_MB11_LENGTH    ((volatile uint16_t *)CAN_MB11_LENGTH)
#define pCAN_MB11_TIMESTAMP ((volatile uint16_t *)CAN_MB11_TIMESTAMP)
#define pCAN_MB11_ID0       ((volatile uint16_t *)CAN_MB11_ID0)
#define pCAN_MB11_ID1       ((volatile uint16_t *)CAN_MB11_ID1)

#define pCAN_MB12_DATA0     ((volatile uint16_t *)CAN_MB12_DATA0)
#define pCAN_MB12_DATA1     ((volatile uint16_t *)CAN_MB12_DATA1)
#define pCAN_MB12_DATA2     ((volatile uint16_t *)CAN_MB12_DATA2)
#define pCAN_MB12_DATA3     ((volatile uint16_t *)CAN_MB12_DATA3)
#define pCAN_MB12_LENGTH    ((volatile uint16_t *)CAN_MB12_LENGTH)
#define pCAN_MB12_TIMESTAMP ((volatile uint16_t *)CAN_MB12_TIMESTAMP)
#define pCAN_MB12_ID0       ((volatile uint16_t *)CAN_MB12_ID0)
#define pCAN_MB12_ID1       ((volatile uint16_t *)CAN_MB12_ID1)

#define pCAN_MB13_DATA0     ((volatile uint16_t *)CAN_MB13_DATA0)
#define pCAN_MB13_DATA1     ((volatile uint16_t *)CAN_MB13_DATA1)
#define pCAN_MB13_DATA2     ((volatile uint16_t *)CAN_MB13_DATA2)
#define pCAN_MB13_DATA3     ((volatile uint16_t *)CAN_MB13_DATA3)
#define pCAN_MB13_LENGTH    ((volatile uint16_t *)CAN_MB13_LENGTH)
#define pCAN_MB13_TIMESTAMP ((volatile uint16_t *)CAN_MB13_TIMESTAMP)
#define pCAN_MB13_ID0       ((volatile uint16_t *)CAN_MB13_ID0)
#define pCAN_MB13_ID1       ((volatile uint16_t *)CAN_MB13_ID1)

#define pCAN_MB14_DATA0     ((volatile uint16_t *)CAN_MB14_DATA0)
#define pCAN_MB14_DATA1     ((volatile uint16_t *)CAN_MB14_DATA1)
#define pCAN_MB14_DATA2     ((volatile uint16_t *)CAN_MB14_DATA2)
#define pCAN_MB14_DATA3     ((volatile uint16_t *)CAN_MB14_DATA3)
#define pCAN_MB14_LENGTH    ((volatile uint16_t *)CAN_MB14_LENGTH)
#define pCAN_MB14_TIMESTAMP ((volatile uint16_t *)CAN_MB14_TIMESTAMP)
#define pCAN_MB14_ID0       ((volatile uint16_t *)CAN_MB14_ID0)
#define pCAN_MB14_ID1       ((volatile uint16_t *)CAN_MB14_ID1)

#define pCAN_MB15_DATA0     ((volatile uint16_t *)CAN_MB15_DATA0)
#define pCAN_MB15_DATA1     ((volatile uint16_t *)CAN_MB15_DATA1)
#define pCAN_MB15_DATA2     ((volatile uint16_t *)CAN_MB15_DATA2)
#define pCAN_MB15_DATA3     ((volatile uint16_t *)CAN_MB15_DATA3)
#define pCAN_MB15_LENGTH    ((volatile uint16_t *)CAN_MB15_LENGTH)
#define pCAN_MB15_TIMESTAMP ((volatile uint16_t *)CAN_MB15_TIMESTAMP)
#define pCAN_MB15_ID0       ((volatile uint16_t *)CAN_MB15_ID0)
#define pCAN_MB15_ID1       ((volatile uint16_t *)CAN_MB15_ID1)

#define pCAN_MB16_DATA0     ((volatile uint16_t *)CAN_MB16_DATA0)
#define pCAN_MB16_DATA1     ((volatile uint16_t *)CAN_MB16_DATA1)
#define pCAN_MB16_DATA2     ((volatile uint16_t *)CAN_MB16_DATA2)
#define pCAN_MB16_DATA3     ((volatile uint16_t *)CAN_MB16_DATA3)
#define pCAN_MB16_LENGTH    ((volatile uint16_t *)CAN_MB16_LENGTH)
#define pCAN_MB16_TIMESTAMP ((volatile uint16_t *)CAN_MB16_TIMESTAMP)
#define pCAN_MB16_ID0       ((volatile uint16_t *)CAN_MB16_ID0)
#define pCAN_MB16_ID1       ((volatile uint16_t *)CAN_MB16_ID1)

#define pCAN_MB17_DATA0     ((volatile uint16_t *)CAN_MB17_DATA0)
#define pCAN_MB17_DATA1     ((volatile uint16_t *)CAN_MB17_DATA1)
#define pCAN_MB17_DATA2     ((volatile uint16_t *)CAN_MB17_DATA2)
#define pCAN_MB17_DATA3     ((volatile uint16_t *)CAN_MB17_DATA3)
#define pCAN_MB17_LENGTH    ((volatile uint16_t *)CAN_MB17_LENGTH)
#define pCAN_MB17_TIMESTAMP ((volatile uint16_t *)CAN_MB17_TIMESTAMP)
#define pCAN_MB17_ID0       ((volatile uint16_t *)CAN_MB17_ID0)
#define pCAN_MB17_ID1       ((volatile uint16_t *)CAN_MB17_ID1)

#define pCAN_MB18_DATA0     ((volatile uint16_t *)CAN_MB18_DATA0)
#define pCAN_MB18_DATA1     ((volatile uint16_t *)CAN_MB18_DATA1)
#define pCAN_MB18_DATA2     ((volatile uint16_t *)CAN_MB18_DATA2)
#define pCAN_MB18_DATA3     ((volatile uint16_t *)CAN_MB18_DATA3)
#define pCAN_MB18_LENGTH    ((volatile uint16_t *)CAN_MB18_LENGTH)
#define pCAN_MB18_TIMESTAMP ((volatile uint16_t *)CAN_MB18_TIMESTAMP)
#define pCAN_MB18_ID0       ((volatile uint16_t *)CAN_MB18_ID0)
#define pCAN_MB18_ID1       ((volatile uint16_t *)CAN_MB18_ID1)

#define pCAN_MB19_DATA0     ((volatile uint16_t *)CAN_MB19_DATA0)
#define pCAN_MB19_DATA1     ((volatile uint16_t *)CAN_MB19_DATA1)
#define pCAN_MB19_DATA2     ((volatile uint16_t *)CAN_MB19_DATA2)
#define pCAN_MB19_DATA3     ((volatile uint16_t *)CAN_MB19_DATA3)
#define pCAN_MB19_LENGTH    ((volatile uint16_t *)CAN_MB19_LENGTH)
#define pCAN_MB19_TIMESTAMP ((volatile uint16_t *)CAN_MB19_TIMESTAMP)
#define pCAN_MB19_ID0       ((volatile uint16_t *)CAN_MB19_ID0)
#define pCAN_MB19_ID1       ((volatile uint16_t *)CAN_MB19_ID1)

#define pCAN_MB20_DATA0     ((volatile uint16_t *)CAN_MB20_DATA0)
#define pCAN_MB20_DATA1     ((volatile uint16_t *)CAN_MB20_DATA1)
#define pCAN_MB20_DATA2     ((volatile uint16_t *)CAN_MB20_DATA2)
#define pCAN_MB20_DATA3     ((volatile uint16_t *)CAN_MB20_DATA3)
#define pCAN_MB20_LENGTH    ((volatile uint16_t *)CAN_MB20_LENGTH)
#define pCAN_MB20_TIMESTAMP ((volatile uint16_t *)CAN_MB20_TIMESTAMP)
#define pCAN_MB20_ID0       ((volatile uint16_t *)CAN_MB20_ID0)
#define pCAN_MB20_ID1       ((volatile uint16_t *)CAN_MB20_ID1)

#define pCAN_MB21_DATA0     ((volatile uint16_t *)CAN_MB21_DATA0)
#define pCAN_MB21_DATA1     ((volatile uint16_t *)CAN_MB21_DATA1)
#define pCAN_MB21_DATA2     ((volatile uint16_t *)CAN_MB21_DATA2)
#define pCAN_MB21_DATA3     ((volatile uint16_t *)CAN_MB21_DATA3)
#define pCAN_MB21_LENGTH    ((volatile uint16_t *)CAN_MB21_LENGTH)
#define pCAN_MB21_TIMESTAMP ((volatile uint16_t *)CAN_MB21_TIMESTAMP)
#define pCAN_MB21_ID0       ((volatile uint16_t *)CAN_MB21_ID0)
#define pCAN_MB21_ID1       ((volatile uint16_t *)CAN_MB21_ID1)

#define pCAN_MB22_DATA0     ((volatile uint16_t *)CAN_MB22_DATA0)
#define pCAN_MB22_DATA1     ((volatile uint16_t *)CAN_MB22_DATA1)
#define pCAN_MB22_DATA2     ((volatile uint16_t *)CAN_MB22_DATA2)
#define pCAN_MB22_DATA3     ((volatile uint16_t *)CAN_MB22_DATA3)
#define pCAN_MB22_LENGTH    ((volatile uint16_t *)CAN_MB22_LENGTH)
#define pCAN_MB22_TIMESTAMP ((volatile uint16_t *)CAN_MB22_TIMESTAMP)
#define pCAN_MB22_ID0       ((volatile uint16_t *)CAN_MB22_ID0)
#define pCAN_MB22_ID1       ((volatile uint16_t *)CAN_MB22_ID1)

#define pCAN_MB23_DATA0     ((volatile uint16_t *)CAN_MB23_DATA0)
#define pCAN_MB23_DATA1     ((volatile uint16_t *)CAN_MB23_DATA1)
#define pCAN_MB23_DATA2     ((volatile uint16_t *)CAN_MB23_DATA2)
#define pCAN_MB23_DATA3     ((volatile uint16_t *)CAN_MB23_DATA3)
#define pCAN_MB23_LENGTH    ((volatile uint16_t *)CAN_MB23_LENGTH)
#define pCAN_MB23_TIMESTAMP ((volatile uint16_t *)CAN_MB23_TIMESTAMP)
#define pCAN_MB23_ID0       ((volatile uint16_t *)CAN_MB23_ID0)
#define pCAN_MB23_ID1       ((volatile uint16_t *)CAN_MB23_ID1)

#define pCAN_MB24_DATA0     ((volatile uint16_t *)CAN_MB24_DATA0)
#define pCAN_MB24_DATA1     ((volatile uint16_t *)CAN_MB24_DATA1)
#define pCAN_MB24_DATA2     ((volatile uint16_t *)CAN_MB24_DATA2)
#define pCAN_MB24_DATA3     ((volatile uint16_t *)CAN_MB24_DATA3)
#define pCAN_MB24_LENGTH    ((volatile uint16_t *)CAN_MB24_LENGTH)
#define pCAN_MB24_TIMESTAMP ((volatile uint16_t *)CAN_MB24_TIMESTAMP)
#define pCAN_MB24_ID0       ((volatile uint16_t *)CAN_MB24_ID0)
#define pCAN_MB24_ID1       ((volatile uint16_t *)CAN_MB24_ID1)

#define pCAN_MB25_DATA0     ((volatile uint16_t *)CAN_MB25_DATA0)
#define pCAN_MB25_DATA1     ((volatile uint16_t *)CAN_MB25_DATA1)
#define pCAN_MB25_DATA2     ((volatile uint16_t *)CAN_MB25_DATA2)
#define pCAN_MB25_DATA3     ((volatile uint16_t *)CAN_MB25_DATA3)
#define pCAN_MB25_LENGTH    ((volatile uint16_t *)CAN_MB25_LENGTH)
#define pCAN_MB25_TIMESTAMP ((volatile uint16_t *)CAN_MB25_TIMESTAMP)
#define pCAN_MB25_ID0       ((volatile uint16_t *)CAN_MB25_ID0)
#define pCAN_MB25_ID1       ((volatile uint16_t *)CAN_MB25_ID1)

#define pCAN_MB26_DATA0     ((volatile uint16_t *)CAN_MB26_DATA0)
#define pCAN_MB26_DATA1     ((volatile uint16_t *)CAN_MB26_DATA1)
#define pCAN_MB26_DATA2     ((volatile uint16_t *)CAN_MB26_DATA2)
#define pCAN_MB26_DATA3     ((volatile uint16_t *)CAN_MB26_DATA3)
#define pCAN_MB26_LENGTH    ((volatile uint16_t *)CAN_MB26_LENGTH)
#define pCAN_MB26_TIMESTAMP ((volatile uint16_t *)CAN_MB26_TIMESTAMP)
#define pCAN_MB26_ID0       ((volatile uint16_t *)CAN_MB26_ID0)
#define pCAN_MB26_ID1       ((volatile uint16_t *)CAN_MB26_ID1)

#define pCAN_MB27_DATA0     ((volatile uint16_t *)CAN_MB27_DATA0)
#define pCAN_MB27_DATA1     ((volatile uint16_t *)CAN_MB27_DATA1)
#define pCAN_MB27_DATA2     ((volatile uint16_t *)CAN_MB27_DATA2)
#define pCAN_MB27_DATA3     ((volatile uint16_t *)CAN_MB27_DATA3)
#define pCAN_MB27_LENGTH    ((volatile uint16_t *)CAN_MB27_LENGTH)
#define pCAN_MB27_TIMESTAMP ((volatile uint16_t *)CAN_MB27_TIMESTAMP)
#define pCAN_MB27_ID0       ((volatile uint16_t *)CAN_MB27_ID0)
#define pCAN_MB27_ID1       ((volatile uint16_t *)CAN_MB27_ID1)

#define pCAN_MB28_DATA0     ((volatile uint16_t *)CAN_MB28_DATA0)
#define pCAN_MB28_DATA1     ((volatile uint16_t *)CAN_MB28_DATA1)
#define pCAN_MB28_DATA2     ((volatile uint16_t *)CAN_MB28_DATA2)
#define pCAN_MB28_DATA3     ((volatile uint16_t *)CAN_MB28_DATA3)
#define pCAN_MB28_LENGTH    ((volatile uint16_t *)CAN_MB28_LENGTH)
#define pCAN_MB28_TIMESTAMP ((volatile uint16_t *)CAN_MB28_TIMESTAMP)
#define pCAN_MB28_ID0       ((volatile uint16_t *)CAN_MB28_ID0)
#define pCAN_MB28_ID1       ((volatile uint16_t *)CAN_MB28_ID1)

#define pCAN_MB29_DATA0     ((volatile uint16_t *)CAN_MB29_DATA0)
#define pCAN_MB29_DATA1     ((volatile uint16_t *)CAN_MB29_DATA1)
#define pCAN_MB29_DATA2     ((volatile uint16_t *)CAN_MB29_DATA2)
#define pCAN_MB29_DATA3     ((volatile uint16_t *)CAN_MB29_DATA3)
#define pCAN_MB29_LENGTH    ((volatile uint16_t *)CAN_MB29_LENGTH)
#define pCAN_MB29_TIMESTAMP ((volatile uint16_t *)CAN_MB29_TIMESTAMP)
#define pCAN_MB29_ID0       ((volatile uint16_t *)CAN_MB29_ID0)
#define pCAN_MB29_ID1       ((volatile uint16_t *)CAN_MB29_ID1)

#define pCAN_MB30_DATA0     ((volatile uint16_t *)CAN_MB30_DATA0)
#define pCAN_MB30_DATA1     ((volatile uint16_t *)CAN_MB30_DATA1)
#define pCAN_MB30_DATA2     ((volatile uint16_t *)CAN_MB30_DATA2)
#define pCAN_MB30_DATA3     ((volatile uint16_t *)CAN_MB30_DATA3)
#define pCAN_MB30_LENGTH    ((volatile uint16_t *)CAN_MB30_LENGTH)
#define pCAN_MB30_TIMESTAMP ((volatile uint16_t *)CAN_MB30_TIMESTAMP)
#define pCAN_MB30_ID0       ((volatile uint16_t *)CAN_MB30_ID0)
#define pCAN_MB30_ID1       ((volatile uint16_t *)CAN_MB30_ID1)

#define pCAN_MB31_DATA0     ((volatile uint16_t *)CAN_MB31_DATA0)
#define pCAN_MB31_DATA1     ((volatile uint16_t *)CAN_MB31_DATA1)
#define pCAN_MB31_DATA2     ((volatile uint16_t *)CAN_MB31_DATA2)
#define pCAN_MB31_DATA3     ((volatile uint16_t *)CAN_MB31_DATA3)
#define pCAN_MB31_LENGTH    ((volatile uint16_t *)CAN_MB31_LENGTH)
#define pCAN_MB31_TIMESTAMP ((volatile uint16_t *)CAN_MB31_TIMESTAMP)
#define pCAN_MB31_ID0       ((volatile uint16_t *)CAN_MB31_ID0)
#define pCAN_MB31_ID1       ((volatile uint16_t *)CAN_MB31_ID1)


/* CAN Mailbox Area Macros      */
#define pCAN_MB_ID1(x)          ((volatile uint16_t *)CAN_MB_ID1(x))
#define pCAN_MB_ID0(x)          ((volatile uint16_t *)CAN_MB_ID0(x))
#define pCAN_MB_TIMESTAMP(x)    ((volatile uint16_t *)CAN_MB_TIMESTAMP(x))
#define pCAN_MB_LENGTH(x)       ((volatile uint16_t *)CAN_MB_LENGTH(x))
#define pCAN_MB_DATA3(x)        ((volatile uint16_t *)CAN_MB_DATA3(x))
#define pCAN_MB_DATA2(x)        ((volatile uint16_t *)CAN_MB_DATA2(x))
#define pCAN_MB_DATA1(x)        ((volatile uint16_t *)CAN_MB_DATA1(x))
#define pCAN_MB_DATA0(x)        ((volatile uint16_t *)CAN_MB_DATA0(x))


/* Motor Control PWM1 Registers (0xFFC03000 - 0xFFC030FF) */
#define pPWM1_CTRL     ((volatile uint16_t *)PWM1_CTRL)
#define pPWM1_STAT     ((volatile uint16_t *)PWM1_STAT)
#define pPWM1_TM       ((volatile uint16_t *)PWM1_TM)
#define pPWM1_DT       ((volatile uint16_t *)PWM1_DT)
#define pPWM1_GATE     ((volatile uint16_t *)PWM1_GATE)
#define pPWM1_CHA      ((volatile uint16_t *)PWM1_CHA)
#define pPWM1_CHB      ((volatile uint16_t *)PWM1_CHB)
#define pPWM1_CHC      ((volatile uint16_t *)PWM1_CHC)
#define pPWM1_SEG      ((volatile uint16_t *)PWM1_SEG)
#define pPWM1_SYNCWT   ((volatile uint16_t *)PWM1_SYNCWT)
#define pPWM1_CHAL     ((volatile uint16_t *)PWM1_CHAL)
#define pPWM1_CHBL     ((volatile uint16_t *)PWM1_CHBL)
#define pPWM1_CHCL     ((volatile uint16_t *)PWM1_CHCL)
#define pPWM1_LSI      ((volatile uint16_t *)PWM1_LSI)
#define pPWM1_STAT2    ((volatile uint16_t *)PWM1_STAT2)


/* ADC Controller Module Registers (0xFFC03100 - 0xFFC031FF) */
#define pACM_CTL        ((volatile uint16_t *)ACM_CTL)
#define pACM_TC0        ((volatile uint16_t *)ACM_TC0)
#define pACM_TC1        ((volatile uint16_t *)ACM_TC1)
#define pACM_STAT       ((volatile uint16_t *)ACM_STAT)
#define pACM_ES         ((volatile uint16_t *)ACM_ES)
#define pACM_IMSK       ((volatile uint16_t *)ACM_IMSK)
#define pACM_MS         ((volatile uint16_t *)ACM_MS)
#define pACM_EMSK       ((volatile uint16_t *)ACM_EMSK)

#define pACM_ER0        ((volatile uint16_t *)ACM_ER0)
#define pACM_ER1        ((volatile uint16_t *)ACM_ER1)
#define pACM_ER2        ((volatile uint16_t *)ACM_ER2)
#define pACM_ER3        ((volatile uint16_t *)ACM_ER3)
#define pACM_ER4        ((volatile uint16_t *)ACM_ER4)
#define pACM_ER5        ((volatile uint16_t *)ACM_ER5)
#define pACM_ER6        ((volatile uint16_t *)ACM_ER6)
#define pACM_ER7        ((volatile uint16_t *)ACM_ER7)
#define pACM_ER8        ((volatile uint16_t *)ACM_ER8)
#define pACM_ER9        ((volatile uint16_t *)ACM_ER9)
#define pACM_ER10       ((volatile uint16_t *)ACM_ER10)
#define pACM_ER11       ((volatile uint16_t *)ACM_ER11)
#define pACM_ER12       ((volatile uint16_t *)ACM_ER12)
#define pACM_ER13       ((volatile uint16_t *)ACM_ER13)
#define pACM_ER14       ((volatile uint16_t *)ACM_ER14)
#define pACM_ER15       ((volatile uint16_t *)ACM_ER15)

#define pACM_ET0        ((volatile uint32_t *)ACM_ET0)
#define pACM_ET1        ((volatile uint32_t *)ACM_ET1)
#define pACM_ET2        ((volatile uint32_t *)ACM_ET2)
#define pACM_ET3        ((volatile uint32_t *)ACM_ET3)
#define pACM_ET4        ((volatile uint32_t *)ACM_ET4)
#define pACM_ET5        ((volatile uint32_t *)ACM_ET5)
#define pACM_ET6        ((volatile uint32_t *)ACM_ET6)
#define pACM_ET7        ((volatile uint32_t *)ACM_ET7)
#define pACM_ET8        ((volatile uint32_t *)ACM_ET8)
#define pACM_ET9        ((volatile uint32_t *)ACM_ET9)
#define pACM_ET10       ((volatile uint32_t *)ACM_ET10)
#define pACM_ET11       ((volatile uint32_t *)ACM_ET11)
#define pACM_ET12       ((volatile uint32_t *)ACM_ET12)
#define pACM_ET13       ((volatile uint32_t *)ACM_ET13)
#define pACM_ET14       ((volatile uint32_t *)ACM_ET14)
#define pACM_ET15       ((volatile uint32_t *)ACM_ET15)

#define pACM_TMR0       ((volatile uint32_t *)ACM_TMR0)
#define pACM_TMR1       ((volatile uint32_t *)ACM_TMR1)


/* Pin Control Registers (0xFFC03200 - 0xFFC032FF) */
#define pPORTF_FER      ((volatile uint16_t *)PORTF_FER)
#define pPORTG_FER      ((volatile uint16_t *)PORTG_FER)
#define pPORTH_FER      ((volatile uint16_t *)PORTH_FER)

/* GPIO PIN mux (0xFFC03210 - OxFFC03288) */

#define pPORTF_MUX        ((volatile uint16_t *)PORTF_MUX)
#define pPORTG_MUX        ((volatile uint16_t *)PORTG_MUX)
#define pPORTH_MUX        ((volatile uint16_t *)PORTH_MUX)
#define pPORTF_HYSTERESIS ((volatile uint16_t *)PORTF_HYSTERESIS)
#define pPORTG_HYSTERESIS ((volatile uint16_t *)PORTG_HYSTERESIS)
#define pPORTH_HYSTERESIS ((volatile uint16_t *)PORTH_HYSTERESIS)

#define pNONGPIO_DRIVE      ((volatile uint16_t *)NONGPIO_DRIVE)
#define pNONGPIO_HYSTERESIS ((volatile uint16_t *)NONGPIO_HYSTERESIS)

#define pFLASH_CONTROL        ((volatile uint16_t *)FLASH_CONTROL)
#define pFLASH_CONTROL_SET    ((volatile uint16_t *)FLASH_CONTROL_SET)
#define pFLASH_CONTROL_CLEAR  ((volatile uint16_t *)FLASH_CONTROL_CLEAR)


/* Counter 1 Registers      (0xFFC03300 - 0xFFC033FF)*/
#define pCNT1_CONFIG        ((volatile uint16_t *)CNT1_CONFIG)
#define pCNT1_IMASK         ((volatile uint16_t *)CNT1_IMASK)
#define pCNT1_STATUS        ((volatile uint16_t *)CNT1_STATUS)
#define pCNT1_COMMAND       ((volatile uint16_t *)CNT1_COMMAND)
#define pCNT1_DEBOUNCE      ((volatile uint16_t *)CNT1_DEBOUNCE)
#define pCNT1_COUNTER       ((volatile uint32_t *)CNT1_COUNTER)
#define pCNT1_MAX           ((volatile uint32_t *)CNT1_MAX)
#define pCNT1_MIN           ((volatile uint32_t *)CNT1_MIN)


/* SPI1 Controller      (0xFFC03400 - 0xFFC034FF)*/
#define pSPI1_CTL       ((volatile uint16_t *)SPI1_CTL)
#define pSPI1_FLG       ((volatile uint16_t *)SPI1_FLG)
#define pSPI1_STAT      ((volatile uint16_t *)SPI1_STAT)
#define pSPI1_TDBR      ((volatile uint16_t *)SPI1_TDBR)
#define pSPI1_RDBR      ((volatile uint16_t *)SPI1_RDBR)
#define pSPI1_BAUD      ((volatile uint16_t *)SPI1_BAUD)
#define pSPI1_SHADOW        ((volatile uint16_t *)SPI1_SHADOW)


/* Counter 0 Registers      (0xFFC03500 - 0xFFC035FF)*/
#define pCNT0_CONFIG        ((volatile uint16_t *)CNT0_CONFIG)
#define pCNT0_IMASK         ((volatile uint16_t *)CNT0_IMASK)
#define pCNT0_STATUS        ((volatile uint16_t *)CNT0_STATUS)
#define pCNT0_COMMAND       ((volatile uint16_t *)CNT0_COMMAND)
#define pCNT0_DEBOUNCE      ((volatile uint16_t *)CNT0_DEBOUNCE)
#define pCNT0_COUNTER       ((volatile uint32_t *)CNT0_COUNTER)
#define pCNT0_MAX           ((volatile uint32_t *)CNT0_MAX)
#define pCNT0_MIN           ((volatile uint32_t *)CNT0_MIN)


/* Motor Control PWM0 Registers (0xFFC03700 - 0xFFC037FF) */
#define pPWM0_CTRL     ((volatile uint16_t *)PWM0_CTRL)
#define pPWM0_STAT     ((volatile uint16_t *)PWM0_STAT)
#define pPWM0_TM       ((volatile uint16_t *)PWM0_TM)
#define pPWM0_DT       ((volatile uint16_t *)PWM0_DT)
#define pPWM0_GATE     ((volatile uint16_t *)PWM0_GATE)
#define pPWM0_CHA      ((volatile uint16_t *)PWM0_CHA)
#define pPWM0_CHB      ((volatile uint16_t *)PWM0_CHB)
#define pPWM0_CHC      ((volatile uint16_t *)PWM0_CHC)
#define pPWM0_SEG      ((volatile uint16_t *)PWM0_SEG)
#define pPWM0_SYNCWT   ((volatile uint16_t *)PWM0_SYNCWT)
#define pPWM0_CHAL     ((volatile uint16_t *)PWM0_CHAL)
#define pPWM0_CHBL     ((volatile uint16_t *)PWM0_CHBL)
#define pPWM0_CHCL     ((volatile uint16_t *)PWM0_CHCL)
#define pPWM0_LSI      ((volatile uint16_t *)PWM0_LSI)
#define pPWM0_STAT2    ((volatile uint16_t *)PWM0_STAT2)


/* RSI Registers (0xFFC03800 - 0xFFC03CFF) */
#define pRSI_PWR_CONTROL        ((volatile uint16_t *)RSI_PWR_CONTROL)
#define pRSI_CLK_CONTROL        ((volatile uint16_t *)RSI_CLK_CONTROL)
#define pRSI_ARGUMENT           ((volatile uint32_t *)RSI_ARGUMENT)
#define pRSI_COMMAND            ((volatile uint16_t *)RSI_COMMAND)
#define pRSI_RESP_CMD           ((volatile uint16_t *)RSI_RESP_CMD)
#define pRSI_RESPONSE0          ((volatile uint32_t *)RSI_RESPONSE0)
#define pRSI_RESPONSE1          ((volatile uint32_t *)RSI_RESPONSE1)
#define pRSI_RESPONSE2          ((volatile uint32_t *)RSI_RESPONSE2)
#define pRSI_RESPONSE3          ((volatile uint32_t *)RSI_RESPONSE3)
#define pRSI_DATA_TIMER         ((volatile uint32_t *)RSI_DATA_TIMER)
#define pRSI_DATA_LGTH          ((volatile uint16_t *)RSI_DATA_LGTH)
#define pRSI_DATA_CONTROL       ((volatile uint16_t *)RSI_DATA_CONTROL)
#define pRSI_DATA_CNT           ((volatile uint16_t *)RSI_DATA_CNT)
#define pRSI_STATUS         ((volatile uint32_t *)RSI_STATUS)
#define pRSI_STATUSCL           ((volatile uint16_t *)RSI_STATUSCL)
#define pRSI_MASK0          ((volatile uint32_t *)RSI_MASK0)
#define pRSI_MASK1          ((volatile uint32_t *)RSI_MASK1)
#define pRSI_FIFO_CNT           ((volatile uint16_t *)RSI_FIFO_CNT)
#define pRSI_CEATA_CONTROL      ((volatile uint16_t *)RSI_CEATA_CONTROL)
#define pRSI_FIFO               ((volatile uint32_t *)RSI_FIFO)
#define pRSI_ESTAT          ((volatile uint16_t *)RSI_ESTAT)
#define pRSI_EMASK          ((volatile uint16_t *)RSI_EMASK)
#define pRSI_CONFIG         ((volatile uint16_t *)RSI_CONFIG)
#define pRSI_RD_WAIT_EN         ((volatile uint16_t *)RSI_RD_WAIT_EN)
#define pRSI_PID0               ((volatile uint16_t *)RSI_PID0)
#define pRSI_PID1               ((volatile uint16_t *)RSI_PID1)
#define pRSI_PID2               ((volatile uint16_t *)RSI_PID2)
#define pRSI_PID3               ((volatile uint16_t *)RSI_PID3)



#ifdef _MISRA_RULES
#pragma diag(pop)
#endif /* _MISRA_RULES */

#endif  /*_CDEF_BF50X_H*/
