.TH SENDFILES %manext1% "October 21, 2012" "%nmhversion%"
.\"
.\" %nmhwarning%
.\"
.SH NAME
sendfiles \- send multiple files via a MIME message
.SH SYNOPSIS
.HP 5
.na
.B sendfiles
.RB [ -compress
.IR bzip2 " | " compress " | " gzip " | " lzma " | " none ]
.br
.RB [ \-from
.IR sender ]
.RI [ "\-delay n" " | " \-n ]
.RB [ \-version ]
.RB [ \-help ]
.br
.B \-to
.I recipient
.B \-subject
.IR subject " | "
.I recipient
.I subject
.br
.I file/directory1
.RI [ file/directory2
\&...]
.ad
.SH DESCRIPTION
The shell script
.BR sendfiles
is used to send a collection
of files and directories via electronic mail.
.PP
.B sendfiles
will archive the files and directories you name
with the
.B tar
command, and then mail the compressed
archive to the \*(lqrecipient\*(rq with the given \*(lqsubject\*(rq.
The archive
will be automatically split up into as many messages as necessary
in order to get past most mailers.
.PP
The
.B \-to
switch specifies the recipient.  The
.B \-subject
switch specifies the subject.  Alternatively, these two required values
can be provided without their corresponding switch names.
.PP
The
.B \-from
switch can, and should, be used to specify the sender's mailbox (name
and email address).  Alternatively, the
.B PERSON
environment variable can be used for the same purpose.
If neither is used,
.B sendfiles
will supply a \*(lqFrom:\*(rq header field using the sender's local
mailbox, see
.I localmbox
in
.IR mh-format (5).
.PP
The
.B \-compress
command line switch can be used to override the run-time determination
of the compression program by
.BR sendfiles .
.B \-compress
.I none
(alternatively,
.BR \-none )
disables compression.
.PP
Sometimes you want
.B sendfiles
to pause after posting a partial
message.  This is usually the case when you are running
.B sendmail
and expect to generate a lot of partial messages.  The
.B \-delay
switch specifies the number of seconds to pause in between postings,
e.g.,
.PP
.RS 5
sendfiles -delay 30 -to recipient -subject \*(lqsubject\*(rq files\0...
.RE
.PP
will pause 30 seconds in between each posting.  An alternate form of
the switch with just the delay time,
.BR \-30 ,
for example, is also supported.
.PP
.SS "Extracting the Received Files"
When these messages are received, invoke
.B mhstore
once for
the list of messages.  The default is for
.B mhstore
to store
the combined parts as a new message in the current folder, although
this can be changed using storage formatting strings.  You can then
use
.B mhlist
to find out what's inside; possibly followed by
.B mhstore
again to write the archive to a file where you can
subsequently uncompress and untar it.  For instance:
.PP
.RS 5
.nf
% mhlist 5-8
 msg part  type/subtype             size description
   5       message/partial           47K part 1 of 4
   6       message/partial           47K part 2 of 4
   7       message/partial           47K part 3 of 4
   8       message/partial           18K part 4 of 4
% mhstore 5-8
reassembling partials 5,6,7,8 to folder inbox as message 9
% mhlist -verbose 9
 msg part  type/subtype             size description
   9       application/octet-stream 118K
             (extract with uncompress | tar xvpf -)
             type=tar
             conversions=compress
% mhstore 9
% uncompress < 9.tar.Z | tar xvpf -
.fi
.RE
.PP
Alternately, by using the
.B \-auto
switch,
.B mhstore
will automatically do the extraction for you:
.PP
.RS 5
.nf
% mhlist 5-8
 msg part  type/subtype             size description
   5       message/partial           47K part 1 of 4
   6       message/partial           47K part 2 of 4
   7       message/partial           47K part 3 of 4
   8       message/partial           18K part 4 of 4
% mhstore 5-8
reassembling partials 5,6,7,8 to folder inbox as message 9
% mhlist -verbose 9
 msg part  type/subtype             size description
   9       application/octet-stream 118K
             (extract with uncompress | tar xvpf -)
             type=tar
             conversions=compress
% mhstore -auto 9
-- tar listing appears here as files are extracted
.fi
.RE
.PP
As the second
.B tar
listing is generated, the files are extracted.
A prudent user will never put
.B \-auto
in the
.I \&.mh\(ruprofile
file.  The correct procedure is to first use
.B mhlist
to find out what will be extracted.  Then
.B mhstore
can be invoked with
.B \-auto
to perform the extraction.
.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^$HOME/\&.mh\(ruprofile~^The user profile
.fi
.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
^Path:~^To determine the user's nmh directory
^Current\-Folder:~^To find the default current folder
.fi
.SH "SEE ALSO"
.IR mhbuild (1),
.IR mhlist (1),
.IR mhshow (1),
.IR mhstore (1),
.IR mh-format (5)
.PP
.I "Proposed Standard for Message Encapsulation"
(RFC 934)
.SH DEFAULTS
.nf
.RB ` "\-delay\ 0" '
.RB ` "\-from localmbox" '
.fi
.SH CONTEXT
None
