if (typeof T === 'undefined') require('../setup');

T('hypot', function () {

  function t(a, b, pr, rm, expected) {
    Decimal.precision = pr;
    Decimal.rounding = rm;
    T.assertEqual(expected, Decimal.hypot(a, b).valueOf());
  }

  Decimal.config({
    precision: 40,
    rounding: 4,
    toExpNeg: -9e15,
    toExpPos: 9e15,
    minE: -9e15,
    maxE: 9e15
  });

  t('1', 'NaN', 20, 4, 'NaN');
  t('NaN', '1', 20, 4, 'NaN');
  t('Infinity', 'NaN', 20, 4, 'Infinity');
  t('NaN', '-Infinity', 20, 4, 'Infinity');
  t('Infinity', '-9', 20, 4, 'Infinity');
  t('9', 'Infinity', 20, 4, 'Infinity');
  t('9', '-Infinity', 20, 4, 'Infinity');
  t('0', '0', 20, 4, '0');
  t('0', '-0', 20, 4, '0');
  t('-0', '-0', 20, 4, '0');

  t('-73859972487135996812.3348849386076204815086183608621433996131', '-40900275', 92, 4, '73859972487135996812.334896262958542538634842711692934521304033086425417371740907212824629036');
  t('87777821928367383886207001990043726894046439498880958101', '13100000', 53, 2, '87777821928367383886207001990043726894046439498880959000');
  t('-9068023035566545177890098186515752036653463863403529285431568942304.1209958989782427940509418772899870623734', '2666666666666.6666666666662666666666666666666666666666766666466666666666666666666666666668', 93, 5, '9068023035566545177890098186515752036653463863403529285431568942304.12099589897824279405094188');
  t('-19.8731062176484', '-631970.6', 60, 0, '631970.600312467344715323508497215861344293021711284138304041');
  t('-1111111111111141067315396649709360127244075372005400124355334298632449424416463580266666666666', '-0.0000000015372402412953773290762250418563358319557966420343267849914304381916024954828959476537495440147246975615343391', 43, 0, '1111111111111141067315396649709360127244076000000000000000000000000000000000000000000000000000');
  t('-0.983064721909232202799884070088', '-1888888888888371106396282947223787931710', 20, 4, '1888888888888371106400000000000000000000');
  t('861123450449582222', '-3268941330032700177909698138482', 73, 1, '3268941330032700177909698251903.062363755594001549793838456512462423760753');
  t('-1.759', '-0.1666933060407184714285777825813947232316520181597980844428', 8, 3, '1.7668807');
  t('0.1852451289933636289285652675346736246965605', '-48506.827382527105658688770367877324273166861983575641312454026244237512829473955620223096782936193504746', 48, 2, '48506.8273828808265642535390473175215096921677017');
  t('-3000008000000000000000070000000000000000000001000000000000.000000000000002000000000000000000900000000010002', '-802.661566839437264337325468337423185084', 22, 0, '3000008000000000000001000000000000000000000000000000000000');
  t('-8', '-5482493793', 53, 2, '5482493793.0000000058367599140481142689669647662254134');
  t('4111111111111111.11111111111611110111171111811111111611', '-0.7801745669150266383906952786894096943691775116027', 26, 1, '4111111111111111.1111111111');
  t('4649136268549586431953848205459087026588854116776105905', '-0.4538997053719724982993', 76, 4, '4649136268549586431953848205459087026588854116776105905');
  t('-711281636404745616773671624856748035918060782119438', '0.6011202051617683354856452418581', 80, 0, '711281636404745616773671624856748035918060782119438.00000000000000000000000000001');
  t('-55102601.0381', '-5160591', 93, 5, '55343729.0091054507509667515051408897750996134016431347788775107555545851579689419350413225929');
  t('183', '0.6', 22, 3, '183.0009836039139981977');
  t('4000000000080000000000000000000000', '0.55', 82, 0, '4000000000080000000000000000000000.000000000000000000000000000000000037812499999244');
  t('-0.55', '-9000000.000000000000000000000000000000000000000000000000000000000000000000000000000009', 62, 1, '9000000.0000000168055555555555398651834705075738799986293162621');
  t('-0.388099754174217471056249565014913560596333083573199500992', '0.0000363576265205', 75, 0, '0.388099755877229375967849346839104152672911497025034368058113842991365933724');
  t('52222222222227378067480110037255168691979179742111111111', '-867069820.333078943531805179108670644728376893549909696519412570032111919516568762799', 7, 2, '52222230000000000000000000000000000000000000000000000000');
  t('-8.0898982865397951925970316274645291728205275567128', '-0.0000945902', 28, 6, '8.089898287092787678956284349');
  t('-1664553204017852793900913959927482283751', '-933333388888.15884290172642527', 32, 1, '1664553204017852793900913959927400000000');
  t('-0.09771882084', '-8', 41, 2, '8.000596788236885020873363221344096704335');
  t('-10.11111111545', '-0.306711465294651568375461540673418284608909142237604855', 98, 2, '10.11576195409518993106696772029199668325921193685867908705991646038726063827463162781415087647978');
  t('-4437098359999999999993.9999', '-0.2241991', 56, 3, '4437098359999999999993.9999000000000000000000056642012823');
  t('901390573372408932467350822015112608121945120543338853670905789705602623427861.103187236210204922562771581943724285507586728737018434159395', '-23333333333333333351020223106390010419253302605986582847591694927992733993338709578970900366475156635422035555555', 18, 0, '23333333333333333400000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000');
  t('19999999999999999999999999999999.919999999999999999999', '-95670705629746263190920599520452475212900072593749902459133558626394349560336068069498100861613875411', 24, 6, '95670705629746263190920600000000000000000000000000000000000000000000000000000000000000000000000000000');
  t('459.273', '9638369683361034.552409', 63, 5, '9638369683361034.55240900001094229083644388522937457239375956406');
  t('19333333333.33313333333333', '-307058050750', 19, 4, '307666092230.143791');
  t('-4888.8813611', '61856704783261924843882364363459938129336598998376', 35, 6, '61856704783261924843882364363459938000000000000000');
  t('-90316963180999999999997999999999999.99999999999999959999999999999999999999999999999', '-899997034414865629076187032', 24, 0, '90316963181000004484176000000000000');
  t('-0.00001175529004148059889839195560772120687431522218537528816456748920635963047412762382567334499074596992570830887179621917584255805343012605460010989845894713567382571024', '59.8600988774488317444932', 22, 1, '59.86009887744998599287');
  t('-844444444444445105013379803702088715444444.44444444', '851735648360163016915210118100049528358186144013411569', 13, 2, '851735648360200000000000000000000000000000000000000000');
  t('-0.1098958603115877986399807307790849607335424187223724689574921530969578406825061416021390586394788741395795498746592063682753064315701974886', '-52222222222222262283923266176757777', 76, 5, '52222222222222262283923266176757777.00000000000000000000000000000000000011563');
  t('-10027999242546642659855555555555', '-703.824', 25, 3, '10027999242546642659855550000000');
  t('-17118682794143106193517128.496346472179213795', '19999999999999999997919330.00231406838630646574151545822388888888888888888', 38, 5, '26325829533112365449334045.441841092728');
  t('0.465596788868', '-9431769081', 29, 3, '9431769081.0000000000114920312');
  t('-587359.66395', '-0.49568003707000085674015751654640980033', 13, 5, '587359.6639502');
  t('-0.059956811106228018570509499080322651692489744383276282735', '0.7728191', 54, 5, '0.775141393890713275121528253795513914835075182802874717');
  t('2222215171676429123638899593785648371510606061543680191659124444444444.6906517318485520720388589138008481347302123923691909983086306231440651', '788888.888888885011536108582122208072284443333', 80, 6, '2222215171676429123638899593785648371510606061543680191659124444444444.6906517318');
  t('70000000000000010000000000006.100000000000004', '-78957772777.77777777777777777777777777777777777777277771777777777777', 1, 0, '80000000000000000000000000000');
  t('-41720000000020000000000000000000000000000000000000000700000000000000600000004000000001000000000000060000000000.00080000000000000006', '-46835015.87548144758089751035240583513', 34, 6, '41720000000020000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000');
  t('28666666666666666666666676666666666666666666666666616666666666666666666.6663666666666666666666666666666666666666666666666664666666666666666666', '-7.8461', 56, 4, '28666666666666666666666676666666666666666666666666616667000000000000000');
  t('0.6', '-91.5250722217761303', 63, 0, '91.5270388748665715095625471128327141160527733302883072128489811');
  t('30000.6', '511111111111145686553087261381.999991267342292294981021024064788686134890483114665388298481703', 51, 2, '511111111111145686553087261381.999991267342292294982');
  t('72926343.726877231000712798686463998173070827809981833334964558342793176683041794308836271', '-82222222222221937444', 49, 2, '82222222222221937444.00003234071924617295968730272');
  t('-242915822316177763142341053724.3195904798466883740740090079450439', '-299999999999.999999999999999999995999999999999999999999999999990999994', 51, 2, '242915822316177763142341053724.319590665096045830207');
  t('-306555555555555555555555055555555555555555555555555555559555555555555555555555555555555555555555555555555595555555555555555555555555555555555555555555525555555555555555555555555555555.5555555555', '0.15666773914679673976142669430328125908359330664846715765297103124831482667541495', 15, 3, '306555555555555000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000');
  t('-5734991.83220402694035812590544522858837047993475498775680667010453187699606727653014592756227908536357219129844096200521', '99399999.699', 55, 0, '99565305.56110721338952690556051338361260372609898394192');
  t('-0.585223', '9742275700501', 25, 1, '9742275700501');
  t('-817', '2706343113769608709474153626083514693465686442858333333333333333', 54, 2, '2706343113769608709474153626083514693465686442858333340000000000');
  t('521999999999199999929999999999999999.99999995999999', '-6777777777777777777777777.777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777777770777777775', 54, 2, '521999999999199999930044002175866866.547023411749520706');
  t('-4516475899411196.1710280841858351554959449', '0.00362', 26, 2, '4516475899411196.1710280842');
  t('79996999999999999999999999999999999999999999999.999999999999999999299999999999999599999999999999999996', '0.000000006393873924327515206665863616080266830154605167288849831012562983901', 32, 3, '79996999999999999999999999999999000000000000000');
  t('165014180635256662053.5623866609995456978976014664', '126847933143118145017958510547081.01687771', 82, 2, '126847933143118145017958617879061.6649297630723081683143413440383325550496316428679');
  t('4444444444.44444444444444444444444444444444444444444444', '0.0000390055319967605996065972540356157510147289248305250742502606', 19, 5, '4444444444.444444444');
  t('-8905370954396883647914407290800692779839518281513035906502493568844696561439275153317671748655256327646885877826948402873397232451', '0.000000002433575166551955655019349462492613256751863629697572595342683572506451544556497587139362820461701547049759568493058791704546964632763776550260691', 95, 6, '8905370954396883647914407290800692779839518281513035906502493568844696561439275153317671748655300000000000000000000000000000000000');
  t('700000000', '0.10532749524343436', 67, 4, '700000000.0000000000079242008958969198076099247634079046096355599626');
  t('9555555555555555555555555555555555555555.55555555555555555555555555555555555555555', '757773470777777777787727.7777777777777747777', 34, 5, '9555555555555555555555555555555586000000');
  t('-0.297233184499378290751031871', '94444444444450932925402136569369568252675313623114112449951937227491', 57, 4, '94444444444450932925402136569369568252675313623114112450000000000000');
  t('706.6640602786138076271815698607630793709065809977913853658899180593912800991919896234768331533404376463838897508518404177667748', '589272858', 76, 5, '589272858.0004237205967572977795909916847730224498576503592425079948021269944');
  t('141421829337978396523958245492.356577241347882862045', '-0.0000009062726880615943999813266035730355189554501814541380840728', 17, 3, '141421829337978390000000000000');
  t('288888418696038361803537630426270.71151743887471708693463333333333333', '-81195599558835246729685688119938533071101', 8, 4, '81195600000000000000000000000000000000000');
  t('382666666.66666666666', '-310.351', 17, 2, '382666666.66679252');
  t('509146', '27974901', 27, 1, '27979533.8704760590941855702');
  t('600075881745331917265194619524368592248337558828411479126381966442789', '-199999999959999999999999999999999999999999999999.9999999999999999999999999999999999999999999999999999', 68, 5, '600075881745331917265194619524368592248337592157529679693993900861880');
  t('33333333333333333333933.333', '92675418847792981854934.77651107680859649467120073', 26, 2, '98487787921777255092429.556');
  t('-194.04494819612983', '87934613325863285610318426691747541751704168685', 55, 3, '87934613325863285610318426691747541751704168685');
  t('-0.00006', '-9108555555555555755555555555555555555555555555.555855555555565555555555585555555', 69, 5, '9108555555555555755555555555555555555555555555.55585555555556555555556');
  t('-1867112.3', '-7443151922333351621784797114283077371961143985830384399', 98, 2, '7443151922333351621784797114283077371961143985830384399.0000000000000000000000000000000000000000003');
  t('0.640650325', '8337529018416437', 88, 1, '8337529018416437.000000000000000024613577836791740925174427714878489185918199187020262415');
  t('-7.0711298394245347979492394379496305607768672891309791', '-92.5549672712666393257898900443199898401181108080123982312500316214214726463524089322636338782070900725995605695513761536504989976346266550486346671844299550305743931825324317787', 26, 5, '92.824688762156584043556536');
  t('11.000500000000070000000000000000515', '-928864249591777933822222222', 69, 4, '928864249591777933822222222.000000000000000000000000065139227989011355');
  t('8.9929999999999999999999999999', '-94444444444444.7777777777777777777444449232900948624986161628952947337337208243', 100, 0, '94444444444444.77777777777820593447444492177895346249764146644605457433165778719182374051141272166291');
  t('-3', '8000000000', 48, 6, '8000000000.00000000056249999999999999998022460938');
  t('524224294278833258504244689131128804963', '-0.1964918169532600262422065880715612530725541194753716933743653473301573055', 92, 0, '524224294278833258504244689131128804963.00000000000000000000000000000000000000003682491879045');
  t('-5563710.400490441356383129065751744241271474147187007959891690143773431654594134378', '234644300000000000.86356426586528430874003818', 73, 4, '234644300000000000.8636302271381993667815855570906197025798452968278931064');
  t('0.005336508972581768759465256138116638362412237071722728683544001', '-2744818576', 62, 5, '2744818576.0000000000000051876521573143355893278038250258951491');
  t('6100958683940338086146995110755471006768600255866666666666666666', '95009361293210581532023714', 96, 2, '6100958683940338086146995110755471006768600255866666666666666666.00000000000073978363081733130453');
  t('4948457219440599111007826250603151703105812225460181157894774181631869', '-500000000050000000000000000000000000.7000000000600000000000000000000000000000000005', 23, 0, '4948457219440599111007900000000000000000000000000000000000000000000000');
  t('0.000000002979', '-9', 43, 1, '9.000000000000000000493024499999999999986495');
  t('0.47555305129875312820342601735', '-0.2673085693', 12, 0, '0.545531461807');
  t('3290866969805582657729329868.97622844503712282586503', '8996300581562651076861828923126756911315531038131347433298', 26, 5, '8996300581562651076861828900000000000000000000000000000000');
  t('-95721335544.654143365002196', '-1822222', 96, 1, '95721335561.9987248947602645712748098096888624484242375216519098735810157428711542690977103766782');
  t('0.974893703406145670332688066323452747831483011640048285105884619867888725281346574205291151337004770627960177971', '0.000239596749', 4, 6, '0.9749');
  t('-0.00012856579', '-21536540290437517549950.6925', 13, 0, '21536540290440000000000');
  t('6300828.297308463126', '-555138043489683551066925156982819307', 3, 4, '555000000000000000000000000000000000');
  t('0.4519719010451812700381881242155284703426402593258190987', '92346327717009585478189395590602.34545881237122995324639951758026247635570631069180557087', 55, 4, '92346327717009585478189395590602.3454588123712299532464');
  t('69398002688216703269792743800286307271116693445111111111111111', '-211393667179764005100083390018873694', 100, 0, '69398002688216703269792743800286307271116693445111111433074862.06409526630410784634920186057594444197');
  t('0.19', '-5288.143883', 42, 3, '5288.14388641329593020355143132324946951485');
});
