/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

var randu = require( '@stdlib/random/base/randu' );
var round = require( '@stdlib/math/base/special/round' );
var Float64Array = require( '@stdlib/array/float64' );
var Uint8ClampedArray = require( '@stdlib/array/uint8c' );
var gcopy = require( './../lib' );

var x;
var y;
var i;

x = new Float64Array( 10 );
y = new Uint8ClampedArray( 10 );
for ( i = 0; i < x.length; i++ ) {
	x[ i ] = round( randu()*500.0 );
	y[ i ] = round( randu()*255.0 );
}
console.log( x );
console.log( y );

// Copy elements from `x` into `y` starting from the end of `y`:
gcopy( x.length, x, 1, y, -1 );
console.log( y );
