/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Square root of `1/2`.
*
* @module @stdlib/constants/float64/sqrt-half
* @type {number}
*
* @example
* var SQRT_HALF = require( '@stdlib/constants/float64/sqrt-half' );
* // returns 0.7071067811865476
*/


// MAIN //

/**
* Square root of `1/2`.
*
* ```tex
* \sqrt{\frac{1}{2}}
* ```
*
* @constant
* @type {number}
* @default 0.7071067811865476
*/
var SQRT_HALF = 7.07106781186547524400844362104849039284835937688474036588339868995366239231053519425193767163820786367506923115e-01; // eslint-disable-line max-len


// EXPORTS //

module.exports = SQRT_HALF;
