<!--

@license Apache-2.0

Copyright (c) 2021 The Stdlib Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-->

# Markdown

> Markdown commands.

<!-- Section to include introductory text. Make sure to keep an empty line after the intro `section` element and another before the `/section` close. -->

<section class="intro">

This directory contains [`make`][make] rules for managing Markdown files.

</section>

<!-- /.intro -->

<!-- Usage documentation. -->

<section class="usage">

## Usage

```text
Usage: make <command> [<ENV_VAR>=<value> <ENV_VAR>=<value> ...]
```

### Commands

#### markdown-asset-url

Generates an asset URL (derived from the current Git hash) for inclusion in a project Markdown file.

<!-- run-disable -->

```bash
$ make markdown-asset-url MARKDOWN_ASSET_PATH='./README.md'
```

The command supports the following environment variables:

-   **MARKDOWN_ASSET_PATH**: a file path relative to the project root directory; e.g., `./README.md`.

* * *

### Namespace ToCs

#### markdown-namespace-tocs

Updates the table of contents of namespace Markdown files.

<!-- run-disable -->

```bash
$ make markdown-namespace-tocs
```

The command supports the following environment variables:

-   **MARKDOWN_PATTERN**: filename pattern; e.g., `*.md`.
-   **MARKDOWN_FILTER**: file path pattern; e.g., `.*/math/base/special/.*`

<!-- run-disable -->

```bash
$ make markdown-namespace-tocs MARKDOWN_PATTERN='README.md' MARKDOWN_FILTER='.*/math/base/special/.*'
```

This command is useful when wanting to glob for Markdown files (e.g., process all Markdown files for a particular package).

#### markdown-namespace-tocs-files

Updates the table of contents of a specified list of namespace Markdown files.

<!-- run-disable -->

```bash
$ make markdown-namespace-tocs-files FILES='/foo/foo.md /foo/bar.md'
```

The command supports the following environment variables:

-   **FILES**: list of Markdown files.

This command is useful when wanting to process a list of Markdown files generated by some other command (e.g., a list of changed Markdown files obtained via `git diff`).

* * *

### Package URLs

#### markdown-pkg-urls

Updates Markdown files by resolving package identifiers to GitHub repository URLs.

<!-- run-disable -->

```bash
$ make markdown-pkg-urls
```

The command supports the following environment variables:

-   **MARKDOWN_PATTERN**: filename pattern; e.g., `*.md`.
-   **MARKDOWN_FILTER**: file path pattern; e.g., `.*/math/base/special/.*`

<!-- run-disable -->

```bash
$ make markdown-pkg-urls MARKDOWN_PATTERN='README.md' MARKDOWN_FILTER='.*/math/base/special/.*'
```

This command is useful when wanting to glob for Markdown files (e.g., process all Markdown files for a particular package).

#### markdown-pkg-urls-files

Updates a specified list of Markdown files by resolving package identifiers to GitHub repository URLs.

<!-- run-disable -->

```bash
$ make markdown-pkg-urls-files FILES='/foo/foo.md /foo/bar.md'
```

The command supports the following environment variables:

-   **FILES**: list of Markdown files.

This command is useful when wanting to process a list of Markdown files generated by some other command (e.g., a list of changed Markdown files obtained via `git diff`).

* * *

### Equations

#### markdown-equations

Processes Markdown files containing Markdown equation elements.

<!-- run-disable -->

```bash
$ make markdown-equations
```

The command supports the following environment variables:

-   **MARKDOWN_PATTERN**: filename pattern; e.g., `*.md`.
-   **MARKDOWN_FILTER**: file path pattern; e.g., `.*/math/base/special/.*`

<!-- run-disable -->

```bash
$ make markdown-equations MARKDOWN_PATTERN='README.md' MARKDOWN_FILTER='.*/math/base/special/.*'
```

This command is useful when wanting to glob for Markdown files (e.g., process all Markdown files for a particular package).

Processed files are committed to source control. Accordingly, this command must be run on a clean working directory.

#### markdown-img-equations

Transforms Markdown files containing equation comment markup to include image equation elements.

<!-- run-disable -->

```bash
$ make markdown-img-equations
```

The command supports the following environment variables:

-   **MARKDOWN_PATTERN**: filename pattern; e.g., `*.md`.
-   **MARKDOWN_FILTER**: file path pattern; e.g., `.*/math/base/special/.*`

<!-- run-disable -->

```bash
$ make markdown-img-equations MARKDOWN_PATTERN='README.md' MARKDOWN_FILTER='.*/math/base/special/.*'
```

This command is useful when wanting to glob for Markdown files (e.g., process all Markdown files for a particular package).

#### markdown-img-equations-files

Transforms a specified list of Markdown files containing equation comment markup to include image equation elements.

<!-- run-disable -->

```bash
$ make markdown-img-equations-files FILES='/foo/foo.md /foo/bar.md'
```

The command supports the following environment variables:

-   **FILES**: list of Markdown files.

This command is useful when wanting to process a list of Markdown files generated by some other command (e.g., a list of changed Markdown files obtained via `git diff`).

#### markdown-img-equations-src-urls

Inserts resource URLs into Markdown image equation elements.

<!-- run-disable -->

```bash
$ make markdown-img-equations-src-urls
```

The command supports the following environment variables:

-   **MARKDOWN_PATTERN**: filename pattern; e.g., `*.md`.
-   **MARKDOWN_FILTER**: file path pattern; e.g., `.*/math/base/special/.*`

<!-- run-disable -->

```bash
$ make markdown-img-equations-src-urls MARKDOWN_PATTERN='README.md' MARKDOWN_FILTER='.*/math/base/special/.*'
```

This command is useful when wanting to glob for Markdown files (e.g., process all Markdown files for a particular package).

This command assumes that image SVG equation files already exist and have been committed to source control. See `markdown-svg-equations`.

#### markdown-img-equations-src-urls-files

Inserts resource URLs into Markdown image equation elements for a specified list of Markdown files.

<!-- run-disable -->

```bash
$ make markdown-img-equations-src-urls-files FILES='/foo/foo.md /foo/bar.md'
```

The command supports the following environment variables:

-   **FILES**: list of Markdown files.

This command is useful when wanting to process a list of Markdown files generated by some other command (e.g., a list of changed Markdown files obtained via `git diff`).

#### markdown-svg-equations

Generates SVG equation files from Markdown equation comments.

<!-- run-disable -->

```bash
$ make markdown-svg-equations
```

The command supports the following environment variables:

-   **MARKDOWN_PATTERN**: filename pattern; e.g., `*.md`.
-   **MARKDOWN_FILTER**: file path pattern; e.g., `.*/math/base/special/.*`

<!-- run-disable -->

```bash
$ make markdown-svg-equations MARKDOWN_PATTERN='README.md' MARKDOWN_FILTER='.*/math/base/special/.*'
```

This command is useful when wanting to glob for Markdown files (e.g., process all Markdown files for a particular package).

#### markdown-svg-equations-files

Generates SVG equation files from Markdown equation comments for a specified list of Markdown files.

<!-- run-disable -->

```bash
$ make markdown-svg-equations-files FILES='/foo/foo.md /foo/bar.md'
```

The command supports the following environment variables:

-   **FILES**: list of Markdown files.

This command is useful when wanting to process a list of Markdown files generated by some other command (e.g., a list of changed Markdown files obtained via `git diff`).

#### clean-markdown-svg-equations

Removes SVG equation files.

<!-- run-disable -->

```bash
$ make clean-markdown-svg-equations
```

The command supports the following environment variables:

-   **SVG_EQUATIONS_PATTERN**: filename pattern; e.g., `equation*.svg`.
-   **SVG_EQUATIONS_FILTER**: file path pattern; e.g., `.*/math/base/special/.*`

<!-- run-disable -->

```bash
$ make clean-markdown-svg-equations SVG_EQUATIONS_PATTERN='equation*.svg' SVG_EQUATIONS_FILTER='.*/math/base/special/.*'
```

</section>

<!-- /.usage -->

<!-- Section to include notes. Make sure to keep an empty line after the `section` element and another before the `/section` close. -->

<section class="notes">

</section>

<!-- /.notes -->

<!-- Section for all links. Make sure to keep an empty line after the `section` element and another before the `/section` close. -->

<section class="links">

[make]: https://www.gnu.org/software/make/

</section>

<!-- /.links -->
