import { Arbitrary } from './definition/Arbitrary';
export interface WeightedArbitrary<T> {
    weight: number;
    arbitrary: Arbitrary<T>;
}
/**
 * Infer the type of the Arbitrary produced by oneof
 * given the type of the source arbitraries
 */
declare type FrequencyArbitraryType<Ts extends WeightedArbitrary<unknown>[]> = {
    [K in keyof Ts]: Ts[K] extends WeightedArbitrary<infer U> ? U : never;
}[number];
/**
 * For one of the values generated by `...warbs` - the probability of selecting the ith warb is of `warb[i].weight / sum(warb[j].weight)`
 *
 * **WARNING**: It expects at least one (Arbitrary, weight)
 *
 * @param warbs (Arbitrary, weight)s that might be called to produce a value
 */
declare function frequency<Ts extends WeightedArbitrary<unknown>[]>(...warbs: Ts): Arbitrary<FrequencyArbitraryType<Ts>>;
export { frequency };
