import { Arbitrary } from './definition/Arbitrary';
/**
 * Infer the type of the Arbitrary produced by oneof
 * given the type of the source arbitraries
 */
declare type OneOfArbitraryType<Ts extends Arbitrary<unknown>[]> = {
    [K in keyof Ts]: Ts[K] extends Arbitrary<infer U> ? U : never;
}[number];
/**
 * For one of the values generated by `...arbs` - with all `...arbs` equiprobable
 *
 * **WARNING**: It expects at least one arbitrary
 *
 * @param arbs Arbitraries that might be called to produce a value
 */
declare function oneof<Ts extends Arbitrary<unknown>[]>(...arbs: Ts): Arbitrary<OneOfArbitraryType<Ts>>;
export { oneof };
