[comment {-*- tcl -*- nxwish manpage}]

[include version.inc]
[manpage_begin nxwish 1 [vset VERSION]]

[copyright {2014-16 Stefan Sobernig <stefan.sobernig@wu.ac.at>, Gustaf Neumann <gustaf.neumann@wu.ac.at>; available under the Creative Commons Attribution 3.0 Austria license (CC BY 3.0 AT).}]

[titledesc {Simple windowing shell containing NSF/NX interpreter}]
[moddesc {Command-line interface}]

[description]

[list_begin definitions]

[call [syscmd "nxwish"] [opt [arg fileName]]]

[syscmd "nxwish"] is a shell-like application including Tcl and the NX extension as well as the Tk toolkit. [syscmd "nxwish"] creates a main window and, then, reads commands from its standard input or from [arg fileName] and evaluates them.  If invoked without [arg fileName], then it runs in REPL mode, reading commands from standard input. [syscmd "nxwish"] will continue processing commands until all windows have been deleted or until end-of-file is reached on standard input.

[para] 

[syscmd "nxwish"] can be used like [syscmd "wish"] to make NX scripts directly invokable from the shell, by providing the following first line ("shebang") in the respective script:

[example {
	#! /usr/bin/env nxwish 
}]

A (more portable) alternative is:

[example_begin]
	#! /bin/sh
	# the next line restarts using nxwish \
	    exec nxwish "$0" "$@"
[example_end]

[list_end]

[manpage_end]
