C> \ingroup nwxc 
C> @{ 
C> 
C> \file nwxcm_x_wpbe.F 
C> The nwxcm_x_wpbe functional 
C> 
C> @} 
C> 
C> \ingroup nwxc_priv 
C> @{ 
C> 
C> \brief Evaluate the nwxcm_x_wpbe functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{{{4}\over{3}}}\\\\ 
C>   {\it t_2} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_3} &=& {{1}\over{\rho_\alpha^4}}\\\\ 
C>   {\it t_4} &=& \sqrt{\sigma_{\alpha\alpha}}\\\\ 
C>   {\it t_5} &=& {\it t_4}^3\\\\ 
C>   {\it t_6} &=& {{1}\over{\rho_\alpha^{{{16}\over{3}}}}}\\\\ 
C>   {\it t_7} &=& \sigma_{\alpha\alpha}^2\\\\ 
C>   {\it t_8} &=& {{1}\over{\rho_\alpha^{{{20}\over{3}}}}}\\\\ 
C>   {\it t_9} &=& {\it t_4}^5\\\\ 
C>   {\it t_{10}} &=& {{1}\over{\rho_\alpha^8}}\\\\ 
C>   {\it t_{11}} &=& \sigma_{\alpha\alpha}^3\\\\ 
C>   {\it t_{12}} &=& {{1}\over{\rho_\alpha^{{{28}\over{3}}}}}\\\\ 
C>   {\it t_{13}} &=& {\it t_4}^7\\\\ 
C>   {\it t_{14}} &=& 2.41238302476954 \times 10^{-8}\,{\it t_{12}}
C>    \,{\it t_{13}}-4.327677396975467 \times 10^{-7}\,{\it t_{10}}
C>    \,{\it t_{11}}+5.3020963068324 \times 10^{-6}\,{\it t_8}\,{
C>    \it t_9}-4.342399100269002 \times 10^{-5}\,{\it t_6}\,{\it t_7}
C>    +1.800551313354082 \times 10^{-4}\,{\it t_3}\,{\it t_5}
C>    +2.631878392200375 \times 10^{-4}\,{\it t_2}\,
C>    \sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{15}} &=& {{1}\over{{{3.149302550983647 \times 10^{-10}
C>    \,{\it t_4}^9}\over{\rho_\alpha^{12}}}
C>    -{{5.649671283776346 \times 10^{-9}\,
C>    \sigma_{\alpha\alpha}^4}\over{\rho_\alpha^{{{32}\over{3}}}}}
C>    +1.7578986477855 \times 10^{-7}\,{\it t_{12}}\,{\it t_{13}}
C>    -2.719683267627703 \times 10^{-6}\,{\it t_{10}}\,{\it t_{11}}
C>    +5.955909787676884 \times 10^{-5}\,{\it t_8}\,{\it t_9}
C>    -0.001383706469760652\,{\it t_6}\,{\it t_7}
C>    +0.02342799068769956\,{\it t_3}\,{\it t_5}-0.2053293313026446
C>    \,{\it t_2}\,\sigma_{\alpha\alpha}+{{0.6841322473346062\,{
C>    \it t_4}}\over{{\it t_1}}}+1.0}}\\\\ 
C>   {\it t_{16}} &=& 0.01645530784602056\,{\it t_2}\,
C>    \sigma_{\alpha\alpha}\,{\it t_{14}}\,{\it t_{15}}\\\\ 
C>   {\it t_{17}} &=& {\it t_{16}}+0.60965\\\\ 
C>   {\it t_{18}} &=& 0.06934448603031025\,{\it t_2}\,
C>    \sigma_{\alpha\alpha}\,{\it t_{14}}\,{\it t_{15}}
C>    +{{0.005136628594837796\,{\it t_2}\,
C>    \sigma_{\alpha\alpha}}\over{0.00411382696150514\,{\it t_2}
C>    \,\sigma_{\alpha\alpha}+1.0}}+1.0\\\\ 
C>   {\it t_{19}} &=& {\it t_{17}}^{3.5}\\\\ 
C>   {\it t_{20}} &=& {\it t_{16}}+0.757211\\\\ 
C>   {\it t_{21}} &=& {\it param}\left(1\right)\\\\ 
C>   {\it t_{22}} &=& {{1}\over{\rho_\alpha^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{23}} &=& {\it t_{16}}+0.06582123138408225\,\left({
C>    \it t_{21}}\,{\it t_{22}}\right)^{2.0}+0.60965\\\\ 
C>   {\it t_{24}} &=& {{1}\over{\sqrt{{\it t_{23}}}}}\\\\ 
C>   {\it t_{25}} &=& 0.2565564877060844\,{\it t_{21}}\,{\it t_{22}}
C>    \,{\it t_{24}}+1.0\\\\ 
C>   {\it t_{26}} &=& {\it t_{23}}\,{\it t_{25}}\\\\ 
C>   {\it t_{27}} &=& 0.2565564877060844\,{\it t_{21}}\,{
C>    \it t_{22}}\\\\ 
C>   {\it t_{28}} &=& {\it t_{21}}^2\\\\ 
C>   {\it t_{29}} &=& {{0.06582123138408225\,{\it t_{28}}}
C>    \over{\rho_\alpha^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{30}} &=& \sqrt{{\it t_{16}}+{\it t_{29}}}\\\\ 
C>   {\it t_{31}} &=& \sqrt{{\it t_{16}}+{\it t_{29}}+0.757211}\\\\ 
C>   {\it t_{32}} &=& {{1}\over{{\it t_{31}}+{\it t_{30}}}}\\\\ 
C>   {\it t_{33}} &=& \sqrt{{\it t_{16}}+{\it t_{29}}+0.60965}\\\\ 
C>   {\it t_{34}} &=& {{1}\over{{\it t_{33}}+{\it t_{27}}}}\\\\ 
C>   {\it t_{35}} &=& \rho_\beta^{{{4}\over{3}}}\\\\ 
C>   {\it t_{36}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{37}} &=& {{1}\over{\rho_\beta^4}}\\\\ 
C>   {\it t_{38}} &=& \sqrt{\sigma_{\beta\beta}}\\\\ 
C>   {\it t_{39}} &=& {\it t_{38}}^3\\\\ 
C>   {\it t_{40}} &=& {{1}\over{\rho_\beta^{{{16}\over{3}}}}}\\\\ 
C>   {\it t_{41}} &=& \sigma_{\beta\beta}^2\\\\ 
C>   {\it t_{42}} &=& {{1}\over{\rho_\beta^{{{20}\over{3}}}}}\\\\ 
C>   {\it t_{43}} &=& {\it t_{38}}^5\\\\ 
C>   {\it t_{44}} &=& {{1}\over{\rho_\beta^8}}\\\\ 
C>   {\it t_{45}} &=& \sigma_{\beta\beta}^3\\\\ 
C>   {\it t_{46}} &=& {{1}\over{\rho_\beta^{{{28}\over{3}}}}}\\\\ 
C>   {\it t_{47}} &=& {\it t_{38}}^7\\\\ 
C>   {\it t_{48}} &=& 2.41238302476954 \times 10^{-8}\,{\it t_{46}}
C>    \,{\it t_{47}}-4.327677396975467 \times 10^{-7}\,{\it t_{44}}
C>    \,{\it t_{45}}+5.3020963068324 \times 10^{-6}\,{\it t_{42}}
C>    \,{\it t_{43}}-4.342399100269002 \times 10^{-5}\,{\it t_{40}}
C>    \,{\it t_{41}}+1.800551313354082 \times 10^{-4}\,{\it t_{37}}
C>    \,{\it t_{39}}+2.631878392200375 \times 10^{-4}\,{\it t_{36}}
C>    \,\sigma_{\beta\beta}\\\\ 
C>   {\it t_{49}} &=& {{1}\over{{{3.149302550983647 \times 10^{-10}
C>    \,{\it t_{38}}^9}\over{\rho_\beta^{12}}}
C>    -{{5.649671283776346 \times 10^{-9}\,
C>    \sigma_{\beta\beta}^4}\over{\rho_\beta^{{{32}\over{3}}}}}
C>    +1.7578986477855 \times 10^{-7}\,{\it t_{46}}\,{\it t_{47}}
C>    -2.719683267627703 \times 10^{-6}\,{\it t_{44}}\,{\it t_{45}}
C>    +5.955909787676884 \times 10^{-5}\,{\it t_{42}}\,{\it t_{43}}
C>    -0.001383706469760652\,{\it t_{40}}\,{\it t_{41}}
C>    +0.02342799068769956\,{\it t_{37}}\,{\it t_{39}}
C>    -0.2053293313026446\,{\it t_{36}}\,\sigma_{\beta\beta}
C>    +{{0.6841322473346062\,{\it t_{38}}}\over{{\it t_{35}}}}
C>    +1.0}}\\\\ 
C>   {\it t_{50}} &=& 0.01645530784602056\,{\it t_{36}}\,
C>    \sigma_{\beta\beta}\,{\it t_{48}}\,{\it t_{49}}\\\\ 
C>   {\it t_{51}} &=& {\it t_{50}}+0.60965\\\\ 
C>   {\it t_{52}} &=& 0.06934448603031025\,{\it t_{36}}\,
C>    \sigma_{\beta\beta}\,{\it t_{48}}\,{\it t_{49}}
C>    +{{0.005136628594837796\,{\it t_{36}}\,
C>    \sigma_{\beta\beta}}\over{0.00411382696150514\,{\it t_{36}}
C>    \,\sigma_{\beta\beta}+1.0}}+1.0\\\\ 
C>   {\it t_{53}} &=& {\it t_{51}}^{3.5}\\\\ 
C>   {\it t_{54}} &=& {\it t_{50}}+0.757211\\\\ 
C>   {\it t_{55}} &=& {{1}\over{\rho_\beta^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{56}} &=& {\it t_{50}}+0.06582123138408225\,\left({
C>    \it t_{21}}\,{\it t_{55}}\right)^{2.0}+0.60965\\\\ 
C>   {\it t_{57}} &=& {{1}\over{\sqrt{{\it t_{56}}}}}\\\\ 
C>   {\it t_{58}} &=& 0.2565564877060844\,{\it t_{21}}\,{\it t_{55}}
C>    \,{\it t_{57}}+1.0\\\\ 
C>   {\it t_{59}} &=& {\it t_{56}}\,{\it t_{58}}\\\\ 
C>   {\it t_{60}} &=& 0.2565564877060844\,{\it t_{21}}\,{
C>    \it t_{55}}\\\\ 
C>   {\it t_{61}} &=& {{0.06582123138408225\,{\it t_{28}}}
C>    \over{\rho_\beta^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{62}} &=& \sqrt{{\it t_{50}}+{\it t_{61}}}\\\\ 
C>   {\it t_{63}} &=& \sqrt{{\it t_{50}}+{\it t_{61}}+0.757211}\\\\ 
C>   {\it t_{64}} &=& {{1}\over{{\it t_{63}}+{\it t_{62}}}}\\\\ 
C>   {\it t_{65}} &=& \sqrt{{\it t_{50}}+{\it t_{61}}+0.60965}\\\\ 
C>   {\it t_{66}} &=& {{1}\over{{\it t_{65}}+{\it t_{60}}}}\\\\ 
C>   {\it t_{67}} &=& \rho_s^{{{4}\over{3}}}\\\\ 
C>   {\it t_{68}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{69}} &=& {{1}\over{\rho_s^4}}\\\\ 
C>   {\it t_{70}} &=& \sqrt{\sigma_{ss}}\\\\ 
C>   {\it t_{71}} &=& {\it t_{70}}^3\\\\ 
C>   {\it t_{72}} &=& {{1}\over{\rho_s^{{{16}\over{3}}}}}\\\\ 
C>   {\it t_{73}} &=& \sigma_{ss}^2\\\\ 
C>   {\it t_{74}} &=& {{1}\over{\rho_s^{{{20}\over{3}}}}}\\\\ 
C>   {\it t_{75}} &=& {\it t_{70}}^5\\\\ 
C>   {\it t_{76}} &=& {{1}\over{\rho_s^8}}\\\\ 
C>   {\it t_{77}} &=& \sigma_{ss}^3\\\\ 
C>   {\it t_{78}} &=& {{1}\over{\rho_s^{{{28}\over{3}}}}}\\\\ 
C>   {\it t_{79}} &=& {\it t_{70}}^7\\\\ 
C>   {\it t_{80}} &=& 2.41238302476954 \times 10^{-8}\,{\it t_{78}}
C>    \,{\it t_{79}}-4.327677396975467 \times 10^{-7}\,{\it t_{76}}
C>    \,{\it t_{77}}+5.3020963068324 \times 10^{-6}\,{\it t_{74}}
C>    \,{\it t_{75}}-4.342399100269002 \times 10^{-5}\,{\it t_{72}}
C>    \,{\it t_{73}}+1.800551313354082 \times 10^{-4}\,{\it t_{69}}
C>    \,{\it t_{71}}+2.631878392200375 \times 10^{-4}\,{\it t_{68}}
C>    \,\sigma_{ss}\\\\ 
C>   {\it t_{81}} &=& {{1}\over{{{3.149302550983647 \times 10^{-10}
C>    \,{\it t_{70}}^9}\over{\rho_s^{12}}}
C>    -{{5.649671283776346 \times 10^{-9}\,\sigma_{ss}^4}
C>    \over{\rho_s^{{{32}\over{3}}}}}+1.7578986477855 \times 10^{-7}
C>    \,{\it t_{78}}\,{\it t_{79}}-2.719683267627703 \times 10^{-6}
C>    \,{\it t_{76}}\,{\it t_{77}}+5.955909787676884 \times 10^{-5}
C>    \,{\it t_{74}}\,{\it t_{75}}-0.001383706469760652\,{
C>    \it t_{72}}\,{\it t_{73}}+0.02342799068769956\,{\it t_{69}}
C>    \,{\it t_{71}}-0.2053293313026446\,{\it t_{68}}\,\sigma_{ss}
C>    +{{0.6841322473346062\,{\it t_{70}}}\over{{\it t_{67}}}}
C>    +1.0}}\\\\ 
C>   {\it t_{82}} &=& 0.01645530784602056\,{\it t_{68}}\,\sigma_{ss}
C>    \,{\it t_{80}}\,{\it t_{81}}\\\\ 
C>   {\it t_{83}} &=& {\it t_{82}}+0.60965\\\\ 
C>   {\it t_{84}} &=& 0.06934448603031025\,{\it t_{68}}\,\sigma_{ss}
C>    \,{\it t_{80}}\,{\it t_{81}}+{{0.005136628594837796\,{
C>    \it t_{68}}\,\sigma_{ss}}\over{0.00411382696150514\,{
C>    \it t_{68}}\,\sigma_{ss}+1.0}}+1.0\\\\ 
C>   {\it t_{85}} &=& {\it t_{83}}^{3.5}\\\\ 
C>   {\it t_{86}} &=& {\it t_{82}}+0.757211\\\\ 
C>   {\it t_{87}} &=& {{1}\over{\rho_s^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{88}} &=& {\it t_{82}}+0.06582123138408225\,\left({
C>    \it t_{21}}\,{\it t_{87}}\right)^{2.0}+0.60965\\\\ 
C>   {\it t_{89}} &=& {{1}\over{\sqrt{{\it t_{88}}}}}\\\\ 
C>   {\it t_{90}} &=& 0.2565564877060844\,{\it t_{21}}\,{\it t_{87}}
C>    \,{\it t_{89}}+1.0\\\\ 
C>   {\it t_{91}} &=& {\it t_{88}}\,{\it t_{90}}\\\\ 
C>   {\it t_{92}} &=& 0.2565564877060844\,{\it t_{21}}\,{
C>    \it t_{87}}\\\\ 
C>   {\it t_{93}} &=& {{0.06582123138408225\,{\it t_{28}}}
C>    \over{\rho_s^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{94}} &=& \sqrt{{\it t_{82}}+{\it t_{93}}}\\\\ 
C>   {\it t_{95}} &=& \sqrt{{\it t_{82}}+{\it t_{93}}+0.757211}\\\\ 
C>   {\it t_{96}} &=& {{1}\over{{\it t_{95}}+{\it t_{94}}}}\\\\ 
C>   {\it t_{97}} &=& \sqrt{{\it t_{82}}+{\it t_{93}}+0.60965}\\\\ 
C>   {\it t_{98}} &=& {{1}\over{{\it t_{97}}+{\it t_{92}}}}\\\\ 
C>   f &=& -0.9305257363491\,{\it t_{35}}\,\left(-2.0\,{\it t_{54}}
C>    \,\log \left({{0.1475609999999999\,{\it t_{66}}}\over{{
C>    \it t_{63}}+{\it t_{65}}}}+1.0\right)+0.03291061569204112\,{
C>    \it t_{36}}\,\sigma_{\beta\beta}\,{\it t_{48}}\,{\it t_{49}}
C>    \,\log \left(1.0-{{0.60965\,{\it t_{66}}}\over{{\it t_{65}}
C>    +{\it t_{62}}}}\right)+0.757211\,\left({{{\it t_{54}}\,{
C>    \it t_{64}}}\over{{\it t_{63}}+{\it t_{60}}}}
C>    +{{0.01645530784602056\,{\it t_{36}}\,\sigma_{\beta\beta}\,{
C>    \it t_{48}}\,{\it t_{49}}\,{\it t_{64}}}\over{{\it t_{62}}+{
C>    \it t_{60}}}}\right)+{{0.05273288888888888\,{\it t_{52}}
C>    \,\left(0.1282782438530422\,{\it t_{21}}\,{\it t_{55}}\,{
C>    \it t_{57}}+1.0\right)}\over{{\it t_{59}}^{2.0}}}
C>    +{{0.04727288888888889}\over{{\it t_{56}}\,{\it t_{58}}}}
C>    -{{0.8888888888888888\,\left(-2.4\,{\it t_{53}}\,
C>    \left(0.1282782438530422\,\sqrt{{\it t_{36}}\,
C>    \sigma_{\beta\beta}\,{\it t_{48}}\,{\it t_{49}}}-\sqrt{{
C>    \it t_{54}}}\right)-1.417963080724413\,{\it t_{53}}-0.9086532
C>    \,{\it t_{51}}^{3.0}+0.02836373333333333\,{\it t_{51}}^{2.0}
C>    +0.0474596\,{\it t_{51}}\,{\it t_{52}}\right)\,
C>    \left(0.02468296176903084\,\left({\it t_{21}}\,{\it t_{55}}
C>    \,{\it t_{57}}\right)^{2.0}+0.2886260486693449\,{\it t_{21}}
C>    \,{\it t_{55}}\,{\it t_{57}}+1.0\right)}\over{{
C>    \it t_{59}}^{3.0}}}-1.0\right)-0.9305257363491\,{\it t_1}
C>    \,\left(-2.0\,{\it t_{20}}\,\log \left({{0.1475609999999999
C>    \,{\it t_{34}}}\over{{\it t_{31}}+{\it t_{33}}}}+1.0\right)
C>    +0.03291061569204112\,{\it t_2}\,\sigma_{\alpha\alpha}\,{
C>    \it t_{14}}\,{\it t_{15}}\,\log \left(1.0-{{0.60965\,{
C>    \it t_{34}}}\over{{\it t_{33}}+{\it t_{30}}}}\right)+0.757211
C>    \,\left({{{\it t_{20}}\,{\it t_{32}}}\over{{\it t_{31}}+{
C>    \it t_{27}}}}+{{0.01645530784602056\,{\it t_2}\,
C>    \sigma_{\alpha\alpha}\,{\it t_{14}}\,{\it t_{15}}\,{
C>    \it t_{32}}}\over{{\it t_{30}}+{\it t_{27}}}}\right)
C>    +{{0.05273288888888888\,{\it t_{18}}\,\left(0.1282782438530422
C>    \,{\it t_{21}}\,{\it t_{22}}\,{\it t_{24}}+1.0\right)}
C>    \over{{\it t_{26}}^{2.0}}}+{{0.04727288888888889}\over{{
C>    \it t_{23}}\,{\it t_{25}}}}-{{0.8888888888888888\,\left(-2.4
C>    \,{\it t_{19}}\,\left(0.1282782438530422\,\sqrt{{\it t_2}
C>    \,\sigma_{\alpha\alpha}\,{\it t_{14}}\,{\it t_{15}}}-\sqrt{{
C>    \it t_{20}}}\right)-1.417963080724413\,{\it t_{19}}-0.9086532
C>    \,{\it t_{17}}^{3.0}+0.02836373333333333\,{\it t_{17}}^{2.0}
C>    +0.0474596\,{\it t_{17}}\,{\it t_{18}}\right)\,
C>    \left(0.02468296176903084\,\left({\it t_{21}}\,{\it t_{22}}
C>    \,{\it t_{24}}\right)^{2.0}+0.2886260486693449\,{\it t_{21}}
C>    \,{\it t_{22}}\,{\it t_{24}}+1.0\right)}\over{{
C>    \it t_{26}}^{3.0}}}-1.0\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& -0.9305257363491\,{\it t_{67}}\,\left(-2.0\,{\it t_{86}}
C>    \,\log \left({{0.1475609999999999\,{\it t_{98}}}\over{{
C>    \it t_{95}}+{\it t_{97}}}}+1.0\right)+0.03291061569204112\,{
C>    \it t_{68}}\,\sigma_{ss}\,{\it t_{80}}\,{\it t_{81}}
C>    \,\log \left(1.0-{{0.60965\,{\it t_{98}}}\over{{\it t_{97}}
C>    +{\it t_{94}}}}\right)+0.757211\,\left({{{\it t_{86}}\,{
C>    \it t_{96}}}\over{{\it t_{95}}+{\it t_{92}}}}
C>    +{{0.01645530784602056\,{\it t_{68}}\,\sigma_{ss}\,{
C>    \it t_{80}}\,{\it t_{81}}\,{\it t_{96}}}\over{{\it t_{94}}+{
C>    \it t_{92}}}}\right)+{{0.05273288888888888\,{\it t_{84}}
C>    \,\left(0.1282782438530422\,{\it t_{21}}\,{\it t_{87}}\,{
C>    \it t_{89}}+1.0\right)}\over{{\it t_{91}}^{2.0}}}
C>    +{{0.04727288888888889}\over{{\it t_{88}}\,{\it t_{90}}}}
C>    -{{0.8888888888888888\,\left(-2.4\,{\it t_{85}}\,
C>    \left(0.1282782438530422\,\sqrt{{\it t_{68}}\,\sigma_{ss}\,{
C>    \it t_{80}}\,{\it t_{81}}}-\sqrt{{\it t_{86}}}\right)
C>    -1.417963080724413\,{\it t_{85}}-0.9086532\,{\it t_{83}}^{3.0}
C>    +0.02836373333333333\,{\it t_{83}}^{2.0}+0.0474596\,{
C>    \it t_{83}}\,{\it t_{84}}\right)\,\left(0.02468296176903084
C>    \,\left({\it t_{21}}\,{\it t_{87}}\,{\it t_{89}}\right)^{2.0}
C>    +0.2886260486693449\,{\it t_{21}}\,{\it t_{87}}\,{\it t_{89}}
C>    +1.0\right)}\over{{\it t_{91}}^{3.0}}}-1.0\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] E Weintraub, TM Henderson, GE Scuseria
C>    , J.Chem.Theory.Comput. 5, 754 (2009)  , DOI: 
C> <a href="https://doi.org/10.1021/ct800530u "> 
C> 10.1021/ct800530u </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_x_wpbe(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Cmat) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = param(1)
            t2 = rhoa**3.333333333333333d-1
            t3 = 1/t2
            t4 = gammaaa**5.0d-1
            t5 = t4**7
            t6 = 1/rhoa**9.333333333333333d+0
            t7 = gammaaa**3
            t8 = 1/rhoa**8
            t9 = t4**5
            t10 = 1/rhoa**6.666666666666667d+0
            t11 = gammaaa**2
            t12 = 1/rhoa**5.333333333333333d+0
            t13 = t4**3
            t14 = 1/rhoa**4
            t15 = 1/rhoa**2.6666666666666666d+0
            t16 = 5.3020963068324d-6*t10*t9-4.327677396975467d-7*t7*t8+2
     1         .4123830247695402d-8*t5*t6+2.631878392200375d-4*gammaaa*t
     2         15+1.8005513133540818d-4*t13*t14-4.342399100269002d-5*t11
     3         *t12
            t17 = t4**9
            t18 = 1/rhoa**12
            t19 = gammaaa**4
            t20 = 1/rhoa**1.0666666666666666d+1
            t21 = rhoa**1.3333333333333333d+0
            t22 = 1/t21
            t23 = 5.955909787676884d-5*t10*t9-2.7196832676277033d-6*t7*t
     1         8+1.7578986477855002d-7*t5*t6+6.841322473346062d-1*t22*t4
     2         -5.649671283776346d-9*t19*t20+3.149302550983647d-10*t17*t
     3         18-2.0532933130264455d-1*gammaaa*t15+2.342799068769956d-2
     4         *t13*t14-1.3837064697606524d-3*t11*t12+1.0d+0
            t24 = 1/t23
            t25 = 1.6455307846020562d-2*gammaaa*t15*t16*t24
            t26 = 6.582123138408225d-2*(t1*t3)**2.0d+0+t25+6.0965d-1
            t27 = 1/t26
            t28 = t26**5.0d-1
            t29 = 1/t28
            t30 = 2.565564877060844d-1*t1*t29*t3+1.0d+0
            t31 = 1/t30
            t32 = 4.1138269615051404d-3*gammaaa*t15+1.0d+0
            t33 = 1/t32
            t34 = 5.136628594837797d-3*gammaaa*t15*t33+6.934448603031025
     1         d-2*gammaaa*t15*t16*t24+1.0d+0
            t35 = 1.282782438530422d-1*t1*t29*t3+1.0d+0
            t36 = t26*t30
            t37 = 1/t36**2.0d+0
            t38 = t1**2
            t39 = 1/rhoa**6.666666666666666d-1
            t40 = 6.582123138408225d-2*t38*t39
            t41 = (t40+t25)**5.0d-1
            t42 = (t40+t25+6.0965d-1)**5.0d-1
            t43 = t42+t41
            t44 = 1/t43
            t45 = 2.565564877060844d-1*t1*t3
            t46 = t45+t42
            t47 = 1/t46
            t48 = 1.0d+0-6.0965d-1*t44*t47
            t49 = log(t48)
            t50 = (t40+t25+7.57211d-1)**5.0d-1
            t51 = t50+t42
            t52 = 1/t51
            t53 = 1.475609999999999d-1*t47*t52+1.0d+0
            t54 = log(t53)
            t55 = t25+7.57211d-1
            t56 = t50+t41
            t57 = 1/t56
            t58 = t50+t45
            t59 = 1/t58
            t60 = t45+t41
            t61 = 1/t60
            t62 = t25+6.0965d-1
            t63 = t62**2.0d+0
            t64 = t62**3.5d+0
            t65 = (gammaaa*t15*t16*t24)**5.0d-1
            t66 = t55**5.0d-1
            t67 = 1.282782438530422d-1*t65-t66
            t68 = -2.4d+0*t64*t67-1.417963080724413d+0*t64+2.83637333333
     1         3333d-2*t63-9.086532d-1*t62**3.0d+0+4.7459599999999996d-2
     2         *t34*t62
            t69 = 1/t36**3.0d+0
            t70 = 2.4682961769030842d-2*(t1*t29*t3)**2.0d+0+2.8862604866
     1         934494d-1*t1*t29*t3+1.0d+0
            t71 = -8.888888888888888d-1*t68*t69*t70+7.57211d-1*(1.645530
     1         7846020562d-2*gammaaa*t15*t16*t24*t57*t61+t55*t57*t59)-2.
     2         0d+0*t54*t55+3.2910615692041123d-2*gammaaa*t15*t16*t24*t4
     3         9+5.273288888888887d-2*t34*t35*t37+4.727288888888889d-2*t
     4         27*t31-1.0d+0
            t72 = 1/t26**2
            t73 = 1/rhoa**3.6666666666666664d+0
            t74 = -4.38808209227215d-2*gammaaa*t16*t24*t73
            t75 = 1/rhoa**1.0333333333333333d+1
            t76 = 1/rhoa**9
            t77 = 1/rhoa**7.666666666666667d+0
            t78 = 1/rhoa**6.333333333333333d+0
            t79 = 1/rhoa**5
            t80 = -3.970606525117923d-4*t77*t9-9.371196275079824d-2*t13*
     1         t79+7.379767838723479d-3*t11*t78+2.1757466141021625d-5*t7
     2         *t76-1.6407054045998d-6*t5*t75+5.475448834737188d-1*gamma
     3         aa*t73-9.121763297794749d-1*t4/rhoa**2.3333333333333334d+
     4         0+6.026316036028103d-8*t19/rhoa**1.1666666666666665d+1-3.
     5         7791630611803767d-9*t17/rhoa**13
            t81 = 1/t23**2
            t82 = -1.6455307846020562d-2*gammaaa*t15*t16*t80*t81
            t83 = -3.5347308712216d-5*t77*t9-7.202205253416327d-4*t13*t7
     1         9+2.3159461868101344d-4*t11*t78+3.462141917580374d-6*t7*t
     2         76-2.2515574897849044d-7*t5*t75-7.018342379201d-4*gammaaa
     3         *t73
            t84 = 1.6455307846020562d-2*gammaaa*t15*t24*t83
            t85 = t84+t82+t74-4.38808209227215d-2*t38/rhoa**1.6666666666
     1         666669d+0
            t86 = 1/t32**2
            t87 = 5.634986987915197d-5*t11*t78*t86+6.934448603031025d-2*
     1         gammaaa*t15*t24*t83-6.934448603031025d-2*gammaaa*t15*t16*
     2         t80*t81-1.369767625290079d-2*gammaaa*t33*t73-1.8491862941
     3         416065d-1*gammaaa*t16*t24*t73
            t88 = 1/t42
            t89 = 5.0d-1*t85*t88
            t90 = -8.551882923536147d-2*t1*t22
            t91 = t90+t89
            t92 = 1/t46**2
            t93 = 1/t41
            t94 = 5.0d-1*t85*t93
            t95 = 1/t43**2
            t96 = 1/t48
            t97 = t84+t82+t74
            t98 = 1/t50
            t99 = 5.0d-1*t85*t98
            t100 = 1/t51**2
            t101 = 1/t53
            t102 = 1/t58**2
            t103 = t99+t94
            t104 = 1/t56**2
            t105 = 1/t60**2
            t106 = t62**2.5d+0
            t107 = 1/t66
            t108 = 1/t65
            t109 = 1/t30**2
            t110 = 1/t28**3
            t111 = -1.282782438530422d-1*t1*t110*t3*t85-8.55188292353614
     1         7d-2*t1*t22*t29
            t112 = t30*t85+t111*t26
            t113 = 1/t36**4.0d+0
            t114 = 6.15264526724925d-7*t6*t9-8.159049802883108d-6*t11*t8
     1         -2.2598685135105387d-8*t20*t7+1.4171861479426412d-9*t18*t
     2         5+3.514198603154934d-2*t14*t4+3.420661236673031d-1*t22/t4
     3         -2.0532933130264455d-1*t15+1.488977446919221d-4*t10*t13-2
     4         .767412939521305d-3*gammaaa*t12
            t115 = 8.443340586693391d-8*t6*t9-1.2983032190926402d-6*t11*
     1         t8+2.7008269700311227d-4*t14*t4+2.631878392200375d-4*t15+
     2         1.3255240767081d-5*t10*t13-8.684798200538004d-5*gammaaa*t
     3         12
            t116 = -1.6455307846020562d-2*gammaaa*t114*t15*t16*t81+1.645
     1         5307846020562d-2*t15*t16*t24+1.6455307846020562d-2*gammaa
     2         a*t115*t15*t24
            t117 = -2.113120120468199d-5*gammaaa*t12*t86-6.9344486030310
     1         25d-2*gammaaa*t114*t15*t16*t81+5.136628594837797d-3*t15*t
     2         33+6.934448603031025d-2*t15*t16*t24+6.934448603031025d-2*
     3         gammaaa*t115*t15*t24
            t118 = 5.0d-1*t116*t93
            t119 = 5.0d-1*t116*t88
            t120 = 5.0d-1*t116*t98
            t121 = t120+t118
            t122 = t116*t30-1.282782438530422d-1*t1*t116*t29*t3
            fnc(iq) = fnc(iq)-1.8610514726982d+0*t21*t71*wght
            Amat(iq,D1_RA) = (-9.305257363491d-1*t21*(7.57211d-1*(-t102*
     1         t55*t57*(t99+t90)+t57*t59*t97-1.6455307846020562d-2*gamma
     2         aa*t105*t15*t16*t24*t57*(t94+t90)+1.6455307846020562d-2*g
     3         ammaaa*t15*t24*t57*t61*t83-1.6455307846020562d-2*gammaaa*
     4         t15*t16*t57*t61*t80*t81-4.38808209227215d-2*gammaaa*t16*t
     5         24*t57*t61*t73-1.6455307846020562d-2*gammaaa*t103*t104*t1
     6         5*t16*t24*t61-t103*t104*t55*t59)-2.0d+0*t101*t55*(-1.4756
     7         09999999999d-1*t100*t47*(t99+t89)-1.475609999999999d-1*t5
     8         2*t91*t92)-8.888888888888888d-1*t69*t70*(-2.4d+0*t64*(6.4
     9         1391219265211d-2*t108*(gammaaa*t15*t24*t83-gammaaa*t15*t1
     :         6*t80*t81-2.6666666666666666d+0*gammaaa*t16*t24*t73)-5.0d
     ;         -1*t107*t97)-8.400000000000001d+0*t106*t67*t97-2.7259596d
     <         +0*t63*t97+5.672746666666666d-2*t62*t97+4.745959999999999
     =         6d-2*t34*t97-4.9628707825354457d+0*t106*t97+4.74595999999
     >         99996d-2*t62*t87)-2.0d+0*t54*t97+3.2910615692041123d-2*ga
     ?         mmaaa*t15*t16*t24*(6.0965d-1*t47*(t94+t89)*t95+6.0965d-1*
     @         t44*t91*t92)*t96+5.273288888888887d-2*t35*t37*t87-8.88888
     1         8888888888d-1*t68*t69*(4.9365923538061685d-2*t1*t29*t3*(-
     2         5.0d-1*t1*t110*t3*t85-3.333333333333333d-1*t1*t22*t29)-1.
     3         4431302433467247d-1*t1*t110*t3*t85-9.620868288978164d-2*t
     4         1*t22*t29)+5.273288888888887d-2*t34*t37*(-6.4139121926521
     5         1d-2*t1*t110*t3*t85-4.2759414617680735d-2*t1*t22*t29)-4.7
     6         27288888888889d-2*t31*t72*t85+3.2910615692041123d-2*gamma
     7         aa*t15*t24*t49*t83-3.2910615692041123d-2*gammaaa*t15*t16*
     8         t49*t80*t81-8.7761641845443d-2*gammaaa*t16*t24*t49*t73+2.
     9         6666666666666666d+0*t112*t113*t68*t70-1.0546577777777776d
     :         -1*t112*t34*t35*t69-4.727288888888889d-2*t109*t111*t27)-1
     ;         .2407009817987999d+0*t2*t71)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-9.305257363491d-1*t21*(7.5
     1         7211d-1*(-5.0d-1*t102*t116*t55*t57*t98-8.227653923010281d
     2         -3*gammaaa*t105*t116*t15*t16*t24*t57*t93-1.64553078460205
     3         62d-2*gammaaa*t114*t15*t16*t57*t61*t81+1.6455307846020562
     4         d-2*t15*t16*t24*t57*t61+1.6455307846020562d-2*gammaaa*t11
     5         5*t15*t24*t57*t61-1.6455307846020562d-2*gammaaa*t104*t121
     6         *t15*t16*t24*t61+t116*t57*t59-t104*t121*t55*t59)+3.291061
     7         5692041123d-2*gammaaa*t15*t16*t24*(6.0965d-1*(t119+t118)*
     8         t47*t95+3.04825d-1*t116*t44*t88*t92)*t96-2.0d+0*t101*t55*
     9         (-7.378049999999994d-2*t116*t52*t88*t92-1.475609999999999
     :         d-1*t100*(t120+t119)*t47)+t69*(-8.888888888888888d-1*t70*
     ;         (-2.4d+0*t64*(6.41391219265211d-2*t108*(-gammaaa*t114*t15
     <         *t16*t81+t15*t16*t24+gammaaa*t115*t15*t24)-5.0d-1*t107*t1
     =         16)-8.400000000000001d+0*t106*t116*t67-2.7259596d+0*t116*
     >         t63+4.7459599999999996d-2*t117*t62+5.672746666666666d-2*t
     ?         116*t62+4.7459599999999996d-2*t116*t34-4.9628707825354457
     @         d+0*t106*t116)-8.888888888888888d-1*t68*(-2.4682961769030
     1         842d-2*t116*t38*t39*t72-1.4431302433467247d-1*t1*t110*t11
     2         6*t3)-1.0546577777777776d-1*t122*t34*t35)-3.2910615692041
     3         123d-2*gammaaa*t114*t15*t16*t49*t81-4.727288888888889d-2*
     4         t116*t31*t72+2.6666666666666666d+0*t113*t122*t68*t70-2.0d
     5         +0*t116*t54+t15*t24*(3.2910615692041123d-2*t16*t49+3.2910
     6         615692041123d-2*gammaaa*t115*t49)+5.273288888888887d-2*t1
     7         17*t35*t37-3.3822411899821336d-3*t1*t110*t116*t3*t34*t37+
     8         6.064083168526658d-3*t1*t109*t116*t3/t28**5)*wght
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = param(1)
            t2 = rhoa**3.333333333333333d-1
            t3 = 1/t2
            t4 = t1*t3
            t5 = gammaaa**5.0d-1
            t6 = t5**7
            t7 = 1/rhoa**9.333333333333333d+0
            t8 = gammaaa**3
            t9 = 1/rhoa**8
            t10 = t5**5
            t11 = 1/rhoa**6.666666666666667d+0
            t12 = gammaaa**2
            t13 = 1/rhoa**5.333333333333333d+0
            t14 = t5**3
            t15 = 1/rhoa**4
            t16 = 1/rhoa**2.6666666666666666d+0
            t17 = -4.327677396975467d-7*t8*t9+2.4123830247695402d-8*t6*t
     1         7+2.631878392200375d-4*gammaaa*t16+1.8005513133540818d-4*
     2         t14*t15-4.342399100269002d-5*t12*t13+5.3020963068324d-6*t
     3         10*t11
            t18 = t5**9
            t19 = 1/rhoa**12
            t20 = gammaaa**4
            t21 = 1/rhoa**1.0666666666666666d+1
            t22 = rhoa**1.3333333333333333d+0
            t23 = 1/t22
            t24 = -2.7196832676277033d-6*t8*t9+1.7578986477855002d-7*t6*
     1         t7+6.841322473346062d-1*t23*t5-5.649671283776346d-9*t20*t
     2         21+3.149302550983647d-10*t18*t19-2.0532933130264455d-1*ga
     3         mmaaa*t16+2.342799068769956d-2*t14*t15-1.3837064697606524
     4         d-3*t12*t13+5.955909787676884d-5*t10*t11+1.0d+0
            t25 = 1/t24
            t26 = 1.6455307846020562d-2*gammaaa*t16*t17*t25
            t27 = 6.582123138408225d-2*t4**2.0d+0+t26+6.0965d-1
            t28 = 1/t27
            t29 = t27**5.0d-1
            t30 = 1/t29
            t31 = 2.565564877060844d-1*t1*t3*t30+1.0d+0
            t32 = 1/t31
            t33 = 4.1138269615051404d-3*gammaaa*t16+1.0d+0
            t34 = 1/t33
            t35 = 5.136628594837797d-3*gammaaa*t16*t34+6.934448603031025
     1         d-2*gammaaa*t16*t17*t25+1.0d+0
            t36 = 1.282782438530422d-1*t1*t3*t30+1.0d+0
            t37 = t27*t31
            t38 = 1/t37**2.0d+0
            t39 = t1**2
            t40 = 1/rhoa**6.666666666666666d-1
            t41 = 6.582123138408225d-2*t39*t40
            t42 = (t41+t26)**5.0d-1
            t43 = (t41+t26+6.0965d-1)**5.0d-1
            t44 = t43+t42
            t45 = 1/t44
            t46 = 2.565564877060844d-1*t1*t3
            t47 = t46+t43
            t48 = 1/t47
            t49 = 1.0d+0-6.0965d-1*t45*t48
            t50 = log(t49)
            t51 = (t41+t26+7.57211d-1)**5.0d-1
            t52 = t51+t43
            t53 = 1/t52
            t54 = 1.475609999999999d-1*t48*t53+1.0d+0
            t55 = log(t54)
            t56 = t26+7.57211d-1
            t57 = t51+t42
            t58 = 1/t57
            t59 = t51+t46
            t60 = 1/t59
            t61 = t46+t42
            t62 = 1/t61
            t63 = t26+6.0965d-1
            t64 = t63**2.0d+0
            t65 = t63**3.5d+0
            t66 = (gammaaa*t16*t17*t25)**5.0d-1
            t67 = t56**5.0d-1
            t68 = 1.282782438530422d-1*t66-t67
            t69 = -2.4d+0*t65*t68-1.417963080724413d+0*t65+2.83637333333
     1         3333d-2*t64-9.086532d-1*t63**3.0d+0+4.7459599999999996d-2
     2         *t35*t63
            t70 = 1/t37**3.0d+0
            t71 = t1*t3*t30
            t72 = 2.4682961769030842d-2*t71**2.0d+0+2.8862604866934494d-
     1         1*t1*t3*t30+1.0d+0
            t73 = -8.888888888888888d-1*t69*t70*t72+7.57211d-1*(1.645530
     1         7846020562d-2*gammaaa*t16*t17*t25*t58*t62+t56*t58*t60)-2.
     2         0d+0*t55*t56+3.2910615692041123d-2*gammaaa*t16*t17*t25*t5
     3         0+5.273288888888887d-2*t35*t36*t38+4.727288888888889d-2*t
     4         28*t32-1.0d+0
            t74 = rhob**3.333333333333333d-1
            t75 = 1/t74
            t76 = t1*t75
            t77 = gammabb**5.0d-1
            t78 = t77**7
            t79 = 1/rhob**9.333333333333333d+0
            t80 = gammabb**3
            t81 = 1/rhob**8
            t82 = t77**5
            t83 = 1/rhob**6.666666666666667d+0
            t84 = gammabb**2
            t85 = 1/rhob**5.333333333333333d+0
            t86 = t77**3
            t87 = 1/rhob**4
            t88 = 1/rhob**2.6666666666666666d+0
            t89 = 2.631878392200375d-4*gammabb*t88+1.8005513133540818d-4
     1         *t86*t87-4.342399100269002d-5*t84*t85+5.3020963068324d-6*
     2         t82*t83-4.327677396975467d-7*t80*t81+2.4123830247695402d-
     3         8*t78*t79
            t90 = t77**9
            t91 = 1/rhob**12
            t92 = gammabb**4
            t93 = 1/rhob**1.0666666666666666d+1
            t94 = rhob**1.3333333333333333d+0
            t95 = 1/t94
            t96 = 6.841322473346062d-1*t77*t95-5.649671283776346d-9*t92*
     1         t93+3.149302550983647d-10*t90*t91-2.0532933130264455d-1*g
     2         ammabb*t88+2.342799068769956d-2*t86*t87-1.383706469760652
     3         4d-3*t84*t85+5.955909787676884d-5*t82*t83-2.7196832676277
     4         033d-6*t80*t81+1.7578986477855002d-7*t78*t79+1.0d+0
            t97 = 1/t96
            t98 = 1.6455307846020562d-2*gammabb*t88*t89*t97
            t99 = t98+6.582123138408225d-2*t76**2.0d+0+6.0965d-1
            t100 = 1/t99
            t101 = t99**5.0d-1
            t102 = 1/t101
            t103 = 2.565564877060844d-1*t1*t102*t75+1.0d+0
            t104 = 1/t103
            t105 = 4.1138269615051404d-3*gammabb*t88+1.0d+0
            t106 = 1/t105
            t107 = 6.934448603031025d-2*gammabb*t88*t89*t97+5.1366285948
     1         37797d-3*gammabb*t106*t88+1.0d+0
            t108 = 1.282782438530422d-1*t1*t102*t75+1.0d+0
            t109 = t103*t99
            t110 = 1/t109**2.0d+0
            t111 = 1/rhob**6.666666666666666d-1
            t112 = 6.582123138408225d-2*t111*t39
            t113 = (t98+t112)**5.0d-1
            t114 = (t98+t112+6.0965d-1)**5.0d-1
            t115 = t114+t113
            t116 = 1/t115
            t117 = 2.565564877060844d-1*t1*t75
            t118 = t117+t114
            t119 = 1/t118
            t120 = 1.0d+0-6.0965d-1*t116*t119
            t121 = log(t120)
            t122 = (t98+t112+7.57211d-1)**5.0d-1
            t123 = t122+t114
            t124 = 1/t123
            t125 = 1.475609999999999d-1*t119*t124+1.0d+0
            t126 = log(t125)
            t127 = t98+7.57211d-1
            t128 = t122+t113
            t129 = 1/t128
            t130 = t122+t117
            t131 = 1/t130
            t132 = t117+t113
            t133 = 1/t132
            t134 = t98+6.0965d-1
            t135 = t134**2.0d+0
            t136 = t134**3.5d+0
            t137 = (gammabb*t88*t89*t97)**5.0d-1
            t138 = t127**5.0d-1
            t139 = 1.282782438530422d-1*t137-t138
            t140 = -2.4d+0*t136*t139-1.417963080724413d+0*t136+2.8363733
     1         33333333d-2*t135-9.086532d-1*t134**3.0d+0+4.7459599999999
     2         996d-2*t107*t134
            t141 = 1/t109**3.0d+0
            t142 = t1*t102*t75
            t143 = 2.8862604866934494d-1*t1*t102*t75+2.4682961769030842d
     1         -2*t142**2.0d+0+1.0d+0
            t144 = 7.57211d-1*(1.6455307846020562d-2*gammabb*t129*t133*t
     1         88*t89*t97+t127*t129*t131)+3.2910615692041123d-2*gammabb*
     2         t121*t88*t89*t97-8.888888888888888d-1*t140*t141*t143-2.0d
     3         +0*t126*t127+5.273288888888887d-2*t107*t108*t110+4.727288
     4         888888889d-2*t100*t104-1.0d+0
            t145 = 1/t27**2
            t146 = 1/rhoa**3.6666666666666664d+0
            t147 = -4.38808209227215d-2*gammaaa*t146*t17*t25
            t148 = 1/rhoa**1.0333333333333333d+1
            t149 = 1/rhoa**9
            t150 = 1/rhoa**7.666666666666667d+0
            t151 = 1/rhoa**6.333333333333333d+0
            t152 = 1/rhoa**5
            t153 = 2.1757466141021625d-5*t149*t8-1.6407054045998d-6*t148
     1         *t6-9.121763297794749d-1*t5/rhoa**2.3333333333333334d+0+6
     2         .026316036028103d-8*t20/rhoa**1.1666666666666665d+1-3.779
     3         1630611803767d-9*t18/rhoa**13-9.371196275079824d-2*t14*t1
     4         52+7.379767838723479d-3*t12*t151-3.970606525117923d-4*t10
     5         *t150+5.475448834737188d-1*gammaaa*t146
            t154 = 1/t24**2
            t155 = -1.6455307846020562d-2*gammaaa*t153*t154*t16*t17
            t156 = 3.462141917580374d-6*t149*t8-2.2515574897849044d-7*t1
     1         48*t6-7.202205253416327d-4*t14*t152+2.3159461868101344d-4
     2         *t12*t151-3.5347308712216d-5*t10*t150-7.018342379201d-4*g
     3         ammaaa*t146
            t157 = 1.6455307846020562d-2*gammaaa*t156*t16*t25
            t158 = -4.38808209227215d-2*t1*t23*t4+t157+t155+t147
            t159 = 1/t33**2
            t160 = -1.369767625290079d-2*gammaaa*t146*t34-1.849186294141
     1         6065d-1*gammaaa*t146*t17*t25+6.934448603031025d-2*gammaaa
     2         *t156*t16*t25-6.934448603031025d-2*gammaaa*t153*t154*t16*
     3         t17+5.634986987915197d-5*t12*t151*t159
            t161 = -4.38808209227215d-2*t39/rhoa**1.6666666666666669d+0+
     1         t157+t155+t147
            t162 = 1/t43
            t163 = 5.0d-1*t161*t162
            t164 = -8.551882923536147d-2*t1*t23
            t165 = t164+t163
            t166 = 1/t47**2
            t167 = 1/t42
            t168 = 5.0d-1*t161*t167
            t169 = 1/t44**2
            t170 = 1/t49
            t171 = t157+t155+t147
            t172 = 1/t51
            t173 = 5.0d-1*t161*t172
            t174 = 1/t52**2
            t175 = 1/t54
            t176 = 1/t59**2
            t177 = t173+t168
            t178 = 1/t57**2
            t179 = 1/t61**2
            t180 = t63**2.5d+0
            t181 = 1/t67
            t182 = 1/t66
            t183 = 1/t31**2
            t184 = 1/t29**3
            t185 = -8.551882923536147d-2*t1*t23*t30-1.282782438530422d-1
     1         *t1*t158*t184*t3
            t186 = t158*t31+t185*t27
            t187 = 1/t37**4.0d+0
            t188 = 1/t99**2
            t189 = 1/rhob**3.6666666666666664d+0
            t190 = -4.38808209227215d-2*gammabb*t189*t89*t97
            t191 = 1/rhob**1.0333333333333333d+1
            t192 = 1/rhob**9
            t193 = 1/rhob**7.666666666666667d+0
            t194 = 1/rhob**6.333333333333333d+0
            t195 = 1/rhob**5
            t196 = 6.026316036028103d-8*t92/rhob**1.1666666666666665d+1-
     1         3.7791630611803767d-9*t90/rhob**13-9.371196275079824d-2*t
     2         195*t86+7.379767838723479d-3*t194*t84-3.970606525117923d-
     3         4*t193*t82+2.1757466141021625d-5*t192*t80-1.6407054045998
     4         d-6*t191*t78-9.121763297794749d-1*t77/rhob**2.33333333333
     5         33334d+0+5.475448834737188d-1*gammabb*t189
            t197 = 1/t96**2
            t198 = -1.6455307846020562d-2*gammabb*t196*t197*t88*t89
            t199 = -7.202205253416327d-4*t195*t86+2.3159461868101344d-4*
     1         t194*t84-3.5347308712216d-5*t193*t82+3.462141917580374d-6
     2         *t192*t80-2.2515574897849044d-7*t191*t78-7.018342379201d-
     3         4*gammabb*t189
            t200 = 1.6455307846020562d-2*gammabb*t199*t88*t97
            t201 = -4.38808209227215d-2*t1*t76*t95+t200+t198+t190
            t202 = 1/t105**2
            t203 = -1.8491862941416065d-1*gammabb*t189*t89*t97+6.9344486
     1         03031025d-2*gammabb*t199*t88*t97-6.934448603031025d-2*gam
     2         mabb*t196*t197*t88*t89+5.634986987915197d-5*t194*t202*t84
     3         -1.369767625290079d-2*gammabb*t106*t189
            t204 = -4.38808209227215d-2*t39/rhob**1.6666666666666669d+0+
     1         t200+t198+t190
            t205 = 1/t114
            t206 = 5.0d-1*t204*t205
            t207 = -8.551882923536147d-2*t1*t95
            t208 = t207+t206
            t209 = 1/t118**2
            t210 = 1/t113
            t211 = 5.0d-1*t204*t210
            t212 = 1/t115**2
            t213 = 1/t120
            t214 = t200+t198+t190
            t215 = 1/t122
            t216 = 5.0d-1*t204*t215
            t217 = 1/t123**2
            t218 = 1/t125
            t219 = 1/t130**2
            t220 = t216+t211
            t221 = 1/t128**2
            t222 = 1/t132**2
            t223 = t134**2.5d+0
            t224 = 1/t138
            t225 = 1/t137
            t226 = 1/t103**2
            t227 = 1/t101**3
            t228 = -8.551882923536147d-2*t1*t102*t95-1.282782438530422d-
     1         1*t1*t201*t227*t75
            t229 = t228*t99+t103*t201
            t230 = 1/t109**4.0d+0
            t231 = -8.159049802883108d-6*t12*t9-2.2598685135105387d-8*t2
     1         1*t8+6.15264526724925d-7*t10*t7+1.4171861479426412d-9*t19
     2         *t6+3.514198603154934d-2*t15*t5+3.420661236673031d-1*t23/
     3         t5-2.0532933130264455d-1*t16+1.488977446919221d-4*t11*t14
     4         -2.767412939521305d-3*gammaaa*t13
            t232 = -1.2983032190926402d-6*t12*t9+8.443340586693391d-8*t1
     1         0*t7+2.7008269700311227d-4*t15*t5+2.631878392200375d-4*t1
     2         6+1.3255240767081d-5*t11*t14-8.684798200538004d-5*gammaaa
     3         *t13
            t233 = 1.6455307846020562d-2*gammaaa*t16*t232*t25+1.64553078
     1         46020562d-2*t16*t17*t25-1.6455307846020562d-2*gammaaa*t15
     2         4*t16*t17*t231
            t234 = 5.136628594837797d-3*t16*t34+6.934448603031025d-2*gam
     1         maaa*t16*t232*t25+6.934448603031025d-2*t16*t17*t25-6.9344
     2         48603031025d-2*gammaaa*t154*t16*t17*t231-2.11312012046819
     3         9d-5*gammaaa*t13*t159
            t235 = 5.0d-1*t167*t233
            t236 = 5.0d-1*t162*t233
            t237 = 5.0d-1*t172*t233
            t238 = t237+t235
            t239 = t233*t31-1.282782438530422d-1*t1*t233*t3*t30
            t240 = 3.420661236673031d-1*t95/t77-2.2598685135105387d-8*t8
     1         0*t93+1.4171861479426412d-9*t78*t91-2.0532933130264455d-1
     2         *t88+3.514198603154934d-2*t77*t87+1.488977446919221d-4*t8
     3         3*t86-2.767412939521305d-3*gammabb*t85-8.159049802883108d
     4         -6*t81*t84+6.15264526724925d-7*t79*t82
            t241 = 2.631878392200375d-4*t88+2.7008269700311227d-4*t77*t8
     1         7+1.3255240767081d-5*t83*t86-8.684798200538004d-5*gammabb
     2         *t85-1.2983032190926402d-6*t81*t84+8.443340586693391d-8*t
     3         79*t82
            t242 = 1.6455307846020562d-2*t88*t89*t97+1.6455307846020562d
     1         -2*gammabb*t241*t88*t97-1.6455307846020562d-2*gammabb*t19
     2         7*t240*t88*t89
            t243 = 6.934448603031025d-2*t88*t89*t97+6.934448603031025d-2
     1         *gammabb*t241*t88*t97-6.934448603031025d-2*gammabb*t197*t
     2         240*t88*t89+5.136628594837797d-3*t106*t88-2.1131201204681
     3         99d-5*gammabb*t202*t85
            t244 = 5.0d-1*t210*t242
            t245 = 5.0d-1*t205*t242
            t246 = 5.0d-1*t215*t242
            t247 = t246+t244
            t248 = t103*t242-1.282782438530422d-1*t1*t102*t242*t75
            fnc(iq) = (-9.305257363491d-1*t144*t94-9.305257363491d-1*t22
     1         *t73)*wght+fnc(iq)
            Amat(iq,D1_RA) = (-1.2407009817987999d+0*t2*t73-9.3052573634
     1         91d-1*t22*(-8.888888888888888d-1*(-8.400000000000001d+0*t
     2         171*t180*t68-2.4d+0*(6.41391219265211d-2*t182*(-2.6666666
     3         666666666d+0*gammaaa*t146*t17*t25+gammaaa*t156*t16*t25-ga
     4         mmaaa*t153*t154*t16*t17)-5.0d-1*t171*t181)*t65-2.7259596d
     5         +0*t171*t64+5.672746666666666d-2*t171*t63+4.7459599999999
     6         996d-2*t160*t63+4.7459599999999996d-2*t171*t35-4.96287078
     7         25354457d+0*t171*t180)*t70*t72+2.6666666666666666d+0*t186
     8         *t187*t69*t72-8.888888888888888d-1*t69*t70*(4.93659235380
     9         61685d-2*(-3.333333333333333d-1*t1*t23*t30-5.0d-1*t1*t158
     :         *t184*t3)*t71-9.620868288978164d-2*t1*t23*t30-1.443130243
     ;         3467247d-1*t1*t158*t184*t3)-1.0546577777777776d-1*t186*t3
     <         5*t36*t70+7.57211d-1*(-4.38808209227215d-2*gammaaa*t146*t
     =         17*t25*t58*t62+1.6455307846020562d-2*gammaaa*t156*t16*t25
     >         *t58*t62-1.6455307846020562d-2*gammaaa*t153*t154*t16*t17*
     ?         t58*t62-1.6455307846020562d-2*gammaaa*t16*t17*t177*t178*t
     @         25*t62+t171*t58*t60-t177*t178*t56*t60-(t173+t164)*t176*t5
     1         6*t58-1.6455307846020562d-2*gammaaa*t16*(t168+t164)*t17*t
     2         179*t25*t58)-2.0d+0*t175*(-1.475609999999999d-1*t165*t166
     3         *t53-1.475609999999999d-1*(t173+t163)*t174*t48)*t56-2.0d+
     4         0*t171*t55-8.7761641845443d-2*gammaaa*t146*t17*t25*t50+3.
     5         2910615692041123d-2*gammaaa*t156*t16*t25*t50-3.2910615692
     6         041123d-2*gammaaa*t153*t154*t16*t17*t50+3.291061569204112
     7         3d-2*gammaaa*t16*t17*t170*t25*(6.0965d-1*(t168+t163)*t169
     8         *t48+6.0965d-1*t165*t166*t45)+5.273288888888887d-2*t160*t
     9         36*t38+5.273288888888887d-2*(-4.2759414617680735d-2*t1*t2
     :         3*t30-6.41391219265211d-2*t1*t158*t184*t3)*t35*t38-4.7272
     ;         88888888889d-2*t145*t158*t32-4.727288888888889d-2*t183*t1
     <         85*t28))*wght+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = (-9.305257363491d-1*t94*(-8.888888888888888
     1         d-1*t141*t143*(-2.4d+0*t136*(6.41391219265211d-2*t225*(-2
     2         .6666666666666666d+0*gammabb*t189*t89*t97+gammabb*t199*t8
     3         8*t97-gammabb*t196*t197*t88*t89)-5.0d-1*t214*t224)-8.4000
     4         00000000001d+0*t139*t214*t223-4.9628707825354457d+0*t214*
     5         t223-2.7259596d+0*t135*t214+5.672746666666666d-2*t134*t21
     6         4+4.7459599999999996d-2*t107*t214+4.7459599999999996d-2*t
     7         134*t203)+7.57211d-1*(-1.6455307846020562d-2*gammabb*t129
     8         *(t211+t207)*t222*t88*t89*t97-1.6455307846020562d-2*gamma
     9         bb*t133*t220*t221*t88*t89*t97-4.38808209227215d-2*gammabb
     :         *t129*t133*t189*t89*t97+1.6455307846020562d-2*gammabb*t12
     ;         9*t133*t199*t88*t97-1.6455307846020562d-2*gammabb*t129*t1
     <         33*t196*t197*t88*t89-t127*t131*t220*t221-t127*t129*(t216+
     =         t207)*t219+t129*t131*t214)+3.2910615692041123d-2*gammabb*
     >         (6.0965d-1*t119*(t211+t206)*t212+6.0965d-1*t116*t208*t209
     ?         )*t213*t88*t89*t97-8.7761641845443d-2*gammabb*t121*t189*t
     @         89*t97+3.2910615692041123d-2*gammabb*t121*t199*t88*t97-8.
     1         888888888888888d-1*t140*t141*(4.9365923538061685d-2*t142*
     2         (-3.333333333333333d-1*t1*t102*t95-5.0d-1*t1*t201*t227*t7
     3         5)-9.620868288978164d-2*t1*t102*t95-1.4431302433467247d-1
     4         *t1*t201*t227*t75)+5.273288888888887d-2*t107*t110*(-4.275
     5         9414617680735d-2*t1*t102*t95-6.41391219265211d-2*t1*t201*
     6         t227*t75)-3.2910615692041123d-2*gammabb*t121*t196*t197*t8
     7         8*t89+2.6666666666666666d+0*t140*t143*t229*t230-1.0546577
     8         777777776d-1*t107*t108*t141*t229-4.727288888888889d-2*t10
     9         0*t226*t228-2.0d+0*t127*(-1.475609999999999d-1*t119*(t216
     :         +t206)*t217-1.475609999999999d-1*t124*t208*t209)*t218-2.0
     ;         d+0*t126*t214+5.273288888888887d-2*t108*t110*t203-4.72728
     <         8888888889d-2*t104*t188*t201)-1.2407009817987999d+0*t144*
     =         t74)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-9.305257363491d-1*t22*(t70
     1         *(-8.888888888888888d-1*(-8.400000000000001d+0*t180*t233*
     2         t68-2.4d+0*(6.41391219265211d-2*t182*(gammaaa*t16*t232*t2
     3         5+t16*t17*t25-gammaaa*t154*t16*t17*t231)-5.0d-1*t181*t233
     4         )*t65-2.7259596d+0*t233*t64+4.7459599999999996d-2*t234*t6
     5         3+5.672746666666666d-2*t233*t63+4.7459599999999996d-2*t23
     6         3*t35-4.9628707825354457d+0*t180*t233)*t72-8.888888888888
     7         888d-1*(-2.4682961769030842d-2*t145*t233*t39*t40-1.443130
     8         2433467247d-1*t1*t184*t233*t3)*t69-1.0546577777777776d-1*
     9         t239*t35*t36)+2.6666666666666666d+0*t187*t239*t69*t72+7.5
     :         7211d-1*(1.6455307846020562d-2*gammaaa*t16*t232*t25*t58*t
     ;         62+1.6455307846020562d-2*t16*t17*t25*t58*t62-1.6455307846
     <         020562d-2*gammaaa*t154*t16*t17*t231*t58*t62-1.64553078460
     =         20562d-2*gammaaa*t16*t17*t178*t238*t25*t62+t233*t58*t60-t
     >         178*t238*t56*t60-5.0d-1*t172*t176*t233*t56*t58-8.22765392
     ?         3010281d-3*gammaaa*t16*t167*t17*t179*t233*t25*t58)-2.0d+0
     @         *t175*(-7.378049999999994d-2*t162*t166*t233*t53-1.4756099
     1         99999999d-1*t174*(t237+t236)*t48)*t56-2.0d+0*t233*t55+t16
     2         *t25*(3.2910615692041123d-2*gammaaa*t232*t50+3.2910615692
     3         041123d-2*t17*t50)-3.2910615692041123d-2*gammaaa*t154*t16
     4         *t17*t231*t50+3.2910615692041123d-2*gammaaa*t16*t17*t170*
     5         t25*(6.0965d-1*t169*(t236+t235)*t48+3.04825d-1*t162*t166*
     6         t233*t45)+5.273288888888887d-2*t234*t36*t38-3.38224118998
     7         21336d-3*t1*t184*t233*t3*t35*t38-4.727288888888889d-2*t14
     8         5*t233*t32+6.064083168526658d-3*t1*t183*t233*t3/t29**5)*w
     9         ght
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)-9.305257363491d-1*t94*(t14
     1         1*(-8.888888888888888d-1*t143*(-2.4d+0*t136*(6.4139121926
     2         5211d-2*t225*(t88*t89*t97+gammabb*t241*t88*t97-gammabb*t1
     3         97*t240*t88*t89)-5.0d-1*t224*t242)+4.7459599999999996d-2*
     4         t134*t243-8.400000000000001d+0*t139*t223*t242-4.962870782
     5         5354457d+0*t223*t242-2.7259596d+0*t135*t242+5.67274666666
     6         6666d-2*t134*t242+4.7459599999999996d-2*t107*t242)-8.8888
     7         88888888888d-1*t140*(-1.4431302433467247d-1*t1*t227*t242*
     8         t75-2.4682961769030842d-2*t111*t188*t242*t39)-1.054657777
     9         7777776d-1*t107*t108*t248)+7.57211d-1*(-1.645530784602056
     :         2d-2*gammabb*t133*t221*t247*t88*t89*t97-8.227653923010281
     ;         d-3*gammabb*t129*t210*t222*t242*t88*t89*t97+1.64553078460
     <         20562d-2*t129*t133*t88*t89*t97+1.6455307846020562d-2*gamm
     =         abb*t129*t133*t241*t88*t97-1.6455307846020562d-2*gammabb*
     >         t129*t133*t197*t240*t88*t89-t127*t131*t221*t247-5.0d-1*t1
     ?         27*t129*t215*t219*t242+t129*t131*t242)+t88*(3.29106156920
     @         41123d-2*t121*t89+3.2910615692041123d-2*gammabb*t121*t241
     1         )*t97+3.2910615692041123d-2*gammabb*t213*(6.0965d-1*t119*
     2         t212*(t245+t244)+3.04825d-1*t116*t205*t209*t242)*t88*t89*
     3         t97-3.2910615692041123d-2*gammabb*t121*t197*t240*t88*t89-
     4         3.3822411899821336d-3*t1*t107*t110*t227*t242*t75+6.064083
     5         168526658d-3*t1*t226*t242*t75/t101**5+2.6666666666666666d
     6         +0*t140*t143*t230*t248-2.0d+0*t127*t218*(-1.4756099999999
     7         99d-1*t119*t217*(t246+t245)-7.378049999999994d-2*t124*t20
     8         5*t209*t242)+5.273288888888887d-2*t108*t110*t243-4.727288
     9         888888889d-2*t104*t188*t242-2.0d+0*t126*t242)*wght
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = param(1)
            t2 = rhoa**3.333333333333333d-1
            t3 = 1/t2
            t4 = t1*t3
            t5 = gammaaa**5.0d-1
            t6 = t5**7
            t7 = 1/rhoa**9.333333333333333d+0
            t8 = gammaaa**3
            t9 = 1/rhoa**8
            t10 = t5**5
            t11 = 1/rhoa**6.666666666666667d+0
            t12 = gammaaa**2
            t13 = 1/rhoa**5.333333333333333d+0
            t14 = t5**3
            t15 = 1/rhoa**4
            t16 = 1/rhoa**2.6666666666666666d+0
            t17 = -4.327677396975467d-7*t8*t9+2.4123830247695402d-8*t6*t
     1         7+2.631878392200375d-4*gammaaa*t16+1.8005513133540818d-4*
     2         t14*t15-4.342399100269002d-5*t12*t13+5.3020963068324d-6*t
     3         10*t11
            t18 = t5**9
            t19 = 1/rhoa**12
            t20 = gammaaa**4
            t21 = 1/rhoa**1.0666666666666666d+1
            t22 = rhoa**1.3333333333333333d+0
            t23 = 1/t22
            t24 = -2.7196832676277033d-6*t8*t9+1.7578986477855002d-7*t6*
     1         t7+6.841322473346062d-1*t23*t5-5.649671283776346d-9*t20*t
     2         21+3.149302550983647d-10*t18*t19-2.0532933130264455d-1*ga
     3         mmaaa*t16+2.342799068769956d-2*t14*t15-1.3837064697606524
     4         d-3*t12*t13+5.955909787676884d-5*t10*t11+1.0d+0
            t25 = 1/t24
            t26 = 1.6455307846020562d-2*gammaaa*t16*t17*t25
            t27 = 6.582123138408225d-2*t4**2.0d+0+t26+6.0965d-1
            t28 = 1/t27
            t29 = t27**5.0d-1
            t30 = 1/t29
            t31 = 2.565564877060844d-1*t1*t3*t30+1.0d+0
            t32 = 1/t31
            t33 = 4.1138269615051404d-3*gammaaa*t16+1.0d+0
            t34 = 1/t33
            t35 = 5.136628594837797d-3*gammaaa*t16*t34+6.934448603031025
     1         d-2*gammaaa*t16*t17*t25+1.0d+0
            t36 = 1.282782438530422d-1*t1*t3*t30+1.0d+0
            t37 = t27*t31
            t38 = 1/t37**2.0d+0
            t39 = t1**2
            t40 = 1/rhoa**6.666666666666666d-1
            t41 = 6.582123138408225d-2*t39*t40
            t42 = (t41+t26)**5.0d-1
            t43 = (t41+t26+6.0965d-1)**5.0d-1
            t44 = t43+t42
            t45 = 1/t44
            t46 = 2.565564877060844d-1*t1*t3
            t47 = t46+t43
            t48 = 1/t47
            t49 = 1.0d+0-6.0965d-1*t45*t48
            t50 = log(t49)
            t51 = (t41+t26+7.57211d-1)**5.0d-1
            t52 = t51+t43
            t53 = 1/t52
            t54 = 1.475609999999999d-1*t48*t53+1.0d+0
            t55 = log(t54)
            t56 = t26+7.57211d-1
            t57 = t51+t42
            t58 = 1/t57
            t59 = t51+t46
            t60 = 1/t59
            t61 = t46+t42
            t62 = 1/t61
            t63 = t26+6.0965d-1
            t64 = t63**2.0d+0
            t65 = t63**3.5d+0
            t66 = (gammaaa*t16*t17*t25)**5.0d-1
            t67 = t56**5.0d-1
            t68 = 1.282782438530422d-1*t66-t67
            t69 = -2.4d+0*t65*t68-1.417963080724413d+0*t65+2.83637333333
     1         3333d-2*t64-9.086532d-1*t63**3.0d+0+4.7459599999999996d-2
     2         *t35*t63
            t70 = 1/t37**3.0d+0
            t71 = t1*t3*t30
            t72 = 2.4682961769030842d-2*t71**2.0d+0+2.8862604866934494d-
     1         1*t1*t3*t30+1.0d+0
            t73 = -8.888888888888888d-1*t69*t70*t72+7.57211d-1*(1.645530
     1         7846020562d-2*gammaaa*t16*t17*t25*t58*t62+t56*t58*t60)-2.
     2         0d+0*t55*t56+3.2910615692041123d-2*gammaaa*t16*t17*t25*t5
     3         0+5.273288888888887d-2*t35*t36*t38+4.727288888888889d-2*t
     4         28*t32-1.0d+0
            t74 = 1/t27**2
            t75 = 1/rhoa**3.6666666666666664d+0
            t76 = -4.38808209227215d-2*gammaaa*t17*t25*t75
            t77 = 1/rhoa**1.0333333333333333d+1
            t78 = 1/rhoa**9
            t79 = 1/rhoa**7.666666666666667d+0
            t80 = 1/rhoa**6.333333333333333d+0
            t81 = 1/rhoa**5
            t82 = -9.371196275079824d-2*t14*t81+7.379767838723479d-3*t12
     1         *t80+2.1757466141021625d-5*t78*t8-3.970606525117923d-4*t1
     2         0*t79-1.6407054045998d-6*t6*t77+5.475448834737188d-1*gamm
     3         aaa*t75-9.121763297794749d-1*t5/rhoa**2.3333333333333334d
     4         +0+6.026316036028103d-8*t20/rhoa**1.1666666666666665d+1-3
     5         .7791630611803767d-9*t18/rhoa**13
            t83 = 1/t24**2
            t84 = -1.6455307846020562d-2*gammaaa*t16*t17*t82*t83
            t85 = -7.202205253416327d-4*t14*t81+2.3159461868101344d-4*t1
     1         2*t80+3.462141917580374d-6*t78*t8-3.5347308712216d-5*t10*
     2         t79-2.2515574897849044d-7*t6*t77-7.018342379201d-4*gammaa
     3         a*t75
            t86 = 1.6455307846020562d-2*gammaaa*t16*t25*t85
            t87 = t86+t84+t76-4.38808209227215d-2*t1*t23*t4
            t88 = 1/t33**2
            t89 = 5.634986987915197d-5*t12*t80*t88+6.934448603031025d-2*
     1         gammaaa*t16*t25*t85-6.934448603031025d-2*gammaaa*t16*t17*
     2         t82*t83-1.369767625290079d-2*gammaaa*t34*t75-1.8491862941
     3         416065d-1*gammaaa*t17*t25*t75
            t90 = t86+t84+t76-4.38808209227215d-2*t39/rhoa**1.6666666666
     1         666669d+0
            t91 = 1/t43
            t92 = 5.0d-1*t90*t91
            t93 = -8.551882923536147d-2*t1*t23
            t94 = t93+t92
            t95 = 1/t47**2
            t96 = 1/t42
            t97 = 5.0d-1*t90*t96
            t98 = 1/t44**2
            t99 = 1/t49
            t100 = t86+t84+t76
            t101 = 1/t51
            t102 = 5.0d-1*t101*t90
            t103 = 1/t52**2
            t104 = 1/t54
            t105 = 1/t59**2
            t106 = t97+t102
            t107 = 1/t57**2
            t108 = 1/t61**2
            t109 = t63**2.5d+0
            t110 = 1/t67
            t111 = 1/t66
            t112 = 1/t31**2
            t113 = 1/t29**3
            t114 = -1.282782438530422d-1*t1*t113*t3*t87-8.55188292353614
     1         7d-2*t1*t23*t30
            t115 = t31*t87+t114*t27
            t116 = 1/t37**4.0d+0
            t117 = -8.159049802883108d-6*t12*t9-2.2598685135105387d-8*t2
     1         1*t8+6.15264526724925d-7*t10*t7+1.4171861479426412d-9*t19
     2         *t6+3.514198603154934d-2*t15*t5+3.420661236673031d-1*t23/
     3         t5-2.0532933130264455d-1*t16+1.488977446919221d-4*t11*t14
     4         -2.767412939521305d-3*gammaaa*t13
            t118 = -1.2983032190926402d-6*t12*t9+8.443340586693391d-8*t1
     1         0*t7+2.7008269700311227d-4*t15*t5+2.631878392200375d-4*t1
     2         6+1.3255240767081d-5*t11*t14-8.684798200538004d-5*gammaaa
     3         *t13
            t119 = -1.6455307846020562d-2*gammaaa*t117*t16*t17*t83+1.645
     1         5307846020562d-2*t16*t17*t25+1.6455307846020562d-2*gammaa
     2         a*t118*t16*t25
            t120 = -2.113120120468199d-5*gammaaa*t13*t88-6.9344486030310
     1         25d-2*gammaaa*t117*t16*t17*t83+5.136628594837797d-3*t16*t
     2         34+6.934448603031025d-2*t16*t17*t25+6.934448603031025d-2*
     3         gammaaa*t118*t16*t25
            t121 = 5.0d-1*t119*t96
            t122 = 5.0d-1*t119*t91
            t123 = 5.0d-1*t101*t119
            t124 = t123+t121
            t125 = t119*t31-1.282782438530422d-1*t1*t119*t3*t30
            fnc(iq) = fnc(iq)-9.305257363491d-1*t22*t73*wght
            Amat(iq,D1_RA) = -9.305257363491d-1*t22*(3.2910615692041123d
     1         -2*gammaaa*t16*t17*t25*(6.0965d-1*t48*(t97+t92)*t98+6.096
     2         5d-1*t45*t94*t95)*t99+7.57211d-1*(-1.6455307846020562d-2*
     3         gammaaa*t108*t16*t17*t25*t58*(t97+t93)-t105*t56*t58*(t93+
     4         t102)+1.6455307846020562d-2*gammaaa*t16*t25*t58*t62*t85-1
     5         .6455307846020562d-2*gammaaa*t16*t17*t58*t62*t82*t83-4.38
     6         808209227215d-2*gammaaa*t17*t25*t58*t62*t75-1.64553078460
     7         20562d-2*gammaaa*t106*t107*t16*t17*t25*t62+t100*t58*t60-t
     8         106*t107*t56*t60)-2.0d+0*t104*t56*(-1.475609999999999d-1*
     9         t53*t94*t95-1.475609999999999d-1*t103*t48*(t92+t102))-8.8
     :         88888888888888d-1*t70*t72*(4.7459599999999996d-2*t63*t89-
     ;         2.4d+0*t65*(6.41391219265211d-2*t111*(gammaaa*t16*t25*t85
     <         -gammaaa*t16*t17*t82*t83-2.6666666666666666d+0*gammaaa*t1
     =         7*t25*t75)-5.0d-1*t100*t110)-8.400000000000001d+0*t100*t1
     >         09*t68-2.7259596d+0*t100*t64+5.672746666666666d-2*t100*t6
     ?         3+4.7459599999999996d-2*t100*t35-4.9628707825354457d+0*t1
     @         00*t109)+5.273288888888887d-2*t36*t38*t89-8.8888888888888
     1         88d-1*t69*t70*(4.9365923538061685d-2*t71*(-5.0d-1*t1*t113
     2         *t3*t87-3.333333333333333d-1*t1*t23*t30)-1.44313024334672
     3         47d-1*t1*t113*t3*t87-9.620868288978164d-2*t1*t23*t30)+5.2
     4         73288888888887d-2*t35*t38*(-6.41391219265211d-2*t1*t113*t
     5         3*t87-4.2759414617680735d-2*t1*t23*t30)-4.727288888888889
     6         d-2*t32*t74*t87+3.2910615692041123d-2*gammaaa*t16*t25*t50
     7         *t85-3.2910615692041123d-2*gammaaa*t16*t17*t50*t82*t83-8.
     8         7761641845443d-2*gammaaa*t17*t25*t50*t75+2.66666666666666
     9         66d+0*t115*t116*t69*t72-1.0546577777777776d-1*t115*t35*t3
     :         6*t70-2.0d+0*t100*t55-4.727288888888889d-2*t112*t114*t28)
     ;         *wght-1.2407009817987999d+0*t2*t73*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-9.305257363491d-1*t22*(3.2
     1         910615692041123d-2*gammaaa*t16*t17*t25*(6.0965d-1*(t122+t
     2         121)*t48*t98+3.04825d-1*t119*t45*t91*t95)*t99+7.57211d-1*
     3         (-8.227653923010281d-3*gammaaa*t108*t119*t16*t17*t25*t58*
     4         t96-1.6455307846020562d-2*gammaaa*t117*t16*t17*t58*t62*t8
     5         3+1.6455307846020562d-2*t16*t17*t25*t58*t62+1.64553078460
     6         20562d-2*gammaaa*t118*t16*t25*t58*t62-1.6455307846020562d
     7         -2*gammaaa*t107*t124*t16*t17*t25*t62+t119*t58*t60-t107*t1
     8         24*t56*t60-5.0d-1*t101*t105*t119*t56*t58)-2.0d+0*t104*t56
     9         *(-7.378049999999994d-2*t119*t53*t91*t95-1.47560999999999
     :         9d-1*t103*(t123+t122)*t48)+t70*(-8.888888888888888d-1*t72
     ;         *(-2.4d+0*t65*(6.41391219265211d-2*t111*(-gammaaa*t117*t1
     <         6*t17*t83+t16*t17*t25+gammaaa*t118*t16*t25)-5.0d-1*t110*t
     =         119)-8.400000000000001d+0*t109*t119*t68-2.7259596d+0*t119
     >         *t64+4.7459599999999996d-2*t120*t63+5.672746666666666d-2*
     ?         t119*t63+4.7459599999999996d-2*t119*t35-4.962870782535445
     @         7d+0*t109*t119)-8.888888888888888d-1*t69*(-2.468296176903
     1         0842d-2*t119*t39*t40*t74-1.4431302433467247d-1*t1*t113*t1
     2         19*t3)-1.0546577777777776d-1*t125*t35*t36)-3.291061569204
     3         1123d-2*gammaaa*t117*t16*t17*t50*t83-4.727288888888889d-2
     4         *t119*t32*t74+2.6666666666666666d+0*t116*t125*t69*t72-2.0
     5         d+0*t119*t55+t16*t25*(3.2910615692041123d-2*t17*t50+3.291
     6         0615692041123d-2*gammaaa*t118*t50)+5.273288888888887d-2*t
     7         120*t36*t38-3.3822411899821336d-3*t1*t113*t119*t3*t35*t38
     8         +6.064083168526658d-3*t1*t112*t119*t3/t29**5)*wght
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = param(1)
            t2 = rhob**3.333333333333333d-1
            t3 = 1/t2
            t4 = t1*t3
            t5 = gammabb**5.0d-1
            t6 = t5**7
            t7 = 1/rhob**9.333333333333333d+0
            t8 = gammabb**3
            t9 = 1/rhob**8
            t10 = t5**5
            t11 = 1/rhob**6.666666666666667d+0
            t12 = gammabb**2
            t13 = 1/rhob**5.333333333333333d+0
            t14 = t5**3
            t15 = 1/rhob**4
            t16 = 1/rhob**2.6666666666666666d+0
            t17 = -4.327677396975467d-7*t8*t9+2.4123830247695402d-8*t6*t
     1         7+2.631878392200375d-4*gammabb*t16+1.8005513133540818d-4*
     2         t14*t15-4.342399100269002d-5*t12*t13+5.3020963068324d-6*t
     3         10*t11
            t18 = t5**9
            t19 = 1/rhob**12
            t20 = gammabb**4
            t21 = 1/rhob**1.0666666666666666d+1
            t22 = rhob**1.3333333333333333d+0
            t23 = 1/t22
            t24 = -2.7196832676277033d-6*t8*t9+1.7578986477855002d-7*t6*
     1         t7+6.841322473346062d-1*t23*t5-5.649671283776346d-9*t20*t
     2         21+3.149302550983647d-10*t18*t19-2.0532933130264455d-1*ga
     3         mmabb*t16+2.342799068769956d-2*t14*t15-1.3837064697606524
     4         d-3*t12*t13+5.955909787676884d-5*t10*t11+1.0d+0
            t25 = 1/t24
            t26 = 1.6455307846020562d-2*gammabb*t16*t17*t25
            t27 = 6.582123138408225d-2*t4**2.0d+0+t26+6.0965d-1
            t28 = 1/t27
            t29 = t27**5.0d-1
            t30 = 1/t29
            t31 = 2.565564877060844d-1*t1*t3*t30+1.0d+0
            t32 = 1/t31
            t33 = 4.1138269615051404d-3*gammabb*t16+1.0d+0
            t34 = 1/t33
            t35 = 5.136628594837797d-3*gammabb*t16*t34+6.934448603031025
     1         d-2*gammabb*t16*t17*t25+1.0d+0
            t36 = 1.282782438530422d-1*t1*t3*t30+1.0d+0
            t37 = t27*t31
            t38 = 1/t37**2.0d+0
            t39 = t1**2
            t40 = 1/rhob**6.666666666666666d-1
            t41 = 6.582123138408225d-2*t39*t40
            t42 = (t41+t26)**5.0d-1
            t43 = (t41+t26+6.0965d-1)**5.0d-1
            t44 = t43+t42
            t45 = 1/t44
            t46 = 2.565564877060844d-1*t1*t3
            t47 = t46+t43
            t48 = 1/t47
            t49 = 1.0d+0-6.0965d-1*t45*t48
            t50 = log(t49)
            t51 = (t41+t26+7.57211d-1)**5.0d-1
            t52 = t51+t43
            t53 = 1/t52
            t54 = 1.475609999999999d-1*t48*t53+1.0d+0
            t55 = log(t54)
            t56 = t26+7.57211d-1
            t57 = t51+t42
            t58 = 1/t57
            t59 = t51+t46
            t60 = 1/t59
            t61 = t46+t42
            t62 = 1/t61
            t63 = t26+6.0965d-1
            t64 = t63**2.0d+0
            t65 = t63**3.5d+0
            t66 = (gammabb*t16*t17*t25)**5.0d-1
            t67 = t56**5.0d-1
            t68 = 1.282782438530422d-1*t66-t67
            t69 = -2.4d+0*t65*t68-1.417963080724413d+0*t65+2.83637333333
     1         3333d-2*t64-9.086532d-1*t63**3.0d+0+4.7459599999999996d-2
     2         *t35*t63
            t70 = 1/t37**3.0d+0
            t71 = t1*t3*t30
            t72 = 2.4682961769030842d-2*t71**2.0d+0+2.8862604866934494d-
     1         1*t1*t3*t30+1.0d+0
            t73 = -8.888888888888888d-1*t69*t70*t72+7.57211d-1*(1.645530
     1         7846020562d-2*gammabb*t16*t17*t25*t58*t62+t56*t58*t60)-2.
     2         0d+0*t55*t56+3.2910615692041123d-2*gammabb*t16*t17*t25*t5
     3         0+5.273288888888887d-2*t35*t36*t38+4.727288888888889d-2*t
     4         28*t32-1.0d+0
            t74 = 1/t27**2
            t75 = 1/rhob**3.6666666666666664d+0
            t76 = -4.38808209227215d-2*gammabb*t17*t25*t75
            t77 = 1/rhob**1.0333333333333333d+1
            t78 = 1/rhob**9
            t79 = 1/rhob**7.666666666666667d+0
            t80 = 1/rhob**6.333333333333333d+0
            t81 = 1/rhob**5
            t82 = -9.371196275079824d-2*t14*t81+7.379767838723479d-3*t12
     1         *t80+2.1757466141021625d-5*t78*t8-3.970606525117923d-4*t1
     2         0*t79-1.6407054045998d-6*t6*t77+5.475448834737188d-1*gamm
     3         abb*t75-9.121763297794749d-1*t5/rhob**2.3333333333333334d
     4         +0+6.026316036028103d-8*t20/rhob**1.1666666666666665d+1-3
     5         .7791630611803767d-9*t18/rhob**13
            t83 = 1/t24**2
            t84 = -1.6455307846020562d-2*gammabb*t16*t17*t82*t83
            t85 = -7.202205253416327d-4*t14*t81+2.3159461868101344d-4*t1
     1         2*t80+3.462141917580374d-6*t78*t8-3.5347308712216d-5*t10*
     2         t79-2.2515574897849044d-7*t6*t77-7.018342379201d-4*gammab
     3         b*t75
            t86 = 1.6455307846020562d-2*gammabb*t16*t25*t85
            t87 = t86+t84+t76-4.38808209227215d-2*t1*t23*t4
            t88 = 1/t33**2
            t89 = 5.634986987915197d-5*t12*t80*t88+6.934448603031025d-2*
     1         gammabb*t16*t25*t85-6.934448603031025d-2*gammabb*t16*t17*
     2         t82*t83-1.369767625290079d-2*gammabb*t34*t75-1.8491862941
     3         416065d-1*gammabb*t17*t25*t75
            t90 = t86+t84+t76-4.38808209227215d-2*t39/rhob**1.6666666666
     1         666669d+0
            t91 = 1/t43
            t92 = 5.0d-1*t90*t91
            t93 = -8.551882923536147d-2*t1*t23
            t94 = t93+t92
            t95 = 1/t47**2
            t96 = 1/t42
            t97 = 5.0d-1*t90*t96
            t98 = 1/t44**2
            t99 = 1/t49
            t100 = t86+t84+t76
            t101 = 1/t51
            t102 = 5.0d-1*t101*t90
            t103 = 1/t52**2
            t104 = 1/t54
            t105 = 1/t59**2
            t106 = t97+t102
            t107 = 1/t57**2
            t108 = 1/t61**2
            t109 = t63**2.5d+0
            t110 = 1/t67
            t111 = 1/t66
            t112 = 1/t31**2
            t113 = 1/t29**3
            t114 = -1.282782438530422d-1*t1*t113*t3*t87-8.55188292353614
     1         7d-2*t1*t23*t30
            t115 = t31*t87+t114*t27
            t116 = 1/t37**4.0d+0
            t117 = -8.159049802883108d-6*t12*t9-2.2598685135105387d-8*t2
     1         1*t8+6.15264526724925d-7*t10*t7+1.4171861479426412d-9*t19
     2         *t6+3.514198603154934d-2*t15*t5+3.420661236673031d-1*t23/
     3         t5-2.0532933130264455d-1*t16+1.488977446919221d-4*t11*t14
     4         -2.767412939521305d-3*gammabb*t13
            t118 = -1.2983032190926402d-6*t12*t9+8.443340586693391d-8*t1
     1         0*t7+2.7008269700311227d-4*t15*t5+2.631878392200375d-4*t1
     2         6+1.3255240767081d-5*t11*t14-8.684798200538004d-5*gammabb
     3         *t13
            t119 = -1.6455307846020562d-2*gammabb*t117*t16*t17*t83+1.645
     1         5307846020562d-2*t16*t17*t25+1.6455307846020562d-2*gammab
     2         b*t118*t16*t25
            t120 = -2.113120120468199d-5*gammabb*t13*t88-6.9344486030310
     1         25d-2*gammabb*t117*t16*t17*t83+5.136628594837797d-3*t16*t
     2         34+6.934448603031025d-2*t16*t17*t25+6.934448603031025d-2*
     3         gammabb*t118*t16*t25
            t121 = 5.0d-1*t119*t96
            t122 = 5.0d-1*t119*t91
            t123 = 5.0d-1*t101*t119
            t124 = t123+t121
            t125 = t119*t31-1.282782438530422d-1*t1*t119*t3*t30
            fnc(iq) = fnc(iq)-9.305257363491d-1*t22*t73*wght
            Amat(iq,D1_RB) = -9.305257363491d-1*t22*(3.2910615692041123d
     1         -2*gammabb*t16*t17*t25*(6.0965d-1*t48*(t97+t92)*t98+6.096
     2         5d-1*t45*t94*t95)*t99+7.57211d-1*(-1.6455307846020562d-2*
     3         gammabb*t108*t16*t17*t25*t58*(t97+t93)-t105*t56*t58*(t93+
     4         t102)+1.6455307846020562d-2*gammabb*t16*t25*t58*t62*t85-1
     5         .6455307846020562d-2*gammabb*t16*t17*t58*t62*t82*t83-4.38
     6         808209227215d-2*gammabb*t17*t25*t58*t62*t75-1.64553078460
     7         20562d-2*gammabb*t106*t107*t16*t17*t25*t62+t100*t58*t60-t
     8         106*t107*t56*t60)-2.0d+0*t104*t56*(-1.475609999999999d-1*
     9         t53*t94*t95-1.475609999999999d-1*t103*t48*(t92+t102))-8.8
     :         88888888888888d-1*t70*t72*(4.7459599999999996d-2*t63*t89-
     ;         2.4d+0*t65*(6.41391219265211d-2*t111*(gammabb*t16*t25*t85
     <         -gammabb*t16*t17*t82*t83-2.6666666666666666d+0*gammabb*t1
     =         7*t25*t75)-5.0d-1*t100*t110)-8.400000000000001d+0*t100*t1
     >         09*t68-2.7259596d+0*t100*t64+5.672746666666666d-2*t100*t6
     ?         3+4.7459599999999996d-2*t100*t35-4.9628707825354457d+0*t1
     @         00*t109)+5.273288888888887d-2*t36*t38*t89-8.8888888888888
     1         88d-1*t69*t70*(4.9365923538061685d-2*t71*(-5.0d-1*t1*t113
     2         *t3*t87-3.333333333333333d-1*t1*t23*t30)-1.44313024334672
     3         47d-1*t1*t113*t3*t87-9.620868288978164d-2*t1*t23*t30)+5.2
     4         73288888888887d-2*t35*t38*(-6.41391219265211d-2*t1*t113*t
     5         3*t87-4.2759414617680735d-2*t1*t23*t30)-4.727288888888889
     6         d-2*t32*t74*t87+3.2910615692041123d-2*gammabb*t16*t25*t50
     7         *t85-3.2910615692041123d-2*gammabb*t16*t17*t50*t82*t83-8.
     8         7761641845443d-2*gammabb*t17*t25*t50*t75+2.66666666666666
     9         66d+0*t115*t116*t69*t72-1.0546577777777776d-1*t115*t35*t3
     :         6*t70-2.0d+0*t100*t55-4.727288888888889d-2*t112*t114*t28)
     ;         *wght-1.2407009817987999d+0*t2*t73*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)-9.305257363491d-1*t22*(3.2
     1         910615692041123d-2*gammabb*t16*t17*t25*(6.0965d-1*(t122+t
     2         121)*t48*t98+3.04825d-1*t119*t45*t91*t95)*t99+7.57211d-1*
     3         (-8.227653923010281d-3*gammabb*t108*t119*t16*t17*t25*t58*
     4         t96-1.6455307846020562d-2*gammabb*t117*t16*t17*t58*t62*t8
     5         3+1.6455307846020562d-2*t16*t17*t25*t58*t62+1.64553078460
     6         20562d-2*gammabb*t118*t16*t25*t58*t62-1.6455307846020562d
     7         -2*gammabb*t107*t124*t16*t17*t25*t62+t119*t58*t60-t107*t1
     8         24*t56*t60-5.0d-1*t101*t105*t119*t56*t58)-2.0d+0*t104*t56
     9         *(-7.378049999999994d-2*t119*t53*t91*t95-1.47560999999999
     :         9d-1*t103*(t123+t122)*t48)+t70*(-8.888888888888888d-1*t72
     ;         *(-2.4d+0*t65*(6.41391219265211d-2*t111*(-gammabb*t117*t1
     <         6*t17*t83+t16*t17*t25+gammabb*t118*t16*t25)-5.0d-1*t110*t
     =         119)-8.400000000000001d+0*t109*t119*t68-2.7259596d+0*t119
     >         *t64+4.7459599999999996d-2*t120*t63+5.672746666666666d-2*
     ?         t119*t63+4.7459599999999996d-2*t119*t35-4.962870782535445
     @         7d+0*t109*t119)-8.888888888888888d-1*t69*(-2.468296176903
     1         0842d-2*t119*t39*t40*t74-1.4431302433467247d-1*t1*t113*t1
     2         19*t3)-1.0546577777777776d-1*t125*t35*t36)-3.291061569204
     3         1123d-2*gammabb*t117*t16*t17*t50*t83-4.727288888888889d-2
     4         *t119*t32*t74+2.6666666666666666d+0*t116*t125*t69*t72-2.0
     5         d+0*t119*t55+t16*t25*(3.2910615692041123d-2*t17*t50+3.291
     6         0615692041123d-2*gammabb*t118*t50)+5.273288888888887d-2*t
     7         120*t36*t38-3.3822411899821336d-3*t1*t113*t119*t3*t35*t38
     8         +6.064083168526658d-3*t1*t112*t119*t3/t29**5)*wght
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_x_wpbe functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{{{4}\over{3}}}\\\\ 
C>   {\it t_2} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_3} &=& {{1}\over{\rho_\alpha^4}}\\\\ 
C>   {\it t_4} &=& \sqrt{\sigma_{\alpha\alpha}}\\\\ 
C>   {\it t_5} &=& {\it t_4}^3\\\\ 
C>   {\it t_6} &=& {{1}\over{\rho_\alpha^{{{16}\over{3}}}}}\\\\ 
C>   {\it t_7} &=& \sigma_{\alpha\alpha}^2\\\\ 
C>   {\it t_8} &=& {{1}\over{\rho_\alpha^{{{20}\over{3}}}}}\\\\ 
C>   {\it t_9} &=& {\it t_4}^5\\\\ 
C>   {\it t_{10}} &=& {{1}\over{\rho_\alpha^8}}\\\\ 
C>   {\it t_{11}} &=& \sigma_{\alpha\alpha}^3\\\\ 
C>   {\it t_{12}} &=& {{1}\over{\rho_\alpha^{{{28}\over{3}}}}}\\\\ 
C>   {\it t_{13}} &=& {\it t_4}^7\\\\ 
C>   {\it t_{14}} &=& 2.41238302476954 \times 10^{-8}\,{\it t_{12}}
C>    \,{\it t_{13}}-4.327677396975467 \times 10^{-7}\,{\it t_{10}}
C>    \,{\it t_{11}}+5.3020963068324 \times 10^{-6}\,{\it t_8}\,{
C>    \it t_9}-4.342399100269002 \times 10^{-5}\,{\it t_6}\,{\it t_7}
C>    +1.800551313354082 \times 10^{-4}\,{\it t_3}\,{\it t_5}
C>    +2.631878392200375 \times 10^{-4}\,{\it t_2}\,
C>    \sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{15}} &=& {{1}\over{{{3.149302550983647 \times 10^{-10}
C>    \,{\it t_4}^9}\over{\rho_\alpha^{12}}}
C>    -{{5.649671283776346 \times 10^{-9}\,
C>    \sigma_{\alpha\alpha}^4}\over{\rho_\alpha^{{{32}\over{3}}}}}
C>    +1.7578986477855 \times 10^{-7}\,{\it t_{12}}\,{\it t_{13}}
C>    -2.719683267627703 \times 10^{-6}\,{\it t_{10}}\,{\it t_{11}}
C>    +5.955909787676884 \times 10^{-5}\,{\it t_8}\,{\it t_9}
C>    -0.001383706469760652\,{\it t_6}\,{\it t_7}
C>    +0.02342799068769956\,{\it t_3}\,{\it t_5}-0.2053293313026446
C>    \,{\it t_2}\,\sigma_{\alpha\alpha}+{{0.6841322473346062\,{
C>    \it t_4}}\over{{\it t_1}}}+1.0}}\\\\ 
C>   {\it t_{16}} &=& 0.01645530784602056\,{\it t_2}\,
C>    \sigma_{\alpha\alpha}\,{\it t_{14}}\,{\it t_{15}}\\\\ 
C>   {\it t_{17}} &=& {\it t_{16}}+0.60965\\\\ 
C>   {\it t_{18}} &=& 0.06934448603031025\,{\it t_2}\,
C>    \sigma_{\alpha\alpha}\,{\it t_{14}}\,{\it t_{15}}
C>    +{{0.005136628594837796\,{\it t_2}\,
C>    \sigma_{\alpha\alpha}}\over{0.00411382696150514\,{\it t_2}
C>    \,\sigma_{\alpha\alpha}+1.0}}+1.0\\\\ 
C>   {\it t_{19}} &=& {\it t_{17}}^{3.5}\\\\ 
C>   {\it t_{20}} &=& {\it t_{16}}+0.757211\\\\ 
C>   {\it t_{21}} &=& {\it param}\left(1\right)\\\\ 
C>   {\it t_{22}} &=& {{1}\over{\rho_\alpha^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{23}} &=& {\it t_{16}}+0.06582123138408225\,\left({
C>    \it t_{21}}\,{\it t_{22}}\right)^{2.0}+0.60965\\\\ 
C>   {\it t_{24}} &=& {{1}\over{\sqrt{{\it t_{23}}}}}\\\\ 
C>   {\it t_{25}} &=& 0.2565564877060844\,{\it t_{21}}\,{\it t_{22}}
C>    \,{\it t_{24}}+1.0\\\\ 
C>   {\it t_{26}} &=& {\it t_{23}}\,{\it t_{25}}\\\\ 
C>   {\it t_{27}} &=& 0.2565564877060844\,{\it t_{21}}\,{
C>    \it t_{22}}\\\\ 
C>   {\it t_{28}} &=& {\it t_{21}}^2\\\\ 
C>   {\it t_{29}} &=& {{0.06582123138408225\,{\it t_{28}}}
C>    \over{\rho_\alpha^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{30}} &=& \sqrt{{\it t_{16}}+{\it t_{29}}}\\\\ 
C>   {\it t_{31}} &=& \sqrt{{\it t_{16}}+{\it t_{29}}+0.757211}\\\\ 
C>   {\it t_{32}} &=& {{1}\over{{\it t_{31}}+{\it t_{30}}}}\\\\ 
C>   {\it t_{33}} &=& \sqrt{{\it t_{16}}+{\it t_{29}}+0.60965}\\\\ 
C>   {\it t_{34}} &=& {{1}\over{{\it t_{33}}+{\it t_{27}}}}\\\\ 
C>   {\it t_{35}} &=& \rho_\beta^{{{4}\over{3}}}\\\\ 
C>   {\it t_{36}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{37}} &=& {{1}\over{\rho_\beta^4}}\\\\ 
C>   {\it t_{38}} &=& \sqrt{\sigma_{\beta\beta}}\\\\ 
C>   {\it t_{39}} &=& {\it t_{38}}^3\\\\ 
C>   {\it t_{40}} &=& {{1}\over{\rho_\beta^{{{16}\over{3}}}}}\\\\ 
C>   {\it t_{41}} &=& \sigma_{\beta\beta}^2\\\\ 
C>   {\it t_{42}} &=& {{1}\over{\rho_\beta^{{{20}\over{3}}}}}\\\\ 
C>   {\it t_{43}} &=& {\it t_{38}}^5\\\\ 
C>   {\it t_{44}} &=& {{1}\over{\rho_\beta^8}}\\\\ 
C>   {\it t_{45}} &=& \sigma_{\beta\beta}^3\\\\ 
C>   {\it t_{46}} &=& {{1}\over{\rho_\beta^{{{28}\over{3}}}}}\\\\ 
C>   {\it t_{47}} &=& {\it t_{38}}^7\\\\ 
C>   {\it t_{48}} &=& 2.41238302476954 \times 10^{-8}\,{\it t_{46}}
C>    \,{\it t_{47}}-4.327677396975467 \times 10^{-7}\,{\it t_{44}}
C>    \,{\it t_{45}}+5.3020963068324 \times 10^{-6}\,{\it t_{42}}
C>    \,{\it t_{43}}-4.342399100269002 \times 10^{-5}\,{\it t_{40}}
C>    \,{\it t_{41}}+1.800551313354082 \times 10^{-4}\,{\it t_{37}}
C>    \,{\it t_{39}}+2.631878392200375 \times 10^{-4}\,{\it t_{36}}
C>    \,\sigma_{\beta\beta}\\\\ 
C>   {\it t_{49}} &=& {{1}\over{{{3.149302550983647 \times 10^{-10}
C>    \,{\it t_{38}}^9}\over{\rho_\beta^{12}}}
C>    -{{5.649671283776346 \times 10^{-9}\,
C>    \sigma_{\beta\beta}^4}\over{\rho_\beta^{{{32}\over{3}}}}}
C>    +1.7578986477855 \times 10^{-7}\,{\it t_{46}}\,{\it t_{47}}
C>    -2.719683267627703 \times 10^{-6}\,{\it t_{44}}\,{\it t_{45}}
C>    +5.955909787676884 \times 10^{-5}\,{\it t_{42}}\,{\it t_{43}}
C>    -0.001383706469760652\,{\it t_{40}}\,{\it t_{41}}
C>    +0.02342799068769956\,{\it t_{37}}\,{\it t_{39}}
C>    -0.2053293313026446\,{\it t_{36}}\,\sigma_{\beta\beta}
C>    +{{0.6841322473346062\,{\it t_{38}}}\over{{\it t_{35}}}}
C>    +1.0}}\\\\ 
C>   {\it t_{50}} &=& 0.01645530784602056\,{\it t_{36}}\,
C>    \sigma_{\beta\beta}\,{\it t_{48}}\,{\it t_{49}}\\\\ 
C>   {\it t_{51}} &=& {\it t_{50}}+0.60965\\\\ 
C>   {\it t_{52}} &=& 0.06934448603031025\,{\it t_{36}}\,
C>    \sigma_{\beta\beta}\,{\it t_{48}}\,{\it t_{49}}
C>    +{{0.005136628594837796\,{\it t_{36}}\,
C>    \sigma_{\beta\beta}}\over{0.00411382696150514\,{\it t_{36}}
C>    \,\sigma_{\beta\beta}+1.0}}+1.0\\\\ 
C>   {\it t_{53}} &=& {\it t_{51}}^{3.5}\\\\ 
C>   {\it t_{54}} &=& {\it t_{50}}+0.757211\\\\ 
C>   {\it t_{55}} &=& {{1}\over{\rho_\beta^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{56}} &=& {\it t_{50}}+0.06582123138408225\,\left({
C>    \it t_{21}}\,{\it t_{55}}\right)^{2.0}+0.60965\\\\ 
C>   {\it t_{57}} &=& {{1}\over{\sqrt{{\it t_{56}}}}}\\\\ 
C>   {\it t_{58}} &=& 0.2565564877060844\,{\it t_{21}}\,{\it t_{55}}
C>    \,{\it t_{57}}+1.0\\\\ 
C>   {\it t_{59}} &=& {\it t_{56}}\,{\it t_{58}}\\\\ 
C>   {\it t_{60}} &=& 0.2565564877060844\,{\it t_{21}}\,{
C>    \it t_{55}}\\\\ 
C>   {\it t_{61}} &=& {{0.06582123138408225\,{\it t_{28}}}
C>    \over{\rho_\beta^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{62}} &=& \sqrt{{\it t_{50}}+{\it t_{61}}}\\\\ 
C>   {\it t_{63}} &=& \sqrt{{\it t_{50}}+{\it t_{61}}+0.757211}\\\\ 
C>   {\it t_{64}} &=& {{1}\over{{\it t_{63}}+{\it t_{62}}}}\\\\ 
C>   {\it t_{65}} &=& \sqrt{{\it t_{50}}+{\it t_{61}}+0.60965}\\\\ 
C>   {\it t_{66}} &=& {{1}\over{{\it t_{65}}+{\it t_{60}}}}\\\\ 
C>   {\it t_{67}} &=& \rho_s^{{{4}\over{3}}}\\\\ 
C>   {\it t_{68}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{69}} &=& {{1}\over{\rho_s^4}}\\\\ 
C>   {\it t_{70}} &=& \sqrt{\sigma_{ss}}\\\\ 
C>   {\it t_{71}} &=& {\it t_{70}}^3\\\\ 
C>   {\it t_{72}} &=& {{1}\over{\rho_s^{{{16}\over{3}}}}}\\\\ 
C>   {\it t_{73}} &=& \sigma_{ss}^2\\\\ 
C>   {\it t_{74}} &=& {{1}\over{\rho_s^{{{20}\over{3}}}}}\\\\ 
C>   {\it t_{75}} &=& {\it t_{70}}^5\\\\ 
C>   {\it t_{76}} &=& {{1}\over{\rho_s^8}}\\\\ 
C>   {\it t_{77}} &=& \sigma_{ss}^3\\\\ 
C>   {\it t_{78}} &=& {{1}\over{\rho_s^{{{28}\over{3}}}}}\\\\ 
C>   {\it t_{79}} &=& {\it t_{70}}^7\\\\ 
C>   {\it t_{80}} &=& 2.41238302476954 \times 10^{-8}\,{\it t_{78}}
C>    \,{\it t_{79}}-4.327677396975467 \times 10^{-7}\,{\it t_{76}}
C>    \,{\it t_{77}}+5.3020963068324 \times 10^{-6}\,{\it t_{74}}
C>    \,{\it t_{75}}-4.342399100269002 \times 10^{-5}\,{\it t_{72}}
C>    \,{\it t_{73}}+1.800551313354082 \times 10^{-4}\,{\it t_{69}}
C>    \,{\it t_{71}}+2.631878392200375 \times 10^{-4}\,{\it t_{68}}
C>    \,\sigma_{ss}\\\\ 
C>   {\it t_{81}} &=& {{1}\over{{{3.149302550983647 \times 10^{-10}
C>    \,{\it t_{70}}^9}\over{\rho_s^{12}}}
C>    -{{5.649671283776346 \times 10^{-9}\,\sigma_{ss}^4}
C>    \over{\rho_s^{{{32}\over{3}}}}}+1.7578986477855 \times 10^{-7}
C>    \,{\it t_{78}}\,{\it t_{79}}-2.719683267627703 \times 10^{-6}
C>    \,{\it t_{76}}\,{\it t_{77}}+5.955909787676884 \times 10^{-5}
C>    \,{\it t_{74}}\,{\it t_{75}}-0.001383706469760652\,{
C>    \it t_{72}}\,{\it t_{73}}+0.02342799068769956\,{\it t_{69}}
C>    \,{\it t_{71}}-0.2053293313026446\,{\it t_{68}}\,\sigma_{ss}
C>    +{{0.6841322473346062\,{\it t_{70}}}\over{{\it t_{67}}}}
C>    +1.0}}\\\\ 
C>   {\it t_{82}} &=& 0.01645530784602056\,{\it t_{68}}\,\sigma_{ss}
C>    \,{\it t_{80}}\,{\it t_{81}}\\\\ 
C>   {\it t_{83}} &=& {\it t_{82}}+0.60965\\\\ 
C>   {\it t_{84}} &=& 0.06934448603031025\,{\it t_{68}}\,\sigma_{ss}
C>    \,{\it t_{80}}\,{\it t_{81}}+{{0.005136628594837796\,{
C>    \it t_{68}}\,\sigma_{ss}}\over{0.00411382696150514\,{
C>    \it t_{68}}\,\sigma_{ss}+1.0}}+1.0\\\\ 
C>   {\it t_{85}} &=& {\it t_{83}}^{3.5}\\\\ 
C>   {\it t_{86}} &=& {\it t_{82}}+0.757211\\\\ 
C>   {\it t_{87}} &=& {{1}\over{\rho_s^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{88}} &=& {\it t_{82}}+0.06582123138408225\,\left({
C>    \it t_{21}}\,{\it t_{87}}\right)^{2.0}+0.60965\\\\ 
C>   {\it t_{89}} &=& {{1}\over{\sqrt{{\it t_{88}}}}}\\\\ 
C>   {\it t_{90}} &=& 0.2565564877060844\,{\it t_{21}}\,{\it t_{87}}
C>    \,{\it t_{89}}+1.0\\\\ 
C>   {\it t_{91}} &=& {\it t_{88}}\,{\it t_{90}}\\\\ 
C>   {\it t_{92}} &=& 0.2565564877060844\,{\it t_{21}}\,{
C>    \it t_{87}}\\\\ 
C>   {\it t_{93}} &=& {{0.06582123138408225\,{\it t_{28}}}
C>    \over{\rho_s^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{94}} &=& \sqrt{{\it t_{82}}+{\it t_{93}}}\\\\ 
C>   {\it t_{95}} &=& \sqrt{{\it t_{82}}+{\it t_{93}}+0.757211}\\\\ 
C>   {\it t_{96}} &=& {{1}\over{{\it t_{95}}+{\it t_{94}}}}\\\\ 
C>   {\it t_{97}} &=& \sqrt{{\it t_{82}}+{\it t_{93}}+0.60965}\\\\ 
C>   {\it t_{98}} &=& {{1}\over{{\it t_{97}}+{\it t_{92}}}}\\\\ 
C>   f &=& -0.9305257363491\,{\it t_{35}}\,\left(-2.0\,{\it t_{54}}
C>    \,\log \left({{0.1475609999999999\,{\it t_{66}}}\over{{
C>    \it t_{63}}+{\it t_{65}}}}+1.0\right)+0.03291061569204112\,{
C>    \it t_{36}}\,\sigma_{\beta\beta}\,{\it t_{48}}\,{\it t_{49}}
C>    \,\log \left(1.0-{{0.60965\,{\it t_{66}}}\over{{\it t_{65}}
C>    +{\it t_{62}}}}\right)+0.757211\,\left({{{\it t_{54}}\,{
C>    \it t_{64}}}\over{{\it t_{63}}+{\it t_{60}}}}
C>    +{{0.01645530784602056\,{\it t_{36}}\,\sigma_{\beta\beta}\,{
C>    \it t_{48}}\,{\it t_{49}}\,{\it t_{64}}}\over{{\it t_{62}}+{
C>    \it t_{60}}}}\right)+{{0.05273288888888888\,{\it t_{52}}
C>    \,\left(0.1282782438530422\,{\it t_{21}}\,{\it t_{55}}\,{
C>    \it t_{57}}+1.0\right)}\over{{\it t_{59}}^{2.0}}}
C>    +{{0.04727288888888889}\over{{\it t_{56}}\,{\it t_{58}}}}
C>    -{{0.8888888888888888\,\left(-2.4\,{\it t_{53}}\,
C>    \left(0.1282782438530422\,\sqrt{{\it t_{36}}\,
C>    \sigma_{\beta\beta}\,{\it t_{48}}\,{\it t_{49}}}-\sqrt{{
C>    \it t_{54}}}\right)-1.417963080724413\,{\it t_{53}}-0.9086532
C>    \,{\it t_{51}}^{3.0}+0.02836373333333333\,{\it t_{51}}^{2.0}
C>    +0.0474596\,{\it t_{51}}\,{\it t_{52}}\right)\,
C>    \left(0.02468296176903084\,\left({\it t_{21}}\,{\it t_{55}}
C>    \,{\it t_{57}}\right)^{2.0}+0.2886260486693449\,{\it t_{21}}
C>    \,{\it t_{55}}\,{\it t_{57}}+1.0\right)}\over{{
C>    \it t_{59}}^{3.0}}}-1.0\right)-0.9305257363491\,{\it t_1}
C>    \,\left(-2.0\,{\it t_{20}}\,\log \left({{0.1475609999999999
C>    \,{\it t_{34}}}\over{{\it t_{31}}+{\it t_{33}}}}+1.0\right)
C>    +0.03291061569204112\,{\it t_2}\,\sigma_{\alpha\alpha}\,{
C>    \it t_{14}}\,{\it t_{15}}\,\log \left(1.0-{{0.60965\,{
C>    \it t_{34}}}\over{{\it t_{33}}+{\it t_{30}}}}\right)+0.757211
C>    \,\left({{{\it t_{20}}\,{\it t_{32}}}\over{{\it t_{31}}+{
C>    \it t_{27}}}}+{{0.01645530784602056\,{\it t_2}\,
C>    \sigma_{\alpha\alpha}\,{\it t_{14}}\,{\it t_{15}}\,{
C>    \it t_{32}}}\over{{\it t_{30}}+{\it t_{27}}}}\right)
C>    +{{0.05273288888888888\,{\it t_{18}}\,\left(0.1282782438530422
C>    \,{\it t_{21}}\,{\it t_{22}}\,{\it t_{24}}+1.0\right)}
C>    \over{{\it t_{26}}^{2.0}}}+{{0.04727288888888889}\over{{
C>    \it t_{23}}\,{\it t_{25}}}}-{{0.8888888888888888\,\left(-2.4
C>    \,{\it t_{19}}\,\left(0.1282782438530422\,\sqrt{{\it t_2}
C>    \,\sigma_{\alpha\alpha}\,{\it t_{14}}\,{\it t_{15}}}-\sqrt{{
C>    \it t_{20}}}\right)-1.417963080724413\,{\it t_{19}}-0.9086532
C>    \,{\it t_{17}}^{3.0}+0.02836373333333333\,{\it t_{17}}^{2.0}
C>    +0.0474596\,{\it t_{17}}\,{\it t_{18}}\right)\,
C>    \left(0.02468296176903084\,\left({\it t_{21}}\,{\it t_{22}}
C>    \,{\it t_{24}}\right)^{2.0}+0.2886260486693449\,{\it t_{21}}
C>    \,{\it t_{22}}\,{\it t_{24}}+1.0\right)}\over{{
C>    \it t_{26}}^{3.0}}}-1.0\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& -0.9305257363491\,{\it t_{67}}\,\left(-2.0\,{\it t_{86}}
C>    \,\log \left({{0.1475609999999999\,{\it t_{98}}}\over{{
C>    \it t_{95}}+{\it t_{97}}}}+1.0\right)+0.03291061569204112\,{
C>    \it t_{68}}\,\sigma_{ss}\,{\it t_{80}}\,{\it t_{81}}
C>    \,\log \left(1.0-{{0.60965\,{\it t_{98}}}\over{{\it t_{97}}
C>    +{\it t_{94}}}}\right)+0.757211\,\left({{{\it t_{86}}\,{
C>    \it t_{96}}}\over{{\it t_{95}}+{\it t_{92}}}}
C>    +{{0.01645530784602056\,{\it t_{68}}\,\sigma_{ss}\,{
C>    \it t_{80}}\,{\it t_{81}}\,{\it t_{96}}}\over{{\it t_{94}}+{
C>    \it t_{92}}}}\right)+{{0.05273288888888888\,{\it t_{84}}
C>    \,\left(0.1282782438530422\,{\it t_{21}}\,{\it t_{87}}\,{
C>    \it t_{89}}+1.0\right)}\over{{\it t_{91}}^{2.0}}}
C>    +{{0.04727288888888889}\over{{\it t_{88}}\,{\it t_{90}}}}
C>    -{{0.8888888888888888\,\left(-2.4\,{\it t_{85}}\,
C>    \left(0.1282782438530422\,\sqrt{{\it t_{68}}\,\sigma_{ss}\,{
C>    \it t_{80}}\,{\it t_{81}}}-\sqrt{{\it t_{86}}}\right)
C>    -1.417963080724413\,{\it t_{85}}-0.9086532\,{\it t_{83}}^{3.0}
C>    +0.02836373333333333\,{\it t_{83}}^{2.0}+0.0474596\,{
C>    \it t_{83}}\,{\it t_{84}}\right)\,\left(0.02468296176903084
C>    \,\left({\it t_{21}}\,{\it t_{87}}\,{\it t_{89}}\right)^{2.0}
C>    +0.2886260486693449\,{\it t_{21}}\,{\it t_{87}}\,{\it t_{89}}
C>    +1.0\right)}\over{{\it t_{91}}^{3.0}}}-1.0\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] E Weintraub, TM Henderson, GE Scuseria
C>    , J.Chem.Theory.Comput. 5, 754 (2009)  , DOI: 
C> <a href="https://doi.org/10.1021/ct800530u "> 
C> 10.1021/ct800530u </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_x_wpbe_d2(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Amat2,Cmat,Cmat2) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,*)  !< [Output] The 2nd derivative wrt rgamma 
                                    !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = param(1)
            t2 = rhoa**3.333333333333333d-1
            t3 = 1/t2
            t4 = gammaaa**5.0d-1
            t5 = t4**7
            t6 = 1/rhoa**9.333333333333333d+0
            t7 = gammaaa**3
            t8 = 1/rhoa**8
            t9 = t4**5
            t10 = 1/rhoa**6.666666666666667d+0
            t11 = gammaaa**2
            t12 = 1/rhoa**5.333333333333333d+0
            t13 = t4**3
            t14 = 1/rhoa**4
            t15 = 1/rhoa**2.6666666666666666d+0
            t16 = 5.3020963068324d-6*t10*t9-4.327677396975467d-7*t7*t8+2
     1         .4123830247695402d-8*t5*t6+2.631878392200375d-4*gammaaa*t
     2         15+1.8005513133540818d-4*t13*t14-4.342399100269002d-5*t11
     3         *t12
            t17 = t4**9
            t18 = 1/rhoa**12
            t19 = gammaaa**4
            t20 = 1/rhoa**1.0666666666666666d+1
            t21 = rhoa**1.3333333333333333d+0
            t22 = 1/t21
            t23 = 5.955909787676884d-5*t10*t9-2.7196832676277033d-6*t7*t
     1         8+1.7578986477855002d-7*t5*t6+6.841322473346062d-1*t22*t4
     2         -5.649671283776346d-9*t19*t20+3.149302550983647d-10*t17*t
     3         18-2.0532933130264455d-1*gammaaa*t15+2.342799068769956d-2
     4         *t13*t14-1.3837064697606524d-3*t11*t12+1.0d+0
            t24 = 1/t23
            t25 = 1.6455307846020562d-2*gammaaa*t15*t16*t24
            t26 = 6.582123138408225d-2*(t1*t3)**2.0d+0+t25+6.0965d-1
            t27 = 1/t26
            t28 = t26**5.0d-1
            t29 = 1/t28
            t30 = 2.565564877060844d-1*t1*t29*t3+1.0d+0
            t31 = 1/t30
            t32 = 4.1138269615051404d-3*gammaaa*t15+1.0d+0
            t33 = 1/t32
            t34 = 5.136628594837797d-3*gammaaa*t15*t33+6.934448603031025
     1         d-2*gammaaa*t15*t16*t24+1.0d+0
            t35 = 1.282782438530422d-1*t1*t29*t3+1.0d+0
            t36 = t26*t30
            t37 = 1/t36**2.0d+0
            t38 = t1**2
            t39 = 1/rhoa**6.666666666666666d-1
            t40 = 6.582123138408225d-2*t38*t39
            t41 = t40+t25
            t42 = t41**5.0d-1
            t43 = t40+t25+6.0965d-1
            t44 = t43**5.0d-1
            t45 = t44+t42
            t46 = 1/t45
            t47 = 2.565564877060844d-1*t1*t3
            t48 = t47+t44
            t49 = 1/t48
            t50 = 1.0d+0-6.0965d-1*t46*t49
            t51 = log(t50)
            t52 = t40+t25+7.57211d-1
            t53 = t52**5.0d-1
            t54 = t53+t44
            t55 = 1/t54
            t56 = 1.475609999999999d-1*t49*t55+1.0d+0
            t57 = log(t56)
            t58 = t25+7.57211d-1
            t59 = t53+t42
            t60 = 1/t59
            t61 = t53+t47
            t62 = 1/t61
            t63 = t47+t42
            t64 = 1/t63
            t65 = t25+6.0965d-1
            t66 = t65**2.0d+0
            t67 = t65**3.5d+0
            t68 = (gammaaa*t15*t16*t24)**5.0d-1
            t69 = t58**5.0d-1
            t70 = 1.282782438530422d-1*t68-t69
            t71 = -2.4d+0*t67*t70-1.417963080724413d+0*t67+2.83637333333
     1         3333d-2*t66-9.086532d-1*t65**3.0d+0+4.7459599999999996d-2
     2         *t34*t65
            t72 = 1/t36**3.0d+0
            t73 = 2.4682961769030842d-2*(t1*t29*t3)**2.0d+0+2.8862604866
     1         934494d-1*t1*t29*t3+1.0d+0
            t74 = -8.888888888888888d-1*t71*t72*t73+7.57211d-1*(1.645530
     1         7846020562d-2*gammaaa*t15*t16*t24*t60*t64+t58*t60*t62)-2.
     2         0d+0*t57*t58+3.2910615692041123d-2*gammaaa*t15*t16*t24*t5
     3         1+5.273288888888887d-2*t34*t35*t37+4.727288888888889d-2*t
     4         27*t31-1.0d+0
            t75 = 1/t26**2
            t76 = 1/rhoa**3.6666666666666664d+0
            t77 = -4.38808209227215d-2*gammaaa*t16*t24*t76
            t78 = 1/rhoa**13
            t79 = 1/rhoa**1.1666666666666665d+1
            t80 = 1/rhoa**1.0333333333333333d+1
            t81 = 1/rhoa**9
            t82 = 1/rhoa**7.666666666666667d+0
            t83 = 1/rhoa**6.333333333333333d+0
            t84 = 1/rhoa**5
            t85 = 1/rhoa**2.3333333333333334d+0
            t86 = -3.970606525117923d-4*t82*t9-9.121763297794749d-1*t4*t
     1         85-9.371196275079824d-2*t13*t84+7.379767838723479d-3*t11*
     2         t83+2.1757466141021625d-5*t7*t81-1.6407054045998d-6*t5*t8
     3         0+6.026316036028103d-8*t19*t79-3.7791630611803767d-9*t17*
     4         t78+5.475448834737188d-1*gammaaa*t76
            t87 = 1/t23**2
            t88 = -1.6455307846020562d-2*gammaaa*t15*t16*t86*t87
            t89 = -3.5347308712216d-5*t82*t9-7.202205253416327d-4*t13*t8
     1         4+2.3159461868101344d-4*t11*t83+3.462141917580374d-6*t7*t
     2         81-2.2515574897849044d-7*t5*t80-7.018342379201d-4*gammaaa
     3         *t76
            t90 = 1.6455307846020562d-2*gammaaa*t15*t24*t89
            t91 = t90+t88+t77-4.38808209227215d-2*t38/rhoa**1.6666666666
     1         666669d+0
            t92 = 1/t32**2
            t93 = 5.634986987915197d-5*t11*t83*t92+6.934448603031025d-2*
     1         gammaaa*t15*t24*t89-6.934448603031025d-2*gammaaa*t15*t16*
     2         t86*t87-1.369767625290079d-2*gammaaa*t33*t76-1.8491862941
     3         416065d-1*gammaaa*t16*t24*t76
            t94 = 1/t44
            t95 = 5.0d-1*t91*t94
            t96 = -8.551882923536147d-2*t1*t22
            t97 = t96+t95
            t98 = 1/t48**2
            t99 = 1/t42
            t100 = 5.0d-1*t91*t99
            t101 = t95+t100
            t102 = 1/t45**2
            t103 = 6.0965d-1*t46*t97*t98+6.0965d-1*t101*t102*t49
            t104 = 1/t50
            t105 = t90+t88+t77
            t106 = 1/t53
            t107 = 5.0d-1*t106*t91
            t108 = t95+t107
            t109 = 1/t54**2
            t110 = -1.475609999999999d-1*t55*t97*t98-1.475609999999999d-
     1         1*t108*t109*t49
            t111 = 1/t56
            t112 = t96+t107
            t113 = 1/t61**2
            t114 = t107+t100
            t115 = 1/t59**2
            t116 = t96+t100
            t117 = 1/t63**2
            t118 = t65**2.5d+0
            t119 = 1/t69
            t120 = 1/t68
            t121 = gammaaa*t15*t24*t89-gammaaa*t15*t16*t86*t87-2.6666666
     1         666666666d+0*gammaaa*t16*t24*t76
            t122 = 6.41391219265211d-2*t120*t121-5.0d-1*t105*t119
            t123 = 4.7459599999999996d-2*t65*t93-8.400000000000001d+0*t1
     1         05*t118*t70-2.4d+0*t122*t67-2.7259596d+0*t105*t66+5.67274
     2         6666666666d-2*t105*t65+4.7459599999999996d-2*t105*t34-4.9
     3         628707825354457d+0*t105*t118
            t124 = 1/t30**2
            t125 = 1/t28**3
            t126 = -1.282782438530422d-1*t1*t125*t3*t91-8.55188292353614
     1         7d-2*t1*t22*t29
            t127 = -6.41391219265211d-2*t1*t125*t3*t91-4.275941461768073
     1         5d-2*t1*t22*t29
            t128 = -5.0d-1*t1*t125*t3*t91-3.333333333333333d-1*t1*t22*t2
     1         9
            t129 = -1.4431302433467247d-1*t1*t125*t3*t91+4.9365923538061
     1         685d-2*t1*t128*t29*t3-9.620868288978164d-2*t1*t22*t29
            t130 = t30*t91+t126*t26
            t131 = 1/t36**4.0d+0
            t132 = 5.273288888888887d-2*t35*t37*t93-4.727288888888889d-2
     1         *t31*t75*t91+7.57211d-1*(1.6455307846020562d-2*gammaaa*t1
     2         5*t24*t60*t64*t89-1.6455307846020562d-2*gammaaa*t15*t16*t
     3         60*t64*t86*t87-4.38808209227215d-2*gammaaa*t16*t24*t60*t6
     4         4*t76-1.6455307846020562d-2*gammaaa*t114*t115*t15*t16*t24
     5         *t64+t105*t60*t62-t114*t115*t58*t62-t112*t113*t58*t60-1.6
     6         455307846020562d-2*gammaaa*t116*t117*t15*t16*t24*t60)+3.2
     7         910615692041123d-2*gammaaa*t15*t24*t51*t89-3.291061569204
     8         1123d-2*gammaaa*t15*t16*t51*t86*t87-8.7761641845443d-2*ga
     9         mmaaa*t16*t24*t51*t76-8.888888888888888d-1*t123*t72*t73+2
     :         .6666666666666666d+0*t130*t131*t71*t73-8.888888888888888d
     ;         -1*t129*t71*t72-1.0546577777777776d-1*t130*t34*t35*t72-2.
     <         0d+0*t110*t111*t58-2.0d+0*t105*t57+5.273288888888887d-2*t
     =         127*t34*t37-4.727288888888889d-2*t124*t126*t27+3.29106156
     >         92041123d-2*gammaaa*t103*t104*t15*t16*t24
            t133 = 1/t4
            t134 = 6.15264526724925d-7*t6*t9-8.159049802883108d-6*t11*t8
     1         -2.2598685135105387d-8*t20*t7+1.4171861479426412d-9*t18*t
     2         5+3.514198603154934d-2*t14*t4+3.420661236673031d-1*t133*t
     3         22-2.0532933130264455d-1*t15+1.488977446919221d-4*t10*t13
     4         -2.767412939521305d-3*gammaaa*t12
            t135 = 8.443340586693391d-8*t6*t9-1.2983032190926402d-6*t11*
     1         t8+2.7008269700311227d-4*t14*t4+2.631878392200375d-4*t15+
     2         1.3255240767081d-5*t10*t13-8.684798200538004d-5*gammaaa*t
     3         12
            t136 = -1.6455307846020562d-2*gammaaa*t134*t15*t16*t87+1.645
     1         5307846020562d-2*t15*t16*t24+1.6455307846020562d-2*gammaa
     2         a*t135*t15*t24
            t137 = -4.727288888888889d-2*t136*t31*t75
            t138 = -2.113120120468199d-5*gammaaa*t12*t92-6.9344486030310
     1         25d-2*gammaaa*t134*t15*t16*t87+5.136628594837797d-3*t15*t
     2         33+6.934448603031025d-2*t15*t16*t24+6.934448603031025d-2*
     3         gammaaa*t135*t15*t24
            t139 = 5.273288888888887d-2*t138*t35*t37
            t140 = -3.2910615692041123d-2*gammaaa*t134*t15*t16*t51*t87
            t141 = 5.0d-1*t136*t99
            t142 = 5.0d-1*t136*t94
            t143 = t142+t141
            t144 = 3.04825d-1*t136*t46*t94*t98+6.0965d-1*t102*t143*t49
            t145 = 3.2910615692041123d-2*gammaaa*t104*t144*t15*t16*t24
            t146 = 3.2910615692041123d-2*t16*t51+3.2910615692041123d-2*g
     1         ammaaa*t135*t51
            t147 = -2.0d+0*t136*t57
            t148 = 5.0d-1*t106*t136
            t149 = t148+t142
            t150 = -7.378049999999994d-2*t136*t55*t94*t98-1.475609999999
     1         999d-1*t109*t149*t49
            t151 = -2.0d+0*t111*t150*t58
            t152 = t148+t141
            t153 = 7.57211d-1*(-8.227653923010281d-3*gammaaa*t117*t136*t
     1         15*t16*t24*t60*t99-1.6455307846020562d-2*gammaaa*t134*t15
     2         *t16*t60*t64*t87+1.6455307846020562d-2*t15*t16*t24*t60*t6
     3         4+1.6455307846020562d-2*gammaaa*t135*t15*t24*t60*t64-1.64
     4         55307846020562d-2*gammaaa*t115*t15*t152*t16*t24*t64+t136*
     5         t60*t62-t115*t152*t58*t62-5.0d-1*t106*t113*t136*t58*t60)
            t154 = 1/t28**5
            t155 = 6.064083168526658d-3*t1*t124*t136*t154*t3
            t156 = -3.3822411899821336d-3*t1*t125*t136*t3*t34*t37
            t157 = t136*t30-1.282782438530422d-1*t1*t136*t29*t3
            t158 = 2.6666666666666666d+0*t131*t157*t71*t73
            t159 = -2.4682961769030842d-2*t136*t38*t39*t75-1.44313024334
     1         67247d-1*t1*t125*t136*t3
            t160 = -gammaaa*t134*t15*t16*t87+t15*t16*t24+gammaaa*t135*t1
     1         5*t24
            t161 = 6.41391219265211d-2*t120*t160-5.0d-1*t119*t136
            t162 = -8.400000000000001d+0*t118*t136*t70-2.4d+0*t161*t67-2
     1         .7259596d+0*t136*t66+4.7459599999999996d-2*t138*t65+5.672
     2         746666666666d-2*t136*t65+4.7459599999999996d-2*t136*t34-4
     3         .9628707825354457d+0*t118*t136
            t163 = -8.888888888888888d-1*t162*t73-8.888888888888888d-1*t
     1         159*t71-1.0546577777777776d-1*t157*t34*t35
            t164 = 1/rhoa**4.666666666666667d+0
            t165 = 1.6089634338331216d-1*gammaaa*t16*t164*t24
            t166 = 8.7761641845443d-2*gammaaa*t16*t76*t86*t87
            t167 = -8.7761641845443d-2*gammaaa*t24*t76*t89
            t168 = t86**2
            t169 = 1/t23**3
            t170 = 3.2910615692041123d-2*gammaaa*t15*t16*t168*t169
            t171 = 1/rhoa**1.1333333333333334d+1
            t172 = 1/rhoa**10
            t173 = 1/rhoa**8.666666666666666d+0
            t174 = 1/rhoa**7.333333333333333d+0
            t175 = 1/rhoa**6
            t176 = 3.0441316692570747d-3*t173*t9-1.9581719526919464d-4*t
     1         172*t7+1.695395584753127d-5*t171*t5+2.1284114361521084d+0
     2         *t4/rhoa**3.3333333333333337d+0-7.030702042032786d-7*t19/
     3         rhoa**1.2666666666666665d+1+4.685598137539912d-1*t13*t175
     4         -4.6738529645248705d-2*t11*t174+4.9129119795344894d-8*t17
     5         /rhoa**14-2.0076645727369685d+0*gammaaa*t164
            t177 = -1.6455307846020562d-2*gammaaa*t15*t16*t176*t87
            t178 = -3.2910615692041123d-2*gammaaa*t15*t86*t87*t89
            t179 = 2.709960334603227d-4*t173*t9-3.115927725822337d-5*t17
     1         2*t7+2.326609406111068d-6*t171*t5+3.6011026267081636d-3*t
     2         13*t175-1.466765918313085d-3*t11*t174+2.5733922057070335d
     3         -3*gammaaa*t164
            t180 = 1.6455307846020562d-2*gammaaa*t15*t179*t24
            t181 = 7.313470153786916d-2*t15*t38+t180+t178+t177+t170+t167
     1         +t166+t165
            t182 = 1/t26**3
            t183 = t91**2
            t184 = 1/t32**3
            t185 = -5.071488289123677d-4*t11*t174*t92-1.386889720606205d
     1         -1*gammaaa*t15*t86*t87*t89-3.698372588283213d-1*gammaaa*t
     2         24*t76*t89+3.698372588283213d-1*gammaaa*t16*t76*t86*t87-6
     3         .934448603031025d-2*gammaaa*t15*t16*t176*t87+1.2363392745
     4         928628d-6*t172*t184*t7+5.02248129273029d-2*gammaaa*t164*t
     5         33+6.934448603031025d-2*gammaaa*t15*t179*t24+6.7803497451
     6         85891d-1*gammaaa*t16*t164*t24+1.386889720606205d-1*gammaa
     7         a*t15*t16*t168*t169
            t186 = 1/t30**3
            t187 = t130**2
            t188 = 1/t36**5.0d+0
            t189 = 1/t50**2
            t190 = t97**2
            t191 = 1/t48**3
            t192 = 1/t44**3
            t193 = -2.5d-1*t183*t192
            t194 = 5.0d-1*t181*t94
            t195 = 1.1402510564714863d-1*t1*t85
            t196 = t195+t194+t193
            t197 = 1/t45**3
            t198 = 1/t42**3
            t199 = -2.5d-1*t183*t198
            t200 = 5.0d-1*t181*t99
            t201 = t180+t178+t177+t170+t167+t166+t165
            t202 = 1/t56**2
            t203 = 1/t54**3
            t204 = 1/t53**3
            t205 = -2.5d-1*t183*t204
            t206 = 5.0d-1*t106*t181
            t207 = 1/t61**3
            t208 = t114**2
            t209 = 1/t59**3
            t210 = t206+t205+t200+t199
            t211 = 1/t63**3
            t212 = t105**2
            t213 = t65**1.5d+0
            t214 = 1/t68**3
            t215 = 1/t69**3
            t216 = 8.551882923536147d-2*t1*t125*t22*t91+1.14025105647148
     1         63d-1*t1*t29*t85+1.924173657795633d-1*t1*t154*t183*t3-1.2
     2         82782438530422d-1*t1*t125*t181*t3
            t217 = 2*t126*t91+t181*t30+t216*t26
            t218 = -5.742468916099301d-6*t80*t9-4.5608816488973747d-1*t1
     1         33*t85-1.4056794412619736d-1*t4*t84+1.4759535677446958d-2
     2         *gammaaa*t83-9.926516312794808d-4*t13*t82+6.5272398423064
     3         87d-5*t11*t81+2.4105264144112412d-7*t7*t79-1.700623377531
     4         1694d-8*t5*t78+5.475448834737188d-1*t76
            t219 = -7.880451214247165d-7*t80*t9-1.0803307880124491d-3*t4
     1         *t84+4.631892373620269d-4*gammaaa*t83-8.836827178054d-5*t
     2         13*t82+1.0386425752741123d-5*t11*t81-7.018342379201d-4*t7
     3         6
            t220 = -1.6455307846020562d-2*gammaaa*t134*t15*t87*t89+1.645
     1         5307846020562d-2*t15*t24*t89-1.6455307846020562d-2*t15*t1
     2         6*t86*t87-1.6455307846020562d-2*gammaaa*t135*t15*t86*t87+
     3         4.38808209227215d-2*gammaaa*t134*t16*t76*t87-1.6455307846
     4         020562d-2*gammaaa*t15*t16*t218*t87+3.2910615692041123d-2*
     5         gammaaa*t134*t15*t16*t169*t86-4.38808209227215d-2*t16*t24
     6         *t76-4.38808209227215d-2*gammaaa*t135*t24*t76+1.645530784
     7         6020562d-2*gammaaa*t15*t219*t24
            t221 = 1.690496096374559d-4*gammaaa*t83*t92-6.93444860303102
     1         5d-2*gammaaa*t134*t15*t87*t89+6.934448603031025d-2*t15*t2
     2         4*t89-6.934448603031025d-2*t15*t16*t86*t87-6.934448603031
     3         025d-2*gammaaa*t135*t15*t86*t87+1.8491862941416065d-1*gam
     4         maaa*t134*t16*t76*t87-6.934448603031025d-2*gammaaa*t15*t1
     5         6*t218*t87+1.386889720606205d-1*gammaaa*t134*t15*t16*t169
     6         *t86-4.6362722797232353d-7*t11*t184*t81-1.369767625290079
     7         d-2*t33*t76-1.8491862941416065d-1*t16*t24*t76-1.849186294
     8         1416065d-1*gammaaa*t135*t24*t76+6.934448603031025d-2*gamm
     9         aaa*t15*t219*t24
            t222 = -2.5d-1*t136*t192*t91
            t223 = 5.0d-1*t220*t94
            t224 = t223+t222
            t225 = -2.5d-1*t136*t198*t91
            t226 = 5.0d-1*t220*t99
            t227 = -2.5d-1*t136*t204*t91
            t228 = 5.0d-1*t106*t220
            t229 = t228+t227+t226+t225
            t230 = 1/t28**7
            t231 = 1.924173657795633d-1*t1*t136*t154*t3*t91-1.2827824385
     1         30422d-1*t1*t125*t220*t3+4.2759414617680735d-2*t1*t125*t1
     2         36*t22
            t232 = -1.282782438530422d-1*t1*t125*t136*t3*t91+t220*t30+t2
     1         31*t26+t126*t136
            t233 = t136**2
            t234 = t134**2
            t235 = 4.960151517799245d-9*t18*t9-1.6318099605766218d-5*gam
     1         maaa*t8+1.5381613168123123d-6*t13*t6+2.2334661703788317d-
     2         4*t10*t4-1.7103306183365155d-1*t22/t13-6.779605540531617d
     3         -8*t11*t20+1.757099301577467d-2*t133*t14-2.76741293952130
     4         5d-3*t12
            t236 = -2.5966064381852805d-6*gammaaa*t8+2.1108351466733477d
     1         -7*t13*t6+1.9882861150621498d-5*t10*t4+1.3504134850155614
     2         d-4*t133*t14-8.684798200538004d-5*t12
            t237 = -1.6455307846020562d-2*gammaaa*t15*t16*t235*t87-3.291
     1         0615692041123d-2*t134*t15*t16*t87-3.2910615692041123d-2*g
     2         ammaaa*t134*t135*t15*t87+1.6455307846020562d-2*gammaaa*t1
     3         5*t236*t24+3.2910615692041123d-2*t135*t15*t24+3.291061569
     4         2041123d-2*gammaaa*t15*t16*t169*t234
            t238 = -4.226240240936398d-5*t12*t92-6.934448603031025d-2*ga
     1         mmaaa*t15*t16*t235*t87-1.386889720606205d-1*t134*t15*t16*
     2         t87-1.386889720606205d-1*gammaaa*t134*t135*t15*t87+1.7386
     3         021048962136d-7*gammaaa*t184*t8+6.934448603031025d-2*gamm
     4         aaa*t15*t236*t24+1.386889720606205d-1*t135*t15*t24+1.3868
     5         89720606205d-1*gammaaa*t15*t16*t169*t234
            t239 = 1/t43
            t240 = -2.5d-1*t198*t233
            t241 = 5.0d-1*t237*t99
            t242 = -2.5d-1*t192*t233
            t243 = 5.0d-1*t237*t94
            t244 = t152**2
            t245 = -2.5d-1*t204*t233
            t246 = 5.0d-1*t106*t237
            t247 = t246+t245+t241+t240
            t248 = t237*t30-1.282782438530422d-1*t1*t237*t29*t3-6.413912
     1         19265211d-2*t1*t125*t233*t3
            fnc(iq) = fnc(iq)-1.8610514726982d+0*t21*t74*wght
            Amat(iq,D1_RA) = (-1.2407009817987999d+0*t2*t74-9.3052573634
     1         91d-1*t132*t21)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-9.305257363491d-1*t21*(t16
     1         3*t72+t146*t15*t24+t158+t156+t155+t153+t151+t147+t145+t14
     2         0+t139+t137)*wght
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Amat2(iq,D2_RA_RA) = (-9.305257363491d-1*t21*(-2.0d+0*t111*t
     1         58*(2.951219999999998d-1*t108*t109*t97*t98-1.475609999999
     2         999d-1*t196*t55*t98+2.951219999999998d-1*t190*t191*t55-1.
     3         475609999999999d-1*t109*(t206+t205+t194+t193)*t49+2.95121
     4         9999999998d-1*t108**2*t203*t49)+3.2910615692041123d-2*gam
     5         maaa*t104*t15*t16*t24*(-1.2193000000000001d+0*t101*t102*t
     6         97*t98+6.0965d-1*t196*t46*t98+6.0965d-1*t102*(t200+t199+t
     7         194+t193)*t49-1.2193000000000001d+0*t101**2*t197*t49-1.21
     8         93000000000001d+0*t190*t191*t46)-8.888888888888888d-1*t72
     9         *t73*(9.491919999999999d-2*t105*t93-2.4d+0*t67*(6.4139121
     :         9265211d-2*t120*(-2*gammaaa*t15*t86*t87*t89-5.33333333333
     ;         3333d+0*gammaaa*t24*t76*t89+5.333333333333333d+0*gammaaa*
     <         t16*t76*t86*t87-gammaaa*t15*t16*t176*t87+gammaaa*t15*t179
     =         *t24+9.777777777777779d+0*gammaaa*t16*t164*t24+2*gammaaa*
     >         t15*t16*t168*t169)+2.5d-1*t212*t215-3.206956096326055d-2*
     ?         t121**2*t214-5.0d-1*t119*t201)-2.1d+1*t212*t213*t70-8.400
     @         000000000001d+0*t118*t201*t70-2.7259596d+0*t201*t66-5.451
     1         9192d+0*t212*t65+5.672746666666666d-2*t201*t65+4.74595999
     2         99999996d-2*t185*t65+4.7459599999999996d-2*t201*t34-1.240
     3         7176956338616d+1*t212*t213+5.672746666666666d-2*t212-4.96
     4         28707825354457d+0*t118*t201-1.68d+1*t105*t118*t122)-2.109
     5         315555555555d-1*t130*t35*t72*t93+1.0546577777777776d-1*t1
     6         27*t37*t93-8.888888888888888d-1*t71*t72*(4.93659235380616
     7         85d-2*t1*t29*t3*(3.333333333333333d-1*t1*t125*t22*t91+4.4
     8         44444444444444d-1*t1*t29*t85+7.5d-1*t1*t154*t183*t3-5.0d-
     9         1*t1*t125*t181*t3)+9.620868288978164d-2*t1*t125*t22*t91+1
     :         .2827824385304218d-1*t1*t29*t85+2.164695365020087d-1*t1*t
     ;         154*t183*t3-1.4431302433467247d-1*t1*t125*t181*t3+4.93659
     <         23538061685d-2*t128**2)+5.273288888888887d-2*t34*t37*(4.2
     =         759414617680735d-2*t1*t125*t22*t91+5.701255282357431d-2*t
     >         1*t29*t85+9.620868288978166d-2*t1*t154*t183*t3-6.41391219
     ?         265211d-2*t1*t125*t181*t3)+9.454577777777778d-2*t124*t126
     @         *t75*t91+7.57211d-1*(-3.2910615692041123d-2*gammaaa*t15*t
     1         60*t64*t86*t87*t89-8.7761641845443d-2*gammaaa*t24*t60*t64
     2         *t76*t89-3.2910615692041123d-2*gammaaa*t114*t115*t15*t24*
     3         t64*t89-3.2910615692041123d-2*gammaaa*t116*t117*t15*t24*t
     4         60*t89+8.7761641845443d-2*gammaaa*t16*t60*t64*t76*t86*t87
     5         +3.2910615692041123d-2*gammaaa*t114*t115*t15*t16*t64*t86*
     6         t87+3.2910615692041123d-2*gammaaa*t116*t117*t15*t16*t60*t
     7         86*t87-1.6455307846020562d-2*gammaaa*t15*t16*t176*t60*t64
     8         *t87+8.7761641845443d-2*gammaaa*t114*t115*t16*t24*t64*t76
     9         +8.7761641845443d-2*gammaaa*t116*t117*t16*t24*t60*t76+1.6
     :         455307846020562d-2*gammaaa*t15*t179*t24*t60*t64+1.6089634
     ;         338331216d-1*gammaaa*t16*t164*t24*t60*t64+3.2910615692041
     <         123d-2*gammaaa*t15*t16*t168*t169*t60*t64-1.64553078460205
     =         62d-2*gammaaa*t115*t15*t16*t210*t24*t64+3.291061569204112
     >         3d-2*gammaaa*t15*t16*t208*t209*t24*t64+t201*t60*t62-t115*
     ?         t210*t58*t62+2*t208*t209*t58*t62-2*t105*t114*t115*t62+2*t
     @         112**2*t207*t58*t60-t113*(t206+t205+t195)*t58*t60+3.29106
     1         15692041123d-2*gammaaa*t116**2*t15*t16*t211*t24*t60-1.645
     2         5307846020562d-2*gammaaa*t117*t15*t16*(t200+t199+t195)*t2
     3         4*t60-2*t105*t112*t113*t60+2*t112*t113*t114*t115*t58+3.29
     4         10615692041123d-2*gammaaa*t114*t115*t116*t117*t15*t16*t24
     5         )-6.582123138408225d-2*gammaaa*t15*t51*t86*t87*t89-1.7552
     6         3283690886d-1*gammaaa*t24*t51*t76*t89+6.582123138408225d-
     7         2*gammaaa*t103*t104*t15*t24*t89+1.75523283690886d-1*gamma
     8         aa*t16*t51*t76*t86*t87-6.582123138408225d-2*gammaaa*t103*
     9         t104*t15*t16*t86*t87-3.2910615692041123d-2*gammaaa*t15*t1
     :         6*t176*t51*t87-1.75523283690886d-1*gammaaa*t103*t104*t16*
     ;         t24*t76-4.727288888888889d-2*t181*t31*t75+2.6666666666666
     <         666d+0*t131*t217*t71*t73-1.0666666666666666d+1*t187*t188*
     =         t71*t73+5.333333333333333d+0*t123*t130*t131*t73-1.0546577
     >         777777776d-1*t217*t34*t35*t72-2.109315555555555d-1*t127*t
     ?         130*t34*t72-1.7777777777777776d+0*t123*t129*t72+5.3333333
     @         33333333d+0*t129*t130*t131*t71+2.0d+0*t110**2*t202*t58-2.
     1         0d+0*t201*t57+3.2910615692041123d-2*gammaaa*t15*t179*t24*
     2         t51+3.217926867666243d-1*gammaaa*t16*t164*t24*t51+6.58212
     3         3138408225d-2*gammaaa*t15*t16*t168*t169*t51+5.27328888888
     4         8887d-2*t185*t35*t37+3.1639733333333325d-1*t131*t187*t34*
     5         t35+9.454577777777778d-2*t182*t183*t31-4.727288888888889d
     6         -2*t124*t216*t27+9.454577777777778d-2*t126**2*t186*t27-3.
     7         2910615692041123d-2*gammaaa*t103**2*t15*t16*t189*t24-4.0d
     8         +0*t105*t110*t111)-4.135669939329333d-1*t39*t74-2.4814019
     9         635975998d+0*t132*t2)*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = (-9.305257363491d-1*t21*(7.57211d-1*(-
     1         8.227653923010281d-3*gammaaa*t117*t136*t15*t24*t60*t89*t9
     2         9+8.227653923010281d-3*gammaaa*t117*t136*t15*t16*t60*t86*
     3         t87*t99+2.194041046136075d-2*gammaaa*t117*t136*t16*t24*t6
     4         0*t76*t99+1.6455307846020562d-2*gammaaa*t116*t136*t15*t16
     5         *t211*t24*t60*t99+8.227653923010281d-3*gammaaa*t114*t115*
     6         t117*t136*t15*t16*t24*t99-1.6455307846020562d-2*gammaaa*t
     7         134*t15*t60*t64*t87*t89+1.6455307846020562d-2*t15*t24*t60
     8         *t64*t89-1.6455307846020562d-2*gammaaa*t115*t15*t152*t24*
     9         t64*t89-1.6455307846020562d-2*t15*t16*t60*t64*t86*t87-1.6
     :         455307846020562d-2*gammaaa*t135*t15*t60*t64*t86*t87+1.645
     ;         5307846020562d-2*gammaaa*t115*t15*t152*t16*t64*t86*t87+4.
     <         38808209227215d-2*gammaaa*t134*t16*t60*t64*t76*t87-1.6455
     =         307846020562d-2*gammaaa*t15*t16*t218*t60*t64*t87+1.645530
     >         7846020562d-2*gammaaa*t114*t115*t134*t15*t16*t64*t87+1.64
     ?         55307846020562d-2*gammaaa*t116*t117*t134*t15*t16*t60*t87+
     @         3.2910615692041123d-2*gammaaa*t134*t15*t16*t169*t60*t64*t
     1         86-4.38808209227215d-2*t16*t24*t60*t64*t76-4.388082092272
     2         15d-2*gammaaa*t135*t24*t60*t64*t76+4.38808209227215d-2*ga
     3         mmaaa*t115*t152*t16*t24*t64*t76+1.6455307846020562d-2*gam
     4         maaa*t15*t219*t24*t60*t64-1.6455307846020562d-2*gammaaa*t
     5         115*t15*t16*t229*t24*t64+3.2910615692041123d-2*gammaaa*t1
     6         14*t15*t152*t16*t209*t24*t64-1.6455307846020562d-2*t114*t
     7         115*t15*t16*t24*t64-1.6455307846020562d-2*gammaaa*t114*t1
     8         15*t135*t15*t24*t64+t220*t60*t62-t115*t229*t58*t62+2*t114
     9         *t152*t209*t58*t62-t105*t115*t152*t62-t114*t115*t136*t62-
     :         t113*(t228+t227)*t58*t60+t106*t112*t136*t207*t58*t60-1.64
     ;         55307846020562d-2*gammaaa*t117*t15*t16*(t226+t225)*t24*t6
     <         0-1.6455307846020562d-2*t116*t117*t15*t16*t24*t60-1.64553
     =         07846020562d-2*gammaaa*t116*t117*t135*t15*t24*t60-t112*t1
     >         13*t136*t60-5.0d-1*t105*t106*t113*t136*t60+t112*t113*t115
     ?         *t152*t58+5.0d-1*t106*t113*t114*t115*t136*t58+1.645530784
     @         6020562d-2*gammaaa*t115*t116*t117*t15*t152*t16*t24)-2.0d+
     1         0*t111*t58*(1.475609999999999d-1*t109*t149*t97*t98+7.3780
     2         49999999994d-2*t108*t109*t136*t94*t98-1.475609999999999d-
     3         1*t224*t55*t98+1.475609999999999d-1*t136*t191*t55*t94*t97
     4         -1.475609999999999d-1*t109*(t228+t227+t223+t222)*t49+2.95
     5         1219999999998d-1*t108*t149*t203*t49)+3.2910615692041123d-
     6         2*gammaaa*t104*t15*t16*t24*(-6.0965d-1*t102*t143*t97*t98-
     7         3.04825d-1*t101*t102*t136*t94*t98+6.0965d-1*t224*t46*t98-
     8         6.0965d-1*t136*t191*t46*t94*t97+6.0965d-1*t102*(t226+t225
     9         +t223+t222)*t49-1.2193000000000001d+0*t101*t143*t197*t49)
     :         -8.888888888888888d-1*t72*t73*(4.7459599999999996d-2*t136
     ;         *t93-2.4d+0*t67*(6.41391219265211d-2*t120*(-gammaaa*t134*
     <         t15*t87*t89+t15*t24*t89-t15*t16*t86*t87-gammaaa*t135*t15*
     =         t86*t87+2.6666666666666666d+0*gammaaa*t134*t16*t76*t87-ga
     >         mmaaa*t15*t16*t218*t87+2*gammaaa*t134*t15*t16*t169*t86-2.
     ?         6666666666666666d+0*t16*t24*t76-2.6666666666666666d+0*gam
     @         maaa*t135*t24*t76+gammaaa*t15*t219*t24)-5.0d-1*t119*t220+
     1         2.5d-1*t105*t136*t215-3.206956096326055d-2*t121*t160*t214
     2         )-8.400000000000001d+0*t118*t220*t70-2.1d+1*t105*t136*t21
     3         3*t70-2.7259596d+0*t220*t66+4.7459599999999996d-2*t221*t6
     4         5+5.672746666666666d-2*t220*t65-5.4519192d+0*t105*t136*t6
     5         5+4.7459599999999996d-2*t220*t34-4.9628707825354457d+0*t1
     6         18*t220-1.2407176956338616d+1*t105*t136*t213-8.4000000000
     7         00001d+0*t105*t118*t161+4.7459599999999996d-2*t105*t138-8
     8         .400000000000001d+0*t118*t122*t136+5.672746666666666d-2*t
     9         105*t136)-1.0546577777777776d-1*t157*t35*t72*t93-3.382241
     :         1899821336d-3*t1*t125*t136*t3*t37*t93-8.888888888888888d-
     ;         1*t71*t72*(4.9365923538061685d-2*t1*t29*t3*(7.5d-1*t1*t13
     <         6*t154*t3*t91-5.0d-1*t1*t125*t220*t3+1.6666666666666666d-
     =         1*t1*t125*t136*t22)+2.164695365020087d-1*t1*t136*t154*t3*
     >         t91-1.4431302433467247d-1*t1*t125*t220*t3-2.4682961769030
     ?         842d-2*t1*t125*t128*t136*t3+4.810434144489082d-2*t1*t125*
     @         t136*t22)+5.273288888888887d-2*t34*t37*(9.620868288978166
     1         d-2*t1*t136*t154*t3*t91-6.41391219265211d-2*t1*t125*t220*
     2         t3+2.1379707308840368d-2*t1*t125*t136*t22)+9.454577777777
     3         778d-2*t136*t182*t31*t91-6.064083168526658d-3*t1*t124*t13
     4         6*t230*t3*t91-3.2910615692041123d-2*gammaaa*t134*t15*t51*
     5         t87*t89+3.2910615692041123d-2*t15*t24*t51*t89+3.291061569
     6         2041123d-2*gammaaa*t104*t144*t15*t24*t89-3.29106156920411
     7         23d-2*t15*t16*t51*t86*t87-3.2910615692041123d-2*gammaaa*t
     8         135*t15*t51*t86*t87-3.2910615692041123d-2*gammaaa*t104*t1
     9         44*t15*t16*t86*t87+8.7761641845443d-2*gammaaa*t134*t16*t5
     :         1*t76*t87-3.2910615692041123d-2*gammaaa*t15*t16*t218*t51*
     ;         t87-3.2910615692041123d-2*gammaaa*t103*t104*t134*t15*t16*
     <         t87+6.582123138408225d-2*gammaaa*t134*t15*t16*t169*t51*t8
     =         6-8.7761641845443d-2*t16*t24*t51*t76-8.7761641845443d-2*g
     >         ammaaa*t135*t24*t51*t76-8.7761641845443d-2*gammaaa*t104*t
     ?         144*t16*t24*t76-4.727288888888889d-2*t220*t31*t75+4.72728
     @         8888888889d-2*t124*t126*t136*t75+2.6666666666666666d+0*t1
     1         31*t232*t71*t73-1.0666666666666666d+1*t130*t157*t188*t71*
     2         t73+2.6666666666666666d+0*t130*t131*t162*t73+2.6666666666
     3         666666d+0*t123*t131*t157*t73-1.0546577777777776d-1*t232*t
     4         34*t35*t72-1.0546577777777776d-1*t130*t138*t35*t72+6.7644
     5         82379964267d-3*t1*t125*t130*t136*t3*t34*t72-1.05465777777
     6         77776d-1*t127*t157*t34*t72-8.888888888888888d-1*t129*t162
     7         *t72-8.888888888888888d-1*t123*t159*t72+2.666666666666666
     8         6d+0*t130*t131*t159*t71+2.6666666666666666d+0*t129*t131*t
     9         157*t71+2.0d+0*t110*t150*t202*t58-2.0d+0*t220*t57+3.29106
     :         15692041123d-2*gammaaa*t15*t219*t24*t51+5.273288888888887
     ;         d-2*t221*t35*t37+5.273288888888887d-2*t127*t138*t37+3.163
     <         9733333333325d-1*t130*t131*t157*t34*t35-1.212816633705331
     =         7d-2*t1*t126*t136*t154*t186*t3-4.727288888888889d-2*t124*
     >         t231*t27-3.2910615692041123d-2*gammaaa*t103*t144*t15*t16*
     ?         t189*t24+3.2910615692041123d-2*t103*t104*t15*t16*t24+3.29
     @         10615692041123d-2*gammaaa*t103*t104*t135*t15*t24-2.0d+0*t
     1         105*t111*t150-2.0d+0*t110*t111*t136)-1.2407009817987999d+
     2         0*t2*(-8.888888888888888d-1*t162*t72*t73-8.88888888888888
     3         8d-1*t159*t71*t72-1.0546577777777776d-1*t157*t34*t35*t72+
     4         3.2910615692041123d-2*t15*t16*t24*t51+3.2910615692041123d
     5         -2*gammaaa*t135*t15*t24*t51+t158+t156+t155+t153+t151+t147
     6         +t145+t140+t139+t137))*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)-9.305257363491d-
     1         1*t21*(7.57211d-1*(1.6455307846020562d-2*gammaaa*t117*t13
     2         4*t136*t15*t16*t60*t87*t99-8.227653923010281d-3*gammaaa*t
     3         117*t15*t16*t237*t24*t60*t99-1.6455307846020562d-2*t117*t
     4         136*t15*t16*t24*t60*t99-1.6455307846020562d-2*gammaaa*t11
     5         7*t135*t136*t15*t24*t60*t99+1.6455307846020562d-2*gammaaa
     6         *t115*t117*t136*t15*t152*t16*t24*t99-1.6455307846020562d-
     7         2*gammaaa*t15*t16*t235*t60*t64*t87-3.2910615692041123d-2*
     8         t134*t15*t16*t60*t64*t87-3.2910615692041123d-2*gammaaa*t1
     9         34*t135*t15*t60*t64*t87+3.2910615692041123d-2*gammaaa*t11
     :         5*t134*t15*t152*t16*t64*t87+1.6455307846020562d-2*gammaaa
     ;         *t15*t236*t24*t60*t64+3.2910615692041123d-2*t135*t15*t24*
     <         t60*t64+3.2910615692041123d-2*gammaaa*t15*t16*t169*t234*t
     =         60*t64-1.6455307846020562d-2*gammaaa*t115*t15*t16*t24*t24
     >         7*t64+3.2910615692041123d-2*gammaaa*t15*t16*t209*t24*t244
     ?         *t64-3.2910615692041123d-2*t115*t15*t152*t16*t24*t64-3.29
     @         10615692041123d-2*gammaaa*t115*t135*t15*t152*t24*t64+t237
     1         *t60*t62-t115*t247*t58*t62+2*t209*t244*t58*t62-2*t115*t13
     2         6*t152*t62+5.0d-1*t207*t233*t58*t60/t52-5.0d-1*t106*t113*
     3         t237*t58*t60+2.5d-1*t113*t204*t233*t58*t60+8.227653923010
     4         281d-3*gammaaa*t15*t16*t211*t233*t24*t60/t41+4.1138269615
     5         051404d-3*gammaaa*t117*t15*t16*t198*t233*t24*t60-t106*t11
     6         3*t233*t60+t106*t113*t115*t136*t152*t58)+t111*(-2.0d+0*t5
     7         8*(-7.378049999999994d-2*t237*t55*t94*t98+1.4756099999999
     8         99d-1*t109*t136*t149*t94*t98+3.689024999999997d-2*t192*t2
     9         33*t55*t98+7.378049999999994d-2*t191*t233*t239*t55-1.4756
     :         09999999999d-1*t109*(t246+t245+t243+t242)*t49+2.951219999
     ;         999998d-1*t149**2*t203*t49)-4.0d+0*t136*t150)+t104*t15*t2
     <         4*(3.2910615692041123d-2*gammaaa*t16*(3.04825d-1*t237*t46
     =         *t94*t98-6.0965d-1*t102*t136*t143*t94*t98-1.524125d-1*t19
     >         2*t233*t46*t98+6.0965d-1*t102*(t243+t242+t241+t240)*t49-1
     ?         .2193000000000001d+0*t143**2*t197*t49-3.04825d-1*t191*t23
     @         3*t239*t46)+3.2910615692041123d-2*t144*t16+3.291061569204
     1         1123d-2*gammaaa*t135*t144)+t72*(-8.888888888888888d-1*t73
     2         *(-2.4d+0*t67*(6.41391219265211d-2*t120*(-gammaaa*t15*t16
     3         *t235*t87-2*t134*t15*t16*t87-2*gammaaa*t134*t135*t15*t87+
     4         gammaaa*t15*t236*t24+2*t135*t15*t24+2*gammaaa*t15*t16*t16
     5         9*t234)-5.0d-1*t119*t237+2.5d-1*t215*t233-3.2069560963260
     6         55d-2*t160**2*t214)-8.400000000000001d+0*t118*t237*t70-2.
     7         1d+1*t213*t233*t70-2.7259596d+0*t237*t66+4.74595999999999
     8         96d-2*t238*t65+5.672746666666666d-2*t237*t65-5.4519192d+0
     9         *t233*t65+4.7459599999999996d-2*t237*t34-4.96287078253544
     :         57d+0*t118*t237-1.2407176956338616d+1*t213*t233+5.6727466
     ;         66666666d-2*t233-1.68d+1*t118*t136*t161+9.491919999999999
     <         d-2*t136*t138)-8.888888888888888d-1*t71*(-2.4682961769030
     =         842d-2*t237*t38*t39*t75+4.9365923538061685d-2*t182*t233*t
     >         38*t39-1.4431302433467247d-1*t1*t125*t237*t3+2.1646953650
     ?         20087d-1*t1*t154*t233*t3)-1.0546577777777776d-1*t248*t34*
     @         t35-2.109315555555555d-1*t138*t157*t35+6.764482379964267d
     1         -3*t1*t125*t136*t157*t3*t34-1.7777777777777776d+0*t159*t1
     2         62)+t15*(-3.2910615692041123d-2*gammaaa*t16*t235*t51-3.29
     3         10615692041123d-2*t134*t16*t51-3.2910615692041123d-2*gamm
     4         aaa*t134*t135*t51-t134*t146)*t87-6.582123138408225d-2*gam
     5         maaa*t104*t134*t144*t15*t16*t87-4.727288888888889d-2*t237
     6         *t31*t75+t131*(2.6666666666666666d+0*t248*t71*t73+2.66666
     7         66666666666d+0*t157*t162*t73+2.6666666666666666d+0*t157*t
     8         159*t71-3.0d+0*t157*t163)-1.0666666666666666d+1*t157**2*t
     9         188*t71*t73+6.764482379964267d-3*t1*t125*t136*t157*t3*t34
     :         *t72+2.0d+0*t150**2*t202*t58-2.0d+0*t237*t57+t15*t24*(3.2
     ;         910615692041123d-2*gammaaa*t236*t51+6.582123138408225d-2*
     <         t135*t51+3.2910615692041123d-2*t104*t144*t16+3.2910615692
     =         041123d-2*gammaaa*t104*t135*t144)+6.582123138408225d-2*ga
     >         mmaaa*t15*t16*t169*t234*t51+1.5557798788747831d-3*t186*t2
     ?         33*t38*t39/t26**4+5.273288888888887d-2*t238*t35*t37+t125*
     @         t3*(-3.3822411899821336d-3*t1*t237*t34-6.764482379964267d
     1         -3*t1*t136*t138)*t37+5.0733617849732d-3*t1*t154*t233*t3*t
     2         34*t37+9.454577777777778d-2*t182*t233*t31+6.0640831685266
     3         58d-3*t1*t124*t154*t237*t3-2.1224291089843306d-2*t1*t124*
     4         t230*t233*t3-3.2910615692041123d-2*gammaaa*t144**2*t15*t1
     5         6*t189*t24)*wght
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = param(1)
            t2 = rhoa**3.333333333333333d-1
            t3 = 1/t2
            t4 = t1*t3
            t5 = gammaaa**5.0d-1
            t6 = t5**7
            t7 = 1/rhoa**9.333333333333333d+0
            t8 = gammaaa**3
            t9 = 1/rhoa**8
            t10 = t5**5
            t11 = 1/rhoa**6.666666666666667d+0
            t12 = gammaaa**2
            t13 = 1/rhoa**5.333333333333333d+0
            t14 = t5**3
            t15 = 1/rhoa**4
            t16 = 1/rhoa**2.6666666666666666d+0
            t17 = -4.327677396975467d-7*t8*t9+2.4123830247695402d-8*t6*t
     1         7+2.631878392200375d-4*gammaaa*t16+1.8005513133540818d-4*
     2         t14*t15-4.342399100269002d-5*t12*t13+5.3020963068324d-6*t
     3         10*t11
            t18 = t5**9
            t19 = 1/rhoa**12
            t20 = gammaaa**4
            t21 = 1/rhoa**1.0666666666666666d+1
            t22 = rhoa**1.3333333333333333d+0
            t23 = 1/t22
            t24 = -2.7196832676277033d-6*t8*t9+1.7578986477855002d-7*t6*
     1         t7+6.841322473346062d-1*t23*t5-5.649671283776346d-9*t20*t
     2         21+3.149302550983647d-10*t18*t19-2.0532933130264455d-1*ga
     3         mmaaa*t16+2.342799068769956d-2*t14*t15-1.3837064697606524
     4         d-3*t12*t13+5.955909787676884d-5*t10*t11+1.0d+0
            t25 = 1/t24
            t26 = 1.6455307846020562d-2*gammaaa*t16*t17*t25
            t27 = 6.582123138408225d-2*t4**2.0d+0+t26+6.0965d-1
            t28 = 1/t27
            t29 = t27**5.0d-1
            t30 = 1/t29
            t31 = 2.565564877060844d-1*t1*t3*t30+1.0d+0
            t32 = 1/t31
            t33 = 4.1138269615051404d-3*gammaaa*t16+1.0d+0
            t34 = 1/t33
            t35 = 5.136628594837797d-3*gammaaa*t16*t34+6.934448603031025
     1         d-2*gammaaa*t16*t17*t25+1.0d+0
            t36 = 1.282782438530422d-1*t1*t3*t30+1.0d+0
            t37 = t27*t31
            t38 = 1/t37**2.0d+0
            t39 = t1**2
            t40 = 1/rhoa**6.666666666666666d-1
            t41 = 6.582123138408225d-2*t39*t40
            t42 = t41+t26
            t43 = t42**5.0d-1
            t44 = t41+t26+6.0965d-1
            t45 = t44**5.0d-1
            t46 = t45+t43
            t47 = 1/t46
            t48 = 2.565564877060844d-1*t1*t3
            t49 = t48+t45
            t50 = 1/t49
            t51 = 1.0d+0-6.0965d-1*t47*t50
            t52 = log(t51)
            t53 = t41+t26+7.57211d-1
            t54 = t53**5.0d-1
            t55 = t54+t45
            t56 = 1/t55
            t57 = 1.475609999999999d-1*t50*t56+1.0d+0
            t58 = log(t57)
            t59 = t26+7.57211d-1
            t60 = t54+t43
            t61 = 1/t60
            t62 = t54+t48
            t63 = 1/t62
            t64 = t48+t43
            t65 = 1/t64
            t66 = t26+6.0965d-1
            t67 = t66**2.0d+0
            t68 = t66**3.5d+0
            t69 = (gammaaa*t16*t17*t25)**5.0d-1
            t70 = t59**5.0d-1
            t71 = 1.282782438530422d-1*t69-t70
            t72 = -2.4d+0*t68*t71-1.417963080724413d+0*t68+2.83637333333
     1         3333d-2*t67-9.086532d-1*t66**3.0d+0+4.7459599999999996d-2
     2         *t35*t66
            t73 = 1/t37**3.0d+0
            t74 = t1*t3*t30
            t75 = 2.4682961769030842d-2*t74**2.0d+0+2.8862604866934494d-
     1         1*t1*t3*t30+1.0d+0
            t76 = -8.888888888888888d-1*t72*t73*t75+7.57211d-1*(1.645530
     1         7846020562d-2*gammaaa*t16*t17*t25*t61*t65+t59*t61*t63)-2.
     2         0d+0*t58*t59+3.2910615692041123d-2*gammaaa*t16*t17*t25*t5
     3         2+5.273288888888887d-2*t35*t36*t38+4.727288888888889d-2*t
     4         28*t32-1.0d+0
            t77 = rhob**3.333333333333333d-1
            t78 = 1/t77
            t79 = t1*t78
            t80 = gammabb**5.0d-1
            t81 = t80**7
            t82 = 1/rhob**9.333333333333333d+0
            t83 = gammabb**3
            t84 = 1/rhob**8
            t85 = t80**5
            t86 = 1/rhob**6.666666666666667d+0
            t87 = gammabb**2
            t88 = 1/rhob**5.333333333333333d+0
            t89 = t80**3
            t90 = 1/rhob**4
            t91 = 1/rhob**2.6666666666666666d+0
            t92 = 2.631878392200375d-4*gammabb*t91+1.8005513133540818d-4
     1         *t89*t90-4.342399100269002d-5*t87*t88+5.3020963068324d-6*
     2         t85*t86-4.327677396975467d-7*t83*t84+2.4123830247695402d-
     3         8*t81*t82
            t93 = t80**9
            t94 = 1/rhob**12
            t95 = gammabb**4
            t96 = 1/rhob**1.0666666666666666d+1
            t97 = rhob**1.3333333333333333d+0
            t98 = 1/t97
            t99 = 6.841322473346062d-1*t80*t98-5.649671283776346d-9*t95*
     1         t96+3.149302550983647d-10*t93*t94-2.0532933130264455d-1*g
     2         ammabb*t91+2.342799068769956d-2*t89*t90-1.383706469760652
     3         4d-3*t87*t88+5.955909787676884d-5*t85*t86-2.7196832676277
     4         033d-6*t83*t84+1.7578986477855002d-7*t81*t82+1.0d+0
            t100 = 1/t99
            t101 = 1.6455307846020562d-2*gammabb*t100*t91*t92
            t102 = 6.582123138408225d-2*t79**2.0d+0+t101+6.0965d-1
            t103 = 1/t102
            t104 = t102**5.0d-1
            t105 = 1/t104
            t106 = 2.565564877060844d-1*t1*t105*t78+1.0d+0
            t107 = 1/t106
            t108 = 4.1138269615051404d-3*gammabb*t91+1.0d+0
            t109 = 1/t108
            t110 = 6.934448603031025d-2*gammabb*t100*t91*t92+5.136628594
     1         837797d-3*gammabb*t109*t91+1.0d+0
            t111 = 1.282782438530422d-1*t1*t105*t78+1.0d+0
            t112 = t102*t106
            t113 = 1/t112**2.0d+0
            t114 = 1/rhob**6.666666666666666d-1
            t115 = 6.582123138408225d-2*t114*t39
            t116 = t115+t101
            t117 = t116**5.0d-1
            t118 = t115+t101+6.0965d-1
            t119 = t118**5.0d-1
            t120 = t119+t117
            t121 = 1/t120
            t122 = 2.565564877060844d-1*t1*t78
            t123 = t122+t119
            t124 = 1/t123
            t125 = 1.0d+0-6.0965d-1*t121*t124
            t126 = log(t125)
            t127 = t115+t101+7.57211d-1
            t128 = t127**5.0d-1
            t129 = t128+t119
            t130 = 1/t129
            t131 = 1.475609999999999d-1*t124*t130+1.0d+0
            t132 = log(t131)
            t133 = t101+7.57211d-1
            t134 = t128+t117
            t135 = 1/t134
            t136 = t128+t122
            t137 = 1/t136
            t138 = t122+t117
            t139 = 1/t138
            t140 = t101+6.0965d-1
            t141 = t140**2.0d+0
            t142 = t140**3.5d+0
            t143 = (gammabb*t100*t91*t92)**5.0d-1
            t144 = t133**5.0d-1
            t145 = 1.282782438530422d-1*t143-t144
            t146 = -2.4d+0*t142*t145-1.417963080724413d+0*t142+2.8363733
     1         33333333d-2*t141-9.086532d-1*t140**3.0d+0+4.7459599999999
     2         996d-2*t110*t140
            t147 = 1/t112**3.0d+0
            t148 = t1*t105*t78
            t149 = 2.8862604866934494d-1*t1*t105*t78+2.4682961769030842d
     1         -2*t148**2.0d+0+1.0d+0
            t150 = 7.57211d-1*(1.6455307846020562d-2*gammabb*t100*t135*t
     1         139*t91*t92+t133*t135*t137)+3.2910615692041123d-2*gammabb
     2         *t100*t126*t91*t92-8.888888888888888d-1*t146*t147*t149-2.
     3         0d+0*t132*t133+5.273288888888887d-2*t110*t111*t113+4.7272
     4         88888888889d-2*t103*t107-1.0d+0
            t151 = 1/t27**2
            t152 = 1/rhoa**3.6666666666666664d+0
            t153 = -4.38808209227215d-2*gammaaa*t152*t17*t25
            t154 = 1/rhoa**13
            t155 = 1/rhoa**1.1666666666666665d+1
            t156 = 1/rhoa**1.0333333333333333d+1
            t157 = 1/rhoa**9
            t158 = 1/rhoa**7.666666666666667d+0
            t159 = 1/rhoa**6.333333333333333d+0
            t160 = 1/rhoa**5
            t161 = 1/rhoa**2.3333333333333334d+0
            t162 = 2.1757466141021625d-5*t157*t8-1.6407054045998d-6*t156
     1         *t6-9.121763297794749d-1*t161*t5+6.026316036028103d-8*t15
     2         5*t20-3.7791630611803767d-9*t154*t18-9.371196275079824d-2
     3         *t14*t160+7.379767838723479d-3*t12*t159-3.970606525117923
     4         d-4*t10*t158+5.475448834737188d-1*gammaaa*t152
            t163 = 1/t24**2
            t164 = -1.6455307846020562d-2*gammaaa*t16*t162*t163*t17
            t165 = 3.462141917580374d-6*t157*t8-2.2515574897849044d-7*t1
     1         56*t6-7.202205253416327d-4*t14*t160+2.3159461868101344d-4
     2         *t12*t159-3.5347308712216d-5*t10*t158-7.018342379201d-4*g
     3         ammaaa*t152
            t166 = 1.6455307846020562d-2*gammaaa*t16*t165*t25
            t167 = -4.38808209227215d-2*t1*t23*t4+t166+t164+t153
            t168 = 1/t33**2
            t169 = -1.369767625290079d-2*gammaaa*t152*t34-1.849186294141
     1         6065d-1*gammaaa*t152*t17*t25+6.934448603031025d-2*gammaaa
     2         *t16*t165*t25-6.934448603031025d-2*gammaaa*t16*t162*t163*
     3         t17+5.634986987915197d-5*t12*t159*t168
            t170 = -4.38808209227215d-2*t39/rhoa**1.6666666666666669d+0+
     1         t166+t164+t153
            t171 = 1/t45
            t172 = 5.0d-1*t170*t171
            t173 = -8.551882923536147d-2*t1*t23
            t174 = t173+t172
            t175 = 1/t49**2
            t176 = 1/t43
            t177 = 5.0d-1*t170*t176
            t178 = t177+t172
            t179 = 1/t46**2
            t180 = 6.0965d-1*t178*t179*t50+6.0965d-1*t174*t175*t47
            t181 = 1/t51
            t182 = t166+t164+t153
            t183 = 1/t54
            t184 = 5.0d-1*t170*t183
            t185 = t184+t172
            t186 = 1/t55**2
            t187 = -1.475609999999999d-1*t174*t175*t56-1.475609999999999
     1         d-1*t185*t186*t50
            t188 = 1/t57
            t189 = t184+t173
            t190 = 1/t62**2
            t191 = t184+t177
            t192 = 1/t60**2
            t193 = t177+t173
            t194 = 1/t64**2
            t195 = t66**2.5d+0
            t196 = 1/t70
            t197 = 1/t69
            t198 = -2.6666666666666666d+0*gammaaa*t152*t17*t25+gammaaa*t
     1         16*t165*t25-gammaaa*t16*t162*t163*t17
            t199 = 6.41391219265211d-2*t197*t198-5.0d-1*t182*t196
            t200 = -8.400000000000001d+0*t182*t195*t71-2.4d+0*t199*t68-2
     1         .7259596d+0*t182*t67+5.672746666666666d-2*t182*t66+4.7459
     2         599999999996d-2*t169*t66+4.7459599999999996d-2*t182*t35-4
     3         .9628707825354457d+0*t182*t195
            t201 = 1/t31**2
            t202 = 1/t29**3
            t203 = -8.551882923536147d-2*t1*t23*t30-1.282782438530422d-1
     1         *t1*t167*t202*t3
            t204 = -4.2759414617680735d-2*t1*t23*t30-6.41391219265211d-2
     1         *t1*t167*t202*t3
            t205 = -3.333333333333333d-1*t1*t23*t30-5.0d-1*t1*t167*t202*
     1         t3
            t206 = 4.9365923538061685d-2*t205*t74-9.620868288978164d-2*t
     1         1*t23*t30-1.4431302433467247d-1*t1*t167*t202*t3
            t207 = t167*t31+t203*t27
            t208 = 1/t37**4.0d+0
            t209 = -8.888888888888888d-1*t200*t73*t75+2.6666666666666666
     1         d+0*t207*t208*t72*t75-8.888888888888888d-1*t206*t72*t73-1
     2         .0546577777777776d-1*t207*t35*t36*t73+7.57211d-1*(-4.3880
     3         8209227215d-2*gammaaa*t152*t17*t25*t61*t65+1.645530784602
     4         0562d-2*gammaaa*t16*t165*t25*t61*t65-1.6455307846020562d-
     5         2*gammaaa*t16*t162*t163*t17*t61*t65-1.6455307846020562d-2
     6         *gammaaa*t16*t17*t191*t192*t25*t65+t182*t61*t63-t191*t192
     7         *t59*t63-t189*t190*t59*t61-1.6455307846020562d-2*gammaaa*
     8         t16*t17*t193*t194*t25*t61)-2.0d+0*t187*t188*t59-2.0d+0*t1
     9         82*t58-8.7761641845443d-2*gammaaa*t152*t17*t25*t52+3.2910
     :         615692041123d-2*gammaaa*t16*t165*t25*t52-3.29106156920411
     ;         23d-2*gammaaa*t16*t162*t163*t17*t52+5.273288888888887d-2*
     <         t169*t36*t38+5.273288888888887d-2*t204*t35*t38-4.72728888
     =         8888889d-2*t151*t167*t32-4.727288888888889d-2*t201*t203*t
     >         28+3.2910615692041123d-2*gammaaa*t16*t17*t180*t181*t25
            t210 = 1/t102**2
            t211 = 1/rhob**3.6666666666666664d+0
            t212 = -4.38808209227215d-2*gammabb*t100*t211*t92
            t213 = 1/rhob**13
            t214 = 1/rhob**1.1666666666666665d+1
            t215 = 1/rhob**1.0333333333333333d+1
            t216 = 1/rhob**9
            t217 = 1/rhob**7.666666666666667d+0
            t218 = 1/rhob**6.333333333333333d+0
            t219 = 1/rhob**5
            t220 = 1/rhob**2.3333333333333334d+0
            t221 = 6.026316036028103d-8*t214*t95-3.7791630611803767d-9*t
     1         213*t93-9.371196275079824d-2*t219*t89+7.379767838723479d-
     2         3*t218*t87-3.970606525117923d-4*t217*t85+2.17574661410216
     3         25d-5*t216*t83-1.6407054045998d-6*t215*t81-9.121763297794
     4         749d-1*t220*t80+5.475448834737188d-1*gammabb*t211
            t222 = 1/t99**2
            t223 = -1.6455307846020562d-2*gammabb*t221*t222*t91*t92
            t224 = -7.202205253416327d-4*t219*t89+2.3159461868101344d-4*
     1         t218*t87-3.5347308712216d-5*t217*t85+3.462141917580374d-6
     2         *t216*t83-2.2515574897849044d-7*t215*t81-7.018342379201d-
     3         4*gammabb*t211
            t225 = 1.6455307846020562d-2*gammabb*t100*t224*t91
            t226 = -4.38808209227215d-2*t1*t79*t98+t225+t223+t212
            t227 = 1/t108**2
            t228 = -6.934448603031025d-2*gammabb*t221*t222*t91*t92-1.849
     1         1862941416065d-1*gammabb*t100*t211*t92+6.934448603031025d
     2         -2*gammabb*t100*t224*t91+5.634986987915197d-5*t218*t227*t
     3         87-1.369767625290079d-2*gammabb*t109*t211
            t229 = -4.38808209227215d-2*t39/rhob**1.6666666666666669d+0+
     1         t225+t223+t212
            t230 = 1/t119
            t231 = 5.0d-1*t229*t230
            t232 = -8.551882923536147d-2*t1*t98
            t233 = t232+t231
            t234 = 1/t123**2
            t235 = 1/t117
            t236 = 5.0d-1*t229*t235
            t237 = t236+t231
            t238 = 1/t120**2
            t239 = 6.0965d-1*t124*t237*t238+6.0965d-1*t121*t233*t234
            t240 = 1/t125
            t241 = t225+t223+t212
            t242 = 1/t128
            t243 = 5.0d-1*t229*t242
            t244 = t243+t231
            t245 = 1/t129**2
            t246 = -1.475609999999999d-1*t124*t244*t245-1.47560999999999
     1         9d-1*t130*t233*t234
            t247 = 1/t131
            t248 = t243+t232
            t249 = 1/t136**2
            t250 = t243+t236
            t251 = 1/t134**2
            t252 = t236+t232
            t253 = 1/t138**2
            t254 = t140**2.5d+0
            t255 = 1/t144
            t256 = 1/t143
            t257 = -gammabb*t221*t222*t91*t92-2.6666666666666666d+0*gamm
     1         abb*t100*t211*t92+gammabb*t100*t224*t91
            t258 = 6.41391219265211d-2*t256*t257-5.0d-1*t241*t255
            t259 = -2.4d+0*t142*t258-8.400000000000001d+0*t145*t241*t254
     1         -4.9628707825354457d+0*t241*t254-2.7259596d+0*t141*t241+5
     2         .672746666666666d-2*t140*t241+4.7459599999999996d-2*t110*
     3         t241+4.7459599999999996d-2*t140*t228
            t260 = 1/t106**2
            t261 = 1/t104**3
            t262 = -8.551882923536147d-2*t1*t105*t98-1.282782438530422d-
     1         1*t1*t226*t261*t78
            t263 = -4.2759414617680735d-2*t1*t105*t98-6.41391219265211d-
     1         2*t1*t226*t261*t78
            t264 = -3.333333333333333d-1*t1*t105*t98-5.0d-1*t1*t226*t261
     1         *t78
            t265 = -9.620868288978164d-2*t1*t105*t98-1.4431302433467247d
     1         -1*t1*t226*t261*t78+4.9365923538061685d-2*t148*t264
            t266 = t102*t262+t106*t226
            t267 = 1/t112**4.0d+0
            t268 = 7.57211d-1*(-1.6455307846020562d-2*gammabb*t100*t135*
     1         t252*t253*t91*t92-1.6455307846020562d-2*gammabb*t100*t139
     2         *t250*t251*t91*t92-1.6455307846020562d-2*gammabb*t135*t13
     3         9*t221*t222*t91*t92-4.38808209227215d-2*gammabb*t100*t135
     4         *t139*t211*t92+1.6455307846020562d-2*gammabb*t100*t135*t1
     5         39*t224*t91-t133*t137*t250*t251-t133*t135*t248*t249+t135*
     6         t137*t241)+3.2910615692041123d-2*gammabb*t100*t239*t240*t
     7         91*t92-3.2910615692041123d-2*gammabb*t126*t221*t222*t91*t
     8         92-8.7761641845443d-2*gammabb*t100*t126*t211*t92+3.291061
     9         5692041123d-2*gammabb*t100*t126*t224*t91+2.66666666666666
     :         66d+0*t146*t149*t266*t267-1.0546577777777776d-1*t110*t111
     ;         *t147*t266-8.888888888888888d-1*t146*t147*t265+5.27328888
     <         8888887d-2*t110*t113*t263-4.727288888888889d-2*t103*t260*
     =         t262-8.888888888888888d-1*t147*t149*t259-2.0d+0*t133*t246
     >         *t247-2.0d+0*t132*t241+5.273288888888887d-2*t111*t113*t22
     ?         8-4.727288888888889d-2*t107*t210*t226
            t269 = 1/t5
            t270 = -8.159049802883108d-6*t12*t9-2.2598685135105387d-8*t2
     1         1*t8+6.15264526724925d-7*t10*t7+1.4171861479426412d-9*t19
     2         *t6+3.514198603154934d-2*t15*t5+3.420661236673031d-1*t23*
     3         t269-2.0532933130264455d-1*t16+1.488977446919221d-4*t11*t
     4         14-2.767412939521305d-3*gammaaa*t13
            t271 = -1.2983032190926402d-6*t12*t9+8.443340586693391d-8*t1
     1         0*t7+2.7008269700311227d-4*t15*t5+2.631878392200375d-4*t1
     2         6+1.3255240767081d-5*t11*t14-8.684798200538004d-5*gammaaa
     3         *t13
            t272 = 1.6455307846020562d-2*gammaaa*t16*t25*t271-1.64553078
     1         46020562d-2*gammaaa*t16*t163*t17*t270+1.6455307846020562d
     2         -2*t16*t17*t25
            t273 = -4.727288888888889d-2*t151*t272*t32
            t274 = 5.136628594837797d-3*t16*t34+6.934448603031025d-2*gam
     1         maaa*t16*t25*t271-6.934448603031025d-2*gammaaa*t16*t163*t
     2         17*t270+6.934448603031025d-2*t16*t17*t25-2.11312012046819
     3         9d-5*gammaaa*t13*t168
            t275 = 5.273288888888887d-2*t274*t36*t38
            t276 = -3.2910615692041123d-2*gammaaa*t16*t163*t17*t270*t52
            t277 = 5.0d-1*t176*t272
            t278 = 5.0d-1*t171*t272
            t279 = t278+t277
            t280 = 6.0965d-1*t179*t279*t50+3.04825d-1*t171*t175*t272*t47
            t281 = 3.2910615692041123d-2*gammaaa*t16*t17*t181*t25*t280
            t282 = 3.2910615692041123d-2*gammaaa*t271*t52+3.291061569204
     1         1123d-2*t17*t52
            t283 = -2.0d+0*t272*t58
            t284 = 5.0d-1*t183*t272
            t285 = t284+t278
            t286 = -7.378049999999994d-2*t171*t175*t272*t56-1.4756099999
     1         99999d-1*t186*t285*t50
            t287 = -2.0d+0*t188*t286*t59
            t288 = t284+t277
            t289 = 7.57211d-1*(1.6455307846020562d-2*gammaaa*t16*t25*t27
     1         1*t61*t65-1.6455307846020562d-2*gammaaa*t16*t163*t17*t270
     2         *t61*t65+1.6455307846020562d-2*t16*t17*t25*t61*t65-1.6455
     3         307846020562d-2*gammaaa*t16*t17*t192*t25*t288*t65+t272*t6
     4         1*t63-t192*t288*t59*t63-5.0d-1*t183*t190*t272*t59*t61-8.2
     5         27653923010281d-3*gammaaa*t16*t17*t176*t194*t25*t272*t61)
            t290 = 1/t29**5
            t291 = 6.064083168526658d-3*t1*t201*t272*t290*t3
            t292 = -3.3822411899821336d-3*t1*t202*t272*t3*t35*t38
            t293 = t272*t31-1.282782438530422d-1*t1*t272*t3*t30
            t294 = 2.6666666666666666d+0*t208*t293*t72*t75
            t295 = -1.4431302433467247d-1*t1*t202*t272*t3
            t296 = t295-2.4682961769030842d-2*t151*t272*t39*t40
            t297 = gammaaa*t16*t25*t271-gammaaa*t16*t163*t17*t270+t16*t1
     1         7*t25
            t298 = 6.41391219265211d-2*t197*t297-5.0d-1*t196*t272
            t299 = -8.400000000000001d+0*t195*t272*t71-2.4d+0*t298*t68-2
     1         .7259596d+0*t272*t67+4.7459599999999996d-2*t274*t66+5.672
     2         746666666666d-2*t272*t66+4.7459599999999996d-2*t272*t35-4
     3         .9628707825354457d+0*t195*t272
            t300 = -8.888888888888888d-1*t299*t75-8.888888888888888d-1*t
     1         296*t72-1.0546577777777776d-1*t293*t35*t36
            t301 = 1/t80
            t302 = 3.420661236673031d-1*t301*t98-2.2598685135105387d-8*t
     1         83*t96+1.4171861479426412d-9*t81*t94-2.0532933130264455d-
     2         1*t91+3.514198603154934d-2*t80*t90+1.488977446919221d-4*t
     3         86*t89-2.767412939521305d-3*gammabb*t88-8.159049802883108
     4         d-6*t84*t87+6.15264526724925d-7*t82*t85
            t303 = 2.631878392200375d-4*t91+2.7008269700311227d-4*t80*t9
     1         0+1.3255240767081d-5*t86*t89-8.684798200538004d-5*gammabb
     2         *t88-1.2983032190926402d-6*t84*t87+8.443340586693391d-8*t
     3         82*t85
            t304 = -1.6455307846020562d-2*gammabb*t222*t302*t91*t92+1.64
     1         55307846020562d-2*t100*t91*t92+1.6455307846020562d-2*gamm
     2         abb*t100*t303*t91
            t305 = -4.727288888888889d-2*t107*t210*t304
            t306 = -6.934448603031025d-2*gammabb*t222*t302*t91*t92+6.934
     1         448603031025d-2*t100*t91*t92+6.934448603031025d-2*gammabb
     2         *t100*t303*t91+5.136628594837797d-3*t109*t91-2.1131201204
     3         68199d-5*gammabb*t227*t88
            t307 = 5.273288888888887d-2*t111*t113*t306
            t308 = -3.2910615692041123d-2*gammabb*t126*t222*t302*t91*t92
            t309 = 5.0d-1*t235*t304
            t310 = 5.0d-1*t230*t304
            t311 = t310+t309
            t312 = 6.0965d-1*t124*t238*t311+3.04825d-1*t121*t230*t234*t3
     1         04
            t313 = 3.2910615692041123d-2*gammabb*t100*t240*t312*t91*t92
            t314 = 3.2910615692041123d-2*t126*t92+3.2910615692041123d-2*
     1         gammabb*t126*t303
            t315 = -2.0d+0*t132*t304
            t316 = 5.0d-1*t242*t304
            t317 = t316+t310
            t318 = -1.475609999999999d-1*t124*t245*t317-7.37804999999999
     1         4d-2*t130*t230*t234*t304
            t319 = -2.0d+0*t133*t247*t318
            t320 = t316+t309
            t321 = 7.57211d-1*(-1.6455307846020562d-2*gammabb*t100*t139*
     1         t251*t320*t91*t92-8.227653923010281d-3*gammabb*t100*t135*
     2         t235*t253*t304*t91*t92-1.6455307846020562d-2*gammabb*t135
     3         *t139*t222*t302*t91*t92+1.6455307846020562d-2*t100*t135*t
     4         139*t91*t92+1.6455307846020562d-2*gammabb*t100*t135*t139*
     5         t303*t91-t133*t137*t251*t320-5.0d-1*t133*t135*t242*t249*t
     6         304+t135*t137*t304)
            t322 = 1/t104**5
            t323 = 6.064083168526658d-3*t1*t260*t304*t322*t78
            t324 = -3.3822411899821336d-3*t1*t110*t113*t261*t304*t78
            t325 = t106*t304-1.282782438530422d-1*t1*t105*t304*t78
            t326 = 2.6666666666666666d+0*t146*t149*t267*t325
            t327 = -1.4431302433467247d-1*t1*t261*t304*t78
            t328 = t327-2.4682961769030842d-2*t114*t210*t304*t39
            t329 = -gammabb*t222*t302*t91*t92+t100*t91*t92+gammabb*t100*
     1         t303*t91
            t330 = 6.41391219265211d-2*t256*t329-5.0d-1*t255*t304
            t331 = -2.4d+0*t142*t330+4.7459599999999996d-2*t140*t306-8.4
     1         00000000000001d+0*t145*t254*t304-4.9628707825354457d+0*t2
     2         54*t304-2.7259596d+0*t141*t304+5.672746666666666d-2*t140*
     3         t304+4.7459599999999996d-2*t110*t304
            t332 = -8.888888888888888d-1*t149*t331-8.888888888888888d-1*
     1         t146*t328-1.0546577777777776d-1*t110*t111*t325
            t333 = 1/rhoa**4.666666666666667d+0
            t334 = 1.6089634338331216d-1*gammaaa*t17*t25*t333
            t335 = 8.7761641845443d-2*gammaaa*t152*t162*t163*t17
            t336 = -8.7761641845443d-2*gammaaa*t152*t165*t25
            t337 = t162**2
            t338 = 1/t24**3
            t339 = 3.2910615692041123d-2*gammaaa*t16*t17*t337*t338
            t340 = 1/rhoa**1.1333333333333334d+1
            t341 = 1/rhoa**10
            t342 = 1/rhoa**8.666666666666666d+0
            t343 = 1/rhoa**7.333333333333333d+0
            t344 = 1/rhoa**6
            t345 = -1.9581719526919464d-4*t341*t8+1.695395584753127d-5*t
     1         340*t6+2.1284114361521084d+0*t5/rhoa**3.3333333333333337d
     2         +0+4.685598137539912d-1*t14*t344-4.6738529645248705d-2*t1
     3         2*t343+3.0441316692570747d-3*t10*t342-2.0076645727369685d
     4         +0*gammaaa*t333-7.030702042032786d-7*t20/rhoa**1.26666666
     5         66666665d+1+4.9129119795344894d-8*t18/rhoa**14
            t346 = -1.6455307846020562d-2*gammaaa*t16*t163*t17*t345
            t347 = -3.2910615692041123d-2*gammaaa*t16*t162*t163*t165
            t348 = -3.115927725822337d-5*t341*t8+2.326609406111068d-6*t3
     1         40*t6+3.6011026267081636d-3*t14*t344-1.466765918313085d-3
     2         *t12*t343+2.709960334603227d-4*t10*t342+2.573392205707033
     3         5d-3*gammaaa*t333
            t349 = 1.6455307846020562d-2*gammaaa*t16*t25*t348
            t350 = 7.313470153786916d-2*t16*t39+t349+t347+t346+t339+t336
     1         +t335+t334
            t351 = 1/t27**3
            t352 = t167**2
            t353 = 1/t33**3
            t354 = 1.2363392745928628d-6*t341*t353*t8+6.934448603031025d
     1         -2*gammaaa*t16*t25*t348-6.934448603031025d-2*gammaaa*t16*
     2         t163*t17*t345-5.071488289123677d-4*t12*t168*t343+5.022481
     3         29273029d-2*gammaaa*t333*t34+1.386889720606205d-1*gammaaa
     4         *t16*t17*t337*t338+6.780349745185891d-1*gammaaa*t17*t25*t
     5         333-3.698372588283213d-1*gammaaa*t152*t165*t25+3.69837258
     6         8283213d-1*gammaaa*t152*t162*t163*t17-1.386889720606205d-
     7         1*gammaaa*t16*t162*t163*t165
            t355 = 1/t31**3
            t356 = t207**2
            t357 = 1/t37**5.0d+0
            t358 = 1/t51**2
            t359 = t174**2
            t360 = 1/t49**3
            t361 = t170**2
            t362 = 1/t45**3
            t363 = -2.5d-1*t361*t362
            t364 = 5.0d-1*t171*t350
            t365 = 1.1402510564714863d-1*t1*t161
            t366 = t365+t364+t363
            t367 = 1/t46**3
            t368 = 1/t43**3
            t369 = -2.5d-1*t361*t368
            t370 = 5.0d-1*t176*t350
            t371 = t349+t347+t346+t339+t336+t335+t334
            t372 = 1/t57**2
            t373 = 1/t55**3
            t374 = 1/t54**3
            t375 = -2.5d-1*t361*t374
            t376 = 5.0d-1*t183*t350
            t377 = 1/t62**3
            t378 = t191**2
            t379 = 1/t60**3
            t380 = t376+t375+t370+t369
            t381 = 1/t64**3
            t382 = t182**2
            t383 = t66**1.5d+0
            t384 = 1/t69**3
            t385 = 1/t70**3
            t386 = 1.924173657795633d-1*t1*t290*t3*t352-1.28278243853042
     1         2d-1*t1*t202*t3*t350+1.1402510564714863d-1*t1*t161*t30+8.
     2         551882923536147d-2*t1*t167*t202*t23
            t387 = t27*t386+t31*t350+2*t167*t203
            t388 = 1/rhob**4.666666666666667d+0
            t389 = 1.6089634338331216d-1*gammabb*t100*t388*t92
            t390 = 8.7761641845443d-2*gammabb*t211*t221*t222*t92
            t391 = -8.7761641845443d-2*gammabb*t100*t211*t224
            t392 = t221**2
            t393 = 1/t99**3
            t394 = 3.2910615692041123d-2*gammabb*t392*t393*t91*t92
            t395 = 1/rhob**1.1333333333333334d+1
            t396 = 1/rhob**10
            t397 = 1/rhob**8.666666666666666d+0
            t398 = 1/rhob**7.333333333333333d+0
            t399 = 1/rhob**6
            t400 = -7.030702042032786d-7*t95/rhob**1.2666666666666665d+1
     1         +4.9129119795344894d-8*t93/rhob**14+4.685598137539912d-1*
     2         t399*t89-4.6738529645248705d-2*t398*t87+3.044131669257074
     3         7d-3*t397*t85-1.9581719526919464d-4*t396*t83+1.6953955847
     4         53127d-5*t395*t81+2.1284114361521084d+0*t80/rhob**3.33333
     5         33333333337d+0-2.0076645727369685d+0*gammabb*t388
            t401 = -1.6455307846020562d-2*gammabb*t222*t400*t91*t92
            t402 = -3.2910615692041123d-2*gammabb*t221*t222*t224*t91
            t403 = 3.6011026267081636d-3*t399*t89-1.466765918313085d-3*t
     1         398*t87+2.709960334603227d-4*t397*t85-3.115927725822337d-
     2         5*t396*t83+2.326609406111068d-6*t395*t81+2.57339220570703
     3         35d-3*gammabb*t388
            t404 = 1.6455307846020562d-2*gammabb*t100*t403*t91
            t405 = 7.313470153786916d-2*t39*t91+t404+t402+t401+t394+t391
     1         +t390+t389
            t406 = 1/t102**3
            t407 = t226**2
            t408 = 1/t108**3
            t409 = -6.934448603031025d-2*gammabb*t222*t400*t91*t92+1.386
     1         889720606205d-1*gammabb*t392*t393*t91*t92+6.7803497451858
     2         91d-1*gammabb*t100*t388*t92+3.698372588283213d-1*gammabb*
     3         t211*t221*t222*t92+6.934448603031025d-2*gammabb*t100*t403
     4         *t91-1.386889720606205d-1*gammabb*t221*t222*t224*t91-5.07
     5         1488289123677d-4*t227*t398*t87+1.2363392745928628d-6*t396
     6         *t408*t83+5.02248129273029d-2*gammabb*t109*t388-3.6983725
     7         88283213d-1*gammabb*t100*t211*t224
            t410 = 1/t106**3
            t411 = t266**2
            t412 = 1/t112**5.0d+0
            t413 = 1/t125**2
            t414 = t233**2
            t415 = 1/t123**3
            t416 = t229**2
            t417 = 1/t119**3
            t418 = -2.5d-1*t416*t417
            t419 = 5.0d-1*t230*t405
            t420 = 1.1402510564714863d-1*t1*t220
            t421 = t420+t419+t418
            t422 = 1/t120**3
            t423 = 1/t117**3
            t424 = -2.5d-1*t416*t423
            t425 = 5.0d-1*t235*t405
            t426 = t404+t402+t401+t394+t391+t390+t389
            t427 = 1/t131**2
            t428 = 1/t129**3
            t429 = 1/t128**3
            t430 = -2.5d-1*t416*t429
            t431 = 5.0d-1*t242*t405
            t432 = 1/t136**3
            t433 = t250**2
            t434 = 1/t134**3
            t435 = t431+t430+t425+t424
            t436 = 1/t138**3
            t437 = t241**2
            t438 = t140**1.5d+0
            t439 = 1/t143**3
            t440 = 1/t144**3
            t441 = 8.551882923536147d-2*t1*t226*t261*t98+1.9241736577956
     1         33d-1*t1*t322*t407*t78-1.282782438530422d-1*t1*t261*t405*
     2         t78+1.1402510564714863d-1*t1*t105*t220
            t442 = t102*t441+t106*t405+2*t226*t262
            t443 = t295-2.4682961769030842d-2*t1*t202*t272*t3*t74
            t444 = 2.4105264144112412d-7*t155*t8-1.7006233775311694d-8*t
     1         154*t6-1.4056794412619736d-1*t160*t5-4.5608816488973747d-
     2         1*t161*t269+1.4759535677446958d-2*gammaaa*t159-9.92651631
     3         2794808d-4*t14*t158+6.527239842306487d-5*t12*t157-5.74246
     4         8916099301d-6*t10*t156+5.475448834737188d-1*t152
            t445 = -1.0803307880124491d-3*t160*t5+4.631892373620269d-4*g
     1         ammaaa*t159-8.836827178054d-5*t14*t158+1.0386425752741123
     2         d-5*t12*t157-7.880451214247165d-7*t10*t156-7.018342379201
     3         d-4*t152
            t446 = 1.6455307846020562d-2*gammaaa*t16*t25*t445-1.64553078
     1         46020562d-2*gammaaa*t16*t163*t17*t444+3.2910615692041123d
     2         -2*gammaaa*t16*t162*t17*t270*t338-4.38808209227215d-2*gam
     3         maaa*t152*t25*t271-1.6455307846020562d-2*gammaaa*t16*t162
     4         *t163*t271+4.38808209227215d-2*gammaaa*t152*t163*t17*t270
     5         -1.6455307846020562d-2*gammaaa*t16*t163*t165*t270-4.38808
     6         209227215d-2*t152*t17*t25+1.6455307846020562d-2*t16*t165*
     7         t25-1.6455307846020562d-2*t16*t162*t163*t17
            t447 = 6.934448603031025d-2*gammaaa*t16*t25*t445-6.934448603
     1         031025d-2*gammaaa*t16*t163*t17*t444-4.6362722797232353d-7
     2         *t12*t157*t353-1.369767625290079d-2*t152*t34+1.3868897206
     3         06205d-1*gammaaa*t16*t162*t17*t270*t338-1.849186294141606
     4         5d-1*gammaaa*t152*t25*t271-6.934448603031025d-2*gammaaa*t
     5         16*t162*t163*t271+1.8491862941416065d-1*gammaaa*t152*t163
     6         *t17*t270-6.934448603031025d-2*gammaaa*t16*t163*t165*t270
     7         -1.8491862941416065d-1*t152*t17*t25+6.934448603031025d-2*
     8         t16*t165*t25-6.934448603031025d-2*t16*t162*t163*t17+1.690
     9         496096374559d-4*gammaaa*t159*t168
            t448 = -2.5d-1*t170*t272*t362
            t449 = 5.0d-1*t171*t446
            t450 = t449+t448
            t451 = -2.5d-1*t170*t272*t368
            t452 = 5.0d-1*t176*t446
            t453 = -2.5d-1*t170*t272*t374
            t454 = 5.0d-1*t183*t446
            t455 = t454+t453+t452+t451
            t456 = 1/t29**7
            t457 = -1.282782438530422d-1*t1*t202*t3*t446+1.9241736577956
     1         33d-1*t1*t167*t272*t290*t3+4.2759414617680735d-2*t1*t202*
     2         t23*t272
            t458 = t27*t457+t31*t446-1.282782438530422d-1*t1*t167*t202*t
     1         272*t3+t203*t272
            t459 = t327-2.4682961769030842d-2*t1*t148*t261*t304*t78
            t460 = -9.926516312794808d-4*t217*t89+6.527239842306487d-5*t
     1         216*t87-5.742468916099301d-6*t215*t85+2.4105264144112412d
     2         -7*t214*t83-1.7006233775311694d-8*t213*t81-1.405679441261
     3         9736d-1*t219*t80-4.5608816488973747d-1*t220*t301+1.475953
     4         5677446958d-2*gammabb*t218+5.475448834737188d-1*t211
            t461 = -8.836827178054d-5*t217*t89+1.0386425752741123d-5*t21
     1         6*t87-7.880451214247165d-7*t215*t85-1.0803307880124491d-3
     2         *t219*t80+4.631892373620269d-4*gammabb*t218-7.01834237920
     3         1d-4*t211
            t462 = -1.6455307846020562d-2*gammabb*t222*t460*t91*t92+3.29
     1         10615692041123d-2*gammabb*t221*t302*t393*t91*t92-1.645530
     2         7846020562d-2*t221*t222*t91*t92+4.38808209227215d-2*gamma
     3         bb*t211*t222*t302*t92-4.38808209227215d-2*t100*t211*t92+1
     4         .6455307846020562d-2*gammabb*t100*t461*t91-1.645530784602
     5         0562d-2*gammabb*t221*t222*t303*t91-1.6455307846020562d-2*
     6         gammabb*t222*t224*t302*t91+1.6455307846020562d-2*t100*t22
     7         4*t91-4.38808209227215d-2*gammabb*t100*t211*t303
            t463 = -6.934448603031025d-2*gammabb*t222*t460*t91*t92+1.386
     1         889720606205d-1*gammabb*t221*t302*t393*t91*t92-6.93444860
     2         3031025d-2*t221*t222*t91*t92+1.8491862941416065d-1*gammab
     3         b*t211*t222*t302*t92-1.8491862941416065d-1*t100*t211*t92+
     4         6.934448603031025d-2*gammabb*t100*t461*t91-6.934448603031
     5         025d-2*gammabb*t221*t222*t303*t91-6.934448603031025d-2*ga
     6         mmabb*t222*t224*t302*t91+6.934448603031025d-2*t100*t224*t
     7         91-4.6362722797232353d-7*t216*t408*t87-1.8491862941416065
     8         d-1*gammabb*t100*t211*t303+1.690496096374559d-4*gammabb*t
     9         218*t227-1.369767625290079d-2*t109*t211
            t464 = -2.5d-1*t229*t304*t417
            t465 = 5.0d-1*t230*t462
            t466 = t465+t464
            t467 = -2.5d-1*t229*t304*t423
            t468 = 5.0d-1*t235*t462
            t469 = -2.5d-1*t229*t304*t429
            t470 = 5.0d-1*t242*t462
            t471 = t470+t469+t468+t467
            t472 = 1/t104**7
            t473 = 4.2759414617680735d-2*t1*t261*t304*t98-1.282782438530
     1         422d-1*t1*t261*t462*t78+1.924173657795633d-1*t1*t226*t304
     2         *t322*t78
            t474 = -1.282782438530422d-1*t1*t226*t261*t304*t78+t102*t473
     1         +t106*t462+t262*t304
            t475 = t272**2
            t476 = t270**2
            t477 = -1.6318099605766218d-5*gammaaa*t9+1.5381613168123123d
     1         -6*t14*t7+2.2334661703788317d-4*t11*t5+1.757099301577467d
     2         -2*t15*t269-1.7103306183365155d-1*t23/t14-6.7796055405316
     3         17d-8*t12*t21+4.960151517799245d-9*t10*t19-2.767412939521
     4         305d-3*t13
            t478 = -2.5966064381852805d-6*gammaaa*t9+2.1108351466733477d
     1         -7*t14*t7+1.9882861150621498d-5*t11*t5+1.3504134850155614
     2         d-4*t15*t269-8.684798200538004d-5*t13
            t479 = 1.6455307846020562d-2*gammaaa*t16*t25*t478-1.64553078
     1         46020562d-2*gammaaa*t16*t163*t17*t477+3.2910615692041123d
     2         -2*gammaaa*t16*t17*t338*t476-3.2910615692041123d-2*gammaa
     3         a*t16*t163*t270*t271+3.2910615692041123d-2*t16*t25*t271-3
     4         .2910615692041123d-2*t16*t163*t17*t270
            t480 = 1.7386021048962136d-7*gammaaa*t353*t9+6.9344486030310
     1         25d-2*gammaaa*t16*t25*t478-6.934448603031025d-2*gammaaa*t
     2         16*t163*t17*t477+1.386889720606205d-1*gammaaa*t16*t17*t33
     3         8*t476-1.386889720606205d-1*gammaaa*t16*t163*t270*t271+1.
     4         386889720606205d-1*t16*t25*t271-1.386889720606205d-1*t16*
     5         t163*t17*t270-4.226240240936398d-5*t13*t168
            t481 = 1/t44
            t482 = -2.5d-1*t368*t475
            t483 = 5.0d-1*t176*t479
            t484 = -2.5d-1*t362*t475
            t485 = 5.0d-1*t171*t479
            t486 = t288**2
            t487 = -2.5d-1*t374*t475
            t488 = 5.0d-1*t183*t479
            t489 = t488+t487+t483+t482
            t490 = t31*t479-1.282782438530422d-1*t1*t3*t30*t479-6.413912
     1         19265211d-2*t1*t202*t3*t475
            t491 = t304**2
            t492 = t302**2
            t493 = -1.7103306183365155d-1*t98/t89-6.779605540531617d-8*t
     1         87*t96+4.960151517799245d-9*t85*t94+1.757099301577467d-2*
     2         t301*t90+1.5381613168123123d-6*t82*t89-2.767412939521305d
     3         -3*t88+2.2334661703788317d-4*t80*t86-1.6318099605766218d-
     4         5*gammabb*t84
            t494 = 1.3504134850155614d-4*t301*t90+2.1108351466733477d-7*
     1         t82*t89-8.684798200538004d-5*t88+1.9882861150621498d-5*t8
     2         0*t86-2.5966064381852805d-6*gammabb*t84
            t495 = -1.6455307846020562d-2*gammabb*t222*t493*t91*t92+3.29
     1         10615692041123d-2*gammabb*t393*t492*t91*t92-3.29106156920
     2         41123d-2*t222*t302*t91*t92+1.6455307846020562d-2*gammabb*
     3         t100*t494*t91-3.2910615692041123d-2*gammabb*t222*t302*t30
     4         3*t91+3.2910615692041123d-2*t100*t303*t91
            t496 = -6.934448603031025d-2*gammabb*t222*t493*t91*t92+1.386
     1         889720606205d-1*gammabb*t393*t492*t91*t92-1.3868897206062
     2         05d-1*t222*t302*t91*t92+6.934448603031025d-2*gammabb*t100
     3         *t494*t91-1.386889720606205d-1*gammabb*t222*t302*t303*t91
     4         +1.386889720606205d-1*t100*t303*t91-4.226240240936398d-5*
     5         t227*t88+1.7386021048962136d-7*gammabb*t408*t84
            t497 = 1/t118
            t498 = -2.5d-1*t423*t491
            t499 = 5.0d-1*t235*t495
            t500 = -2.5d-1*t417*t491
            t501 = 5.0d-1*t230*t495
            t502 = t320**2
            t503 = -2.5d-1*t429*t491
            t504 = 5.0d-1*t242*t495
            t505 = t504+t503+t499+t498
            t506 = -1.282782438530422d-1*t1*t105*t495*t78-6.413912192652
     1         11d-2*t1*t261*t491*t78+t106*t495
            fnc(iq) = (-9.305257363491d-1*t150*t97-9.305257363491d-1*t22
     1         *t76)*wght+fnc(iq)
            Amat(iq,D1_RA) = (-1.2407009817987999d+0*t2*t76-9.3052573634
     1         91d-1*t209*t22)*wght+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = (-9.305257363491d-1*t268*t97-1.240700981798
     1         7999d+0*t150*t77)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-9.305257363491d-1*t22*(t30
     1         0*t73+t294+t292+t291+t289+t287+t283+t16*t25*t282+t281+t27
     2         6+t275+t273)*wght
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)-9.305257363491d-1*(t100*t3
     1         14*t91+t147*t332+t326+t324+t323+t321+t319+t315+t313+t308+
     2         t307+t305)*t97*wght
            Amat2(iq,D2_RA_RA) = (-4.135669939329333d-1*t40*t76-9.305257
     1         363491d-1*t22*(-8.888888888888888d-1*(-2.1d+1*t382*t383*t
     2         71-8.400000000000001d+0*t195*t371*t71-2.4d+0*(2.5d-1*t382
     3         *t385-3.206956096326055d-2*t198**2*t384-5.0d-1*t196*t371+
     4         6.41391219265211d-2*t197*(gammaaa*t16*t25*t348-gammaaa*t1
     5         6*t163*t17*t345+2*gammaaa*t16*t17*t337*t338+9.77777777777
     6         7779d+0*gammaaa*t17*t25*t333-5.333333333333333d+0*gammaaa
     7         *t152*t165*t25+5.333333333333333d+0*gammaaa*t152*t162*t16
     8         3*t17-2*gammaaa*t16*t162*t163*t165))*t68-2.7259596d+0*t37
     9         1*t67-5.4519192d+0*t382*t66+5.672746666666666d-2*t371*t66
     :         +4.7459599999999996d-2*t354*t66-1.2407176956338616d+1*t38
     ;         2*t383+5.672746666666666d-2*t382+4.7459599999999996d-2*t3
     <         5*t371-4.9628707825354457d+0*t195*t371-1.68d+1*t182*t195*
     =         t199+9.491919999999999d-2*t169*t182)*t73*t75+2.6666666666
     >         666666d+0*t208*t387*t72*t75-1.0666666666666666d+1*t356*t3
     ?         57*t72*t75+5.333333333333333d+0*t200*t207*t208*t75-8.8888
     @         88888888888d-1*(4.9365923538061685d-2*t1*t3*t30*(7.5d-1*t
     1         1*t290*t3*t352-5.0d-1*t1*t202*t3*t350+4.444444444444444d-
     2         1*t1*t161*t30+3.333333333333333d-1*t1*t167*t202*t23)+2.16
     3         4695365020087d-1*t1*t290*t3*t352-1.4431302433467247d-1*t1
     4         *t202*t3*t350+1.2827824385304218d-1*t1*t161*t30+9.6208682
     5         88978164d-2*t1*t167*t202*t23+4.9365923538061685d-2*t205**
     6         2)*t72*t73-1.0546577777777776d-1*t35*t36*t387*t73-2.10931
     7         5555555555d-1*t169*t207*t36*t73-2.109315555555555d-1*t204
     8         *t207*t35*t73-1.7777777777777776d+0*t200*t206*t73+5.33333
     9         3333333333d+0*t206*t207*t208*t72+7.57211d-1*(1.6455307846
     :         020562d-2*gammaaa*t16*t25*t348*t61*t65-1.6455307846020562
     ;         d-2*gammaaa*t16*t163*t17*t345*t61*t65+3.2910615692041123d
     <         -2*gammaaa*t16*t17*t337*t338*t61*t65+1.6089634338331216d-
     =         1*gammaaa*t17*t25*t333*t61*t65-8.7761641845443d-2*gammaaa
     >         *t152*t165*t25*t61*t65+8.7761641845443d-2*gammaaa*t152*t1
     ?         62*t163*t17*t61*t65-3.2910615692041123d-2*gammaaa*t16*t16
     @         2*t163*t165*t61*t65-1.6455307846020562d-2*gammaaa*t16*t17
     1         *t192*t25*t380*t65+3.2910615692041123d-2*gammaaa*t16*t17*
     2         t25*t378*t379*t65+8.7761641845443d-2*gammaaa*t152*t17*t19
     3         1*t192*t25*t65-3.2910615692041123d-2*gammaaa*t16*t165*t19
     4         1*t192*t25*t65+3.2910615692041123d-2*gammaaa*t16*t162*t16
     5         3*t17*t191*t192*t65+t371*t61*t63-t192*t380*t59*t63+2*t378
     6         *t379*t59*t63-2*t182*t191*t192*t63+2*t189**2*t377*t59*t61
     7         -t190*(t376+t375+t365)*t59*t61+3.2910615692041123d-2*gamm
     8         aaa*t16*t17*t193**2*t25*t381*t61-1.6455307846020562d-2*ga
     9         mmaaa*t16*t17*t194*t25*(t370+t369+t365)*t61+8.77616418454
     :         43d-2*gammaaa*t152*t17*t193*t194*t25*t61-3.29106156920411
     ;         23d-2*gammaaa*t16*t165*t193*t194*t25*t61+3.29106156920411
     <         23d-2*gammaaa*t16*t162*t163*t17*t193*t194*t61-2*t182*t189
     =         *t190*t61+2*t189*t190*t191*t192*t59+3.2910615692041123d-2
     >         *gammaaa*t16*t17*t191*t192*t193*t194*t25)-2.0d+0*t188*(-1
     ?         .475609999999999d-1*t175*t366*t56+2.951219999999998d-1*t3
     @         59*t360*t56-1.475609999999999d-1*t186*(t376+t375+t364+t36
     1         3)*t50+2.951219999999998d-1*t185**2*t373*t50+2.9512199999
     2         99998d-1*t174*t175*t185*t186)*t59+2.0d+0*t187**2*t372*t59
     3         -2.0d+0*t371*t58+3.2910615692041123d-2*gammaaa*t16*t25*t3
     4         48*t52-3.2910615692041123d-2*gammaaa*t16*t163*t17*t345*t5
     5         2+6.582123138408225d-2*gammaaa*t16*t17*t337*t338*t52+3.21
     6         7926867666243d-1*gammaaa*t17*t25*t333*t52-1.7552328369088
     7         6d-1*gammaaa*t152*t165*t25*t52+1.75523283690886d-1*gammaa
     8         a*t152*t162*t163*t17*t52-6.582123138408225d-2*gammaaa*t16
     9         *t162*t163*t165*t52+3.2910615692041123d-2*gammaaa*t16*t17
     :         *t181*t25*(6.0965d-1*t179*(t370+t369+t364+t363)*t50-1.219
     ;         3000000000001d+0*t178**2*t367*t50+6.0965d-1*t175*t366*t47
     <         -1.2193000000000001d+0*t359*t360*t47-1.2193000000000001d+
     =         0*t174*t175*t178*t179)-4.727288888888889d-2*t201*t28*t386
     >         +5.273288888888887d-2*t354*t36*t38+5.273288888888887d-2*t
     ?         35*(9.620868288978166d-2*t1*t290*t3*t352-6.41391219265211
     @         d-2*t1*t202*t3*t350+5.701255282357431d-2*t1*t161*t30+4.27
     1         59414617680735d-2*t1*t167*t202*t23)*t38+1.054657777777777
     2         6d-1*t169*t204*t38+3.1639733333333325d-1*t208*t35*t356*t3
     3         6-3.2910615692041123d-2*gammaaa*t16*t17*t180**2*t25*t358+
     4         9.454577777777778d-2*t203**2*t28*t355+9.454577777777778d-
     5         2*t32*t351*t352-4.727288888888889d-2*t151*t32*t350-1.7552
     6         3283690886d-1*gammaaa*t152*t17*t180*t181*t25+6.5821231384
     7         08225d-2*gammaaa*t16*t165*t180*t181*t25+9.454577777777778
     8         d-2*t151*t167*t201*t203-4.0d+0*t182*t187*t188-6.582123138
     9         408225d-2*gammaaa*t16*t162*t163*t17*t180*t181)-2.48140196
     :         35975998d+0*t2*t209)*wght+Amat2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = (-9.305257363491d-1*t97*(-8.88888888888
     1         8888d-1*t146*t147*(4.9365923538061685d-2*t1*t105*t78*(3.3
     2         33333333333333d-1*t1*t226*t261*t98+7.5d-1*t1*t322*t407*t7
     3         8-5.0d-1*t1*t261*t405*t78+4.444444444444444d-1*t1*t105*t2
     4         20)+9.620868288978164d-2*t1*t226*t261*t98+2.1646953650200
     5         87d-1*t1*t322*t407*t78-1.4431302433467247d-1*t1*t261*t405
     6         *t78+4.9365923538061685d-2*t264**2+1.2827824385304218d-1*
     7         t1*t105*t220)+5.273288888888887d-2*t110*t113*(4.275941461
     8         7680735d-2*t1*t226*t261*t98+9.620868288978166d-2*t1*t322*
     9         t407*t78-6.41391219265211d-2*t1*t261*t405*t78+5.701255282
     :         357431d-2*t1*t105*t220)-8.888888888888888d-1*t147*t149*(-
     ;         2.4d+0*t142*(6.41391219265211d-2*t256*(-gammabb*t222*t400
     <         *t91*t92+2*gammabb*t392*t393*t91*t92+9.777777777777779d+0
     =         *gammabb*t100*t388*t92+5.333333333333333d+0*gammabb*t211*
     >         t221*t222*t92+gammabb*t100*t403*t91-2*gammabb*t221*t222*t
     ?         224*t91-5.333333333333333d+0*gammabb*t100*t211*t224)+2.5d
     @         -1*t437*t440-3.206956096326055d-2*t257**2*t439-5.0d-1*t25
     1         5*t426)-2.1d+1*t145*t437*t438-1.2407176956338616d+1*t437*
     2         t438-5.4519192d+0*t140*t437+5.672746666666666d-2*t437-8.4
     3         00000000000001d+0*t145*t254*t426-4.9628707825354457d+0*t2
     4         54*t426-2.7259596d+0*t141*t426+5.672746666666666d-2*t140*
     5         t426+4.7459599999999996d-2*t110*t426+4.7459599999999996d-
     6         2*t140*t409-1.68d+1*t241*t254*t258+9.491919999999999d-2*t
     7         228*t241)+7.57211d-1*(3.2910615692041123d-2*gammabb*t100*
     8         t135*t252**2*t436*t91*t92-1.6455307846020562d-2*gammabb*t
     9         100*t139*t251*t435*t91*t92+3.2910615692041123d-2*gammabb*
     :         t100*t139*t433*t434*t91*t92-1.6455307846020562d-2*gammabb
     ;         *t100*t135*t253*(t425+t424+t420)*t91*t92-1.64553078460205
     <         62d-2*gammabb*t135*t139*t222*t400*t91*t92+3.2910615692041
     =         123d-2*gammabb*t135*t139*t392*t393*t91*t92+3.291061569204
     >         1123d-2*gammabb*t100*t250*t251*t252*t253*t91*t92+3.291061
     ?         5692041123d-2*gammabb*t135*t221*t222*t252*t253*t91*t92+3.
     @         2910615692041123d-2*gammabb*t139*t221*t222*t250*t251*t91*
     1         t92+1.6089634338331216d-1*gammabb*t100*t135*t139*t388*t92
     2         +8.7761641845443d-2*gammabb*t100*t135*t211*t252*t253*t92+
     3         8.7761641845443d-2*gammabb*t100*t139*t211*t250*t251*t92+8
     4         .7761641845443d-2*gammabb*t135*t139*t211*t221*t222*t92+1.
     5         6455307846020562d-2*gammabb*t100*t135*t139*t403*t91-3.291
     6         0615692041123d-2*gammabb*t100*t135*t224*t252*t253*t91-3.2
     7         910615692041123d-2*gammabb*t100*t139*t224*t250*t251*t91-3
     8         .2910615692041123d-2*gammabb*t135*t139*t221*t222*t224*t91
     9         -t133*t137*t251*t435+2*t133*t137*t433*t434+2*t133*t135*t2
     :         48**2*t432-t133*t135*t249*(t431+t430+t420)+t135*t137*t426
     ;         +2*t133*t248*t249*t250*t251-2*t137*t241*t250*t251-2*t135*
     <         t241*t248*t249-8.7761641845443d-2*gammabb*t100*t135*t139*
     =         t211*t224)+3.2910615692041123d-2*gammabb*t100*t240*(6.096
     >         5d-1*t124*t238*(t425+t424+t419+t418)-1.2193000000000001d+
     ?         0*t124*t237**2*t422+6.0965d-1*t121*t234*t421-1.2193000000
     @         000001d+0*t121*t414*t415-1.2193000000000001d+0*t233*t234*
     1         t237*t238)*t91*t92-3.2910615692041123d-2*gammabb*t100*t23
     2         9**2*t413*t91*t92-3.2910615692041123d-2*gammabb*t126*t222
     3         *t400*t91*t92+6.582123138408225d-2*gammabb*t126*t392*t393
     4         *t91*t92-6.582123138408225d-2*gammabb*t221*t222*t239*t240
     5         *t91*t92+3.217926867666243d-1*gammabb*t100*t126*t388*t92-
     6         1.75523283690886d-1*gammabb*t100*t211*t239*t240*t92+1.755
     7         23283690886d-1*gammabb*t126*t211*t221*t222*t92+3.29106156
     8         92041123d-2*gammabb*t100*t126*t403*t91+6.582123138408225d
     9         -2*gammabb*t100*t224*t239*t240*t91-6.582123138408225d-2*g
     :         ammabb*t126*t221*t222*t224*t91+2.6666666666666666d+0*t146
     ;         *t149*t267*t442-1.0546577777777776d-1*t110*t111*t147*t442
     <         -4.727288888888889d-2*t103*t260*t441-2.0d+0*t133*t247*(-1
     =         .475609999999999d-1*t124*t245*(t431+t430+t419+t418)+2.951
     >         219999999998d-1*t124*t244**2*t428-1.475609999999999d-1*t1
     ?         30*t234*t421+2.951219999999998d-1*t130*t414*t415+2.951219
     @         999999998d-1*t233*t234*t244*t245)+2.0d+0*t133*t246**2*t42
     1         7-2.0d+0*t132*t426-1.0666666666666666d+1*t146*t149*t411*t
     2         412+3.1639733333333325d-1*t110*t111*t267*t411+9.454577777
     3         777778d-2*t103*t262**2*t410+5.273288888888887d-2*t111*t11
     4         3*t409+9.454577777777778d-2*t107*t406*t407-4.727288888888
     5         889d-2*t107*t210*t405+5.333333333333333d+0*t146*t265*t266
     6         *t267+5.333333333333333d+0*t149*t259*t266*t267-2.10931555
     7         5555555d-1*t110*t147*t263*t266-2.109315555555555d-1*t111*
     8         t147*t228*t266-1.7777777777777776d+0*t147*t259*t265+1.054
     9         6577777777776d-1*t113*t228*t263+9.454577777777778d-2*t210
     :         *t226*t260*t262-4.0d+0*t241*t246*t247-1.75523283690886d-1
     ;         *gammabb*t100*t126*t211*t224)-2.4814019635975998d+0*t268*
     <         t77-4.135669939329333d-1*t114*t150)*wght+Amat2(iq,D2_RB_R
     =         B)
            Cmat2(iq,D2_RA_GAA) = (-9.305257363491d-1*t22*(-8.8888888888
     1         88888d-1*(-8.400000000000001d+0*t195*t446*t71-2.1d+1*t182
     2         *t272*t383*t71-2.4d+0*(-5.0d-1*t196*t446+6.41391219265211
     3         d-2*t197*(gammaaa*t16*t25*t445-gammaaa*t16*t163*t17*t444+
     4         2*gammaaa*t16*t162*t17*t270*t338-2.6666666666666666d+0*ga
     5         mmaaa*t152*t25*t271-gammaaa*t16*t162*t163*t271+2.66666666
     6         66666666d+0*gammaaa*t152*t163*t17*t270-gammaaa*t16*t163*t
     7         165*t270-2.6666666666666666d+0*t152*t17*t25+t16*t165*t25-
     8         t16*t162*t163*t17)+2.5d-1*t182*t272*t385-3.20695609632605
     9         5d-2*t198*t297*t384)*t68-2.7259596d+0*t446*t67+4.74595999
     :         99999996d-2*t447*t66+5.672746666666666d-2*t446*t66-5.4519
     ;         192d+0*t182*t272*t66+4.7459599999999996d-2*t35*t446-4.962
     <         8707825354457d+0*t195*t446-1.2407176956338616d+1*t182*t27
     =         2*t383-8.400000000000001d+0*t182*t195*t298+4.745959999999
     >         9996d-2*t182*t274-8.400000000000001d+0*t195*t199*t272+5.6
     ?         72746666666666d-2*t182*t272+4.7459599999999996d-2*t169*t2
     @         72)*t73*t75+2.6666666666666666d+0*t208*t458*t72*t75-1.066
     1         6666666666666d+1*t207*t293*t357*t72*t75+2.666666666666666
     2         6d+0*t207*t208*t299*t75+2.6666666666666666d+0*t200*t208*t
     3         293*t75-8.888888888888888d-1*(4.9365923538061685d-2*t1*t3
     4         *t30*(-5.0d-1*t1*t202*t3*t446+7.5d-1*t1*t167*t272*t290*t3
     5         +1.6666666666666666d-1*t1*t202*t23*t272)-1.44313024334672
     6         47d-1*t1*t202*t3*t446+2.164695365020087d-1*t1*t167*t272*t
     7         290*t3-2.4682961769030842d-2*t1*t202*t205*t272*t3+4.81043
     8         4144489082d-2*t1*t202*t23*t272)*t72*t73-1.054657777777777
     9         6d-1*t35*t36*t458*t73-8.888888888888888d-1*t200*t443*t73-
     :         1.0546577777777776d-1*t169*t293*t36*t73-1.054657777777777
     ;         6d-1*t207*t274*t36*t73+6.764482379964267d-3*t1*t202*t207*
     <         t272*t3*t35*t73-1.0546577777777776d-1*t204*t293*t35*t73-8
     =         .888888888888888d-1*t206*t299*t73+2.6666666666666666d+0*t
     >         207*t208*t443*t72+2.6666666666666666d+0*t206*t208*t293*t7
     ?         2+7.57211d-1*(1.6455307846020562d-2*gammaaa*t16*t25*t445*
     @         t61*t65-1.6455307846020562d-2*gammaaa*t16*t163*t17*t444*t
     1         61*t65+3.2910615692041123d-2*gammaaa*t16*t162*t17*t270*t3
     2         38*t61*t65-4.38808209227215d-2*gammaaa*t152*t25*t271*t61*
     3         t65-1.6455307846020562d-2*gammaaa*t16*t162*t163*t271*t61*
     4         t65+4.38808209227215d-2*gammaaa*t152*t163*t17*t270*t61*t6
     5         5-1.6455307846020562d-2*gammaaa*t16*t163*t165*t270*t61*t6
     6         5-4.38808209227215d-2*t152*t17*t25*t61*t65+1.645530784602
     7         0562d-2*t16*t165*t25*t61*t65-1.6455307846020562d-2*t16*t1
     8         62*t163*t17*t61*t65-1.6455307846020562d-2*gammaaa*t16*t17
     9         *t192*t25*t455*t65+3.2910615692041123d-2*gammaaa*t16*t17*
     :         t191*t25*t288*t379*t65+4.38808209227215d-2*gammaaa*t152*t
     ;         17*t192*t25*t288*t65-1.6455307846020562d-2*gammaaa*t16*t1
     <         65*t192*t25*t288*t65+1.6455307846020562d-2*gammaaa*t16*t1
     =         62*t163*t17*t192*t288*t65-1.6455307846020562d-2*gammaaa*t
     >         16*t191*t192*t25*t271*t65+1.6455307846020562d-2*gammaaa*t
     ?         16*t163*t17*t191*t192*t270*t65-1.6455307846020562d-2*t16*
     @         t17*t191*t192*t25*t65+t446*t61*t63-t192*t455*t59*t63+2*t1
     1         91*t288*t379*t59*t63-t182*t192*t288*t63-t191*t192*t272*t6
     2         3-t190*(t454+t453)*t59*t61+t183*t189*t272*t377*t59*t61-1.
     3         6455307846020562d-2*gammaaa*t16*t17*t194*t25*(t452+t451)*
     4         t61+1.6455307846020562d-2*gammaaa*t16*t17*t176*t193*t25*t
     5         272*t381*t61+2.194041046136075d-2*gammaaa*t152*t17*t176*t
     6         194*t25*t272*t61-8.227653923010281d-3*gammaaa*t16*t165*t1
     7         76*t194*t25*t272*t61+8.227653923010281d-3*gammaaa*t16*t16
     8         2*t163*t17*t176*t194*t272*t61-t189*t190*t272*t61-5.0d-1*t
     9         182*t183*t190*t272*t61-1.6455307846020562d-2*gammaaa*t16*
     :         t193*t194*t25*t271*t61+1.6455307846020562d-2*gammaaa*t16*
     ;         t163*t17*t193*t194*t270*t61-1.6455307846020562d-2*t16*t17
     <         *t193*t194*t25*t61+t189*t190*t192*t288*t59+5.0d-1*t183*t1
     =         90*t191*t192*t272*t59+1.6455307846020562d-2*gammaaa*t16*t
     >         17*t192*t193*t194*t25*t288+8.227653923010281d-3*gammaaa*t
     ?         16*t17*t176*t191*t192*t194*t25*t272)-2.0d+0*t188*(-1.4756
     @         09999999999d-1*t175*t450*t56+1.475609999999999d-1*t171*t1
     1         74*t272*t360*t56-1.475609999999999d-1*t186*(t454+t453+t44
     2         9+t448)*t50+2.951219999999998d-1*t185*t285*t373*t50+1.475
     3         609999999999d-1*t174*t175*t186*t285+7.378049999999994d-2*
     4         t171*t175*t185*t186*t272)*t59+2.0d+0*t187*t286*t372*t59-2
     5         .0d+0*t446*t58+3.2910615692041123d-2*gammaaa*t16*t25*t445
     6         *t52-3.2910615692041123d-2*gammaaa*t16*t163*t17*t444*t52+
     7         6.582123138408225d-2*gammaaa*t16*t162*t17*t270*t338*t52-8
     8         .7761641845443d-2*gammaaa*t152*t25*t271*t52-3.29106156920
     9         41123d-2*gammaaa*t16*t162*t163*t271*t52+8.7761641845443d-
     :         2*gammaaa*t152*t163*t17*t270*t52-3.2910615692041123d-2*ga
     ;         mmaaa*t16*t163*t165*t270*t52-8.7761641845443d-2*t152*t17*
     <         t25*t52+3.2910615692041123d-2*t16*t165*t25*t52-3.29106156
     =         92041123d-2*t16*t162*t163*t17*t52+3.2910615692041123d-2*g
     >         ammaaa*t16*t17*t181*t25*(6.0965d-1*t179*(t452+t451+t449+t
     ?         448)*t50-1.2193000000000001d+0*t178*t279*t367*t50+6.0965d
     @         -1*t175*t450*t47-6.0965d-1*t171*t174*t272*t360*t47-6.0965
     1         d-1*t174*t175*t179*t279-3.04825d-1*t171*t175*t178*t179*t2
     2         72)-4.727288888888889d-2*t201*t28*t457-6.064083168526658d
     3         -3*t1*t167*t201*t272*t3*t456+5.273288888888887d-2*t36*t38
     4         *t447+5.273288888888887d-2*t35*t38*(-6.41391219265211d-2*
     5         t1*t202*t3*t446+9.620868288978166d-2*t1*t167*t272*t290*t3
     6         +2.1379707308840368d-2*t1*t202*t23*t272)-4.72728888888888
     7         9d-2*t151*t32*t446-3.3822411899821336d-3*t1*t169*t202*t27
     8         2*t3*t38+5.273288888888887d-2*t204*t274*t38+3.16397333333
     9         33325d-1*t207*t208*t293*t35*t36-3.2910615692041123d-2*gam
     :         maaa*t16*t17*t180*t25*t280*t358-1.2128166337053317d-2*t1*
     ;         t203*t272*t290*t3*t355+9.454577777777778d-2*t167*t272*t32
     <         *t351-2.0d+0*t182*t188*t286-8.7761641845443d-2*gammaaa*t1
     =         52*t17*t181*t25*t280+3.2910615692041123d-2*gammaaa*t16*t1
     >         65*t181*t25*t280-3.2910615692041123d-2*gammaaa*t16*t162*t
     ?         163*t17*t181*t280+4.727288888888889d-2*t151*t201*t203*t27
     @         2-2.0d+0*t187*t188*t272+3.2910615692041123d-2*gammaaa*t16
     1         *t180*t181*t25*t271-3.2910615692041123d-2*gammaaa*t16*t16
     2         3*t17*t180*t181*t270+3.2910615692041123d-2*t16*t17*t180*t
     3         181*t25)-1.2407009817987999d+0*t2*(-8.888888888888888d-1*
     4         t299*t73*t75-8.888888888888888d-1*t443*t72*t73-1.05465777
     5         77777776d-1*t293*t35*t36*t73+3.2910615692041123d-2*gammaa
     6         a*t16*t25*t271*t52+3.2910615692041123d-2*t16*t17*t25*t52+
     7         t294+t292+t291+t289+t287+t283+t281+t276+t275+t273))*wght+
     8         Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
            Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = (-9.305257363491d-1*t97*(-8.8888888888
     1         88888d-1*t146*t147*(4.9365923538061685d-2*t1*t105*t78*(1.
     2         6666666666666666d-1*t1*t261*t304*t98-5.0d-1*t1*t261*t462*
     3         t78+7.5d-1*t1*t226*t304*t322*t78)+4.810434144489082d-2*t1
     4         *t261*t304*t98-1.4431302433467247d-1*t1*t261*t462*t78+2.1
     5         64695365020087d-1*t1*t226*t304*t322*t78-2.468296176903084
     6         2d-2*t1*t261*t264*t304*t78)+5.273288888888887d-2*t110*t11
     7         3*(2.1379707308840368d-2*t1*t261*t304*t98-6.4139121926521
     8         1d-2*t1*t261*t462*t78+9.620868288978166d-2*t1*t226*t304*t
     9         322*t78)-8.888888888888888d-1*t147*t149*(-2.4d+0*t142*(6.
     :         41391219265211d-2*t256*(-gammabb*t222*t460*t91*t92+2*gamm
     ;         abb*t221*t302*t393*t91*t92-t221*t222*t91*t92+2.6666666666
     <         666666d+0*gammabb*t211*t222*t302*t92-2.6666666666666666d+
     =         0*t100*t211*t92+gammabb*t100*t461*t91-gammabb*t221*t222*t
     >         303*t91-gammabb*t222*t224*t302*t91+t100*t224*t91-2.666666
     ?         6666666666d+0*gammabb*t100*t211*t303)-5.0d-1*t255*t462+2.
     @         5d-1*t241*t304*t440-3.206956096326055d-2*t257*t329*t439)+
     1         4.7459599999999996d-2*t140*t463-8.400000000000001d+0*t145
     2         *t254*t462-4.9628707825354457d+0*t254*t462-2.7259596d+0*t
     3         141*t462+5.672746666666666d-2*t140*t462+4.745959999999999
     4         6d-2*t110*t462-2.1d+1*t145*t241*t304*t438-1.2407176956338
     5         616d+1*t241*t304*t438-8.400000000000001d+0*t241*t254*t330
     6         +4.7459599999999996d-2*t241*t306-8.400000000000001d+0*t25
     7         4*t258*t304-5.4519192d+0*t140*t241*t304+5.672746666666666
     8         d-2*t241*t304+4.7459599999999996d-2*t228*t304)+7.57211d-1
     9         *(-1.6455307846020562d-2*gammabb*t100*t139*t251*t471*t91*
     :         t92-1.6455307846020562d-2*gammabb*t100*t135*t253*(t468+t4
     ;         67)*t91*t92-1.6455307846020562d-2*gammabb*t135*t139*t222*
     <         t460*t91*t92+1.6455307846020562d-2*gammabb*t100*t135*t235
     =         *t252*t304*t436*t91*t92+3.2910615692041123d-2*gammabb*t10
     >         0*t139*t250*t320*t434*t91*t92+3.2910615692041123d-2*gamma
     ?         bb*t135*t139*t221*t302*t393*t91*t92+1.6455307846020562d-2
     @         *gammabb*t100*t251*t252*t253*t320*t91*t92+1.6455307846020
     1         562d-2*gammabb*t139*t221*t222*t251*t320*t91*t92+8.2276539
     2         23010281d-3*gammabb*t100*t235*t250*t251*t253*t304*t91*t92
     3         +8.227653923010281d-3*gammabb*t135*t221*t222*t235*t253*t3
     4         04*t91*t92+1.6455307846020562d-2*gammabb*t135*t222*t252*t
     5         253*t302*t91*t92+1.6455307846020562d-2*gammabb*t139*t222*
     6         t250*t251*t302*t91*t92-1.6455307846020562d-2*t100*t135*t2
     7         52*t253*t91*t92-1.6455307846020562d-2*t100*t139*t250*t251
     8         *t91*t92-1.6455307846020562d-2*t135*t139*t221*t222*t91*t9
     9         2+4.38808209227215d-2*gammabb*t100*t139*t211*t251*t320*t9
     :         2+2.194041046136075d-2*gammabb*t100*t135*t211*t235*t253*t
     ;         304*t92+4.38808209227215d-2*gammabb*t135*t139*t211*t222*t
     <         302*t92-4.38808209227215d-2*t100*t135*t139*t211*t92+1.645
     =         5307846020562d-2*gammabb*t100*t135*t139*t461*t91-1.645530
     >         7846020562d-2*gammabb*t100*t139*t224*t251*t320*t91-8.2276
     ?         53923010281d-3*gammabb*t100*t135*t224*t235*t253*t304*t91-
     @         1.6455307846020562d-2*gammabb*t100*t135*t252*t253*t303*t9
     1         1-1.6455307846020562d-2*gammabb*t100*t139*t250*t251*t303*
     2         t91-1.6455307846020562d-2*gammabb*t135*t139*t221*t222*t30
     3         3*t91-1.6455307846020562d-2*gammabb*t135*t139*t222*t224*t
     4         302*t91+1.6455307846020562d-2*t100*t135*t139*t224*t91-t13
     5         3*t137*t251*t471-t133*t135*t249*(t470+t469)+t135*t137*t46
     6         2+2*t133*t137*t250*t320*t434+t133*t135*t242*t248*t304*t43
     7         2+t133*t248*t249*t251*t320-t137*t241*t251*t320+5.0d-1*t13
     8         3*t242*t249*t250*t251*t304-t137*t250*t251*t304-t135*t248*
     9         t249*t304-5.0d-1*t135*t241*t242*t249*t304-4.3880820922721
     :         5d-2*gammabb*t100*t135*t139*t211*t303)+3.2910615692041123
     ;         d-2*gammabb*t100*t240*(6.0965d-1*t124*t238*(t468+t467+t46
     <         5+t464)+6.0965d-1*t121*t234*t466-1.2193000000000001d+0*t1
     =         24*t237*t311*t422-6.0965d-1*t121*t230*t233*t304*t415-6.09
     >         65d-1*t233*t234*t238*t311-3.04825d-1*t230*t234*t237*t238*
     ?         t304)*t91*t92-3.2910615692041123d-2*gammabb*t126*t222*t46
     @         0*t91*t92-3.2910615692041123d-2*gammabb*t100*t239*t312*t4
     1         13*t91*t92+6.582123138408225d-2*gammabb*t126*t221*t302*t3
     2         93*t91*t92-3.2910615692041123d-2*gammabb*t221*t222*t240*t
     3         312*t91*t92-3.2910615692041123d-2*gammabb*t222*t239*t240*
     4         t302*t91*t92+3.2910615692041123d-2*t100*t239*t240*t91*t92
     5         -3.2910615692041123d-2*t126*t221*t222*t91*t92-8.776164184
     6         5443d-2*gammabb*t100*t211*t240*t312*t92+8.7761641845443d-
     7         2*gammabb*t126*t211*t222*t302*t92-8.7761641845443d-2*t100
     8         *t126*t211*t92+3.2910615692041123d-2*gammabb*t100*t126*t4
     9         61*t91+3.2910615692041123d-2*gammabb*t100*t224*t240*t312*
     :         t91+3.2910615692041123d-2*gammabb*t100*t239*t240*t303*t91
     ;         -3.2910615692041123d-2*gammabb*t126*t221*t222*t303*t91-3.
     <         2910615692041123d-2*gammabb*t126*t222*t224*t302*t91+3.291
     =         0615692041123d-2*t100*t126*t224*t91-6.064083168526658d-3*
     >         t1*t226*t260*t304*t472*t78-1.2128166337053317d-2*t1*t262*
     ?         t304*t322*t410*t78+6.764482379964267d-3*t1*t110*t147*t261
     @         *t266*t304*t78-3.3822411899821336d-3*t1*t113*t228*t261*t3
     1         04*t78+2.6666666666666666d+0*t146*t149*t267*t474-1.054657
     2         7777777776d-1*t110*t111*t147*t474-4.727288888888889d-2*t1
     3         03*t260*t473-2.0d+0*t133*t247*(-1.475609999999999d-1*t124
     4         *t245*(t470+t469+t465+t464)-1.475609999999999d-1*t130*t23
     5         4*t466+2.951219999999998d-1*t124*t244*t317*t428+1.4756099
     6         99999999d-1*t130*t230*t233*t304*t415+1.475609999999999d-1
     7         *t233*t234*t245*t317+7.378049999999994d-2*t230*t234*t244*
     8         t245*t304)+5.273288888888887d-2*t111*t113*t463-4.72728888
     9         8888889d-2*t107*t210*t462-2.0d+0*t132*t462+2.666666666666
     :         6666d+0*t146*t266*t267*t459-8.888888888888888d-1*t147*t25
     ;         9*t459+2.0d+0*t133*t246*t318*t427-1.0666666666666666d+1*t
     <         146*t149*t266*t325*t412+9.454577777777778d-2*t107*t226*t3
     =         04*t406+2.6666666666666666d+0*t149*t266*t267*t331-8.88888
     >         8888888888d-1*t147*t265*t331+3.1639733333333325d-1*t110*t
     ?         111*t266*t267*t325+2.6666666666666666d+0*t146*t265*t267*t
     @         325+2.6666666666666666d+0*t149*t259*t267*t325-1.054657777
     1         7777776d-1*t110*t147*t263*t325-1.0546577777777776d-1*t111
     2         *t147*t228*t325-2.0d+0*t241*t247*t318-1.0546577777777776d
     3         -1*t111*t147*t266*t306+5.273288888888887d-2*t113*t263*t30
     4         6+4.727288888888889d-2*t210*t260*t262*t304-2.0d+0*t246*t2
     5         47*t304-8.7761641845443d-2*gammabb*t100*t126*t211*t303)-1
     6         .2407009817987999d+0*t77*(3.2910615692041123d-2*t100*t126
     7         *t91*t92+3.2910615692041123d-2*gammabb*t100*t126*t303*t91
     8         -8.888888888888888d-1*t146*t147*t459-8.888888888888888d-1
     9         *t147*t149*t331+t326-1.0546577777777776d-1*t110*t111*t147
     :         *t325+t324+t323+t321+t319+t315+t313+t308+t307+t305))*wght
     ;         +Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)-9.305257363491d-
     1         1*t22*(t208*(2.6666666666666666d+0*t490*t72*t75+2.6666666
     2         666666666d+0*t293*t299*t75+2.6666666666666666d+0*t293*t29
     3         6*t72-3.0d+0*t293*t300)+t73*(-8.888888888888888d-1*(-8.40
     4         0000000000001d+0*t195*t479*t71-2.1d+1*t383*t475*t71-2.4d+
     5         0*(-5.0d-1*t196*t479+6.41391219265211d-2*t197*(gammaaa*t1
     6         6*t25*t478-gammaaa*t16*t163*t17*t477+2*gammaaa*t16*t17*t3
     7         38*t476-2*gammaaa*t16*t163*t270*t271+2*t16*t25*t271-2*t16
     8         *t163*t17*t270)+2.5d-1*t385*t475-3.206956096326055d-2*t29
     9         7**2*t384)*t68-2.7259596d+0*t479*t67+4.7459599999999996d-
     :         2*t480*t66+5.672746666666666d-2*t479*t66-5.4519192d+0*t47
     ;         5*t66+4.7459599999999996d-2*t35*t479-4.9628707825354457d+
     <         0*t195*t479-1.2407176956338616d+1*t383*t475+5.67274666666
     =         6666d-2*t475-1.68d+1*t195*t272*t298+9.491919999999999d-2*
     >         t272*t274)*t75-8.888888888888888d-1*(-2.4682961769030842d
     ?         -2*t151*t39*t40*t479-1.4431302433467247d-1*t1*t202*t3*t47
     @         9+4.9365923538061685d-2*t351*t39*t40*t475+2.1646953650200
     1         87d-1*t1*t290*t3*t475)*t72-1.0546577777777776d-1*t35*t36*
     2         t490-2.109315555555555d-1*t274*t293*t36+6.764482379964267
     3         d-3*t1*t202*t272*t293*t3*t35-1.7777777777777776d+0*t296*t
     4         299)-1.0666666666666666d+1*t293**2*t357*t72*t75+6.7644823
     5         79964267d-3*t1*t202*t272*t293*t3*t35*t73+7.57211d-1*(1.64
     6         55307846020562d-2*gammaaa*t16*t25*t478*t61*t65-1.64553078
     7         46020562d-2*gammaaa*t16*t163*t17*t477*t61*t65+3.291061569
     8         2041123d-2*gammaaa*t16*t17*t338*t476*t61*t65-3.2910615692
     9         041123d-2*gammaaa*t16*t163*t270*t271*t61*t65+3.2910615692
     :         041123d-2*t16*t25*t271*t61*t65-3.2910615692041123d-2*t16*
     ;         t163*t17*t270*t61*t65-1.6455307846020562d-2*gammaaa*t16*t
     <         17*t192*t25*t489*t65+3.2910615692041123d-2*gammaaa*t16*t1
     =         7*t25*t379*t486*t65-3.2910615692041123d-2*gammaaa*t16*t19
     >         2*t25*t271*t288*t65+3.2910615692041123d-2*gammaaa*t16*t16
     ?         3*t17*t192*t270*t288*t65-3.2910615692041123d-2*t16*t17*t1
     @         92*t25*t288*t65+t479*t61*t63-t192*t489*t59*t63+2*t379*t48
     1         6*t59*t63-2*t192*t272*t288*t63+5.0d-1*t377*t475*t59*t61/t
     2         53-5.0d-1*t183*t190*t479*t59*t61+2.5d-1*t190*t374*t475*t5
     3         9*t61-8.227653923010281d-3*gammaaa*t16*t17*t176*t194*t25*
     4         t479*t61+8.227653923010281d-3*gammaaa*t16*t17*t25*t381*t4
     5         75*t61/t42+4.1138269615051404d-3*gammaaa*t16*t17*t194*t25
     6         *t368*t475*t61-t183*t190*t475*t61-1.6455307846020562d-2*g
     7         ammaaa*t16*t176*t194*t25*t271*t272*t61+1.6455307846020562
     8         d-2*gammaaa*t16*t163*t17*t176*t194*t270*t272*t61-1.645530
     9         7846020562d-2*t16*t17*t176*t194*t25*t272*t61+t183*t190*t1
     :         92*t272*t288*t59+1.6455307846020562d-2*gammaaa*t16*t17*t1
     ;         76*t192*t194*t25*t272*t288)+t188*(-2.0d+0*(7.378049999999
     <         994d-2*t360*t475*t481*t56-7.378049999999994d-2*t171*t175*
     =         t479*t56+3.689024999999997d-2*t175*t362*t475*t56-1.475609
     >         999999999d-1*t186*(t488+t487+t485+t484)*t50+2.95121999999
     ?         9998d-1*t285**2*t373*t50+1.475609999999999d-1*t171*t175*t
     @         186*t272*t285)*t59-4.0d+0*t272*t286)+2.0d+0*t286**2*t372*
     1         t59-2.0d+0*t479*t58+t16*t25*(3.2910615692041123d-2*gammaa
     2         a*t478*t52+6.582123138408225d-2*t271*t52+3.29106156920411
     3         23d-2*gammaaa*t181*t271*t280+3.2910615692041123d-2*t17*t1
     4         81*t280)+t16*t163*(-3.2910615692041123d-2*gammaaa*t17*t47
     5         7*t52-3.2910615692041123d-2*gammaaa*t270*t271*t52-3.29106
     6         15692041123d-2*t17*t270*t52-t270*t282)+6.582123138408225d
     7         -2*gammaaa*t16*t17*t338*t476*t52+t16*t181*t25*(3.29106156
     8         92041123d-2*gammaaa*t17*(6.0965d-1*t179*(t485+t484+t483+t
     9         482)*t50-1.2193000000000001d+0*t279**2*t367*t50-3.04825d-
     :         1*t360*t47*t475*t481+3.04825d-1*t171*t175*t47*t479-1.5241
     ;         25d-1*t175*t362*t47*t475-6.0965d-1*t171*t175*t179*t272*t2
     <         79)+3.2910615692041123d-2*gammaaa*t271*t280+3.29106156920
     =         41123d-2*t17*t280)+5.273288888888887d-2*t36*t38*t480+t202
     >         *t3*t38*(-3.3822411899821336d-3*t1*t35*t479-6.76448237996
     ?         4267d-3*t1*t272*t274)-4.727288888888889d-2*t151*t32*t479+
     @         6.064083168526658d-3*t1*t201*t290*t3*t479-2.1224291089843
     1         306d-2*t1*t201*t3*t456*t475+1.5557798788747831d-3*t355*t3
     2         9*t40*t475/t27**4+5.0733617849732d-3*t1*t290*t3*t35*t38*t
     3         475+9.454577777777778d-2*t32*t351*t475-3.2910615692041123
     4         d-2*gammaaa*t16*t17*t25*t280**2*t358-6.582123138408225d-2
     5         *gammaaa*t16*t163*t17*t181*t270*t280)*wght
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
            Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)-9.305257363491d-
     1         1*(t147*(-8.888888888888888d-1*t149*(-2.4d+0*t142*(6.4139
     2         1219265211d-2*t256*(-gammabb*t222*t493*t91*t92+2*gammabb*
     3         t393*t492*t91*t92-2*t222*t302*t91*t92+gammabb*t100*t494*t
     4         91-2*gammabb*t222*t302*t303*t91+2*t100*t303*t91)-5.0d-1*t
     5         255*t495+2.5d-1*t440*t491-3.206956096326055d-2*t329**2*t4
     6         39)+4.7459599999999996d-2*t140*t496-8.400000000000001d+0*
     7         t145*t254*t495-4.9628707825354457d+0*t254*t495-2.7259596d
     8         +0*t141*t495+5.672746666666666d-2*t140*t495+4.74595999999
     9         99996d-2*t110*t495-2.1d+1*t145*t438*t491-1.24071769563386
     :         16d+1*t438*t491-5.4519192d+0*t140*t491+5.672746666666666d
     ;         -2*t491-1.68d+1*t254*t304*t330+9.491919999999999d-2*t304*
     <         t306)-8.888888888888888d-1*t146*(-1.4431302433467247d-1*t
     =         1*t261*t495*t78+2.164695365020087d-1*t1*t322*t491*t78-2.4
     >         682961769030842d-2*t114*t210*t39*t495+4.9365923538061685d
     ?         -2*t114*t39*t406*t491)+6.764482379964267d-3*t1*t110*t261*
     @         t304*t325*t78-1.0546577777777776d-1*t110*t111*t506-1.7777
     1         777777777776d+0*t328*t331-2.109315555555555d-1*t111*t306*
     2         t325)+7.57211d-1*(-1.6455307846020562d-2*gammabb*t100*t13
     3         9*t251*t505*t91*t92+3.2910615692041123d-2*gammabb*t100*t1
     4         39*t434*t502*t91*t92-8.227653923010281d-3*gammabb*t100*t1
     5         35*t235*t253*t495*t91*t92-1.6455307846020562d-2*gammabb*t
     6         135*t139*t222*t493*t91*t92+3.2910615692041123d-2*gammabb*
     7         t135*t139*t393*t492*t91*t92+8.227653923010281d-3*gammabb*
     8         t100*t135*t436*t491*t91*t92/t116+4.1138269615051404d-3*ga
     9         mmabb*t100*t135*t253*t423*t491*t91*t92+1.6455307846020562
     :         d-2*gammabb*t100*t235*t251*t253*t304*t320*t91*t92+3.29106
     ;         15692041123d-2*gammabb*t139*t222*t251*t302*t320*t91*t92-3
     <         .2910615692041123d-2*t100*t139*t251*t320*t91*t92+1.645530
     =         7846020562d-2*gammabb*t135*t222*t235*t253*t302*t304*t91*t
     >         92-1.6455307846020562d-2*t100*t135*t235*t253*t304*t91*t92
     ?         -3.2910615692041123d-2*t135*t139*t222*t302*t91*t92+1.6455
     @         307846020562d-2*gammabb*t100*t135*t139*t494*t91-3.2910615
     1         692041123d-2*gammabb*t100*t139*t251*t303*t320*t91-1.64553
     2         07846020562d-2*gammabb*t100*t135*t235*t253*t303*t304*t91-
     3         3.2910615692041123d-2*gammabb*t135*t139*t222*t302*t303*t9
     4         1+3.2910615692041123d-2*t100*t135*t139*t303*t91-t133*t137
     5         *t251*t505+2*t133*t137*t434*t502-5.0d-1*t133*t135*t242*t2
     6         49*t495+t135*t137*t495+5.0d-1*t133*t135*t432*t491/t127+2.
     7         5d-1*t133*t135*t249*t429*t491-t135*t242*t249*t491+t133*t2
     8         42*t249*t251*t304*t320-2*t137*t251*t304*t320)+t100*t240*t
     9         91*(3.2910615692041123d-2*gammabb*(6.0965d-1*t124*t238*(t
     :         501+t500+t499+t498)-3.04825d-1*t121*t415*t491*t497+3.0482
     ;         5d-1*t121*t230*t234*t495-1.524125d-1*t121*t234*t417*t491-
     <         1.2193000000000001d+0*t124*t311**2*t422-6.0965d-1*t230*t2
     =         34*t238*t304*t311)*t92+3.2910615692041123d-2*t312*t92+3.2
     >         910615692041123d-2*gammabb*t303*t312)+t222*t91*(-3.291061
     ?         5692041123d-2*gammabb*t126*t493*t92-3.2910615692041123d-2
     @         *t126*t302*t92-t302*t314-3.2910615692041123d-2*gammabb*t1
     1         26*t302*t303)+t100*t91*(3.2910615692041123d-2*t240*t312*t
     2         92+3.2910615692041123d-2*gammabb*t126*t494+3.291061569204
     3         1123d-2*gammabb*t240*t303*t312+6.582123138408225d-2*t126*
     4         t303)+6.582123138408225d-2*gammabb*t126*t393*t492*t91*t92
     5         -3.2910615692041123d-2*gammabb*t100*t312**2*t413*t91*t92-
     6         6.582123138408225d-2*gammabb*t222*t240*t302*t312*t91*t92+
     7         t113*t261*(-3.3822411899821336d-3*t1*t110*t495-6.76448237
     8         9964267d-3*t1*t304*t306)*t78+6.064083168526658d-3*t1*t260
     9         *t322*t495*t78-2.1224291089843306d-2*t1*t260*t472*t491*t7
     :         8+5.0733617849732d-3*t1*t110*t113*t322*t491*t78+6.7644823
     ;         79964267d-3*t1*t110*t147*t261*t304*t325*t78+t267*(2.66666
     <         66666666666d+0*t146*t149*t506-3.0d+0*t325*t332+2.66666666
     =         66666666d+0*t149*t325*t331+2.6666666666666666d+0*t146*t32
     >         5*t328)+t247*(-2.0d+0*t133*(-1.475609999999999d-1*t124*t2
     ?         45*(t504+t503+t501+t500)+7.378049999999994d-2*t130*t415*t
     @         491*t497-7.378049999999994d-2*t130*t230*t234*t495+3.68902
     1         4999999997d-2*t130*t234*t417*t491+2.951219999999998d-1*t1
     2         24*t317**2*t428+1.475609999999999d-1*t230*t234*t245*t304*
     3         t317)-4.0d+0*t304*t318)+5.273288888888887d-2*t111*t113*t4
     4         96-4.727288888888889d-2*t107*t210*t495-2.0d+0*t132*t495+1
     5         .5557798788747831d-3*t114*t39*t410*t491/t102**4+9.4545777
     6         77777778d-2*t107*t406*t491+2.0d+0*t133*t318**2*t427-1.066
     7         6666666666666d+1*t146*t149*t325**2*t412)*t97*wght
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = param(1)
            t2 = rhoa**3.333333333333333d-1
            t3 = 1/t2
            t4 = t1*t3
            t5 = gammaaa**5.0d-1
            t6 = t5**7
            t7 = 1/rhoa**9.333333333333333d+0
            t8 = gammaaa**3
            t9 = 1/rhoa**8
            t10 = t5**5
            t11 = 1/rhoa**6.666666666666667d+0
            t12 = gammaaa**2
            t13 = 1/rhoa**5.333333333333333d+0
            t14 = t5**3
            t15 = 1/rhoa**4
            t16 = 1/rhoa**2.6666666666666666d+0
            t17 = -4.327677396975467d-7*t8*t9+2.4123830247695402d-8*t6*t
     1         7+2.631878392200375d-4*gammaaa*t16+1.8005513133540818d-4*
     2         t14*t15-4.342399100269002d-5*t12*t13+5.3020963068324d-6*t
     3         10*t11
            t18 = t5**9
            t19 = 1/rhoa**12
            t20 = gammaaa**4
            t21 = 1/rhoa**1.0666666666666666d+1
            t22 = rhoa**1.3333333333333333d+0
            t23 = 1/t22
            t24 = -2.7196832676277033d-6*t8*t9+1.7578986477855002d-7*t6*
     1         t7+6.841322473346062d-1*t23*t5-5.649671283776346d-9*t20*t
     2         21+3.149302550983647d-10*t18*t19-2.0532933130264455d-1*ga
     3         mmaaa*t16+2.342799068769956d-2*t14*t15-1.3837064697606524
     4         d-3*t12*t13+5.955909787676884d-5*t10*t11+1.0d+0
            t25 = 1/t24
            t26 = 1.6455307846020562d-2*gammaaa*t16*t17*t25
            t27 = 6.582123138408225d-2*t4**2.0d+0+t26+6.0965d-1
            t28 = 1/t27
            t29 = t27**5.0d-1
            t30 = 1/t29
            t31 = 2.565564877060844d-1*t1*t3*t30+1.0d+0
            t32 = 1/t31
            t33 = 4.1138269615051404d-3*gammaaa*t16+1.0d+0
            t34 = 1/t33
            t35 = 5.136628594837797d-3*gammaaa*t16*t34+6.934448603031025
     1         d-2*gammaaa*t16*t17*t25+1.0d+0
            t36 = 1.282782438530422d-1*t1*t3*t30+1.0d+0
            t37 = t27*t31
            t38 = 1/t37**2.0d+0
            t39 = t1**2
            t40 = 1/rhoa**6.666666666666666d-1
            t41 = 6.582123138408225d-2*t39*t40
            t42 = t41+t26
            t43 = t42**5.0d-1
            t44 = t41+t26+6.0965d-1
            t45 = t44**5.0d-1
            t46 = t45+t43
            t47 = 1/t46
            t48 = 2.565564877060844d-1*t1*t3
            t49 = t48+t45
            t50 = 1/t49
            t51 = 1.0d+0-6.0965d-1*t47*t50
            t52 = log(t51)
            t53 = t41+t26+7.57211d-1
            t54 = t53**5.0d-1
            t55 = t54+t45
            t56 = 1/t55
            t57 = 1.475609999999999d-1*t50*t56+1.0d+0
            t58 = log(t57)
            t59 = t26+7.57211d-1
            t60 = t54+t43
            t61 = 1/t60
            t62 = t54+t48
            t63 = 1/t62
            t64 = t48+t43
            t65 = 1/t64
            t66 = t26+6.0965d-1
            t67 = t66**2.0d+0
            t68 = t66**3.5d+0
            t69 = (gammaaa*t16*t17*t25)**5.0d-1
            t70 = t59**5.0d-1
            t71 = 1.282782438530422d-1*t69-t70
            t72 = -2.4d+0*t68*t71-1.417963080724413d+0*t68+2.83637333333
     1         3333d-2*t67-9.086532d-1*t66**3.0d+0+4.7459599999999996d-2
     2         *t35*t66
            t73 = 1/t37**3.0d+0
            t74 = t1*t3*t30
            t75 = 2.4682961769030842d-2*t74**2.0d+0+2.8862604866934494d-
     1         1*t1*t3*t30+1.0d+0
            t76 = -8.888888888888888d-1*t72*t73*t75+7.57211d-1*(1.645530
     1         7846020562d-2*gammaaa*t16*t17*t25*t61*t65+t59*t61*t63)-2.
     2         0d+0*t58*t59+3.2910615692041123d-2*gammaaa*t16*t17*t25*t5
     3         2+5.273288888888887d-2*t35*t36*t38+4.727288888888889d-2*t
     4         28*t32-1.0d+0
            t77 = 1/t27**2
            t78 = 1/rhoa**3.6666666666666664d+0
            t79 = -4.38808209227215d-2*gammaaa*t17*t25*t78
            t80 = 1/rhoa**13
            t81 = 1/rhoa**1.1666666666666665d+1
            t82 = 1/rhoa**1.0333333333333333d+1
            t83 = 1/rhoa**9
            t84 = 1/rhoa**7.666666666666667d+0
            t85 = 1/rhoa**6.333333333333333d+0
            t86 = 1/rhoa**5
            t87 = 1/rhoa**2.3333333333333334d+0
            t88 = -9.121763297794749d-1*t5*t87-9.371196275079824d-2*t14*
     1         t86+7.379767838723479d-3*t12*t85-3.970606525117923d-4*t10
     2         *t84+2.1757466141021625d-5*t8*t83-1.6407054045998d-6*t6*t
     3         82+6.026316036028103d-8*t20*t81-3.7791630611803767d-9*t18
     4         *t80+5.475448834737188d-1*gammaaa*t78
            t89 = 1/t24**2
            t90 = -1.6455307846020562d-2*gammaaa*t16*t17*t88*t89
            t91 = -7.202205253416327d-4*t14*t86+2.3159461868101344d-4*t1
     1         2*t85-3.5347308712216d-5*t10*t84+3.462141917580374d-6*t8*
     2         t83-2.2515574897849044d-7*t6*t82-7.018342379201d-4*gammaa
     3         a*t78
            t92 = 1.6455307846020562d-2*gammaaa*t16*t25*t91
            t93 = t92+t90+t79-4.38808209227215d-2*t1*t23*t4
            t94 = 1/t33**2
            t95 = 5.634986987915197d-5*t12*t85*t94+6.934448603031025d-2*
     1         gammaaa*t16*t25*t91-6.934448603031025d-2*gammaaa*t16*t17*
     2         t88*t89-1.369767625290079d-2*gammaaa*t34*t78-1.8491862941
     3         416065d-1*gammaaa*t17*t25*t78
            t96 = t92+t90+t79-4.38808209227215d-2*t39/rhoa**1.6666666666
     1         666669d+0
            t97 = 1/t45
            t98 = 5.0d-1*t96*t97
            t99 = -8.551882923536147d-2*t1*t23
            t100 = t99+t98
            t101 = 1/t49**2
            t102 = 1/t43
            t103 = 5.0d-1*t102*t96
            t104 = t98+t103
            t105 = 1/t46**2
            t106 = 6.0965d-1*t104*t105*t50+6.0965d-1*t100*t101*t47
            t107 = 1/t51
            t108 = t92+t90+t79
            t109 = 1/t54
            t110 = 5.0d-1*t109*t96
            t111 = t98+t110
            t112 = 1/t55**2
            t113 = -1.475609999999999d-1*t100*t101*t56-1.475609999999999
     1         d-1*t111*t112*t50
            t114 = 1/t57
            t115 = t99+t110
            t116 = 1/t62**2
            t117 = t110+t103
            t118 = 1/t60**2
            t119 = t99+t103
            t120 = 1/t64**2
            t121 = t66**2.5d+0
            t122 = 1/t70
            t123 = 1/t69
            t124 = gammaaa*t16*t25*t91-gammaaa*t16*t17*t88*t89-2.6666666
     1         666666666d+0*gammaaa*t17*t25*t78
            t125 = 6.41391219265211d-2*t123*t124-5.0d-1*t108*t122
            t126 = 4.7459599999999996d-2*t66*t95-8.400000000000001d+0*t1
     1         08*t121*t71-2.4d+0*t125*t68-2.7259596d+0*t108*t67+5.67274
     2         6666666666d-2*t108*t66+4.7459599999999996d-2*t108*t35-4.9
     3         628707825354457d+0*t108*t121
            t127 = 1/t31**2
            t128 = 1/t29**3
            t129 = -1.282782438530422d-1*t1*t128*t3*t93-8.55188292353614
     1         7d-2*t1*t23*t30
            t130 = -6.41391219265211d-2*t1*t128*t3*t93-4.275941461768073
     1         5d-2*t1*t23*t30
            t131 = -5.0d-1*t1*t128*t3*t93-3.333333333333333d-1*t1*t23*t3
     1         0
            t132 = -1.4431302433467247d-1*t1*t128*t3*t93+4.9365923538061
     1         685d-2*t131*t74-9.620868288978164d-2*t1*t23*t30
            t133 = t31*t93+t129*t27
            t134 = 1/t37**4.0d+0
            t135 = 5.273288888888887d-2*t36*t38*t95-4.727288888888889d-2
     1         *t32*t77*t93+7.57211d-1*(1.6455307846020562d-2*gammaaa*t1
     2         6*t25*t61*t65*t91-1.6455307846020562d-2*gammaaa*t16*t17*t
     3         61*t65*t88*t89-4.38808209227215d-2*gammaaa*t17*t25*t61*t6
     4         5*t78-1.6455307846020562d-2*gammaaa*t117*t118*t16*t17*t25
     5         *t65+t108*t61*t63-t117*t118*t59*t63-t115*t116*t59*t61-1.6
     6         455307846020562d-2*gammaaa*t119*t120*t16*t17*t25*t61)+3.2
     7         910615692041123d-2*gammaaa*t16*t25*t52*t91-3.291061569204
     8         1123d-2*gammaaa*t16*t17*t52*t88*t89-8.7761641845443d-2*ga
     9         mmaaa*t17*t25*t52*t78-8.888888888888888d-1*t126*t73*t75+2
     :         .6666666666666666d+0*t133*t134*t72*t75-8.888888888888888d
     ;         -1*t132*t72*t73-1.0546577777777776d-1*t133*t35*t36*t73-2.
     <         0d+0*t113*t114*t59-2.0d+0*t108*t58+5.273288888888887d-2*t
     =         130*t35*t38-4.727288888888889d-2*t127*t129*t28+3.29106156
     >         92041123d-2*gammaaa*t106*t107*t16*t17*t25
            t136 = 1/t5
            t137 = -8.159049802883108d-6*t12*t9-2.2598685135105387d-8*t2
     1         1*t8+6.15264526724925d-7*t10*t7+1.4171861479426412d-9*t19
     2         *t6+3.514198603154934d-2*t15*t5+3.420661236673031d-1*t136
     3         *t23-2.0532933130264455d-1*t16+1.488977446919221d-4*t11*t
     4         14-2.767412939521305d-3*gammaaa*t13
            t138 = -1.2983032190926402d-6*t12*t9+8.443340586693391d-8*t1
     1         0*t7+2.7008269700311227d-4*t15*t5+2.631878392200375d-4*t1
     2         6+1.3255240767081d-5*t11*t14-8.684798200538004d-5*gammaaa
     3         *t13
            t139 = -1.6455307846020562d-2*gammaaa*t137*t16*t17*t89+1.645
     1         5307846020562d-2*t16*t17*t25+1.6455307846020562d-2*gammaa
     2         a*t138*t16*t25
            t140 = -4.727288888888889d-2*t139*t32*t77
            t141 = -2.113120120468199d-5*gammaaa*t13*t94-6.9344486030310
     1         25d-2*gammaaa*t137*t16*t17*t89+5.136628594837797d-3*t16*t
     2         34+6.934448603031025d-2*t16*t17*t25+6.934448603031025d-2*
     3         gammaaa*t138*t16*t25
            t142 = 5.273288888888887d-2*t141*t36*t38
            t143 = -3.2910615692041123d-2*gammaaa*t137*t16*t17*t52*t89
            t144 = 5.0d-1*t102*t139
            t145 = 5.0d-1*t139*t97
            t146 = t145+t144
            t147 = 3.04825d-1*t101*t139*t47*t97+6.0965d-1*t105*t146*t50
            t148 = 3.2910615692041123d-2*gammaaa*t107*t147*t16*t17*t25
            t149 = 3.2910615692041123d-2*t17*t52+3.2910615692041123d-2*g
     1         ammaaa*t138*t52
            t150 = -2.0d+0*t139*t58
            t151 = 5.0d-1*t109*t139
            t152 = t151+t145
            t153 = -7.378049999999994d-2*t101*t139*t56*t97-1.47560999999
     1         9999d-1*t112*t152*t50
            t154 = -2.0d+0*t114*t153*t59
            t155 = t151+t144
            t156 = 7.57211d-1*(-1.6455307846020562d-2*gammaaa*t137*t16*t
     1         17*t61*t65*t89+1.6455307846020562d-2*t16*t17*t25*t61*t65+
     2         1.6455307846020562d-2*gammaaa*t138*t16*t25*t61*t65-1.6455
     3         307846020562d-2*gammaaa*t118*t155*t16*t17*t25*t65+t139*t6
     4         1*t63-t118*t155*t59*t63-5.0d-1*t109*t116*t139*t59*t61-8.2
     5         27653923010281d-3*gammaaa*t102*t120*t139*t16*t17*t25*t61)
            t157 = 1/t29**5
            t158 = 6.064083168526658d-3*t1*t127*t139*t157*t3
            t159 = -3.3822411899821336d-3*t1*t128*t139*t3*t35*t38
            t160 = t139*t31-1.282782438530422d-1*t1*t139*t3*t30
            t161 = 2.6666666666666666d+0*t134*t160*t72*t75
            t162 = -1.4431302433467247d-1*t1*t128*t139*t3
            t163 = t162-2.4682961769030842d-2*t139*t39*t40*t77
            t164 = -gammaaa*t137*t16*t17*t89+t16*t17*t25+gammaaa*t138*t1
     1         6*t25
            t165 = 6.41391219265211d-2*t123*t164-5.0d-1*t122*t139
            t166 = -8.400000000000001d+0*t121*t139*t71-2.4d+0*t165*t68-2
     1         .7259596d+0*t139*t67+4.7459599999999996d-2*t141*t66+5.672
     2         746666666666d-2*t139*t66+4.7459599999999996d-2*t139*t35-4
     3         .9628707825354457d+0*t121*t139
            t167 = -8.888888888888888d-1*t166*t75-8.888888888888888d-1*t
     1         163*t72-1.0546577777777776d-1*t160*t35*t36
            t168 = 1/rhoa**4.666666666666667d+0
            t169 = 1.6089634338331216d-1*gammaaa*t168*t17*t25
            t170 = 8.7761641845443d-2*gammaaa*t17*t78*t88*t89
            t171 = -8.7761641845443d-2*gammaaa*t25*t78*t91
            t172 = t88**2
            t173 = 1/t24**3
            t174 = 3.2910615692041123d-2*gammaaa*t16*t17*t172*t173
            t175 = 1/rhoa**1.1333333333333334d+1
            t176 = 1/rhoa**10
            t177 = 1/rhoa**8.666666666666666d+0
            t178 = 1/rhoa**7.333333333333333d+0
            t179 = 1/rhoa**6
            t180 = -1.9581719526919464d-4*t176*t8+1.695395584753127d-5*t
     1         175*t6+2.1284114361521084d+0*t5/rhoa**3.3333333333333337d
     2         +0-7.030702042032786d-7*t20/rhoa**1.2666666666666665d+1+4
     3         .9129119795344894d-8*t18/rhoa**14+4.685598137539912d-1*t1
     4         4*t179-4.6738529645248705d-2*t12*t178+3.0441316692570747d
     5         -3*t10*t177-2.0076645727369685d+0*gammaaa*t168
            t181 = -1.6455307846020562d-2*gammaaa*t16*t17*t180*t89
            t182 = -3.2910615692041123d-2*gammaaa*t16*t88*t89*t91
            t183 = -3.115927725822337d-5*t176*t8+2.326609406111068d-6*t1
     1         75*t6+3.6011026267081636d-3*t14*t179-1.466765918313085d-3
     2         *t12*t178+2.709960334603227d-4*t10*t177+2.573392205707033
     3         5d-3*gammaaa*t168
            t184 = 1.6455307846020562d-2*gammaaa*t16*t183*t25
            t185 = 7.313470153786916d-2*t16*t39+t184+t182+t181+t174+t171
     1         +t170+t169
            t186 = 1/t27**3
            t187 = t93**2
            t188 = 1/t33**3
            t189 = -5.071488289123677d-4*t12*t178*t94-1.386889720606205d
     1         -1*gammaaa*t16*t88*t89*t91-3.698372588283213d-1*gammaaa*t
     2         25*t78*t91+3.698372588283213d-1*gammaaa*t17*t78*t88*t89-6
     3         .934448603031025d-2*gammaaa*t16*t17*t180*t89+1.2363392745
     4         928628d-6*t176*t188*t8+5.02248129273029d-2*gammaaa*t168*t
     5         34+6.934448603031025d-2*gammaaa*t16*t183*t25+6.7803497451
     6         85891d-1*gammaaa*t168*t17*t25+1.386889720606205d-1*gammaa
     7         a*t16*t17*t172*t173
            t190 = 1/t31**3
            t191 = t133**2
            t192 = 1/t37**5.0d+0
            t193 = 1/t51**2
            t194 = t100**2
            t195 = 1/t49**3
            t196 = t96**2
            t197 = 1/t45**3
            t198 = -2.5d-1*t196*t197
            t199 = 5.0d-1*t185*t97
            t200 = 1.1402510564714863d-1*t1*t87
            t201 = t200+t199+t198
            t202 = 1/t46**3
            t203 = 1/t43**3
            t204 = -2.5d-1*t196*t203
            t205 = 5.0d-1*t102*t185
            t206 = t184+t182+t181+t174+t171+t170+t169
            t207 = 1/t57**2
            t208 = 1/t55**3
            t209 = 1/t54**3
            t210 = -2.5d-1*t196*t209
            t211 = 5.0d-1*t109*t185
            t212 = 1/t62**3
            t213 = t117**2
            t214 = 1/t60**3
            t215 = t211+t210+t205+t204
            t216 = 1/t64**3
            t217 = t108**2
            t218 = t66**1.5d+0
            t219 = 1/t69**3
            t220 = 1/t70**3
            t221 = 8.551882923536147d-2*t1*t128*t23*t93+1.14025105647148
     1         63d-1*t1*t30*t87+1.924173657795633d-1*t1*t157*t187*t3-1.2
     2         82782438530422d-1*t1*t128*t185*t3
            t222 = 2*t129*t93+t185*t31+t221*t27
            t223 = t162-2.4682961769030842d-2*t1*t128*t139*t3*t74
            t224 = -4.5608816488973747d-1*t136*t87-1.4056794412619736d-1
     1         *t5*t86+1.4759535677446958d-2*gammaaa*t85-9.9265163127948
     2         08d-4*t14*t84+6.527239842306487d-5*t12*t83-5.742468916099
     3         301d-6*t10*t82+2.4105264144112412d-7*t8*t81-1.70062337753
     4         11694d-8*t6*t80+5.475448834737188d-1*t78
            t225 = -1.0803307880124491d-3*t5*t86+4.631892373620269d-4*ga
     1         mmaaa*t85-8.836827178054d-5*t14*t84+1.0386425752741123d-5
     2         *t12*t83-7.880451214247165d-7*t10*t82-7.018342379201d-4*t
     3         78
            t226 = -1.6455307846020562d-2*gammaaa*t137*t16*t89*t91+1.645
     1         5307846020562d-2*t16*t25*t91-1.6455307846020562d-2*t16*t1
     2         7*t88*t89-1.6455307846020562d-2*gammaaa*t138*t16*t88*t89+
     3         4.38808209227215d-2*gammaaa*t137*t17*t78*t89-1.6455307846
     4         020562d-2*gammaaa*t16*t17*t224*t89+3.2910615692041123d-2*
     5         gammaaa*t137*t16*t17*t173*t88-4.38808209227215d-2*t17*t25
     6         *t78-4.38808209227215d-2*gammaaa*t138*t25*t78+1.645530784
     7         6020562d-2*gammaaa*t16*t225*t25
            t227 = 1.690496096374559d-4*gammaaa*t85*t94-6.93444860303102
     1         5d-2*gammaaa*t137*t16*t89*t91+6.934448603031025d-2*t16*t2
     2         5*t91-6.934448603031025d-2*t16*t17*t88*t89-6.934448603031
     3         025d-2*gammaaa*t138*t16*t88*t89+1.8491862941416065d-1*gam
     4         maaa*t137*t17*t78*t89-6.934448603031025d-2*gammaaa*t16*t1
     5         7*t224*t89+1.386889720606205d-1*gammaaa*t137*t16*t17*t173
     6         *t88-4.6362722797232353d-7*t12*t188*t83-1.369767625290079
     7         d-2*t34*t78-1.8491862941416065d-1*t17*t25*t78-1.849186294
     8         1416065d-1*gammaaa*t138*t25*t78+6.934448603031025d-2*gamm
     9         aaa*t16*t225*t25
            t228 = -2.5d-1*t139*t197*t96
            t229 = 5.0d-1*t226*t97
            t230 = t229+t228
            t231 = -2.5d-1*t139*t203*t96
            t232 = 5.0d-1*t102*t226
            t233 = -2.5d-1*t139*t209*t96
            t234 = 5.0d-1*t109*t226
            t235 = t234+t233+t232+t231
            t236 = 1/t29**7
            t237 = 1.924173657795633d-1*t1*t139*t157*t3*t93-1.2827824385
     1         30422d-1*t1*t128*t226*t3+4.2759414617680735d-2*t1*t128*t1
     2         39*t23
            t238 = -1.282782438530422d-1*t1*t128*t139*t3*t93+t226*t31+t2
     1         37*t27+t129*t139
            t239 = t139**2
            t240 = t137**2
            t241 = -1.6318099605766218d-5*gammaaa*t9+1.5381613168123123d
     1         -6*t14*t7+2.2334661703788317d-4*t11*t5-1.7103306183365155
     2         d-1*t23/t14-6.779605540531617d-8*t12*t21+4.96015151779924
     3         5d-9*t10*t19+1.757099301577467d-2*t136*t15-2.767412939521
     4         305d-3*t13
            t242 = -2.5966064381852805d-6*gammaaa*t9+2.1108351466733477d
     1         -7*t14*t7+1.9882861150621498d-5*t11*t5+1.3504134850155614
     2         d-4*t136*t15-8.684798200538004d-5*t13
            t243 = -1.6455307846020562d-2*gammaaa*t16*t17*t241*t89-3.291
     1         0615692041123d-2*t137*t16*t17*t89-3.2910615692041123d-2*g
     2         ammaaa*t137*t138*t16*t89+1.6455307846020562d-2*gammaaa*t1
     3         6*t242*t25+3.2910615692041123d-2*t138*t16*t25+3.291061569
     4         2041123d-2*gammaaa*t16*t17*t173*t240
            t244 = -4.226240240936398d-5*t13*t94+1.7386021048962136d-7*g
     1         ammaaa*t188*t9-6.934448603031025d-2*gammaaa*t16*t17*t241*
     2         t89-1.386889720606205d-1*t137*t16*t17*t89-1.3868897206062
     3         05d-1*gammaaa*t137*t138*t16*t89+6.934448603031025d-2*gamm
     4         aaa*t16*t242*t25+1.386889720606205d-1*t138*t16*t25+1.3868
     5         89720606205d-1*gammaaa*t16*t17*t173*t240
            t245 = 1/t44
            t246 = -2.5d-1*t203*t239
            t247 = 5.0d-1*t102*t243
            t248 = -2.5d-1*t197*t239
            t249 = 5.0d-1*t243*t97
            t250 = t155**2
            t251 = -2.5d-1*t209*t239
            t252 = 5.0d-1*t109*t243
            t253 = t252+t251+t247+t246
            t254 = t243*t31-1.282782438530422d-1*t1*t243*t3*t30-6.413912
     1         19265211d-2*t1*t128*t239*t3
            fnc(iq) = fnc(iq)-9.305257363491d-1*t22*t76*wght
            Amat(iq,D1_RA) = -1.2407009817987999d+0*t2*t76*wght-9.305257
     1         363491d-1*t135*t22*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-9.305257363491d-1*t22*(t16
     1         7*t73+t149*t16*t25+t161+t159+t158+t156+t154+t150+t148+t14
     2         3+t142+t140)*wght
            Amat2(iq,D2_RA_RA) = -9.305257363491d-1*t22*(-8.888888888888
     1         888d-1*t73*t75*(9.491919999999999d-2*t108*t95-2.4d+0*t68*
     2         (6.41391219265211d-2*t123*(-2*gammaaa*t16*t88*t89*t91-5.3
     3         33333333333333d+0*gammaaa*t25*t78*t91+5.333333333333333d+
     4         0*gammaaa*t17*t78*t88*t89-gammaaa*t16*t17*t180*t89+gammaa
     5         a*t16*t183*t25+9.777777777777779d+0*gammaaa*t168*t17*t25+
     6         2*gammaaa*t16*t17*t172*t173)+2.5d-1*t217*t220-3.206956096
     7         326055d-2*t124**2*t219-5.0d-1*t122*t206)-2.1d+1*t217*t218
     8         *t71-8.400000000000001d+0*t121*t206*t71-2.7259596d+0*t206
     9         *t67-5.4519192d+0*t217*t66+5.672746666666666d-2*t206*t66+
     :         4.7459599999999996d-2*t189*t66+4.7459599999999996d-2*t206
     ;         *t35-1.2407176956338616d+1*t217*t218+5.672746666666666d-2
     <         *t217-4.9628707825354457d+0*t121*t206-1.68d+1*t108*t121*t
     =         125)-2.109315555555555d-1*t133*t36*t73*t95+1.054657777777
     >         7776d-1*t130*t38*t95-8.888888888888888d-1*t72*t73*(4.9365
     ?         923538061685d-2*t1*t3*t30*(3.333333333333333d-1*t1*t128*t
     @         23*t93+4.444444444444444d-1*t1*t30*t87+7.5d-1*t1*t157*t18
     1         7*t3-5.0d-1*t1*t128*t185*t3)+9.620868288978164d-2*t1*t128
     2         *t23*t93+1.2827824385304218d-1*t1*t30*t87+2.1646953650200
     3         87d-1*t1*t157*t187*t3-1.4431302433467247d-1*t1*t128*t185*
     4         t3+4.9365923538061685d-2*t131**2)+5.273288888888887d-2*t3
     5         5*t38*(4.2759414617680735d-2*t1*t128*t23*t93+5.7012552823
     6         57431d-2*t1*t30*t87+9.620868288978166d-2*t1*t157*t187*t3-
     7         6.41391219265211d-2*t1*t128*t185*t3)+9.454577777777778d-2
     8         *t127*t129*t77*t93+7.57211d-1*(-3.2910615692041123d-2*gam
     9         maaa*t16*t61*t65*t88*t89*t91-8.7761641845443d-2*gammaaa*t
     :         25*t61*t65*t78*t91-3.2910615692041123d-2*gammaaa*t117*t11
     ;         8*t16*t25*t65*t91-3.2910615692041123d-2*gammaaa*t119*t120
     <         *t16*t25*t61*t91+8.7761641845443d-2*gammaaa*t17*t61*t65*t
     =         78*t88*t89+3.2910615692041123d-2*gammaaa*t117*t118*t16*t1
     >         7*t65*t88*t89+3.2910615692041123d-2*gammaaa*t119*t120*t16
     ?         *t17*t61*t88*t89-1.6455307846020562d-2*gammaaa*t16*t17*t1
     @         80*t61*t65*t89+8.7761641845443d-2*gammaaa*t117*t118*t17*t
     1         25*t65*t78+8.7761641845443d-2*gammaaa*t119*t120*t17*t25*t
     2         61*t78+1.6455307846020562d-2*gammaaa*t16*t183*t25*t61*t65
     3         +1.6089634338331216d-1*gammaaa*t168*t17*t25*t61*t65+3.291
     4         0615692041123d-2*gammaaa*t16*t17*t172*t173*t61*t65-1.6455
     5         307846020562d-2*gammaaa*t118*t16*t17*t215*t25*t65+3.29106
     6         15692041123d-2*gammaaa*t16*t17*t213*t214*t25*t65+t206*t61
     7         *t63-t118*t215*t59*t63+2*t213*t214*t59*t63-2*t108*t117*t1
     8         18*t63+2*t115**2*t212*t59*t61-t116*(t211+t210+t200)*t59*t
     9         61+3.2910615692041123d-2*gammaaa*t119**2*t16*t17*t216*t25
     :         *t61-1.6455307846020562d-2*gammaaa*t120*t16*t17*(t205+t20
     ;         4+t200)*t25*t61-2*t108*t115*t116*t61+2*t115*t116*t117*t11
     <         8*t59+3.2910615692041123d-2*gammaaa*t117*t118*t119*t120*t
     =         16*t17*t25)-6.582123138408225d-2*gammaaa*t16*t52*t88*t89*
     >         t91-1.75523283690886d-1*gammaaa*t25*t52*t78*t91+6.5821231
     ?         38408225d-2*gammaaa*t106*t107*t16*t25*t91+1.7552328369088
     @         6d-1*gammaaa*t17*t52*t78*t88*t89-6.582123138408225d-2*gam
     1         maaa*t106*t107*t16*t17*t88*t89-3.2910615692041123d-2*gamm
     2         aaa*t16*t17*t180*t52*t89-1.75523283690886d-1*gammaaa*t106
     3         *t107*t17*t25*t78-4.727288888888889d-2*t185*t32*t77+2.666
     4         6666666666666d+0*t134*t222*t72*t75-1.0666666666666666d+1*
     5         t191*t192*t72*t75+5.333333333333333d+0*t126*t133*t134*t75
     6         -1.0546577777777776d-1*t222*t35*t36*t73-2.109315555555555
     7         d-1*t130*t133*t35*t73-1.7777777777777776d+0*t126*t132*t73
     8         +5.333333333333333d+0*t132*t133*t134*t72-2.0d+0*t114*(-1.
     9         475609999999999d-1*t101*t201*t56+2.951219999999998d-1*t19
     :         4*t195*t56-1.475609999999999d-1*t112*(t211+t210+t199+t198
     ;         )*t50+2.951219999999998d-1*t111**2*t208*t50+2.95121999999
     <         9998d-1*t100*t101*t111*t112)*t59+2.0d+0*t113**2*t207*t59-
     =         2.0d+0*t206*t58+3.2910615692041123d-2*gammaaa*t16*t183*t2
     >         5*t52+3.217926867666243d-1*gammaaa*t168*t17*t25*t52+6.582
     ?         123138408225d-2*gammaaa*t16*t17*t172*t173*t52+3.291061569
     @         2041123d-2*gammaaa*t107*t16*t17*t25*(6.0965d-1*t105*(t205
     1         +t204+t199+t198)*t50-1.2193000000000001d+0*t104**2*t202*t
     2         50+6.0965d-1*t101*t201*t47-1.2193000000000001d+0*t194*t19
     3         5*t47-1.2193000000000001d+0*t100*t101*t104*t105)+5.273288
     4         888888887d-2*t189*t36*t38+3.1639733333333325d-1*t134*t191
     5         *t35*t36+9.454577777777778d-2*t186*t187*t32-4.72728888888
     6         8889d-2*t127*t221*t28+9.454577777777778d-2*t129**2*t190*t
     7         28-3.2910615692041123d-2*gammaaa*t106**2*t16*t17*t193*t25
     8         -4.0d+0*t108*t113*t114)*wght-4.135669939329333d-1*t40*t76
     9         *wght-2.4814019635975998d+0*t135*t2*wght+Amat2(iq,D2_RA_R
     :         A)
            Cmat2(iq,D2_RA_GAA) = -9.305257363491d-1*t22*(-2.0d+0*t114*t
     1         59*(1.475609999999999d-1*t100*t139*t195*t56*t97+7.3780499
     2         99999994d-2*t101*t111*t112*t139*t97-1.475609999999999d-1*
     3         t101*t230*t56-1.475609999999999d-1*t112*(t234+t233+t229+t
     4         228)*t50+2.951219999999998d-1*t111*t152*t208*t50+1.475609
     5         999999999d-1*t100*t101*t112*t152)+3.2910615692041123d-2*g
     6         ammaaa*t107*t16*t17*t25*(-6.0965d-1*t100*t139*t195*t47*t9
     7         7-3.04825d-1*t101*t104*t105*t139*t97+6.0965d-1*t105*(t232
     8         +t231+t229+t228)*t50-1.2193000000000001d+0*t104*t146*t202
     9         *t50+6.0965d-1*t101*t230*t47-6.0965d-1*t100*t101*t105*t14
     :         6)-8.888888888888888d-1*t73*t75*(4.7459599999999996d-2*t1
     ;         39*t95-2.4d+0*t68*(6.41391219265211d-2*t123*(-gammaaa*t13
     <         7*t16*t89*t91+t16*t25*t91-t16*t17*t88*t89-gammaaa*t138*t1
     =         6*t88*t89+2.6666666666666666d+0*gammaaa*t137*t17*t78*t89-
     >         gammaaa*t16*t17*t224*t89+2*gammaaa*t137*t16*t17*t173*t88-
     ?         2.6666666666666666d+0*t17*t25*t78-2.6666666666666666d+0*g
     @         ammaaa*t138*t25*t78+gammaaa*t16*t225*t25)-5.0d-1*t122*t22
     1         6+2.5d-1*t108*t139*t220-3.206956096326055d-2*t124*t164*t2
     2         19)-8.400000000000001d+0*t121*t226*t71-2.1d+1*t108*t139*t
     3         218*t71-2.7259596d+0*t226*t67+4.7459599999999996d-2*t227*
     4         t66+5.672746666666666d-2*t226*t66-5.4519192d+0*t108*t139*
     5         t66+4.7459599999999996d-2*t226*t35-4.9628707825354457d+0*
     6         t121*t226-1.2407176956338616d+1*t108*t139*t218-8.40000000
     7         0000001d+0*t108*t121*t165+4.7459599999999996d-2*t108*t141
     8         -8.400000000000001d+0*t121*t125*t139+5.672746666666666d-2
     9         *t108*t139)-1.0546577777777776d-1*t160*t36*t73*t95-3.3822
     :         411899821336d-3*t1*t128*t139*t3*t38*t95-8.888888888888888
     ;         d-1*t72*t73*(4.9365923538061685d-2*t1*t3*t30*(7.5d-1*t1*t
     <         139*t157*t3*t93-5.0d-1*t1*t128*t226*t3+1.6666666666666666
     =         d-1*t1*t128*t139*t23)+2.164695365020087d-1*t1*t139*t157*t
     >         3*t93-1.4431302433467247d-1*t1*t128*t226*t3-2.46829617690
     ?         30842d-2*t1*t128*t131*t139*t3+4.810434144489082d-2*t1*t12
     @         8*t139*t23)+5.273288888888887d-2*t35*t38*(9.6208682889781
     1         66d-2*t1*t139*t157*t3*t93-6.41391219265211d-2*t1*t128*t22
     2         6*t3+2.1379707308840368d-2*t1*t128*t139*t23)+9.4545777777
     3         77778d-2*t139*t186*t32*t93-6.064083168526658d-3*t1*t127*t
     4         139*t236*t3*t93+7.57211d-1*(-1.6455307846020562d-2*gammaa
     5         a*t137*t16*t61*t65*t89*t91+1.6455307846020562d-2*t16*t25*
     6         t61*t65*t91-1.6455307846020562d-2*gammaaa*t118*t155*t16*t
     7         25*t65*t91-8.227653923010281d-3*gammaaa*t102*t120*t139*t1
     8         6*t25*t61*t91-1.6455307846020562d-2*t16*t17*t61*t65*t88*t
     9         89-1.6455307846020562d-2*gammaaa*t138*t16*t61*t65*t88*t89
     :         +1.6455307846020562d-2*gammaaa*t118*t155*t16*t17*t65*t88*
     ;         t89+8.227653923010281d-3*gammaaa*t102*t120*t139*t16*t17*t
     <         61*t88*t89+4.38808209227215d-2*gammaaa*t137*t17*t61*t65*t
     =         78*t89-1.6455307846020562d-2*gammaaa*t16*t17*t224*t61*t65
     >         *t89+1.6455307846020562d-2*gammaaa*t117*t118*t137*t16*t17
     ?         *t65*t89+1.6455307846020562d-2*gammaaa*t119*t120*t137*t16
     @         *t17*t61*t89+3.2910615692041123d-2*gammaaa*t137*t16*t17*t
     1         173*t61*t65*t88-4.38808209227215d-2*t17*t25*t61*t65*t78-4
     2         .38808209227215d-2*gammaaa*t138*t25*t61*t65*t78+4.3880820
     3         9227215d-2*gammaaa*t118*t155*t17*t25*t65*t78+2.1940410461
     4         36075d-2*gammaaa*t102*t120*t139*t17*t25*t61*t78+1.6455307
     5         846020562d-2*gammaaa*t16*t225*t25*t61*t65-1.6455307846020
     6         562d-2*gammaaa*t118*t16*t17*t235*t25*t65+3.29106156920411
     7         23d-2*gammaaa*t117*t155*t16*t17*t214*t25*t65-1.6455307846
     8         020562d-2*t117*t118*t16*t17*t25*t65-1.6455307846020562d-2
     9         *gammaaa*t117*t118*t138*t16*t25*t65+t226*t61*t63-t118*t23
     :         5*t59*t63+2*t117*t155*t214*t59*t63-t108*t118*t155*t63-t11
     ;         7*t118*t139*t63-t116*(t234+t233)*t59*t61+t109*t115*t139*t
     <         212*t59*t61-1.6455307846020562d-2*gammaaa*t120*t16*t17*(t
     =         232+t231)*t25*t61+1.6455307846020562d-2*gammaaa*t102*t119
     >         *t139*t16*t17*t216*t25*t61-1.6455307846020562d-2*t119*t12
     ?         0*t16*t17*t25*t61-1.6455307846020562d-2*gammaaa*t119*t120
     @         *t138*t16*t25*t61-t115*t116*t139*t61-5.0d-1*t108*t109*t11
     1         6*t139*t61+t115*t116*t118*t155*t59+5.0d-1*t109*t116*t117*
     2         t118*t139*t59+1.6455307846020562d-2*gammaaa*t118*t119*t12
     3         0*t155*t16*t17*t25+8.227653923010281d-3*gammaaa*t102*t117
     4         *t118*t120*t139*t16*t17*t25)-3.2910615692041123d-2*gammaa
     5         a*t137*t16*t52*t89*t91+3.2910615692041123d-2*t16*t25*t52*
     6         t91+3.2910615692041123d-2*gammaaa*t107*t147*t16*t25*t91-3
     7         .2910615692041123d-2*t16*t17*t52*t88*t89-3.29106156920411
     8         23d-2*gammaaa*t138*t16*t52*t88*t89-3.2910615692041123d-2*
     9         gammaaa*t107*t147*t16*t17*t88*t89+8.7761641845443d-2*gamm
     :         aaa*t137*t17*t52*t78*t89-3.2910615692041123d-2*gammaaa*t1
     ;         6*t17*t224*t52*t89-3.2910615692041123d-2*gammaaa*t106*t10
     <         7*t137*t16*t17*t89+6.582123138408225d-2*gammaaa*t137*t16*
     =         t17*t173*t52*t88-8.7761641845443d-2*t17*t25*t52*t78-8.776
     >         1641845443d-2*gammaaa*t138*t25*t52*t78-8.7761641845443d-2
     ?         *gammaaa*t107*t147*t17*t25*t78-4.727288888888889d-2*t226*
     @         t32*t77+4.727288888888889d-2*t127*t129*t139*t77+2.6666666
     1         666666666d+0*t134*t238*t72*t75-1.0666666666666666d+1*t133
     2         *t160*t192*t72*t75+2.6666666666666666d+0*t133*t134*t166*t
     3         75+2.6666666666666666d+0*t126*t134*t160*t75-1.05465777777
     4         77776d-1*t238*t35*t36*t73-1.0546577777777776d-1*t133*t141
     5         *t36*t73+6.764482379964267d-3*t1*t128*t133*t139*t3*t35*t7
     6         3-1.0546577777777776d-1*t130*t160*t35*t73-8.8888888888888
     7         88d-1*t126*t223*t73-8.888888888888888d-1*t132*t166*t73+2.
     8         6666666666666666d+0*t133*t134*t223*t72+2.6666666666666666
     9         d+0*t132*t134*t160*t72+2.0d+0*t113*t153*t207*t59-2.0d+0*t
     :         226*t58+3.2910615692041123d-2*gammaaa*t16*t225*t25*t52+5.
     ;         273288888888887d-2*t227*t36*t38+5.273288888888887d-2*t130
     <         *t141*t38+3.1639733333333325d-1*t133*t134*t160*t35*t36-1.
     =         2128166337053317d-2*t1*t129*t139*t157*t190*t3-4.727288888
     >         888889d-2*t127*t237*t28-3.2910615692041123d-2*gammaaa*t10
     ?         6*t147*t16*t17*t193*t25+3.2910615692041123d-2*t106*t107*t
     @         16*t17*t25+3.2910615692041123d-2*gammaaa*t106*t107*t138*t
     1         16*t25-2.0d+0*t108*t114*t153-2.0d+0*t113*t114*t139)*wght-
     2         1.2407009817987999d+0*t2*(-8.888888888888888d-1*t166*t73*
     3         t75-8.888888888888888d-1*t223*t72*t73-1.0546577777777776d
     4         -1*t160*t35*t36*t73+3.2910615692041123d-2*t16*t17*t25*t52
     5         +3.2910615692041123d-2*gammaaa*t138*t16*t25*t52+t161+t159
     6         +t158+t156+t154+t150+t148+t143+t142+t140)*wght+Cmat2(iq,D
     7         2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)-9.305257363491d-
     1         1*t22*(t114*(-2.0d+0*t59*(-7.378049999999994d-2*t101*t243
     2         *t56*t97+1.475609999999999d-1*t101*t112*t139*t152*t97+7.3
     3         78049999999994d-2*t195*t239*t245*t56+3.689024999999997d-2
     4         *t101*t197*t239*t56-1.475609999999999d-1*t112*(t252+t251+
     5         t249+t248)*t50+2.951219999999998d-1*t152**2*t208*t50)-4.0
     6         d+0*t139*t153)+t107*t16*t25*(3.2910615692041123d-2*gammaa
     7         a*t17*(3.04825d-1*t101*t243*t47*t97-6.0965d-1*t101*t105*t
     8         139*t146*t97+6.0965d-1*t105*(t249+t248+t247+t246)*t50-1.2
     9         193000000000001d+0*t146**2*t202*t50-3.04825d-1*t195*t239*
     :         t245*t47-1.524125d-1*t101*t197*t239*t47)+3.29106156920411
     ;         23d-2*t147*t17+3.2910615692041123d-2*gammaaa*t138*t147)+t
     <         73*(-8.888888888888888d-1*t75*(-2.4d+0*t68*(6.41391219265
     =         211d-2*t123*(-gammaaa*t16*t17*t241*t89-2*t137*t16*t17*t89
     >         -2*gammaaa*t137*t138*t16*t89+gammaaa*t16*t242*t25+2*t138*
     ?         t16*t25+2*gammaaa*t16*t17*t173*t240)-5.0d-1*t122*t243+2.5
     @         d-1*t220*t239-3.206956096326055d-2*t164**2*t219)-8.400000
     1         000000001d+0*t121*t243*t71-2.1d+1*t218*t239*t71-2.7259596
     2         d+0*t243*t67+4.7459599999999996d-2*t244*t66+5.67274666666
     3         6666d-2*t243*t66-5.4519192d+0*t239*t66+4.7459599999999996
     4         d-2*t243*t35-4.9628707825354457d+0*t121*t243-1.2407176956
     5         338616d+1*t218*t239+5.672746666666666d-2*t239-1.68d+1*t12
     6         1*t139*t165+9.491919999999999d-2*t139*t141)-8.88888888888
     7         8888d-1*t72*(-2.4682961769030842d-2*t243*t39*t40*t77+4.93
     8         65923538061685d-2*t186*t239*t39*t40-1.4431302433467247d-1
     9         *t1*t128*t243*t3+2.164695365020087d-1*t1*t157*t239*t3)-1.
     :         0546577777777776d-1*t254*t35*t36-2.109315555555555d-1*t14
     ;         1*t160*t36+6.764482379964267d-3*t1*t128*t139*t160*t3*t35-
     <         1.7777777777777776d+0*t163*t166)+7.57211d-1*(-1.645530784
     =         6020562d-2*gammaaa*t16*t17*t241*t61*t65*t89-3.29106156920
     >         41123d-2*t137*t16*t17*t61*t65*t89-3.2910615692041123d-2*g
     ?         ammaaa*t137*t138*t16*t61*t65*t89+3.2910615692041123d-2*ga
     @         mmaaa*t118*t137*t155*t16*t17*t65*t89+1.6455307846020562d-
     1         2*gammaaa*t102*t120*t137*t139*t16*t17*t61*t89+1.645530784
     2         6020562d-2*gammaaa*t16*t242*t25*t61*t65+3.291061569204112
     3         3d-2*t138*t16*t25*t61*t65+3.2910615692041123d-2*gammaaa*t
     4         16*t17*t173*t240*t61*t65-1.6455307846020562d-2*gammaaa*t1
     5         18*t16*t17*t25*t253*t65+3.2910615692041123d-2*gammaaa*t16
     6         *t17*t214*t25*t250*t65-3.2910615692041123d-2*t118*t155*t1
     7         6*t17*t25*t65-3.2910615692041123d-2*gammaaa*t118*t138*t15
     8         5*t16*t25*t65+t243*t61*t63-t118*t253*t59*t63+2*t214*t250*
     9         t59*t63-2*t118*t139*t155*t63+5.0d-1*t212*t239*t59*t61/t53
     :         -5.0d-1*t109*t116*t243*t59*t61+2.5d-1*t116*t209*t239*t59*
     ;         t61+8.227653923010281d-3*gammaaa*t16*t17*t216*t239*t25*t6
     <         1/t42-8.227653923010281d-3*gammaaa*t102*t120*t16*t17*t243
     =         *t25*t61+4.1138269615051404d-3*gammaaa*t120*t16*t17*t203*
     >         t239*t25*t61-1.6455307846020562d-2*t102*t120*t139*t16*t17
     ?         *t25*t61-1.6455307846020562d-2*gammaaa*t102*t120*t138*t13
     @         9*t16*t25*t61-t109*t116*t239*t61+t109*t116*t118*t139*t155
     1         *t59+1.6455307846020562d-2*gammaaa*t102*t118*t120*t139*t1
     2         55*t16*t17*t25)+t16*(-3.2910615692041123d-2*gammaaa*t17*t
     3         241*t52-3.2910615692041123d-2*t137*t17*t52-3.291061569204
     4         1123d-2*gammaaa*t137*t138*t52-t137*t149)*t89-6.5821231384
     5         08225d-2*gammaaa*t107*t137*t147*t16*t17*t89-4.72728888888
     6         8889d-2*t243*t32*t77+t134*(2.6666666666666666d+0*t254*t72
     7         *t75+2.6666666666666666d+0*t160*t166*t75+2.66666666666666
     8         66d+0*t160*t163*t72-3.0d+0*t160*t167)-1.0666666666666666d
     9         +1*t160**2*t192*t72*t75+6.764482379964267d-3*t1*t128*t139
     :         *t160*t3*t35*t73+2.0d+0*t153**2*t207*t59-2.0d+0*t243*t58+
     ;         t16*t25*(3.2910615692041123d-2*gammaaa*t242*t52+6.5821231
     <         38408225d-2*t138*t52+3.2910615692041123d-2*t107*t147*t17+
     =         3.2910615692041123d-2*gammaaa*t107*t138*t147)+6.582123138
     >         408225d-2*gammaaa*t16*t17*t173*t240*t52+1.555779878874783
     ?         1d-3*t190*t239*t39*t40/t27**4+5.273288888888887d-2*t244*t
     @         36*t38+t128*t3*(-3.3822411899821336d-3*t1*t243*t35-6.7644
     1         82379964267d-3*t1*t139*t141)*t38+5.0733617849732d-3*t1*t1
     2         57*t239*t3*t35*t38+9.454577777777778d-2*t186*t239*t32+6.0
     3         64083168526658d-3*t1*t127*t157*t243*t3-2.1224291089843306
     4         d-2*t1*t127*t236*t239*t3-3.2910615692041123d-2*gammaaa*t1
     5         47**2*t16*t17*t193*t25)*wght
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = param(1)
            t2 = rhob**3.333333333333333d-1
            t3 = 1/t2
            t4 = t1*t3
            t5 = gammabb**5.0d-1
            t6 = t5**7
            t7 = 1/rhob**9.333333333333333d+0
            t8 = gammabb**3
            t9 = 1/rhob**8
            t10 = t5**5
            t11 = 1/rhob**6.666666666666667d+0
            t12 = gammabb**2
            t13 = 1/rhob**5.333333333333333d+0
            t14 = t5**3
            t15 = 1/rhob**4
            t16 = 1/rhob**2.6666666666666666d+0
            t17 = -4.327677396975467d-7*t8*t9+2.4123830247695402d-8*t6*t
     1         7+2.631878392200375d-4*gammabb*t16+1.8005513133540818d-4*
     2         t14*t15-4.342399100269002d-5*t12*t13+5.3020963068324d-6*t
     3         10*t11
            t18 = t5**9
            t19 = 1/rhob**12
            t20 = gammabb**4
            t21 = 1/rhob**1.0666666666666666d+1
            t22 = rhob**1.3333333333333333d+0
            t23 = 1/t22
            t24 = -2.7196832676277033d-6*t8*t9+1.7578986477855002d-7*t6*
     1         t7+6.841322473346062d-1*t23*t5-5.649671283776346d-9*t20*t
     2         21+3.149302550983647d-10*t18*t19-2.0532933130264455d-1*ga
     3         mmabb*t16+2.342799068769956d-2*t14*t15-1.3837064697606524
     4         d-3*t12*t13+5.955909787676884d-5*t10*t11+1.0d+0
            t25 = 1/t24
            t26 = 1.6455307846020562d-2*gammabb*t16*t17*t25
            t27 = 6.582123138408225d-2*t4**2.0d+0+t26+6.0965d-1
            t28 = 1/t27
            t29 = t27**5.0d-1
            t30 = 1/t29
            t31 = 2.565564877060844d-1*t1*t3*t30+1.0d+0
            t32 = 1/t31
            t33 = 4.1138269615051404d-3*gammabb*t16+1.0d+0
            t34 = 1/t33
            t35 = 5.136628594837797d-3*gammabb*t16*t34+6.934448603031025
     1         d-2*gammabb*t16*t17*t25+1.0d+0
            t36 = 1.282782438530422d-1*t1*t3*t30+1.0d+0
            t37 = t27*t31
            t38 = 1/t37**2.0d+0
            t39 = t1**2
            t40 = 1/rhob**6.666666666666666d-1
            t41 = 6.582123138408225d-2*t39*t40
            t42 = t41+t26
            t43 = t42**5.0d-1
            t44 = t41+t26+6.0965d-1
            t45 = t44**5.0d-1
            t46 = t45+t43
            t47 = 1/t46
            t48 = 2.565564877060844d-1*t1*t3
            t49 = t48+t45
            t50 = 1/t49
            t51 = 1.0d+0-6.0965d-1*t47*t50
            t52 = log(t51)
            t53 = t41+t26+7.57211d-1
            t54 = t53**5.0d-1
            t55 = t54+t45
            t56 = 1/t55
            t57 = 1.475609999999999d-1*t50*t56+1.0d+0
            t58 = log(t57)
            t59 = t26+7.57211d-1
            t60 = t54+t43
            t61 = 1/t60
            t62 = t54+t48
            t63 = 1/t62
            t64 = t48+t43
            t65 = 1/t64
            t66 = t26+6.0965d-1
            t67 = t66**2.0d+0
            t68 = t66**3.5d+0
            t69 = (gammabb*t16*t17*t25)**5.0d-1
            t70 = t59**5.0d-1
            t71 = 1.282782438530422d-1*t69-t70
            t72 = -2.4d+0*t68*t71-1.417963080724413d+0*t68+2.83637333333
     1         3333d-2*t67-9.086532d-1*t66**3.0d+0+4.7459599999999996d-2
     2         *t35*t66
            t73 = 1/t37**3.0d+0
            t74 = t1*t3*t30
            t75 = 2.4682961769030842d-2*t74**2.0d+0+2.8862604866934494d-
     1         1*t1*t3*t30+1.0d+0
            t76 = -8.888888888888888d-1*t72*t73*t75+7.57211d-1*(1.645530
     1         7846020562d-2*gammabb*t16*t17*t25*t61*t65+t59*t61*t63)-2.
     2         0d+0*t58*t59+3.2910615692041123d-2*gammabb*t16*t17*t25*t5
     3         2+5.273288888888887d-2*t35*t36*t38+4.727288888888889d-2*t
     4         28*t32-1.0d+0
            t77 = 1/t27**2
            t78 = 1/rhob**3.6666666666666664d+0
            t79 = -4.38808209227215d-2*gammabb*t17*t25*t78
            t80 = 1/rhob**13
            t81 = 1/rhob**1.1666666666666665d+1
            t82 = 1/rhob**1.0333333333333333d+1
            t83 = 1/rhob**9
            t84 = 1/rhob**7.666666666666667d+0
            t85 = 1/rhob**6.333333333333333d+0
            t86 = 1/rhob**5
            t87 = 1/rhob**2.3333333333333334d+0
            t88 = -9.121763297794749d-1*t5*t87-9.371196275079824d-2*t14*
     1         t86+7.379767838723479d-3*t12*t85-3.970606525117923d-4*t10
     2         *t84+2.1757466141021625d-5*t8*t83-1.6407054045998d-6*t6*t
     3         82+6.026316036028103d-8*t20*t81-3.7791630611803767d-9*t18
     4         *t80+5.475448834737188d-1*gammabb*t78
            t89 = 1/t24**2
            t90 = -1.6455307846020562d-2*gammabb*t16*t17*t88*t89
            t91 = -7.202205253416327d-4*t14*t86+2.3159461868101344d-4*t1
     1         2*t85-3.5347308712216d-5*t10*t84+3.462141917580374d-6*t8*
     2         t83-2.2515574897849044d-7*t6*t82-7.018342379201d-4*gammab
     3         b*t78
            t92 = 1.6455307846020562d-2*gammabb*t16*t25*t91
            t93 = t92+t90+t79-4.38808209227215d-2*t1*t23*t4
            t94 = 1/t33**2
            t95 = 5.634986987915197d-5*t12*t85*t94+6.934448603031025d-2*
     1         gammabb*t16*t25*t91-6.934448603031025d-2*gammabb*t16*t17*
     2         t88*t89-1.369767625290079d-2*gammabb*t34*t78-1.8491862941
     3         416065d-1*gammabb*t17*t25*t78
            t96 = t92+t90+t79-4.38808209227215d-2*t39/rhob**1.6666666666
     1         666669d+0
            t97 = 1/t45
            t98 = 5.0d-1*t96*t97
            t99 = -8.551882923536147d-2*t1*t23
            t100 = t99+t98
            t101 = 1/t49**2
            t102 = 1/t43
            t103 = 5.0d-1*t102*t96
            t104 = t98+t103
            t105 = 1/t46**2
            t106 = 6.0965d-1*t104*t105*t50+6.0965d-1*t100*t101*t47
            t107 = 1/t51
            t108 = t92+t90+t79
            t109 = 1/t54
            t110 = 5.0d-1*t109*t96
            t111 = t98+t110
            t112 = 1/t55**2
            t113 = -1.475609999999999d-1*t100*t101*t56-1.475609999999999
     1         d-1*t111*t112*t50
            t114 = 1/t57
            t115 = t99+t110
            t116 = 1/t62**2
            t117 = t110+t103
            t118 = 1/t60**2
            t119 = t99+t103
            t120 = 1/t64**2
            t121 = t66**2.5d+0
            t122 = 1/t70
            t123 = 1/t69
            t124 = gammabb*t16*t25*t91-gammabb*t16*t17*t88*t89-2.6666666
     1         666666666d+0*gammabb*t17*t25*t78
            t125 = 6.41391219265211d-2*t123*t124-5.0d-1*t108*t122
            t126 = 4.7459599999999996d-2*t66*t95-8.400000000000001d+0*t1
     1         08*t121*t71-2.4d+0*t125*t68-2.7259596d+0*t108*t67+5.67274
     2         6666666666d-2*t108*t66+4.7459599999999996d-2*t108*t35-4.9
     3         628707825354457d+0*t108*t121
            t127 = 1/t31**2
            t128 = 1/t29**3
            t129 = -1.282782438530422d-1*t1*t128*t3*t93-8.55188292353614
     1         7d-2*t1*t23*t30
            t130 = -6.41391219265211d-2*t1*t128*t3*t93-4.275941461768073
     1         5d-2*t1*t23*t30
            t131 = -5.0d-1*t1*t128*t3*t93-3.333333333333333d-1*t1*t23*t3
     1         0
            t132 = -1.4431302433467247d-1*t1*t128*t3*t93+4.9365923538061
     1         685d-2*t131*t74-9.620868288978164d-2*t1*t23*t30
            t133 = t31*t93+t129*t27
            t134 = 1/t37**4.0d+0
            t135 = 5.273288888888887d-2*t36*t38*t95-4.727288888888889d-2
     1         *t32*t77*t93+7.57211d-1*(1.6455307846020562d-2*gammabb*t1
     2         6*t25*t61*t65*t91-1.6455307846020562d-2*gammabb*t16*t17*t
     3         61*t65*t88*t89-4.38808209227215d-2*gammabb*t17*t25*t61*t6
     4         5*t78-1.6455307846020562d-2*gammabb*t117*t118*t16*t17*t25
     5         *t65+t108*t61*t63-t117*t118*t59*t63-t115*t116*t59*t61-1.6
     6         455307846020562d-2*gammabb*t119*t120*t16*t17*t25*t61)+3.2
     7         910615692041123d-2*gammabb*t16*t25*t52*t91-3.291061569204
     8         1123d-2*gammabb*t16*t17*t52*t88*t89-8.7761641845443d-2*ga
     9         mmabb*t17*t25*t52*t78-8.888888888888888d-1*t126*t73*t75+2
     :         .6666666666666666d+0*t133*t134*t72*t75-8.888888888888888d
     ;         -1*t132*t72*t73-1.0546577777777776d-1*t133*t35*t36*t73-2.
     <         0d+0*t113*t114*t59-2.0d+0*t108*t58+5.273288888888887d-2*t
     =         130*t35*t38-4.727288888888889d-2*t127*t129*t28+3.29106156
     >         92041123d-2*gammabb*t106*t107*t16*t17*t25
            t136 = 1/t5
            t137 = -8.159049802883108d-6*t12*t9-2.2598685135105387d-8*t2
     1         1*t8+6.15264526724925d-7*t10*t7+1.4171861479426412d-9*t19
     2         *t6+3.514198603154934d-2*t15*t5+3.420661236673031d-1*t136
     3         *t23-2.0532933130264455d-1*t16+1.488977446919221d-4*t11*t
     4         14-2.767412939521305d-3*gammabb*t13
            t138 = -1.2983032190926402d-6*t12*t9+8.443340586693391d-8*t1
     1         0*t7+2.7008269700311227d-4*t15*t5+2.631878392200375d-4*t1
     2         6+1.3255240767081d-5*t11*t14-8.684798200538004d-5*gammabb
     3         *t13
            t139 = -1.6455307846020562d-2*gammabb*t137*t16*t17*t89+1.645
     1         5307846020562d-2*t16*t17*t25+1.6455307846020562d-2*gammab
     2         b*t138*t16*t25
            t140 = -4.727288888888889d-2*t139*t32*t77
            t141 = -2.113120120468199d-5*gammabb*t13*t94-6.9344486030310
     1         25d-2*gammabb*t137*t16*t17*t89+5.136628594837797d-3*t16*t
     2         34+6.934448603031025d-2*t16*t17*t25+6.934448603031025d-2*
     3         gammabb*t138*t16*t25
            t142 = 5.273288888888887d-2*t141*t36*t38
            t143 = -3.2910615692041123d-2*gammabb*t137*t16*t17*t52*t89
            t144 = 5.0d-1*t102*t139
            t145 = 5.0d-1*t139*t97
            t146 = t145+t144
            t147 = 3.04825d-1*t101*t139*t47*t97+6.0965d-1*t105*t146*t50
            t148 = 3.2910615692041123d-2*gammabb*t107*t147*t16*t17*t25
            t149 = 3.2910615692041123d-2*t17*t52+3.2910615692041123d-2*g
     1         ammabb*t138*t52
            t150 = -2.0d+0*t139*t58
            t151 = 5.0d-1*t109*t139
            t152 = t151+t145
            t153 = -7.378049999999994d-2*t101*t139*t56*t97-1.47560999999
     1         9999d-1*t112*t152*t50
            t154 = -2.0d+0*t114*t153*t59
            t155 = t151+t144
            t156 = 7.57211d-1*(-1.6455307846020562d-2*gammabb*t137*t16*t
     1         17*t61*t65*t89+1.6455307846020562d-2*t16*t17*t25*t61*t65+
     2         1.6455307846020562d-2*gammabb*t138*t16*t25*t61*t65-1.6455
     3         307846020562d-2*gammabb*t118*t155*t16*t17*t25*t65+t139*t6
     4         1*t63-t118*t155*t59*t63-5.0d-1*t109*t116*t139*t59*t61-8.2
     5         27653923010281d-3*gammabb*t102*t120*t139*t16*t17*t25*t61)
            t157 = 1/t29**5
            t158 = 6.064083168526658d-3*t1*t127*t139*t157*t3
            t159 = -3.3822411899821336d-3*t1*t128*t139*t3*t35*t38
            t160 = t139*t31-1.282782438530422d-1*t1*t139*t3*t30
            t161 = 2.6666666666666666d+0*t134*t160*t72*t75
            t162 = -1.4431302433467247d-1*t1*t128*t139*t3
            t163 = t162-2.4682961769030842d-2*t139*t39*t40*t77
            t164 = -gammabb*t137*t16*t17*t89+t16*t17*t25+gammabb*t138*t1
     1         6*t25
            t165 = 6.41391219265211d-2*t123*t164-5.0d-1*t122*t139
            t166 = -8.400000000000001d+0*t121*t139*t71-2.4d+0*t165*t68-2
     1         .7259596d+0*t139*t67+4.7459599999999996d-2*t141*t66+5.672
     2         746666666666d-2*t139*t66+4.7459599999999996d-2*t139*t35-4
     3         .9628707825354457d+0*t121*t139
            t167 = -8.888888888888888d-1*t166*t75-8.888888888888888d-1*t
     1         163*t72-1.0546577777777776d-1*t160*t35*t36
            t168 = 1/rhob**4.666666666666667d+0
            t169 = 1.6089634338331216d-1*gammabb*t168*t17*t25
            t170 = 8.7761641845443d-2*gammabb*t17*t78*t88*t89
            t171 = -8.7761641845443d-2*gammabb*t25*t78*t91
            t172 = t88**2
            t173 = 1/t24**3
            t174 = 3.2910615692041123d-2*gammabb*t16*t17*t172*t173
            t175 = 1/rhob**1.1333333333333334d+1
            t176 = 1/rhob**10
            t177 = 1/rhob**8.666666666666666d+0
            t178 = 1/rhob**7.333333333333333d+0
            t179 = 1/rhob**6
            t180 = -1.9581719526919464d-4*t176*t8+1.695395584753127d-5*t
     1         175*t6+2.1284114361521084d+0*t5/rhob**3.3333333333333337d
     2         +0-7.030702042032786d-7*t20/rhob**1.2666666666666665d+1+4
     3         .9129119795344894d-8*t18/rhob**14+4.685598137539912d-1*t1
     4         4*t179-4.6738529645248705d-2*t12*t178+3.0441316692570747d
     5         -3*t10*t177-2.0076645727369685d+0*gammabb*t168
            t181 = -1.6455307846020562d-2*gammabb*t16*t17*t180*t89
            t182 = -3.2910615692041123d-2*gammabb*t16*t88*t89*t91
            t183 = -3.115927725822337d-5*t176*t8+2.326609406111068d-6*t1
     1         75*t6+3.6011026267081636d-3*t14*t179-1.466765918313085d-3
     2         *t12*t178+2.709960334603227d-4*t10*t177+2.573392205707033
     3         5d-3*gammabb*t168
            t184 = 1.6455307846020562d-2*gammabb*t16*t183*t25
            t185 = 7.313470153786916d-2*t16*t39+t184+t182+t181+t174+t171
     1         +t170+t169
            t186 = 1/t27**3
            t187 = t93**2
            t188 = 1/t33**3
            t189 = -5.071488289123677d-4*t12*t178*t94-1.386889720606205d
     1         -1*gammabb*t16*t88*t89*t91-3.698372588283213d-1*gammabb*t
     2         25*t78*t91+3.698372588283213d-1*gammabb*t17*t78*t88*t89-6
     3         .934448603031025d-2*gammabb*t16*t17*t180*t89+1.2363392745
     4         928628d-6*t176*t188*t8+5.02248129273029d-2*gammabb*t168*t
     5         34+6.934448603031025d-2*gammabb*t16*t183*t25+6.7803497451
     6         85891d-1*gammabb*t168*t17*t25+1.386889720606205d-1*gammab
     7         b*t16*t17*t172*t173
            t190 = 1/t31**3
            t191 = t133**2
            t192 = 1/t37**5.0d+0
            t193 = 1/t51**2
            t194 = t100**2
            t195 = 1/t49**3
            t196 = t96**2
            t197 = 1/t45**3
            t198 = -2.5d-1*t196*t197
            t199 = 5.0d-1*t185*t97
            t200 = 1.1402510564714863d-1*t1*t87
            t201 = t200+t199+t198
            t202 = 1/t46**3
            t203 = 1/t43**3
            t204 = -2.5d-1*t196*t203
            t205 = 5.0d-1*t102*t185
            t206 = t184+t182+t181+t174+t171+t170+t169
            t207 = 1/t57**2
            t208 = 1/t55**3
            t209 = 1/t54**3
            t210 = -2.5d-1*t196*t209
            t211 = 5.0d-1*t109*t185
            t212 = 1/t62**3
            t213 = t117**2
            t214 = 1/t60**3
            t215 = t211+t210+t205+t204
            t216 = 1/t64**3
            t217 = t108**2
            t218 = t66**1.5d+0
            t219 = 1/t69**3
            t220 = 1/t70**3
            t221 = 8.551882923536147d-2*t1*t128*t23*t93+1.14025105647148
     1         63d-1*t1*t30*t87+1.924173657795633d-1*t1*t157*t187*t3-1.2
     2         82782438530422d-1*t1*t128*t185*t3
            t222 = 2*t129*t93+t185*t31+t221*t27
            t223 = t162-2.4682961769030842d-2*t1*t128*t139*t3*t74
            t224 = -4.5608816488973747d-1*t136*t87-1.4056794412619736d-1
     1         *t5*t86+1.4759535677446958d-2*gammabb*t85-9.9265163127948
     2         08d-4*t14*t84+6.527239842306487d-5*t12*t83-5.742468916099
     3         301d-6*t10*t82+2.4105264144112412d-7*t8*t81-1.70062337753
     4         11694d-8*t6*t80+5.475448834737188d-1*t78
            t225 = -1.0803307880124491d-3*t5*t86+4.631892373620269d-4*ga
     1         mmabb*t85-8.836827178054d-5*t14*t84+1.0386425752741123d-5
     2         *t12*t83-7.880451214247165d-7*t10*t82-7.018342379201d-4*t
     3         78
            t226 = -1.6455307846020562d-2*gammabb*t137*t16*t89*t91+1.645
     1         5307846020562d-2*t16*t25*t91-1.6455307846020562d-2*t16*t1
     2         7*t88*t89-1.6455307846020562d-2*gammabb*t138*t16*t88*t89+
     3         4.38808209227215d-2*gammabb*t137*t17*t78*t89-1.6455307846
     4         020562d-2*gammabb*t16*t17*t224*t89+3.2910615692041123d-2*
     5         gammabb*t137*t16*t17*t173*t88-4.38808209227215d-2*t17*t25
     6         *t78-4.38808209227215d-2*gammabb*t138*t25*t78+1.645530784
     7         6020562d-2*gammabb*t16*t225*t25
            t227 = 1.690496096374559d-4*gammabb*t85*t94-6.93444860303102
     1         5d-2*gammabb*t137*t16*t89*t91+6.934448603031025d-2*t16*t2
     2         5*t91-6.934448603031025d-2*t16*t17*t88*t89-6.934448603031
     3         025d-2*gammabb*t138*t16*t88*t89+1.8491862941416065d-1*gam
     4         mabb*t137*t17*t78*t89-6.934448603031025d-2*gammabb*t16*t1
     5         7*t224*t89+1.386889720606205d-1*gammabb*t137*t16*t17*t173
     6         *t88-4.6362722797232353d-7*t12*t188*t83-1.369767625290079
     7         d-2*t34*t78-1.8491862941416065d-1*t17*t25*t78-1.849186294
     8         1416065d-1*gammabb*t138*t25*t78+6.934448603031025d-2*gamm
     9         abb*t16*t225*t25
            t228 = -2.5d-1*t139*t197*t96
            t229 = 5.0d-1*t226*t97
            t230 = t229+t228
            t231 = -2.5d-1*t139*t203*t96
            t232 = 5.0d-1*t102*t226
            t233 = -2.5d-1*t139*t209*t96
            t234 = 5.0d-1*t109*t226
            t235 = t234+t233+t232+t231
            t236 = 1/t29**7
            t237 = 1.924173657795633d-1*t1*t139*t157*t3*t93-1.2827824385
     1         30422d-1*t1*t128*t226*t3+4.2759414617680735d-2*t1*t128*t1
     2         39*t23
            t238 = -1.282782438530422d-1*t1*t128*t139*t3*t93+t226*t31+t2
     1         37*t27+t129*t139
            t239 = t139**2
            t240 = t137**2
            t241 = -1.6318099605766218d-5*gammabb*t9+1.5381613168123123d
     1         -6*t14*t7+2.2334661703788317d-4*t11*t5-1.7103306183365155
     2         d-1*t23/t14-6.779605540531617d-8*t12*t21+4.96015151779924
     3         5d-9*t10*t19+1.757099301577467d-2*t136*t15-2.767412939521
     4         305d-3*t13
            t242 = -2.5966064381852805d-6*gammabb*t9+2.1108351466733477d
     1         -7*t14*t7+1.9882861150621498d-5*t11*t5+1.3504134850155614
     2         d-4*t136*t15-8.684798200538004d-5*t13
            t243 = -1.6455307846020562d-2*gammabb*t16*t17*t241*t89-3.291
     1         0615692041123d-2*t137*t16*t17*t89-3.2910615692041123d-2*g
     2         ammabb*t137*t138*t16*t89+1.6455307846020562d-2*gammabb*t1
     3         6*t242*t25+3.2910615692041123d-2*t138*t16*t25+3.291061569
     4         2041123d-2*gammabb*t16*t17*t173*t240
            t244 = -4.226240240936398d-5*t13*t94+1.7386021048962136d-7*g
     1         ammabb*t188*t9-6.934448603031025d-2*gammabb*t16*t17*t241*
     2         t89-1.386889720606205d-1*t137*t16*t17*t89-1.3868897206062
     3         05d-1*gammabb*t137*t138*t16*t89+6.934448603031025d-2*gamm
     4         abb*t16*t242*t25+1.386889720606205d-1*t138*t16*t25+1.3868
     5         89720606205d-1*gammabb*t16*t17*t173*t240
            t245 = 1/t44
            t246 = -2.5d-1*t203*t239
            t247 = 5.0d-1*t102*t243
            t248 = -2.5d-1*t197*t239
            t249 = 5.0d-1*t243*t97
            t250 = t155**2
            t251 = -2.5d-1*t209*t239
            t252 = 5.0d-1*t109*t243
            t253 = t252+t251+t247+t246
            t254 = t243*t31-1.282782438530422d-1*t1*t243*t3*t30-6.413912
     1         19265211d-2*t1*t128*t239*t3
            fnc(iq) = fnc(iq)-9.305257363491d-1*t22*t76*wght
            Amat(iq,D1_RB) = -1.2407009817987999d+0*t2*t76*wght-9.305257
     1         363491d-1*t135*t22*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)-9.305257363491d-1*t22*(t16
     1         7*t73+t149*t16*t25+t161+t159+t158+t156+t154+t150+t148+t14
     2         3+t142+t140)*wght
            Amat2(iq,D2_RB_RB) = -9.305257363491d-1*t22*(-8.888888888888
     1         888d-1*t73*t75*(9.491919999999999d-2*t108*t95-2.4d+0*t68*
     2         (6.41391219265211d-2*t123*(-2*gammabb*t16*t88*t89*t91-5.3
     3         33333333333333d+0*gammabb*t25*t78*t91+5.333333333333333d+
     4         0*gammabb*t17*t78*t88*t89-gammabb*t16*t17*t180*t89+gammab
     5         b*t16*t183*t25+9.777777777777779d+0*gammabb*t168*t17*t25+
     6         2*gammabb*t16*t17*t172*t173)+2.5d-1*t217*t220-3.206956096
     7         326055d-2*t124**2*t219-5.0d-1*t122*t206)-2.1d+1*t217*t218
     8         *t71-8.400000000000001d+0*t121*t206*t71-2.7259596d+0*t206
     9         *t67-5.4519192d+0*t217*t66+5.672746666666666d-2*t206*t66+
     :         4.7459599999999996d-2*t189*t66+4.7459599999999996d-2*t206
     ;         *t35-1.2407176956338616d+1*t217*t218+5.672746666666666d-2
     <         *t217-4.9628707825354457d+0*t121*t206-1.68d+1*t108*t121*t
     =         125)-2.109315555555555d-1*t133*t36*t73*t95+1.054657777777
     >         7776d-1*t130*t38*t95-8.888888888888888d-1*t72*t73*(4.9365
     ?         923538061685d-2*t1*t3*t30*(3.333333333333333d-1*t1*t128*t
     @         23*t93+4.444444444444444d-1*t1*t30*t87+7.5d-1*t1*t157*t18
     1         7*t3-5.0d-1*t1*t128*t185*t3)+9.620868288978164d-2*t1*t128
     2         *t23*t93+1.2827824385304218d-1*t1*t30*t87+2.1646953650200
     3         87d-1*t1*t157*t187*t3-1.4431302433467247d-1*t1*t128*t185*
     4         t3+4.9365923538061685d-2*t131**2)+5.273288888888887d-2*t3
     5         5*t38*(4.2759414617680735d-2*t1*t128*t23*t93+5.7012552823
     6         57431d-2*t1*t30*t87+9.620868288978166d-2*t1*t157*t187*t3-
     7         6.41391219265211d-2*t1*t128*t185*t3)+9.454577777777778d-2
     8         *t127*t129*t77*t93+7.57211d-1*(-3.2910615692041123d-2*gam
     9         mabb*t16*t61*t65*t88*t89*t91-8.7761641845443d-2*gammabb*t
     :         25*t61*t65*t78*t91-3.2910615692041123d-2*gammabb*t117*t11
     ;         8*t16*t25*t65*t91-3.2910615692041123d-2*gammabb*t119*t120
     <         *t16*t25*t61*t91+8.7761641845443d-2*gammabb*t17*t61*t65*t
     =         78*t88*t89+3.2910615692041123d-2*gammabb*t117*t118*t16*t1
     >         7*t65*t88*t89+3.2910615692041123d-2*gammabb*t119*t120*t16
     ?         *t17*t61*t88*t89-1.6455307846020562d-2*gammabb*t16*t17*t1
     @         80*t61*t65*t89+8.7761641845443d-2*gammabb*t117*t118*t17*t
     1         25*t65*t78+8.7761641845443d-2*gammabb*t119*t120*t17*t25*t
     2         61*t78+1.6455307846020562d-2*gammabb*t16*t183*t25*t61*t65
     3         +1.6089634338331216d-1*gammabb*t168*t17*t25*t61*t65+3.291
     4         0615692041123d-2*gammabb*t16*t17*t172*t173*t61*t65-1.6455
     5         307846020562d-2*gammabb*t118*t16*t17*t215*t25*t65+3.29106
     6         15692041123d-2*gammabb*t16*t17*t213*t214*t25*t65+t206*t61
     7         *t63-t118*t215*t59*t63+2*t213*t214*t59*t63-2*t108*t117*t1
     8         18*t63+2*t115**2*t212*t59*t61-t116*(t211+t210+t200)*t59*t
     9         61+3.2910615692041123d-2*gammabb*t119**2*t16*t17*t216*t25
     :         *t61-1.6455307846020562d-2*gammabb*t120*t16*t17*(t205+t20
     ;         4+t200)*t25*t61-2*t108*t115*t116*t61+2*t115*t116*t117*t11
     <         8*t59+3.2910615692041123d-2*gammabb*t117*t118*t119*t120*t
     =         16*t17*t25)-6.582123138408225d-2*gammabb*t16*t52*t88*t89*
     >         t91-1.75523283690886d-1*gammabb*t25*t52*t78*t91+6.5821231
     ?         38408225d-2*gammabb*t106*t107*t16*t25*t91+1.7552328369088
     @         6d-1*gammabb*t17*t52*t78*t88*t89-6.582123138408225d-2*gam
     1         mabb*t106*t107*t16*t17*t88*t89-3.2910615692041123d-2*gamm
     2         abb*t16*t17*t180*t52*t89-1.75523283690886d-1*gammabb*t106
     3         *t107*t17*t25*t78-4.727288888888889d-2*t185*t32*t77+2.666
     4         6666666666666d+0*t134*t222*t72*t75-1.0666666666666666d+1*
     5         t191*t192*t72*t75+5.333333333333333d+0*t126*t133*t134*t75
     6         -1.0546577777777776d-1*t222*t35*t36*t73-2.109315555555555
     7         d-1*t130*t133*t35*t73-1.7777777777777776d+0*t126*t132*t73
     8         +5.333333333333333d+0*t132*t133*t134*t72-2.0d+0*t114*(-1.
     9         475609999999999d-1*t101*t201*t56+2.951219999999998d-1*t19
     :         4*t195*t56-1.475609999999999d-1*t112*(t211+t210+t199+t198
     ;         )*t50+2.951219999999998d-1*t111**2*t208*t50+2.95121999999
     <         9998d-1*t100*t101*t111*t112)*t59+2.0d+0*t113**2*t207*t59-
     =         2.0d+0*t206*t58+3.2910615692041123d-2*gammabb*t16*t183*t2
     >         5*t52+3.217926867666243d-1*gammabb*t168*t17*t25*t52+6.582
     ?         123138408225d-2*gammabb*t16*t17*t172*t173*t52+3.291061569
     @         2041123d-2*gammabb*t107*t16*t17*t25*(6.0965d-1*t105*(t205
     1         +t204+t199+t198)*t50-1.2193000000000001d+0*t104**2*t202*t
     2         50+6.0965d-1*t101*t201*t47-1.2193000000000001d+0*t194*t19
     3         5*t47-1.2193000000000001d+0*t100*t101*t104*t105)+5.273288
     4         888888887d-2*t189*t36*t38+3.1639733333333325d-1*t134*t191
     5         *t35*t36+9.454577777777778d-2*t186*t187*t32-4.72728888888
     6         8889d-2*t127*t221*t28+9.454577777777778d-2*t129**2*t190*t
     7         28-3.2910615692041123d-2*gammabb*t106**2*t16*t17*t193*t25
     8         -4.0d+0*t108*t113*t114)*wght-4.135669939329333d-1*t40*t76
     9         *wght-2.4814019635975998d+0*t135*t2*wght+Amat2(iq,D2_RB_R
     :         B)
            Cmat2(iq,D2_RB_GBB) = -9.305257363491d-1*t22*(-2.0d+0*t114*t
     1         59*(1.475609999999999d-1*t100*t139*t195*t56*t97+7.3780499
     2         99999994d-2*t101*t111*t112*t139*t97-1.475609999999999d-1*
     3         t101*t230*t56-1.475609999999999d-1*t112*(t234+t233+t229+t
     4         228)*t50+2.951219999999998d-1*t111*t152*t208*t50+1.475609
     5         999999999d-1*t100*t101*t112*t152)+3.2910615692041123d-2*g
     6         ammabb*t107*t16*t17*t25*(-6.0965d-1*t100*t139*t195*t47*t9
     7         7-3.04825d-1*t101*t104*t105*t139*t97+6.0965d-1*t105*(t232
     8         +t231+t229+t228)*t50-1.2193000000000001d+0*t104*t146*t202
     9         *t50+6.0965d-1*t101*t230*t47-6.0965d-1*t100*t101*t105*t14
     :         6)-8.888888888888888d-1*t73*t75*(4.7459599999999996d-2*t1
     ;         39*t95-2.4d+0*t68*(6.41391219265211d-2*t123*(-gammabb*t13
     <         7*t16*t89*t91+t16*t25*t91-t16*t17*t88*t89-gammabb*t138*t1
     =         6*t88*t89+2.6666666666666666d+0*gammabb*t137*t17*t78*t89-
     >         gammabb*t16*t17*t224*t89+2*gammabb*t137*t16*t17*t173*t88-
     ?         2.6666666666666666d+0*t17*t25*t78-2.6666666666666666d+0*g
     @         ammabb*t138*t25*t78+gammabb*t16*t225*t25)-5.0d-1*t122*t22
     1         6+2.5d-1*t108*t139*t220-3.206956096326055d-2*t124*t164*t2
     2         19)-8.400000000000001d+0*t121*t226*t71-2.1d+1*t108*t139*t
     3         218*t71-2.7259596d+0*t226*t67+4.7459599999999996d-2*t227*
     4         t66+5.672746666666666d-2*t226*t66-5.4519192d+0*t108*t139*
     5         t66+4.7459599999999996d-2*t226*t35-4.9628707825354457d+0*
     6         t121*t226-1.2407176956338616d+1*t108*t139*t218-8.40000000
     7         0000001d+0*t108*t121*t165+4.7459599999999996d-2*t108*t141
     8         -8.400000000000001d+0*t121*t125*t139+5.672746666666666d-2
     9         *t108*t139)-1.0546577777777776d-1*t160*t36*t73*t95-3.3822
     :         411899821336d-3*t1*t128*t139*t3*t38*t95-8.888888888888888
     ;         d-1*t72*t73*(4.9365923538061685d-2*t1*t3*t30*(7.5d-1*t1*t
     <         139*t157*t3*t93-5.0d-1*t1*t128*t226*t3+1.6666666666666666
     =         d-1*t1*t128*t139*t23)+2.164695365020087d-1*t1*t139*t157*t
     >         3*t93-1.4431302433467247d-1*t1*t128*t226*t3-2.46829617690
     ?         30842d-2*t1*t128*t131*t139*t3+4.810434144489082d-2*t1*t12
     @         8*t139*t23)+5.273288888888887d-2*t35*t38*(9.6208682889781
     1         66d-2*t1*t139*t157*t3*t93-6.41391219265211d-2*t1*t128*t22
     2         6*t3+2.1379707308840368d-2*t1*t128*t139*t23)+9.4545777777
     3         77778d-2*t139*t186*t32*t93-6.064083168526658d-3*t1*t127*t
     4         139*t236*t3*t93+7.57211d-1*(-1.6455307846020562d-2*gammab
     5         b*t137*t16*t61*t65*t89*t91+1.6455307846020562d-2*t16*t25*
     6         t61*t65*t91-1.6455307846020562d-2*gammabb*t118*t155*t16*t
     7         25*t65*t91-8.227653923010281d-3*gammabb*t102*t120*t139*t1
     8         6*t25*t61*t91-1.6455307846020562d-2*t16*t17*t61*t65*t88*t
     9         89-1.6455307846020562d-2*gammabb*t138*t16*t61*t65*t88*t89
     :         +1.6455307846020562d-2*gammabb*t118*t155*t16*t17*t65*t88*
     ;         t89+8.227653923010281d-3*gammabb*t102*t120*t139*t16*t17*t
     <         61*t88*t89+4.38808209227215d-2*gammabb*t137*t17*t61*t65*t
     =         78*t89-1.6455307846020562d-2*gammabb*t16*t17*t224*t61*t65
     >         *t89+1.6455307846020562d-2*gammabb*t117*t118*t137*t16*t17
     ?         *t65*t89+1.6455307846020562d-2*gammabb*t119*t120*t137*t16
     @         *t17*t61*t89+3.2910615692041123d-2*gammabb*t137*t16*t17*t
     1         173*t61*t65*t88-4.38808209227215d-2*t17*t25*t61*t65*t78-4
     2         .38808209227215d-2*gammabb*t138*t25*t61*t65*t78+4.3880820
     3         9227215d-2*gammabb*t118*t155*t17*t25*t65*t78+2.1940410461
     4         36075d-2*gammabb*t102*t120*t139*t17*t25*t61*t78+1.6455307
     5         846020562d-2*gammabb*t16*t225*t25*t61*t65-1.6455307846020
     6         562d-2*gammabb*t118*t16*t17*t235*t25*t65+3.29106156920411
     7         23d-2*gammabb*t117*t155*t16*t17*t214*t25*t65-1.6455307846
     8         020562d-2*t117*t118*t16*t17*t25*t65-1.6455307846020562d-2
     9         *gammabb*t117*t118*t138*t16*t25*t65+t226*t61*t63-t118*t23
     :         5*t59*t63+2*t117*t155*t214*t59*t63-t108*t118*t155*t63-t11
     ;         7*t118*t139*t63-t116*(t234+t233)*t59*t61+t109*t115*t139*t
     <         212*t59*t61-1.6455307846020562d-2*gammabb*t120*t16*t17*(t
     =         232+t231)*t25*t61+1.6455307846020562d-2*gammabb*t102*t119
     >         *t139*t16*t17*t216*t25*t61-1.6455307846020562d-2*t119*t12
     ?         0*t16*t17*t25*t61-1.6455307846020562d-2*gammabb*t119*t120
     @         *t138*t16*t25*t61-t115*t116*t139*t61-5.0d-1*t108*t109*t11
     1         6*t139*t61+t115*t116*t118*t155*t59+5.0d-1*t109*t116*t117*
     2         t118*t139*t59+1.6455307846020562d-2*gammabb*t118*t119*t12
     3         0*t155*t16*t17*t25+8.227653923010281d-3*gammabb*t102*t117
     4         *t118*t120*t139*t16*t17*t25)-3.2910615692041123d-2*gammab
     5         b*t137*t16*t52*t89*t91+3.2910615692041123d-2*t16*t25*t52*
     6         t91+3.2910615692041123d-2*gammabb*t107*t147*t16*t25*t91-3
     7         .2910615692041123d-2*t16*t17*t52*t88*t89-3.29106156920411
     8         23d-2*gammabb*t138*t16*t52*t88*t89-3.2910615692041123d-2*
     9         gammabb*t107*t147*t16*t17*t88*t89+8.7761641845443d-2*gamm
     :         abb*t137*t17*t52*t78*t89-3.2910615692041123d-2*gammabb*t1
     ;         6*t17*t224*t52*t89-3.2910615692041123d-2*gammabb*t106*t10
     <         7*t137*t16*t17*t89+6.582123138408225d-2*gammabb*t137*t16*
     =         t17*t173*t52*t88-8.7761641845443d-2*t17*t25*t52*t78-8.776
     >         1641845443d-2*gammabb*t138*t25*t52*t78-8.7761641845443d-2
     ?         *gammabb*t107*t147*t17*t25*t78-4.727288888888889d-2*t226*
     @         t32*t77+4.727288888888889d-2*t127*t129*t139*t77+2.6666666
     1         666666666d+0*t134*t238*t72*t75-1.0666666666666666d+1*t133
     2         *t160*t192*t72*t75+2.6666666666666666d+0*t133*t134*t166*t
     3         75+2.6666666666666666d+0*t126*t134*t160*t75-1.05465777777
     4         77776d-1*t238*t35*t36*t73-1.0546577777777776d-1*t133*t141
     5         *t36*t73+6.764482379964267d-3*t1*t128*t133*t139*t3*t35*t7
     6         3-1.0546577777777776d-1*t130*t160*t35*t73-8.8888888888888
     7         88d-1*t126*t223*t73-8.888888888888888d-1*t132*t166*t73+2.
     8         6666666666666666d+0*t133*t134*t223*t72+2.6666666666666666
     9         d+0*t132*t134*t160*t72+2.0d+0*t113*t153*t207*t59-2.0d+0*t
     :         226*t58+3.2910615692041123d-2*gammabb*t16*t225*t25*t52+5.
     ;         273288888888887d-2*t227*t36*t38+5.273288888888887d-2*t130
     <         *t141*t38+3.1639733333333325d-1*t133*t134*t160*t35*t36-1.
     =         2128166337053317d-2*t1*t129*t139*t157*t190*t3-4.727288888
     >         888889d-2*t127*t237*t28-3.2910615692041123d-2*gammabb*t10
     ?         6*t147*t16*t17*t193*t25+3.2910615692041123d-2*t106*t107*t
     @         16*t17*t25+3.2910615692041123d-2*gammabb*t106*t107*t138*t
     1         16*t25-2.0d+0*t108*t114*t153-2.0d+0*t113*t114*t139)*wght-
     2         1.2407009817987999d+0*t2*(-8.888888888888888d-1*t166*t73*
     3         t75-8.888888888888888d-1*t223*t72*t73-1.0546577777777776d
     4         -1*t160*t35*t36*t73+3.2910615692041123d-2*t16*t17*t25*t52
     5         +3.2910615692041123d-2*gammabb*t138*t16*t25*t52+t161+t159
     6         +t158+t156+t154+t150+t148+t143+t142+t140)*wght+Cmat2(iq,D
     7         2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)-9.305257363491d-
     1         1*t22*(t114*(-2.0d+0*t59*(-7.378049999999994d-2*t101*t243
     2         *t56*t97+1.475609999999999d-1*t101*t112*t139*t152*t97+7.3
     3         78049999999994d-2*t195*t239*t245*t56+3.689024999999997d-2
     4         *t101*t197*t239*t56-1.475609999999999d-1*t112*(t252+t251+
     5         t249+t248)*t50+2.951219999999998d-1*t152**2*t208*t50)-4.0
     6         d+0*t139*t153)+t107*t16*t25*(3.2910615692041123d-2*gammab
     7         b*t17*(3.04825d-1*t101*t243*t47*t97-6.0965d-1*t101*t105*t
     8         139*t146*t97+6.0965d-1*t105*(t249+t248+t247+t246)*t50-1.2
     9         193000000000001d+0*t146**2*t202*t50-3.04825d-1*t195*t239*
     :         t245*t47-1.524125d-1*t101*t197*t239*t47)+3.29106156920411
     ;         23d-2*t147*t17+3.2910615692041123d-2*gammabb*t138*t147)+t
     <         73*(-8.888888888888888d-1*t75*(-2.4d+0*t68*(6.41391219265
     =         211d-2*t123*(-gammabb*t16*t17*t241*t89-2*t137*t16*t17*t89
     >         -2*gammabb*t137*t138*t16*t89+gammabb*t16*t242*t25+2*t138*
     ?         t16*t25+2*gammabb*t16*t17*t173*t240)-5.0d-1*t122*t243+2.5
     @         d-1*t220*t239-3.206956096326055d-2*t164**2*t219)-8.400000
     1         000000001d+0*t121*t243*t71-2.1d+1*t218*t239*t71-2.7259596
     2         d+0*t243*t67+4.7459599999999996d-2*t244*t66+5.67274666666
     3         6666d-2*t243*t66-5.4519192d+0*t239*t66+4.7459599999999996
     4         d-2*t243*t35-4.9628707825354457d+0*t121*t243-1.2407176956
     5         338616d+1*t218*t239+5.672746666666666d-2*t239-1.68d+1*t12
     6         1*t139*t165+9.491919999999999d-2*t139*t141)-8.88888888888
     7         8888d-1*t72*(-2.4682961769030842d-2*t243*t39*t40*t77+4.93
     8         65923538061685d-2*t186*t239*t39*t40-1.4431302433467247d-1
     9         *t1*t128*t243*t3+2.164695365020087d-1*t1*t157*t239*t3)-1.
     :         0546577777777776d-1*t254*t35*t36-2.109315555555555d-1*t14
     ;         1*t160*t36+6.764482379964267d-3*t1*t128*t139*t160*t3*t35-
     <         1.7777777777777776d+0*t163*t166)+7.57211d-1*(-1.645530784
     =         6020562d-2*gammabb*t16*t17*t241*t61*t65*t89-3.29106156920
     >         41123d-2*t137*t16*t17*t61*t65*t89-3.2910615692041123d-2*g
     ?         ammabb*t137*t138*t16*t61*t65*t89+3.2910615692041123d-2*ga
     @         mmabb*t118*t137*t155*t16*t17*t65*t89+1.6455307846020562d-
     1         2*gammabb*t102*t120*t137*t139*t16*t17*t61*t89+1.645530784
     2         6020562d-2*gammabb*t16*t242*t25*t61*t65+3.291061569204112
     3         3d-2*t138*t16*t25*t61*t65+3.2910615692041123d-2*gammabb*t
     4         16*t17*t173*t240*t61*t65-1.6455307846020562d-2*gammabb*t1
     5         18*t16*t17*t25*t253*t65+3.2910615692041123d-2*gammabb*t16
     6         *t17*t214*t25*t250*t65-3.2910615692041123d-2*t118*t155*t1
     7         6*t17*t25*t65-3.2910615692041123d-2*gammabb*t118*t138*t15
     8         5*t16*t25*t65+t243*t61*t63-t118*t253*t59*t63+2*t214*t250*
     9         t59*t63-2*t118*t139*t155*t63+5.0d-1*t212*t239*t59*t61/t53
     :         -5.0d-1*t109*t116*t243*t59*t61+2.5d-1*t116*t209*t239*t59*
     ;         t61+8.227653923010281d-3*gammabb*t16*t17*t216*t239*t25*t6
     <         1/t42-8.227653923010281d-3*gammabb*t102*t120*t16*t17*t243
     =         *t25*t61+4.1138269615051404d-3*gammabb*t120*t16*t17*t203*
     >         t239*t25*t61-1.6455307846020562d-2*t102*t120*t139*t16*t17
     ?         *t25*t61-1.6455307846020562d-2*gammabb*t102*t120*t138*t13
     @         9*t16*t25*t61-t109*t116*t239*t61+t109*t116*t118*t139*t155
     1         *t59+1.6455307846020562d-2*gammabb*t102*t118*t120*t139*t1
     2         55*t16*t17*t25)+t16*(-3.2910615692041123d-2*gammabb*t17*t
     3         241*t52-3.2910615692041123d-2*t137*t17*t52-3.291061569204
     4         1123d-2*gammabb*t137*t138*t52-t137*t149)*t89-6.5821231384
     5         08225d-2*gammabb*t107*t137*t147*t16*t17*t89-4.72728888888
     6         8889d-2*t243*t32*t77+t134*(2.6666666666666666d+0*t254*t72
     7         *t75+2.6666666666666666d+0*t160*t166*t75+2.66666666666666
     8         66d+0*t160*t163*t72-3.0d+0*t160*t167)-1.0666666666666666d
     9         +1*t160**2*t192*t72*t75+6.764482379964267d-3*t1*t128*t139
     :         *t160*t3*t35*t73+2.0d+0*t153**2*t207*t59-2.0d+0*t243*t58+
     ;         t16*t25*(3.2910615692041123d-2*gammabb*t242*t52+6.5821231
     <         38408225d-2*t138*t52+3.2910615692041123d-2*t107*t147*t17+
     =         3.2910615692041123d-2*gammabb*t107*t138*t147)+6.582123138
     >         408225d-2*gammabb*t16*t17*t173*t240*t52+1.555779878874783
     ?         1d-3*t190*t239*t39*t40/t27**4+5.273288888888887d-2*t244*t
     @         36*t38+t128*t3*(-3.3822411899821336d-3*t1*t243*t35-6.7644
     1         82379964267d-3*t1*t139*t141)*t38+5.0733617849732d-3*t1*t1
     2         57*t239*t3*t35*t38+9.454577777777778d-2*t186*t239*t32+6.0
     3         64083168526658d-3*t1*t127*t157*t243*t3-2.1224291089843306
     4         d-2*t1*t127*t236*t239*t3-3.2910615692041123d-2*gammabb*t1
     5         47**2*t16*t17*t193*t25)*wght
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> 
C> \brief Evaluate the nwxcm_x_wpbe functional [1] 
C> 
C> \f{eqnarray*}{ 
C>   {\it t_1} &=& \rho_\alpha^{{{4}\over{3}}}\\\\ 
C>   {\it t_2} &=& {{1}\over{\rho_\alpha^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_3} &=& {{1}\over{\rho_\alpha^4}}\\\\ 
C>   {\it t_4} &=& \sqrt{\sigma_{\alpha\alpha}}\\\\ 
C>   {\it t_5} &=& {\it t_4}^3\\\\ 
C>   {\it t_6} &=& {{1}\over{\rho_\alpha^{{{16}\over{3}}}}}\\\\ 
C>   {\it t_7} &=& \sigma_{\alpha\alpha}^2\\\\ 
C>   {\it t_8} &=& {{1}\over{\rho_\alpha^{{{20}\over{3}}}}}\\\\ 
C>   {\it t_9} &=& {\it t_4}^5\\\\ 
C>   {\it t_{10}} &=& {{1}\over{\rho_\alpha^8}}\\\\ 
C>   {\it t_{11}} &=& \sigma_{\alpha\alpha}^3\\\\ 
C>   {\it t_{12}} &=& {{1}\over{\rho_\alpha^{{{28}\over{3}}}}}\\\\ 
C>   {\it t_{13}} &=& {\it t_4}^7\\\\ 
C>   {\it t_{14}} &=& 2.41238302476954 \times 10^{-8}\,{\it t_{12}}
C>    \,{\it t_{13}}-4.327677396975467 \times 10^{-7}\,{\it t_{10}}
C>    \,{\it t_{11}}+5.3020963068324 \times 10^{-6}\,{\it t_8}\,{
C>    \it t_9}-4.342399100269002 \times 10^{-5}\,{\it t_6}\,{\it t_7}
C>    +1.800551313354082 \times 10^{-4}\,{\it t_3}\,{\it t_5}
C>    +2.631878392200375 \times 10^{-4}\,{\it t_2}\,
C>    \sigma_{\alpha\alpha}\\\\ 
C>   {\it t_{15}} &=& {{1}\over{{{3.149302550983647 \times 10^{-10}
C>    \,{\it t_4}^9}\over{\rho_\alpha^{12}}}
C>    -{{5.649671283776346 \times 10^{-9}\,
C>    \sigma_{\alpha\alpha}^4}\over{\rho_\alpha^{{{32}\over{3}}}}}
C>    +1.7578986477855 \times 10^{-7}\,{\it t_{12}}\,{\it t_{13}}
C>    -2.719683267627703 \times 10^{-6}\,{\it t_{10}}\,{\it t_{11}}
C>    +5.955909787676884 \times 10^{-5}\,{\it t_8}\,{\it t_9}
C>    -0.001383706469760652\,{\it t_6}\,{\it t_7}
C>    +0.02342799068769956\,{\it t_3}\,{\it t_5}-0.2053293313026446
C>    \,{\it t_2}\,\sigma_{\alpha\alpha}+{{0.6841322473346062\,{
C>    \it t_4}}\over{{\it t_1}}}+1.0}}\\\\ 
C>   {\it t_{16}} &=& 0.01645530784602056\,{\it t_2}\,
C>    \sigma_{\alpha\alpha}\,{\it t_{14}}\,{\it t_{15}}\\\\ 
C>   {\it t_{17}} &=& {\it t_{16}}+0.60965\\\\ 
C>   {\it t_{18}} &=& 0.06934448603031025\,{\it t_2}\,
C>    \sigma_{\alpha\alpha}\,{\it t_{14}}\,{\it t_{15}}
C>    +{{0.005136628594837796\,{\it t_2}\,
C>    \sigma_{\alpha\alpha}}\over{0.00411382696150514\,{\it t_2}
C>    \,\sigma_{\alpha\alpha}+1.0}}+1.0\\\\ 
C>   {\it t_{19}} &=& {\it t_{17}}^{3.5}\\\\ 
C>   {\it t_{20}} &=& {\it t_{16}}+0.757211\\\\ 
C>   {\it t_{21}} &=& {\it param}\left(1\right)\\\\ 
C>   {\it t_{22}} &=& {{1}\over{\rho_\alpha^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{23}} &=& {\it t_{16}}+0.06582123138408225\,\left({
C>    \it t_{21}}\,{\it t_{22}}\right)^{2.0}+0.60965\\\\ 
C>   {\it t_{24}} &=& {{1}\over{\sqrt{{\it t_{23}}}}}\\\\ 
C>   {\it t_{25}} &=& 0.2565564877060844\,{\it t_{21}}\,{\it t_{22}}
C>    \,{\it t_{24}}+1.0\\\\ 
C>   {\it t_{26}} &=& {\it t_{23}}\,{\it t_{25}}\\\\ 
C>   {\it t_{27}} &=& 0.2565564877060844\,{\it t_{21}}\,{
C>    \it t_{22}}\\\\ 
C>   {\it t_{28}} &=& {\it t_{21}}^2\\\\ 
C>   {\it t_{29}} &=& {{0.06582123138408225\,{\it t_{28}}}
C>    \over{\rho_\alpha^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{30}} &=& \sqrt{{\it t_{16}}+{\it t_{29}}}\\\\ 
C>   {\it t_{31}} &=& \sqrt{{\it t_{16}}+{\it t_{29}}+0.757211}\\\\ 
C>   {\it t_{32}} &=& {{1}\over{{\it t_{31}}+{\it t_{30}}}}\\\\ 
C>   {\it t_{33}} &=& \sqrt{{\it t_{16}}+{\it t_{29}}+0.60965}\\\\ 
C>   {\it t_{34}} &=& {{1}\over{{\it t_{33}}+{\it t_{27}}}}\\\\ 
C>   {\it t_{35}} &=& \rho_\beta^{{{4}\over{3}}}\\\\ 
C>   {\it t_{36}} &=& {{1}\over{\rho_\beta^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{37}} &=& {{1}\over{\rho_\beta^4}}\\\\ 
C>   {\it t_{38}} &=& \sqrt{\sigma_{\beta\beta}}\\\\ 
C>   {\it t_{39}} &=& {\it t_{38}}^3\\\\ 
C>   {\it t_{40}} &=& {{1}\over{\rho_\beta^{{{16}\over{3}}}}}\\\\ 
C>   {\it t_{41}} &=& \sigma_{\beta\beta}^2\\\\ 
C>   {\it t_{42}} &=& {{1}\over{\rho_\beta^{{{20}\over{3}}}}}\\\\ 
C>   {\it t_{43}} &=& {\it t_{38}}^5\\\\ 
C>   {\it t_{44}} &=& {{1}\over{\rho_\beta^8}}\\\\ 
C>   {\it t_{45}} &=& \sigma_{\beta\beta}^3\\\\ 
C>   {\it t_{46}} &=& {{1}\over{\rho_\beta^{{{28}\over{3}}}}}\\\\ 
C>   {\it t_{47}} &=& {\it t_{38}}^7\\\\ 
C>   {\it t_{48}} &=& 2.41238302476954 \times 10^{-8}\,{\it t_{46}}
C>    \,{\it t_{47}}-4.327677396975467 \times 10^{-7}\,{\it t_{44}}
C>    \,{\it t_{45}}+5.3020963068324 \times 10^{-6}\,{\it t_{42}}
C>    \,{\it t_{43}}-4.342399100269002 \times 10^{-5}\,{\it t_{40}}
C>    \,{\it t_{41}}+1.800551313354082 \times 10^{-4}\,{\it t_{37}}
C>    \,{\it t_{39}}+2.631878392200375 \times 10^{-4}\,{\it t_{36}}
C>    \,\sigma_{\beta\beta}\\\\ 
C>   {\it t_{49}} &=& {{1}\over{{{3.149302550983647 \times 10^{-10}
C>    \,{\it t_{38}}^9}\over{\rho_\beta^{12}}}
C>    -{{5.649671283776346 \times 10^{-9}\,
C>    \sigma_{\beta\beta}^4}\over{\rho_\beta^{{{32}\over{3}}}}}
C>    +1.7578986477855 \times 10^{-7}\,{\it t_{46}}\,{\it t_{47}}
C>    -2.719683267627703 \times 10^{-6}\,{\it t_{44}}\,{\it t_{45}}
C>    +5.955909787676884 \times 10^{-5}\,{\it t_{42}}\,{\it t_{43}}
C>    -0.001383706469760652\,{\it t_{40}}\,{\it t_{41}}
C>    +0.02342799068769956\,{\it t_{37}}\,{\it t_{39}}
C>    -0.2053293313026446\,{\it t_{36}}\,\sigma_{\beta\beta}
C>    +{{0.6841322473346062\,{\it t_{38}}}\over{{\it t_{35}}}}
C>    +1.0}}\\\\ 
C>   {\it t_{50}} &=& 0.01645530784602056\,{\it t_{36}}\,
C>    \sigma_{\beta\beta}\,{\it t_{48}}\,{\it t_{49}}\\\\ 
C>   {\it t_{51}} &=& {\it t_{50}}+0.60965\\\\ 
C>   {\it t_{52}} &=& 0.06934448603031025\,{\it t_{36}}\,
C>    \sigma_{\beta\beta}\,{\it t_{48}}\,{\it t_{49}}
C>    +{{0.005136628594837796\,{\it t_{36}}\,
C>    \sigma_{\beta\beta}}\over{0.00411382696150514\,{\it t_{36}}
C>    \,\sigma_{\beta\beta}+1.0}}+1.0\\\\ 
C>   {\it t_{53}} &=& {\it t_{51}}^{3.5}\\\\ 
C>   {\it t_{54}} &=& {\it t_{50}}+0.757211\\\\ 
C>   {\it t_{55}} &=& {{1}\over{\rho_\beta^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{56}} &=& {\it t_{50}}+0.06582123138408225\,\left({
C>    \it t_{21}}\,{\it t_{55}}\right)^{2.0}+0.60965\\\\ 
C>   {\it t_{57}} &=& {{1}\over{\sqrt{{\it t_{56}}}}}\\\\ 
C>   {\it t_{58}} &=& 0.2565564877060844\,{\it t_{21}}\,{\it t_{55}}
C>    \,{\it t_{57}}+1.0\\\\ 
C>   {\it t_{59}} &=& {\it t_{56}}\,{\it t_{58}}\\\\ 
C>   {\it t_{60}} &=& 0.2565564877060844\,{\it t_{21}}\,{
C>    \it t_{55}}\\\\ 
C>   {\it t_{61}} &=& {{0.06582123138408225\,{\it t_{28}}}
C>    \over{\rho_\beta^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{62}} &=& \sqrt{{\it t_{50}}+{\it t_{61}}}\\\\ 
C>   {\it t_{63}} &=& \sqrt{{\it t_{50}}+{\it t_{61}}+0.757211}\\\\ 
C>   {\it t_{64}} &=& {{1}\over{{\it t_{63}}+{\it t_{62}}}}\\\\ 
C>   {\it t_{65}} &=& \sqrt{{\it t_{50}}+{\it t_{61}}+0.60965}\\\\ 
C>   {\it t_{66}} &=& {{1}\over{{\it t_{65}}+{\it t_{60}}}}\\\\ 
C>   {\it t_{67}} &=& \rho_s^{{{4}\over{3}}}\\\\ 
C>   {\it t_{68}} &=& {{1}\over{\rho_s^{{{8}\over{3}}}}}\\\\ 
C>   {\it t_{69}} &=& {{1}\over{\rho_s^4}}\\\\ 
C>   {\it t_{70}} &=& \sqrt{\sigma_{ss}}\\\\ 
C>   {\it t_{71}} &=& {\it t_{70}}^3\\\\ 
C>   {\it t_{72}} &=& {{1}\over{\rho_s^{{{16}\over{3}}}}}\\\\ 
C>   {\it t_{73}} &=& \sigma_{ss}^2\\\\ 
C>   {\it t_{74}} &=& {{1}\over{\rho_s^{{{20}\over{3}}}}}\\\\ 
C>   {\it t_{75}} &=& {\it t_{70}}^5\\\\ 
C>   {\it t_{76}} &=& {{1}\over{\rho_s^8}}\\\\ 
C>   {\it t_{77}} &=& \sigma_{ss}^3\\\\ 
C>   {\it t_{78}} &=& {{1}\over{\rho_s^{{{28}\over{3}}}}}\\\\ 
C>   {\it t_{79}} &=& {\it t_{70}}^7\\\\ 
C>   {\it t_{80}} &=& 2.41238302476954 \times 10^{-8}\,{\it t_{78}}
C>    \,{\it t_{79}}-4.327677396975467 \times 10^{-7}\,{\it t_{76}}
C>    \,{\it t_{77}}+5.3020963068324 \times 10^{-6}\,{\it t_{74}}
C>    \,{\it t_{75}}-4.342399100269002 \times 10^{-5}\,{\it t_{72}}
C>    \,{\it t_{73}}+1.800551313354082 \times 10^{-4}\,{\it t_{69}}
C>    \,{\it t_{71}}+2.631878392200375 \times 10^{-4}\,{\it t_{68}}
C>    \,\sigma_{ss}\\\\ 
C>   {\it t_{81}} &=& {{1}\over{{{3.149302550983647 \times 10^{-10}
C>    \,{\it t_{70}}^9}\over{\rho_s^{12}}}
C>    -{{5.649671283776346 \times 10^{-9}\,\sigma_{ss}^4}
C>    \over{\rho_s^{{{32}\over{3}}}}}+1.7578986477855 \times 10^{-7}
C>    \,{\it t_{78}}\,{\it t_{79}}-2.719683267627703 \times 10^{-6}
C>    \,{\it t_{76}}\,{\it t_{77}}+5.955909787676884 \times 10^{-5}
C>    \,{\it t_{74}}\,{\it t_{75}}-0.001383706469760652\,{
C>    \it t_{72}}\,{\it t_{73}}+0.02342799068769956\,{\it t_{69}}
C>    \,{\it t_{71}}-0.2053293313026446\,{\it t_{68}}\,\sigma_{ss}
C>    +{{0.6841322473346062\,{\it t_{70}}}\over{{\it t_{67}}}}
C>    +1.0}}\\\\ 
C>   {\it t_{82}} &=& 0.01645530784602056\,{\it t_{68}}\,\sigma_{ss}
C>    \,{\it t_{80}}\,{\it t_{81}}\\\\ 
C>   {\it t_{83}} &=& {\it t_{82}}+0.60965\\\\ 
C>   {\it t_{84}} &=& 0.06934448603031025\,{\it t_{68}}\,\sigma_{ss}
C>    \,{\it t_{80}}\,{\it t_{81}}+{{0.005136628594837796\,{
C>    \it t_{68}}\,\sigma_{ss}}\over{0.00411382696150514\,{
C>    \it t_{68}}\,\sigma_{ss}+1.0}}+1.0\\\\ 
C>   {\it t_{85}} &=& {\it t_{83}}^{3.5}\\\\ 
C>   {\it t_{86}} &=& {\it t_{82}}+0.757211\\\\ 
C>   {\it t_{87}} &=& {{1}\over{\rho_s^{{{1}\over{3}}}}}\\\\ 
C>   {\it t_{88}} &=& {\it t_{82}}+0.06582123138408225\,\left({
C>    \it t_{21}}\,{\it t_{87}}\right)^{2.0}+0.60965\\\\ 
C>   {\it t_{89}} &=& {{1}\over{\sqrt{{\it t_{88}}}}}\\\\ 
C>   {\it t_{90}} &=& 0.2565564877060844\,{\it t_{21}}\,{\it t_{87}}
C>    \,{\it t_{89}}+1.0\\\\ 
C>   {\it t_{91}} &=& {\it t_{88}}\,{\it t_{90}}\\\\ 
C>   {\it t_{92}} &=& 0.2565564877060844\,{\it t_{21}}\,{
C>    \it t_{87}}\\\\ 
C>   {\it t_{93}} &=& {{0.06582123138408225\,{\it t_{28}}}
C>    \over{\rho_s^{{{2}\over{3}}}}}\\\\ 
C>   {\it t_{94}} &=& \sqrt{{\it t_{82}}+{\it t_{93}}}\\\\ 
C>   {\it t_{95}} &=& \sqrt{{\it t_{82}}+{\it t_{93}}+0.757211}\\\\ 
C>   {\it t_{96}} &=& {{1}\over{{\it t_{95}}+{\it t_{94}}}}\\\\ 
C>   {\it t_{97}} &=& \sqrt{{\it t_{82}}+{\it t_{93}}+0.60965}\\\\ 
C>   {\it t_{98}} &=& {{1}\over{{\it t_{97}}+{\it t_{92}}}}\\\\ 
C>   f &=& -0.9305257363491\,{\it t_{35}}\,\left(-2.0\,{\it t_{54}}
C>    \,\log \left({{0.1475609999999999\,{\it t_{66}}}\over{{
C>    \it t_{63}}+{\it t_{65}}}}+1.0\right)+0.03291061569204112\,{
C>    \it t_{36}}\,\sigma_{\beta\beta}\,{\it t_{48}}\,{\it t_{49}}
C>    \,\log \left(1.0-{{0.60965\,{\it t_{66}}}\over{{\it t_{65}}
C>    +{\it t_{62}}}}\right)+0.757211\,\left({{{\it t_{54}}\,{
C>    \it t_{64}}}\over{{\it t_{63}}+{\it t_{60}}}}
C>    +{{0.01645530784602056\,{\it t_{36}}\,\sigma_{\beta\beta}\,{
C>    \it t_{48}}\,{\it t_{49}}\,{\it t_{64}}}\over{{\it t_{62}}+{
C>    \it t_{60}}}}\right)+{{0.05273288888888888\,{\it t_{52}}
C>    \,\left(0.1282782438530422\,{\it t_{21}}\,{\it t_{55}}\,{
C>    \it t_{57}}+1.0\right)}\over{{\it t_{59}}^{2.0}}}
C>    +{{0.04727288888888889}\over{{\it t_{56}}\,{\it t_{58}}}}
C>    -{{0.8888888888888888\,\left(-2.4\,{\it t_{53}}\,
C>    \left(0.1282782438530422\,\sqrt{{\it t_{36}}\,
C>    \sigma_{\beta\beta}\,{\it t_{48}}\,{\it t_{49}}}-\sqrt{{
C>    \it t_{54}}}\right)-1.417963080724413\,{\it t_{53}}-0.9086532
C>    \,{\it t_{51}}^{3.0}+0.02836373333333333\,{\it t_{51}}^{2.0}
C>    +0.0474596\,{\it t_{51}}\,{\it t_{52}}\right)\,
C>    \left(0.02468296176903084\,\left({\it t_{21}}\,{\it t_{55}}
C>    \,{\it t_{57}}\right)^{2.0}+0.2886260486693449\,{\it t_{21}}
C>    \,{\it t_{55}}\,{\it t_{57}}+1.0\right)}\over{{
C>    \it t_{59}}^{3.0}}}-1.0\right)-0.9305257363491\,{\it t_1}
C>    \,\left(-2.0\,{\it t_{20}}\,\log \left({{0.1475609999999999
C>    \,{\it t_{34}}}\over{{\it t_{31}}+{\it t_{33}}}}+1.0\right)
C>    +0.03291061569204112\,{\it t_2}\,\sigma_{\alpha\alpha}\,{
C>    \it t_{14}}\,{\it t_{15}}\,\log \left(1.0-{{0.60965\,{
C>    \it t_{34}}}\over{{\it t_{33}}+{\it t_{30}}}}\right)+0.757211
C>    \,\left({{{\it t_{20}}\,{\it t_{32}}}\over{{\it t_{31}}+{
C>    \it t_{27}}}}+{{0.01645530784602056\,{\it t_2}\,
C>    \sigma_{\alpha\alpha}\,{\it t_{14}}\,{\it t_{15}}\,{
C>    \it t_{32}}}\over{{\it t_{30}}+{\it t_{27}}}}\right)
C>    +{{0.05273288888888888\,{\it t_{18}}\,\left(0.1282782438530422
C>    \,{\it t_{21}}\,{\it t_{22}}\,{\it t_{24}}+1.0\right)}
C>    \over{{\it t_{26}}^{2.0}}}+{{0.04727288888888889}\over{{
C>    \it t_{23}}\,{\it t_{25}}}}-{{0.8888888888888888\,\left(-2.4
C>    \,{\it t_{19}}\,\left(0.1282782438530422\,\sqrt{{\it t_2}
C>    \,\sigma_{\alpha\alpha}\,{\it t_{14}}\,{\it t_{15}}}-\sqrt{{
C>    \it t_{20}}}\right)-1.417963080724413\,{\it t_{19}}-0.9086532
C>    \,{\it t_{17}}^{3.0}+0.02836373333333333\,{\it t_{17}}^{2.0}
C>    +0.0474596\,{\it t_{17}}\,{\it t_{18}}\right)\,
C>    \left(0.02468296176903084\,\left({\it t_{21}}\,{\it t_{22}}
C>    \,{\it t_{24}}\right)^{2.0}+0.2886260486693449\,{\it t_{21}}
C>    \,{\it t_{22}}\,{\it t_{24}}+1.0\right)}\over{{
C>    \it t_{26}}^{3.0}}}-1.0\right)\\\\ 
C>   g &=& 0\\\\ 
C>   G &=& -0.9305257363491\,{\it t_{67}}\,\left(-2.0\,{\it t_{86}}
C>    \,\log \left({{0.1475609999999999\,{\it t_{98}}}\over{{
C>    \it t_{95}}+{\it t_{97}}}}+1.0\right)+0.03291061569204112\,{
C>    \it t_{68}}\,\sigma_{ss}\,{\it t_{80}}\,{\it t_{81}}
C>    \,\log \left(1.0-{{0.60965\,{\it t_{98}}}\over{{\it t_{97}}
C>    +{\it t_{94}}}}\right)+0.757211\,\left({{{\it t_{86}}\,{
C>    \it t_{96}}}\over{{\it t_{95}}+{\it t_{92}}}}
C>    +{{0.01645530784602056\,{\it t_{68}}\,\sigma_{ss}\,{
C>    \it t_{80}}\,{\it t_{81}}\,{\it t_{96}}}\over{{\it t_{94}}+{
C>    \it t_{92}}}}\right)+{{0.05273288888888888\,{\it t_{84}}
C>    \,\left(0.1282782438530422\,{\it t_{21}}\,{\it t_{87}}\,{
C>    \it t_{89}}+1.0\right)}\over{{\it t_{91}}^{2.0}}}
C>    +{{0.04727288888888889}\over{{\it t_{88}}\,{\it t_{90}}}}
C>    -{{0.8888888888888888\,\left(-2.4\,{\it t_{85}}\,
C>    \left(0.1282782438530422\,\sqrt{{\it t_{68}}\,\sigma_{ss}\,{
C>    \it t_{80}}\,{\it t_{81}}}-\sqrt{{\it t_{86}}}\right)
C>    -1.417963080724413\,{\it t_{85}}-0.9086532\,{\it t_{83}}^{3.0}
C>    +0.02836373333333333\,{\it t_{83}}^{2.0}+0.0474596\,{
C>    \it t_{83}}\,{\it t_{84}}\right)\,\left(0.02468296176903084
C>    \,\left({\it t_{21}}\,{\it t_{87}}\,{\it t_{89}}\right)^{2.0}
C>    +0.2886260486693449\,{\it t_{21}}\,{\it t_{87}}\,{\it t_{89}}
C>    +1.0\right)}\over{{\it t_{91}}^{3.0}}}-1.0\right)\\\\ 
C> \f} 
C> 
C> Code generated with Maxima 5.34.0 [2] 
C> driven by autoxc [3]. 
C> 
C> ### References ### 
C> 
C> [1] E Weintraub, TM Henderson, GE Scuseria
C>    , J.Chem.Theory.Comput. 5, 754 (2009)  , DOI: 
C> <a href="https://doi.org/10.1021/ct800530u "> 
C> 10.1021/ct800530u </a> 
C> 
C> [2] Maxima, a computer algebra system, 
C> <a href="http://maxima.sourceforge.net/"> 
C> http://maxima.sourceforge.net/</a> 
C> 
C> [3] autoxc, revision 27097 2015-05-08 
C> 
      subroutine nwxcm_x_wpbe_d3(param,tol_rho,ipol,nq,wght, 
     +rho,rgamma,fnc,Amat,Amat2,Amat3, 
     +Cmat,Cmat2,Cmat3) 
c $Id: $ 
#ifdef NWXC_QUAD_PREC 
      implicit real(kind=selected_real_kind(30))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(30) 
#else 
      implicit real(kind=selected_real_kind(15))(a-h,o-z),integer(i-n) 
      integer, parameter :: rk=selected_real_kind(15) 
#endif 
#include "nwxc_param.fh" 
      double precision param(*)     !< [Input] Parameters of functional 
      double precision tol_rho      !< [Input] The lower limit on the density 
      integer ipol                  !< [Input] The number of spin channels 
      integer nq                    !< [Input] The number of points 
      double precision wght         !< [Input] The weight of the functional 
      double precision rho(nq,*)    !< [Input] The density 
      double precision rgamma(nq,*) !< [Input] The norm of the density 
                                    !< gradients 
      double precision fnc(nq)      !< [Output] The value of the functional 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat(nq,*)   !< [Output] The derivative wrt rho 
      double precision Cmat(nq,*)   !< [Output] The derivative wrt rgamma 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat2(nq,*)  !< [Output] The 2nd derivative wrt rho 
      double precision Cmat2(nq,*)  !< [Output] The 2nd derivative wrt rgamma 
                                    !< and possibly rho 
c 
c     Sampling Matrices for the XC Kernel 
c 
      double precision Amat3(nq,*)  !< [Output] The 3rd derivative wrt rho 
      double precision Cmat3(nq,*)  !< [Output] The 3rd derivative wrt rgamma 
                                    !< and possibly rho 
      integer iq 
      double precision tmp 
      double precision rhoa,rhob 
      double precision gammaaa,gammaab,gammabb 
      double precision taua,taub 
      double precision nwxcm_heaviside 
      external         nwxcm_heaviside 
CDIR$ NOVECTOR
      do iq = 1, nq 
        if (ipol.eq.1) then 
          rhoa    = 0.5d0*rho(iq,R_T) 
          gammaaa = 0.25d0*rgamma(iq,G_TT) 
          if (rhoa.gt.tol_rho) then 
            t1 = param(1)
            t2 = rhoa**3.333333333333333d-1
            t3 = 1/t2
            t4 = gammaaa**5.0d-1
            t5 = t4**7
            t6 = 1/rhoa**9.333333333333333d+0
            t7 = gammaaa**3
            t8 = 1/rhoa**8
            t9 = t4**5
            t10 = 1/rhoa**6.666666666666667d+0
            t11 = gammaaa**2
            t12 = 1/rhoa**5.333333333333333d+0
            t13 = t4**3
            t14 = 1/rhoa**4
            t15 = 1/rhoa**2.6666666666666666d+0
            t16 = 5.3020963068324d-6*t10*t9-4.327677396975467d-7*t7*t8+2
     1         .4123830247695402d-8*t5*t6+2.631878392200375d-4*gammaaa*t
     2         15+1.8005513133540818d-4*t13*t14-4.342399100269002d-5*t11
     3         *t12
            t17 = t4**9
            t18 = 1/rhoa**12
            t19 = gammaaa**4
            t20 = 1/rhoa**1.0666666666666666d+1
            t21 = rhoa**1.3333333333333333d+0
            t22 = 1/t21
            t23 = 5.955909787676884d-5*t10*t9-2.7196832676277033d-6*t7*t
     1         8+1.7578986477855002d-7*t5*t6+6.841322473346062d-1*t22*t4
     2         -5.649671283776346d-9*t19*t20+3.149302550983647d-10*t17*t
     3         18-2.0532933130264455d-1*gammaaa*t15+2.342799068769956d-2
     4         *t13*t14-1.3837064697606524d-3*t11*t12+1.0d+0
            t24 = 1/t23
            t25 = 1.6455307846020562d-2*gammaaa*t15*t16*t24
            t26 = 6.582123138408225d-2*(t1*t3)**2.0d+0+t25+6.0965d-1
            t27 = 1/t26
            t28 = t26**5.0d-1
            t29 = 1/t28
            t30 = 2.565564877060844d-1*t1*t29*t3+1.0d+0
            t31 = 1/t30
            t32 = 4.1138269615051404d-3*gammaaa*t15+1.0d+0
            t33 = 1/t32
            t34 = 5.136628594837797d-3*gammaaa*t15*t33+6.934448603031025
     1         d-2*gammaaa*t15*t16*t24+1.0d+0
            t35 = 1.282782438530422d-1*t1*t29*t3+1.0d+0
            t36 = t26*t30
            t37 = 1/t36**2.0d+0
            t38 = t1**2
            t39 = 1/rhoa**6.666666666666666d-1
            t40 = 6.582123138408225d-2*t38*t39
            t41 = t40+t25
            t42 = t41**5.0d-1
            t43 = t40+t25+6.0965d-1
            t44 = t43**5.0d-1
            t45 = t44+t42
            t46 = 1/t45
            t47 = 2.565564877060844d-1*t1*t3
            t48 = t47+t44
            t49 = 1/t48
            t50 = 1.0d+0-6.0965d-1*t46*t49
            t51 = log(t50)
            t52 = t40+t25+7.57211d-1
            t53 = t52**5.0d-1
            t54 = t53+t44
            t55 = 1/t54
            t56 = 1.475609999999999d-1*t49*t55+1.0d+0
            t57 = log(t56)
            t58 = t25+7.57211d-1
            t59 = t53+t42
            t60 = 1/t59
            t61 = t53+t47
            t62 = 1/t61
            t63 = t47+t42
            t64 = 1/t63
            t65 = t25+6.0965d-1
            t66 = t65**2.0d+0
            t67 = t65**3.5d+0
            t68 = (gammaaa*t15*t16*t24)**5.0d-1
            t69 = t58**5.0d-1
            t70 = 1.282782438530422d-1*t68-t69
            t71 = -2.4d+0*t67*t70-1.417963080724413d+0*t67+2.83637333333
     1         3333d-2*t66-9.086532d-1*t65**3.0d+0+4.7459599999999996d-2
     2         *t34*t65
            t72 = 1/t36**3.0d+0
            t73 = 2.4682961769030842d-2*(t1*t29*t3)**2.0d+0+2.8862604866
     1         934494d-1*t1*t29*t3+1.0d+0
            t74 = -8.888888888888888d-1*t71*t72*t73+7.57211d-1*(1.645530
     1         7846020562d-2*gammaaa*t15*t16*t24*t60*t64+t58*t60*t62)-2.
     2         0d+0*t57*t58+3.2910615692041123d-2*gammaaa*t15*t16*t24*t5
     3         1+5.273288888888887d-2*t34*t35*t37+4.727288888888889d-2*t
     4         27*t31-1.0d+0
            t75 = 1/t26**2
            t76 = 1/rhoa**3.6666666666666664d+0
            t77 = -4.38808209227215d-2*gammaaa*t16*t24*t76
            t78 = 1/rhoa**13
            t79 = 1/rhoa**1.1666666666666665d+1
            t80 = 1/rhoa**1.0333333333333333d+1
            t81 = 1/rhoa**9
            t82 = 1/rhoa**7.666666666666667d+0
            t83 = 1/rhoa**6.333333333333333d+0
            t84 = 1/rhoa**5
            t85 = 1/rhoa**2.3333333333333334d+0
            t86 = -3.970606525117923d-4*t82*t9-9.121763297794749d-1*t4*t
     1         85-9.371196275079824d-2*t13*t84+7.379767838723479d-3*t11*
     2         t83+2.1757466141021625d-5*t7*t81-1.6407054045998d-6*t5*t8
     3         0+6.026316036028103d-8*t19*t79-3.7791630611803767d-9*t17*
     4         t78+5.475448834737188d-1*gammaaa*t76
            t87 = 1/t23**2
            t88 = -1.6455307846020562d-2*gammaaa*t15*t16*t86*t87
            t89 = -3.5347308712216d-5*t82*t9-7.202205253416327d-4*t13*t8
     1         4+2.3159461868101344d-4*t11*t83+3.462141917580374d-6*t7*t
     2         81-2.2515574897849044d-7*t5*t80-7.018342379201d-4*gammaaa
     3         *t76
            t90 = 1.6455307846020562d-2*gammaaa*t15*t24*t89
            t91 = 1/rhoa**1.6666666666666669d+0
            t92 = -4.38808209227215d-2*t38*t91+t90+t88+t77
            t93 = 1/t32**2
            t94 = 5.634986987915197d-5*t11*t83*t93+6.934448603031025d-2*
     1         gammaaa*t15*t24*t89-6.934448603031025d-2*gammaaa*t15*t16*
     2         t86*t87-1.369767625290079d-2*gammaaa*t33*t76-1.8491862941
     3         416065d-1*gammaaa*t16*t24*t76
            t95 = 1/t44
            t96 = 5.0d-1*t92*t95
            t97 = -8.551882923536147d-2*t1*t22
            t98 = t97+t96
            t99 = 1/t48**2
            t100 = 1/t42
            t101 = 5.0d-1*t100*t92
            t102 = t96+t101
            t103 = 1/t45**2
            t104 = 6.0965d-1*t46*t98*t99+6.0965d-1*t102*t103*t49
            t105 = 1/t50
            t106 = t90+t88+t77
            t107 = 1/t53
            t108 = 5.0d-1*t107*t92
            t109 = t96+t108
            t110 = 1/t54**2
            t111 = -1.475609999999999d-1*t55*t98*t99-1.475609999999999d-
     1         1*t109*t110*t49
            t112 = 1/t56
            t113 = t97+t108
            t114 = 1/t61**2
            t115 = t108+t101
            t116 = 1/t59**2
            t117 = t97+t101
            t118 = 1/t63**2
            t119 = t65**2.5d+0
            t120 = 1/t69
            t121 = 1/t68
            t122 = gammaaa*t15*t24*t89-gammaaa*t15*t16*t86*t87-2.6666666
     1         666666666d+0*gammaaa*t16*t24*t76
            t123 = 6.41391219265211d-2*t121*t122-5.0d-1*t106*t120
            t124 = 4.7459599999999996d-2*t65*t94-8.400000000000001d+0*t1
     1         06*t119*t70-2.4d+0*t123*t67-2.7259596d+0*t106*t66+5.67274
     2         6666666666d-2*t106*t65+4.7459599999999996d-2*t106*t34-4.9
     3         628707825354457d+0*t106*t119
            t125 = 1/t30**2
            t126 = 1/t28**3
            t127 = -1.282782438530422d-1*t1*t126*t3*t92-8.55188292353614
     1         7d-2*t1*t22*t29
            t128 = -6.41391219265211d-2*t1*t126*t3*t92-4.275941461768073
     1         5d-2*t1*t22*t29
            t129 = -5.0d-1*t1*t126*t3*t92-3.333333333333333d-1*t1*t22*t2
     1         9
            t130 = -1.4431302433467247d-1*t1*t126*t3*t92+4.9365923538061
     1         685d-2*t1*t129*t29*t3-9.620868288978164d-2*t1*t22*t29
            t131 = t30*t92+t127*t26
            t132 = 1/t36**4.0d+0
            t133 = 5.273288888888887d-2*t35*t37*t94-4.727288888888889d-2
     1         *t31*t75*t92+7.57211d-1*(1.6455307846020562d-2*gammaaa*t1
     2         5*t24*t60*t64*t89-1.6455307846020562d-2*gammaaa*t15*t16*t
     3         60*t64*t86*t87-4.38808209227215d-2*gammaaa*t16*t24*t60*t6
     4         4*t76-1.6455307846020562d-2*gammaaa*t115*t116*t15*t16*t24
     5         *t64+t106*t60*t62-t115*t116*t58*t62-t113*t114*t58*t60-1.6
     6         455307846020562d-2*gammaaa*t117*t118*t15*t16*t24*t60)+3.2
     7         910615692041123d-2*gammaaa*t15*t24*t51*t89-3.291061569204
     8         1123d-2*gammaaa*t15*t16*t51*t86*t87-8.7761641845443d-2*ga
     9         mmaaa*t16*t24*t51*t76-8.888888888888888d-1*t124*t72*t73+2
     :         .6666666666666666d+0*t131*t132*t71*t73-8.888888888888888d
     ;         -1*t130*t71*t72-1.0546577777777776d-1*t131*t34*t35*t72-2.
     <         0d+0*t111*t112*t58-2.0d+0*t106*t57+5.273288888888887d-2*t
     =         128*t34*t37-4.727288888888889d-2*t125*t127*t27+3.29106156
     >         92041123d-2*gammaaa*t104*t105*t15*t16*t24
            t134 = 1/t4
            t135 = 6.15264526724925d-7*t6*t9-8.159049802883108d-6*t11*t8
     1         -2.2598685135105387d-8*t20*t7+1.4171861479426412d-9*t18*t
     2         5+3.514198603154934d-2*t14*t4+3.420661236673031d-1*t134*t
     3         22-2.0532933130264455d-1*t15+1.488977446919221d-4*t10*t13
     4         -2.767412939521305d-3*gammaaa*t12
            t136 = 8.443340586693391d-8*t6*t9-1.2983032190926402d-6*t11*
     1         t8+2.7008269700311227d-4*t14*t4+2.631878392200375d-4*t15+
     2         1.3255240767081d-5*t10*t13-8.684798200538004d-5*gammaaa*t
     3         12
            t137 = -1.6455307846020562d-2*gammaaa*t135*t15*t16*t87+1.645
     1         5307846020562d-2*t15*t16*t24+1.6455307846020562d-2*gammaa
     2         a*t136*t15*t24
            t138 = -4.727288888888889d-2*t137*t31*t75
            t139 = -2.113120120468199d-5*gammaaa*t12*t93-6.9344486030310
     1         25d-2*gammaaa*t135*t15*t16*t87+5.136628594837797d-3*t15*t
     2         33+6.934448603031025d-2*t15*t16*t24+6.934448603031025d-2*
     3         gammaaa*t136*t15*t24
            t140 = 5.273288888888887d-2*t139*t35*t37
            t141 = -3.2910615692041123d-2*gammaaa*t135*t15*t16*t51*t87
            t142 = 5.0d-1*t100*t137
            t143 = 5.0d-1*t137*t95
            t144 = t143+t142
            t145 = 3.04825d-1*t137*t46*t95*t99+6.0965d-1*t103*t144*t49
            t146 = 3.2910615692041123d-2*gammaaa*t105*t145*t15*t16*t24
            t147 = 3.2910615692041123d-2*t16*t51+3.2910615692041123d-2*g
     1         ammaaa*t136*t51
            t148 = -2.0d+0*t137*t57
            t149 = 5.0d-1*t107*t137
            t150 = t149+t143
            t151 = -7.378049999999994d-2*t137*t55*t95*t99-1.475609999999
     1         999d-1*t110*t150*t49
            t152 = -2.0d+0*t112*t151*t58
            t153 = t149+t142
            t154 = 7.57211d-1*(-1.6455307846020562d-2*gammaaa*t135*t15*t
     1         16*t60*t64*t87+1.6455307846020562d-2*t15*t16*t24*t60*t64+
     2         1.6455307846020562d-2*gammaaa*t136*t15*t24*t60*t64-1.6455
     3         307846020562d-2*gammaaa*t116*t15*t153*t16*t24*t64+t137*t6
     4         0*t62-t116*t153*t58*t62-5.0d-1*t107*t114*t137*t58*t60-8.2
     5         27653923010281d-3*gammaaa*t100*t118*t137*t15*t16*t24*t60)
            t155 = 1/t28**5
            t156 = 6.064083168526658d-3*t1*t125*t137*t155*t3
            t157 = -3.3822411899821336d-3*t1*t126*t137*t3*t34*t37
            t158 = t137*t30-1.282782438530422d-1*t1*t137*t29*t3
            t159 = 2.6666666666666666d+0*t132*t158*t71*t73
            t160 = -2.4682961769030842d-2*t137*t38*t39*t75-1.44313024334
     1         67247d-1*t1*t126*t137*t3
            t161 = -gammaaa*t135*t15*t16*t87+t15*t16*t24+gammaaa*t136*t1
     1         5*t24
            t162 = 6.41391219265211d-2*t121*t161-5.0d-1*t120*t137
            t163 = -8.400000000000001d+0*t119*t137*t70-2.4d+0*t162*t67-2
     1         .7259596d+0*t137*t66+4.7459599999999996d-2*t139*t65+5.672
     2         746666666666d-2*t137*t65+4.7459599999999996d-2*t137*t34-4
     3         .9628707825354457d+0*t119*t137
            t164 = -8.888888888888888d-1*t163*t73-8.888888888888888d-1*t
     1         160*t71-1.0546577777777776d-1*t158*t34*t35
            t165 = 1/rhoa**4.666666666666667d+0
            t166 = 1.6089634338331216d-1*gammaaa*t16*t165*t24
            t167 = 8.7761641845443d-2*gammaaa*t16*t76*t86*t87
            t168 = -8.7761641845443d-2*gammaaa*t24*t76*t89
            t169 = t86**2
            t170 = 1/t23**3
            t171 = 3.2910615692041123d-2*gammaaa*t15*t16*t169*t170
            t172 = 1/rhoa**14
            t173 = 1/rhoa**1.2666666666666665d+1
            t174 = 1/rhoa**1.1333333333333334d+1
            t175 = 1/rhoa**10
            t176 = 1/rhoa**8.666666666666666d+0
            t177 = 1/rhoa**7.333333333333333d+0
            t178 = 1/rhoa**6
            t179 = 1/rhoa**3.3333333333333337d+0
            t180 = 3.0441316692570747d-3*t176*t9-1.9581719526919464d-4*t
     1         175*t7+1.695395584753127d-5*t174*t5+2.1284114361521084d+0
     2         *t179*t4-7.030702042032786d-7*t173*t19+4.685598137539912d
     3         -1*t13*t178-4.6738529645248705d-2*t11*t177+4.912911979534
     4         4894d-8*t17*t172-2.0076645727369685d+0*gammaaa*t165
            t181 = -1.6455307846020562d-2*gammaaa*t15*t16*t180*t87
            t182 = -3.2910615692041123d-2*gammaaa*t15*t86*t87*t89
            t183 = 2.709960334603227d-4*t176*t9-3.115927725822337d-5*t17
     1         5*t7+2.326609406111068d-6*t174*t5+3.6011026267081636d-3*t
     2         13*t178-1.466765918313085d-3*t11*t177+2.5733922057070335d
     3         -3*gammaaa*t165
            t184 = 1.6455307846020562d-2*gammaaa*t15*t183*t24
            t185 = 7.313470153786916d-2*t15*t38+t184+t182+t181+t171+t168
     1         +t167+t166
            t186 = 1/t26**3
            t187 = t92**2
            t188 = 1/t32**3
            t189 = -5.071488289123677d-4*t11*t177*t93-1.386889720606205d
     1         -1*gammaaa*t15*t86*t87*t89-3.698372588283213d-1*gammaaa*t
     2         24*t76*t89+3.698372588283213d-1*gammaaa*t16*t76*t86*t87-6
     3         .934448603031025d-2*gammaaa*t15*t16*t180*t87+1.2363392745
     4         928628d-6*t175*t188*t7+5.02248129273029d-2*gammaaa*t165*t
     5         33+6.934448603031025d-2*gammaaa*t15*t183*t24+6.7803497451
     6         85891d-1*gammaaa*t16*t165*t24+1.386889720606205d-1*gammaa
     7         a*t15*t16*t169*t170
            t190 = 1/t30**3
            t191 = t127**2
            t192 = t131**2
            t193 = 1/t36**5.0d+0
            t194 = t104**2
            t195 = 1/t50**2
            t196 = t98**2
            t197 = 1/t48**3
            t198 = 1/t44**3
            t199 = -2.5d-1*t187*t198
            t200 = 5.0d-1*t185*t95
            t201 = 1.1402510564714863d-1*t1*t85
            t202 = t201+t200+t199
            t203 = t102**2
            t204 = 1/t45**3
            t205 = 1/t42**3
            t206 = -2.5d-1*t187*t205
            t207 = 5.0d-1*t100*t185
            t208 = t207+t206+t200+t199
            t209 = -1.2193000000000001d+0*t102*t103*t98*t99+6.0965d-1*t2
     1         02*t46*t99+6.0965d-1*t103*t208*t49-1.2193000000000001d+0*
     2         t203*t204*t49-1.2193000000000001d+0*t196*t197*t46
            t210 = t184+t182+t181+t171+t168+t167+t166
            t211 = t111**2
            t212 = 1/t56**2
            t213 = t109**2
            t214 = 1/t54**3
            t215 = 1/t53**3
            t216 = -2.5d-1*t187*t215
            t217 = 5.0d-1*t107*t185
            t218 = t217+t216+t200+t199
            t219 = 2.951219999999998d-1*t109*t110*t98*t99-1.475609999999
     1         999d-1*t202*t55*t99+2.951219999999998d-1*t196*t197*t55-1.
     2         475609999999999d-1*t110*t218*t49+2.951219999999998d-1*t21
     3         3*t214*t49
            t220 = t113**2
            t221 = 1/t61**3
            t222 = t217+t216+t201
            t223 = t115**2
            t224 = 1/t59**3
            t225 = t217+t216+t207+t206
            t226 = t117**2
            t227 = 1/t63**3
            t228 = t207+t206+t201
            t229 = t106**2
            t230 = t65**1.5d+0
            t231 = 1/t68**3
            t232 = t122**2
            t233 = 1/t69**3
            t234 = -2*gammaaa*t15*t86*t87*t89-5.333333333333333d+0*gamma
     1         aa*t24*t76*t89+5.333333333333333d+0*gammaaa*t16*t76*t86*t
     2         87-gammaaa*t15*t16*t180*t87+gammaaa*t15*t183*t24+9.777777
     3         777777779d+0*gammaaa*t16*t165*t24+2*gammaaa*t15*t16*t169*
     4         t170
            t235 = 6.41391219265211d-2*t121*t234+2.5d-1*t229*t233-3.2069
     1         56096326055d-2*t231*t232-5.0d-1*t120*t210
            t236 = 9.491919999999999d-2*t106*t94-2.1d+1*t229*t230*t70-8.
     1         400000000000001d+0*t119*t210*t70-2.4d+0*t235*t67-2.725959
     2         6d+0*t210*t66-5.4519192d+0*t229*t65+5.672746666666666d-2*
     3         t210*t65+4.7459599999999996d-2*t189*t65+4.745959999999999
     4         6d-2*t210*t34-1.2407176956338616d+1*t229*t230+5.672746666
     5         666666d-2*t229-4.9628707825354457d+0*t119*t210-1.68d+1*t1
     6         06*t119*t123
            t237 = 4.2759414617680735d-2*t1*t126*t22*t92+5.7012552823574
     1         31d-2*t1*t29*t85+9.620868288978166d-2*t1*t155*t187*t3-6.4
     2         1391219265211d-2*t1*t126*t185*t3
            t238 = 8.551882923536147d-2*t1*t126*t22*t92+1.14025105647148
     1         63d-1*t1*t29*t85+1.924173657795633d-1*t1*t155*t187*t3-1.2
     2         82782438530422d-1*t1*t126*t185*t3
            t239 = 3.333333333333333d-1*t1*t126*t22*t92+4.44444444444444
     1         4d-1*t1*t29*t85+7.5d-1*t1*t155*t187*t3-5.0d-1*t1*t126*t18
     2         5*t3
            t240 = 9.620868288978164d-2*t1*t126*t22*t92+1.28278243853042
     1         18d-1*t1*t29*t85+4.9365923538061685d-2*t1*t239*t29*t3+2.1
     2         64695365020087d-1*t1*t155*t187*t3-1.4431302433467247d-1*t
     3         1*t126*t185*t3+4.9365923538061685d-2*t129**2
            t241 = 2*t127*t92+t185*t30+t238*t26
            t242 = -2.109315555555555d-1*t131*t35*t72*t94+1.054657777777
     1         7776d-1*t128*t37*t94+9.454577777777778d-2*t125*t127*t75*t
     2         92+7.57211d-1*(-3.2910615692041123d-2*gammaaa*t15*t60*t64
     3         *t86*t87*t89-8.7761641845443d-2*gammaaa*t24*t60*t64*t76*t
     4         89-3.2910615692041123d-2*gammaaa*t115*t116*t15*t24*t64*t8
     5         9-3.2910615692041123d-2*gammaaa*t117*t118*t15*t24*t60*t89
     6         +8.7761641845443d-2*gammaaa*t16*t60*t64*t76*t86*t87+3.291
     7         0615692041123d-2*gammaaa*t115*t116*t15*t16*t64*t86*t87+3.
     8         2910615692041123d-2*gammaaa*t117*t118*t15*t16*t60*t86*t87
     9         -1.6455307846020562d-2*gammaaa*t15*t16*t180*t60*t64*t87+8
     :         .7761641845443d-2*gammaaa*t115*t116*t16*t24*t64*t76+8.776
     ;         1641845443d-2*gammaaa*t117*t118*t16*t24*t60*t76+1.6455307
     <         846020562d-2*gammaaa*t15*t183*t24*t60*t64+1.6089634338331
     =         216d-1*gammaaa*t16*t165*t24*t60*t64+3.2910615692041123d-2
     >         *gammaaa*t15*t16*t169*t170*t60*t64-1.6455307846020562d-2*
     ?         gammaaa*t116*t15*t16*t225*t24*t64+3.2910615692041123d-2*g
     @         ammaaa*t15*t16*t223*t224*t24*t64+t210*t60*t62-t116*t225*t
     1         58*t62+2*t223*t224*t58*t62-2*t106*t115*t116*t62-t114*t222
     2         *t58*t60+2*t220*t221*t58*t60-1.6455307846020562d-2*gammaa
     3         a*t118*t15*t16*t228*t24*t60+3.2910615692041123d-2*gammaaa
     4         *t15*t16*t226*t227*t24*t60-2*t106*t113*t114*t60+2*t113*t1
     5         14*t115*t116*t58+3.2910615692041123d-2*gammaaa*t115*t116*
     6         t117*t118*t15*t16*t24)-6.582123138408225d-2*gammaaa*t15*t
     7         51*t86*t87*t89-1.75523283690886d-1*gammaaa*t24*t51*t76*t8
     8         9+6.582123138408225d-2*gammaaa*t104*t105*t15*t24*t89+1.75
     9         523283690886d-1*gammaaa*t16*t51*t76*t86*t87-6.58212313840
     :         8225d-2*gammaaa*t104*t105*t15*t16*t86*t87-3.2910615692041
     ;         123d-2*gammaaa*t15*t16*t180*t51*t87-1.75523283690886d-1*g
     <         ammaaa*t104*t105*t16*t24*t76-4.727288888888889d-2*t185*t3
     =         1*t75-8.888888888888888d-1*t236*t72*t73+2.666666666666666
     >         6d+0*t132*t241*t71*t73-1.0666666666666666d+1*t192*t193*t7
     ?         1*t73+5.333333333333333d+0*t124*t131*t132*t73-8.888888888
     @         888888d-1*t240*t71*t72-1.0546577777777776d-1*t241*t34*t35
     1         *t72-2.109315555555555d-1*t128*t131*t34*t72-1.77777777777
     2         77776d+0*t124*t130*t72+5.333333333333333d+0*t130*t131*t13
     3         2*t71-2.0d+0*t112*t219*t58+2.0d+0*t211*t212*t58-2.0d+0*t2
     4         10*t57+3.2910615692041123d-2*gammaaa*t15*t183*t24*t51+3.2
     5         17926867666243d-1*gammaaa*t16*t165*t24*t51+6.582123138408
     6         225d-2*gammaaa*t15*t16*t169*t170*t51+5.273288888888887d-2
     7         *t189*t35*t37+5.273288888888887d-2*t237*t34*t37+3.1639733
     8         333333325d-1*t132*t192*t34*t35+9.454577777777778d-2*t186*
     9         t187*t31-4.727288888888889d-2*t125*t238*t27+9.45457777777
     :         7778d-2*t190*t191*t27+3.2910615692041123d-2*gammaaa*t105*
     ;         t15*t16*t209*t24-3.2910615692041123d-2*gammaaa*t15*t16*t1
     <         94*t195*t24-4.0d+0*t106*t111*t112
            t243 = -8.888888888888888d-1*t163*t72*t73-8.888888888888888d
     1         -1*t160*t71*t72-1.0546577777777776d-1*t158*t34*t35*t72+3.
     2         2910615692041123d-2*t15*t16*t24*t51+3.2910615692041123d-2
     3         *gammaaa*t136*t15*t24*t51+t159+t157+t156+t154+t152+t148+t
     4         146+t141+t140+t138
            t244 = -5.742468916099301d-6*t80*t9-4.5608816488973747d-1*t1
     1         34*t85-1.4056794412619736d-1*t4*t84+1.4759535677446958d-2
     2         *gammaaa*t83-9.926516312794808d-4*t13*t82+6.5272398423064
     3         87d-5*t11*t81+2.4105264144112412d-7*t7*t79-1.700623377531
     4         1694d-8*t5*t78+5.475448834737188d-1*t76
            t245 = -7.880451214247165d-7*t80*t9-1.0803307880124491d-3*t4
     1         *t84+4.631892373620269d-4*gammaaa*t83-8.836827178054d-5*t
     2         13*t82+1.0386425752741123d-5*t11*t81-7.018342379201d-4*t7
     3         6
            t246 = -1.6455307846020562d-2*gammaaa*t135*t15*t87*t89+1.645
     1         5307846020562d-2*t15*t24*t89-1.6455307846020562d-2*t15*t1
     2         6*t86*t87-1.6455307846020562d-2*gammaaa*t136*t15*t86*t87+
     3         4.38808209227215d-2*gammaaa*t135*t16*t76*t87-1.6455307846
     4         020562d-2*gammaaa*t15*t16*t244*t87+3.2910615692041123d-2*
     5         gammaaa*t135*t15*t16*t170*t86-4.38808209227215d-2*t16*t24
     6         *t76-4.38808209227215d-2*gammaaa*t136*t24*t76+1.645530784
     7         6020562d-2*gammaaa*t15*t24*t245
            t247 = 1.690496096374559d-4*gammaaa*t83*t93-6.93444860303102
     1         5d-2*gammaaa*t135*t15*t87*t89+6.934448603031025d-2*t15*t2
     2         4*t89-6.934448603031025d-2*t15*t16*t86*t87-6.934448603031
     3         025d-2*gammaaa*t136*t15*t86*t87+1.8491862941416065d-1*gam
     4         maaa*t135*t16*t76*t87-6.934448603031025d-2*gammaaa*t15*t1
     5         6*t244*t87+1.386889720606205d-1*gammaaa*t135*t15*t16*t170
     6         *t86-4.6362722797232353d-7*t11*t188*t81-1.369767625290079
     7         d-2*t33*t76-1.8491862941416065d-1*t16*t24*t76-1.849186294
     8         1416065d-1*gammaaa*t136*t24*t76+6.934448603031025d-2*gamm
     9         aaa*t15*t24*t245
            t248 = -2.5d-1*t137*t198*t92
            t249 = 5.0d-1*t246*t95
            t250 = t249+t248
            t251 = -2.5d-1*t137*t205*t92
            t252 = 5.0d-1*t100*t246
            t253 = t252+t251+t249+t248
            t254 = -6.0965d-1*t103*t144*t98*t99-3.04825d-1*t102*t103*t13
     1         7*t95*t99+6.0965d-1*t250*t46*t99-6.0965d-1*t137*t197*t46*
     2         t95*t98+6.0965d-1*t103*t253*t49-1.2193000000000001d+0*t10
     3         2*t144*t204*t49
            t255 = -2.5d-1*t137*t215*t92
            t256 = 5.0d-1*t107*t246
            t257 = t256+t255+t249+t248
            t258 = 1.475609999999999d-1*t110*t150*t98*t99+7.378049999999
     1         994d-2*t109*t110*t137*t95*t99-1.475609999999999d-1*t250*t
     2         55*t99+1.475609999999999d-1*t137*t197*t55*t95*t98-1.47560
     3         9999999999d-1*t110*t257*t49+2.951219999999998d-1*t109*t15
     4         0*t214*t49
            t259 = t256+t255
            t260 = t256+t255+t252+t251
            t261 = t252+t251
            t262 = 1/t28**7
            t263 = -gammaaa*t135*t15*t87*t89+t15*t24*t89-t15*t16*t86*t87
     1         -gammaaa*t136*t15*t86*t87+2.6666666666666666d+0*gammaaa*t
     2         135*t16*t76*t87-gammaaa*t15*t16*t244*t87+2*gammaaa*t135*t
     3         15*t16*t170*t86-2.6666666666666666d+0*t16*t24*t76-2.66666
     4         66666666666d+0*gammaaa*t136*t24*t76+gammaaa*t15*t24*t245
            t264 = 6.41391219265211d-2*t121*t263-5.0d-1*t120*t246+2.5d-1
     1         *t106*t137*t233-3.206956096326055d-2*t122*t161*t231
            t265 = 4.7459599999999996d-2*t137*t94-8.400000000000001d+0*t
     1         119*t246*t70-2.1d+1*t106*t137*t230*t70-2.4d+0*t264*t67-2.
     2         7259596d+0*t246*t66+4.7459599999999996d-2*t247*t65+5.6727
     3         46666666666d-2*t246*t65-5.4519192d+0*t106*t137*t65+4.7459
     4         599999999996d-2*t246*t34-4.9628707825354457d+0*t119*t246-
     5         1.2407176956338616d+1*t106*t137*t230-8.400000000000001d+0
     6         *t106*t119*t162+4.7459599999999996d-2*t106*t139-8.4000000
     7         00000001d+0*t119*t123*t137+5.672746666666666d-2*t106*t137
            t266 = 9.620868288978166d-2*t1*t137*t155*t3*t92-6.4139121926
     1         5211d-2*t1*t126*t246*t3+2.1379707308840368d-2*t1*t126*t13
     2         7*t22
            t267 = 1.924173657795633d-1*t1*t137*t155*t3*t92-1.2827824385
     1         30422d-1*t1*t126*t246*t3+4.2759414617680735d-2*t1*t126*t1
     2         37*t22
            t268 = 7.5d-1*t1*t137*t155*t3*t92-5.0d-1*t1*t126*t246*t3+1.6
     1         666666666666666d-1*t1*t126*t137*t22
            t269 = 2.164695365020087d-1*t1*t137*t155*t3*t92+4.9365923538
     1         061685d-2*t1*t268*t29*t3-1.4431302433467247d-1*t1*t126*t2
     2         46*t3-2.4682961769030842d-2*t1*t126*t129*t137*t3+4.810434
     3         144489082d-2*t1*t126*t137*t22
            t270 = -1.282782438530422d-1*t1*t126*t137*t3*t92+t246*t30+t2
     1         6*t267+t127*t137
            t271 = -1.0546577777777776d-1*t158*t35*t72*t94-3.38224118998
     1         21336d-3*t1*t126*t137*t3*t37*t94+9.454577777777778d-2*t13
     2         7*t186*t31*t92-6.064083168526658d-3*t1*t125*t137*t262*t3*
     3         t92+7.57211d-1*(-1.6455307846020562d-2*gammaaa*t135*t15*t
     4         60*t64*t87*t89+1.6455307846020562d-2*t15*t24*t60*t64*t89-
     5         1.6455307846020562d-2*gammaaa*t116*t15*t153*t24*t64*t89-8
     6         .227653923010281d-3*gammaaa*t100*t118*t137*t15*t24*t60*t8
     7         9-1.6455307846020562d-2*t15*t16*t60*t64*t86*t87-1.6455307
     8         846020562d-2*gammaaa*t136*t15*t60*t64*t86*t87+1.645530784
     9         6020562d-2*gammaaa*t116*t15*t153*t16*t64*t86*t87+8.227653
     :         923010281d-3*gammaaa*t100*t118*t137*t15*t16*t60*t86*t87+4
     ;         .38808209227215d-2*gammaaa*t135*t16*t60*t64*t76*t87-1.645
     <         5307846020562d-2*gammaaa*t15*t16*t244*t60*t64*t87+1.64553
     =         07846020562d-2*gammaaa*t115*t116*t135*t15*t16*t64*t87+1.6
     >         455307846020562d-2*gammaaa*t117*t118*t135*t15*t16*t60*t87
     ?         +3.2910615692041123d-2*gammaaa*t135*t15*t16*t170*t60*t64*
     @         t86-4.38808209227215d-2*t16*t24*t60*t64*t76-4.38808209227
     1         215d-2*gammaaa*t136*t24*t60*t64*t76+4.38808209227215d-2*g
     2         ammaaa*t116*t153*t16*t24*t64*t76+2.194041046136075d-2*gam
     3         maaa*t100*t118*t137*t16*t24*t60*t76+1.6455307846020562d-2
     4         *gammaaa*t15*t24*t245*t60*t64-1.6455307846020562d-2*gamma
     5         aa*t116*t15*t16*t24*t260*t64+3.2910615692041123d-2*gammaa
     6         a*t115*t15*t153*t16*t224*t24*t64-1.6455307846020562d-2*t1
     7         15*t116*t15*t16*t24*t64-1.6455307846020562d-2*gammaaa*t11
     8         5*t116*t136*t15*t24*t64+t246*t60*t62-t116*t260*t58*t62+2*
     9         t115*t153*t224*t58*t62-t106*t116*t153*t62-t115*t116*t137*
     :         t62-t114*t259*t58*t60+t107*t113*t137*t221*t58*t60-1.64553
     ;         07846020562d-2*gammaaa*t118*t15*t16*t24*t261*t60+1.645530
     <         7846020562d-2*gammaaa*t100*t117*t137*t15*t16*t227*t24*t60
     =         -1.6455307846020562d-2*t117*t118*t15*t16*t24*t60-1.645530
     >         7846020562d-2*gammaaa*t117*t118*t136*t15*t24*t60-t113*t11
     ?         4*t137*t60-5.0d-1*t106*t107*t114*t137*t60+t113*t114*t116*
     @         t153*t58+5.0d-1*t107*t114*t115*t116*t137*t58+1.6455307846
     1         020562d-2*gammaaa*t116*t117*t118*t15*t153*t16*t24+8.22765
     2         3923010281d-3*gammaaa*t100*t115*t116*t118*t137*t15*t16*t2
     3         4)-3.2910615692041123d-2*gammaaa*t135*t15*t51*t87*t89+3.2
     4         910615692041123d-2*t15*t24*t51*t89+3.2910615692041123d-2*
     5         gammaaa*t105*t145*t15*t24*t89-3.2910615692041123d-2*t15*t
     6         16*t51*t86*t87-3.2910615692041123d-2*gammaaa*t136*t15*t51
     7         *t86*t87-3.2910615692041123d-2*gammaaa*t105*t145*t15*t16*
     8         t86*t87+8.7761641845443d-2*gammaaa*t135*t16*t51*t76*t87-3
     9         .2910615692041123d-2*gammaaa*t15*t16*t244*t51*t87-3.29106
     :         15692041123d-2*gammaaa*t104*t105*t135*t15*t16*t87+6.58212
     ;         3138408225d-2*gammaaa*t135*t15*t16*t170*t51*t86-8.7761641
     <         845443d-2*t16*t24*t51*t76-8.7761641845443d-2*gammaaa*t136
     =         *t24*t51*t76-8.7761641845443d-2*gammaaa*t105*t145*t16*t24
     >         *t76-4.727288888888889d-2*t246*t31*t75+4.727288888888889d
     ?         -2*t125*t127*t137*t75-8.888888888888888d-1*t265*t72*t73+2
     @         .6666666666666666d+0*t132*t270*t71*t73-1.0666666666666666
     1         d+1*t131*t158*t193*t71*t73+2.6666666666666666d+0*t131*t13
     2         2*t163*t73+2.6666666666666666d+0*t124*t132*t158*t73-8.888
     3         888888888888d-1*t269*t71*t72-1.0546577777777776d-1*t270*t
     4         34*t35*t72-1.0546577777777776d-1*t131*t139*t35*t72+6.7644
     5         82379964267d-3*t1*t126*t131*t137*t3*t34*t72-1.05465777777
     6         77776d-1*t128*t158*t34*t72-8.888888888888888d-1*t130*t163
     7         *t72-8.888888888888888d-1*t124*t160*t72+2.666666666666666
     8         6d+0*t131*t132*t160*t71+2.6666666666666666d+0*t130*t132*t
     9         158*t71-2.0d+0*t112*t258*t58+2.0d+0*t111*t151*t212*t58-2.
     :         0d+0*t246*t57+3.2910615692041123d-2*gammaaa*t15*t24*t245*
     ;         t51+5.273288888888887d-2*t247*t35*t37+5.273288888888887d-
     <         2*t266*t34*t37+5.273288888888887d-2*t128*t139*t37+3.16397
     =         33333333325d-1*t131*t132*t158*t34*t35-1.2128166337053317d
     >         -2*t1*t127*t137*t155*t190*t3-4.727288888888889d-2*t125*t2
     ?         67*t27+3.2910615692041123d-2*gammaaa*t105*t15*t16*t24*t25
     @         4-3.2910615692041123d-2*gammaaa*t104*t145*t15*t16*t195*t2
     1         4+3.2910615692041123d-2*t104*t105*t15*t16*t24+3.291061569
     2         2041123d-2*gammaaa*t104*t105*t136*t15*t24-2.0d+0*t106*t11
     3         2*t151-2.0d+0*t111*t112*t137
            t272 = t137**2
            t273 = 9.454577777777778d-2*t186*t272*t31
            t274 = t135**2
            t275 = 1/t13
            t276 = 4.960151517799245d-9*t18*t9-1.6318099605766218d-5*gam
     1         maaa*t8+1.5381613168123123d-6*t13*t6+2.2334661703788317d-
     2         4*t10*t4-1.7103306183365155d-1*t22*t275-6.779605540531617
     3         d-8*t11*t20+1.757099301577467d-2*t134*t14-2.7674129395213
     4         05d-3*t12
            t277 = -2.5966064381852805d-6*gammaaa*t8+2.1108351466733477d
     1         -7*t13*t6+1.9882861150621498d-5*t10*t4+1.3504134850155614
     2         d-4*t134*t14-8.684798200538004d-5*t12
            t278 = -1.6455307846020562d-2*gammaaa*t15*t16*t276*t87-3.291
     1         0615692041123d-2*t135*t15*t16*t87-3.2910615692041123d-2*g
     2         ammaaa*t135*t136*t15*t87+1.6455307846020562d-2*gammaaa*t1
     3         5*t24*t277+3.2910615692041123d-2*gammaaa*t15*t16*t170*t27
     4         4+3.2910615692041123d-2*t136*t15*t24
            t279 = -4.727288888888889d-2*t278*t31*t75
            t280 = -4.226240240936398d-5*t12*t93-6.934448603031025d-2*ga
     1         mmaaa*t15*t16*t276*t87-1.386889720606205d-1*t135*t15*t16*
     2         t87-1.386889720606205d-1*gammaaa*t135*t136*t15*t87+1.7386
     3         021048962136d-7*gammaaa*t188*t8+6.934448603031025d-2*gamm
     4         aaa*t15*t24*t277+1.386889720606205d-1*gammaaa*t15*t16*t17
     5         0*t274+1.386889720606205d-1*t136*t15*t24
            t281 = 5.273288888888887d-2*t280*t35*t37
            t282 = t158**2
            t283 = -1.0666666666666666d+1*t193*t282*t71*t73
            t284 = 6.582123138408225d-2*gammaaa*t15*t16*t170*t274*t51
            t285 = -6.582123138408225d-2*gammaaa*t105*t135*t145*t15*t16*
     1         t87
            t286 = t145**2
            t287 = -3.2910615692041123d-2*gammaaa*t15*t16*t195*t24*t286
            t288 = 3.2910615692041123d-2*gammaaa*t277*t51+6.582123138408
     1         225d-2*t136*t51+3.2910615692041123d-2*t105*t145*t16+3.291
     2         0615692041123d-2*gammaaa*t105*t136*t145
            t289 = 1/t43
            t290 = t144**2
            t291 = -2.5d-1*t205*t272
            t292 = 5.0d-1*t100*t278
            t293 = -2.5d-1*t198*t272
            t294 = 5.0d-1*t278*t95
            t295 = t294+t293+t292+t291
            t296 = 3.04825d-1*t278*t46*t95*t99-6.0965d-1*t103*t137*t144*
     1         t95*t99-1.524125d-1*t198*t272*t46*t99+6.0965d-1*t103*t295
     2         *t49-1.2193000000000001d+0*t204*t290*t49-3.04825d-1*t197*
     3         t272*t289*t46
            t297 = 3.2910615692041123d-2*gammaaa*t16*t296+3.291061569204
     1         1123d-2*t145*t16+3.2910615692041123d-2*gammaaa*t136*t145
            t298 = -3.2910615692041123d-2*gammaaa*t16*t276*t51-3.2910615
     1         692041123d-2*t135*t16*t51-3.2910615692041123d-2*gammaaa*t
     2         135*t136*t51-t135*t147
            t299 = -2.0d+0*t278*t57
            t300 = t151**2
            t301 = 2.0d+0*t212*t300*t58
            t302 = 1/t52
            t303 = t153**2
            t304 = -2.5d-1*t215*t272
            t305 = 5.0d-1*t107*t278
            t306 = t305+t304+t292+t291
            t307 = 1/t41
            t308 = 7.57211d-1*(-1.6455307846020562d-2*gammaaa*t15*t16*t2
     1         76*t60*t64*t87-3.2910615692041123d-2*t135*t15*t16*t60*t64
     2         *t87-3.2910615692041123d-2*gammaaa*t135*t136*t15*t60*t64*
     3         t87+3.2910615692041123d-2*gammaaa*t116*t135*t15*t153*t16*
     4         t64*t87+1.6455307846020562d-2*gammaaa*t100*t118*t135*t137
     5         *t15*t16*t60*t87+1.6455307846020562d-2*gammaaa*t15*t24*t2
     6         77*t60*t64+3.2910615692041123d-2*gammaaa*t15*t16*t170*t27
     7         4*t60*t64+3.2910615692041123d-2*t136*t15*t24*t60*t64-1.64
     8         55307846020562d-2*gammaaa*t116*t15*t16*t24*t306*t64+3.291
     9         0615692041123d-2*gammaaa*t15*t16*t224*t24*t303*t64-3.2910
     :         615692041123d-2*t116*t15*t153*t16*t24*t64-3.2910615692041
     ;         123d-2*gammaaa*t116*t136*t15*t153*t24*t64+t278*t60*t62-t1
     <         16*t306*t58*t62+2*t224*t303*t58*t62-2*t116*t137*t153*t62+
     =         5.0d-1*t221*t272*t302*t58*t60-5.0d-1*t107*t114*t278*t58*t
     >         60+2.5d-1*t114*t215*t272*t58*t60+8.227653923010281d-3*gam
     ?         maaa*t15*t16*t227*t24*t272*t307*t60-8.227653923010281d-3*
     @         gammaaa*t100*t118*t15*t16*t24*t278*t60+4.1138269615051404
     1         d-3*gammaaa*t118*t15*t16*t205*t24*t272*t60-t107*t114*t272
     2         *t60-1.6455307846020562d-2*t100*t118*t137*t15*t16*t24*t60
     3         -1.6455307846020562d-2*gammaaa*t100*t118*t136*t137*t15*t2
     4         4*t60+t107*t114*t116*t137*t153*t58+1.6455307846020562d-2*
     5         gammaaa*t100*t116*t118*t137*t15*t153*t16*t24)
            t309 = t150**2
            t310 = t305+t304+t294+t293
            t311 = -7.378049999999994d-2*t278*t55*t95*t99+1.475609999999
     1         999d-1*t110*t137*t150*t95*t99+3.689024999999997d-2*t198*t
     2         272*t55*t99+7.378049999999994d-2*t197*t272*t289*t55-1.475
     3         609999999999d-1*t110*t310*t49+2.951219999999998d-1*t214*t
     4         309*t49
            t312 = -2.0d+0*t311*t58-4.0d+0*t137*t151
            t313 = 1/t26**4
            t314 = 1.5557798788747831d-3*t190*t272*t313*t38*t39
            t315 = -2.1224291089843306d-2*t1*t125*t262*t272*t3
            t316 = 6.064083168526658d-3*t1*t125*t155*t278*t3
            t317 = 5.0733617849732d-3*t1*t155*t272*t3*t34*t37
            t318 = -3.3822411899821336d-3*t1*t278*t34-6.764482379964267d
     1         -3*t1*t137*t139
            t319 = 6.764482379964267d-3*t1*t126*t137*t158*t3*t34
            t320 = -2.4682961769030842d-2*t278*t38*t39*t75+4.93659235380
     1         61685d-2*t186*t272*t38*t39-1.4431302433467247d-1*t1*t126*
     2         t278*t3+2.164695365020087d-1*t1*t155*t272*t3
            t321 = -8.888888888888888d-1*t320*t71
            t322 = -1.7777777777777776d+0*t160*t163
            t323 = t161**2
            t324 = -gammaaa*t15*t16*t276*t87-2*t135*t15*t16*t87-2*gammaa
     1         a*t135*t136*t15*t87+gammaaa*t15*t24*t277+2*gammaaa*t15*t1
     2         6*t170*t274+2*t136*t15*t24
            t325 = 6.41391219265211d-2*t121*t324-3.206956096326055d-2*t2
     1         31*t323-5.0d-1*t120*t278+2.5d-1*t233*t272
            t326 = -8.400000000000001d+0*t119*t278*t70-2.1d+1*t230*t272*
     1         t70-2.4d+0*t325*t67-2.7259596d+0*t278*t66+4.7459599999999
     2         996d-2*t280*t65+5.672746666666666d-2*t278*t65-5.4519192d+
     3         0*t272*t65+4.7459599999999996d-2*t278*t34-4.9628707825354
     4         457d+0*t119*t278-1.2407176956338616d+1*t230*t272+5.672746
     5         666666666d-2*t272-1.68d+1*t119*t137*t162+9.49191999999999
     6         9d-2*t137*t139
            t327 = -8.888888888888888d-1*t326*t73
            t328 = t278*t30-1.282782438530422d-1*t1*t278*t29*t3-6.413912
     1         19265211d-2*t1*t126*t272*t3
            t329 = -1.0546577777777776d-1*t328*t34*t35
            t330 = -2.109315555555555d-1*t139*t158*t35+t329+t327+t322+t3
     1         21+t319
            t331 = 2.6666666666666666d+0*t328*t71*t73+2.6666666666666666
     1         d+0*t158*t163*t73+2.6666666666666666d+0*t158*t160*t71-3.0
     2         d+0*t158*t164
            t332 = 1/rhoa**5.666666666666667d+0
            t333 = -7.508496024554567d-1*gammaaa*t16*t24*t332
            t334 = -4.8268903014993647d-1*gammaaa*t16*t165*t86*t87
            t335 = 4.8268903014993647d-1*gammaaa*t165*t24*t89
            t336 = -2.63284925536329d-1*gammaaa*t16*t169*t170*t76
            t337 = 1.316424627681645d-1*gammaaa*t16*t180*t76*t87
            t338 = 2.63284925536329d-1*gammaaa*t76*t86*t87*t89
            t339 = -1.316424627681645d-1*gammaaa*t183*t24*t76
            t340 = t86**3
            t341 = 1/t23**4
            t342 = -9.873184707612337d-2*gammaaa*t15*t16*t340*t341
            t343 = 9.873184707612337d-2*gammaaa*t15*t169*t170*t89
            t344 = 9.873184707612337d-2*gammaaa*t15*t16*t170*t180*t86
            t345 = -4.9365923538061685d-2*gammaaa*t15*t180*t87*t89
            t346 = 1/rhoa**1.3666666666666666d+1
            t347 = 1/rhoa**1.2333333333333334d+1
            t348 = 1/rhoa**11
            t349 = 1/rhoa**9.666666666666666d+0
            t350 = 1/rhoa**8.333333333333334d+0
            t351 = 1/rhoa**7
            t352 = -2.6382474466894645d-2*t349*t9+1.958171952691946d-3*t
     1         348*t7-1.9214483293868775d-4*t347*t5-7.094704787173696d+0
     2         *t4/rhoa**4.333333333333333d+0-2.811358882523947d+0*t13*t
     3         351+3.4274921739849046d-1*t11*t350+8.905555919908195d-6*t
     4         19*t346+9.369101339439189d+0*gammaaa*t332-6.8780767713482
     5         86d-7*t17/rhoa**15
            t353 = -1.6455307846020562d-2*gammaaa*t15*t16*t352*t87
            t354 = -4.9365923538061685d-2*gammaaa*t15*t183*t86*t87
            t355 = -2.3486322899894632d-3*t349*t9+3.115927725822337d-4*t
     1         348*t7-2.636823993592544d-5*t347*t5-2.1606615760248984d-2
     2         *t13*t351+1.0756283400962623d-2*t11*t350-1.20091636266328
     3         24d-2*gammaaa*t332
            t356 = 1.6455307846020562d-2*gammaaa*t15*t24*t355
            t357 = -1.950258707676511d-1*t38*t76+t356+t354+t353+t345+t34
     1         4+t343+t342+t339+t338+t337+t336+t335+t334+t333
            t358 = t92**3
            t359 = 1/t32**4
            t360 = 4.270067917509071d-3*t11*t350*t93+1.1095117764849638d
     1         +0*gammaaa*t76*t86*t87*t89-2.0803345809093077d-1*gammaaa*
     2         t15*t180*t87*t89+2.034104923555767d+0*gammaaa*t165*t24*t8
     3         9+4.1606691618186153d-1*gammaaa*t15*t169*t170*t89-2.08033
     4         45809093077d-1*gammaaa*t15*t183*t86*t87-2.034104923555767
     5         d+0*gammaaa*t16*t165*t86*t87+5.547558882424819d-1*gammaaa
     6         *t16*t180*t76*t87-6.934448603031025d-2*gammaaa*t15*t16*t3
     7         52*t87+4.1606691618186153d-1*gammaaa*t15*t16*t170*t180*t8
     8         6-5.547558882424819d-1*gammaaa*t183*t24*t76-1.10951177648
     9         49638d+0*gammaaa*t16*t169*t170*t76-2.349044621726439d-5*t
     :         188*t348*t7+4.0688686731102613d-8*t19*t346*t359+6.9344486
     ;         03031025d-2*gammaaa*t15*t24*t355-4.1606691618186153d-1*ga
     <         mmaaa*t15*t16*t340*t341-2.3438246032741353d-1*gammaaa*t33
     =         *t332-3.1641632144200826d+0*gammaaa*t16*t24*t332
            t361 = 1/t30**4
            t362 = t131**3
            t363 = 1/t36**6.0d+0
            t364 = 1/t50**3
            t365 = t98**3
            t366 = 1/t48**4
            t367 = 1/t44**5
            t368 = 3.75d-1*t358*t367
            t369 = -7.5d-1*t185*t198*t92
            t370 = 5.0d-1*t357*t95
            t371 = -2.660585798433468d-1*t1*t179
            t372 = t371+t370+t369+t368
            t373 = 1/t45**4
            t374 = 1/t42**5
            t375 = 3.75d-1*t358*t374
            t376 = -7.5d-1*t185*t205*t92
            t377 = 5.0d-1*t100*t357
            t378 = t356+t354+t353+t345+t344+t343+t342+t339+t338+t337+t33
     1         6+t335+t334+t333
            t379 = 1/t56**3
            t380 = 1/t54**4
            t381 = 1/t53**5
            t382 = 3.75d-1*t358*t381
            t383 = -7.5d-1*t185*t215*t92
            t384 = 5.0d-1*t107*t357
            t385 = 1/t61**4
            t386 = t115**3
            t387 = 1/t59**4
            t388 = t384+t383+t382+t377+t376+t375
            t389 = 1/t63**4
            t390 = t106**3
            t391 = t65**5.0d-1
            t392 = 1/t68**5
            t393 = 1/t69**5
            t394 = -1.7103765847072294d-1*t1*t126*t85*t92+5.772520973386
     1         899d-1*t1*t155*t185*t3*t92-4.810434144489083d-1*t1*t262*t
     2         3*t358-1.282782438530422d-1*t1*t126*t3*t357-2.66058579843
     3         3468d-1*t1*t179*t29-1.924173657795633d-1*t1*t155*t187*t22
     4         +1.282782438530422d-1*t1*t126*t185*t22
            t395 = 3*t238*t92+t26*t394+t30*t357+3*t127*t185
            t396 = 5.933884546635945d-5*t174*t9-2.812280816813114d-6*t17
     1         3*t7+2.2108103907905202d-7*t172*t5+7.028397206309868d-1*t
     2         178*t4+1.0642057180760542d+0*t134*t179-9.347705929049741d
     3         -2*gammaaa*t177+7.610329173142687d-3*t13*t176-5.874515858
     4         075838d-4*t11*t175-2.0076645727369685d+0*t165
            t397 = 8.143132921388737d-6*t174*t9+5.401653940062247d-3*t17
     1         8*t4-2.93353183662617d-3*gammaaa*t177+6.774900836508068d-
     2         4*t13*t176-9.347783177467011d-5*t11*t175+2.57339220570703
     3         35d-3*t165
            t398 = -3.2910615692041123d-2*t15*t86*t87*t89+8.776164184544
     1         3d-2*gammaaa*t135*t76*t87*t89-3.2910615692041123d-2*gamma
     2         aa*t15*t244*t87*t89+6.582123138408225d-2*gammaaa*t135*t15
     3         *t170*t86*t89-8.7761641845443d-2*t24*t76*t89+8.7761641845
     4         443d-2*t16*t76*t86*t87+8.7761641845443d-2*gammaaa*t136*t7
     5         6*t86*t87-3.2910615692041123d-2*gammaaa*t15*t245*t86*t87+
     6         8.7761641845443d-2*gammaaa*t16*t244*t76*t87-1.64553078460
     7         20562d-2*gammaaa*t15*t16*t396*t87-1.6455307846020562d-2*g
     8         ammaaa*t135*t15*t183*t87-1.6455307846020562d-2*t15*t16*t1
     9         80*t87-1.6455307846020562d-2*gammaaa*t136*t15*t180*t87-1.
     :         6089634338331216d-1*gammaaa*t135*t16*t165*t87-1.755232836
     ;         90886d-1*gammaaa*t135*t16*t170*t76*t86+6.582123138408225d
     <         -2*gammaaa*t15*t16*t170*t244*t86-8.7761641845443d-2*gamma
     =         aa*t24*t245*t76+1.6455307846020562d-2*gammaaa*t15*t24*t39
     >         7-9.873184707612337d-2*gammaaa*t135*t15*t16*t169*t341+1.6
     ?         455307846020562d-2*t15*t183*t24+1.6089634338331216d-1*t16
     @         *t165*t24+1.6089634338331216d-1*gammaaa*t136*t165*t24+3.2
     1         910615692041123d-2*gammaaa*t135*t15*t16*t170*t180+3.29106
     2         15692041123d-2*t15*t16*t169*t170+3.2910615692041123d-2*ga
     3         mmaaa*t136*t15*t169*t170
            t399 = -1.220913847381626d-3*gammaaa*t177*t93-1.386889720606
     1         205d-1*t15*t86*t87*t89+3.698372588283213d-1*gammaaa*t135*
     2         t76*t87*t89-1.386889720606205d-1*gammaaa*t15*t244*t87*t89
     3         +2.77377944121241d-1*gammaaa*t135*t15*t170*t86*t89-3.6983
     4         72588283213d-1*t24*t76*t89+3.698372588283213d-1*t16*t76*t
     5         86*t87+3.698372588283213d-1*gammaaa*t136*t76*t86*t87-1.38
     6         6889720606205d-1*gammaaa*t15*t245*t86*t87+3.6983725882832
     7         13d-1*gammaaa*t16*t244*t76*t87-6.934448603031025d-2*gamma
     8         aa*t15*t16*t396*t87-6.934448603031025d-2*gammaaa*t135*t15
     9         *t183*t87-6.934448603031025d-2*t15*t16*t180*t87-6.9344486
     :         03031025d-2*gammaaa*t136*t15*t180*t87-6.780349745185891d-
     ;         1*gammaaa*t135*t16*t165*t87-7.396745176566426d-1*gammaaa*
     <         t135*t16*t170*t76*t86+2.77377944121241d-1*gammaaa*t15*t16
     =         *t170*t244*t86-3.698372588283213d-1*gammaaa*t24*t245*t76-
     >         1.525825752416348d-8*t173*t359*t7+6.934448603031025d-2*ga
     ?         mmaaa*t15*t24*t397-4.1606691618186153d-1*gammaaa*t135*t15
     @         *t16*t169*t341+5.02248129273029d-2*t165*t33+6.93444860303
     1         1025d-2*t15*t183*t24+6.780349745185891d-1*t16*t165*t24+6.
     2         780349745185891d-1*gammaaa*t136*t165*t24+7.88166287552949
     3         9d-6*t11*t175*t188+1.386889720606205d-1*gammaaa*t135*t15*
     4         t16*t170*t180+1.386889720606205d-1*t15*t16*t169*t170+1.38
     5         6889720606205d-1*gammaaa*t136*t15*t169*t170
            t400 = 3.75d-1*t137*t187*t367
            t401 = -2.5d-1*t137*t185*t198
            t402 = -5.0d-1*t198*t246*t92
            t403 = 5.0d-1*t398*t95
            t404 = t403+t402+t401+t400
            t405 = 3.75d-1*t137*t187*t374
            t406 = -2.5d-1*t137*t185*t205
            t407 = -5.0d-1*t205*t246*t92
            t408 = 5.0d-1*t100*t398
            t409 = 3.75d-1*t137*t187*t381
            t410 = -2.5d-1*t137*t185*t215
            t411 = -5.0d-1*t215*t246*t92
            t412 = 5.0d-1*t107*t398
            t413 = t412+t411+t410+t409+t408+t407+t406+t405
            t414 = 1/t28**9
            t415 = 3.848347315591266d-1*t1*t155*t246*t3*t92-1.2827824385
     1         30422d-1*t1*t137*t155*t22*t92-5.701255282357431d-2*t1*t12
     2         6*t137*t85-1.282782438530422d-1*t1*t126*t3*t398-4.8104341
     3         44489083d-1*t1*t137*t187*t262*t3+1.924173657795633d-1*t1*
     4         t137*t155*t185*t3+8.551882923536147d-2*t1*t126*t22*t246
            t416 = 2*t267*t92+t26*t415+t30*t398-1.282782438530422d-1*t1*
     1         t126*t137*t185*t3+2*t127*t246+t137*t238
            t417 = -5.952181821359094d-8*t78*t9+2.2804408244486873d-1*t2
     1         75*t85-7.028397206309868d-2*t134*t84+1.4759535677446958d-
     2         2*t83-1.488977446919221d-3*t4*t82+1.3054479684612974d-4*g
     3         ammaaa*t81-1.4356172290248254d-5*t13*t80+7.23157924323372
     4         3d-7*t11*t79
            t418 = -5.401653940062245d-4*t134*t84+4.631892373620269d-4*t
     1         83-1.3255240767081d-4*t4*t82+2.0772851505482245d-5*gammaa
     2         a*t81-1.9701128035617912d-6*t13*t80
            t419 = -1.6455307846020562d-2*gammaaa*t15*t276*t87*t89-3.291
     1         0615692041123d-2*t135*t15*t87*t89+3.2910615692041123d-2*g
     2         ammaaa*t15*t170*t274*t89-1.6455307846020562d-2*gammaaa*t1
     3         5*t277*t86*t87-3.2910615692041123d-2*t136*t15*t86*t87+4.3
     4         8808209227215d-2*gammaaa*t16*t276*t76*t87+8.7761641845443
     5         d-2*t135*t16*t76*t87+8.7761641845443d-2*gammaaa*t135*t136
     6         *t76*t87-1.6455307846020562d-2*gammaaa*t15*t16*t417*t87-3
     7         .2910615692041123d-2*gammaaa*t135*t15*t245*t87-3.29106156
     8         92041123d-2*t15*t16*t244*t87-3.2910615692041123d-2*gammaa
     9         a*t136*t15*t244*t87-9.873184707612337d-2*gammaaa*t15*t16*
     :         t274*t341*t86+3.2910615692041123d-2*gammaaa*t15*t16*t170*
     ;         t276*t86+6.582123138408225d-2*t135*t15*t16*t170*t86+6.582
     <         123138408225d-2*gammaaa*t135*t136*t15*t170*t86-4.38808209
     =         227215d-2*gammaaa*t24*t277*t76-8.7761641845443d-2*gammaaa
     >         *t16*t170*t274*t76-8.7761641845443d-2*t136*t24*t76+1.6455
     ?         307846020562d-2*gammaaa*t15*t24*t418+3.2910615692041123d-
     @         2*t15*t24*t245+6.582123138408225d-2*gammaaa*t135*t15*t16*
     1         t170*t244
            t420 = 2.2539947951660788d-4*t83*t93-6.934448603031025d-2*ga
     1         mmaaa*t15*t276*t87*t89-1.386889720606205d-1*t135*t15*t87*
     2         t89+1.386889720606205d-1*gammaaa*t15*t170*t274*t89-6.9344
     3         48603031025d-2*gammaaa*t15*t277*t86*t87-1.386889720606205
     4         d-1*t136*t15*t86*t87+1.8491862941416065d-1*gammaaa*t16*t2
     5         76*t76*t87+3.698372588283213d-1*t135*t16*t76*t87+3.698372
     6         588283213d-1*gammaaa*t135*t136*t76*t87-6.934448603031025d
     7         -2*gammaaa*t15*t16*t417*t87-1.386889720606205d-1*gammaaa*
     8         t135*t15*t245*t87-1.386889720606205d-1*t15*t16*t244*t87-1
     9         .386889720606205d-1*gammaaa*t136*t15*t244*t87-4.160669161
     :         8186153d-1*gammaaa*t15*t16*t274*t341*t86+1.38688972060620
     ;         5d-1*gammaaa*t15*t16*t170*t276*t86+2.77377944121241d-1*t1
     <         35*t15*t16*t170*t86+2.77377944121241d-1*gammaaa*t135*t136
     =         *t15*t170*t86-2.318136139861618d-6*gammaaa*t188*t81+5.721
     >         846571561304d-9*t11*t359*t79-1.8491862941416065d-1*gammaa
     ?         a*t24*t277*t76-3.698372588283213d-1*gammaaa*t16*t170*t274
     @         *t76-3.698372588283213d-1*t136*t24*t76+6.934448603031025d
     1         -2*gammaaa*t15*t24*t418+1.386889720606205d-1*t15*t24*t245
     2         +2.77377944121241d-1*gammaaa*t135*t15*t16*t170*t244
            t421 = 3.75d-1*t272*t367*t92
            t422 = -5.0d-1*t137*t198*t246
            t423 = -2.5d-1*t198*t278*t92
            t424 = 5.0d-1*t419*t95
            t425 = t424+t423+t422+t421
            t426 = 3.75d-1*t272*t374*t92
            t427 = -5.0d-1*t137*t205*t246
            t428 = -2.5d-1*t205*t278*t92
            t429 = 5.0d-1*t100*t419
            t430 = 3.75d-1*t272*t381*t92
            t431 = -5.0d-1*t137*t215*t246
            t432 = -2.5d-1*t215*t278*t92
            t433 = 5.0d-1*t107*t419
            t434 = t433+t432+t431+t430+t429+t428+t427+t426
            t435 = 1/t26**5
            t436 = 1.924173657795633d-1*t1*t155*t278*t3*t92-4.8104341444
     1         89083d-1*t1*t262*t272*t3*t92-1.282782438530422d-1*t1*t126
     2         *t3*t419+3.848347315591266d-1*t1*t137*t155*t246*t3+4.2759
     3         414617680735d-2*t1*t126*t22*t278-6.41391219265211d-2*t1*t
     4         155*t22*t272
            t437 = -1.282782438530422d-1*t1*t126*t278*t3*t92+1.924173657
     1         795633d-1*t1*t155*t272*t3*t92+t26*t436+t30*t419-2.5655648
     2         77060844d-1*t1*t126*t137*t246*t3+t127*t278+2*t137*t267
            t438 = t137**3
            t439 = t135**3
            t440 = 2.5654959275047734d-1*t22/t9-1.6318099605766218d-5*t8
     1         +2.3072419752184684d-6*t4*t6-8.785496507887335d-3*t14*t27
     2         5-1.3559211081063233d-7*gammaaa*t20+1.2400378794498113d-8
     3         *t13*t18+1.1167330851894158d-4*t10*t134
            t441 = -2.5966064381852805d-6*t8+3.1662527200100216d-7*t4*t6
     1         -6.752067425077807d-5*t14*t275+9.941430575310749d-6*t10*t
     2         134
            t442 = -1.6455307846020562d-2*gammaaa*t15*t16*t440*t87-4.936
     1         5923538061685d-2*gammaaa*t135*t15*t277*t87-4.936592353806
     2         1685d-2*t15*t16*t276*t87-4.9365923538061685d-2*gammaaa*t1
     3         36*t15*t276*t87-9.873184707612337d-2*t135*t136*t15*t87+1.
     4         6455307846020562d-2*gammaaa*t15*t24*t441-9.87318470761233
     5         7d-2*gammaaa*t15*t16*t341*t439+4.9365923538061685d-2*t15*
     6         t24*t277+9.873184707612337d-2*gammaaa*t135*t15*t16*t170*t
     7         276+9.873184707612337d-2*t15*t16*t170*t274+9.873184707612
     8         337d-2*gammaaa*t136*t15*t170*t274
            t443 = -6.934448603031025d-2*gammaaa*t15*t16*t440*t87-2.0803
     1         345809093077d-1*gammaaa*t135*t15*t277*t87-2.0803345809093
     2         077d-1*t15*t16*t276*t87-2.0803345809093077d-1*gammaaa*t13
     3         6*t15*t276*t87-4.1606691618186153d-1*t135*t136*t15*t87+5.
     4         21580631468864d-7*t188*t8+6.934448603031025d-2*gammaaa*t1
     5         5*t24*t441-4.1606691618186153d-1*gammaaa*t15*t16*t341*t43
     6         9-2.1456924643354894d-9*gammaaa*t20*t359+2.08033458090930
     7         77d-1*t15*t24*t277+4.1606691618186153d-1*gammaaa*t135*t15
     8         *t16*t170*t276+4.1606691618186153d-1*t15*t16*t170*t274+4.
     9         1606691618186153d-1*gammaaa*t136*t15*t170*t274
            t444 = 1/t43**2
            t445 = 3.75d-1*t374*t438
            t446 = -7.5d-1*t137*t205*t278
            t447 = 5.0d-1*t100*t442
            t448 = 3.75d-1*t367*t438
            t449 = -7.5d-1*t137*t198*t278
            t450 = 5.0d-1*t442*t95
            t451 = t153**3
            t452 = 3.75d-1*t381*t438
            t453 = -7.5d-1*t137*t215*t278
            t454 = 5.0d-1*t107*t442
            t455 = t454+t453+t452+t447+t446+t445
            t456 = t30*t442-1.282782438530422d-1*t1*t29*t3*t442+9.620868
     1         288978166d-2*t1*t155*t3*t438-1.924173657795633d-1*t1*t126
     2         *t137*t278*t3
            fnc(iq) = fnc(iq)-1.8610514726982d+0*t21*t74*wght
            Amat(iq,D1_RA) = (-1.2407009817987999d+0*t2*t74-9.3052573634
     1         91d-1*t133*t21)*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-9.305257363491d-1*t21*(t16
     1         4*t72+t147*t15*t24+t159+t157+t156+t154+t152+t148+t146+t14
     2         1+t140+t138)*wght
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Amat2(iq,D2_RA_RA) = (-4.135669939329333d-1*t39*t74-9.305257
     1         363491d-1*t21*t242-2.4814019635975998d+0*t133*t2)*wght+Am
     2         at2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
            Cmat2(iq,D2_RA_GAA) = (-9.305257363491d-1*t21*t271-1.2407009
     1         817987999d+0*t2*t243)*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)-9.305257363491d-
     1         1*t21*(t15*t298*t87+6.764482379964267d-3*t1*t126*t137*t15
     2         8*t3*t34*t72+t330*t72+t126*t3*t318*t37+t132*t331+t317+t31
     3         6+t315+t314+t112*t312+t308+t301+t299+t105*t15*t24*t297+t1
     4         5*t24*t288+t287+t285+t284+t283+t281+t279+t273)*wght
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Amat3(iq,D3_RA_RA_RA) = (-9.305257363491d-1*t21*(-2.0d+0*t11
     1         2*t58*(4.4268299999999966d-1*t110*t218*t98*t99-8.85365999
     2         9999993d-1*t213*t214*t98*t99-1.475609999999999d-1*t372*t5
     3         5*t99+4.4268299999999966d-1*t109*t110*t202*t99+8.85365999
     4         9999993d-1*t197*t202*t55*t98-8.853659999999993d-1*t365*t3
     5         66*t55-1.475609999999999d-1*t110*(t384+t383+t382+t370+t36
     6         9+t368)*t49-8.853659999999993d-1*t109**3*t380*t49+8.85365
     7         9999999993d-1*t109*t214*t218*t49-8.853659999999993d-1*t10
     8         9*t110*t196*t197)+3.2910615692041123d-2*gammaaa*t105*t15*
     9         t16*t24*(-1.82895d+0*t103*t208*t98*t99+3.6579d+0*t203*t20
     :         4*t98*t99+6.0965d-1*t372*t46*t99-1.82895d+0*t102*t103*t20
     ;         2*t99-3.6579d+0*t197*t202*t46*t98+6.0965d-1*t103*(t377+t3
     <         76+t375+t370+t369+t368)*t49+3.6579d+0*t102**3*t373*t49-3.
     =         6579d+0*t102*t204*t208*t49+3.6579d+0*t365*t366*t46+3.6579
     >         d+0*t102*t103*t196*t197)-8.888888888888888d-1*t72*t73*(1.
     ?         423788d-1*t210*t94-2.4d+0*t67*(6.41391219265211d-2*t121*(
     @         16*gammaaa*t76*t86*t87*t89-3*gammaaa*t15*t180*t87*t89+2.9
     1         333333333333333d+1*gammaaa*t165*t24*t89+6*gammaaa*t15*t16
     2         9*t170*t89-3*gammaaa*t15*t183*t86*t87-2.9333333333333333d
     3         +1*gammaaa*t16*t165*t86*t87+8*gammaaa*t16*t180*t76*t87-ga
     4         mmaaa*t15*t16*t352*t87+6*gammaaa*t15*t16*t170*t180*t86-8*
     5         gammaaa*t183*t24*t76-16*gammaaa*t16*t169*t170*t76+gammaaa
     6         *t15*t24*t355-6*gammaaa*t15*t16*t340*t341-4.5629629629629
     7         626d+1*gammaaa*t16*t24*t332)-3.75d-1*t390*t393+4.81043414
     8         4489083d-2*t122**3*t392-5.0d-1*t120*t378-9.62086828897816
     9         6d-2*t122*t231*t234+7.5d-1*t106*t210*t233)-3.15d+1*t390*t
     :         391*t70-8.400000000000001d+0*t119*t378*t70-6.3d+1*t106*t2
     ;         10*t230*t70-2.7259596d+0*t378*t66+5.672746666666666d-2*t3
     <         78*t65+4.7459599999999996d-2*t360*t65-1.6355757600000004d
     =         +1*t106*t210*t65-1.8610765434507923d+1*t390*t391-5.451919
     >         2d+0*t390+4.7459599999999996d-2*t34*t378-4.96287078253544
     ?         57d+0*t119*t378-2.52d+1*t106*t119*t235-6.3d+1*t123*t229*t
     @         230-3.7221530869015845d+1*t106*t210*t230-2.52d+1*t119*t12
     1         3*t210+1.7018239999999996d-1*t106*t210+1.423788d-1*t106*t
     2         189)-3.1639733333333325d-1*t241*t35*t72*t94-6.32794666666
     3         6665d-1*t128*t131*t72*t94+1.5819866666666663d-1*t237*t37*
     4         t94+9.491919999999998d-1*t132*t192*t35*t94-8.888888888888
     5         888d-1*t71*t72*(4.9365923538061685d-2*t1*t29*t3*(-6.66666
     6         6666666666d-1*t1*t126*t85*t92+2.25d+0*t1*t155*t185*t3*t92
     7         -1.875d+0*t1*t262*t3*t358-5.0d-1*t1*t126*t3*t357-1.037037
     8         037037037d+0*t1*t179*t29-7.5d-1*t1*t155*t187*t22+5.0d-1*t
     9         1*t126*t185*t22)-1.9241736577956325d-1*t1*t126*t85*t92-2.
     :         4682961769030842d-2*t1*t126*t239*t3*t92+6.494086095060261
     ;         d-1*t1*t155*t185*t3*t92-5.411738412550218d-1*t1*t262*t3*t
     <         358-1.4431302433467247d-1*t1*t126*t3*t357-1.6455307846020
     =         562d-2*t1*t22*t239*t29-2.993159023237651d-1*t1*t179*t29+9
     >         .873184707612337d-2*t129*t239-2.164695365020087d-1*t1*t15
     ?         5*t187*t22+1.4431302433467247d-1*t1*t126*t185*t22)+5.2732
     @         88888888887d-2*t34*t37*(-8.551882923536147d-2*t1*t126*t85
     1         *t92+2.8862604866934494d-1*t1*t155*t185*t3*t92-2.40521707
     2         22445415d-1*t1*t262*t3*t358-6.41391219265211d-2*t1*t126*t
     3         3*t357-1.330292899216734d-1*t1*t179*t29-9.620868288978166
     4         d-2*t1*t155*t187*t22+6.41391219265211d-2*t1*t126*t185*t22
     5         )+1.4181866666666668d-1*t125*t238*t75*t92-2.8363733333333
     6         335d-1*t190*t191*t75*t92+2.8363733333333335d-1*t185*t186*
     7         t31*t92+7.57211d-1*(2.63284925536329d-1*gammaaa*t60*t64*t
     8         76*t86*t87*t89+9.873184707612337d-2*gammaaa*t115*t116*t15
     9         *t64*t86*t87*t89+9.873184707612337d-2*gammaaa*t117*t118*t
     :         15*t60*t86*t87*t89-4.9365923538061685d-2*gammaaa*t15*t180
     ;         *t60*t64*t87*t89+2.63284925536329d-1*gammaaa*t115*t116*t2
     <         4*t64*t76*t89+2.63284925536329d-1*gammaaa*t117*t118*t24*t
     =         60*t76*t89+4.8268903014993647d-1*gammaaa*t165*t24*t60*t64
     >         *t89+9.873184707612337d-2*gammaaa*t15*t169*t170*t60*t64*t
     ?         89-4.9365923538061685d-2*gammaaa*t116*t15*t225*t24*t64*t8
     @         9+9.873184707612337d-2*gammaaa*t15*t223*t224*t24*t64*t89-
     1         4.9365923538061685d-2*gammaaa*t118*t15*t228*t24*t60*t89+9
     2         .873184707612337d-2*gammaaa*t15*t226*t227*t24*t60*t89+9.8
     3         73184707612337d-2*gammaaa*t115*t116*t117*t118*t15*t24*t89
     4         -2.63284925536329d-1*gammaaa*t115*t116*t16*t64*t76*t86*t8
     5         7-2.63284925536329d-1*gammaaa*t117*t118*t16*t60*t76*t86*t
     6         87-4.9365923538061685d-2*gammaaa*t15*t183*t60*t64*t86*t87
     7         -4.8268903014993647d-1*gammaaa*t16*t165*t60*t64*t86*t87+4
     8         .9365923538061685d-2*gammaaa*t116*t15*t16*t225*t64*t86*t8
     9         7-9.873184707612337d-2*gammaaa*t15*t16*t223*t224*t64*t86*
     :         t87+4.9365923538061685d-2*gammaaa*t118*t15*t16*t228*t60*t
     ;         86*t87-9.873184707612337d-2*gammaaa*t15*t16*t226*t227*t60
     <         *t86*t87-9.873184707612337d-2*gammaaa*t115*t116*t117*t118
     =         *t15*t16*t86*t87+1.316424627681645d-1*gammaaa*t16*t180*t6
     >         0*t64*t76*t87-1.6455307846020562d-2*gammaaa*t15*t16*t352*
     ?         t60*t64*t87+4.9365923538061685d-2*gammaaa*t115*t116*t15*t
     @         16*t180*t64*t87+4.9365923538061685d-2*gammaaa*t117*t118*t
     1         15*t16*t180*t60*t87+9.873184707612337d-2*gammaaa*t15*t16*
     2         t170*t180*t60*t64*t86-1.316424627681645d-1*gammaaa*t183*t
     3         24*t60*t64*t76-2.63284925536329d-1*gammaaa*t16*t169*t170*
     4         t60*t64*t76+1.316424627681645d-1*gammaaa*t116*t16*t225*t2
     5         4*t64*t76-2.63284925536329d-1*gammaaa*t16*t223*t224*t24*t
     6         64*t76+1.316424627681645d-1*gammaaa*t118*t16*t228*t24*t60
     7         *t76-2.63284925536329d-1*gammaaa*t16*t226*t227*t24*t60*t7
     8         6-2.63284925536329d-1*gammaaa*t115*t116*t117*t118*t16*t24
     9         *t76+1.6455307846020562d-2*gammaaa*t15*t24*t355*t60*t64-9
     :         .873184707612337d-2*gammaaa*t15*t16*t340*t341*t60*t64-7.5
     ;         08496024554567d-1*gammaaa*t16*t24*t332*t60*t64-1.64553078
     <         46020562d-2*gammaaa*t116*t15*t16*t24*t388*t64-9.873184707
     =         612337d-2*gammaaa*t15*t16*t24*t386*t387*t64+9.87318470761
     >         2337d-2*gammaaa*t115*t15*t16*t224*t225*t24*t64-4.93659235
     ?         38061685d-2*gammaaa*t115*t116*t15*t183*t24*t64-4.82689030
     @         14993647d-1*gammaaa*t115*t116*t16*t165*t24*t64-9.87318470
     1         7612337d-2*gammaaa*t115*t116*t15*t16*t169*t170*t64+t378*t
     2         60*t62-t116*t388*t58*t62-6*t386*t387*t58*t62+6*t115*t224*
     3         t225*t58*t62-3*t106*t116*t225*t62+6*t106*t223*t224*t62-3*
     4         t115*t116*t210*t62-6*t113**3*t385*t58*t60-t114*(t384+t383
     5         +t382+t371)*t58*t60+6*t113*t221*t222*t58*t60-9.8731847076
     6         12337d-2*gammaaa*t117**3*t15*t16*t24*t389*t60-1.645530784
     7         6020562d-2*gammaaa*t118*t15*t16*t24*(t377+t376+t375+t371)
     8         *t60+9.873184707612337d-2*gammaaa*t117*t15*t16*t227*t228*
     9         t24*t60-4.9365923538061685d-2*gammaaa*t117*t118*t15*t183*
     :         t24*t60-4.8268903014993647d-1*gammaaa*t117*t118*t16*t165*
     ;         t24*t60-3*t106*t114*t222*t60+6*t106*t220*t221*t60-3*t113*
     <         t114*t210*t60-9.873184707612337d-2*gammaaa*t117*t118*t15*
     =         t16*t169*t170*t60+3*t113*t114*t116*t225*t58-6*t113*t114*t
     >         223*t224*t58+3*t114*t115*t116*t222*t58-6*t115*t116*t220*t
     ?         221*t58+4.9365923538061685d-2*gammaaa*t115*t116*t118*t15*
     @         t16*t228*t24-9.873184707612337d-2*gammaaa*t115*t116*t15*t
     1         16*t226*t227*t24+4.9365923538061685d-2*gammaaa*t116*t117*
     2         t118*t15*t16*t225*t24-9.873184707612337d-2*gammaaa*t117*t
     3         118*t15*t16*t223*t224*t24+6*t106*t113*t114*t115*t116)+5.2
     4         6569851072658d-1*gammaaa*t51*t76*t86*t87*t89-1.9746369415
     5         224674d-1*gammaaa*t104*t105*t15*t86*t87*t89-9.87318470761
     6         2337d-2*gammaaa*t15*t180*t51*t87*t89-5.26569851072658d-1*
     7         gammaaa*t104*t105*t24*t76*t89+9.653780602998729d-1*gammaa
     8         a*t165*t24*t51*t89+1.9746369415224674d-1*gammaaa*t15*t169
     9         *t170*t51*t89+9.873184707612337d-2*gammaaa*t105*t15*t209*
     :         t24*t89-9.873184707612337d-2*gammaaa*t15*t194*t195*t24*t8
     ;         9+5.26569851072658d-1*gammaaa*t104*t105*t16*t76*t86*t87-9
     <         .873184707612337d-2*gammaaa*t15*t183*t51*t86*t87-9.653780
     =         602998729d-1*gammaaa*t16*t165*t51*t86*t87-9.8731847076123
     >         37d-2*gammaaa*t105*t15*t16*t209*t86*t87+9.873184707612337
     ?         d-2*gammaaa*t15*t16*t194*t195*t86*t87+2.63284925536329d-1
     @         *gammaaa*t16*t180*t51*t76*t87-3.2910615692041123d-2*gamma
     1         aa*t15*t16*t352*t51*t87-9.873184707612337d-2*gammaaa*t104
     2         *t105*t15*t16*t180*t87+1.9746369415224674d-1*gammaaa*t15*
     3         t16*t170*t180*t51*t86-2.63284925536329d-1*gammaaa*t183*t2
     4         4*t51*t76-5.26569851072658d-1*gammaaa*t16*t169*t170*t51*t
     5         76-2.63284925536329d-1*gammaaa*t105*t16*t209*t24*t76+2.63
     6         284925536329d-1*gammaaa*t16*t194*t195*t24*t76-4.727288888
     7         888889d-2*t31*t357*t75+1.4181866666666668d-1*t125*t127*t1
     8         85*t75+2.6666666666666666d+0*t132*t395*t71*t73+5.33333333
     9         3333333d+1*t362*t363*t71*t73-3.2d+1*t131*t193*t241*t71*t7
     :         3+8.0d+0*t124*t132*t241*t73+8.0d+0*t131*t132*t236*t73-3.2
     ;         d+1*t124*t192*t193*t73-1.0546577777777776d-1*t34*t35*t395
     <         *t72-3.1639733333333325d-1*t131*t189*t35*t72-3.1639733333
     =         333325d-1*t128*t241*t34*t72-3.1639733333333325d-1*t131*t2
     >         37*t34*t72-2.6666666666666666d+0*t124*t240*t72-2.66666666
     ?         66666666d+0*t130*t236*t72+8.0d+0*t130*t132*t241*t71+8.0d+
     @         0*t131*t132*t240*t71-3.2d+1*t130*t192*t193*t71-4.0d+0*t11
     1         1**3*t379*t58+6.0d+0*t111*t212*t219*t58-2.0d+0*t378*t57+3
     2         .2910615692041123d-2*gammaaa*t15*t24*t355*t51-1.974636941
     3         5224674d-1*gammaaa*t15*t16*t340*t341*t51-1.50169920491091
     4         35d+0*gammaaa*t16*t24*t332*t51-4.727288888888889d-2*t125*
     5         t27*t394+5.273288888888887d-2*t35*t360*t37+1.581986666666
     6         6663d-1*t128*t189*t37+6.582123138408225d-2*gammaaa*t104**
     7         3*t15*t16*t24*t364-1.265589333333333d+0*t193*t34*t35*t362
     8         -2.8363733333333335d-1*t127**3*t27*t361-2.836373333333333
     9         5d-1*t31*t313*t358+9.491919999999998d-1*t131*t132*t241*t3
     :         4*t35+9.491919999999998d-1*t128*t132*t192*t34+2.836373333
     ;         3333335d-1*t127*t190*t238*t27-9.873184707612337d-2*gammaa
     <         a*t104*t15*t16*t195*t209*t24+9.873184707612337d-2*gammaaa
     =         *t104*t105*t15*t183*t24+9.653780602998729d-1*gammaaa*t104
     >         *t105*t16*t165*t24-6.0d+0*t106*t112*t219+6.0d+0*t106*t211
     ?         *t212-6.0d+0*t111*t112*t210-2.8363733333333335d-1*t125*t1
     @         27*t186*t187+1.9746369415224674d-1*gammaaa*t104*t105*t15*
     1         t16*t169*t170+1.6d+1*t124*t130*t131*t132)+2.7571132928862
     2         22d-1*t74*t91-1.2407009817987999d+0*t133*t39-3.7221029453
     3         964d+0*t2*t242)*wght+Amat3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = Amat3(iq,D3_RA_RA_RB)
            Cmat3(iq,D3_RA_RA_GAA) = (-9.305257363491d-1*t21*(-2.0d+0*t1
     1         12*t58*(2.951219999999998d-1*t110*t257*t98*t99-5.90243999
     2         9999995d-1*t109*t150*t214*t98*t99+7.378049999999994d-2*t1
     3         10*t137*t218*t95*t99-1.475609999999999d-1*t137*t213*t214*
     4         t95*t99-1.475609999999999d-1*t404*t55*t99+2.9512199999999
     5         98d-1*t109*t110*t250*t99+1.475609999999999d-1*t110*t150*t
     6         202*t99-2.951219999999998d-1*t109*t110*t137*t197*t95*t98+
     7         5.902439999999995d-1*t197*t250*t55*t98-4.4268299999999966
     8         d-1*t137*t196*t366*t55*t95+1.475609999999999d-1*t137*t197
     9         *t202*t55*t95-1.475609999999999d-1*t110*(t412+t411+t410+t
     :         409+t403+t402+t401+t400)*t49-8.853659999999993d-1*t150*t2
     ;         13*t380*t49+5.902439999999995d-1*t109*t214*t257*t49+2.951
     <         219999999998d-1*t150*t214*t218*t49-2.951219999999998d-1*t
     =         110*t150*t196*t197)+3.2910615692041123d-2*gammaaa*t105*t1
     >         5*t16*t24*(-1.2193000000000001d+0*t103*t253*t98*t99+2.438
     ?         6000000000002d+0*t102*t144*t204*t98*t99-3.04825d-1*t103*t
     @         137*t208*t95*t99+6.0965d-1*t137*t203*t204*t95*t99+6.0965d
     1         -1*t404*t46*t99-1.2193000000000001d+0*t102*t103*t250*t99-
     2         6.0965d-1*t103*t144*t202*t99+1.2193000000000001d+0*t102*t
     3         103*t137*t197*t95*t98-2.4386000000000002d+0*t197*t250*t46
     4         *t98+1.82895d+0*t137*t196*t366*t46*t95-6.0965d-1*t137*t19
     5         7*t202*t46*t95+6.0965d-1*t103*(t408+t407+t406+t405+t403+t
     6         402+t401+t400)*t49+3.6579d+0*t144*t203*t373*t49-2.4386000
     7         000000002d+0*t102*t204*t253*t49-1.2193000000000001d+0*t14
     8         4*t204*t208*t49+1.2193000000000001d+0*t103*t144*t196*t197
     9         )-8.888888888888888d-1*t72*t73*(9.491919999999999d-2*t246
     :         *t94-2.4d+0*t67*(6.41391219265211d-2*t121*(-2*t15*t86*t87
     ;         *t89+5.333333333333333d+0*gammaaa*t135*t76*t87*t89-2*gamm
     <         aaa*t15*t244*t87*t89+4*gammaaa*t135*t15*t170*t86*t89-5.33
     =         3333333333333d+0*t24*t76*t89+5.333333333333333d+0*t16*t76
     >         *t86*t87+5.333333333333333d+0*gammaaa*t136*t76*t86*t87-2*
     ?         gammaaa*t15*t245*t86*t87+5.333333333333333d+0*gammaaa*t16
     @         *t244*t76*t87-gammaaa*t15*t16*t396*t87-gammaaa*t135*t15*t
     1         183*t87-t15*t16*t180*t87-gammaaa*t136*t15*t180*t87-9.7777
     2         77777777779d+0*gammaaa*t135*t16*t165*t87-1.06666666666666
     3         66d+1*gammaaa*t135*t16*t170*t76*t86+4*gammaaa*t15*t16*t17
     4         0*t244*t86-5.333333333333333d+0*gammaaa*t24*t245*t76+gamm
     5         aaa*t15*t24*t397-6*gammaaa*t135*t15*t16*t169*t341+t15*t18
     6         3*t24+9.777777777777779d+0*t16*t165*t24+9.777777777777779
     7         d+0*gammaaa*t136*t165*t24+2*gammaaa*t135*t15*t16*t170*t18
     8         0+2*t15*t16*t169*t170+2*gammaaa*t136*t15*t169*t170)-5.0d-
     9         1*t120*t398-3.75d-1*t137*t229*t393+4.810434144489083d-2*t
     :         161*t232*t392-6.41391219265211d-2*t122*t231*t263+5.0d-1*t
     ;         106*t233*t246-3.206956096326055d-2*t161*t231*t234+2.5d-1*
     <         t137*t210*t233)-8.400000000000001d+0*t119*t398*t70-3.15d+
     =         1*t137*t229*t391*t70-4.2d+1*t106*t230*t246*t70-2.1d+1*t13
     >         7*t210*t230*t70-2.7259596d+0*t398*t66+4.7459599999999996d
     ?         -2*t399*t65+5.672746666666666d-2*t398*t65-1.0903838400000
     @         002d+1*t106*t246*t65-5.4519192d+0*t137*t210*t65+4.7459599
     1         999999996d-2*t34*t398-4.9628707825354457d+0*t119*t398-1.8
     2         610765434507923d+1*t137*t229*t391-1.68d+1*t106*t119*t264+
     3         9.491919999999999d-2*t106*t247-2.481435391267723d+1*t106*
     4         t230*t246-1.68d+1*t119*t123*t246+1.1345493333333331d-1*t1
     5         06*t246-8.400000000000001d+0*t119*t137*t235-2.1d+1*t162*t
     6         229*t230-1.2407176956338616d+1*t137*t210*t230-4.2d+1*t106
     7         *t123*t137*t230-5.4519192d+0*t137*t229-8.400000000000001d
     8         +0*t119*t162*t210+4.7459599999999996d-2*t139*t210+5.67274
     9         6666666666d-2*t137*t210+4.7459599999999996d-2*t137*t189)-
     :         2.109315555555555d-1*t270*t35*t72*t94+1.3528964759928536d
     ;         -2*t1*t126*t131*t137*t3*t72*t94-2.109315555555555d-1*t128
     <         *t158*t72*t94+1.0546577777777776d-1*t266*t37*t94+6.327946
     =         666666665d-1*t131*t132*t158*t35*t94-8.888888888888888d-1*
     >         t71*t72*(4.9365923538061685d-2*t1*t29*t3*(1.5d+0*t1*t155*
     ?         t246*t3*t92-5.0d-1*t1*t137*t155*t22*t92-2.222222222222222
     @         d-1*t1*t126*t137*t85-5.0d-1*t1*t126*t3*t398-1.875d+0*t1*t
     1         137*t187*t262*t3+7.5d-1*t1*t137*t155*t185*t3+3.3333333333
     2         33333d-1*t1*t126*t22*t246)+4.329390730040174d-1*t1*t155*t
     3         246*t3*t92-1.4431302433467247d-1*t1*t137*t155*t22*t92-6.4
     4         13912192652109d-2*t1*t126*t137*t85-1.4431302433467247d-1*
     5         t1*t126*t3*t398-5.411738412550218d-1*t1*t137*t187*t262*t3
     6         -2.4682961769030842d-2*t1*t126*t137*t239*t3+2.16469536502
     7         0087d-1*t1*t137*t155*t185*t3+9.873184707612337d-2*t129*t2
     8         68+9.620868288978164d-2*t1*t126*t22*t246)+5.2732888888888
     9         87d-2*t34*t37*(1.924173657795633d-1*t1*t155*t246*t3*t92-6
     :         .41391219265211d-2*t1*t137*t155*t22*t92-2.850627641178715
     ;         7d-2*t1*t126*t137*t85-6.41391219265211d-2*t1*t126*t3*t398
     <         -2.4052170722445415d-1*t1*t137*t187*t262*t3+9.62086828897
     =         8166d-2*t1*t137*t155*t185*t3+4.2759414617680735d-2*t1*t12
     >         6*t22*t246)+9.454577777777778d-2*t125*t267*t75*t92+1.8909
     ?         155555555557d-1*t186*t246*t31*t92+2.4256332674106634d-2*t
     @         1*t127*t137*t190*t262*t3*t92-1.8909155555555557d-1*t125*t
     1         127*t137*t186*t92+7.57211d-1*(-3.2910615692041123d-2*t15*
     2         t60*t64*t86*t87*t89+3.2910615692041123d-2*gammaaa*t116*t1
     3         5*t153*t64*t86*t87*t89+1.6455307846020562d-2*gammaaa*t100
     4         *t118*t137*t15*t60*t86*t87*t89+8.7761641845443d-2*gammaaa
     5         *t135*t60*t64*t76*t87*t89-3.2910615692041123d-2*gammaaa*t
     6         15*t244*t60*t64*t87*t89+3.2910615692041123d-2*gammaaa*t11
     7         5*t116*t135*t15*t64*t87*t89+3.2910615692041123d-2*gammaaa
     8         *t117*t118*t135*t15*t60*t87*t89+6.582123138408225d-2*gamm
     9         aaa*t135*t15*t170*t60*t64*t86*t89-8.7761641845443d-2*t24*
     :         t60*t64*t76*t89+8.7761641845443d-2*gammaaa*t116*t153*t24*
     ;         t64*t76*t89+4.38808209227215d-2*gammaaa*t100*t118*t137*t2
     <         4*t60*t76*t89-3.2910615692041123d-2*gammaaa*t116*t15*t24*
     =         t260*t64*t89+6.582123138408225d-2*gammaaa*t115*t15*t153*t
     >         224*t24*t64*t89-3.2910615692041123d-2*t115*t116*t15*t24*t
     ?         64*t89-3.2910615692041123d-2*gammaaa*t118*t15*t24*t261*t6
     @         0*t89+3.2910615692041123d-2*gammaaa*t100*t117*t137*t15*t2
     1         27*t24*t60*t89-3.2910615692041123d-2*t117*t118*t15*t24*t6
     2         0*t89+3.2910615692041123d-2*gammaaa*t116*t117*t118*t15*t1
     3         53*t24*t89+1.6455307846020562d-2*gammaaa*t100*t115*t116*t
     4         118*t137*t15*t24*t89+8.7761641845443d-2*t16*t60*t64*t76*t
     5         86*t87+8.7761641845443d-2*gammaaa*t136*t60*t64*t76*t86*t8
     6         7-8.7761641845443d-2*gammaaa*t116*t153*t16*t64*t76*t86*t8
     7         7-4.38808209227215d-2*gammaaa*t100*t118*t137*t16*t60*t76*
     8         t86*t87-3.2910615692041123d-2*gammaaa*t15*t245*t60*t64*t8
     9         6*t87+3.2910615692041123d-2*gammaaa*t116*t15*t16*t260*t64
     :         *t86*t87-6.582123138408225d-2*gammaaa*t115*t15*t153*t16*t
     ;         224*t64*t86*t87+3.2910615692041123d-2*t115*t116*t15*t16*t
     <         64*t86*t87+3.2910615692041123d-2*gammaaa*t115*t116*t136*t
     =         15*t64*t86*t87+3.2910615692041123d-2*gammaaa*t118*t15*t16
     >         *t261*t60*t86*t87-3.2910615692041123d-2*gammaaa*t100*t117
     ?         *t137*t15*t16*t227*t60*t86*t87+3.2910615692041123d-2*t117
     @         *t118*t15*t16*t60*t86*t87+3.2910615692041123d-2*gammaaa*t
     1         117*t118*t136*t15*t60*t86*t87-3.2910615692041123d-2*gamma
     2         aa*t116*t117*t118*t15*t153*t16*t86*t87-1.6455307846020562
     3         d-2*gammaaa*t100*t115*t116*t118*t137*t15*t16*t86*t87+8.77
     4         61641845443d-2*gammaaa*t16*t244*t60*t64*t76*t87-8.7761641
     5         845443d-2*gammaaa*t115*t116*t135*t16*t64*t76*t87-8.776164
     6         1845443d-2*gammaaa*t117*t118*t135*t16*t60*t76*t87-1.64553
     7         07846020562d-2*gammaaa*t15*t16*t396*t60*t64*t87-1.6455307
     8         846020562d-2*gammaaa*t135*t15*t183*t60*t64*t87-1.64553078
     9         46020562d-2*t15*t16*t180*t60*t64*t87-1.6455307846020562d-
     :         2*gammaaa*t136*t15*t180*t60*t64*t87-1.6089634338331216d-1
     ;         *gammaaa*t135*t16*t165*t60*t64*t87+3.2910615692041123d-2*
     <         gammaaa*t115*t116*t15*t16*t244*t64*t87+1.6455307846020562
     =         d-2*gammaaa*t116*t135*t15*t16*t225*t64*t87-3.291061569204
     >         1123d-2*gammaaa*t135*t15*t16*t223*t224*t64*t87+1.64553078
     ?         46020562d-2*gammaaa*t116*t15*t153*t16*t180*t64*t87+3.2910
     @         615692041123d-2*gammaaa*t117*t118*t15*t16*t244*t60*t87+1.
     1         6455307846020562d-2*gammaaa*t118*t135*t15*t16*t228*t60*t8
     2         7-3.2910615692041123d-2*gammaaa*t135*t15*t16*t226*t227*t6
     3         0*t87+8.227653923010281d-3*gammaaa*t100*t118*t137*t15*t16
     4         *t180*t60*t87-3.2910615692041123d-2*gammaaa*t115*t116*t11
     5         7*t118*t135*t15*t16*t87-1.75523283690886d-1*gammaaa*t135*
     6         t16*t170*t60*t64*t76*t86+6.582123138408225d-2*gammaaa*t15
     7         *t16*t170*t244*t60*t64*t86-6.582123138408225d-2*gammaaa*t
     8         115*t116*t135*t15*t16*t170*t64*t86-6.582123138408225d-2*g
     9         ammaaa*t117*t118*t135*t15*t16*t170*t60*t86-8.776164184544
     :         3d-2*gammaaa*t24*t245*t60*t64*t76+8.7761641845443d-2*gamm
     ;         aaa*t116*t16*t24*t260*t64*t76-1.75523283690886d-1*gammaaa
     <         *t115*t153*t16*t224*t24*t64*t76+8.7761641845443d-2*t115*t
     =         116*t16*t24*t64*t76+8.7761641845443d-2*gammaaa*t115*t116*
     >         t136*t24*t64*t76+8.7761641845443d-2*gammaaa*t118*t16*t24*
     ?         t261*t60*t76-8.7761641845443d-2*gammaaa*t100*t117*t137*t1
     @         6*t227*t24*t60*t76+8.7761641845443d-2*t117*t118*t16*t24*t
     1         60*t76+8.7761641845443d-2*gammaaa*t117*t118*t136*t24*t60*
     2         t76-8.7761641845443d-2*gammaaa*t116*t117*t118*t153*t16*t2
     3         4*t76-4.38808209227215d-2*gammaaa*t100*t115*t116*t118*t13
     4         7*t16*t24*t76+1.6455307846020562d-2*gammaaa*t15*t24*t397*
     5         t60*t64-9.873184707612337d-2*gammaaa*t135*t15*t16*t169*t3
     6         41*t60*t64+1.6455307846020562d-2*t15*t183*t24*t60*t64+1.6
     7         089634338331216d-1*t16*t165*t24*t60*t64+1.608963433833121
     8         6d-1*gammaaa*t136*t165*t24*t60*t64+3.2910615692041123d-2*
     9         gammaaa*t135*t15*t16*t170*t180*t60*t64+3.2910615692041123
     :         d-2*t15*t16*t169*t170*t60*t64+3.2910615692041123d-2*gamma
     ;         aa*t136*t15*t169*t170*t60*t64-1.6455307846020562d-2*gamma
     <         aa*t116*t15*t16*t24*t413*t64-9.873184707612337d-2*gammaaa
     =         *t15*t153*t16*t223*t24*t387*t64+6.582123138408225d-2*gamm
     >         aaa*t115*t15*t16*t224*t24*t260*t64-3.2910615692041123d-2*
     ?         gammaaa*t115*t116*t15*t24*t245*t64+3.2910615692041123d-2*
     @         gammaaa*t15*t153*t16*t224*t225*t24*t64-1.6455307846020562
     1         d-2*t116*t15*t16*t225*t24*t64-1.6455307846020562d-2*gamma
     2         aa*t116*t136*t15*t225*t24*t64+3.2910615692041123d-2*t15*t
     3         16*t223*t224*t24*t64+3.2910615692041123d-2*gammaaa*t136*t
     4         15*t223*t224*t24*t64-1.6455307846020562d-2*gammaaa*t116*t
     5         15*t153*t183*t24*t64-1.6089634338331216d-1*gammaaa*t116*t
     6         153*t16*t165*t24*t64-3.2910615692041123d-2*gammaaa*t116*t
     7         15*t153*t16*t169*t170*t64+t398*t60*t62-t116*t413*t58*t62-
     8         6*t153*t223*t387*t58*t62+4*t115*t224*t260*t58*t62+2*t153*
     9         t224*t225*t58*t62-2*t106*t116*t260*t62-2*t115*t116*t246*t
     :         62-t116*t137*t225*t62+2*t137*t223*t224*t62+4*t106*t115*t1
     ;         53*t224*t62-t116*t153*t210*t62-t114*(t412+t411+t410+t409)
     <         *t58*t60-3*t107*t137*t220*t385*t58*t60+4*t113*t221*t259*t
     =         58*t60+t107*t137*t221*t222*t58*t60-1.6455307846020562d-2*
     >         gammaaa*t118*t15*t16*t24*(t408+t407+t406+t405)*t60-4.9365
     ?         923538061685d-2*gammaaa*t100*t137*t15*t16*t226*t24*t389*t
     @         60+6.582123138408225d-2*gammaaa*t117*t15*t16*t227*t24*t26
     1         1*t60-2*t106*t114*t259*t60-2*t113*t114*t246*t60-3.2910615
     2         692041123d-2*gammaaa*t117*t118*t15*t24*t245*t60+1.6455307
     3         846020562d-2*gammaaa*t100*t137*t15*t16*t227*t228*t24*t60-
     4         1.6455307846020562d-2*t118*t15*t16*t228*t24*t60-1.6455307
     5         846020562d-2*gammaaa*t118*t136*t15*t228*t24*t60+3.2910615
     6         692041123d-2*t15*t16*t226*t227*t24*t60+3.2910615692041123
     7         d-2*gammaaa*t136*t15*t226*t227*t24*t60-8.227653923010281d
     8         -3*gammaaa*t100*t118*t137*t15*t183*t24*t60-8.044817169165
     9         608d-2*gammaaa*t100*t118*t137*t16*t165*t24*t60-t114*t137*
     :         t222*t60+2*t137*t220*t221*t60+2*t106*t107*t113*t137*t221*
     ;         t60-5.0d-1*t107*t114*t137*t210*t60-1.6455307846020562d-2*
     <         gammaaa*t100*t118*t137*t15*t16*t169*t170*t60+2*t113*t114*
     =         t116*t260*t58+2*t114*t115*t116*t259*t58+5.0d-1*t107*t114*
     >         t116*t137*t225*t58-t107*t114*t137*t223*t224*t58-4*t113*t1
     ?         14*t115*t153*t224*t58+t114*t116*t153*t222*t58-2*t116*t153
     @         *t220*t221*t58-2*t107*t113*t115*t116*t137*t221*t58+3.2910
     1         615692041123d-2*gammaaa*t115*t116*t118*t15*t16*t24*t261+3
     2         .2910615692041123d-2*gammaaa*t116*t117*t118*t15*t16*t24*t
     3         260+1.6455307846020562d-2*gammaaa*t116*t118*t15*t153*t16*
     4         t228*t24-3.2910615692041123d-2*gammaaa*t116*t15*t153*t16*
     5         t226*t227*t24-3.2910615692041123d-2*gammaaa*t100*t115*t11
     6         6*t117*t137*t15*t16*t227*t24+8.227653923010281d-3*gammaaa
     7         *t100*t116*t118*t137*t15*t16*t225*t24-1.6455307846020562d
     8         -2*gammaaa*t100*t118*t137*t15*t16*t223*t224*t24-6.5821231
     9         38408225d-2*gammaaa*t115*t117*t118*t15*t153*t16*t224*t24+
     :         3.2910615692041123d-2*t115*t116*t117*t118*t15*t16*t24+3.2
     ;         910615692041123d-2*gammaaa*t115*t116*t117*t118*t136*t15*t
     <         24+2*t106*t113*t114*t116*t153+2*t113*t114*t115*t116*t137+
     =         t106*t107*t114*t115*t116*t137)-6.582123138408225d-2*t15*t
     >         51*t86*t87*t89-6.582123138408225d-2*gammaaa*t105*t145*t15
     ?         *t86*t87*t89+1.75523283690886d-1*gammaaa*t135*t51*t76*t87
     @         *t89-6.582123138408225d-2*gammaaa*t15*t244*t51*t87*t89-6.
     1         582123138408225d-2*gammaaa*t104*t105*t135*t15*t87*t89+1.3
     2         16424627681645d-1*gammaaa*t135*t15*t170*t51*t86*t89-1.755
     3         23283690886d-1*t24*t51*t76*t89-1.75523283690886d-1*gammaa
     4         a*t105*t145*t24*t76*t89+6.582123138408225d-2*gammaaa*t105
     5         *t15*t24*t254*t89-6.582123138408225d-2*gammaaa*t104*t145*
     6         t15*t195*t24*t89+6.582123138408225d-2*t104*t105*t15*t24*t
     7         89+1.75523283690886d-1*t16*t51*t76*t86*t87+1.755232836908
     8         86d-1*gammaaa*t136*t51*t76*t86*t87+1.75523283690886d-1*ga
     9         mmaaa*t105*t145*t16*t76*t86*t87-6.582123138408225d-2*gamm
     :         aaa*t15*t245*t51*t86*t87-6.582123138408225d-2*gammaaa*t10
     ;         5*t15*t16*t254*t86*t87+6.582123138408225d-2*gammaaa*t104*
     <         t145*t15*t16*t195*t86*t87-6.582123138408225d-2*t104*t105*
     =         t15*t16*t86*t87-6.582123138408225d-2*gammaaa*t104*t105*t1
     >         36*t15*t86*t87+1.75523283690886d-1*gammaaa*t16*t244*t51*t
     ?         76*t87+1.75523283690886d-1*gammaaa*t104*t105*t135*t16*t76
     @         *t87-3.2910615692041123d-2*gammaaa*t15*t16*t396*t51*t87-3
     1         .2910615692041123d-2*gammaaa*t135*t15*t183*t51*t87-3.2910
     2         615692041123d-2*t15*t16*t180*t51*t87-3.2910615692041123d-
     3         2*gammaaa*t136*t15*t180*t51*t87-3.217926867666243d-1*gamm
     4         aaa*t135*t16*t165*t51*t87-6.582123138408225d-2*gammaaa*t1
     5         04*t105*t15*t16*t244*t87-3.2910615692041123d-2*gammaaa*t1
     6         05*t135*t15*t16*t209*t87+3.2910615692041123d-2*gammaaa*t1
     7         35*t15*t16*t194*t195*t87-3.2910615692041123d-2*gammaaa*t1
     8         05*t145*t15*t16*t180*t87-3.51046567381772d-1*gammaaa*t135
     9         *t16*t170*t51*t76*t86+1.316424627681645d-1*gammaaa*t15*t1
     :         6*t170*t244*t51*t86+1.316424627681645d-1*gammaaa*t104*t10
     ;         5*t135*t15*t16*t170*t86-1.75523283690886d-1*gammaaa*t24*t
     <         245*t51*t76-1.75523283690886d-1*gammaaa*t105*t16*t24*t254
     =         *t76+1.75523283690886d-1*gammaaa*t104*t145*t16*t195*t24*t
     >         76-1.75523283690886d-1*t104*t105*t16*t24*t76-1.7552328369
     ?         0886d-1*gammaaa*t104*t105*t136*t24*t76-4.727288888888889d
     @         -2*t31*t398*t75+9.454577777777778d-2*t125*t127*t246*t75+4
     1         .727288888888889d-2*t125*t137*t238*t75-9.454577777777778d
     2         -2*t137*t190*t191*t75+2.6666666666666666d+0*t132*t416*t71
     3         *t73+5.333333333333333d+1*t158*t192*t363*t71*t73-2.133333
     4         3333333332d+1*t131*t193*t270*t71*t73-1.0666666666666666d+
     5         1*t158*t193*t241*t71*t73+5.333333333333333d+0*t124*t132*t
     6         270*t73+5.333333333333333d+0*t131*t132*t265*t73+2.6666666
     7         666666666d+0*t132*t163*t241*t73+2.6666666666666666d+0*t13
     8         2*t158*t236*t73-1.0666666666666666d+1*t163*t192*t193*t73-
     9         2.1333333333333332d+1*t124*t131*t158*t193*t73-1.054657777
     :         7777776d-1*t34*t35*t416*t72-2.109315555555555d-1*t131*t24
     ;         7*t35*t72-1.0546577777777776d-1*t139*t241*t35*t72-1.05465
     <         77777777776d-1*t158*t189*t35*t72+6.764482379964267d-3*t1*
     =         t126*t137*t241*t3*t34*t72-2.109315555555555d-1*t128*t270*
     >         t34*t72-2.109315555555555d-1*t131*t266*t34*t72-1.05465777
     ?         77777776d-1*t158*t237*t34*t72-1.7777777777777776d+0*t124*
     @         t269*t72-1.7777777777777776d+0*t130*t265*t72-8.8888888888
     1         88888d-1*t163*t240*t72-8.888888888888888d-1*t160*t236*t72
     2         -2.109315555555555d-1*t128*t131*t139*t72+5.33333333333333
     3         3d+0*t130*t132*t270*t71+5.333333333333333d+0*t131*t132*t2
     4         69*t71+2.6666666666666666d+0*t132*t160*t241*t71+2.6666666
     5         666666666d+0*t132*t158*t240*t71-1.0666666666666666d+1*t16
     6         0*t192*t193*t71-2.1333333333333332d+1*t130*t131*t158*t193
     7         *t71-4.0d+0*t151*t211*t379*t58+4.0d+0*t111*t212*t258*t58+
     8         2.0d+0*t151*t212*t219*t58-2.0d+0*t398*t57+3.2910615692041
     9         123d-2*gammaaa*t15*t24*t397*t51-1.9746369415224674d-1*gam
     :         maaa*t135*t15*t16*t169*t341*t51+3.2910615692041123d-2*t15
     ;         *t183*t24*t51+3.217926867666243d-1*t16*t165*t24*t51+3.217
     <         926867666243d-1*gammaaa*t136*t165*t24*t51+6.5821231384082
     =         25d-2*gammaaa*t135*t15*t16*t170*t180*t51+6.58212313840822
     >         5d-2*t15*t16*t169*t170*t51+6.582123138408225d-2*gammaaa*t
     ?         136*t15*t169*t170*t51-4.727288888888889d-2*t125*t27*t415+
     @         1.2128166337053317d-2*t1*t125*t137*t187*t3*t414+5.2732888
     1         88888887d-2*t35*t37*t399-3.3822411899821336d-3*t1*t126*t1
     2         37*t189*t3*t37+1.0546577777777776d-1*t128*t247*t37+5.2732
     3         88888888887d-2*t139*t237*t37+6.582123138408225d-2*gammaaa
     4         *t145*t15*t16*t194*t24*t364+3.6384499011159954d-2*t1*t137
     5         *t155*t191*t3*t361+6.327946666666665d-1*t131*t132*t270*t3
     6         4*t35+3.1639733333333325d-1*t132*t158*t241*t34*t35-1.2655
     7         89333333333d+0*t158*t192*t193*t34*t35+3.1639733333333325d
     8         -1*t132*t139*t192*t35-2.02934471398928d-2*t1*t126*t132*t1
     9         37*t192*t3*t34+6.327946666666665d-1*t128*t131*t132*t158*t
     :         34-2.8363733333333335d-1*t137*t187*t31*t313+9.45457777777
     ;         7778d-2*t137*t185*t186*t31-6.064083168526658d-3*t1*t125*t
     <         137*t185*t262*t3-1.2128166337053317d-2*t1*t137*t155*t190*
     =         t238*t3+1.8909155555555557d-1*t127*t190*t267*t27-4.0d+0*t
     >         106*t112*t258-6.582123138408225d-2*gammaaa*t104*t15*t16*t
     ?         195*t24*t254-4.0d+0*t111*t112*t246+6.582123138408225d-2*g
     @         ammaaa*t104*t105*t15*t24*t245-3.2910615692041123d-2*gamma
     1         aa*t145*t15*t16*t195*t209*t24+3.2910615692041123d-2*t105*
     2         t15*t16*t209*t24+3.2910615692041123d-2*gammaaa*t105*t136*
     3         t15*t209*t24-3.2910615692041123d-2*t15*t16*t194*t195*t24-
     4         3.2910615692041123d-2*gammaaa*t136*t15*t194*t195*t24+3.29
     5         10615692041123d-2*gammaaa*t105*t145*t15*t183*t24+3.217926
     6         867666243d-1*gammaaa*t105*t145*t16*t165*t24-2.0d+0*t112*t
     7         137*t219+2.0d+0*t137*t211*t212+4.0d+0*t106*t111*t151*t212
     8         -2.0d+0*t112*t151*t210+6.582123138408225d-2*gammaaa*t105*
     9         t145*t15*t16*t169*t170+5.333333333333333d+0*t130*t131*t13
     :         2*t163+5.333333333333333d+0*t124*t131*t132*t160+5.3333333
     ;         33333333d+0*t124*t130*t132*t158)-4.135669939329333d-1*t24
     <         3*t39-2.4814019635975998d+0*t2*t271)*wght+Cmat3(iq,D3_RA_
     =         RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = Cmat3(iq,D3_RA_RA_GBB)
            Cmat3(iq,D3_RA_RB_GAA) = Cmat3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
            Cmat3(iq,D3_RA_GAA_GAA) = (-9.305257363491d-1*t21*(-2.0d+0*t
     1         112*t58*(1.475609999999999d-1*t110*t310*t98*t99-2.9512199
     2         99999998d-1*t214*t309*t98*t99+7.378049999999994d-2*t109*t
     3         110*t278*t95*t99+1.475609999999999d-1*t110*t137*t257*t95*
     4         t99-2.951219999999998d-1*t109*t137*t150*t214*t95*t99-1.47
     5         5609999999999d-1*t425*t55*t99-3.689024999999997d-2*t109*t
     6         110*t198*t272*t99+2.951219999999998d-1*t110*t150*t250*t99
     7         +1.475609999999999d-1*t197*t278*t55*t95*t98-2.95121999999
     8         9998d-1*t110*t137*t150*t197*t95*t98-2.2134149999999983d-1
     9         *t272*t289*t366*t55*t98-7.378049999999994d-2*t197*t198*t2
     :         72*t55*t98+2.951219999999998d-1*t137*t197*t250*t55*t95-1.
     ;         475609999999999d-1*t110*(t433+t432+t431+t430+t424+t423+t4
     <         22+t421)*t49-8.853659999999993d-1*t109*t309*t380*t49+2.95
     =         1219999999998d-1*t109*t214*t310*t49+5.902439999999995d-1*
     >         t150*t214*t257*t49-7.378049999999994d-2*t109*t110*t197*t2
     ?         72*t289)+3.2910615692041123d-2*gammaaa*t105*t15*t16*t24*(
     @         -6.0965d-1*t103*t295*t98*t99+1.2193000000000001d+0*t204*t
     1         290*t98*t99-3.04825d-1*t102*t103*t278*t95*t99-6.0965d-1*t
     2         103*t137*t253*t95*t99+1.2193000000000001d+0*t102*t137*t14
     3         4*t204*t95*t99+6.0965d-1*t425*t46*t99+1.524125d-1*t102*t1
     4         03*t198*t272*t99-1.2193000000000001d+0*t103*t144*t250*t99
     5         -6.0965d-1*t197*t278*t46*t95*t98+1.2193000000000001d+0*t1
     6         03*t137*t144*t197*t95*t98+9.14475d-1*t272*t289*t366*t46*t
     7         98+3.04825d-1*t197*t198*t272*t46*t98-1.2193000000000001d+
     8         0*t137*t197*t250*t46*t95+6.0965d-1*t103*(t429+t428+t427+t
     9         426+t424+t423+t422+t421)*t49+3.6579d+0*t102*t290*t373*t49
     :         -1.2193000000000001d+0*t102*t204*t295*t49-2.4386000000000
     ;         002d+0*t144*t204*t253*t49+3.04825d-1*t102*t103*t197*t272*
     <         t289)-8.888888888888888d-1*t72*t73*(4.7459599999999996d-2
     =         *t278*t94-2.4d+0*t67*(6.41391219265211d-2*t121*(-gammaaa*
     >         t15*t276*t87*t89-2*t135*t15*t87*t89+2*gammaaa*t15*t170*t2
     ?         74*t89-gammaaa*t15*t277*t86*t87-2*t136*t15*t86*t87+2.6666
     @         666666666666d+0*gammaaa*t16*t276*t76*t87+5.33333333333333
     1         3d+0*t135*t16*t76*t87+5.333333333333333d+0*gammaaa*t135*t
     2         136*t76*t87-gammaaa*t15*t16*t417*t87-2*gammaaa*t135*t15*t
     3         245*t87-2*t15*t16*t244*t87-2*gammaaa*t136*t15*t244*t87-6*
     4         gammaaa*t15*t16*t274*t341*t86+2*gammaaa*t15*t16*t170*t276
     5         *t86+4*t135*t15*t16*t170*t86+4*gammaaa*t135*t136*t15*t170
     6         *t86-2.6666666666666666d+0*gammaaa*t24*t277*t76-5.3333333
     7         33333333d+0*gammaaa*t16*t170*t274*t76-5.333333333333333d+
     8         0*t136*t24*t76+gammaaa*t15*t24*t418+2*t15*t24*t245+4*gamm
     9         aaa*t135*t15*t16*t170*t244)-5.0d-1*t120*t419-3.75d-1*t106
     :         *t272*t393+4.810434144489083d-2*t122*t323*t392-3.20695609
     ;         6326055d-2*t122*t231*t324+2.5d-1*t106*t233*t278-6.4139121
     <         9265211d-2*t161*t231*t263+5.0d-1*t137*t233*t246)-8.400000
     =         000000001d+0*t119*t419*t70-3.15d+1*t106*t272*t391*t70-2.1
     >         d+1*t106*t230*t278*t70-4.2d+1*t137*t230*t246*t70-2.725959
     ?         6d+0*t419*t66+4.7459599999999996d-2*t420*t65+5.6727466666
     @         66666d-2*t419*t65-5.4519192d+0*t106*t278*t65-1.0903838400
     1         000002d+1*t137*t246*t65+4.7459599999999996d-2*t34*t419-4.
     2         9628707825354457d+0*t119*t419-1.8610765434507923d+1*t106*
     3         t272*t391-8.400000000000001d+0*t106*t119*t325+4.745959999
     4         9999996d-2*t106*t280-1.2407176956338616d+1*t106*t230*t278
     5         -8.400000000000001d+0*t119*t123*t278+5.672746666666666d-2
     6         *t106*t278-2.1d+1*t123*t230*t272-5.4519192d+0*t106*t272-1
     7         .68d+1*t119*t137*t264+9.491919999999999d-2*t137*t247-2.48
     8         1435391267723d+1*t137*t230*t246-1.68d+1*t119*t162*t246+9.
     9         491919999999999d-2*t139*t246+1.1345493333333331d-1*t137*t
     :         246-4.2d+1*t106*t137*t162*t230)-1.0546577777777776d-1*t32
     ;         8*t35*t72*t94+1.3528964759928536d-2*t1*t126*t137*t158*t3*
     <         t72*t94-3.3822411899821336d-3*t1*t126*t278*t3*t37*t94+5.0
     =         733617849732d-3*t1*t155*t272*t3*t37*t94+3.163973333333332
     >         5d-1*t132*t282*t35*t94-8.888888888888888d-1*t71*t72*(4.93
     ?         65923538061685d-2*t1*t29*t3*(7.5d-1*t1*t155*t278*t3*t92-1
     @         .875d+0*t1*t262*t272*t3*t92-5.0d-1*t1*t126*t3*t419+1.5d+0
     1         *t1*t137*t155*t246*t3+1.6666666666666666d-1*t1*t126*t22*t
     2         278-2.5d-1*t1*t155*t22*t272)+2.164695365020087d-1*t1*t155
     3         *t278*t3*t92-5.411738412550218d-1*t1*t262*t272*t3*t92-1.4
     4         431302433467247d-1*t1*t126*t3*t419-2.4682961769030842d-2*
     5         t1*t126*t129*t278*t3+3.7024442653546263d-2*t1*t129*t155*t
     6         272*t3-4.9365923538061685d-2*t1*t126*t137*t268*t3+4.32939
     7         0730040174d-1*t1*t137*t155*t246*t3+4.810434144489082d-2*t
     8         1*t126*t22*t278-7.215651216733623d-2*t1*t155*t22*t272)+5.
     9         273288888888887d-2*t34*t37*(9.620868288978166d-2*t1*t155*
     :         t278*t3*t92-2.4052170722445415d-1*t1*t262*t272*t3*t92-6.4
     ;         1391219265211d-2*t1*t126*t3*t419+1.924173657795633d-1*t1*
     <         t137*t155*t246*t3+2.1379707308840368d-2*t1*t126*t22*t278-
     =         3.206956096326055d-2*t1*t155*t22*t272)-1.5557798788747831
     >         d-3*t190*t272*t38*t39*t435*t92+3.3352457426896626d-2*t1*t
     ?         125*t272*t3*t414*t92-2.8363733333333335d-1*t272*t31*t313*
     @         t92+9.454577777777778d-2*t186*t278*t31*t92-6.064083168526
     1         658d-3*t1*t125*t262*t278*t3*t92+7.57211d-1*(-1.6455307846
     2         020562d-2*gammaaa*t15*t276*t60*t64*t87*t89-3.291061569204
     3         1123d-2*t135*t15*t60*t64*t87*t89+3.2910615692041123d-2*ga
     4         mmaaa*t116*t135*t15*t153*t64*t87*t89+1.6455307846020562d-
     5         2*gammaaa*t100*t118*t135*t137*t15*t60*t87*t89+3.291061569
     6         2041123d-2*gammaaa*t15*t170*t274*t60*t64*t89-1.6455307846
     7         020562d-2*gammaaa*t116*t15*t24*t306*t64*t89+3.29106156920
     8         41123d-2*gammaaa*t15*t224*t24*t303*t64*t89-3.291061569204
     9         1123d-2*t116*t15*t153*t24*t64*t89+8.227653923010281d-3*ga
     :         mmaaa*t15*t227*t24*t272*t307*t60*t89-8.227653923010281d-3
     ;         *gammaaa*t100*t118*t15*t24*t278*t60*t89+4.113826961505140
     <         4d-3*gammaaa*t118*t15*t205*t24*t272*t60*t89-1.64553078460
     =         20562d-2*t100*t118*t137*t15*t24*t60*t89+1.645530784602056
     >         2d-2*gammaaa*t100*t116*t118*t137*t15*t153*t24*t89-1.64553
     ?         07846020562d-2*gammaaa*t15*t277*t60*t64*t86*t87-3.2910615
     @         692041123d-2*t136*t15*t60*t64*t86*t87+1.6455307846020562d
     1         -2*gammaaa*t116*t15*t16*t306*t64*t86*t87-3.29106156920411
     2         23d-2*gammaaa*t15*t16*t224*t303*t64*t86*t87+3.29106156920
     3         41123d-2*t116*t15*t153*t16*t64*t86*t87+3.2910615692041123
     4         d-2*gammaaa*t116*t136*t15*t153*t64*t86*t87-8.227653923010
     5         281d-3*gammaaa*t15*t16*t227*t272*t307*t60*t86*t87+8.22765
     6         3923010281d-3*gammaaa*t100*t118*t15*t16*t278*t60*t86*t87-
     7         4.1138269615051404d-3*gammaaa*t118*t15*t16*t205*t272*t60*
     8         t86*t87+1.6455307846020562d-2*t100*t118*t137*t15*t16*t60*
     9         t86*t87+1.6455307846020562d-2*gammaaa*t100*t118*t136*t137
     :         *t15*t60*t86*t87-1.6455307846020562d-2*gammaaa*t100*t116*
     ;         t118*t137*t15*t153*t16*t86*t87+4.38808209227215d-2*gammaa
     <         a*t16*t276*t60*t64*t76*t87+8.7761641845443d-2*t135*t16*t6
     =         0*t64*t76*t87+8.7761641845443d-2*gammaaa*t135*t136*t60*t6
     >         4*t76*t87-8.7761641845443d-2*gammaaa*t116*t135*t153*t16*t
     ?         64*t76*t87-4.38808209227215d-2*gammaaa*t100*t118*t135*t13
     @         7*t16*t60*t76*t87-1.6455307846020562d-2*gammaaa*t15*t16*t
     1         417*t60*t64*t87-3.2910615692041123d-2*gammaaa*t135*t15*t2
     2         45*t60*t64*t87-3.2910615692041123d-2*t15*t16*t244*t60*t64
     3         *t87-3.2910615692041123d-2*gammaaa*t136*t15*t244*t60*t64*
     4         t87+1.6455307846020562d-2*gammaaa*t115*t116*t15*t16*t276*
     5         t64*t87+3.2910615692041123d-2*gammaaa*t116*t135*t15*t16*t
     6         260*t64*t87+3.2910615692041123d-2*gammaaa*t116*t15*t153*t
     7         16*t244*t64*t87-6.582123138408225d-2*gammaaa*t115*t135*t1
     8         5*t153*t16*t224*t64*t87+3.2910615692041123d-2*t115*t116*t
     9         135*t15*t16*t64*t87+3.2910615692041123d-2*gammaaa*t115*t1
     :         16*t135*t136*t15*t64*t87+1.6455307846020562d-2*gammaaa*t1
     ;         17*t118*t15*t16*t276*t60*t87+3.2910615692041123d-2*gammaa
     <         a*t118*t135*t15*t16*t261*t60*t87+1.6455307846020562d-2*ga
     =         mmaaa*t100*t118*t137*t15*t16*t244*t60*t87-3.2910615692041
     >         123d-2*gammaaa*t100*t117*t135*t137*t15*t16*t227*t60*t87+3
     ?         .2910615692041123d-2*t117*t118*t135*t15*t16*t60*t87+3.291
     @         0615692041123d-2*gammaaa*t117*t118*t135*t136*t15*t60*t87-
     1         3.2910615692041123d-2*gammaaa*t116*t117*t118*t135*t15*t15
     2         3*t16*t87-1.6455307846020562d-2*gammaaa*t100*t115*t116*t1
     3         18*t135*t137*t15*t16*t87-9.873184707612337d-2*gammaaa*t15
     4         *t16*t274*t341*t60*t64*t86+3.2910615692041123d-2*gammaaa*
     5         t15*t16*t170*t276*t60*t64*t86+6.582123138408225d-2*t135*t
     6         15*t16*t170*t60*t64*t86+6.582123138408225d-2*gammaaa*t135
     7         *t136*t15*t170*t60*t64*t86-6.582123138408225d-2*gammaaa*t
     8         116*t135*t15*t153*t16*t170*t64*t86-3.2910615692041123d-2*
     9         gammaaa*t100*t118*t135*t137*t15*t16*t170*t60*t86-4.388082
     :         09227215d-2*gammaaa*t24*t277*t60*t64*t76-8.7761641845443d
     ;         -2*gammaaa*t16*t170*t274*t60*t64*t76-8.7761641845443d-2*t
     <         136*t24*t60*t64*t76+4.38808209227215d-2*gammaaa*t116*t16*
     =         t24*t306*t64*t76-8.7761641845443d-2*gammaaa*t16*t224*t24*
     >         t303*t64*t76+8.7761641845443d-2*t116*t153*t16*t24*t64*t76
     ?         +8.7761641845443d-2*gammaaa*t116*t136*t153*t24*t64*t76-2.
     @         194041046136075d-2*gammaaa*t16*t227*t24*t272*t307*t60*t76
     1         +2.194041046136075d-2*gammaaa*t100*t118*t16*t24*t278*t60*
     2         t76-1.0970205230680374d-2*gammaaa*t118*t16*t205*t24*t272*
     3         t60*t76+4.38808209227215d-2*t100*t118*t137*t16*t24*t60*t7
     4         6+4.38808209227215d-2*gammaaa*t100*t118*t136*t137*t24*t60
     5         *t76-4.38808209227215d-2*gammaaa*t100*t116*t118*t137*t153
     6         *t16*t24*t76+1.6455307846020562d-2*gammaaa*t15*t24*t418*t
     7         60*t64+3.2910615692041123d-2*t15*t24*t245*t60*t64+6.58212
     8         3138408225d-2*gammaaa*t135*t15*t16*t170*t244*t60*t64-1.64
     9         55307846020562d-2*gammaaa*t116*t15*t16*t24*t434*t64-9.873
     :         184707612337d-2*gammaaa*t115*t15*t16*t24*t303*t387*t64+3.
     ;         2910615692041123d-2*gammaaa*t115*t15*t16*t224*t24*t306*t6
     <         4-1.6455307846020562d-2*gammaaa*t115*t116*t15*t24*t277*t6
     =         4-3.2910615692041123d-2*gammaaa*t115*t116*t15*t16*t170*t2
     >         74*t64+6.582123138408225d-2*gammaaa*t15*t153*t16*t224*t24
     ?         *t260*t64-3.2910615692041123d-2*t116*t15*t16*t24*t260*t64
     @         -3.2910615692041123d-2*gammaaa*t116*t136*t15*t24*t260*t64
     1         -3.2910615692041123d-2*gammaaa*t116*t15*t153*t24*t245*t64
     2         +6.582123138408225d-2*t115*t15*t153*t16*t224*t24*t64+6.58
     3         2123138408225d-2*gammaaa*t115*t136*t15*t153*t224*t24*t64-
     4         3.2910615692041123d-2*t115*t116*t136*t15*t24*t64+t419*t60
     5         *t62-t116*t434*t58*t62-6*t115*t303*t387*t58*t62+2*t115*t2
     6         24*t306*t58*t62+4*t153*t224*t260*t58*t62-t106*t116*t306*t
     7         62+2*t106*t224*t303*t62-t115*t116*t278*t62-2*t116*t137*t2
     8         60*t62-2*t116*t153*t246*t62+4*t115*t137*t153*t224*t62-t11
     9         4*(t433+t432+t431+t430)*t58*t60-1.5d+0*t113*t272*t302*t38
     :         5*t58*t60+t107*t113*t221*t278*t58*t60-5.0d-1*t113*t215*t2
     ;         21*t272*t58*t60+2*t107*t137*t221*t259*t58*t60-1.645530784
     <         6020562d-2*gammaaa*t118*t15*t16*t24*(t429+t428+t427+t426)
     =         *t60-2.4682961769030842d-2*gammaaa*t117*t15*t16*t24*t272*
     >         t307*t389*t60+5.0d-1*t106*t221*t272*t302*t60+1.6455307846
     ?         020562d-2*gammaaa*t100*t117*t15*t16*t227*t24*t278*t60-t11
     @         3*t114*t278*t60-5.0d-1*t106*t107*t114*t278*t60-1.64553078
     1         46020562d-2*gammaaa*t117*t118*t15*t24*t277*t60-3.29106156
     2         92041123d-2*gammaaa*t117*t118*t15*t16*t170*t274*t60-8.227
     3         653923010281d-3*gammaaa*t117*t15*t16*t205*t227*t24*t272*t
     4         60+2*t107*t113*t221*t272*t60+2.5d-1*t106*t114*t215*t272*t
     5         60+3.2910615692041123d-2*gammaaa*t100*t137*t15*t16*t227*t
     6         24*t261*t60-3.2910615692041123d-2*t118*t15*t16*t24*t261*t
     7         60-3.2910615692041123d-2*gammaaa*t118*t136*t15*t24*t261*t
     8         60-2*t114*t137*t259*t60-t107*t114*t137*t246*t60-1.6455307
     9         846020562d-2*gammaaa*t100*t118*t137*t15*t24*t245*t60+3.29
     :         10615692041123d-2*t100*t117*t137*t15*t16*t227*t24*t60+3.2
     ;         910615692041123d-2*gammaaa*t100*t117*t136*t137*t15*t227*t
     <         24*t60-3.2910615692041123d-2*t117*t118*t136*t15*t24*t60+t
     =         113*t114*t116*t306*t58-2*t113*t114*t224*t303*t58-5.0d-1*t
     >         115*t116*t221*t272*t302*t58+5.0d-1*t107*t114*t115*t116*t2
     ?         78*t58-2.5d-1*t114*t115*t116*t215*t272*t58+t107*t114*t116
     @         *t137*t260*t58+2*t114*t116*t153*t259*t58-2*t107*t114*t115
     1         *t137*t153*t224*t58-2*t107*t113*t116*t137*t153*t221*t58-8
     2         .227653923010281d-3*gammaaa*t115*t116*t15*t16*t227*t24*t2
     3         72*t307+1.6455307846020562d-2*gammaaa*t116*t117*t118*t15*
     4         t16*t24*t306-3.2910615692041123d-2*gammaaa*t117*t118*t15*
     5         t16*t224*t24*t303+8.227653923010281d-3*gammaaa*t100*t115*
     6         t116*t118*t15*t16*t24*t278-4.1138269615051404d-3*gammaaa*
     7         t115*t116*t118*t15*t16*t205*t24*t272+t107*t114*t115*t116*
     8         t272+3.2910615692041123d-2*gammaaa*t116*t118*t15*t153*t16
     9         *t24*t261+1.6455307846020562d-2*gammaaa*t100*t116*t118*t1
     :         37*t15*t16*t24*t260-3.2910615692041123d-2*gammaaa*t100*t1
     ;         16*t117*t137*t15*t153*t16*t227*t24-3.2910615692041123d-2*
     <         gammaaa*t100*t115*t118*t137*t15*t153*t16*t224*t24+3.29106
     =         15692041123d-2*t116*t117*t118*t15*t153*t16*t24+1.64553078
     >         46020562d-2*t100*t115*t116*t118*t137*t15*t16*t24+3.291061
     ?         5692041123d-2*gammaaa*t116*t117*t118*t136*t15*t153*t24+1.
     @         6455307846020562d-2*gammaaa*t100*t115*t116*t118*t136*t137
     1         *t15*t24+2*t113*t114*t116*t137*t153+t106*t107*t114*t116*t
     2         137*t153)-3.2910615692041123d-2*gammaaa*t15*t276*t51*t87*
     3         t89-6.582123138408225d-2*t135*t15*t51*t87*t89-6.582123138
     4         408225d-2*gammaaa*t105*t135*t145*t15*t87*t89+6.5821231384
     5         08225d-2*gammaaa*t15*t170*t274*t51*t89+3.2910615692041123
     6         d-2*gammaaa*t105*t15*t24*t296*t89-3.2910615692041123d-2*g
     7         ammaaa*t15*t195*t24*t286*t89+6.582123138408225d-2*t105*t1
     8         45*t15*t24*t89-3.2910615692041123d-2*gammaaa*t15*t277*t51
     9         *t86*t87-6.582123138408225d-2*t136*t15*t51*t86*t87-3.2910
     :         615692041123d-2*gammaaa*t105*t15*t16*t296*t86*t87+3.29106
     ;         15692041123d-2*gammaaa*t15*t16*t195*t286*t86*t87-6.582123
     <         138408225d-2*t105*t145*t15*t16*t86*t87-6.582123138408225d
     =         -2*gammaaa*t105*t136*t145*t15*t86*t87+8.7761641845443d-2*
     >         gammaaa*t16*t276*t51*t76*t87+1.75523283690886d-1*t135*t16
     ?         *t51*t76*t87+1.75523283690886d-1*gammaaa*t135*t136*t51*t7
     @         6*t87+1.75523283690886d-1*gammaaa*t105*t135*t145*t16*t76*
     1         t87-3.2910615692041123d-2*gammaaa*t15*t16*t417*t51*t87-6.
     2         582123138408225d-2*gammaaa*t135*t15*t245*t51*t87-6.582123
     3         138408225d-2*t15*t16*t244*t51*t87-6.582123138408225d-2*ga
     4         mmaaa*t136*t15*t244*t51*t87-3.2910615692041123d-2*gammaaa
     5         *t104*t105*t15*t16*t276*t87-6.582123138408225d-2*gammaaa*
     6         t105*t135*t15*t16*t254*t87-6.582123138408225d-2*gammaaa*t
     7         105*t145*t15*t16*t244*t87+6.582123138408225d-2*gammaaa*t1
     8         04*t135*t145*t15*t16*t195*t87-6.582123138408225d-2*t104*t
     9         105*t135*t15*t16*t87-6.582123138408225d-2*gammaaa*t104*t1
     :         05*t135*t136*t15*t87-1.9746369415224674d-1*gammaaa*t15*t1
     ;         6*t274*t341*t51*t86+6.582123138408225d-2*gammaaa*t15*t16*
     <         t170*t276*t51*t86+1.316424627681645d-1*t135*t15*t16*t170*
     =         t51*t86+1.316424627681645d-1*gammaaa*t135*t136*t15*t170*t
     >         51*t86+1.316424627681645d-1*gammaaa*t105*t135*t145*t15*t1
     ?         6*t170*t86-8.7761641845443d-2*gammaaa*t24*t277*t51*t76-1.
     @         75523283690886d-1*gammaaa*t16*t170*t274*t51*t76-1.7552328
     1         3690886d-1*t136*t24*t51*t76-8.7761641845443d-2*gammaaa*t1
     2         05*t16*t24*t296*t76+8.7761641845443d-2*gammaaa*t16*t195*t
     3         24*t286*t76-1.75523283690886d-1*t105*t145*t16*t24*t76-1.7
     4         5523283690886d-1*gammaaa*t105*t136*t145*t24*t76-4.7272888
     5         88888889d-2*t31*t419*t75+4.727288888888889d-2*t125*t127*t
     6         278*t75+9.454577777777778d-2*t125*t137*t267*t75+2.6666666
     7         666666666d+0*t132*t437*t71*t73+5.333333333333333d+1*t131*
     8         t282*t363*t71*t73-1.0666666666666666d+1*t131*t193*t328*t7
     9         1*t73-2.1333333333333332d+1*t158*t193*t270*t71*t73+2.6666
     :         666666666666d+0*t124*t132*t328*t73+2.6666666666666666d+0*
     ;         t131*t132*t326*t73-1.0666666666666666d+1*t124*t193*t282*t
     <         73+5.333333333333333d+0*t132*t163*t270*t73+5.333333333333
     =         333d+0*t132*t158*t265*t73-2.1333333333333332d+1*t131*t158
     >         *t163*t193*t73-1.0546577777777776d-1*t34*t35*t437*t72-1.0
     ?         546577777777776d-1*t131*t280*t35*t72-2.109315555555555d-1
     @         *t139*t270*t35*t72-2.109315555555555d-1*t158*t247*t35*t72
     1         -1.0546577777777776d-1*t128*t328*t34*t72+6.76448237996426
     2         7d-3*t1*t126*t131*t278*t3*t34*t72-1.01467235699464d-2*t1*
     3         t131*t155*t272*t3*t34*t72+1.3528964759928536d-2*t1*t126*t
     4         137*t270*t3*t34*t72-2.109315555555555d-1*t158*t266*t34*t7
     5         2-8.888888888888888d-1*t130*t326*t72-8.888888888888888d-1
     6         *t124*t320*t72+1.3528964759928536d-2*t1*t126*t131*t137*t1
     7         39*t3*t72-1.7777777777777776d+0*t163*t269*t72-1.777777777
     8         7777776d+0*t160*t265*t72-2.109315555555555d-1*t128*t139*t
     9         158*t72+2.6666666666666666d+0*t130*t132*t328*t71+2.666666
     :         6666666666d+0*t131*t132*t320*t71-1.0666666666666666d+1*t1
     ;         30*t193*t282*t71+5.333333333333333d+0*t132*t160*t270*t71+
     <         5.333333333333333d+0*t132*t158*t269*t71-2.133333333333333
     =         2d+1*t131*t158*t160*t193*t71-4.0d+0*t111*t300*t379*t58+2.
     >         0d+0*t111*t212*t311*t58+4.0d+0*t151*t212*t258*t58-2.0d+0*
     ?         t419*t57+3.2910615692041123d-2*gammaaa*t15*t24*t418*t51+6
     @         .582123138408225d-2*t15*t24*t245*t51+1.316424627681645d-1
     1         *gammaaa*t135*t15*t16*t170*t244*t51-4.727288888888889d-2*
     2         t125*t27*t436+5.273288888888887d-2*t35*t37*t420-4.6673396
     3         36624349d-3*t127*t272*t313*t361*t38*t39-6.764482379964267
     4         d-3*t1*t126*t137*t247*t3*t37+5.273288888888887d-2*t128*t2
     5         80*t37+1.0546577777777776d-1*t139*t266*t37+6.582123138408
     6         225d-2*gammaaa*t104*t15*t16*t24*t286*t364+3.1639733333333
     7         325d-1*t131*t132*t328*t34*t35-1.265589333333333d+0*t131*t
     8         193*t282*t34*t35+6.327946666666665d-1*t132*t158*t270*t34*
     9         t35+6.327946666666665d-1*t131*t132*t139*t158*t35-4.058689
     :         42797856d-2*t1*t126*t131*t132*t137*t158*t3*t34+3.16397333
     ;         33333325d-1*t128*t132*t282*t34-2.0d+0*t106*t112*t311+1.89
     <         09155555555557d-1*t137*t186*t246*t31+2.0d+0*t106*t212*t30
     =         0-1.2128166337053317d-2*t1*t127*t155*t190*t278*t3+4.24485
     >         8217968661d-2*t1*t127*t190*t262*t272*t3-2.425633267410663
     ?         4d-2*t1*t137*t155*t190*t267*t3-1.2128166337053317d-2*t1*t
     @         125*t137*t246*t262*t3-3.2910615692041123d-2*gammaaa*t104*
     1         t15*t16*t195*t24*t296-2.0d+0*t111*t112*t278+3.29106156920
     2         41123d-2*gammaaa*t104*t105*t15*t24*t277+6.582123138408225
     3         d-2*gammaaa*t104*t105*t15*t16*t170*t274-9.454577777777778
     4         d-2*t125*t127*t186*t272-4.0d+0*t112*t137*t258-6.582123138
     5         408225d-2*gammaaa*t145*t15*t16*t195*t24*t254+6.5821231384
     6         08225d-2*t105*t15*t16*t24*t254+6.582123138408225d-2*gamma
     7         aa*t105*t136*t15*t24*t254-4.0d+0*t112*t151*t246+6.5821231
     8         38408225d-2*gammaaa*t105*t145*t15*t24*t245-6.582123138408
     9         225d-2*t104*t145*t15*t16*t195*t24-6.582123138408225d-2*ga
     :         mmaaa*t104*t136*t145*t15*t195*t24+6.582123138408225d-2*t1
     ;         04*t105*t136*t15*t24+4.0d+0*t111*t137*t151*t212+5.3333333
     <         33333333d+0*t131*t132*t160*t163+5.333333333333333d+0*t130
     =         *t132*t158*t163+5.333333333333333d+0*t124*t132*t158*t160)
     >         -1.2407009817987999d+0*t2*(-3.2910615692041123d-2*gammaaa
     ?         *t15*t16*t276*t51*t87-6.582123138408225d-2*t135*t15*t16*t
     @         51*t87-6.582123138408225d-2*gammaaa*t135*t136*t15*t51*t87
     1         -8.888888888888888d-1*t326*t72*t73+2.6666666666666666d+0*
     2         t132*t328*t71*t73+5.333333333333333d+0*t132*t158*t163*t73
     3         -8.888888888888888d-1*t320*t71*t72-1.0546577777777776d-1*
     4         t328*t34*t35*t72-2.109315555555555d-1*t139*t158*t35*t72+1
     5         .3528964759928536d-2*t1*t126*t137*t158*t3*t34*t72-1.77777
     6         77777777776d+0*t160*t163*t72+5.333333333333333d+0*t132*t1
     7         58*t160*t71-2.0d+0*t112*t311*t58+3.2910615692041123d-2*ga
     8         mmaaa*t15*t24*t277*t51+6.582123138408225d-2*t136*t15*t24*
     9         t51-3.3822411899821336d-3*t1*t126*t278*t3*t34*t37-6.76448
     :         2379964267d-3*t1*t126*t137*t139*t3*t37+3.1639733333333325
     ;         d-1*t132*t282*t34*t35+t317+t316+t315+t314+t308+t301+t299+
     <         3.2910615692041123d-2*gammaaa*t105*t15*t16*t24*t296+t287+
     =         t285+t284+t283+t281+t279+t273+6.582123138408225d-2*t105*t
     >         145*t15*t16*t24+6.582123138408225d-2*gammaaa*t105*t136*t1
     ?         45*t15*t24-4.0d+0*t112*t137*t151))*wght+Cmat3(iq,D3_RA_GA
     @         A_GAA)
            Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
            Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
            Cmat3(iq,D3_RA_GBB_GBB) = Cmat3(iq,D3_RA_GBB_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = Cmat3(iq,D3_GAA_GAA_GAA)-9.305257
     1         363491d-1*t21*(t112*(-2.0d+0*t58*(-7.378049999999994d-2*t
     2         442*t55*t95*t99+2.2134149999999983d-1*t110*t137*t310*t95*
     3         t99-4.4268299999999966d-1*t137*t214*t309*t95*t99+2.213414
     4         9999999983d-1*t110*t150*t278*t95*t99-5.533537499999995d-2
     5         *t367*t438*t55*t99+1.1067074999999992d-1*t137*t198*t278*t
     6         55*t99-1.1067074999999992d-1*t110*t150*t198*t272*t99-1.10
     7         67074999999992d-1*t197*t438*t444*t55-1.1067074999999992d-
     8         1*t198*t366*t438*t55+2.2134149999999983d-1*t137*t197*t278
     9         *t289*t55-1.475609999999999d-1*t110*(t454+t453+t452+t450+
     :         t449+t448)*t49-8.853659999999993d-1*t150**3*t380*t49+8.85
     ;         3659999999993d-1*t150*t214*t310*t49-2.2134149999999983d-1
     <         *t110*t150*t197*t272*t289)-6.0d+0*t137*t311-6.0d+0*t151*t
     =         278)+t105*t15*t24*(3.2910615692041123d-2*gammaaa*t16*(3.0
     >         4825d-1*t442*t46*t95*t99-9.14475d-1*t103*t137*t295*t95*t9
     ?         9+1.82895d+0*t137*t204*t290*t95*t99-9.14475d-1*t103*t144*
     @         t278*t95*t99+2.2861875d-1*t367*t438*t46*t99-4.572375d-1*t
     1         137*t198*t278*t46*t99+4.572375d-1*t103*t144*t198*t272*t99
     2         +6.0965d-1*t103*(t450+t449+t448+t447+t446+t445)*t49+3.657
     3         9d+0*t144**3*t373*t49-3.6579d+0*t144*t204*t295*t49+4.5723
     4         75d-1*t197*t438*t444*t46+4.572375d-1*t198*t366*t438*t46-9
     5         .14475d-1*t137*t197*t278*t289*t46+9.14475d-1*t103*t144*t1
     6         97*t272*t289)+6.582123138408225d-2*t16*t296+6.58212313840
     7         8225d-2*gammaaa*t136*t296+3.2910615692041123d-2*gammaaa*t
     8         145*t277+6.582123138408225d-2*t136*t145)+t72*(-8.88888888
     9         8888888d-1*t73*(-2.4d+0*t67*(6.41391219265211d-2*t121*(-g
     :         ammaaa*t15*t16*t440*t87-3*gammaaa*t135*t15*t277*t87-3*t15
     ;         *t16*t276*t87-3*gammaaa*t136*t15*t276*t87-6*t135*t136*t15
     <         *t87+gammaaa*t15*t24*t441-6*gammaaa*t15*t16*t341*t439+3*t
     =         15*t24*t277+6*gammaaa*t135*t15*t16*t170*t276+6*t15*t16*t1
     >         70*t274+6*gammaaa*t136*t15*t170*t274)-5.0d-1*t120*t442-3.
     ?         75d-1*t393*t438+4.810434144489083d-2*t161**3*t392-9.62086
     @         8288978166d-2*t161*t231*t324+7.5d-1*t137*t233*t278)-8.400
     1         000000000001d+0*t119*t442*t70-3.15d+1*t391*t438*t70-6.3d+
     2         1*t137*t230*t278*t70-2.7259596d+0*t442*t66+4.745959999999
     3         9996d-2*t443*t65+5.672746666666666d-2*t442*t65-1.63557576
     4         00000004d+1*t137*t278*t65+4.7459599999999996d-2*t34*t442-
     5         4.9628707825354457d+0*t119*t442-1.8610765434507923d+1*t39
     6         1*t438-5.4519192d+0*t438-2.52d+1*t119*t137*t325+1.423788d
     7         -1*t137*t280-3.7221530869015845d+1*t137*t230*t278-2.52d+1
     8         *t119*t162*t278+1.423788d-1*t139*t278+1.7018239999999996d
     9         -1*t137*t278-6.3d+1*t162*t230*t272)-8.888888888888888d-1*
     :         t71*(-2.4682961769030842d-2*t38*t39*t442*t75-1.4431302433
     ;         467247d-1*t1*t126*t3*t442-1.4809777061418505d-1*t313*t38*
     <         t39*t438-5.411738412550218d-1*t1*t262*t3*t438+1.480977706
     =         1418505d-1*t137*t186*t278*t38*t39+6.494086095060261d-1*t1
     >         *t137*t155*t278*t3)-1.0546577777777776d-1*t34*t35*t456-3.
     ?         1639733333333325d-1*t139*t328*t35-3.1639733333333325d-1*t
     @         158*t280*t35+1.3528964759928536d-2*t1*t126*t137*t3*t328*t
     1         34+6.764482379964267d-3*t1*t126*t158*t278*t3*t34-1.014672
     2         35699464d-2*t1*t155*t158*t272*t3*t34-2.6666666666666666d+
     3         0*t160*t326-2.6666666666666666d+0*t163*t320+2.02934471398
     4         928d-2*t1*t126*t137*t139*t158*t3)+7.57211d-1*(-1.64553078
     5         46020562d-2*gammaaa*t15*t16*t440*t60*t64*t87-4.9365923538
     6         061685d-2*gammaaa*t135*t15*t277*t60*t64*t87-4.93659235380
     7         61685d-2*t15*t16*t276*t60*t64*t87-4.9365923538061685d-2*g
     8         ammaaa*t136*t15*t276*t60*t64*t87-9.873184707612337d-2*t13
     9         5*t136*t15*t60*t64*t87+4.9365923538061685d-2*gammaaa*t116
     :         *t135*t15*t16*t306*t64*t87-9.873184707612337d-2*gammaaa*t
     ;         135*t15*t16*t224*t303*t64*t87+4.9365923538061685d-2*gamma
     <         aa*t116*t15*t153*t16*t276*t64*t87+9.873184707612337d-2*t1
     =         16*t135*t15*t153*t16*t64*t87+9.873184707612337d-2*gammaaa
     >         *t116*t135*t136*t15*t153*t64*t87-2.4682961769030842d-2*ga
     ?         mmaaa*t135*t15*t16*t227*t272*t307*t60*t87+2.4682961769030
     @         842d-2*gammaaa*t100*t118*t135*t15*t16*t278*t60*t87+2.4682
     1         961769030842d-2*gammaaa*t100*t118*t137*t15*t16*t276*t60*t
     2         87-1.2341480884515421d-2*gammaaa*t118*t135*t15*t16*t205*t
     3         272*t60*t87+4.9365923538061685d-2*t100*t118*t135*t137*t15
     4         *t16*t60*t87+4.9365923538061685d-2*gammaaa*t100*t118*t135
     5         *t136*t137*t15*t60*t87-4.9365923538061685d-2*gammaaa*t100
     6         *t116*t118*t135*t137*t15*t153*t16*t87+1.6455307846020562d
     7         -2*gammaaa*t15*t24*t441*t60*t64-9.873184707612337d-2*gamm
     8         aaa*t15*t16*t341*t439*t60*t64+4.9365923538061685d-2*t15*t
     9         24*t277*t60*t64+9.873184707612337d-2*gammaaa*t135*t15*t16
     :         *t170*t276*t60*t64+9.873184707612337d-2*t15*t16*t170*t274
     ;         *t60*t64+9.873184707612337d-2*gammaaa*t136*t15*t170*t274*
     <         t60*t64-1.6455307846020562d-2*gammaaa*t116*t15*t16*t24*t4
     =         55*t64-9.873184707612337d-2*gammaaa*t15*t16*t24*t387*t451
     >         *t64+9.873184707612337d-2*gammaaa*t15*t153*t16*t224*t24*t
     ?         306*t64-4.9365923538061685d-2*t116*t15*t16*t24*t306*t64-4
     @         .9365923538061685d-2*gammaaa*t116*t136*t15*t24*t306*t64+9
     1         .873184707612337d-2*t15*t16*t224*t24*t303*t64+9.873184707
     2         612337d-2*gammaaa*t136*t15*t224*t24*t303*t64-4.9365923538
     3         061685d-2*gammaaa*t116*t15*t153*t24*t277*t64-9.8731847076
     4         12337d-2*gammaaa*t116*t15*t153*t16*t170*t274*t64-9.873184
     5         707612337d-2*t116*t136*t15*t153*t24*t64+t442*t60*t62-t116
     6         *t455*t58*t62-6*t387*t451*t58*t62+6*t153*t224*t306*t58*t6
     7         2-3*t116*t137*t306*t62+6*t137*t224*t303*t62-3*t116*t153*t
     8         278*t62-7.5d-1*t221*t438*t58*t60/t52**2-5.0d-1*t107*t114*
     9         t442*t58*t60-7.5d-1*t215*t385*t438*t58*t60-3.75d-1*t114*t
     :         381*t438*t58*t60+1.5d+0*t137*t221*t278*t302*t58*t60+7.5d-
     ;         1*t114*t137*t215*t278*t58*t60-8.227653923010281d-3*gammaa
     <         a*t100*t118*t15*t16*t24*t442*t60-1.2341480884515421d-2*ga
     =         mmaaa*t15*t16*t227*t24*t438*t60/t41**2-1.2341480884515421
     >         d-2*gammaaa*t15*t16*t205*t24*t389*t438*t60-6.170740442257
     ?         711d-3*gammaaa*t118*t15*t16*t24*t374*t438*t60+1.5d+0*t221
     @         *t302*t438*t60+7.5d-1*t114*t215*t438*t60+2.46829617690308
     1         42d-2*gammaaa*t137*t15*t16*t227*t24*t278*t307*t60+2.46829
     2         61769030842d-2*t15*t16*t227*t24*t272*t307*t60+2.468296176
     3         9030842d-2*gammaaa*t136*t15*t227*t24*t272*t307*t60+1.2341
     4         480884515421d-2*gammaaa*t118*t137*t15*t16*t205*t24*t278*t
     5         60-2.4682961769030842d-2*t100*t118*t15*t16*t24*t278*t60-2
     6         .4682961769030842d-2*gammaaa*t100*t118*t136*t15*t24*t278*
     7         t60-3*t107*t114*t137*t278*t60-2.4682961769030842d-2*gamma
     8         aa*t100*t118*t137*t15*t24*t277*t60-4.9365923538061685d-2*
     9         gammaaa*t100*t118*t137*t15*t16*t170*t274*t60+1.2341480884
     :         515421d-2*t118*t15*t16*t205*t24*t272*t60+1.23414808845154
     ;         21d-2*gammaaa*t118*t136*t15*t205*t24*t272*t60-4.936592353
     <         8061685d-2*t100*t118*t136*t137*t15*t24*t60+1.5d+0*t107*t1
     =         14*t116*t137*t306*t58-3*t107*t114*t137*t224*t303*t58-1.5d
     >         +0*t116*t153*t221*t272*t302*t58+1.5d+0*t107*t114*t116*t15
     ?         3*t278*t58-7.5d-1*t114*t116*t153*t215*t272*t58-2.46829617
     @         69030842d-2*gammaaa*t116*t15*t153*t16*t227*t24*t272*t307+
     1         2.4682961769030842d-2*gammaaa*t100*t116*t118*t137*t15*t16
     2         *t24*t306-4.9365923538061685d-2*gammaaa*t100*t118*t137*t1
     3         5*t16*t224*t24*t303+2.4682961769030842d-2*gammaaa*t100*t1
     4         16*t118*t15*t153*t16*t24*t278-1.2341480884515421d-2*gamma
     5         aa*t116*t118*t15*t153*t16*t205*t24*t272+3*t107*t114*t116*
     6         t153*t272+4.9365923538061685d-2*t100*t116*t118*t137*t15*t
     7         153*t16*t24+4.9365923538061685d-2*gammaaa*t100*t116*t118*
     8         t136*t137*t15*t153*t24)+t15*(-3.2910615692041123d-2*gamma
     9         aa*t16*t440*t51-3.2910615692041123d-2*gammaaa*t135*t277*t
     :         51-6.582123138408225d-2*t16*t276*t51-6.582123138408225d-2
     ;         *gammaaa*t136*t276*t51-6.582123138408225d-2*t135*t136*t51
     <         -2*t135*t288-3.2910615692041123d-2*gammaaa*t105*t145*t16*
     =         t276-t147*t276-3.2910615692041123d-2*t105*t135*t145*t16-3
     >         .2910615692041123d-2*gammaaa*t105*t135*t136*t145)*t87+t10
     ?         5*t15*(-t135*t297-6.582123138408225d-2*gammaaa*t135*t16*t
     @         296-6.582123138408225d-2*gammaaa*t145*t16*t276-6.58212313
     1         8408225d-2*t135*t145*t16-6.582123138408225d-2*gammaaa*t13
     2         5*t136*t145)*t87+9.873184707612337d-2*gammaaa*t135*t15*t1
     3         6*t195*t286*t87-4.727288888888889d-2*t31*t442*t75+t132*(2
     4         .6666666666666666d+0*t456*t71*t73+5.333333333333333d+0*t1
     5         63*t328*t73+2.6666666666666666d+0*t158*t326*t73+5.3333333
     6         33333333d+0*t160*t328*t71+2.6666666666666666d+0*t158*t320
     7         *t71-3.0d+0*t158*(-1.0546577777777776d-1*t139*t158*t35+t3
     8         29+t327+t322+t321+t319)-3.0d+0*t158*t330-3.0d+0*t164*t328
     9         +5.333333333333333d+0*t158*t160*t163)+t193*(-2.1333333333
     :         333332d+1*t158*t328*t71*t73-1.0666666666666666d+1*t163*t2
     ;         82*t73-1.0666666666666666d+1*t160*t282*t71-4.0d+0*t158*t3
     <         31)+5.333333333333333d+1*t158**3*t363*t71*t73+t126*t3*(6.
     =         764482379964267d-3*t1*t137*t328*t34+6.764482379964267d-3*
     >         t1*t158*t278*t34-2.0d+0*t158*t318+6.764482379964267d-3*t1
     ?         *t137*t139*t158)*t72-2.02934471398928d-2*t1*t155*t158*t27
     @         2*t3*t34*t72+t212*(4.0d+0*t151*t311*t58-t151*t312+2.0d+0*
     1         t137*t300)-4.0d+0*t151**3*t379*t58-2.0d+0*t442*t57+t15*t2
     2         4*(3.2910615692041123d-2*gammaaa*t441*t51+9.8731847076123
     3         37d-2*t277*t51+3.2910615692041123d-2*t105*t16*t296+3.2910
     4         615692041123d-2*gammaaa*t105*t136*t296-3.2910615692041123
     5         d-2*t16*t195*t286-3.2910615692041123d-2*gammaaa*t136*t195
     6         *t286+6.582123138408225d-2*gammaaa*t105*t145*t277+1.31642
     7         4627681645d-1*t105*t136*t145)+t15*t170*(1.316424627681645
     8         d-1*gammaaa*t135*t16*t276*t51+6.582123138408225d-2*t16*t2
     9         74*t51+6.582123138408225d-2*gammaaa*t136*t274*t51-2*t135*
     :         t298)-1.9746369415224674d-1*gammaaa*t15*t16*t341*t439*t51
     ;         +5.273288888888887d-2*t35*t37*t443+t126*t3*t37*(-3.382241
     <         1899821336d-3*t1*t34*t442-1.01467235699464d-2*t1*t137*t28
     =         0-1.01467235699464d-2*t1*t139*t278)+6.064083168526658d-3*
     >         t1*t125*t155*t3*t442-1.1668349091560873d-2*t190*t38*t39*t
     ?         435*t438+8.641318515150488d-2*t1*t125*t3*t414*t438-1.2683
     @         404462433d-2*t1*t262*t3*t34*t37*t438+5.987181320518676d-4
     1         *t1**3*t361*t438/(rhoa*t28**11)-2.8363733333333335d-1*t31
     2         *t313*t438+4.667339636624349d-3*t137*t190*t278*t313*t38*t
     3         39+t155*t3*(1.01467235699464d-2*t1*t137*t278*t34+5.073361
     4         7849732d-3*t1*t139*t272)*t37-1.5d+0*t137*t155*t3*t318*t37
     5         +6.582123138408225d-2*gammaaa*t145**3*t15*t16*t24*t364-2.
     6         02934471398928d-2*t1*t126*t132*t137*t282*t3*t34+2.8363733
     7         333333335d-1*t137*t186*t278*t31-6.367287326952992d-2*t1*t
     8         125*t137*t262*t278*t3+t15*t195*t24*(-t145*t297-6.58212313
     9         8408225d-2*gammaaa*t145*t16*t296-3.2910615692041123d-2*t1
     :         6*t286-3.2910615692041123d-2*gammaaa*t136*t286)+1.9746369
     ;         415224674d-1*gammaaa*t105*t145*t15*t16*t170*t274)*wght
            Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
            Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
            Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
          endif ! rhoa.gt.tol_rho 
        else  ! ipol.eq.1 
          rhoa    = rho(iq,R_A) 
          rhob    = rho(iq,R_B) 
          gammaaa = rgamma(iq,G_AA) 
          gammaab = rgamma(iq,G_AB) 
          gammabb = rgamma(iq,G_BB) 
          if (rhoa.gt.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = param(1)
            t2 = rhoa**3.333333333333333d-1
            t3 = 1/t2
            t4 = t1*t3
            t5 = gammaaa**5.0d-1
            t6 = t5**7
            t7 = 1/rhoa**9.333333333333333d+0
            t8 = gammaaa**3
            t9 = 1/rhoa**8
            t10 = t5**5
            t11 = 1/rhoa**6.666666666666667d+0
            t12 = gammaaa**2
            t13 = 1/rhoa**5.333333333333333d+0
            t14 = t5**3
            t15 = 1/rhoa**4
            t16 = 1/rhoa**2.6666666666666666d+0
            t17 = -4.327677396975467d-7*t8*t9+2.4123830247695402d-8*t6*t
     1         7+2.631878392200375d-4*gammaaa*t16+1.8005513133540818d-4*
     2         t14*t15-4.342399100269002d-5*t12*t13+5.3020963068324d-6*t
     3         10*t11
            t18 = t5**9
            t19 = 1/rhoa**12
            t20 = gammaaa**4
            t21 = 1/rhoa**1.0666666666666666d+1
            t22 = rhoa**1.3333333333333333d+0
            t23 = 1/t22
            t24 = -2.7196832676277033d-6*t8*t9+1.7578986477855002d-7*t6*
     1         t7+6.841322473346062d-1*t23*t5-5.649671283776346d-9*t20*t
     2         21+3.149302550983647d-10*t18*t19-2.0532933130264455d-1*ga
     3         mmaaa*t16+2.342799068769956d-2*t14*t15-1.3837064697606524
     4         d-3*t12*t13+5.955909787676884d-5*t10*t11+1.0d+0
            t25 = 1/t24
            t26 = 1.6455307846020562d-2*gammaaa*t16*t17*t25
            t27 = 6.582123138408225d-2*t4**2.0d+0+t26+6.0965d-1
            t28 = 1/t27
            t29 = t27**5.0d-1
            t30 = 1/t29
            t31 = 2.565564877060844d-1*t1*t3*t30+1.0d+0
            t32 = 1/t31
            t33 = 4.1138269615051404d-3*gammaaa*t16+1.0d+0
            t34 = 1/t33
            t35 = 5.136628594837797d-3*gammaaa*t16*t34+6.934448603031025
     1         d-2*gammaaa*t16*t17*t25+1.0d+0
            t36 = 1.282782438530422d-1*t1*t3*t30+1.0d+0
            t37 = t27*t31
            t38 = 1/t37**2.0d+0
            t39 = t1**2
            t40 = 1/rhoa**6.666666666666666d-1
            t41 = 6.582123138408225d-2*t39*t40
            t42 = t41+t26
            t43 = t42**5.0d-1
            t44 = t41+t26+6.0965d-1
            t45 = t44**5.0d-1
            t46 = t45+t43
            t47 = 1/t46
            t48 = 2.565564877060844d-1*t1*t3
            t49 = t48+t45
            t50 = 1/t49
            t51 = 1.0d+0-6.0965d-1*t47*t50
            t52 = log(t51)
            t53 = t41+t26+7.57211d-1
            t54 = t53**5.0d-1
            t55 = t54+t45
            t56 = 1/t55
            t57 = 1.475609999999999d-1*t50*t56+1.0d+0
            t58 = log(t57)
            t59 = t26+7.57211d-1
            t60 = t54+t43
            t61 = 1/t60
            t62 = t54+t48
            t63 = 1/t62
            t64 = t48+t43
            t65 = 1/t64
            t66 = t26+6.0965d-1
            t67 = t66**2.0d+0
            t68 = t66**3.5d+0
            t69 = (gammaaa*t16*t17*t25)**5.0d-1
            t70 = t59**5.0d-1
            t71 = 1.282782438530422d-1*t69-t70
            t72 = -2.4d+0*t68*t71-1.417963080724413d+0*t68+2.83637333333
     1         3333d-2*t67-9.086532d-1*t66**3.0d+0+4.7459599999999996d-2
     2         *t35*t66
            t73 = 1/t37**3.0d+0
            t74 = t1*t3*t30
            t75 = 2.4682961769030842d-2*t74**2.0d+0+2.8862604866934494d-
     1         1*t1*t3*t30+1.0d+0
            t76 = -8.888888888888888d-1*t72*t73*t75+7.57211d-1*(1.645530
     1         7846020562d-2*gammaaa*t16*t17*t25*t61*t65+t59*t61*t63)-2.
     2         0d+0*t58*t59+3.2910615692041123d-2*gammaaa*t16*t17*t25*t5
     3         2+5.273288888888887d-2*t35*t36*t38+4.727288888888889d-2*t
     4         28*t32-1.0d+0
            t77 = rhob**3.333333333333333d-1
            t78 = 1/t77
            t79 = t1*t78
            t80 = gammabb**5.0d-1
            t81 = t80**7
            t82 = 1/rhob**9.333333333333333d+0
            t83 = gammabb**3
            t84 = 1/rhob**8
            t85 = t80**5
            t86 = 1/rhob**6.666666666666667d+0
            t87 = gammabb**2
            t88 = 1/rhob**5.333333333333333d+0
            t89 = t80**3
            t90 = 1/rhob**4
            t91 = 1/rhob**2.6666666666666666d+0
            t92 = 2.631878392200375d-4*gammabb*t91+1.8005513133540818d-4
     1         *t89*t90-4.342399100269002d-5*t87*t88+5.3020963068324d-6*
     2         t85*t86-4.327677396975467d-7*t83*t84+2.4123830247695402d-
     3         8*t81*t82
            t93 = t80**9
            t94 = 1/rhob**12
            t95 = gammabb**4
            t96 = 1/rhob**1.0666666666666666d+1
            t97 = rhob**1.3333333333333333d+0
            t98 = 1/t97
            t99 = 6.841322473346062d-1*t80*t98-5.649671283776346d-9*t95*
     1         t96+3.149302550983647d-10*t93*t94-2.0532933130264455d-1*g
     2         ammabb*t91+2.342799068769956d-2*t89*t90-1.383706469760652
     3         4d-3*t87*t88+5.955909787676884d-5*t85*t86-2.7196832676277
     4         033d-6*t83*t84+1.7578986477855002d-7*t81*t82+1.0d+0
            t100 = 1/t99
            t101 = 1.6455307846020562d-2*gammabb*t100*t91*t92
            t102 = 6.582123138408225d-2*t79**2.0d+0+t101+6.0965d-1
            t103 = 1/t102
            t104 = t102**5.0d-1
            t105 = 1/t104
            t106 = 2.565564877060844d-1*t1*t105*t78+1.0d+0
            t107 = 1/t106
            t108 = 4.1138269615051404d-3*gammabb*t91+1.0d+0
            t109 = 1/t108
            t110 = 6.934448603031025d-2*gammabb*t100*t91*t92+5.136628594
     1         837797d-3*gammabb*t109*t91+1.0d+0
            t111 = 1.282782438530422d-1*t1*t105*t78+1.0d+0
            t112 = t102*t106
            t113 = 1/t112**2.0d+0
            t114 = 1/rhob**6.666666666666666d-1
            t115 = 6.582123138408225d-2*t114*t39
            t116 = t115+t101
            t117 = t116**5.0d-1
            t118 = t115+t101+6.0965d-1
            t119 = t118**5.0d-1
            t120 = t119+t117
            t121 = 1/t120
            t122 = 2.565564877060844d-1*t1*t78
            t123 = t122+t119
            t124 = 1/t123
            t125 = 1.0d+0-6.0965d-1*t121*t124
            t126 = log(t125)
            t127 = t115+t101+7.57211d-1
            t128 = t127**5.0d-1
            t129 = t128+t119
            t130 = 1/t129
            t131 = 1.475609999999999d-1*t124*t130+1.0d+0
            t132 = log(t131)
            t133 = t101+7.57211d-1
            t134 = t128+t117
            t135 = 1/t134
            t136 = t128+t122
            t137 = 1/t136
            t138 = t122+t117
            t139 = 1/t138
            t140 = t101+6.0965d-1
            t141 = t140**2.0d+0
            t142 = t140**3.5d+0
            t143 = (gammabb*t100*t91*t92)**5.0d-1
            t144 = t133**5.0d-1
            t145 = 1.282782438530422d-1*t143-t144
            t146 = -2.4d+0*t142*t145-1.417963080724413d+0*t142+2.8363733
     1         33333333d-2*t141-9.086532d-1*t140**3.0d+0+4.7459599999999
     2         996d-2*t110*t140
            t147 = 1/t112**3.0d+0
            t148 = t1*t105*t78
            t149 = 2.8862604866934494d-1*t1*t105*t78+2.4682961769030842d
     1         -2*t148**2.0d+0+1.0d+0
            t150 = 7.57211d-1*(1.6455307846020562d-2*gammabb*t100*t135*t
     1         139*t91*t92+t133*t135*t137)+3.2910615692041123d-2*gammabb
     2         *t100*t126*t91*t92-8.888888888888888d-1*t146*t147*t149-2.
     3         0d+0*t132*t133+5.273288888888887d-2*t110*t111*t113+4.7272
     4         88888888889d-2*t103*t107-1.0d+0
            t151 = 1/t27**2
            t152 = 1/rhoa**3.6666666666666664d+0
            t153 = -4.38808209227215d-2*gammaaa*t152*t17*t25
            t154 = 1/rhoa**13
            t155 = 1/rhoa**1.1666666666666665d+1
            t156 = 1/rhoa**1.0333333333333333d+1
            t157 = 1/rhoa**9
            t158 = 1/rhoa**7.666666666666667d+0
            t159 = 1/rhoa**6.333333333333333d+0
            t160 = 1/rhoa**5
            t161 = 1/rhoa**2.3333333333333334d+0
            t162 = 2.1757466141021625d-5*t157*t8-1.6407054045998d-6*t156
     1         *t6-9.121763297794749d-1*t161*t5+6.026316036028103d-8*t15
     2         5*t20-3.7791630611803767d-9*t154*t18-9.371196275079824d-2
     3         *t14*t160+7.379767838723479d-3*t12*t159-3.970606525117923
     4         d-4*t10*t158+5.475448834737188d-1*gammaaa*t152
            t163 = 1/t24**2
            t164 = -1.6455307846020562d-2*gammaaa*t16*t162*t163*t17
            t165 = 3.462141917580374d-6*t157*t8-2.2515574897849044d-7*t1
     1         56*t6-7.202205253416327d-4*t14*t160+2.3159461868101344d-4
     2         *t12*t159-3.5347308712216d-5*t10*t158-7.018342379201d-4*g
     3         ammaaa*t152
            t166 = 1.6455307846020562d-2*gammaaa*t16*t165*t25
            t167 = -4.38808209227215d-2*t1*t23*t4+t166+t164+t153
            t168 = 1/t33**2
            t169 = -1.369767625290079d-2*gammaaa*t152*t34-1.849186294141
     1         6065d-1*gammaaa*t152*t17*t25+6.934448603031025d-2*gammaaa
     2         *t16*t165*t25-6.934448603031025d-2*gammaaa*t16*t162*t163*
     3         t17+5.634986987915197d-5*t12*t159*t168
            t170 = 5.273288888888887d-2*t169*t36*t38
            t171 = -8.7761641845443d-2*gammaaa*t152*t17*t25*t52
            t172 = -3.2910615692041123d-2*gammaaa*t16*t162*t163*t17*t52
            t173 = 3.2910615692041123d-2*gammaaa*t16*t165*t25*t52
            t174 = 1/rhoa**1.6666666666666669d+0
            t175 = -4.38808209227215d-2*t174*t39+t166+t164+t153
            t176 = 1/t45
            t177 = 5.0d-1*t175*t176
            t178 = -8.551882923536147d-2*t1*t23
            t179 = t178+t177
            t180 = 1/t49**2
            t181 = 1/t43
            t182 = 5.0d-1*t175*t181
            t183 = t182+t177
            t184 = 1/t46**2
            t185 = 6.0965d-1*t183*t184*t50+6.0965d-1*t179*t180*t47
            t186 = 1/t51
            t187 = 3.2910615692041123d-2*gammaaa*t16*t17*t185*t186*t25
            t188 = t166+t164+t153
            t189 = -2.0d+0*t188*t58
            t190 = 1/t54
            t191 = 5.0d-1*t175*t190
            t192 = t191+t177
            t193 = 1/t55**2
            t194 = -1.475609999999999d-1*t179*t180*t56-1.475609999999999
     1         d-1*t192*t193*t50
            t195 = 1/t57
            t196 = -2.0d+0*t194*t195*t59
            t197 = t191+t178
            t198 = 1/t62**2
            t199 = t191+t182
            t200 = 1/t60**2
            t201 = t182+t178
            t202 = 1/t64**2
            t203 = 7.57211d-1*(-4.38808209227215d-2*gammaaa*t152*t17*t25
     1         *t61*t65+1.6455307846020562d-2*gammaaa*t16*t165*t25*t61*t
     2         65-1.6455307846020562d-2*gammaaa*t16*t162*t163*t17*t61*t6
     3         5-1.6455307846020562d-2*gammaaa*t16*t17*t199*t200*t25*t65
     4         +t188*t61*t63-t199*t200*t59*t63-t197*t198*t59*t61-1.64553
     5         07846020562d-2*gammaaa*t16*t17*t201*t202*t25*t61)
            t204 = t66**2.5d+0
            t205 = 1/t70
            t206 = 1/t69
            t207 = -2.6666666666666666d+0*gammaaa*t152*t17*t25+gammaaa*t
     1         16*t165*t25-gammaaa*t16*t162*t163*t17
            t208 = 6.41391219265211d-2*t206*t207-5.0d-1*t188*t205
            t209 = -8.400000000000001d+0*t188*t204*t71-2.4d+0*t208*t68-2
     1         .7259596d+0*t188*t67+5.672746666666666d-2*t188*t66+4.7459
     2         599999999996d-2*t169*t66+4.7459599999999996d-2*t188*t35-4
     3         .9628707825354457d+0*t188*t204
            t210 = -8.888888888888888d-1*t209*t73*t75
            t211 = 1/t31**2
            t212 = -8.551882923536147d-2*t1*t23*t30
            t213 = 1/t29**3
            t214 = t212-1.282782438530422d-1*t1*t167*t213*t3
            t215 = -4.2759414617680735d-2*t1*t23*t30
            t216 = t215-6.41391219265211d-2*t1*t167*t213*t3
            t217 = -9.620868288978164d-2*t1*t23*t30
            t218 = -3.333333333333333d-1*t1*t23*t30
            t219 = t218-5.0d-1*t1*t167*t213*t3
            t220 = 4.9365923538061685d-2*t219*t74-1.4431302433467247d-1*
     1         t1*t167*t213*t3+t217
            t221 = t167*t31+t214*t27
            t222 = 1/t37**4.0d+0
            t223 = 2.6666666666666666d+0*t221*t222*t72*t75-8.88888888888
     1         8888d-1*t220*t72*t73-1.0546577777777776d-1*t221*t35*t36*t
     2         73+5.273288888888887d-2*t216*t35*t38-4.727288888888889d-2
     3         *t151*t167*t32-4.727288888888889d-2*t211*t214*t28+t210+t2
     4         03+t196+t189+t187+t173+t172+t171+t170
            t224 = 1/t102**2
            t225 = 1/rhob**3.6666666666666664d+0
            t226 = -4.38808209227215d-2*gammabb*t100*t225*t92
            t227 = 1/rhob**13
            t228 = 1/rhob**1.1666666666666665d+1
            t229 = 1/rhob**1.0333333333333333d+1
            t230 = 1/rhob**9
            t231 = 1/rhob**7.666666666666667d+0
            t232 = 1/rhob**6.333333333333333d+0
            t233 = 1/rhob**5
            t234 = 1/rhob**2.3333333333333334d+0
            t235 = 6.026316036028103d-8*t228*t95-3.7791630611803767d-9*t
     1         227*t93-9.371196275079824d-2*t233*t89+7.379767838723479d-
     2         3*t232*t87-3.970606525117923d-4*t231*t85+2.17574661410216
     3         25d-5*t230*t83-1.6407054045998d-6*t229*t81-9.121763297794
     4         749d-1*t234*t80+5.475448834737188d-1*gammabb*t225
            t236 = 1/t99**2
            t237 = -1.6455307846020562d-2*gammabb*t235*t236*t91*t92
            t238 = -7.202205253416327d-4*t233*t89+2.3159461868101344d-4*
     1         t232*t87-3.5347308712216d-5*t231*t85+3.462141917580374d-6
     2         *t230*t83-2.2515574897849044d-7*t229*t81-7.018342379201d-
     3         4*gammabb*t225
            t239 = 1.6455307846020562d-2*gammabb*t100*t238*t91
            t240 = -4.38808209227215d-2*t1*t79*t98+t239+t237+t226
            t241 = 1/t108**2
            t242 = -6.934448603031025d-2*gammabb*t235*t236*t91*t92-1.849
     1         1862941416065d-1*gammabb*t100*t225*t92+6.934448603031025d
     2         -2*gammabb*t100*t238*t91+5.634986987915197d-5*t232*t241*t
     3         87-1.369767625290079d-2*gammabb*t109*t225
            t243 = 5.273288888888887d-2*t111*t113*t242
            t244 = -8.7761641845443d-2*gammabb*t100*t126*t225*t92
            t245 = -3.2910615692041123d-2*gammabb*t126*t235*t236*t91*t92
            t246 = 3.2910615692041123d-2*gammabb*t100*t126*t238*t91
            t247 = 1/rhob**1.6666666666666669d+0
            t248 = -4.38808209227215d-2*t247*t39+t239+t237+t226
            t249 = 1/t119
            t250 = 5.0d-1*t248*t249
            t251 = -8.551882923536147d-2*t1*t98
            t252 = t251+t250
            t253 = 1/t123**2
            t254 = 1/t117
            t255 = 5.0d-1*t248*t254
            t256 = t255+t250
            t257 = 1/t120**2
            t258 = 6.0965d-1*t124*t256*t257+6.0965d-1*t121*t252*t253
            t259 = 1/t125
            t260 = 3.2910615692041123d-2*gammabb*t100*t258*t259*t91*t92
            t261 = t239+t237+t226
            t262 = -2.0d+0*t132*t261
            t263 = 1/t128
            t264 = 5.0d-1*t248*t263
            t265 = t264+t250
            t266 = 1/t129**2
            t267 = -1.475609999999999d-1*t124*t265*t266-1.47560999999999
     1         9d-1*t130*t252*t253
            t268 = 1/t131
            t269 = -2.0d+0*t133*t267*t268
            t270 = t264+t251
            t271 = 1/t136**2
            t272 = t264+t255
            t273 = 1/t134**2
            t274 = t255+t251
            t275 = 1/t138**2
            t276 = 7.57211d-1*(-1.6455307846020562d-2*gammabb*t100*t135*
     1         t274*t275*t91*t92-1.6455307846020562d-2*gammabb*t100*t139
     2         *t272*t273*t91*t92-1.6455307846020562d-2*gammabb*t135*t13
     3         9*t235*t236*t91*t92-4.38808209227215d-2*gammabb*t100*t135
     4         *t139*t225*t92+1.6455307846020562d-2*gammabb*t100*t135*t1
     5         39*t238*t91-t133*t137*t272*t273-t133*t135*t270*t271+t135*
     6         t137*t261)
            t277 = t140**2.5d+0
            t278 = 1/t144
            t279 = 1/t143
            t280 = -gammabb*t235*t236*t91*t92-2.6666666666666666d+0*gamm
     1         abb*t100*t225*t92+gammabb*t100*t238*t91
            t281 = 6.41391219265211d-2*t279*t280-5.0d-1*t261*t278
            t282 = -2.4d+0*t142*t281-8.400000000000001d+0*t145*t261*t277
     1         -4.9628707825354457d+0*t261*t277-2.7259596d+0*t141*t261+5
     2         .672746666666666d-2*t140*t261+4.7459599999999996d-2*t110*
     3         t261+4.7459599999999996d-2*t140*t242
            t283 = -8.888888888888888d-1*t147*t149*t282
            t284 = 1/t106**2
            t285 = -8.551882923536147d-2*t1*t105*t98
            t286 = 1/t104**3
            t287 = t285-1.282782438530422d-1*t1*t240*t286*t78
            t288 = -4.2759414617680735d-2*t1*t105*t98
            t289 = t288-6.41391219265211d-2*t1*t240*t286*t78
            t290 = -9.620868288978164d-2*t1*t105*t98
            t291 = -3.333333333333333d-1*t1*t105*t98
            t292 = t291-5.0d-1*t1*t240*t286*t78
            t293 = -1.4431302433467247d-1*t1*t240*t286*t78+4.93659235380
     1         61685d-2*t148*t292+t290
            t294 = t102*t287+t106*t240
            t295 = 1/t112**4.0d+0
            t296 = 2.6666666666666666d+0*t146*t149*t294*t295-1.054657777
     1         7777776d-1*t110*t111*t147*t294-8.888888888888888d-1*t146*
     2         t147*t293+5.273288888888887d-2*t110*t113*t289-4.727288888
     3         888889d-2*t103*t284*t287+t283+t276+t269+t262+t260+t246+t2
     4         45+t244+t243-4.727288888888889d-2*t107*t224*t240
            t297 = 1/t5
            t298 = -8.159049802883108d-6*t12*t9-2.2598685135105387d-8*t2
     1         1*t8+6.15264526724925d-7*t10*t7+1.4171861479426412d-9*t19
     2         *t6+3.514198603154934d-2*t15*t5+3.420661236673031d-1*t23*
     3         t297-2.0532933130264455d-1*t16+1.488977446919221d-4*t11*t
     4         14-2.767412939521305d-3*gammaaa*t13
            t299 = -1.2983032190926402d-6*t12*t9+8.443340586693391d-8*t1
     1         0*t7+2.7008269700311227d-4*t15*t5+2.631878392200375d-4*t1
     2         6+1.3255240767081d-5*t11*t14-8.684798200538004d-5*gammaaa
     3         *t13
            t300 = 1.6455307846020562d-2*gammaaa*t16*t25*t299-1.64553078
     1         46020562d-2*gammaaa*t16*t163*t17*t298+1.6455307846020562d
     2         -2*t16*t17*t25
            t301 = -4.727288888888889d-2*t151*t300*t32
            t302 = 5.136628594837797d-3*t16*t34+6.934448603031025d-2*gam
     1         maaa*t16*t25*t299-6.934448603031025d-2*gammaaa*t16*t163*t
     2         17*t298+6.934448603031025d-2*t16*t17*t25-2.11312012046819
     3         9d-5*gammaaa*t13*t168
            t303 = 5.273288888888887d-2*t302*t36*t38
            t304 = -3.2910615692041123d-2*gammaaa*t16*t163*t17*t298*t52
            t305 = 5.0d-1*t181*t300
            t306 = 5.0d-1*t176*t300
            t307 = t306+t305
            t308 = 6.0965d-1*t184*t307*t50+3.04825d-1*t176*t180*t300*t47
            t309 = 3.2910615692041123d-2*gammaaa*t16*t17*t186*t25*t308
            t310 = 3.2910615692041123d-2*gammaaa*t299*t52+3.291061569204
     1         1123d-2*t17*t52
            t311 = -2.0d+0*t300*t58
            t312 = 5.0d-1*t190*t300
            t313 = t312+t306
            t314 = -7.378049999999994d-2*t176*t180*t300*t56-1.4756099999
     1         99999d-1*t193*t313*t50
            t315 = -2.0d+0*t195*t314*t59
            t316 = t312+t305
            t317 = 7.57211d-1*(1.6455307846020562d-2*gammaaa*t16*t25*t29
     1         9*t61*t65-1.6455307846020562d-2*gammaaa*t16*t163*t17*t298
     2         *t61*t65+1.6455307846020562d-2*t16*t17*t25*t61*t65-1.6455
     3         307846020562d-2*gammaaa*t16*t17*t200*t25*t316*t65+t300*t6
     4         1*t63-t200*t316*t59*t63-5.0d-1*t190*t198*t300*t59*t61-8.2
     5         27653923010281d-3*gammaaa*t16*t17*t181*t202*t25*t300*t61)
            t318 = 1/t29**5
            t319 = 6.064083168526658d-3*t1*t211*t3*t300*t318
            t320 = -3.3822411899821336d-3*t1*t213*t3*t300*t35*t38
            t321 = t300*t31-1.282782438530422d-1*t1*t3*t30*t300
            t322 = 2.6666666666666666d+0*t222*t321*t72*t75
            t323 = -1.4431302433467247d-1*t1*t213*t3*t300
            t324 = t323-2.4682961769030842d-2*t151*t300*t39*t40
            t325 = gammaaa*t16*t25*t299-gammaaa*t16*t163*t17*t298+t16*t1
     1         7*t25
            t326 = 6.41391219265211d-2*t206*t325-5.0d-1*t205*t300
            t327 = -8.400000000000001d+0*t204*t300*t71-2.4d+0*t326*t68-2
     1         .7259596d+0*t300*t67+4.7459599999999996d-2*t302*t66+5.672
     2         746666666666d-2*t300*t66+4.7459599999999996d-2*t300*t35-4
     3         .9628707825354457d+0*t204*t300
            t328 = -8.888888888888888d-1*t327*t75-8.888888888888888d-1*t
     1         324*t72-1.0546577777777776d-1*t321*t35*t36
            t329 = 1/t80
            t330 = 3.420661236673031d-1*t329*t98-2.2598685135105387d-8*t
     1         83*t96+1.4171861479426412d-9*t81*t94-2.0532933130264455d-
     2         1*t91+3.514198603154934d-2*t80*t90+1.488977446919221d-4*t
     3         86*t89-2.767412939521305d-3*gammabb*t88-8.159049802883108
     4         d-6*t84*t87+6.15264526724925d-7*t82*t85
            t331 = 2.631878392200375d-4*t91+2.7008269700311227d-4*t80*t9
     1         0+1.3255240767081d-5*t86*t89-8.684798200538004d-5*gammabb
     2         *t88-1.2983032190926402d-6*t84*t87+8.443340586693391d-8*t
     3         82*t85
            t332 = -1.6455307846020562d-2*gammabb*t236*t330*t91*t92+1.64
     1         55307846020562d-2*t100*t91*t92+1.6455307846020562d-2*gamm
     2         abb*t100*t331*t91
            t333 = -4.727288888888889d-2*t107*t224*t332
            t334 = -6.934448603031025d-2*gammabb*t236*t330*t91*t92+6.934
     1         448603031025d-2*t100*t91*t92+6.934448603031025d-2*gammabb
     2         *t100*t331*t91+5.136628594837797d-3*t109*t91-2.1131201204
     3         68199d-5*gammabb*t241*t88
            t335 = 5.273288888888887d-2*t111*t113*t334
            t336 = -3.2910615692041123d-2*gammabb*t126*t236*t330*t91*t92
            t337 = 5.0d-1*t254*t332
            t338 = 5.0d-1*t249*t332
            t339 = t338+t337
            t340 = 6.0965d-1*t124*t257*t339+3.04825d-1*t121*t249*t253*t3
     1         32
            t341 = 3.2910615692041123d-2*gammabb*t100*t259*t340*t91*t92
            t342 = 3.2910615692041123d-2*t126*t92+3.2910615692041123d-2*
     1         gammabb*t126*t331
            t343 = -2.0d+0*t132*t332
            t344 = 5.0d-1*t263*t332
            t345 = t344+t338
            t346 = -1.475609999999999d-1*t124*t266*t345-7.37804999999999
     1         4d-2*t130*t249*t253*t332
            t347 = -2.0d+0*t133*t268*t346
            t348 = t344+t337
            t349 = 7.57211d-1*(-1.6455307846020562d-2*gammabb*t100*t139*
     1         t273*t348*t91*t92-8.227653923010281d-3*gammabb*t100*t135*
     2         t254*t275*t332*t91*t92-1.6455307846020562d-2*gammabb*t135
     3         *t139*t236*t330*t91*t92+1.6455307846020562d-2*t100*t135*t
     4         139*t91*t92+1.6455307846020562d-2*gammabb*t100*t135*t139*
     5         t331*t91-t133*t137*t273*t348-5.0d-1*t133*t135*t263*t271*t
     6         332+t135*t137*t332)
            t350 = 1/t104**5
            t351 = 6.064083168526658d-3*t1*t284*t332*t350*t78
            t352 = -3.3822411899821336d-3*t1*t110*t113*t286*t332*t78
            t353 = t106*t332-1.282782438530422d-1*t1*t105*t332*t78
            t354 = 2.6666666666666666d+0*t146*t149*t295*t353
            t355 = -1.4431302433467247d-1*t1*t286*t332*t78
            t356 = t355-2.4682961769030842d-2*t114*t224*t332*t39
            t357 = -gammabb*t236*t330*t91*t92+t100*t91*t92+gammabb*t100*
     1         t331*t91
            t358 = 6.41391219265211d-2*t279*t357-5.0d-1*t278*t332
            t359 = -2.4d+0*t142*t358+4.7459599999999996d-2*t140*t334-8.4
     1         00000000000001d+0*t145*t277*t332-4.9628707825354457d+0*t2
     2         77*t332-2.7259596d+0*t141*t332+5.672746666666666d-2*t140*
     3         t332+4.7459599999999996d-2*t110*t332
            t360 = -8.888888888888888d-1*t149*t359-8.888888888888888d-1*
     1         t146*t356-1.0546577777777776d-1*t110*t111*t353
            t361 = 1/rhoa**4.666666666666667d+0
            t362 = 1.6089634338331216d-1*gammaaa*t17*t25*t361
            t363 = 8.7761641845443d-2*gammaaa*t152*t162*t163*t17
            t364 = -8.7761641845443d-2*gammaaa*t152*t165*t25
            t365 = t162**2
            t366 = 1/t24**3
            t367 = 3.2910615692041123d-2*gammaaa*t16*t17*t365*t366
            t368 = 1/rhoa**14
            t369 = 1/rhoa**1.2666666666666665d+1
            t370 = 1/rhoa**1.1333333333333334d+1
            t371 = 1/rhoa**10
            t372 = 1/rhoa**8.666666666666666d+0
            t373 = 1/rhoa**7.333333333333333d+0
            t374 = 1/rhoa**6
            t375 = 1/rhoa**3.3333333333333337d+0
            t376 = -1.9581719526919464d-4*t371*t8+1.695395584753127d-5*t
     1         370*t6+2.1284114361521084d+0*t375*t5+4.685598137539912d-1
     2         *t14*t374-4.6738529645248705d-2*t12*t373+3.04413166925707
     3         47d-3*t10*t372-7.030702042032786d-7*t20*t369+4.9129119795
     4         344894d-8*t18*t368-2.0076645727369685d+0*gammaaa*t361
            t377 = -1.6455307846020562d-2*gammaaa*t16*t163*t17*t376
            t378 = -3.2910615692041123d-2*gammaaa*t16*t162*t163*t165
            t379 = -3.115927725822337d-5*t371*t8+2.326609406111068d-6*t3
     1         70*t6+3.6011026267081636d-3*t14*t374-1.466765918313085d-3
     2         *t12*t373+2.709960334603227d-4*t10*t372+2.573392205707033
     3         5d-3*gammaaa*t361
            t380 = 1.6455307846020562d-2*gammaaa*t16*t25*t379
            t381 = 7.313470153786916d-2*t16*t39+t380+t378+t377+t367+t364
     1         +t363+t362
            t382 = 1/t27**3
            t383 = t167**2
            t384 = 1/t33**3
            t385 = 1.2363392745928628d-6*t371*t384*t8+6.934448603031025d
     1         -2*gammaaa*t16*t25*t379-6.934448603031025d-2*gammaaa*t16*
     2         t163*t17*t376-5.071488289123677d-4*t12*t168*t373+1.386889
     3         720606205d-1*gammaaa*t16*t17*t365*t366+5.02248129273029d-
     4         2*gammaaa*t34*t361+6.780349745185891d-1*gammaaa*t17*t25*t
     5         361-3.698372588283213d-1*gammaaa*t152*t165*t25+3.69837258
     6         8283213d-1*gammaaa*t152*t162*t163*t17-1.386889720606205d-
     7         1*gammaaa*t16*t162*t163*t165
            t386 = 1/t31**3
            t387 = t214**2
            t388 = t221**2
            t389 = 1/t37**5.0d+0
            t390 = t185**2
            t391 = 1/t51**2
            t392 = t179**2
            t393 = 1/t49**3
            t394 = t175**2
            t395 = 1/t45**3
            t396 = -2.5d-1*t394*t395
            t397 = 5.0d-1*t176*t381
            t398 = 1.1402510564714863d-1*t1*t161
            t399 = t398+t397+t396
            t400 = t183**2
            t401 = 1/t46**3
            t402 = 1/t43**3
            t403 = -2.5d-1*t394*t402
            t404 = 5.0d-1*t181*t381
            t405 = t404+t403+t397+t396
            t406 = 6.0965d-1*t184*t405*t50-1.2193000000000001d+0*t400*t4
     1         01*t50+6.0965d-1*t180*t399*t47-1.2193000000000001d+0*t392
     2         *t393*t47-1.2193000000000001d+0*t179*t180*t183*t184
            t407 = t380+t378+t377+t367+t364+t363+t362
            t408 = t194**2
            t409 = 1/t57**2
            t410 = t192**2
            t411 = 1/t55**3
            t412 = 1/t54**3
            t413 = -2.5d-1*t394*t412
            t414 = 5.0d-1*t190*t381
            t415 = t414+t413+t397+t396
            t416 = -1.475609999999999d-1*t180*t399*t56+2.951219999999998
     1         d-1*t392*t393*t56-1.475609999999999d-1*t193*t415*t50+2.95
     2         1219999999998d-1*t410*t411*t50+2.951219999999998d-1*t179*
     3         t180*t192*t193
            t417 = t197**2
            t418 = 1/t62**3
            t419 = t414+t413+t398
            t420 = t199**2
            t421 = 1/t60**3
            t422 = t414+t413+t404+t403
            t423 = t201**2
            t424 = 1/t64**3
            t425 = t404+t403+t398
            t426 = t188**2
            t427 = t66**1.5d+0
            t428 = 1/t69**3
            t429 = t207**2
            t430 = 1/t70**3
            t431 = gammaaa*t16*t25*t379-gammaaa*t16*t163*t17*t376+2*gamm
     1         aaa*t16*t17*t365*t366+9.777777777777779d+0*gammaaa*t17*t2
     2         5*t361-5.333333333333333d+0*gammaaa*t152*t165*t25+5.33333
     3         3333333333d+0*gammaaa*t152*t162*t163*t17-2*gammaaa*t16*t1
     4         62*t163*t165
            t432 = 6.41391219265211d-2*t206*t431+2.5d-1*t426*t430-3.2069
     1         56096326055d-2*t428*t429-5.0d-1*t205*t407
            t433 = -2.1d+1*t426*t427*t71-8.400000000000001d+0*t204*t407*
     1         t71-2.4d+0*t432*t68-2.7259596d+0*t407*t67-5.4519192d+0*t4
     2         26*t66+5.672746666666666d-2*t407*t66+4.7459599999999996d-
     3         2*t385*t66-1.2407176956338616d+1*t426*t427+5.672746666666
     4         666d-2*t426+4.7459599999999996d-2*t35*t407-4.962870782535
     5         4457d+0*t204*t407-1.68d+1*t188*t204*t208+9.49191999999999
     6         9d-2*t169*t188
            t434 = 9.620868288978166d-2*t1*t3*t318*t383-6.41391219265211
     1         d-2*t1*t213*t3*t381+5.701255282357431d-2*t1*t161*t30+4.27
     2         59414617680735d-2*t1*t167*t213*t23
            t435 = 1.924173657795633d-1*t1*t3*t318*t383-1.28278243853042
     1         2d-1*t1*t213*t3*t381+1.1402510564714863d-1*t1*t161*t30+8.
     2         551882923536147d-2*t1*t167*t213*t23
            t436 = 7.5d-1*t1*t3*t318*t383-5.0d-1*t1*t213*t3*t381+4.44444
     1         4444444444d-1*t1*t161*t30+3.333333333333333d-1*t1*t167*t2
     2         13*t23
            t437 = 4.9365923538061685d-2*t1*t3*t30*t436+2.16469536502008
     1         7d-1*t1*t3*t318*t383-1.4431302433467247d-1*t1*t213*t3*t38
     2         1+1.2827824385304218d-1*t1*t161*t30+9.620868288978164d-2*
     3         t1*t167*t213*t23+4.9365923538061685d-2*t219**2
            t438 = t27*t435+t31*t381+2*t167*t214
            t439 = -8.888888888888888d-1*t433*t73*t75+2.6666666666666666
     1         d+0*t222*t438*t72*t75-1.0666666666666666d+1*t388*t389*t72
     2         *t75+5.333333333333333d+0*t209*t221*t222*t75-8.8888888888
     3         88888d-1*t437*t72*t73-1.0546577777777776d-1*t35*t36*t438*
     4         t73-2.109315555555555d-1*t169*t221*t36*t73-2.109315555555
     5         555d-1*t216*t221*t35*t73-1.7777777777777776d+0*t209*t220*
     6         t73+5.333333333333333d+0*t220*t221*t222*t72+7.57211d-1*(1
     7         .6455307846020562d-2*gammaaa*t16*t25*t379*t61*t65-1.64553
     8         07846020562d-2*gammaaa*t16*t163*t17*t376*t61*t65+3.291061
     9         5692041123d-2*gammaaa*t16*t17*t365*t366*t61*t65+1.6089634
     :         338331216d-1*gammaaa*t17*t25*t361*t61*t65-8.7761641845443
     ;         d-2*gammaaa*t152*t165*t25*t61*t65+8.7761641845443d-2*gamm
     <         aaa*t152*t162*t163*t17*t61*t65-3.2910615692041123d-2*gamm
     =         aaa*t16*t162*t163*t165*t61*t65-1.6455307846020562d-2*gamm
     >         aaa*t16*t17*t200*t25*t422*t65+3.2910615692041123d-2*gamma
     ?         aa*t16*t17*t25*t420*t421*t65+8.7761641845443d-2*gammaaa*t
     @         152*t17*t199*t200*t25*t65-3.2910615692041123d-2*gammaaa*t
     1         16*t165*t199*t200*t25*t65+3.2910615692041123d-2*gammaaa*t
     2         16*t162*t163*t17*t199*t200*t65+t407*t61*t63-t200*t422*t59
     3         *t63+2*t420*t421*t59*t63-2*t188*t199*t200*t63-t198*t419*t
     4         59*t61+2*t417*t418*t59*t61-1.6455307846020562d-2*gammaaa*
     5         t16*t17*t202*t25*t425*t61+3.2910615692041123d-2*gammaaa*t
     6         16*t17*t25*t423*t424*t61+8.7761641845443d-2*gammaaa*t152*
     7         t17*t201*t202*t25*t61-3.2910615692041123d-2*gammaaa*t16*t
     8         165*t201*t202*t25*t61+3.2910615692041123d-2*gammaaa*t16*t
     9         162*t163*t17*t201*t202*t61-2*t188*t197*t198*t61+2*t197*t1
     :         98*t199*t200*t59+3.2910615692041123d-2*gammaaa*t16*t17*t1
     ;         99*t200*t201*t202*t25)-2.0d+0*t195*t416*t59+2.0d+0*t408*t
     <         409*t59-2.0d+0*t407*t58+3.2910615692041123d-2*gammaaa*t16
     =         *t25*t379*t52-3.2910615692041123d-2*gammaaa*t16*t163*t17*
     >         t376*t52+6.582123138408225d-2*gammaaa*t16*t17*t365*t366*t
     ?         52+3.217926867666243d-1*gammaaa*t17*t25*t361*t52-1.755232
     @         83690886d-1*gammaaa*t152*t165*t25*t52+1.75523283690886d-1
     1         *gammaaa*t152*t162*t163*t17*t52-6.582123138408225d-2*gamm
     2         aaa*t16*t162*t163*t165*t52-4.727288888888889d-2*t211*t28*
     3         t435+5.273288888888887d-2*t35*t38*t434+3.2910615692041123
     4         d-2*gammaaa*t16*t17*t186*t25*t406-3.2910615692041123d-2*g
     5         ammaaa*t16*t17*t25*t390*t391+3.1639733333333325d-1*t222*t
     6         35*t36*t388+9.454577777777778d-2*t28*t386*t387+5.27328888
     7         8888887d-2*t36*t38*t385+9.454577777777778d-2*t32*t382*t38
     8         3-4.727288888888889d-2*t151*t32*t381+1.0546577777777776d-
     9         1*t169*t216*t38-1.75523283690886d-1*gammaaa*t152*t17*t185
     :         *t186*t25+6.582123138408225d-2*gammaaa*t16*t165*t185*t186
     ;         *t25+9.454577777777778d-2*t151*t167*t211*t214-4.0d+0*t188
     <         *t194*t195-6.582123138408225d-2*gammaaa*t16*t162*t163*t17
     =         *t185*t186
            t440 = 1/rhob**4.666666666666667d+0
            t441 = 1.6089634338331216d-1*gammabb*t100*t440*t92
            t442 = 8.7761641845443d-2*gammabb*t225*t235*t236*t92
            t443 = -8.7761641845443d-2*gammabb*t100*t225*t238
            t444 = t235**2
            t445 = 1/t99**3
            t446 = 3.2910615692041123d-2*gammabb*t444*t445*t91*t92
            t447 = 1/rhob**14
            t448 = 1/rhob**1.2666666666666665d+1
            t449 = 1/rhob**1.1333333333333334d+1
            t450 = 1/rhob**10
            t451 = 1/rhob**8.666666666666666d+0
            t452 = 1/rhob**7.333333333333333d+0
            t453 = 1/rhob**6
            t454 = 1/rhob**3.3333333333333337d+0
            t455 = -7.030702042032786d-7*t448*t95+4.9129119795344894d-8*
     1         t447*t93+4.685598137539912d-1*t453*t89-4.6738529645248705
     2         d-2*t452*t87+3.0441316692570747d-3*t451*t85-1.95817195269
     3         19464d-4*t450*t83+1.695395584753127d-5*t449*t81+2.1284114
     4         361521084d+0*t454*t80-2.0076645727369685d+0*gammabb*t440
            t456 = -1.6455307846020562d-2*gammabb*t236*t455*t91*t92
            t457 = -3.2910615692041123d-2*gammabb*t235*t236*t238*t91
            t458 = 3.6011026267081636d-3*t453*t89-1.466765918313085d-3*t
     1         452*t87+2.709960334603227d-4*t451*t85-3.115927725822337d-
     2         5*t450*t83+2.326609406111068d-6*t449*t81+2.57339220570703
     3         35d-3*gammabb*t440
            t459 = 1.6455307846020562d-2*gammabb*t100*t458*t91
            t460 = 7.313470153786916d-2*t39*t91+t459+t457+t456+t446+t443
     1         +t442+t441
            t461 = 1/t102**3
            t462 = t240**2
            t463 = 1/t108**3
            t464 = -6.934448603031025d-2*gammabb*t236*t455*t91*t92+1.386
     1         889720606205d-1*gammabb*t444*t445*t91*t92+6.7803497451858
     2         91d-1*gammabb*t100*t440*t92+3.698372588283213d-1*gammabb*
     3         t225*t235*t236*t92+6.934448603031025d-2*gammabb*t100*t458
     4         *t91-1.386889720606205d-1*gammabb*t235*t236*t238*t91-5.07
     5         1488289123677d-4*t241*t452*t87+1.2363392745928628d-6*t450
     6         *t463*t83+5.02248129273029d-2*gammabb*t109*t440-3.6983725
     7         88283213d-1*gammabb*t100*t225*t238
            t465 = 1/t106**3
            t466 = t287**2
            t467 = t294**2
            t468 = 1/t112**5.0d+0
            t469 = t258**2
            t470 = 1/t125**2
            t471 = t252**2
            t472 = 1/t123**3
            t473 = t248**2
            t474 = 1/t119**3
            t475 = -2.5d-1*t473*t474
            t476 = 5.0d-1*t249*t460
            t477 = 1.1402510564714863d-1*t1*t234
            t478 = t477+t476+t475
            t479 = t256**2
            t480 = 1/t120**3
            t481 = 1/t117**3
            t482 = -2.5d-1*t473*t481
            t483 = 5.0d-1*t254*t460
            t484 = t483+t482+t476+t475
            t485 = 6.0965d-1*t124*t257*t484-1.2193000000000001d+0*t124*t
     1         479*t480+6.0965d-1*t121*t253*t478-1.2193000000000001d+0*t
     2         121*t471*t472-1.2193000000000001d+0*t252*t253*t256*t257
            t486 = t459+t457+t456+t446+t443+t442+t441
            t487 = t267**2
            t488 = 1/t131**2
            t489 = t265**2
            t490 = 1/t129**3
            t491 = 1/t128**3
            t492 = -2.5d-1*t473*t491
            t493 = 5.0d-1*t263*t460
            t494 = t493+t492+t476+t475
            t495 = -1.475609999999999d-1*t124*t266*t494+2.95121999999999
     1         8d-1*t124*t489*t490-1.475609999999999d-1*t130*t253*t478+2
     2         .951219999999998d-1*t130*t471*t472+2.951219999999998d-1*t
     3         252*t253*t265*t266
            t496 = t270**2
            t497 = 1/t136**3
            t498 = t493+t492+t477
            t499 = t272**2
            t500 = 1/t134**3
            t501 = t493+t492+t483+t482
            t502 = t274**2
            t503 = 1/t138**3
            t504 = t483+t482+t477
            t505 = t261**2
            t506 = t140**1.5d+0
            t507 = 1/t143**3
            t508 = t280**2
            t509 = 1/t144**3
            t510 = -gammabb*t236*t455*t91*t92+2*gammabb*t444*t445*t91*t9
     1         2+9.777777777777779d+0*gammabb*t100*t440*t92+5.3333333333
     2         33333d+0*gammabb*t225*t235*t236*t92+gammabb*t100*t458*t91
     3         -2*gammabb*t235*t236*t238*t91-5.333333333333333d+0*gammab
     4         b*t100*t225*t238
            t511 = 6.41391219265211d-2*t279*t510+2.5d-1*t505*t509-3.2069
     1         56096326055d-2*t507*t508-5.0d-1*t278*t486
            t512 = -2.4d+0*t142*t511-2.1d+1*t145*t505*t506-1.24071769563
     1         38616d+1*t505*t506-5.4519192d+0*t140*t505+5.6727466666666
     2         66d-2*t505-8.400000000000001d+0*t145*t277*t486-4.96287078
     3         25354457d+0*t277*t486-2.7259596d+0*t141*t486+5.6727466666
     4         66666d-2*t140*t486+4.7459599999999996d-2*t110*t486+4.7459
     5         599999999996d-2*t140*t464-1.68d+1*t261*t277*t281+9.491919
     6         999999999d-2*t242*t261
            t513 = 4.2759414617680735d-2*t1*t240*t286*t98+9.620868288978
     1         166d-2*t1*t350*t462*t78-6.41391219265211d-2*t1*t286*t460*
     2         t78+5.701255282357431d-2*t1*t105*t234
            t514 = 8.551882923536147d-2*t1*t240*t286*t98+1.9241736577956
     1         33d-1*t1*t350*t462*t78-1.282782438530422d-1*t1*t286*t460*
     2         t78+1.1402510564714863d-1*t1*t105*t234
            t515 = 3.333333333333333d-1*t1*t240*t286*t98+7.5d-1*t1*t350*
     1         t462*t78-5.0d-1*t1*t286*t460*t78+4.444444444444444d-1*t1*
     2         t105*t234
            t516 = 9.620868288978164d-2*t1*t240*t286*t98+4.9365923538061
     1         685d-2*t1*t105*t515*t78+2.164695365020087d-1*t1*t350*t462
     2         *t78-1.4431302433467247d-1*t1*t286*t460*t78+4.93659235380
     3         61685d-2*t292**2+1.2827824385304218d-1*t1*t105*t234
            t517 = t102*t514+t106*t460+2*t240*t287
            t518 = 7.57211d-1*(-1.6455307846020562d-2*gammabb*t100*t135*
     1         t275*t504*t91*t92+3.2910615692041123d-2*gammabb*t100*t135
     2         *t502*t503*t91*t92-1.6455307846020562d-2*gammabb*t100*t13
     3         9*t273*t501*t91*t92+3.2910615692041123d-2*gammabb*t100*t1
     4         39*t499*t500*t91*t92-1.6455307846020562d-2*gammabb*t135*t
     5         139*t236*t455*t91*t92+3.2910615692041123d-2*gammabb*t135*
     6         t139*t444*t445*t91*t92+3.2910615692041123d-2*gammabb*t100
     7         *t272*t273*t274*t275*t91*t92+3.2910615692041123d-2*gammab
     8         b*t135*t235*t236*t274*t275*t91*t92+3.2910615692041123d-2*
     9         gammabb*t139*t235*t236*t272*t273*t91*t92+1.60896343383312
     :         16d-1*gammabb*t100*t135*t139*t440*t92+8.7761641845443d-2*
     ;         gammabb*t100*t135*t225*t274*t275*t92+8.7761641845443d-2*g
     <         ammabb*t100*t139*t225*t272*t273*t92+8.7761641845443d-2*ga
     =         mmabb*t135*t139*t225*t235*t236*t92+1.6455307846020562d-2*
     >         gammabb*t100*t135*t139*t458*t91-3.2910615692041123d-2*gam
     ?         mabb*t100*t135*t238*t274*t275*t91-3.2910615692041123d-2*g
     @         ammabb*t100*t139*t238*t272*t273*t91-3.2910615692041123d-2
     1         *gammabb*t135*t139*t235*t236*t238*t91-t133*t137*t273*t501
     2         +2*t133*t137*t499*t500-t133*t135*t271*t498+2*t133*t135*t4
     3         96*t497+t135*t137*t486+2*t133*t270*t271*t272*t273-2*t137*
     4         t261*t272*t273-2*t135*t261*t270*t271-8.7761641845443d-2*g
     5         ammabb*t100*t135*t139*t225*t238)+3.2910615692041123d-2*ga
     6         mmabb*t100*t259*t485*t91*t92-3.2910615692041123d-2*gammab
     7         b*t100*t469*t470*t91*t92-3.2910615692041123d-2*gammabb*t1
     8         26*t236*t455*t91*t92+6.582123138408225d-2*gammabb*t126*t4
     9         44*t445*t91*t92-6.582123138408225d-2*gammabb*t235*t236*t2
     :         58*t259*t91*t92+3.217926867666243d-1*gammabb*t100*t126*t4
     ;         40*t92-1.75523283690886d-1*gammabb*t100*t225*t258*t259*t9
     <         2+1.75523283690886d-1*gammabb*t126*t225*t235*t236*t92+3.2
     =         910615692041123d-2*gammabb*t100*t126*t458*t91+6.582123138
     >         408225d-2*gammabb*t100*t238*t258*t259*t91-6.5821231384082
     ?         25d-2*gammabb*t126*t235*t236*t238*t91+2.6666666666666666d
     @         +0*t146*t149*t295*t517-1.0546577777777776d-1*t110*t111*t1
     1         47*t517-8.888888888888888d-1*t146*t147*t516-4.72728888888
     2         8889d-2*t103*t284*t514+5.273288888888887d-2*t110*t113*t51
     3         3-8.888888888888888d-1*t147*t149*t512-2.0d+0*t133*t268*t4
     4         95+2.0d+0*t133*t487*t488-2.0d+0*t132*t486-1.0666666666666
     5         666d+1*t146*t149*t467*t468+3.1639733333333325d-1*t110*t11
     6         1*t295*t467+9.454577777777778d-2*t103*t465*t466+5.2732888
     7         88888887d-2*t111*t113*t464+9.454577777777778d-2*t107*t461
     8         *t462-4.727288888888889d-2*t107*t224*t460+5.3333333333333
     9         33d+0*t146*t293*t294*t295+5.333333333333333d+0*t149*t282*
     :         t294*t295-2.109315555555555d-1*t110*t147*t289*t294-2.1093
     ;         15555555555d-1*t111*t147*t242*t294-1.7777777777777776d+0*
     <         t147*t282*t293+1.0546577777777776d-1*t113*t242*t289+9.454
     =         577777777778d-2*t224*t240*t284*t287-4.0d+0*t261*t267*t268
     >         -1.75523283690886d-1*gammabb*t100*t126*t225*t238
            t519 = 3.2910615692041123d-2*gammaaa*t16*t25*t299*t52
            t520 = 3.2910615692041123d-2*t16*t17*t25*t52
            t521 = -8.888888888888888d-1*t327*t73*t75
            t522 = t323-2.4682961769030842d-2*t1*t213*t3*t300*t74
            t523 = -1.0546577777777776d-1*t321*t35*t36*t73
            t524 = 2.4105264144112412d-7*t155*t8-1.7006233775311694d-8*t
     1         154*t6-1.4056794412619736d-1*t160*t5-4.5608816488973747d-
     2         1*t161*t297+1.4759535677446958d-2*gammaaa*t159-9.92651631
     3         2794808d-4*t14*t158+6.527239842306487d-5*t12*t157-5.74246
     4         8916099301d-6*t10*t156+5.475448834737188d-1*t152
            t525 = -1.0803307880124491d-3*t160*t5+4.631892373620269d-4*g
     1         ammaaa*t159-8.836827178054d-5*t14*t158+1.0386425752741123
     2         d-5*t12*t157-7.880451214247165d-7*t10*t156-7.018342379201
     3         d-4*t152
            t526 = 1.6455307846020562d-2*gammaaa*t16*t25*t525-1.64553078
     1         46020562d-2*gammaaa*t16*t163*t17*t524+3.2910615692041123d
     2         -2*gammaaa*t16*t162*t17*t298*t366-4.38808209227215d-2*gam
     3         maaa*t152*t25*t299-1.6455307846020562d-2*gammaaa*t16*t162
     4         *t163*t299+4.38808209227215d-2*gammaaa*t152*t163*t17*t298
     5         -1.6455307846020562d-2*gammaaa*t16*t163*t165*t298-4.38808
     6         209227215d-2*t152*t17*t25+1.6455307846020562d-2*t16*t165*
     7         t25-1.6455307846020562d-2*t16*t162*t163*t17
            t527 = 6.934448603031025d-2*gammaaa*t16*t25*t525-6.934448603
     1         031025d-2*gammaaa*t16*t163*t17*t524-4.6362722797232353d-7
     2         *t12*t157*t384+1.386889720606205d-1*gammaaa*t16*t162*t17*
     3         t298*t366-1.369767625290079d-2*t152*t34-1.849186294141606
     4         5d-1*gammaaa*t152*t25*t299-6.934448603031025d-2*gammaaa*t
     5         16*t162*t163*t299+1.8491862941416065d-1*gammaaa*t152*t163
     6         *t17*t298-6.934448603031025d-2*gammaaa*t16*t163*t165*t298
     7         -1.8491862941416065d-1*t152*t17*t25+6.934448603031025d-2*
     8         t16*t165*t25-6.934448603031025d-2*t16*t162*t163*t17+1.690
     9         496096374559d-4*gammaaa*t159*t168
            t528 = -2.5d-1*t175*t300*t395
            t529 = 5.0d-1*t176*t526
            t530 = t529+t528
            t531 = -2.5d-1*t175*t300*t402
            t532 = 5.0d-1*t181*t526
            t533 = t532+t531+t529+t528
            t534 = 6.0965d-1*t184*t50*t533+6.0965d-1*t180*t47*t530-1.219
     1         3000000000001d+0*t183*t307*t401*t50-6.0965d-1*t176*t179*t
     2         300*t393*t47-6.0965d-1*t179*t180*t184*t307-3.04825d-1*t17
     3         6*t180*t183*t184*t300
            t535 = -2.5d-1*t175*t300*t412
            t536 = 5.0d-1*t190*t526
            t537 = t536+t535+t529+t528
            t538 = -1.475609999999999d-1*t180*t530*t56+1.475609999999999
     1         d-1*t176*t179*t300*t393*t56-1.475609999999999d-1*t193*t50
     2         *t537+2.951219999999998d-1*t192*t313*t411*t50+1.475609999
     3         999999d-1*t179*t180*t193*t313+7.378049999999994d-2*t176*t
     4         180*t192*t193*t300
            t539 = t536+t535
            t540 = t536+t535+t532+t531
            t541 = t532+t531
            t542 = 1/t29**7
            t543 = gammaaa*t16*t25*t525-gammaaa*t16*t163*t17*t524+2*gamm
     1         aaa*t16*t162*t17*t298*t366-2.6666666666666666d+0*gammaaa*
     2         t152*t25*t299-gammaaa*t16*t162*t163*t299+2.66666666666666
     3         66d+0*gammaaa*t152*t163*t17*t298-gammaaa*t16*t163*t165*t2
     4         98-2.6666666666666666d+0*t152*t17*t25+t16*t165*t25-t16*t1
     5         62*t163*t17
            t544 = 6.41391219265211d-2*t206*t543-5.0d-1*t205*t526+2.5d-1
     1         *t188*t300*t430-3.206956096326055d-2*t207*t325*t428
            t545 = -8.400000000000001d+0*t204*t526*t71-2.1d+1*t188*t300*
     1         t427*t71-2.4d+0*t544*t68-2.7259596d+0*t526*t67+4.74595999
     2         99999996d-2*t527*t66+5.672746666666666d-2*t526*t66-5.4519
     3         192d+0*t188*t300*t66+4.7459599999999996d-2*t35*t526-4.962
     4         8707825354457d+0*t204*t526-1.2407176956338616d+1*t188*t30
     5         0*t427-8.400000000000001d+0*t188*t204*t326+4.745959999999
     6         9996d-2*t188*t302-8.400000000000001d+0*t204*t208*t300+5.6
     7         72746666666666d-2*t188*t300+4.7459599999999996d-2*t169*t3
     8         00
            t546 = -6.41391219265211d-2*t1*t213*t3*t526+9.62086828897816
     1         6d-2*t1*t167*t3*t300*t318+2.1379707308840368d-2*t1*t213*t
     2         23*t300
            t547 = -1.282782438530422d-1*t1*t213*t3*t526+1.9241736577956
     1         33d-1*t1*t167*t3*t300*t318+4.2759414617680735d-2*t1*t213*
     2         t23*t300
            t548 = -5.0d-1*t1*t213*t3*t526+7.5d-1*t1*t167*t3*t300*t318+1
     1         .6666666666666666d-1*t1*t213*t23*t300
            t549 = 4.9365923538061685d-2*t1*t3*t30*t548-1.44313024334672
     1         47d-1*t1*t213*t3*t526+2.164695365020087d-1*t1*t167*t3*t30
     2         0*t318-2.4682961769030842d-2*t1*t213*t219*t3*t300+4.81043
     3         4144489082d-2*t1*t213*t23*t300
            t550 = t27*t547+t31*t526-1.282782438530422d-1*t1*t167*t213*t
     1         3*t300+t214*t300
            t551 = -8.888888888888888d-1*t545*t73*t75+2.6666666666666666
     1         d+0*t222*t550*t72*t75-1.0666666666666666d+1*t221*t321*t38
     2         9*t72*t75+2.6666666666666666d+0*t221*t222*t327*t75+2.6666
     3         666666666666d+0*t209*t222*t321*t75-8.888888888888888d-1*t
     4         549*t72*t73-1.0546577777777776d-1*t35*t36*t550*t73-8.8888
     5         88888888888d-1*t209*t522*t73-1.0546577777777776d-1*t169*t
     6         321*t36*t73-1.0546577777777776d-1*t221*t302*t36*t73-1.054
     7         6577777777776d-1*t216*t321*t35*t73+6.764482379964267d-3*t
     8         1*t213*t221*t3*t300*t35*t73-8.888888888888888d-1*t220*t32
     9         7*t73+2.6666666666666666d+0*t221*t222*t522*t72+2.66666666
     :         66666666d+0*t220*t222*t321*t72+7.57211d-1*(1.645530784602
     ;         0562d-2*gammaaa*t16*t25*t525*t61*t65-1.6455307846020562d-
     <         2*gammaaa*t16*t163*t17*t524*t61*t65+3.2910615692041123d-2
     =         *gammaaa*t16*t162*t17*t298*t366*t61*t65-4.38808209227215d
     >         -2*gammaaa*t152*t25*t299*t61*t65-1.6455307846020562d-2*ga
     ?         mmaaa*t16*t162*t163*t299*t61*t65+4.38808209227215d-2*gamm
     @         aaa*t152*t163*t17*t298*t61*t65-1.6455307846020562d-2*gamm
     1         aaa*t16*t163*t165*t298*t61*t65-4.38808209227215d-2*t152*t
     2         17*t25*t61*t65+1.6455307846020562d-2*t16*t165*t25*t61*t65
     3         -1.6455307846020562d-2*t16*t162*t163*t17*t61*t65-1.645530
     4         7846020562d-2*gammaaa*t16*t17*t200*t25*t540*t65+3.2910615
     5         692041123d-2*gammaaa*t16*t17*t199*t25*t316*t421*t65+4.388
     6         08209227215d-2*gammaaa*t152*t17*t200*t25*t316*t65-1.64553
     7         07846020562d-2*gammaaa*t16*t165*t200*t25*t316*t65+1.64553
     8         07846020562d-2*gammaaa*t16*t162*t163*t17*t200*t316*t65-1.
     9         6455307846020562d-2*gammaaa*t16*t199*t200*t25*t299*t65+1.
     :         6455307846020562d-2*gammaaa*t16*t163*t17*t199*t200*t298*t
     ;         65-1.6455307846020562d-2*t16*t17*t199*t200*t25*t65+t526*t
     <         61*t63-t200*t540*t59*t63+2*t199*t316*t421*t59*t63-t188*t2
     =         00*t316*t63-t199*t200*t300*t63-t198*t539*t59*t61+t190*t19
     >         7*t300*t418*t59*t61-1.6455307846020562d-2*gammaaa*t16*t17
     ?         *t202*t25*t541*t61+1.6455307846020562d-2*gammaaa*t16*t17*
     @         t181*t201*t25*t300*t424*t61+2.194041046136075d-2*gammaaa*
     1         t152*t17*t181*t202*t25*t300*t61-8.227653923010281d-3*gamm
     2         aaa*t16*t165*t181*t202*t25*t300*t61+8.227653923010281d-3*
     3         gammaaa*t16*t162*t163*t17*t181*t202*t300*t61-t197*t198*t3
     4         00*t61-5.0d-1*t188*t190*t198*t300*t61-1.6455307846020562d
     5         -2*gammaaa*t16*t201*t202*t25*t299*t61+1.6455307846020562d
     6         -2*gammaaa*t16*t163*t17*t201*t202*t298*t61-1.645530784602
     7         0562d-2*t16*t17*t201*t202*t25*t61+t197*t198*t200*t316*t59
     8         +5.0d-1*t190*t198*t199*t200*t300*t59+1.6455307846020562d-
     9         2*gammaaa*t16*t17*t200*t201*t202*t25*t316+8.2276539230102
     :         81d-3*gammaaa*t16*t17*t181*t199*t200*t202*t25*t300)-2.0d+
     ;         0*t195*t538*t59+2.0d+0*t194*t314*t409*t59-2.0d+0*t526*t58
     <         -4.727288888888889d-2*t211*t28*t547+5.273288888888887d-2*
     =         t35*t38*t546-6.064083168526658d-3*t1*t167*t211*t3*t300*t5
     >         42+3.2910615692041123d-2*gammaaa*t16*t17*t186*t25*t534+5.
     ?         273288888888887d-2*t36*t38*t527-4.727288888888889d-2*t151
     @         *t32*t526+3.2910615692041123d-2*gammaaa*t16*t25*t52*t525-
     1         3.2910615692041123d-2*gammaaa*t16*t163*t17*t52*t524+6.582
     2         123138408225d-2*gammaaa*t16*t162*t17*t298*t366*t52-8.7761
     3         641845443d-2*gammaaa*t152*t25*t299*t52-3.2910615692041123
     4         d-2*gammaaa*t16*t162*t163*t299*t52+8.7761641845443d-2*gam
     5         maaa*t152*t163*t17*t298*t52-3.2910615692041123d-2*gammaaa
     6         *t16*t163*t165*t298*t52-8.7761641845443d-2*t152*t17*t25*t
     7         52+3.2910615692041123d-2*t16*t165*t25*t52-3.2910615692041
     8         123d-2*t16*t162*t163*t17*t52-3.2910615692041123d-2*gammaa
     9         a*t16*t17*t185*t25*t308*t391-1.2128166337053317d-2*t1*t21
     :         4*t3*t300*t318*t386+9.454577777777778d-2*t167*t300*t32*t3
     ;         82+5.273288888888887d-2*t216*t302*t38-3.3822411899821336d
     <         -3*t1*t169*t213*t3*t300*t38+3.1639733333333325d-1*t221*t2
     =         22*t321*t35*t36-2.0d+0*t188*t195*t314-8.7761641845443d-2*
     >         gammaaa*t152*t17*t186*t25*t308+3.2910615692041123d-2*gamm
     ?         aaa*t16*t165*t186*t25*t308-3.2910615692041123d-2*gammaaa*
     @         t16*t162*t163*t17*t186*t308+4.727288888888889d-2*t151*t21
     1         1*t214*t300-2.0d+0*t194*t195*t300+3.2910615692041123d-2*g
     2         ammaaa*t16*t185*t186*t25*t299-3.2910615692041123d-2*gamma
     3         aa*t16*t163*t17*t185*t186*t298+3.2910615692041123d-2*t16*
     4         t17*t185*t186*t25
            t552 = 3.2910615692041123d-2*gammabb*t100*t126*t331*t91
            t553 = 3.2910615692041123d-2*t100*t126*t91*t92
            t554 = -8.888888888888888d-1*t147*t149*t359
            t555 = t355-2.4682961769030842d-2*t1*t148*t286*t332*t78
            t556 = -1.0546577777777776d-1*t110*t111*t147*t353
            t557 = -9.926516312794808d-4*t231*t89+6.527239842306487d-5*t
     1         230*t87-5.742468916099301d-6*t229*t85+2.4105264144112412d
     2         -7*t228*t83-1.7006233775311694d-8*t227*t81-1.405679441261
     3         9736d-1*t233*t80-4.5608816488973747d-1*t234*t329+1.475953
     4         5677446958d-2*gammabb*t232+5.475448834737188d-1*t225
            t558 = -8.836827178054d-5*t231*t89+1.0386425752741123d-5*t23
     1         0*t87-7.880451214247165d-7*t229*t85-1.0803307880124491d-3
     2         *t233*t80+4.631892373620269d-4*gammabb*t232-7.01834237920
     3         1d-4*t225
            t559 = -1.6455307846020562d-2*gammabb*t236*t557*t91*t92+3.29
     1         10615692041123d-2*gammabb*t235*t330*t445*t91*t92-1.645530
     2         7846020562d-2*t235*t236*t91*t92+4.38808209227215d-2*gamma
     3         bb*t225*t236*t330*t92-4.38808209227215d-2*t100*t225*t92+1
     4         .6455307846020562d-2*gammabb*t100*t558*t91-1.645530784602
     5         0562d-2*gammabb*t235*t236*t331*t91-1.6455307846020562d-2*
     6         gammabb*t236*t238*t330*t91+1.6455307846020562d-2*t100*t23
     7         8*t91-4.38808209227215d-2*gammabb*t100*t225*t331
            t560 = -6.934448603031025d-2*gammabb*t236*t557*t91*t92+1.386
     1         889720606205d-1*gammabb*t235*t330*t445*t91*t92-6.93444860
     2         3031025d-2*t235*t236*t91*t92+1.8491862941416065d-1*gammab
     3         b*t225*t236*t330*t92-1.8491862941416065d-1*t100*t225*t92+
     4         6.934448603031025d-2*gammabb*t100*t558*t91-6.934448603031
     5         025d-2*gammabb*t235*t236*t331*t91-6.934448603031025d-2*ga
     6         mmabb*t236*t238*t330*t91+6.934448603031025d-2*t100*t238*t
     7         91-4.6362722797232353d-7*t230*t463*t87-1.8491862941416065
     8         d-1*gammabb*t100*t225*t331+1.690496096374559d-4*gammabb*t
     9         232*t241-1.369767625290079d-2*t109*t225
            t561 = -2.5d-1*t248*t332*t474
            t562 = 5.0d-1*t249*t559
            t563 = t562+t561
            t564 = -2.5d-1*t248*t332*t481
            t565 = 5.0d-1*t254*t559
            t566 = t565+t564+t562+t561
            t567 = 6.0965d-1*t124*t257*t566+6.0965d-1*t121*t253*t563-1.2
     1         193000000000001d+0*t124*t256*t339*t480-6.0965d-1*t121*t24
     2         9*t252*t332*t472-6.0965d-1*t252*t253*t257*t339-3.04825d-1
     3         *t249*t253*t256*t257*t332
            t568 = -2.5d-1*t248*t332*t491
            t569 = 5.0d-1*t263*t559
            t570 = t569+t568+t562+t561
            t571 = -1.475609999999999d-1*t124*t266*t570-1.47560999999999
     1         9d-1*t130*t253*t563+2.951219999999998d-1*t124*t265*t345*t
     2         490+1.475609999999999d-1*t130*t249*t252*t332*t472+1.47560
     3         9999999999d-1*t252*t253*t266*t345+7.378049999999994d-2*t2
     4         49*t253*t265*t266*t332
            t572 = t569+t568
            t573 = t569+t568+t565+t564
            t574 = t565+t564
            t575 = 1/t104**7
            t576 = -gammabb*t236*t557*t91*t92+2*gammabb*t235*t330*t445*t
     1         91*t92-t235*t236*t91*t92+2.6666666666666666d+0*gammabb*t2
     2         25*t236*t330*t92-2.6666666666666666d+0*t100*t225*t92+gamm
     3         abb*t100*t558*t91-gammabb*t235*t236*t331*t91-gammabb*t236
     4         *t238*t330*t91+t100*t238*t91-2.6666666666666666d+0*gammab
     5         b*t100*t225*t331
            t577 = 6.41391219265211d-2*t279*t576-5.0d-1*t278*t559+2.5d-1
     1         *t261*t332*t509-3.206956096326055d-2*t280*t357*t507
            t578 = -2.4d+0*t142*t577+4.7459599999999996d-2*t140*t560-8.4
     1         00000000000001d+0*t145*t277*t559-4.9628707825354457d+0*t2
     2         77*t559-2.7259596d+0*t141*t559+5.672746666666666d-2*t140*
     3         t559+4.7459599999999996d-2*t110*t559-2.1d+1*t145*t261*t33
     4         2*t506-1.2407176956338616d+1*t261*t332*t506-8.40000000000
     5         0001d+0*t261*t277*t358+4.7459599999999996d-2*t261*t334-8.
     6         400000000000001d+0*t277*t281*t332-5.4519192d+0*t140*t261*
     7         t332+5.672746666666666d-2*t261*t332+4.7459599999999996d-2
     8         *t242*t332
            t579 = 2.1379707308840368d-2*t1*t286*t332*t98-6.413912192652
     1         11d-2*t1*t286*t559*t78+9.620868288978166d-2*t1*t240*t332*
     2         t350*t78
            t580 = 4.2759414617680735d-2*t1*t286*t332*t98-1.282782438530
     1         422d-1*t1*t286*t559*t78+1.924173657795633d-1*t1*t240*t332
     2         *t350*t78
            t581 = 1.6666666666666666d-1*t1*t286*t332*t98-5.0d-1*t1*t286
     1         *t559*t78+7.5d-1*t1*t240*t332*t350*t78
            t582 = 4.810434144489082d-2*t1*t286*t332*t98+4.9365923538061
     1         685d-2*t1*t105*t581*t78-1.4431302433467247d-1*t1*t286*t55
     2         9*t78+2.164695365020087d-1*t1*t240*t332*t350*t78-2.468296
     3         1769030842d-2*t1*t286*t292*t332*t78
            t583 = -1.282782438530422d-1*t1*t240*t286*t332*t78+t102*t580
     1         +t106*t559+t287*t332
            t584 = 7.57211d-1*(-1.6455307846020562d-2*gammabb*t100*t135*
     1         t275*t574*t91*t92-1.6455307846020562d-2*gammabb*t100*t139
     2         *t273*t573*t91*t92-1.6455307846020562d-2*gammabb*t135*t13
     3         9*t236*t557*t91*t92+1.6455307846020562d-2*gammabb*t100*t1
     4         35*t254*t274*t332*t503*t91*t92+3.2910615692041123d-2*gamm
     5         abb*t100*t139*t272*t348*t500*t91*t92+3.2910615692041123d-
     6         2*gammabb*t135*t139*t235*t330*t445*t91*t92+1.645530784602
     7         0562d-2*gammabb*t100*t273*t274*t275*t348*t91*t92+1.645530
     8         7846020562d-2*gammabb*t139*t235*t236*t273*t348*t91*t92+8.
     9         227653923010281d-3*gammabb*t100*t254*t272*t273*t275*t332*
     :         t91*t92+8.227653923010281d-3*gammabb*t135*t235*t236*t254*
     ;         t275*t332*t91*t92+1.6455307846020562d-2*gammabb*t135*t236
     <         *t274*t275*t330*t91*t92+1.6455307846020562d-2*gammabb*t13
     =         9*t236*t272*t273*t330*t91*t92-1.6455307846020562d-2*t100*
     >         t135*t274*t275*t91*t92-1.6455307846020562d-2*t100*t139*t2
     ?         72*t273*t91*t92-1.6455307846020562d-2*t135*t139*t235*t236
     @         *t91*t92+4.38808209227215d-2*gammabb*t100*t139*t225*t273*
     1         t348*t92+2.194041046136075d-2*gammabb*t100*t135*t225*t254
     2         *t275*t332*t92+4.38808209227215d-2*gammabb*t135*t139*t225
     3         *t236*t330*t92-4.38808209227215d-2*t100*t135*t139*t225*t9
     4         2+1.6455307846020562d-2*gammabb*t100*t135*t139*t558*t91-1
     5         .6455307846020562d-2*gammabb*t100*t139*t238*t273*t348*t91
     6         -8.227653923010281d-3*gammabb*t100*t135*t238*t254*t275*t3
     7         32*t91-1.6455307846020562d-2*gammabb*t100*t135*t274*t275*
     8         t331*t91-1.6455307846020562d-2*gammabb*t100*t139*t272*t27
     9         3*t331*t91-1.6455307846020562d-2*gammabb*t135*t139*t235*t
     :         236*t331*t91-1.6455307846020562d-2*gammabb*t135*t139*t236
     ;         *t238*t330*t91+1.6455307846020562d-2*t100*t135*t139*t238*
     <         t91-t133*t137*t273*t573-t133*t135*t271*t572+t135*t137*t55
     =         9+2*t133*t137*t272*t348*t500+t133*t135*t263*t270*t332*t49
     >         7+t133*t270*t271*t273*t348-t137*t261*t273*t348+5.0d-1*t13
     ?         3*t263*t271*t272*t273*t332-t137*t272*t273*t332-t135*t270*
     @         t271*t332-5.0d-1*t135*t261*t263*t271*t332-4.3880820922721
     1         5d-2*gammabb*t100*t135*t139*t225*t331)+3.2910615692041123
     2         d-2*gammabb*t100*t259*t567*t91*t92-3.2910615692041123d-2*
     3         gammabb*t126*t236*t557*t91*t92-3.2910615692041123d-2*gamm
     4         abb*t100*t258*t340*t470*t91*t92+6.582123138408225d-2*gamm
     5         abb*t126*t235*t330*t445*t91*t92-3.2910615692041123d-2*gam
     6         mabb*t235*t236*t259*t340*t91*t92-3.2910615692041123d-2*ga
     7         mmabb*t236*t258*t259*t330*t91*t92+3.2910615692041123d-2*t
     8         100*t258*t259*t91*t92-3.2910615692041123d-2*t126*t235*t23
     9         6*t91*t92-8.7761641845443d-2*gammabb*t100*t225*t259*t340*
     :         t92+8.7761641845443d-2*gammabb*t126*t225*t236*t330*t92-8.
     ;         7761641845443d-2*t100*t126*t225*t92+3.2910615692041123d-2
     <         *gammabb*t100*t126*t558*t91+3.2910615692041123d-2*gammabb
     =         *t100*t238*t259*t340*t91+3.2910615692041123d-2*gammabb*t1
     >         00*t258*t259*t331*t91-3.2910615692041123d-2*gammabb*t126*
     ?         t235*t236*t331*t91-3.2910615692041123d-2*gammabb*t126*t23
     @         6*t238*t330*t91+3.2910615692041123d-2*t100*t126*t238*t91-
     1         6.064083168526658d-3*t1*t240*t284*t332*t575*t78-1.2128166
     2         337053317d-2*t1*t287*t332*t350*t465*t78+6.764482379964267
     3         d-3*t1*t110*t147*t286*t294*t332*t78-3.3822411899821336d-3
     4         *t1*t113*t242*t286*t332*t78+2.6666666666666666d+0*t146*t1
     5         49*t295*t583-1.0546577777777776d-1*t110*t111*t147*t583-8.
     6         888888888888888d-1*t146*t147*t582-4.727288888888889d-2*t1
     7         03*t284*t580+5.273288888888887d-2*t110*t113*t579-8.888888
     8         888888888d-1*t147*t149*t578-2.0d+0*t133*t268*t571+5.27328
     9         8888888887d-2*t111*t113*t560-4.727288888888889d-2*t107*t2
     :         24*t559-2.0d+0*t132*t559+2.6666666666666666d+0*t146*t294*
     ;         t295*t555-8.888888888888888d-1*t147*t282*t555+2.0d+0*t133
     <         *t267*t346*t488-1.0666666666666666d+1*t146*t149*t294*t353
     =         *t468+9.454577777777778d-2*t107*t240*t332*t461+2.66666666
     >         66666666d+0*t149*t294*t295*t359-8.888888888888888d-1*t147
     ?         *t293*t359+3.1639733333333325d-1*t110*t111*t294*t295*t353
     @         +2.6666666666666666d+0*t146*t293*t295*t353+2.666666666666
     1         6666d+0*t149*t282*t295*t353-1.0546577777777776d-1*t110*t1
     2         47*t289*t353-1.0546577777777776d-1*t111*t147*t242*t353-2.
     3         0d+0*t261*t268*t346-1.0546577777777776d-1*t111*t147*t294*
     4         t334+5.273288888888887d-2*t113*t289*t334+4.72728888888888
     5         9d-2*t224*t284*t287*t332-2.0d+0*t267*t268*t332-8.77616418
     6         45443d-2*gammabb*t100*t126*t225*t331
            t585 = t300**2
            t586 = 9.454577777777778d-2*t32*t382*t585
            t587 = t298**2
            t588 = 1/t14
            t589 = -1.6318099605766218d-5*gammaaa*t9+1.5381613168123123d
     1         -6*t14*t7-1.7103306183365155d-1*t23*t588+2.23346617037883
     2         17d-4*t11*t5+1.757099301577467d-2*t15*t297-6.779605540531
     3         617d-8*t12*t21+4.960151517799245d-9*t10*t19-2.76741293952
     4         1305d-3*t13
            t590 = -2.5966064381852805d-6*gammaaa*t9+2.1108351466733477d
     1         -7*t14*t7+1.9882861150621498d-5*t11*t5+1.3504134850155614
     2         d-4*t15*t297-8.684798200538004d-5*t13
            t591 = 1.6455307846020562d-2*gammaaa*t16*t25*t590-1.64553078
     1         46020562d-2*gammaaa*t16*t163*t17*t589+3.2910615692041123d
     2         -2*gammaaa*t16*t17*t366*t587-3.2910615692041123d-2*gammaa
     3         a*t16*t163*t298*t299+3.2910615692041123d-2*t16*t25*t299-3
     4         .2910615692041123d-2*t16*t163*t17*t298
            t592 = -4.727288888888889d-2*t151*t32*t591
            t593 = 1.7386021048962136d-7*gammaaa*t384*t9+6.9344486030310
     1         25d-2*gammaaa*t16*t25*t590-6.934448603031025d-2*gammaaa*t
     2         16*t163*t17*t589+1.386889720606205d-1*gammaaa*t16*t17*t36
     3         6*t587-1.386889720606205d-1*gammaaa*t16*t163*t298*t299+1.
     4         386889720606205d-1*t16*t25*t299-1.386889720606205d-1*t16*
     5         t163*t17*t298-4.226240240936398d-5*t13*t168
            t594 = 5.273288888888887d-2*t36*t38*t593
            t595 = t321**2
            t596 = -1.0666666666666666d+1*t389*t595*t72*t75
            t597 = 6.582123138408225d-2*gammaaa*t16*t17*t366*t52*t587
            t598 = -6.582123138408225d-2*gammaaa*t16*t163*t17*t186*t298*
     1         t308
            t599 = t308**2
            t600 = -3.2910615692041123d-2*gammaaa*t16*t17*t25*t391*t599
            t601 = 3.2910615692041123d-2*gammaaa*t52*t590+6.582123138408
     1         225d-2*t299*t52+3.2910615692041123d-2*gammaaa*t186*t299*t
     2         308+3.2910615692041123d-2*t17*t186*t308
            t602 = 1/t44
            t603 = t307**2
            t604 = -2.5d-1*t402*t585
            t605 = 5.0d-1*t181*t591
            t606 = -2.5d-1*t395*t585
            t607 = 5.0d-1*t176*t591
            t608 = t607+t606+t605+t604
            t609 = 6.0965d-1*t184*t50*t608-1.2193000000000001d+0*t401*t5
     1         0*t603-3.04825d-1*t393*t47*t585*t602+3.04825d-1*t176*t180
     2         *t47*t591-1.524125d-1*t180*t395*t47*t585-6.0965d-1*t176*t
     3         180*t184*t300*t307
            t610 = 3.2910615692041123d-2*gammaaa*t17*t609+3.291061569204
     1         1123d-2*gammaaa*t299*t308+3.2910615692041123d-2*t17*t308
            t611 = -3.2910615692041123d-2*gammaaa*t17*t52*t589-3.2910615
     1         692041123d-2*gammaaa*t298*t299*t52-3.2910615692041123d-2*
     2         t17*t298*t52-t298*t310
            t612 = -2.0d+0*t58*t591
            t613 = t314**2
            t614 = 2.0d+0*t409*t59*t613
            t615 = 1/t53
            t616 = t316**2
            t617 = -2.5d-1*t412*t585
            t618 = 5.0d-1*t190*t591
            t619 = t618+t617+t605+t604
            t620 = 1/t42
            t621 = 7.57211d-1*(-1.6455307846020562d-2*gammaaa*t16*t17*t2
     1         00*t25*t619*t65+3.2910615692041123d-2*gammaaa*t16*t17*t25
     2         *t421*t616*t65+1.6455307846020562d-2*gammaaa*t16*t25*t590
     3         *t61*t65-1.6455307846020562d-2*gammaaa*t16*t163*t17*t589*
     4         t61*t65+3.2910615692041123d-2*gammaaa*t16*t17*t366*t587*t
     5         61*t65-3.2910615692041123d-2*gammaaa*t16*t163*t298*t299*t
     6         61*t65+3.2910615692041123d-2*t16*t25*t299*t61*t65-3.29106
     7         15692041123d-2*t16*t163*t17*t298*t61*t65-3.29106156920411
     8         23d-2*gammaaa*t16*t200*t25*t299*t316*t65+3.29106156920411
     9         23d-2*gammaaa*t16*t163*t17*t200*t298*t316*t65-3.291061569
     :         2041123d-2*t16*t17*t200*t25*t316*t65-t200*t59*t619*t63+2*
     ;         t421*t59*t616*t63+t591*t61*t63-2*t200*t300*t316*t63+8.227
     <         653923010281d-3*gammaaa*t16*t17*t25*t424*t585*t61*t620+5.
     =         0d-1*t418*t585*t59*t61*t615-5.0d-1*t190*t198*t59*t591*t61
     >         -8.227653923010281d-3*gammaaa*t16*t17*t181*t202*t25*t591*
     ?         t61+2.5d-1*t198*t412*t585*t59*t61+4.1138269615051404d-3*g
     @         ammaaa*t16*t17*t202*t25*t402*t585*t61-t190*t198*t585*t61-
     1         1.6455307846020562d-2*gammaaa*t16*t181*t202*t25*t299*t300
     2         *t61+1.6455307846020562d-2*gammaaa*t16*t163*t17*t181*t202
     3         *t298*t300*t61-1.6455307846020562d-2*t16*t17*t181*t202*t2
     4         5*t300*t61+t190*t198*t200*t300*t316*t59+1.645530784602056
     5         2d-2*gammaaa*t16*t17*t181*t200*t202*t25*t300*t316)
            t622 = t313**2
            t623 = t618+t617+t607+t606
            t624 = -1.475609999999999d-1*t193*t50*t623+2.951219999999998
     1         d-1*t411*t50*t622+7.378049999999994d-2*t393*t56*t585*t602
     2         -7.378049999999994d-2*t176*t180*t56*t591+3.68902499999999
     3         7d-2*t180*t395*t56*t585+1.475609999999999d-1*t176*t180*t1
     4         93*t300*t313
            t625 = -2.0d+0*t59*t624-4.0d+0*t300*t314
            t626 = 1/t27**4
            t627 = 1.5557798788747831d-3*t386*t39*t40*t585*t626
            t628 = -2.1224291089843306d-2*t1*t211*t3*t542*t585
            t629 = 6.064083168526658d-3*t1*t211*t3*t318*t591
            t630 = 5.0733617849732d-3*t1*t3*t318*t35*t38*t585
            t631 = -3.3822411899821336d-3*t1*t35*t591-6.764482379964267d
     1         -3*t1*t300*t302
            t632 = 6.764482379964267d-3*t1*t213*t3*t300*t321*t35
            t633 = -2.4682961769030842d-2*t151*t39*t40*t591-1.4431302433
     1         467247d-1*t1*t213*t3*t591+4.9365923538061685d-2*t382*t39*
     2         t40*t585+2.164695365020087d-1*t1*t3*t318*t585
            t634 = -8.888888888888888d-1*t633*t72
            t635 = -1.7777777777777776d+0*t324*t327
            t636 = t325**2
            t637 = gammaaa*t16*t25*t590-gammaaa*t16*t163*t17*t589+2*gamm
     1         aaa*t16*t17*t366*t587-2*gammaaa*t16*t163*t298*t299+2*t16*
     2         t25*t299-2*t16*t163*t17*t298
            t638 = 6.41391219265211d-2*t206*t637-3.206956096326055d-2*t4
     1         28*t636-5.0d-1*t205*t591+2.5d-1*t430*t585
            t639 = -8.400000000000001d+0*t204*t591*t71-2.1d+1*t427*t585*
     1         t71-2.4d+0*t638*t68-2.7259596d+0*t591*t67+4.7459599999999
     2         996d-2*t593*t66+5.672746666666666d-2*t591*t66-5.4519192d+
     3         0*t585*t66+4.7459599999999996d-2*t35*t591-4.9628707825354
     4         457d+0*t204*t591-1.2407176956338616d+1*t427*t585+5.672746
     5         666666666d-2*t585-1.68d+1*t204*t300*t326+9.49191999999999
     6         9d-2*t300*t302
            t640 = -8.888888888888888d-1*t639*t75
            t641 = t31*t591-1.282782438530422d-1*t1*t3*t30*t591-6.413912
     1         19265211d-2*t1*t213*t3*t585
            t642 = -1.0546577777777776d-1*t35*t36*t641
            t643 = t642+t640+t635+t634+t632-2.109315555555555d-1*t302*t3
     1         21*t36
            t644 = 2.6666666666666666d+0*t641*t72*t75+2.6666666666666666
     1         d+0*t321*t327*t75+2.6666666666666666d+0*t321*t324*t72-3.0
     2         d+0*t321*t328
            t645 = t332**2
            t646 = 9.454577777777778d-2*t107*t461*t645
            t647 = t330**2
            t648 = 1/t89
            t649 = -1.7103306183365155d-1*t648*t98-6.779605540531617d-8*
     1         t87*t96+4.960151517799245d-9*t85*t94+1.757099301577467d-2
     2         *t329*t90+1.5381613168123123d-6*t82*t89-2.767412939521305
     3         d-3*t88+2.2334661703788317d-4*t80*t86-1.6318099605766218d
     4         -5*gammabb*t84
            t650 = 1.3504134850155614d-4*t329*t90+2.1108351466733477d-7*
     1         t82*t89-8.684798200538004d-5*t88+1.9882861150621498d-5*t8
     2         0*t86-2.5966064381852805d-6*gammabb*t84
            t651 = -1.6455307846020562d-2*gammabb*t236*t649*t91*t92+3.29
     1         10615692041123d-2*gammabb*t445*t647*t91*t92-3.29106156920
     2         41123d-2*t236*t330*t91*t92+1.6455307846020562d-2*gammabb*
     3         t100*t650*t91-3.2910615692041123d-2*gammabb*t236*t330*t33
     4         1*t91+3.2910615692041123d-2*t100*t331*t91
            t652 = -4.727288888888889d-2*t107*t224*t651
            t653 = -6.934448603031025d-2*gammabb*t236*t649*t91*t92+1.386
     1         889720606205d-1*gammabb*t445*t647*t91*t92-1.3868897206062
     2         05d-1*t236*t330*t91*t92+6.934448603031025d-2*gammabb*t100
     3         *t650*t91-1.386889720606205d-1*gammabb*t236*t330*t331*t91
     4         +1.386889720606205d-1*t100*t331*t91-4.226240240936398d-5*
     5         t241*t88+1.7386021048962136d-7*gammabb*t463*t84
            t654 = 5.273288888888887d-2*t111*t113*t653
            t655 = t353**2
            t656 = -1.0666666666666666d+1*t146*t149*t468*t655
            t657 = 6.582123138408225d-2*gammabb*t126*t445*t647*t91*t92
            t658 = -6.582123138408225d-2*gammabb*t236*t259*t330*t340*t91
     1         *t92
            t659 = t340**2
            t660 = -3.2910615692041123d-2*gammabb*t100*t470*t659*t91*t92
            t661 = 3.2910615692041123d-2*t259*t340*t92+3.291061569204112
     1         3d-2*gammabb*t126*t650+3.2910615692041123d-2*gammabb*t259
     2         *t331*t340+6.582123138408225d-2*t126*t331
            t662 = 1/t118
            t663 = t339**2
            t664 = -2.5d-1*t481*t645
            t665 = 5.0d-1*t254*t651
            t666 = -2.5d-1*t474*t645
            t667 = 5.0d-1*t249*t651
            t668 = t667+t666+t665+t664
            t669 = 6.0965d-1*t124*t257*t668-1.2193000000000001d+0*t124*t
     1         480*t663-3.04825d-1*t121*t472*t645*t662+3.04825d-1*t121*t
     2         249*t253*t651-1.524125d-1*t121*t253*t474*t645-6.0965d-1*t
     3         249*t253*t257*t332*t339
            t670 = 3.2910615692041123d-2*gammabb*t669*t92+3.291061569204
     1         1123d-2*t340*t92+3.2910615692041123d-2*gammabb*t331*t340
            t671 = -3.2910615692041123d-2*gammabb*t126*t649*t92-3.291061
     1         5692041123d-2*t126*t330*t92-t330*t342-3.2910615692041123d
     2         -2*gammabb*t126*t330*t331
            t672 = -2.0d+0*t132*t651
            t673 = t346**2
            t674 = 2.0d+0*t133*t488*t673
            t675 = 1/t127
            t676 = t348**2
            t677 = -2.5d-1*t491*t645
            t678 = 5.0d-1*t263*t651
            t679 = t678+t677+t665+t664
            t680 = 1/t116
            t681 = 7.57211d-1*(8.227653923010281d-3*gammabb*t100*t135*t5
     1         03*t645*t680*t91*t92-1.6455307846020562d-2*gammabb*t100*t
     2         139*t273*t679*t91*t92+3.2910615692041123d-2*gammabb*t100*
     3         t139*t500*t676*t91*t92-8.227653923010281d-3*gammabb*t100*
     4         t135*t254*t275*t651*t91*t92-1.6455307846020562d-2*gammabb
     5         *t135*t139*t236*t649*t91*t92+3.2910615692041123d-2*gammab
     6         b*t135*t139*t445*t647*t91*t92+4.1138269615051404d-3*gamma
     7         bb*t100*t135*t275*t481*t645*t91*t92+1.6455307846020562d-2
     8         *gammabb*t100*t254*t273*t275*t332*t348*t91*t92+3.29106156
     9         92041123d-2*gammabb*t139*t236*t273*t330*t348*t91*t92-3.29
     :         10615692041123d-2*t100*t139*t273*t348*t91*t92+1.645530784
     ;         6020562d-2*gammabb*t135*t236*t254*t275*t330*t332*t91*t92-
     <         1.6455307846020562d-2*t100*t135*t254*t275*t332*t91*t92-3.
     =         2910615692041123d-2*t135*t139*t236*t330*t91*t92+1.6455307
     >         846020562d-2*gammabb*t100*t135*t139*t650*t91-3.2910615692
     ?         041123d-2*gammabb*t100*t139*t273*t331*t348*t91-1.64553078
     @         46020562d-2*gammabb*t100*t135*t254*t275*t331*t332*t91-3.2
     1         910615692041123d-2*gammabb*t135*t139*t236*t330*t331*t91+3
     2         .2910615692041123d-2*t100*t135*t139*t331*t91-t133*t137*t2
     3         73*t679+2*t133*t137*t500*t676+5.0d-1*t133*t135*t497*t645*
     4         t675-5.0d-1*t133*t135*t263*t271*t651+t135*t137*t651+2.5d-
     5         1*t133*t135*t271*t491*t645-t135*t263*t271*t645+t133*t263*
     6         t271*t273*t332*t348-2*t137*t273*t332*t348)
            t682 = t345**2
            t683 = t678+t677+t667+t666
            t684 = -1.475609999999999d-1*t124*t266*t683+2.95121999999999
     1         8d-1*t124*t490*t682+7.378049999999994d-2*t130*t472*t645*t
     2         662-7.378049999999994d-2*t130*t249*t253*t651+3.6890249999
     3         99997d-2*t130*t253*t474*t645+1.475609999999999d-1*t249*t2
     4         53*t266*t332*t345
            t685 = -2.0d+0*t133*t684-4.0d+0*t332*t346
            t686 = 1/t102**4
            t687 = 1.5557798788747831d-3*t114*t39*t465*t645*t686
            t688 = -2.1224291089843306d-2*t1*t284*t575*t645*t78
            t689 = 6.064083168526658d-3*t1*t284*t350*t651*t78
            t690 = 5.0733617849732d-3*t1*t110*t113*t350*t645*t78
            t691 = -3.3822411899821336d-3*t1*t110*t651-6.764482379964267
     1         d-3*t1*t332*t334
            t692 = 6.764482379964267d-3*t1*t110*t286*t332*t353*t78
            t693 = -1.4431302433467247d-1*t1*t286*t651*t78+2.16469536502
     1         0087d-1*t1*t350*t645*t78-2.4682961769030842d-2*t114*t224*
     2         t39*t651+4.9365923538061685d-2*t114*t39*t461*t645
            t694 = -8.888888888888888d-1*t146*t693
            t695 = -1.7777777777777776d+0*t356*t359
            t696 = t357**2
            t697 = -gammabb*t236*t649*t91*t92+2*gammabb*t445*t647*t91*t9
     1         2-2*t236*t330*t91*t92+gammabb*t100*t650*t91-2*gammabb*t23
     2         6*t330*t331*t91+2*t100*t331*t91
            t698 = 6.41391219265211d-2*t279*t697-3.206956096326055d-2*t5
     1         07*t696-5.0d-1*t278*t651+2.5d-1*t509*t645
            t699 = -2.4d+0*t142*t698+4.7459599999999996d-2*t140*t653-8.4
     1         00000000000001d+0*t145*t277*t651-4.9628707825354457d+0*t2
     2         77*t651-2.7259596d+0*t141*t651+5.672746666666666d-2*t140*
     3         t651+4.7459599999999996d-2*t110*t651-2.1d+1*t145*t506*t64
     4         5-1.2407176956338616d+1*t506*t645-5.4519192d+0*t140*t645+
     5         5.672746666666666d-2*t645-1.68d+1*t277*t332*t358+9.491919
     6         999999999d-2*t332*t334
            t700 = -8.888888888888888d-1*t149*t699
            t701 = -1.282782438530422d-1*t1*t105*t651*t78-6.413912192652
     1         11d-2*t1*t286*t645*t78+t106*t651
            t702 = -1.0546577777777776d-1*t110*t111*t701
            t703 = t702+t700+t695+t694+t692-2.109315555555555d-1*t111*t3
     1         34*t353
            t704 = 2.6666666666666666d+0*t146*t149*t701-3.0d+0*t353*t360
     1         +2.6666666666666666d+0*t149*t353*t359+2.6666666666666666d
     2         +0*t146*t353*t356
            t705 = t212-1.282782438530422d-1*t1*t175*t213*t3
            t706 = t27*t705+t175*t31
            t707 = 1/rhoa**5.666666666666667d+0
            t708 = -7.508496024554567d-1*gammaaa*t17*t25*t707
            t709 = -4.8268903014993647d-1*gammaaa*t162*t163*t17*t361
            t710 = 4.8268903014993647d-1*gammaaa*t165*t25*t361
            t711 = -2.63284925536329d-1*gammaaa*t152*t17*t365*t366
            t712 = 1.316424627681645d-1*gammaaa*t152*t163*t17*t376
            t713 = 2.63284925536329d-1*gammaaa*t152*t162*t163*t165
            t714 = -1.316424627681645d-1*gammaaa*t152*t25*t379
            t715 = t162**3
            t716 = 1/t24**4
            t717 = -9.873184707612337d-2*gammaaa*t16*t17*t715*t716
            t718 = 9.873184707612337d-2*gammaaa*t16*t165*t365*t366
            t719 = 9.873184707612337d-2*gammaaa*t16*t162*t17*t366*t376
            t720 = -4.9365923538061685d-2*gammaaa*t16*t163*t165*t376
            t721 = 1/rhoa**1.3666666666666666d+1
            t722 = 1/rhoa**1.2333333333333334d+1
            t723 = 1/rhoa**11
            t724 = 1/rhoa**9.666666666666666d+0
            t725 = 1/rhoa**8.333333333333334d+0
            t726 = 1/rhoa**7
            t727 = 1.958171952691946d-3*t723*t8-2.811358882523947d+0*t14
     1         *t726+3.4274921739849046d-1*t12*t725-2.6382474466894645d-
     2         2*t10*t724-1.9214483293868775d-4*t6*t722+8.90555591990819
     3         5d-6*t20*t721+9.369101339439189d+0*gammaaa*t707-7.0947047
     4         87173696d+0*t5/rhoa**4.333333333333333d+0-6.8780767713482
     5         86d-7*t18/rhoa**15
            t728 = -1.6455307846020562d-2*gammaaa*t16*t163*t17*t727
            t729 = -4.9365923538061685d-2*gammaaa*t16*t162*t163*t379
            t730 = 3.115927725822337d-4*t723*t8-2.1606615760248984d-2*t1
     1         4*t726+1.0756283400962623d-2*t12*t725-2.3486322899894632d
     2         -3*t10*t724-2.636823993592544d-5*t6*t722-1.20091636266328
     3         24d-2*gammaaa*t707
            t731 = 1.6455307846020562d-2*gammaaa*t16*t25*t730
            t732 = t731+t729+t728+t720+t719+t718+t717+t714+t713+t712+t71
     1         1+t710+t709+t708-1.950258707676511d-1*t152*t39
            t733 = t167**3
            t734 = 1/t33**4
            t735 = -2.349044621726439d-5*t384*t723*t8+4.0688686731102613
     1         d-8*t20*t721*t734+6.934448603031025d-2*gammaaa*t16*t25*t7
     2         30-6.934448603031025d-2*gammaaa*t16*t163*t17*t727+4.27006
     3         7917509071d-3*t12*t168*t725-4.1606691618186153d-1*gammaaa
     4         *t16*t17*t715*t716-2.3438246032741353d-1*gammaaa*t34*t707
     5         -3.1641632144200826d+0*gammaaa*t17*t25*t707-5.54755888242
     6         4819d-1*gammaaa*t152*t25*t379-2.0803345809093077d-1*gamma
     7         aa*t16*t162*t163*t379+4.1606691618186153d-1*gammaaa*t16*t
     8         162*t17*t366*t376+5.547558882424819d-1*gammaaa*t152*t163*
     9         t17*t376-2.0803345809093077d-1*gammaaa*t16*t163*t165*t376
     :         -1.1095117764849638d+0*gammaaa*t152*t17*t365*t366+4.16066
     ;         91618186153d-1*gammaaa*t16*t165*t365*t366+2.0341049235557
     <         67d+0*gammaaa*t165*t25*t361-2.034104923555767d+0*gammaaa*
     =         t162*t163*t17*t361+1.1095117764849638d+0*gammaaa*t152*t16
     >         2*t163*t165
            t736 = 1/t31**4
            t737 = t221**3
            t738 = 1/t37**6.0d+0
            t739 = 1/t51**3
            t740 = t179**3
            t741 = 1/t49**4
            t742 = t175**3
            t743 = 1/t45**5
            t744 = 3.75d-1*t742*t743
            t745 = -7.5d-1*t175*t381*t395
            t746 = 5.0d-1*t176*t732
            t747 = -2.660585798433468d-1*t1*t375
            t748 = t747+t746+t745+t744
            t749 = 1/t46**4
            t750 = 1/t43**5
            t751 = 3.75d-1*t742*t750
            t752 = -7.5d-1*t175*t381*t402
            t753 = 5.0d-1*t181*t732
            t754 = t731+t729+t728+t720+t719+t718+t717+t714+t713+t712+t71
     1         1+t710+t709+t708
            t755 = 1/t57**3
            t756 = 1/t55**4
            t757 = 1/t54**5
            t758 = 3.75d-1*t742*t757
            t759 = -7.5d-1*t175*t381*t412
            t760 = 5.0d-1*t190*t732
            t761 = 1/t62**4
            t762 = t199**3
            t763 = 1/t60**4
            t764 = t760+t759+t758+t753+t752+t751
            t765 = 1/t64**4
            t766 = t188**3
            t767 = t66**5.0d-1
            t768 = 1/t69**5
            t769 = 1/t70**5
            t770 = -4.810434144489083d-1*t1*t3*t542*t733-1.2827824385304
     1         22d-1*t1*t213*t3*t732-1.924173657795633d-1*t1*t23*t318*t3
     2         83+5.772520973386899d-1*t1*t167*t3*t318*t381+1.2827824385
     3         30422d-1*t1*t213*t23*t381-2.660585798433468d-1*t1*t30*t37
     4         5-1.7103765847072294d-1*t1*t161*t167*t213
            t771 = t27*t770+t31*t732+3*t167*t435+3*t214*t381
            t772 = t285-1.282782438530422d-1*t1*t248*t286*t78
            t773 = t102*t772+t106*t248
            t774 = 1/rhob**5.666666666666667d+0
            t775 = -7.508496024554567d-1*gammabb*t100*t774*t92
            t776 = -4.8268903014993647d-1*gammabb*t235*t236*t440*t92
            t777 = 4.8268903014993647d-1*gammabb*t100*t238*t440
            t778 = -2.63284925536329d-1*gammabb*t225*t444*t445*t92
            t779 = 1.316424627681645d-1*gammabb*t225*t236*t455*t92
            t780 = 2.63284925536329d-1*gammabb*t225*t235*t236*t238
            t781 = -1.316424627681645d-1*gammabb*t100*t225*t458
            t782 = t235**3
            t783 = 1/t99**4
            t784 = -9.873184707612337d-2*gammabb*t782*t783*t91*t92
            t785 = 9.873184707612337d-2*gammabb*t238*t444*t445*t91
            t786 = 9.873184707612337d-2*gammabb*t235*t445*t455*t91*t92
            t787 = -4.9365923538061685d-2*gammabb*t236*t238*t455*t91
            t788 = 1/rhob**1.3666666666666666d+1
            t789 = 1/rhob**1.2333333333333334d+1
            t790 = 1/rhob**11
            t791 = 1/rhob**9.666666666666666d+0
            t792 = 1/rhob**8.333333333333334d+0
            t793 = 1/rhob**7
            t794 = 8.905555919908195d-6*t788*t95-6.878076771348286d-7*t9
     1         3/rhob**15-2.811358882523947d+0*t793*t89+3.42749217398490
     2         46d-1*t792*t87-2.6382474466894645d-2*t791*t85+1.958171952
     3         691946d-3*t790*t83-1.9214483293868775d-4*t789*t81-7.09470
     4         4787173696d+0*t80/rhob**4.333333333333333d+0+9.3691013394
     5         39189d+0*gammabb*t774
            t795 = -1.6455307846020562d-2*gammabb*t236*t794*t91*t92
            t796 = -4.9365923538061685d-2*gammabb*t235*t236*t458*t91
            t797 = -2.1606615760248984d-2*t793*t89+1.0756283400962623d-2
     1         *t792*t87-2.3486322899894632d-3*t791*t85+3.11592772582233
     2         7d-4*t790*t83-2.636823993592544d-5*t789*t81-1.20091636266
     3         32824d-2*gammabb*t774
            t798 = 1.6455307846020562d-2*gammabb*t100*t797*t91
            t799 = t798+t796+t795+t787+t786+t785+t784+t781+t780+t779+t77
     1         8+t777+t776+t775-1.950258707676511d-1*t225*t39
            t800 = t240**3
            t801 = 1/t108**4
            t802 = 4.0688686731102613d-8*t788*t801*t95-6.934448603031025
     1         d-2*gammabb*t236*t794*t91*t92-4.1606691618186153d-1*gamma
     2         bb*t782*t783*t91*t92+4.1606691618186153d-1*gammabb*t235*t
     3         445*t455*t91*t92-3.1641632144200826d+0*gammabb*t100*t774*
     4         t92+5.547558882424819d-1*gammabb*t225*t236*t455*t92-1.109
     5         5117764849638d+0*gammabb*t225*t444*t445*t92-2.03410492355
     6         5767d+0*gammabb*t235*t236*t440*t92+6.934448603031025d-2*g
     7         ammabb*t100*t797*t91-2.0803345809093077d-1*gammabb*t235*t
     8         236*t458*t91-2.0803345809093077d-1*gammabb*t236*t238*t455
     9         *t91+4.1606691618186153d-1*gammabb*t238*t444*t445*t91+4.2
     :         70067917509071d-3*t241*t792*t87-2.349044621726439d-5*t463
     ;         *t790*t83-2.3438246032741353d-1*gammabb*t109*t774-5.54755
     <         8882424819d-1*gammabb*t100*t225*t458+2.034104923555767d+0
     =         *gammabb*t100*t238*t440+1.1095117764849638d+0*gammabb*t22
     >         5*t235*t236*t238
            t803 = 1/t106**4
            t804 = t294**3
            t805 = 1/t112**6.0d+0
            t806 = 1/t125**3
            t807 = t252**3
            t808 = 1/t123**4
            t809 = t248**3
            t810 = 1/t119**5
            t811 = 3.75d-1*t809*t810
            t812 = -7.5d-1*t248*t460*t474
            t813 = 5.0d-1*t249*t799
            t814 = -2.660585798433468d-1*t1*t454
            t815 = t814+t813+t812+t811
            t816 = 1/t120**4
            t817 = 1/t117**5
            t818 = 3.75d-1*t809*t817
            t819 = -7.5d-1*t248*t460*t481
            t820 = 5.0d-1*t254*t799
            t821 = t798+t796+t795+t787+t786+t785+t784+t781+t780+t779+t77
     1         8+t777+t776+t775
            t822 = 1/t131**3
            t823 = 1/t129**4
            t824 = 1/t128**5
            t825 = 3.75d-1*t809*t824
            t826 = -7.5d-1*t248*t460*t491
            t827 = 5.0d-1*t263*t799
            t828 = 1/t136**4
            t829 = t272**3
            t830 = 1/t134**4
            t831 = t827+t826+t825+t820+t819+t818
            t832 = 1/t138**4
            t833 = t261**3
            t834 = t140**5.0d-1
            t835 = 1/t143**5
            t836 = 1/t144**5
            t837 = -1.924173657795633d-1*t1*t350*t462*t98+1.282782438530
     1         422d-1*t1*t286*t460*t98-4.810434144489083d-1*t1*t575*t78*
     2         t800-1.282782438530422d-1*t1*t286*t78*t799+5.772520973386
     3         899d-1*t1*t240*t350*t460*t78-2.660585798433468d-1*t1*t105
     4         *t454-1.7103765847072294d-1*t1*t234*t240*t286
            t838 = t102*t837+t106*t799+3*t240*t514+3*t287*t460
            t839 = -2.812280816813114d-6*t369*t8+2.2108103907905202d-7*t
     1         368*t6+7.028397206309868d-1*t374*t5+1.0642057180760542d+0
     2         *t297*t375-9.347705929049741d-2*gammaaa*t373+7.6103291731
     3         42687d-3*t14*t372-5.874515858075838d-4*t12*t371+5.9338845
     4         46635945d-5*t10*t370-2.0076645727369685d+0*t361
            t840 = 5.401653940062247d-3*t374*t5-2.93353183662617d-3*gamm
     1         aaa*t373+6.774900836508068d-4*t14*t372-9.347783177467011d
     2         -5*t12*t371+8.143132921388737d-6*t10*t370+2.5733922057070
     3         335d-3*t361
            t841 = 1.6455307846020562d-2*gammaaa*t16*t25*t840-1.64553078
     1         46020562d-2*gammaaa*t16*t163*t17*t839-9.873184707612337d-
     2         2*gammaaa*t16*t17*t298*t365*t716-8.7761641845443d-2*gamma
     3         aa*t152*t25*t525-3.2910615692041123d-2*gammaaa*t16*t162*t
     4         163*t525+6.582123138408225d-2*gammaaa*t16*t162*t17*t366*t
     5         524+8.7761641845443d-2*gammaaa*t152*t163*t17*t524-3.29106
     6         15692041123d-2*gammaaa*t16*t163*t165*t524-1.6455307846020
     7         562d-2*gammaaa*t16*t163*t298*t379+1.6455307846020562d-2*t
     8         16*t25*t379+3.2910615692041123d-2*gammaaa*t16*t17*t298*t3
     9         66*t376-1.6455307846020562d-2*gammaaa*t16*t163*t299*t376-
     :         1.6455307846020562d-2*t16*t163*t17*t376+3.291061569204112
     ;         3d-2*gammaaa*t16*t299*t365*t366+3.2910615692041123d-2*t16
     <         *t17*t365*t366-1.75523283690886d-1*gammaaa*t152*t162*t17*
     =         t298*t366+6.582123138408225d-2*gammaaa*t16*t162*t165*t298
     >         *t366+1.6089634338331216d-1*gammaaa*t25*t299*t361-1.60896
     ?         34338331216d-1*gammaaa*t163*t17*t298*t361+1.6089634338331
     @         216d-1*t17*t25*t361+8.7761641845443d-2*gammaaa*t152*t162*
     1         t163*t299+8.7761641845443d-2*gammaaa*t152*t163*t165*t298-
     2         8.7761641845443d-2*t152*t165*t25+8.7761641845443d-2*t152*
     3         t162*t163*t17-3.2910615692041123d-2*t16*t162*t163*t165
            t842 = 6.934448603031025d-2*gammaaa*t16*t25*t840-6.934448603
     1         031025d-2*gammaaa*t16*t163*t17*t839-1.525825752416348d-8*
     2         t369*t734*t8-4.1606691618186153d-1*gammaaa*t16*t17*t298*t
     3         365*t716-3.698372588283213d-1*gammaaa*t152*t25*t525-1.386
     4         889720606205d-1*gammaaa*t16*t162*t163*t525+2.773779441212
     5         41d-1*gammaaa*t16*t162*t17*t366*t524+3.698372588283213d-1
     6         *gammaaa*t152*t163*t17*t524-1.386889720606205d-1*gammaaa*
     7         t16*t163*t165*t524+7.881662875529499d-6*t12*t371*t384-6.9
     8         34448603031025d-2*gammaaa*t16*t163*t298*t379+6.9344486030
     9         31025d-2*t16*t25*t379+1.386889720606205d-1*gammaaa*t16*t1
     :         7*t298*t366*t376-6.934448603031025d-2*gammaaa*t16*t163*t2
     ;         99*t376-6.934448603031025d-2*t16*t163*t17*t376-1.22091384
     <         7381626d-3*gammaaa*t168*t373+1.386889720606205d-1*gammaaa
     =         *t16*t299*t365*t366+1.386889720606205d-1*t16*t17*t365*t36
     >         6-7.396745176566426d-1*gammaaa*t152*t162*t17*t298*t366+2.
     ?         77377944121241d-1*gammaaa*t16*t162*t165*t298*t366+5.02248
     @         129273029d-2*t34*t361+6.780349745185891d-1*gammaaa*t25*t2
     1         99*t361-6.780349745185891d-1*gammaaa*t163*t17*t298*t361+6
     2         .780349745185891d-1*t17*t25*t361+3.698372588283213d-1*gam
     3         maaa*t152*t162*t163*t299+3.698372588283213d-1*gammaaa*t15
     4         2*t163*t165*t298-3.698372588283213d-1*t152*t165*t25+3.698
     5         372588283213d-1*t152*t162*t163*t17-1.386889720606205d-1*t
     6         16*t162*t163*t165
            t843 = 3.75d-1*t300*t394*t743
            t844 = -2.5d-1*t300*t381*t395
            t845 = -5.0d-1*t175*t395*t526
            t846 = 5.0d-1*t176*t841
            t847 = t846+t845+t844+t843
            t848 = 3.75d-1*t300*t394*t750
            t849 = -2.5d-1*t300*t381*t402
            t850 = -5.0d-1*t175*t402*t526
            t851 = 5.0d-1*t181*t841
            t852 = 3.75d-1*t300*t394*t757
            t853 = -2.5d-1*t300*t381*t412
            t854 = -5.0d-1*t175*t412*t526
            t855 = 5.0d-1*t190*t841
            t856 = t855+t854+t853+t852+t851+t850+t849+t848
            t857 = 1/t29**9
            t858 = -1.282782438530422d-1*t1*t213*t3*t841-4.8104341444890
     1         83d-1*t1*t3*t300*t383*t542+3.848347315591266d-1*t1*t167*t
     2         3*t318*t526+8.551882923536147d-2*t1*t213*t23*t526+1.92417
     3         3657795633d-1*t1*t3*t300*t318*t381-1.282782438530422d-1*t
     4         1*t167*t23*t300*t318-5.701255282357431d-2*t1*t161*t213*t3
     5         00
            t859 = t27*t858+t31*t841+2*t167*t547+2*t214*t526+t300*t435-1
     1         .282782438530422d-1*t1*t213*t3*t300*t381
            t860 = 7.610329173142687d-3*t451*t89-5.874515858075838d-4*t4
     1         50*t87+5.933884546635945d-5*t449*t85-2.812280816813114d-6
     2         *t448*t83+2.2108103907905202d-7*t447*t81+7.02839720630986
     3         8d-1*t453*t80+1.0642057180760542d+0*t329*t454-9.347705929
     4         049741d-2*gammabb*t452-2.0076645727369685d+0*t440
            t861 = 6.774900836508068d-4*t451*t89-9.347783177467011d-5*t4
     1         50*t87+8.143132921388737d-6*t449*t85+5.401653940062247d-3
     2         *t453*t80-2.93353183662617d-3*gammabb*t452+2.573392205707
     3         0335d-3*t440
            t862 = -1.6455307846020562d-2*gammabb*t236*t860*t91*t92-9.87
     1         3184707612337d-2*gammabb*t330*t444*t783*t91*t92+6.5821231
     2         38408225d-2*gammabb*t235*t445*t557*t91*t92+3.291061569204
     3         1123d-2*gammabb*t330*t445*t455*t91*t92-1.6455307846020562
     4         d-2*t236*t455*t91*t92+3.2910615692041123d-2*t444*t445*t91
     5         *t92+8.7761641845443d-2*gammabb*t225*t236*t557*t92-1.7552
     6         3283690886d-1*gammabb*t225*t235*t330*t445*t92-1.608963433
     7         8331216d-1*gammabb*t236*t330*t440*t92+1.6089634338331216d
     8         -1*t100*t440*t92+8.7761641845443d-2*t225*t235*t236*t92+1.
     9         6455307846020562d-2*gammabb*t100*t861*t91-3.2910615692041
     :         123d-2*gammabb*t235*t236*t558*t91-3.2910615692041123d-2*g
     ;         ammabb*t236*t238*t557*t91-1.6455307846020562d-2*gammabb*t
     <         236*t330*t458*t91+1.6455307846020562d-2*t100*t458*t91-1.6
     =         455307846020562d-2*gammabb*t236*t331*t455*t91+3.291061569
     >         2041123d-2*gammabb*t331*t444*t445*t91+6.582123138408225d-
     ?         2*gammabb*t235*t238*t330*t445*t91-3.2910615692041123d-2*t
     @         235*t236*t238*t91-8.7761641845443d-2*gammabb*t100*t225*t5
     1         58+1.6089634338331216d-1*gammabb*t100*t331*t440+8.7761641
     2         845443d-2*gammabb*t225*t235*t236*t331+8.7761641845443d-2*
     3         gammabb*t225*t236*t238*t330-8.7761641845443d-2*t100*t225*
     4         t238
            t863 = -6.934448603031025d-2*gammabb*t236*t860*t91*t92-4.160
     1         6691618186153d-1*gammabb*t330*t444*t783*t91*t92+2.7737794
     2         4121241d-1*gammabb*t235*t445*t557*t91*t92+1.3868897206062
     3         05d-1*gammabb*t330*t445*t455*t91*t92-6.934448603031025d-2
     4         *t236*t455*t91*t92+1.386889720606205d-1*t444*t445*t91*t92
     5         +3.698372588283213d-1*gammabb*t225*t236*t557*t92-7.396745
     6         176566426d-1*gammabb*t225*t235*t330*t445*t92-6.7803497451
     7         85891d-1*gammabb*t236*t330*t440*t92+6.780349745185891d-1*
     8         t100*t440*t92+3.698372588283213d-1*t225*t235*t236*t92+6.9
     9         34448603031025d-2*gammabb*t100*t861*t91-1.386889720606205
     :         d-1*gammabb*t235*t236*t558*t91-1.386889720606205d-1*gamma
     ;         bb*t236*t238*t557*t91-6.934448603031025d-2*gammabb*t236*t
     <         330*t458*t91+6.934448603031025d-2*t100*t458*t91-6.9344486
     =         03031025d-2*gammabb*t236*t331*t455*t91+1.386889720606205d
     >         -1*gammabb*t331*t444*t445*t91+2.77377944121241d-1*gammabb
     ?         *t235*t238*t330*t445*t91-1.386889720606205d-1*t235*t236*t
     @         238*t91+7.881662875529499d-6*t450*t463*t87-1.525825752416
     1         348d-8*t448*t801*t83-3.698372588283213d-1*gammabb*t100*t2
     2         25*t558-1.220913847381626d-3*gammabb*t241*t452+6.78034974
     3         5185891d-1*gammabb*t100*t331*t440+5.02248129273029d-2*t10
     4         9*t440+3.698372588283213d-1*gammabb*t225*t235*t236*t331+3
     5         .698372588283213d-1*gammabb*t225*t236*t238*t330-3.6983725
     6         88283213d-1*t100*t225*t238
            t864 = 3.75d-1*t332*t473*t810
            t865 = -2.5d-1*t332*t460*t474
            t866 = -5.0d-1*t248*t474*t559
            t867 = 5.0d-1*t249*t862
            t868 = t867+t866+t865+t864
            t869 = 3.75d-1*t332*t473*t817
            t870 = -2.5d-1*t332*t460*t481
            t871 = -5.0d-1*t248*t481*t559
            t872 = 5.0d-1*t254*t862
            t873 = 3.75d-1*t332*t473*t824
            t874 = -2.5d-1*t332*t460*t491
            t875 = -5.0d-1*t248*t491*t559
            t876 = 5.0d-1*t263*t862
            t877 = t876+t875+t874+t873+t872+t871+t870+t869
            t878 = 1/t104**9
            t879 = 8.551882923536147d-2*t1*t286*t559*t98-1.2827824385304
     1         22d-1*t1*t240*t332*t350*t98-1.282782438530422d-1*t1*t286*
     2         t78*t862-4.810434144489083d-1*t1*t332*t462*t575*t78+3.848
     3         347315591266d-1*t1*t240*t350*t559*t78+1.924173657795633d-
     4         1*t1*t332*t350*t460*t78-5.701255282357431d-2*t1*t234*t286
     5         *t332
            t880 = t102*t879+t106*t862-1.282782438530422d-1*t1*t286*t332
     1         *t460*t78+2*t240*t580+2*t287*t559+t332*t514
            t881 = 2.2804408244486873d-1*t161*t588-1.488977446919221d-3*
     1         t158*t5-7.028397206309868d-2*t160*t297+1.4759535677446958
     2         d-2*t159+1.3054479684612974d-4*gammaaa*t157-1.43561722902
     3         48254d-5*t14*t156+7.231579243233723d-7*t12*t155-5.9521818
     4         21359094d-8*t10*t154
            t882 = -1.3255240767081d-4*t158*t5-5.401653940062245d-4*t160
     1         *t297+4.631892373620269d-4*t159+2.0772851505482245d-5*gam
     2         maaa*t157-1.9701128035617912d-6*t14*t156
            t883 = 1.6455307846020562d-2*gammaaa*t16*t25*t882-1.64553078
     1         46020562d-2*gammaaa*t16*t163*t17*t881-9.873184707612337d-
     2         2*gammaaa*t16*t162*t17*t587*t716-4.38808209227215d-2*gamm
     3         aaa*t152*t25*t590-1.6455307846020562d-2*gammaaa*t16*t162*
     4         t163*t590+3.2910615692041123d-2*gammaaa*t16*t162*t17*t366
     5         *t589+4.38808209227215d-2*gammaaa*t152*t163*t17*t589-1.64
     6         55307846020562d-2*gammaaa*t16*t163*t165*t589-8.7761641845
     7         443d-2*gammaaa*t152*t17*t366*t587+3.2910615692041123d-2*g
     8         ammaaa*t16*t165*t366*t587-3.2910615692041123d-2*gammaaa*t
     9         16*t163*t298*t525+3.2910615692041123d-2*t16*t25*t525+6.58
     :         2123138408225d-2*gammaaa*t16*t17*t298*t366*t524-3.2910615
     ;         692041123d-2*gammaaa*t16*t163*t299*t524-3.291061569204112
     <         3d-2*t16*t163*t17*t524+6.582123138408225d-2*gammaaa*t16*t
     =         162*t298*t299*t366+6.582123138408225d-2*t16*t162*t17*t298
     >         *t366+8.7761641845443d-2*gammaaa*t152*t163*t298*t299-8.77
     ?         61641845443d-2*t152*t25*t299-3.2910615692041123d-2*t16*t1
     @         62*t163*t299+8.7761641845443d-2*t152*t163*t17*t298-3.2910
     1         615692041123d-2*t16*t163*t165*t298
            t884 = 6.934448603031025d-2*gammaaa*t16*t25*t882-6.934448603
     1         031025d-2*gammaaa*t16*t163*t17*t881+5.721846571561304d-9*
     2         t12*t155*t734-4.1606691618186153d-1*gammaaa*t16*t162*t17*
     3         t587*t716-1.8491862941416065d-1*gammaaa*t152*t25*t590-6.9
     4         34448603031025d-2*gammaaa*t16*t162*t163*t590+1.3868897206
     5         06205d-1*gammaaa*t16*t162*t17*t366*t589+1.849186294141606
     6         5d-1*gammaaa*t152*t163*t17*t589-6.934448603031025d-2*gamm
     7         aaa*t16*t163*t165*t589-3.698372588283213d-1*gammaaa*t152*
     8         t17*t366*t587+1.386889720606205d-1*gammaaa*t16*t165*t366*
     9         t587-1.386889720606205d-1*gammaaa*t16*t163*t298*t525+1.38
     :         6889720606205d-1*t16*t25*t525+2.77377944121241d-1*gammaaa
     ;         *t16*t17*t298*t366*t524-1.386889720606205d-1*gammaaa*t16*
     <         t163*t299*t524-1.386889720606205d-1*t16*t163*t17*t524-2.3
     =         18136139861618d-6*gammaaa*t157*t384+2.77377944121241d-1*g
     >         ammaaa*t16*t162*t298*t299*t366+2.77377944121241d-1*t16*t1
     ?         62*t17*t298*t366+3.698372588283213d-1*gammaaa*t152*t163*t
     @         298*t299-3.698372588283213d-1*t152*t25*t299-1.38688972060
     1         6205d-1*t16*t162*t163*t299+3.698372588283213d-1*t152*t163
     2         *t17*t298-1.386889720606205d-1*t16*t163*t165*t298+2.25399
     3         47951660788d-4*t159*t168
            t885 = 3.75d-1*t175*t585*t743
            t886 = -5.0d-1*t300*t395*t526
            t887 = -2.5d-1*t175*t395*t591
            t888 = 5.0d-1*t176*t883
            t889 = t888+t887+t886+t885
            t890 = 3.75d-1*t175*t585*t750
            t891 = -5.0d-1*t300*t402*t526
            t892 = -2.5d-1*t175*t402*t591
            t893 = 5.0d-1*t181*t883
            t894 = 3.75d-1*t175*t585*t757
            t895 = -5.0d-1*t300*t412*t526
            t896 = -2.5d-1*t175*t412*t591
            t897 = 5.0d-1*t190*t883
            t898 = t897+t896+t895+t894+t893+t892+t891+t890
            t899 = 1/t27**5
            t900 = -1.282782438530422d-1*t1*t213*t3*t883+1.9241736577956
     1         33d-1*t1*t167*t3*t318*t591+4.2759414617680735d-2*t1*t213*
     2         t23*t591-4.810434144489083d-1*t1*t167*t3*t542*t585-6.4139
     3         1219265211d-2*t1*t23*t318*t585+3.848347315591266d-1*t1*t3
     4         *t300*t318*t526
            t901 = t27*t900+t31*t883-1.282782438530422d-1*t1*t167*t213*t
     1         3*t591+t214*t591+1.924173657795633d-1*t1*t167*t3*t318*t58
     2         5+2*t300*t547-2.565564877060844d-1*t1*t213*t3*t300*t526
            t902 = -1.4356172290248254d-5*t229*t89+7.231579243233723d-7*
     1         t228*t87-5.952181821359094d-8*t227*t85-1.488977446919221d
     2         -3*t231*t80+2.2804408244486873d-1*t234*t648-7.02839720630
     3         9868d-2*t233*t329+1.4759535677446958d-2*t232+1.3054479684
     4         612974d-4*gammabb*t230
            t903 = -1.9701128035617912d-6*t229*t89-1.3255240767081d-4*t2
     1         31*t80-5.401653940062245d-4*t233*t329+4.631892373620269d-
     2         4*t232+2.0772851505482245d-5*gammabb*t230
            t904 = -1.6455307846020562d-2*gammabb*t236*t902*t91*t92-9.87
     1         3184707612337d-2*gammabb*t235*t647*t783*t91*t92+3.2910615
     2         692041123d-2*gammabb*t235*t445*t649*t91*t92+6.58212313840
     3         8225d-2*gammabb*t330*t445*t557*t91*t92-3.2910615692041123
     4         d-2*t236*t557*t91*t92+6.582123138408225d-2*t235*t330*t445
     5         *t91*t92+4.38808209227215d-2*gammabb*t225*t236*t649*t92-8
     6         .7761641845443d-2*gammabb*t225*t445*t647*t92+8.7761641845
     7         443d-2*t225*t236*t330*t92+1.6455307846020562d-2*gammabb*t
     8         100*t903*t91-1.6455307846020562d-2*gammabb*t235*t236*t650
     9         *t91-1.6455307846020562d-2*gammabb*t236*t238*t649*t91+3.2
     :         910615692041123d-2*gammabb*t238*t445*t647*t91-3.291061569
     ;         2041123d-2*gammabb*t236*t330*t558*t91+3.2910615692041123d
     <         -2*t100*t558*t91-3.2910615692041123d-2*gammabb*t236*t331*
     =         t557*t91+6.582123138408225d-2*gammabb*t235*t330*t331*t445
     >         *t91-3.2910615692041123d-2*t235*t236*t331*t91-3.291061569
     ?         2041123d-2*t236*t238*t330*t91-4.38808209227215d-2*gammabb
     @         *t100*t225*t650+8.7761641845443d-2*gammabb*t225*t236*t330
     1         *t331-8.7761641845443d-2*t100*t225*t331
            t905 = -6.934448603031025d-2*gammabb*t236*t902*t91*t92-4.160
     1         6691618186153d-1*gammabb*t235*t647*t783*t91*t92+1.3868897
     2         20606205d-1*gammabb*t235*t445*t649*t91*t92+2.773779441212
     3         41d-1*gammabb*t330*t445*t557*t91*t92-1.386889720606205d-1
     4         *t236*t557*t91*t92+2.77377944121241d-1*t235*t330*t445*t91
     5         *t92+1.8491862941416065d-1*gammabb*t225*t236*t649*t92-3.6
     6         98372588283213d-1*gammabb*t225*t445*t647*t92+3.6983725882
     7         83213d-1*t225*t236*t330*t92+6.934448603031025d-2*gammabb*
     8         t100*t903*t91-6.934448603031025d-2*gammabb*t235*t236*t650
     9         *t91-6.934448603031025d-2*gammabb*t236*t238*t649*t91+1.38
     :         6889720606205d-1*gammabb*t238*t445*t647*t91-1.38688972060
     ;         6205d-1*gammabb*t236*t330*t558*t91+1.386889720606205d-1*t
     <         100*t558*t91-1.386889720606205d-1*gammabb*t236*t331*t557*
     =         t91+2.77377944121241d-1*gammabb*t235*t330*t331*t445*t91-1
     >         .386889720606205d-1*t235*t236*t331*t91-1.386889720606205d
     ?         -1*t236*t238*t330*t91+5.721846571561304d-9*t228*t801*t87-
     @         1.8491862941416065d-1*gammabb*t100*t225*t650-2.3181361398
     1         61618d-6*gammabb*t230*t463+3.698372588283213d-1*gammabb*t
     2         225*t236*t330*t331-3.698372588283213d-1*t100*t225*t331+2.
     3         2539947951660788d-4*t232*t241
            t906 = 3.75d-1*t248*t645*t810
            t907 = -5.0d-1*t332*t474*t559
            t908 = -2.5d-1*t248*t474*t651
            t909 = 5.0d-1*t249*t904
            t910 = t909+t908+t907+t906
            t911 = 3.75d-1*t248*t645*t817
            t912 = -5.0d-1*t332*t481*t559
            t913 = -2.5d-1*t248*t481*t651
            t914 = 5.0d-1*t254*t904
            t915 = 3.75d-1*t248*t645*t824
            t916 = -5.0d-1*t332*t491*t559
            t917 = -2.5d-1*t248*t491*t651
            t918 = 5.0d-1*t263*t904
            t919 = t918+t917+t916+t915+t914+t913+t912+t911
            t920 = 1/t102**5
            t921 = 4.2759414617680735d-2*t1*t286*t651*t98-6.413912192652
     1         11d-2*t1*t350*t645*t98-1.282782438530422d-1*t1*t286*t78*t
     2         904+1.924173657795633d-1*t1*t240*t350*t651*t78-4.81043414
     3         4489083d-1*t1*t240*t575*t645*t78+3.848347315591266d-1*t1*
     4         t332*t350*t559*t78
            t922 = t102*t921+t106*t904-1.282782438530422d-1*t1*t240*t286
     1         *t651*t78+1.924173657795633d-1*t1*t240*t350*t645*t78-2.56
     2         5564877060844d-1*t1*t286*t332*t559*t78+t287*t651+2*t332*t
     3         580
            t923 = t300**3
            t924 = t298**3
            t925 = -1.6318099605766218d-5*t9+2.3072419752184684d-6*t5*t7
     1         -8.785496507887335d-3*t15*t588+1.1167330851894158d-4*t11*
     2         t297+2.5654959275047734d-1*t23/t10-1.3559211081063233d-7*
     3         gammaaa*t21+1.2400378794498113d-8*t14*t19
            t926 = -2.5966064381852805d-6*t9+3.1662527200100216d-7*t5*t7
     1         -6.752067425077807d-5*t15*t588+9.941430575310749d-6*t11*t
     2         297
            t927 = 1.6455307846020562d-2*gammaaa*t16*t25*t926-1.64553078
     1         46020562d-2*gammaaa*t16*t163*t17*t925-9.873184707612337d-
     2         2*gammaaa*t16*t17*t716*t924-4.9365923538061685d-2*gammaaa
     3         *t16*t163*t298*t590+4.9365923538061685d-2*t16*t25*t590+9.
     4         873184707612337d-2*gammaaa*t16*t17*t298*t366*t589-4.93659
     5         23538061685d-2*gammaaa*t16*t163*t299*t589-4.9365923538061
     6         685d-2*t16*t163*t17*t589+9.873184707612337d-2*gammaaa*t16
     7         *t299*t366*t587+9.873184707612337d-2*t16*t17*t366*t587-9.
     8         873184707612337d-2*t16*t163*t298*t299
            t928 = 6.934448603031025d-2*gammaaa*t16*t25*t926-6.934448603
     1         031025d-2*gammaaa*t16*t163*t17*t925-4.1606691618186153d-1
     2         *gammaaa*t16*t17*t716*t924+5.21580631468864d-7*t384*t9-2.
     3         1456924643354894d-9*gammaaa*t21*t734-2.0803345809093077d-
     4         1*gammaaa*t16*t163*t298*t590+2.0803345809093077d-1*t16*t2
     5         5*t590+4.1606691618186153d-1*gammaaa*t16*t17*t298*t366*t5
     6         89-2.0803345809093077d-1*gammaaa*t16*t163*t299*t589-2.080
     7         3345809093077d-1*t16*t163*t17*t589+4.1606691618186153d-1*
     8         gammaaa*t16*t299*t366*t587+4.1606691618186153d-1*t16*t17*
     9         t366*t587-4.1606691618186153d-1*t16*t163*t298*t299
            t929 = 1/t44**2
            t930 = 3.75d-1*t750*t923
            t931 = -7.5d-1*t300*t402*t591
            t932 = 5.0d-1*t181*t927
            t933 = 3.75d-1*t743*t923
            t934 = -7.5d-1*t300*t395*t591
            t935 = 5.0d-1*t176*t927
            t936 = t316**3
            t937 = 3.75d-1*t757*t923
            t938 = -7.5d-1*t300*t412*t591
            t939 = 5.0d-1*t190*t927
            t940 = t939+t938+t937+t932+t931+t930
            t941 = t1**3
            t942 = t31*t927-1.282782438530422d-1*t1*t3*t30*t927+9.620868
     1         288978166d-2*t1*t3*t318*t923-1.924173657795633d-1*t1*t213
     2         *t3*t300*t591
            t943 = t332**3
            t944 = t330**3
            t945 = 2.5654959275047734d-1*t98/t85-1.3559211081063233d-7*g
     1         ammabb*t96+1.2400378794498113d-8*t89*t94-8.78549650788733
     2         5d-3*t648*t90+1.1167330851894158d-4*t329*t86-1.6318099605
     3         766218d-5*t84+2.3072419752184684d-6*t80*t82
            t946 = -6.752067425077807d-5*t648*t90+9.941430575310749d-6*t
     1         329*t86-2.5966064381852805d-6*t84+3.1662527200100216d-7*t
     2         80*t82
            t947 = 1.6455307846020562d-2*gammabb*t100*t91*t946-1.6455307
     1         846020562d-2*gammabb*t236*t91*t92*t945-9.873184707612337d
     2         -2*gammabb*t783*t91*t92*t944+9.873184707612337d-2*gammabb
     3         *t330*t445*t649*t91*t92-4.9365923538061685d-2*t236*t649*t
     4         91*t92+9.873184707612337d-2*t445*t647*t91*t92-4.936592353
     5         8061685d-2*gammabb*t236*t330*t650*t91+4.9365923538061685d
     6         -2*t100*t650*t91-4.9365923538061685d-2*gammabb*t236*t331*
     7         t649*t91+9.873184707612337d-2*gammabb*t331*t445*t647*t91-
     8         9.873184707612337d-2*t236*t330*t331*t91
            t948 = -2.1456924643354894d-9*gammabb*t801*t96+6.93444860303
     1         1025d-2*gammabb*t100*t91*t946-6.934448603031025d-2*gammab
     2         b*t236*t91*t92*t945-4.1606691618186153d-1*gammabb*t783*t9
     3         1*t92*t944+4.1606691618186153d-1*gammabb*t330*t445*t649*t
     4         91*t92-2.0803345809093077d-1*t236*t649*t91*t92+4.16066916
     5         18186153d-1*t445*t647*t91*t92-2.0803345809093077d-1*gamma
     6         bb*t236*t330*t650*t91+2.0803345809093077d-1*t100*t650*t91
     7         -2.0803345809093077d-1*gammabb*t236*t331*t649*t91+4.16066
     8         91618186153d-1*gammabb*t331*t445*t647*t91-4.1606691618186
     9         153d-1*t236*t330*t331*t91+5.21580631468864d-7*t463*t84
            t949 = 1/t118**2
            t950 = 3.75d-1*t817*t943
            t951 = -7.5d-1*t332*t481*t651
            t952 = 5.0d-1*t254*t947
            t953 = 3.75d-1*t810*t943
            t954 = -7.5d-1*t332*t474*t651
            t955 = 5.0d-1*t249*t947
            t956 = t348**3
            t957 = 3.75d-1*t824*t943
            t958 = -7.5d-1*t332*t491*t651
            t959 = 5.0d-1*t263*t947
            t960 = t959+t958+t957+t952+t951+t950
            t961 = -1.282782438530422d-1*t1*t105*t78*t947+t106*t947+9.62
     1         0868288978166d-2*t1*t350*t78*t943-1.924173657795633d-1*t1
     2         *t286*t332*t651*t78
            fnc(iq) = (-9.305257363491d-1*t150*t97-9.305257363491d-1*t22
     1         *t76)*wght+fnc(iq)
            Amat(iq,D1_RA) = (-1.2407009817987999d+0*t2*t76-9.3052573634
     1         91d-1*t22*t223)*wght+Amat(iq,D1_RA)
            Amat(iq,D1_RB) = (-9.305257363491d-1*t296*t97-1.240700981798
     1         7999d+0*t150*t77)*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-9.305257363491d-1*t22*(t32
     1         8*t73+t322+t320+t319+t317+t315+t311+t16*t25*t310+t309+t30
     2         4+t303+t301)*wght
            Cmat(iq,D1_GAB) = Cmat(iq,D1_GAB)
            Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)-9.305257363491d-1*(t100*t3
     1         42*t91+t147*t360+t354+t352+t351+t349+t347+t343+t341+t336+
     2         t335+t333)*t97*wght
            Amat2(iq,D2_RA_RA) = (-4.135669939329333d-1*t40*t76-9.305257
     1         363491d-1*t22*t439-2.4814019635975998d+0*t2*t223)*wght+Am
     2         at2(iq,D2_RA_RA)
            Amat2(iq,D2_RA_RB) = Amat2(iq,D2_RA_RB)
            Amat2(iq,D2_RB_RB) = (-9.305257363491d-1*t518*t97-2.48140196
     1         35975998d+0*t296*t77-4.135669939329333d-1*t114*t150)*wght
     2         +Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RA_GAA) = (-1.2407009817987999d+0*t2*(-8.8888888
     1         88888888d-1*t522*t72*t73+t523+t521+t520+t519+t322+t320+t3
     2         19+t317+t315+t311+t309+t304+t303+t301)-9.305257363491d-1*
     3         t22*t551)*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_RA_GAB) = Cmat2(iq,D2_RA_GAB)
            Cmat2(iq,D2_RA_GBB) = Cmat2(iq,D2_RA_GBB)
            Cmat2(iq,D2_RB_GAA) = Cmat2(iq,D2_RB_GAA)
            Cmat2(iq,D2_RB_GAB) = Cmat2(iq,D2_RB_GAB)
            Cmat2(iq,D2_RB_GBB) = (-9.305257363491d-1*t584*t97-1.2407009
     1         817987999d+0*(t556-8.888888888888888d-1*t146*t147*t555+t5
     2         54+t553+t552+t354+t352+t351+t349+t347+t343+t341+t336+t335
     3         +t333)*t77)*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)-9.305257363491d-
     1         1*t22*(t643*t73+6.764482379964267d-3*t1*t213*t3*t300*t321
     2         *t35*t73+t222*t644+t213*t3*t38*t631+t630+t629+t628+t627+t
     3         195*t625+t621+t614+t612+t16*t163*t611+t16*t186*t25*t610+t
     4         16*t25*t601+t600+t598+t597+t596+t594+t592+t586)*wght
            Cmat2(iq,D2_GAA_GAB) = Cmat2(iq,D2_GAA_GAB)
            Cmat2(iq,D2_GAA_GBB) = Cmat2(iq,D2_GAA_GBB)
            Cmat2(iq,D2_GAB_GAB) = Cmat2(iq,D2_GAB_GAB)
            Cmat2(iq,D2_GAB_GBB) = Cmat2(iq,D2_GAB_GBB)
            Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)-9.305257363491d-
     1         1*(t236*t671*t91+t100*t259*t670*t91+t100*t661*t91+t113*t2
     2         86*t691*t78+6.764482379964267d-3*t1*t110*t147*t286*t332*t
     3         353*t78+t295*t704+t147*t703+t690+t689+t688+t687+t268*t685
     4         +t681+t674+t672+t660+t658+t657+t656+t654+t652+t646)*t97*w
     5         ght
            Amat3(iq,D3_RA_RA_RA) = (-9.305257363491d-1*t22*(2.666666666
     1         6666666d+0*t222*t72*t75*t771-1.0546577777777776d-1*t35*t3
     2         6*t73*t771-4.727288888888889d-2*t211*t28*t770-8.888888888
     3         888888d-1*t73*t75*(-2.4d+0*t68*(-3.75d-1*t766*t769+4.8104
     4         34144489083d-2*t207**3*t768-5.0d-1*t205*t754+6.4139121926
     5         5211d-2*t206*(gammaaa*t16*t25*t730-gammaaa*t16*t163*t17*t
     6         727-6*gammaaa*t16*t17*t715*t716-4.5629629629629626d+1*gam
     7         maaa*t17*t25*t707-8*gammaaa*t152*t25*t379-3*gammaaa*t16*t
     8         162*t163*t379+6*gammaaa*t16*t162*t17*t366*t376+8*gammaaa*
     9         t152*t163*t17*t376-3*gammaaa*t16*t163*t165*t376-16*gammaa
     :         a*t152*t17*t365*t366+6*gammaaa*t16*t165*t365*t366+2.93333
     ;         33333333333d+1*gammaaa*t165*t25*t361-2.9333333333333333d+
     <         1*gammaaa*t162*t163*t17*t361+16*gammaaa*t152*t162*t163*t1
     =         65)-9.620868288978166d-2*t207*t428*t431+7.5d-1*t188*t407*
     >         t430)-3.15d+1*t71*t766*t767-1.8610765434507923d+1*t766*t7
     ?         67-5.4519192d+0*t766-8.400000000000001d+0*t204*t71*t754-2
     @         .7259596d+0*t67*t754+5.672746666666666d-2*t66*t754+4.7459
     1         599999999996d-2*t35*t754-4.9628707825354457d+0*t204*t754+
     2         4.7459599999999996d-2*t66*t735-6.3d+1*t188*t407*t427*t71-
     3         1.6355757600000004d+1*t188*t407*t66-2.52d+1*t188*t204*t43
     4         2-6.3d+1*t208*t426*t427-3.7221530869015845d+1*t188*t407*t
     5         427-2.52d+1*t204*t208*t407+1.7018239999999996d-1*t188*t40
     6         7+1.423788d-1*t169*t407+1.423788d-1*t188*t385)+7.57211d-1
     7         *(-9.873184707612337d-2*gammaaa*t16*t17*t201**3*t25*t61*t
     8         765-1.6455307846020562d-2*gammaaa*t16*t17*t200*t25*t65*t7
     9         64-t200*t59*t63*t764-9.873184707612337d-2*gammaaa*t16*t17
     :         *t25*t65*t762*t763-6*t59*t63*t762*t763-6*t197**3*t59*t61*
     ;         t761-t198*t59*t61*(t760+t759+t758+t747)+t61*t63*t754-1.64
     <         55307846020562d-2*gammaaa*t16*t17*t202*t25*t61*(t753+t752
     =         +t751+t747)+1.6455307846020562d-2*gammaaa*t16*t25*t61*t65
     >         *t730-1.6455307846020562d-2*gammaaa*t16*t163*t17*t61*t65*
     ?         t727-9.873184707612337d-2*gammaaa*t16*t17*t61*t65*t715*t7
     @         16-7.508496024554567d-1*gammaaa*t17*t25*t61*t65*t707-1.31
     1         6424627681645d-1*gammaaa*t152*t25*t379*t61*t65-4.93659235
     2         38061685d-2*gammaaa*t16*t162*t163*t379*t61*t65+9.87318470
     3         7612337d-2*gammaaa*t16*t162*t17*t366*t376*t61*t65+1.31642
     4         4627681645d-1*gammaaa*t152*t163*t17*t376*t61*t65-4.936592
     5         3538061685d-2*gammaaa*t16*t163*t165*t376*t61*t65-2.632849
     6         25536329d-1*gammaaa*t152*t17*t365*t366*t61*t65+9.87318470
     7         7612337d-2*gammaaa*t16*t165*t365*t366*t61*t65+4.826890301
     8         4993647d-1*gammaaa*t165*t25*t361*t61*t65-4.82689030149936
     9         47d-1*gammaaa*t162*t163*t17*t361*t61*t65+2.63284925536329
     :         d-1*gammaaa*t152*t162*t163*t165*t61*t65+9.873184707612337
     ;         d-2*gammaaa*t16*t17*t199*t25*t421*t422*t65+1.316424627681
     <         645d-1*gammaaa*t152*t17*t200*t25*t422*t65-4.9365923538061
     =         685d-2*gammaaa*t16*t165*t200*t25*t422*t65+4.9365923538061
     >         685d-2*gammaaa*t16*t162*t163*t17*t200*t422*t65-2.63284925
     ?         536329d-1*gammaaa*t152*t17*t25*t420*t421*t65+9.8731847076
     @         12337d-2*gammaaa*t16*t165*t25*t420*t421*t65-9.87318470761
     1         2337d-2*gammaaa*t16*t162*t163*t17*t420*t421*t65-4.9365923
     2         538061685d-2*gammaaa*t16*t199*t200*t25*t379*t65+4.9365923
     3         538061685d-2*gammaaa*t16*t163*t17*t199*t200*t376*t65-9.87
     4         3184707612337d-2*gammaaa*t16*t17*t199*t200*t365*t366*t65-
     5         4.8268903014993647d-1*gammaaa*t17*t199*t200*t25*t361*t65+
     6         2.63284925536329d-1*gammaaa*t152*t165*t199*t200*t25*t65-2
     7         .63284925536329d-1*gammaaa*t152*t162*t163*t17*t199*t200*t
     8         65+9.873184707612337d-2*gammaaa*t16*t162*t163*t165*t199*t
     9         200*t65+6*t199*t421*t422*t59*t63-3*t188*t200*t422*t63+6*t
     :         188*t420*t421*t63-3*t199*t200*t407*t63+6*t197*t418*t419*t
     ;         59*t61+9.873184707612337d-2*gammaaa*t16*t17*t201*t25*t424
     <         *t425*t61+1.316424627681645d-1*gammaaa*t152*t17*t202*t25*
     =         t425*t61-4.9365923538061685d-2*gammaaa*t16*t165*t202*t25*
     >         t425*t61+4.9365923538061685d-2*gammaaa*t16*t162*t163*t17*
     ?         t202*t425*t61-2.63284925536329d-1*gammaaa*t152*t17*t25*t4
     @         23*t424*t61+9.873184707612337d-2*gammaaa*t16*t165*t25*t42
     1         3*t424*t61-9.873184707612337d-2*gammaaa*t16*t162*t163*t17
     2         *t423*t424*t61-3*t188*t198*t419*t61+6*t188*t417*t418*t61-
     3         3*t197*t198*t407*t61-4.9365923538061685d-2*gammaaa*t16*t2
     4         01*t202*t25*t379*t61+4.9365923538061685d-2*gammaaa*t16*t1
     5         63*t17*t201*t202*t376*t61-9.873184707612337d-2*gammaaa*t1
     6         6*t17*t201*t202*t365*t366*t61-4.8268903014993647d-1*gamma
     7         aa*t17*t201*t202*t25*t361*t61+2.63284925536329d-1*gammaaa
     8         *t152*t165*t201*t202*t25*t61-2.63284925536329d-1*gammaaa*
     9         t152*t162*t163*t17*t201*t202*t61+9.873184707612337d-2*gam
     :         maaa*t16*t162*t163*t165*t201*t202*t61+3*t197*t198*t200*t4
     ;         22*t59-6*t197*t198*t420*t421*t59+3*t198*t199*t200*t419*t5
     <         9-6*t199*t200*t417*t418*t59+4.9365923538061685d-2*gammaaa
     =         *t16*t17*t199*t200*t202*t25*t425-9.873184707612337d-2*gam
     >         maaa*t16*t17*t199*t200*t25*t423*t424+4.9365923538061685d-
     ?         2*gammaaa*t16*t17*t200*t201*t202*t25*t422-9.8731847076123
     @         37d-2*gammaaa*t16*t17*t201*t202*t25*t420*t421-2.632849255
     1         36329d-1*gammaaa*t152*t17*t199*t200*t201*t202*t25+9.87318
     2         4707612337d-2*gammaaa*t16*t165*t199*t200*t201*t202*t25-9.
     3         873184707612337d-2*gammaaa*t16*t162*t163*t17*t199*t200*t2
     4         01*t202+6*t188*t197*t198*t199*t200)-2.0d+0*t195*t59*(-1.4
     5         75609999999999d-1*t193*t50*(t760+t759+t758+t746+t745+t744
     6         )-8.853659999999993d-1*t192**3*t50*t756-1.475609999999999
     7         d-1*t180*t56*t748-8.853659999999993d-1*t56*t740*t741+8.85
     8         3659999999993d-1*t179*t393*t399*t56+8.853659999999993d-1*
     9         t192*t411*t415*t50+4.4268299999999966d-1*t179*t180*t193*t
     :         415-8.853659999999993d-1*t179*t180*t410*t411+4.4268299999
     ;         999966d-1*t180*t192*t193*t399-8.853659999999993d-1*t192*t
     <         193*t392*t393)-4.0d+0*t194**3*t59*t755-2.0d+0*t58*t754+3.
     =         2910615692041123d-2*gammaaa*t16*t17*t186*t25*(6.0965d-1*t
     >         184*t50*(t753+t752+t751+t746+t745+t744)+3.6579d+0*t183**3
     ?         *t50*t749+6.0965d-1*t180*t47*t748+3.6579d+0*t47*t740*t741
     @         -3.6579d+0*t183*t401*t405*t50-3.6579d+0*t179*t393*t399*t4
     1         7-1.82895d+0*t179*t180*t184*t405+3.6579d+0*t179*t180*t400
     2         *t401-1.82895d+0*t180*t183*t184*t399+3.6579d+0*t183*t184*
     3         t392*t393)+5.333333333333333d+1*t72*t737*t738*t75-3.2d+1*
     4         t221*t389*t438*t72*t75+8.0d+0*t209*t222*t438*t75+8.0d+0*t
     5         221*t222*t433*t75-3.2d+1*t209*t388*t389*t75+6.58212313840
     6         8225d-2*gammaaa*t16*t17*t185**3*t25*t739-1.26558933333333
     7         3d+0*t35*t36*t389*t737-2.8363733333333335d-1*t214**3*t28*
     8         t736+5.273288888888887d-2*t36*t38*t735-8.888888888888888d
     9         -1*t72*t73*(4.9365923538061685d-2*t1*t3*t30*(-1.875d+0*t1
     :         *t3*t542*t733-5.0d-1*t1*t213*t3*t732-7.5d-1*t1*t23*t318*t
     ;         383+2.25d+0*t1*t167*t3*t318*t381+5.0d-1*t1*t213*t23*t381-
     <         1.037037037037037d+0*t1*t30*t375-6.666666666666666d-1*t1*
     =         t161*t167*t213)-5.411738412550218d-1*t1*t3*t542*t733-1.44
     >         31302433467247d-1*t1*t213*t3*t732-1.6455307846020562d-2*t
     ?         1*t23*t30*t436-2.4682961769030842d-2*t1*t167*t213*t3*t436
     @         +9.873184707612337d-2*t219*t436-2.164695365020087d-1*t1*t
     1         23*t318*t383+6.494086095060261d-1*t1*t167*t3*t318*t381+1.
     2         4431302433467247d-1*t1*t213*t23*t381-2.993159023237651d-1
     3         *t1*t30*t375-1.9241736577956325d-1*t1*t161*t167*t213)+5.2
     4         73288888888887d-2*t35*t38*(-2.4052170722445415d-1*t1*t3*t
     5         542*t733-6.41391219265211d-2*t1*t213*t3*t732-9.6208682889
     6         78166d-2*t1*t23*t318*t383+2.8862604866934494d-1*t1*t167*t
     7         3*t318*t381+6.41391219265211d-2*t1*t213*t23*t381-1.330292
     8         899216734d-1*t1*t30*t375-8.551882923536147d-2*t1*t161*t16
     9         7*t213)-2.8363733333333335d-1*t32*t626*t733-4.72728888888
     :         8889d-2*t151*t32*t732+3.2910615692041123d-2*gammaaa*t16*t
     ;         25*t52*t730-3.1639733333333325d-1*t169*t36*t438*t73-3.163
     <         9733333333325d-1*t216*t35*t438*t73-2.6666666666666666d+0*
     =         t209*t437*t73-3.1639733333333325d-1*t221*t35*t434*t73-2.6
     >         666666666666666d+0*t220*t433*t73-3.1639733333333325d-1*t2
     ?         21*t36*t385*t73-6.327946666666665d-1*t169*t216*t221*t73-3
     @         .2910615692041123d-2*gammaaa*t16*t163*t17*t52*t727+8.0d+0
     1         *t220*t222*t438*t72+8.0d+0*t221*t222*t437*t72-3.2d+1*t220
     2         *t388*t389*t72-1.9746369415224674d-1*gammaaa*t16*t17*t52*
     3         t715*t716-1.5016992049109135d+0*gammaaa*t17*t25*t52*t707+
     4         6.0d+0*t194*t409*t416*t59-2.63284925536329d-1*gammaaa*t15
     5         2*t25*t379*t52-9.873184707612337d-2*gammaaa*t16*t162*t163
     6         *t379*t52+1.9746369415224674d-1*gammaaa*t16*t162*t17*t366
     7         *t376*t52+2.63284925536329d-1*gammaaa*t152*t163*t17*t376*
     8         t52-9.873184707612337d-2*gammaaa*t16*t163*t165*t376*t52-5
     9         .26569851072658d-1*gammaaa*t152*t17*t365*t366*t52+1.97463
     :         69415224674d-1*gammaaa*t16*t165*t365*t366*t52+9.653780602
     ;         998729d-1*gammaaa*t165*t25*t361*t52-9.653780602998729d-1*
     <         gammaaa*t162*t163*t17*t361*t52+5.26569851072658d-1*gammaa
     =         a*t152*t162*t163*t165*t52+9.491919999999998d-1*t221*t222*
     >         t35*t36*t438+2.8363733333333335d-1*t214*t28*t386*t435+1.4
     ?         181866666666668d-1*t151*t167*t211*t435+1.5819866666666663
     @         d-1*t169*t38*t434-6.0d+0*t188*t195*t416+6.0d+0*t188*t408*
     1         t409-6.0d+0*t194*t195*t407-9.873184707612337d-2*gammaaa*t
     2         16*t17*t185*t25*t391*t406-2.63284925536329d-1*gammaaa*t15
     3         2*t17*t186*t25*t406+9.873184707612337d-2*gammaaa*t16*t165
     4         *t186*t25*t406-9.873184707612337d-2*gammaaa*t16*t162*t163
     5         *t17*t186*t406+2.63284925536329d-1*gammaaa*t152*t17*t25*t
     6         390*t391-9.873184707612337d-2*gammaaa*t16*t165*t25*t390*t
     7         391+9.873184707612337d-2*gammaaa*t16*t162*t163*t17*t390*t
     8         391+9.491919999999998d-1*t169*t222*t36*t388+9.49191999999
     9         9998d-1*t216*t222*t35*t388-2.8363733333333335d-1*t151*t16
     :         7*t386*t387+1.5819866666666663d-1*t216*t38*t385-2.8363733
     ;         333333335d-1*t211*t214*t382*t383+2.8363733333333335d-1*t1
     <         67*t32*t381*t382+1.4181866666666668d-1*t151*t211*t214*t38
     =         1+9.873184707612337d-2*gammaaa*t16*t185*t186*t25*t379-9.8
     >         73184707612337d-2*gammaaa*t16*t163*t17*t185*t186*t376+1.9
     ?         746369415224674d-1*gammaaa*t16*t17*t185*t186*t365*t366+9.
     @         653780602998729d-1*gammaaa*t17*t185*t186*t25*t361-5.26569
     1         851072658d-1*gammaaa*t152*t165*t185*t186*t25+1.6d+1*t209*
     2         t220*t221*t222+5.26569851072658d-1*gammaaa*t152*t162*t163
     3         *t17*t185*t186-1.9746369415224674d-1*gammaaa*t16*t162*t16
     4         3*t165*t185*t186)+2.757113292886222d-1*t174*t76-1.2407009
     5         817987999d+0*t40*(2.6666666666666666d+0*t222*t706*t72*t75
     6         -8.888888888888888d-1*(4.9365923538061685d-2*t1*t3*(t218-
     7         5.0d-1*t1*t175*t213*t3)*t30-1.4431302433467247d-1*t1*t175
     8         *t213*t3+t217)*t72*t73-1.0546577777777776d-1*t35*t36*t706
     9         *t73-4.727288888888889d-2*t211*t28*t705+5.273288888888887
     :         d-2*(t215-6.41391219265211d-2*t1*t175*t213*t3)*t35*t38-4.
     ;         727288888888889d-2*t151*t175*t32+t210+t203+t196+t189+t187
     <         +t173+t172+t171+t170)-3.7221029453964d+0*t2*t439)*wght+Am
     =         at3(iq,D3_RA_RA_RA)
            Amat3(iq,D3_RA_RA_RB) = Amat3(iq,D3_RA_RA_RB)
            Amat3(iq,D3_RA_RB_RB) = Amat3(iq,D3_RA_RB_RB)
            Amat3(iq,D3_RB_RB_RB) = (-9.305257363491d-1*t97*(-8.88888888
     1         8888888d-1*t146*t147*(4.9365923538061685d-2*t1*t105*t78*(
     2         -7.5d-1*t1*t350*t462*t98+5.0d-1*t1*t286*t460*t98-1.875d+0
     3         *t1*t575*t78*t800-5.0d-1*t1*t286*t78*t799+2.25d+0*t1*t240
     4         *t350*t460*t78-1.037037037037037d+0*t1*t105*t454-6.666666
     5         666666666d-1*t1*t234*t240*t286)-1.6455307846020562d-2*t1*
     6         t105*t515*t98-2.164695365020087d-1*t1*t350*t462*t98+1.443
     7         1302433467247d-1*t1*t286*t460*t98-5.411738412550218d-1*t1
     8         *t575*t78*t800-1.4431302433467247d-1*t1*t286*t78*t799-2.4
     9         682961769030842d-2*t1*t240*t286*t515*t78+6.49408609506026
     :         1d-1*t1*t240*t350*t460*t78+9.873184707612337d-2*t292*t515
     ;         -2.993159023237651d-1*t1*t105*t454-1.9241736577956325d-1*
     <         t1*t234*t240*t286)+5.273288888888887d-2*t110*t113*(-9.620
     =         868288978166d-2*t1*t350*t462*t98+6.41391219265211d-2*t1*t
     >         286*t460*t98-2.4052170722445415d-1*t1*t575*t78*t800-6.413
     ?         91219265211d-2*t1*t286*t78*t799+2.8862604866934494d-1*t1*
     @         t240*t350*t460*t78-1.330292899216734d-1*t1*t105*t454-8.55
     1         1882923536147d-2*t1*t234*t240*t286)-8.888888888888888d-1*
     2         t147*t149*(-2.4d+0*t142*(6.41391219265211d-2*t279*(-gamma
     3         bb*t236*t794*t91*t92-6*gammabb*t782*t783*t91*t92+6*gammab
     4         b*t235*t445*t455*t91*t92-4.5629629629629626d+1*gammabb*t1
     5         00*t774*t92+8*gammabb*t225*t236*t455*t92-16*gammabb*t225*
     6         t444*t445*t92-2.9333333333333333d+1*gammabb*t235*t236*t44
     7         0*t92+gammabb*t100*t797*t91-3*gammabb*t235*t236*t458*t91-
     8         3*gammabb*t236*t238*t455*t91+6*gammabb*t238*t444*t445*t91
     9         -8*gammabb*t100*t225*t458+2.9333333333333333d+1*gammabb*t
     :         100*t238*t440+16*gammabb*t225*t235*t236*t238)-3.75d-1*t83
     ;         3*t836+4.810434144489083d-2*t280**3*t835-5.0d-1*t278*t821
     <         -9.620868288978166d-2*t280*t507*t510+7.5d-1*t261*t486*t50
     =         9)-3.15d+1*t145*t833*t834-1.8610765434507923d+1*t833*t834
     >         -5.4519192d+0*t833-8.400000000000001d+0*t145*t277*t821-4.
     ?         9628707825354457d+0*t277*t821-2.7259596d+0*t141*t821+5.67
     @         2746666666666d-2*t140*t821+4.7459599999999996d-2*t110*t82
     1         1+4.7459599999999996d-2*t140*t802-2.52d+1*t261*t277*t511-
     2         6.3d+1*t281*t505*t506-6.3d+1*t145*t261*t486*t506-3.722153
     3         0869015845d+1*t261*t486*t506-2.52d+1*t277*t281*t486-1.635
     4         5757600000004d+1*t140*t261*t486+1.7018239999999996d-1*t26
     5         1*t486+1.423788d-1*t242*t486+1.423788d-1*t261*t464)+7.572
     6         11d-1*(-9.873184707612337d-2*gammabb*t100*t135*t274**3*t8
     7         32*t91*t92-1.6455307846020562d-2*gammabb*t100*t139*t273*t
     8         831*t91*t92-9.873184707612337d-2*gammabb*t100*t139*t829*t
     9         830*t91*t92-1.6455307846020562d-2*gammabb*t100*t135*t275*
     :         (t820+t819+t818+t814)*t91*t92-1.6455307846020562d-2*gamma
     ;         bb*t135*t139*t236*t794*t91*t92-9.873184707612337d-2*gamma
     <         bb*t135*t139*t782*t783*t91*t92+9.873184707612337d-2*gamma
     =         bb*t100*t135*t274*t503*t504*t91*t92+4.9365923538061685d-2
     >         *gammabb*t100*t272*t273*t275*t504*t91*t92+4.9365923538061
     ?         685d-2*gammabb*t135*t235*t236*t275*t504*t91*t92-9.8731847
     @         07612337d-2*gammabb*t100*t272*t273*t502*t503*t91*t92-9.87
     1         3184707612337d-2*gammabb*t135*t235*t236*t502*t503*t91*t92
     2         +9.873184707612337d-2*gammabb*t100*t139*t272*t500*t501*t9
     3         1*t92+4.9365923538061685d-2*gammabb*t100*t273*t274*t275*t
     4         501*t91*t92+4.9365923538061685d-2*gammabb*t139*t235*t236*
     5         t273*t501*t91*t92-9.873184707612337d-2*gammabb*t100*t274*
     6         t275*t499*t500*t91*t92-9.873184707612337d-2*gammabb*t139*
     7         t235*t236*t499*t500*t91*t92+9.873184707612337d-2*gammabb*
     8         t135*t139*t235*t445*t455*t91*t92+4.9365923538061685d-2*ga
     9         mmabb*t135*t236*t274*t275*t455*t91*t92+4.9365923538061685
     :         d-2*gammabb*t139*t236*t272*t273*t455*t91*t92-9.8731847076
     ;         12337d-2*gammabb*t135*t274*t275*t444*t445*t91*t92-9.87318
     <         4707612337d-2*gammabb*t139*t272*t273*t444*t445*t91*t92-9.
     =         873184707612337d-2*gammabb*t235*t236*t272*t273*t274*t275*
     >         t91*t92-7.508496024554567d-1*gammabb*t100*t135*t139*t774*
     ?         t92+1.316424627681645d-1*gammabb*t100*t135*t225*t275*t504
     @         *t92-2.63284925536329d-1*gammabb*t100*t135*t225*t502*t503
     1         *t92+1.316424627681645d-1*gammabb*t100*t139*t225*t273*t50
     2         1*t92-2.63284925536329d-1*gammabb*t100*t139*t225*t499*t50
     3         0*t92+1.316424627681645d-1*gammabb*t135*t139*t225*t236*t4
     4         55*t92-2.63284925536329d-1*gammabb*t135*t139*t225*t444*t4
     5         45*t92-4.8268903014993647d-1*gammabb*t100*t135*t274*t275*
     6         t440*t92-4.8268903014993647d-1*gammabb*t100*t139*t272*t27
     7         3*t440*t92-4.8268903014993647d-1*gammabb*t135*t139*t235*t
     8         236*t440*t92-2.63284925536329d-1*gammabb*t100*t225*t272*t
     9         273*t274*t275*t92-2.63284925536329d-1*gammabb*t135*t225*t
     :         235*t236*t274*t275*t92-2.63284925536329d-1*gammabb*t139*t
     ;         225*t235*t236*t272*t273*t92+1.6455307846020562d-2*gammabb
     <         *t100*t135*t139*t797*t91-4.9365923538061685d-2*gammabb*t1
     =         00*t135*t238*t275*t504*t91+9.873184707612337d-2*gammabb*t
     >         100*t135*t238*t502*t503*t91-4.9365923538061685d-2*gammabb
     ?         *t100*t139*t238*t273*t501*t91+9.873184707612337d-2*gammab
     @         b*t100*t139*t238*t499*t500*t91-4.9365923538061685d-2*gamm
     1         abb*t100*t135*t274*t275*t458*t91-4.9365923538061685d-2*ga
     2         mmabb*t100*t139*t272*t273*t458*t91-4.9365923538061685d-2*
     3         gammabb*t135*t139*t235*t236*t458*t91-4.9365923538061685d-
     4         2*gammabb*t135*t139*t236*t238*t455*t91+9.873184707612337d
     5         -2*gammabb*t135*t139*t238*t444*t445*t91+9.873184707612337
     6         d-2*gammabb*t100*t238*t272*t273*t274*t275*t91+9.873184707
     7         612337d-2*gammabb*t135*t235*t236*t238*t274*t275*t91+9.873
     8         184707612337d-2*gammabb*t139*t235*t236*t238*t272*t273*t91
     9         -t133*t137*t273*t831-6*t133*t137*t829*t830-6*t133*t135*t2
     :         70**3*t828-t133*t135*t271*(t827+t826+t825+t814)+t135*t137
     ;         *t821+6*t133*t137*t272*t500*t501+3*t133*t270*t271*t273*t5
     <         01-3*t137*t261*t273*t501-6*t133*t270*t271*t499*t500+6*t13
     =         7*t261*t499*t500+6*t133*t135*t270*t497*t498+3*t133*t271*t
     >         272*t273*t498-3*t135*t261*t271*t498-6*t133*t272*t273*t496
     ?         *t497+6*t135*t261*t496*t497-3*t137*t272*t273*t486-3*t135*
     @         t270*t271*t486-1.316424627681645d-1*gammabb*t100*t135*t13
     1         9*t225*t458+4.8268903014993647d-1*gammabb*t100*t135*t139*
     2         t238*t440+2.63284925536329d-1*gammabb*t100*t135*t225*t238
     3         *t274*t275+6*t261*t270*t271*t272*t273+2.63284925536329d-1
     4         *gammabb*t100*t139*t225*t238*t272*t273+2.63284925536329d-
     5         1*gammabb*t135*t139*t225*t235*t236*t238)+3.29106156920411
     6         23d-2*gammabb*t100*t259*(6.0965d-1*t124*t257*(t820+t819+t
     7         818+t813+t812+t811)+3.6579d+0*t124*t256**3*t816+6.0965d-1
     8         *t121*t253*t815+3.6579d+0*t121*t807*t808-3.6579d+0*t124*t
     9         256*t480*t484-1.82895d+0*t252*t253*t257*t484+3.6579d+0*t2
     :         52*t253*t479*t480-3.6579d+0*t121*t252*t472*t478-1.82895d+
     ;         0*t253*t256*t257*t478+3.6579d+0*t256*t257*t471*t472)*t91*
     <         t92+6.582123138408225d-2*gammabb*t100*t258**3*t806*t91*t9
     =         2-3.2910615692041123d-2*gammabb*t126*t236*t794*t91*t92-1.
     >         9746369415224674d-1*gammabb*t126*t782*t783*t91*t92-9.8731
     ?         84707612337d-2*gammabb*t100*t258*t470*t485*t91*t92-9.8731
     @         84707612337d-2*gammabb*t235*t236*t259*t485*t91*t92+9.8731
     1         84707612337d-2*gammabb*t235*t236*t469*t470*t91*t92+1.9746
     2         369415224674d-1*gammabb*t126*t235*t445*t455*t91*t92-9.873
     3         184707612337d-2*gammabb*t236*t258*t259*t455*t91*t92+1.974
     4         6369415224674d-1*gammabb*t258*t259*t444*t445*t91*t92-1.50
     5         16992049109135d+0*gammabb*t100*t126*t774*t92-2.6328492553
     6         6329d-1*gammabb*t100*t225*t259*t485*t92+2.63284925536329d
     7         -1*gammabb*t100*t225*t469*t470*t92+2.63284925536329d-1*ga
     8         mmabb*t126*t225*t236*t455*t92-5.26569851072658d-1*gammabb
     9         *t126*t225*t444*t445*t92+9.653780602998729d-1*gammabb*t10
     :         0*t258*t259*t440*t92-9.653780602998729d-1*gammabb*t126*t2
     ;         35*t236*t440*t92+5.26569851072658d-1*gammabb*t225*t235*t2
     <         36*t258*t259*t92+3.2910615692041123d-2*gammabb*t100*t126*
     =         t797*t91+9.873184707612337d-2*gammabb*t100*t238*t259*t485
     >         *t91-9.873184707612337d-2*gammabb*t100*t238*t469*t470*t91
     ?         +9.873184707612337d-2*gammabb*t100*t258*t259*t458*t91-9.8
     @         73184707612337d-2*gammabb*t126*t235*t236*t458*t91-9.87318
     1         4707612337d-2*gammabb*t126*t236*t238*t455*t91+1.974636941
     2         5224674d-1*gammabb*t126*t238*t444*t445*t91-1.974636941522
     3         4674d-1*gammabb*t235*t236*t238*t258*t259*t91+2.6666666666
     4         666666d+0*t146*t149*t295*t838-1.0546577777777776d-1*t110*
     5         t111*t147*t838-4.727288888888889d-2*t103*t284*t837-2.0d+0
     6         *t133*t268*(-1.475609999999999d-1*t124*t266*(t827+t826+t8
     7         25+t813+t812+t811)-8.853659999999993d-1*t124*t265**3*t823
     8         -1.475609999999999d-1*t130*t253*t815-8.853659999999993d-1
     9         *t130*t807*t808+8.853659999999993d-1*t124*t265*t490*t494+
     :         4.4268299999999966d-1*t252*t253*t266*t494-8.8536599999999
     ;         93d-1*t252*t253*t489*t490+8.853659999999993d-1*t130*t252*
     <         t472*t478+4.4268299999999966d-1*t253*t265*t266*t478-8.853
     =         659999999993d-1*t265*t266*t471*t472)-4.0d+0*t133*t267**3*
     >         t822-2.0d+0*t132*t821+5.333333333333333d+1*t146*t149*t804
     ?         *t805-1.265589333333333d+0*t110*t111*t468*t804-2.83637333
     @         33333335d-1*t103*t287**3*t803+5.273288888888887d-2*t111*t
     1         113*t802-2.8363733333333335d-1*t107*t686*t800-4.727288888
     2         888889d-2*t107*t224*t799-3.2d+1*t146*t149*t294*t468*t517+
     3         9.491919999999998d-1*t110*t111*t294*t295*t517+8.0d+0*t146
     4         *t293*t295*t517+8.0d+0*t149*t282*t295*t517-3.163973333333
     5         3325d-1*t110*t147*t289*t517-3.1639733333333325d-1*t111*t1
     6         47*t242*t517+8.0d+0*t146*t294*t295*t516-2.666666666666666
     7         6d+0*t147*t282*t516+2.8363733333333335d-1*t103*t287*t465*
     8         t514+1.4181866666666668d-1*t224*t240*t284*t514-3.16397333
     9         33333325d-1*t110*t147*t294*t513+1.5819866666666663d-1*t11
     :         3*t242*t513+8.0d+0*t149*t294*t295*t512-2.6666666666666666
     ;         d+0*t147*t293*t512+6.0d+0*t133*t267*t488*t495-6.0d+0*t261
     <         *t268*t495+6.0d+0*t261*t487*t488-6.0d+0*t267*t268*t486-3.
     =         2d+1*t146*t293*t467*t468-3.2d+1*t149*t282*t467*t468+9.491
     >         919999999998d-1*t110*t289*t295*t467+9.491919999999998d-1*
     ?         t111*t242*t295*t467-2.8363733333333335d-1*t224*t240*t465*
     @         t466-3.1639733333333325d-1*t111*t147*t294*t464+1.58198666
     1         66666663d-1*t113*t289*t464-2.8363733333333335d-1*t284*t28
     2         7*t461*t462+2.8363733333333335d-1*t107*t240*t460*t461+1.4
     3         181866666666668d-1*t224*t284*t287*t460-2.63284925536329d-
     4         1*gammabb*t100*t126*t225*t458+9.653780602998729d-1*gammab
     5         b*t100*t126*t238*t440+1.6d+1*t282*t293*t294*t295-6.327946
     6         666666665d-1*t147*t242*t289*t294-5.26569851072658d-1*gamm
     7         abb*t100*t225*t238*t258*t259+5.26569851072658d-1*gammabb*
     8         t126*t225*t235*t236*t238)-1.2407009817987999d+0*t114*(-8.
     9         888888888888888d-1*t146*t147*(4.9365923538061685d-2*t1*t1
     :         05*t78*(t291-5.0d-1*t1*t248*t286*t78)-1.4431302433467247d
     ;         -1*t1*t248*t286*t78+t290)+5.273288888888887d-2*t110*t113*
     <         (t288-6.41391219265211d-2*t1*t248*t286*t78)+2.66666666666
     =         66666d+0*t146*t149*t295*t773-1.0546577777777776d-1*t110*t
     >         111*t147*t773-4.727288888888889d-2*t103*t284*t772+t283+t2
     ?         76+t269+t262+t260-4.727288888888889d-2*t107*t224*t248+t24
     @         6+t245+t244+t243)-3.7221029453964d+0*t518*t77+2.757113292
     1         886222d-1*t150*t247)*wght+Amat3(iq,D3_RB_RB_RB)
            Cmat3(iq,D3_RA_RA_GAA) = (-9.305257363491d-1*t22*(2.66666666
     1         66666666d+0*t222*t72*t75*t859-1.0546577777777776d-1*t35*t
     2         36*t73*t859-4.727288888888889d-2*t211*t28*t858+1.21281663
     3         37053317d-2*t1*t211*t3*t300*t383*t857+7.57211d-1*(-1.6455
     4         307846020562d-2*gammaaa*t16*t17*t200*t25*t65*t856-t200*t5
     5         9*t63*t856-t198*t59*t61*(t855+t854+t853+t852)-1.645530784
     6         6020562d-2*gammaaa*t16*t17*t202*t25*t61*(t851+t850+t849+t
     7         848)+t61*t63*t841+1.6455307846020562d-2*gammaaa*t16*t25*t
     8         61*t65*t840-1.6455307846020562d-2*gammaaa*t16*t163*t17*t6
     9         1*t65*t839-4.9365923538061685d-2*gammaaa*t16*t17*t181*t25
     :         *t300*t423*t61*t765-9.873184707612337d-2*gammaaa*t16*t17*
     ;         t25*t316*t420*t65*t763-6*t316*t420*t59*t63*t763-3*t190*t3
     <         00*t417*t59*t61*t761-9.873184707612337d-2*gammaaa*t16*t17
     =         *t298*t365*t61*t65*t716-8.7761641845443d-2*gammaaa*t152*t
     >         25*t525*t61*t65-3.2910615692041123d-2*gammaaa*t16*t162*t1
     ?         63*t525*t61*t65+6.582123138408225d-2*gammaaa*t16*t162*t17
     @         *t366*t524*t61*t65+8.7761641845443d-2*gammaaa*t152*t163*t
     1         17*t524*t61*t65-3.2910615692041123d-2*gammaaa*t16*t163*t1
     2         65*t524*t61*t65-1.6455307846020562d-2*gammaaa*t16*t163*t2
     3         98*t379*t61*t65+1.6455307846020562d-2*t16*t25*t379*t61*t6
     4         5+3.2910615692041123d-2*gammaaa*t16*t17*t298*t366*t376*t6
     5         1*t65-1.6455307846020562d-2*gammaaa*t16*t163*t299*t376*t6
     6         1*t65-1.6455307846020562d-2*t16*t163*t17*t376*t61*t65+3.2
     7         910615692041123d-2*gammaaa*t16*t299*t365*t366*t61*t65+3.2
     8         910615692041123d-2*t16*t17*t365*t366*t61*t65-1.7552328369
     9         0886d-1*gammaaa*t152*t162*t17*t298*t366*t61*t65+6.5821231
     :         38408225d-2*gammaaa*t16*t162*t165*t298*t366*t61*t65+1.608
     ;         9634338331216d-1*gammaaa*t25*t299*t361*t61*t65-1.60896343
     <         38331216d-1*gammaaa*t163*t17*t298*t361*t61*t65+1.60896343
     =         38331216d-1*t17*t25*t361*t61*t65+8.7761641845443d-2*gamma
     >         aa*t152*t162*t163*t299*t61*t65+8.7761641845443d-2*gammaaa
     ?         *t152*t163*t165*t298*t61*t65-8.7761641845443d-2*t152*t165
     @         *t25*t61*t65+8.7761641845443d-2*t152*t162*t163*t17*t61*t6
     1         5-3.2910615692041123d-2*t16*t162*t163*t165*t61*t65+6.5821
     2         23138408225d-2*gammaaa*t16*t17*t199*t25*t421*t540*t65+8.7
     3         761641845443d-2*gammaaa*t152*t17*t200*t25*t540*t65-3.2910
     4         615692041123d-2*gammaaa*t16*t165*t200*t25*t540*t65+3.2910
     5         615692041123d-2*gammaaa*t16*t162*t163*t17*t200*t540*t65-3
     6         .2910615692041123d-2*gammaaa*t16*t199*t200*t25*t525*t65+3
     7         .2910615692041123d-2*gammaaa*t16*t163*t17*t199*t200*t524*
     8         t65+3.2910615692041123d-2*gammaaa*t16*t17*t25*t316*t421*t
     9         422*t65-1.6455307846020562d-2*gammaaa*t16*t200*t25*t299*t
     :         422*t65+1.6455307846020562d-2*gammaaa*t16*t163*t17*t200*t
     ;         298*t422*t65-1.6455307846020562d-2*t16*t17*t200*t25*t422*
     <         t65+3.2910615692041123d-2*gammaaa*t16*t25*t299*t420*t421*
     =         t65-3.2910615692041123d-2*gammaaa*t16*t163*t17*t298*t420*
     >         t421*t65+3.2910615692041123d-2*t16*t17*t25*t420*t421*t65-
     ?         1.75523283690886d-1*gammaaa*t152*t17*t199*t25*t316*t421*t
     @         65+6.582123138408225d-2*gammaaa*t16*t165*t199*t25*t316*t4
     1         21*t65-6.582123138408225d-2*gammaaa*t16*t162*t163*t17*t19
     2         9*t316*t421*t65-1.6455307846020562d-2*gammaaa*t16*t200*t2
     3         5*t316*t379*t65+1.6455307846020562d-2*gammaaa*t16*t163*t1
     4         7*t200*t316*t376*t65-3.2910615692041123d-2*gammaaa*t16*t1
     5         7*t200*t316*t365*t366*t65-6.582123138408225d-2*gammaaa*t1
     6         6*t162*t17*t199*t200*t298*t366*t65-1.6089634338331216d-1*
     7         gammaaa*t17*t200*t25*t316*t361*t65+8.7761641845443d-2*gam
     8         maaa*t152*t165*t200*t25*t316*t65-8.7761641845443d-2*gamma
     9         aa*t152*t162*t163*t17*t200*t316*t65+3.2910615692041123d-2
     :         *gammaaa*t16*t162*t163*t165*t200*t316*t65+8.7761641845443
     ;         d-2*gammaaa*t152*t199*t200*t25*t299*t65+3.291061569204112
     <         3d-2*gammaaa*t16*t162*t163*t199*t200*t299*t65-8.776164184
     =         5443d-2*gammaaa*t152*t163*t17*t199*t200*t298*t65+3.291061
     >         5692041123d-2*gammaaa*t16*t163*t165*t199*t200*t298*t65+8.
     ?         7761641845443d-2*t152*t17*t199*t200*t25*t65-3.29106156920
     @         41123d-2*t16*t165*t199*t200*t25*t65+3.2910615692041123d-2
     1         *t16*t162*t163*t17*t199*t200*t65+4*t199*t421*t540*t59*t63
     2         +2*t316*t421*t422*t59*t63-2*t188*t200*t540*t63-2*t199*t20
     3         0*t526*t63-t200*t300*t422*t63+2*t300*t420*t421*t63+4*t188
     4         *t199*t316*t421*t63-t200*t316*t407*t63+4*t197*t418*t539*t
     5         59*t61+t190*t300*t418*t419*t59*t61+6.582123138408225d-2*g
     6         ammaaa*t16*t17*t201*t25*t424*t541*t61+8.7761641845443d-2*
     7         gammaaa*t152*t17*t202*t25*t541*t61-3.2910615692041123d-2*
     8         gammaaa*t16*t165*t202*t25*t541*t61+3.2910615692041123d-2*
     9         gammaaa*t16*t162*t163*t17*t202*t541*t61-2*t188*t198*t539*
     :         t61-2*t197*t198*t526*t61-3.2910615692041123d-2*gammaaa*t1
     ;         6*t201*t202*t25*t525*t61+3.2910615692041123d-2*gammaaa*t1
     <         6*t163*t17*t201*t202*t524*t61+1.6455307846020562d-2*gamma
     =         aa*t16*t17*t181*t25*t300*t424*t425*t61-1.6455307846020562
     >         d-2*gammaaa*t16*t202*t25*t299*t425*t61+1.6455307846020562
     ?         d-2*gammaaa*t16*t163*t17*t202*t298*t425*t61-1.64553078460
     @         20562d-2*t16*t17*t202*t25*t425*t61+3.2910615692041123d-2*
     1         gammaaa*t16*t25*t299*t423*t424*t61-3.2910615692041123d-2*
     2         gammaaa*t16*t163*t17*t298*t423*t424*t61+3.291061569204112
     3         3d-2*t16*t17*t25*t423*t424*t61-8.7761641845443d-2*gammaaa
     4         *t152*t17*t181*t201*t25*t300*t424*t61+3.2910615692041123d
     5         -2*gammaaa*t16*t165*t181*t201*t25*t300*t424*t61-3.2910615
     6         692041123d-2*gammaaa*t16*t162*t163*t17*t181*t201*t300*t42
     7         4*t61-t198*t300*t419*t61+2*t300*t417*t418*t61+2*t188*t190
     8         *t197*t300*t418*t61-5.0d-1*t190*t198*t300*t407*t61-8.2276
     9         53923010281d-3*gammaaa*t16*t181*t202*t25*t300*t379*t61+8.
     :         227653923010281d-3*gammaaa*t16*t163*t17*t181*t202*t300*t3
     ;         76*t61-1.6455307846020562d-2*gammaaa*t16*t17*t181*t202*t3
     <         00*t365*t366*t61-6.582123138408225d-2*gammaaa*t16*t162*t1
     =         7*t201*t202*t298*t366*t61-8.044817169165608d-2*gammaaa*t1
     >         7*t181*t202*t25*t300*t361*t61+4.38808209227215d-2*gammaaa
     ?         *t152*t165*t181*t202*t25*t300*t61-4.38808209227215d-2*gam
     @         maaa*t152*t162*t163*t17*t181*t202*t300*t61+1.645530784602
     1         0562d-2*gammaaa*t16*t162*t163*t165*t181*t202*t300*t61+8.7
     2         761641845443d-2*gammaaa*t152*t201*t202*t25*t299*t61+3.291
     3         0615692041123d-2*gammaaa*t16*t162*t163*t201*t202*t299*t61
     4         -8.7761641845443d-2*gammaaa*t152*t163*t17*t201*t202*t298*
     5         t61+3.2910615692041123d-2*gammaaa*t16*t163*t165*t201*t202
     6         *t298*t61+8.7761641845443d-2*t152*t17*t201*t202*t25*t61-3
     7         .2910615692041123d-2*t16*t165*t201*t202*t25*t61+3.2910615
     8         692041123d-2*t16*t162*t163*t17*t201*t202*t61+2*t197*t198*
     9         t200*t540*t59+2*t198*t199*t200*t539*t59+5.0d-1*t190*t198*
     :         t200*t300*t422*t59-t190*t198*t300*t420*t421*t59-4*t197*t1
     ;         98*t199*t316*t421*t59+t198*t200*t316*t419*t59-2*t200*t316
     <         *t417*t418*t59-2*t190*t197*t199*t200*t300*t418*t59+3.2910
     =         615692041123d-2*gammaaa*t16*t17*t199*t200*t202*t25*t541+3
     >         .2910615692041123d-2*gammaaa*t16*t17*t200*t201*t202*t25*t
     ?         540+1.6455307846020562d-2*gammaaa*t16*t17*t200*t202*t25*t
     @         316*t425-3.2910615692041123d-2*gammaaa*t16*t17*t200*t25*t
     1         316*t423*t424-3.2910615692041123d-2*gammaaa*t16*t17*t181*
     2         t199*t200*t201*t25*t300*t424+8.227653923010281d-3*gammaaa
     3         *t16*t17*t181*t200*t202*t25*t300*t422-1.6455307846020562d
     4         -2*gammaaa*t16*t17*t181*t202*t25*t300*t420*t421-6.5821231
     5         38408225d-2*gammaaa*t16*t17*t199*t201*t202*t25*t316*t421-
     6         8.7761641845443d-2*gammaaa*t152*t17*t200*t201*t202*t25*t3
     7         16+3.2910615692041123d-2*gammaaa*t16*t165*t200*t201*t202*
     8         t25*t316-3.2910615692041123d-2*gammaaa*t16*t162*t163*t17*
     9         t200*t201*t202*t316+2*t188*t197*t198*t200*t316-4.38808209
     :         227215d-2*gammaaa*t152*t17*t181*t199*t200*t202*t25*t300+1
     ;         .6455307846020562d-2*gammaaa*t16*t165*t181*t199*t200*t202
     <         *t25*t300-1.6455307846020562d-2*gammaaa*t16*t162*t163*t17
     =         *t181*t199*t200*t202*t300+2*t197*t198*t199*t200*t300+t188
     >         *t190*t198*t199*t200*t300+3.2910615692041123d-2*gammaaa*t
     ?         16*t199*t200*t201*t202*t25*t299-3.2910615692041123d-2*gam
     @         maaa*t16*t163*t17*t199*t200*t201*t202*t298+3.291061569204
     1         1123d-2*t16*t17*t199*t200*t201*t202*t25)-2.0d+0*t195*t59*
     2         (-1.475609999999999d-1*t193*t50*(t855+t854+t853+t852+t846
     3         +t845+t844+t843)-1.475609999999999d-1*t180*t56*t847-8.853
     4         659999999993d-1*t313*t410*t50*t756-4.4268299999999966d-1*
     5         t176*t300*t392*t56*t741+5.902439999999995d-1*t179*t393*t5
     6         30*t56+1.475609999999999d-1*t176*t300*t393*t399*t56+5.902
     7         439999999995d-1*t192*t411*t50*t537+2.951219999999998d-1*t
     8         179*t180*t193*t537+2.951219999999998d-1*t180*t192*t193*t5
     9         30+2.951219999999998d-1*t313*t411*t415*t50+7.378049999999
     :         994d-2*t176*t180*t193*t300*t415-1.475609999999999d-1*t176
     ;         *t180*t300*t410*t411-5.902439999999995d-1*t179*t180*t192*
     <         t313*t411+1.475609999999999d-1*t180*t193*t313*t399-2.9512
     =         19999999998d-1*t193*t313*t392*t393-2.951219999999998d-1*t
     >         176*t179*t192*t193*t300*t393)+3.2910615692041123d-2*gamma
     ?         aa*t16*t17*t186*t25*(6.0965d-1*t184*t50*(t851+t850+t849+t
     @         848+t846+t845+t844+t843)+6.0965d-1*t180*t47*t847+3.6579d+
     1         0*t307*t400*t50*t749+1.82895d+0*t176*t300*t392*t47*t741-2
     2         .4386000000000002d+0*t183*t401*t50*t533-1.219300000000000
     3         1d+0*t179*t180*t184*t533-2.4386000000000002d+0*t179*t393*
     4         t47*t530-1.2193000000000001d+0*t180*t183*t184*t530-1.2193
     5         000000000001d+0*t307*t401*t405*t50-6.0965d-1*t176*t300*t3
     6         93*t399*t47-3.04825d-1*t176*t180*t184*t300*t405+6.0965d-1
     7         *t176*t180*t300*t400*t401+2.4386000000000002d+0*t179*t180
     8         *t183*t307*t401-6.0965d-1*t180*t184*t307*t399+1.219300000
     9         0000001d+0*t184*t307*t392*t393+1.2193000000000001d+0*t176
     :         *t179*t183*t184*t300*t393)-8.888888888888888d-1*t73*t75*(
     ;         4.7459599999999996d-2*t66*t842-2.4d+0*t68*(-5.0d-1*t205*t
     <         841+6.41391219265211d-2*t206*(gammaaa*t16*t25*t840-gammaa
     =         a*t16*t163*t17*t839-6*gammaaa*t16*t17*t298*t365*t716-5.33
     >         3333333333333d+0*gammaaa*t152*t25*t525-2*gammaaa*t16*t162
     ?         *t163*t525+4*gammaaa*t16*t162*t17*t366*t524+5.33333333333
     @         3333d+0*gammaaa*t152*t163*t17*t524-2*gammaaa*t16*t163*t16
     1         5*t524-gammaaa*t16*t163*t298*t379+t16*t25*t379+2*gammaaa*
     2         t16*t17*t298*t366*t376-gammaaa*t16*t163*t299*t376-t16*t16
     3         3*t17*t376+2*gammaaa*t16*t299*t365*t366+2*t16*t17*t365*t3
     4         66-1.0666666666666666d+1*gammaaa*t152*t162*t17*t298*t366+
     5         4*gammaaa*t16*t162*t165*t298*t366+9.777777777777779d+0*ga
     6         mmaaa*t25*t299*t361-9.777777777777779d+0*gammaaa*t163*t17
     7         *t298*t361+9.777777777777779d+0*t17*t25*t361+5.3333333333
     8         33333d+0*gammaaa*t152*t162*t163*t299+5.333333333333333d+0
     9         *gammaaa*t152*t163*t165*t298-5.333333333333333d+0*t152*t1
     :         65*t25+5.333333333333333d+0*t152*t162*t163*t17-2*t16*t162
     ;         *t163*t165)-3.75d-1*t300*t426*t769+4.810434144489083d-2*t
     <         325*t429*t768-6.41391219265211d-2*t207*t428*t543+5.0d-1*t
     =         188*t430*t526-3.206956096326055d-2*t325*t428*t431+2.5d-1*
     >         t300*t407*t430)-8.400000000000001d+0*t204*t71*t841-2.7259
     ?         596d+0*t67*t841+5.672746666666666d-2*t66*t841+4.745959999
     @         9999996d-2*t35*t841-4.9628707825354457d+0*t204*t841-3.15d
     1         +1*t300*t426*t71*t767-1.8610765434507923d+1*t300*t426*t76
     2         7-4.2d+1*t188*t427*t526*t71-2.1d+1*t300*t407*t427*t71-1.0
     3         903838400000002d+1*t188*t526*t66-5.4519192d+0*t300*t407*t
     4         66-1.68d+1*t188*t204*t544+9.491919999999999d-2*t188*t527-
     5         2.481435391267723d+1*t188*t427*t526-1.68d+1*t204*t208*t52
     6         6+1.1345493333333331d-1*t188*t526+9.491919999999999d-2*t1
     7         69*t526-8.400000000000001d+0*t204*t300*t432-2.1d+1*t326*t
     8         426*t427-1.2407176956338616d+1*t300*t407*t427-4.2d+1*t188
     9         *t208*t300*t427-5.4519192d+0*t300*t426-8.400000000000001d
     :         +0*t204*t326*t407+4.7459599999999996d-2*t302*t407+5.67274
     ;         6666666666d-2*t300*t407+4.7459599999999996d-2*t300*t385)+
     <         5.273288888888887d-2*t36*t38*t842-8.888888888888888d-1*t7
     =         2*t73*(4.9365923538061685d-2*t1*t3*t30*(-5.0d-1*t1*t213*t
     >         3*t841-1.875d+0*t1*t3*t300*t383*t542+1.5d+0*t1*t167*t3*t3
     ?         18*t526+3.333333333333333d-1*t1*t213*t23*t526+7.5d-1*t1*t
     @         3*t300*t318*t381-5.0d-1*t1*t167*t23*t300*t318-2.222222222
     1         222222d-1*t1*t161*t213*t300)-1.4431302433467247d-1*t1*t21
     2         3*t3*t841+9.873184707612337d-2*t219*t548-5.41173841255021
     3         8d-1*t1*t3*t300*t383*t542+4.329390730040174d-1*t1*t167*t3
     4         *t318*t526+9.620868288978164d-2*t1*t213*t23*t526-2.468296
     5         1769030842d-2*t1*t213*t3*t300*t436+2.164695365020087d-1*t
     6         1*t3*t300*t318*t381-1.4431302433467247d-1*t1*t167*t23*t30
     7         0*t318-6.413912192652109d-2*t1*t161*t213*t300)+5.27328888
     8         8888887d-2*t35*t38*(-6.41391219265211d-2*t1*t213*t3*t841-
     9         2.4052170722445415d-1*t1*t3*t300*t383*t542+1.924173657795
     :         633d-1*t1*t167*t3*t318*t526+4.2759414617680735d-2*t1*t213
     ;         *t23*t526+9.620868288978166d-2*t1*t3*t300*t318*t381-6.413
     <         91219265211d-2*t1*t167*t23*t300*t318-2.8506276411787157d-
     =         2*t1*t161*t213*t300)-2.0d+0*t58*t841-4.727288888888889d-2
     >         *t151*t32*t841+3.2910615692041123d-2*gammaaa*t16*t25*t52*
     ?         t840-3.2910615692041123d-2*gammaaa*t16*t163*t17*t52*t839-
     @         4.0d+0*t314*t408*t59*t755+5.333333333333333d+1*t321*t388*
     1         t72*t738*t75-2.1333333333333332d+1*t221*t389*t550*t72*t75
     2         -1.0666666666666666d+1*t321*t389*t438*t72*t75+5.333333333
     3         333333d+0*t209*t222*t550*t75+5.333333333333333d+0*t221*t2
     4         22*t545*t75+2.6666666666666666d+0*t222*t327*t438*t75+2.66
     5         66666666666666d+0*t222*t321*t433*t75-1.0666666666666666d+
     6         1*t327*t388*t389*t75-2.1333333333333332d+1*t209*t221*t321
     7         *t389*t75+6.582123138408225d-2*gammaaa*t16*t17*t25*t308*t
     8         390*t739+3.6384499011159954d-2*t1*t3*t300*t318*t387*t736-
     9         2.109315555555555d-1*t169*t36*t550*t73-2.109315555555555d
     :         -1*t216*t35*t550*t73-1.7777777777777776d+0*t209*t549*t73-
     ;         2.109315555555555d-1*t221*t35*t546*t73-1.7777777777777776
     <         d+0*t220*t545*t73-2.109315555555555d-1*t221*t36*t527*t73-
     =         8.888888888888888d-1*t433*t522*t73-1.0546577777777776d-1*
     >         t302*t36*t438*t73+6.764482379964267d-3*t1*t213*t3*t300*t3
     ?         5*t438*t73-8.888888888888888d-1*t327*t437*t73-1.054657777
     @         7777776d-1*t321*t35*t434*t73-1.0546577777777776d-1*t321*t
     1         36*t385*t73-2.109315555555555d-1*t169*t216*t321*t73-2.109
     2         315555555555d-1*t216*t221*t302*t73+1.3528964759928536d-2*
     3         t1*t169*t213*t221*t3*t300*t73+5.333333333333333d+0*t220*t
     4         222*t550*t72+5.333333333333333d+0*t221*t222*t549*t72+2.66
     5         66666666666666d+0*t222*t438*t522*t72-1.0666666666666666d+
     6         1*t388*t389*t522*t72+2.6666666666666666d+0*t222*t321*t437
     7         *t72-2.1333333333333332d+1*t220*t221*t321*t389*t72-1.9746
     8         369415224674d-1*gammaaa*t16*t17*t298*t365*t52*t716-2.8363
     9         733333333335d-1*t300*t32*t383*t626+4.0d+0*t194*t409*t538*
     :         t59+2.0d+0*t314*t409*t416*t59+6.327946666666665d-1*t221*t
     ;         222*t35*t36*t550+1.8909155555555557d-1*t214*t28*t386*t547
     <         +9.454577777777778d-2*t151*t167*t211*t547+1.0546577777777
     =         776d-1*t169*t38*t546+2.4256332674106634d-2*t1*t167*t214*t
     >         3*t300*t386*t542-6.064083168526658d-3*t1*t211*t3*t300*t38
     ?         1*t542-4.0d+0*t188*t195*t538-6.582123138408225d-2*gammaaa
     @         *t16*t17*t185*t25*t391*t534-1.75523283690886d-1*gammaaa*t
     1         152*t17*t186*t25*t534+6.582123138408225d-2*gammaaa*t16*t1
     2         65*t186*t25*t534-6.582123138408225d-2*gammaaa*t16*t162*t1
     3         63*t17*t186*t534+1.0546577777777776d-1*t216*t38*t527+1.89
     4         09155555555557d-1*t167*t32*t382*t526+9.454577777777778d-2
     5         *t151*t211*t214*t526-4.0d+0*t194*t195*t526-1.755232836908
     6         86d-1*gammaaa*t152*t25*t52*t525-6.582123138408225d-2*gamm
     7         aaa*t16*t162*t163*t52*t525+6.582123138408225d-2*gammaaa*t
     8         16*t185*t186*t25*t525+1.316424627681645d-1*gammaaa*t16*t1
     9         62*t17*t366*t52*t524+1.75523283690886d-1*gammaaa*t152*t16
     :         3*t17*t52*t524-6.582123138408225d-2*gammaaa*t16*t163*t165
     ;         *t52*t524-6.582123138408225d-2*gammaaa*t16*t163*t17*t185*
     <         t186*t524+5.333333333333333d+0*t209*t221*t222*t522-3.2910
     =         615692041123d-2*gammaaa*t16*t163*t298*t379*t52+3.29106156
     >         92041123d-2*t16*t25*t379*t52+6.582123138408225d-2*gammaaa
     ?         *t16*t17*t298*t366*t376*t52-3.2910615692041123d-2*gammaaa
     @         *t16*t163*t299*t376*t52-3.2910615692041123d-2*t16*t163*t1
     1         7*t376*t52+6.582123138408225d-2*gammaaa*t16*t299*t365*t36
     2         6*t52+6.582123138408225d-2*t16*t17*t365*t366*t52-3.510465
     3         67381772d-1*gammaaa*t152*t162*t17*t298*t366*t52+1.3164246
     4         27681645d-1*gammaaa*t16*t162*t165*t298*t366*t52+3.2179268
     5         67666243d-1*gammaaa*t25*t299*t361*t52-3.217926867666243d-
     6         1*gammaaa*t163*t17*t298*t361*t52+3.217926867666243d-1*t17
     7         *t25*t361*t52+1.75523283690886d-1*gammaaa*t152*t162*t163*
     8         t299*t52+1.75523283690886d-1*gammaaa*t152*t163*t165*t298*
     9         t52-1.75523283690886d-1*t152*t165*t25*t52+1.7552328369088
     :         6d-1*t152*t162*t163*t17*t52-6.582123138408225d-2*t16*t162
     ;         *t163*t165*t52+3.1639733333333325d-1*t222*t321*t35*t36*t4
     <         38-1.2128166337053317d-2*t1*t3*t300*t318*t386*t435+4.7272
     =         88888888889d-2*t151*t211*t300*t435+5.273288888888887d-2*t
     >         302*t38*t434-2.0d+0*t195*t300*t416+2.0d+0*t300*t408*t409+
     ?         4.0d+0*t188*t194*t314*t409-2.0d+0*t195*t314*t407-3.291061
     @         5692041123d-2*gammaaa*t16*t17*t25*t308*t391*t406+3.291061
     1         5692041123d-2*gammaaa*t16*t186*t25*t299*t406-3.2910615692
     2         041123d-2*gammaaa*t16*t163*t17*t186*t298*t406+3.291061569
     3         2041123d-2*t16*t17*t186*t25*t406-3.2910615692041123d-2*ga
     4         mmaaa*t16*t25*t299*t390*t391+3.2910615692041123d-2*gammaa
     5         a*t16*t163*t17*t298*t390*t391-3.2910615692041123d-2*t16*t
     6         17*t25*t390*t391+1.75523283690886d-1*gammaaa*t152*t17*t18
     7         5*t25*t308*t391-6.582123138408225d-2*gammaaa*t16*t165*t18
     8         5*t25*t308*t391+6.582123138408225d-2*gammaaa*t16*t162*t16
     9         3*t17*t185*t308*t391-1.265589333333333d+0*t321*t35*t36*t3
     :         88*t389+3.1639733333333325d-1*t222*t302*t36*t388-2.029344
     ;         71398928d-2*t1*t213*t222*t3*t300*t35*t388-9.4545777777777
     <         78d-2*t151*t300*t386*t387-3.3822411899821336d-3*t1*t213*t
     =         3*t300*t38*t385+9.454577777777778d-2*t300*t32*t381*t382-1
     >         .8909155555555557d-1*t167*t211*t214*t300*t382+3.291061569
     ?         2041123d-2*gammaaa*t16*t186*t25*t308*t379-3.2910615692041
     @         123d-2*gammaaa*t16*t163*t17*t186*t308*t376+6.582123138408
     1         225d-2*gammaaa*t16*t17*t186*t308*t365*t366+1.316424627681
     2         645d-1*gammaaa*t16*t162*t17*t185*t186*t298*t366+3.2179268
     3         67666243d-1*gammaaa*t17*t186*t25*t308*t361+6.327946666666
     4         665d-1*t169*t221*t222*t321*t36+6.327946666666665d-1*t216*
     5         t221*t222*t321*t35+5.333333333333333d+0*t220*t221*t222*t3
     6         27+5.333333333333333d+0*t209*t220*t222*t321-1.75523283690
     7         886d-1*gammaaa*t152*t165*t186*t25*t308+1.75523283690886d-
     8         1*gammaaa*t152*t162*t163*t17*t186*t308-6.582123138408225d
     9         -2*gammaaa*t16*t162*t163*t165*t186*t308-1.75523283690886d
     :         -1*gammaaa*t152*t185*t186*t25*t299-6.582123138408225d-2*g
     ;         ammaaa*t16*t162*t163*t185*t186*t299+1.75523283690886d-1*g
     <         ammaaa*t152*t163*t17*t185*t186*t298-6.582123138408225d-2*
     =         gammaaa*t16*t163*t165*t185*t186*t298-1.75523283690886d-1*
     >         t152*t17*t185*t186*t25+6.582123138408225d-2*t16*t165*t185
     ?         *t186*t25-6.582123138408225d-2*t16*t162*t163*t17*t185*t18
     @         6)-4.135669939329333d-1*t40*(-8.888888888888888d-1*t324*t
     1         72*t73+t523+t521+t520+t519+t322+t320+t319+t317+t315+t311+
     2         t309+t304+t303+t301)-2.4814019635975998d+0*t2*t551)*wght+
     3         Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_RA_GAB) = Cmat3(iq,D3_RA_RA_GAB)
            Cmat3(iq,D3_RA_RA_GBB) = Cmat3(iq,D3_RA_RA_GBB)
            Cmat3(iq,D3_RA_RB_GAA) = Cmat3(iq,D3_RA_RB_GAA)
            Cmat3(iq,D3_RA_RB_GAB) = Cmat3(iq,D3_RA_RB_GAB)
            Cmat3(iq,D3_RA_RB_GBB) = Cmat3(iq,D3_RA_RB_GBB)
            Cmat3(iq,D3_RB_RB_GAA) = Cmat3(iq,D3_RB_RB_GAA)
            Cmat3(iq,D3_RB_RB_GAB) = Cmat3(iq,D3_RB_RB_GAB)
            Cmat3(iq,D3_RB_RB_GBB) = (-9.305257363491d-1*t97*(-8.8888888
     1         88888888d-1*t146*t147*(4.9365923538061685d-2*t1*t105*t78*
     2         (3.333333333333333d-1*t1*t286*t559*t98-5.0d-1*t1*t240*t33
     3         2*t350*t98-5.0d-1*t1*t286*t78*t862-1.875d+0*t1*t332*t462*
     4         t575*t78+1.5d+0*t1*t240*t350*t559*t78+7.5d-1*t1*t332*t350
     5         *t460*t78-2.222222222222222d-1*t1*t234*t286*t332)+9.62086
     6         8288978164d-2*t1*t286*t559*t98-1.4431302433467247d-1*t1*t
     7         240*t332*t350*t98-1.4431302433467247d-1*t1*t286*t78*t862-
     8         5.411738412550218d-1*t1*t332*t462*t575*t78+4.329390730040
     9         174d-1*t1*t240*t350*t559*t78-2.4682961769030842d-2*t1*t28
     :         6*t332*t515*t78+2.164695365020087d-1*t1*t332*t350*t460*t7
     ;         8+9.873184707612337d-2*t292*t581-6.413912192652109d-2*t1*
     <         t234*t286*t332)+5.273288888888887d-2*t110*t113*(4.2759414
     =         617680735d-2*t1*t286*t559*t98-6.41391219265211d-2*t1*t240
     >         *t332*t350*t98-6.41391219265211d-2*t1*t286*t78*t862-2.405
     ?         2170722445415d-1*t1*t332*t462*t575*t78+1.924173657795633d
     @         -1*t1*t240*t350*t559*t78+9.620868288978166d-2*t1*t332*t35
     1         0*t460*t78-2.8506276411787157d-2*t1*t234*t286*t332)-8.888
     2         888888888888d-1*t147*t149*(-2.4d+0*t142*(6.41391219265211
     3         d-2*t279*(-gammabb*t236*t860*t91*t92-6*gammabb*t330*t444*
     4         t783*t91*t92+4*gammabb*t235*t445*t557*t91*t92+2*gammabb*t
     5         330*t445*t455*t91*t92-t236*t455*t91*t92+2*t444*t445*t91*t
     6         92+5.333333333333333d+0*gammabb*t225*t236*t557*t92-1.0666
     7         666666666666d+1*gammabb*t225*t235*t330*t445*t92-9.7777777
     8         77777779d+0*gammabb*t236*t330*t440*t92+9.777777777777779d
     9         +0*t100*t440*t92+5.333333333333333d+0*t225*t235*t236*t92+
     :         gammabb*t100*t861*t91-2*gammabb*t235*t236*t558*t91-2*gamm
     ;         abb*t236*t238*t557*t91-gammabb*t236*t330*t458*t91+t100*t4
     <         58*t91-gammabb*t236*t331*t455*t91+2*gammabb*t331*t444*t44
     =         5*t91+4*gammabb*t235*t238*t330*t445*t91-2*t235*t236*t238*
     >         t91-5.333333333333333d+0*gammabb*t100*t225*t558+9.7777777
     ?         77777779d+0*gammabb*t100*t331*t440+5.333333333333333d+0*g
     @         ammabb*t225*t235*t236*t331+5.333333333333333d+0*gammabb*t
     1         225*t236*t238*t330-5.333333333333333d+0*t100*t225*t238)-5
     2         .0d-1*t278*t862-3.75d-1*t332*t505*t836+4.810434144489083d
     3         -2*t357*t508*t835-6.41391219265211d-2*t280*t507*t576+5.0d
     4         -1*t261*t509*t559-3.206956096326055d-2*t357*t507*t510+2.5
     5         d-1*t332*t486*t509)+4.7459599999999996d-2*t140*t863-8.400
     6         000000000001d+0*t145*t277*t862-4.9628707825354457d+0*t277
     7         *t862-2.7259596d+0*t141*t862+5.672746666666666d-2*t140*t8
     8         62+4.7459599999999996d-2*t110*t862-3.15d+1*t145*t332*t505
     9         *t834-1.8610765434507923d+1*t332*t505*t834-1.68d+1*t261*t
     :         277*t577+9.491919999999999d-2*t261*t560-4.2d+1*t145*t261*
     ;         t506*t559-2.481435391267723d+1*t261*t506*t559-1.68d+1*t27
     <         7*t281*t559-1.0903838400000002d+1*t140*t261*t559+1.134549
     =         3333333331d-1*t261*t559+9.491919999999999d-2*t242*t559-8.
     >         400000000000001d+0*t277*t332*t511-2.1d+1*t358*t505*t506-2
     ?         .1d+1*t145*t332*t486*t506-1.2407176956338616d+1*t332*t486
     @         *t506-4.2d+1*t261*t281*t332*t506-5.4519192d+0*t332*t505-8
     1         .400000000000001d+0*t277*t358*t486+4.7459599999999996d-2*
     2         t334*t486-5.4519192d+0*t140*t332*t486+5.672746666666666d-
     3         2*t332*t486+4.7459599999999996d-2*t332*t464)+7.57211d-1*(
     4         -1.6455307846020562d-2*gammabb*t100*t139*t273*t877*t91*t9
     5         2-1.6455307846020562d-2*gammabb*t100*t135*t275*(t872+t871
     6         +t870+t869)*t91*t92-1.6455307846020562d-2*gammabb*t135*t1
     7         39*t236*t860*t91*t92-4.9365923538061685d-2*gammabb*t100*t
     8         135*t254*t332*t502*t832*t91*t92-9.873184707612337d-2*gamm
     9         abb*t100*t139*t348*t499*t830*t91*t92-9.873184707612337d-2
     :         *gammabb*t135*t139*t330*t444*t783*t91*t92+6.5821231384082
     ;         25d-2*gammabb*t100*t135*t274*t503*t574*t91*t92+3.29106156
     <         92041123d-2*gammabb*t100*t272*t273*t275*t574*t91*t92+3.29
     =         10615692041123d-2*gammabb*t135*t235*t236*t275*t574*t91*t9
     >         2+6.582123138408225d-2*gammabb*t100*t139*t272*t500*t573*t
     ?         91*t92+3.2910615692041123d-2*gammabb*t100*t273*t274*t275*
     @         t573*t91*t92+3.2910615692041123d-2*gammabb*t139*t235*t236
     1         *t273*t573*t91*t92+6.582123138408225d-2*gammabb*t135*t139
     2         *t235*t445*t557*t91*t92+3.2910615692041123d-2*gammabb*t13
     3         5*t236*t274*t275*t557*t91*t92+3.2910615692041123d-2*gamma
     4         bb*t139*t236*t272*t273*t557*t91*t92+1.6455307846020562d-2
     5         *gammabb*t100*t135*t254*t332*t503*t504*t91*t92+1.64553078
     6         46020562d-2*gammabb*t100*t273*t275*t348*t504*t91*t92+1.64
     7         55307846020562d-2*gammabb*t135*t236*t275*t330*t504*t91*t9
     8         2-1.6455307846020562d-2*t100*t135*t275*t504*t91*t92-3.291
     9         0615692041123d-2*gammabb*t100*t273*t348*t502*t503*t91*t92
     :         -3.2910615692041123d-2*gammabb*t135*t236*t330*t502*t503*t
     ;         91*t92+3.2910615692041123d-2*t100*t135*t502*t503*t91*t92-
     <         3.2910615692041123d-2*gammabb*t100*t254*t272*t273*t274*t3
     =         32*t503*t91*t92-3.2910615692041123d-2*gammabb*t135*t235*t
     >         236*t254*t274*t332*t503*t91*t92+3.2910615692041123d-2*gam
     ?         mabb*t100*t139*t348*t500*t501*t91*t92+8.227653923010281d-
     @         3*gammabb*t100*t254*t273*t275*t332*t501*t91*t92+1.6455307
     1         846020562d-2*gammabb*t139*t236*t273*t330*t501*t91*t92-1.6
     2         455307846020562d-2*t100*t139*t273*t501*t91*t92-1.64553078
     3         46020562d-2*gammabb*t100*t254*t275*t332*t499*t500*t91*t92
     4         -3.2910615692041123d-2*gammabb*t139*t236*t330*t499*t500*t
     5         91*t92+3.2910615692041123d-2*t100*t139*t499*t500*t91*t92-
     6         6.582123138408225d-2*gammabb*t100*t272*t274*t275*t348*t50
     7         0*t91*t92-6.582123138408225d-2*gammabb*t139*t235*t236*t27
     8         2*t348*t500*t91*t92+3.2910615692041123d-2*gammabb*t135*t1
     9         39*t330*t445*t455*t91*t92+1.6455307846020562d-2*gammabb*t
     :         139*t236*t273*t348*t455*t91*t92+8.227653923010281d-3*gamm
     ;         abb*t135*t236*t254*t275*t332*t455*t91*t92-1.6455307846020
     <         562d-2*t135*t139*t236*t455*t91*t92-3.2910615692041123d-2*
     =         gammabb*t139*t273*t348*t444*t445*t91*t92-1.64553078460205
     >         62d-2*gammabb*t135*t254*t275*t332*t444*t445*t91*t92+3.291
     ?         0615692041123d-2*t135*t139*t444*t445*t91*t92-6.5821231384
     @         08225d-2*gammabb*t135*t235*t274*t275*t330*t445*t91*t92-6.
     1         582123138408225d-2*gammabb*t139*t235*t272*t273*t330*t445*
     2         t91*t92-3.2910615692041123d-2*gammabb*t235*t236*t273*t274
     3         *t275*t348*t91*t92-1.6455307846020562d-2*gammabb*t235*t23
     4         6*t254*t272*t273*t275*t332*t91*t92-3.2910615692041123d-2*
     5         gammabb*t236*t272*t273*t274*t275*t330*t91*t92+3.291061569
     6         2041123d-2*t100*t272*t273*t274*t275*t91*t92+3.29106156920
     7         41123d-2*t135*t235*t236*t274*t275*t91*t92+3.2910615692041
     8         123d-2*t139*t235*t236*t272*t273*t91*t92+8.7761641845443d-
     9         2*gammabb*t100*t135*t225*t275*t574*t92+8.7761641845443d-2
     :         *gammabb*t100*t139*t225*t273*t573*t92+8.7761641845443d-2*
     ;         gammabb*t135*t139*t225*t236*t557*t92-8.7761641845443d-2*g
     <         ammabb*t100*t135*t225*t254*t274*t332*t503*t92-1.755232836
     =         90886d-1*gammabb*t100*t139*t225*t272*t348*t500*t92-1.7552
     >         3283690886d-1*gammabb*t135*t139*t225*t235*t330*t445*t92-1
     ?         .6089634338331216d-1*gammabb*t100*t139*t273*t348*t440*t92
     @         -8.044817169165608d-2*gammabb*t100*t135*t254*t275*t332*t4
     1         40*t92-1.6089634338331216d-1*gammabb*t135*t139*t236*t330*
     2         t440*t92+1.6089634338331216d-1*t100*t135*t139*t440*t92-8.
     3         7761641845443d-2*gammabb*t100*t225*t273*t274*t275*t348*t9
     4         2-8.7761641845443d-2*gammabb*t139*t225*t235*t236*t273*t34
     5         8*t92-4.38808209227215d-2*gammabb*t100*t225*t254*t272*t27
     6         3*t275*t332*t92-4.38808209227215d-2*gammabb*t135*t225*t23
     7         5*t236*t254*t275*t332*t92-8.7761641845443d-2*gammabb*t135
     8         *t225*t236*t274*t275*t330*t92-8.7761641845443d-2*gammabb*
     9         t139*t225*t236*t272*t273*t330*t92+8.7761641845443d-2*t100
     :         *t135*t225*t274*t275*t92+8.7761641845443d-2*t100*t139*t22
     ;         5*t272*t273*t92+8.7761641845443d-2*t135*t139*t225*t235*t2
     <         36*t92+1.6455307846020562d-2*gammabb*t100*t135*t139*t861*
     =         t91-3.2910615692041123d-2*gammabb*t100*t135*t238*t275*t57
     >         4*t91-3.2910615692041123d-2*gammabb*t100*t139*t238*t273*t
     ?         573*t91-3.2910615692041123d-2*gammabb*t100*t135*t274*t275
     @         *t558*t91-3.2910615692041123d-2*gammabb*t100*t139*t272*t2
     1         73*t558*t91-3.2910615692041123d-2*gammabb*t135*t139*t235*
     2         t236*t558*t91-3.2910615692041123d-2*gammabb*t135*t139*t23
     3         6*t238*t557*t91-1.6455307846020562d-2*gammabb*t100*t135*t
     4         275*t331*t504*t91+3.2910615692041123d-2*gammabb*t100*t135
     5         *t331*t502*t503*t91+3.2910615692041123d-2*gammabb*t100*t1
     6         35*t238*t254*t274*t332*t503*t91-1.6455307846020562d-2*gam
     7         mabb*t100*t139*t273*t331*t501*t91+3.2910615692041123d-2*g
     8         ammabb*t100*t139*t331*t499*t500*t91+6.582123138408225d-2*
     9         gammabb*t100*t139*t238*t272*t348*t500*t91-1.6455307846020
     :         562d-2*gammabb*t100*t139*t273*t348*t458*t91-8.22765392301
     ;         0281d-3*gammabb*t100*t135*t254*t275*t332*t458*t91-1.64553
     <         07846020562d-2*gammabb*t135*t139*t236*t330*t458*t91+1.645
     =         5307846020562d-2*t100*t135*t139*t458*t91-1.64553078460205
     >         62d-2*gammabb*t135*t139*t236*t331*t455*t91+3.291061569204
     ?         1123d-2*gammabb*t135*t139*t331*t444*t445*t91+6.5821231384
     @         08225d-2*gammabb*t135*t139*t235*t238*t330*t445*t91+3.2910
     1         615692041123d-2*gammabb*t100*t238*t273*t274*t275*t348*t91
     2         +3.2910615692041123d-2*gammabb*t139*t235*t236*t238*t273*t
     3         348*t91+1.6455307846020562d-2*gammabb*t100*t238*t254*t272
     4         *t273*t275*t332*t91+1.6455307846020562d-2*gammabb*t135*t2
     5         35*t236*t238*t254*t275*t332*t91+3.2910615692041123d-2*gam
     6         mabb*t100*t272*t273*t274*t275*t331*t91+3.2910615692041123
     7         d-2*gammabb*t135*t235*t236*t274*t275*t331*t91+3.291061569
     8         2041123d-2*gammabb*t139*t235*t236*t272*t273*t331*t91+3.29
     9         10615692041123d-2*gammabb*t135*t236*t238*t274*t275*t330*t
     :         91+3.2910615692041123d-2*gammabb*t139*t236*t238*t272*t273
     ;         *t330*t91-3.2910615692041123d-2*t100*t135*t238*t274*t275*
     <         t91-3.2910615692041123d-2*t100*t139*t238*t272*t273*t91-3.
     =         2910615692041123d-2*t135*t139*t235*t236*t238*t91-t133*t13
     >         7*t273*t877-t133*t135*t271*(t876+t875+t874+t873)+t135*t13
     ?         7*t862-6*t133*t137*t348*t499*t830-3*t133*t135*t263*t332*t
     @         496*t828+4*t133*t137*t272*t500*t573+2*t133*t270*t271*t273
     1         *t573-2*t137*t261*t273*t573+4*t133*t135*t270*t497*t572+2*
     2         t133*t271*t272*t273*t572-2*t135*t261*t271*t572-2*t137*t27
     3         2*t273*t559-2*t135*t270*t271*t559-8.7761641845443d-2*gamm
     4         abb*t100*t135*t139*t225*t558+2*t133*t137*t348*t500*t501+5
     5         .0d-1*t133*t263*t271*t273*t332*t501-t137*t273*t332*t501-t
     6         133*t263*t271*t332*t499*t500+2*t137*t332*t499*t500-4*t133
     7         *t270*t271*t272*t348*t500+4*t137*t261*t272*t348*t500+t133
     8         *t135*t263*t332*t497*t498+t133*t271*t273*t348*t498-t135*t
     9         271*t332*t498-2*t133*t273*t348*t496*t497+2*t135*t332*t496
     :         *t497-2*t133*t263*t270*t272*t273*t332*t497+2*t135*t261*t2
     ;         63*t270*t332*t497-t137*t273*t348*t486-5.0d-1*t135*t263*t2
     <         71*t332*t486+1.6089634338331216d-1*gammabb*t100*t135*t139
     =         *t331*t440+2*t261*t270*t271*t273*t348+8.7761641845443d-2*
     >         gammabb*t100*t139*t225*t238*t273*t348+4.38808209227215d-2
     ?         *gammabb*t100*t135*t225*t238*t254*t275*t332+2*t270*t271*t
     @         272*t273*t332+t261*t263*t271*t272*t273*t332+8.77616418454
     1         43d-2*gammabb*t100*t135*t225*t274*t275*t331+8.77616418454
     2         43d-2*gammabb*t100*t139*t225*t272*t273*t331+8.77616418454
     3         43d-2*gammabb*t135*t139*t225*t235*t236*t331+8.77616418454
     4         43d-2*gammabb*t135*t139*t225*t236*t238*t330-8.77616418454
     5         43d-2*t100*t135*t139*t225*t238)+3.2910615692041123d-2*gam
     6         mabb*t100*t259*(6.0965d-1*t124*t257*(t872+t871+t870+t869+
     7         t867+t866+t865+t864)+6.0965d-1*t121*t253*t868+3.6579d+0*t
     8         124*t339*t479*t816+1.82895d+0*t121*t249*t332*t471*t808-2.
     9         4386000000000002d+0*t124*t256*t480*t566-1.219300000000000
     :         1d+0*t252*t253*t257*t566-2.4386000000000002d+0*t121*t252*
     ;         t472*t563-1.2193000000000001d+0*t253*t256*t257*t563-1.219
     <         3000000000001d+0*t124*t339*t480*t484-3.04825d-1*t249*t253
     =         *t257*t332*t484+6.0965d-1*t249*t253*t332*t479*t480+2.4386
     >         000000000002d+0*t252*t253*t256*t339*t480-6.0965d-1*t121*t
     ?         249*t332*t472*t478-6.0965d-1*t253*t257*t339*t478+1.219300
     @         0000000001d+0*t257*t339*t471*t472+1.2193000000000001d+0*t
     1         249*t252*t256*t257*t332*t472)*t91*t92-3.2910615692041123d
     2         -2*gammabb*t126*t236*t860*t91*t92+6.582123138408225d-2*ga
     3         mmabb*t100*t340*t469*t806*t91*t92-1.9746369415224674d-1*g
     4         ammabb*t126*t330*t444*t783*t91*t92-6.582123138408225d-2*g
     5         ammabb*t100*t258*t470*t567*t91*t92-6.582123138408225d-2*g
     6         ammabb*t235*t236*t259*t567*t91*t92+1.316424627681645d-1*g
     7         ammabb*t126*t235*t445*t557*t91*t92-6.582123138408225d-2*g
     8         ammabb*t236*t258*t259*t557*t91*t92-3.2910615692041123d-2*
     9         gammabb*t100*t340*t470*t485*t91*t92-3.2910615692041123d-2
     :         *gammabb*t236*t259*t330*t485*t91*t92+3.2910615692041123d-
     ;         2*t100*t259*t485*t91*t92+3.2910615692041123d-2*gammabb*t2
     <         36*t330*t469*t470*t91*t92-3.2910615692041123d-2*t100*t469
     =         *t470*t91*t92+6.582123138408225d-2*gammabb*t235*t236*t258
     >         *t340*t470*t91*t92+6.582123138408225d-2*gammabb*t126*t330
     ?         *t445*t455*t91*t92-3.2910615692041123d-2*gammabb*t236*t25
     @         9*t340*t455*t91*t92-3.2910615692041123d-2*t126*t236*t455*
     1         t91*t92+6.582123138408225d-2*gammabb*t259*t340*t444*t445*
     2         t91*t92+6.582123138408225d-2*t126*t444*t445*t91*t92+1.316
     3         424627681645d-1*gammabb*t235*t258*t259*t330*t445*t91*t92-
     4         6.582123138408225d-2*t235*t236*t258*t259*t91*t92-1.755232
     5         83690886d-1*gammabb*t100*t225*t259*t567*t92+1.75523283690
     6         886d-1*gammabb*t126*t225*t236*t557*t92+1.75523283690886d-
     7         1*gammabb*t100*t225*t258*t340*t470*t92-3.51046567381772d-
     8         1*gammabb*t126*t225*t235*t330*t445*t92+3.217926867666243d
     9         -1*gammabb*t100*t259*t340*t440*t92-3.217926867666243d-1*g
     :         ammabb*t126*t236*t330*t440*t92+3.217926867666243d-1*t100*
     ;         t126*t440*t92+1.75523283690886d-1*gammabb*t225*t235*t236*
     <         t259*t340*t92+1.75523283690886d-1*gammabb*t225*t236*t258*
     =         t259*t330*t92-1.75523283690886d-1*t100*t225*t258*t259*t92
     >         +1.75523283690886d-1*t126*t225*t235*t236*t92+3.2910615692
     ?         041123d-2*gammabb*t100*t126*t861*t91+6.582123138408225d-2
     @         *gammabb*t100*t238*t259*t567*t91+6.582123138408225d-2*gam
     1         mabb*t100*t258*t259*t558*t91-6.582123138408225d-2*gammabb
     2         *t126*t235*t236*t558*t91-6.582123138408225d-2*gammabb*t12
     3         6*t236*t238*t557*t91+3.2910615692041123d-2*gammabb*t100*t
     4         259*t331*t485*t91-3.2910615692041123d-2*gammabb*t100*t331
     5         *t469*t470*t91-6.582123138408225d-2*gammabb*t100*t238*t25
     6         8*t340*t470*t91+3.2910615692041123d-2*gammabb*t100*t259*t
     7         340*t458*t91-3.2910615692041123d-2*gammabb*t126*t236*t330
     8         *t458*t91+3.2910615692041123d-2*t100*t126*t458*t91-3.2910
     9         615692041123d-2*gammabb*t126*t236*t331*t455*t91+6.5821231
     :         38408225d-2*gammabb*t126*t331*t444*t445*t91+1.31642462768
     ;         1645d-1*gammabb*t126*t235*t238*t330*t445*t91-6.5821231384
     <         08225d-2*gammabb*t235*t236*t238*t259*t340*t91-6.582123138
     =         408225d-2*gammabb*t235*t236*t258*t259*t331*t91-6.58212313
     >         8408225d-2*gammabb*t236*t238*t258*t259*t330*t91+6.5821231
     ?         38408225d-2*t100*t238*t258*t259*t91-6.582123138408225d-2*
     @         t126*t235*t236*t238*t91+2.6666666666666666d+0*t146*t149*t
     1         295*t880-1.0546577777777776d-1*t110*t111*t147*t880-4.7272
     2         88888888889d-2*t103*t284*t879+1.2128166337053317d-2*t1*t2
     3         84*t332*t462*t78*t878-2.0d+0*t133*t268*(-1.47560999999999
     4         9d-1*t124*t266*(t876+t875+t874+t873+t867+t866+t865+t864)-
     5         1.475609999999999d-1*t130*t253*t868-8.853659999999993d-1*
     6         t124*t345*t489*t823-4.4268299999999966d-1*t130*t249*t332*
     7         t471*t808+5.902439999999995d-1*t124*t265*t490*t570+2.9512
     8         19999999998d-1*t252*t253*t266*t570+5.902439999999995d-1*t
     9         130*t252*t472*t563+2.951219999999998d-1*t253*t265*t266*t5
     :         63+2.951219999999998d-1*t124*t345*t490*t494+7.37804999999
     ;         9994d-2*t249*t253*t266*t332*t494-1.475609999999999d-1*t24
     <         9*t253*t332*t489*t490-5.902439999999995d-1*t252*t253*t265
     =         *t345*t490+1.475609999999999d-1*t130*t249*t332*t472*t478+
     >         1.475609999999999d-1*t253*t266*t345*t478-2.95121999999999
     ?         8d-1*t266*t345*t471*t472-2.951219999999998d-1*t249*t252*t
     @         265*t266*t332*t472)+5.273288888888887d-2*t111*t113*t863-4
     1         .727288888888889d-2*t107*t224*t862-2.0d+0*t132*t862-4.0d+
     2         0*t133*t346*t487*t822+5.333333333333333d+1*t146*t149*t353
     3         *t467*t805+3.6384499011159954d-2*t1*t332*t350*t466*t78*t8
     4         03+2.4256332674106634d-2*t1*t240*t287*t332*t465*t575*t78-
     5         6.064083168526658d-3*t1*t284*t332*t460*t575*t78+6.7644823
     6         79964267d-3*t1*t110*t147*t286*t332*t517*t78-1.21281663370
     7         53317d-2*t1*t332*t350*t465*t514*t78-2.02934471398928d-2*t
     8         1*t110*t286*t295*t332*t467*t78-3.3822411899821336d-3*t1*t
     9         113*t286*t332*t464*t78+1.3528964759928536d-2*t1*t147*t242
     :         *t286*t294*t332*t78-2.8363733333333335d-1*t107*t332*t462*
     ;         t686-2.1333333333333332d+1*t146*t149*t294*t468*t583+6.327
     <         946666666665d-1*t110*t111*t294*t295*t583+5.33333333333333
     =         3d+0*t146*t293*t295*t583+5.333333333333333d+0*t149*t282*t
     >         295*t583-2.109315555555555d-1*t110*t147*t289*t583-2.10931
     ?         5555555555d-1*t111*t147*t242*t583+5.333333333333333d+0*t1
     @         46*t294*t295*t582-1.7777777777777776d+0*t147*t282*t582+1.
     1         8909155555555557d-1*t103*t287*t465*t580+9.454577777777778
     2         d-2*t224*t240*t284*t580-2.109315555555555d-1*t110*t147*t2
     3         94*t579+1.0546577777777776d-1*t113*t242*t579+5.3333333333
     4         33333d+0*t149*t294*t295*t578-1.7777777777777776d+0*t147*t
     5         293*t578+4.0d+0*t133*t267*t488*t571-4.0d+0*t261*t268*t571
     6         -2.109315555555555d-1*t111*t147*t294*t560+1.0546577777777
     7         776d-1*t113*t289*t560+1.8909155555555557d-1*t107*t240*t46
     8         1*t559+9.454577777777778d-2*t224*t284*t287*t559-4.0d+0*t2
     9         67*t268*t559-1.75523283690886d-1*gammabb*t100*t126*t225*t
     :         558+2.6666666666666666d+0*t146*t295*t517*t555-8.888888888
     ;         888888d-1*t147*t512*t555-1.0666666666666666d+1*t146*t467*
     <         t468*t555+5.333333333333333d+0*t282*t294*t295*t555-1.0666
     =         666666666666d+1*t146*t149*t353*t468*t517+2.66666666666666
     >         66d+0*t149*t295*t359*t517+3.1639733333333325d-1*t110*t111
     ?         *t295*t353*t517-1.0546577777777776d-1*t111*t147*t334*t517
     @         -8.888888888888888d-1*t147*t359*t516+2.6666666666666666d+
     1         0*t146*t295*t353*t516+4.727288888888889d-2*t224*t284*t332
     2         *t514-1.0546577777777776d-1*t110*t147*t353*t513+5.2732888
     3         88888887d-2*t113*t334*t513+2.6666666666666666d+0*t149*t29
     4         5*t353*t512+2.0d+0*t133*t346*t488*t495-2.0d+0*t268*t332*t
     5         495+2.0d+0*t332*t487*t488+4.0d+0*t261*t267*t346*t488-2.0d
     6         +0*t268*t346*t486-1.0666666666666666d+1*t149*t359*t467*t4
     7         68-1.265589333333333d+0*t110*t111*t353*t467*t468-2.133333
     8         3333333332d+1*t146*t293*t294*t353*t468-2.1333333333333332
     9         d+1*t149*t282*t294*t353*t468+3.1639733333333325d-1*t111*t
     :         295*t334*t467-9.454577777777778d-2*t224*t332*t465*t466-1.
     ;         0546577777777776d-1*t111*t147*t353*t464+9.454577777777778
     <         d-2*t107*t332*t460*t461-1.8909155555555557d-1*t240*t284*t
     =         287*t332*t461+3.217926867666243d-1*gammabb*t100*t126*t331
     >         *t440+5.333333333333333d+0*t293*t294*t295*t359+6.32794666
     ?         6666665d-1*t110*t289*t294*t295*t353+6.327946666666665d-1*
     @         t111*t242*t294*t295*t353+5.333333333333333d+0*t282*t293*t
     1         295*t353-2.109315555555555d-1*t147*t242*t289*t353-1.75523
     2         283690886d-1*gammabb*t100*t225*t238*t259*t340-2.109315555
     3         555555d-1*t147*t289*t294*t334-1.75523283690886d-1*gammabb
     4         *t100*t225*t258*t259*t331+1.75523283690886d-1*gammabb*t12
     5         6*t225*t235*t236*t331+1.75523283690886d-1*gammabb*t126*t2
     6         25*t236*t238*t330-1.75523283690886d-1*t100*t126*t225*t238
     7         )-2.4814019635975998d+0*t584*t77-4.135669939329333d-1*t11
     8         4*(t556+t554+t553+t552-8.888888888888888d-1*t146*t147*t35
     9         6+t354+t352+t351+t349+t347+t343+t341+t336+t335+t333))*wgh
     :         t+Cmat3(iq,D3_RB_RB_GBB)
            Cmat3(iq,D3_RA_GAA_GAA) = (-9.305257363491d-1*t22*(2.6666666
     1         666666666d+0*t222*t72*t75*t901-1.0546577777777776d-1*t35*
     2         t36*t73*t901-4.727288888888889d-2*t211*t28*t900-1.5557798
     3         788747831d-3*t167*t386*t39*t40*t585*t899+7.57211d-1*(-1.6
     4         455307846020562d-2*gammaaa*t16*t17*t200*t25*t65*t898-t200
     5         *t59*t63*t898-t198*t59*t61*(t897+t896+t895+t894)-1.645530
     6         7846020562d-2*gammaaa*t16*t17*t202*t25*t61*(t893+t892+t89
     7         1+t890)+t61*t63*t883+1.6455307846020562d-2*gammaaa*t16*t2
     8         5*t61*t65*t882-1.6455307846020562d-2*gammaaa*t16*t163*t17
     9         *t61*t65*t881-2.4682961769030842d-2*gammaaa*t16*t17*t201*
     :         t25*t585*t61*t620*t765-9.873184707612337d-2*gammaaa*t16*t
     ;         17*t199*t25*t616*t65*t763-6*t199*t59*t616*t63*t763-1.5d+0
     <         *t197*t585*t59*t61*t615*t761-9.873184707612337d-2*gammaaa
     =         *t16*t162*t17*t587*t61*t65*t716+3.2910615692041123d-2*gam
     >         maaa*t16*t17*t199*t25*t421*t619*t65+4.38808209227215d-2*g
     ?         ammaaa*t152*t17*t200*t25*t619*t65-1.6455307846020562d-2*g
     @         ammaaa*t16*t165*t200*t25*t619*t65+1.6455307846020562d-2*g
     1         ammaaa*t16*t162*t163*t17*t200*t619*t65-8.7761641845443d-2
     2         *gammaaa*t152*t17*t25*t421*t616*t65+3.2910615692041123d-2
     3         *gammaaa*t16*t165*t25*t421*t616*t65-3.2910615692041123d-2
     4         *gammaaa*t16*t162*t163*t17*t421*t616*t65-4.38808209227215
     5         d-2*gammaaa*t152*t25*t590*t61*t65-1.6455307846020562d-2*g
     6         ammaaa*t16*t162*t163*t590*t61*t65+3.2910615692041123d-2*g
     7         ammaaa*t16*t162*t17*t366*t589*t61*t65+4.38808209227215d-2
     8         *gammaaa*t152*t163*t17*t589*t61*t65-1.6455307846020562d-2
     9         *gammaaa*t16*t163*t165*t589*t61*t65-8.7761641845443d-2*ga
     :         mmaaa*t152*t17*t366*t587*t61*t65+3.2910615692041123d-2*ga
     ;         mmaaa*t16*t165*t366*t587*t61*t65-3.2910615692041123d-2*ga
     <         mmaaa*t16*t163*t298*t525*t61*t65+3.2910615692041123d-2*t1
     =         6*t25*t525*t61*t65+6.582123138408225d-2*gammaaa*t16*t17*t
     >         298*t366*t524*t61*t65-3.2910615692041123d-2*gammaaa*t16*t
     ?         163*t299*t524*t61*t65-3.2910615692041123d-2*t16*t163*t17*
     @         t524*t61*t65+6.582123138408225d-2*gammaaa*t16*t162*t298*t
     1         299*t366*t61*t65+6.582123138408225d-2*t16*t162*t17*t298*t
     2         366*t61*t65+8.7761641845443d-2*gammaaa*t152*t163*t298*t29
     3         9*t61*t65-8.7761641845443d-2*t152*t25*t299*t61*t65-3.2910
     4         615692041123d-2*t16*t162*t163*t299*t61*t65+8.776164184544
     5         3d-2*t152*t163*t17*t298*t61*t65-3.2910615692041123d-2*t16
     6         *t163*t165*t298*t61*t65-1.6455307846020562d-2*gammaaa*t16
     7         *t199*t200*t25*t590*t65+1.6455307846020562d-2*gammaaa*t16
     8         *t163*t17*t199*t200*t589*t65-3.2910615692041123d-2*gammaa
     9         a*t16*t17*t199*t200*t366*t587*t65+6.582123138408225d-2*ga
     :         mmaaa*t16*t17*t25*t316*t421*t540*t65-3.2910615692041123d-
     ;         2*gammaaa*t16*t200*t25*t299*t540*t65+3.2910615692041123d-
     <         2*gammaaa*t16*t163*t17*t200*t298*t540*t65-3.2910615692041
     =         123d-2*t16*t17*t200*t25*t540*t65-3.2910615692041123d-2*ga
     >         mmaaa*t16*t200*t25*t316*t525*t65+3.2910615692041123d-2*ga
     ?         mmaaa*t16*t163*t17*t200*t316*t524*t65+6.582123138408225d-
     @         2*gammaaa*t16*t199*t25*t299*t316*t421*t65-6.5821231384082
     1         25d-2*gammaaa*t16*t163*t17*t199*t298*t316*t421*t65+6.5821
     2         23138408225d-2*t16*t17*t199*t25*t316*t421*t65-6.582123138
     3         408225d-2*gammaaa*t16*t162*t17*t200*t298*t316*t366*t65+8.
     4         7761641845443d-2*gammaaa*t152*t200*t25*t299*t316*t65+3.29
     5         10615692041123d-2*gammaaa*t16*t162*t163*t200*t299*t316*t6
     6         5-8.7761641845443d-2*gammaaa*t152*t163*t17*t200*t298*t316
     7         *t65+3.2910615692041123d-2*gammaaa*t16*t163*t165*t200*t29
     8         8*t316*t65+8.7761641845443d-2*t152*t17*t200*t25*t316*t65-
     9         3.2910615692041123d-2*t16*t165*t200*t25*t316*t65+3.291061
     :         5692041123d-2*t16*t162*t163*t17*t200*t316*t65+3.291061569
     ;         2041123d-2*gammaaa*t16*t163*t199*t200*t298*t299*t65-3.291
     <         0615692041123d-2*t16*t199*t200*t25*t299*t65+3.29106156920
     =         41123d-2*t16*t163*t17*t199*t200*t298*t65+2*t199*t421*t59*
     >         t619*t63-t188*t200*t619*t63+2*t188*t421*t616*t63-t199*t20
     ?         0*t591*t63+4*t316*t421*t540*t59*t63-2*t200*t300*t540*t63-
     @         2*t200*t316*t526*t63+4*t199*t300*t316*t421*t63-2.19404104
     1         6136075d-2*gammaaa*t152*t17*t25*t424*t585*t61*t620+8.2276
     2         53923010281d-3*gammaaa*t16*t165*t25*t424*t585*t61*t620-8.
     3         227653923010281d-3*gammaaa*t16*t162*t163*t17*t424*t585*t6
     4         1*t620-8.227653923010281d-3*gammaaa*t16*t17*t199*t200*t25
     5         *t424*t585*t620+t197*t198*t200*t59*t619+1.645530784602056
     6         2d-2*gammaaa*t16*t17*t200*t201*t202*t25*t619-2*t197*t198*
     7         t421*t59*t616-3.2910615692041123d-2*gammaaa*t16*t17*t201*
     8         t202*t25*t421*t616+5.0d-1*t188*t418*t585*t61*t615-5.0d-1*
     9         t199*t200*t418*t585*t59*t615+t190*t197*t418*t59*t591*t61+
     :         1.6455307846020562d-2*gammaaa*t16*t17*t181*t201*t25*t424*
     ;         t591*t61+2.194041046136075d-2*gammaaa*t152*t17*t181*t202*
     <         t25*t591*t61-8.227653923010281d-3*gammaaa*t16*t165*t181*t
     =         202*t25*t591*t61+8.227653923010281d-3*gammaaa*t16*t162*t1
     >         63*t17*t181*t202*t591*t61-t197*t198*t591*t61-5.0d-1*t188*
     ?         t190*t198*t591*t61-1.6455307846020562d-2*gammaaa*t16*t201
     @         *t202*t25*t590*t61-5.0d-1*t197*t412*t418*t585*t59*t61+2*t
     1         190*t300*t418*t539*t59*t61+1.6455307846020562d-2*gammaaa*
     2         t16*t163*t17*t201*t202*t589*t61-3.2910615692041123d-2*gam
     3         maaa*t16*t17*t201*t202*t366*t587*t61-8.227653923010281d-3
     4         *gammaaa*t16*t17*t201*t25*t402*t424*t585*t61+2*t190*t197*
     5         t418*t585*t61+2.5d-1*t188*t198*t412*t585*t61-1.0970205230
     6         680374d-2*gammaaa*t152*t17*t202*t25*t402*t585*t61+4.11382
     7         69615051404d-3*gammaaa*t16*t165*t202*t25*t402*t585*t61-4.
     8         1138269615051404d-3*gammaaa*t16*t162*t163*t17*t202*t402*t
     9         585*t61+3.2910615692041123d-2*gammaaa*t16*t17*t181*t25*t3
     :         00*t424*t541*t61-3.2910615692041123d-2*gammaaa*t16*t202*t
     ;         25*t299*t541*t61+3.2910615692041123d-2*gammaaa*t16*t163*t
     <         17*t202*t298*t541*t61-3.2910615692041123d-2*t16*t17*t202*
     =         t25*t541*t61-2*t198*t300*t539*t61-t190*t198*t300*t526*t61
     >         -1.6455307846020562d-2*gammaaa*t16*t181*t202*t25*t300*t52
     ?         5*t61+1.6455307846020562d-2*gammaaa*t16*t163*t17*t181*t20
     @         2*t300*t524*t61+3.2910615692041123d-2*gammaaa*t16*t181*t2
     1         01*t25*t299*t300*t424*t61-3.2910615692041123d-2*gammaaa*t
     2         16*t163*t17*t181*t201*t298*t300*t424*t61+3.29106156920411
     3         23d-2*t16*t17*t181*t201*t25*t300*t424*t61-3.2910615692041
     4         123d-2*gammaaa*t16*t162*t17*t181*t202*t298*t300*t366*t61+
     5         4.38808209227215d-2*gammaaa*t152*t181*t202*t25*t299*t300*
     6         t61+1.6455307846020562d-2*gammaaa*t16*t162*t163*t181*t202
     7         *t299*t300*t61-4.38808209227215d-2*gammaaa*t152*t163*t17*
     8         t181*t202*t298*t300*t61+1.6455307846020562d-2*gammaaa*t16
     9         *t163*t165*t181*t202*t298*t300*t61+4.38808209227215d-2*t1
     :         52*t17*t181*t202*t25*t300*t61-1.6455307846020562d-2*t16*t
     ;         165*t181*t202*t25*t300*t61+1.6455307846020562d-2*t16*t162
     <         *t163*t17*t181*t202*t300*t61+3.2910615692041123d-2*gammaa
     =         a*t16*t163*t201*t202*t298*t299*t61-3.2910615692041123d-2*
     >         t16*t201*t202*t25*t299*t61+3.2910615692041123d-2*t16*t163
     ?         *t17*t201*t202*t298*t61+5.0d-1*t190*t198*t199*t200*t59*t5
     @         91+8.227653923010281d-3*gammaaa*t16*t17*t181*t199*t200*t2
     1         02*t25*t591-2.5d-1*t198*t199*t200*t412*t585*t59+t190*t198
     2         *t200*t300*t540*t59+2*t198*t200*t316*t539*t59-2*t190*t198
     3         *t199*t300*t316*t421*t59-2*t190*t197*t200*t300*t316*t418*
     4         t59-4.1138269615051404d-3*gammaaa*t16*t17*t199*t200*t202*
     5         t25*t402*t585+t190*t198*t199*t200*t585+3.2910615692041123
     6         d-2*gammaaa*t16*t17*t200*t202*t25*t316*t541+1.64553078460
     7         20562d-2*gammaaa*t16*t17*t181*t200*t202*t25*t300*t540-3.2
     8         910615692041123d-2*gammaaa*t16*t17*t181*t200*t201*t25*t30
     9         0*t316*t424-3.2910615692041123d-2*gammaaa*t16*t17*t181*t1
     :         99*t202*t25*t300*t316*t421-4.38808209227215d-2*gammaaa*t1
     ;         52*t17*t181*t200*t202*t25*t300*t316+1.6455307846020562d-2
     <         *gammaaa*t16*t165*t181*t200*t202*t25*t300*t316-1.64553078
     =         46020562d-2*gammaaa*t16*t162*t163*t17*t181*t200*t202*t300
     >         *t316+2*t197*t198*t200*t300*t316+t188*t190*t198*t200*t300
     ?         *t316+3.2910615692041123d-2*gammaaa*t16*t200*t201*t202*t2
     @         5*t299*t316-3.2910615692041123d-2*gammaaa*t16*t163*t17*t2
     1         00*t201*t202*t298*t316+3.2910615692041123d-2*t16*t17*t200
     2         *t201*t202*t25*t316+1.6455307846020562d-2*gammaaa*t16*t18
     3         1*t199*t200*t202*t25*t299*t300-1.6455307846020562d-2*gamm
     4         aaa*t16*t163*t17*t181*t199*t200*t202*t298*t300+1.64553078
     5         46020562d-2*t16*t17*t181*t199*t200*t202*t25*t300)-2.0d+0*
     6         t195*t59*(-1.475609999999999d-1*t193*t50*(t897+t896+t895+
     7         t894+t888+t887+t886+t885)-1.475609999999999d-1*t180*t56*t
     8         889-8.853659999999993d-1*t192*t50*t622*t756-2.21341499999
     9         99983d-1*t179*t56*t585*t602*t741+2.951219999999998d-1*t19
     :         2*t411*t50*t623+1.475609999999999d-1*t179*t180*t193*t623-
     ;         2.951219999999998d-1*t179*t180*t411*t622-7.37804999999999
     <         4d-2*t192*t193*t393*t585*t602+1.475609999999999d-1*t176*t
     =         179*t393*t56*t591+7.378049999999994d-2*t176*t180*t192*t19
     >         3*t591-7.378049999999994d-2*t179*t393*t395*t56*t585-3.689
     ?         024999999997d-2*t180*t192*t193*t395*t585+2.95121999999999
     @         8d-1*t176*t300*t393*t530*t56+5.902439999999995d-1*t313*t4
     1         11*t50*t537+1.475609999999999d-1*t176*t180*t193*t300*t537
     2         +2.951219999999998d-1*t180*t193*t313*t530-2.9512199999999
     3         98d-1*t176*t180*t192*t300*t313*t411-2.951219999999998d-1*
     4         t176*t179*t193*t300*t313*t393)+3.2910615692041123d-2*gamm
     5         aaa*t16*t17*t186*t25*(6.0965d-1*t184*t50*(t893+t892+t891+
     6         t890+t888+t887+t886+t885)+6.0965d-1*t180*t47*t889+3.6579d
     7         +0*t183*t50*t603*t749+9.14475d-1*t179*t47*t585*t602*t741-
     8         1.2193000000000001d+0*t183*t401*t50*t608-6.0965d-1*t179*t
     9         180*t184*t608+1.2193000000000001d+0*t179*t180*t401*t603+3
     :         .04825d-1*t183*t184*t393*t585*t602-6.0965d-1*t176*t179*t3
     ;         93*t47*t591-3.04825d-1*t176*t180*t183*t184*t591+3.04825d-
     <         1*t179*t393*t395*t47*t585+1.524125d-1*t180*t183*t184*t395
     =         *t585-2.4386000000000002d+0*t307*t401*t50*t533-6.0965d-1*
     >         t176*t180*t184*t300*t533-1.2193000000000001d+0*t176*t300*
     ?         t393*t47*t530-1.2193000000000001d+0*t180*t184*t307*t530+1
     @         .2193000000000001d+0*t176*t180*t183*t300*t307*t401+1.2193
     1         000000000001d+0*t176*t179*t184*t300*t307*t393)-8.88888888
     2         8888888d-1*t73*t75*(4.7459599999999996d-2*t66*t884-2.4d+0
     3         *t68*(-5.0d-1*t205*t883+6.41391219265211d-2*t206*(gammaaa
     4         *t16*t25*t882-gammaaa*t16*t163*t17*t881-6*gammaaa*t16*t16
     5         2*t17*t587*t716-2.6666666666666666d+0*gammaaa*t152*t25*t5
     6         90-gammaaa*t16*t162*t163*t590+2*gammaaa*t16*t162*t17*t366
     7         *t589+2.6666666666666666d+0*gammaaa*t152*t163*t17*t589-ga
     8         mmaaa*t16*t163*t165*t589-5.333333333333333d+0*gammaaa*t15
     9         2*t17*t366*t587+2*gammaaa*t16*t165*t366*t587-2*gammaaa*t1
     :         6*t163*t298*t525+2*t16*t25*t525+4*gammaaa*t16*t17*t298*t3
     ;         66*t524-2*gammaaa*t16*t163*t299*t524-2*t16*t163*t17*t524+
     <         4*gammaaa*t16*t162*t298*t299*t366+4*t16*t162*t17*t298*t36
     =         6+5.333333333333333d+0*gammaaa*t152*t163*t298*t299-5.3333
     >         33333333333d+0*t152*t25*t299-2*t16*t162*t163*t299+5.33333
     ?         3333333333d+0*t152*t163*t17*t298-2*t16*t163*t165*t298)-3.
     @         75d-1*t188*t585*t769+4.810434144489083d-2*t207*t636*t768-
     1         3.206956096326055d-2*t207*t428*t637+2.5d-1*t188*t430*t591
     2         -6.41391219265211d-2*t325*t428*t543+5.0d-1*t300*t430*t526
     3         )-8.400000000000001d+0*t204*t71*t883-2.7259596d+0*t67*t88
     4         3+5.672746666666666d-2*t66*t883+4.7459599999999996d-2*t35
     5         *t883-4.9628707825354457d+0*t204*t883-3.15d+1*t188*t585*t
     6         71*t767-1.8610765434507923d+1*t188*t585*t767-2.1d+1*t188*
     7         t427*t591*t71-4.2d+1*t300*t427*t526*t71-5.4519192d+0*t188
     8         *t591*t66-1.0903838400000002d+1*t300*t526*t66-8.400000000
     9         000001d+0*t188*t204*t638+4.7459599999999996d-2*t188*t593-
     :         1.2407176956338616d+1*t188*t427*t591-8.400000000000001d+0
     ;         *t204*t208*t591+5.672746666666666d-2*t188*t591+4.74595999
     <         99999996d-2*t169*t591-2.1d+1*t208*t427*t585-5.4519192d+0*
     =         t188*t585-1.68d+1*t204*t300*t544+9.491919999999999d-2*t30
     >         0*t527-2.481435391267723d+1*t300*t427*t526-1.68d+1*t204*t
     ?         326*t526+9.491919999999999d-2*t302*t526+1.134549333333333
     @         1d-1*t300*t526-4.2d+1*t188*t300*t326*t427)+5.273288888888
     1         887d-2*t36*t38*t884-8.888888888888888d-1*t72*t73*(4.93659
     2         23538061685d-2*t1*t3*t30*(-5.0d-1*t1*t213*t3*t883+7.5d-1*
     3         t1*t167*t3*t318*t591+1.6666666666666666d-1*t1*t213*t23*t5
     4         91-1.875d+0*t1*t167*t3*t542*t585-2.5d-1*t1*t23*t318*t585+
     5         1.5d+0*t1*t3*t300*t318*t526)-1.4431302433467247d-1*t1*t21
     6         3*t3*t883+2.164695365020087d-1*t1*t167*t3*t318*t591-2.468
     7         2961769030842d-2*t1*t213*t219*t3*t591+4.810434144489082d-
     8         2*t1*t213*t23*t591-5.411738412550218d-1*t1*t167*t3*t542*t
     9         585+3.7024442653546263d-2*t1*t219*t3*t318*t585-7.21565121
     :         6733623d-2*t1*t23*t318*t585-4.9365923538061685d-2*t1*t213
     ;         *t3*t300*t548+4.329390730040174d-1*t1*t3*t300*t318*t526)+
     <         5.273288888888887d-2*t35*t38*(-6.41391219265211d-2*t1*t21
     =         3*t3*t883+9.620868288978166d-2*t1*t167*t3*t318*t591+2.137
     >         9707308840368d-2*t1*t213*t23*t591-2.4052170722445415d-1*t
     ?         1*t167*t3*t542*t585-3.206956096326055d-2*t1*t23*t318*t585
     @         +1.924173657795633d-1*t1*t3*t300*t318*t526)-2.0d+0*t58*t8
     1         83-4.727288888888889d-2*t151*t32*t883+3.2910615692041123d
     2         -2*gammaaa*t16*t25*t52*t882-3.2910615692041123d-2*gammaaa
     3         *t16*t163*t17*t52*t881+3.3352457426896626d-2*t1*t167*t211
     4         *t3*t585*t857-4.0d+0*t194*t59*t613*t755+5.333333333333333
     5         d+1*t221*t595*t72*t738*t75-1.0666666666666666d+1*t221*t38
     6         9*t641*t72*t75-2.1333333333333332d+1*t321*t389*t550*t72*t
     7         75+2.6666666666666666d+0*t209*t222*t641*t75+2.66666666666
     8         66666d+0*t221*t222*t639*t75-1.0666666666666666d+1*t209*t3
     9         89*t595*t75+5.333333333333333d+0*t222*t327*t550*t75+5.333
     :         333333333333d+0*t222*t321*t545*t75-2.1333333333333332d+1*
     ;         t221*t321*t327*t389*t75+6.582123138408225d-2*gammaaa*t16*
     <         t17*t185*t25*t599*t739-4.667339636624349d-3*t214*t39*t40*
     =         t585*t626*t736-1.0546577777777776d-1*t169*t36*t641*t73-1.
     >         0546577777777776d-1*t216*t35*t641*t73-8.888888888888888d-
     ?         1*t220*t639*t73-8.888888888888888d-1*t209*t633*t73-1.0546
     @         577777777776d-1*t221*t36*t593*t73+6.764482379964267d-3*t1
     1         *t213*t221*t3*t35*t591*t73-1.01467235699464d-2*t1*t221*t3
     2         *t318*t35*t585*t73-2.109315555555555d-1*t302*t36*t550*t73
     3         +1.3528964759928536d-2*t1*t213*t3*t300*t35*t550*t73-1.777
     4         7777777777776d+0*t327*t549*t73-2.109315555555555d-1*t321*
     5         t35*t546*t73-1.7777777777777776d+0*t522*t545*t73-2.109315
     6         555555555d-1*t321*t36*t527*t73-2.109315555555555d-1*t216*
     7         t302*t321*t73+1.3528964759928536d-2*t1*t169*t213*t3*t300*
     8         t321*t73+1.3528964759928536d-2*t1*t213*t221*t3*t300*t302*
     9         t73+2.6666666666666666d+0*t220*t222*t641*t72+2.6666666666
     :         666666d+0*t221*t222*t633*t72-1.0666666666666666d+1*t220*t
     ;         389*t595*t72+5.333333333333333d+0*t222*t522*t550*t72+5.33
     <         3333333333333d+0*t222*t321*t549*t72-2.1333333333333332d+1
     =         *t221*t321*t389*t522*t72-1.9746369415224674d-1*gammaaa*t1
     >         6*t162*t17*t52*t587*t716+3.1639733333333325d-1*t221*t222*
     ?         t35*t36*t641-2.8363733333333335d-1*t167*t32*t585*t626+2.0
     @         d+0*t194*t409*t59*t624-2.0d+0*t188*t195*t624+2.0d+0*t188*
     1         t409*t613-3.2910615692041123d-2*gammaaa*t16*t17*t185*t25*
     2         t391*t609-8.7761641845443d-2*gammaaa*t152*t17*t186*t25*t6
     3         09+3.2910615692041123d-2*gammaaa*t16*t165*t186*t25*t609-3
     4         .2910615692041123d-2*gammaaa*t16*t162*t163*t17*t186*t609+
     5         8.7761641845443d-2*gammaaa*t152*t17*t25*t391*t599-3.29106
     6         15692041123d-2*gammaaa*t16*t165*t25*t391*t599+3.291061569
     7         2041123d-2*gammaaa*t16*t162*t163*t17*t391*t599-1.26558933
     8         3333333d+0*t221*t35*t36*t389*t595+3.1639733333333325d-1*t
     9         169*t222*t36*t595+3.1639733333333325d-1*t216*t222*t35*t59
     :         5+5.273288888888887d-2*t216*t38*t593-6.064083168526658d-3
     ;         *t1*t167*t211*t3*t542*t591-1.2128166337053317d-2*t1*t214*
     <         t3*t318*t386*t591+9.454577777777778d-2*t167*t32*t382*t591
     =         -3.3822411899821336d-3*t1*t169*t213*t3*t38*t591+4.7272888
     >         88888889d-2*t151*t211*t214*t591-2.0d+0*t194*t195*t591-8.7
     ?         761641845443d-2*gammaaa*t152*t25*t52*t590-3.2910615692041
     @         123d-2*gammaaa*t16*t162*t163*t52*t590+3.2910615692041123d
     1         -2*gammaaa*t16*t185*t186*t25*t590+4.0d+0*t314*t409*t538*t
     2         59+6.582123138408225d-2*gammaaa*t16*t162*t17*t366*t52*t58
     3         9+8.7761641845443d-2*gammaaa*t152*t163*t17*t52*t589-3.291
     4         0615692041123d-2*gammaaa*t16*t163*t165*t52*t589-3.2910615
     5         692041123d-2*gammaaa*t16*t163*t17*t185*t186*t589-1.755232
     6         83690886d-1*gammaaa*t152*t17*t366*t52*t587+6.582123138408
     7         225d-2*gammaaa*t16*t165*t366*t52*t587+6.582123138408225d-
     8         2*gammaaa*t16*t17*t185*t186*t366*t587+4.244858217968661d-
     9         2*t1*t214*t3*t386*t542*t585-9.454577777777778d-2*t211*t21
     :         4*t382*t585+5.0733617849732d-3*t1*t169*t3*t318*t38*t585+6
     ;         .327946666666665d-1*t222*t321*t35*t36*t550-2.425633267410
     <         6634d-2*t1*t3*t300*t318*t386*t547+9.454577777777778d-2*t1
     =         51*t211*t300*t547+1.0546577777777776d-1*t302*t38*t546-1.2
     >         128166337053317d-2*t1*t211*t3*t300*t526*t542-4.0d+0*t195*
     ?         t300*t538-6.582123138408225d-2*gammaaa*t16*t17*t25*t308*t
     @         391*t534+6.582123138408225d-2*gammaaa*t16*t186*t25*t299*t
     1         534-6.582123138408225d-2*gammaaa*t16*t163*t17*t186*t298*t
     2         534+6.582123138408225d-2*t16*t17*t186*t25*t534-6.76448237
     3         9964267d-3*t1*t213*t3*t300*t38*t527+1.8909155555555557d-1
     4         *t300*t32*t382*t526-4.0d+0*t195*t314*t526-6.5821231384082
     5         25d-2*gammaaa*t16*t163*t298*t52*t525+6.582123138408225d-2
     6         *t16*t25*t52*t525+6.582123138408225d-2*gammaaa*t16*t186*t
     7         25*t308*t525+1.316424627681645d-1*gammaaa*t16*t17*t298*t3
     8         66*t52*t524-6.582123138408225d-2*gammaaa*t16*t163*t299*t5
     9         2*t524-6.582123138408225d-2*t16*t163*t17*t52*t524-6.58212
     :         3138408225d-2*gammaaa*t16*t163*t17*t186*t308*t524+5.33333
     ;         3333333333d+0*t221*t222*t327*t522+5.333333333333333d+0*t2
     <         09*t222*t321*t522+1.316424627681645d-1*gammaaa*t16*t162*t
     =         298*t299*t366*t52+1.316424627681645d-1*t16*t162*t17*t298*
     >         t366*t52+1.75523283690886d-1*gammaaa*t152*t163*t298*t299*
     ?         t52-1.75523283690886d-1*t152*t25*t299*t52-6.5821231384082
     @         25d-2*t16*t162*t163*t299*t52+1.75523283690886d-1*t152*t16
     1         3*t17*t298*t52-6.582123138408225d-2*t16*t163*t165*t298*t5
     2         2+4.0d+0*t194*t300*t314*t409-6.582123138408225d-2*gammaaa
     3         *t16*t185*t25*t299*t308*t391+6.582123138408225d-2*gammaaa
     4         *t16*t163*t17*t185*t298*t308*t391-6.582123138408225d-2*t1
     5         6*t17*t185*t25*t308*t391+1.316424627681645d-1*gammaaa*t16
     6         *t162*t17*t186*t298*t308*t366+6.327946666666665d-1*t221*t
     7         222*t302*t321*t36-4.05868942797856d-2*t1*t213*t221*t222*t
     8         3*t300*t321*t35+5.333333333333333d+0*t220*t222*t321*t327-
     9         1.75523283690886d-1*gammaaa*t152*t186*t25*t299*t308-6.582
     :         123138408225d-2*gammaaa*t16*t162*t163*t186*t299*t308+1.75
     ;         523283690886d-1*gammaaa*t152*t163*t17*t186*t298*t308-6.58
     <         2123138408225d-2*gammaaa*t16*t163*t165*t186*t298*t308-1.7
     =         5523283690886d-1*t152*t17*t186*t25*t308+6.582123138408225
     >         d-2*t16*t165*t186*t25*t308-6.582123138408225d-2*t16*t162*
     ?         t163*t17*t186*t308-6.582123138408225d-2*gammaaa*t16*t163*
     @         t185*t186*t298*t299+6.582123138408225d-2*t16*t185*t186*t2
     1         5*t299-6.582123138408225d-2*t16*t163*t17*t185*t186*t298)-
     2         1.2407009817987999d+0*t2*(-8.888888888888888d-1*t639*t73*
     3         t75+2.6666666666666666d+0*t222*t641*t72*t75+5.33333333333
     4         3333d+0*t222*t321*t327*t75-8.888888888888888d-1*t633*t72*
     5         t73-1.0546577777777776d-1*t35*t36*t641*t73-1.777777777777
     6         7776d+0*t327*t522*t73-2.109315555555555d-1*t302*t321*t36*
     7         t73+1.3528964759928536d-2*t1*t213*t3*t300*t321*t35*t73+5.
     8         333333333333333d+0*t222*t321*t522*t72+t630+t629+t628+t627
     9         -2.0d+0*t195*t59*t624+t621+t614+t612+3.2910615692041123d-
     :         2*gammaaa*t16*t17*t186*t25*t609+t600+t598+t597+t596+3.163
     ;         9733333333325d-1*t222*t35*t36*t595+t594+t592-3.3822411899
     <         821336d-3*t1*t213*t3*t35*t38*t591+3.2910615692041123d-2*g
     =         ammaaa*t16*t25*t52*t590-3.2910615692041123d-2*gammaaa*t16
     >         *t163*t17*t52*t589+t586-6.582123138408225d-2*gammaaa*t16*
     ?         t163*t298*t299*t52+6.582123138408225d-2*t16*t25*t299*t52-
     @         6.582123138408225d-2*t16*t163*t17*t298*t52-6.764482379964
     1         267d-3*t1*t213*t3*t300*t302*t38-4.0d+0*t195*t300*t314+6.5
     2         82123138408225d-2*gammaaa*t16*t186*t25*t299*t308+6.582123
     3         138408225d-2*t16*t17*t186*t25*t308))*wght+Cmat3(iq,D3_RA_
     4         GAA_GAA)
            Cmat3(iq,D3_RA_GAA_GAB) = Cmat3(iq,D3_RA_GAA_GAB)
            Cmat3(iq,D3_RA_GAA_GBB) = Cmat3(iq,D3_RA_GAA_GBB)
            Cmat3(iq,D3_RA_GAB_GAB) = Cmat3(iq,D3_RA_GAB_GAB)
            Cmat3(iq,D3_RA_GAB_GBB) = Cmat3(iq,D3_RA_GAB_GBB)
            Cmat3(iq,D3_RA_GBB_GBB) = Cmat3(iq,D3_RA_GBB_GBB)
            Cmat3(iq,D3_RB_GAA_GAA) = Cmat3(iq,D3_RB_GAA_GAA)
            Cmat3(iq,D3_RB_GAA_GAB) = Cmat3(iq,D3_RB_GAA_GAB)
            Cmat3(iq,D3_RB_GAA_GBB) = Cmat3(iq,D3_RB_GAA_GBB)
            Cmat3(iq,D3_RB_GAB_GAB) = Cmat3(iq,D3_RB_GAB_GAB)
            Cmat3(iq,D3_RB_GAB_GBB) = Cmat3(iq,D3_RB_GAB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = (-9.305257363491d-1*t97*(-8.888888
     1         888888888d-1*t146*t147*(4.9365923538061685d-2*t1*t105*t78
     2         *(1.6666666666666666d-1*t1*t286*t651*t98-2.5d-1*t1*t350*t
     3         645*t98-5.0d-1*t1*t286*t78*t904+7.5d-1*t1*t240*t350*t651*
     4         t78-1.875d+0*t1*t240*t575*t645*t78+1.5d+0*t1*t332*t350*t5
     5         59*t78)+4.810434144489082d-2*t1*t286*t651*t98-7.215651216
     6         733623d-2*t1*t350*t645*t98-1.4431302433467247d-1*t1*t286*
     7         t78*t904+2.164695365020087d-1*t1*t240*t350*t651*t78-2.468
     8         2961769030842d-2*t1*t286*t292*t651*t78-5.411738412550218d
     9         -1*t1*t240*t575*t645*t78+3.7024442653546263d-2*t1*t292*t3
     :         50*t645*t78-4.9365923538061685d-2*t1*t286*t332*t581*t78+4
     ;         .329390730040174d-1*t1*t332*t350*t559*t78)+5.273288888888
     <         887d-2*t110*t113*(2.1379707308840368d-2*t1*t286*t651*t98-
     =         3.206956096326055d-2*t1*t350*t645*t98-6.41391219265211d-2
     >         *t1*t286*t78*t904+9.620868288978166d-2*t1*t240*t350*t651*
     ?         t78-2.4052170722445415d-1*t1*t240*t575*t645*t78+1.9241736
     @         57795633d-1*t1*t332*t350*t559*t78)+2.6666666666666666d+0*
     1         t146*t149*t295*t922-1.0546577777777776d-1*t110*t111*t147*
     2         t922-4.727288888888889d-2*t103*t284*t921-1.55577987887478
     3         31d-3*t114*t240*t39*t465*t645*t920-8.888888888888888d-1*t
     4         147*t149*(-2.4d+0*t142*(6.41391219265211d-2*t279*(-gammab
     5         b*t236*t902*t91*t92-6*gammabb*t235*t647*t783*t91*t92+2*ga
     6         mmabb*t235*t445*t649*t91*t92+4*gammabb*t330*t445*t557*t91
     7         *t92-2*t236*t557*t91*t92+4*t235*t330*t445*t91*t92+2.66666
     8         66666666666d+0*gammabb*t225*t236*t649*t92-5.3333333333333
     9         33d+0*gammabb*t225*t445*t647*t92+5.333333333333333d+0*t22
     :         5*t236*t330*t92+gammabb*t100*t903*t91-gammabb*t235*t236*t
     ;         650*t91-gammabb*t236*t238*t649*t91+2*gammabb*t238*t445*t6
     <         47*t91-2*gammabb*t236*t330*t558*t91+2*t100*t558*t91-2*gam
     =         mabb*t236*t331*t557*t91+4*gammabb*t235*t330*t331*t445*t91
     >         -2*t235*t236*t331*t91-2*t236*t238*t330*t91-2.666666666666
     ?         6666d+0*gammabb*t100*t225*t650+5.333333333333333d+0*gamma
     @         bb*t225*t236*t330*t331-5.333333333333333d+0*t100*t225*t33
     1         1)-5.0d-1*t278*t904-3.75d-1*t261*t645*t836+4.810434144489
     2         083d-2*t280*t696*t835-3.206956096326055d-2*t280*t507*t697
     3         +2.5d-1*t261*t509*t651-6.41391219265211d-2*t357*t507*t576
     4         +5.0d-1*t332*t509*t559)+4.7459599999999996d-2*t140*t905-8
     5         .400000000000001d+0*t145*t277*t904-4.9628707825354457d+0*
     6         t277*t904-2.7259596d+0*t141*t904+5.672746666666666d-2*t14
     7         0*t904+4.7459599999999996d-2*t110*t904-3.15d+1*t145*t261*
     8         t645*t834-1.8610765434507923d+1*t261*t645*t834-8.40000000
     9         0000001d+0*t261*t277*t698+4.7459599999999996d-2*t261*t653
     :         -2.1d+1*t145*t261*t506*t651-1.2407176956338616d+1*t261*t5
     ;         06*t651-8.400000000000001d+0*t277*t281*t651-5.4519192d+0*
     <         t140*t261*t651+5.672746666666666d-2*t261*t651+4.745959999
     =         9999996d-2*t242*t651-2.1d+1*t281*t506*t645-5.4519192d+0*t
     >         261*t645-1.68d+1*t277*t332*t577+9.491919999999999d-2*t332
     ?         *t560-4.2d+1*t145*t332*t506*t559-2.481435391267723d+1*t33
     @         2*t506*t559-1.68d+1*t277*t358*t559+9.491919999999999d-2*t
     1         334*t559-1.0903838400000002d+1*t140*t332*t559+1.134549333
     2         3333331d-1*t332*t559-4.2d+1*t261*t332*t358*t506)+7.57211d
     3         -1*(-1.6455307846020562d-2*gammabb*t100*t139*t273*t91*t91
     4         9*t92-1.6455307846020562d-2*gammabb*t100*t135*t275*t91*(t
     5         914+t913+t912+t911)*t92-1.6455307846020562d-2*gammabb*t13
     6         5*t139*t236*t902*t91*t92-2.4682961769030842d-2*gammabb*t1
     7         00*t135*t274*t645*t680*t832*t91*t92-9.873184707612337d-2*
     8         gammabb*t100*t139*t272*t676*t830*t91*t92-9.87318470761233
     9         7d-2*gammabb*t135*t139*t235*t647*t783*t91*t92-8.227653923
     :         010281d-3*gammabb*t100*t272*t273*t503*t645*t680*t91*t92-8
     ;         .227653923010281d-3*gammabb*t135*t235*t236*t503*t645*t680
     <         *t91*t92+3.2910615692041123d-2*gammabb*t100*t139*t272*t50
     =         0*t679*t91*t92+1.6455307846020562d-2*gammabb*t100*t273*t2
     >         74*t275*t679*t91*t92+1.6455307846020562d-2*gammabb*t139*t
     ?         235*t236*t273*t679*t91*t92-3.2910615692041123d-2*gammabb*
     @         t100*t274*t275*t500*t676*t91*t92-3.2910615692041123d-2*ga
     1         mmabb*t139*t235*t236*t500*t676*t91*t92+1.6455307846020562
     2         d-2*gammabb*t100*t135*t254*t274*t503*t651*t91*t92+8.22765
     3         3923010281d-3*gammabb*t100*t254*t272*t273*t275*t651*t91*t
     4         92+8.227653923010281d-3*gammabb*t135*t235*t236*t254*t275*
     5         t651*t91*t92+3.2910615692041123d-2*gammabb*t135*t139*t235
     6         *t445*t649*t91*t92+1.6455307846020562d-2*gammabb*t135*t23
     7         6*t274*t275*t649*t91*t92+1.6455307846020562d-2*gammabb*t1
     8         39*t236*t272*t273*t649*t91*t92-3.2910615692041123d-2*gamm
     9         abb*t135*t274*t275*t445*t647*t91*t92-3.2910615692041123d-
     :         2*gammabb*t139*t272*t273*t445*t647*t91*t92-8.227653923010
     ;         281d-3*gammabb*t100*t135*t274*t481*t503*t645*t91*t92-4.11
     <         38269615051404d-3*gammabb*t100*t272*t273*t275*t481*t645*t
     =         91*t92-4.1138269615051404d-3*gammabb*t135*t235*t236*t275*
     >         t481*t645*t91*t92+3.2910615692041123d-2*gammabb*t100*t135
     ?         *t254*t332*t503*t574*t91*t92+3.2910615692041123d-2*gammab
     @         b*t100*t273*t275*t348*t574*t91*t92+3.2910615692041123d-2*
     1         gammabb*t135*t236*t275*t330*t574*t91*t92-3.29106156920411
     2         23d-2*t100*t135*t275*t574*t91*t92+6.582123138408225d-2*ga
     3         mmabb*t100*t139*t348*t500*t573*t91*t92+1.6455307846020562
     4         d-2*gammabb*t100*t254*t273*t275*t332*t573*t91*t92+3.29106
     5         15692041123d-2*gammabb*t139*t236*t273*t330*t573*t91*t92-3
     6         .2910615692041123d-2*t100*t139*t273*t573*t91*t92+6.582123
     7         138408225d-2*gammabb*t135*t139*t330*t445*t557*t91*t92+3.2
     8         910615692041123d-2*gammabb*t139*t236*t273*t348*t557*t91*t
     9         92+1.6455307846020562d-2*gammabb*t135*t236*t254*t275*t332
     :         *t557*t91*t92-3.2910615692041123d-2*t135*t139*t236*t557*t
     ;         91*t92-3.2910615692041123d-2*gammabb*t100*t254*t273*t274*
     <         t332*t348*t503*t91*t92-3.2910615692041123d-2*gammabb*t135
     =         *t236*t254*t274*t330*t332*t503*t91*t92+3.2910615692041123
     >         d-2*t100*t135*t254*t274*t332*t503*t91*t92-3.2910615692041
     ?         123d-2*gammabb*t100*t254*t272*t275*t332*t348*t500*t91*t92
     @         -6.582123138408225d-2*gammabb*t139*t236*t272*t330*t348*t5
     1         00*t91*t92+6.582123138408225d-2*t100*t139*t272*t348*t500*
     2         t91*t92-6.582123138408225d-2*gammabb*t139*t235*t273*t330*
     3         t348*t445*t91*t92-3.2910615692041123d-2*gammabb*t135*t235
     4         *t254*t275*t330*t332*t445*t91*t92+6.582123138408225d-2*t1
     5         35*t139*t235*t330*t445*t91*t92-1.6455307846020562d-2*gamm
     6         abb*t235*t236*t254*t273*t275*t332*t348*t91*t92-3.29106156
     7         92041123d-2*gammabb*t236*t273*t274*t275*t330*t348*t91*t92
     8         +3.2910615692041123d-2*t100*t273*t274*t275*t348*t91*t92+3
     9         .2910615692041123d-2*t139*t235*t236*t273*t348*t91*t92-1.6
     :         455307846020562d-2*gammabb*t236*t254*t272*t273*t275*t330*
     ;         t332*t91*t92+1.6455307846020562d-2*t100*t254*t272*t273*t2
     <         75*t332*t91*t92+1.6455307846020562d-2*t135*t235*t236*t254
     =         *t275*t332*t91*t92+3.2910615692041123d-2*t135*t236*t274*t
     >         275*t330*t91*t92+3.2910615692041123d-2*t139*t236*t272*t27
     ?         3*t330*t91*t92-2.194041046136075d-2*gammabb*t100*t135*t22
     @         5*t503*t645*t680*t92+4.38808209227215d-2*gammabb*t100*t13
     1         9*t225*t273*t679*t92-8.7761641845443d-2*gammabb*t100*t139
     2         *t225*t500*t676*t92+2.194041046136075d-2*gammabb*t100*t13
     3         5*t225*t254*t275*t651*t92+4.38808209227215d-2*gammabb*t13
     4         5*t139*t225*t236*t649*t92-8.7761641845443d-2*gammabb*t135
     5         *t139*t225*t445*t647*t92-1.0970205230680374d-2*gammabb*t1
     6         00*t135*t225*t275*t481*t645*t92-4.38808209227215d-2*gamma
     7         bb*t100*t225*t254*t273*t275*t332*t348*t92-8.7761641845443
     8         d-2*gammabb*t139*t225*t236*t273*t330*t348*t92+8.776164184
     9         5443d-2*t100*t139*t225*t273*t348*t92-4.38808209227215d-2*
     :         gammabb*t135*t225*t236*t254*t275*t330*t332*t92+4.38808209
     ;         227215d-2*t100*t135*t225*t254*t275*t332*t92+8.77616418454
     <         43d-2*t135*t139*t225*t236*t330*t92-t133*t137*t273*t919-t1
     =         33*t135*t271*(t918+t917+t916+t915)+1.6455307846020562d-2*
     >         gammabb*t100*t135*t139*t903*t91+8.227653923010281d-3*gamm
     ?         abb*t100*t135*t238*t503*t645*t680*t91-1.6455307846020562d
     @         -2*gammabb*t100*t139*t238*t273*t679*t91+3.291061569204112
     1         3d-2*gammabb*t100*t139*t238*t500*t676*t91-8.2276539230102
     2         81d-3*gammabb*t100*t135*t238*t254*t275*t651*t91-1.6455307
     3         846020562d-2*gammabb*t100*t135*t274*t275*t650*t91-1.64553
     4         07846020562d-2*gammabb*t100*t139*t272*t273*t650*t91-1.645
     5         5307846020562d-2*gammabb*t135*t139*t235*t236*t650*t91-1.6
     6         455307846020562d-2*gammabb*t135*t139*t236*t238*t649*t91+3
     7         .2910615692041123d-2*gammabb*t135*t139*t238*t445*t647*t91
     8         +4.1138269615051404d-3*gammabb*t100*t135*t238*t275*t481*t
     9         645*t91-3.2910615692041123d-2*gammabb*t100*t135*t275*t331
     :         *t574*t91-3.2910615692041123d-2*gammabb*t100*t139*t273*t3
     ;         31*t573*t91-3.2910615692041123d-2*gammabb*t100*t139*t273*
     <         t348*t558*t91-1.6455307846020562d-2*gammabb*t100*t135*t25
     =         4*t275*t332*t558*t91-3.2910615692041123d-2*gammabb*t135*t
     >         139*t236*t330*t558*t91+3.2910615692041123d-2*t100*t135*t1
     ?         39*t558*t91-3.2910615692041123d-2*gammabb*t135*t139*t236*
     @         t331*t557*t91+3.2910615692041123d-2*gammabb*t100*t135*t25
     1         4*t274*t331*t332*t503*t91+6.582123138408225d-2*gammabb*t1
     2         00*t139*t272*t331*t348*t500*t91+6.582123138408225d-2*gamm
     3         abb*t135*t139*t235*t330*t331*t445*t91+1.6455307846020562d
     4         -2*gammabb*t100*t238*t254*t273*t275*t332*t348*t91+3.29106
     5         15692041123d-2*gammabb*t100*t273*t274*t275*t331*t348*t91+
     6         3.2910615692041123d-2*gammabb*t139*t235*t236*t273*t331*t3
     7         48*t91+3.2910615692041123d-2*gammabb*t139*t236*t238*t273*
     8         t330*t348*t91-3.2910615692041123d-2*t100*t139*t238*t273*t
     9         348*t91+1.6455307846020562d-2*gammabb*t100*t254*t272*t273
     :         *t275*t331*t332*t91+1.6455307846020562d-2*gammabb*t135*t2
     ;         35*t236*t254*t275*t331*t332*t91+1.6455307846020562d-2*gam
     <         mabb*t135*t236*t238*t254*t275*t330*t332*t91-1.64553078460
     =         20562d-2*t100*t135*t238*t254*t275*t332*t91+3.291061569204
     >         1123d-2*gammabb*t135*t236*t274*t275*t330*t331*t91+3.29106
     ?         15692041123d-2*gammabb*t139*t236*t272*t273*t330*t331*t91-
     @         3.2910615692041123d-2*t100*t135*t274*t275*t331*t91-3.2910
     1         615692041123d-2*t100*t139*t272*t273*t331*t91-3.2910615692
     2         041123d-2*t135*t139*t235*t236*t331*t91-3.2910615692041123
     3         d-2*t135*t139*t236*t238*t330*t91+t135*t137*t904-6*t133*t1
     4         37*t272*t676*t830-1.5d+0*t133*t135*t270*t645*t675*t828+2*
     5         t133*t137*t272*t500*t679+t133*t270*t271*t273*t679-t137*t2
     6         61*t273*t679-2*t133*t270*t271*t500*t676+2*t137*t261*t500*
     7         t676-5.0d-1*t133*t272*t273*t497*t645*t675+5.0d-1*t135*t26
     8         1*t497*t645*t675+t133*t135*t263*t270*t497*t651+5.0d-1*t13
     9         3*t263*t271*t272*t273*t651-t137*t272*t273*t651-t135*t270*
     :         t271*t651-5.0d-1*t135*t261*t263*t271*t651-4.3880820922721
     ;         5d-2*gammabb*t100*t135*t139*t225*t650-5.0d-1*t133*t135*t2
     <         70*t491*t497*t645+2*t135*t263*t270*t497*t645-2.5d-1*t133*
     =         t271*t272*t273*t491*t645+2.5d-1*t135*t261*t271*t491*t645+
     >         t263*t271*t272*t273*t645+4*t133*t137*t348*t500*t573+t133*
     ?         t263*t271*t273*t332*t573-2*t137*t273*t332*t573+2*t133*t13
     @         5*t263*t332*t497*t572+2*t133*t271*t273*t348*t572-2*t135*t
     1         271*t332*t572-2*t137*t273*t348*t559-t135*t263*t271*t332*t
     2         559-2*t133*t263*t271*t272*t332*t348*t500+4*t137*t272*t332
     3         *t348*t500-2*t133*t263*t270*t273*t332*t348*t497+2*t270*t2
     4         71*t273*t332*t348+t261*t263*t271*t273*t332*t348+8.7761641
     5         845443d-2*gammabb*t100*t139*t225*t273*t331*t348+4.3880820
     6         9227215d-2*gammabb*t100*t135*t225*t254*t275*t331*t332+8.7
     7         761641845443d-2*gammabb*t135*t139*t225*t236*t330*t331-8.7
     8         761641845443d-2*t100*t135*t139*t225*t331)+3.2910615692041
     9         123d-2*gammabb*t100*t259*t91*(6.0965d-1*t124*t257*(t914+t
     :         913+t912+t911+t909+t908+t907+t906)+6.0965d-1*t121*t253*t9
     ;         10+3.6579d+0*t124*t256*t663*t816+9.14475d-1*t121*t252*t64
     <         5*t662*t808-1.2193000000000001d+0*t124*t256*t480*t668-6.0
     =         965d-1*t252*t253*t257*t668+1.2193000000000001d+0*t252*t25
     >         3*t480*t663+3.04825d-1*t256*t257*t472*t645*t662-6.0965d-1
     ?         *t121*t249*t252*t472*t651-3.04825d-1*t249*t253*t256*t257*
     @         t651+3.04825d-1*t121*t252*t472*t474*t645+1.524125d-1*t253
     1         *t256*t257*t474*t645-2.4386000000000002d+0*t124*t339*t480
     2         *t566-6.0965d-1*t249*t253*t257*t332*t566-1.21930000000000
     3         01d+0*t121*t249*t332*t472*t563-1.2193000000000001d+0*t253
     4         *t257*t339*t563+1.2193000000000001d+0*t249*t253*t256*t332
     5         *t339*t480+1.2193000000000001d+0*t249*t252*t257*t332*t339
     6         *t472)*t92-3.2910615692041123d-2*gammabb*t126*t236*t902*t
     7         91*t92+6.582123138408225d-2*gammabb*t100*t258*t659*t806*t
     8         91*t92-1.9746369415224674d-1*gammabb*t126*t235*t647*t783*
     9         t91*t92-3.2910615692041123d-2*gammabb*t100*t258*t470*t669
     :         *t91*t92-3.2910615692041123d-2*gammabb*t235*t236*t259*t66
     ;         9*t91*t92+3.2910615692041123d-2*gammabb*t235*t236*t470*t6
     <         59*t91*t92+6.582123138408225d-2*gammabb*t126*t235*t445*t6
     =         49*t91*t92-3.2910615692041123d-2*gammabb*t236*t258*t259*t
     >         649*t91*t92+6.582123138408225d-2*gammabb*t258*t259*t445*t
     ?         647*t91*t92-6.582123138408225d-2*gammabb*t100*t340*t470*t
     @         567*t91*t92-6.582123138408225d-2*gammabb*t236*t259*t330*t
     1         567*t91*t92+6.582123138408225d-2*t100*t259*t567*t91*t92+1
     2         .316424627681645d-1*gammabb*t126*t330*t445*t557*t91*t92-6
     3         .582123138408225d-2*gammabb*t236*t259*t340*t557*t91*t92-6
     4         .582123138408225d-2*t126*t236*t557*t91*t92+6.582123138408
     5         225d-2*gammabb*t236*t258*t330*t340*t470*t91*t92-6.5821231
     6         38408225d-2*t100*t258*t340*t470*t91*t92+1.316424627681645
     7         d-1*gammabb*t235*t259*t330*t340*t445*t91*t92+1.3164246276
     8         81645d-1*t126*t235*t330*t445*t91*t92-6.582123138408225d-2
     9         *t235*t236*t259*t340*t91*t92-6.582123138408225d-2*t236*t2
     :         58*t259*t330*t91*t92-8.7761641845443d-2*gammabb*t100*t225
     ;         *t259*t669*t92+8.7761641845443d-2*gammabb*t100*t225*t470*
     <         t659*t92+8.7761641845443d-2*gammabb*t126*t225*t236*t649*t
     =         92-1.75523283690886d-1*gammabb*t126*t225*t445*t647*t92+1.
     >         75523283690886d-1*gammabb*t225*t236*t259*t330*t340*t92-1.
     ?         75523283690886d-1*t100*t225*t259*t340*t92+1.7552328369088
     @         6d-1*t126*t225*t236*t330*t92-2.0d+0*t133*t268*(-1.4756099
     1         99999999d-1*t124*t266*(t918+t917+t916+t915+t909+t908+t907
     2         +t906)-1.475609999999999d-1*t130*t253*t910-8.853659999999
     3         993d-1*t124*t265*t682*t823-2.2134149999999983d-1*t130*t25
     4         2*t645*t662*t808+2.951219999999998d-1*t124*t265*t490*t683
     5         +1.475609999999999d-1*t252*t253*t266*t683-2.9512199999999
     6         98d-1*t252*t253*t490*t682-7.378049999999994d-2*t265*t266*
     7         t472*t645*t662+1.475609999999999d-1*t130*t249*t252*t472*t
     8         651+7.378049999999994d-2*t249*t253*t265*t266*t651-7.37804
     9         9999999994d-2*t130*t252*t472*t474*t645-3.689024999999997d
     :         -2*t253*t265*t266*t474*t645+5.902439999999995d-1*t124*t34
     ;         5*t490*t570+1.475609999999999d-1*t249*t253*t266*t332*t570
     <         +2.951219999999998d-1*t130*t249*t332*t472*t563+2.95121999
     =         9999998d-1*t253*t266*t345*t563-2.951219999999998d-1*t249*
     >         t253*t265*t332*t345*t490-2.951219999999998d-1*t249*t252*t
     ?         266*t332*t345*t472)+3.2910615692041123d-2*gammabb*t100*t1
     @         26*t903*t91+3.2910615692041123d-2*gammabb*t100*t238*t259*
     1         t669*t91-3.2910615692041123d-2*gammabb*t100*t238*t470*t65
     2         9*t91+3.2910615692041123d-2*gammabb*t100*t258*t259*t650*t
     3         91-3.2910615692041123d-2*gammabb*t126*t235*t236*t650*t91-
     4         3.2910615692041123d-2*gammabb*t126*t236*t238*t649*t91+6.5
     5         82123138408225d-2*gammabb*t126*t238*t445*t647*t91+6.58212
     6         3138408225d-2*gammabb*t100*t259*t331*t567*t91+6.582123138
     7         408225d-2*gammabb*t100*t259*t340*t558*t91-6.5821231384082
     8         25d-2*gammabb*t126*t236*t330*t558*t91+6.582123138408225d-
     9         2*t100*t126*t558*t91-6.582123138408225d-2*gammabb*t126*t2
     :         36*t331*t557*t91-6.582123138408225d-2*gammabb*t100*t258*t
     ;         331*t340*t470*t91+1.316424627681645d-1*gammabb*t126*t235*
     <         t330*t331*t445*t91-6.582123138408225d-2*gammabb*t235*t236
     =         *t259*t331*t340*t91-6.582123138408225d-2*gammabb*t236*t23
     >         8*t259*t330*t340*t91+6.582123138408225d-2*t100*t238*t259*
     ?         t340*t91-6.582123138408225d-2*gammabb*t236*t258*t259*t330
     @         *t331*t91+6.582123138408225d-2*t100*t258*t259*t331*t91-6.
     1         582123138408225d-2*t126*t235*t236*t331*t91-6.582123138408
     2         225d-2*t126*t236*t238*t330*t91+5.273288888888887d-2*t111*
     3         t113*t905-4.727288888888889d-2*t107*t224*t904-2.0d+0*t132
     4         *t904+3.3352457426896626d-2*t1*t240*t284*t645*t78*t878-4.
     5         0d+0*t133*t267*t673*t822+5.333333333333333d+1*t146*t149*t
     6         294*t655*t805-4.667339636624349d-3*t114*t287*t39*t645*t68
     7         6*t803-6.064083168526658d-3*t1*t240*t284*t575*t651*t78-1.
     8         2128166337053317d-2*t1*t287*t350*t465*t651*t78+6.76448237
     9         9964267d-3*t1*t110*t147*t286*t294*t651*t78-3.382241189982
     :         1336d-3*t1*t113*t242*t286*t651*t78+4.244858217968661d-2*t
     ;         1*t287*t465*t575*t645*t78-1.01467235699464d-2*t1*t110*t14
     <         7*t294*t350*t645*t78+5.0733617849732d-3*t1*t113*t242*t350
     =         *t645*t78+1.3528964759928536d-2*t1*t110*t147*t286*t332*t5
     >         83*t78-2.4256332674106634d-2*t1*t332*t350*t465*t580*t78-1
     ?         .2128166337053317d-2*t1*t284*t332*t559*t575*t78-6.7644823
     @         79964267d-3*t1*t113*t286*t332*t560*t78-4.05868942797856d-
     1         2*t1*t110*t286*t294*t295*t332*t353*t78+1.3528964759928536
     2         d-2*t1*t147*t242*t286*t332*t353*t78+1.3528964759928536d-2
     3         *t1*t147*t286*t294*t332*t334*t78-1.0666666666666666d+1*t1
     4         46*t149*t294*t468*t701+3.1639733333333325d-1*t110*t111*t2
     5         94*t295*t701+2.6666666666666666d+0*t146*t293*t295*t701+2.
     6         6666666666666666d+0*t149*t282*t295*t701-1.054657777777777
     7         6d-1*t110*t147*t289*t701-1.0546577777777776d-1*t111*t147*
     8         t242*t701+2.6666666666666666d+0*t149*t294*t295*t699-8.888
     9         888888888888d-1*t147*t293*t699+2.6666666666666666d+0*t146
     :         *t294*t295*t693-8.888888888888888d-1*t147*t282*t693-2.836
     ;         3733333333335d-1*t107*t240*t645*t686+2.0d+0*t133*t267*t48
     <         8*t684-2.0d+0*t261*t268*t684+2.0d+0*t261*t488*t673-1.2655
     =         89333333333d+0*t110*t111*t294*t468*t655-1.066666666666666
     >         6d+1*t146*t293*t468*t655-1.0666666666666666d+1*t149*t282*
     ?         t468*t655+3.1639733333333325d-1*t110*t289*t295*t655+3.163
     @         9733333333325d-1*t111*t242*t295*t655-1.0546577777777776d-
     1         1*t111*t147*t294*t653+5.273288888888887d-2*t113*t289*t653
     2         +9.454577777777778d-2*t107*t240*t461*t651+4.7272888888888
     3         89d-2*t224*t284*t287*t651-2.0d+0*t267*t268*t651-8.7761641
     4         845443d-2*gammabb*t100*t126*t225*t650-9.454577777777778d-
     5         2*t284*t287*t461*t645+5.333333333333333d+0*t146*t295*t555
     6         *t583-2.1333333333333332d+1*t146*t149*t353*t468*t583+5.33
     7         3333333333333d+0*t149*t295*t359*t583+6.327946666666665d-1
     8         *t110*t111*t295*t353*t583-2.109315555555555d-1*t111*t147*
     9         t334*t583-1.7777777777777776d+0*t147*t359*t582+5.33333333
     :         3333333d+0*t146*t295*t353*t582+9.454577777777778d-2*t224*
     ;         t284*t332*t580-2.109315555555555d-1*t110*t147*t353*t579+1
     <         .0546577777777776d-1*t113*t334*t579-1.7777777777777776d+0
     =         *t147*t555*t578+5.333333333333333d+0*t149*t295*t353*t578+
     >         4.0d+0*t133*t346*t488*t571-4.0d+0*t268*t332*t571-2.109315
     ?         555555555d-1*t111*t147*t353*t560+1.8909155555555557d-1*t1
     @         07*t332*t461*t559-4.0d+0*t268*t346*t559-2.133333333333333
     1         2d+1*t146*t294*t353*t468*t555+5.333333333333333d+0*t294*t
     2         295*t359*t555+5.333333333333333d+0*t282*t295*t353*t555+4.
     3         0d+0*t267*t332*t346*t488-2.1333333333333332d+1*t149*t294*
     4         t353*t359*t468+5.333333333333333d+0*t293*t295*t353*t359+6
     5         .327946666666665d-1*t111*t294*t295*t334*t353-2.1093155555
     6         55555d-1*t147*t289*t334*t353-1.75523283690886d-1*gammabb*
     7         t100*t225*t259*t331*t340+1.75523283690886d-1*gammabb*t126
     8         *t225*t236*t330*t331-1.75523283690886d-1*t100*t126*t225*t
     9         331)-1.2407009817987999d+0*t77*(3.2910615692041123d-2*gam
     :         mabb*t100*t259*t669*t91*t92-3.2910615692041123d-2*gammabb
     ;         *t126*t236*t649*t91*t92+6.582123138408225d-2*t100*t259*t3
     <         40*t91*t92-6.582123138408225d-2*t126*t236*t330*t91*t92+3.
     =         2910615692041123d-2*gammabb*t100*t126*t650*t91+6.58212313
     >         8408225d-2*gammabb*t100*t259*t331*t340*t91-6.582123138408
     ?         225d-2*gammabb*t126*t236*t330*t331*t91+6.582123138408225d
     @         -2*t100*t126*t331*t91-3.3822411899821336d-3*t1*t110*t113*
     1         t286*t651*t78+1.3528964759928536d-2*t1*t110*t147*t286*t33
     2         2*t353*t78-6.764482379964267d-3*t1*t113*t286*t332*t334*t7
     3         8+2.6666666666666666d+0*t146*t149*t295*t701-1.05465777777
     4         77776d-1*t110*t111*t147*t701-8.888888888888888d-1*t147*t1
     5         49*t699-8.888888888888888d-1*t146*t147*t693+t690+t689+t68
     6         8+t687-2.0d+0*t133*t268*t684+t681+t674+t672+t660+t658+t65
     7         7+t656+3.1639733333333325d-1*t110*t111*t295*t655+t654+t65
     8         2+t646-1.7777777777777776d+0*t147*t359*t555+5.33333333333
     9         3333d+0*t146*t295*t353*t555+5.333333333333333d+0*t149*t29
     :         5*t353*t359-2.109315555555555d-1*t111*t147*t334*t353-4.0d
     ;         +0*t268*t332*t346))*wght+Cmat3(iq,D3_RB_GBB_GBB)
            Cmat3(iq,D3_GAA_GAA_GAA) = Cmat3(iq,D3_GAA_GAA_GAA)-9.305257
     1         363491d-1*t22*(t222*(2.6666666666666666d+0*t72*t75*t942+5
     2         .333333333333333d+0*t327*t641*t75+2.6666666666666666d+0*t
     3         321*t639*t75+5.333333333333333d+0*t324*t641*t72+2.6666666
     4         666666666d+0*t321*t633*t72-3.0d+0*t321*t643-3.0d+0*t321*(
     5         t642+t640+t635+t634+t632-1.0546577777777776d-1*t302*t321*
     6         t36)-3.0d+0*t328*t641+5.333333333333333d+0*t321*t324*t327
     7         )+t73*(-1.0546577777777776d-1*t35*t36*t942-8.888888888888
     8         888d-1*t75*(4.7459599999999996d-2*t66*t928-2.4d+0*t68*(-5
     9         .0d-1*t205*t927+6.41391219265211d-2*t206*(gammaaa*t16*t25
     :         *t926-gammaaa*t16*t163*t17*t925-6*gammaaa*t16*t17*t716*t9
     ;         24-3*gammaaa*t16*t163*t298*t590+3*t16*t25*t590+6*gammaaa*
     <         t16*t17*t298*t366*t589-3*gammaaa*t16*t163*t299*t589-3*t16
     =         *t163*t17*t589+6*gammaaa*t16*t299*t366*t587+6*t16*t17*t36
     >         6*t587-6*t16*t163*t298*t299)-3.75d-1*t769*t923+4.81043414
     ?         4489083d-2*t325**3*t768-9.620868288978166d-2*t325*t428*t6
     @         37+7.5d-1*t300*t430*t591)-8.400000000000001d+0*t204*t71*t
     1         927-2.7259596d+0*t67*t927+5.672746666666666d-2*t66*t927+4
     2         .7459599999999996d-2*t35*t927-4.9628707825354457d+0*t204*
     3         t927-3.15d+1*t71*t767*t923-1.8610765434507923d+1*t767*t92
     4         3-5.4519192d+0*t923-6.3d+1*t300*t427*t591*t71-1.635575760
     5         0000004d+1*t300*t591*t66-2.52d+1*t204*t300*t638+1.423788d
     6         -1*t300*t593-3.7221530869015845d+1*t300*t427*t591-2.52d+1
     7         *t204*t326*t591+1.423788d-1*t302*t591+1.7018239999999996d
     8         -1*t300*t591-6.3d+1*t326*t427*t585)-8.888888888888888d-1*
     9         t72*(-2.4682961769030842d-2*t151*t39*t40*t927-1.443130243
     :         3467247d-1*t1*t213*t3*t927-1.4809777061418505d-1*t39*t40*
     ;         t626*t923-5.411738412550218d-1*t1*t3*t542*t923+1.48097770
     <         61418505d-1*t300*t382*t39*t40*t591+6.494086095060261d-1*t
     =         1*t3*t300*t318*t591)-3.1639733333333325d-1*t302*t36*t641+
     >         1.3528964759928536d-2*t1*t213*t3*t300*t35*t641-2.66666666
     ?         66666666d+0*t324*t639-2.6666666666666666d+0*t327*t633-3.1
     @         639733333333325d-1*t321*t36*t593+6.764482379964267d-3*t1*
     1         t213*t3*t321*t35*t591-1.01467235699464d-2*t1*t3*t318*t321
     2         *t35*t585+2.02934471398928d-2*t1*t213*t3*t300*t302*t321)+
     3         5.987181320518676d-4*t736*t923*t941/(rhoa*t29**11)+7.5721
     4         1d-1*(-1.6455307846020562d-2*gammaaa*t16*t17*t200*t25*t65
     5         *t940-t200*t59*t63*t940-9.873184707612337d-2*gammaaa*t16*
     6         t17*t25*t65*t763*t936-6*t59*t63*t763*t936+t61*t63*t927-5.
     7         0d-1*t190*t198*t59*t61*t927-8.227653923010281d-3*gammaaa*
     8         t16*t17*t181*t202*t25*t61*t927+1.6455307846020562d-2*gamm
     9         aaa*t16*t25*t61*t65*t926-1.6455307846020562d-2*gammaaa*t1
     :         6*t163*t17*t61*t65*t925-9.873184707612337d-2*gammaaa*t16*
     ;         t17*t61*t65*t716*t924-1.2341480884515421d-2*gammaaa*t16*t
     <         17*t25*t402*t61*t765*t923-7.5d-1*t412*t59*t61*t761*t923-3
     =         .75d-1*t198*t59*t61*t757*t923-6.170740442257711d-3*gammaa
     >         a*t16*t17*t202*t25*t61*t750*t923+1.5d+0*t418*t61*t615*t92
     ?         3-7.5d-1*t418*t59*t61*t923/t53**2-1.2341480884515421d-2*g
     @         ammaaa*t16*t17*t25*t424*t61*t923/t42**2+7.5d-1*t198*t412*
     1         t61*t923+9.873184707612337d-2*gammaaa*t16*t17*t25*t316*t4
     2         21*t619*t65-4.9365923538061685d-2*gammaaa*t16*t200*t25*t2
     3         99*t619*t65+4.9365923538061685d-2*gammaaa*t16*t163*t17*t2
     4         00*t298*t619*t65-4.9365923538061685d-2*t16*t17*t200*t25*t
     5         619*t65+9.873184707612337d-2*gammaaa*t16*t25*t299*t421*t6
     6         16*t65-9.873184707612337d-2*gammaaa*t16*t163*t17*t298*t42
     7         1*t616*t65+9.873184707612337d-2*t16*t17*t25*t421*t616*t65
     8         -4.9365923538061685d-2*gammaaa*t16*t163*t298*t590*t61*t65
     9         +4.9365923538061685d-2*t16*t25*t590*t61*t65+9.87318470761
     :         2337d-2*gammaaa*t16*t17*t298*t366*t589*t61*t65-4.93659235
     ;         38061685d-2*gammaaa*t16*t163*t299*t589*t61*t65-4.93659235
     <         38061685d-2*t16*t163*t17*t589*t61*t65+9.873184707612337d-
     =         2*gammaaa*t16*t299*t366*t587*t61*t65+9.873184707612337d-2
     >         *t16*t17*t366*t587*t61*t65-9.873184707612337d-2*t16*t163*
     ?         t298*t299*t61*t65-4.9365923538061685d-2*gammaaa*t16*t200*
     @         t25*t316*t590*t65+4.9365923538061685d-2*gammaaa*t16*t163*
     1         t17*t200*t316*t589*t65-9.873184707612337d-2*gammaaa*t16*t
     2         17*t200*t316*t366*t587*t65+9.873184707612337d-2*gammaaa*t
     3         16*t163*t200*t298*t299*t316*t65-9.873184707612337d-2*t16*
     4         t200*t25*t299*t316*t65+9.873184707612337d-2*t16*t163*t17*
     5         t200*t298*t316*t65+6*t316*t421*t59*t619*t63-3*t200*t300*t
     6         619*t63+6*t300*t421*t616*t63-3*t200*t316*t591*t63+2.46829
     7         61769030842d-2*gammaaa*t16*t17*t25*t300*t424*t591*t61*t62
     8         0+2.4682961769030842d-2*gammaaa*t16*t25*t299*t424*t585*t6
     9         1*t620-2.4682961769030842d-2*gammaaa*t16*t163*t17*t298*t4
     :         24*t585*t61*t620+2.4682961769030842d-2*t16*t17*t25*t424*t
     ;         585*t61*t620-2.4682961769030842d-2*gammaaa*t16*t17*t200*t
     <         25*t316*t424*t585*t620+1.5d+0*t190*t198*t200*t300*t59*t61
     =         9+2.4682961769030842d-2*gammaaa*t16*t17*t181*t200*t202*t2
     >         5*t300*t619-3*t190*t198*t300*t421*t59*t616-4.936592353806
     ?         1685d-2*gammaaa*t16*t17*t181*t202*t25*t300*t421*t616+1.5d
     @         +0*t300*t418*t59*t591*t61*t615-1.5d+0*t200*t316*t418*t585
     1         *t59*t615+7.5d-1*t198*t300*t412*t59*t591*t61+1.2341480884
     2         515421d-2*gammaaa*t16*t17*t202*t25*t300*t402*t591*t61-3*t
     3         190*t198*t300*t591*t61-2.4682961769030842d-2*gammaaa*t16*
     4         t181*t202*t25*t299*t591*t61+2.4682961769030842d-2*gammaaa
     5         *t16*t163*t17*t181*t202*t298*t591*t61-2.4682961769030842d
     6         -2*t16*t17*t181*t202*t25*t591*t61-2.4682961769030842d-2*g
     7         ammaaa*t16*t181*t202*t25*t300*t590*t61+2.4682961769030842
     8         d-2*gammaaa*t16*t163*t17*t181*t202*t300*t589*t61-4.936592
     9         3538061685d-2*gammaaa*t16*t17*t181*t202*t300*t366*t587*t6
     :         1+1.2341480884515421d-2*gammaaa*t16*t202*t25*t299*t402*t5
     ;         85*t61-1.2341480884515421d-2*gammaaa*t16*t163*t17*t202*t2
     <         98*t402*t585*t61+1.2341480884515421d-2*t16*t17*t202*t25*t
     =         402*t585*t61+4.9365923538061685d-2*gammaaa*t16*t163*t181*
     >         t202*t298*t299*t300*t61-4.9365923538061685d-2*t16*t181*t2
     ?         02*t25*t299*t300*t61+4.9365923538061685d-2*t16*t163*t17*t
     @         181*t202*t298*t300*t61+1.5d+0*t190*t198*t200*t316*t59*t59
     1         1+2.4682961769030842d-2*gammaaa*t16*t17*t181*t200*t202*t2
     2         5*t316*t591-7.5d-1*t198*t200*t316*t412*t585*t59-1.2341480
     3         884515421d-2*gammaaa*t16*t17*t200*t202*t25*t316*t402*t585
     4         +3*t190*t198*t200*t316*t585+4.9365923538061685d-2*gammaaa
     5         *t16*t181*t200*t202*t25*t299*t300*t316-4.9365923538061685
     6         d-2*gammaaa*t16*t163*t17*t181*t200*t202*t298*t300*t316+4.
     7         9365923538061685d-2*t16*t17*t181*t200*t202*t25*t300*t316)
     8         +t195*(-2.0d+0*t59*(-1.475609999999999d-1*t193*t50*(t939+
     9         t938+t937+t935+t934+t933)-1.1067074999999992d-1*t393*t56*
     :         t923*t929-7.378049999999994d-2*t176*t180*t56*t927-5.53353
     ;         7499999995d-2*t180*t56*t743*t923-1.1067074999999992d-1*t3
     <         95*t56*t741*t923-8.853659999999993d-1*t313**3*t50*t756+8.
     =         853659999999993d-1*t313*t411*t50*t623+2.2134149999999983d
     >         -1*t176*t180*t193*t300*t623-4.4268299999999966d-1*t176*t1
     ?         80*t300*t411*t622+2.2134149999999983d-1*t300*t393*t56*t59
     @         1*t602-2.2134149999999983d-1*t193*t313*t393*t585*t602+1.1
     1         067074999999992d-1*t180*t300*t395*t56*t591+2.213414999999
     2         9983d-1*t176*t180*t193*t313*t591-1.1067074999999992d-1*t1
     3         80*t193*t313*t395*t585)-6.0d+0*t300*t624-6.0d+0*t314*t591
     4         )+t16*t186*t25*(3.2910615692041123d-2*gammaaa*t17*(6.0965
     5         d-1*t184*t50*(t935+t934+t933+t932+t931+t930)+4.572375d-1*
     6         t393*t47*t923*t929+3.04825d-1*t176*t180*t47*t927+2.286187
     7         5d-1*t180*t47*t743*t923+4.572375d-1*t395*t47*t741*t923+3.
     8         6579d+0*t307**3*t50*t749-3.6579d+0*t307*t401*t50*t608-9.1
     9         4475d-1*t176*t180*t184*t300*t608+1.82895d+0*t176*t180*t30
     :         0*t401*t603-9.14475d-1*t300*t393*t47*t591*t602+9.14475d-1
     ;         *t184*t307*t393*t585*t602-4.572375d-1*t180*t300*t395*t47*
     <         t591-9.14475d-1*t176*t180*t184*t307*t591+4.572375d-1*t180
     =         *t184*t307*t395*t585)+6.582123138408225d-2*gammaaa*t299*t
     >         609+6.582123138408225d-2*t17*t609+3.2910615692041123d-2*g
     ?         ammaaa*t308*t590+6.582123138408225d-2*t299*t308)+5.273288
     @         888888887d-2*t36*t38*t928+t213*t3*t38*(-3.382241189982133
     1         6d-3*t1*t35*t927-1.01467235699464d-2*t1*t300*t593-1.01467
     2         235699464d-2*t1*t302*t591)-2.0d+0*t58*t927-4.727288888888
     3         889d-2*t151*t32*t927+6.064083168526658d-3*t1*t211*t3*t318
     4         *t927+t16*t25*(3.2910615692041123d-2*gammaaa*t52*t926+3.2
     5         910615692041123d-2*gammaaa*t186*t299*t609+3.2910615692041
     6         123d-2*t17*t186*t609-3.2910615692041123d-2*gammaaa*t299*t
     7         391*t599-3.2910615692041123d-2*t17*t391*t599+9.8731847076
     8         12337d-2*t52*t590+6.582123138408225d-2*gammaaa*t186*t308*
     9         t590+1.316424627681645d-1*t186*t299*t308)+t16*t163*(-3.29
     :         10615692041123d-2*gammaaa*t17*t52*t925-2*t298*t601-3.2910
     ;         615692041123d-2*gammaaa*t298*t52*t590-6.582123138408225d-
     <         2*gammaaa*t299*t52*t589-6.582123138408225d-2*t17*t52*t589
     =         -t310*t589-3.2910615692041123d-2*gammaaa*t17*t186*t308*t5
     >         89-6.582123138408225d-2*t298*t299*t52-3.2910615692041123d
     ?         -2*gammaaa*t186*t298*t299*t308-3.2910615692041123d-2*t17*
     @         t186*t298*t308)-1.9746369415224674d-1*gammaaa*t16*t17*t52
     1         *t716*t924-1.1668349091560873d-2*t386*t39*t40*t899*t923+8
     2         .641318515150488d-2*t1*t211*t3*t857*t923-2.83637333333333
     3         35d-1*t32*t626*t923-1.2683404462433d-2*t1*t3*t35*t38*t542
     4         *t923-4.0d+0*t314**3*t59*t755+t389*(-2.1333333333333332d+
     5         1*t321*t641*t72*t75-1.0666666666666666d+1*t327*t595*t75-1
     6         .0666666666666666d+1*t324*t595*t72-4.0d+0*t321*t644)+5.33
     7         3333333333333d+1*t321**3*t72*t738*t75+6.582123138408225d-
     8         2*gammaaa*t16*t17*t25*t308**3*t739+t213*t3*(6.76448237996
     9         4267d-3*t1*t300*t35*t641-2.0d+0*t321*t631+6.7644823799642
     :         67d-3*t1*t321*t35*t591+6.764482379964267d-3*t1*t300*t302*
     ;         t321)*t73-2.02934471398928d-2*t1*t3*t318*t321*t35*t585*t7
     <         3-1.5d+0*t3*t300*t318*t38*t631+4.667339636624349d-3*t300*
     =         t386*t39*t40*t591*t626+t409*(-t314*t625+4.0d+0*t314*t59*t
     >         624+2.0d+0*t300*t613)+t16*t366*(-2*t298*t611+1.3164246276
     ?         81645d-1*gammaaa*t17*t298*t52*t589+6.582123138408225d-2*g
     @         ammaaa*t299*t52*t587+6.582123138408225d-2*t17*t52*t587)+t
     1         16*t25*t391*(-t308*t610-6.582123138408225d-2*gammaaa*t17*
     2         t308*t609-3.2910615692041123d-2*gammaaa*t299*t599-3.29106
     3         15692041123d-2*t17*t599)+t16*t163*t186*(-t298*t610-6.5821
     4         23138408225d-2*gammaaa*t17*t298*t609-6.582123138408225d-2
     5         *gammaaa*t17*t308*t589-6.582123138408225d-2*gammaaa*t298*
     6         t299*t308-6.582123138408225d-2*t17*t298*t308)+9.873184707
     7         612337d-2*gammaaa*t16*t163*t17*t298*t391*t599-2.029344713
     8         98928d-2*t1*t213*t222*t3*t300*t35*t595+t3*t318*t38*(1.014
     9         67235699464d-2*t1*t300*t35*t591+5.0733617849732d-3*t1*t30
     :         2*t585)-6.367287326952992d-2*t1*t211*t3*t300*t542*t591+2.
     ;         8363733333333335d-1*t300*t32*t382*t591+1.9746369415224674
     <         d-1*gammaaa*t16*t17*t186*t308*t366*t587)*wght
            Cmat3(iq,D3_GAA_GAA_GAB) = Cmat3(iq,D3_GAA_GAA_GAB)
            Cmat3(iq,D3_GAA_GAA_GBB) = Cmat3(iq,D3_GAA_GAA_GBB)
            Cmat3(iq,D3_GAA_GAB_GAB) = Cmat3(iq,D3_GAA_GAB_GAB)
            Cmat3(iq,D3_GAA_GAB_GBB) = Cmat3(iq,D3_GAA_GAB_GBB)
            Cmat3(iq,D3_GAA_GBB_GBB) = Cmat3(iq,D3_GAA_GBB_GBB)
            Cmat3(iq,D3_GAB_GAB_GAB) = Cmat3(iq,D3_GAB_GAB_GAB)
            Cmat3(iq,D3_GAB_GAB_GBB) = Cmat3(iq,D3_GAB_GAB_GBB)
            Cmat3(iq,D3_GAB_GBB_GBB) = Cmat3(iq,D3_GAB_GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = Cmat3(iq,D3_GBB_GBB_GBB)-9.305257
     1         363491d-1*(t295*(2.6666666666666666d+0*t146*t149*t961-3.0
     2         d+0*t353*t703-3.0d+0*t353*(t702+t700+t695+t694+t692-1.054
     3         6577777777776d-1*t111*t334*t353)-3.0d+0*t360*t701+5.33333
     4         3333333333d+0*t149*t359*t701+5.333333333333333d+0*t146*t3
     5         56*t701+2.6666666666666666d+0*t149*t353*t699+2.6666666666
     6         666666d+0*t146*t353*t693+5.333333333333333d+0*t353*t356*t
     7         359)+t147*(-1.0546577777777776d-1*t110*t111*t961-8.888888
     8         888888888d-1*t149*(4.7459599999999996d-2*t140*t948-2.4d+0
     9         *t142*(-5.0d-1*t278*t947+6.41391219265211d-2*t279*(gammab
     :         b*t100*t91*t946-gammabb*t236*t91*t92*t945-6*gammabb*t783*
     ;         t91*t92*t944+6*gammabb*t330*t445*t649*t91*t92-3*t236*t649
     <         *t91*t92+6*t445*t647*t91*t92-3*gammabb*t236*t330*t650*t91
     =         +3*t100*t650*t91-3*gammabb*t236*t331*t649*t91+6*gammabb*t
     >         331*t445*t647*t91-6*t236*t330*t331*t91)-3.75d-1*t836*t943
     ?         +4.810434144489083d-2*t357**3*t835-9.620868288978166d-2*t
     @         357*t507*t697+7.5d-1*t332*t509*t651)-8.400000000000001d+0
     1         *t145*t277*t947-4.9628707825354457d+0*t277*t947-2.7259596
     2         d+0*t141*t947+5.672746666666666d-2*t140*t947+4.7459599999
     3         999996d-2*t110*t947-3.15d+1*t145*t834*t943-1.861076543450
     4         7923d+1*t834*t943-5.4519192d+0*t943-2.52d+1*t277*t332*t69
     5         8+1.423788d-1*t332*t653-6.3d+1*t145*t332*t506*t651-3.7221
     6         530869015845d+1*t332*t506*t651-2.52d+1*t277*t358*t651+1.4
     7         23788d-1*t334*t651-1.6355757600000004d+1*t140*t332*t651+1
     8         .7018239999999996d-1*t332*t651-6.3d+1*t358*t506*t645)-8.8
     9         88888888888888d-1*t146*(-1.4431302433467247d-1*t1*t286*t7
     :         8*t947-2.4682961769030842d-2*t114*t224*t39*t947-5.4117384
     ;         12550218d-1*t1*t575*t78*t943-1.4809777061418505d-1*t114*t
     <         39*t686*t943+6.494086095060261d-1*t1*t332*t350*t651*t78+1
     =         .4809777061418505d-1*t114*t332*t39*t461*t651)+1.352896475
     >         9928536d-2*t1*t110*t286*t332*t701*t78+6.764482379964267d-
     ?         3*t1*t110*t286*t353*t651*t78-1.01467235699464d-2*t1*t110*
     @         t350*t353*t645*t78+2.02934471398928d-2*t1*t286*t332*t334*
     1         t353*t78-3.1639733333333325d-1*t111*t334*t701-2.666666666
     2         6666666d+0*t356*t699-2.6666666666666666d+0*t359*t693-3.16
     3         39733333333325d-1*t111*t353*t653)+7.57211d-1*(-1.64553078
     4         46020562d-2*gammabb*t100*t139*t273*t91*t92*t960-t133*t137
     5         *t273*t960-9.873184707612337d-2*gammabb*t100*t139*t830*t9
     6         1*t92*t956-6*t133*t137*t830*t956-8.227653923010281d-3*gam
     7         mabb*t100*t135*t254*t275*t91*t92*t947-5.0d-1*t133*t135*t2
     8         63*t271*t947+t135*t137*t947+1.6455307846020562d-2*gammabb
     9         *t100*t135*t139*t91*t946-1.6455307846020562d-2*gammabb*t1
     :         35*t139*t236*t91*t92*t945-9.873184707612337d-2*gammabb*t1
     ;         35*t139*t783*t91*t92*t944-1.2341480884515421d-2*gammabb*t
     <         100*t135*t481*t832*t91*t92*t943-6.170740442257711d-3*gamm
     =         abb*t100*t135*t275*t817*t91*t92*t943-1.2341480884515421d-
     >         2*gammabb*t100*t135*t503*t91*t92*t943/t116**2-7.5d-1*t133
     ?         *t135*t491*t828*t943-3.75d-1*t133*t135*t271*t824*t943+1.5
     @         d+0*t135*t497*t675*t943-7.5d-1*t133*t135*t497*t943/t127**
     1         2+7.5d-1*t135*t271*t491*t943+2.4682961769030842d-2*gammab
     2         b*t100*t135*t332*t503*t651*t680*t91*t92-2.468296176903084
     3         2d-2*gammabb*t100*t273*t348*t503*t645*t680*t91*t92-2.4682
     4         961769030842d-2*gammabb*t135*t236*t330*t503*t645*t680*t91
     5         *t92+2.4682961769030842d-2*t100*t135*t503*t645*t680*t91*t
     6         92+9.873184707612337d-2*gammabb*t100*t139*t348*t500*t679*
     7         t91*t92+2.4682961769030842d-2*gammabb*t100*t254*t273*t275
     8         *t332*t679*t91*t92+4.9365923538061685d-2*gammabb*t139*t23
     9         6*t273*t330*t679*t91*t92-4.9365923538061685d-2*t100*t139*
     :         t273*t679*t91*t92-4.9365923538061685d-2*gammabb*t100*t254
     ;         *t275*t332*t500*t676*t91*t92-9.873184707612337d-2*gammabb
     <         *t139*t236*t330*t500*t676*t91*t92+9.873184707612337d-2*t1
     =         00*t139*t500*t676*t91*t92+1.2341480884515421d-2*gammabb*t
     >         100*t135*t275*t332*t481*t651*t91*t92+2.4682961769030842d-
     ?         2*gammabb*t100*t254*t273*t275*t348*t651*t91*t92+2.4682961
     @         769030842d-2*gammabb*t135*t236*t254*t275*t330*t651*t91*t9
     1         2-2.4682961769030842d-2*t100*t135*t254*t275*t651*t91*t92+
     2         9.873184707612337d-2*gammabb*t135*t139*t330*t445*t649*t91
     3         *t92+4.9365923538061685d-2*gammabb*t139*t236*t273*t348*t6
     4         49*t91*t92+2.4682961769030842d-2*gammabb*t135*t236*t254*t
     5         275*t332*t649*t91*t92-4.9365923538061685d-2*t135*t139*t23
     6         6*t649*t91*t92-9.873184707612337d-2*gammabb*t139*t273*t34
     7         8*t445*t647*t91*t92-4.9365923538061685d-2*gammabb*t135*t2
     8         54*t275*t332*t445*t647*t91*t92+9.873184707612337d-2*t135*
     9         t139*t445*t647*t91*t92-1.2341480884515421d-2*gammabb*t100
     :         *t273*t275*t348*t481*t645*t91*t92-1.2341480884515421d-2*g
     ;         ammabb*t135*t236*t275*t330*t481*t645*t91*t92+1.2341480884
     <         515421d-2*t100*t135*t275*t481*t645*t91*t92-4.936592353806
     =         1685d-2*gammabb*t236*t254*t273*t275*t330*t332*t348*t91*t9
     >         2+4.9365923538061685d-2*t100*t254*t273*t275*t332*t348*t91
     ?         *t92+9.873184707612337d-2*t139*t236*t273*t330*t348*t91*t9
     @         2+4.9365923538061685d-2*t135*t236*t254*t275*t330*t332*t91
     1         *t92+2.4682961769030842d-2*gammabb*t100*t135*t331*t503*t6
     2         45*t680*t91-4.9365923538061685d-2*gammabb*t100*t139*t273*
     3         t331*t679*t91+9.873184707612337d-2*gammabb*t100*t139*t331
     4         *t500*t676*t91-2.4682961769030842d-2*gammabb*t100*t135*t2
     5         54*t275*t331*t651*t91-4.9365923538061685d-2*gammabb*t100*
     6         t139*t273*t348*t650*t91-2.4682961769030842d-2*gammabb*t10
     7         0*t135*t254*t275*t332*t650*t91-4.9365923538061685d-2*gamm
     8         abb*t135*t139*t236*t330*t650*t91+4.9365923538061685d-2*t1
     9         00*t135*t139*t650*t91-4.9365923538061685d-2*gammabb*t135*
     :         t139*t236*t331*t649*t91+9.873184707612337d-2*gammabb*t135
     ;         *t139*t331*t445*t647*t91+1.2341480884515421d-2*gammabb*t1
     <         00*t135*t275*t331*t481*t645*t91+4.9365923538061685d-2*gam
     =         mabb*t100*t254*t273*t275*t331*t332*t348*t91+9.87318470761
     >         2337d-2*gammabb*t139*t236*t273*t330*t331*t348*t91-9.87318
     ?         4707612337d-2*t100*t139*t273*t331*t348*t91+4.936592353806
     @         1685d-2*gammabb*t135*t236*t254*t275*t330*t331*t332*t91-4.
     1         9365923538061685d-2*t100*t135*t254*t275*t331*t332*t91-9.8
     2         73184707612337d-2*t135*t139*t236*t330*t331*t91+6*t133*t13
     3         7*t348*t500*t679+1.5d+0*t133*t263*t271*t273*t332*t679-3*t
     4         137*t273*t332*t679-3*t133*t263*t271*t332*t500*t676+6*t137
     5         *t332*t500*t676+1.5d+0*t133*t135*t332*t497*t651*t675-1.5d
     6         +0*t133*t273*t348*t497*t645*t675+7.5d-1*t133*t135*t271*t3
     7         32*t491*t651+1.5d+0*t133*t263*t271*t273*t348*t651-3*t137*
     8         t273*t348*t651-3*t135*t263*t271*t332*t651-7.5d-1*t133*t27
     9         1*t273*t348*t491*t645+3*t263*t271*t273*t348*t645)+t268*(-
     :         2.0d+0*t133*(-1.475609999999999d-1*t124*t266*(t959+t958+t
     ;         957+t955+t954+t953)-1.1067074999999992d-1*t130*t472*t943*
     <         t949-7.378049999999994d-2*t130*t249*t253*t947-5.533537499
     =         999995d-2*t130*t253*t810*t943-1.1067074999999992d-1*t130*
     >         t474*t808*t943-8.853659999999993d-1*t124*t345**3*t823+8.8
     ?         53659999999993d-1*t124*t345*t490*t683+2.2134149999999983d
     @         -1*t249*t253*t266*t332*t683-4.4268299999999966d-1*t249*t2
     1         53*t332*t490*t682+2.2134149999999983d-1*t130*t332*t472*t6
     2         51*t662-2.2134149999999983d-1*t266*t345*t472*t645*t662+1.
     3         1067074999999992d-1*t130*t253*t332*t474*t651+2.2134149999
     4         999983d-1*t249*t253*t266*t345*t651-1.1067074999999992d-1*
     5         t253*t266*t345*t474*t645)-6.0d+0*t332*t684-6.0d+0*t346*t6
     6         51)+t100*t259*t91*(3.2910615692041123d-2*gammabb*t92*(6.0
     7         965d-1*t124*t257*(t955+t954+t953+t952+t951+t950)+4.572375
     8         d-1*t121*t472*t943*t949+3.04825d-1*t121*t249*t253*t947+2.
     9         2861875d-1*t121*t253*t810*t943+4.572375d-1*t121*t474*t808
     :         *t943+3.6579d+0*t124*t339**3*t816-3.6579d+0*t124*t339*t48
     ;         0*t668-9.14475d-1*t249*t253*t257*t332*t668+1.82895d+0*t24
     <         9*t253*t332*t480*t663-9.14475d-1*t121*t332*t472*t651*t662
     =         +9.14475d-1*t257*t339*t472*t645*t662-4.572375d-1*t121*t25
     >         3*t332*t474*t651-9.14475d-1*t249*t253*t257*t339*t651+4.57
     ?         2375d-1*t253*t257*t339*t474*t645)+6.582123138408225d-2*t6
     @         69*t92+6.582123138408225d-2*gammabb*t331*t669+3.291061569
     1         2041123d-2*gammabb*t340*t650+6.582123138408225d-2*t331*t3
     2         40)+5.273288888888887d-2*t111*t113*t948+t113*t286*t78*(-3
     3         .3822411899821336d-3*t1*t110*t947-1.01467235699464d-2*t1*
     4         t332*t653-1.01467235699464d-2*t1*t334*t651)+6.06408316852
     5         6658d-3*t1*t284*t350*t78*t947-4.727288888888889d-2*t107*t
     6         224*t947-2.0d+0*t132*t947+t100*t91*(3.2910615692041123d-2
     7         *gammabb*t126*t946+3.2910615692041123d-2*t259*t669*t92-3.
     8         2910615692041123d-2*t470*t659*t92+3.2910615692041123d-2*g
     9         ammabb*t259*t331*t669-3.2910615692041123d-2*gammabb*t331*
     :         t470*t659+6.582123138408225d-2*gammabb*t259*t340*t650+9.8
     ;         73184707612337d-2*t126*t650+1.316424627681645d-1*t259*t33
     <         1*t340)+t236*t91*(-3.2910615692041123d-2*gammabb*t126*t92
     =         *t945-3.2910615692041123d-2*gammabb*t259*t340*t649*t92-6.
     >         582123138408225d-2*t126*t649*t92-3.2910615692041123d-2*t2
     ?         59*t330*t340*t92-2*t330*t661-3.2910615692041123d-2*gammab
     @         b*t126*t330*t650-t342*t649-6.582123138408225d-2*gammabb*t
     1         126*t331*t649-3.2910615692041123d-2*gammabb*t259*t330*t33
     2         1*t340-6.582123138408225d-2*t126*t330*t331)-1.97463694152
     3         24674d-1*gammabb*t126*t783*t91*t92*t944+5.987181320518676
     4         d-4*t803*t941*t943/(rhob*t104**11)-1.1668349091560873d-2*
     5         t114*t39*t465*t920*t943+8.641318515150488d-2*t1*t284*t78*
     6         t878*t943-1.2683404462433d-2*t1*t110*t113*t575*t78*t943-2
     7         .8363733333333335d-1*t107*t686*t943+t100*t470*t91*(-6.582
     8         123138408225d-2*gammabb*t340*t669*t92-3.2910615692041123d
     9         -2*t659*t92-t340*t670-3.2910615692041123d-2*gammabb*t331*
     :         t659)+t236*t259*t91*(-6.582123138408225d-2*gammabb*t330*t
     ;         669*t92-6.582123138408225d-2*gammabb*t340*t649*t92-6.5821
     <         23138408225d-2*t330*t340*t92-t330*t670-6.582123138408225d
     =         -2*gammabb*t330*t331*t340)+t445*t91*(1.316424627681645d-1
     >         *gammabb*t126*t330*t649*t92+6.582123138408225d-2*t126*t64
     ?         7*t92-2*t330*t671+6.582123138408225d-2*gammabb*t126*t331*
     @         t647)+6.582123138408225d-2*gammabb*t100*t340**3*t806*t91*
     1         t92+9.873184707612337d-2*gammabb*t236*t330*t470*t659*t91*
     2         t92+1.9746369415224674d-1*gammabb*t259*t340*t445*t647*t91
     3         *t92-4.0d+0*t133*t346**3*t822+5.333333333333333d+1*t146*t
     4         149*t353**3*t805+t147*t286*(6.764482379964267d-3*t1*t110*
     5         t332*t701-2.0d+0*t353*t691+6.764482379964267d-3*t1*t110*t
     6         353*t651+6.764482379964267d-3*t1*t332*t334*t353)*t78-1.5d
     7         +0*t113*t332*t350*t691*t78-2.02934471398928d-2*t1*t110*t2
     8         86*t295*t332*t655*t78+t113*t350*(1.01467235699464d-2*t1*t
     9         110*t332*t651+5.0733617849732d-3*t1*t334*t645)*t78-6.3672
     :         87326952992d-2*t1*t284*t332*t575*t651*t78-2.0293447139892
     ;         8d-2*t1*t110*t147*t350*t353*t645*t78+t468*(-4.0d+0*t353*t
     <         704-2.1333333333333332d+1*t146*t149*t353*t701-1.066666666
     =         6666666d+1*t149*t359*t655-1.0666666666666666d+1*t146*t356
     >         *t655)+4.667339636624349d-3*t114*t332*t39*t465*t651*t686+
     ?         t488*(-t346*t685+4.0d+0*t133*t346*t684+2.0d+0*t332*t673)+
     @         2.8363733333333335d-1*t107*t332*t461*t651)*t97*wght
          elseif (rhoa.gt.tol_rho.and.rhob.le.tol_rho) then 
            t1 = param(1)
            t2 = rhoa**3.333333333333333d-1
            t3 = 1/t2
            t4 = t1*t3
            t5 = gammaaa**5.0d-1
            t6 = t5**7
            t7 = 1/rhoa**9.333333333333333d+0
            t8 = gammaaa**3
            t9 = 1/rhoa**8
            t10 = t5**5
            t11 = 1/rhoa**6.666666666666667d+0
            t12 = gammaaa**2
            t13 = 1/rhoa**5.333333333333333d+0
            t14 = t5**3
            t15 = 1/rhoa**4
            t16 = 1/rhoa**2.6666666666666666d+0
            t17 = -4.327677396975467d-7*t8*t9+2.4123830247695402d-8*t6*t
     1         7+2.631878392200375d-4*gammaaa*t16+1.8005513133540818d-4*
     2         t14*t15-4.342399100269002d-5*t12*t13+5.3020963068324d-6*t
     3         10*t11
            t18 = t5**9
            t19 = 1/rhoa**12
            t20 = gammaaa**4
            t21 = 1/rhoa**1.0666666666666666d+1
            t22 = rhoa**1.3333333333333333d+0
            t23 = 1/t22
            t24 = -2.7196832676277033d-6*t8*t9+1.7578986477855002d-7*t6*
     1         t7+6.841322473346062d-1*t23*t5-5.649671283776346d-9*t20*t
     2         21+3.149302550983647d-10*t18*t19-2.0532933130264455d-1*ga
     3         mmaaa*t16+2.342799068769956d-2*t14*t15-1.3837064697606524
     4         d-3*t12*t13+5.955909787676884d-5*t10*t11+1.0d+0
            t25 = 1/t24
            t26 = 1.6455307846020562d-2*gammaaa*t16*t17*t25
            t27 = 6.582123138408225d-2*t4**2.0d+0+t26+6.0965d-1
            t28 = 1/t27
            t29 = t27**5.0d-1
            t30 = 1/t29
            t31 = 2.565564877060844d-1*t1*t3*t30+1.0d+0
            t32 = 1/t31
            t33 = 4.1138269615051404d-3*gammaaa*t16+1.0d+0
            t34 = 1/t33
            t35 = 5.136628594837797d-3*gammaaa*t16*t34+6.934448603031025
     1         d-2*gammaaa*t16*t17*t25+1.0d+0
            t36 = 1.282782438530422d-1*t1*t3*t30+1.0d+0
            t37 = t27*t31
            t38 = 1/t37**2.0d+0
            t39 = t1**2
            t40 = 1/rhoa**6.666666666666666d-1
            t41 = 6.582123138408225d-2*t39*t40
            t42 = t41+t26
            t43 = t42**5.0d-1
            t44 = t41+t26+6.0965d-1
            t45 = t44**5.0d-1
            t46 = t45+t43
            t47 = 1/t46
            t48 = 2.565564877060844d-1*t1*t3
            t49 = t48+t45
            t50 = 1/t49
            t51 = 1.0d+0-6.0965d-1*t47*t50
            t52 = log(t51)
            t53 = t41+t26+7.57211d-1
            t54 = t53**5.0d-1
            t55 = t54+t45
            t56 = 1/t55
            t57 = 1.475609999999999d-1*t50*t56+1.0d+0
            t58 = log(t57)
            t59 = t26+7.57211d-1
            t60 = t54+t43
            t61 = 1/t60
            t62 = t54+t48
            t63 = 1/t62
            t64 = t48+t43
            t65 = 1/t64
            t66 = t26+6.0965d-1
            t67 = t66**2.0d+0
            t68 = t66**3.5d+0
            t69 = (gammaaa*t16*t17*t25)**5.0d-1
            t70 = t59**5.0d-1
            t71 = 1.282782438530422d-1*t69-t70
            t72 = -2.4d+0*t68*t71-1.417963080724413d+0*t68+2.83637333333
     1         3333d-2*t67-9.086532d-1*t66**3.0d+0+4.7459599999999996d-2
     2         *t35*t66
            t73 = 1/t37**3.0d+0
            t74 = t1*t3*t30
            t75 = 2.4682961769030842d-2*t74**2.0d+0+2.8862604866934494d-
     1         1*t1*t3*t30+1.0d+0
            t76 = -8.888888888888888d-1*t72*t73*t75+7.57211d-1*(1.645530
     1         7846020562d-2*gammaaa*t16*t17*t25*t61*t65+t59*t61*t63)-2.
     2         0d+0*t58*t59+3.2910615692041123d-2*gammaaa*t16*t17*t25*t5
     3         2+5.273288888888887d-2*t35*t36*t38+4.727288888888889d-2*t
     4         28*t32-1.0d+0
            t77 = 1/t27**2
            t78 = 1/rhoa**3.6666666666666664d+0
            t79 = -4.38808209227215d-2*gammaaa*t17*t25*t78
            t80 = 1/rhoa**13
            t81 = 1/rhoa**1.1666666666666665d+1
            t82 = 1/rhoa**1.0333333333333333d+1
            t83 = 1/rhoa**9
            t84 = 1/rhoa**7.666666666666667d+0
            t85 = 1/rhoa**6.333333333333333d+0
            t86 = 1/rhoa**5
            t87 = 1/rhoa**2.3333333333333334d+0
            t88 = -9.121763297794749d-1*t5*t87-9.371196275079824d-2*t14*
     1         t86+7.379767838723479d-3*t12*t85-3.970606525117923d-4*t10
     2         *t84+2.1757466141021625d-5*t8*t83-1.6407054045998d-6*t6*t
     3         82+6.026316036028103d-8*t20*t81-3.7791630611803767d-9*t18
     4         *t80+5.475448834737188d-1*gammaaa*t78
            t89 = 1/t24**2
            t90 = -1.6455307846020562d-2*gammaaa*t16*t17*t88*t89
            t91 = -7.202205253416327d-4*t14*t86+2.3159461868101344d-4*t1
     1         2*t85-3.5347308712216d-5*t10*t84+3.462141917580374d-6*t8*
     2         t83-2.2515574897849044d-7*t6*t82-7.018342379201d-4*gammaa
     3         a*t78
            t92 = 1.6455307846020562d-2*gammaaa*t16*t25*t91
            t93 = t92+t90+t79-4.38808209227215d-2*t1*t23*t4
            t94 = 1/t33**2
            t95 = 5.634986987915197d-5*t12*t85*t94+6.934448603031025d-2*
     1         gammaaa*t16*t25*t91-6.934448603031025d-2*gammaaa*t16*t17*
     2         t88*t89-1.369767625290079d-2*gammaaa*t34*t78-1.8491862941
     3         416065d-1*gammaaa*t17*t25*t78
            t96 = 5.273288888888887d-2*t36*t38*t95
            t97 = -8.7761641845443d-2*gammaaa*t17*t25*t52*t78
            t98 = -3.2910615692041123d-2*gammaaa*t16*t17*t52*t88*t89
            t99 = 3.2910615692041123d-2*gammaaa*t16*t25*t52*t91
            t100 = 1/rhoa**1.6666666666666669d+0
            t101 = t92+t90+t79-4.38808209227215d-2*t100*t39
            t102 = 1/t45
            t103 = 5.0d-1*t101*t102
            t104 = -8.551882923536147d-2*t1*t23
            t105 = t104+t103
            t106 = 1/t49**2
            t107 = 1/t43
            t108 = 5.0d-1*t101*t107
            t109 = t108+t103
            t110 = 1/t46**2
            t111 = 6.0965d-1*t109*t110*t50+6.0965d-1*t105*t106*t47
            t112 = 1/t51
            t113 = 3.2910615692041123d-2*gammaaa*t111*t112*t16*t17*t25
            t114 = t92+t90+t79
            t115 = -2.0d+0*t114*t58
            t116 = 1/t54
            t117 = 5.0d-1*t101*t116
            t118 = t117+t103
            t119 = 1/t55**2
            t120 = -1.475609999999999d-1*t105*t106*t56-1.475609999999999
     1         d-1*t118*t119*t50
            t121 = 1/t57
            t122 = -2.0d+0*t120*t121*t59
            t123 = t117+t104
            t124 = 1/t62**2
            t125 = t117+t108
            t126 = 1/t60**2
            t127 = t108+t104
            t128 = 1/t64**2
            t129 = 7.57211d-1*(1.6455307846020562d-2*gammaaa*t16*t25*t61
     1         *t65*t91-1.6455307846020562d-2*gammaaa*t16*t17*t61*t65*t8
     2         8*t89-4.38808209227215d-2*gammaaa*t17*t25*t61*t65*t78-1.6
     3         455307846020562d-2*gammaaa*t125*t126*t16*t17*t25*t65+t114
     4         *t61*t63-t125*t126*t59*t63-t123*t124*t59*t61-1.6455307846
     5         020562d-2*gammaaa*t127*t128*t16*t17*t25*t61)
            t130 = t66**2.5d+0
            t131 = 1/t70
            t132 = 1/t69
            t133 = gammaaa*t16*t25*t91-gammaaa*t16*t17*t88*t89-2.6666666
     1         666666666d+0*gammaaa*t17*t25*t78
            t134 = 6.41391219265211d-2*t132*t133-5.0d-1*t114*t131
            t135 = 4.7459599999999996d-2*t66*t95-8.400000000000001d+0*t1
     1         14*t130*t71-2.4d+0*t134*t68-2.7259596d+0*t114*t67+5.67274
     2         6666666666d-2*t114*t66+4.7459599999999996d-2*t114*t35-4.9
     3         628707825354457d+0*t114*t130
            t136 = -8.888888888888888d-1*t135*t73*t75
            t137 = 1/t31**2
            t138 = -8.551882923536147d-2*t1*t23*t30
            t139 = 1/t29**3
            t140 = t138-1.282782438530422d-1*t1*t139*t3*t93
            t141 = -4.2759414617680735d-2*t1*t23*t30
            t142 = t141-6.41391219265211d-2*t1*t139*t3*t93
            t143 = -9.620868288978164d-2*t1*t23*t30
            t144 = -3.333333333333333d-1*t1*t23*t30
            t145 = t144-5.0d-1*t1*t139*t3*t93
            t146 = -1.4431302433467247d-1*t1*t139*t3*t93+4.9365923538061
     1         685d-2*t145*t74+t143
            t147 = t31*t93+t140*t27
            t148 = 1/t37**4.0d+0
            t149 = t99+t98+t97+t96-4.727288888888889d-2*t32*t77*t93+2.66
     1         66666666666666d+0*t147*t148*t72*t75-8.888888888888888d-1*
     2         t146*t72*t73-1.0546577777777776d-1*t147*t35*t36*t73+5.273
     3         288888888887d-2*t142*t35*t38-4.727288888888889d-2*t137*t1
     4         40*t28+t136+t129+t122+t115+t113
            t150 = 1/t5
            t151 = -8.159049802883108d-6*t12*t9-2.2598685135105387d-8*t2
     1         1*t8+6.15264526724925d-7*t10*t7+1.4171861479426412d-9*t19
     2         *t6+3.514198603154934d-2*t15*t5+3.420661236673031d-1*t150
     3         *t23-2.0532933130264455d-1*t16+1.488977446919221d-4*t11*t
     4         14-2.767412939521305d-3*gammaaa*t13
            t152 = -1.2983032190926402d-6*t12*t9+8.443340586693391d-8*t1
     1         0*t7+2.7008269700311227d-4*t15*t5+2.631878392200375d-4*t1
     2         6+1.3255240767081d-5*t11*t14-8.684798200538004d-5*gammaaa
     3         *t13
            t153 = -1.6455307846020562d-2*gammaaa*t151*t16*t17*t89+1.645
     1         5307846020562d-2*t16*t17*t25+1.6455307846020562d-2*gammaa
     2         a*t152*t16*t25
            t154 = -4.727288888888889d-2*t153*t32*t77
            t155 = -2.113120120468199d-5*gammaaa*t13*t94-6.9344486030310
     1         25d-2*gammaaa*t151*t16*t17*t89+5.136628594837797d-3*t16*t
     2         34+6.934448603031025d-2*t16*t17*t25+6.934448603031025d-2*
     3         gammaaa*t152*t16*t25
            t156 = 5.273288888888887d-2*t155*t36*t38
            t157 = -3.2910615692041123d-2*gammaaa*t151*t16*t17*t52*t89
            t158 = 5.0d-1*t107*t153
            t159 = 5.0d-1*t102*t153
            t160 = t159+t158
            t161 = 6.0965d-1*t110*t160*t50+3.04825d-1*t102*t106*t153*t47
            t162 = 3.2910615692041123d-2*gammaaa*t112*t16*t161*t17*t25
            t163 = 3.2910615692041123d-2*t17*t52+3.2910615692041123d-2*g
     1         ammaaa*t152*t52
            t164 = -2.0d+0*t153*t58
            t165 = 5.0d-1*t116*t153
            t166 = t165+t159
            t167 = -7.378049999999994d-2*t102*t106*t153*t56-1.4756099999
     1         99999d-1*t119*t166*t50
            t168 = -2.0d+0*t121*t167*t59
            t169 = t165+t158
            t170 = 7.57211d-1*(-1.6455307846020562d-2*gammaaa*t151*t16*t
     1         17*t61*t65*t89+1.6455307846020562d-2*t16*t17*t25*t61*t65+
     2         1.6455307846020562d-2*gammaaa*t152*t16*t25*t61*t65-1.6455
     3         307846020562d-2*gammaaa*t126*t16*t169*t17*t25*t65+t153*t6
     4         1*t63-t126*t169*t59*t63-5.0d-1*t116*t124*t153*t59*t61-8.2
     5         27653923010281d-3*gammaaa*t107*t128*t153*t16*t17*t25*t61)
            t171 = 1/t29**5
            t172 = 6.064083168526658d-3*t1*t137*t153*t171*t3
            t173 = -3.3822411899821336d-3*t1*t139*t153*t3*t35*t38
            t174 = t153*t31-1.282782438530422d-1*t1*t153*t3*t30
            t175 = 2.6666666666666666d+0*t148*t174*t72*t75
            t176 = -1.4431302433467247d-1*t1*t139*t153*t3
            t177 = t176-2.4682961769030842d-2*t153*t39*t40*t77
            t178 = -gammaaa*t151*t16*t17*t89+t16*t17*t25+gammaaa*t152*t1
     1         6*t25
            t179 = 6.41391219265211d-2*t132*t178-5.0d-1*t131*t153
            t180 = -8.400000000000001d+0*t130*t153*t71-2.4d+0*t179*t68-2
     1         .7259596d+0*t153*t67+4.7459599999999996d-2*t155*t66+5.672
     2         746666666666d-2*t153*t66+4.7459599999999996d-2*t153*t35-4
     3         .9628707825354457d+0*t130*t153
            t181 = -8.888888888888888d-1*t180*t75-8.888888888888888d-1*t
     1         177*t72-1.0546577777777776d-1*t174*t35*t36
            t182 = 1/rhoa**4.666666666666667d+0
            t183 = 1.6089634338331216d-1*gammaaa*t17*t182*t25
            t184 = 8.7761641845443d-2*gammaaa*t17*t78*t88*t89
            t185 = -8.7761641845443d-2*gammaaa*t25*t78*t91
            t186 = t88**2
            t187 = 1/t24**3
            t188 = 3.2910615692041123d-2*gammaaa*t16*t17*t186*t187
            t189 = 1/rhoa**14
            t190 = 1/rhoa**1.2666666666666665d+1
            t191 = 1/rhoa**1.1333333333333334d+1
            t192 = 1/rhoa**10
            t193 = 1/rhoa**8.666666666666666d+0
            t194 = 1/rhoa**7.333333333333333d+0
            t195 = 1/rhoa**6
            t196 = 1/rhoa**3.3333333333333337d+0
            t197 = -1.9581719526919464d-4*t192*t8+1.695395584753127d-5*t
     1         191*t6+2.1284114361521084d+0*t196*t5-7.030702042032786d-7
     2         *t190*t20+4.685598137539912d-1*t14*t195-4.673852964524870
     3         5d-2*t12*t194+3.0441316692570747d-3*t10*t193+4.9129119795
     4         344894d-8*t18*t189-2.0076645727369685d+0*gammaaa*t182
            t198 = -1.6455307846020562d-2*gammaaa*t16*t17*t197*t89
            t199 = -3.2910615692041123d-2*gammaaa*t16*t88*t89*t91
            t200 = -3.115927725822337d-5*t192*t8+2.326609406111068d-6*t1
     1         91*t6+3.6011026267081636d-3*t14*t195-1.466765918313085d-3
     2         *t12*t194+2.709960334603227d-4*t10*t193+2.573392205707033
     3         5d-3*gammaaa*t182
            t201 = 1.6455307846020562d-2*gammaaa*t16*t200*t25
            t202 = 7.313470153786916d-2*t16*t39+t201+t199+t198+t188+t185
     1         +t184+t183
            t203 = 1/t27**3
            t204 = t93**2
            t205 = 1/t33**3
            t206 = -5.071488289123677d-4*t12*t194*t94-1.386889720606205d
     1         -1*gammaaa*t16*t88*t89*t91-3.698372588283213d-1*gammaaa*t
     2         25*t78*t91+3.698372588283213d-1*gammaaa*t17*t78*t88*t89-6
     3         .934448603031025d-2*gammaaa*t16*t17*t197*t89+1.2363392745
     4         928628d-6*t192*t205*t8+5.02248129273029d-2*gammaaa*t182*t
     5         34+6.934448603031025d-2*gammaaa*t16*t200*t25+6.7803497451
     6         85891d-1*gammaaa*t17*t182*t25+1.386889720606205d-1*gammaa
     7         a*t16*t17*t186*t187
            t207 = 1/t31**3
            t208 = t140**2
            t209 = t147**2
            t210 = 1/t37**5.0d+0
            t211 = t111**2
            t212 = 1/t51**2
            t213 = t105**2
            t214 = 1/t49**3
            t215 = t101**2
            t216 = 1/t45**3
            t217 = -2.5d-1*t215*t216
            t218 = 5.0d-1*t102*t202
            t219 = 1.1402510564714863d-1*t1*t87
            t220 = t219+t218+t217
            t221 = t109**2
            t222 = 1/t46**3
            t223 = 1/t43**3
            t224 = -2.5d-1*t215*t223
            t225 = 5.0d-1*t107*t202
            t226 = t225+t224+t218+t217
            t227 = 6.0965d-1*t110*t226*t50-1.2193000000000001d+0*t221*t2
     1         22*t50+6.0965d-1*t106*t220*t47-1.2193000000000001d+0*t213
     2         *t214*t47-1.2193000000000001d+0*t105*t106*t109*t110
            t228 = t201+t199+t198+t188+t185+t184+t183
            t229 = t120**2
            t230 = 1/t57**2
            t231 = t118**2
            t232 = 1/t55**3
            t233 = 1/t54**3
            t234 = -2.5d-1*t215*t233
            t235 = 5.0d-1*t116*t202
            t236 = t235+t234+t218+t217
            t237 = -1.475609999999999d-1*t106*t220*t56+2.951219999999998
     1         d-1*t213*t214*t56-1.475609999999999d-1*t119*t236*t50+2.95
     2         1219999999998d-1*t231*t232*t50+2.951219999999998d-1*t105*
     3         t106*t118*t119
            t238 = t123**2
            t239 = 1/t62**3
            t240 = t235+t234+t219
            t241 = t125**2
            t242 = 1/t60**3
            t243 = t235+t234+t225+t224
            t244 = t127**2
            t245 = 1/t64**3
            t246 = t225+t224+t219
            t247 = t114**2
            t248 = t66**1.5d+0
            t249 = 1/t69**3
            t250 = t133**2
            t251 = 1/t70**3
            t252 = -2*gammaaa*t16*t88*t89*t91-5.333333333333333d+0*gamma
     1         aa*t25*t78*t91+5.333333333333333d+0*gammaaa*t17*t78*t88*t
     2         89-gammaaa*t16*t17*t197*t89+gammaaa*t16*t200*t25+9.777777
     3         777777779d+0*gammaaa*t17*t182*t25+2*gammaaa*t16*t17*t186*
     4         t187
            t253 = 6.41391219265211d-2*t132*t252+2.5d-1*t247*t251-3.2069
     1         56096326055d-2*t249*t250-5.0d-1*t131*t228
            t254 = 9.491919999999999d-2*t114*t95-2.1d+1*t247*t248*t71-8.
     1         400000000000001d+0*t130*t228*t71-2.4d+0*t253*t68-2.725959
     2         6d+0*t228*t67-5.4519192d+0*t247*t66+5.672746666666666d-2*
     3         t228*t66+4.7459599999999996d-2*t206*t66+4.745959999999999
     4         6d-2*t228*t35-1.2407176956338616d+1*t247*t248+5.672746666
     5         666666d-2*t247-4.9628707825354457d+0*t130*t228-1.68d+1*t1
     6         14*t130*t134
            t255 = 4.2759414617680735d-2*t1*t139*t23*t93+5.7012552823574
     1         31d-2*t1*t30*t87+9.620868288978166d-2*t1*t171*t204*t3-6.4
     2         1391219265211d-2*t1*t139*t202*t3
            t256 = 8.551882923536147d-2*t1*t139*t23*t93+1.14025105647148
     1         63d-1*t1*t30*t87+1.924173657795633d-1*t1*t171*t204*t3-1.2
     2         82782438530422d-1*t1*t139*t202*t3
            t257 = 3.333333333333333d-1*t1*t139*t23*t93+4.44444444444444
     1         4d-1*t1*t30*t87+7.5d-1*t1*t171*t204*t3-5.0d-1*t1*t139*t20
     2         2*t3
            t258 = 9.620868288978164d-2*t1*t139*t23*t93+1.28278243853042
     1         18d-1*t1*t30*t87+4.9365923538061685d-2*t1*t257*t3*t30+2.1
     2         64695365020087d-1*t1*t171*t204*t3-1.4431302433467247d-1*t
     3         1*t139*t202*t3+4.9365923538061685d-2*t145**2
            t259 = 2*t140*t93+t202*t31+t256*t27
            t260 = -2.109315555555555d-1*t147*t36*t73*t95+1.054657777777
     1         7776d-1*t142*t38*t95+9.454577777777778d-2*t137*t140*t77*t
     2         93+7.57211d-1*(-3.2910615692041123d-2*gammaaa*t16*t61*t65
     3         *t88*t89*t91-8.7761641845443d-2*gammaaa*t25*t61*t65*t78*t
     4         91-3.2910615692041123d-2*gammaaa*t125*t126*t16*t25*t65*t9
     5         1-3.2910615692041123d-2*gammaaa*t127*t128*t16*t25*t61*t91
     6         +8.7761641845443d-2*gammaaa*t17*t61*t65*t78*t88*t89+3.291
     7         0615692041123d-2*gammaaa*t125*t126*t16*t17*t65*t88*t89+3.
     8         2910615692041123d-2*gammaaa*t127*t128*t16*t17*t61*t88*t89
     9         -1.6455307846020562d-2*gammaaa*t16*t17*t197*t61*t65*t89+8
     :         .7761641845443d-2*gammaaa*t125*t126*t17*t25*t65*t78+8.776
     ;         1641845443d-2*gammaaa*t127*t128*t17*t25*t61*t78+1.6455307
     <         846020562d-2*gammaaa*t16*t200*t25*t61*t65+1.6089634338331
     =         216d-1*gammaaa*t17*t182*t25*t61*t65+3.2910615692041123d-2
     >         *gammaaa*t16*t17*t186*t187*t61*t65-1.6455307846020562d-2*
     ?         gammaaa*t126*t16*t17*t243*t25*t65+3.2910615692041123d-2*g
     @         ammaaa*t16*t17*t241*t242*t25*t65+t228*t61*t63-t126*t243*t
     1         59*t63+2*t241*t242*t59*t63-2*t114*t125*t126*t63-t124*t240
     2         *t59*t61+2*t238*t239*t59*t61-1.6455307846020562d-2*gammaa
     3         a*t128*t16*t17*t246*t25*t61+3.2910615692041123d-2*gammaaa
     4         *t16*t17*t244*t245*t25*t61-2*t114*t123*t124*t61+2*t123*t1
     5         24*t125*t126*t59+3.2910615692041123d-2*gammaaa*t125*t126*
     6         t127*t128*t16*t17*t25)-6.582123138408225d-2*gammaaa*t16*t
     7         52*t88*t89*t91-1.75523283690886d-1*gammaaa*t25*t52*t78*t9
     8         1+6.582123138408225d-2*gammaaa*t111*t112*t16*t25*t91+1.75
     9         523283690886d-1*gammaaa*t17*t52*t78*t88*t89-6.58212313840
     :         8225d-2*gammaaa*t111*t112*t16*t17*t88*t89-3.2910615692041
     ;         123d-2*gammaaa*t16*t17*t197*t52*t89-1.75523283690886d-1*g
     <         ammaaa*t111*t112*t17*t25*t78-4.727288888888889d-2*t202*t3
     =         2*t77-8.888888888888888d-1*t254*t73*t75+2.666666666666666
     >         6d+0*t148*t259*t72*t75-1.0666666666666666d+1*t209*t210*t7
     ?         2*t75+5.333333333333333d+0*t135*t147*t148*t75-8.888888888
     @         888888d-1*t258*t72*t73-1.0546577777777776d-1*t259*t35*t36
     1         *t73-2.109315555555555d-1*t142*t147*t35*t73-1.77777777777
     2         77776d+0*t135*t146*t73+5.333333333333333d+0*t146*t147*t14
     3         8*t72-2.0d+0*t121*t237*t59+2.0d+0*t229*t230*t59-2.0d+0*t2
     4         28*t58+3.2910615692041123d-2*gammaaa*t16*t200*t25*t52+3.2
     5         17926867666243d-1*gammaaa*t17*t182*t25*t52+6.582123138408
     6         225d-2*gammaaa*t16*t17*t186*t187*t52+5.273288888888887d-2
     7         *t206*t36*t38+5.273288888888887d-2*t255*t35*t38+3.1639733
     8         333333325d-1*t148*t209*t35*t36+9.454577777777778d-2*t203*
     9         t204*t32-4.727288888888889d-2*t137*t256*t28+9.45457777777
     :         7778d-2*t207*t208*t28+3.2910615692041123d-2*gammaaa*t112*
     ;         t16*t17*t227*t25-3.2910615692041123d-2*gammaaa*t16*t17*t2
     <         11*t212*t25-4.0d+0*t114*t120*t121
            t261 = 3.2910615692041123d-2*gammaaa*t152*t16*t25*t52
            t262 = 3.2910615692041123d-2*t16*t17*t25*t52
            t263 = -8.888888888888888d-1*t180*t73*t75
            t264 = t176-2.4682961769030842d-2*t1*t139*t153*t3*t74
            t265 = -1.0546577777777776d-1*t174*t35*t36*t73
            t266 = -4.5608816488973747d-1*t150*t87-1.4056794412619736d-1
     1         *t5*t86+1.4759535677446958d-2*gammaaa*t85-9.9265163127948
     2         08d-4*t14*t84+6.527239842306487d-5*t12*t83-5.742468916099
     3         301d-6*t10*t82+2.4105264144112412d-7*t8*t81-1.70062337753
     4         11694d-8*t6*t80+5.475448834737188d-1*t78
            t267 = -1.0803307880124491d-3*t5*t86+4.631892373620269d-4*ga
     1         mmaaa*t85-8.836827178054d-5*t14*t84+1.0386425752741123d-5
     2         *t12*t83-7.880451214247165d-7*t10*t82-7.018342379201d-4*t
     3         78
            t268 = -1.6455307846020562d-2*gammaaa*t151*t16*t89*t91+1.645
     1         5307846020562d-2*t16*t25*t91-1.6455307846020562d-2*t16*t1
     2         7*t88*t89-1.6455307846020562d-2*gammaaa*t152*t16*t88*t89+
     3         4.38808209227215d-2*gammaaa*t151*t17*t78*t89-1.6455307846
     4         020562d-2*gammaaa*t16*t17*t266*t89+3.2910615692041123d-2*
     5         gammaaa*t151*t16*t17*t187*t88-4.38808209227215d-2*t17*t25
     6         *t78-4.38808209227215d-2*gammaaa*t152*t25*t78+1.645530784
     7         6020562d-2*gammaaa*t16*t25*t267
            t269 = 1.690496096374559d-4*gammaaa*t85*t94-6.93444860303102
     1         5d-2*gammaaa*t151*t16*t89*t91+6.934448603031025d-2*t16*t2
     2         5*t91-6.934448603031025d-2*t16*t17*t88*t89-6.934448603031
     3         025d-2*gammaaa*t152*t16*t88*t89+1.8491862941416065d-1*gam
     4         maaa*t151*t17*t78*t89-6.934448603031025d-2*gammaaa*t16*t1
     5         7*t266*t89+1.386889720606205d-1*gammaaa*t151*t16*t17*t187
     6         *t88-4.6362722797232353d-7*t12*t205*t83-1.369767625290079
     7         d-2*t34*t78-1.8491862941416065d-1*t17*t25*t78-1.849186294
     8         1416065d-1*gammaaa*t152*t25*t78+6.934448603031025d-2*gamm
     9         aaa*t16*t25*t267
            t270 = -2.5d-1*t101*t153*t216
            t271 = 5.0d-1*t102*t268
            t272 = t271+t270
            t273 = -2.5d-1*t101*t153*t223
            t274 = 5.0d-1*t107*t268
            t275 = t274+t273+t271+t270
            t276 = 6.0965d-1*t110*t275*t50-1.2193000000000001d+0*t109*t1
     1         60*t222*t50+6.0965d-1*t106*t272*t47-6.0965d-1*t102*t105*t
     2         153*t214*t47-6.0965d-1*t105*t106*t110*t160-3.04825d-1*t10
     3         2*t106*t109*t110*t153
            t277 = -2.5d-1*t101*t153*t233
            t278 = 5.0d-1*t116*t268
            t279 = t278+t277+t271+t270
            t280 = -1.475609999999999d-1*t106*t272*t56+1.475609999999999
     1         d-1*t102*t105*t153*t214*t56-1.475609999999999d-1*t119*t27
     2         9*t50+2.951219999999998d-1*t118*t166*t232*t50+1.475609999
     3         999999d-1*t105*t106*t119*t166+7.378049999999994d-2*t102*t
     4         106*t118*t119*t153
            t281 = t278+t277
            t282 = t278+t277+t274+t273
            t283 = t274+t273
            t284 = 1/t29**7
            t285 = -gammaaa*t151*t16*t89*t91+t16*t25*t91-t16*t17*t88*t89
     1         -gammaaa*t152*t16*t88*t89+2.6666666666666666d+0*gammaaa*t
     2         151*t17*t78*t89-gammaaa*t16*t17*t266*t89+2*gammaaa*t151*t
     3         16*t17*t187*t88-2.6666666666666666d+0*t17*t25*t78-2.66666
     4         66666666666d+0*gammaaa*t152*t25*t78+gammaaa*t16*t25*t267
            t286 = 6.41391219265211d-2*t132*t285-5.0d-1*t131*t268+2.5d-1
     1         *t114*t153*t251-3.206956096326055d-2*t133*t178*t249
            t287 = 4.7459599999999996d-2*t153*t95-8.400000000000001d+0*t
     1         130*t268*t71-2.1d+1*t114*t153*t248*t71-2.4d+0*t286*t68-2.
     2         7259596d+0*t268*t67+4.7459599999999996d-2*t269*t66+5.6727
     3         46666666666d-2*t268*t66-5.4519192d+0*t114*t153*t66+4.7459
     4         599999999996d-2*t268*t35-4.9628707825354457d+0*t130*t268-
     5         1.2407176956338616d+1*t114*t153*t248-8.400000000000001d+0
     6         *t114*t130*t179+4.7459599999999996d-2*t114*t155-8.4000000
     7         00000001d+0*t130*t134*t153+5.672746666666666d-2*t114*t153
            t288 = 9.620868288978166d-2*t1*t153*t171*t3*t93-6.4139121926
     1         5211d-2*t1*t139*t268*t3+2.1379707308840368d-2*t1*t139*t15
     2         3*t23
            t289 = 1.924173657795633d-1*t1*t153*t171*t3*t93-1.2827824385
     1         30422d-1*t1*t139*t268*t3+4.2759414617680735d-2*t1*t139*t1
     2         53*t23
            t290 = 7.5d-1*t1*t153*t171*t3*t93-5.0d-1*t1*t139*t268*t3+1.6
     1         666666666666666d-1*t1*t139*t153*t23
            t291 = 2.164695365020087d-1*t1*t153*t171*t3*t93+4.9365923538
     1         061685d-2*t1*t290*t3*t30-1.4431302433467247d-1*t1*t139*t2
     2         68*t3-2.4682961769030842d-2*t1*t139*t145*t153*t3+4.810434
     3         144489082d-2*t1*t139*t153*t23
            t292 = -1.282782438530422d-1*t1*t139*t153*t3*t93+t268*t31+t2
     1         7*t289+t140*t153
            t293 = -1.0546577777777776d-1*t174*t36*t73*t95-3.38224118998
     1         21336d-3*t1*t139*t153*t3*t38*t95+9.454577777777778d-2*t15
     2         3*t203*t32*t93-6.064083168526658d-3*t1*t137*t153*t284*t3*
     3         t93+7.57211d-1*(-1.6455307846020562d-2*gammaaa*t151*t16*t
     4         61*t65*t89*t91+1.6455307846020562d-2*t16*t25*t61*t65*t91-
     5         1.6455307846020562d-2*gammaaa*t126*t16*t169*t25*t65*t91-8
     6         .227653923010281d-3*gammaaa*t107*t128*t153*t16*t25*t61*t9
     7         1-1.6455307846020562d-2*t16*t17*t61*t65*t88*t89-1.6455307
     8         846020562d-2*gammaaa*t152*t16*t61*t65*t88*t89+1.645530784
     9         6020562d-2*gammaaa*t126*t16*t169*t17*t65*t88*t89+8.227653
     :         923010281d-3*gammaaa*t107*t128*t153*t16*t17*t61*t88*t89+4
     ;         .38808209227215d-2*gammaaa*t151*t17*t61*t65*t78*t89-1.645
     <         5307846020562d-2*gammaaa*t16*t17*t266*t61*t65*t89+1.64553
     =         07846020562d-2*gammaaa*t125*t126*t151*t16*t17*t65*t89+1.6
     >         455307846020562d-2*gammaaa*t127*t128*t151*t16*t17*t61*t89
     ?         +3.2910615692041123d-2*gammaaa*t151*t16*t17*t187*t61*t65*
     @         t88-4.38808209227215d-2*t17*t25*t61*t65*t78-4.38808209227
     1         215d-2*gammaaa*t152*t25*t61*t65*t78+4.38808209227215d-2*g
     2         ammaaa*t126*t169*t17*t25*t65*t78+2.194041046136075d-2*gam
     3         maaa*t107*t128*t153*t17*t25*t61*t78+1.6455307846020562d-2
     4         *gammaaa*t16*t25*t267*t61*t65-1.6455307846020562d-2*gamma
     5         aa*t126*t16*t17*t25*t282*t65+3.2910615692041123d-2*gammaa
     6         a*t125*t16*t169*t17*t242*t25*t65-1.6455307846020562d-2*t1
     7         25*t126*t16*t17*t25*t65-1.6455307846020562d-2*gammaaa*t12
     8         5*t126*t152*t16*t25*t65+t268*t61*t63-t126*t282*t59*t63+2*
     9         t125*t169*t242*t59*t63-t114*t126*t169*t63-t125*t126*t153*
     :         t63-t124*t281*t59*t61+t116*t123*t153*t239*t59*t61-1.64553
     ;         07846020562d-2*gammaaa*t128*t16*t17*t25*t283*t61+1.645530
     <         7846020562d-2*gammaaa*t107*t127*t153*t16*t17*t245*t25*t61
     =         -1.6455307846020562d-2*t127*t128*t16*t17*t25*t61-1.645530
     >         7846020562d-2*gammaaa*t127*t128*t152*t16*t25*t61-t123*t12
     ?         4*t153*t61-5.0d-1*t114*t116*t124*t153*t61+t123*t124*t126*
     @         t169*t59+5.0d-1*t116*t124*t125*t126*t153*t59+1.6455307846
     1         020562d-2*gammaaa*t126*t127*t128*t16*t169*t17*t25+8.22765
     2         3923010281d-3*gammaaa*t107*t125*t126*t128*t153*t16*t17*t2
     3         5)-3.2910615692041123d-2*gammaaa*t151*t16*t52*t89*t91+3.2
     4         910615692041123d-2*t16*t25*t52*t91+3.2910615692041123d-2*
     5         gammaaa*t112*t16*t161*t25*t91-3.2910615692041123d-2*t16*t
     6         17*t52*t88*t89-3.2910615692041123d-2*gammaaa*t152*t16*t52
     7         *t88*t89-3.2910615692041123d-2*gammaaa*t112*t16*t161*t17*
     8         t88*t89+8.7761641845443d-2*gammaaa*t151*t17*t52*t78*t89-3
     9         .2910615692041123d-2*gammaaa*t16*t17*t266*t52*t89-3.29106
     :         15692041123d-2*gammaaa*t111*t112*t151*t16*t17*t89+6.58212
     ;         3138408225d-2*gammaaa*t151*t16*t17*t187*t52*t88-8.7761641
     <         845443d-2*t17*t25*t52*t78-8.7761641845443d-2*gammaaa*t152
     =         *t25*t52*t78-8.7761641845443d-2*gammaaa*t112*t161*t17*t25
     >         *t78-4.727288888888889d-2*t268*t32*t77+4.727288888888889d
     ?         -2*t137*t140*t153*t77-8.888888888888888d-1*t287*t73*t75+2
     @         .6666666666666666d+0*t148*t292*t72*t75-1.0666666666666666
     1         d+1*t147*t174*t210*t72*t75+2.6666666666666666d+0*t147*t14
     2         8*t180*t75+2.6666666666666666d+0*t135*t148*t174*t75-8.888
     3         888888888888d-1*t291*t72*t73-1.0546577777777776d-1*t292*t
     4         35*t36*t73-1.0546577777777776d-1*t147*t155*t36*t73+6.7644
     5         82379964267d-3*t1*t139*t147*t153*t3*t35*t73-1.05465777777
     6         77776d-1*t142*t174*t35*t73-8.888888888888888d-1*t135*t264
     7         *t73-8.888888888888888d-1*t146*t180*t73+2.666666666666666
     8         6d+0*t147*t148*t264*t72+2.6666666666666666d+0*t146*t148*t
     9         174*t72-2.0d+0*t121*t280*t59+2.0d+0*t120*t167*t230*t59-2.
     :         0d+0*t268*t58+3.2910615692041123d-2*gammaaa*t16*t25*t267*
     ;         t52+5.273288888888887d-2*t269*t36*t38+5.273288888888887d-
     <         2*t288*t35*t38+5.273288888888887d-2*t142*t155*t38+3.16397
     =         33333333325d-1*t147*t148*t174*t35*t36-1.2128166337053317d
     >         -2*t1*t140*t153*t171*t207*t3-4.727288888888889d-2*t137*t2
     ?         8*t289+3.2910615692041123d-2*gammaaa*t112*t16*t17*t25*t27
     @         6-3.2910615692041123d-2*gammaaa*t111*t16*t161*t17*t212*t2
     1         5+3.2910615692041123d-2*t111*t112*t16*t17*t25+3.291061569
     2         2041123d-2*gammaaa*t111*t112*t152*t16*t25-2.0d+0*t114*t12
     3         1*t167-2.0d+0*t120*t121*t153
            t294 = t153**2
            t295 = 9.454577777777778d-2*t203*t294*t32
            t296 = t151**2
            t297 = 1/t14
            t298 = -1.6318099605766218d-5*gammaaa*t9+1.5381613168123123d
     1         -6*t14*t7+2.2334661703788317d-4*t11*t5-1.7103306183365155
     2         d-1*t23*t297-6.779605540531617d-8*t12*t21+4.9601515177992
     3         45d-9*t10*t19+1.757099301577467d-2*t15*t150-2.76741293952
     4         1305d-3*t13
            t299 = -2.5966064381852805d-6*gammaaa*t9+2.1108351466733477d
     1         -7*t14*t7+1.9882861150621498d-5*t11*t5+1.3504134850155614
     2         d-4*t15*t150-8.684798200538004d-5*t13
            t300 = -1.6455307846020562d-2*gammaaa*t16*t17*t298*t89-3.291
     1         0615692041123d-2*t151*t16*t17*t89-3.2910615692041123d-2*g
     2         ammaaa*t151*t152*t16*t89+1.6455307846020562d-2*gammaaa*t1
     3         6*t25*t299+3.2910615692041123d-2*gammaaa*t16*t17*t187*t29
     4         6+3.2910615692041123d-2*t152*t16*t25
            t301 = -4.727288888888889d-2*t300*t32*t77
            t302 = -4.226240240936398d-5*t13*t94+1.7386021048962136d-7*g
     1         ammaaa*t205*t9-6.934448603031025d-2*gammaaa*t16*t17*t298*
     2         t89-1.386889720606205d-1*t151*t16*t17*t89-1.3868897206062
     3         05d-1*gammaaa*t151*t152*t16*t89+6.934448603031025d-2*gamm
     4         aaa*t16*t25*t299+1.386889720606205d-1*gammaaa*t16*t17*t18
     5         7*t296+1.386889720606205d-1*t152*t16*t25
            t303 = 5.273288888888887d-2*t302*t36*t38
            t304 = t174**2
            t305 = -1.0666666666666666d+1*t210*t304*t72*t75
            t306 = 6.582123138408225d-2*gammaaa*t16*t17*t187*t296*t52
            t307 = -6.582123138408225d-2*gammaaa*t112*t151*t16*t161*t17*
     1         t89
            t308 = t161**2
            t309 = -3.2910615692041123d-2*gammaaa*t16*t17*t212*t25*t308
            t310 = 3.2910615692041123d-2*gammaaa*t299*t52+6.582123138408
     1         225d-2*t152*t52+3.2910615692041123d-2*t112*t161*t17+3.291
     2         0615692041123d-2*gammaaa*t112*t152*t161
            t311 = 1/t44
            t312 = t160**2
            t313 = -2.5d-1*t223*t294
            t314 = 5.0d-1*t107*t300
            t315 = -2.5d-1*t216*t294
            t316 = 5.0d-1*t102*t300
            t317 = t316+t315+t314+t313
            t318 = 6.0965d-1*t110*t317*t50-1.2193000000000001d+0*t222*t3
     1         12*t50-3.04825d-1*t214*t294*t311*t47+3.04825d-1*t102*t106
     2         *t300*t47-1.524125d-1*t106*t216*t294*t47-6.0965d-1*t102*t
     3         106*t110*t153*t160
            t319 = 3.2910615692041123d-2*gammaaa*t17*t318+3.291061569204
     1         1123d-2*t161*t17+3.2910615692041123d-2*gammaaa*t152*t161
            t320 = -3.2910615692041123d-2*gammaaa*t17*t298*t52-3.2910615
     1         692041123d-2*t151*t17*t52-3.2910615692041123d-2*gammaaa*t
     2         151*t152*t52-t151*t163
            t321 = -2.0d+0*t300*t58
            t322 = t167**2
            t323 = 2.0d+0*t230*t322*t59
            t324 = 1/t53
            t325 = t169**2
            t326 = -2.5d-1*t233*t294
            t327 = 5.0d-1*t116*t300
            t328 = t327+t326+t314+t313
            t329 = 1/t42
            t330 = 7.57211d-1*(-1.6455307846020562d-2*gammaaa*t16*t17*t2
     1         98*t61*t65*t89-3.2910615692041123d-2*t151*t16*t17*t61*t65
     2         *t89-3.2910615692041123d-2*gammaaa*t151*t152*t16*t61*t65*
     3         t89+3.2910615692041123d-2*gammaaa*t126*t151*t16*t169*t17*
     4         t65*t89+1.6455307846020562d-2*gammaaa*t107*t128*t151*t153
     5         *t16*t17*t61*t89+1.6455307846020562d-2*gammaaa*t16*t25*t2
     6         99*t61*t65+3.2910615692041123d-2*gammaaa*t16*t17*t187*t29
     7         6*t61*t65+3.2910615692041123d-2*t152*t16*t25*t61*t65-1.64
     8         55307846020562d-2*gammaaa*t126*t16*t17*t25*t328*t65+3.291
     9         0615692041123d-2*gammaaa*t16*t17*t242*t25*t325*t65-3.2910
     :         615692041123d-2*t126*t16*t169*t17*t25*t65-3.2910615692041
     ;         123d-2*gammaaa*t126*t152*t16*t169*t25*t65+t300*t61*t63-t1
     <         26*t328*t59*t63+2*t242*t325*t59*t63-2*t126*t153*t169*t63+
     =         5.0d-1*t239*t294*t324*t59*t61-5.0d-1*t116*t124*t300*t59*t
     >         61+2.5d-1*t124*t233*t294*t59*t61+8.227653923010281d-3*gam
     ?         maaa*t16*t17*t245*t25*t294*t329*t61-8.227653923010281d-3*
     @         gammaaa*t107*t128*t16*t17*t25*t300*t61+4.1138269615051404
     1         d-3*gammaaa*t128*t16*t17*t223*t25*t294*t61-t116*t124*t294
     2         *t61-1.6455307846020562d-2*t107*t128*t153*t16*t17*t25*t61
     3         -1.6455307846020562d-2*gammaaa*t107*t128*t152*t153*t16*t2
     4         5*t61+t116*t124*t126*t153*t169*t59+1.6455307846020562d-2*
     5         gammaaa*t107*t126*t128*t153*t16*t169*t17*t25)
            t331 = t166**2
            t332 = t327+t326+t316+t315
            t333 = 7.378049999999994d-2*t214*t294*t311*t56-7.37804999999
     1         9994d-2*t102*t106*t300*t56+3.689024999999997d-2*t106*t216
     2         *t294*t56-1.475609999999999d-1*t119*t332*t50+2.9512199999
     3         99998d-1*t232*t331*t50+1.475609999999999d-1*t102*t106*t11
     4         9*t153*t166
            t334 = -2.0d+0*t333*t59-4.0d+0*t153*t167
            t335 = 1/t27**4
            t336 = 1.5557798788747831d-3*t207*t294*t335*t39*t40
            t337 = -2.1224291089843306d-2*t1*t137*t284*t294*t3
            t338 = 6.064083168526658d-3*t1*t137*t171*t3*t300
            t339 = 5.0733617849732d-3*t1*t171*t294*t3*t35*t38
            t340 = -3.3822411899821336d-3*t1*t300*t35-6.764482379964267d
     1         -3*t1*t153*t155
            t341 = 6.764482379964267d-3*t1*t139*t153*t174*t3*t35
            t342 = -2.4682961769030842d-2*t300*t39*t40*t77+4.93659235380
     1         61685d-2*t203*t294*t39*t40-1.4431302433467247d-1*t1*t139*
     2         t3*t300+2.164695365020087d-1*t1*t171*t294*t3
            t343 = -8.888888888888888d-1*t342*t72
            t344 = -1.7777777777777776d+0*t177*t180
            t345 = t178**2
            t346 = -gammaaa*t16*t17*t298*t89-2*t151*t16*t17*t89-2*gammaa
     1         a*t151*t152*t16*t89+gammaaa*t16*t25*t299+2*gammaaa*t16*t1
     2         7*t187*t296+2*t152*t16*t25
            t347 = 6.41391219265211d-2*t132*t346-3.206956096326055d-2*t2
     1         49*t345-5.0d-1*t131*t300+2.5d-1*t251*t294
            t348 = -8.400000000000001d+0*t130*t300*t71-2.1d+1*t248*t294*
     1         t71-2.4d+0*t347*t68-2.7259596d+0*t300*t67+4.7459599999999
     2         996d-2*t302*t66+5.672746666666666d-2*t300*t66-5.4519192d+
     3         0*t294*t66+4.7459599999999996d-2*t300*t35-4.9628707825354
     4         457d+0*t130*t300-1.2407176956338616d+1*t248*t294+5.672746
     5         666666666d-2*t294-1.68d+1*t130*t153*t179+9.49191999999999
     6         9d-2*t153*t155
            t349 = -8.888888888888888d-1*t348*t75
            t350 = t300*t31-1.282782438530422d-1*t1*t3*t30*t300-6.413912
     1         19265211d-2*t1*t139*t294*t3
            t351 = -1.0546577777777776d-1*t35*t350*t36
            t352 = -2.109315555555555d-1*t155*t174*t36+t351+t349+t344+t3
     1         43+t341
            t353 = 2.6666666666666666d+0*t350*t72*t75+2.6666666666666666
     1         d+0*t174*t180*t75+2.6666666666666666d+0*t174*t177*t72-3.0
     2         d+0*t174*t181
            t354 = t138-1.282782438530422d-1*t1*t101*t139*t3
            t355 = t27*t354+t101*t31
            t356 = 1/rhoa**5.666666666666667d+0
            t357 = -7.508496024554567d-1*gammaaa*t17*t25*t356
            t358 = -4.8268903014993647d-1*gammaaa*t17*t182*t88*t89
            t359 = 4.8268903014993647d-1*gammaaa*t182*t25*t91
            t360 = -2.63284925536329d-1*gammaaa*t17*t186*t187*t78
            t361 = 1.316424627681645d-1*gammaaa*t17*t197*t78*t89
            t362 = 2.63284925536329d-1*gammaaa*t78*t88*t89*t91
            t363 = -1.316424627681645d-1*gammaaa*t200*t25*t78
            t364 = t88**3
            t365 = 1/t24**4
            t366 = -9.873184707612337d-2*gammaaa*t16*t17*t364*t365
            t367 = 9.873184707612337d-2*gammaaa*t16*t186*t187*t91
            t368 = 9.873184707612337d-2*gammaaa*t16*t17*t187*t197*t88
            t369 = -4.9365923538061685d-2*gammaaa*t16*t197*t89*t91
            t370 = 1/rhoa**1.3666666666666666d+1
            t371 = 1/rhoa**1.2333333333333334d+1
            t372 = 1/rhoa**11
            t373 = 1/rhoa**9.666666666666666d+0
            t374 = 1/rhoa**8.333333333333334d+0
            t375 = 1/rhoa**7
            t376 = 1.958171952691946d-3*t372*t8-1.9214483293868775d-4*t3
     1         71*t6-7.094704787173696d+0*t5/rhoa**4.333333333333333d+0-
     2         2.811358882523947d+0*t14*t375+3.4274921739849046d-1*t12*t
     3         374-2.6382474466894645d-2*t10*t373+8.905555919908195d-6*t
     4         20*t370+9.369101339439189d+0*gammaaa*t356-6.8780767713482
     5         86d-7*t18/rhoa**15
            t377 = -1.6455307846020562d-2*gammaaa*t16*t17*t376*t89
            t378 = -4.9365923538061685d-2*gammaaa*t16*t200*t88*t89
            t379 = 3.115927725822337d-4*t372*t8-2.636823993592544d-5*t37
     1         1*t6-2.1606615760248984d-2*t14*t375+1.0756283400962623d-2
     2         *t12*t374-2.3486322899894632d-3*t10*t373-1.20091636266328
     3         24d-2*gammaaa*t356
            t380 = 1.6455307846020562d-2*gammaaa*t16*t25*t379
            t381 = -1.950258707676511d-1*t39*t78+t380+t378+t377+t369+t36
     1         8+t367+t366+t363+t362+t361+t360+t359+t358+t357
            t382 = t93**3
            t383 = 1/t33**4
            t384 = 4.270067917509071d-3*t12*t374*t94+1.1095117764849638d
     1         +0*gammaaa*t78*t88*t89*t91-2.0803345809093077d-1*gammaaa*
     2         t16*t197*t89*t91+2.034104923555767d+0*gammaaa*t182*t25*t9
     3         1+4.1606691618186153d-1*gammaaa*t16*t186*t187*t91-2.08033
     4         45809093077d-1*gammaaa*t16*t200*t88*t89-2.034104923555767
     5         d+0*gammaaa*t17*t182*t88*t89+5.547558882424819d-1*gammaaa
     6         *t17*t197*t78*t89-6.934448603031025d-2*gammaaa*t16*t17*t3
     7         76*t89+4.1606691618186153d-1*gammaaa*t16*t17*t187*t197*t8
     8         8-2.349044621726439d-5*t205*t372*t8-5.547558882424819d-1*
     9         gammaaa*t200*t25*t78-1.1095117764849638d+0*gammaaa*t17*t1
     :         86*t187*t78+4.0688686731102613d-8*t20*t370*t383+6.9344486
     ;         03031025d-2*gammaaa*t16*t25*t379-4.1606691618186153d-1*ga
     <         mmaaa*t16*t17*t364*t365-2.3438246032741353d-1*gammaaa*t34
     =         *t356-3.1641632144200826d+0*gammaaa*t17*t25*t356
            t385 = 1/t31**4
            t386 = t147**3
            t387 = 1/t37**6.0d+0
            t388 = 1/t51**3
            t389 = t105**3
            t390 = 1/t49**4
            t391 = t101**3
            t392 = 1/t45**5
            t393 = 3.75d-1*t391*t392
            t394 = -7.5d-1*t101*t202*t216
            t395 = 5.0d-1*t102*t381
            t396 = -2.660585798433468d-1*t1*t196
            t397 = t396+t395+t394+t393
            t398 = 1/t46**4
            t399 = 1/t43**5
            t400 = 3.75d-1*t391*t399
            t401 = -7.5d-1*t101*t202*t223
            t402 = 5.0d-1*t107*t381
            t403 = t380+t378+t377+t369+t368+t367+t366+t363+t362+t361+t36
     1         0+t359+t358+t357
            t404 = 1/t57**3
            t405 = 1/t55**4
            t406 = 1/t54**5
            t407 = 3.75d-1*t391*t406
            t408 = -7.5d-1*t101*t202*t233
            t409 = 5.0d-1*t116*t381
            t410 = 1/t62**4
            t411 = t125**3
            t412 = 1/t60**4
            t413 = t409+t408+t407+t402+t401+t400
            t414 = 1/t64**4
            t415 = t114**3
            t416 = t66**5.0d-1
            t417 = 1/t69**5
            t418 = 1/t70**5
            t419 = -1.7103765847072294d-1*t1*t139*t87*t93+5.772520973386
     1         899d-1*t1*t171*t202*t3*t93-4.810434144489083d-1*t1*t284*t
     2         3*t382-1.282782438530422d-1*t1*t139*t3*t381-2.66058579843
     3         3468d-1*t1*t196*t30-1.924173657795633d-1*t1*t171*t204*t23
     4         +1.282782438530422d-1*t1*t139*t202*t23
            t420 = 3*t256*t93+t27*t419+t31*t381+3*t140*t202
            t421 = -2.812280816813114d-6*t190*t8+2.2108103907905202d-7*t
     1         189*t6+7.028397206309868d-1*t195*t5+1.0642057180760542d+0
     2         *t150*t196-9.347705929049741d-2*gammaaa*t194+7.6103291731
     3         42687d-3*t14*t193-5.874515858075838d-4*t12*t192+5.9338845
     4         46635945d-5*t10*t191-2.0076645727369685d+0*t182
            t422 = 5.401653940062247d-3*t195*t5-2.93353183662617d-3*gamm
     1         aaa*t194+6.774900836508068d-4*t14*t193-9.347783177467011d
     2         -5*t12*t192+8.143132921388737d-6*t10*t191+2.5733922057070
     3         335d-3*t182
            t423 = -3.2910615692041123d-2*t16*t88*t89*t91+8.776164184544
     1         3d-2*gammaaa*t151*t78*t89*t91-3.2910615692041123d-2*gamma
     2         aa*t16*t266*t89*t91+6.582123138408225d-2*gammaaa*t151*t16
     3         *t187*t88*t91-8.7761641845443d-2*t25*t78*t91+8.7761641845
     4         443d-2*t17*t78*t88*t89+8.7761641845443d-2*gammaaa*t152*t7
     5         8*t88*t89-3.2910615692041123d-2*gammaaa*t16*t267*t88*t89+
     6         8.7761641845443d-2*gammaaa*t17*t266*t78*t89-1.64553078460
     7         20562d-2*gammaaa*t16*t17*t421*t89-1.6455307846020562d-2*g
     8         ammaaa*t151*t16*t200*t89-1.6455307846020562d-2*t16*t17*t1
     9         97*t89-1.6455307846020562d-2*gammaaa*t152*t16*t197*t89-1.
     :         6089634338331216d-1*gammaaa*t151*t17*t182*t89-1.755232836
     ;         90886d-1*gammaaa*t151*t17*t187*t78*t88+6.582123138408225d
     <         -2*gammaaa*t16*t17*t187*t266*t88-8.7761641845443d-2*gamma
     =         aa*t25*t267*t78+1.6455307846020562d-2*gammaaa*t16*t25*t42
     >         2-9.873184707612337d-2*gammaaa*t151*t16*t17*t186*t365+1.6
     ?         455307846020562d-2*t16*t200*t25+1.6089634338331216d-1*t17
     @         *t182*t25+1.6089634338331216d-1*gammaaa*t152*t182*t25+3.2
     1         910615692041123d-2*gammaaa*t151*t16*t17*t187*t197+3.29106
     2         15692041123d-2*t16*t17*t186*t187+3.2910615692041123d-2*ga
     3         mmaaa*t152*t16*t186*t187
            t424 = -1.220913847381626d-3*gammaaa*t194*t94-1.386889720606
     1         205d-1*t16*t88*t89*t91+3.698372588283213d-1*gammaaa*t151*
     2         t78*t89*t91-1.386889720606205d-1*gammaaa*t16*t266*t89*t91
     3         +2.77377944121241d-1*gammaaa*t151*t16*t187*t88*t91-3.6983
     4         72588283213d-1*t25*t78*t91+3.698372588283213d-1*t17*t78*t
     5         88*t89+3.698372588283213d-1*gammaaa*t152*t78*t88*t89-1.38
     6         6889720606205d-1*gammaaa*t16*t267*t88*t89+3.6983725882832
     7         13d-1*gammaaa*t17*t266*t78*t89-6.934448603031025d-2*gamma
     8         aa*t16*t17*t421*t89-6.934448603031025d-2*gammaaa*t151*t16
     9         *t200*t89-6.934448603031025d-2*t16*t17*t197*t89-6.9344486
     :         03031025d-2*gammaaa*t152*t16*t197*t89-6.780349745185891d-
     ;         1*gammaaa*t151*t17*t182*t89-7.396745176566426d-1*gammaaa*
     <         t151*t17*t187*t78*t88+2.77377944121241d-1*gammaaa*t16*t17
     =         *t187*t266*t88-1.525825752416348d-8*t190*t383*t8-3.698372
     >         588283213d-1*gammaaa*t25*t267*t78+6.934448603031025d-2*ga
     ?         mmaaa*t16*t25*t422-4.1606691618186153d-1*gammaaa*t151*t16
     @         *t17*t186*t365+5.02248129273029d-2*t182*t34+6.93444860303
     1         1025d-2*t16*t200*t25+6.780349745185891d-1*t17*t182*t25+6.
     2         780349745185891d-1*gammaaa*t152*t182*t25+7.88166287552949
     3         9d-6*t12*t192*t205+1.386889720606205d-1*gammaaa*t151*t16*
     4         t17*t187*t197+1.386889720606205d-1*t16*t17*t186*t187+1.38
     5         6889720606205d-1*gammaaa*t152*t16*t186*t187
            t425 = 3.75d-1*t153*t215*t392
            t426 = -2.5d-1*t153*t202*t216
            t427 = -5.0d-1*t101*t216*t268
            t428 = 5.0d-1*t102*t423
            t429 = t428+t427+t426+t425
            t430 = 3.75d-1*t153*t215*t399
            t431 = -2.5d-1*t153*t202*t223
            t432 = -5.0d-1*t101*t223*t268
            t433 = 5.0d-1*t107*t423
            t434 = 3.75d-1*t153*t215*t406
            t435 = -2.5d-1*t153*t202*t233
            t436 = -5.0d-1*t101*t233*t268
            t437 = 5.0d-1*t116*t423
            t438 = t437+t436+t435+t434+t433+t432+t431+t430
            t439 = 1/t29**9
            t440 = 3.848347315591266d-1*t1*t171*t268*t3*t93-1.2827824385
     1         30422d-1*t1*t153*t171*t23*t93-5.701255282357431d-2*t1*t13
     2         9*t153*t87-1.282782438530422d-1*t1*t139*t3*t423-4.8104341
     3         44489083d-1*t1*t153*t204*t284*t3+1.924173657795633d-1*t1*
     4         t153*t171*t202*t3+8.551882923536147d-2*t1*t139*t23*t268
            t441 = 2*t289*t93+t27*t440+t31*t423-1.282782438530422d-1*t1*
     1         t139*t153*t202*t3+2*t140*t268+t153*t256
            t442 = 2.2804408244486873d-1*t297*t87-7.028397206309868d-2*t
     1         150*t86+1.4759535677446958d-2*t85-1.488977446919221d-3*t5
     2         *t84+1.3054479684612974d-4*gammaaa*t83-1.4356172290248254
     3         d-5*t14*t82+7.231579243233723d-7*t12*t81-5.95218182135909
     4         4d-8*t10*t80
            t443 = -5.401653940062245d-4*t150*t86+4.631892373620269d-4*t
     1         85-1.3255240767081d-4*t5*t84+2.0772851505482245d-5*gammaa
     2         a*t83-1.9701128035617912d-6*t14*t82
            t444 = -1.6455307846020562d-2*gammaaa*t16*t298*t89*t91-3.291
     1         0615692041123d-2*t151*t16*t89*t91+3.2910615692041123d-2*g
     2         ammaaa*t16*t187*t296*t91-1.6455307846020562d-2*gammaaa*t1
     3         6*t299*t88*t89-3.2910615692041123d-2*t152*t16*t88*t89+4.3
     4         8808209227215d-2*gammaaa*t17*t298*t78*t89+8.7761641845443
     5         d-2*t151*t17*t78*t89+8.7761641845443d-2*gammaaa*t151*t152
     6         *t78*t89-1.6455307846020562d-2*gammaaa*t16*t17*t442*t89-3
     7         .2910615692041123d-2*gammaaa*t151*t16*t267*t89-3.29106156
     8         92041123d-2*t16*t17*t266*t89-3.2910615692041123d-2*gammaa
     9         a*t152*t16*t266*t89-9.873184707612337d-2*gammaaa*t16*t17*
     :         t296*t365*t88+3.2910615692041123d-2*gammaaa*t16*t17*t187*
     ;         t298*t88+6.582123138408225d-2*t151*t16*t17*t187*t88+6.582
     <         123138408225d-2*gammaaa*t151*t152*t16*t187*t88-4.38808209
     =         227215d-2*gammaaa*t25*t299*t78-8.7761641845443d-2*gammaaa
     >         *t17*t187*t296*t78-8.7761641845443d-2*t152*t25*t78+1.6455
     ?         307846020562d-2*gammaaa*t16*t25*t443+3.2910615692041123d-
     @         2*t16*t25*t267+6.582123138408225d-2*gammaaa*t151*t16*t17*
     1         t187*t266
            t445 = 2.2539947951660788d-4*t85*t94-6.934448603031025d-2*ga
     1         mmaaa*t16*t298*t89*t91-1.386889720606205d-1*t151*t16*t89*
     2         t91+1.386889720606205d-1*gammaaa*t16*t187*t296*t91-6.9344
     3         48603031025d-2*gammaaa*t16*t299*t88*t89-1.386889720606205
     4         d-1*t152*t16*t88*t89+1.8491862941416065d-1*gammaaa*t17*t2
     5         98*t78*t89+3.698372588283213d-1*t151*t17*t78*t89+3.698372
     6         588283213d-1*gammaaa*t151*t152*t78*t89-6.934448603031025d
     7         -2*gammaaa*t16*t17*t442*t89-1.386889720606205d-1*gammaaa*
     8         t151*t16*t267*t89-1.386889720606205d-1*t16*t17*t266*t89-1
     9         .386889720606205d-1*gammaaa*t152*t16*t266*t89-4.160669161
     :         8186153d-1*gammaaa*t16*t17*t296*t365*t88+1.38688972060620
     ;         5d-1*gammaaa*t16*t17*t187*t298*t88+2.77377944121241d-1*t1
     <         51*t16*t17*t187*t88+2.77377944121241d-1*gammaaa*t151*t152
     =         *t16*t187*t88-2.318136139861618d-6*gammaaa*t205*t83+5.721
     >         846571561304d-9*t12*t383*t81-1.8491862941416065d-1*gammaa
     ?         a*t25*t299*t78-3.698372588283213d-1*gammaaa*t17*t187*t296
     @         *t78-3.698372588283213d-1*t152*t25*t78+6.934448603031025d
     1         -2*gammaaa*t16*t25*t443+1.386889720606205d-1*t16*t25*t267
     2         +2.77377944121241d-1*gammaaa*t151*t16*t17*t187*t266
            t446 = 3.75d-1*t101*t294*t392
            t447 = -5.0d-1*t153*t216*t268
            t448 = -2.5d-1*t101*t216*t300
            t449 = 5.0d-1*t102*t444
            t450 = t449+t448+t447+t446
            t451 = 3.75d-1*t101*t294*t399
            t452 = -5.0d-1*t153*t223*t268
            t453 = -2.5d-1*t101*t223*t300
            t454 = 5.0d-1*t107*t444
            t455 = 3.75d-1*t101*t294*t406
            t456 = -5.0d-1*t153*t233*t268
            t457 = -2.5d-1*t101*t233*t300
            t458 = 5.0d-1*t116*t444
            t459 = t458+t457+t456+t455+t454+t453+t452+t451
            t460 = 1/t27**5
            t461 = 1.924173657795633d-1*t1*t171*t3*t300*t93-4.8104341444
     1         89083d-1*t1*t284*t294*t3*t93-1.282782438530422d-1*t1*t139
     2         *t3*t444+4.2759414617680735d-2*t1*t139*t23*t300+3.8483473
     3         15591266d-1*t1*t153*t171*t268*t3-6.41391219265211d-2*t1*t
     4         171*t23*t294
            t462 = -1.282782438530422d-1*t1*t139*t3*t300*t93+1.924173657
     1         795633d-1*t1*t171*t294*t3*t93+t27*t461+t31*t444+t140*t300
     2         -2.565564877060844d-1*t1*t139*t153*t268*t3+2*t153*t289
            t463 = t153**3
            t464 = t151**3
            t465 = -1.6318099605766218d-5*t9+2.3072419752184684d-6*t5*t7
     1         -8.785496507887335d-3*t15*t297+2.5654959275047734d-1*t23/
     2         t10-1.3559211081063233d-7*gammaaa*t21+1.2400378794498113d
     3         -8*t14*t19+1.1167330851894158d-4*t11*t150
            t466 = -2.5966064381852805d-6*t9+3.1662527200100216d-7*t5*t7
     1         -6.752067425077807d-5*t15*t297+9.941430575310749d-6*t11*t
     2         150
            t467 = -1.6455307846020562d-2*gammaaa*t16*t17*t465*t89-4.936
     1         5923538061685d-2*gammaaa*t151*t16*t299*t89-4.936592353806
     2         1685d-2*t16*t17*t298*t89-4.9365923538061685d-2*gammaaa*t1
     3         52*t16*t298*t89-9.873184707612337d-2*t151*t152*t16*t89+1.
     4         6455307846020562d-2*gammaaa*t16*t25*t466-9.87318470761233
     5         7d-2*gammaaa*t16*t17*t365*t464+4.9365923538061685d-2*t16*
     6         t25*t299+9.873184707612337d-2*gammaaa*t151*t16*t17*t187*t
     7         298+9.873184707612337d-2*t16*t17*t187*t296+9.873184707612
     8         337d-2*gammaaa*t152*t16*t187*t296
            t468 = 5.21580631468864d-7*t205*t9-6.934448603031025d-2*gamm
     1         aaa*t16*t17*t465*t89-2.0803345809093077d-1*gammaaa*t151*t
     2         16*t299*t89-2.0803345809093077d-1*t16*t17*t298*t89-2.0803
     3         345809093077d-1*gammaaa*t152*t16*t298*t89-4.1606691618186
     4         153d-1*t151*t152*t16*t89+6.934448603031025d-2*gammaaa*t16
     5         *t25*t466-4.1606691618186153d-1*gammaaa*t16*t17*t365*t464
     6         -2.1456924643354894d-9*gammaaa*t21*t383+2.080334580909307
     7         7d-1*t16*t25*t299+4.1606691618186153d-1*gammaaa*t151*t16*
     8         t17*t187*t298+4.1606691618186153d-1*t16*t17*t187*t296+4.1
     9         606691618186153d-1*gammaaa*t152*t16*t187*t296
            t469 = 1/t44**2
            t470 = 3.75d-1*t399*t463
            t471 = -7.5d-1*t153*t223*t300
            t472 = 5.0d-1*t107*t467
            t473 = 3.75d-1*t392*t463
            t474 = -7.5d-1*t153*t216*t300
            t475 = 5.0d-1*t102*t467
            t476 = t169**3
            t477 = 3.75d-1*t406*t463
            t478 = -7.5d-1*t153*t233*t300
            t479 = 5.0d-1*t116*t467
            t480 = t479+t478+t477+t472+t471+t470
            t481 = t31*t467-1.282782438530422d-1*t1*t3*t30*t467+9.620868
     1         288978166d-2*t1*t171*t3*t463-1.924173657795633d-1*t1*t139
     2         *t153*t3*t300
            fnc(iq) = fnc(iq)-9.305257363491d-1*t22*t76*wght
            Amat(iq,D1_RA) = -1.2407009817987999d+0*t2*t76*wght-9.305257
     1         363491d-1*t149*t22*wght+Amat(iq,D1_RA)
            Cmat(iq,D1_GAA) = Cmat(iq,D1_GAA)-9.305257363491d-1*t22*(t18
     1         1*t73+t16*t163*t25+t175+t173+t172+t170+t168+t164+t162+t15
     2         7+t156+t154)*wght
            Amat2(iq,D2_RA_RA) = -4.135669939329333d-1*t40*t76*wght-9.30
     1         5257363491d-1*t22*t260*wght-2.4814019635975998d+0*t149*t2
     2         *wght+Amat2(iq,D2_RA_RA)
            Cmat2(iq,D2_RA_GAA) = -1.2407009817987999d+0*t2*(-8.88888888
     1         8888888d-1*t264*t72*t73+t265+t263+t262+t261+t175+t173+t17
     2         2+t170+t168+t164+t162+t157+t156+t154)*wght-9.305257363491
     3         d-1*t22*t293*wght+Cmat2(iq,D2_RA_GAA)
            Cmat2(iq,D2_GAA_GAA) = Cmat2(iq,D2_GAA_GAA)-9.305257363491d-
     1         1*t22*(t16*t320*t89+t352*t73+6.764482379964267d-3*t1*t139
     2         *t153*t174*t3*t35*t73+t139*t3*t340*t38+t148*t353+t339+t33
     3         8+t337+t336+t121*t334+t330+t323+t321+t112*t16*t25*t319+t1
     4         6*t25*t310+t309+t307+t306+t305+t303+t301+t295)*wght
            Amat3(iq,D3_RA_RA_RA) = -1.2407009817987999d+0*t40*(t99+t98+
     1         t97+t96-4.727288888888889d-2*t101*t32*t77+2.6666666666666
     2         666d+0*t148*t355*t72*t75-8.888888888888888d-1*(4.93659235
     3         38061685d-2*t1*t3*(t144-5.0d-1*t1*t101*t139*t3)*t30-1.443
     4         1302433467247d-1*t1*t101*t139*t3+t143)*t72*t73-1.05465777
     5         77777776d-1*t35*t355*t36*t73+5.273288888888887d-2*(t141-6
     6         .41391219265211d-2*t1*t101*t139*t3)*t35*t38-4.72728888888
     7         8889d-2*t137*t28*t354+t136+t129+t122+t115+t113)*wght-9.30
     8         5257363491d-1*t22*(-8.888888888888888d-1*t73*t75*(1.42378
     9         8d-1*t228*t95-2.4d+0*t68*(6.41391219265211d-2*t132*(16*ga
     :         mmaaa*t78*t88*t89*t91-3*gammaaa*t16*t197*t89*t91+2.933333
     ;         3333333333d+1*gammaaa*t182*t25*t91+6*gammaaa*t16*t186*t18
     <         7*t91-3*gammaaa*t16*t200*t88*t89-2.9333333333333333d+1*ga
     =         mmaaa*t17*t182*t88*t89+8*gammaaa*t17*t197*t78*t89-gammaaa
     >         *t16*t17*t376*t89+6*gammaaa*t16*t17*t187*t197*t88-8*gamma
     ?         aa*t200*t25*t78-16*gammaaa*t17*t186*t187*t78+gammaaa*t16*
     @         t25*t379-6*gammaaa*t16*t17*t364*t365-4.5629629629629626d+
     1         1*gammaaa*t17*t25*t356)-3.75d-1*t415*t418+4.8104341444890
     2         83d-2*t133**3*t417-5.0d-1*t131*t403-9.620868288978166d-2*
     3         t133*t249*t252+7.5d-1*t114*t228*t251)-3.15d+1*t415*t416*t
     4         71-8.400000000000001d+0*t130*t403*t71-6.3d+1*t114*t228*t2
     5         48*t71-2.7259596d+0*t403*t67+5.672746666666666d-2*t403*t6
     6         6+4.7459599999999996d-2*t384*t66-1.6355757600000004d+1*t1
     7         14*t228*t66-1.8610765434507923d+1*t415*t416-5.4519192d+0*
     8         t415+4.7459599999999996d-2*t35*t403-4.9628707825354457d+0
     9         *t130*t403-2.52d+1*t114*t130*t253-6.3d+1*t134*t247*t248-3
     :         .7221530869015845d+1*t114*t228*t248-2.52d+1*t130*t134*t22
     ;         8+1.7018239999999996d-1*t114*t228+1.423788d-1*t114*t206)-
     <         3.1639733333333325d-1*t259*t36*t73*t95-6.327946666666665d
     =         -1*t142*t147*t73*t95+1.5819866666666663d-1*t255*t38*t95+9
     >         .491919999999998d-1*t148*t209*t36*t95-8.888888888888888d-
     ?         1*t72*t73*(4.9365923538061685d-2*t1*t3*t30*(-6.6666666666
     @         66666d-1*t1*t139*t87*t93+2.25d+0*t1*t171*t202*t3*t93-1.87
     1         5d+0*t1*t284*t3*t382-5.0d-1*t1*t139*t3*t381-1.03703703703
     2         7037d+0*t1*t196*t30-7.5d-1*t1*t171*t204*t23+5.0d-1*t1*t13
     3         9*t202*t23)-1.9241736577956325d-1*t1*t139*t87*t93-2.46829
     4         61769030842d-2*t1*t139*t257*t3*t93+6.494086095060261d-1*t
     5         1*t171*t202*t3*t93-5.411738412550218d-1*t1*t284*t3*t382-1
     6         .4431302433467247d-1*t1*t139*t3*t381-1.6455307846020562d-
     7         2*t1*t23*t257*t30-2.993159023237651d-1*t1*t196*t30+9.8731
     8         84707612337d-2*t145*t257-2.164695365020087d-1*t1*t171*t20
     9         4*t23+1.4431302433467247d-1*t1*t139*t202*t23)+5.273288888
     :         888887d-2*t35*t38*(-8.551882923536147d-2*t1*t139*t87*t93+
     ;         2.8862604866934494d-1*t1*t171*t202*t3*t93-2.4052170722445
     <         415d-1*t1*t284*t3*t382-6.41391219265211d-2*t1*t139*t3*t38
     =         1-1.330292899216734d-1*t1*t196*t30-9.620868288978166d-2*t
     >         1*t171*t204*t23+6.41391219265211d-2*t1*t139*t202*t23)+1.4
     ?         181866666666668d-1*t137*t256*t77*t93-2.8363733333333335d-
     @         1*t207*t208*t77*t93+2.8363733333333335d-1*t202*t203*t32*t
     1         93+7.57211d-1*(2.63284925536329d-1*gammaaa*t61*t65*t78*t8
     2         8*t89*t91+9.873184707612337d-2*gammaaa*t125*t126*t16*t65*
     3         t88*t89*t91+9.873184707612337d-2*gammaaa*t127*t128*t16*t6
     4         1*t88*t89*t91-4.9365923538061685d-2*gammaaa*t16*t197*t61*
     5         t65*t89*t91+2.63284925536329d-1*gammaaa*t125*t126*t25*t65
     6         *t78*t91+2.63284925536329d-1*gammaaa*t127*t128*t25*t61*t7
     7         8*t91+4.8268903014993647d-1*gammaaa*t182*t25*t61*t65*t91+
     8         9.873184707612337d-2*gammaaa*t16*t186*t187*t61*t65*t91-4.
     9         9365923538061685d-2*gammaaa*t126*t16*t243*t25*t65*t91+9.8
     :         73184707612337d-2*gammaaa*t16*t241*t242*t25*t65*t91-4.936
     ;         5923538061685d-2*gammaaa*t128*t16*t246*t25*t61*t91+9.8731
     <         84707612337d-2*gammaaa*t16*t244*t245*t25*t61*t91+9.873184
     =         707612337d-2*gammaaa*t125*t126*t127*t128*t16*t25*t91-2.63
     >         284925536329d-1*gammaaa*t125*t126*t17*t65*t78*t88*t89-2.6
     ?         3284925536329d-1*gammaaa*t127*t128*t17*t61*t78*t88*t89-4.
     @         9365923538061685d-2*gammaaa*t16*t200*t61*t65*t88*t89-4.82
     1         68903014993647d-1*gammaaa*t17*t182*t61*t65*t88*t89+4.9365
     2         923538061685d-2*gammaaa*t126*t16*t17*t243*t65*t88*t89-9.8
     3         73184707612337d-2*gammaaa*t16*t17*t241*t242*t65*t88*t89+4
     4         .9365923538061685d-2*gammaaa*t128*t16*t17*t246*t61*t88*t8
     5         9-9.873184707612337d-2*gammaaa*t16*t17*t244*t245*t61*t88*
     6         t89-9.873184707612337d-2*gammaaa*t125*t126*t127*t128*t16*
     7         t17*t88*t89+1.316424627681645d-1*gammaaa*t17*t197*t61*t65
     8         *t78*t89-1.6455307846020562d-2*gammaaa*t16*t17*t376*t61*t
     9         65*t89+4.9365923538061685d-2*gammaaa*t125*t126*t16*t17*t1
     :         97*t65*t89+4.9365923538061685d-2*gammaaa*t127*t128*t16*t1
     ;         7*t197*t61*t89+9.873184707612337d-2*gammaaa*t16*t17*t187*
     <         t197*t61*t65*t88-1.316424627681645d-1*gammaaa*t200*t25*t6
     =         1*t65*t78-2.63284925536329d-1*gammaaa*t17*t186*t187*t61*t
     >         65*t78+1.316424627681645d-1*gammaaa*t126*t17*t243*t25*t65
     ?         *t78-2.63284925536329d-1*gammaaa*t17*t241*t242*t25*t65*t7
     @         8+1.316424627681645d-1*gammaaa*t128*t17*t246*t25*t61*t78-
     1         2.63284925536329d-1*gammaaa*t17*t244*t245*t25*t61*t78-2.6
     2         3284925536329d-1*gammaaa*t125*t126*t127*t128*t17*t25*t78+
     3         1.6455307846020562d-2*gammaaa*t16*t25*t379*t61*t65-9.8731
     4         84707612337d-2*gammaaa*t16*t17*t364*t365*t61*t65-7.508496
     5         024554567d-1*gammaaa*t17*t25*t356*t61*t65-1.6455307846020
     6         562d-2*gammaaa*t126*t16*t17*t25*t413*t65-9.87318470761233
     7         7d-2*gammaaa*t16*t17*t25*t411*t412*t65+9.873184707612337d
     8         -2*gammaaa*t125*t16*t17*t242*t243*t25*t65-4.9365923538061
     9         685d-2*gammaaa*t125*t126*t16*t200*t25*t65-4.8268903014993
     :         647d-1*gammaaa*t125*t126*t17*t182*t25*t65-9.8731847076123
     ;         37d-2*gammaaa*t125*t126*t16*t17*t186*t187*t65+t403*t61*t6
     <         3-t126*t413*t59*t63-6*t411*t412*t59*t63+6*t125*t242*t243*
     =         t59*t63-3*t114*t126*t243*t63+6*t114*t241*t242*t63-3*t125*
     >         t126*t228*t63-6*t123**3*t410*t59*t61-t124*(t409+t408+t407
     ?         +t396)*t59*t61+6*t123*t239*t240*t59*t61-9.873184707612337
     @         d-2*gammaaa*t127**3*t16*t17*t25*t414*t61-1.64553078460205
     1         62d-2*gammaaa*t128*t16*t17*t25*(t402+t401+t400+t396)*t61+
     2         9.873184707612337d-2*gammaaa*t127*t16*t17*t245*t246*t25*t
     3         61-4.9365923538061685d-2*gammaaa*t127*t128*t16*t200*t25*t
     4         61-4.8268903014993647d-1*gammaaa*t127*t128*t17*t182*t25*t
     5         61-3*t114*t124*t240*t61+6*t114*t238*t239*t61-3*t123*t124*
     6         t228*t61-9.873184707612337d-2*gammaaa*t127*t128*t16*t17*t
     7         186*t187*t61+3*t123*t124*t126*t243*t59-6*t123*t124*t241*t
     8         242*t59+3*t124*t125*t126*t240*t59-6*t125*t126*t238*t239*t
     9         59+4.9365923538061685d-2*gammaaa*t125*t126*t128*t16*t17*t
     :         246*t25-9.873184707612337d-2*gammaaa*t125*t126*t16*t17*t2
     ;         44*t245*t25+4.9365923538061685d-2*gammaaa*t126*t127*t128*
     <         t16*t17*t243*t25-9.873184707612337d-2*gammaaa*t127*t128*t
     =         16*t17*t241*t242*t25+6*t114*t123*t124*t125*t126)+5.265698
     >         51072658d-1*gammaaa*t52*t78*t88*t89*t91-1.974636941522467
     ?         4d-1*gammaaa*t111*t112*t16*t88*t89*t91-9.873184707612337d
     @         -2*gammaaa*t16*t197*t52*t89*t91-5.26569851072658d-1*gamma
     1         aa*t111*t112*t25*t78*t91+9.653780602998729d-1*gammaaa*t18
     2         2*t25*t52*t91+1.9746369415224674d-1*gammaaa*t16*t186*t187
     3         *t52*t91+9.873184707612337d-2*gammaaa*t112*t16*t227*t25*t
     4         91-9.873184707612337d-2*gammaaa*t16*t211*t212*t25*t91+5.2
     5         6569851072658d-1*gammaaa*t111*t112*t17*t78*t88*t89-9.8731
     6         84707612337d-2*gammaaa*t16*t200*t52*t88*t89-9.65378060299
     7         8729d-1*gammaaa*t17*t182*t52*t88*t89-9.873184707612337d-2
     8         *gammaaa*t112*t16*t17*t227*t88*t89+9.873184707612337d-2*g
     9         ammaaa*t16*t17*t211*t212*t88*t89+2.63284925536329d-1*gamm
     :         aaa*t17*t197*t52*t78*t89-3.2910615692041123d-2*gammaaa*t1
     ;         6*t17*t376*t52*t89-9.873184707612337d-2*gammaaa*t111*t112
     <         *t16*t17*t197*t89+1.9746369415224674d-1*gammaaa*t16*t17*t
     =         187*t197*t52*t88-2.63284925536329d-1*gammaaa*t200*t25*t52
     >         *t78-5.26569851072658d-1*gammaaa*t17*t186*t187*t52*t78-2.
     ?         63284925536329d-1*gammaaa*t112*t17*t227*t25*t78+2.6328492
     @         5536329d-1*gammaaa*t17*t211*t212*t25*t78-4.72728888888888
     1         9d-2*t32*t381*t77+1.4181866666666668d-1*t137*t140*t202*t7
     2         7+2.6666666666666666d+0*t148*t420*t72*t75+5.3333333333333
     3         33d+1*t386*t387*t72*t75-3.2d+1*t147*t210*t259*t72*t75+8.0
     4         d+0*t135*t148*t259*t75+8.0d+0*t147*t148*t254*t75-3.2d+1*t
     5         135*t209*t210*t75-1.0546577777777776d-1*t35*t36*t420*t73-
     6         3.1639733333333325d-1*t147*t206*t36*t73-3.163973333333332
     7         5d-1*t142*t259*t35*t73-3.1639733333333325d-1*t147*t255*t3
     8         5*t73-2.6666666666666666d+0*t135*t258*t73-2.6666666666666
     9         666d+0*t146*t254*t73+8.0d+0*t146*t148*t259*t72+8.0d+0*t14
     :         7*t148*t258*t72-3.2d+1*t146*t209*t210*t72-2.0d+0*t121*(-1
     ;         .475609999999999d-1*t106*t397*t56-8.853659999999993d-1*t3
     <         89*t390*t56+8.853659999999993d-1*t105*t214*t220*t56-1.475
     =         609999999999d-1*t119*(t409+t408+t407+t395+t394+t393)*t50-
     >         8.853659999999993d-1*t118**3*t405*t50+8.853659999999993d-
     ?         1*t118*t232*t236*t50+4.4268299999999966d-1*t105*t106*t119
     @         *t236-8.853659999999993d-1*t105*t106*t231*t232+4.42682999
     1         99999966d-1*t106*t118*t119*t220-8.853659999999993d-1*t118
     2         *t119*t213*t214)*t59-4.0d+0*t120**3*t404*t59+6.0d+0*t120*
     3         t230*t237*t59-2.0d+0*t403*t58+3.2910615692041123d-2*gamma
     4         aa*t16*t25*t379*t52-1.9746369415224674d-1*gammaaa*t16*t17
     5         *t364*t365*t52-1.5016992049109135d+0*gammaaa*t17*t25*t356
     6         *t52+3.2910615692041123d-2*gammaaa*t112*t16*t17*t25*(6.09
     7         65d-1*t110*(t402+t401+t400+t395+t394+t393)*t50+3.6579d+0*
     8         t109**3*t398*t50-3.6579d+0*t109*t222*t226*t50+6.0965d-1*t
     9         106*t397*t47+3.6579d+0*t389*t390*t47-3.6579d+0*t105*t214*
     :         t220*t47-1.82895d+0*t105*t106*t110*t226+3.6579d+0*t105*t1
     ;         06*t221*t222-1.82895d+0*t106*t109*t110*t220+3.6579d+0*t10
     <         9*t110*t213*t214)-4.727288888888889d-2*t137*t28*t419+6.58
     =         2123138408225d-2*gammaaa*t111**3*t16*t17*t25*t388-1.26558
     >         9333333333d+0*t210*t35*t36*t386-2.8363733333333335d-1*t14
     ?         0**3*t28*t385+5.273288888888887d-2*t36*t38*t384-2.8363733
     @         333333335d-1*t32*t335*t382+1.5819866666666663d-1*t142*t20
     1         6*t38+9.491919999999998d-1*t147*t148*t259*t35*t36+9.49191
     2         9999999998d-1*t142*t148*t209*t35+2.8363733333333335d-1*t1
     3         40*t207*t256*t28-9.873184707612337d-2*gammaaa*t111*t16*t1
     4         7*t212*t227*t25+9.873184707612337d-2*gammaaa*t111*t112*t1
     5         6*t200*t25+9.653780602998729d-1*gammaaa*t111*t112*t17*t18
     6         2*t25-6.0d+0*t114*t121*t237+6.0d+0*t114*t229*t230-6.0d+0*
     7         t120*t121*t228-2.8363733333333335d-1*t137*t140*t203*t204+
     8         1.9746369415224674d-1*gammaaa*t111*t112*t16*t17*t186*t187
     9         +1.6d+1*t135*t146*t147*t148)*wght+2.757113292886222d-1*t1
     :         00*t76*wght-3.7221029453964d+0*t2*t260*wght+Amat3(iq,D3_R
     ;         A_RA_RA)
            Cmat3(iq,D3_RA_RA_GAA) = -9.305257363491d-1*t22*(-8.88888888
     1         8888888d-1*t73*t75*(9.491919999999999d-2*t268*t95-2.4d+0*
     2         t68*(6.41391219265211d-2*t132*(-2*t16*t88*t89*t91+5.33333
     3         3333333333d+0*gammaaa*t151*t78*t89*t91-2*gammaaa*t16*t266
     4         *t89*t91+4*gammaaa*t151*t16*t187*t88*t91-5.33333333333333
     5         3d+0*t25*t78*t91+5.333333333333333d+0*t17*t78*t88*t89+5.3
     6         33333333333333d+0*gammaaa*t152*t78*t88*t89-2*gammaaa*t16*
     7         t267*t88*t89+5.333333333333333d+0*gammaaa*t17*t266*t78*t8
     8         9-gammaaa*t16*t17*t421*t89-gammaaa*t151*t16*t200*t89-t16*
     9         t17*t197*t89-gammaaa*t152*t16*t197*t89-9.777777777777779d
     :         +0*gammaaa*t151*t17*t182*t89-1.0666666666666666d+1*gammaa
     ;         a*t151*t17*t187*t78*t88+4*gammaaa*t16*t17*t187*t266*t88-5
     <         .333333333333333d+0*gammaaa*t25*t267*t78+gammaaa*t16*t25*
     =         t422-6*gammaaa*t151*t16*t17*t186*t365+t16*t200*t25+9.7777
     >         77777777779d+0*t17*t182*t25+9.777777777777779d+0*gammaaa*
     ?         t152*t182*t25+2*gammaaa*t151*t16*t17*t187*t197+2*t16*t17*
     @         t186*t187+2*gammaaa*t152*t16*t186*t187)-5.0d-1*t131*t423-
     1         3.75d-1*t153*t247*t418+4.810434144489083d-2*t178*t250*t41
     2         7-6.41391219265211d-2*t133*t249*t285+5.0d-1*t114*t251*t26
     3         8-3.206956096326055d-2*t178*t249*t252+2.5d-1*t153*t228*t2
     4         51)-8.400000000000001d+0*t130*t423*t71-3.15d+1*t153*t247*
     5         t416*t71-4.2d+1*t114*t248*t268*t71-2.1d+1*t153*t228*t248*
     6         t71-2.7259596d+0*t423*t67+4.7459599999999996d-2*t424*t66+
     7         5.672746666666666d-2*t423*t66-1.0903838400000002d+1*t114*
     8         t268*t66-5.4519192d+0*t153*t228*t66+4.7459599999999996d-2
     9         *t35*t423-4.9628707825354457d+0*t130*t423-1.8610765434507
     :         923d+1*t153*t247*t416-1.68d+1*t114*t130*t286+9.4919199999
     ;         99999d-2*t114*t269-2.481435391267723d+1*t114*t248*t268-1.
     <         68d+1*t130*t134*t268+1.1345493333333331d-1*t114*t268-8.40
     =         0000000000001d+0*t130*t153*t253-2.1d+1*t179*t247*t248-1.2
     >         407176956338616d+1*t153*t228*t248-4.2d+1*t114*t134*t153*t
     ?         248-5.4519192d+0*t153*t247-8.400000000000001d+0*t130*t179
     @         *t228+4.7459599999999996d-2*t155*t228+5.672746666666666d-
     1         2*t153*t228+4.7459599999999996d-2*t153*t206)-2.1093155555
     2         55555d-1*t292*t36*t73*t95+1.3528964759928536d-2*t1*t139*t
     3         147*t153*t3*t73*t95-2.109315555555555d-1*t142*t174*t73*t9
     4         5+1.0546577777777776d-1*t288*t38*t95+6.327946666666665d-1
     5         *t147*t148*t174*t36*t95-8.888888888888888d-1*t72*t73*(4.9
     6         365923538061685d-2*t1*t3*t30*(1.5d+0*t1*t171*t268*t3*t93-
     7         5.0d-1*t1*t153*t171*t23*t93-2.222222222222222d-1*t1*t139*
     8         t153*t87-5.0d-1*t1*t139*t3*t423-1.875d+0*t1*t153*t204*t28
     9         4*t3+7.5d-1*t1*t153*t171*t202*t3+3.333333333333333d-1*t1*
     :         t139*t23*t268)+4.329390730040174d-1*t1*t171*t268*t3*t93-1
     ;         .4431302433467247d-1*t1*t153*t171*t23*t93-6.4139121926521
     <         09d-2*t1*t139*t153*t87-1.4431302433467247d-1*t1*t139*t3*t
     =         423-5.411738412550218d-1*t1*t153*t204*t284*t3-2.468296176
     >         9030842d-2*t1*t139*t153*t257*t3+2.164695365020087d-1*t1*t
     ?         153*t171*t202*t3+9.873184707612337d-2*t145*t290+9.6208682
     @         88978164d-2*t1*t139*t23*t268)+5.273288888888887d-2*t35*t3
     1         8*(1.924173657795633d-1*t1*t171*t268*t3*t93-6.41391219265
     2         211d-2*t1*t153*t171*t23*t93-2.8506276411787157d-2*t1*t139
     3         *t153*t87-6.41391219265211d-2*t1*t139*t3*t423-2.405217072
     4         2445415d-1*t1*t153*t204*t284*t3+9.620868288978166d-2*t1*t
     5         153*t171*t202*t3+4.2759414617680735d-2*t1*t139*t23*t268)+
     6         9.454577777777778d-2*t137*t289*t77*t93+1.8909155555555557
     7         d-1*t203*t268*t32*t93+2.4256332674106634d-2*t1*t140*t153*
     8         t207*t284*t3*t93-1.8909155555555557d-1*t137*t140*t153*t20
     9         3*t93+7.57211d-1*(-3.2910615692041123d-2*t16*t61*t65*t88*
     :         t89*t91+3.2910615692041123d-2*gammaaa*t126*t16*t169*t65*t
     ;         88*t89*t91+1.6455307846020562d-2*gammaaa*t107*t128*t153*t
     <         16*t61*t88*t89*t91+8.7761641845443d-2*gammaaa*t151*t61*t6
     =         5*t78*t89*t91-3.2910615692041123d-2*gammaaa*t16*t266*t61*
     >         t65*t89*t91+3.2910615692041123d-2*gammaaa*t125*t126*t151*
     ?         t16*t65*t89*t91+3.2910615692041123d-2*gammaaa*t127*t128*t
     @         151*t16*t61*t89*t91+6.582123138408225d-2*gammaaa*t151*t16
     1         *t187*t61*t65*t88*t91-8.7761641845443d-2*t25*t61*t65*t78*
     2         t91+8.7761641845443d-2*gammaaa*t126*t169*t25*t65*t78*t91+
     3         4.38808209227215d-2*gammaaa*t107*t128*t153*t25*t61*t78*t9
     4         1-3.2910615692041123d-2*gammaaa*t126*t16*t25*t282*t65*t91
     5         +6.582123138408225d-2*gammaaa*t125*t16*t169*t242*t25*t65*
     6         t91-3.2910615692041123d-2*t125*t126*t16*t25*t65*t91-3.291
     7         0615692041123d-2*gammaaa*t128*t16*t25*t283*t61*t91+3.2910
     8         615692041123d-2*gammaaa*t107*t127*t153*t16*t245*t25*t61*t
     9         91-3.2910615692041123d-2*t127*t128*t16*t25*t61*t91+3.2910
     :         615692041123d-2*gammaaa*t126*t127*t128*t16*t169*t25*t91+1
     ;         .6455307846020562d-2*gammaaa*t107*t125*t126*t128*t153*t16
     <         *t25*t91+8.7761641845443d-2*t17*t61*t65*t78*t88*t89+8.776
     =         1641845443d-2*gammaaa*t152*t61*t65*t78*t88*t89-8.77616418
     >         45443d-2*gammaaa*t126*t169*t17*t65*t78*t88*t89-4.38808209
     ?         227215d-2*gammaaa*t107*t128*t153*t17*t61*t78*t88*t89-3.29
     @         10615692041123d-2*gammaaa*t16*t267*t61*t65*t88*t89+3.2910
     1         615692041123d-2*gammaaa*t126*t16*t17*t282*t65*t88*t89-6.5
     2         82123138408225d-2*gammaaa*t125*t16*t169*t17*t242*t65*t88*
     3         t89+3.2910615692041123d-2*t125*t126*t16*t17*t65*t88*t89+3
     4         .2910615692041123d-2*gammaaa*t125*t126*t152*t16*t65*t88*t
     5         89+3.2910615692041123d-2*gammaaa*t128*t16*t17*t283*t61*t8
     6         8*t89-3.2910615692041123d-2*gammaaa*t107*t127*t153*t16*t1
     7         7*t245*t61*t88*t89+3.2910615692041123d-2*t127*t128*t16*t1
     8         7*t61*t88*t89+3.2910615692041123d-2*gammaaa*t127*t128*t15
     9         2*t16*t61*t88*t89-3.2910615692041123d-2*gammaaa*t126*t127
     :         *t128*t16*t169*t17*t88*t89-1.6455307846020562d-2*gammaaa*
     ;         t107*t125*t126*t128*t153*t16*t17*t88*t89+8.7761641845443d
     <         -2*gammaaa*t17*t266*t61*t65*t78*t89-8.7761641845443d-2*ga
     =         mmaaa*t125*t126*t151*t17*t65*t78*t89-8.7761641845443d-2*g
     >         ammaaa*t127*t128*t151*t17*t61*t78*t89-1.6455307846020562d
     ?         -2*gammaaa*t16*t17*t421*t61*t65*t89-1.6455307846020562d-2
     @         *gammaaa*t151*t16*t200*t61*t65*t89-1.6455307846020562d-2*
     1         t16*t17*t197*t61*t65*t89-1.6455307846020562d-2*gammaaa*t1
     2         52*t16*t197*t61*t65*t89-1.6089634338331216d-1*gammaaa*t15
     3         1*t17*t182*t61*t65*t89+3.2910615692041123d-2*gammaaa*t125
     4         *t126*t16*t17*t266*t65*t89+1.6455307846020562d-2*gammaaa*
     5         t126*t151*t16*t17*t243*t65*t89-3.2910615692041123d-2*gamm
     6         aaa*t151*t16*t17*t241*t242*t65*t89+1.6455307846020562d-2*
     7         gammaaa*t126*t16*t169*t17*t197*t65*t89+3.2910615692041123
     8         d-2*gammaaa*t127*t128*t16*t17*t266*t61*t89+1.645530784602
     9         0562d-2*gammaaa*t128*t151*t16*t17*t246*t61*t89-3.29106156
     :         92041123d-2*gammaaa*t151*t16*t17*t244*t245*t61*t89+8.2276
     ;         53923010281d-3*gammaaa*t107*t128*t153*t16*t17*t197*t61*t8
     <         9-3.2910615692041123d-2*gammaaa*t125*t126*t127*t128*t151*
     =         t16*t17*t89-1.75523283690886d-1*gammaaa*t151*t17*t187*t61
     >         *t65*t78*t88+6.582123138408225d-2*gammaaa*t16*t17*t187*t2
     ?         66*t61*t65*t88-6.582123138408225d-2*gammaaa*t125*t126*t15
     @         1*t16*t17*t187*t65*t88-6.582123138408225d-2*gammaaa*t127*
     1         t128*t151*t16*t17*t187*t61*t88-8.7761641845443d-2*gammaaa
     2         *t25*t267*t61*t65*t78+8.7761641845443d-2*gammaaa*t126*t17
     3         *t25*t282*t65*t78-1.75523283690886d-1*gammaaa*t125*t169*t
     4         17*t242*t25*t65*t78+8.7761641845443d-2*t125*t126*t17*t25*
     5         t65*t78+8.7761641845443d-2*gammaaa*t125*t126*t152*t25*t65
     6         *t78+8.7761641845443d-2*gammaaa*t128*t17*t25*t283*t61*t78
     7         -8.7761641845443d-2*gammaaa*t107*t127*t153*t17*t245*t25*t
     8         61*t78+8.7761641845443d-2*t127*t128*t17*t25*t61*t78+8.776
     9         1641845443d-2*gammaaa*t127*t128*t152*t25*t61*t78-8.776164
     :         1845443d-2*gammaaa*t126*t127*t128*t169*t17*t25*t78-4.3880
     ;         8209227215d-2*gammaaa*t107*t125*t126*t128*t153*t17*t25*t7
     <         8+1.6455307846020562d-2*gammaaa*t16*t25*t422*t61*t65-9.87
     =         3184707612337d-2*gammaaa*t151*t16*t17*t186*t365*t61*t65+1
     >         .6455307846020562d-2*t16*t200*t25*t61*t65+1.6089634338331
     ?         216d-1*t17*t182*t25*t61*t65+1.6089634338331216d-1*gammaaa
     @         *t152*t182*t25*t61*t65+3.2910615692041123d-2*gammaaa*t151
     1         *t16*t17*t187*t197*t61*t65+3.2910615692041123d-2*t16*t17*
     2         t186*t187*t61*t65+3.2910615692041123d-2*gammaaa*t152*t16*
     3         t186*t187*t61*t65-1.6455307846020562d-2*gammaaa*t126*t16*
     4         t17*t25*t438*t65-9.873184707612337d-2*gammaaa*t16*t169*t1
     5         7*t241*t25*t412*t65+6.582123138408225d-2*gammaaa*t125*t16
     6         *t17*t242*t25*t282*t65-3.2910615692041123d-2*gammaaa*t125
     7         *t126*t16*t25*t267*t65+3.2910615692041123d-2*gammaaa*t16*
     8         t169*t17*t242*t243*t25*t65-1.6455307846020562d-2*t126*t16
     9         *t17*t243*t25*t65-1.6455307846020562d-2*gammaaa*t126*t152
     :         *t16*t243*t25*t65+3.2910615692041123d-2*t16*t17*t241*t242
     ;         *t25*t65+3.2910615692041123d-2*gammaaa*t152*t16*t241*t242
     <         *t25*t65-1.6455307846020562d-2*gammaaa*t126*t16*t169*t200
     =         *t25*t65-1.6089634338331216d-1*gammaaa*t126*t169*t17*t182
     >         *t25*t65-3.2910615692041123d-2*gammaaa*t126*t16*t169*t17*
     ?         t186*t187*t65+t423*t61*t63-t126*t438*t59*t63-6*t169*t241*
     @         t412*t59*t63+4*t125*t242*t282*t59*t63+2*t169*t242*t243*t5
     1         9*t63-2*t114*t126*t282*t63-2*t125*t126*t268*t63-t126*t153
     2         *t243*t63+2*t153*t241*t242*t63+4*t114*t125*t169*t242*t63-
     3         t126*t169*t228*t63-t124*(t437+t436+t435+t434)*t59*t61-3*t
     4         116*t153*t238*t410*t59*t61+4*t123*t239*t281*t59*t61+t116*
     5         t153*t239*t240*t59*t61-1.6455307846020562d-2*gammaaa*t128
     6         *t16*t17*t25*(t433+t432+t431+t430)*t61-4.9365923538061685
     7         d-2*gammaaa*t107*t153*t16*t17*t244*t25*t414*t61+6.5821231
     8         38408225d-2*gammaaa*t127*t16*t17*t245*t25*t283*t61-2*t114
     9         *t124*t281*t61-2*t123*t124*t268*t61-3.2910615692041123d-2
     :         *gammaaa*t127*t128*t16*t25*t267*t61+1.6455307846020562d-2
     ;         *gammaaa*t107*t153*t16*t17*t245*t246*t25*t61-1.6455307846
     <         020562d-2*t128*t16*t17*t246*t25*t61-1.6455307846020562d-2
     =         *gammaaa*t128*t152*t16*t246*t25*t61+3.2910615692041123d-2
     >         *t16*t17*t244*t245*t25*t61+3.2910615692041123d-2*gammaaa*
     ?         t152*t16*t244*t245*t25*t61-8.227653923010281d-3*gammaaa*t
     @         107*t128*t153*t16*t200*t25*t61-8.044817169165608d-2*gamma
     1         aa*t107*t128*t153*t17*t182*t25*t61-t124*t153*t240*t61+2*t
     2         153*t238*t239*t61+2*t114*t116*t123*t153*t239*t61-5.0d-1*t
     3         116*t124*t153*t228*t61-1.6455307846020562d-2*gammaaa*t107
     4         *t128*t153*t16*t17*t186*t187*t61+2*t123*t124*t126*t282*t5
     5         9+2*t124*t125*t126*t281*t59+5.0d-1*t116*t124*t126*t153*t2
     6         43*t59-t116*t124*t153*t241*t242*t59-4*t123*t124*t125*t169
     7         *t242*t59+t124*t126*t169*t240*t59-2*t126*t169*t238*t239*t
     8         59-2*t116*t123*t125*t126*t153*t239*t59+3.2910615692041123
     9         d-2*gammaaa*t125*t126*t128*t16*t17*t25*t283+3.29106156920
     :         41123d-2*gammaaa*t126*t127*t128*t16*t17*t25*t282+1.645530
     ;         7846020562d-2*gammaaa*t126*t128*t16*t169*t17*t246*t25-3.2
     <         910615692041123d-2*gammaaa*t126*t16*t169*t17*t244*t245*t2
     =         5-3.2910615692041123d-2*gammaaa*t107*t125*t126*t127*t153*
     >         t16*t17*t245*t25+8.227653923010281d-3*gammaaa*t107*t126*t
     ?         128*t153*t16*t17*t243*t25-1.6455307846020562d-2*gammaaa*t
     @         107*t128*t153*t16*t17*t241*t242*t25-6.582123138408225d-2*
     1         gammaaa*t125*t127*t128*t16*t169*t17*t242*t25+3.2910615692
     2         041123d-2*t125*t126*t127*t128*t16*t17*t25+3.2910615692041
     3         123d-2*gammaaa*t125*t126*t127*t128*t152*t16*t25+2*t114*t1
     4         23*t124*t126*t169+2*t123*t124*t125*t126*t153+t114*t116*t1
     5         24*t125*t126*t153)-6.582123138408225d-2*t16*t52*t88*t89*t
     6         91-6.582123138408225d-2*gammaaa*t112*t16*t161*t88*t89*t91
     7         +1.75523283690886d-1*gammaaa*t151*t52*t78*t89*t91-6.58212
     8         3138408225d-2*gammaaa*t16*t266*t52*t89*t91-6.582123138408
     9         225d-2*gammaaa*t111*t112*t151*t16*t89*t91+1.3164246276816
     :         45d-1*gammaaa*t151*t16*t187*t52*t88*t91-1.75523283690886d
     ;         -1*t25*t52*t78*t91-1.75523283690886d-1*gammaaa*t112*t161*
     <         t25*t78*t91+6.582123138408225d-2*gammaaa*t112*t16*t25*t27
     =         6*t91-6.582123138408225d-2*gammaaa*t111*t16*t161*t212*t25
     >         *t91+6.582123138408225d-2*t111*t112*t16*t25*t91+1.7552328
     ?         3690886d-1*t17*t52*t78*t88*t89+1.75523283690886d-1*gammaa
     @         a*t152*t52*t78*t88*t89+1.75523283690886d-1*gammaaa*t112*t
     1         161*t17*t78*t88*t89-6.582123138408225d-2*gammaaa*t16*t267
     2         *t52*t88*t89-6.582123138408225d-2*gammaaa*t112*t16*t17*t2
     3         76*t88*t89+6.582123138408225d-2*gammaaa*t111*t16*t161*t17
     4         *t212*t88*t89-6.582123138408225d-2*t111*t112*t16*t17*t88*
     5         t89-6.582123138408225d-2*gammaaa*t111*t112*t152*t16*t88*t
     6         89+1.75523283690886d-1*gammaaa*t17*t266*t52*t78*t89+1.755
     7         23283690886d-1*gammaaa*t111*t112*t151*t17*t78*t89-3.29106
     8         15692041123d-2*gammaaa*t16*t17*t421*t52*t89-3.29106156920
     9         41123d-2*gammaaa*t151*t16*t200*t52*t89-3.2910615692041123
     :         d-2*t16*t17*t197*t52*t89-3.2910615692041123d-2*gammaaa*t1
     ;         52*t16*t197*t52*t89-3.217926867666243d-1*gammaaa*t151*t17
     <         *t182*t52*t89-6.582123138408225d-2*gammaaa*t111*t112*t16*
     =         t17*t266*t89-3.2910615692041123d-2*gammaaa*t112*t151*t16*
     >         t17*t227*t89+3.2910615692041123d-2*gammaaa*t151*t16*t17*t
     ?         211*t212*t89-3.2910615692041123d-2*gammaaa*t112*t16*t161*
     @         t17*t197*t89-3.51046567381772d-1*gammaaa*t151*t17*t187*t5
     1         2*t78*t88+1.316424627681645d-1*gammaaa*t16*t17*t187*t266*
     2         t52*t88+1.316424627681645d-1*gammaaa*t111*t112*t151*t16*t
     3         17*t187*t88-1.75523283690886d-1*gammaaa*t25*t267*t52*t78-
     4         1.75523283690886d-1*gammaaa*t112*t17*t25*t276*t78+1.75523
     5         283690886d-1*gammaaa*t111*t161*t17*t212*t25*t78-1.7552328
     6         3690886d-1*t111*t112*t17*t25*t78-1.75523283690886d-1*gamm
     7         aaa*t111*t112*t152*t25*t78-4.727288888888889d-2*t32*t423*
     8         t77+9.454577777777778d-2*t137*t140*t268*t77+4.72728888888
     9         8889d-2*t137*t153*t256*t77-9.454577777777778d-2*t153*t207
     :         *t208*t77+2.6666666666666666d+0*t148*t441*t72*t75+5.33333
     ;         3333333333d+1*t174*t209*t387*t72*t75-2.1333333333333332d+
     <         1*t147*t210*t292*t72*t75-1.0666666666666666d+1*t174*t210*
     =         t259*t72*t75+5.333333333333333d+0*t135*t148*t292*t75+5.33
     >         3333333333333d+0*t147*t148*t287*t75+2.6666666666666666d+0
     ?         *t148*t180*t259*t75+2.6666666666666666d+0*t148*t174*t254*
     @         t75-1.0666666666666666d+1*t180*t209*t210*t75-2.1333333333
     1         333332d+1*t135*t147*t174*t210*t75-1.0546577777777776d-1*t
     2         35*t36*t441*t73-2.109315555555555d-1*t147*t269*t36*t73-1.
     3         0546577777777776d-1*t155*t259*t36*t73-1.0546577777777776d
     4         -1*t174*t206*t36*t73+6.764482379964267d-3*t1*t139*t153*t2
     5         59*t3*t35*t73-2.109315555555555d-1*t142*t292*t35*t73-2.10
     6         9315555555555d-1*t147*t288*t35*t73-1.0546577777777776d-1*
     7         t174*t255*t35*t73-1.7777777777777776d+0*t135*t291*t73-1.7
     8         777777777777776d+0*t146*t287*t73-8.888888888888888d-1*t25
     9         4*t264*t73-8.888888888888888d-1*t180*t258*t73-2.109315555
     :         555555d-1*t142*t147*t155*t73+5.333333333333333d+0*t146*t1
     ;         48*t292*t72+5.333333333333333d+0*t147*t148*t291*t72+2.666
     <         6666666666666d+0*t148*t259*t264*t72-1.0666666666666666d+1
     =         *t209*t210*t264*t72+2.6666666666666666d+0*t148*t174*t258*
     >         t72-2.1333333333333332d+1*t146*t147*t174*t210*t72-2.0d+0*
     ?         t121*(-1.475609999999999d-1*t106*t429*t56-4.4268299999999
     @         966d-1*t102*t153*t213*t390*t56+5.902439999999995d-1*t105*
     1         t214*t272*t56+1.475609999999999d-1*t102*t153*t214*t220*t5
     2         6-1.475609999999999d-1*t119*(t437+t436+t435+t434+t428+t42
     3         7+t426+t425)*t50-8.853659999999993d-1*t166*t231*t405*t50+
     4         5.902439999999995d-1*t118*t232*t279*t50+2.951219999999998
     5         d-1*t166*t232*t236*t50+2.951219999999998d-1*t105*t106*t11
     6         9*t279+2.951219999999998d-1*t106*t118*t119*t272+7.3780499
     7         99999994d-2*t102*t106*t119*t153*t236-1.475609999999999d-1
     8         *t102*t106*t153*t231*t232-5.902439999999995d-1*t105*t106*
     9         t118*t166*t232+1.475609999999999d-1*t106*t119*t166*t220-2
     :         .951219999999998d-1*t119*t166*t213*t214-2.951219999999998
     ;         d-1*t102*t105*t118*t119*t153*t214)*t59-4.0d+0*t167*t229*t
     <         404*t59+4.0d+0*t120*t230*t280*t59+2.0d+0*t167*t230*t237*t
     =         59-2.0d+0*t423*t58+3.2910615692041123d-2*gammaaa*t16*t25*
     >         t422*t52-1.9746369415224674d-1*gammaaa*t151*t16*t17*t186*
     ?         t365*t52+3.2910615692041123d-2*t16*t200*t25*t52+3.2179268
     @         67666243d-1*t17*t182*t25*t52+3.217926867666243d-1*gammaaa
     1         *t152*t182*t25*t52+6.582123138408225d-2*gammaaa*t151*t16*
     2         t17*t187*t197*t52+6.582123138408225d-2*t16*t17*t186*t187*
     3         t52+6.582123138408225d-2*gammaaa*t152*t16*t186*t187*t52+3
     4         .2910615692041123d-2*gammaaa*t112*t16*t17*t25*(6.0965d-1*
     5         t110*(t433+t432+t431+t430+t428+t427+t426+t425)*t50+3.6579
     6         d+0*t160*t221*t398*t50-2.4386000000000002d+0*t109*t222*t2
     7         75*t50-1.2193000000000001d+0*t160*t222*t226*t50+6.0965d-1
     8         *t106*t429*t47+1.82895d+0*t102*t153*t213*t390*t47-2.43860
     9         00000000002d+0*t105*t214*t272*t47-6.0965d-1*t102*t153*t21
     :         4*t220*t47-1.2193000000000001d+0*t105*t106*t110*t275-1.21
     ;         93000000000001d+0*t106*t109*t110*t272-3.04825d-1*t102*t10
     <         6*t110*t153*t226+6.0965d-1*t102*t106*t153*t221*t222+2.438
     =         6000000000002d+0*t105*t106*t109*t160*t222-6.0965d-1*t106*
     >         t110*t160*t220+1.2193000000000001d+0*t110*t160*t213*t214+
     ?         1.2193000000000001d+0*t102*t105*t109*t110*t153*t214)-4.72
     @         7288888888889d-2*t137*t28*t440+1.2128166337053317d-2*t1*t
     1         137*t153*t204*t3*t439+5.273288888888887d-2*t36*t38*t424+6
     2         .582123138408225d-2*gammaaa*t16*t161*t17*t211*t25*t388+3.
     3         6384499011159954d-2*t1*t153*t171*t208*t3*t385-3.382241189
     4         9821336d-3*t1*t139*t153*t206*t3*t38+1.0546577777777776d-1
     5         *t142*t269*t38+5.273288888888887d-2*t155*t255*t38+6.32794
     6         6666666665d-1*t147*t148*t292*t35*t36+3.1639733333333325d-
     7         1*t148*t174*t259*t35*t36-1.265589333333333d+0*t174*t209*t
     8         210*t35*t36+3.1639733333333325d-1*t148*t155*t209*t36-2.02
     9         934471398928d-2*t1*t139*t148*t153*t209*t3*t35+6.327946666
     :         666665d-1*t142*t147*t148*t174*t35-2.8363733333333335d-1*t
     ;         153*t204*t32*t335+9.454577777777778d-2*t153*t202*t203*t32
     <         -6.064083168526658d-3*t1*t137*t153*t202*t284*t3-1.2128166
     =         337053317d-2*t1*t153*t171*t207*t256*t3+1.8909155555555557
     >         d-1*t140*t207*t28*t289-4.0d+0*t114*t121*t280-6.5821231384
     ?         08225d-2*gammaaa*t111*t16*t17*t212*t25*t276-4.0d+0*t120*t
     @         121*t268+6.582123138408225d-2*gammaaa*t111*t112*t16*t25*t
     1         267+5.333333333333333d+0*t135*t147*t148*t264-3.2910615692
     2         041123d-2*gammaaa*t16*t161*t17*t212*t227*t25+3.2910615692
     3         041123d-2*t112*t16*t17*t227*t25+3.2910615692041123d-2*gam
     4         maaa*t112*t152*t16*t227*t25-3.2910615692041123d-2*t16*t17
     5         *t211*t212*t25-3.2910615692041123d-2*gammaaa*t152*t16*t21
     6         1*t212*t25+3.2910615692041123d-2*gammaaa*t112*t16*t161*t2
     7         00*t25+3.217926867666243d-1*gammaaa*t112*t161*t17*t182*t2
     8         5-2.0d+0*t121*t153*t237+2.0d+0*t153*t229*t230+4.0d+0*t114
     9         *t120*t167*t230-2.0d+0*t121*t167*t228+6.582123138408225d-
     :         2*gammaaa*t112*t16*t161*t17*t186*t187+5.333333333333333d+
     ;         0*t146*t147*t148*t180+5.333333333333333d+0*t135*t146*t148
     <         *t174)*wght-4.135669939329333d-1*t40*(-8.888888888888888d
     =         -1*t177*t72*t73+t265+t263+t262+t261+t175+t173+t172+t170+t
     >         168+t164+t162+t157+t156+t154)*wght-2.4814019635975998d+0*
     ?         t2*t293*wght+Cmat3(iq,D3_RA_RA_GAA)
            Cmat3(iq,D3_RA_GAA_GAA) = -9.305257363491d-1*t22*(-8.8888888
     1         88888888d-1*t73*t75*(4.7459599999999996d-2*t300*t95-2.4d+
     2         0*t68*(6.41391219265211d-2*t132*(-gammaaa*t16*t298*t89*t9
     3         1-2*t151*t16*t89*t91+2*gammaaa*t16*t187*t296*t91-gammaaa*
     4         t16*t299*t88*t89-2*t152*t16*t88*t89+2.6666666666666666d+0
     5         *gammaaa*t17*t298*t78*t89+5.333333333333333d+0*t151*t17*t
     6         78*t89+5.333333333333333d+0*gammaaa*t151*t152*t78*t89-gam
     7         maaa*t16*t17*t442*t89-2*gammaaa*t151*t16*t267*t89-2*t16*t
     8         17*t266*t89-2*gammaaa*t152*t16*t266*t89-6*gammaaa*t16*t17
     9         *t296*t365*t88+2*gammaaa*t16*t17*t187*t298*t88+4*t151*t16
     :         *t17*t187*t88+4*gammaaa*t151*t152*t16*t187*t88-2.66666666
     ;         66666666d+0*gammaaa*t25*t299*t78-5.333333333333333d+0*gam
     <         maaa*t17*t187*t296*t78-5.333333333333333d+0*t152*t25*t78+
     =         gammaaa*t16*t25*t443+2*t16*t25*t267+4*gammaaa*t151*t16*t1
     >         7*t187*t266)-5.0d-1*t131*t444-3.75d-1*t114*t294*t418+4.81
     ?         0434144489083d-2*t133*t345*t417-3.206956096326055d-2*t133
     @         *t249*t346+2.5d-1*t114*t251*t300-6.41391219265211d-2*t178
     1         *t249*t285+5.0d-1*t153*t251*t268)-8.400000000000001d+0*t1
     2         30*t444*t71-3.15d+1*t114*t294*t416*t71-2.1d+1*t114*t248*t
     3         300*t71-4.2d+1*t153*t248*t268*t71-2.7259596d+0*t444*t67+4
     4         .7459599999999996d-2*t445*t66+5.672746666666666d-2*t444*t
     5         66-5.4519192d+0*t114*t300*t66-1.0903838400000002d+1*t153*
     6         t268*t66+4.7459599999999996d-2*t35*t444-4.962870782535445
     7         7d+0*t130*t444-1.8610765434507923d+1*t114*t294*t416-8.400
     8         000000000001d+0*t114*t130*t347+4.7459599999999996d-2*t114
     9         *t302-1.2407176956338616d+1*t114*t248*t300-8.400000000000
     :         001d+0*t130*t134*t300+5.672746666666666d-2*t114*t300-2.1d
     ;         +1*t134*t248*t294-5.4519192d+0*t114*t294-1.68d+1*t130*t15
     <         3*t286+9.491919999999999d-2*t153*t269-2.481435391267723d+
     =         1*t153*t248*t268-1.68d+1*t130*t179*t268+9.491919999999999
     >         d-2*t155*t268+1.1345493333333331d-1*t153*t268-4.2d+1*t114
     ?         *t153*t179*t248)-1.0546577777777776d-1*t350*t36*t73*t95+1
     @         .3528964759928536d-2*t1*t139*t153*t174*t3*t73*t95-3.38224
     1         11899821336d-3*t1*t139*t3*t300*t38*t95+5.0733617849732d-3
     2         *t1*t171*t294*t3*t38*t95+3.1639733333333325d-1*t148*t304*
     3         t36*t95-8.888888888888888d-1*t72*t73*(4.9365923538061685d
     4         -2*t1*t3*t30*(7.5d-1*t1*t171*t3*t300*t93-1.875d+0*t1*t284
     5         *t294*t3*t93-5.0d-1*t1*t139*t3*t444+1.6666666666666666d-1
     6         *t1*t139*t23*t300+1.5d+0*t1*t153*t171*t268*t3-2.5d-1*t1*t
     7         171*t23*t294)+2.164695365020087d-1*t1*t171*t3*t300*t93-5.
     8         411738412550218d-1*t1*t284*t294*t3*t93-1.4431302433467247
     9         d-1*t1*t139*t3*t444-2.4682961769030842d-2*t1*t139*t145*t3
     :         *t300+4.810434144489082d-2*t1*t139*t23*t300+3.70244426535
     ;         46263d-2*t1*t145*t171*t294*t3-4.9365923538061685d-2*t1*t1
     <         39*t153*t290*t3+4.329390730040174d-1*t1*t153*t171*t268*t3
     =         -7.215651216733623d-2*t1*t171*t23*t294)+5.273288888888887
     >         d-2*t35*t38*(9.620868288978166d-2*t1*t171*t3*t300*t93-2.4
     ?         052170722445415d-1*t1*t284*t294*t3*t93-6.41391219265211d-
     @         2*t1*t139*t3*t444+2.1379707308840368d-2*t1*t139*t23*t300+
     1         1.924173657795633d-1*t1*t153*t171*t268*t3-3.2069560963260
     2         55d-2*t1*t171*t23*t294)-1.5557798788747831d-3*t207*t294*t
     3         39*t40*t460*t93+3.3352457426896626d-2*t1*t137*t294*t3*t43
     4         9*t93-2.8363733333333335d-1*t294*t32*t335*t93+9.454577777
     5         777778d-2*t203*t300*t32*t93-6.064083168526658d-3*t1*t137*
     6         t284*t3*t300*t93+7.57211d-1*(-1.6455307846020562d-2*gamma
     7         aa*t16*t298*t61*t65*t89*t91-3.2910615692041123d-2*t151*t1
     8         6*t61*t65*t89*t91+3.2910615692041123d-2*gammaaa*t126*t151
     9         *t16*t169*t65*t89*t91+1.6455307846020562d-2*gammaaa*t107*
     :         t128*t151*t153*t16*t61*t89*t91+3.2910615692041123d-2*gamm
     ;         aaa*t16*t187*t296*t61*t65*t91-1.6455307846020562d-2*gamma
     <         aa*t126*t16*t25*t328*t65*t91+3.2910615692041123d-2*gammaa
     =         a*t16*t242*t25*t325*t65*t91-3.2910615692041123d-2*t126*t1
     >         6*t169*t25*t65*t91+8.227653923010281d-3*gammaaa*t16*t245*
     ?         t25*t294*t329*t61*t91-8.227653923010281d-3*gammaaa*t107*t
     @         128*t16*t25*t300*t61*t91+4.1138269615051404d-3*gammaaa*t1
     1         28*t16*t223*t25*t294*t61*t91-1.6455307846020562d-2*t107*t
     2         128*t153*t16*t25*t61*t91+1.6455307846020562d-2*gammaaa*t1
     3         07*t126*t128*t153*t16*t169*t25*t91-1.6455307846020562d-2*
     4         gammaaa*t16*t299*t61*t65*t88*t89-3.2910615692041123d-2*t1
     5         52*t16*t61*t65*t88*t89+1.6455307846020562d-2*gammaaa*t126
     6         *t16*t17*t328*t65*t88*t89-3.2910615692041123d-2*gammaaa*t
     7         16*t17*t242*t325*t65*t88*t89+3.2910615692041123d-2*t126*t
     8         16*t169*t17*t65*t88*t89+3.2910615692041123d-2*gammaaa*t12
     9         6*t152*t16*t169*t65*t88*t89-8.227653923010281d-3*gammaaa*
     :         t16*t17*t245*t294*t329*t61*t88*t89+8.227653923010281d-3*g
     ;         ammaaa*t107*t128*t16*t17*t300*t61*t88*t89-4.1138269615051
     <         404d-3*gammaaa*t128*t16*t17*t223*t294*t61*t88*t89+1.64553
     =         07846020562d-2*t107*t128*t153*t16*t17*t61*t88*t89+1.64553
     >         07846020562d-2*gammaaa*t107*t128*t152*t153*t16*t61*t88*t8
     ?         9-1.6455307846020562d-2*gammaaa*t107*t126*t128*t153*t16*t
     @         169*t17*t88*t89+4.38808209227215d-2*gammaaa*t17*t298*t61*
     1         t65*t78*t89+8.7761641845443d-2*t151*t17*t61*t65*t78*t89+8
     2         .7761641845443d-2*gammaaa*t151*t152*t61*t65*t78*t89-8.776
     3         1641845443d-2*gammaaa*t126*t151*t169*t17*t65*t78*t89-4.38
     4         808209227215d-2*gammaaa*t107*t128*t151*t153*t17*t61*t78*t
     5         89-1.6455307846020562d-2*gammaaa*t16*t17*t442*t61*t65*t89
     6         -3.2910615692041123d-2*gammaaa*t151*t16*t267*t61*t65*t89-
     7         3.2910615692041123d-2*t16*t17*t266*t61*t65*t89-3.29106156
     8         92041123d-2*gammaaa*t152*t16*t266*t61*t65*t89+1.645530784
     9         6020562d-2*gammaaa*t125*t126*t16*t17*t298*t65*t89+3.29106
     :         15692041123d-2*gammaaa*t126*t151*t16*t17*t282*t65*t89+3.2
     ;         910615692041123d-2*gammaaa*t126*t16*t169*t17*t266*t65*t89
     <         -6.582123138408225d-2*gammaaa*t125*t151*t16*t169*t17*t242
     =         *t65*t89+3.2910615692041123d-2*t125*t126*t151*t16*t17*t65
     >         *t89+3.2910615692041123d-2*gammaaa*t125*t126*t151*t152*t1
     ?         6*t65*t89+1.6455307846020562d-2*gammaaa*t127*t128*t16*t17
     @         *t298*t61*t89+3.2910615692041123d-2*gammaaa*t128*t151*t16
     1         *t17*t283*t61*t89+1.6455307846020562d-2*gammaaa*t107*t128
     2         *t153*t16*t17*t266*t61*t89-3.2910615692041123d-2*gammaaa*
     3         t107*t127*t151*t153*t16*t17*t245*t61*t89+3.29106156920411
     4         23d-2*t127*t128*t151*t16*t17*t61*t89+3.2910615692041123d-
     5         2*gammaaa*t127*t128*t151*t152*t16*t61*t89-3.2910615692041
     6         123d-2*gammaaa*t126*t127*t128*t151*t16*t169*t17*t89-1.645
     7         5307846020562d-2*gammaaa*t107*t125*t126*t128*t151*t153*t1
     8         6*t17*t89-9.873184707612337d-2*gammaaa*t16*t17*t296*t365*
     9         t61*t65*t88+3.2910615692041123d-2*gammaaa*t16*t17*t187*t2
     :         98*t61*t65*t88+6.582123138408225d-2*t151*t16*t17*t187*t61
     ;         *t65*t88+6.582123138408225d-2*gammaaa*t151*t152*t16*t187*
     <         t61*t65*t88-6.582123138408225d-2*gammaaa*t126*t151*t16*t1
     =         69*t17*t187*t65*t88-3.2910615692041123d-2*gammaaa*t107*t1
     >         28*t151*t153*t16*t17*t187*t61*t88-4.38808209227215d-2*gam
     ?         maaa*t25*t299*t61*t65*t78-8.7761641845443d-2*gammaaa*t17*
     @         t187*t296*t61*t65*t78-8.7761641845443d-2*t152*t25*t61*t65
     1         *t78+4.38808209227215d-2*gammaaa*t126*t17*t25*t328*t65*t7
     2         8-8.7761641845443d-2*gammaaa*t17*t242*t25*t325*t65*t78+8.
     3         7761641845443d-2*t126*t169*t17*t25*t65*t78+8.776164184544
     4         3d-2*gammaaa*t126*t152*t169*t25*t65*t78-2.194041046136075
     5         d-2*gammaaa*t17*t245*t25*t294*t329*t61*t78+2.194041046136
     6         075d-2*gammaaa*t107*t128*t17*t25*t300*t61*t78-1.097020523
     7         0680374d-2*gammaaa*t128*t17*t223*t25*t294*t61*t78+4.38808
     8         209227215d-2*t107*t128*t153*t17*t25*t61*t78+4.38808209227
     9         215d-2*gammaaa*t107*t128*t152*t153*t25*t61*t78-4.38808209
     :         227215d-2*gammaaa*t107*t126*t128*t153*t169*t17*t25*t78+1.
     ;         6455307846020562d-2*gammaaa*t16*t25*t443*t61*t65+3.291061
     <         5692041123d-2*t16*t25*t267*t61*t65+6.582123138408225d-2*g
     =         ammaaa*t151*t16*t17*t187*t266*t61*t65-1.6455307846020562d
     >         -2*gammaaa*t126*t16*t17*t25*t459*t65-9.873184707612337d-2
     ?         *gammaaa*t125*t16*t17*t25*t325*t412*t65+3.291061569204112
     @         3d-2*gammaaa*t125*t16*t17*t242*t25*t328*t65-1.64553078460
     1         20562d-2*gammaaa*t125*t126*t16*t25*t299*t65-3.29106156920
     2         41123d-2*gammaaa*t125*t126*t16*t17*t187*t296*t65+6.582123
     3         138408225d-2*gammaaa*t16*t169*t17*t242*t25*t282*t65-3.291
     4         0615692041123d-2*t126*t16*t17*t25*t282*t65-3.291061569204
     5         1123d-2*gammaaa*t126*t152*t16*t25*t282*t65-3.291061569204
     6         1123d-2*gammaaa*t126*t16*t169*t25*t267*t65+6.582123138408
     7         225d-2*t125*t16*t169*t17*t242*t25*t65+6.582123138408225d-
     8         2*gammaaa*t125*t152*t16*t169*t242*t25*t65-3.2910615692041
     9         123d-2*t125*t126*t152*t16*t25*t65+t444*t61*t63-t126*t459*
     :         t59*t63-6*t125*t325*t412*t59*t63+2*t125*t242*t328*t59*t63
     ;         +4*t169*t242*t282*t59*t63-t114*t126*t328*t63+2*t114*t242*
     <         t325*t63-t125*t126*t300*t63-2*t126*t153*t282*t63-2*t126*t
     =         169*t268*t63+4*t125*t153*t169*t242*t63-t124*(t458+t457+t4
     >         56+t455)*t59*t61-1.5d+0*t123*t294*t324*t410*t59*t61+t116*
     ?         t123*t239*t300*t59*t61-5.0d-1*t123*t233*t239*t294*t59*t61
     @         +2*t116*t153*t239*t281*t59*t61-1.6455307846020562d-2*gamm
     1         aaa*t128*t16*t17*t25*(t454+t453+t452+t451)*t61-2.46829617
     2         69030842d-2*gammaaa*t127*t16*t17*t25*t294*t329*t414*t61+5
     3         .0d-1*t114*t239*t294*t324*t61+1.6455307846020562d-2*gamma
     4         aa*t107*t127*t16*t17*t245*t25*t300*t61-t123*t124*t300*t61
     5         -5.0d-1*t114*t116*t124*t300*t61-1.6455307846020562d-2*gam
     6         maaa*t127*t128*t16*t25*t299*t61-3.2910615692041123d-2*gam
     7         maaa*t127*t128*t16*t17*t187*t296*t61-8.227653923010281d-3
     8         *gammaaa*t127*t16*t17*t223*t245*t25*t294*t61+2*t116*t123*
     9         t239*t294*t61+2.5d-1*t114*t124*t233*t294*t61+3.2910615692
     :         041123d-2*gammaaa*t107*t153*t16*t17*t245*t25*t283*t61-3.2
     ;         910615692041123d-2*t128*t16*t17*t25*t283*t61-3.2910615692
     <         041123d-2*gammaaa*t128*t152*t16*t25*t283*t61-2*t124*t153*
     =         t281*t61-t116*t124*t153*t268*t61-1.6455307846020562d-2*ga
     >         mmaaa*t107*t128*t153*t16*t25*t267*t61+3.2910615692041123d
     ?         -2*t107*t127*t153*t16*t17*t245*t25*t61+3.2910615692041123
     @         d-2*gammaaa*t107*t127*t152*t153*t16*t245*t25*t61-3.291061
     1         5692041123d-2*t127*t128*t152*t16*t25*t61+t123*t124*t126*t
     2         328*t59-2*t123*t124*t242*t325*t59-5.0d-1*t125*t126*t239*t
     3         294*t324*t59+5.0d-1*t116*t124*t125*t126*t300*t59-2.5d-1*t
     4         124*t125*t126*t233*t294*t59+t116*t124*t126*t153*t282*t59+
     5         2*t124*t126*t169*t281*t59-2*t116*t124*t125*t153*t169*t242
     6         *t59-2*t116*t123*t126*t153*t169*t239*t59-8.22765392301028
     7         1d-3*gammaaa*t125*t126*t16*t17*t245*t25*t294*t329+1.64553
     8         07846020562d-2*gammaaa*t126*t127*t128*t16*t17*t25*t328-3.
     9         2910615692041123d-2*gammaaa*t127*t128*t16*t17*t242*t25*t3
     :         25+8.227653923010281d-3*gammaaa*t107*t125*t126*t128*t16*t
     ;         17*t25*t300-4.1138269615051404d-3*gammaaa*t125*t126*t128*
     <         t16*t17*t223*t25*t294+t116*t124*t125*t126*t294+3.29106156
     =         92041123d-2*gammaaa*t126*t128*t16*t169*t17*t25*t283+1.645
     >         5307846020562d-2*gammaaa*t107*t126*t128*t153*t16*t17*t25*
     ?         t282-3.2910615692041123d-2*gammaaa*t107*t126*t127*t153*t1
     @         6*t169*t17*t245*t25-3.2910615692041123d-2*gammaaa*t107*t1
     1         25*t128*t153*t16*t169*t17*t242*t25+3.2910615692041123d-2*
     2         t126*t127*t128*t16*t169*t17*t25+1.6455307846020562d-2*t10
     3         7*t125*t126*t128*t153*t16*t17*t25+3.2910615692041123d-2*g
     4         ammaaa*t126*t127*t128*t152*t16*t169*t25+1.645530784602056
     5         2d-2*gammaaa*t107*t125*t126*t128*t152*t153*t16*t25+2*t123
     6         *t124*t126*t153*t169+t114*t116*t124*t126*t153*t169)-3.291
     7         0615692041123d-2*gammaaa*t16*t298*t52*t89*t91-6.582123138
     8         408225d-2*t151*t16*t52*t89*t91-6.582123138408225d-2*gamma
     9         aa*t112*t151*t16*t161*t89*t91+6.582123138408225d-2*gammaa
     :         a*t16*t187*t296*t52*t91+3.2910615692041123d-2*gammaaa*t11
     ;         2*t16*t25*t318*t91-3.2910615692041123d-2*gammaaa*t16*t212
     <         *t25*t308*t91+6.582123138408225d-2*t112*t16*t161*t25*t91-
     =         3.2910615692041123d-2*gammaaa*t16*t299*t52*t88*t89-6.5821
     >         23138408225d-2*t152*t16*t52*t88*t89-3.2910615692041123d-2
     ?         *gammaaa*t112*t16*t17*t318*t88*t89+3.2910615692041123d-2*
     @         gammaaa*t16*t17*t212*t308*t88*t89-6.582123138408225d-2*t1
     1         12*t16*t161*t17*t88*t89-6.582123138408225d-2*gammaaa*t112
     2         *t152*t16*t161*t88*t89+8.7761641845443d-2*gammaaa*t17*t29
     3         8*t52*t78*t89+1.75523283690886d-1*t151*t17*t52*t78*t89+1.
     4         75523283690886d-1*gammaaa*t151*t152*t52*t78*t89+1.7552328
     5         3690886d-1*gammaaa*t112*t151*t161*t17*t78*t89-3.291061569
     6         2041123d-2*gammaaa*t16*t17*t442*t52*t89-6.582123138408225
     7         d-2*gammaaa*t151*t16*t267*t52*t89-6.582123138408225d-2*t1
     8         6*t17*t266*t52*t89-6.582123138408225d-2*gammaaa*t152*t16*
     9         t266*t52*t89-3.2910615692041123d-2*gammaaa*t111*t112*t16*
     :         t17*t298*t89-6.582123138408225d-2*gammaaa*t112*t151*t16*t
     ;         17*t276*t89-6.582123138408225d-2*gammaaa*t112*t16*t161*t1
     <         7*t266*t89+6.582123138408225d-2*gammaaa*t111*t151*t16*t16
     =         1*t17*t212*t89-6.582123138408225d-2*t111*t112*t151*t16*t1
     >         7*t89-6.582123138408225d-2*gammaaa*t111*t112*t151*t152*t1
     ?         6*t89-1.9746369415224674d-1*gammaaa*t16*t17*t296*t365*t52
     @         *t88+6.582123138408225d-2*gammaaa*t16*t17*t187*t298*t52*t
     1         88+1.316424627681645d-1*t151*t16*t17*t187*t52*t88+1.31642
     2         4627681645d-1*gammaaa*t151*t152*t16*t187*t52*t88+1.316424
     3         627681645d-1*gammaaa*t112*t151*t16*t161*t17*t187*t88-8.77
     4         61641845443d-2*gammaaa*t25*t299*t52*t78-1.75523283690886d
     5         -1*gammaaa*t17*t187*t296*t52*t78-1.75523283690886d-1*t152
     6         *t25*t52*t78-8.7761641845443d-2*gammaaa*t112*t17*t25*t318
     7         *t78+8.7761641845443d-2*gammaaa*t17*t212*t25*t308*t78-1.7
     8         5523283690886d-1*t112*t161*t17*t25*t78-1.75523283690886d-
     9         1*gammaaa*t112*t152*t161*t25*t78-4.727288888888889d-2*t32
     :         *t444*t77+4.727288888888889d-2*t137*t140*t300*t77+9.45457
     ;         7777777778d-2*t137*t153*t289*t77+2.6666666666666666d+0*t1
     <         48*t462*t72*t75+5.333333333333333d+1*t147*t304*t387*t72*t
     =         75-1.0666666666666666d+1*t147*t210*t350*t72*t75-2.1333333
     >         333333332d+1*t174*t210*t292*t72*t75+2.6666666666666666d+0
     ?         *t135*t148*t350*t75+2.6666666666666666d+0*t147*t148*t348*
     @         t75-1.0666666666666666d+1*t135*t210*t304*t75+5.3333333333
     1         33333d+0*t148*t180*t292*t75+5.333333333333333d+0*t148*t17
     2         4*t287*t75-2.1333333333333332d+1*t147*t174*t180*t210*t75-
     3         1.0546577777777776d-1*t35*t36*t462*t73-1.0546577777777776
     4         d-1*t147*t302*t36*t73-2.109315555555555d-1*t155*t292*t36*
     5         t73-2.109315555555555d-1*t174*t269*t36*t73-1.054657777777
     6         7776d-1*t142*t35*t350*t73+6.764482379964267d-3*t1*t139*t1
     7         47*t3*t300*t35*t73-1.01467235699464d-2*t1*t147*t171*t294*
     8         t3*t35*t73+1.3528964759928536d-2*t1*t139*t153*t292*t3*t35
     9         *t73-2.109315555555555d-1*t174*t288*t35*t73-8.88888888888
     :         8888d-1*t146*t348*t73-8.888888888888888d-1*t135*t342*t73+
     ;         1.3528964759928536d-2*t1*t139*t147*t153*t155*t3*t73-1.777
     <         7777777777776d+0*t180*t291*t73-1.7777777777777776d+0*t264
     =         *t287*t73-2.109315555555555d-1*t142*t155*t174*t73+2.66666
     >         66666666666d+0*t146*t148*t350*t72+2.6666666666666666d+0*t
     ?         147*t148*t342*t72-1.0666666666666666d+1*t146*t210*t304*t7
     @         2+5.333333333333333d+0*t148*t264*t292*t72+5.3333333333333
     1         33d+0*t148*t174*t291*t72-2.1333333333333332d+1*t147*t174*
     2         t210*t264*t72-2.0d+0*t121*(-1.475609999999999d-1*t106*t45
     3         0*t56-2.2134149999999983d-1*t105*t294*t311*t390*t56+1.475
     4         609999999999d-1*t102*t105*t214*t300*t56-7.378049999999994
     5         d-2*t105*t214*t216*t294*t56+2.951219999999998d-1*t102*t15
     6         3*t214*t272*t56-1.475609999999999d-1*t119*(t458+t457+t456
     7         +t455+t449+t448+t447+t446)*t50-8.853659999999993d-1*t118*
     8         t331*t405*t50+2.951219999999998d-1*t118*t232*t332*t50+5.9
     9         02439999999995d-1*t166*t232*t279*t50+1.475609999999999d-1
     :         *t105*t106*t119*t332-2.951219999999998d-1*t105*t106*t232*
     ;         t331-7.378049999999994d-2*t118*t119*t214*t294*t311+7.3780
     <         49999999994d-2*t102*t106*t118*t119*t300-3.689024999999997
     =         d-2*t106*t118*t119*t216*t294+1.475609999999999d-1*t102*t1
     >         06*t119*t153*t279+2.951219999999998d-1*t106*t119*t166*t27
     ?         2-2.951219999999998d-1*t102*t106*t118*t153*t166*t232-2.95
     @         1219999999998d-1*t102*t105*t119*t153*t166*t214)*t59-4.0d+
     1         0*t120*t322*t404*t59+2.0d+0*t120*t230*t333*t59+4.0d+0*t16
     2         7*t230*t280*t59-2.0d+0*t444*t58+3.2910615692041123d-2*gam
     3         maaa*t16*t25*t443*t52+6.582123138408225d-2*t16*t25*t267*t
     4         52+1.316424627681645d-1*gammaaa*t151*t16*t17*t187*t266*t5
     5         2+3.2910615692041123d-2*gammaaa*t112*t16*t17*t25*(6.0965d
     6         -1*t110*(t454+t453+t452+t451+t449+t448+t447+t446)*t50+3.6
     7         579d+0*t109*t312*t398*t50-1.2193000000000001d+0*t109*t222
     8         *t317*t50-2.4386000000000002d+0*t160*t222*t275*t50+6.0965
     9         d-1*t106*t450*t47+9.14475d-1*t105*t294*t311*t390*t47-6.09
     :         65d-1*t102*t105*t214*t300*t47+3.04825d-1*t105*t214*t216*t
     ;         294*t47-1.2193000000000001d+0*t102*t153*t214*t272*t47-6.0
     <         965d-1*t105*t106*t110*t317+1.2193000000000001d+0*t105*t10
     =         6*t222*t312+3.04825d-1*t109*t110*t214*t294*t311-3.04825d-
     >         1*t102*t106*t109*t110*t300+1.524125d-1*t106*t109*t110*t21
     ?         6*t294-6.0965d-1*t102*t106*t110*t153*t275-1.2193000000000
     @         001d+0*t106*t110*t160*t272+1.2193000000000001d+0*t102*t10
     1         6*t109*t153*t160*t222+1.2193000000000001d+0*t102*t105*t11
     2         0*t153*t160*t214)-4.727288888888889d-2*t137*t28*t461+5.27
     3         3288888888887d-2*t36*t38*t445-4.667339636624349d-3*t140*t
     4         294*t335*t385*t39*t40+6.582123138408225d-2*gammaaa*t111*t
     5         16*t17*t25*t308*t388+5.273288888888887d-2*t142*t302*t38-6
     6         .764482379964267d-3*t1*t139*t153*t269*t3*t38+1.0546577777
     7         777776d-1*t155*t288*t38+3.1639733333333325d-1*t147*t148*t
     8         35*t350*t36-1.265589333333333d+0*t147*t210*t304*t35*t36+6
     9         .327946666666665d-1*t148*t174*t292*t35*t36+6.327946666666
     :         665d-1*t147*t148*t155*t174*t36+3.1639733333333325d-1*t142
     ;         *t148*t304*t35-4.05868942797856d-2*t1*t139*t147*t148*t153
     <         *t174*t3*t35-2.0d+0*t114*t121*t333+2.0d+0*t114*t230*t322+
     =         1.8909155555555557d-1*t153*t203*t268*t32-3.29106156920411
     >         23d-2*gammaaa*t111*t16*t17*t212*t25*t318-1.21281663370533
     ?         17d-2*t1*t140*t171*t207*t3*t300-2.0d+0*t120*t121*t300+4.2
     @         44858217968661d-2*t1*t140*t207*t284*t294*t3-2.42563326741
     1         06634d-2*t1*t153*t171*t207*t289*t3-1.2128166337053317d-2*
     2         t1*t137*t153*t268*t284*t3+3.2910615692041123d-2*gammaaa*t
     3         111*t112*t16*t25*t299+6.582123138408225d-2*gammaaa*t111*t
     4         112*t16*t17*t187*t296-9.454577777777778d-2*t137*t140*t203
     5         *t294-4.0d+0*t121*t153*t280-6.582123138408225d-2*gammaaa*
     6         t16*t161*t17*t212*t25*t276+6.582123138408225d-2*t112*t16*
     7         t17*t25*t276+6.582123138408225d-2*gammaaa*t112*t152*t16*t
     8         25*t276-4.0d+0*t121*t167*t268+6.582123138408225d-2*gammaa
     9         a*t112*t16*t161*t25*t267+5.333333333333333d+0*t147*t148*t
     :         180*t264+5.333333333333333d+0*t135*t148*t174*t264-6.58212
     ;         3138408225d-2*t111*t16*t161*t17*t212*t25-6.58212313840822
     <         5d-2*gammaaa*t111*t152*t16*t161*t212*t25+6.58212313840822
     =         5d-2*t111*t112*t152*t16*t25+4.0d+0*t120*t153*t167*t230+5.
     >         333333333333333d+0*t146*t148*t174*t180)*wght-1.2407009817
     ?         987999d+0*t2*(-3.2910615692041123d-2*gammaaa*t16*t17*t298
     @         *t52*t89-6.582123138408225d-2*t151*t16*t17*t52*t89-6.5821
     1         23138408225d-2*gammaaa*t151*t152*t16*t52*t89-8.8888888888
     2         88888d-1*t348*t73*t75+2.6666666666666666d+0*t148*t350*t72
     3         *t75+5.333333333333333d+0*t148*t174*t180*t75-8.8888888888
     4         88888d-1*t342*t72*t73-1.0546577777777776d-1*t35*t350*t36*
     5         t73-2.109315555555555d-1*t155*t174*t36*t73+1.352896475992
     6         8536d-2*t1*t139*t153*t174*t3*t35*t73-1.7777777777777776d+
     7         0*t180*t264*t73+5.333333333333333d+0*t148*t174*t264*t72-2
     8         .0d+0*t121*t333*t59+3.2910615692041123d-2*gammaaa*t16*t25
     9         *t299*t52+6.582123138408225d-2*t152*t16*t25*t52-3.3822411
     :         899821336d-3*t1*t139*t3*t300*t35*t38-6.764482379964267d-3
     ;         *t1*t139*t153*t155*t3*t38+3.1639733333333325d-1*t148*t304
     <         *t35*t36+t339+t338+t337+t336+t330+t323+t321+3.29106156920
     =         41123d-2*gammaaa*t112*t16*t17*t25*t318+t309+t307+t306+t30
     >         5+t303+t301+t295+6.582123138408225d-2*t112*t16*t161*t17*t
     ?         25+6.582123138408225d-2*gammaaa*t112*t152*t16*t161*t25-4.
     @         0d+0*t121*t153*t167)*wght+Cmat3(iq,D3_RA_GAA_GAA)
            Cmat3(iq,D3_GAA_GAA_GAA) = Cmat3(iq,D3_GAA_GAA_GAA)-9.305257
     1         363491d-1*t22*(t73*(-8.888888888888888d-1*t75*(-2.4d+0*t6
     2         8*(6.41391219265211d-2*t132*(-gammaaa*t16*t17*t465*t89-3*
     3         gammaaa*t151*t16*t299*t89-3*t16*t17*t298*t89-3*gammaaa*t1
     4         52*t16*t298*t89-6*t151*t152*t16*t89+gammaaa*t16*t25*t466-
     5         6*gammaaa*t16*t17*t365*t464+3*t16*t25*t299+6*gammaaa*t151
     6         *t16*t17*t187*t298+6*t16*t17*t187*t296+6*gammaaa*t152*t16
     7         *t187*t296)-5.0d-1*t131*t467-3.75d-1*t418*t463+4.81043414
     8         4489083d-2*t178**3*t417-9.620868288978166d-2*t178*t249*t3
     9         46+7.5d-1*t153*t251*t300)-8.400000000000001d+0*t130*t467*
     :         t71-3.15d+1*t416*t463*t71-6.3d+1*t153*t248*t300*t71-2.725
     ;         9596d+0*t467*t67+4.7459599999999996d-2*t468*t66+5.6727466
     <         66666666d-2*t467*t66-1.6355757600000004d+1*t153*t300*t66+
     =         4.7459599999999996d-2*t35*t467-4.9628707825354457d+0*t130
     >         *t467-1.8610765434507923d+1*t416*t463-5.4519192d+0*t463-2
     ?         .52d+1*t130*t153*t347+1.423788d-1*t153*t302-3.72215308690
     @         15845d+1*t153*t248*t300-2.52d+1*t130*t179*t300+1.423788d-
     1         1*t155*t300+1.7018239999999996d-1*t153*t300-6.3d+1*t179*t
     2         248*t294)-8.888888888888888d-1*t72*(-2.4682961769030842d-
     3         2*t39*t40*t467*t77-1.4431302433467247d-1*t1*t139*t3*t467-
     4         1.4809777061418505d-1*t335*t39*t40*t463-5.411738412550218
     5         d-1*t1*t284*t3*t463+1.4809777061418505d-1*t153*t203*t300*
     6         t39*t40+6.494086095060261d-1*t1*t153*t171*t3*t300)-1.0546
     7         577777777776d-1*t35*t36*t481-3.1639733333333325d-1*t155*t
     8         350*t36-3.1639733333333325d-1*t174*t302*t36+1.35289647599
     9         28536d-2*t1*t139*t153*t3*t35*t350+6.764482379964267d-3*t1
     :         *t139*t174*t3*t300*t35-1.01467235699464d-2*t1*t171*t174*t
     ;         294*t3*t35-2.6666666666666666d+0*t177*t348-2.666666666666
     <         6666d+0*t180*t342+2.02934471398928d-2*t1*t139*t153*t155*t
     =         174*t3)+7.57211d-1*(-1.6455307846020562d-2*gammaaa*t16*t1
     >         7*t465*t61*t65*t89-4.9365923538061685d-2*gammaaa*t151*t16
     ?         *t299*t61*t65*t89-4.9365923538061685d-2*t16*t17*t298*t61*
     @         t65*t89-4.9365923538061685d-2*gammaaa*t152*t16*t298*t61*t
     1         65*t89-9.873184707612337d-2*t151*t152*t16*t61*t65*t89+4.9
     2         365923538061685d-2*gammaaa*t126*t151*t16*t17*t328*t65*t89
     3         -9.873184707612337d-2*gammaaa*t151*t16*t17*t242*t325*t65*
     4         t89+4.9365923538061685d-2*gammaaa*t126*t16*t169*t17*t298*
     5         t65*t89+9.873184707612337d-2*t126*t151*t16*t169*t17*t65*t
     6         89+9.873184707612337d-2*gammaaa*t126*t151*t152*t16*t169*t
     7         65*t89-2.4682961769030842d-2*gammaaa*t151*t16*t17*t245*t2
     8         94*t329*t61*t89+2.4682961769030842d-2*gammaaa*t107*t128*t
     9         151*t16*t17*t300*t61*t89+2.4682961769030842d-2*gammaaa*t1
     :         07*t128*t153*t16*t17*t298*t61*t89-1.2341480884515421d-2*g
     ;         ammaaa*t128*t151*t16*t17*t223*t294*t61*t89+4.936592353806
     <         1685d-2*t107*t128*t151*t153*t16*t17*t61*t89+4.93659235380
     =         61685d-2*gammaaa*t107*t128*t151*t152*t153*t16*t61*t89-4.9
     >         365923538061685d-2*gammaaa*t107*t126*t128*t151*t153*t16*t
     ?         169*t17*t89+1.6455307846020562d-2*gammaaa*t16*t25*t466*t6
     @         1*t65-9.873184707612337d-2*gammaaa*t16*t17*t365*t464*t61*
     1         t65+4.9365923538061685d-2*t16*t25*t299*t61*t65+9.87318470
     2         7612337d-2*gammaaa*t151*t16*t17*t187*t298*t61*t65+9.87318
     3         4707612337d-2*t16*t17*t187*t296*t61*t65+9.873184707612337
     4         d-2*gammaaa*t152*t16*t187*t296*t61*t65-1.6455307846020562
     5         d-2*gammaaa*t126*t16*t17*t25*t480*t65-9.873184707612337d-
     6         2*gammaaa*t16*t17*t25*t412*t476*t65+9.873184707612337d-2*
     7         gammaaa*t16*t169*t17*t242*t25*t328*t65-4.9365923538061685
     8         d-2*t126*t16*t17*t25*t328*t65-4.9365923538061685d-2*gamma
     9         aa*t126*t152*t16*t25*t328*t65+9.873184707612337d-2*t16*t1
     :         7*t242*t25*t325*t65+9.873184707612337d-2*gammaaa*t152*t16
     ;         *t242*t25*t325*t65-4.9365923538061685d-2*gammaaa*t126*t16
     <         *t169*t25*t299*t65-9.873184707612337d-2*gammaaa*t126*t16*
     =         t169*t17*t187*t296*t65-9.873184707612337d-2*t126*t152*t16
     >         *t169*t25*t65+t467*t61*t63-t126*t480*t59*t63-6*t412*t476*
     ?         t59*t63+6*t169*t242*t328*t59*t63-3*t126*t153*t328*t63+6*t
     @         153*t242*t325*t63-3*t126*t169*t300*t63-7.5d-1*t239*t463*t
     1         59*t61/t53**2-5.0d-1*t116*t124*t467*t59*t61-7.5d-1*t233*t
     2         410*t463*t59*t61-3.75d-1*t124*t406*t463*t59*t61+1.5d+0*t1
     3         53*t239*t300*t324*t59*t61+7.5d-1*t124*t153*t233*t300*t59*
     4         t61-8.227653923010281d-3*gammaaa*t107*t128*t16*t17*t25*t4
     5         67*t61-1.2341480884515421d-2*gammaaa*t16*t17*t245*t25*t46
     6         3*t61/t42**2-1.2341480884515421d-2*gammaaa*t16*t17*t223*t
     7         25*t414*t463*t61-6.170740442257711d-3*gammaaa*t128*t16*t1
     8         7*t25*t399*t463*t61+1.5d+0*t239*t324*t463*t61+7.5d-1*t124
     9         *t233*t463*t61+2.4682961769030842d-2*gammaaa*t153*t16*t17
     :         *t245*t25*t300*t329*t61+2.4682961769030842d-2*t16*t17*t24
     ;         5*t25*t294*t329*t61+2.4682961769030842d-2*gammaaa*t152*t1
     <         6*t245*t25*t294*t329*t61+1.2341480884515421d-2*gammaaa*t1
     =         28*t153*t16*t17*t223*t25*t300*t61-2.4682961769030842d-2*t
     >         107*t128*t16*t17*t25*t300*t61-2.4682961769030842d-2*gamma
     ?         aa*t107*t128*t152*t16*t25*t300*t61-3*t116*t124*t153*t300*
     @         t61-2.4682961769030842d-2*gammaaa*t107*t128*t153*t16*t25*
     1         t299*t61-4.9365923538061685d-2*gammaaa*t107*t128*t153*t16
     2         *t17*t187*t296*t61+1.2341480884515421d-2*t128*t16*t17*t22
     3         3*t25*t294*t61+1.2341480884515421d-2*gammaaa*t128*t152*t1
     4         6*t223*t25*t294*t61-4.9365923538061685d-2*t107*t128*t152*
     5         t153*t16*t25*t61+1.5d+0*t116*t124*t126*t153*t328*t59-3*t1
     6         16*t124*t153*t242*t325*t59-1.5d+0*t126*t169*t239*t294*t32
     7         4*t59+1.5d+0*t116*t124*t126*t169*t300*t59-7.5d-1*t124*t12
     8         6*t169*t233*t294*t59-2.4682961769030842d-2*gammaaa*t126*t
     9         16*t169*t17*t245*t25*t294*t329+2.4682961769030842d-2*gamm
     :         aaa*t107*t126*t128*t153*t16*t17*t25*t328-4.93659235380616
     ;         85d-2*gammaaa*t107*t128*t153*t16*t17*t242*t25*t325+2.4682
     <         961769030842d-2*gammaaa*t107*t126*t128*t16*t169*t17*t25*t
     =         300-1.2341480884515421d-2*gammaaa*t126*t128*t16*t169*t17*
     >         t223*t25*t294+3*t116*t124*t126*t169*t294+4.93659235380616
     ?         85d-2*t107*t126*t128*t153*t16*t169*t17*t25+4.936592353806
     @         1685d-2*gammaaa*t107*t126*t128*t152*t153*t16*t169*t25)+t1
     1         6*(-3.2910615692041123d-2*gammaaa*t17*t465*t52-3.29106156
     2         92041123d-2*gammaaa*t151*t299*t52-6.582123138408225d-2*t1
     3         7*t298*t52-6.582123138408225d-2*gammaaa*t152*t298*t52-6.5
     4         82123138408225d-2*t151*t152*t52-2*t151*t310-3.29106156920
     5         41123d-2*gammaaa*t112*t161*t17*t298-t163*t298-3.291061569
     6         2041123d-2*t112*t151*t161*t17-3.2910615692041123d-2*gamma
     7         aa*t112*t151*t152*t161)*t89+t112*t16*(-t151*t319-6.582123
     8         138408225d-2*gammaaa*t151*t17*t318-6.582123138408225d-2*g
     9         ammaaa*t161*t17*t298-6.582123138408225d-2*t151*t161*t17-6
     :         .582123138408225d-2*gammaaa*t151*t152*t161)*t89+9.8731847
     ;         07612337d-2*gammaaa*t151*t16*t17*t212*t308*t89-4.72728888
     <         8888889d-2*t32*t467*t77+t148*(2.6666666666666666d+0*t481*
     =         t72*t75+5.333333333333333d+0*t180*t350*t75+2.666666666666
     >         6666d+0*t174*t348*t75+5.333333333333333d+0*t177*t350*t72+
     ?         2.6666666666666666d+0*t174*t342*t72-3.0d+0*t174*(-1.05465
     @         77777777776d-1*t155*t174*t36+t351+t349+t344+t343+t341)-3.
     1         0d+0*t174*t352-3.0d+0*t181*t350+5.333333333333333d+0*t174
     2         *t177*t180)+t210*(-2.1333333333333332d+1*t174*t350*t72*t7
     3         5-1.0666666666666666d+1*t180*t304*t75-1.0666666666666666d
     4         +1*t177*t304*t72-4.0d+0*t174*t353)+5.333333333333333d+1*t
     5         174**3*t387*t72*t75+t139*t3*(6.764482379964267d-3*t1*t153
     6         *t35*t350+6.764482379964267d-3*t1*t174*t300*t35-2.0d+0*t1
     7         74*t340+6.764482379964267d-3*t1*t153*t155*t174)*t73-2.029
     8         34471398928d-2*t1*t171*t174*t294*t3*t35*t73+t121*(-2.0d+0
     9         *(-1.1067074999999992d-1*t214*t463*t469*t56-7.37804999999
     :         9994d-2*t102*t106*t467*t56-5.533537499999995d-2*t106*t392
     ;         *t463*t56-1.1067074999999992d-1*t216*t390*t463*t56+2.2134
     <         149999999983d-1*t153*t214*t300*t311*t56+1.106707499999999
     =         2d-1*t106*t153*t216*t300*t56-1.475609999999999d-1*t119*(t
     >         479+t478+t477+t475+t474+t473)*t50-8.853659999999993d-1*t1
     ?         66**3*t405*t50+8.853659999999993d-1*t166*t232*t332*t50+2.
     @         2134149999999983d-1*t102*t106*t119*t153*t332-4.4268299999
     1         999966d-1*t102*t106*t153*t232*t331-2.2134149999999983d-1*
     2         t119*t166*t214*t294*t311+2.2134149999999983d-1*t102*t106*
     3         t119*t166*t300-1.1067074999999992d-1*t106*t119*t166*t216*
     4         t294)*t59-6.0d+0*t153*t333-6.0d+0*t167*t300)+t230*(4.0d+0
     5         *t167*t333*t59-t167*t334+2.0d+0*t153*t322)-4.0d+0*t167**3
     6         *t404*t59-2.0d+0*t467*t58+t16*t25*(3.2910615692041123d-2*
     7         gammaaa*t466*t52+9.873184707612337d-2*t299*t52+3.29106156
     8         92041123d-2*t112*t17*t318+3.2910615692041123d-2*gammaaa*t
     9         112*t152*t318-3.2910615692041123d-2*t17*t212*t308-3.29106
     :         15692041123d-2*gammaaa*t152*t212*t308+6.582123138408225d-
     ;         2*gammaaa*t112*t161*t299+1.316424627681645d-1*t112*t152*t
     <         161)+t16*t187*(1.316424627681645d-1*gammaaa*t151*t17*t298
     =         *t52+6.582123138408225d-2*t17*t296*t52+6.582123138408225d
     >         -2*gammaaa*t152*t296*t52-2*t151*t320)-1.9746369415224674d
     ?         -1*gammaaa*t16*t17*t365*t464*t52+t112*t16*t25*(3.29106156
     @         92041123d-2*gammaaa*t17*(6.0965d-1*t110*(t475+t474+t473+t
     1         472+t471+t470)*t50+3.6579d+0*t160**3*t398*t50-3.6579d+0*t
     2         160*t222*t317*t50+4.572375d-1*t214*t463*t469*t47+3.04825d
     3         -1*t102*t106*t467*t47+2.2861875d-1*t106*t392*t463*t47+4.5
     4         72375d-1*t216*t390*t463*t47-9.14475d-1*t153*t214*t300*t31
     5         1*t47-4.572375d-1*t106*t153*t216*t300*t47-9.14475d-1*t102
     6         *t106*t110*t153*t317+1.82895d+0*t102*t106*t153*t222*t312+
     7         9.14475d-1*t110*t160*t214*t294*t311-9.14475d-1*t102*t106*
     8         t110*t160*t300+4.572375d-1*t106*t110*t160*t216*t294)+6.58
     9         2123138408225d-2*t17*t318+6.582123138408225d-2*gammaaa*t1
     :         52*t318+3.2910615692041123d-2*gammaaa*t161*t299+6.5821231
     ;         38408225d-2*t152*t161)+5.273288888888887d-2*t36*t38*t468+
     <         t139*t3*t38*(-3.3822411899821336d-3*t1*t35*t467-1.0146723
     =         5699464d-2*t1*t153*t302-1.01467235699464d-2*t1*t155*t300)
     >         +6.064083168526658d-3*t1*t137*t171*t3*t467-1.166834909156
     ?         0873d-2*t207*t39*t40*t460*t463+8.641318515150488d-2*t1*t1
     @         37*t3*t439*t463+5.987181320518676d-4*t1**3*t385*t463/(rho
     1         a*t29**11)-1.2683404462433d-2*t1*t284*t3*t35*t38*t463-2.8
     2         363733333333335d-1*t32*t335*t463+4.667339636624349d-3*t15
     3         3*t207*t300*t335*t39*t40+6.582123138408225d-2*gammaaa*t16
     4         *t161**3*t17*t25*t388+t171*t3*(1.01467235699464d-2*t1*t15
     5         3*t300*t35+5.0733617849732d-3*t1*t155*t294)*t38-1.5d+0*t1
     6         53*t171*t3*t340*t38-2.02934471398928d-2*t1*t139*t148*t153
     7         *t3*t304*t35+2.8363733333333335d-1*t153*t203*t300*t32+t16
     8         *t212*t25*(-t161*t319-6.582123138408225d-2*gammaaa*t161*t
     9         17*t318-3.2910615692041123d-2*t17*t308-3.2910615692041123
     :         d-2*gammaaa*t152*t308)-6.367287326952992d-2*t1*t137*t153*
     ;         t284*t3*t300+1.9746369415224674d-1*gammaaa*t112*t16*t161*
     <         t17*t187*t296)*wght
          elseif (rhoa.le.tol_rho.and.rhob.gt.tol_rho) then 
            t1 = param(1)
            t2 = rhob**3.333333333333333d-1
            t3 = 1/t2
            t4 = t1*t3
            t5 = gammabb**5.0d-1
            t6 = t5**7
            t7 = 1/rhob**9.333333333333333d+0
            t8 = gammabb**3
            t9 = 1/rhob**8
            t10 = t5**5
            t11 = 1/rhob**6.666666666666667d+0
            t12 = gammabb**2
            t13 = 1/rhob**5.333333333333333d+0
            t14 = t5**3
            t15 = 1/rhob**4
            t16 = 1/rhob**2.6666666666666666d+0
            t17 = -4.327677396975467d-7*t8*t9+2.4123830247695402d-8*t6*t
     1         7+2.631878392200375d-4*gammabb*t16+1.8005513133540818d-4*
     2         t14*t15-4.342399100269002d-5*t12*t13+5.3020963068324d-6*t
     3         10*t11
            t18 = t5**9
            t19 = 1/rhob**12
            t20 = gammabb**4
            t21 = 1/rhob**1.0666666666666666d+1
            t22 = rhob**1.3333333333333333d+0
            t23 = 1/t22
            t24 = -2.7196832676277033d-6*t8*t9+1.7578986477855002d-7*t6*
     1         t7+6.841322473346062d-1*t23*t5-5.649671283776346d-9*t20*t
     2         21+3.149302550983647d-10*t18*t19-2.0532933130264455d-1*ga
     3         mmabb*t16+2.342799068769956d-2*t14*t15-1.3837064697606524
     4         d-3*t12*t13+5.955909787676884d-5*t10*t11+1.0d+0
            t25 = 1/t24
            t26 = 1.6455307846020562d-2*gammabb*t16*t17*t25
            t27 = 6.582123138408225d-2*t4**2.0d+0+t26+6.0965d-1
            t28 = 1/t27
            t29 = t27**5.0d-1
            t30 = 1/t29
            t31 = 2.565564877060844d-1*t1*t3*t30+1.0d+0
            t32 = 1/t31
            t33 = 4.1138269615051404d-3*gammabb*t16+1.0d+0
            t34 = 1/t33
            t35 = 5.136628594837797d-3*gammabb*t16*t34+6.934448603031025
     1         d-2*gammabb*t16*t17*t25+1.0d+0
            t36 = 1.282782438530422d-1*t1*t3*t30+1.0d+0
            t37 = t27*t31
            t38 = 1/t37**2.0d+0
            t39 = t1**2
            t40 = 1/rhob**6.666666666666666d-1
            t41 = 6.582123138408225d-2*t39*t40
            t42 = t41+t26
            t43 = t42**5.0d-1
            t44 = t41+t26+6.0965d-1
            t45 = t44**5.0d-1
            t46 = t45+t43
            t47 = 1/t46
            t48 = 2.565564877060844d-1*t1*t3
            t49 = t48+t45
            t50 = 1/t49
            t51 = 1.0d+0-6.0965d-1*t47*t50
            t52 = log(t51)
            t53 = t41+t26+7.57211d-1
            t54 = t53**5.0d-1
            t55 = t54+t45
            t56 = 1/t55
            t57 = 1.475609999999999d-1*t50*t56+1.0d+0
            t58 = log(t57)
            t59 = t26+7.57211d-1
            t60 = t54+t43
            t61 = 1/t60
            t62 = t54+t48
            t63 = 1/t62
            t64 = t48+t43
            t65 = 1/t64
            t66 = t26+6.0965d-1
            t67 = t66**2.0d+0
            t68 = t66**3.5d+0
            t69 = (gammabb*t16*t17*t25)**5.0d-1
            t70 = t59**5.0d-1
            t71 = 1.282782438530422d-1*t69-t70
            t72 = -2.4d+0*t68*t71-1.417963080724413d+0*t68+2.83637333333
     1         3333d-2*t67-9.086532d-1*t66**3.0d+0+4.7459599999999996d-2
     2         *t35*t66
            t73 = 1/t37**3.0d+0
            t74 = t1*t3*t30
            t75 = 2.4682961769030842d-2*t74**2.0d+0+2.8862604866934494d-
     1         1*t1*t3*t30+1.0d+0
            t76 = -8.888888888888888d-1*t72*t73*t75+7.57211d-1*(1.645530
     1         7846020562d-2*gammabb*t16*t17*t25*t61*t65+t59*t61*t63)-2.
     2         0d+0*t58*t59+3.2910615692041123d-2*gammabb*t16*t17*t25*t5
     3         2+5.273288888888887d-2*t35*t36*t38+4.727288888888889d-2*t
     4         28*t32-1.0d+0
            t77 = 1/t27**2
            t78 = 1/rhob**3.6666666666666664d+0
            t79 = -4.38808209227215d-2*gammabb*t17*t25*t78
            t80 = 1/rhob**13
            t81 = 1/rhob**1.1666666666666665d+1
            t82 = 1/rhob**1.0333333333333333d+1
            t83 = 1/rhob**9
            t84 = 1/rhob**7.666666666666667d+0
            t85 = 1/rhob**6.333333333333333d+0
            t86 = 1/rhob**5
            t87 = 1/rhob**2.3333333333333334d+0
            t88 = -9.121763297794749d-1*t5*t87-9.371196275079824d-2*t14*
     1         t86+7.379767838723479d-3*t12*t85-3.970606525117923d-4*t10
     2         *t84+2.1757466141021625d-5*t8*t83-1.6407054045998d-6*t6*t
     3         82+6.026316036028103d-8*t20*t81-3.7791630611803767d-9*t18
     4         *t80+5.475448834737188d-1*gammabb*t78
            t89 = 1/t24**2
            t90 = -1.6455307846020562d-2*gammabb*t16*t17*t88*t89
            t91 = -7.202205253416327d-4*t14*t86+2.3159461868101344d-4*t1
     1         2*t85-3.5347308712216d-5*t10*t84+3.462141917580374d-6*t8*
     2         t83-2.2515574897849044d-7*t6*t82-7.018342379201d-4*gammab
     3         b*t78
            t92 = 1.6455307846020562d-2*gammabb*t16*t25*t91
            t93 = t92+t90+t79-4.38808209227215d-2*t1*t23*t4
            t94 = 1/t33**2
            t95 = 5.634986987915197d-5*t12*t85*t94+6.934448603031025d-2*
     1         gammabb*t16*t25*t91-6.934448603031025d-2*gammabb*t16*t17*
     2         t88*t89-1.369767625290079d-2*gammabb*t34*t78-1.8491862941
     3         416065d-1*gammabb*t17*t25*t78
            t96 = 5.273288888888887d-2*t36*t38*t95
            t97 = -8.7761641845443d-2*gammabb*t17*t25*t52*t78
            t98 = -3.2910615692041123d-2*gammabb*t16*t17*t52*t88*t89
            t99 = 3.2910615692041123d-2*gammabb*t16*t25*t52*t91
            t100 = 1/rhob**1.6666666666666669d+0
            t101 = t92+t90+t79-4.38808209227215d-2*t100*t39
            t102 = 1/t45
            t103 = 5.0d-1*t101*t102
            t104 = -8.551882923536147d-2*t1*t23
            t105 = t104+t103
            t106 = 1/t49**2
            t107 = 1/t43
            t108 = 5.0d-1*t101*t107
            t109 = t108+t103
            t110 = 1/t46**2
            t111 = 6.0965d-1*t109*t110*t50+6.0965d-1*t105*t106*t47
            t112 = 1/t51
            t113 = 3.2910615692041123d-2*gammabb*t111*t112*t16*t17*t25
            t114 = t92+t90+t79
            t115 = -2.0d+0*t114*t58
            t116 = 1/t54
            t117 = 5.0d-1*t101*t116
            t118 = t117+t103
            t119 = 1/t55**2
            t120 = -1.475609999999999d-1*t105*t106*t56-1.475609999999999
     1         d-1*t118*t119*t50
            t121 = 1/t57
            t122 = -2.0d+0*t120*t121*t59
            t123 = t117+t104
            t124 = 1/t62**2
            t125 = t117+t108
            t126 = 1/t60**2
            t127 = t108+t104
            t128 = 1/t64**2
            t129 = 7.57211d-1*(1.6455307846020562d-2*gammabb*t16*t25*t61
     1         *t65*t91-1.6455307846020562d-2*gammabb*t16*t17*t61*t65*t8
     2         8*t89-4.38808209227215d-2*gammabb*t17*t25*t61*t65*t78-1.6
     3         455307846020562d-2*gammabb*t125*t126*t16*t17*t25*t65+t114
     4         *t61*t63-t125*t126*t59*t63-t123*t124*t59*t61-1.6455307846
     5         020562d-2*gammabb*t127*t128*t16*t17*t25*t61)
            t130 = t66**2.5d+0
            t131 = 1/t70
            t132 = 1/t69
            t133 = gammabb*t16*t25*t91-gammabb*t16*t17*t88*t89-2.6666666
     1         666666666d+0*gammabb*t17*t25*t78
            t134 = 6.41391219265211d-2*t132*t133-5.0d-1*t114*t131
            t135 = 4.7459599999999996d-2*t66*t95-8.400000000000001d+0*t1
     1         14*t130*t71-2.4d+0*t134*t68-2.7259596d+0*t114*t67+5.67274
     2         6666666666d-2*t114*t66+4.7459599999999996d-2*t114*t35-4.9
     3         628707825354457d+0*t114*t130
            t136 = -8.888888888888888d-1*t135*t73*t75
            t137 = 1/t31**2
            t138 = -8.551882923536147d-2*t1*t23*t30
            t139 = 1/t29**3
            t140 = t138-1.282782438530422d-1*t1*t139*t3*t93
            t141 = -4.2759414617680735d-2*t1*t23*t30
            t142 = t141-6.41391219265211d-2*t1*t139*t3*t93
            t143 = -9.620868288978164d-2*t1*t23*t30
            t144 = -3.333333333333333d-1*t1*t23*t30
            t145 = t144-5.0d-1*t1*t139*t3*t93
            t146 = -1.4431302433467247d-1*t1*t139*t3*t93+4.9365923538061
     1         685d-2*t145*t74+t143
            t147 = t31*t93+t140*t27
            t148 = 1/t37**4.0d+0
            t149 = t99+t98+t97+t96-4.727288888888889d-2*t32*t77*t93+2.66
     1         66666666666666d+0*t147*t148*t72*t75-8.888888888888888d-1*
     2         t146*t72*t73-1.0546577777777776d-1*t147*t35*t36*t73+5.273
     3         288888888887d-2*t142*t35*t38-4.727288888888889d-2*t137*t1
     4         40*t28+t136+t129+t122+t115+t113
            t150 = 1/t5
            t151 = -8.159049802883108d-6*t12*t9-2.2598685135105387d-8*t2
     1         1*t8+6.15264526724925d-7*t10*t7+1.4171861479426412d-9*t19
     2         *t6+3.514198603154934d-2*t15*t5+3.420661236673031d-1*t150
     3         *t23-2.0532933130264455d-1*t16+1.488977446919221d-4*t11*t
     4         14-2.767412939521305d-3*gammabb*t13
            t152 = -1.2983032190926402d-6*t12*t9+8.443340586693391d-8*t1
     1         0*t7+2.7008269700311227d-4*t15*t5+2.631878392200375d-4*t1
     2         6+1.3255240767081d-5*t11*t14-8.684798200538004d-5*gammabb
     3         *t13
            t153 = -1.6455307846020562d-2*gammabb*t151*t16*t17*t89+1.645
     1         5307846020562d-2*t16*t17*t25+1.6455307846020562d-2*gammab
     2         b*t152*t16*t25
            t154 = -4.727288888888889d-2*t153*t32*t77
            t155 = -2.113120120468199d-5*gammabb*t13*t94-6.9344486030310
     1         25d-2*gammabb*t151*t16*t17*t89+5.136628594837797d-3*t16*t
     2         34+6.934448603031025d-2*t16*t17*t25+6.934448603031025d-2*
     3         gammabb*t152*t16*t25
            t156 = 5.273288888888887d-2*t155*t36*t38
            t157 = -3.2910615692041123d-2*gammabb*t151*t16*t17*t52*t89
            t158 = 5.0d-1*t107*t153
            t159 = 5.0d-1*t102*t153
            t160 = t159+t158
            t161 = 6.0965d-1*t110*t160*t50+3.04825d-1*t102*t106*t153*t47
            t162 = 3.2910615692041123d-2*gammabb*t112*t16*t161*t17*t25
            t163 = 3.2910615692041123d-2*t17*t52+3.2910615692041123d-2*g
     1         ammabb*t152*t52
            t164 = -2.0d+0*t153*t58
            t165 = 5.0d-1*t116*t153
            t166 = t165+t159
            t167 = -7.378049999999994d-2*t102*t106*t153*t56-1.4756099999
     1         99999d-1*t119*t166*t50
            t168 = -2.0d+0*t121*t167*t59
            t169 = t165+t158
            t170 = 7.57211d-1*(-1.6455307846020562d-2*gammabb*t151*t16*t
     1         17*t61*t65*t89+1.6455307846020562d-2*t16*t17*t25*t61*t65+
     2         1.6455307846020562d-2*gammabb*t152*t16*t25*t61*t65-1.6455
     3         307846020562d-2*gammabb*t126*t16*t169*t17*t25*t65+t153*t6
     4         1*t63-t126*t169*t59*t63-5.0d-1*t116*t124*t153*t59*t61-8.2
     5         27653923010281d-3*gammabb*t107*t128*t153*t16*t17*t25*t61)
            t171 = 1/t29**5
            t172 = 6.064083168526658d-3*t1*t137*t153*t171*t3
            t173 = -3.3822411899821336d-3*t1*t139*t153*t3*t35*t38
            t174 = t153*t31-1.282782438530422d-1*t1*t153*t3*t30
            t175 = 2.6666666666666666d+0*t148*t174*t72*t75
            t176 = -1.4431302433467247d-1*t1*t139*t153*t3
            t177 = t176-2.4682961769030842d-2*t153*t39*t40*t77
            t178 = -gammabb*t151*t16*t17*t89+t16*t17*t25+gammabb*t152*t1
     1         6*t25
            t179 = 6.41391219265211d-2*t132*t178-5.0d-1*t131*t153
            t180 = -8.400000000000001d+0*t130*t153*t71-2.4d+0*t179*t68-2
     1         .7259596d+0*t153*t67+4.7459599999999996d-2*t155*t66+5.672
     2         746666666666d-2*t153*t66+4.7459599999999996d-2*t153*t35-4
     3         .9628707825354457d+0*t130*t153
            t181 = -8.888888888888888d-1*t180*t75-8.888888888888888d-1*t
     1         177*t72-1.0546577777777776d-1*t174*t35*t36
            t182 = 1/rhob**4.666666666666667d+0
            t183 = 1.6089634338331216d-1*gammabb*t17*t182*t25
            t184 = 8.7761641845443d-2*gammabb*t17*t78*t88*t89
            t185 = -8.7761641845443d-2*gammabb*t25*t78*t91
            t186 = t88**2
            t187 = 1/t24**3
            t188 = 3.2910615692041123d-2*gammabb*t16*t17*t186*t187
            t189 = 1/rhob**14
            t190 = 1/rhob**1.2666666666666665d+1
            t191 = 1/rhob**1.1333333333333334d+1
            t192 = 1/rhob**10
            t193 = 1/rhob**8.666666666666666d+0
            t194 = 1/rhob**7.333333333333333d+0
            t195 = 1/rhob**6
            t196 = 1/rhob**3.3333333333333337d+0
            t197 = -1.9581719526919464d-4*t192*t8+1.695395584753127d-5*t
     1         191*t6+2.1284114361521084d+0*t196*t5-7.030702042032786d-7
     2         *t190*t20+4.685598137539912d-1*t14*t195-4.673852964524870
     3         5d-2*t12*t194+3.0441316692570747d-3*t10*t193+4.9129119795
     4         344894d-8*t18*t189-2.0076645727369685d+0*gammabb*t182
            t198 = -1.6455307846020562d-2*gammabb*t16*t17*t197*t89
            t199 = -3.2910615692041123d-2*gammabb*t16*t88*t89*t91
            t200 = -3.115927725822337d-5*t192*t8+2.326609406111068d-6*t1
     1         91*t6+3.6011026267081636d-3*t14*t195-1.466765918313085d-3
     2         *t12*t194+2.709960334603227d-4*t10*t193+2.573392205707033
     3         5d-3*gammabb*t182
            t201 = 1.6455307846020562d-2*gammabb*t16*t200*t25
            t202 = 7.313470153786916d-2*t16*t39+t201+t199+t198+t188+t185
     1         +t184+t183
            t203 = 1/t27**3
            t204 = t93**2
            t205 = 1/t33**3
            t206 = -5.071488289123677d-4*t12*t194*t94-1.386889720606205d
     1         -1*gammabb*t16*t88*t89*t91-3.698372588283213d-1*gammabb*t
     2         25*t78*t91+3.698372588283213d-1*gammabb*t17*t78*t88*t89-6
     3         .934448603031025d-2*gammabb*t16*t17*t197*t89+1.2363392745
     4         928628d-6*t192*t205*t8+5.02248129273029d-2*gammabb*t182*t
     5         34+6.934448603031025d-2*gammabb*t16*t200*t25+6.7803497451
     6         85891d-1*gammabb*t17*t182*t25+1.386889720606205d-1*gammab
     7         b*t16*t17*t186*t187
            t207 = 1/t31**3
            t208 = t140**2
            t209 = t147**2
            t210 = 1/t37**5.0d+0
            t211 = t111**2
            t212 = 1/t51**2
            t213 = t105**2
            t214 = 1/t49**3
            t215 = t101**2
            t216 = 1/t45**3
            t217 = -2.5d-1*t215*t216
            t218 = 5.0d-1*t102*t202
            t219 = 1.1402510564714863d-1*t1*t87
            t220 = t219+t218+t217
            t221 = t109**2
            t222 = 1/t46**3
            t223 = 1/t43**3
            t224 = -2.5d-1*t215*t223
            t225 = 5.0d-1*t107*t202
            t226 = t225+t224+t218+t217
            t227 = 6.0965d-1*t110*t226*t50-1.2193000000000001d+0*t221*t2
     1         22*t50+6.0965d-1*t106*t220*t47-1.2193000000000001d+0*t213
     2         *t214*t47-1.2193000000000001d+0*t105*t106*t109*t110
            t228 = t201+t199+t198+t188+t185+t184+t183
            t229 = t120**2
            t230 = 1/t57**2
            t231 = t118**2
            t232 = 1/t55**3
            t233 = 1/t54**3
            t234 = -2.5d-1*t215*t233
            t235 = 5.0d-1*t116*t202
            t236 = t235+t234+t218+t217
            t237 = -1.475609999999999d-1*t106*t220*t56+2.951219999999998
     1         d-1*t213*t214*t56-1.475609999999999d-1*t119*t236*t50+2.95
     2         1219999999998d-1*t231*t232*t50+2.951219999999998d-1*t105*
     3         t106*t118*t119
            t238 = t123**2
            t239 = 1/t62**3
            t240 = t235+t234+t219
            t241 = t125**2
            t242 = 1/t60**3
            t243 = t235+t234+t225+t224
            t244 = t127**2
            t245 = 1/t64**3
            t246 = t225+t224+t219
            t247 = t114**2
            t248 = t66**1.5d+0
            t249 = 1/t69**3
            t250 = t133**2
            t251 = 1/t70**3
            t252 = -2*gammabb*t16*t88*t89*t91-5.333333333333333d+0*gamma
     1         bb*t25*t78*t91+5.333333333333333d+0*gammabb*t17*t78*t88*t
     2         89-gammabb*t16*t17*t197*t89+gammabb*t16*t200*t25+9.777777
     3         777777779d+0*gammabb*t17*t182*t25+2*gammabb*t16*t17*t186*
     4         t187
            t253 = 6.41391219265211d-2*t132*t252+2.5d-1*t247*t251-3.2069
     1         56096326055d-2*t249*t250-5.0d-1*t131*t228
            t254 = 9.491919999999999d-2*t114*t95-2.1d+1*t247*t248*t71-8.
     1         400000000000001d+0*t130*t228*t71-2.4d+0*t253*t68-2.725959
     2         6d+0*t228*t67-5.4519192d+0*t247*t66+5.672746666666666d-2*
     3         t228*t66+4.7459599999999996d-2*t206*t66+4.745959999999999
     4         6d-2*t228*t35-1.2407176956338616d+1*t247*t248+5.672746666
     5         666666d-2*t247-4.9628707825354457d+0*t130*t228-1.68d+1*t1
     6         14*t130*t134
            t255 = 4.2759414617680735d-2*t1*t139*t23*t93+5.7012552823574
     1         31d-2*t1*t30*t87+9.620868288978166d-2*t1*t171*t204*t3-6.4
     2         1391219265211d-2*t1*t139*t202*t3
            t256 = 8.551882923536147d-2*t1*t139*t23*t93+1.14025105647148
     1         63d-1*t1*t30*t87+1.924173657795633d-1*t1*t171*t204*t3-1.2
     2         82782438530422d-1*t1*t139*t202*t3
            t257 = 3.333333333333333d-1*t1*t139*t23*t93+4.44444444444444
     1         4d-1*t1*t30*t87+7.5d-1*t1*t171*t204*t3-5.0d-1*t1*t139*t20
     2         2*t3
            t258 = 9.620868288978164d-2*t1*t139*t23*t93+1.28278243853042
     1         18d-1*t1*t30*t87+4.9365923538061685d-2*t1*t257*t3*t30+2.1
     2         64695365020087d-1*t1*t171*t204*t3-1.4431302433467247d-1*t
     3         1*t139*t202*t3+4.9365923538061685d-2*t145**2
            t259 = 2*t140*t93+t202*t31+t256*t27
            t260 = -2.109315555555555d-1*t147*t36*t73*t95+1.054657777777
     1         7776d-1*t142*t38*t95+9.454577777777778d-2*t137*t140*t77*t
     2         93+7.57211d-1*(-3.2910615692041123d-2*gammabb*t16*t61*t65
     3         *t88*t89*t91-8.7761641845443d-2*gammabb*t25*t61*t65*t78*t
     4         91-3.2910615692041123d-2*gammabb*t125*t126*t16*t25*t65*t9
     5         1-3.2910615692041123d-2*gammabb*t127*t128*t16*t25*t61*t91
     6         +8.7761641845443d-2*gammabb*t17*t61*t65*t78*t88*t89+3.291
     7         0615692041123d-2*gammabb*t125*t126*t16*t17*t65*t88*t89+3.
     8         2910615692041123d-2*gammabb*t127*t128*t16*t17*t61*t88*t89
     9         -1.6455307846020562d-2*gammabb*t16*t17*t197*t61*t65*t89+8
     :         .7761641845443d-2*gammabb*t125*t126*t17*t25*t65*t78+8.776
     ;         1641845443d-2*gammabb*t127*t128*t17*t25*t61*t78+1.6455307
     <         846020562d-2*gammabb*t16*t200*t25*t61*t65+1.6089634338331
     =         216d-1*gammabb*t17*t182*t25*t61*t65+3.2910615692041123d-2
     >         *gammabb*t16*t17*t186*t187*t61*t65-1.6455307846020562d-2*
     ?         gammabb*t126*t16*t17*t243*t25*t65+3.2910615692041123d-2*g
     @         ammabb*t16*t17*t241*t242*t25*t65+t228*t61*t63-t126*t243*t
     1         59*t63+2*t241*t242*t59*t63-2*t114*t125*t126*t63-t124*t240
     2         *t59*t61+2*t238*t239*t59*t61-1.6455307846020562d-2*gammab
     3         b*t128*t16*t17*t246*t25*t61+3.2910615692041123d-2*gammabb
     4         *t16*t17*t244*t245*t25*t61-2*t114*t123*t124*t61+2*t123*t1
     5         24*t125*t126*t59+3.2910615692041123d-2*gammabb*t125*t126*
     6         t127*t128*t16*t17*t25)-6.582123138408225d-2*gammabb*t16*t
     7         52*t88*t89*t91-1.75523283690886d-1*gammabb*t25*t52*t78*t9
     8         1+6.582123138408225d-2*gammabb*t111*t112*t16*t25*t91+1.75
     9         523283690886d-1*gammabb*t17*t52*t78*t88*t89-6.58212313840
     :         8225d-2*gammabb*t111*t112*t16*t17*t88*t89-3.2910615692041
     ;         123d-2*gammabb*t16*t17*t197*t52*t89-1.75523283690886d-1*g
     <         ammabb*t111*t112*t17*t25*t78-4.727288888888889d-2*t202*t3
     =         2*t77-8.888888888888888d-1*t254*t73*t75+2.666666666666666
     >         6d+0*t148*t259*t72*t75-1.0666666666666666d+1*t209*t210*t7
     ?         2*t75+5.333333333333333d+0*t135*t147*t148*t75-8.888888888
     @         888888d-1*t258*t72*t73-1.0546577777777776d-1*t259*t35*t36
     1         *t73-2.109315555555555d-1*t142*t147*t35*t73-1.77777777777
     2         77776d+0*t135*t146*t73+5.333333333333333d+0*t146*t147*t14
     3         8*t72-2.0d+0*t121*t237*t59+2.0d+0*t229*t230*t59-2.0d+0*t2
     4         28*t58+3.2910615692041123d-2*gammabb*t16*t200*t25*t52+3.2
     5         17926867666243d-1*gammabb*t17*t182*t25*t52+6.582123138408
     6         225d-2*gammabb*t16*t17*t186*t187*t52+5.273288888888887d-2
     7         *t206*t36*t38+5.273288888888887d-2*t255*t35*t38+3.1639733
     8         333333325d-1*t148*t209*t35*t36+9.454577777777778d-2*t203*
     9         t204*t32-4.727288888888889d-2*t137*t256*t28+9.45457777777
     :         7778d-2*t207*t208*t28+3.2910615692041123d-2*gammabb*t112*
     ;         t16*t17*t227*t25-3.2910615692041123d-2*gammabb*t16*t17*t2
     <         11*t212*t25-4.0d+0*t114*t120*t121
            t261 = 3.2910615692041123d-2*gammabb*t152*t16*t25*t52
            t262 = 3.2910615692041123d-2*t16*t17*t25*t52
            t263 = -8.888888888888888d-1*t180*t73*t75
            t264 = t176-2.4682961769030842d-2*t1*t139*t153*t3*t74
            t265 = -1.0546577777777776d-1*t174*t35*t36*t73
            t266 = -4.5608816488973747d-1*t150*t87-1.4056794412619736d-1
     1         *t5*t86+1.4759535677446958d-2*gammabb*t85-9.9265163127948
     2         08d-4*t14*t84+6.527239842306487d-5*t12*t83-5.742468916099
     3         301d-6*t10*t82+2.4105264144112412d-7*t8*t81-1.70062337753
     4         11694d-8*t6*t80+5.475448834737188d-1*t78
            t267 = -1.0803307880124491d-3*t5*t86+4.631892373620269d-4*ga
     1         mmabb*t85-8.836827178054d-5*t14*t84+1.0386425752741123d-5
     2         *t12*t83-7.880451214247165d-7*t10*t82-7.018342379201d-4*t
     3         78
            t268 = -1.6455307846020562d-2*gammabb*t151*t16*t89*t91+1.645
     1         5307846020562d-2*t16*t25*t91-1.6455307846020562d-2*t16*t1
     2         7*t88*t89-1.6455307846020562d-2*gammabb*t152*t16*t88*t89+
     3         4.38808209227215d-2*gammabb*t151*t17*t78*t89-1.6455307846
     4         020562d-2*gammabb*t16*t17*t266*t89+3.2910615692041123d-2*
     5         gammabb*t151*t16*t17*t187*t88-4.38808209227215d-2*t17*t25
     6         *t78-4.38808209227215d-2*gammabb*t152*t25*t78+1.645530784
     7         6020562d-2*gammabb*t16*t25*t267
            t269 = 1.690496096374559d-4*gammabb*t85*t94-6.93444860303102
     1         5d-2*gammabb*t151*t16*t89*t91+6.934448603031025d-2*t16*t2
     2         5*t91-6.934448603031025d-2*t16*t17*t88*t89-6.934448603031
     3         025d-2*gammabb*t152*t16*t88*t89+1.8491862941416065d-1*gam
     4         mabb*t151*t17*t78*t89-6.934448603031025d-2*gammabb*t16*t1
     5         7*t266*t89+1.386889720606205d-1*gammabb*t151*t16*t17*t187
     6         *t88-4.6362722797232353d-7*t12*t205*t83-1.369767625290079
     7         d-2*t34*t78-1.8491862941416065d-1*t17*t25*t78-1.849186294
     8         1416065d-1*gammabb*t152*t25*t78+6.934448603031025d-2*gamm
     9         abb*t16*t25*t267
            t270 = -2.5d-1*t101*t153*t216
            t271 = 5.0d-1*t102*t268
            t272 = t271+t270
            t273 = -2.5d-1*t101*t153*t223
            t274 = 5.0d-1*t107*t268
            t275 = t274+t273+t271+t270
            t276 = 6.0965d-1*t110*t275*t50-1.2193000000000001d+0*t109*t1
     1         60*t222*t50+6.0965d-1*t106*t272*t47-6.0965d-1*t102*t105*t
     2         153*t214*t47-6.0965d-1*t105*t106*t110*t160-3.04825d-1*t10
     3         2*t106*t109*t110*t153
            t277 = -2.5d-1*t101*t153*t233
            t278 = 5.0d-1*t116*t268
            t279 = t278+t277+t271+t270
            t280 = -1.475609999999999d-1*t106*t272*t56+1.475609999999999
     1         d-1*t102*t105*t153*t214*t56-1.475609999999999d-1*t119*t27
     2         9*t50+2.951219999999998d-1*t118*t166*t232*t50+1.475609999
     3         999999d-1*t105*t106*t119*t166+7.378049999999994d-2*t102*t
     4         106*t118*t119*t153
            t281 = t278+t277
            t282 = t278+t277+t274+t273
            t283 = t274+t273
            t284 = 1/t29**7
            t285 = -gammabb*t151*t16*t89*t91+t16*t25*t91-t16*t17*t88*t89
     1         -gammabb*t152*t16*t88*t89+2.6666666666666666d+0*gammabb*t
     2         151*t17*t78*t89-gammabb*t16*t17*t266*t89+2*gammabb*t151*t
     3         16*t17*t187*t88-2.6666666666666666d+0*t17*t25*t78-2.66666
     4         66666666666d+0*gammabb*t152*t25*t78+gammabb*t16*t25*t267
            t286 = 6.41391219265211d-2*t132*t285-5.0d-1*t131*t268+2.5d-1
     1         *t114*t153*t251-3.206956096326055d-2*t133*t178*t249
            t287 = 4.7459599999999996d-2*t153*t95-8.400000000000001d+0*t
     1         130*t268*t71-2.1d+1*t114*t153*t248*t71-2.4d+0*t286*t68-2.
     2         7259596d+0*t268*t67+4.7459599999999996d-2*t269*t66+5.6727
     3         46666666666d-2*t268*t66-5.4519192d+0*t114*t153*t66+4.7459
     4         599999999996d-2*t268*t35-4.9628707825354457d+0*t130*t268-
     5         1.2407176956338616d+1*t114*t153*t248-8.400000000000001d+0
     6         *t114*t130*t179+4.7459599999999996d-2*t114*t155-8.4000000
     7         00000001d+0*t130*t134*t153+5.672746666666666d-2*t114*t153
            t288 = 9.620868288978166d-2*t1*t153*t171*t3*t93-6.4139121926
     1         5211d-2*t1*t139*t268*t3+2.1379707308840368d-2*t1*t139*t15
     2         3*t23
            t289 = 1.924173657795633d-1*t1*t153*t171*t3*t93-1.2827824385
     1         30422d-1*t1*t139*t268*t3+4.2759414617680735d-2*t1*t139*t1
     2         53*t23
            t290 = 7.5d-1*t1*t153*t171*t3*t93-5.0d-1*t1*t139*t268*t3+1.6
     1         666666666666666d-1*t1*t139*t153*t23
            t291 = 2.164695365020087d-1*t1*t153*t171*t3*t93+4.9365923538
     1         061685d-2*t1*t290*t3*t30-1.4431302433467247d-1*t1*t139*t2
     2         68*t3-2.4682961769030842d-2*t1*t139*t145*t153*t3+4.810434
     3         144489082d-2*t1*t139*t153*t23
            t292 = -1.282782438530422d-1*t1*t139*t153*t3*t93+t268*t31+t2
     1         7*t289+t140*t153
            t293 = -1.0546577777777776d-1*t174*t36*t73*t95-3.38224118998
     1         21336d-3*t1*t139*t153*t3*t38*t95+9.454577777777778d-2*t15
     2         3*t203*t32*t93-6.064083168526658d-3*t1*t137*t153*t284*t3*
     3         t93+7.57211d-1*(-1.6455307846020562d-2*gammabb*t151*t16*t
     4         61*t65*t89*t91+1.6455307846020562d-2*t16*t25*t61*t65*t91-
     5         1.6455307846020562d-2*gammabb*t126*t16*t169*t25*t65*t91-8
     6         .227653923010281d-3*gammabb*t107*t128*t153*t16*t25*t61*t9
     7         1-1.6455307846020562d-2*t16*t17*t61*t65*t88*t89-1.6455307
     8         846020562d-2*gammabb*t152*t16*t61*t65*t88*t89+1.645530784
     9         6020562d-2*gammabb*t126*t16*t169*t17*t65*t88*t89+8.227653
     :         923010281d-3*gammabb*t107*t128*t153*t16*t17*t61*t88*t89+4
     ;         .38808209227215d-2*gammabb*t151*t17*t61*t65*t78*t89-1.645
     <         5307846020562d-2*gammabb*t16*t17*t266*t61*t65*t89+1.64553
     =         07846020562d-2*gammabb*t125*t126*t151*t16*t17*t65*t89+1.6
     >         455307846020562d-2*gammabb*t127*t128*t151*t16*t17*t61*t89
     ?         +3.2910615692041123d-2*gammabb*t151*t16*t17*t187*t61*t65*
     @         t88-4.38808209227215d-2*t17*t25*t61*t65*t78-4.38808209227
     1         215d-2*gammabb*t152*t25*t61*t65*t78+4.38808209227215d-2*g
     2         ammabb*t126*t169*t17*t25*t65*t78+2.194041046136075d-2*gam
     3         mabb*t107*t128*t153*t17*t25*t61*t78+1.6455307846020562d-2
     4         *gammabb*t16*t25*t267*t61*t65-1.6455307846020562d-2*gamma
     5         bb*t126*t16*t17*t25*t282*t65+3.2910615692041123d-2*gammab
     6         b*t125*t16*t169*t17*t242*t25*t65-1.6455307846020562d-2*t1
     7         25*t126*t16*t17*t25*t65-1.6455307846020562d-2*gammabb*t12
     8         5*t126*t152*t16*t25*t65+t268*t61*t63-t126*t282*t59*t63+2*
     9         t125*t169*t242*t59*t63-t114*t126*t169*t63-t125*t126*t153*
     :         t63-t124*t281*t59*t61+t116*t123*t153*t239*t59*t61-1.64553
     ;         07846020562d-2*gammabb*t128*t16*t17*t25*t283*t61+1.645530
     <         7846020562d-2*gammabb*t107*t127*t153*t16*t17*t245*t25*t61
     =         -1.6455307846020562d-2*t127*t128*t16*t17*t25*t61-1.645530
     >         7846020562d-2*gammabb*t127*t128*t152*t16*t25*t61-t123*t12
     ?         4*t153*t61-5.0d-1*t114*t116*t124*t153*t61+t123*t124*t126*
     @         t169*t59+5.0d-1*t116*t124*t125*t126*t153*t59+1.6455307846
     1         020562d-2*gammabb*t126*t127*t128*t16*t169*t17*t25+8.22765
     2         3923010281d-3*gammabb*t107*t125*t126*t128*t153*t16*t17*t2
     3         5)-3.2910615692041123d-2*gammabb*t151*t16*t52*t89*t91+3.2
     4         910615692041123d-2*t16*t25*t52*t91+3.2910615692041123d-2*
     5         gammabb*t112*t16*t161*t25*t91-3.2910615692041123d-2*t16*t
     6         17*t52*t88*t89-3.2910615692041123d-2*gammabb*t152*t16*t52
     7         *t88*t89-3.2910615692041123d-2*gammabb*t112*t16*t161*t17*
     8         t88*t89+8.7761641845443d-2*gammabb*t151*t17*t52*t78*t89-3
     9         .2910615692041123d-2*gammabb*t16*t17*t266*t52*t89-3.29106
     :         15692041123d-2*gammabb*t111*t112*t151*t16*t17*t89+6.58212
     ;         3138408225d-2*gammabb*t151*t16*t17*t187*t52*t88-8.7761641
     <         845443d-2*t17*t25*t52*t78-8.7761641845443d-2*gammabb*t152
     =         *t25*t52*t78-8.7761641845443d-2*gammabb*t112*t161*t17*t25
     >         *t78-4.727288888888889d-2*t268*t32*t77+4.727288888888889d
     ?         -2*t137*t140*t153*t77-8.888888888888888d-1*t287*t73*t75+2
     @         .6666666666666666d+0*t148*t292*t72*t75-1.0666666666666666
     1         d+1*t147*t174*t210*t72*t75+2.6666666666666666d+0*t147*t14
     2         8*t180*t75+2.6666666666666666d+0*t135*t148*t174*t75-8.888
     3         888888888888d-1*t291*t72*t73-1.0546577777777776d-1*t292*t
     4         35*t36*t73-1.0546577777777776d-1*t147*t155*t36*t73+6.7644
     5         82379964267d-3*t1*t139*t147*t153*t3*t35*t73-1.05465777777
     6         77776d-1*t142*t174*t35*t73-8.888888888888888d-1*t135*t264
     7         *t73-8.888888888888888d-1*t146*t180*t73+2.666666666666666
     8         6d+0*t147*t148*t264*t72+2.6666666666666666d+0*t146*t148*t
     9         174*t72-2.0d+0*t121*t280*t59+2.0d+0*t120*t167*t230*t59-2.
     :         0d+0*t268*t58+3.2910615692041123d-2*gammabb*t16*t25*t267*
     ;         t52+5.273288888888887d-2*t269*t36*t38+5.273288888888887d-
     <         2*t288*t35*t38+5.273288888888887d-2*t142*t155*t38+3.16397
     =         33333333325d-1*t147*t148*t174*t35*t36-1.2128166337053317d
     >         -2*t1*t140*t153*t171*t207*t3-4.727288888888889d-2*t137*t2
     ?         8*t289+3.2910615692041123d-2*gammabb*t112*t16*t17*t25*t27
     @         6-3.2910615692041123d-2*gammabb*t111*t16*t161*t17*t212*t2
     1         5+3.2910615692041123d-2*t111*t112*t16*t17*t25+3.291061569
     2         2041123d-2*gammabb*t111*t112*t152*t16*t25-2.0d+0*t114*t12
     3         1*t167-2.0d+0*t120*t121*t153
            t294 = t153**2
            t295 = 9.454577777777778d-2*t203*t294*t32
            t296 = t151**2
            t297 = 1/t14
            t298 = -1.6318099605766218d-5*gammabb*t9+1.5381613168123123d
     1         -6*t14*t7+2.2334661703788317d-4*t11*t5-1.7103306183365155
     2         d-1*t23*t297-6.779605540531617d-8*t12*t21+4.9601515177992
     3         45d-9*t10*t19+1.757099301577467d-2*t15*t150-2.76741293952
     4         1305d-3*t13
            t299 = -2.5966064381852805d-6*gammabb*t9+2.1108351466733477d
     1         -7*t14*t7+1.9882861150621498d-5*t11*t5+1.3504134850155614
     2         d-4*t15*t150-8.684798200538004d-5*t13
            t300 = -1.6455307846020562d-2*gammabb*t16*t17*t298*t89-3.291
     1         0615692041123d-2*t151*t16*t17*t89-3.2910615692041123d-2*g
     2         ammabb*t151*t152*t16*t89+1.6455307846020562d-2*gammabb*t1
     3         6*t25*t299+3.2910615692041123d-2*gammabb*t16*t17*t187*t29
     4         6+3.2910615692041123d-2*t152*t16*t25
            t301 = -4.727288888888889d-2*t300*t32*t77
            t302 = -4.226240240936398d-5*t13*t94+1.7386021048962136d-7*g
     1         ammabb*t205*t9-6.934448603031025d-2*gammabb*t16*t17*t298*
     2         t89-1.386889720606205d-1*t151*t16*t17*t89-1.3868897206062
     3         05d-1*gammabb*t151*t152*t16*t89+6.934448603031025d-2*gamm
     4         abb*t16*t25*t299+1.386889720606205d-1*gammabb*t16*t17*t18
     5         7*t296+1.386889720606205d-1*t152*t16*t25
            t303 = 5.273288888888887d-2*t302*t36*t38
            t304 = t174**2
            t305 = -1.0666666666666666d+1*t210*t304*t72*t75
            t306 = 6.582123138408225d-2*gammabb*t16*t17*t187*t296*t52
            t307 = -6.582123138408225d-2*gammabb*t112*t151*t16*t161*t17*
     1         t89
            t308 = t161**2
            t309 = -3.2910615692041123d-2*gammabb*t16*t17*t212*t25*t308
            t310 = 3.2910615692041123d-2*gammabb*t299*t52+6.582123138408
     1         225d-2*t152*t52+3.2910615692041123d-2*t112*t161*t17+3.291
     2         0615692041123d-2*gammabb*t112*t152*t161
            t311 = 1/t44
            t312 = t160**2
            t313 = -2.5d-1*t223*t294
            t314 = 5.0d-1*t107*t300
            t315 = -2.5d-1*t216*t294
            t316 = 5.0d-1*t102*t300
            t317 = t316+t315+t314+t313
            t318 = 6.0965d-1*t110*t317*t50-1.2193000000000001d+0*t222*t3
     1         12*t50-3.04825d-1*t214*t294*t311*t47+3.04825d-1*t102*t106
     2         *t300*t47-1.524125d-1*t106*t216*t294*t47-6.0965d-1*t102*t
     3         106*t110*t153*t160
            t319 = 3.2910615692041123d-2*gammabb*t17*t318+3.291061569204
     1         1123d-2*t161*t17+3.2910615692041123d-2*gammabb*t152*t161
            t320 = -3.2910615692041123d-2*gammabb*t17*t298*t52-3.2910615
     1         692041123d-2*t151*t17*t52-3.2910615692041123d-2*gammabb*t
     2         151*t152*t52-t151*t163
            t321 = -2.0d+0*t300*t58
            t322 = t167**2
            t323 = 2.0d+0*t230*t322*t59
            t324 = 1/t53
            t325 = t169**2
            t326 = -2.5d-1*t233*t294
            t327 = 5.0d-1*t116*t300
            t328 = t327+t326+t314+t313
            t329 = 1/t42
            t330 = 7.57211d-1*(-1.6455307846020562d-2*gammabb*t16*t17*t2
     1         98*t61*t65*t89-3.2910615692041123d-2*t151*t16*t17*t61*t65
     2         *t89-3.2910615692041123d-2*gammabb*t151*t152*t16*t61*t65*
     3         t89+3.2910615692041123d-2*gammabb*t126*t151*t16*t169*t17*
     4         t65*t89+1.6455307846020562d-2*gammabb*t107*t128*t151*t153
     5         *t16*t17*t61*t89+1.6455307846020562d-2*gammabb*t16*t25*t2
     6         99*t61*t65+3.2910615692041123d-2*gammabb*t16*t17*t187*t29
     7         6*t61*t65+3.2910615692041123d-2*t152*t16*t25*t61*t65-1.64
     8         55307846020562d-2*gammabb*t126*t16*t17*t25*t328*t65+3.291
     9         0615692041123d-2*gammabb*t16*t17*t242*t25*t325*t65-3.2910
     :         615692041123d-2*t126*t16*t169*t17*t25*t65-3.2910615692041
     ;         123d-2*gammabb*t126*t152*t16*t169*t25*t65+t300*t61*t63-t1
     <         26*t328*t59*t63+2*t242*t325*t59*t63-2*t126*t153*t169*t63+
     =         5.0d-1*t239*t294*t324*t59*t61-5.0d-1*t116*t124*t300*t59*t
     >         61+2.5d-1*t124*t233*t294*t59*t61+8.227653923010281d-3*gam
     ?         mabb*t16*t17*t245*t25*t294*t329*t61-8.227653923010281d-3*
     @         gammabb*t107*t128*t16*t17*t25*t300*t61+4.1138269615051404
     1         d-3*gammabb*t128*t16*t17*t223*t25*t294*t61-t116*t124*t294
     2         *t61-1.6455307846020562d-2*t107*t128*t153*t16*t17*t25*t61
     3         -1.6455307846020562d-2*gammabb*t107*t128*t152*t153*t16*t2
     4         5*t61+t116*t124*t126*t153*t169*t59+1.6455307846020562d-2*
     5         gammabb*t107*t126*t128*t153*t16*t169*t17*t25)
            t331 = t166**2
            t332 = t327+t326+t316+t315
            t333 = 7.378049999999994d-2*t214*t294*t311*t56-7.37804999999
     1         9994d-2*t102*t106*t300*t56+3.689024999999997d-2*t106*t216
     2         *t294*t56-1.475609999999999d-1*t119*t332*t50+2.9512199999
     3         99998d-1*t232*t331*t50+1.475609999999999d-1*t102*t106*t11
     4         9*t153*t166
            t334 = -2.0d+0*t333*t59-4.0d+0*t153*t167
            t335 = 1/t27**4
            t336 = 1.5557798788747831d-3*t207*t294*t335*t39*t40
            t337 = -2.1224291089843306d-2*t1*t137*t284*t294*t3
            t338 = 6.064083168526658d-3*t1*t137*t171*t3*t300
            t339 = 5.0733617849732d-3*t1*t171*t294*t3*t35*t38
            t340 = -3.3822411899821336d-3*t1*t300*t35-6.764482379964267d
     1         -3*t1*t153*t155
            t341 = 6.764482379964267d-3*t1*t139*t153*t174*t3*t35
            t342 = -2.4682961769030842d-2*t300*t39*t40*t77+4.93659235380
     1         61685d-2*t203*t294*t39*t40-1.4431302433467247d-1*t1*t139*
     2         t3*t300+2.164695365020087d-1*t1*t171*t294*t3
            t343 = -8.888888888888888d-1*t342*t72
            t344 = -1.7777777777777776d+0*t177*t180
            t345 = t178**2
            t346 = -gammabb*t16*t17*t298*t89-2*t151*t16*t17*t89-2*gammab
     1         b*t151*t152*t16*t89+gammabb*t16*t25*t299+2*gammabb*t16*t1
     2         7*t187*t296+2*t152*t16*t25
            t347 = 6.41391219265211d-2*t132*t346-3.206956096326055d-2*t2
     1         49*t345-5.0d-1*t131*t300+2.5d-1*t251*t294
            t348 = -8.400000000000001d+0*t130*t300*t71-2.1d+1*t248*t294*
     1         t71-2.4d+0*t347*t68-2.7259596d+0*t300*t67+4.7459599999999
     2         996d-2*t302*t66+5.672746666666666d-2*t300*t66-5.4519192d+
     3         0*t294*t66+4.7459599999999996d-2*t300*t35-4.9628707825354
     4         457d+0*t130*t300-1.2407176956338616d+1*t248*t294+5.672746
     5         666666666d-2*t294-1.68d+1*t130*t153*t179+9.49191999999999
     6         9d-2*t153*t155
            t349 = -8.888888888888888d-1*t348*t75
            t350 = t300*t31-1.282782438530422d-1*t1*t3*t30*t300-6.413912
     1         19265211d-2*t1*t139*t294*t3
            t351 = -1.0546577777777776d-1*t35*t350*t36
            t352 = -2.109315555555555d-1*t155*t174*t36+t351+t349+t344+t3
     1         43+t341
            t353 = 2.6666666666666666d+0*t350*t72*t75+2.6666666666666666
     1         d+0*t174*t180*t75+2.6666666666666666d+0*t174*t177*t72-3.0
     2         d+0*t174*t181
            t354 = t138-1.282782438530422d-1*t1*t101*t139*t3
            t355 = t27*t354+t101*t31
            t356 = 1/rhob**5.666666666666667d+0
            t357 = -7.508496024554567d-1*gammabb*t17*t25*t356
            t358 = -4.8268903014993647d-1*gammabb*t17*t182*t88*t89
            t359 = 4.8268903014993647d-1*gammabb*t182*t25*t91
            t360 = -2.63284925536329d-1*gammabb*t17*t186*t187*t78
            t361 = 1.316424627681645d-1*gammabb*t17*t197*t78*t89
            t362 = 2.63284925536329d-1*gammabb*t78*t88*t89*t91
            t363 = -1.316424627681645d-1*gammabb*t200*t25*t78
            t364 = t88**3
            t365 = 1/t24**4
            t366 = -9.873184707612337d-2*gammabb*t16*t17*t364*t365
            t367 = 9.873184707612337d-2*gammabb*t16*t186*t187*t91
            t368 = 9.873184707612337d-2*gammabb*t16*t17*t187*t197*t88
            t369 = -4.9365923538061685d-2*gammabb*t16*t197*t89*t91
            t370 = 1/rhob**1.3666666666666666d+1
            t371 = 1/rhob**1.2333333333333334d+1
            t372 = 1/rhob**11
            t373 = 1/rhob**9.666666666666666d+0
            t374 = 1/rhob**8.333333333333334d+0
            t375 = 1/rhob**7
            t376 = 1.958171952691946d-3*t372*t8-1.9214483293868775d-4*t3
     1         71*t6-7.094704787173696d+0*t5/rhob**4.333333333333333d+0-
     2         2.811358882523947d+0*t14*t375+3.4274921739849046d-1*t12*t
     3         374-2.6382474466894645d-2*t10*t373+8.905555919908195d-6*t
     4         20*t370+9.369101339439189d+0*gammabb*t356-6.8780767713482
     5         86d-7*t18/rhob**15
            t377 = -1.6455307846020562d-2*gammabb*t16*t17*t376*t89
            t378 = -4.9365923538061685d-2*gammabb*t16*t200*t88*t89
            t379 = 3.115927725822337d-4*t372*t8-2.636823993592544d-5*t37
     1         1*t6-2.1606615760248984d-2*t14*t375+1.0756283400962623d-2
     2         *t12*t374-2.3486322899894632d-3*t10*t373-1.20091636266328
     3         24d-2*gammabb*t356
            t380 = 1.6455307846020562d-2*gammabb*t16*t25*t379
            t381 = -1.950258707676511d-1*t39*t78+t380+t378+t377+t369+t36
     1         8+t367+t366+t363+t362+t361+t360+t359+t358+t357
            t382 = t93**3
            t383 = 1/t33**4
            t384 = 4.270067917509071d-3*t12*t374*t94+1.1095117764849638d
     1         +0*gammabb*t78*t88*t89*t91-2.0803345809093077d-1*gammabb*
     2         t16*t197*t89*t91+2.034104923555767d+0*gammabb*t182*t25*t9
     3         1+4.1606691618186153d-1*gammabb*t16*t186*t187*t91-2.08033
     4         45809093077d-1*gammabb*t16*t200*t88*t89-2.034104923555767
     5         d+0*gammabb*t17*t182*t88*t89+5.547558882424819d-1*gammabb
     6         *t17*t197*t78*t89-6.934448603031025d-2*gammabb*t16*t17*t3
     7         76*t89+4.1606691618186153d-1*gammabb*t16*t17*t187*t197*t8
     8         8-2.349044621726439d-5*t205*t372*t8-5.547558882424819d-1*
     9         gammabb*t200*t25*t78-1.1095117764849638d+0*gammabb*t17*t1
     :         86*t187*t78+4.0688686731102613d-8*t20*t370*t383+6.9344486
     ;         03031025d-2*gammabb*t16*t25*t379-4.1606691618186153d-1*ga
     <         mmabb*t16*t17*t364*t365-2.3438246032741353d-1*gammabb*t34
     =         *t356-3.1641632144200826d+0*gammabb*t17*t25*t356
            t385 = 1/t31**4
            t386 = t147**3
            t387 = 1/t37**6.0d+0
            t388 = 1/t51**3
            t389 = t105**3
            t390 = 1/t49**4
            t391 = t101**3
            t392 = 1/t45**5
            t393 = 3.75d-1*t391*t392
            t394 = -7.5d-1*t101*t202*t216
            t395 = 5.0d-1*t102*t381
            t396 = -2.660585798433468d-1*t1*t196
            t397 = t396+t395+t394+t393
            t398 = 1/t46**4
            t399 = 1/t43**5
            t400 = 3.75d-1*t391*t399
            t401 = -7.5d-1*t101*t202*t223
            t402 = 5.0d-1*t107*t381
            t403 = t380+t378+t377+t369+t368+t367+t366+t363+t362+t361+t36
     1         0+t359+t358+t357
            t404 = 1/t57**3
            t405 = 1/t55**4
            t406 = 1/t54**5
            t407 = 3.75d-1*t391*t406
            t408 = -7.5d-1*t101*t202*t233
            t409 = 5.0d-1*t116*t381
            t410 = 1/t62**4
            t411 = t125**3
            t412 = 1/t60**4
            t413 = t409+t408+t407+t402+t401+t400
            t414 = 1/t64**4
            t415 = t114**3
            t416 = t66**5.0d-1
            t417 = 1/t69**5
            t418 = 1/t70**5
            t419 = -1.7103765847072294d-1*t1*t139*t87*t93+5.772520973386
     1         899d-1*t1*t171*t202*t3*t93-4.810434144489083d-1*t1*t284*t
     2         3*t382-1.282782438530422d-1*t1*t139*t3*t381-2.66058579843
     3         3468d-1*t1*t196*t30-1.924173657795633d-1*t1*t171*t204*t23
     4         +1.282782438530422d-1*t1*t139*t202*t23
            t420 = 3*t256*t93+t27*t419+t31*t381+3*t140*t202
            t421 = -2.812280816813114d-6*t190*t8+2.2108103907905202d-7*t
     1         189*t6+7.028397206309868d-1*t195*t5+1.0642057180760542d+0
     2         *t150*t196-9.347705929049741d-2*gammabb*t194+7.6103291731
     3         42687d-3*t14*t193-5.874515858075838d-4*t12*t192+5.9338845
     4         46635945d-5*t10*t191-2.0076645727369685d+0*t182
            t422 = 5.401653940062247d-3*t195*t5-2.93353183662617d-3*gamm
     1         abb*t194+6.774900836508068d-4*t14*t193-9.347783177467011d
     2         -5*t12*t192+8.143132921388737d-6*t10*t191+2.5733922057070
     3         335d-3*t182
            t423 = -3.2910615692041123d-2*t16*t88*t89*t91+8.776164184544
     1         3d-2*gammabb*t151*t78*t89*t91-3.2910615692041123d-2*gamma
     2         bb*t16*t266*t89*t91+6.582123138408225d-2*gammabb*t151*t16
     3         *t187*t88*t91-8.7761641845443d-2*t25*t78*t91+8.7761641845
     4         443d-2*t17*t78*t88*t89+8.7761641845443d-2*gammabb*t152*t7
     5         8*t88*t89-3.2910615692041123d-2*gammabb*t16*t267*t88*t89+
     6         8.7761641845443d-2*gammabb*t17*t266*t78*t89-1.64553078460
     7         20562d-2*gammabb*t16*t17*t421*t89-1.6455307846020562d-2*g
     8         ammabb*t151*t16*t200*t89-1.6455307846020562d-2*t16*t17*t1
     9         97*t89-1.6455307846020562d-2*gammabb*t152*t16*t197*t89-1.
     :         6089634338331216d-1*gammabb*t151*t17*t182*t89-1.755232836
     ;         90886d-1*gammabb*t151*t17*t187*t78*t88+6.582123138408225d
     <         -2*gammabb*t16*t17*t187*t266*t88-8.7761641845443d-2*gamma
     =         bb*t25*t267*t78+1.6455307846020562d-2*gammabb*t16*t25*t42
     >         2-9.873184707612337d-2*gammabb*t151*t16*t17*t186*t365+1.6
     ?         455307846020562d-2*t16*t200*t25+1.6089634338331216d-1*t17
     @         *t182*t25+1.6089634338331216d-1*gammabb*t152*t182*t25+3.2
     1         910615692041123d-2*gammabb*t151*t16*t17*t187*t197+3.29106
     2         15692041123d-2*t16*t17*t186*t187+3.2910615692041123d-2*ga
     3         mmabb*t152*t16*t186*t187
            t424 = -1.220913847381626d-3*gammabb*t194*t94-1.386889720606
     1         205d-1*t16*t88*t89*t91+3.698372588283213d-1*gammabb*t151*
     2         t78*t89*t91-1.386889720606205d-1*gammabb*t16*t266*t89*t91
     3         +2.77377944121241d-1*gammabb*t151*t16*t187*t88*t91-3.6983
     4         72588283213d-1*t25*t78*t91+3.698372588283213d-1*t17*t78*t
     5         88*t89+3.698372588283213d-1*gammabb*t152*t78*t88*t89-1.38
     6         6889720606205d-1*gammabb*t16*t267*t88*t89+3.6983725882832
     7         13d-1*gammabb*t17*t266*t78*t89-6.934448603031025d-2*gamma
     8         bb*t16*t17*t421*t89-6.934448603031025d-2*gammabb*t151*t16
     9         *t200*t89-6.934448603031025d-2*t16*t17*t197*t89-6.9344486
     :         03031025d-2*gammabb*t152*t16*t197*t89-6.780349745185891d-
     ;         1*gammabb*t151*t17*t182*t89-7.396745176566426d-1*gammabb*
     <         t151*t17*t187*t78*t88+2.77377944121241d-1*gammabb*t16*t17
     =         *t187*t266*t88-1.525825752416348d-8*t190*t383*t8-3.698372
     >         588283213d-1*gammabb*t25*t267*t78+6.934448603031025d-2*ga
     ?         mmabb*t16*t25*t422-4.1606691618186153d-1*gammabb*t151*t16
     @         *t17*t186*t365+5.02248129273029d-2*t182*t34+6.93444860303
     1         1025d-2*t16*t200*t25+6.780349745185891d-1*t17*t182*t25+6.
     2         780349745185891d-1*gammabb*t152*t182*t25+7.88166287552949
     3         9d-6*t12*t192*t205+1.386889720606205d-1*gammabb*t151*t16*
     4         t17*t187*t197+1.386889720606205d-1*t16*t17*t186*t187+1.38
     5         6889720606205d-1*gammabb*t152*t16*t186*t187
            t425 = 3.75d-1*t153*t215*t392
            t426 = -2.5d-1*t153*t202*t216
            t427 = -5.0d-1*t101*t216*t268
            t428 = 5.0d-1*t102*t423
            t429 = t428+t427+t426+t425
            t430 = 3.75d-1*t153*t215*t399
            t431 = -2.5d-1*t153*t202*t223
            t432 = -5.0d-1*t101*t223*t268
            t433 = 5.0d-1*t107*t423
            t434 = 3.75d-1*t153*t215*t406
            t435 = -2.5d-1*t153*t202*t233
            t436 = -5.0d-1*t101*t233*t268
            t437 = 5.0d-1*t116*t423
            t438 = t437+t436+t435+t434+t433+t432+t431+t430
            t439 = 1/t29**9
            t440 = 3.848347315591266d-1*t1*t171*t268*t3*t93-1.2827824385
     1         30422d-1*t1*t153*t171*t23*t93-5.701255282357431d-2*t1*t13
     2         9*t153*t87-1.282782438530422d-1*t1*t139*t3*t423-4.8104341
     3         44489083d-1*t1*t153*t204*t284*t3+1.924173657795633d-1*t1*
     4         t153*t171*t202*t3+8.551882923536147d-2*t1*t139*t23*t268
            t441 = 2*t289*t93+t27*t440+t31*t423-1.282782438530422d-1*t1*
     1         t139*t153*t202*t3+2*t140*t268+t153*t256
            t442 = 2.2804408244486873d-1*t297*t87-7.028397206309868d-2*t
     1         150*t86+1.4759535677446958d-2*t85-1.488977446919221d-3*t5
     2         *t84+1.3054479684612974d-4*gammabb*t83-1.4356172290248254
     3         d-5*t14*t82+7.231579243233723d-7*t12*t81-5.95218182135909
     4         4d-8*t10*t80
            t443 = -5.401653940062245d-4*t150*t86+4.631892373620269d-4*t
     1         85-1.3255240767081d-4*t5*t84+2.0772851505482245d-5*gammab
     2         b*t83-1.9701128035617912d-6*t14*t82
            t444 = -1.6455307846020562d-2*gammabb*t16*t298*t89*t91-3.291
     1         0615692041123d-2*t151*t16*t89*t91+3.2910615692041123d-2*g
     2         ammabb*t16*t187*t296*t91-1.6455307846020562d-2*gammabb*t1
     3         6*t299*t88*t89-3.2910615692041123d-2*t152*t16*t88*t89+4.3
     4         8808209227215d-2*gammabb*t17*t298*t78*t89+8.7761641845443
     5         d-2*t151*t17*t78*t89+8.7761641845443d-2*gammabb*t151*t152
     6         *t78*t89-1.6455307846020562d-2*gammabb*t16*t17*t442*t89-3
     7         .2910615692041123d-2*gammabb*t151*t16*t267*t89-3.29106156
     8         92041123d-2*t16*t17*t266*t89-3.2910615692041123d-2*gammab
     9         b*t152*t16*t266*t89-9.873184707612337d-2*gammabb*t16*t17*
     :         t296*t365*t88+3.2910615692041123d-2*gammabb*t16*t17*t187*
     ;         t298*t88+6.582123138408225d-2*t151*t16*t17*t187*t88+6.582
     <         123138408225d-2*gammabb*t151*t152*t16*t187*t88-4.38808209
     =         227215d-2*gammabb*t25*t299*t78-8.7761641845443d-2*gammabb
     >         *t17*t187*t296*t78-8.7761641845443d-2*t152*t25*t78+1.6455
     ?         307846020562d-2*gammabb*t16*t25*t443+3.2910615692041123d-
     @         2*t16*t25*t267+6.582123138408225d-2*gammabb*t151*t16*t17*
     1         t187*t266
            t445 = 2.2539947951660788d-4*t85*t94-6.934448603031025d-2*ga
     1         mmabb*t16*t298*t89*t91-1.386889720606205d-1*t151*t16*t89*
     2         t91+1.386889720606205d-1*gammabb*t16*t187*t296*t91-6.9344
     3         48603031025d-2*gammabb*t16*t299*t88*t89-1.386889720606205
     4         d-1*t152*t16*t88*t89+1.8491862941416065d-1*gammabb*t17*t2
     5         98*t78*t89+3.698372588283213d-1*t151*t17*t78*t89+3.698372
     6         588283213d-1*gammabb*t151*t152*t78*t89-6.934448603031025d
     7         -2*gammabb*t16*t17*t442*t89-1.386889720606205d-1*gammabb*
     8         t151*t16*t267*t89-1.386889720606205d-1*t16*t17*t266*t89-1
     9         .386889720606205d-1*gammabb*t152*t16*t266*t89-4.160669161
     :         8186153d-1*gammabb*t16*t17*t296*t365*t88+1.38688972060620
     ;         5d-1*gammabb*t16*t17*t187*t298*t88+2.77377944121241d-1*t1
     <         51*t16*t17*t187*t88+2.77377944121241d-1*gammabb*t151*t152
     =         *t16*t187*t88-2.318136139861618d-6*gammabb*t205*t83+5.721
     >         846571561304d-9*t12*t383*t81-1.8491862941416065d-1*gammab
     ?         b*t25*t299*t78-3.698372588283213d-1*gammabb*t17*t187*t296
     @         *t78-3.698372588283213d-1*t152*t25*t78+6.934448603031025d
     1         -2*gammabb*t16*t25*t443+1.386889720606205d-1*t16*t25*t267
     2         +2.77377944121241d-1*gammabb*t151*t16*t17*t187*t266
            t446 = 3.75d-1*t101*t294*t392
            t447 = -5.0d-1*t153*t216*t268
            t448 = -2.5d-1*t101*t216*t300
            t449 = 5.0d-1*t102*t444
            t450 = t449+t448+t447+t446
            t451 = 3.75d-1*t101*t294*t399
            t452 = -5.0d-1*t153*t223*t268
            t453 = -2.5d-1*t101*t223*t300
            t454 = 5.0d-1*t107*t444
            t455 = 3.75d-1*t101*t294*t406
            t456 = -5.0d-1*t153*t233*t268
            t457 = -2.5d-1*t101*t233*t300
            t458 = 5.0d-1*t116*t444
            t459 = t458+t457+t456+t455+t454+t453+t452+t451
            t460 = 1/t27**5
            t461 = 1.924173657795633d-1*t1*t171*t3*t300*t93-4.8104341444
     1         89083d-1*t1*t284*t294*t3*t93-1.282782438530422d-1*t1*t139
     2         *t3*t444+4.2759414617680735d-2*t1*t139*t23*t300+3.8483473
     3         15591266d-1*t1*t153*t171*t268*t3-6.41391219265211d-2*t1*t
     4         171*t23*t294
            t462 = -1.282782438530422d-1*t1*t139*t3*t300*t93+1.924173657
     1         795633d-1*t1*t171*t294*t3*t93+t27*t461+t31*t444+t140*t300
     2         -2.565564877060844d-1*t1*t139*t153*t268*t3+2*t153*t289
            t463 = t153**3
            t464 = t151**3
            t465 = -1.6318099605766218d-5*t9+2.3072419752184684d-6*t5*t7
     1         -8.785496507887335d-3*t15*t297+2.5654959275047734d-1*t23/
     2         t10-1.3559211081063233d-7*gammabb*t21+1.2400378794498113d
     3         -8*t14*t19+1.1167330851894158d-4*t11*t150
            t466 = -2.5966064381852805d-6*t9+3.1662527200100216d-7*t5*t7
     1         -6.752067425077807d-5*t15*t297+9.941430575310749d-6*t11*t
     2         150
            t467 = -1.6455307846020562d-2*gammabb*t16*t17*t465*t89-4.936
     1         5923538061685d-2*gammabb*t151*t16*t299*t89-4.936592353806
     2         1685d-2*t16*t17*t298*t89-4.9365923538061685d-2*gammabb*t1
     3         52*t16*t298*t89-9.873184707612337d-2*t151*t152*t16*t89+1.
     4         6455307846020562d-2*gammabb*t16*t25*t466-9.87318470761233
     5         7d-2*gammabb*t16*t17*t365*t464+4.9365923538061685d-2*t16*
     6         t25*t299+9.873184707612337d-2*gammabb*t151*t16*t17*t187*t
     7         298+9.873184707612337d-2*t16*t17*t187*t296+9.873184707612
     8         337d-2*gammabb*t152*t16*t187*t296
            t468 = 5.21580631468864d-7*t205*t9-6.934448603031025d-2*gamm
     1         abb*t16*t17*t465*t89-2.0803345809093077d-1*gammabb*t151*t
     2         16*t299*t89-2.0803345809093077d-1*t16*t17*t298*t89-2.0803
     3         345809093077d-1*gammabb*t152*t16*t298*t89-4.1606691618186
     4         153d-1*t151*t152*t16*t89+6.934448603031025d-2*gammabb*t16
     5         *t25*t466-4.1606691618186153d-1*gammabb*t16*t17*t365*t464
     6         -2.1456924643354894d-9*gammabb*t21*t383+2.080334580909307
     7         7d-1*t16*t25*t299+4.1606691618186153d-1*gammabb*t151*t16*
     8         t17*t187*t298+4.1606691618186153d-1*t16*t17*t187*t296+4.1
     9         606691618186153d-1*gammabb*t152*t16*t187*t296
            t469 = 1/t44**2
            t470 = 3.75d-1*t399*t463
            t471 = -7.5d-1*t153*t223*t300
            t472 = 5.0d-1*t107*t467
            t473 = 3.75d-1*t392*t463
            t474 = -7.5d-1*t153*t216*t300
            t475 = 5.0d-1*t102*t467
            t476 = t169**3
            t477 = 3.75d-1*t406*t463
            t478 = -7.5d-1*t153*t233*t300
            t479 = 5.0d-1*t116*t467
            t480 = t479+t478+t477+t472+t471+t470
            t481 = t31*t467-1.282782438530422d-1*t1*t3*t30*t467+9.620868
     1         288978166d-2*t1*t171*t3*t463-1.924173657795633d-1*t1*t139
     2         *t153*t3*t300
            fnc(iq) = fnc(iq)-9.305257363491d-1*t22*t76*wght
            Amat(iq,D1_RB) = -1.2407009817987999d+0*t2*t76*wght-9.305257
     1         363491d-1*t149*t22*wght+Amat(iq,D1_RB)
            Cmat(iq,D1_GBB) = Cmat(iq,D1_GBB)-9.305257363491d-1*t22*(t18
     1         1*t73+t16*t163*t25+t175+t173+t172+t170+t168+t164+t162+t15
     2         7+t156+t154)*wght
            Amat2(iq,D2_RB_RB) = -4.135669939329333d-1*t40*t76*wght-9.30
     1         5257363491d-1*t22*t260*wght-2.4814019635975998d+0*t149*t2
     2         *wght+Amat2(iq,D2_RB_RB)
            Cmat2(iq,D2_RB_GBB) = -1.2407009817987999d+0*t2*(-8.88888888
     1         8888888d-1*t264*t72*t73+t265+t263+t262+t261+t175+t173+t17
     2         2+t170+t168+t164+t162+t157+t156+t154)*wght-9.305257363491
     3         d-1*t22*t293*wght+Cmat2(iq,D2_RB_GBB)
            Cmat2(iq,D2_GBB_GBB) = Cmat2(iq,D2_GBB_GBB)-9.305257363491d-
     1         1*t22*(t16*t320*t89+t352*t73+6.764482379964267d-3*t1*t139
     2         *t153*t174*t3*t35*t73+t139*t3*t340*t38+t148*t353+t339+t33
     3         8+t337+t336+t121*t334+t330+t323+t321+t112*t16*t25*t319+t1
     4         6*t25*t310+t309+t307+t306+t305+t303+t301+t295)*wght
            Amat3(iq,D3_RB_RB_RB) = -1.2407009817987999d+0*t40*(t99+t98+
     1         t97+t96-4.727288888888889d-2*t101*t32*t77+2.6666666666666
     2         666d+0*t148*t355*t72*t75-8.888888888888888d-1*(4.93659235
     3         38061685d-2*t1*t3*(t144-5.0d-1*t1*t101*t139*t3)*t30-1.443
     4         1302433467247d-1*t1*t101*t139*t3+t143)*t72*t73-1.05465777
     5         77777776d-1*t35*t355*t36*t73+5.273288888888887d-2*(t141-6
     6         .41391219265211d-2*t1*t101*t139*t3)*t35*t38-4.72728888888
     7         8889d-2*t137*t28*t354+t136+t129+t122+t115+t113)*wght-9.30
     8         5257363491d-1*t22*(-8.888888888888888d-1*t73*t75*(1.42378
     9         8d-1*t228*t95-2.4d+0*t68*(6.41391219265211d-2*t132*(16*ga
     :         mmabb*t78*t88*t89*t91-3*gammabb*t16*t197*t89*t91+2.933333
     ;         3333333333d+1*gammabb*t182*t25*t91+6*gammabb*t16*t186*t18
     <         7*t91-3*gammabb*t16*t200*t88*t89-2.9333333333333333d+1*ga
     =         mmabb*t17*t182*t88*t89+8*gammabb*t17*t197*t78*t89-gammabb
     >         *t16*t17*t376*t89+6*gammabb*t16*t17*t187*t197*t88-8*gamma
     ?         bb*t200*t25*t78-16*gammabb*t17*t186*t187*t78+gammabb*t16*
     @         t25*t379-6*gammabb*t16*t17*t364*t365-4.5629629629629626d+
     1         1*gammabb*t17*t25*t356)-3.75d-1*t415*t418+4.8104341444890
     2         83d-2*t133**3*t417-5.0d-1*t131*t403-9.620868288978166d-2*
     3         t133*t249*t252+7.5d-1*t114*t228*t251)-3.15d+1*t415*t416*t
     4         71-8.400000000000001d+0*t130*t403*t71-6.3d+1*t114*t228*t2
     5         48*t71-2.7259596d+0*t403*t67+5.672746666666666d-2*t403*t6
     6         6+4.7459599999999996d-2*t384*t66-1.6355757600000004d+1*t1
     7         14*t228*t66-1.8610765434507923d+1*t415*t416-5.4519192d+0*
     8         t415+4.7459599999999996d-2*t35*t403-4.9628707825354457d+0
     9         *t130*t403-2.52d+1*t114*t130*t253-6.3d+1*t134*t247*t248-3
     :         .7221530869015845d+1*t114*t228*t248-2.52d+1*t130*t134*t22
     ;         8+1.7018239999999996d-1*t114*t228+1.423788d-1*t114*t206)-
     <         3.1639733333333325d-1*t259*t36*t73*t95-6.327946666666665d
     =         -1*t142*t147*t73*t95+1.5819866666666663d-1*t255*t38*t95+9
     >         .491919999999998d-1*t148*t209*t36*t95-8.888888888888888d-
     ?         1*t72*t73*(4.9365923538061685d-2*t1*t3*t30*(-6.6666666666
     @         66666d-1*t1*t139*t87*t93+2.25d+0*t1*t171*t202*t3*t93-1.87
     1         5d+0*t1*t284*t3*t382-5.0d-1*t1*t139*t3*t381-1.03703703703
     2         7037d+0*t1*t196*t30-7.5d-1*t1*t171*t204*t23+5.0d-1*t1*t13
     3         9*t202*t23)-1.9241736577956325d-1*t1*t139*t87*t93-2.46829
     4         61769030842d-2*t1*t139*t257*t3*t93+6.494086095060261d-1*t
     5         1*t171*t202*t3*t93-5.411738412550218d-1*t1*t284*t3*t382-1
     6         .4431302433467247d-1*t1*t139*t3*t381-1.6455307846020562d-
     7         2*t1*t23*t257*t30-2.993159023237651d-1*t1*t196*t30+9.8731
     8         84707612337d-2*t145*t257-2.164695365020087d-1*t1*t171*t20
     9         4*t23+1.4431302433467247d-1*t1*t139*t202*t23)+5.273288888
     :         888887d-2*t35*t38*(-8.551882923536147d-2*t1*t139*t87*t93+
     ;         2.8862604866934494d-1*t1*t171*t202*t3*t93-2.4052170722445
     <         415d-1*t1*t284*t3*t382-6.41391219265211d-2*t1*t139*t3*t38
     =         1-1.330292899216734d-1*t1*t196*t30-9.620868288978166d-2*t
     >         1*t171*t204*t23+6.41391219265211d-2*t1*t139*t202*t23)+1.4
     ?         181866666666668d-1*t137*t256*t77*t93-2.8363733333333335d-
     @         1*t207*t208*t77*t93+2.8363733333333335d-1*t202*t203*t32*t
     1         93+7.57211d-1*(2.63284925536329d-1*gammabb*t61*t65*t78*t8
     2         8*t89*t91+9.873184707612337d-2*gammabb*t125*t126*t16*t65*
     3         t88*t89*t91+9.873184707612337d-2*gammabb*t127*t128*t16*t6
     4         1*t88*t89*t91-4.9365923538061685d-2*gammabb*t16*t197*t61*
     5         t65*t89*t91+2.63284925536329d-1*gammabb*t125*t126*t25*t65
     6         *t78*t91+2.63284925536329d-1*gammabb*t127*t128*t25*t61*t7
     7         8*t91+4.8268903014993647d-1*gammabb*t182*t25*t61*t65*t91+
     8         9.873184707612337d-2*gammabb*t16*t186*t187*t61*t65*t91-4.
     9         9365923538061685d-2*gammabb*t126*t16*t243*t25*t65*t91+9.8
     :         73184707612337d-2*gammabb*t16*t241*t242*t25*t65*t91-4.936
     ;         5923538061685d-2*gammabb*t128*t16*t246*t25*t61*t91+9.8731
     <         84707612337d-2*gammabb*t16*t244*t245*t25*t61*t91+9.873184
     =         707612337d-2*gammabb*t125*t126*t127*t128*t16*t25*t91-2.63
     >         284925536329d-1*gammabb*t125*t126*t17*t65*t78*t88*t89-2.6
     ?         3284925536329d-1*gammabb*t127*t128*t17*t61*t78*t88*t89-4.
     @         9365923538061685d-2*gammabb*t16*t200*t61*t65*t88*t89-4.82
     1         68903014993647d-1*gammabb*t17*t182*t61*t65*t88*t89+4.9365
     2         923538061685d-2*gammabb*t126*t16*t17*t243*t65*t88*t89-9.8
     3         73184707612337d-2*gammabb*t16*t17*t241*t242*t65*t88*t89+4
     4         .9365923538061685d-2*gammabb*t128*t16*t17*t246*t61*t88*t8
     5         9-9.873184707612337d-2*gammabb*t16*t17*t244*t245*t61*t88*
     6         t89-9.873184707612337d-2*gammabb*t125*t126*t127*t128*t16*
     7         t17*t88*t89+1.316424627681645d-1*gammabb*t17*t197*t61*t65
     8         *t78*t89-1.6455307846020562d-2*gammabb*t16*t17*t376*t61*t
     9         65*t89+4.9365923538061685d-2*gammabb*t125*t126*t16*t17*t1
     :         97*t65*t89+4.9365923538061685d-2*gammabb*t127*t128*t16*t1
     ;         7*t197*t61*t89+9.873184707612337d-2*gammabb*t16*t17*t187*
     <         t197*t61*t65*t88-1.316424627681645d-1*gammabb*t200*t25*t6
     =         1*t65*t78-2.63284925536329d-1*gammabb*t17*t186*t187*t61*t
     >         65*t78+1.316424627681645d-1*gammabb*t126*t17*t243*t25*t65
     ?         *t78-2.63284925536329d-1*gammabb*t17*t241*t242*t25*t65*t7
     @         8+1.316424627681645d-1*gammabb*t128*t17*t246*t25*t61*t78-
     1         2.63284925536329d-1*gammabb*t17*t244*t245*t25*t61*t78-2.6
     2         3284925536329d-1*gammabb*t125*t126*t127*t128*t17*t25*t78+
     3         1.6455307846020562d-2*gammabb*t16*t25*t379*t61*t65-9.8731
     4         84707612337d-2*gammabb*t16*t17*t364*t365*t61*t65-7.508496
     5         024554567d-1*gammabb*t17*t25*t356*t61*t65-1.6455307846020
     6         562d-2*gammabb*t126*t16*t17*t25*t413*t65-9.87318470761233
     7         7d-2*gammabb*t16*t17*t25*t411*t412*t65+9.873184707612337d
     8         -2*gammabb*t125*t16*t17*t242*t243*t25*t65-4.9365923538061
     9         685d-2*gammabb*t125*t126*t16*t200*t25*t65-4.8268903014993
     :         647d-1*gammabb*t125*t126*t17*t182*t25*t65-9.8731847076123
     ;         37d-2*gammabb*t125*t126*t16*t17*t186*t187*t65+t403*t61*t6
     <         3-t126*t413*t59*t63-6*t411*t412*t59*t63+6*t125*t242*t243*
     =         t59*t63-3*t114*t126*t243*t63+6*t114*t241*t242*t63-3*t125*
     >         t126*t228*t63-6*t123**3*t410*t59*t61-t124*(t409+t408+t407
     ?         +t396)*t59*t61+6*t123*t239*t240*t59*t61-9.873184707612337
     @         d-2*gammabb*t127**3*t16*t17*t25*t414*t61-1.64553078460205
     1         62d-2*gammabb*t128*t16*t17*t25*(t402+t401+t400+t396)*t61+
     2         9.873184707612337d-2*gammabb*t127*t16*t17*t245*t246*t25*t
     3         61-4.9365923538061685d-2*gammabb*t127*t128*t16*t200*t25*t
     4         61-4.8268903014993647d-1*gammabb*t127*t128*t17*t182*t25*t
     5         61-3*t114*t124*t240*t61+6*t114*t238*t239*t61-3*t123*t124*
     6         t228*t61-9.873184707612337d-2*gammabb*t127*t128*t16*t17*t
     7         186*t187*t61+3*t123*t124*t126*t243*t59-6*t123*t124*t241*t
     8         242*t59+3*t124*t125*t126*t240*t59-6*t125*t126*t238*t239*t
     9         59+4.9365923538061685d-2*gammabb*t125*t126*t128*t16*t17*t
     :         246*t25-9.873184707612337d-2*gammabb*t125*t126*t16*t17*t2
     ;         44*t245*t25+4.9365923538061685d-2*gammabb*t126*t127*t128*
     <         t16*t17*t243*t25-9.873184707612337d-2*gammabb*t127*t128*t
     =         16*t17*t241*t242*t25+6*t114*t123*t124*t125*t126)+5.265698
     >         51072658d-1*gammabb*t52*t78*t88*t89*t91-1.974636941522467
     ?         4d-1*gammabb*t111*t112*t16*t88*t89*t91-9.873184707612337d
     @         -2*gammabb*t16*t197*t52*t89*t91-5.26569851072658d-1*gamma
     1         bb*t111*t112*t25*t78*t91+9.653780602998729d-1*gammabb*t18
     2         2*t25*t52*t91+1.9746369415224674d-1*gammabb*t16*t186*t187
     3         *t52*t91+9.873184707612337d-2*gammabb*t112*t16*t227*t25*t
     4         91-9.873184707612337d-2*gammabb*t16*t211*t212*t25*t91+5.2
     5         6569851072658d-1*gammabb*t111*t112*t17*t78*t88*t89-9.8731
     6         84707612337d-2*gammabb*t16*t200*t52*t88*t89-9.65378060299
     7         8729d-1*gammabb*t17*t182*t52*t88*t89-9.873184707612337d-2
     8         *gammabb*t112*t16*t17*t227*t88*t89+9.873184707612337d-2*g
     9         ammabb*t16*t17*t211*t212*t88*t89+2.63284925536329d-1*gamm
     :         abb*t17*t197*t52*t78*t89-3.2910615692041123d-2*gammabb*t1
     ;         6*t17*t376*t52*t89-9.873184707612337d-2*gammabb*t111*t112
     <         *t16*t17*t197*t89+1.9746369415224674d-1*gammabb*t16*t17*t
     =         187*t197*t52*t88-2.63284925536329d-1*gammabb*t200*t25*t52
     >         *t78-5.26569851072658d-1*gammabb*t17*t186*t187*t52*t78-2.
     ?         63284925536329d-1*gammabb*t112*t17*t227*t25*t78+2.6328492
     @         5536329d-1*gammabb*t17*t211*t212*t25*t78-4.72728888888888
     1         9d-2*t32*t381*t77+1.4181866666666668d-1*t137*t140*t202*t7
     2         7+2.6666666666666666d+0*t148*t420*t72*t75+5.3333333333333
     3         33d+1*t386*t387*t72*t75-3.2d+1*t147*t210*t259*t72*t75+8.0
     4         d+0*t135*t148*t259*t75+8.0d+0*t147*t148*t254*t75-3.2d+1*t
     5         135*t209*t210*t75-1.0546577777777776d-1*t35*t36*t420*t73-
     6         3.1639733333333325d-1*t147*t206*t36*t73-3.163973333333332
     7         5d-1*t142*t259*t35*t73-3.1639733333333325d-1*t147*t255*t3
     8         5*t73-2.6666666666666666d+0*t135*t258*t73-2.6666666666666
     9         666d+0*t146*t254*t73+8.0d+0*t146*t148*t259*t72+8.0d+0*t14
     :         7*t148*t258*t72-3.2d+1*t146*t209*t210*t72-2.0d+0*t121*(-1
     ;         .475609999999999d-1*t106*t397*t56-8.853659999999993d-1*t3
     <         89*t390*t56+8.853659999999993d-1*t105*t214*t220*t56-1.475
     =         609999999999d-1*t119*(t409+t408+t407+t395+t394+t393)*t50-
     >         8.853659999999993d-1*t118**3*t405*t50+8.853659999999993d-
     ?         1*t118*t232*t236*t50+4.4268299999999966d-1*t105*t106*t119
     @         *t236-8.853659999999993d-1*t105*t106*t231*t232+4.42682999
     1         99999966d-1*t106*t118*t119*t220-8.853659999999993d-1*t118
     2         *t119*t213*t214)*t59-4.0d+0*t120**3*t404*t59+6.0d+0*t120*
     3         t230*t237*t59-2.0d+0*t403*t58+3.2910615692041123d-2*gamma
     4         bb*t16*t25*t379*t52-1.9746369415224674d-1*gammabb*t16*t17
     5         *t364*t365*t52-1.5016992049109135d+0*gammabb*t17*t25*t356
     6         *t52+3.2910615692041123d-2*gammabb*t112*t16*t17*t25*(6.09
     7         65d-1*t110*(t402+t401+t400+t395+t394+t393)*t50+3.6579d+0*
     8         t109**3*t398*t50-3.6579d+0*t109*t222*t226*t50+6.0965d-1*t
     9         106*t397*t47+3.6579d+0*t389*t390*t47-3.6579d+0*t105*t214*
     :         t220*t47-1.82895d+0*t105*t106*t110*t226+3.6579d+0*t105*t1
     ;         06*t221*t222-1.82895d+0*t106*t109*t110*t220+3.6579d+0*t10
     <         9*t110*t213*t214)-4.727288888888889d-2*t137*t28*t419+6.58
     =         2123138408225d-2*gammabb*t111**3*t16*t17*t25*t388-1.26558
     >         9333333333d+0*t210*t35*t36*t386-2.8363733333333335d-1*t14
     ?         0**3*t28*t385+5.273288888888887d-2*t36*t38*t384-2.8363733
     @         333333335d-1*t32*t335*t382+1.5819866666666663d-1*t142*t20
     1         6*t38+9.491919999999998d-1*t147*t148*t259*t35*t36+9.49191
     2         9999999998d-1*t142*t148*t209*t35+2.8363733333333335d-1*t1
     3         40*t207*t256*t28-9.873184707612337d-2*gammabb*t111*t16*t1
     4         7*t212*t227*t25+9.873184707612337d-2*gammabb*t111*t112*t1
     5         6*t200*t25+9.653780602998729d-1*gammabb*t111*t112*t17*t18
     6         2*t25-6.0d+0*t114*t121*t237+6.0d+0*t114*t229*t230-6.0d+0*
     7         t120*t121*t228-2.8363733333333335d-1*t137*t140*t203*t204+
     8         1.9746369415224674d-1*gammabb*t111*t112*t16*t17*t186*t187
     9         +1.6d+1*t135*t146*t147*t148)*wght+2.757113292886222d-1*t1
     :         00*t76*wght-3.7221029453964d+0*t2*t260*wght+Amat3(iq,D3_R
     ;         B_RB_RB)
            Cmat3(iq,D3_RB_RB_GBB) = -9.305257363491d-1*t22*(-8.88888888
     1         8888888d-1*t73*t75*(9.491919999999999d-2*t268*t95-2.4d+0*
     2         t68*(6.41391219265211d-2*t132*(-2*t16*t88*t89*t91+5.33333
     3         3333333333d+0*gammabb*t151*t78*t89*t91-2*gammabb*t16*t266
     4         *t89*t91+4*gammabb*t151*t16*t187*t88*t91-5.33333333333333
     5         3d+0*t25*t78*t91+5.333333333333333d+0*t17*t78*t88*t89+5.3
     6         33333333333333d+0*gammabb*t152*t78*t88*t89-2*gammabb*t16*
     7         t267*t88*t89+5.333333333333333d+0*gammabb*t17*t266*t78*t8
     8         9-gammabb*t16*t17*t421*t89-gammabb*t151*t16*t200*t89-t16*
     9         t17*t197*t89-gammabb*t152*t16*t197*t89-9.777777777777779d
     :         +0*gammabb*t151*t17*t182*t89-1.0666666666666666d+1*gammab
     ;         b*t151*t17*t187*t78*t88+4*gammabb*t16*t17*t187*t266*t88-5
     <         .333333333333333d+0*gammabb*t25*t267*t78+gammabb*t16*t25*
     =         t422-6*gammabb*t151*t16*t17*t186*t365+t16*t200*t25+9.7777
     >         77777777779d+0*t17*t182*t25+9.777777777777779d+0*gammabb*
     ?         t152*t182*t25+2*gammabb*t151*t16*t17*t187*t197+2*t16*t17*
     @         t186*t187+2*gammabb*t152*t16*t186*t187)-5.0d-1*t131*t423-
     1         3.75d-1*t153*t247*t418+4.810434144489083d-2*t178*t250*t41
     2         7-6.41391219265211d-2*t133*t249*t285+5.0d-1*t114*t251*t26
     3         8-3.206956096326055d-2*t178*t249*t252+2.5d-1*t153*t228*t2
     4         51)-8.400000000000001d+0*t130*t423*t71-3.15d+1*t153*t247*
     5         t416*t71-4.2d+1*t114*t248*t268*t71-2.1d+1*t153*t228*t248*
     6         t71-2.7259596d+0*t423*t67+4.7459599999999996d-2*t424*t66+
     7         5.672746666666666d-2*t423*t66-1.0903838400000002d+1*t114*
     8         t268*t66-5.4519192d+0*t153*t228*t66+4.7459599999999996d-2
     9         *t35*t423-4.9628707825354457d+0*t130*t423-1.8610765434507
     :         923d+1*t153*t247*t416-1.68d+1*t114*t130*t286+9.4919199999
     ;         99999d-2*t114*t269-2.481435391267723d+1*t114*t248*t268-1.
     <         68d+1*t130*t134*t268+1.1345493333333331d-1*t114*t268-8.40
     =         0000000000001d+0*t130*t153*t253-2.1d+1*t179*t247*t248-1.2
     >         407176956338616d+1*t153*t228*t248-4.2d+1*t114*t134*t153*t
     ?         248-5.4519192d+0*t153*t247-8.400000000000001d+0*t130*t179
     @         *t228+4.7459599999999996d-2*t155*t228+5.672746666666666d-
     1         2*t153*t228+4.7459599999999996d-2*t153*t206)-2.1093155555
     2         55555d-1*t292*t36*t73*t95+1.3528964759928536d-2*t1*t139*t
     3         147*t153*t3*t73*t95-2.109315555555555d-1*t142*t174*t73*t9
     4         5+1.0546577777777776d-1*t288*t38*t95+6.327946666666665d-1
     5         *t147*t148*t174*t36*t95-8.888888888888888d-1*t72*t73*(4.9
     6         365923538061685d-2*t1*t3*t30*(1.5d+0*t1*t171*t268*t3*t93-
     7         5.0d-1*t1*t153*t171*t23*t93-2.222222222222222d-1*t1*t139*
     8         t153*t87-5.0d-1*t1*t139*t3*t423-1.875d+0*t1*t153*t204*t28
     9         4*t3+7.5d-1*t1*t153*t171*t202*t3+3.333333333333333d-1*t1*
     :         t139*t23*t268)+4.329390730040174d-1*t1*t171*t268*t3*t93-1
     ;         .4431302433467247d-1*t1*t153*t171*t23*t93-6.4139121926521
     <         09d-2*t1*t139*t153*t87-1.4431302433467247d-1*t1*t139*t3*t
     =         423-5.411738412550218d-1*t1*t153*t204*t284*t3-2.468296176
     >         9030842d-2*t1*t139*t153*t257*t3+2.164695365020087d-1*t1*t
     ?         153*t171*t202*t3+9.873184707612337d-2*t145*t290+9.6208682
     @         88978164d-2*t1*t139*t23*t268)+5.273288888888887d-2*t35*t3
     1         8*(1.924173657795633d-1*t1*t171*t268*t3*t93-6.41391219265
     2         211d-2*t1*t153*t171*t23*t93-2.8506276411787157d-2*t1*t139
     3         *t153*t87-6.41391219265211d-2*t1*t139*t3*t423-2.405217072
     4         2445415d-1*t1*t153*t204*t284*t3+9.620868288978166d-2*t1*t
     5         153*t171*t202*t3+4.2759414617680735d-2*t1*t139*t23*t268)+
     6         9.454577777777778d-2*t137*t289*t77*t93+1.8909155555555557
     7         d-1*t203*t268*t32*t93+2.4256332674106634d-2*t1*t140*t153*
     8         t207*t284*t3*t93-1.8909155555555557d-1*t137*t140*t153*t20
     9         3*t93+7.57211d-1*(-3.2910615692041123d-2*t16*t61*t65*t88*
     :         t89*t91+3.2910615692041123d-2*gammabb*t126*t16*t169*t65*t
     ;         88*t89*t91+1.6455307846020562d-2*gammabb*t107*t128*t153*t
     <         16*t61*t88*t89*t91+8.7761641845443d-2*gammabb*t151*t61*t6
     =         5*t78*t89*t91-3.2910615692041123d-2*gammabb*t16*t266*t61*
     >         t65*t89*t91+3.2910615692041123d-2*gammabb*t125*t126*t151*
     ?         t16*t65*t89*t91+3.2910615692041123d-2*gammabb*t127*t128*t
     @         151*t16*t61*t89*t91+6.582123138408225d-2*gammabb*t151*t16
     1         *t187*t61*t65*t88*t91-8.7761641845443d-2*t25*t61*t65*t78*
     2         t91+8.7761641845443d-2*gammabb*t126*t169*t25*t65*t78*t91+
     3         4.38808209227215d-2*gammabb*t107*t128*t153*t25*t61*t78*t9
     4         1-3.2910615692041123d-2*gammabb*t126*t16*t25*t282*t65*t91
     5         +6.582123138408225d-2*gammabb*t125*t16*t169*t242*t25*t65*
     6         t91-3.2910615692041123d-2*t125*t126*t16*t25*t65*t91-3.291
     7         0615692041123d-2*gammabb*t128*t16*t25*t283*t61*t91+3.2910
     8         615692041123d-2*gammabb*t107*t127*t153*t16*t245*t25*t61*t
     9         91-3.2910615692041123d-2*t127*t128*t16*t25*t61*t91+3.2910
     :         615692041123d-2*gammabb*t126*t127*t128*t16*t169*t25*t91+1
     ;         .6455307846020562d-2*gammabb*t107*t125*t126*t128*t153*t16
     <         *t25*t91+8.7761641845443d-2*t17*t61*t65*t78*t88*t89+8.776
     =         1641845443d-2*gammabb*t152*t61*t65*t78*t88*t89-8.77616418
     >         45443d-2*gammabb*t126*t169*t17*t65*t78*t88*t89-4.38808209
     ?         227215d-2*gammabb*t107*t128*t153*t17*t61*t78*t88*t89-3.29
     @         10615692041123d-2*gammabb*t16*t267*t61*t65*t88*t89+3.2910
     1         615692041123d-2*gammabb*t126*t16*t17*t282*t65*t88*t89-6.5
     2         82123138408225d-2*gammabb*t125*t16*t169*t17*t242*t65*t88*
     3         t89+3.2910615692041123d-2*t125*t126*t16*t17*t65*t88*t89+3
     4         .2910615692041123d-2*gammabb*t125*t126*t152*t16*t65*t88*t
     5         89+3.2910615692041123d-2*gammabb*t128*t16*t17*t283*t61*t8
     6         8*t89-3.2910615692041123d-2*gammabb*t107*t127*t153*t16*t1
     7         7*t245*t61*t88*t89+3.2910615692041123d-2*t127*t128*t16*t1
     8         7*t61*t88*t89+3.2910615692041123d-2*gammabb*t127*t128*t15
     9         2*t16*t61*t88*t89-3.2910615692041123d-2*gammabb*t126*t127
     :         *t128*t16*t169*t17*t88*t89-1.6455307846020562d-2*gammabb*
     ;         t107*t125*t126*t128*t153*t16*t17*t88*t89+8.7761641845443d
     <         -2*gammabb*t17*t266*t61*t65*t78*t89-8.7761641845443d-2*ga
     =         mmabb*t125*t126*t151*t17*t65*t78*t89-8.7761641845443d-2*g
     >         ammabb*t127*t128*t151*t17*t61*t78*t89-1.6455307846020562d
     ?         -2*gammabb*t16*t17*t421*t61*t65*t89-1.6455307846020562d-2
     @         *gammabb*t151*t16*t200*t61*t65*t89-1.6455307846020562d-2*
     1         t16*t17*t197*t61*t65*t89-1.6455307846020562d-2*gammabb*t1
     2         52*t16*t197*t61*t65*t89-1.6089634338331216d-1*gammabb*t15
     3         1*t17*t182*t61*t65*t89+3.2910615692041123d-2*gammabb*t125
     4         *t126*t16*t17*t266*t65*t89+1.6455307846020562d-2*gammabb*
     5         t126*t151*t16*t17*t243*t65*t89-3.2910615692041123d-2*gamm
     6         abb*t151*t16*t17*t241*t242*t65*t89+1.6455307846020562d-2*
     7         gammabb*t126*t16*t169*t17*t197*t65*t89+3.2910615692041123
     8         d-2*gammabb*t127*t128*t16*t17*t266*t61*t89+1.645530784602
     9         0562d-2*gammabb*t128*t151*t16*t17*t246*t61*t89-3.29106156
     :         92041123d-2*gammabb*t151*t16*t17*t244*t245*t61*t89+8.2276
     ;         53923010281d-3*gammabb*t107*t128*t153*t16*t17*t197*t61*t8
     <         9-3.2910615692041123d-2*gammabb*t125*t126*t127*t128*t151*
     =         t16*t17*t89-1.75523283690886d-1*gammabb*t151*t17*t187*t61
     >         *t65*t78*t88+6.582123138408225d-2*gammabb*t16*t17*t187*t2
     ?         66*t61*t65*t88-6.582123138408225d-2*gammabb*t125*t126*t15
     @         1*t16*t17*t187*t65*t88-6.582123138408225d-2*gammabb*t127*
     1         t128*t151*t16*t17*t187*t61*t88-8.7761641845443d-2*gammabb
     2         *t25*t267*t61*t65*t78+8.7761641845443d-2*gammabb*t126*t17
     3         *t25*t282*t65*t78-1.75523283690886d-1*gammabb*t125*t169*t
     4         17*t242*t25*t65*t78+8.7761641845443d-2*t125*t126*t17*t25*
     5         t65*t78+8.7761641845443d-2*gammabb*t125*t126*t152*t25*t65
     6         *t78+8.7761641845443d-2*gammabb*t128*t17*t25*t283*t61*t78
     7         -8.7761641845443d-2*gammabb*t107*t127*t153*t17*t245*t25*t
     8         61*t78+8.7761641845443d-2*t127*t128*t17*t25*t61*t78+8.776
     9         1641845443d-2*gammabb*t127*t128*t152*t25*t61*t78-8.776164
     :         1845443d-2*gammabb*t126*t127*t128*t169*t17*t25*t78-4.3880
     ;         8209227215d-2*gammabb*t107*t125*t126*t128*t153*t17*t25*t7
     <         8+1.6455307846020562d-2*gammabb*t16*t25*t422*t61*t65-9.87
     =         3184707612337d-2*gammabb*t151*t16*t17*t186*t365*t61*t65+1
     >         .6455307846020562d-2*t16*t200*t25*t61*t65+1.6089634338331
     ?         216d-1*t17*t182*t25*t61*t65+1.6089634338331216d-1*gammabb
     @         *t152*t182*t25*t61*t65+3.2910615692041123d-2*gammabb*t151
     1         *t16*t17*t187*t197*t61*t65+3.2910615692041123d-2*t16*t17*
     2         t186*t187*t61*t65+3.2910615692041123d-2*gammabb*t152*t16*
     3         t186*t187*t61*t65-1.6455307846020562d-2*gammabb*t126*t16*
     4         t17*t25*t438*t65-9.873184707612337d-2*gammabb*t16*t169*t1
     5         7*t241*t25*t412*t65+6.582123138408225d-2*gammabb*t125*t16
     6         *t17*t242*t25*t282*t65-3.2910615692041123d-2*gammabb*t125
     7         *t126*t16*t25*t267*t65+3.2910615692041123d-2*gammabb*t16*
     8         t169*t17*t242*t243*t25*t65-1.6455307846020562d-2*t126*t16
     9         *t17*t243*t25*t65-1.6455307846020562d-2*gammabb*t126*t152
     :         *t16*t243*t25*t65+3.2910615692041123d-2*t16*t17*t241*t242
     ;         *t25*t65+3.2910615692041123d-2*gammabb*t152*t16*t241*t242
     <         *t25*t65-1.6455307846020562d-2*gammabb*t126*t16*t169*t200
     =         *t25*t65-1.6089634338331216d-1*gammabb*t126*t169*t17*t182
     >         *t25*t65-3.2910615692041123d-2*gammabb*t126*t16*t169*t17*
     ?         t186*t187*t65+t423*t61*t63-t126*t438*t59*t63-6*t169*t241*
     @         t412*t59*t63+4*t125*t242*t282*t59*t63+2*t169*t242*t243*t5
     1         9*t63-2*t114*t126*t282*t63-2*t125*t126*t268*t63-t126*t153
     2         *t243*t63+2*t153*t241*t242*t63+4*t114*t125*t169*t242*t63-
     3         t126*t169*t228*t63-t124*(t437+t436+t435+t434)*t59*t61-3*t
     4         116*t153*t238*t410*t59*t61+4*t123*t239*t281*t59*t61+t116*
     5         t153*t239*t240*t59*t61-1.6455307846020562d-2*gammabb*t128
     6         *t16*t17*t25*(t433+t432+t431+t430)*t61-4.9365923538061685
     7         d-2*gammabb*t107*t153*t16*t17*t244*t25*t414*t61+6.5821231
     8         38408225d-2*gammabb*t127*t16*t17*t245*t25*t283*t61-2*t114
     9         *t124*t281*t61-2*t123*t124*t268*t61-3.2910615692041123d-2
     :         *gammabb*t127*t128*t16*t25*t267*t61+1.6455307846020562d-2
     ;         *gammabb*t107*t153*t16*t17*t245*t246*t25*t61-1.6455307846
     <         020562d-2*t128*t16*t17*t246*t25*t61-1.6455307846020562d-2
     =         *gammabb*t128*t152*t16*t246*t25*t61+3.2910615692041123d-2
     >         *t16*t17*t244*t245*t25*t61+3.2910615692041123d-2*gammabb*
     ?         t152*t16*t244*t245*t25*t61-8.227653923010281d-3*gammabb*t
     @         107*t128*t153*t16*t200*t25*t61-8.044817169165608d-2*gamma
     1         bb*t107*t128*t153*t17*t182*t25*t61-t124*t153*t240*t61+2*t
     2         153*t238*t239*t61+2*t114*t116*t123*t153*t239*t61-5.0d-1*t
     3         116*t124*t153*t228*t61-1.6455307846020562d-2*gammabb*t107
     4         *t128*t153*t16*t17*t186*t187*t61+2*t123*t124*t126*t282*t5
     5         9+2*t124*t125*t126*t281*t59+5.0d-1*t116*t124*t126*t153*t2
     6         43*t59-t116*t124*t153*t241*t242*t59-4*t123*t124*t125*t169
     7         *t242*t59+t124*t126*t169*t240*t59-2*t126*t169*t238*t239*t
     8         59-2*t116*t123*t125*t126*t153*t239*t59+3.2910615692041123
     9         d-2*gammabb*t125*t126*t128*t16*t17*t25*t283+3.29106156920
     :         41123d-2*gammabb*t126*t127*t128*t16*t17*t25*t282+1.645530
     ;         7846020562d-2*gammabb*t126*t128*t16*t169*t17*t246*t25-3.2
     <         910615692041123d-2*gammabb*t126*t16*t169*t17*t244*t245*t2
     =         5-3.2910615692041123d-2*gammabb*t107*t125*t126*t127*t153*
     >         t16*t17*t245*t25+8.227653923010281d-3*gammabb*t107*t126*t
     ?         128*t153*t16*t17*t243*t25-1.6455307846020562d-2*gammabb*t
     @         107*t128*t153*t16*t17*t241*t242*t25-6.582123138408225d-2*
     1         gammabb*t125*t127*t128*t16*t169*t17*t242*t25+3.2910615692
     2         041123d-2*t125*t126*t127*t128*t16*t17*t25+3.2910615692041
     3         123d-2*gammabb*t125*t126*t127*t128*t152*t16*t25+2*t114*t1
     4         23*t124*t126*t169+2*t123*t124*t125*t126*t153+t114*t116*t1
     5         24*t125*t126*t153)-6.582123138408225d-2*t16*t52*t88*t89*t
     6         91-6.582123138408225d-2*gammabb*t112*t16*t161*t88*t89*t91
     7         +1.75523283690886d-1*gammabb*t151*t52*t78*t89*t91-6.58212
     8         3138408225d-2*gammabb*t16*t266*t52*t89*t91-6.582123138408
     9         225d-2*gammabb*t111*t112*t151*t16*t89*t91+1.3164246276816
     :         45d-1*gammabb*t151*t16*t187*t52*t88*t91-1.75523283690886d
     ;         -1*t25*t52*t78*t91-1.75523283690886d-1*gammabb*t112*t161*
     <         t25*t78*t91+6.582123138408225d-2*gammabb*t112*t16*t25*t27
     =         6*t91-6.582123138408225d-2*gammabb*t111*t16*t161*t212*t25
     >         *t91+6.582123138408225d-2*t111*t112*t16*t25*t91+1.7552328
     ?         3690886d-1*t17*t52*t78*t88*t89+1.75523283690886d-1*gammab
     @         b*t152*t52*t78*t88*t89+1.75523283690886d-1*gammabb*t112*t
     1         161*t17*t78*t88*t89-6.582123138408225d-2*gammabb*t16*t267
     2         *t52*t88*t89-6.582123138408225d-2*gammabb*t112*t16*t17*t2
     3         76*t88*t89+6.582123138408225d-2*gammabb*t111*t16*t161*t17
     4         *t212*t88*t89-6.582123138408225d-2*t111*t112*t16*t17*t88*
     5         t89-6.582123138408225d-2*gammabb*t111*t112*t152*t16*t88*t
     6         89+1.75523283690886d-1*gammabb*t17*t266*t52*t78*t89+1.755
     7         23283690886d-1*gammabb*t111*t112*t151*t17*t78*t89-3.29106
     8         15692041123d-2*gammabb*t16*t17*t421*t52*t89-3.29106156920
     9         41123d-2*gammabb*t151*t16*t200*t52*t89-3.2910615692041123
     :         d-2*t16*t17*t197*t52*t89-3.2910615692041123d-2*gammabb*t1
     ;         52*t16*t197*t52*t89-3.217926867666243d-1*gammabb*t151*t17
     <         *t182*t52*t89-6.582123138408225d-2*gammabb*t111*t112*t16*
     =         t17*t266*t89-3.2910615692041123d-2*gammabb*t112*t151*t16*
     >         t17*t227*t89+3.2910615692041123d-2*gammabb*t151*t16*t17*t
     ?         211*t212*t89-3.2910615692041123d-2*gammabb*t112*t16*t161*
     @         t17*t197*t89-3.51046567381772d-1*gammabb*t151*t17*t187*t5
     1         2*t78*t88+1.316424627681645d-1*gammabb*t16*t17*t187*t266*
     2         t52*t88+1.316424627681645d-1*gammabb*t111*t112*t151*t16*t
     3         17*t187*t88-1.75523283690886d-1*gammabb*t25*t267*t52*t78-
     4         1.75523283690886d-1*gammabb*t112*t17*t25*t276*t78+1.75523
     5         283690886d-1*gammabb*t111*t161*t17*t212*t25*t78-1.7552328
     6         3690886d-1*t111*t112*t17*t25*t78-1.75523283690886d-1*gamm
     7         abb*t111*t112*t152*t25*t78-4.727288888888889d-2*t32*t423*
     8         t77+9.454577777777778d-2*t137*t140*t268*t77+4.72728888888
     9         8889d-2*t137*t153*t256*t77-9.454577777777778d-2*t153*t207
     :         *t208*t77+2.6666666666666666d+0*t148*t441*t72*t75+5.33333
     ;         3333333333d+1*t174*t209*t387*t72*t75-2.1333333333333332d+
     <         1*t147*t210*t292*t72*t75-1.0666666666666666d+1*t174*t210*
     =         t259*t72*t75+5.333333333333333d+0*t135*t148*t292*t75+5.33
     >         3333333333333d+0*t147*t148*t287*t75+2.6666666666666666d+0
     ?         *t148*t180*t259*t75+2.6666666666666666d+0*t148*t174*t254*
     @         t75-1.0666666666666666d+1*t180*t209*t210*t75-2.1333333333
     1         333332d+1*t135*t147*t174*t210*t75-1.0546577777777776d-1*t
     2         35*t36*t441*t73-2.109315555555555d-1*t147*t269*t36*t73-1.
     3         0546577777777776d-1*t155*t259*t36*t73-1.0546577777777776d
     4         -1*t174*t206*t36*t73+6.764482379964267d-3*t1*t139*t153*t2
     5         59*t3*t35*t73-2.109315555555555d-1*t142*t292*t35*t73-2.10
     6         9315555555555d-1*t147*t288*t35*t73-1.0546577777777776d-1*
     7         t174*t255*t35*t73-1.7777777777777776d+0*t135*t291*t73-1.7
     8         777777777777776d+0*t146*t287*t73-8.888888888888888d-1*t25
     9         4*t264*t73-8.888888888888888d-1*t180*t258*t73-2.109315555
     :         555555d-1*t142*t147*t155*t73+5.333333333333333d+0*t146*t1
     ;         48*t292*t72+5.333333333333333d+0*t147*t148*t291*t72+2.666
     <         6666666666666d+0*t148*t259*t264*t72-1.0666666666666666d+1
     =         *t209*t210*t264*t72+2.6666666666666666d+0*t148*t174*t258*
     >         t72-2.1333333333333332d+1*t146*t147*t174*t210*t72-2.0d+0*
     ?         t121*(-1.475609999999999d-1*t106*t429*t56-4.4268299999999
     @         966d-1*t102*t153*t213*t390*t56+5.902439999999995d-1*t105*
     1         t214*t272*t56+1.475609999999999d-1*t102*t153*t214*t220*t5
     2         6-1.475609999999999d-1*t119*(t437+t436+t435+t434+t428+t42
     3         7+t426+t425)*t50-8.853659999999993d-1*t166*t231*t405*t50+
     4         5.902439999999995d-1*t118*t232*t279*t50+2.951219999999998
     5         d-1*t166*t232*t236*t50+2.951219999999998d-1*t105*t106*t11
     6         9*t279+2.951219999999998d-1*t106*t118*t119*t272+7.3780499
     7         99999994d-2*t102*t106*t119*t153*t236-1.475609999999999d-1
     8         *t102*t106*t153*t231*t232-5.902439999999995d-1*t105*t106*
     9         t118*t166*t232+1.475609999999999d-1*t106*t119*t166*t220-2
     :         .951219999999998d-1*t119*t166*t213*t214-2.951219999999998
     ;         d-1*t102*t105*t118*t119*t153*t214)*t59-4.0d+0*t167*t229*t
     <         404*t59+4.0d+0*t120*t230*t280*t59+2.0d+0*t167*t230*t237*t
     =         59-2.0d+0*t423*t58+3.2910615692041123d-2*gammabb*t16*t25*
     >         t422*t52-1.9746369415224674d-1*gammabb*t151*t16*t17*t186*
     ?         t365*t52+3.2910615692041123d-2*t16*t200*t25*t52+3.2179268
     @         67666243d-1*t17*t182*t25*t52+3.217926867666243d-1*gammabb
     1         *t152*t182*t25*t52+6.582123138408225d-2*gammabb*t151*t16*
     2         t17*t187*t197*t52+6.582123138408225d-2*t16*t17*t186*t187*
     3         t52+6.582123138408225d-2*gammabb*t152*t16*t186*t187*t52+3
     4         .2910615692041123d-2*gammabb*t112*t16*t17*t25*(6.0965d-1*
     5         t110*(t433+t432+t431+t430+t428+t427+t426+t425)*t50+3.6579
     6         d+0*t160*t221*t398*t50-2.4386000000000002d+0*t109*t222*t2
     7         75*t50-1.2193000000000001d+0*t160*t222*t226*t50+6.0965d-1
     8         *t106*t429*t47+1.82895d+0*t102*t153*t213*t390*t47-2.43860
     9         00000000002d+0*t105*t214*t272*t47-6.0965d-1*t102*t153*t21
     :         4*t220*t47-1.2193000000000001d+0*t105*t106*t110*t275-1.21
     ;         93000000000001d+0*t106*t109*t110*t272-3.04825d-1*t102*t10
     <         6*t110*t153*t226+6.0965d-1*t102*t106*t153*t221*t222+2.438
     =         6000000000002d+0*t105*t106*t109*t160*t222-6.0965d-1*t106*
     >         t110*t160*t220+1.2193000000000001d+0*t110*t160*t213*t214+
     ?         1.2193000000000001d+0*t102*t105*t109*t110*t153*t214)-4.72
     @         7288888888889d-2*t137*t28*t440+1.2128166337053317d-2*t1*t
     1         137*t153*t204*t3*t439+5.273288888888887d-2*t36*t38*t424+6
     2         .582123138408225d-2*gammabb*t16*t161*t17*t211*t25*t388+3.
     3         6384499011159954d-2*t1*t153*t171*t208*t3*t385-3.382241189
     4         9821336d-3*t1*t139*t153*t206*t3*t38+1.0546577777777776d-1
     5         *t142*t269*t38+5.273288888888887d-2*t155*t255*t38+6.32794
     6         6666666665d-1*t147*t148*t292*t35*t36+3.1639733333333325d-
     7         1*t148*t174*t259*t35*t36-1.265589333333333d+0*t174*t209*t
     8         210*t35*t36+3.1639733333333325d-1*t148*t155*t209*t36-2.02
     9         934471398928d-2*t1*t139*t148*t153*t209*t3*t35+6.327946666
     :         666665d-1*t142*t147*t148*t174*t35-2.8363733333333335d-1*t
     ;         153*t204*t32*t335+9.454577777777778d-2*t153*t202*t203*t32
     <         -6.064083168526658d-3*t1*t137*t153*t202*t284*t3-1.2128166
     =         337053317d-2*t1*t153*t171*t207*t256*t3+1.8909155555555557
     >         d-1*t140*t207*t28*t289-4.0d+0*t114*t121*t280-6.5821231384
     ?         08225d-2*gammabb*t111*t16*t17*t212*t25*t276-4.0d+0*t120*t
     @         121*t268+6.582123138408225d-2*gammabb*t111*t112*t16*t25*t
     1         267+5.333333333333333d+0*t135*t147*t148*t264-3.2910615692
     2         041123d-2*gammabb*t16*t161*t17*t212*t227*t25+3.2910615692
     3         041123d-2*t112*t16*t17*t227*t25+3.2910615692041123d-2*gam
     4         mabb*t112*t152*t16*t227*t25-3.2910615692041123d-2*t16*t17
     5         *t211*t212*t25-3.2910615692041123d-2*gammabb*t152*t16*t21
     6         1*t212*t25+3.2910615692041123d-2*gammabb*t112*t16*t161*t2
     7         00*t25+3.217926867666243d-1*gammabb*t112*t161*t17*t182*t2
     8         5-2.0d+0*t121*t153*t237+2.0d+0*t153*t229*t230+4.0d+0*t114
     9         *t120*t167*t230-2.0d+0*t121*t167*t228+6.582123138408225d-
     :         2*gammabb*t112*t16*t161*t17*t186*t187+5.333333333333333d+
     ;         0*t146*t147*t148*t180+5.333333333333333d+0*t135*t146*t148
     <         *t174)*wght-4.135669939329333d-1*t40*(-8.888888888888888d
     =         -1*t177*t72*t73+t265+t263+t262+t261+t175+t173+t172+t170+t
     >         168+t164+t162+t157+t156+t154)*wght-2.4814019635975998d+0*
     ?         t2*t293*wght+Cmat3(iq,D3_RB_RB_GBB)
            Cmat3(iq,D3_RB_GBB_GBB) = -9.305257363491d-1*t22*(-8.8888888
     1         88888888d-1*t73*t75*(4.7459599999999996d-2*t300*t95-2.4d+
     2         0*t68*(6.41391219265211d-2*t132*(-gammabb*t16*t298*t89*t9
     3         1-2*t151*t16*t89*t91+2*gammabb*t16*t187*t296*t91-gammabb*
     4         t16*t299*t88*t89-2*t152*t16*t88*t89+2.6666666666666666d+0
     5         *gammabb*t17*t298*t78*t89+5.333333333333333d+0*t151*t17*t
     6         78*t89+5.333333333333333d+0*gammabb*t151*t152*t78*t89-gam
     7         mabb*t16*t17*t442*t89-2*gammabb*t151*t16*t267*t89-2*t16*t
     8         17*t266*t89-2*gammabb*t152*t16*t266*t89-6*gammabb*t16*t17
     9         *t296*t365*t88+2*gammabb*t16*t17*t187*t298*t88+4*t151*t16
     :         *t17*t187*t88+4*gammabb*t151*t152*t16*t187*t88-2.66666666
     ;         66666666d+0*gammabb*t25*t299*t78-5.333333333333333d+0*gam
     <         mabb*t17*t187*t296*t78-5.333333333333333d+0*t152*t25*t78+
     =         gammabb*t16*t25*t443+2*t16*t25*t267+4*gammabb*t151*t16*t1
     >         7*t187*t266)-5.0d-1*t131*t444-3.75d-1*t114*t294*t418+4.81
     ?         0434144489083d-2*t133*t345*t417-3.206956096326055d-2*t133
     @         *t249*t346+2.5d-1*t114*t251*t300-6.41391219265211d-2*t178
     1         *t249*t285+5.0d-1*t153*t251*t268)-8.400000000000001d+0*t1
     2         30*t444*t71-3.15d+1*t114*t294*t416*t71-2.1d+1*t114*t248*t
     3         300*t71-4.2d+1*t153*t248*t268*t71-2.7259596d+0*t444*t67+4
     4         .7459599999999996d-2*t445*t66+5.672746666666666d-2*t444*t
     5         66-5.4519192d+0*t114*t300*t66-1.0903838400000002d+1*t153*
     6         t268*t66+4.7459599999999996d-2*t35*t444-4.962870782535445
     7         7d+0*t130*t444-1.8610765434507923d+1*t114*t294*t416-8.400
     8         000000000001d+0*t114*t130*t347+4.7459599999999996d-2*t114
     9         *t302-1.2407176956338616d+1*t114*t248*t300-8.400000000000
     :         001d+0*t130*t134*t300+5.672746666666666d-2*t114*t300-2.1d
     ;         +1*t134*t248*t294-5.4519192d+0*t114*t294-1.68d+1*t130*t15
     <         3*t286+9.491919999999999d-2*t153*t269-2.481435391267723d+
     =         1*t153*t248*t268-1.68d+1*t130*t179*t268+9.491919999999999
     >         d-2*t155*t268+1.1345493333333331d-1*t153*t268-4.2d+1*t114
     ?         *t153*t179*t248)-1.0546577777777776d-1*t350*t36*t73*t95+1
     @         .3528964759928536d-2*t1*t139*t153*t174*t3*t73*t95-3.38224
     1         11899821336d-3*t1*t139*t3*t300*t38*t95+5.0733617849732d-3
     2         *t1*t171*t294*t3*t38*t95+3.1639733333333325d-1*t148*t304*
     3         t36*t95-8.888888888888888d-1*t72*t73*(4.9365923538061685d
     4         -2*t1*t3*t30*(7.5d-1*t1*t171*t3*t300*t93-1.875d+0*t1*t284
     5         *t294*t3*t93-5.0d-1*t1*t139*t3*t444+1.6666666666666666d-1
     6         *t1*t139*t23*t300+1.5d+0*t1*t153*t171*t268*t3-2.5d-1*t1*t
     7         171*t23*t294)+2.164695365020087d-1*t1*t171*t3*t300*t93-5.
     8         411738412550218d-1*t1*t284*t294*t3*t93-1.4431302433467247
     9         d-1*t1*t139*t3*t444-2.4682961769030842d-2*t1*t139*t145*t3
     :         *t300+4.810434144489082d-2*t1*t139*t23*t300+3.70244426535
     ;         46263d-2*t1*t145*t171*t294*t3-4.9365923538061685d-2*t1*t1
     <         39*t153*t290*t3+4.329390730040174d-1*t1*t153*t171*t268*t3
     =         -7.215651216733623d-2*t1*t171*t23*t294)+5.273288888888887
     >         d-2*t35*t38*(9.620868288978166d-2*t1*t171*t3*t300*t93-2.4
     ?         052170722445415d-1*t1*t284*t294*t3*t93-6.41391219265211d-
     @         2*t1*t139*t3*t444+2.1379707308840368d-2*t1*t139*t23*t300+
     1         1.924173657795633d-1*t1*t153*t171*t268*t3-3.2069560963260
     2         55d-2*t1*t171*t23*t294)-1.5557798788747831d-3*t207*t294*t
     3         39*t40*t460*t93+3.3352457426896626d-2*t1*t137*t294*t3*t43
     4         9*t93-2.8363733333333335d-1*t294*t32*t335*t93+9.454577777
     5         777778d-2*t203*t300*t32*t93-6.064083168526658d-3*t1*t137*
     6         t284*t3*t300*t93+7.57211d-1*(-1.6455307846020562d-2*gamma
     7         bb*t16*t298*t61*t65*t89*t91-3.2910615692041123d-2*t151*t1
     8         6*t61*t65*t89*t91+3.2910615692041123d-2*gammabb*t126*t151
     9         *t16*t169*t65*t89*t91+1.6455307846020562d-2*gammabb*t107*
     :         t128*t151*t153*t16*t61*t89*t91+3.2910615692041123d-2*gamm
     ;         abb*t16*t187*t296*t61*t65*t91-1.6455307846020562d-2*gamma
     <         bb*t126*t16*t25*t328*t65*t91+3.2910615692041123d-2*gammab
     =         b*t16*t242*t25*t325*t65*t91-3.2910615692041123d-2*t126*t1
     >         6*t169*t25*t65*t91+8.227653923010281d-3*gammabb*t16*t245*
     ?         t25*t294*t329*t61*t91-8.227653923010281d-3*gammabb*t107*t
     @         128*t16*t25*t300*t61*t91+4.1138269615051404d-3*gammabb*t1
     1         28*t16*t223*t25*t294*t61*t91-1.6455307846020562d-2*t107*t
     2         128*t153*t16*t25*t61*t91+1.6455307846020562d-2*gammabb*t1
     3         07*t126*t128*t153*t16*t169*t25*t91-1.6455307846020562d-2*
     4         gammabb*t16*t299*t61*t65*t88*t89-3.2910615692041123d-2*t1
     5         52*t16*t61*t65*t88*t89+1.6455307846020562d-2*gammabb*t126
     6         *t16*t17*t328*t65*t88*t89-3.2910615692041123d-2*gammabb*t
     7         16*t17*t242*t325*t65*t88*t89+3.2910615692041123d-2*t126*t
     8         16*t169*t17*t65*t88*t89+3.2910615692041123d-2*gammabb*t12
     9         6*t152*t16*t169*t65*t88*t89-8.227653923010281d-3*gammabb*
     :         t16*t17*t245*t294*t329*t61*t88*t89+8.227653923010281d-3*g
     ;         ammabb*t107*t128*t16*t17*t300*t61*t88*t89-4.1138269615051
     <         404d-3*gammabb*t128*t16*t17*t223*t294*t61*t88*t89+1.64553
     =         07846020562d-2*t107*t128*t153*t16*t17*t61*t88*t89+1.64553
     >         07846020562d-2*gammabb*t107*t128*t152*t153*t16*t61*t88*t8
     ?         9-1.6455307846020562d-2*gammabb*t107*t126*t128*t153*t16*t
     @         169*t17*t88*t89+4.38808209227215d-2*gammabb*t17*t298*t61*
     1         t65*t78*t89+8.7761641845443d-2*t151*t17*t61*t65*t78*t89+8
     2         .7761641845443d-2*gammabb*t151*t152*t61*t65*t78*t89-8.776
     3         1641845443d-2*gammabb*t126*t151*t169*t17*t65*t78*t89-4.38
     4         808209227215d-2*gammabb*t107*t128*t151*t153*t17*t61*t78*t
     5         89-1.6455307846020562d-2*gammabb*t16*t17*t442*t61*t65*t89
     6         -3.2910615692041123d-2*gammabb*t151*t16*t267*t61*t65*t89-
     7         3.2910615692041123d-2*t16*t17*t266*t61*t65*t89-3.29106156
     8         92041123d-2*gammabb*t152*t16*t266*t61*t65*t89+1.645530784
     9         6020562d-2*gammabb*t125*t126*t16*t17*t298*t65*t89+3.29106
     :         15692041123d-2*gammabb*t126*t151*t16*t17*t282*t65*t89+3.2
     ;         910615692041123d-2*gammabb*t126*t16*t169*t17*t266*t65*t89
     <         -6.582123138408225d-2*gammabb*t125*t151*t16*t169*t17*t242
     =         *t65*t89+3.2910615692041123d-2*t125*t126*t151*t16*t17*t65
     >         *t89+3.2910615692041123d-2*gammabb*t125*t126*t151*t152*t1
     ?         6*t65*t89+1.6455307846020562d-2*gammabb*t127*t128*t16*t17
     @         *t298*t61*t89+3.2910615692041123d-2*gammabb*t128*t151*t16
     1         *t17*t283*t61*t89+1.6455307846020562d-2*gammabb*t107*t128
     2         *t153*t16*t17*t266*t61*t89-3.2910615692041123d-2*gammabb*
     3         t107*t127*t151*t153*t16*t17*t245*t61*t89+3.29106156920411
     4         23d-2*t127*t128*t151*t16*t17*t61*t89+3.2910615692041123d-
     5         2*gammabb*t127*t128*t151*t152*t16*t61*t89-3.2910615692041
     6         123d-2*gammabb*t126*t127*t128*t151*t16*t169*t17*t89-1.645
     7         5307846020562d-2*gammabb*t107*t125*t126*t128*t151*t153*t1
     8         6*t17*t89-9.873184707612337d-2*gammabb*t16*t17*t296*t365*
     9         t61*t65*t88+3.2910615692041123d-2*gammabb*t16*t17*t187*t2
     :         98*t61*t65*t88+6.582123138408225d-2*t151*t16*t17*t187*t61
     ;         *t65*t88+6.582123138408225d-2*gammabb*t151*t152*t16*t187*
     <         t61*t65*t88-6.582123138408225d-2*gammabb*t126*t151*t16*t1
     =         69*t17*t187*t65*t88-3.2910615692041123d-2*gammabb*t107*t1
     >         28*t151*t153*t16*t17*t187*t61*t88-4.38808209227215d-2*gam
     ?         mabb*t25*t299*t61*t65*t78-8.7761641845443d-2*gammabb*t17*
     @         t187*t296*t61*t65*t78-8.7761641845443d-2*t152*t25*t61*t65
     1         *t78+4.38808209227215d-2*gammabb*t126*t17*t25*t328*t65*t7
     2         8-8.7761641845443d-2*gammabb*t17*t242*t25*t325*t65*t78+8.
     3         7761641845443d-2*t126*t169*t17*t25*t65*t78+8.776164184544
     4         3d-2*gammabb*t126*t152*t169*t25*t65*t78-2.194041046136075
     5         d-2*gammabb*t17*t245*t25*t294*t329*t61*t78+2.194041046136
     6         075d-2*gammabb*t107*t128*t17*t25*t300*t61*t78-1.097020523
     7         0680374d-2*gammabb*t128*t17*t223*t25*t294*t61*t78+4.38808
     8         209227215d-2*t107*t128*t153*t17*t25*t61*t78+4.38808209227
     9         215d-2*gammabb*t107*t128*t152*t153*t25*t61*t78-4.38808209
     :         227215d-2*gammabb*t107*t126*t128*t153*t169*t17*t25*t78+1.
     ;         6455307846020562d-2*gammabb*t16*t25*t443*t61*t65+3.291061
     <         5692041123d-2*t16*t25*t267*t61*t65+6.582123138408225d-2*g
     =         ammabb*t151*t16*t17*t187*t266*t61*t65-1.6455307846020562d
     >         -2*gammabb*t126*t16*t17*t25*t459*t65-9.873184707612337d-2
     ?         *gammabb*t125*t16*t17*t25*t325*t412*t65+3.291061569204112
     @         3d-2*gammabb*t125*t16*t17*t242*t25*t328*t65-1.64553078460
     1         20562d-2*gammabb*t125*t126*t16*t25*t299*t65-3.29106156920
     2         41123d-2*gammabb*t125*t126*t16*t17*t187*t296*t65+6.582123
     3         138408225d-2*gammabb*t16*t169*t17*t242*t25*t282*t65-3.291
     4         0615692041123d-2*t126*t16*t17*t25*t282*t65-3.291061569204
     5         1123d-2*gammabb*t126*t152*t16*t25*t282*t65-3.291061569204
     6         1123d-2*gammabb*t126*t16*t169*t25*t267*t65+6.582123138408
     7         225d-2*t125*t16*t169*t17*t242*t25*t65+6.582123138408225d-
     8         2*gammabb*t125*t152*t16*t169*t242*t25*t65-3.2910615692041
     9         123d-2*t125*t126*t152*t16*t25*t65+t444*t61*t63-t126*t459*
     :         t59*t63-6*t125*t325*t412*t59*t63+2*t125*t242*t328*t59*t63
     ;         +4*t169*t242*t282*t59*t63-t114*t126*t328*t63+2*t114*t242*
     <         t325*t63-t125*t126*t300*t63-2*t126*t153*t282*t63-2*t126*t
     =         169*t268*t63+4*t125*t153*t169*t242*t63-t124*(t458+t457+t4
     >         56+t455)*t59*t61-1.5d+0*t123*t294*t324*t410*t59*t61+t116*
     ?         t123*t239*t300*t59*t61-5.0d-1*t123*t233*t239*t294*t59*t61
     @         +2*t116*t153*t239*t281*t59*t61-1.6455307846020562d-2*gamm
     1         abb*t128*t16*t17*t25*(t454+t453+t452+t451)*t61-2.46829617
     2         69030842d-2*gammabb*t127*t16*t17*t25*t294*t329*t414*t61+5
     3         .0d-1*t114*t239*t294*t324*t61+1.6455307846020562d-2*gamma
     4         bb*t107*t127*t16*t17*t245*t25*t300*t61-t123*t124*t300*t61
     5         -5.0d-1*t114*t116*t124*t300*t61-1.6455307846020562d-2*gam
     6         mabb*t127*t128*t16*t25*t299*t61-3.2910615692041123d-2*gam
     7         mabb*t127*t128*t16*t17*t187*t296*t61-8.227653923010281d-3
     8         *gammabb*t127*t16*t17*t223*t245*t25*t294*t61+2*t116*t123*
     9         t239*t294*t61+2.5d-1*t114*t124*t233*t294*t61+3.2910615692
     :         041123d-2*gammabb*t107*t153*t16*t17*t245*t25*t283*t61-3.2
     ;         910615692041123d-2*t128*t16*t17*t25*t283*t61-3.2910615692
     <         041123d-2*gammabb*t128*t152*t16*t25*t283*t61-2*t124*t153*
     =         t281*t61-t116*t124*t153*t268*t61-1.6455307846020562d-2*ga
     >         mmabb*t107*t128*t153*t16*t25*t267*t61+3.2910615692041123d
     ?         -2*t107*t127*t153*t16*t17*t245*t25*t61+3.2910615692041123
     @         d-2*gammabb*t107*t127*t152*t153*t16*t245*t25*t61-3.291061
     1         5692041123d-2*t127*t128*t152*t16*t25*t61+t123*t124*t126*t
     2         328*t59-2*t123*t124*t242*t325*t59-5.0d-1*t125*t126*t239*t
     3         294*t324*t59+5.0d-1*t116*t124*t125*t126*t300*t59-2.5d-1*t
     4         124*t125*t126*t233*t294*t59+t116*t124*t126*t153*t282*t59+
     5         2*t124*t126*t169*t281*t59-2*t116*t124*t125*t153*t169*t242
     6         *t59-2*t116*t123*t126*t153*t169*t239*t59-8.22765392301028
     7         1d-3*gammabb*t125*t126*t16*t17*t245*t25*t294*t329+1.64553
     8         07846020562d-2*gammabb*t126*t127*t128*t16*t17*t25*t328-3.
     9         2910615692041123d-2*gammabb*t127*t128*t16*t17*t242*t25*t3
     :         25+8.227653923010281d-3*gammabb*t107*t125*t126*t128*t16*t
     ;         17*t25*t300-4.1138269615051404d-3*gammabb*t125*t126*t128*
     <         t16*t17*t223*t25*t294+t116*t124*t125*t126*t294+3.29106156
     =         92041123d-2*gammabb*t126*t128*t16*t169*t17*t25*t283+1.645
     >         5307846020562d-2*gammabb*t107*t126*t128*t153*t16*t17*t25*
     ?         t282-3.2910615692041123d-2*gammabb*t107*t126*t127*t153*t1
     @         6*t169*t17*t245*t25-3.2910615692041123d-2*gammabb*t107*t1
     1         25*t128*t153*t16*t169*t17*t242*t25+3.2910615692041123d-2*
     2         t126*t127*t128*t16*t169*t17*t25+1.6455307846020562d-2*t10
     3         7*t125*t126*t128*t153*t16*t17*t25+3.2910615692041123d-2*g
     4         ammabb*t126*t127*t128*t152*t16*t169*t25+1.645530784602056
     5         2d-2*gammabb*t107*t125*t126*t128*t152*t153*t16*t25+2*t123
     6         *t124*t126*t153*t169+t114*t116*t124*t126*t153*t169)-3.291
     7         0615692041123d-2*gammabb*t16*t298*t52*t89*t91-6.582123138
     8         408225d-2*t151*t16*t52*t89*t91-6.582123138408225d-2*gamma
     9         bb*t112*t151*t16*t161*t89*t91+6.582123138408225d-2*gammab
     :         b*t16*t187*t296*t52*t91+3.2910615692041123d-2*gammabb*t11
     ;         2*t16*t25*t318*t91-3.2910615692041123d-2*gammabb*t16*t212
     <         *t25*t308*t91+6.582123138408225d-2*t112*t16*t161*t25*t91-
     =         3.2910615692041123d-2*gammabb*t16*t299*t52*t88*t89-6.5821
     >         23138408225d-2*t152*t16*t52*t88*t89-3.2910615692041123d-2
     ?         *gammabb*t112*t16*t17*t318*t88*t89+3.2910615692041123d-2*
     @         gammabb*t16*t17*t212*t308*t88*t89-6.582123138408225d-2*t1
     1         12*t16*t161*t17*t88*t89-6.582123138408225d-2*gammabb*t112
     2         *t152*t16*t161*t88*t89+8.7761641845443d-2*gammabb*t17*t29
     3         8*t52*t78*t89+1.75523283690886d-1*t151*t17*t52*t78*t89+1.
     4         75523283690886d-1*gammabb*t151*t152*t52*t78*t89+1.7552328
     5         3690886d-1*gammabb*t112*t151*t161*t17*t78*t89-3.291061569
     6         2041123d-2*gammabb*t16*t17*t442*t52*t89-6.582123138408225
     7         d-2*gammabb*t151*t16*t267*t52*t89-6.582123138408225d-2*t1
     8         6*t17*t266*t52*t89-6.582123138408225d-2*gammabb*t152*t16*
     9         t266*t52*t89-3.2910615692041123d-2*gammabb*t111*t112*t16*
     :         t17*t298*t89-6.582123138408225d-2*gammabb*t112*t151*t16*t
     ;         17*t276*t89-6.582123138408225d-2*gammabb*t112*t16*t161*t1
     <         7*t266*t89+6.582123138408225d-2*gammabb*t111*t151*t16*t16
     =         1*t17*t212*t89-6.582123138408225d-2*t111*t112*t151*t16*t1
     >         7*t89-6.582123138408225d-2*gammabb*t111*t112*t151*t152*t1
     ?         6*t89-1.9746369415224674d-1*gammabb*t16*t17*t296*t365*t52
     @         *t88+6.582123138408225d-2*gammabb*t16*t17*t187*t298*t52*t
     1         88+1.316424627681645d-1*t151*t16*t17*t187*t52*t88+1.31642
     2         4627681645d-1*gammabb*t151*t152*t16*t187*t52*t88+1.316424
     3         627681645d-1*gammabb*t112*t151*t16*t161*t17*t187*t88-8.77
     4         61641845443d-2*gammabb*t25*t299*t52*t78-1.75523283690886d
     5         -1*gammabb*t17*t187*t296*t52*t78-1.75523283690886d-1*t152
     6         *t25*t52*t78-8.7761641845443d-2*gammabb*t112*t17*t25*t318
     7         *t78+8.7761641845443d-2*gammabb*t17*t212*t25*t308*t78-1.7
     8         5523283690886d-1*t112*t161*t17*t25*t78-1.75523283690886d-
     9         1*gammabb*t112*t152*t161*t25*t78-4.727288888888889d-2*t32
     :         *t444*t77+4.727288888888889d-2*t137*t140*t300*t77+9.45457
     ;         7777777778d-2*t137*t153*t289*t77+2.6666666666666666d+0*t1
     <         48*t462*t72*t75+5.333333333333333d+1*t147*t304*t387*t72*t
     =         75-1.0666666666666666d+1*t147*t210*t350*t72*t75-2.1333333
     >         333333332d+1*t174*t210*t292*t72*t75+2.6666666666666666d+0
     ?         *t135*t148*t350*t75+2.6666666666666666d+0*t147*t148*t348*
     @         t75-1.0666666666666666d+1*t135*t210*t304*t75+5.3333333333
     1         33333d+0*t148*t180*t292*t75+5.333333333333333d+0*t148*t17
     2         4*t287*t75-2.1333333333333332d+1*t147*t174*t180*t210*t75-
     3         1.0546577777777776d-1*t35*t36*t462*t73-1.0546577777777776
     4         d-1*t147*t302*t36*t73-2.109315555555555d-1*t155*t292*t36*
     5         t73-2.109315555555555d-1*t174*t269*t36*t73-1.054657777777
     6         7776d-1*t142*t35*t350*t73+6.764482379964267d-3*t1*t139*t1
     7         47*t3*t300*t35*t73-1.01467235699464d-2*t1*t147*t171*t294*
     8         t3*t35*t73+1.3528964759928536d-2*t1*t139*t153*t292*t3*t35
     9         *t73-2.109315555555555d-1*t174*t288*t35*t73-8.88888888888
     :         8888d-1*t146*t348*t73-8.888888888888888d-1*t135*t342*t73+
     ;         1.3528964759928536d-2*t1*t139*t147*t153*t155*t3*t73-1.777
     <         7777777777776d+0*t180*t291*t73-1.7777777777777776d+0*t264
     =         *t287*t73-2.109315555555555d-1*t142*t155*t174*t73+2.66666
     >         66666666666d+0*t146*t148*t350*t72+2.6666666666666666d+0*t
     ?         147*t148*t342*t72-1.0666666666666666d+1*t146*t210*t304*t7
     @         2+5.333333333333333d+0*t148*t264*t292*t72+5.3333333333333
     1         33d+0*t148*t174*t291*t72-2.1333333333333332d+1*t147*t174*
     2         t210*t264*t72-2.0d+0*t121*(-1.475609999999999d-1*t106*t45
     3         0*t56-2.2134149999999983d-1*t105*t294*t311*t390*t56+1.475
     4         609999999999d-1*t102*t105*t214*t300*t56-7.378049999999994
     5         d-2*t105*t214*t216*t294*t56+2.951219999999998d-1*t102*t15
     6         3*t214*t272*t56-1.475609999999999d-1*t119*(t458+t457+t456
     7         +t455+t449+t448+t447+t446)*t50-8.853659999999993d-1*t118*
     8         t331*t405*t50+2.951219999999998d-1*t118*t232*t332*t50+5.9
     9         02439999999995d-1*t166*t232*t279*t50+1.475609999999999d-1
     :         *t105*t106*t119*t332-2.951219999999998d-1*t105*t106*t232*
     ;         t331-7.378049999999994d-2*t118*t119*t214*t294*t311+7.3780
     <         49999999994d-2*t102*t106*t118*t119*t300-3.689024999999997
     =         d-2*t106*t118*t119*t216*t294+1.475609999999999d-1*t102*t1
     >         06*t119*t153*t279+2.951219999999998d-1*t106*t119*t166*t27
     ?         2-2.951219999999998d-1*t102*t106*t118*t153*t166*t232-2.95
     @         1219999999998d-1*t102*t105*t119*t153*t166*t214)*t59-4.0d+
     1         0*t120*t322*t404*t59+2.0d+0*t120*t230*t333*t59+4.0d+0*t16
     2         7*t230*t280*t59-2.0d+0*t444*t58+3.2910615692041123d-2*gam
     3         mabb*t16*t25*t443*t52+6.582123138408225d-2*t16*t25*t267*t
     4         52+1.316424627681645d-1*gammabb*t151*t16*t17*t187*t266*t5
     5         2+3.2910615692041123d-2*gammabb*t112*t16*t17*t25*(6.0965d
     6         -1*t110*(t454+t453+t452+t451+t449+t448+t447+t446)*t50+3.6
     7         579d+0*t109*t312*t398*t50-1.2193000000000001d+0*t109*t222
     8         *t317*t50-2.4386000000000002d+0*t160*t222*t275*t50+6.0965
     9         d-1*t106*t450*t47+9.14475d-1*t105*t294*t311*t390*t47-6.09
     :         65d-1*t102*t105*t214*t300*t47+3.04825d-1*t105*t214*t216*t
     ;         294*t47-1.2193000000000001d+0*t102*t153*t214*t272*t47-6.0
     <         965d-1*t105*t106*t110*t317+1.2193000000000001d+0*t105*t10
     =         6*t222*t312+3.04825d-1*t109*t110*t214*t294*t311-3.04825d-
     >         1*t102*t106*t109*t110*t300+1.524125d-1*t106*t109*t110*t21
     ?         6*t294-6.0965d-1*t102*t106*t110*t153*t275-1.2193000000000
     @         001d+0*t106*t110*t160*t272+1.2193000000000001d+0*t102*t10
     1         6*t109*t153*t160*t222+1.2193000000000001d+0*t102*t105*t11
     2         0*t153*t160*t214)-4.727288888888889d-2*t137*t28*t461+5.27
     3         3288888888887d-2*t36*t38*t445-4.667339636624349d-3*t140*t
     4         294*t335*t385*t39*t40+6.582123138408225d-2*gammabb*t111*t
     5         16*t17*t25*t308*t388+5.273288888888887d-2*t142*t302*t38-6
     6         .764482379964267d-3*t1*t139*t153*t269*t3*t38+1.0546577777
     7         777776d-1*t155*t288*t38+3.1639733333333325d-1*t147*t148*t
     8         35*t350*t36-1.265589333333333d+0*t147*t210*t304*t35*t36+6
     9         .327946666666665d-1*t148*t174*t292*t35*t36+6.327946666666
     :         665d-1*t147*t148*t155*t174*t36+3.1639733333333325d-1*t142
     ;         *t148*t304*t35-4.05868942797856d-2*t1*t139*t147*t148*t153
     <         *t174*t3*t35-2.0d+0*t114*t121*t333+2.0d+0*t114*t230*t322+
     =         1.8909155555555557d-1*t153*t203*t268*t32-3.29106156920411
     >         23d-2*gammabb*t111*t16*t17*t212*t25*t318-1.21281663370533
     ?         17d-2*t1*t140*t171*t207*t3*t300-2.0d+0*t120*t121*t300+4.2
     @         44858217968661d-2*t1*t140*t207*t284*t294*t3-2.42563326741
     1         06634d-2*t1*t153*t171*t207*t289*t3-1.2128166337053317d-2*
     2         t1*t137*t153*t268*t284*t3+3.2910615692041123d-2*gammabb*t
     3         111*t112*t16*t25*t299+6.582123138408225d-2*gammabb*t111*t
     4         112*t16*t17*t187*t296-9.454577777777778d-2*t137*t140*t203
     5         *t294-4.0d+0*t121*t153*t280-6.582123138408225d-2*gammabb*
     6         t16*t161*t17*t212*t25*t276+6.582123138408225d-2*t112*t16*
     7         t17*t25*t276+6.582123138408225d-2*gammabb*t112*t152*t16*t
     8         25*t276-4.0d+0*t121*t167*t268+6.582123138408225d-2*gammab
     9         b*t112*t16*t161*t25*t267+5.333333333333333d+0*t147*t148*t
     :         180*t264+5.333333333333333d+0*t135*t148*t174*t264-6.58212
     ;         3138408225d-2*t111*t16*t161*t17*t212*t25-6.58212313840822
     <         5d-2*gammabb*t111*t152*t16*t161*t212*t25+6.58212313840822
     =         5d-2*t111*t112*t152*t16*t25+4.0d+0*t120*t153*t167*t230+5.
     >         333333333333333d+0*t146*t148*t174*t180)*wght-1.2407009817
     ?         987999d+0*t2*(-3.2910615692041123d-2*gammabb*t16*t17*t298
     @         *t52*t89-6.582123138408225d-2*t151*t16*t17*t52*t89-6.5821
     1         23138408225d-2*gammabb*t151*t152*t16*t52*t89-8.8888888888
     2         88888d-1*t348*t73*t75+2.6666666666666666d+0*t148*t350*t72
     3         *t75+5.333333333333333d+0*t148*t174*t180*t75-8.8888888888
     4         88888d-1*t342*t72*t73-1.0546577777777776d-1*t35*t350*t36*
     5         t73-2.109315555555555d-1*t155*t174*t36*t73+1.352896475992
     6         8536d-2*t1*t139*t153*t174*t3*t35*t73-1.7777777777777776d+
     7         0*t180*t264*t73+5.333333333333333d+0*t148*t174*t264*t72-2
     8         .0d+0*t121*t333*t59+3.2910615692041123d-2*gammabb*t16*t25
     9         *t299*t52+6.582123138408225d-2*t152*t16*t25*t52-3.3822411
     :         899821336d-3*t1*t139*t3*t300*t35*t38-6.764482379964267d-3
     ;         *t1*t139*t153*t155*t3*t38+3.1639733333333325d-1*t148*t304
     <         *t35*t36+t339+t338+t337+t336+t330+t323+t321+3.29106156920
     =         41123d-2*gammabb*t112*t16*t17*t25*t318+t309+t307+t306+t30
     >         5+t303+t301+t295+6.582123138408225d-2*t112*t16*t161*t17*t
     ?         25+6.582123138408225d-2*gammabb*t112*t152*t16*t161*t25-4.
     @         0d+0*t121*t153*t167)*wght+Cmat3(iq,D3_RB_GBB_GBB)
            Cmat3(iq,D3_GBB_GBB_GBB) = Cmat3(iq,D3_GBB_GBB_GBB)-9.305257
     1         363491d-1*t22*(t73*(-8.888888888888888d-1*t75*(-2.4d+0*t6
     2         8*(6.41391219265211d-2*t132*(-gammabb*t16*t17*t465*t89-3*
     3         gammabb*t151*t16*t299*t89-3*t16*t17*t298*t89-3*gammabb*t1
     4         52*t16*t298*t89-6*t151*t152*t16*t89+gammabb*t16*t25*t466-
     5         6*gammabb*t16*t17*t365*t464+3*t16*t25*t299+6*gammabb*t151
     6         *t16*t17*t187*t298+6*t16*t17*t187*t296+6*gammabb*t152*t16
     7         *t187*t296)-5.0d-1*t131*t467-3.75d-1*t418*t463+4.81043414
     8         4489083d-2*t178**3*t417-9.620868288978166d-2*t178*t249*t3
     9         46+7.5d-1*t153*t251*t300)-8.400000000000001d+0*t130*t467*
     :         t71-3.15d+1*t416*t463*t71-6.3d+1*t153*t248*t300*t71-2.725
     ;         9596d+0*t467*t67+4.7459599999999996d-2*t468*t66+5.6727466
     <         66666666d-2*t467*t66-1.6355757600000004d+1*t153*t300*t66+
     =         4.7459599999999996d-2*t35*t467-4.9628707825354457d+0*t130
     >         *t467-1.8610765434507923d+1*t416*t463-5.4519192d+0*t463-2
     ?         .52d+1*t130*t153*t347+1.423788d-1*t153*t302-3.72215308690
     @         15845d+1*t153*t248*t300-2.52d+1*t130*t179*t300+1.423788d-
     1         1*t155*t300+1.7018239999999996d-1*t153*t300-6.3d+1*t179*t
     2         248*t294)-8.888888888888888d-1*t72*(-2.4682961769030842d-
     3         2*t39*t40*t467*t77-1.4431302433467247d-1*t1*t139*t3*t467-
     4         1.4809777061418505d-1*t335*t39*t40*t463-5.411738412550218
     5         d-1*t1*t284*t3*t463+1.4809777061418505d-1*t153*t203*t300*
     6         t39*t40+6.494086095060261d-1*t1*t153*t171*t3*t300)-1.0546
     7         577777777776d-1*t35*t36*t481-3.1639733333333325d-1*t155*t
     8         350*t36-3.1639733333333325d-1*t174*t302*t36+1.35289647599
     9         28536d-2*t1*t139*t153*t3*t35*t350+6.764482379964267d-3*t1
     :         *t139*t174*t3*t300*t35-1.01467235699464d-2*t1*t171*t174*t
     ;         294*t3*t35-2.6666666666666666d+0*t177*t348-2.666666666666
     <         6666d+0*t180*t342+2.02934471398928d-2*t1*t139*t153*t155*t
     =         174*t3)+7.57211d-1*(-1.6455307846020562d-2*gammabb*t16*t1
     >         7*t465*t61*t65*t89-4.9365923538061685d-2*gammabb*t151*t16
     ?         *t299*t61*t65*t89-4.9365923538061685d-2*t16*t17*t298*t61*
     @         t65*t89-4.9365923538061685d-2*gammabb*t152*t16*t298*t61*t
     1         65*t89-9.873184707612337d-2*t151*t152*t16*t61*t65*t89+4.9
     2         365923538061685d-2*gammabb*t126*t151*t16*t17*t328*t65*t89
     3         -9.873184707612337d-2*gammabb*t151*t16*t17*t242*t325*t65*
     4         t89+4.9365923538061685d-2*gammabb*t126*t16*t169*t17*t298*
     5         t65*t89+9.873184707612337d-2*t126*t151*t16*t169*t17*t65*t
     6         89+9.873184707612337d-2*gammabb*t126*t151*t152*t16*t169*t
     7         65*t89-2.4682961769030842d-2*gammabb*t151*t16*t17*t245*t2
     8         94*t329*t61*t89+2.4682961769030842d-2*gammabb*t107*t128*t
     9         151*t16*t17*t300*t61*t89+2.4682961769030842d-2*gammabb*t1
     :         07*t128*t153*t16*t17*t298*t61*t89-1.2341480884515421d-2*g
     ;         ammabb*t128*t151*t16*t17*t223*t294*t61*t89+4.936592353806
     <         1685d-2*t107*t128*t151*t153*t16*t17*t61*t89+4.93659235380
     =         61685d-2*gammabb*t107*t128*t151*t152*t153*t16*t61*t89-4.9
     >         365923538061685d-2*gammabb*t107*t126*t128*t151*t153*t16*t
     ?         169*t17*t89+1.6455307846020562d-2*gammabb*t16*t25*t466*t6
     @         1*t65-9.873184707612337d-2*gammabb*t16*t17*t365*t464*t61*
     1         t65+4.9365923538061685d-2*t16*t25*t299*t61*t65+9.87318470
     2         7612337d-2*gammabb*t151*t16*t17*t187*t298*t61*t65+9.87318
     3         4707612337d-2*t16*t17*t187*t296*t61*t65+9.873184707612337
     4         d-2*gammabb*t152*t16*t187*t296*t61*t65-1.6455307846020562
     5         d-2*gammabb*t126*t16*t17*t25*t480*t65-9.873184707612337d-
     6         2*gammabb*t16*t17*t25*t412*t476*t65+9.873184707612337d-2*
     7         gammabb*t16*t169*t17*t242*t25*t328*t65-4.9365923538061685
     8         d-2*t126*t16*t17*t25*t328*t65-4.9365923538061685d-2*gamma
     9         bb*t126*t152*t16*t25*t328*t65+9.873184707612337d-2*t16*t1
     :         7*t242*t25*t325*t65+9.873184707612337d-2*gammabb*t152*t16
     ;         *t242*t25*t325*t65-4.9365923538061685d-2*gammabb*t126*t16
     <         *t169*t25*t299*t65-9.873184707612337d-2*gammabb*t126*t16*
     =         t169*t17*t187*t296*t65-9.873184707612337d-2*t126*t152*t16
     >         *t169*t25*t65+t467*t61*t63-t126*t480*t59*t63-6*t412*t476*
     ?         t59*t63+6*t169*t242*t328*t59*t63-3*t126*t153*t328*t63+6*t
     @         153*t242*t325*t63-3*t126*t169*t300*t63-7.5d-1*t239*t463*t
     1         59*t61/t53**2-5.0d-1*t116*t124*t467*t59*t61-7.5d-1*t233*t
     2         410*t463*t59*t61-3.75d-1*t124*t406*t463*t59*t61+1.5d+0*t1
     3         53*t239*t300*t324*t59*t61+7.5d-1*t124*t153*t233*t300*t59*
     4         t61-8.227653923010281d-3*gammabb*t107*t128*t16*t17*t25*t4
     5         67*t61-1.2341480884515421d-2*gammabb*t16*t17*t245*t25*t46
     6         3*t61/t42**2-1.2341480884515421d-2*gammabb*t16*t17*t223*t
     7         25*t414*t463*t61-6.170740442257711d-3*gammabb*t128*t16*t1
     8         7*t25*t399*t463*t61+1.5d+0*t239*t324*t463*t61+7.5d-1*t124
     9         *t233*t463*t61+2.4682961769030842d-2*gammabb*t153*t16*t17
     :         *t245*t25*t300*t329*t61+2.4682961769030842d-2*t16*t17*t24
     ;         5*t25*t294*t329*t61+2.4682961769030842d-2*gammabb*t152*t1
     <         6*t245*t25*t294*t329*t61+1.2341480884515421d-2*gammabb*t1
     =         28*t153*t16*t17*t223*t25*t300*t61-2.4682961769030842d-2*t
     >         107*t128*t16*t17*t25*t300*t61-2.4682961769030842d-2*gamma
     ?         bb*t107*t128*t152*t16*t25*t300*t61-3*t116*t124*t153*t300*
     @         t61-2.4682961769030842d-2*gammabb*t107*t128*t153*t16*t25*
     1         t299*t61-4.9365923538061685d-2*gammabb*t107*t128*t153*t16
     2         *t17*t187*t296*t61+1.2341480884515421d-2*t128*t16*t17*t22
     3         3*t25*t294*t61+1.2341480884515421d-2*gammabb*t128*t152*t1
     4         6*t223*t25*t294*t61-4.9365923538061685d-2*t107*t128*t152*
     5         t153*t16*t25*t61+1.5d+0*t116*t124*t126*t153*t328*t59-3*t1
     6         16*t124*t153*t242*t325*t59-1.5d+0*t126*t169*t239*t294*t32
     7         4*t59+1.5d+0*t116*t124*t126*t169*t300*t59-7.5d-1*t124*t12
     8         6*t169*t233*t294*t59-2.4682961769030842d-2*gammabb*t126*t
     9         16*t169*t17*t245*t25*t294*t329+2.4682961769030842d-2*gamm
     :         abb*t107*t126*t128*t153*t16*t17*t25*t328-4.93659235380616
     ;         85d-2*gammabb*t107*t128*t153*t16*t17*t242*t25*t325+2.4682
     <         961769030842d-2*gammabb*t107*t126*t128*t16*t169*t17*t25*t
     =         300-1.2341480884515421d-2*gammabb*t126*t128*t16*t169*t17*
     >         t223*t25*t294+3*t116*t124*t126*t169*t294+4.93659235380616
     ?         85d-2*t107*t126*t128*t153*t16*t169*t17*t25+4.936592353806
     @         1685d-2*gammabb*t107*t126*t128*t152*t153*t16*t169*t25)+t1
     1         6*(-3.2910615692041123d-2*gammabb*t17*t465*t52-3.29106156
     2         92041123d-2*gammabb*t151*t299*t52-6.582123138408225d-2*t1
     3         7*t298*t52-6.582123138408225d-2*gammabb*t152*t298*t52-6.5
     4         82123138408225d-2*t151*t152*t52-2*t151*t310-3.29106156920
     5         41123d-2*gammabb*t112*t161*t17*t298-t163*t298-3.291061569
     6         2041123d-2*t112*t151*t161*t17-3.2910615692041123d-2*gamma
     7         bb*t112*t151*t152*t161)*t89+t112*t16*(-t151*t319-6.582123
     8         138408225d-2*gammabb*t151*t17*t318-6.582123138408225d-2*g
     9         ammabb*t161*t17*t298-6.582123138408225d-2*t151*t161*t17-6
     :         .582123138408225d-2*gammabb*t151*t152*t161)*t89+9.8731847
     ;         07612337d-2*gammabb*t151*t16*t17*t212*t308*t89-4.72728888
     <         8888889d-2*t32*t467*t77+t148*(2.6666666666666666d+0*t481*
     =         t72*t75+5.333333333333333d+0*t180*t350*t75+2.666666666666
     >         6666d+0*t174*t348*t75+5.333333333333333d+0*t177*t350*t72+
     ?         2.6666666666666666d+0*t174*t342*t72-3.0d+0*t174*(-1.05465
     @         77777777776d-1*t155*t174*t36+t351+t349+t344+t343+t341)-3.
     1         0d+0*t174*t352-3.0d+0*t181*t350+5.333333333333333d+0*t174
     2         *t177*t180)+t210*(-2.1333333333333332d+1*t174*t350*t72*t7
     3         5-1.0666666666666666d+1*t180*t304*t75-1.0666666666666666d
     4         +1*t177*t304*t72-4.0d+0*t174*t353)+5.333333333333333d+1*t
     5         174**3*t387*t72*t75+t139*t3*(6.764482379964267d-3*t1*t153
     6         *t35*t350+6.764482379964267d-3*t1*t174*t300*t35-2.0d+0*t1
     7         74*t340+6.764482379964267d-3*t1*t153*t155*t174)*t73-2.029
     8         34471398928d-2*t1*t171*t174*t294*t3*t35*t73+t121*(-2.0d+0
     9         *(-1.1067074999999992d-1*t214*t463*t469*t56-7.37804999999
     :         9994d-2*t102*t106*t467*t56-5.533537499999995d-2*t106*t392
     ;         *t463*t56-1.1067074999999992d-1*t216*t390*t463*t56+2.2134
     <         149999999983d-1*t153*t214*t300*t311*t56+1.106707499999999
     =         2d-1*t106*t153*t216*t300*t56-1.475609999999999d-1*t119*(t
     >         479+t478+t477+t475+t474+t473)*t50-8.853659999999993d-1*t1
     ?         66**3*t405*t50+8.853659999999993d-1*t166*t232*t332*t50+2.
     @         2134149999999983d-1*t102*t106*t119*t153*t332-4.4268299999
     1         999966d-1*t102*t106*t153*t232*t331-2.2134149999999983d-1*
     2         t119*t166*t214*t294*t311+2.2134149999999983d-1*t102*t106*
     3         t119*t166*t300-1.1067074999999992d-1*t106*t119*t166*t216*
     4         t294)*t59-6.0d+0*t153*t333-6.0d+0*t167*t300)+t230*(4.0d+0
     5         *t167*t333*t59-t167*t334+2.0d+0*t153*t322)-4.0d+0*t167**3
     6         *t404*t59-2.0d+0*t467*t58+t16*t25*(3.2910615692041123d-2*
     7         gammabb*t466*t52+9.873184707612337d-2*t299*t52+3.29106156
     8         92041123d-2*t112*t17*t318+3.2910615692041123d-2*gammabb*t
     9         112*t152*t318-3.2910615692041123d-2*t17*t212*t308-3.29106
     :         15692041123d-2*gammabb*t152*t212*t308+6.582123138408225d-
     ;         2*gammabb*t112*t161*t299+1.316424627681645d-1*t112*t152*t
     <         161)+t16*t187*(1.316424627681645d-1*gammabb*t151*t17*t298
     =         *t52+6.582123138408225d-2*t17*t296*t52+6.582123138408225d
     >         -2*gammabb*t152*t296*t52-2*t151*t320)-1.9746369415224674d
     ?         -1*gammabb*t16*t17*t365*t464*t52+t112*t16*t25*(3.29106156
     @         92041123d-2*gammabb*t17*(6.0965d-1*t110*(t475+t474+t473+t
     1         472+t471+t470)*t50+3.6579d+0*t160**3*t398*t50-3.6579d+0*t
     2         160*t222*t317*t50+4.572375d-1*t214*t463*t469*t47+3.04825d
     3         -1*t102*t106*t467*t47+2.2861875d-1*t106*t392*t463*t47+4.5
     4         72375d-1*t216*t390*t463*t47-9.14475d-1*t153*t214*t300*t31
     5         1*t47-4.572375d-1*t106*t153*t216*t300*t47-9.14475d-1*t102
     6         *t106*t110*t153*t317+1.82895d+0*t102*t106*t153*t222*t312+
     7         9.14475d-1*t110*t160*t214*t294*t311-9.14475d-1*t102*t106*
     8         t110*t160*t300+4.572375d-1*t106*t110*t160*t216*t294)+6.58
     9         2123138408225d-2*t17*t318+6.582123138408225d-2*gammabb*t1
     :         52*t318+3.2910615692041123d-2*gammabb*t161*t299+6.5821231
     ;         38408225d-2*t152*t161)+5.273288888888887d-2*t36*t38*t468+
     <         t139*t3*t38*(-3.3822411899821336d-3*t1*t35*t467-1.0146723
     =         5699464d-2*t1*t153*t302-1.01467235699464d-2*t1*t155*t300)
     >         +6.064083168526658d-3*t1*t137*t171*t3*t467-1.166834909156
     ?         0873d-2*t207*t39*t40*t460*t463+8.641318515150488d-2*t1*t1
     @         37*t3*t439*t463+5.987181320518676d-4*t1**3*t385*t463/(rho
     1         b*t29**11)-1.2683404462433d-2*t1*t284*t3*t35*t38*t463-2.8
     2         363733333333335d-1*t32*t335*t463+4.667339636624349d-3*t15
     3         3*t207*t300*t335*t39*t40+6.582123138408225d-2*gammabb*t16
     4         *t161**3*t17*t25*t388+t171*t3*(1.01467235699464d-2*t1*t15
     5         3*t300*t35+5.0733617849732d-3*t1*t155*t294)*t38-1.5d+0*t1
     6         53*t171*t3*t340*t38-2.02934471398928d-2*t1*t139*t148*t153
     7         *t3*t304*t35+2.8363733333333335d-1*t153*t203*t300*t32+t16
     8         *t212*t25*(-t161*t319-6.582123138408225d-2*gammabb*t161*t
     9         17*t318-3.2910615692041123d-2*t17*t308-3.2910615692041123
     :         d-2*gammabb*t152*t308)-6.367287326952992d-2*t1*t137*t153*
     ;         t284*t3*t300+1.9746369415224674d-1*gammabb*t112*t16*t161*
     <         t17*t187*t296)*wght
          endif ! rhoa.gt.tol_rho.and.rhob.gt.tol_rho 
        endif ! ipol.eq.1 
      enddo ! iq 
      end 
C> @} 
