<!--- SPDX-License-Identifier: Apache-2.0 -->
## Operator Changelog
*This file is automatically generated from the
            [def files](/onnx/defs) via [this script](/onnx/defs/gen_doc.py).
            Do not modify directly and instead edit operator definitions.*

For an operator input/output's differentiability, it can be differentiable,
            non-differentiable, or undefined. If a variable's differentiability
            is not specified, that variable has undefined differentiability.

# ai.onnx (default)
## Version 1 of the default ONNX operator set
### <a name="Abs-1"></a>**Abs-1**</a>

  Absolute takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the absolute is, y = abs(x), is applied to
  the tensor elementwise.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Add-1"></a>**Add-1**</a>

  Performs element-wise binary addition (with limited broadcast support).

  If necessary the right-hand-side argument will be broadcasted to match the
  shape of left-hand-side argument. When broadcasting is specified, the second
  tensor can either be of element size 1 (including a scalar tensor and any
  tensor with rank equal to or smaller than the first tensor), or having its
  shape as a contiguous subset of the first tensor's shape. The starting of the
  mutually equal shape is specified by the argument "axis", and if it is not set,
  suffix matching is assumed. 1-dim expansion doesn't work yet.

  For example, the following tensor shapes are supported (with broadcast=1):

    shape(A) = (2, 3, 4, 5), shape(B) = (,), i.e. B is a scalar tensor
    shape(A) = (2, 3, 4, 5), shape(B) = (1, 1), i.e. B is an 1-element tensor
    shape(A) = (2, 3, 4, 5), shape(B) = (5,)
    shape(A) = (2, 3, 4, 5), shape(B) = (4, 5)
    shape(A) = (2, 3, 4, 5), shape(B) = (3, 4), with axis=1
    shape(A) = (2, 3, 4, 5), shape(B) = (2), with axis=0

  Attribute `broadcast=1` needs to be passed to enable broadcasting.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int</dt>
<dd>If set, defines the broadcast dimensions. See doc for details.</dd>
<dt><tt>broadcast</tt> : int (default is 0)</dt>
<dd>Pass 1 to enable broadcasting</dd>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>First operand, should share the type with the second operand.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Second operand. With broadcasting can be of smaller size than A. If broadcasting is disabled it should be of the same size.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T</dt>
<dd>Result, has same dimensions and type as A</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="And-1"></a>**And-1**</a>

  Returns the tensor resulted from performing the `and` logical operation
  elementwise on the input tensors `A` and `B`.

  If broadcasting is enabled, the right-hand-side argument will be broadcasted
  to match the shape of left-hand-side argument. See the doc of `Add` for a
  detailed description of the broadcasting rules.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int</dt>
<dd>If set, defines the broadcast dimensions.</dd>
<dt><tt>broadcast</tt> : int (default is 0)</dt>
<dd>Enable broadcasting</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>Left input tensor for the logical operator.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Right input tensor for the logical operator.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T1</dt>
<dd>Result tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(bool)</dt>
<dd>Constrain input to boolean tensor.</dd>
<dt><tt>T1</tt> : tensor(bool)</dt>
<dd>Constrain output to boolean tensor.</dd>
</dl>

### <a name="ArgMax-1"></a>**ArgMax-1**</a>

  Computes the indices of the max elements of the input tensor's element along the
  provided axis. The resulting tensor has the same rank as the input if keepdims equals 1.
  If keepdims equal 0, then the resulted tensor have the reduced dimension pruned.
  The type of the output tensor is integer.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 0)</dt>
<dd>The axis in which to compute the arg indices.</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : tensor(int64)</dt>
<dd>Reduced output tensor with integer data type.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to all numeric tensors.</dd>
</dl>

### <a name="ArgMin-1"></a>**ArgMin-1**</a>

  Computes the indices of the min elements of the input tensor's element along the
  provided axis. The resulting tensor has the same rank as the input if keepdims equals 1.
  If keepdims equal 0, then the resulted tensor have the reduced dimension pruned.
  The type of the output tensor is integer.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 0)</dt>
<dd>The axis in which to compute the arg indices.</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : tensor(int64)</dt>
<dd>Reduced output tensor with integer data type.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to all numeric tensors.</dd>
</dl>

### <a name="AveragePool-1"></a>**AveragePool-1**</a>

  AveragePool consumes an input tensor X and applies average pooling across
   the tensor according to kernel sizes, stride sizes, and pad lengths.
   average pooling consisting of computing the average on all values of a
   subset of the input tensor according to the kernel size and downsampling the
   data into the output tensor Y for further processing. The output spatial shape will be following:
   ```
   output_spatial_shape[i] = floor((input_spatial_shape[i] + pad_shape[i] - kernel_spatial_shape[i]) / strides_spatial_shape[i] + 1)

   * pad_shape[i] is sum of pads along axis i
   ```

   `auto_pad` is a DEPRECATED attribute. If you are using them currently, the output spatial shape will be following:
   ```
   VALID: output_spatial_shape[i] = ceil((input_spatial_shape[i] - kernel_spatial_shape[i] + 1) / strides_spatial_shape[i])
   SAME_UPPER or SAME_LOWER: output_spatial_shape[i] = ceil(input_spatial_shape[i] / strides_spatial_shape[i])
   ```
   And pad shape will be following if `SAME_UPPER` or `SAME_LOWER`:
   ```
   pad_shape[i] = (output_spatial_shape[i] - 1) * strides_spatial_shape[i] + kernel_spatial_shape[i] - input_spatial_shape[i]
   ```
   The output of each pooling window is divided by the number of elements exclude pad.


#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>auto_pad</tt> : string (default is NOTSET)</dt>
<dd>auto_pad must be either NOTSET, SAME_UPPER, SAME_LOWER or VALID. Where default value is NOTSET, which means explicit padding is used. SAME_UPPER or SAME_LOWER mean pad the input so that the output spatial size match the input.In case of odd number add the extra padding at the end for SAME_UPPER and at the beginning for SAME_LOWER. VALID mean no padding.</dd>
<dt><tt>kernel_shape</tt> : list of ints (required)</dt>
<dd>The size of the kernel along each axis.</dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd>Padding for the beginning and ending along each spatial axis, it can take any value greater than or equal to 0. The value represent the number of pixels added to the beginning and end part of the corresponding axis. `pads` format should be as follow [x1_begin, x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels added at the beginning of axis `i` and xi_end, the number of pixels added at the end of axis `i`. This attribute cannot be used simultaneously with auto_pad attribute. If not present, the padding defaults to 0 along start and end of each spatial axis.</dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd>Stride along each spatial axis.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input data tensor from the previous operator; dimensions for image case are (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data. For non image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size. Optionally, if dimension denotation is in effect, the operation expects the input data tensor to arrive with the dimension denotation of [DATA_BATCH, DATA_CHANNEL, DATA_FEATURE, DATA_FEATURE ...].</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output data tensor from average or max pooling across the input tensor. Dimensions will vary based on various kernel, stride, and pad sizes. Floor value of the dimension is used</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="BatchNormalization-1"></a>**BatchNormalization-1**</a>

  Carries out batch normalization as described in the paper
  https://arxiv.org/abs/1502.03167. Depending on the mode it is being run,
  there are multiple cases for the number of outputs, which we list below:

  Output case #1: Y, mean, var, saved_mean, saved_var (training mode)
  Output case #2: Y (test mode)


#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>consumed_inputs</tt> : list of ints (required)</dt>
<dd>legacy optimization attribute.</dd>
<dt><tt>epsilon</tt> : float (default is 1e-05)</dt>
<dd>The epsilon value to use to avoid division by zero, default is 1e-5f.</dd>
<dt><tt>is_test</tt> : int (default is 0)</dt>
<dd>If set to nonzero, run spatial batch normalization in test mode, default is 0.</dd>
<dt><tt>momentum</tt> : float (default is 0.9)</dt>
<dd>Factor used in computing the running mean and variance.e.g., running_mean = running_mean * momentum + mean * (1 - momentum), default is 0.9f.</dd>
<dt><tt>spatial</tt> : int (default is 1)</dt>
<dd>If true, compute the mean and variance across all spatial elements If false, compute the mean and variance across per feature.Default is 1.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>The input 4-dimensional tensor of shape NCHW.</dd>
<dt><tt>scale</tt> : T</dt>
<dd>The scale as a 1-dimensional tensor of size C to be applied to the output.</dd>
<dt><tt>B</tt> : T</dt>
<dd>The bias as a 1-dimensional tensor of size C to be applied to the output.</dd>
<dt><tt>mean</tt> : T</dt>
<dd>The running mean (training) or the estimated mean (testing) as a 1-dimensional tensor of size C.</dd>
<dt><tt>var</tt> : T</dt>
<dd>The running variance (training) or the estimated variance (testing) as a 1-dimensional tensor of size C.</dd>
</dl>

#### Outputs (1 - 5)

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>The output 4-dimensional tensor of the same shape as X.</dd>
<dt><tt>mean</tt> (optional) : T</dt>
<dd>The running mean after the BatchNormalization operator. Must be in-place with the input mean. Should not be used for testing.</dd>
<dt><tt>var</tt> (optional) : T</dt>
<dd>The running variance after the BatchNormalization operator. Must be in-place with the input var. Should not be used for testing.</dd>
<dt><tt>saved_mean</tt> (optional) : T</dt>
<dd>Saved mean used during training to speed up gradient computation. Should not be used for testing.</dd>
<dt><tt>saved_var</tt> (optional) : T</dt>
<dd>Saved variance used during training to speed up gradient computation. Should not be used for testing.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Cast-1"></a>**Cast-1**</a>

  The operator casts the elements of a given input tensor to a data type
  specified by the 'to' argument and returns an output tensor of the same size in
  the converted type. The 'to' argument must be one of the data types specified
  in the 'DataType' enum field in the TensorProto message.
  NOTE: Casting to and from strings is not supported yet.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>to</tt> : string (required)</dt>
<dd>The data type to which the elements of the input tensor are cast. Strictly must be one of the types from DataType enum in TensorProto</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T1</dt>
<dd>Input tensor to be cast.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T2</dt>
<dd>Output tensor with the same shape as input with type specified by the 'to' argument</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float16), tensor(float), tensor(double), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(bool)</dt>
<dd>Constrain input types. Casting from strings and complex are not supported.</dd>
<dt><tt>T2</tt> : tensor(float16), tensor(float), tensor(double), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(bool)</dt>
<dd>Constrain output types. Casting to strings and complex are not supported.</dd>
</dl>

### <a name="Ceil-1"></a>**Ceil-1**</a>

  Ceil takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the ceil is, y = ceil(x), is applied to
  the tensor elementwise.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Clip-1"></a>**Clip-1**</a>

  Clip operator limits the given input within an interval. The interval is
  specified with arguments 'min' and 'max'. They default to
  numeric_limits::lowest() and numeric_limits::max() respectively.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
<dt><tt>max</tt> : float</dt>
<dd>Maximum value, above which element is replaced by max</dd>
<dt><tt>min</tt> : float</dt>
<dd>Minimum value, under which element is replaced by min</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>Input tensor whose elements to be clipped</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Output tensor with clipped input elements</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Concat-1"></a>**Concat-1**</a>

  Concatenate a list of tensors into a single tensor

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int</dt>
<dd>Which axis to concat on.  Default value is 1.</dd>
</dl>

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>inputs</tt> (variadic) : T</dt>
<dd>List of tensors for concatenation</dd>
</dl>

#### Outputs

<dl>
<dt><tt>concat_result</tt> : T</dt>
<dd>Concatenated tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain output types to float tensors.</dd>
</dl>

### <a name="Constant-1"></a>**Constant-1**</a>

  A constant tensor.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>value</tt> : tensor (required)</dt>
<dd>The value for the elements of the output tensor.</dd>
</dl>

#### Inputs


#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Output tensor containing the same value of the provided tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Conv-1"></a>**Conv-1**</a>

  The convolution operator consumes an input tensor and a filter, and
  computes the output.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>auto_pad</tt> : string (default is NOTSET)</dt>
<dd>auto_pad must be either NOTSET, SAME_UPPER, SAME_LOWER or VALID. Where default value is NOTSET, which means explicit padding is used. SAME_UPPER or SAME_LOWER mean pad the input so that the output spatial size match the input.In case of odd number add the extra padding at the end for SAME_UPPER and at the beginning for SAME_LOWER. VALID mean no padding.</dd>
<dt><tt>dilations</tt> : list of ints</dt>
<dd>dilation value along each spatial axis of the filter.</dd>
<dt><tt>group</tt> : int (default is 1)</dt>
<dd>number of groups input channels and output channels are divided into.</dd>
<dt><tt>kernel_shape</tt> : list of ints</dt>
<dd>The shape of the convolution kernel. If not present, should be inferred from input W.</dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd>Padding for the beginning and ending along each spatial axis, it can take any value greater than or equal to 0. The value represent the number of pixels added to the beginning and end part of the corresponding axis. `pads` format should be as follow [x1_begin, x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels added at the beginning of axis `i` and xi_end, the number of pixels added at the end of axis `i`. This attribute cannot be used simultaneously with auto_pad attribute. If not present, the padding defaults to 0 along start and end of each spatial axis.</dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd>Stride along each spatial axis.</dd>
</dl>

#### Inputs (2 - 3)

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input data tensor from previous layer; has size (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and width. Note that this is for the 2D image. Otherwise the size is (N x C x D1 x D2 ... x Dn). Optionally, if dimension denotation is in effect, the operation expects input data tensor to arrive with the dimension denotation of [DATA_BATCH, DATA_CHANNEL, DATA_FEATURE, DATA_FEATURE ...].</dd>
<dt><tt>W</tt> : T</dt>
<dd>The weight tensor that will be used in the convolutions; has size (M x C/group x kH x kW), where C is the number of channels, and kH and kW are the height and width of the kernel, and M is the number of feature maps. For more than 2 dimensions, the kernel shape will be (M x C/group x k1 x k2 x ... x kn), where (k1 x k2 x ... kn) is the dimension of the kernel. Optionally, if dimension denotation is in effect, the operation expects the weight tensor to arrive with the dimension denotation of [FILTER_OUT_CHANNEL, FILTER_IN_CHANNEL, FILTER_SPATIAL, FILTER_SPATIAL ...]. X.shape[1] == (W.shape[1] * group) == C (assuming zero based indices for the shape array). Or in other words FILTER_IN_CHANNEL should be equal to DATA_CHANNEL. </dd>
<dt><tt>B</tt> (optional) : T</dt>
<dd>Optional 1D bias to be added to the convolution, has size of M.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output data tensor that contains the result of the convolution. The output dimensions are functions of the kernel size, stride size, and pad lengths.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="ConvTranspose-1"></a>**ConvTranspose-1**</a>

  The convolution transpose operator consumes an input tensor and a filter,
  and computes the output.

  If the pads parameter is provided the shape of the output is calculated via the following equation:

    output_shape[i] = stride[i] * (input_size[i] - 1) + output_padding[i] + ((kernel_shape[i] - 1) * dilations[i] + 1) - pads[start_i] - pads[end_i]

  output_shape can also be explicitly specified in which case pads values are auto generated using these equations:

    total_padding[i] = stride[i] * (input_size[i] - 1) + output_padding[i] + ((kernel_shape[i] - 1) * dilations[i] + 1) - output_shape[i]
    If (auto_pads != SAME_UPPER): pads[start_i] = total_padding[i]/2; pads[end_i] = total_padding[i] - (total_padding[i]/2)
    Else: pads[start_i] = total_padding[i] - (total_padding[i]/2); pads[end_i] = (total_padding[i]/2).



#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>auto_pad</tt> : string (default is NOTSET)</dt>
<dd>auto_pad must be either NOTSET, SAME_UPPER, SAME_LOWER or VALID. Where default value is NOTSET, which means explicit padding is used. SAME_UPPER or SAME_LOWER mean pad the input so that the output spatial size match the input.In case of odd number add the extra padding at the end for SAME_UPPER and at the beginning for SAME_LOWER. VALID mean no padding.</dd>
<dt><tt>dilations</tt> : list of ints</dt>
<dd>dilation value along each spatial axis of the filter.</dd>
<dt><tt>group</tt> : int (default is 1)</dt>
<dd>number of groups input channels and output channels are divided into.</dd>
<dt><tt>kernel_shape</tt> : list of ints</dt>
<dd>The shape of the convolution kernel. If not present, should be inferred from input W.</dd>
<dt><tt>output_padding</tt> : list of ints</dt>
<dd>The zero-padding added to one side of the output. This is also called adjs/adjustment in some frameworks.</dd>
<dt><tt>output_shape</tt> : list of ints</dt>
<dd>The shape of the output can be explicitly set which will cause pads values to be auto generated. If output_shape is specified pads values are ignored. See doc for details for equations to generate pads</dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd>Padding for the beginning and ending along each spatial axis, it can take any value greater than or equal to 0. The value represent the number of pixels added to the beginning and end part of the corresponding axis. `pads` format should be as follow [x1_begin, x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels added at the beginning of axis `i` and xi_end, the number of pixels added at the end of axis `i`. This attribute cannot be used simultaneously with auto_pad attribute. If not present, the padding defaults to 0 along start and end of each spatial axis.</dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd>Stride along each spatial axis.</dd>
</dl>

#### Inputs (2 - 3)

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input data tensor from previous layer; has size (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and width. Note that this is for the 2D image. Otherwise the size is (N x C x D1 x D2 ... x Dn)</dd>
<dt><tt>W</tt> : T</dt>
<dd>The weight tensor that will be used in the convolutions; has size (C x M/group x kH x kW), where C is the number of channels, and kH and kW are the height and width of the kernel, and M is the number of feature maps. For more than 2 dimensions, the weight shape will be (C x M/group x k1 x k2 x ... x kn), where (k1 x k2 x ... x kn) is the dimension of the kernel. The number of channels in the output should be equal to W.shape[1] * group (assuming zero based indices of the shape array)</dd>
<dt><tt>B</tt> (optional) : T</dt>
<dd>Optional 1D bias to be added to the convolution, has size of M.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output data tensor that contains the result of the convolution. The output dimensions are functions of the kernel size, stride size, pad lengths and group count. The number of channels in the output should be equal to W.shape[1] * group (assuming zero based indices of the shape array)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="DepthToSpace-1"></a>**DepthToSpace-1**</a>

  DepthToSpace rearranges (permutes) data from depth into blocks of spatial data.
  This is the reverse transformation of SpaceToDepth. More specifically, this op outputs a copy of
  the input tensor where values from the depth dimension are moved in spatial blocks to the height
  and width dimensions.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>blocksize</tt> : int (required)</dt>
<dd>Blocks of [blocksize, blocksize] are moved.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>Input tensor of [N,C,H,W], where N is the batch axis, C is the channel or depth, H is the height and W is the width.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Output tensor of [N, C/(blocksize * blocksize), H * blocksize, W * blocksize].</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

### <a name="Div-1"></a>**Div-1**</a>

  Performs element-wise binary division (with limited broadcast support).

  If necessary the right-hand-side argument will be broadcasted to match the
  shape of left-hand-side argument. When broadcasting is specified, the second
  tensor can either be of element size 1 (including a scalar tensor and any
  tensor with rank equal to or smaller than the first tensor), or having its
  shape as a contiguous subset of the first tensor's shape. The starting of the
  mutually equal shape is specified by the argument "axis", and if it is not set,
  suffix matching is assumed. 1-dim expansion doesn't work yet.

  For example, the following tensor shapes are supported (with broadcast=1):

    shape(A) = (2, 3, 4, 5), shape(B) = (,), i.e. B is a scalar tensor
    shape(A) = (2, 3, 4, 5), shape(B) = (1, 1), i.e. B is an 1-element tensor
    shape(A) = (2, 3, 4, 5), shape(B) = (5,)
    shape(A) = (2, 3, 4, 5), shape(B) = (4, 5)
    shape(A) = (2, 3, 4, 5), shape(B) = (3, 4), with axis=1
    shape(A) = (2, 3, 4, 5), shape(B) = (2), with axis=0

  Attribute `broadcast=1` needs to be passed to enable broadcasting.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int</dt>
<dd>If set, defines the broadcast dimensions. See doc for details.</dd>
<dt><tt>broadcast</tt> : int (default is 0)</dt>
<dd>Pass 1 to enable broadcasting</dd>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>First operand, should share the type with the second operand.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Second operand. With broadcasting can be of smaller size than A. If broadcasting is disabled it should be of the same size.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T</dt>
<dd>Result, has same dimensions and type as A</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Dropout-1"></a>**Dropout-1**</a>

  Dropout takes one input data (Tensor<float>) and produces two Tensor outputs,
  output (Tensor<float>) and mask (Tensor<bool>). Depending on whether it is in
  test mode or not, the output Y will either be a random dropout, or a simple
  copy of the input. Note that our implementation of Dropout does scaling in
  the training phase, so during testing nothing needs to be done.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
<dt><tt>is_test</tt> : int (default is 0)</dt>
<dd>(int, default 0) if nonzero, run dropout in test mode where the output is simply Y = X.</dd>
<dt><tt>ratio</tt> : float (default is 0.5)</dt>
<dd>(float, default 0.5) the ratio of random dropout</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>The input data as Tensor.</dd>
</dl>

#### Outputs (1 - 2)

<dl>
<dt><tt>output</tt> : T</dt>
<dd>The output.</dd>
<dt><tt>mask</tt> (optional) : T</dt>
<dd>The output mask. If is_test is nonzero, this output is not filled.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Elu-1"></a>**Elu-1**</a>

  Elu takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the function `f(x) = alpha * (exp(x) - 1.) for x <
  0`, `f(x) = x for x >= 0`., is applied to the tensor elementwise.


#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float (default is 1.0)</dt>
<dd>Coefficient of ELU default to 1.0.</dd>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>1D input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>1D input tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Equal-1"></a>**Equal-1**</a>

  Returns the tensor resulted from performing the `equal` logical operation
  elementwise on the input tensors `A` and `B`.

  If broadcasting is enabled, the right-hand-side argument will be broadcasted
  to match the shape of left-hand-side argument. See the doc of `Add` for a
  detailed description of the broadcasting rules.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int</dt>
<dd>If set, defines the broadcast dimensions.</dd>
<dt><tt>broadcast</tt> : int (default is 0)</dt>
<dd>Enable broadcasting</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>Left input tensor for the logical operator.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Right input tensor for the logical operator.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T1</dt>
<dd>Result tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(bool), tensor(int32), tensor(int64)</dt>
<dd>Constrain input to integral tensors.</dd>
<dt><tt>T1</tt> : tensor(bool)</dt>
<dd>Constrain output to boolean tensor.</dd>
</dl>

### <a name="Exp-1"></a>**Exp-1**</a>

  Calculates the exponential of the given input tensor, element-wise.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>The exponential of the input tensor computed element-wise</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Flatten-1"></a>**Flatten-1**</a>

  Flattens the input tensor into a 2D matrix. If input tensor has shape
  (d_0, d_1, ... d_n) then the output will have shape
  (d_0 X d_1 ... d_(axis-1), d_axis X d_(axis+1) ... X dn).

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 1)</dt>
<dd>Indicate up to which input dimensions (exclusive) should be flattened to the outer dimension of the output. The value for axis must be in the range [0, R], where R is the rank of the input tensor. When axis = 0, the shape of the output tensor is (1, (d_0 X d_1 ... d_n), where the shape of the input tensor is (d_0, d_1, ... d_n). </dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>A tensor of rank >= axis.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>A 2D tensor with the contents of the input tensor, with input dimensions up to axis flattened to the outer dimension of the output and remaining input dimensions flattened into the inner dimension of the output.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Floor-1"></a>**Floor-1**</a>

  Floor takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the floor is, y = floor(x), is applied to
  the tensor elementwise.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="GRU-1"></a>**GRU-1**</a>

  Computes an one-layer GRU. This operator is usually supported via some custom
  implementation such as CuDNN.

  Notations:

  `X` - input tensor

  `z` - update gate

  `r` - reset gate

  `h` - hidden gate

  `t` - time step (t-1 means previous time step)

  `W[zrh]` - W parameter weight matrix for update, reset, and hidden gates

  `R[zrh]` - R recurrence weight matrix for update, reset, and hidden gates

  `Wb[zrh]` - W bias vectors for update, reset, and hidden gates

  `Rb[zrh]` - R bias vectors for update, reset, and hidden gates

  `WB[zrh]` - W parameter weight matrix for backward update, reset, and hidden gates

  `RB[zrh]` - R recurrence weight matrix for backward update, reset, and hidden gates

  `WBb[zrh]` - W bias vectors for backward update, reset, and hidden gates

  `RBb[zrh]` - R bias vectors for backward update, reset, and hidden gates

  `H` - Hidden state

  `num_directions` - 2 if direction == bidirectional else 1

  Activation functions:

    Relu(x)                - max(0, x)

    Tanh(x)                - (1 - e^{-2x})/(1 + e^{-2x})

    Sigmoid(x)             - 1/(1 + e^{-x})

    (NOTE: Below are optional)

    Affine(x)              - alpha*x + beta

    LeakyRelu(x)           - x if x >= 0 else alpha * x

    ThresholdedRelu(x)     - x if x >= alpha else 0

    ScaledTanh(x)          - alpha*Tanh(beta*x)

    HardSigmoid(x)         - min(max(alpha*x + beta, 0), 1)

    Elu(x)                 - x if x >= 0 else alpha*(e^x - 1)

    Softsign(x)            - x/(1 + |x|)

    Softplus(x)            - log(1 + e^x)

  Equations (Default: f=Sigmoid, g=Tanh):

    - zt = f(Xt*(Wz^T) + Ht-1*Rz + Wbz + Rbz)

    - rt = f(Xt*(Wr^T) + Ht-1*Rr + Wbr + Rbr)

    - ht = g(Xt*(Wh^T) + (rt (.) Ht-1)*Rh + Rbh + Wbh) # default, when linear_before_reset = 0

    - ht = g(Xt*(Wh^T) + (rt (.) (Ht-1*Rh + Rbh) + Wbh) # when linear_before_reset != 0

    - Ht = (1 - zt) (.) ht + zt (.) Ht-1

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>activation_alpha</tt> : list of floats</dt>
<dd>Optional scaling values used by some activation functions. The values are consumed in the order of activation functions, for example (f, g, h) in LSTM.</dd>
<dt><tt>activation_beta</tt> : list of floats</dt>
<dd>Optional scaling values used by some activation functions. The values are consumed in the order of activation functions, for example (f, g, h) in LSTM.</dd>
<dt><tt>activations</tt> : list of strings</dt>
<dd>A list of 2 (or 4 if bidirectional) activation functions for update, reset, and hidden gates. The activation functions must be one of the activation functions specified above. Optional: See the equations for default if not specified.</dd>
<dt><tt>clip</tt> : float</dt>
<dd>Cell clip threshold. Clipping bounds the elements of a tensor in the range of [-threshold, +threshold] and is applied to the input of activations. No clip if not specified.</dd>
<dt><tt>direction</tt> : string (default is foward)</dt>
<dd>Specify if the RNN is forward, reverse, or bidirectional. Must be one of forward (default), reverse, or bidirectional.</dd>
<dt><tt>hidden_size</tt> : int</dt>
<dd>Number of neurons in the hidden layer</dd>
<dt><tt>output_sequence</tt> : int (default is 0)</dt>
<dd>The sequence output for the hidden is optional if 0. Default 0.</dd>
</dl>

#### Inputs (3 - 6)

<dl>
<dt><tt>X</tt> : T</dt>
<dd>The input sequences packed (and potentially padded) into one 3-D tensor with the shape of `[seq_length, batch_size, input_size]`.</dd>
<dt><tt>W</tt> : T</dt>
<dd>The weight tensor for the gates. Concatenation of `W[zrh]` and `WB[zrh]` (if bidirectional) along dimension 0. This tensor has shape `[num_directions, 3*hidden_size, input_size]`.</dd>
<dt><tt>R</tt> : T</dt>
<dd>The recurrence weight tensor. Concatenation of `R[zrh]` and `RB[zrh]` (if bidirectional) along dimension 0. This tensor has shape `[num_directions, 3*hidden_size, hidden_size]`.</dd>
<dt><tt>B</tt> (optional) : T</dt>
<dd>The bias tensor for the gates. Concatenation of `[Wb[zrh], Rb[zrh]]` and `[WBb[zrh], RBb[zrh]]` (if bidirectional) along dimension 0. This tensor has shape `[num_directions, 6*hidden_size]`. Optional: If not specified - assumed to be 0</dd>
<dt><tt>sequence_lens</tt> (optional) : T1</dt>
<dd>Optional tensor specifying lengths of the sequences in a batch. If not specified - assumed all sequences in the batch to have length `seq_length`. It has shape `[batch_size]`.</dd>
<dt><tt>initial_h</tt> (optional) : T</dt>
<dd>Optional initial value of the hidden. If not specified - assumed to be 0. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (optional) : T</dt>
<dd>A tensor that concats all the intermediate output values of the hidden. It has shape `[seq_length, num_directions, batch_size, hidden_size]`. It is optional if `output_sequence` is 0.</dd>
<dt><tt>Y_h</tt> : T</dt>
<dd>The last output value of the hidden. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T1</tt> : tensor(int32)</dt>
<dd>Constrain seq_lens to integer tensor.</dd>
</dl>

### <a name="Gather-1"></a>**Gather-1**</a>

  Given `data` tensor of rank r >= 1, and `indices` tensor of rank q, gather
  entries of the axis dimension of `data` (by default outer-most one as axis=0) indexed by `indices`, and concatenates
  them in an output tensor of rank q + (r - 1).
  Example 1:
  ```
    data = [
        [1.0, 1.2],
        [2.3, 3.4],
        [4.5, 5.7],
    ]
    indices = [
        [0, 1],
        [1, 2],
    ]
    output = [
        [
            [1.0, 1.2],
            [2.3, 3.4],
        ],
        [
            [2.3, 3.4],
            [4.5, 5.7],
        ],
    ]
  ```
  Example 2:
  ```
    data = [
        [1.0, 1.2, 1.9],
        [2.3, 3.4, 3.9],
        [4.5, 5.7, 5.9],
    ]
    indices = [
        [0, 2],
    ]
    axis = 1,
    output = [
        [
            [1.0, 1.9],
            [2.3, 3.9],
            [4.5, 5.9],
        ],
    ]
  ```

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 0)</dt>
<dd>Which axis to gather on. Negative value means counting dimensions from the back. Accepted range is [-r, r-1]</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>Tensor of rank r >= 1.</dd>
<dt><tt>indices</tt> : Tind</dt>
<dd>Tensor of int32/int64 indices, of any rank q. All index values are expected to be within bounds. It is an error if any of the index values are out of bounds.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Tensor of rank q + (r - 1).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to any tensor type.</dd>
<dt><tt>Tind</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain indices to integer types</dd>
</dl>

### <a name="Gemm-1"></a>**Gemm-1**</a>

  General Matrix multiplication:
  https://en.wikipedia.org/wiki/Basic_Linear_Algebra_Subprograms#Level_3
  Compute Y = alpha * A * B + beta * C, where input tensor A has
  dimension (M X K), input tensor B has dimension (K X N), input tensor C and
  output tensor Y have dimension (M X N).
  If attribute broadcast is non-zero, input tensor C will be broadcasted to match
  the dimension requirement. A will be transposed before doing the computation
  if attribute transA is non-zero, same for B and transB.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float (default is 1.0)</dt>
<dd>Scalar multiplier for the product of input tensors A * B, the default value is 1.0.</dd>
<dt><tt>beta</tt> : float (default is 1.0)</dt>
<dd>Scalar multiplier for input tensor C, the default value is 1.0.</dd>
<dt><tt>broadcast</tt> : int (default is 0)</dt>
<dd>Whether C should be broadcasted</dd>
<dt><tt>transA</tt> : int (default is 0)</dt>
<dd>Whether A should be transposed</dd>
<dt><tt>transB</tt> : int (default is 0)</dt>
<dd>Whether B should be transposed</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>Input tensor A</dd>
<dt><tt>B</tt> : T</dt>
<dd>Input tensor B</dd>
<dt><tt>C</tt> : T</dt>
<dd>Input tensor C, can be inplace.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="GlobalAveragePool-1"></a>**GlobalAveragePool-1**</a>

  GlobalAveragePool consumes an input tensor X and applies average pooling across
   the values in the same channel. This is equivalent to AveragePool with kernel size
   equal to the spatial dimension of input tensor.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input data tensor from the previous operator; dimensions for image case are (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data. For non image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output data tensor from pooling across the input tensor. The output tensor has the same rank as the input. The first two dimensions of output shape are the same as the input (N x C), while the other dimensions are all 1.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="GlobalLpPool-1"></a>**GlobalLpPool-1**</a>

  GlobalLpPool consumes an input tensor X and applies lp pool pooling across the
   the values in the same channel. This is equivalent to LpPool with kernel size
   equal to the spatial dimension of input tensor.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>p</tt> : float (default is 2.0)</dt>
<dd>p value of the Lp norm used to pool over the input data, default is 2.0.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input data tensor from the previous operator; dimensions for image case are (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data. For non image case, the dimension are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output data tensor from pooling across the input tensor. Dimensions will be N x C x 1 x 1</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="GlobalMaxPool-1"></a>**GlobalMaxPool-1**</a>

  GlobalMaxPool consumes an input tensor X and applies max pooling across
   the values in the same channel. This is equivalent to MaxPool with kernel size
   equal to the spatial dimension of input tensor.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input data tensor from the previous operator; dimensions for image case are (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data. For non image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output data tensor from pooling across the input tensor. The output tensor has the same rank as the input. The first two dimensions of output shape are the same as the input (N x C), while the other dimensions are all 1.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Greater-1"></a>**Greater-1**</a>

  Returns the tensor resulted from performing the `greater` logical operation
  elementwise on the input tensors `A` and `B`.

  If broadcasting is enabled, the right-hand-side argument will be broadcasted
  to match the shape of left-hand-side argument. See the doc of `Add` for a
  detailed description of the broadcasting rules.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int</dt>
<dd>If set, defines the broadcast dimensions.</dd>
<dt><tt>broadcast</tt> : int (default is 0)</dt>
<dd>Enable broadcasting</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>Left input tensor for the logical operator.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Right input tensor for the logical operator.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T1</dt>
<dd>Result tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input to float tensors.</dd>
<dt><tt>T1</tt> : tensor(bool)</dt>
<dd>Constrain output to boolean tensor.</dd>
</dl>

### <a name="HardSigmoid-1"></a>**HardSigmoid-1**</a>

  HardSigmoid takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the HardSigmoid function, y = max(0, min(1, alpha * x + beta)),
  is applied to the tensor elementwise.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float (default is 0.2)</dt>
<dd>Value of alpha default to 0.2</dd>
<dt><tt>beta</tt> : float (default is 0.5)</dt>
<dd>Value of beta default to 0.5</dd>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Hardmax-1"></a>**Hardmax-1**</a>

  The operator computes the hardmax (1 for the first maximum value, and 0 for all others) values for each layer in the batch
   of the given input. The input is a 2-D tensor (Tensor<float>) of size
  (batch_size x input_feature_dimensions). The output tensor has the same shape
  and contains the hardmax values of the corresponding input.

  Input does not need to explicitly be a 2D vector; rather, it will be
  coerced into one. For an arbitrary n-dimensional tensor
  input \in [a_0, a_1, ..., a_{k-1}, a_k, ..., a_{n-1}] and k is
  the axis provided, then input will be coerced into a 2-dimensional tensor with
  dimensions [a_0 * ... * a_{k-1}, a_k * ... * a_{n-1}]. For the default
  case where axis=1, this means the input tensor will be coerced into a 2D tensor
  of dimensions [a_0, a_1 * ... * a_{n-1}], where a_0 is often the batch size.
  In this situation, we must have a_0 = N and a_1 * ... * a_{n-1} = D.
  Each of these dimensions must be matched correctly, or else the operator
  will throw errors.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 1)</dt>
<dd>Describes the axis of the inputs when coerced to 2D; defaults to one because the 0th axis most likely describes the batch_size</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>The input tensor that's coerced into a 2D matrix of size (NxD) as described above.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>The output values with the same shape as input tensor (the original size without coercion).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Identity-1"></a>**Identity-1**</a>

  Identity operator

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Tensor to copy input into.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

### <a name="If-1"></a>**If-1**</a>

  If conditional

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>else_branch</tt> : graph (required)</dt>
<dd>Graph to run if condition is false. Has N outputs: values you wish to be live-out to the enclosing scope. The number of outputs must match the number of outputs in the then_branch.</dd>
<dt><tt>then_branch</tt> : graph (required)</dt>
<dd>Graph to run if condition is true. Has N outputs: values you wish to be live-out to the enclosing scope. The number of outputs must match the number of outputs in the else_branch.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>cond</tt> : B</dt>
<dd>Condition for the if</dd>
</dl>

#### Outputs (1 - &#8734;)

<dl>
<dt><tt>outputs</tt> (variadic, heterogeneous) : V</dt>
<dd>Values that are live-out to the enclosing scope. The return values in the `then_branch` and `else_branch` must be of the same shape and same data type.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>V</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>All Tensor types</dd>
<dt><tt>B</tt> : tensor(bool)</dt>
<dd>Only bool</dd>
</dl>

### <a name="InstanceNormalization-1"></a>**InstanceNormalization-1**</a>

  Carries out instance normalization as described in the paper
  https://arxiv.org/abs/1607.08022.

  y = scale * (x - mean) / sqrt(variance + epsilon) + B,
  where mean and variance are computed per instance per channel.


#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
<dt><tt>epsilon</tt> : float (default is 1e-05)</dt>
<dd>The epsilon value to use to avoid division by zero, default is 1e-5f.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>The input 4-dimensional tensor of shape NCHW.</dd>
<dt><tt>scale</tt> : T</dt>
<dd>The input 1-dimensional scale tensor of size C.</dd>
<dt><tt>B</tt> : T</dt>
<dd>The input 1-dimensional bias tensor of size C.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>The output 4-dimensional tensor of the same shape as input.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="LRN-1"></a>**LRN-1**</a>

  Local Response Normalization proposed in the [AlexNet paper](https://papers.nips.cc/paper/4824-imagenet-classification-with-deep-convolutional-neural-networks.pdf).
  It normalizes over local input regions.
  The local region is defined across the channels. For an element X[n, c, d1, ..., dk] in a tensor
  of shape (N x C x D1 x D2, ..., Dk), its region is
  {X[n, i, d1, ..., dk] | max(0, c - floor((size - 1) / 2)) <= i <= min(C - 1, c + ceil((size - 1) / 2))}.

  square_sum[n, c, d1, ..., dk] = sum(X[n, i, d1, ..., dk] ^ 2),
  where max(0, c - floor((size - 1) / 2)) <= i <= min(C - 1, c + ceil((size - 1) / 2)).

  Y[n, c, d1, ..., dk] = X[n, c, d1, ..., dk] / (bias + alpha / size * square_sum[n, c, d1, ..., dk] ) ^ beta

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float (default is 0.0001)</dt>
<dd>Scaling parameter.</dd>
<dt><tt>beta</tt> : float (default is 0.75)</dt>
<dd>The exponent.</dd>
<dt><tt>bias</tt> : float (default is 1.0)</dt>
<dd></dd>
<dt><tt>size</tt> : int (required)</dt>
<dd>The number of channels to sum over</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input data tensor from the previous operator; dimensions for image case are (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data. For non image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size. Optionally, if dimension denotation is in effect, the operation expects the input data tensor to arrive with the dimension denotation of [DATA_BATCH, DATA_CHANNEL, DATA_FEATURE, DATA_FEATURE ...].</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor, which has the shape and type as input tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output  types to float tensors.</dd>
</dl>

### <a name="LSTM-1"></a>**LSTM-1**</a>

  Computes an one-layer LSTM. This operator is usually supported via some
  custom implementation such as CuDNN.

  Notations:

  `X` - input tensor

  `i` - input gate

  `o` - output gate

  `f` - forget gate

  `c` - cell gate

  `t` - time step (t-1 means previous time step)

  `W[iofc]` - W parameter weight matrix for input, output, forget, and cell gates

  `R[iofc]` - R recurrence weight matrix for input, output, forget, and cell gates

  `Wb[iofc]` - W bias vectors for input, output, forget, and cell gates

  `Rb[iofc]` - R bias vectors for input, output, forget, and cell gates

  `P[iof]`  - P peephole weight vector for input, output, and forget gates

  `WB[iofc]` - W parameter weight matrix for backward input, output, forget, and cell gates

  `RB[iofc]` - R recurrence weight matrix for backward input, output, forget, and cell gates

  `WBb[iofc]` - W bias vectors for backward input, output, forget, and cell gates

  `RBb[iofc]` - R bias vectors for backward input, output, forget, and cell gates

  `PB[iof]`  - P peephole weight vector for backward input, output, and forget gates

  `H` - Hidden state

  `num_directions` - 2 if direction == bidirectional else 1

  Activation functions:

    Relu(x)                - max(0, x)

    Tanh(x)                - (1 - e^{-2x})/(1 + e^{-2x})

    Sigmoid(x)             - 1/(1 + e^{-x})

    (NOTE: Below are optional)

    Affine(x)              - alpha*x + beta

    LeakyRelu(x)           - x if x >= 0 else alpha * x

    ThresholdedRelu(x)     - x if x >= alpha else 0

    ScaledTanh(x)          - alpha*Tanh(beta*x)

    HardSigmoid(x)         - min(max(alpha*x + beta, 0), 1)

    Elu(x)                 - x if x >= 0 else alpha*(e^x - 1)

    Softsign(x)            - x/(1 + |x|)

    Softplus(x)            - log(1 + e^x)

  Equations (Default: f=Sigmoid, g=Tanh, h=Tanh):

    - it = f(Xt*(Wi^T) + Ht-1*Ri + Pi (.) Ct-1 + Wbi + Rbi)

    - ft = f(Xt*(Wf^T) + Ht-1*Rf + Pf (.) Ct-1 + Wbf + Rbf)

    - ct = g(Xt*(Wc^T) + Ht-1*Rc + Wbc + Rbc)

    - Ct = ft (.) Ct-1 + it (.) ct

    - ot = f(Xt*(Wo^T) + Ht-1*Ro + Po (.) Ct + Wbo + Rbo)

    - Ht = ot (.) h(Ct)

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>activation_alpha</tt> : list of floats</dt>
<dd>Optional scaling values used by some activation functions. The values are consumed in the order of activation functions, for example (f, g, h) in LSTM. Default values are the same as of corresponding ONNX operators.For example with LeakyRelu, the default alpha is 0.01.</dd>
<dt><tt>activation_beta</tt> : list of floats</dt>
<dd>Optional scaling values used by some activation functions. The values are consumed in the order of activation functions, for example (f, g, h) in LSTM. Default values are the same as of corresponding ONNX operators.</dd>
<dt><tt>activations</tt> : list of strings</dt>
<dd>A list of 3 (or 6 if bidirectional) activation functions for input, output, forget, cell, and hidden. The activation functions must be one of the activation functions specified above. Optional: See the equations for default if not specified.</dd>
<dt><tt>clip</tt> : float</dt>
<dd>Cell clip threshold. Clipping bounds the elements of a tensor in the range of [-threshold, +threshold] and is applied to the input of activations. No clip if not specified.</dd>
<dt><tt>direction</tt> : string (default is forward)</dt>
<dd>Specify if the RNN is forward, reverse, or bidirectional. Must be one of forward (default), reverse, or bidirectional.</dd>
<dt><tt>hidden_size</tt> : int</dt>
<dd>Number of neurons in the hidden layer</dd>
<dt><tt>input_forget</tt> : int (default is 0)</dt>
<dd>Couple the input and forget gates if 1, default 0.</dd>
<dt><tt>output_sequence</tt> : int (default is 0)</dt>
<dd>The sequence output for the hidden is optional if 0. Default 0.</dd>
</dl>

#### Inputs (3 - 8)

<dl>
<dt><tt>X</tt> : T</dt>
<dd>The input sequences packed (and potentially padded) into one 3-D tensor with the shape of `[seq_length, batch_size, input_size]`.</dd>
<dt><tt>W</tt> : T</dt>
<dd>The weight tensor for the gates. Concatenation of `W[iofc]` and `WB[iofc]` (if bidirectional) along dimension 0. The tensor has shape `[num_directions, 4*hidden_size, input_size]`.</dd>
<dt><tt>R</tt> : T</dt>
<dd>The recurrence weight tensor. Concatenation of `R[iofc]` and `RB[iofc]` (if bidirectional) along dimension 0. This tensor has shape `[num_directions, 4*hidden_size, hidden_size]`.</dd>
<dt><tt>B</tt> (optional) : T</dt>
<dd>The bias tensor for input gate. Concatenation of `[Wb[iofc], Rb[iofc]]`, and `[WBb[iofc], RBb[iofc]]` (if bidirectional) along dimension 0. This tensor has shape `[num_directions, 8*hidden_size]`. Optional: If not specified - assumed to be 0.</dd>
<dt><tt>sequence_lens</tt> (optional) : T1</dt>
<dd>Optional tensor specifying lengths of the sequences in a batch. If not specified - assumed all sequences in the batch to have length `seq_length`. It has shape `[batch_size]`.</dd>
<dt><tt>initial_h</tt> (optional) : T</dt>
<dd>Optional initial value of the hidden. If not specified - assumed to be 0. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
<dt><tt>initial_c</tt> (optional) : T</dt>
<dd>Optional initial value of the cell. If not specified - assumed to be 0. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
<dt><tt>P</tt> (optional) : T</dt>
<dd>The weight tensor for peepholes. Concatenation of `P[iof]` and `PB[iof]` (if bidirectional) along dimension 0. It has shape `[num_directions, 3*hidde_size]`. Optional: If not specified - assumed to be 0.</dd>
</dl>

#### Outputs (0 - 3)

<dl>
<dt><tt>Y</tt> (optional) : T</dt>
<dd>A tensor that concats all the intermediate output values of the hidden. It has shape `[seq_length, num_directions, batch_size, hidden_size]`. It is optional if `output_sequence` is 0.</dd>
<dt><tt>Y_h</tt> (optional) : T</dt>
<dd>The last output value of the hidden. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
<dt><tt>Y_c</tt> (optional) : T</dt>
<dd>The last output value of the cell. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T1</tt> : tensor(int32)</dt>
<dd>Constrain seq_lens to integer tensor.</dd>
</dl>

### <a name="LeakyRelu-1"></a>**LeakyRelu-1**</a>

  LeakyRelu takes input data (Tensor<T>) and an argument alpha, and produces one
  output data (Tensor<T>) where the function `f(x) = alpha * x for x < 0`,
  `f(x) = x for x >= 0`, is applied to the data tensor elementwise.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float (default is 0.01)</dt>
<dd>Coefficient of leakage default to 0.01.</dd>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Less-1"></a>**Less-1**</a>

  Returns the tensor resulted from performing the `less` logical operation
  elementwise on the input tensors `A` and `B`.

  If broadcasting is enabled, the right-hand-side argument will be broadcasted
  to match the shape of left-hand-side argument. See the doc of `Add` for a
  detailed description of the broadcasting rules.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int</dt>
<dd>If set, defines the broadcast dimensions.</dd>
<dt><tt>broadcast</tt> : int (default is 0)</dt>
<dd>Enable broadcasting</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>Left input tensor for the logical operator.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Right input tensor for the logical operator.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T1</dt>
<dd>Result tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input to float tensors.</dd>
<dt><tt>T1</tt> : tensor(bool)</dt>
<dd>Constrain output to boolean tensor.</dd>
</dl>

### <a name="Log-1"></a>**Log-1**</a>

  Calculates the natural log of the given input tensor, element-wise.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>The natural log of the input tensor computed element-wise</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="LogSoftmax-1"></a>**LogSoftmax-1**</a>

  The operator computes the logsoftmax (log of softmax) values for each layer in the batch
   of the given input. The input is a 2-D tensor (Tensor<float>) of size
  (batch_size x input_feature_dimensions). The output tensor has the same shape
  and contains the logsoftmax values of the corresponding input.

  Input does not need to explicitly be a 2D vector; rather, it will be
  coerced into one. For an arbitrary n-dimensional tensor
  input \in [a_0, a_1, ..., a_{k-1}, a_k, ..., a_{n-1}] and k is
  the axis provided, then input will be coerced into a 2-dimensional tensor with
  dimensions [a_0 * ... * a_{k-1}, a_k * ... * a_{n-1}]. For the default
  case where axis=1, this means the input tensor will be coerced into a 2D tensor
  of dimensions [a_0, a_1 * ... * a_{n-1}], where a_0 is often the batch size.
  In this situation, we must have a_0 = N and a_1 * ... * a_{n-1} = D.
  Each of these dimensions must be matched correctly, or else the operator
  will throw errors.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 1)</dt>
<dd>Describes the axis of the inputs when coerced to 2D; defaults to one because the 0th axis most likely describes the batch_size</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>The input tensor that's coerced into a 2D matrix of size (NxD) as described above.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>The output values with the same shape as input tensor (the original size without coercion).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Loop-1"></a>**Loop-1**</a>

  Generic Looping construct. This loop has multiple termination conditions:

  1) Trip count. Iteration count specified at runtime. Set by
     specifying the input M. Optional. Set to empty string to omit.
     Note that a static trip count (specified at graph construction time) can be
     specified by passing in a constant node for input M.
  2) Loop termination condition. This is an input to the op that determines
     whether to run the first iteration and also a loop-carried dependency for
     the body graph. The body graph must yield a value for the condition variable,
     whether this input is provided or not.

  This table summarizes the operating modes of this operator with equivalent
  C-style code:

      Operator inputs defined as (max_trip_count, condition_var).

      input ("", ""):
          for (int i=0; ; ++i) {
            cond = ... // Note this value is ignored, but is required in the body
          }

      input ("", cond) // Note this is analogous to a while loop
          bool cond = ...;
          for (int i=0; cond; ++i) {
            cond = ...;
          }

      input ("", 1) // Note this is analogous to a do-while loop
          bool cond = true
          for (int i=0; cond; ++i) {
            cond = ...;
          }

      input (trip_count, "") // Note this is analogous to a for loop
          int trip_count = ...
          for (int i=0; i < trip_count; ++i) {
            cond = ...; // ignored
          }

      input (trip_count, cond)
          int trip_count = ...;
          bool cond = ...;
          for (int i=0; i < trip_count && cond; ++i) {
            cond = ...;
          }


  *Sample usage - cond as well as trip count*

      graph predict-net {
        %a = Constant[value = <Scalar Tensor [3]>]()
        %b = Constant[value = <Scalar Tensor [6]>]()
        %keepgoing = Constant[value = <Scalar Tensor [1]>]()
        %max_trip_count = Constant[value = <Scalar Tensor [10]>]()
        %keepgoing_out, %b_out, %user_defined_vals = Loop[body = <graph body-net>](%max_trip_count, %keepgoing, %b)
        return
      }

      graph body-net (
        %i[INT32, scalar]
        %keepgoing[BOOL, scalar]
        %b[INT32, scalar]
      ) {
        %my_local = Add(%a, %b)
        %b_out = Sub(%a, %b)
        %keepgoing_out = Greater(%my_local, %b_out)
        %user_defined_vals = Add(%b, %b)
        return %keepgoing_out, %b_out, %user_defined_vals
      }

  *Sample equivalent C code*

      {
        /* User-defined code (enclosing scope) */
        int a = 3, b = 6;
        bool keepgoing = true; // Analogous to input cond
        /* End user-defined code */

        /* Implicitly-defined code */
        const int max_trip_count = 10; // Analogous to input M
        int user_defined_vals[]; // Imagine this is resizable
        /* End implicitly-defined code */
        for (int i=0; i < max_trip_count && keepgoing; ++i) {
          /* User-defined code (loop body) */
          int my_local = a + b; // Reading values in the enclosing scope is fine
          b = a - b; // writes fine if we specify b as a loop-carried dependency
          keepgoing = my_local > b; // keepgoing is a loop-carried dependency
          user_defined_vals[i] = b + b;
          /* End user-defined code */
        }
        // my_local = 123; // Can't do this. my_local was defined in the the body

        // These below values are live-out from the loop and therefore accessible
        b_out; user_defined_vals; keepgoing_out;
      }

  There are several things of note in this code snippet:

  1) Values from the enclosing scope (i.e. variable a here) are in scope and can
     be referenced in the inputs of the loop.
  2) Any variables which you wish to make available in the enclosing scope (i.e.
     the variables b and keepgoing) must be declared as either loop-carried
     dependencies (both at the op inputs and output and at the body net input and
     output) or scan_outputs.
  3) Values created in the body cannot be accessed in the enclosing scope.

  Note that the semantics of this op support "diagonal" or "wavefront" execution.
  (See Step 3 here for an example:
  https://devblogs.nvidia.com/optimizing-recurrent-neural-networks-cudnn-5/).
  Frontends should emit multi-layer RNNs as a series of While operators (with
  time being the inner looping dimension), with each successive layer consuming
  the scan_outputs from the previous layer, possibly going through several
  point-wise operators (e.g. dropout, residual connections, linear layer).

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>body</tt> : graph (required)</dt>
<dd>The graph run each iteration. It has 2+N inputs: (iteration_num, condition, loop carried dependencies...). It has 1+N+K outputs: (condition, loop carried dependencies..., scan_outputs...). Each scan_output is created by concatenating the value of the specified output value at the end of each iteration of the loop. It is an error if the dimensions or data type of these scan_outputs change across loop iterations.</dd>
</dl>

#### Inputs (3 - &#8734;)

<dl>
<dt><tt>M</tt> (optional) : I</dt>
<dd>A maximum trip-count for the loop specified at runtime. Optional. Pass empty string to skip.</dd>
<dt><tt>cond</tt> (optional) : B</dt>
<dd>A boolean termination condition. Optional. Pass empty string to skip.</dd>
<dt><tt>v_initial</tt> (variadic, heterogeneous) : V</dt>
<dd>The initial values of any loop-carried dependencies (values that change across loop iterations)</dd>
</dl>

#### Outputs (1 - &#8734;)

<dl>
<dt><tt>v_final_and_scan_outputs</tt> (variadic, heterogeneous) : V</dt>
<dd>Final N loop carried dependency values then K scan_outputs</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>V</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>All Tensor types</dd>
<dt><tt>I</tt> : tensor(int64)</dt>
<dd>tensor of int64, which should be a scalar.</dd>
<dt><tt>B</tt> : tensor(bool)</dt>
<dd>tensor of bool, which should be a scalar.</dd>
</dl>

### <a name="LpNormalization-1"></a>**LpNormalization-1**</a>

  Given a matrix, apply Lp-normalization along the provided axis.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is -1)</dt>
<dd>The axis on which to apply normalization, -1 mean last axis.</dd>
<dt><tt>p</tt> : int (default is 2)</dt>
<dd>The order of the normalization, only 1 or 2 are supported.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Input matrix</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>Matrix after normalization</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="LpPool-1"></a>**LpPool-1**</a>

  LpPool consumes an input tensor X and applies Lp pooling across the
   the tensor according to kernel sizes, stride sizes, and pad lengths.
   Lp pooling consisting of computing the Lp norm on all values of a subset
   of the input tensor according to the kernel size and downsampling the
   data into the output tensor Y for further processing.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>auto_pad</tt> : string (default is NOTSET)</dt>
<dd>auto_pad must be either NOTSET, SAME_UPPER, SAME_LOWER or VALID. Where default value is NOTSET, which means explicit padding is used. SAME_UPPER or SAME_LOWER mean pad the input so that the output size match the input.In case of odd number add the extra padding at the end for SAME_UPPER and at the beginning for SAME_LOWER. VALID mean no padding. DEPRECATION NOTE: auto_pad is only intended to support legacy uses, and for framework authors, one is explicitly encouraged to use explicit padding specified in the pads attribute.</dd>
<dt><tt>kernel_shape</tt> : list of ints</dt>
<dd>The size of the kernel along each axis.</dd>
<dt><tt>p</tt> : float (default is 2.0)</dt>
<dd>p value of the Lp norm used to pool over the input data, default is 2.0.</dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd>Padding for the beginning and ending along each axis, it can take any value greater than or equal to 0. The value represent the number of pixels added to the beginning and end part of the corresponding axis. `pads` format should be as follow [x1_begin, x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels added at the beginning of axis `i` and xi_end, the number of pixels added at the end of axis `i`. This attribute cannot be used simultaneously with auto_pad attribute.</dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd>Stride along each axis.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input data tensor from the previous operator; dimensions for image case are (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data. For non image case, the dimension are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output data tensor from Lp pooling across the input tensor. Dimensions will vary based on various kernel, stride, and pad sizes.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="MatMul-1"></a>**MatMul-1**</a>

  Matrix product that behaves like numpy.matmul: https://docs.scipy.org/doc/numpy-1.13.0/reference/generated/numpy.matmul.html

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>N-dimensional matrix A</dd>
<dt><tt>B</tt> : T</dt>
<dd>N-dimensional matrix B</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Matrix multiply results from A * B</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Max-1"></a>**Max-1**</a>

  Element-wise max of each of the input tensors. All inputs and outputs must
  have the same shape and data type.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
</dl>

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>data_0</tt> (variadic) : T</dt>
<dd>List of tensors for Max.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>max</tt> : T</dt>
<dd>Output tensor. Same dimension as inputs.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="MaxPool-1"></a>**MaxPool-1**</a>

  MaxPool consumes an input tensor X and applies max pooling across
   the tensor according to kernel sizes, stride sizes, and pad lengths.
   max pooling consisting of computing the max on all values of a
   subset of the input tensor according to the kernel size and downsampling the
   data into the output tensor Y for further processing. The output spatial shape will be following:
   ```
   output_spatial_shape[i] = floor((input_spatial_shape[i] + pad_shape[i] - kernel_spatial_shape[i]) / strides_spatial_shape[i] + 1)

   * pad_shape[i] is sum of pads along axis i
   ```

   `auto_pad` is a DEPRECATED attribute. If you are using them currently, the output spatial shape will be following:
   ```
   VALID: output_spatial_shape[i] = ceil((input_spatial_shape[i] - kernel_spatial_shape[i] + 1) / strides_spatial_shape[i])
   SAME_UPPER or SAME_LOWER: output_spatial_shape[i] = ceil(input_spatial_shape[i] / strides_spatial_shape[i])
   ```
   And pad shape will be following if `SAME_UPPER` or `SAME_LOWER`:
   ```
   pad_shape[i] = (output_spatial_shape[i] - 1) * strides_spatial_shape[i] + kernel_spatial_shape[i] - input_spatial_shape[i]
   ```
   The output of each pooling window is maximum number of elements exclude pad.


#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>auto_pad</tt> : string (default is NOTSET)</dt>
<dd>auto_pad must be either NOTSET, SAME_UPPER, SAME_LOWER or VALID. Where default value is NOTSET, which means explicit padding is used. SAME_UPPER or SAME_LOWER mean pad the input so that the output spatial size match the input.In case of odd number add the extra padding at the end for SAME_UPPER and at the beginning for SAME_LOWER. VALID mean no padding.</dd>
<dt><tt>kernel_shape</tt> : list of ints (required)</dt>
<dd>The size of the kernel along each axis.</dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd>Padding for the beginning and ending along each spatial axis, it can take any value greater than or equal to 0. The value represent the number of pixels added to the beginning and end part of the corresponding axis. `pads` format should be as follow [x1_begin, x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels added at the beginning of axis `i` and xi_end, the number of pixels added at the end of axis `i`. This attribute cannot be used simultaneously with auto_pad attribute. If not present, the padding defaults to 0 along start and end of each spatial axis.</dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd>Stride along each spatial axis.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input data tensor from the previous operator; dimensions for image case are (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data. For non image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size. Optionally, if dimension denotation is in effect, the operation expects the input data tensor to arrive with the dimension denotation of [DATA_BATCH, DATA_CHANNEL, DATA_FEATURE, DATA_FEATURE ...].</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output data tensor from average or max pooling across the input tensor. Dimensions will vary based on various kernel, stride, and pad sizes. Floor value of the dimension is used</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="MaxRoiPool-1"></a>**MaxRoiPool-1**</a>

  ROI max pool consumes an input tensor X and region of interests (RoIs) to
   apply max pooling across each RoI, to produce output 4-D tensor of shape
   (num_rois, channels, pooled_shape[0], pooled_shape[1]).

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>pooled_shape</tt> : list of ints (required)</dt>
<dd>ROI pool output shape (height, width).</dd>
<dt><tt>spatial_scale</tt> : float (default is 1.0)</dt>
<dd>Multiplicative spatial scale factor to translate ROI coordinates from their input scale to the scale used when pooling.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input data tensor from the previous operator; dimensions for image case are (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data.</dd>
<dt><tt>rois</tt> (non-differentiable) : T</dt>
<dd>RoIs (Regions of Interest) to pool over. Should be a 2-D tensor of shape (num_rois, 5) given as [[batch_id, x1, y1, x2, y2], ...].</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>RoI pooled output 4-D tensor of shape (num_rois, channels, pooled_shape[0], pooled_shape[1]).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Mean-1"></a>**Mean-1**</a>

  Element-wise mean of each of the input tensors. All inputs and outputs must
  have the same shape and data type.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
</dl>

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>data_0</tt> (variadic) : T</dt>
<dd>List of tensors for Mean.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>mean</tt> : T</dt>
<dd>Output tensor. Same dimension as inputs.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Min-1"></a>**Min-1**</a>

  Element-wise min of each of the input tensors. All inputs and outputs must
  have the same shape and data type.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
</dl>

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>data_0</tt> (variadic) : T</dt>
<dd>List of tensors for Min</dd>
</dl>

#### Outputs

<dl>
<dt><tt>min</tt> : T</dt>
<dd>Output tensor. Same dimension as inputs.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Mul-1"></a>**Mul-1**</a>

  Performs element-wise binary multiplication (with limited broadcast support).

  If necessary the right-hand-side argument will be broadcasted to match the
  shape of left-hand-side argument. When broadcasting is specified, the second
  tensor can either be of element size 1 (including a scalar tensor and any
  tensor with rank equal to or smaller than the first tensor), or having its
  shape as a contiguous subset of the first tensor's shape. The starting of the
  mutually equal shape is specified by the argument "axis", and if it is not set,
  suffix matching is assumed. 1-dim expansion doesn't work yet.

  For example, the following tensor shapes are supported (with broadcast=1):

    shape(A) = (2, 3, 4, 5), shape(B) = (,), i.e. B is a scalar tensor
    shape(A) = (2, 3, 4, 5), shape(B) = (1, 1), i.e. B is an 1-element tensor
    shape(A) = (2, 3, 4, 5), shape(B) = (5,)
    shape(A) = (2, 3, 4, 5), shape(B) = (4, 5)
    shape(A) = (2, 3, 4, 5), shape(B) = (3, 4), with axis=1
    shape(A) = (2, 3, 4, 5), shape(B) = (2), with axis=0

  Attribute `broadcast=1` needs to be passed to enable broadcasting.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int</dt>
<dd>If set, defines the broadcast dimensions. See doc for details.</dd>
<dt><tt>broadcast</tt> : int (default is 0)</dt>
<dd>Pass 1 to enable broadcasting</dd>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>First operand, should share the type with the second operand.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Second operand. With broadcasting can be of smaller size than A. If broadcasting is disabled it should be of the same size.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T</dt>
<dd>Result, has same dimensions and type as A</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Neg-1"></a>**Neg-1**</a>

  Neg takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where each element flipped sign, y = -x, is applied to
  the tensor elementwise.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Not-1"></a>**Not-1**</a>

  Returns the negation of the input tensor element-wise.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> (non-differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (non-differentiable) : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(bool)</dt>
<dd>Constrain input/output to boolean tensors.</dd>
</dl>

### <a name="Or-1"></a>**Or-1**</a>

  Returns the tensor resulted from performing the `or` logical operation
  elementwise on the input tensors `A` and `B`.

  If broadcasting is enabled, the right-hand-side argument will be broadcasted
  to match the shape of left-hand-side argument. See the doc of `Add` for a
  detailed description of the broadcasting rules.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int</dt>
<dd>If set, defines the broadcast dimensions.</dd>
<dt><tt>broadcast</tt> : int (default is 0)</dt>
<dd>Enable broadcasting</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>Left input tensor for the logical operator.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Right input tensor for the logical operator.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T1</dt>
<dd>Result tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(bool)</dt>
<dd>Constrain input to boolean tensor.</dd>
<dt><tt>T1</tt> : tensor(bool)</dt>
<dd>Constrain output to boolean tensor.</dd>
</dl>

### <a name="PRelu-1"></a>**PRelu-1**</a>

  PRelu takes input data (Tensor<T>) and slope tensor as input, and produces one
  output data (Tensor<T>) where the function `f(x) = slope * x for x < 0`,
  `f(x) = x for x >= 0`., is applied to the data tensor elementwise.


#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor</dd>
<dt><tt>slope</tt> : T</dt>
<dd>Slope tensor. If `Slope` is of size 1, the value is sharedacross different channels</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Pad-1"></a>**Pad-1**</a>

  Given `data` tensor, paddings, mode, and value.
  Example:
    Insert 0 paddings to the beginning of the second dimension.
    data = [
        [1.0, 1.2],
        [2.3, 3.4],
        [4.5, 5.7],
    ]
    paddings = [0, 0, 2, 0]
    output = [
        [
            [0.0, 0.0, 1.0, 1.2],
            [0.0, 0.0, 2.3, 3.4],
            [0.0, 0.0, 4.5, 5.7],
        ],
    ]

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>mode</tt> : string (default is constant)</dt>
<dd>Three modes: constant(default), reflect, edge</dd>
<dt><tt>paddings</tt> : list of ints (required)</dt>
<dd>List of integers indicate the padding element count at the beginning and end of each axis, for 2D it is the number of pixel. `paddings` rank should be double of the input's rank. `paddings` format should be as follow [x1_begin, x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels added at the beginning of axis `i` and xi_end, the number of pixels added at the end of axis `i`.</dd>
<dt><tt>value</tt> : float (default is 0.0)</dt>
<dd>One float, indicates the value to be filled, default is 0</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>Input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Tensor after padding.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Pow-1"></a>**Pow-1**</a>

  Pow takes input data (Tensor<T>) and exponent Tensor, and
  produces one output data (Tensor<T>) where the function `f(x) = x^exponent`,
  is applied to the data tensor elementwise.

  If necessary the right-hand-side argument will be broadcasted to match the
  shape of left-hand-side argument. When broadcasting is specified, the second
  tensor can either be of element size 1 (including a scalar tensor and any
  tensor with rank equal to or smaller than the first tensor), or having its
  shape as a contiguous subset of the first tensor's shape. The starting of the
  mutually equal shape is specified by the argument "axis", and if it is not set,
  suffix matching is assumed. 1-dim expansion doesn't work yet.

  For example, the following tensor shapes are supported (with broadcast=1):

    shape(A) = (2, 3, 4, 5), shape(B) = (,), i.e. B is a scalar tensor
    shape(A) = (2, 3, 4, 5), shape(B) = (1, 1), i.e. B is an 1-element tensor
    shape(A) = (2, 3, 4, 5), shape(B) = (5,)
    shape(A) = (2, 3, 4, 5), shape(B) = (4, 5)
    shape(A) = (2, 3, 4, 5), shape(B) = (3, 4), with axis=1
    shape(A) = (2, 3, 4, 5), shape(B) = (2), with axis=0

  Attribute `broadcast=1` needs to be passed to enable broadcasting.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int</dt>
<dd>If set, defines the broadcast dimensions. See doc for details.</dd>
<dt><tt>broadcast</tt> : int (default is 0)</dt>
<dd>Pass 1 to enable broadcasting</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor of any shape, base of the exponent.</dd>
<dt><tt>Y</tt> : T</dt>
<dd>Input tensor of any shape broadcastable to X shape, the exponent component.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Z</tt> : T</dt>
<dd>Output tensor (same size as X)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="RNN-1"></a>**RNN-1**</a>

  Computes an one-layer simple RNN. This operator is usually supported
  via some custom implementation such as CuDNN.

  Notations:

  `X` - input tensor

  `i` - input gate

  `t` - time step (t-1 means previous time step)

  `Wi` - W parameter weight matrix for input gate

  `Ri` - R recurrence weight matrix for input gate

  `Wbi` - W parameter bias vector for input gate

  `Rbi` - R parameter bias vector for input gate

  `WBi` - W parameter weight matrix for backward input gate

  `RBi` - R recurrence weight matrix for backward input gate

  `WBbi` - WR bias vectors for backward input gate

  `RBbi` - RR bias vectors for backward input gate

  `H` - Hidden state

  `num_directions` - 2 if direction == bidirectional else 1

  Activation functions:

    Relu(x)                - max(0, x)

    Tanh(x)                - (1 - e^{-2x})/(1 + e^{-2x})

    Sigmoid(x)             - 1/(1 + e^{-x})

    (NOTE: Below are optional)

    Affine(x)              - alpha*x + beta

    LeakyRelu(x)           - x if x >= 0 else alpha * x

    ThresholdedRelu(x)     - x if x >= alpha else 0

    ScaledTanh(x)          - alpha*Tanh(beta*x)

    HardSigmoid(x)         - min(max(alpha*x + beta, 0), 1)

    Elu(x)                 - x if x >= 0 else alpha*(e^x - 1)

    Softsign(x)            - x/(1 + |x|)

    Softplus(x)            - log(1 + e^x)

  Equations (Default: f=Tanh):

    - Ht = f(Xt*(Wi^T) + Ht-1*Ri + Wbi + Rbi)

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>activation_alpha</tt> : list of floats</dt>
<dd>Optional scaling values used by some activation functions. The values are consumed in the order of activation functions, for example (f, g, h) in LSTM. Default values are the same as of corresponding ONNX operators.For example with LeakyRelu, the default alpha is 0.01.</dd>
<dt><tt>activation_beta</tt> : list of floats</dt>
<dd>Optional scaling values used by some activation functions. The values are consumed in the order of activation functions, for example (f, g, h) in LSTM. Default values are the same as of corresponding ONNX operators.</dd>
<dt><tt>activations</tt> : list of strings (default is ['Tanh', 'Tanh'])</dt>
<dd>One (or two if bidirectional) activation function for input gate. The activation function must be one of the activation functions specified above. Optional: Default `Tanh` if not specified.</dd>
<dt><tt>clip</tt> : float</dt>
<dd>Cell clip threshold. Clipping bounds the elements of a tensor in the range of [-threshold, +threshold] and is applied to the input of activations. No clip if not specified.</dd>
<dt><tt>direction</tt> : string (default is forward)</dt>
<dd>Specify if the RNN is forward, reverse, or bidirectional. Must be one of forward (default), reverse, or bidirectional.</dd>
<dt><tt>hidden_size</tt> : int</dt>
<dd>Number of neurons in the hidden layer</dd>
<dt><tt>output_sequence</tt> : int (default is 0)</dt>
<dd>The sequence output for the hidden is optional if 0. Default 0.</dd>
</dl>

#### Inputs (3 - 6)

<dl>
<dt><tt>X</tt> : T</dt>
<dd>The input sequences packed (and potentially padded) into one 3-D tensor with the shape of `[seq_length, batch_size, input_size]`.</dd>
<dt><tt>W</tt> : T</dt>
<dd>The weight tensor for input gate. Concatenation of `Wi` and `WBi` (if bidirectional). The tensor has shape `[num_directions, hidden_size, input_size]`.</dd>
<dt><tt>R</tt> : T</dt>
<dd>The recurrence weight tensor. Concatenation of `Ri` and `RBi` (if bidirectional). The tensor has shape `[num_directions, hidden_size, hidden_size]`.</dd>
<dt><tt>B</tt> (optional) : T</dt>
<dd>The bias tensor for input gate. Concatenation of `[Wbi, Rbi]` and `[WBbi, RBbi]` (if bidirectional). The tensor has shape `[num_directions, 2*hidden_size]`. Optional: If not specified - assumed to be 0.</dd>
<dt><tt>sequence_lens</tt> (optional) : T1</dt>
<dd>Optional tensor specifying lengths of the sequences in a batch. If not specified - assumed all sequences in the batch to have length `seq_length`. It has shape `[batch_size]`.</dd>
<dt><tt>initial_h</tt> (optional) : T</dt>
<dd>Optional initial value of the hidden. If not specified - assumed to be 0. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
</dl>

#### Outputs (0 - 2)

<dl>
<dt><tt>Y</tt> (optional) : T</dt>
<dd>A tensor that concats all the intermediate output values of the hidden. It has shape `[seq_length, num_directions, batch_size, hidden_size]`. It is optional if `output_sequence` is 0.</dd>
<dt><tt>Y_h</tt> (optional) : T</dt>
<dd>The last output value of the hidden. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T1</tt> : tensor(int32)</dt>
<dd>Constrain seq_lens to integer tensor.</dd>
</dl>

### <a name="RandomNormal-1"></a>**RandomNormal-1**</a>

  Generate a tensor with random values drawn from a normal distribution. The shape
  of the tensor is specified by the `shape` argument and the parameter of the normal distribution
  specified by `mean` and `scale`.

  The data type is specified by the 'dtype' argument. The 'dtype' argument must
  be one of the data types specified in the 'DataType' enum field in the
  TensorProto message.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>dtype</tt> : int (default is 1)</dt>
<dd>The data type for the elements of the output tensor. Default is TensorProto::FLOAT.</dd>
<dt><tt>mean</tt> : float (default is 0.0)</dt>
<dd>The mean of the normal distribution.</dd>
<dt><tt>scale</tt> : float (default is 1.0)</dt>
<dd>The standard deviation of the normal distribution.</dd>
<dt><tt>seed</tt> : float</dt>
<dd>(Optional) Seed to the random generator, if not specified we will auto generate one.</dd>
<dt><tt>shape</tt> : list of ints (required)</dt>
<dd>The shape of the output tensor.</dd>
</dl>

#### Inputs


#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Output tensor of random values drawn from normal distribution</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain output types to float tensors.</dd>
</dl>

### <a name="RandomNormalLike-1"></a>**RandomNormalLike-1**</a>

  Generate a tensor with random values drawn from a normal distribution.
  The shape of the output tensor is copied from the shape of the input tensor,
  and the parameters of the normal distribution are specified by `mean` and `scale`.

  The data type is specified by the 'dtype' argument, or copied from the input tensor if not provided.
  The 'dtype' argument must be one of the data types specified in the 'DataType' enum field in the
  TensorProto message, and be valid as an output type.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>dtype</tt> : int</dt>
<dd>(Optional) The data type for the elements of the output tensor, if not specified, we will use the data type of the input tensor.</dd>
<dt><tt>mean</tt> : float (default is 0.0)</dt>
<dd>The mean of the normal distribution.</dd>
<dt><tt>scale</tt> : float (default is 1.0)</dt>
<dd>The standard deviation of the normal distribution.</dd>
<dt><tt>seed</tt> : float</dt>
<dd>(Optional) Seed to the random generator, if not specified we will auto generate one.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T1</dt>
<dd>Input tensor to copy shape and optionally type information from.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T2</dt>
<dd>Output tensor of random values drawn from normal distribution</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain to any tensor type. If the dtype attribute is not provided this must be a valid output type.</dd>
<dt><tt>T2</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain output types to float tensors.</dd>
</dl>

### <a name="RandomUniform-1"></a>**RandomUniform-1**</a>

  Generate a tensor with random values drawn from a uniform distribution. The shape
  of the tensor is specified by the `shape` argument and the range by `low` and `high`.

  The data type is specified by the 'dtype' argument. The 'dtype' argument must
  be one of the data types specified in the 'DataType' enum field in the
  TensorProto message.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>dtype</tt> : int (default is 1)</dt>
<dd>The data type for the elements of the output tensor. If not specified, default is TensorProto::FLOAT.</dd>
<dt><tt>high</tt> : float (default is 1.0)</dt>
<dd>Upper boundary of the output values.</dd>
<dt><tt>low</tt> : float (default is 0.0)</dt>
<dd>Lower boundary of the output values.</dd>
<dt><tt>seed</tt> : float</dt>
<dd>(Optional) Seed to the random generator, if not specified we will auto generate one.</dd>
<dt><tt>shape</tt> : list of ints (required)</dt>
<dd>The shape of the output tensor.</dd>
</dl>

#### Inputs


#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Output tensor of random values drawn from uniform distribution</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain output types to float tensors.</dd>
</dl>

### <a name="RandomUniformLike-1"></a>**RandomUniformLike-1**</a>

  Generate a tensor with random values drawn from a uniform distribution.
  The shape of the output tensor is copied from the shape of the input tensor,
  and the parameters of the uniform distribution are specified by `low` and `high`.

  The data type is specified by the 'dtype' argument, or copied from the input tensor if not provided.
  The 'dtype' argument must be one of the data types specified in the 'DataType' enum field in the
  TensorProto message and be valid as an output type.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>dtype</tt> : int</dt>
<dd>(Optional) The data type for the elements of the output tensor, if not specified, we will use the data type of the input tensor.</dd>
<dt><tt>high</tt> : float (default is 1.0)</dt>
<dd>Upper boundary of the output values.</dd>
<dt><tt>low</tt> : float (default is 0.0)</dt>
<dd>Lower boundary of the output values.</dd>
<dt><tt>seed</tt> : float</dt>
<dd>(Optional) Seed to the random generator, if not specified we will auto generate one.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T1</dt>
<dd>Input tensor to copy shape and optionally type information from.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T2</dt>
<dd>Output tensor of random values drawn from uniform distribution</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain to any tensor type. If the dtype attribute is not provided this must be a valid output type.</dd>
<dt><tt>T2</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain output types to float tensors.</dd>
</dl>

### <a name="Reciprocal-1"></a>**Reciprocal-1**</a>

  Reciprocal takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the reciprocal is, y = 1/x, is applied to
  the tensor elementwise.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="ReduceL1-1"></a>**ReduceL1-1**</a>

  Computes the L1 norm of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
  the resulted tensor have the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor.</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="ReduceL2-1"></a>**ReduceL2-1**</a>

  Computes the L2 norm of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
  the resulted tensor have the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor.</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="ReduceLogSum-1"></a>**ReduceLogSum-1**</a>

  Computes the log sum of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
  the resulted tensor have the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor.</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="ReduceLogSumExp-1"></a>**ReduceLogSumExp-1**</a>

  Computes the log sum exponent of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
  the resulted tensor have the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor.</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="ReduceMax-1"></a>**ReduceMax-1**</a>

  Computes the max of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
  the resulted tensor have the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor.</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="ReduceMean-1"></a>**ReduceMean-1**</a>

  Computes the mean of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
  the resulted tensor have the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor.</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="ReduceMin-1"></a>**ReduceMin-1**</a>

  Computes the min of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
  the resulted tensor have the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor.</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="ReduceProd-1"></a>**ReduceProd-1**</a>

  Computes the product of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
  the resulted tensor have the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor.</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="ReduceSum-1"></a>**ReduceSum-1**</a>

  Computes the sum of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
  the resulted tensor have the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor.</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="ReduceSumSquare-1"></a>**ReduceSumSquare-1**</a>

  Computes the sum square of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
  the resulted tensor have the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor.</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="Relu-1"></a>**Relu-1**</a>

  Relu takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the rectified linear function, y = max(0, x), is applied to
  the tensor elementwise.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Reshape-1"></a>**Reshape-1**</a>

  Reshape the input tensor similar to numpy.reshape.
  It takes a tensor as input and an argument `shape`. It outputs the reshaped tensor.
  At most one dimension of the new shape can be -1. In this case, the value is
  inferred from the size of the tensor and the remaining dimensions. A dimension
  could also be 0, in which case the actual dimension value is unchanged (i.e. taken
  from the input tensor). Shape (second input) could be an empty shape, which means converting to a scalar.
  The input tensor's shape and the output tensor's shape are required to have the same number of elements.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
<dt><tt>shape</tt> : list of ints</dt>
<dd>New shape</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reshaped</tt> : T</dt>
<dd>Reshaped data.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Selu-1"></a>**Selu-1**</a>

  Selu takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the scaled exponential linear unit function,
  `y = gamma * (alpha * e^x - alpha) for x <= 0`, `y = gamma * x for x > 0`,
  is applied to the tensor elementwise.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float (default is 1.6732)</dt>
<dd>Coefficient of SELU default to 1.6732.</dd>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
<dt><tt>gamma</tt> : float (default is 1.0507)</dt>
<dd>Coefficient of SELU default to 1.0507.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Shape-1"></a>**Shape-1**</a>

  Takes a tensor as input and outputs an 1D int64 tensor containing the shape of the input tensor.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>shape</tt> : T1</dt>
<dd>Shape of the input tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Input tensor can be of arbitrary type.</dd>
<dt><tt>T1</tt> : tensor(int64)</dt>
<dd>Constrain output to int64 tensor.</dd>
</dl>

### <a name="Sigmoid-1"></a>**Sigmoid-1**</a>

  Sigmoid takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the sigmoid function, y = 1 / (1 + exp(-x)), is applied to the
  tensor elementwise.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Size-1"></a>**Size-1**</a>

  Takes a tensor as input and outputs a int64 scalar that equals to the total number of elements of the input tensor.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>size</tt> : T1</dt>
<dd>Total number of elements of the input tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Input tensor can be of arbitrary type.</dd>
<dt><tt>T1</tt> : tensor(int64)</dt>
<dd>Constrain output to int64 tensor, which should be a scalar though.</dd>
</dl>

### <a name="Slice-1"></a>**Slice-1**</a>

  Produces a slice of the input tensor along multiple axes. Similar to numpy:
  https://docs.scipy.org/doc/numpy/reference/arrays.indexing.html
  Slices uses `axes`, `starts` and `ends` attributes to specify the start and end
  dimension for each axis in the list of axes, it uses this information to
  slice the input `data` tensor. If a negative value is passed for any of the
  start or end indices, it represent number of elements before the end of that
  dimension. If the value passed to start or end is larger than the `n` (the
  number of elements in this dimension), it represents `n`. For slicing to the
  end of a dimension with unknown size, it is recommended to pass in `INT_MAX`.
  If `axes` are omitted, they are set to `[0, ..., ndim-1]`.
  Example 1:
    data = [
        [1, 2, 3, 4],
        [5, 6, 7, 8],
    ]
    axes = [0, 1]
    starts = [1, 0]
    ends = [2, 3]
    result = [
        [5, 6, 7],
    ]
  Example 2:
    data = [
        [1, 2, 3, 4],
        [5, 6, 7, 8],
    ]
    starts = [0, 1]
    ends = [-1, 1000]
    result = [
        [2, 3, 4],
    ]

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>Axes that `starts` and `ends` apply to. It's optional. If not present, will be treated as [0, 1, ..., len(`starts`) - 1].</dd>
<dt><tt>ends</tt> : list of ints (required)</dt>
<dd>Ending indices (exclusive) of corresponding axis in axes`</dd>
<dt><tt>starts</tt> : list of ints (required)</dt>
<dd>Starting indices of corresponding axis in `axes`</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>Tensor of data to extract slices from.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Sliced data tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

### <a name="Softmax-1"></a>**Softmax-1**</a>

  The operator computes the softmax (normalized exponential) values for each layer in the batch
   of the given input. The input is a 2-D tensor (Tensor<float>) of size
  (batch_size x input_feature_dimensions). The output tensor has the same shape
  and contains the softmax values of the corresponding input.

  Input does not need to explicitly be a 2D vector; rather, it will be
  coerced into one. For an arbitrary n-dimensional tensor
  input \in [a_0, a_1, ..., a_{k-1}, a_k, ..., a_{n-1}] and k is
  the axis provided, then input will be coerced into a 2-dimensional tensor with
  dimensions [a_0 * ... * a_{k-1}, a_k * ... * a_{n-1}]. For the default
  case where axis=1, this means the input tensor will be coerced into a 2D tensor
  of dimensions [a_0, a_1 * ... * a_{n-1}], where a_0 is often the batch size.
  In this situation, we must have a_0 = N and a_1 * ... * a_{n-1} = D.
  Each of these dimensions must be matched correctly, or else the operator
  will throw errors.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 1)</dt>
<dd>Describes the axis of the inputs when coerced to 2D; defaults to one because the 0th axis most likely describes the batch_size</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>The input tensor that's coerced into a 2D matrix of size (NxD) as described above.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>The output values with the same shape as input tensor (the original size without coercion).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Softplus-1"></a>**Softplus-1**</a>

  Softplus takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the softplus function, y = ln(exp(x) + 1), is applied to
  the tensor elementwise.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>1D input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>1D input tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Softsign-1"></a>**Softsign-1**</a>

  Calculates the softsign (x/(1+|x|)) of the given input tensor element-wise.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>The softsign (x/(1+|x|)) values of the input tensor computed element-wise</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="SpaceToDepth-1"></a>**SpaceToDepth-1**</a>

  SpaceToDepth rearranges blocks of spatial data into depth. More specifically,
  this op outputs a copy of the input tensor where values from the height and width dimensions
  are moved to the depth dimension.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>blocksize</tt> : int (required)</dt>
<dd>Blocks of [blocksize, blocksize] are moved.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>Input tensor of [N,C,H,W], where N is the batch axis, C is the channel or depth, H is the height and W is the width.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Output tensor of [N, C * blocksize * blocksize, H/blocksize, W/blocksize].</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

### <a name="Split-1"></a>**Split-1**</a>

  Split a tensor into a list of tensors, along the specified
  'axis'. The lengths of the split can be specified using argument 'axis' or
  optional second input blob to the operator. Otherwise, the tensor is split
  to equal sized parts.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int</dt>
<dd>Which axis to split on</dd>
<dt><tt>split</tt> : list of ints</dt>
<dd>length of each output</dd>
</dl>

#### Inputs (1 - 2)

<dl>
<dt><tt>input</tt> : T</dt>
<dd>The tensor to split</dd>
<dt><tt>split</tt> (optional) : T</dt>
<dd>Optional list of output lengths (see also arg 'split')</dd>
</dl>

#### Outputs (1 - &#8734;)

<dl>
<dt><tt>outputs...</tt> (variadic) : T</dt>
<dd>One or more outputs forming list of tensors after splitting</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input types to float tensors.</dd>
</dl>

### <a name="Sqrt-1"></a>**Sqrt-1**</a>

  Square root takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the square root is, y = x^0.5, is applied to
  the tensor elementwise. If x is negative, then it will return NaN.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Squeeze-1"></a>**Squeeze-1**</a>

  Remove single-dimensional entries from the shape of a tensor.
  Takes a  parameter `axes` with a list of axes to squeeze.
  If `axes` is not provided, all the single dimensions will be removed from
  the shape. If an axis is selected with shape entry not equal to one, an error is raised.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>List of non-negative integers, indicate the dimensions to squeeze.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>Tensors with at least max(dims) dimensions.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>squeezed</tt> : T</dt>
<dd>Reshaped tensor with same data as input.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

### <a name="Sub-1"></a>**Sub-1**</a>

  Performs element-wise binary subtraction (with limited broadcast support).

  If necessary the right-hand-side argument will be broadcasted to match the
  shape of left-hand-side argument. When broadcasting is specified, the second
  tensor can either be of element size 1 (including a scalar tensor and any
  tensor with rank equal to or smaller than the first tensor), or having its
  shape as a contiguous subset of the first tensor's shape. The starting of the
  mutually equal shape is specified by the argument "axis", and if it is not set,
  suffix matching is assumed. 1-dim expansion doesn't work yet.

  For example, the following tensor shapes are supported (with broadcast=1):

    shape(A) = (2, 3, 4, 5), shape(B) = (,), i.e. B is a scalar tensor
    shape(A) = (2, 3, 4, 5), shape(B) = (1, 1), i.e. B is an 1-element tensor
    shape(A) = (2, 3, 4, 5), shape(B) = (5,)
    shape(A) = (2, 3, 4, 5), shape(B) = (4, 5)
    shape(A) = (2, 3, 4, 5), shape(B) = (3, 4), with axis=1
    shape(A) = (2, 3, 4, 5), shape(B) = (2), with axis=0

  Attribute `broadcast=1` needs to be passed to enable broadcasting.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int</dt>
<dd>If set, defines the broadcast dimensions. See doc for details.</dd>
<dt><tt>broadcast</tt> : int (default is 0)</dt>
<dd>Pass 1 to enable broadcasting</dd>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>First operand, should share the type with the second operand.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Second operand. With broadcasting can be of smaller size than A. If broadcasting is disabled it should be of the same size.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T</dt>
<dd>Result, has same dimensions and type as A</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Sum-1"></a>**Sum-1**</a>

  Element-wise sum of each of the input tensors. All inputs and outputs must
  have the same shape and data type.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
</dl>

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>data_0</tt> (variadic) : T</dt>
<dd>List of tensors for Sum.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>sum</tt> : T</dt>
<dd>Output tensor. Same dimension as inputs.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Tanh-1"></a>**Tanh-1**</a>

  Calculates the hyperbolic tangent of the given input tensor element-wise.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>consumed_inputs</tt> : list of ints</dt>
<dd>legacy optimization attribute.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>1-D input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>The hyperbolic tangent values of the input tensor computed element-wise</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Tile-1"></a>**Tile-1**</a>

  Repeat the elements of a tensor along an axis.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>Input tensor of any shape.</dd>
<dt><tt>tiles</tt> : T</dt>
<dd>Number of repeated copies to make of the input tensor.</dd>
<dt><tt>axis</tt> : T</dt>
<dd>Axis along which to repeat.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Output tensor of same shape and type as input.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input types to float tensors.</dd>
<dt><tt>T1</tt> : tensor(int64)</dt>
<dd>Constrain tiles and axis's type to int64 tensors.</dd>
</dl>

### <a name="TopK-1"></a>**TopK-1**</a>

  Retrieve the top-K elements along a specified axis. Given an input tensor of
  shape [a_1, a_2, ..., a_n, r] and integer argument k, return two outputs:
    -Value tensor of shape [a_1, a_2, ..., a_{axis-1}, k, a_{axis+1}, ... a_n]
      which contains the values of the top k elements along the specified axis
    -Index tensor of shape [a_1, a_2, ..., a_{axis-1}, k, a_{axis+1}, ... a_n] which
     contains the indices of the top k elements (original indices from the input
     tensor).
  Given two equivalent values, this operator uses the indices along the axis  as
   a tiebreaker. That is, the element with the lower index will appear first.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is -1)</dt>
<dd>Dimension on which to do the sort.</dd>
<dt><tt>k</tt> : int (required)</dt>
<dd>Number of top elements to retrieve</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Tensor of shape [a_1, a_2, ..., a_n, r]</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Values</tt> : T</dt>
<dd>Tensor of shape [a_1, a_2, ..., a_{axis-1}, k, a_{axis+1}, ... a_n] containing top K values from the input tensor</dd>
<dt><tt>Indices</tt> : I</dt>
<dd>Tensor of shape [a_1, a_2, ..., a_{axis-1}, k, a_{axis+1}, ... a_n] containing the corresponding input tensor indices for the top K values.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>I</tt> : tensor(int64)</dt>
<dd>Constrain index tensor to int64</dd>
</dl>

### <a name="Transpose-1"></a>**Transpose-1**</a>

  Transpose the input tensor similar to numpy.transpose. For example, when
  perm=(1, 0, 2), given an input tensor of shape (1, 2, 3), the output shape
  will be (2, 1, 3).

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>perm</tt> : list of ints</dt>
<dd>A list of integers. By default, reverse the dimensions, otherwise permute the axes according to the values given.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>transposed</tt> : T</dt>
<dd>Transposed output.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

### <a name="Unsqueeze-1"></a>**Unsqueeze-1**</a>

  Insert single-dimensional entries to the shape of a tensor.
  Takes one required argument `axes`, a list of dimensions that will be inserted.
  Dimension indices in `axes` are as seen in the output tensor. For example:
    Given a tensor such that tensor with shape [3, 4, 5], then
    Unsqueeze(tensor, axes=[0, 4]) has shape [1, 3, 4, 5, 1]

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints (required)</dt>
<dd>List of non-negative integers, indicate the dimensions to be inserted</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>Original tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>expanded</tt> : T</dt>
<dd>Reshaped tensor with same data as input.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

### <a name="Upsample-1"></a>**Upsample-1**</a>

  Upsample the input tensor.
  The width and height of the output tensor are:
    output_width = floor(input_width * width_scale),
    output_height = floor(input_height * height_scale).
  Example:
    Given `data` tensor, width_scale, height_scale, mode,
    Upsample the input 4-D tensor in nearest mode:
    data = [[[
        [1, 2],
        [3, 4]
    ]]]
    width_scale = 2
    height_scale = 2
    mode = "nearest"
    output = [[[
        [1, 1, 2, 2],
        [1, 1, 2, 2],
        [3, 3, 4, 4],
        [3, 3, 4, 4]
    ]]]

#### Version

No versioning maintained for experimental ops.
#### Attributes

<dl>
<dt><tt>height_scale</tt> : float (required)</dt>
<dd>The scale along height dimension. It takes value greater than or equal to 1.</dd>
<dt><tt>mode</tt> : string (default is nearest)</dt>
<dd>Two interpolation modes: nearest(default), bilinear</dd>
<dt><tt>width_scale</tt> : float (required)</dt>
<dd>The scale along width dimension. It takes value greater than or equal to 1.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>4-D tensor, [N,C,H,W]</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>4-D tensor after resizing, [N,C,H,W]</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(bool), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain output types to bool, int32, int64, float16, float, double tensors.</dd>
</dl>

### <a name="Xor-1"></a>**Xor-1**</a>

  Returns the tensor resulted from performing the `xor` logical operation
  elementwise on the input tensors `A` and `B`.

  If broadcasting is enabled, the right-hand-side argument will be broadcasted
  to match the shape of left-hand-side argument. See the doc of `Add` for a
  detailed description of the broadcasting rules.

#### Version

This version of the operator has been available since version 1 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int</dt>
<dd>If set, defines the broadcast dimensions.</dd>
<dt><tt>broadcast</tt> : int (default is 0)</dt>
<dd>Enable broadcasting</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>Left input tensor for the logical operator.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Right input tensor for the logical operator.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T1</dt>
<dd>Result tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(bool)</dt>
<dd>Constrain input to boolean tensor.</dd>
<dt><tt>T1</tt> : tensor(bool)</dt>
<dd>Constrain output to boolean tensor.</dd>
</dl>

## Version 2 of the default ONNX operator set
### <a name="GlobalLpPool-2"></a>**GlobalLpPool-2**</a>

  GlobalLpPool consumes an input tensor X and applies lp pool pooling across
   the values in the same channel. This is equivalent to LpPool with kernel size
   equal to the spatial dimension of input tensor.

#### Version

This version of the operator has been available since version 2 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>p</tt> : int (default is 2)</dt>
<dd>p value of the Lp norm used to pool over the input data.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input data tensor from the previous operator; dimensions for image case are (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data. For non image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output data tensor from pooling across the input tensor. The output tensor has the same rank as the input. The first two dimensions of output shape are the same as the input (N x C), while the other dimensions are all 1.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="LpPool-2"></a>**LpPool-2**</a>

  LpPool consumes an input tensor X and applies Lp pooling across
   the tensor according to kernel sizes, stride sizes, and pad lengths.
   Lp pooling consisting of computing the Lp norm on all values of a subset
   of the input tensor according to the kernel size and downsampling the
   data into the output tensor Y for further processing.

#### Version

This version of the operator has been available since version 2 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>auto_pad</tt> : string (default is NOTSET)</dt>
<dd>auto_pad must be either NOTSET, SAME_UPPER, SAME_LOWER or VALID. Where default value is NOTSET, which means explicit padding is used. SAME_UPPER or SAME_LOWER mean pad the input so that the output spatial size match the input.In case of odd number add the extra padding at the end for SAME_UPPER and at the beginning for SAME_LOWER. VALID mean no padding.</dd>
<dt><tt>kernel_shape</tt> : list of ints (required)</dt>
<dd>The size of the kernel along each axis.</dd>
<dt><tt>p</tt> : int (default is 2)</dt>
<dd>p value of the Lp norm used to pool over the input data.</dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd>Padding for the beginning and ending along each spatial axis, it can take any value greater than or equal to 0. The value represent the number of pixels added to the beginning and end part of the corresponding axis. `pads` format should be as follow [x1_begin, x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels added at the beginning of axis `i` and xi_end, the number of pixels added at the end of axis `i`. This attribute cannot be used simultaneously with auto_pad attribute. If not present, the padding defaults to 0 along start and end of each spatial axis.</dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd>Stride along each spatial axis.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input data tensor from the previous operator; dimensions for image case are (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data. For non image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output data tensor from Lp pooling across the input tensor. Dimensions will vary based on various kernel, stride, and pad sizes.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Pad-2"></a>**Pad-2**</a>

  Given `data` tensor, pads, mode, and value.
  Example:
    Insert 0 pads to the beginning of the second dimension.
    data = [
        [1.0, 1.2],
        [2.3, 3.4],
        [4.5, 5.7],
    ]
    pads = [0, 2, 0, 0]
    output = [
        [
            [0.0, 0.0, 1.0, 1.2],
            [0.0, 0.0, 2.3, 3.4],
            [0.0, 0.0, 4.5, 5.7],
        ],
    ]

#### Version

This version of the operator has been available since version 2 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>mode</tt> : string (default is constant)</dt>
<dd>Three modes: constant(default), reflect, edge</dd>
<dt><tt>pads</tt> : list of ints (required)</dt>
<dd>List of integers indicating the number of padding elements to add or remove (if negative) at the beginning and end of each axis. For 2D it is the number of pixels. `pads` rank should be double of the input's rank. `pads` format should be as follow [x1_begin, x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels added at the beginning of axis `i` and xi_end, the number of pixels added at the end of axis `i`.</dd>
<dt><tt>value</tt> : float (default is 0.0)</dt>
<dd>One float, indicates the value to be filled.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>Input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Tensor after padding.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Split-2"></a>**Split-2**</a>

  Split a tensor into a list of tensors, along the specified
  'axis'. Lengths of the parts can be specified using argument 'split'.
  Otherwise, the tensor is split to equal sized parts.

#### Version

This version of the operator has been available since version 2 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 0)</dt>
<dd>Which axis to split on. </dd>
<dt><tt>split</tt> : list of ints</dt>
<dd>length of each output</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>The tensor to split</dd>
</dl>

#### Outputs (1 - &#8734;)

<dl>
<dt><tt>outputs</tt> (variadic) : T</dt>
<dd>One or more outputs forming list of tensors after splitting</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

## Version 3 of the default ONNX operator set
### <a name="GRU-3"></a>**GRU-3**</a>

  Computes an one-layer GRU. This operator is usually supported via some custom
  implementation such as CuDNN.

  Notations:

  `X` - input tensor

  `z` - update gate

  `r` - reset gate

  `h` - hidden gate

  `t` - time step (t-1 means previous time step)

  `W[zrh]` - W parameter weight matrix for update, reset, and hidden gates

  `R[zrh]` - R recurrence weight matrix for update, reset, and hidden gates

  `Wb[zrh]` - W bias vectors for update, reset, and hidden gates

  `Rb[zrh]` - R bias vectors for update, reset, and hidden gates

  `WB[zrh]` - W parameter weight matrix for backward update, reset, and hidden gates

  `RB[zrh]` - R recurrence weight matrix for backward update, reset, and hidden gates

  `WBb[zrh]` - W bias vectors for backward update, reset, and hidden gates

  `RBb[zrh]` - R bias vectors for backward update, reset, and hidden gates

  `H` - Hidden state

  `num_directions` - 2 if direction == bidirectional else 1

  Activation functions:

    Relu(x)                - max(0, x)

    Tanh(x)                - (1 - e^{-2x})/(1 + e^{-2x})

    Sigmoid(x)             - 1/(1 + e^{-x})

    (NOTE: Below are optional)

    Affine(x)              - alpha*x + beta

    LeakyRelu(x)           - x if x >= 0 else alpha * x

    ThresholdedRelu(x)     - x if x >= alpha else 0

    ScaledTanh(x)          - alpha*Tanh(beta*x)

    HardSigmoid(x)         - min(max(alpha*x + beta, 0), 1)

    Elu(x)                 - x if x >= 0 else alpha*(e^x - 1)

    Softsign(x)            - x/(1 + |x|)

    Softplus(x)            - log(1 + e^x)

  Equations (Default: f=Sigmoid, g=Tanh):

    - zt = f(Xt*(Wz^T) + Ht-1*Rz + Wbz + Rbz)

    - rt = f(Xt*(Wr^T) + Ht-1*Rr + Wbr + Rbr)

    - ht = g(Xt*(Wh^T) + (rt (.) Ht-1)*Rh + Rbh + Wbh) # default, when linear_before_reset = 0

    - ht = g(Xt*(Wh^T) + (rt (.) (Ht-1*Rh + Rbh) + Wbh) # when linear_before_reset != 0

    - Ht = (1 - zt) (.) ht + zt (.) Ht-1

#### Version

This version of the operator has been available since version 3 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>activation_alpha</tt> : list of floats</dt>
<dd>Optional scaling values used by some activation functions. The values are consumed in the order of activation functions, for example (f, g, h) in LSTM. Default values are the same as of corresponding ONNX operators.For example with LeakyRelu, the default alpha is 0.01.</dd>
<dt><tt>activation_beta</tt> : list of floats</dt>
<dd>Optional scaling values used by some activation functions. The values are consumed in the order of activation functions, for example (f, g, h) in LSTM. Default values are the same as of corresponding ONNX operators.</dd>
<dt><tt>activations</tt> : list of strings</dt>
<dd>A list of 2 (or 4 if bidirectional) activation functions for update, reset, and hidden gates. The activation functions must be one of the activation functions specified above. Optional: See the equations for default if not specified.</dd>
<dt><tt>clip</tt> : float</dt>
<dd>Cell clip threshold. Clipping bounds the elements of a tensor in the range of [-threshold, +threshold] and is applied to the input of activations. No clip if not specified.</dd>
<dt><tt>direction</tt> : string (default is forward)</dt>
<dd>Specify if the RNN is forward, reverse, or bidirectional. Must be one of forward (default), reverse, or bidirectional.</dd>
<dt><tt>hidden_size</tt> : int</dt>
<dd>Number of neurons in the hidden layer</dd>
<dt><tt>linear_before_reset</tt> : int (default is 0)</dt>
<dd>When computing the output of the hidden gate, apply the linear transformation before multiplying by the output of the reset gate.</dd>
<dt><tt>output_sequence</tt> : int (default is 0)</dt>
<dd>The sequence output for the hidden is optional if 0. Default 0.</dd>
</dl>

#### Inputs (3 - 6)

<dl>
<dt><tt>X</tt> : T</dt>
<dd>The input sequences packed (and potentially padded) into one 3-D tensor with the shape of `[seq_length, batch_size, input_size]`.</dd>
<dt><tt>W</tt> : T</dt>
<dd>The weight tensor for the gates. Concatenation of `W[zrh]` and `WB[zrh]` (if bidirectional) along dimension 0. This tensor has shape `[num_directions, 3*hidden_size, input_size]`.</dd>
<dt><tt>R</tt> : T</dt>
<dd>The recurrence weight tensor. Concatenation of `R[zrh]` and `RB[zrh]` (if bidirectional) along dimension 0. This tensor has shape `[num_directions, 3*hidden_size, hidden_size]`.</dd>
<dt><tt>B</tt> (optional) : T</dt>
<dd>The bias tensor for the gates. Concatenation of `[Wb[zrh], Rb[zrh]]` and `[WBb[zrh], RBb[zrh]]` (if bidirectional) along dimension 0. This tensor has shape `[num_directions, 6*hidden_size]`. Optional: If not specified - assumed to be 0</dd>
<dt><tt>sequence_lens</tt> (optional) : T1</dt>
<dd>Optional tensor specifying lengths of the sequences in a batch. If not specified - assumed all sequences in the batch to have length `seq_length`. It has shape `[batch_size]`.</dd>
<dt><tt>initial_h</tt> (optional) : T</dt>
<dd>Optional initial value of the hidden. If not specified - assumed to be 0. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
</dl>

#### Outputs (0 - 2)

<dl>
<dt><tt>Y</tt> (optional) : T</dt>
<dd>A tensor that concats all the intermediate output values of the hidden. It has shape `[seq_length, num_directions, batch_size, hidden_size]`. It is optional if `output_sequence` is 0.</dd>
<dt><tt>Y_h</tt> (optional) : T</dt>
<dd>The last output value of the hidden. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T1</tt> : tensor(int32)</dt>
<dd>Constrain seq_lens to integer tensor.</dd>
</dl>

## Version 4 of the default ONNX operator set
### <a name="Concat-4"></a>**Concat-4**</a>

  Concatenate a list of tensors into a single tensor

#### Version

This version of the operator has been available since version 4 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (required)</dt>
<dd>Which axis to concat on</dd>
</dl>

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>inputs</tt> (variadic) : T</dt>
<dd>List of tensors for concatenation</dd>
</dl>

#### Outputs

<dl>
<dt><tt>concat_result</tt> : T</dt>
<dd>Concatenated tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain output types to any tensor type.</dd>
</dl>

## Version 5 of the default ONNX operator set
### <a name="Reshape-5"></a>**Reshape-5**</a>

  Reshape the input tensor similar to numpy.reshape.
  First input is the data tensor, second input is a shape tensor which specifies the output shape. It outputs the reshaped tensor.
  At most one dimension of the new shape can be -1. In this case, the value is
  inferred from the size of the tensor and the remaining dimensions. A dimension
  could also be 0, in which case the actual dimension value is unchanged (i.e. taken
  from the input tensor). Shape (second input) could be an empty shape, which means converting to a scalar.
  The input tensor's shape and the output tensor's shape are required to have the same number of elements.

#### Version

This version of the operator has been available since version 5 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
<dt><tt>shape</tt> : tensor(int64)</dt>
<dd>Specified shape for output.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reshaped</tt> : T</dt>
<dd>Reshaped data.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

## Version 6 of the default ONNX operator set
### <a name="Abs-6"></a>**Abs-6**</a>

  Absolute takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the absolute is, y = abs(x), is applied to
  the tensor elementwise.

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to all numeric tensors.</dd>
</dl>

### <a name="Add-6"></a>**Add-6**</a>

  Performs element-wise binary addition (with limited broadcast support).

  If necessary the right-hand-side argument will be broadcasted to match the
  shape of left-hand-side argument. When broadcasting is specified, the second
  tensor can either be of element size 1 (including a scalar tensor and any
  tensor with rank equal to or smaller than the first tensor), or having its
  shape as a contiguous subset of the first tensor's shape. The starting of the
  mutually equal shape is specified by the argument "axis", and if it is not set,
  suffix matching is assumed. 1-dim expansion doesn't work yet.

  For example, the following tensor shapes are supported (with broadcast=1):

    shape(A) = (2, 3, 4, 5), shape(B) = (,), i.e. B is a scalar tensor
    shape(A) = (2, 3, 4, 5), shape(B) = (1, 1), i.e. B is an 1-element tensor
    shape(A) = (2, 3, 4, 5), shape(B) = (5,)
    shape(A) = (2, 3, 4, 5), shape(B) = (4, 5)
    shape(A) = (2, 3, 4, 5), shape(B) = (3, 4), with axis=1
    shape(A) = (2, 3, 4, 5), shape(B) = (2), with axis=0

  Attribute `broadcast=1` needs to be passed to enable broadcasting.

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int</dt>
<dd>If set, defines the broadcast dimensions. See doc for details.</dd>
<dt><tt>broadcast</tt> : int (default is 0)</dt>
<dd>Pass 1 to enable broadcasting</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>First operand, should share the type with the second operand.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Second operand. With broadcasting can be of smaller size than A. If broadcasting is disabled it should be of the same size.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T</dt>
<dd>Result, has same dimensions and type as A</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="BatchNormalization-6"></a>**BatchNormalization-6**</a>

  Carries out batch normalization as described in the paper
  https://arxiv.org/abs/1502.03167. Depending on the mode it is being run,
  there are multiple cases for the number of outputs, which we list below:

  Output case #1: Y, mean, var, saved_mean, saved_var (training mode)
  Output case #2: Y (test mode)

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>epsilon</tt> : float (default is 1e-05)</dt>
<dd>The epsilon value to use to avoid division by zero, default is 1e-5f.</dd>
<dt><tt>is_test</tt> : int (default is 0)</dt>
<dd>If set to nonzero, run spatial batch normalization in test mode, default is 0.</dd>
<dt><tt>momentum</tt> : float (default is 0.9)</dt>
<dd>Factor used in computing the running mean and variance.e.g., running_mean = running_mean * momentum + mean * (1 - momentum), default is 0.9f.</dd>
<dt><tt>spatial</tt> : int (default is 1)</dt>
<dd>If true, compute the mean and variance across all spatial elements If false, compute the mean and variance across per feature.Default is 1.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input data tensor from the previous operator; dimensions for image case are (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data. For non image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size.</dd>
<dt><tt>scale</tt> : T</dt>
<dd>The scale as a 1-dimensional tensor of size C to be applied to the output.</dd>
<dt><tt>B</tt> : T</dt>
<dd>The bias as a 1-dimensional tensor of size C to be applied to the output.</dd>
<dt><tt>mean</tt> : T</dt>
<dd>The running mean (training) or the estimated mean (testing) as a 1-dimensional tensor of size C.</dd>
<dt><tt>var</tt> : T</dt>
<dd>The running variance (training) or the estimated variance (testing) as a 1-dimensional tensor of size C.</dd>
</dl>

#### Outputs (1 - 5)

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>The output tensor of the same shape as X.</dd>
<dt><tt>mean</tt> (optional) : T</dt>
<dd>The running mean after the BatchNormalization operator. Must be in-place with the input mean. Should not be used for testing.</dd>
<dt><tt>var</tt> (optional) : T</dt>
<dd>The running variance after the BatchNormalization operator. Must be in-place with the input var. Should not be used for testing.</dd>
<dt><tt>saved_mean</tt> (optional) : T</dt>
<dd>Saved mean used during training to speed up gradient computation. Should not be used for testing.</dd>
<dt><tt>saved_var</tt> (optional) : T</dt>
<dd>Saved variance used during training to speed up gradient computation. Should not be used for testing.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Cast-6"></a>**Cast-6**</a>

  The operator casts the elements of a given input tensor to a data type
  specified by the 'to' argument and returns an output tensor of the same size in
  the converted type. The 'to' argument must be one of the data types specified
  in the 'DataType' enum field in the TensorProto message.
  NOTE: Casting to and from strings is not supported yet.

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>to</tt> : int (required)</dt>
<dd>The data type to which the elements of the input tensor are cast. Strictly must be one of the types from DataType enum in TensorProto</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T1</dt>
<dd>Input tensor to be cast.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T2</dt>
<dd>Output tensor with the same shape as input with type specified by the 'to' argument</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float16), tensor(float), tensor(double), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(bool)</dt>
<dd>Constrain input types. Casting from strings and complex are not supported.</dd>
<dt><tt>T2</tt> : tensor(float16), tensor(float), tensor(double), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(bool)</dt>
<dd>Constrain output types. Casting to strings and complex are not supported.</dd>
</dl>

### <a name="Ceil-6"></a>**Ceil-6**</a>

  Ceil takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the ceil is, y = ceil(x), is applied to
  the tensor elementwise.

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Clip-6"></a>**Clip-6**</a>

  Clip operator limits the given input within an interval. The interval is
  specified with arguments 'min' and 'max'. They default to
  numeric_limits::lowest() and numeric_limits::max() respectively.

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>max</tt> : float (default is (3.402823e+38))</dt>
<dd>Maximum value, above which element is replaced by max</dd>
<dt><tt>min</tt> : float (default is (-3.402823e+38))</dt>
<dd>Minimum value, under which element is replaced by min</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>Input tensor whose elements to be clipped</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Output tensor with clipped input elements</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Div-6"></a>**Div-6**</a>

  Performs element-wise binary division (with limited broadcast support).

  If necessary the right-hand-side argument will be broadcasted to match the
  shape of left-hand-side argument. When broadcasting is specified, the second
  tensor can either be of element size 1 (including a scalar tensor and any
  tensor with rank equal to or smaller than the first tensor), or having its
  shape as a contiguous subset of the first tensor's shape. The starting of the
  mutually equal shape is specified by the argument "axis", and if it is not set,
  suffix matching is assumed. 1-dim expansion doesn't work yet.

  For example, the following tensor shapes are supported (with broadcast=1):

    shape(A) = (2, 3, 4, 5), shape(B) = (,), i.e. B is a scalar tensor
    shape(A) = (2, 3, 4, 5), shape(B) = (1, 1), i.e. B is an 1-element tensor
    shape(A) = (2, 3, 4, 5), shape(B) = (5,)
    shape(A) = (2, 3, 4, 5), shape(B) = (4, 5)
    shape(A) = (2, 3, 4, 5), shape(B) = (3, 4), with axis=1
    shape(A) = (2, 3, 4, 5), shape(B) = (2), with axis=0

  Attribute `broadcast=1` needs to be passed to enable broadcasting.

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int</dt>
<dd>If set, defines the broadcast dimensions. See doc for details.</dd>
<dt><tt>broadcast</tt> : int (default is 0)</dt>
<dd>Pass 1 to enable broadcasting</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>First operand, should share the type with the second operand.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Second operand. With broadcasting can be of smaller size than A. If broadcasting is disabled it should be of the same size.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T</dt>
<dd>Result, has same dimensions and type as A</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="Dropout-6"></a>**Dropout-6**</a>

  Dropout takes one input data (Tensor<float>) and produces two Tensor outputs,
  output (Tensor<float>) and mask (Tensor<bool>). Depending on whether it is in
  test mode or not, the output Y will either be a random dropout, or a simple
  copy of the input. Note that our implementation of Dropout does scaling in
  the training phase, so during testing nothing needs to be done.

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>is_test</tt> : int (default is 0)</dt>
<dd>(int, default 0) if nonzero, run dropout in test mode where the output is simply Y = X.</dd>
<dt><tt>ratio</tt> : float (default is 0.5)</dt>
<dd>(float, default 0.5) the ratio of random dropout</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>The input data as Tensor.</dd>
</dl>

#### Outputs (1 - 2)

<dl>
<dt><tt>output</tt> : T</dt>
<dd>The output.</dd>
<dt><tt>mask</tt> (optional) : T</dt>
<dd>The output mask. If is_test is nonzero, this output is not filled.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Elu-6"></a>**Elu-6**</a>

  Elu takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the function `f(x) = alpha * (exp(x) - 1.) for x <
  0`, `f(x) = x for x >= 0`., is applied to the tensor elementwise.


#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float (default is 1.0)</dt>
<dd>Coefficient of ELU.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>1D input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>1D output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Exp-6"></a>**Exp-6**</a>

  Calculates the exponential of the given input tensor, element-wise.

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>The exponential of the input tensor computed element-wise</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Floor-6"></a>**Floor-6**</a>

  Floor takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the floor is, y = floor(x), is applied to
  the tensor elementwise.

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Gemm-6"></a>**Gemm-6**</a>

  General Matrix multiplication:
  https://en.wikipedia.org/wiki/Basic_Linear_Algebra_Subprograms#Level_3
  Compute Y = alpha * A * B + beta * C, where input tensor A has
  dimension (M X K), input tensor B has dimension (K X N), input tensor C and
  output tensor Y have dimension (M X N).
  If attribute broadcast is non-zero, input tensor C will be broadcasted to match
  the dimension requirement. A will be transposed before doing the computation
  if attribute transA is non-zero, same for B and transB.

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float (default is 1.0)</dt>
<dd>Scalar multiplier for the product of input tensors A * B, the default value is 1.0.</dd>
<dt><tt>beta</tt> : float (default is 1.0)</dt>
<dd>Scalar multiplier for input tensor C, the default value is 1.0.</dd>
<dt><tt>broadcast</tt> : int (default is 0)</dt>
<dd>Whether C should be broadcasted</dd>
<dt><tt>transA</tt> : int (default is 0)</dt>
<dd>Whether A should be transposed</dd>
<dt><tt>transB</tt> : int (default is 0)</dt>
<dd>Whether B should be transposed</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>Input tensor A</dd>
<dt><tt>B</tt> : T</dt>
<dd>Input tensor B</dd>
<dt><tt>C</tt> : T</dt>
<dd>Input tensor C</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="HardSigmoid-6"></a>**HardSigmoid-6**</a>

  HardSigmoid takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the HardSigmoid function, y = max(0, min(1, alpha * x + beta)),
  is applied to the tensor elementwise.

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float (default is 0.2)</dt>
<dd>Value of alpha.</dd>
<dt><tt>beta</tt> : float (default is 0.5)</dt>
<dd>Value of beta.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="InstanceNormalization-6"></a>**InstanceNormalization-6**</a>

  Carries out instance normalization as described in the paper
  https://arxiv.org/abs/1607.08022.

  y = scale * (x - mean) / sqrt(variance + epsilon) + B,
  where mean and variance are computed per instance per channel.


#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>epsilon</tt> : float (default is 1e-05)</dt>
<dd>The epsilon value to use to avoid division by zero.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Input data tensor from the previous operator; dimensions for image case are (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data. For non image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size.</dd>
<dt><tt>scale</tt> (differentiable) : T</dt>
<dd>The input 1-dimensional scale tensor of size C.</dd>
<dt><tt>B</tt> (differentiable) : T</dt>
<dd>The input 1-dimensional bias tensor of size C.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>The output tensor of the same shape as input.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="LeakyRelu-6"></a>**LeakyRelu-6**</a>

  LeakyRelu takes input data (Tensor<T>) and an argument alpha, and produces one
  output data (Tensor<T>) where the function `f(x) = alpha * x for x < 0`,
  `f(x) = x for x >= 0`, is applied to the data tensor elementwise.

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float (default is 0.01)</dt>
<dd>Coefficient of leakage.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Log-6"></a>**Log-6**</a>

  Calculates the natural log of the given input tensor, element-wise.

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>The natural log of the input tensor computed element-wise</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Max-6"></a>**Max-6**</a>

  Element-wise max of each of the input tensors. All inputs and outputs must
  have the same shape and data type.

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>data_0</tt> (variadic) : T</dt>
<dd>List of tensors for Max.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>max</tt> : T</dt>
<dd>Output tensor. Same dimension as inputs.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Mean-6"></a>**Mean-6**</a>

  Element-wise mean of each of the input tensors. All inputs and outputs must
  have the same shape and data type.

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>data_0</tt> (variadic) : T</dt>
<dd>List of tensors for Mean.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>mean</tt> : T</dt>
<dd>Output tensor. Same dimension as inputs.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Min-6"></a>**Min-6**</a>

  Element-wise min of each of the input tensors. All inputs and outputs must
  have the same shape and data type.

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>data_0</tt> (variadic) : T</dt>
<dd>List of tensors for Min</dd>
</dl>

#### Outputs

<dl>
<dt><tt>min</tt> : T</dt>
<dd>Output tensor. Same dimension as inputs.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Mul-6"></a>**Mul-6**</a>

  Performs element-wise binary multiplication (with limited broadcast support).

  If necessary the right-hand-side argument will be broadcasted to match the
  shape of left-hand-side argument. When broadcasting is specified, the second
  tensor can either be of element size 1 (including a scalar tensor and any
  tensor with rank equal to or smaller than the first tensor), or having its
  shape as a contiguous subset of the first tensor's shape. The starting of the
  mutually equal shape is specified by the argument "axis", and if it is not set,
  suffix matching is assumed. 1-dim expansion doesn't work yet.

  For example, the following tensor shapes are supported (with broadcast=1):

    shape(A) = (2, 3, 4, 5), shape(B) = (,), i.e. B is a scalar tensor
    shape(A) = (2, 3, 4, 5), shape(B) = (1, 1), i.e. B is an 1-element tensor
    shape(A) = (2, 3, 4, 5), shape(B) = (5,)
    shape(A) = (2, 3, 4, 5), shape(B) = (4, 5)
    shape(A) = (2, 3, 4, 5), shape(B) = (3, 4), with axis=1
    shape(A) = (2, 3, 4, 5), shape(B) = (2), with axis=0

  Attribute `broadcast=1` needs to be passed to enable broadcasting.

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int</dt>
<dd>If set, defines the broadcast dimensions. See doc for details.</dd>
<dt><tt>broadcast</tt> : int (default is 0)</dt>
<dd>Pass 1 to enable broadcasting</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>First operand, should share the type with the second operand.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Second operand. With broadcasting can be of smaller size than A. If broadcasting is disabled it should be of the same size.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T</dt>
<dd>Result, has same dimensions and type as A</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="Neg-6"></a>**Neg-6**</a>

  Neg takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where each element flipped sign, y = -x, is applied to
  the tensor elementwise.

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(int32), tensor(int8), tensor(int16), tensor(int64), tensor(float16), tensor(double)</dt>
<dd>Constrain input and output types to signed numeric tensors.</dd>
</dl>

### <a name="PRelu-6"></a>**PRelu-6**</a>

  PRelu takes input data (Tensor<T>) and slope tensor as input, and produces one
  output data (Tensor<T>) where the function `f(x) = slope * x for x < 0`,
  `f(x) = x for x >= 0`., is applied to the data tensor elementwise.


#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor</dd>
<dt><tt>slope</tt> : T</dt>
<dd>Slope tensor. If `Slope` is of size 1, the value is sharedacross different channels</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Reciprocal-6"></a>**Reciprocal-6**</a>

  Reciprocal takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the reciprocal is, y = 1/x, is applied to
  the tensor elementwise.

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Relu-6"></a>**Relu-6**</a>

  Relu takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the rectified linear function, y = max(0, x), is applied to
  the tensor elementwise.

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Selu-6"></a>**Selu-6**</a>

  Selu takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the scaled exponential linear unit function,
  `y = gamma * (alpha * e^x - alpha) for x <= 0`, `y = gamma * x for x > 0`,
  is applied to the tensor elementwise.

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float (default is 1.67326)</dt>
<dd>Coefficient of SELU default to 1.67326319217681884765625 (i.e., float32 approximation of 1.6732632423543772848170429916717).</dd>
<dt><tt>gamma</tt> : float (default is 1.0507)</dt>
<dd>Coefficient of SELU default to 1.05070102214813232421875 (i.e., float32 approximation of 1.0507009873554804934193349852946).</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Sigmoid-6"></a>**Sigmoid-6**</a>

  Sigmoid takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the sigmoid function, y = 1 / (1 + exp(-x)), is applied to the
  tensor elementwise.

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Sqrt-6"></a>**Sqrt-6**</a>

  Square root takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the square root is, y = x^0.5, is applied to
  the tensor elementwise. If x is negative, then it will return NaN.

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Sub-6"></a>**Sub-6**</a>

  Performs element-wise binary subtraction (with limited broadcast support).

  If necessary the right-hand-side argument will be broadcasted to match the
  shape of left-hand-side argument. When broadcasting is specified, the second
  tensor can either be of element size 1 (including a scalar tensor and any
  tensor with rank equal to or smaller than the first tensor), or having its
  shape as a contiguous subset of the first tensor's shape. The starting of the
  mutually equal shape is specified by the argument "axis", and if it is not set,
  suffix matching is assumed. 1-dim expansion doesn't work yet.

  For example, the following tensor shapes are supported (with broadcast=1):

    shape(A) = (2, 3, 4, 5), shape(B) = (,), i.e. B is a scalar tensor
    shape(A) = (2, 3, 4, 5), shape(B) = (1, 1), i.e. B is an 1-element tensor
    shape(A) = (2, 3, 4, 5), shape(B) = (5,)
    shape(A) = (2, 3, 4, 5), shape(B) = (4, 5)
    shape(A) = (2, 3, 4, 5), shape(B) = (3, 4), with axis=1
    shape(A) = (2, 3, 4, 5), shape(B) = (2), with axis=0

  Attribute `broadcast=1` needs to be passed to enable broadcasting.

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int</dt>
<dd>If set, defines the broadcast dimensions. See doc for details.</dd>
<dt><tt>broadcast</tt> : int (default is 0)</dt>
<dd>Pass 1 to enable broadcasting</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>First operand, should share the type with the second operand.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Second operand. With broadcasting can be of smaller size than A. If broadcasting is disabled it should be of the same size.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T</dt>
<dd>Result, has same dimensions and type as A</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="Sum-6"></a>**Sum-6**</a>

  Element-wise sum of each of the input tensors. All inputs and outputs must
  have the same shape and data type.

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>data_0</tt> (variadic) : T</dt>
<dd>List of tensors for Sum.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>sum</tt> : T</dt>
<dd>Output tensor. Same dimension as inputs.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Tanh-6"></a>**Tanh-6**</a>

  Calculates the hyperbolic tangent of the given input tensor element-wise.

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>The hyperbolic tangent values of the input tensor computed element-wise</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Tile-6"></a>**Tile-6**</a>

  Constructs a tensor by tiling a given tensor.
  This is the same as function `tile` in Numpy, but no broadcast.
  For example A = [[1, 2], [3, 4]], B = [1, 2], tile(A, B) = [[1, 2, 1, 2], [3, 4, 3, 4]]

#### Version

This version of the operator has been available since version 6 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>Input tensor of any shape.</dd>
<dt><tt>repeats</tt> : T1</dt>
<dd>1D int64 tensor of the same length as input's dimension number, includes numbers of repeated copies along input's dimensions.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Output tensor of the same dimensions and type as tensor input. output_dim[i] = input_dim[i] * repeats[i]</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
<dt><tt>T1</tt> : tensor(int64)</dt>
<dd>Constrain repeat's type to int64 tensors.</dd>
</dl>

## Version 7 of the default ONNX operator set
### <a name="Acos-7"></a>**Acos-7**</a>

  Calculates the arccosine (inverse of cosine) of the given input tensor, element-wise.

#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>The arccosine of the input tensor computed element-wise</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Add-7"></a>**Add-7**</a>

  Performs element-wise binary addition (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>First operand.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Second operand.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T</dt>
<dd>Result, has same element type as two inputs</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="And-7"></a>**And-7**</a>

  Returns the tensor resulted from performing the `and` logical operation
  elementwise on the input tensors `A` and `B` (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> (non-differentiable) : T</dt>
<dd>First input operand for the logical operator.</dd>
<dt><tt>B</tt> (non-differentiable) : T</dt>
<dd>Second input operand for the logical operator.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> (non-differentiable) : T1</dt>
<dd>Result tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(bool)</dt>
<dd>Constrain input to boolean tensor.</dd>
<dt><tt>T1</tt> : tensor(bool)</dt>
<dd>Constrain output to boolean tensor.</dd>
</dl>

### <a name="Asin-7"></a>**Asin-7**</a>

  Calculates the arcsine (inverse of sine) of the given input tensor, element-wise.

#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>The arcsine of the input tensor computed element-wise</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Atan-7"></a>**Atan-7**</a>

  Calculates the arctangent (inverse of tangent) of the given input tensor, element-wise.

#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>The arctangent of the input tensor computed element-wise</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="AveragePool-7"></a>**AveragePool-7**</a>

  AveragePool consumes an input tensor X and applies average pooling across
   the tensor according to kernel sizes, stride sizes, and pad lengths.
   average pooling consisting of computing the average on all values of a
   subset of the input tensor according to the kernel size and downsampling the
   data into the output tensor Y for further processing. The output spatial shape will be following:
   ```
   output_spatial_shape[i] = floor((input_spatial_shape[i] + pad_shape[i] - kernel_spatial_shape[i]) / strides_spatial_shape[i] + 1)

   * pad_shape[i] is sum of pads along axis i
   ```

   `auto_pad` is a DEPRECATED attribute. If you are using them currently, the output spatial shape will be following:
   ```
   VALID: output_spatial_shape[i] = ceil((input_spatial_shape[i] - kernel_spatial_shape[i] + 1) / strides_spatial_shape[i])
   SAME_UPPER or SAME_LOWER: output_spatial_shape[i] = ceil(input_spatial_shape[i] / strides_spatial_shape[i])
   ```
   And pad shape will be following if `SAME_UPPER` or `SAME_LOWER`:
   ```
   pad_shape[i] = (output_spatial_shape[i] - 1) * strides_spatial_shape[i] + kernel_spatial_shape[i] - input_spatial_shape[i]
   ```
   The output of each pooling window is divided by the number of elements (exclude pad when attribute count_include_pad is zero).


#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>auto_pad</tt> : string (default is NOTSET)</dt>
<dd>auto_pad must be either NOTSET, SAME_UPPER, SAME_LOWER or VALID. Where default value is NOTSET, which means explicit padding is used. SAME_UPPER or SAME_LOWER mean pad the input so that the output spatial size match the input.In case of odd number add the extra padding at the end for SAME_UPPER and at the beginning for SAME_LOWER. VALID mean no padding.</dd>
<dt><tt>count_include_pad</tt> : int (default is 0)</dt>
<dd>Whether include pad pixels when calculating values for the edges. Default is 0, doesn't count include pad.</dd>
<dt><tt>kernel_shape</tt> : list of ints (required)</dt>
<dd>The size of the kernel along each axis.</dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd>Padding for the beginning and ending along each spatial axis, it can take any value greater than or equal to 0. The value represent the number of pixels added to the beginning and end part of the corresponding axis. `pads` format should be as follow [x1_begin, x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels added at the beginning of axis `i` and xi_end, the number of pixels added at the end of axis `i`. This attribute cannot be used simultaneously with auto_pad attribute. If not present, the padding defaults to 0 along start and end of each spatial axis.</dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd>Stride along each spatial axis.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input data tensor from the previous operator; dimensions for image case are (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data. For non image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size. Optionally, if dimension denotation is in effect, the operation expects the input data tensor to arrive with the dimension denotation of [DATA_BATCH, DATA_CHANNEL, DATA_FEATURE, DATA_FEATURE ...].</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output data tensor from average or max pooling across the input tensor. Dimensions will vary based on various kernel, stride, and pad sizes. Floor value of the dimension is used</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="BatchNormalization-7"></a>**BatchNormalization-7**</a>

  Carries out batch normalization as described in the paper
      https://arxiv.org/abs/1502.03167. Depending on the mode it is being run,
      there are multiple cases for the number of outputs, which we list below:

      Output case #1: Y, mean, var, saved_mean, saved_var (training mode)
      Output case #2: Y (test mode)
          This operator has **optional** inputs/outputs. See [the doc](IR.md) for more details about the representation of optional arguments. An empty string may be used in the place of an actual argument's name to indicate a missing argument. Trailing optional arguments (those not followed by an argument that is present) may also be simply omitted.

#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>epsilon</tt> : float (default is 1e-05)</dt>
<dd>The epsilon value to use to avoid division by zero.</dd>
<dt><tt>momentum</tt> : float (default is 0.9)</dt>
<dd>Factor used in computing the running mean and variance.e.g., running_mean = running_mean * momentum + mean * (1 - momentum).</dd>
<dt><tt>spatial</tt> : int (default is 1)</dt>
<dd>If true, compute the mean and variance across per activation. If false, compute the mean and variance across per feature over each mini-batch.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input data tensor from the previous operator; dimensions for image case are (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data. For non image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size.</dd>
<dt><tt>scale</tt> : T</dt>
<dd>If spatial is true, the dimension of scale is (C). If spatial is false, the dimensions of scale are (C x D1 x ... x Dn)</dd>
<dt><tt>B</tt> : T</dt>
<dd>If spatial is true, the dimension of bias is (C). If spatial is false, the dimensions of bias are (C x D1 x ... x Dn)</dd>
<dt><tt>mean</tt> : T</dt>
<dd>If spatial is true, the dimension of the running mean (training) or the estimated mean (testing) is (C). If spatial is false, the dimensions of the running mean (training) or the estimated mean (testing) are (C x D1 x ... x Dn).</dd>
<dt><tt>var</tt> : T</dt>
<dd>If spatial is true, the dimension of the running variance(training) or the estimated variance (testing) is (C). If spatial is false, the dimensions of the running variance(training) or the estimated variance (testing) are (C x D1 x ... x Dn).</dd>
</dl>

#### Outputs (1 - 5)

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>The output tensor of the same shape as X</dd>
<dt><tt>mean</tt> (optional) : T</dt>
<dd>The running mean after the BatchNormalization operator.</dd>
<dt><tt>var</tt> (optional) : T</dt>
<dd>The running variance after the BatchNormalization operator.</dd>
<dt><tt>saved_mean</tt> (optional) : T</dt>
<dd>Saved mean used during training to speed up gradient computation.</dd>
<dt><tt>saved_var</tt> (optional) : T</dt>
<dd>Saved variance used during training to speed up gradient computation.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Cos-7"></a>**Cos-7**</a>

  Calculates the cosine of the given input tensor, element-wise.

#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>The cosine of the input tensor computed element-wise</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Div-7"></a>**Div-7**</a>

  Performs element-wise binary division (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>First operand.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Second operand.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T</dt>
<dd>Result, has same element type as two inputs</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="Dropout-7"></a>**Dropout-7**</a>

  Dropout takes one input data (Tensor<float>) and produces two Tensor outputs,
  output (Tensor<float>) and mask (Tensor<bool>). Depending on whether it is in
  test mode or not, the output Y will either be a random dropout, or a simple
  copy of the input. Note that our implementation of Dropout does scaling in
  the training phase, so during testing nothing needs to be done.
  This operator has **optional** inputs/outputs. See [the doc](IR.md) for more details about the representation of optional arguments. An empty string may be used in the place of an actual argument's name to indicate a missing argument. Trailing optional arguments (those not followed by an argument that is present) may also be simply omitted.

#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>ratio</tt> : float (default is 0.5)</dt>
<dd>The ratio of random dropout</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>The input data as Tensor.</dd>
</dl>

#### Outputs (1 - 2)

<dl>
<dt><tt>output</tt> : T</dt>
<dd>The output.</dd>
<dt><tt>mask</tt> (optional) : T</dt>
<dd>The output mask.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Equal-7"></a>**Equal-7**</a>

  Returns the tensor resulted from performing the `equal` logical operation
  elementwise on the input tensors `A` and `B` (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>First input operand for the logical operator.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Second input operand for the logical operator.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T1</dt>
<dd>Result tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(bool), tensor(int32), tensor(int64)</dt>
<dd>Constrain input to integral tensors.</dd>
<dt><tt>T1</tt> : tensor(bool)</dt>
<dd>Constrain output to boolean tensor.</dd>
</dl>

### <a name="GRU-7"></a>**GRU-7**</a>

  Computes an one-layer GRU. This operator is usually supported via some custom
  implementation such as CuDNN.

  Notations:

  `X` - input tensor

  `z` - update gate

  `r` - reset gate

  `h` - hidden gate

  `t` - time step (t-1 means previous time step)

  `W[zrh]` - W parameter weight matrix for update, reset, and hidden gates

  `R[zrh]` - R recurrence weight matrix for update, reset, and hidden gates

  `Wb[zrh]` - W bias vectors for update, reset, and hidden gates

  `Rb[zrh]` - R bias vectors for update, reset, and hidden gates

  `WB[zrh]` - W parameter weight matrix for backward update, reset, and hidden gates

  `RB[zrh]` - R recurrence weight matrix for backward update, reset, and hidden gates

  `WBb[zrh]` - W bias vectors for backward update, reset, and hidden gates

  `RBb[zrh]` - R bias vectors for backward update, reset, and hidden gates

  `H` - Hidden state

  `num_directions` - 2 if direction == bidirectional else 1

  Activation functions:

    Relu(x)                - max(0, x)

    Tanh(x)                - (1 - e^{-2x})/(1 + e^{-2x})

    Sigmoid(x)             - 1/(1 + e^{-x})

    (NOTE: Below are optional)

    Affine(x)              - alpha*x + beta

    LeakyRelu(x)           - x if x >= 0 else alpha * x

    ThresholdedRelu(x)     - x if x >= alpha else 0

    ScaledTanh(x)          - alpha*Tanh(beta*x)

    HardSigmoid(x)         - min(max(alpha*x + beta, 0), 1)

    Elu(x)                 - x if x >= 0 else alpha*(e^x - 1)

    Softsign(x)            - x/(1 + |x|)

    Softplus(x)            - log(1 + e^x)

  Equations (Default: f=Sigmoid, g=Tanh):

    - zt = f(Xt*(Wz^T) + Ht-1*(Rz^T) + Wbz + Rbz)

    - rt = f(Xt*(Wr^T) + Ht-1*(Rr^T) + Wbr + Rbr)

    - ht = g(Xt*(Wh^T) + (rt (.) Ht-1)*(Rh^T) + Rbh + Wbh) # default, when linear_before_reset = 0

    - ht = g(Xt*(Wh^T) + (rt (.) (Ht-1*(Rh^T) + Rbh)) + Wbh) # when linear_before_reset != 0

    - Ht = (1 - zt) (.) ht + zt (.) Ht-1
  This operator has **optional** inputs/outputs. See [the doc](IR.md) for more details about the representation of optional arguments. An empty string may be used in the place of an actual argument's name to indicate a missing argument. Trailing optional arguments (those not followed by an argument that is present) may also be simply omitted.

#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>activation_alpha</tt> : list of floats</dt>
<dd>Optional scaling values used by some activation functions. The values are consumed in the order of activation functions, for example (f, g, h) in LSTM. Default values are the same as of corresponding ONNX operators.For example with LeakyRelu, the default alpha is 0.01.</dd>
<dt><tt>activation_beta</tt> : list of floats</dt>
<dd>Optional scaling values used by some activation functions. The values are consumed in the order of activation functions, for example (f, g, h) in LSTM. Default values are the same as of corresponding ONNX operators.</dd>
<dt><tt>activations</tt> : list of strings</dt>
<dd>A list of 2 (or 4 if bidirectional) activation functions for update, reset, and hidden gates. The activation functions must be one of the activation functions specified above. Optional: See the equations for default if not specified.</dd>
<dt><tt>clip</tt> : float</dt>
<dd>Cell clip threshold. Clipping bounds the elements of a tensor in the range of [-threshold, +threshold] and is applied to the input of activations. No clip if not specified.</dd>
<dt><tt>direction</tt> : string (default is forward)</dt>
<dd>Specify if the RNN is forward, reverse, or bidirectional. Must be one of forward (default), reverse, or bidirectional.</dd>
<dt><tt>hidden_size</tt> : int</dt>
<dd>Number of neurons in the hidden layer</dd>
<dt><tt>linear_before_reset</tt> : int (default is 0)</dt>
<dd>When computing the output of the hidden gate, apply the linear transformation before multiplying by the output of the reset gate.</dd>
</dl>

#### Inputs (3 - 6)

<dl>
<dt><tt>X</tt> : T</dt>
<dd>The input sequences packed (and potentially padded) into one 3-D tensor with the shape of `[seq_length, batch_size, input_size]`.</dd>
<dt><tt>W</tt> : T</dt>
<dd>The weight tensor for the gates. Concatenation of `W[zrh]` and `WB[zrh]` (if bidirectional) along dimension 0. This tensor has shape `[num_directions, 3*hidden_size, input_size]`.</dd>
<dt><tt>R</tt> : T</dt>
<dd>The recurrence weight tensor. Concatenation of `R[zrh]` and `RB[zrh]` (if bidirectional) along dimension 0. This tensor has shape `[num_directions, 3*hidden_size, hidden_size]`.</dd>
<dt><tt>B</tt> (optional) : T</dt>
<dd>The bias tensor for the gates. Concatenation of `[Wb[zrh], Rb[zrh]]` and `[WBb[zrh], RBb[zrh]]` (if bidirectional) along dimension 0. This tensor has shape `[num_directions, 6*hidden_size]`. Optional: If not specified - assumed to be 0</dd>
<dt><tt>sequence_lens</tt> (optional) : T1</dt>
<dd>Optional tensor specifying lengths of the sequences in a batch. If not specified - assumed all sequences in the batch to have length `seq_length`. It has shape `[batch_size]`.</dd>
<dt><tt>initial_h</tt> (optional) : T</dt>
<dd>Optional initial value of the hidden. If not specified - assumed to be 0. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
</dl>

#### Outputs (0 - 2)

<dl>
<dt><tt>Y</tt> (optional) : T</dt>
<dd>A tensor that concats all the intermediate output values of the hidden. It has shape `[seq_length, num_directions, batch_size, hidden_size]`. </dd>
<dt><tt>Y_h</tt> (optional) : T</dt>
<dd>The last output value of the hidden. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T1</tt> : tensor(int32)</dt>
<dd>Constrain seq_lens to integer tensor.</dd>
</dl>

### <a name="Gemm-7"></a>**Gemm-7**</a>

  General Matrix multiplication:
  https://en.wikipedia.org/wiki/Basic_Linear_Algebra_Subprograms#Level_3

  A' = transpose(A) if transA else A

  B' = transpose(B) if transB else B

  Compute Y = alpha * A' * B' + beta * C, where input tensor A has shape (M, K) or (K, M),
  input tensor B has shape (K, N) or (N, K), input tensor C is broadcastable to shape (M, N),
  and output tensor Y has shape (M, N). A will be transposed before doing the
  computation if attribute transA is non-zero, same for B and transB.
  This operator supports **unidirectional broadcasting** (tensor C should be unidirectional broadcastable to tensor A * B); for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float (default is 1.0)</dt>
<dd>Scalar multiplier for the product of input tensors A * B.</dd>
<dt><tt>beta</tt> : float (default is 1.0)</dt>
<dd>Scalar multiplier for input tensor C.</dd>
<dt><tt>transA</tt> : int (default is 0)</dt>
<dd>Whether A should be transposed</dd>
<dt><tt>transB</tt> : int (default is 0)</dt>
<dd>Whether B should be transposed</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>Input tensor A. The shape of A should be (M, K) if transA is 0, or (K, M) if transA is non-zero.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Input tensor B. The shape of B should be (K, N) if transB is 0, or (N, K) if transB is non-zero.</dd>
<dt><tt>C</tt> : T</dt>
<dd>Input tensor C. The shape of C should be unidirectional broadcastable to (M, N).</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor of shape (M, N).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Greater-7"></a>**Greater-7**</a>

  Returns the tensor resulted from performing the `greater` logical operation
  elementwise on the input tensors `A` and `B` (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>First input operand for the logical operator.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Second input operand for the logical operator.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T1</dt>
<dd>Result tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input to float tensors.</dd>
<dt><tt>T1</tt> : tensor(bool)</dt>
<dd>Constrain output to boolean tensor.</dd>
</dl>

### <a name="LSTM-7"></a>**LSTM-7**</a>

  Computes an one-layer LSTM. This operator is usually supported via some
  custom implementation such as CuDNN.

  Notations:

  `X` - input tensor

  `i` - input gate

  `o` - output gate

  `f` - forget gate

  `c` - cell gate

  `t` - time step (t-1 means previous time step)

  `W[iofc]` - W parameter weight matrix for input, output, forget, and cell gates

  `R[iofc]` - R recurrence weight matrix for input, output, forget, and cell gates

  `Wb[iofc]` - W bias vectors for input, output, forget, and cell gates

  `Rb[iofc]` - R bias vectors for input, output, forget, and cell gates

  `P[iof]`  - P peephole weight vector for input, output, and forget gates

  `WB[iofc]` - W parameter weight matrix for backward input, output, forget, and cell gates

  `RB[iofc]` - R recurrence weight matrix for backward input, output, forget, and cell gates

  `WBb[iofc]` - W bias vectors for backward input, output, forget, and cell gates

  `RBb[iofc]` - R bias vectors for backward input, output, forget, and cell gates

  `PB[iof]`  - P peephole weight vector for backward input, output, and forget gates

  `H` - Hidden state

  `num_directions` - 2 if direction == bidirectional else 1

  Activation functions:

    Relu(x)                - max(0, x)

    Tanh(x)                - (1 - e^{-2x})/(1 + e^{-2x})

    Sigmoid(x)             - 1/(1 + e^{-x})

    (NOTE: Below are optional)

    Affine(x)              - alpha*x + beta

    LeakyRelu(x)           - x if x >= 0 else alpha * x

    ThresholdedRelu(x)     - x if x >= alpha else 0

    ScaledTanh(x)          - alpha*Tanh(beta*x)

    HardSigmoid(x)         - min(max(alpha*x + beta, 0), 1)

    Elu(x)                 - x if x >= 0 else alpha*(e^x - 1)

    Softsign(x)            - x/(1 + |x|)

    Softplus(x)            - log(1 + e^x)

  Equations (Default: f=Sigmoid, g=Tanh, h=Tanh):

    - it = f(Xt*(Wi^T) + Ht-1*(Ri^T) + Pi (.) Ct-1 + Wbi + Rbi)

    - ft = f(Xt*(Wf^T) + Ht-1*(Rf^T) + Pf (.) Ct-1 + Wbf + Rbf)

    - ct = g(Xt*(Wc^T) + Ht-1*(Rc^T) + Wbc + Rbc)

    - Ct = ft (.) Ct-1 + it (.) ct

    - ot = f(Xt*(Wo^T) + Ht-1*(Ro^T) + Po (.) Ct + Wbo + Rbo)

    - Ht = ot (.) h(Ct)
  This operator has **optional** inputs/outputs. See [the doc](IR.md) for more details about the representation of optional arguments. An empty string may be used in the place of an actual argument's name to indicate a missing argument. Trailing optional arguments (those not followed by an argument that is present) may also be simply omitted.

#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>activation_alpha</tt> : list of floats</dt>
<dd>Optional scaling values used by some activation functions. The values are consumed in the order of activation functions, for example (f, g, h) in LSTM. Default values are the same as of corresponding ONNX operators.For example with LeakyRelu, the default alpha is 0.01.</dd>
<dt><tt>activation_beta</tt> : list of floats</dt>
<dd>Optional scaling values used by some activation functions. The values are consumed in the order of activation functions, for example (f, g, h) in LSTM. Default values are the same as of corresponding ONNX operators.</dd>
<dt><tt>activations</tt> : list of strings</dt>
<dd>A list of 3 (or 6 if bidirectional) activation functions for input, output, forget, cell, and hidden. The activation functions must be one of the activation functions specified above. Optional: See the equations for default if not specified.</dd>
<dt><tt>clip</tt> : float</dt>
<dd>Cell clip threshold. Clipping bounds the elements of a tensor in the range of [-threshold, +threshold] and is applied to the input of activations. No clip if not specified.</dd>
<dt><tt>direction</tt> : string (default is forward)</dt>
<dd>Specify if the RNN is forward, reverse, or bidirectional. Must be one of forward (default), reverse, or bidirectional.</dd>
<dt><tt>hidden_size</tt> : int</dt>
<dd>Number of neurons in the hidden layer</dd>
<dt><tt>input_forget</tt> : int (default is 0)</dt>
<dd>Couple the input and forget gates if 1.</dd>
</dl>

#### Inputs (3 - 8)

<dl>
<dt><tt>X</tt> : T</dt>
<dd>The input sequences packed (and potentially padded) into one 3-D tensor with the shape of `[seq_length, batch_size, input_size]`.</dd>
<dt><tt>W</tt> : T</dt>
<dd>The weight tensor for the gates. Concatenation of `W[iofc]` and `WB[iofc]` (if bidirectional) along dimension 0. The tensor has shape `[num_directions, 4*hidden_size, input_size]`.</dd>
<dt><tt>R</tt> : T</dt>
<dd>The recurrence weight tensor. Concatenation of `R[iofc]` and `RB[iofc]` (if bidirectional) along dimension 0. This tensor has shape `[num_directions, 4*hidden_size, hidden_size]`.</dd>
<dt><tt>B</tt> (optional) : T</dt>
<dd>The bias tensor for input gate. Concatenation of `[Wb[iofc], Rb[iofc]]`, and `[WBb[iofc], RBb[iofc]]` (if bidirectional) along dimension 0. This tensor has shape `[num_directions, 8*hidden_size]`. Optional: If not specified - assumed to be 0.</dd>
<dt><tt>sequence_lens</tt> (optional) : T1</dt>
<dd>Optional tensor specifying lengths of the sequences in a batch. If not specified - assumed all sequences in the batch to have length `seq_length`. It has shape `[batch_size]`.</dd>
<dt><tt>initial_h</tt> (optional) : T</dt>
<dd>Optional initial value of the hidden. If not specified - assumed to be 0. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
<dt><tt>initial_c</tt> (optional) : T</dt>
<dd>Optional initial value of the cell. If not specified - assumed to be 0. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
<dt><tt>P</tt> (optional) : T</dt>
<dd>The weight tensor for peepholes. Concatenation of `P[iof]` and `PB[iof]` (if bidirectional) along dimension 0. It has shape `[num_directions, 3*hidde_size]`. Optional: If not specified - assumed to be 0.</dd>
</dl>

#### Outputs (0 - 3)

<dl>
<dt><tt>Y</tt> (optional) : T</dt>
<dd>A tensor that concats all the intermediate output values of the hidden. It has shape `[seq_length, num_directions, batch_size, hidden_size]`. </dd>
<dt><tt>Y_h</tt> (optional) : T</dt>
<dd>The last output value of the hidden. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
<dt><tt>Y_c</tt> (optional) : T</dt>
<dd>The last output value of the cell. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T1</tt> : tensor(int32)</dt>
<dd>Constrain seq_lens to integer tensor.</dd>
</dl>

### <a name="Less-7"></a>**Less-7**</a>

  Returns the tensor resulted from performing the `less` logical operation
  elementwise on the input tensors `A` and `B` (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>First input operand for the logical operator.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Second input operand for the logical operator.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T1</dt>
<dd>Result tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input to float tensors.</dd>
<dt><tt>T1</tt> : tensor(bool)</dt>
<dd>Constrain output to boolean tensor.</dd>
</dl>

### <a name="Mul-7"></a>**Mul-7**</a>

  Performs element-wise binary multiplication (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>First operand.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Second operand.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T</dt>
<dd>Result, has same element type as two inputs</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="Multinomial-7"></a>**Multinomial-7**</a>

  Generate a tensor of samples from a multinomial distribution according to the probabilities
  of each of the possible outcomes.

#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>dtype</tt> : int (default is 6)</dt>
<dd>(Optional) The data type for the elements of the output tensor, if not specified, we will use int32.</dd>
<dt><tt>sample_size</tt> : int (default is 1)</dt>
<dd>Number of times to sample.</dd>
<dt><tt>seed</tt> : float</dt>
<dd>(Optional) Seed to the random generator, if not specified we will auto generate one.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T1</dt>
<dd>Input tensor with shape [batch_size, class_size], where class_size is the number of all possible outcomes. Each value along the axis zero represents the unnormalized log-probability of each corresponding outcome in a batch.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T2</dt>
<dd>Output tensor with shape [batch_size, sample_size], where sample_size is the number of times to sample. Each value along the axis zero represents the outcome of the corresponding sample in a batch.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input types to float tensors.</dd>
<dt><tt>T2</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain output types to integral tensors.</dd>
</dl>

### <a name="Or-7"></a>**Or-7**</a>

  Returns the tensor resulted from performing the `or` logical operation
  elementwise on the input tensors `A` and `B` (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> (non-differentiable) : T</dt>
<dd>First input operand for the logical operator.</dd>
<dt><tt>B</tt> (non-differentiable) : T</dt>
<dd>Second input operand for the logical operator.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> (non-differentiable) : T1</dt>
<dd>Result tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(bool)</dt>
<dd>Constrain input to boolean tensor.</dd>
<dt><tt>T1</tt> : tensor(bool)</dt>
<dd>Constrain output to boolean tensor.</dd>
</dl>

### <a name="PRelu-7"></a>**PRelu-7**</a>

  PRelu takes input data (Tensor<T>) and slope tensor as input, and produces one
  output data (Tensor<T>) where the function `f(x) = slope * x for x < 0`,
  `f(x) = x for x >= 0`., is applied to the data tensor elementwise.
  This operator supports **unidirectional broadcasting** (tensor slope should be unidirectional broadcastable to input tensor X); for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor</dd>
<dt><tt>slope</tt> : T</dt>
<dd>Slope tensor. The shape of slope can be smaller then first input X; if so, its shape must be unidirectional broadcastable to X</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor (same size as X)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Pow-7"></a>**Pow-7**</a>

  Pow takes input data (Tensor<T>) and exponent Tensor, and
  produces one output data (Tensor<T>) where the function `f(x) = x^exponent`,
  is applied to the data tensor elementwise.
  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>First operand, base of the exponent.</dd>
<dt><tt>Y</tt> : T</dt>
<dd>Second operand, power of the exponent.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Z</tt> : T</dt>
<dd>Output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="RNN-7"></a>**RNN-7**</a>

  Computes an one-layer simple RNN. This operator is usually supported
  via some custom implementation such as CuDNN.

  Notations:

  `X` - input tensor

  `i` - input gate

  `t` - time step (t-1 means previous time step)

  `Wi` - W parameter weight matrix for input gate

  `Ri` - R recurrence weight matrix for input gate

  `Wbi` - W parameter bias vector for input gate

  `Rbi` - R parameter bias vector for input gate

  `WBi` - W parameter weight matrix for backward input gate

  `RBi` - R recurrence weight matrix for backward input gate

  `WBbi` - WR bias vectors for backward input gate

  `RBbi` - RR bias vectors for backward input gate

  `H` - Hidden state

  `num_directions` - 2 if direction == bidirectional else 1

  Activation functions:

    Relu(x)                - max(0, x)

    Tanh(x)                - (1 - e^{-2x})/(1 + e^{-2x})

    Sigmoid(x)             - 1/(1 + e^{-x})

    (NOTE: Below are optional)

    Affine(x)              - alpha*x + beta

    LeakyRelu(x)           - x if x >= 0 else alpha * x

    ThresholdedRelu(x)     - x if x >= alpha else 0

    ScaledTanh(x)          - alpha*Tanh(beta*x)

    HardSigmoid(x)         - min(max(alpha*x + beta, 0), 1)

    Elu(x)                 - x if x >= 0 else alpha*(e^x - 1)

    Softsign(x)            - x/(1 + |x|)

    Softplus(x)            - log(1 + e^x)

  Equations (Default: f=Tanh):

    - Ht = f(Xt*(Wi^T) + Ht-1*(Ri^T) + Wbi + Rbi)
  This operator has **optional** inputs/outputs. See [the doc](IR.md) for more details about the representation of optional arguments. An empty string may be used in the place of an actual argument's name to indicate a missing argument. Trailing optional arguments (those not followed by an argument that is present) may also be simply omitted.

#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>activation_alpha</tt> : list of floats</dt>
<dd>Optional scaling values used by some activation functions. The values are consumed in the order of activation functions, for example (f, g, h) in LSTM. Default values are the same as of corresponding ONNX operators.For example with LeakyRelu, the default alpha is 0.01.</dd>
<dt><tt>activation_beta</tt> : list of floats</dt>
<dd>Optional scaling values used by some activation functions. The values are consumed in the order of activation functions, for example (f, g, h) in LSTM. Default values are the same as of corresponding ONNX operators.</dd>
<dt><tt>activations</tt> : list of strings (default is ['Tanh', 'Tanh'])</dt>
<dd>One (or two if bidirectional) activation function for input gate. The activation function must be one of the activation functions specified above. Optional: Default `Tanh` if not specified.</dd>
<dt><tt>clip</tt> : float</dt>
<dd>Cell clip threshold. Clipping bounds the elements of a tensor in the range of [-threshold, +threshold] and is applied to the input of activations. No clip if not specified.</dd>
<dt><tt>direction</tt> : string (default is forward)</dt>
<dd>Specify if the RNN is forward, reverse, or bidirectional. Must be one of forward (default), reverse, or bidirectional.</dd>
<dt><tt>hidden_size</tt> : int</dt>
<dd>Number of neurons in the hidden layer</dd>
</dl>

#### Inputs (3 - 6)

<dl>
<dt><tt>X</tt> : T</dt>
<dd>The input sequences packed (and potentially padded) into one 3-D tensor with the shape of `[seq_length, batch_size, input_size]`.</dd>
<dt><tt>W</tt> : T</dt>
<dd>The weight tensor for input gate. Concatenation of `Wi` and `WBi` (if bidirectional). The tensor has shape `[num_directions, hidden_size, input_size]`.</dd>
<dt><tt>R</tt> : T</dt>
<dd>The recurrence weight tensor. Concatenation of `Ri` and `RBi` (if bidirectional). The tensor has shape `[num_directions, hidden_size, hidden_size]`.</dd>
<dt><tt>B</tt> (optional) : T</dt>
<dd>The bias tensor for input gate. Concatenation of `[Wbi, Rbi]` and `[WBbi, RBbi]` (if bidirectional). The tensor has shape `[num_directions, 2*hidden_size]`. Optional: If not specified - assumed to be 0.</dd>
<dt><tt>sequence_lens</tt> (optional) : T1</dt>
<dd>Optional tensor specifying lengths of the sequences in a batch. If not specified - assumed all sequences in the batch to have length `seq_length`. It has shape `[batch_size]`.</dd>
<dt><tt>initial_h</tt> (optional) : T</dt>
<dd>Optional initial value of the hidden. If not specified - assumed to be 0. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
</dl>

#### Outputs (0 - 2)

<dl>
<dt><tt>Y</tt> (optional) : T</dt>
<dd>A tensor that concats all the intermediate output values of the hidden. It has shape `[seq_length, num_directions, batch_size, hidden_size]`. </dd>
<dt><tt>Y_h</tt> (optional) : T</dt>
<dd>The last output value of the hidden. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T1</tt> : tensor(int32)</dt>
<dd>Constrain seq_lens to integer tensor.</dd>
</dl>

### <a name="Sin-7"></a>**Sin-7**</a>

  Calculates the sine of the given input tensor, element-wise.

#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>The sine of the input tensor computed element-wise</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Sub-7"></a>**Sub-7**</a>

  Performs element-wise binary subtraction (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>First operand.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Second operand.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T</dt>
<dd>Result, has same element type as two inputs</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="Tan-7"></a>**Tan-7**</a>

  Calculates the tangent of the given input tensor, element-wise.

#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>The tangent of the input tensor computed element-wise</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Upsample-7"></a>**Upsample-7**</a>

  Upsample the input tensor.
  Each dimension value of the output tensor is:
    output_dimension = floor(input_dimension * scale).

#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>mode</tt> : string (default is nearest)</dt>
<dd>Two interpolation modes: nearest (default), and linear (including bilinear, trilinear, etc)</dd>
<dt><tt>scales</tt> : list of floats (required)</dt>
<dd>The scale array along each dimension. It takes value greater than or equal to 1. The number of elements of 'scales' should be the same as the rank of input 'X'.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>N-D tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>N-D tensor after resizing</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

### <a name="Xor-7"></a>**Xor-7**</a>

  Returns the tensor resulted from performing the `xor` logical operation
  elementwise on the input tensors `A` and `B` (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 7 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> (non-differentiable) : T</dt>
<dd>First input operand for the logical operator.</dd>
<dt><tt>B</tt> (non-differentiable) : T</dt>
<dd>Second input operand for the logical operator.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> (non-differentiable) : T1</dt>
<dd>Result tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(bool)</dt>
<dd>Constrain input to boolean tensor.</dd>
<dt><tt>T1</tt> : tensor(bool)</dt>
<dd>Constrain output to boolean tensor.</dd>
</dl>

## Version 8 of the default ONNX operator set
### <a name="Expand-8"></a>**Expand-8**</a>

  Broadcast the input tensor following the given shape and the broadcast rule.
  The broadcast rule is similar to numpy.array(input) * numpy.ones(shape):
  Dimensions are right alignment;
  Two corresponding dimensions must have the same value, or one of them is equal to 1.
  Also, this operator is similar to numpy.broadcast_to(input, shape),
  but the major difference is numpy.broadcast_to() does not allow shape to be smaller than input.size().
  It is possible that the output.shape is not equal to shape, when some dimensions in shape is equal to 1,
  or the shape.ndim < input.shape.ndim.

#### Version

This version of the operator has been available since version 8 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>Input tensor</dd>
<dt><tt>shape</tt> : tensor(int64)</dt>
<dd>A 1-D tensor indicates the shape you want to expand to, following the broadcast rule</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensors.</dd>
</dl>

### <a name="Max-8"></a>**Max-8**</a>

  Element-wise max of each of the input tensors (with Numpy-style broadcasting support).
  All inputs and outputs must have the same data type.
  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 8 of the default ONNX operator set.

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>data_0</tt> (variadic) : T</dt>
<dd>List of tensors for max.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>max</tt> : T</dt>
<dd>Output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="MaxPool-8"></a>**MaxPool-8**</a>

  MaxPool consumes an input tensor X and applies max pooling across
   the tensor according to kernel sizes, stride sizes, and pad lengths.
   max pooling consisting of computing the max on all values of a
   subset of the input tensor according to the kernel size and downsampling the
   data into the output tensor Y for further processing. The output spatial shape will be following:
   ```
   output_spatial_shape[i] = floor((input_spatial_shape[i] + pad_shape[i] - kernel_spatial_shape[i]) / strides_spatial_shape[i] + 1)

   * pad_shape[i] is sum of pads along axis i
   ```

   `auto_pad` is a DEPRECATED attribute. If you are using them currently, the output spatial shape will be following:
   ```
   VALID: output_spatial_shape[i] = ceil((input_spatial_shape[i] - kernel_spatial_shape[i] + 1) / strides_spatial_shape[i])
   SAME_UPPER or SAME_LOWER: output_spatial_shape[i] = ceil(input_spatial_shape[i] / strides_spatial_shape[i])
   ```
   And pad shape will be following if `SAME_UPPER` or `SAME_LOWER`:
   ```
   pad_shape[i] = (output_spatial_shape[i] - 1) * strides_spatial_shape[i] + kernel_spatial_shape[i] - input_spatial_shape[i]
   ```
   The output of each pooling window is maximum number of elements exclude pad.


#### Version

This version of the operator has been available since version 8 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>auto_pad</tt> : string (default is NOTSET)</dt>
<dd>auto_pad must be either NOTSET, SAME_UPPER, SAME_LOWER or VALID. Where default value is NOTSET, which means explicit padding is used. SAME_UPPER or SAME_LOWER mean pad the input so that the output spatial size match the input.In case of odd number add the extra padding at the end for SAME_UPPER and at the beginning for SAME_LOWER. VALID mean no padding.</dd>
<dt><tt>kernel_shape</tt> : list of ints (required)</dt>
<dd>The size of the kernel along each axis.</dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd>Padding for the beginning and ending along each spatial axis, it can take any value greater than or equal to 0. The value represent the number of pixels added to the beginning and end part of the corresponding axis. `pads` format should be as follow [x1_begin, x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels added at the beginning of axis `i` and xi_end, the number of pixels added at the end of axis `i`. This attribute cannot be used simultaneously with auto_pad attribute. If not present, the padding defaults to 0 along start and end of each spatial axis.</dd>
<dt><tt>storage_order</tt> : int (default is 0)</dt>
<dd>The storage order of the tensor. 0 is row major, and 1 is column major.</dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd>Stride along each spatial axis.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input data tensor from the previous operator; dimensions for image case are (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data. For non image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size. Optionally, if dimension denotation is in effect, the operation expects the input data tensor to arrive with the dimension denotation of [DATA_BATCH, DATA_CHANNEL, DATA_FEATURE, DATA_FEATURE ...].</dd>
</dl>

#### Outputs (1 - 2)

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output data tensor from average or max pooling across the input tensor. Dimensions will vary based on various kernel, stride, and pad sizes. Floor value of the dimension is used</dd>
<dt><tt>Indices</tt> (optional) : I</dt>
<dd>Indices tensor from max pooling across the input tensor. The dimensions of indices are the same as output tensor. The values in indices of are the indices of the selected values during pooling. The indices are computed as flatten 1-D tensor, and the indices do not consider padding. So the values in indices are in [0, N x C x D1 x ... x Dn).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>I</tt> : tensor(int64)</dt>
<dd>Constrain index tensor to int64</dd>
</dl>

### <a name="Mean-8"></a>**Mean-8**</a>

  Element-wise mean of each of the input tensors (with Numpy-style broadcasting support).
  All inputs and outputs must have the same data type.
  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 8 of the default ONNX operator set.

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>data_0</tt> (variadic) : T</dt>
<dd>List of tensors for mean.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>mean</tt> : T</dt>
<dd>Output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Min-8"></a>**Min-8**</a>

  Element-wise min of each of the input tensors (with Numpy-style broadcasting support).
  All inputs and outputs must have the same data type.
  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 8 of the default ONNX operator set.

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>data_0</tt> (variadic) : T</dt>
<dd>List of tensors for min.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>min</tt> : T</dt>
<dd>Output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Scan-8"></a>**Scan-8**</a>

  Scan can be used to iterate over one or more scan_input tensors,
  constructing zero or more scan_output tensors. It combines ideas from general recurrences,
  functional programming constructs such as scan, fold, map, and zip, and is intended to enable
  generalizations of RNN-like constructs for sequence-to-sequence processing.
  Other tensors (referred to as state_variables here) can be used to carry a state
  when iterating from one element to another (similar to hidden-state in RNNs, also referred
  to as loop-carried dependences in the context of loops). All these tensors are required to
  have the same shape in each iteration of the loop (a restriction imposed to enable efficient
  memory allocation). Many common usages involve a single scan_input tensor (where functionality
  similar to scan, fold and map can be obtained). When more than one scan_input is used,
  a behavior similar to zip is obtained.

  The attribute body must be a graph, specifying the computation to be performed in
  every iteration. It takes as input the current values of the state_variables and
  the current iterated element of the scan_inputs. It must return the (updated) values
  of the state_variables and zero or more scan_output_element tensors. The values of the
  scan_output_element tensors are concatenated over all the iterations to produce the
  scan_output values of the scan construct (similar to the concatenated intermediate
  hidden-state values of RNN-like constructs).

  The scan operation returns the final values of the state_variables as well as the
  scan_outputs.

  The operation supports batching, and the batch-axis is required to be 0.
  When multiple scan_input tensors are used, they must all have the same batch-size,
  and they must all have the same maximum-sequence-length (the dimensionality of the
  sequence axis or scan axis). The sequence axis or scan axis is required to be 1.

  The operation has an optional sequence_lens input (of shape [BATCH_SIZE]) to
  allow variable length sequences of length <= the maximum-sequence-length. If this
  input is not specified, all sequences are assumed to be of length equal to
  maximum-sequence-length. For variable length input sequences, the scan_outputs
  will consist of a sequence of same length as the input, padded to the
  maximum-sequence-length.

  The optional attribute directions can be used to scan a sequence in the reverse direction.
  If this attribute is omitted, all sequences are scanned in the forward direction.
  A bidirectional scan be performed by specifying the same tensor input twice in the
  scan_inputs, once with a forward direction, and once with a backward direction.

  Note that because of the ONNX restriction that only the last parameter of an operator can
  be variadic, the initial-states and scan-inputs are listed together as one input parameter.
  Similarly, the final-states and scan-outputs are listed together as one output parameter.
  The attribute num_scan_inputs indicates the number M of scan-inputs.

  The behavior of

      Scan <
          num_scan_inputs = m,
          body = loop-body
      > (sequence_lengths, init_1, ..., init_n, scan_1, ..., scan_m)

  is equivalent to the following pseudo-code:

      // T.shape[0] denotes the batch-size of T
      // The batch-size of scan_1, ..., scan_m are all required to be equal
      batch_size = scan_1.shape[0];

      // scan_i.shape[1] denotes the (max) sequence-length of scan_i
      // scan_i.shape[1] is required to be equal to scan_j.shape[1] for all i,j.
      max_sequence_length = scan_1.shape[1];

      for (int batch = 0; batch < batch_size; ++batch) {
          // initialize state-variables
          st_1 = init_1; ... st_n = init_n;
          // initialize scan-output variables: [] denotes an empty tensor
          scan_out_1 = []; ...; scan_out_k = [];
          // identify number of iterations:
          N = (sequence_lengths specified) ? sequence_lengths[batch] : max_sequence_length;

          // execute loop
          for (int t = 0; t < N; ++t) {
              // generate the scan-input elements: the notation T<axis=k>[t] indicates the sub-tensor
              // of rank one less than T obtained by indexing T at position t along axis k.
              si_1 = (scan_1<axis=0>[batch])<axis=1>[t];
              ... ;
              si_m = (scan_m<axis=0>[batch])<axis=1>[t];
              // execute loop-body
              st_1, ..., st_n, so_1, ..., so_k = loop-body(st_1, ..., st_n, si_1, ..., si_m)
              // accumulate the scan-output elements
              scan_out_1 = Concat<axis=0>(scan_out_1, so_1); ... ; scan_out_k = Concat<axis=0>(scan_out_k, so_k);
          }
          // accumulate the outputs for this batch:
          bst_1[batch] = st_1; ..., bst_n[batch] = st_n;
          // Note scan-outputs will have size max_sequence_length, but only first N values will be meaningful.
          // The remaining values have an undefined value.
          b_scan_out_1[batch] = scan_out_1; ...; b_scan_out_k[batch] = scan_out_k;
      }
      return bst_1, ..., bst_n, b_scan_out_1, ..., b_scan_out_k;



  *Sample usage: Encoding RNN using a Scan*

  The following example shows how a simple RNN over an input tensor %X, with weight tensor %Wi,
  recurrence weight tensor %Ri, bias tensors %Wbi and %Rbi, and initial hidden-state %H_0 can
  be encoded as a ScanLoop. Note that the loop-body is a nested graph, and it directly computes
  %Wi, %Ri, %Wbi, and %Rbi (typically constants or initializers in the body graph). If these
  values are computed in the outer graph, they need to be passed in as extra state_variables.

      graph rnn-encoding {
        %H_0 = ...
        %X = ...
        %Y_h, %Y = Scan[body = <graph rnn-cell-1>, num_scan_inputs=1]("", %H_0, %X)
        return %Y, %Y_h
      }

      graph rnn-cell-1 (
        %H_tminus1[FLOAT, tensor]
        %X_t[FLOAT, tensor]
      ) {
        %Wi = ...
        %Ri = ...
        %Wbi = ...
        %Rbi = ...
        %t1 = X_t * (Wi^T)
        %t2 = H_tminus1*(Ri^T)
        %t3 = Add(%t1, %t2)
        %t4 = Add(%t3, %Wbi)
        %t5 = Add(%t4, %Rbi)
        %Ht = Tanh(%t5)
        %Accumulate = Identity(%Ht)
        return %Ht, %Accumulate
      }


#### Version

This version of the operator has been available since version 8 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>body</tt> : graph (required)</dt>
<dd>The graph run each iteration. It has N+M inputs: (loop state variables..., scan_input_elts...). It has N+K outputs: (loop state variables..., scan_output_elts...). Each scan_output is created by concatenating the value of the specified scan_output_elt value at the end of each iteration of the loop. It is an error if the dimensions of these values change across loop iterations.</dd>
<dt><tt>directions</tt> : list of ints</dt>
<dd>An optional list of M flags. The i-th element of the list specifies the direction to be scanned for the i-th scan_input tensor: 0 indicates forward direction and 1 indicates reverse direction. If omitted, all scan_input tensors will be scanned in the forward direction.</dd>
<dt><tt>num_scan_inputs</tt> : int (required)</dt>
<dd>An attribute specifying the number of scan_inputs M. </dd>
</dl>

#### Inputs (2 - &#8734;)

<dl>
<dt><tt>sequence_lens</tt> (optional) : I</dt>
<dd>Optional tensor specifying lengths of the sequences in a batch. If this input is not specified, all sequences are assumed to be of the maximum sequence length (the dimension of the sequence axis of the scan_input tensors).</dd>
<dt><tt>initial_state_and_scan_inputs</tt> (variadic, heterogeneous) : V</dt>
<dd>Initial values of the loop's N state variables followed by M scan_inputs</dd>
</dl>

#### Outputs (1 - &#8734;)

<dl>
<dt><tt>final_state_and_scan_outputs</tt> (variadic, heterogeneous) : V</dt>
<dd>Final values of the loop's N state variables followed by K scan_outputs</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>I</tt> : tensor(int64)</dt>
<dd>Int64 tensor</dd>
<dt><tt>V</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>All Tensor types</dd>
</dl>

### <a name="Sum-8"></a>**Sum-8**</a>

  Element-wise sum of each of the input tensors (with Numpy-style broadcasting support).
  All inputs and outputs must have the same data type.
  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 8 of the default ONNX operator set.

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>data_0</tt> (variadic) : T</dt>
<dd>List of tensors for sum.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>sum</tt> : T</dt>
<dd>Output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

## Version 9 of the default ONNX operator set
### <a name="Acosh-9"></a>**Acosh-9**</a>

  Calculates the hyperbolic arccosine of the given input tensor element-wise.

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>The hyperbolic arccosine values of the input tensor computed element-wise</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Asinh-9"></a>**Asinh-9**</a>

  Calculates the hyperbolic arcsine of the given input tensor element-wise.

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>The hyperbolic arcsine values of the input tensor computed element-wise</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Atanh-9"></a>**Atanh-9**</a>

  Calculates the hyperbolic arctangent of the given input tensor element-wise.

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>The hyperbolic arctangent values of the input tensor computed element-wise</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="BatchNormalization-9"></a>**BatchNormalization-9**</a>

  Carries out batch normalization as described in the paper
  https://arxiv.org/abs/1502.03167. Depending on the mode it is being run,
  there are multiple cases for the number of outputs, which we list below:

  Output case #1: Y, mean, var, saved_mean, saved_var (training mode)
  Output case #2: Y (test mode)

  For previous (depreciated) non-spatial cases, implementors are suggested
  to flatten the input shape to (N x C*D1*D2 ..*Dn) before a BatchNormalization Op.
  This operator has **optional** inputs/outputs. See [the doc](IR.md) for more details about the representation of optional arguments. An empty string may be used in the place of an actual argument's name to indicate a missing argument. Trailing optional arguments (those not followed by an argument that is present) may also be simply omitted.

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>epsilon</tt> : float (default is 1e-05)</dt>
<dd>The epsilon value to use to avoid division by zero.</dd>
<dt><tt>momentum</tt> : float (default is 0.9)</dt>
<dd>Factor used in computing the running mean and variance.e.g., running_mean = running_mean * momentum + mean * (1 - momentum).</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input data tensor from the previous operator; dimensions are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size, C is the number of channels. Statistics are computed for every channel of C over N and D1 to Dn dimensions. For image data, input dimensions become (N x C x H x W). The op also accepts single dimension input of size N in which case C is assumed to be 1</dd>
<dt><tt>scale</tt> (differentiable) : T</dt>
<dd>Scale tensor of shape (C).</dd>
<dt><tt>B</tt> (differentiable) : T</dt>
<dd>Bias tensor of shape (C).</dd>
<dt><tt>mean</tt> (differentiable) : T</dt>
<dd>running (training) or estimated (testing) mean tensor of shape (C).</dd>
<dt><tt>var</tt> (differentiable) : T</dt>
<dd>running (training) or estimated (testing) variance tensor of shape (C).</dd>
</dl>

#### Outputs (1 - 5)

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>The output tensor of the same shape as X</dd>
<dt><tt>mean</tt> (optional, non-differentiable) : T</dt>
<dd>The running mean after the BatchNormalization operator.</dd>
<dt><tt>var</tt> (optional, non-differentiable) : T</dt>
<dd>The running variance after the BatchNormalization operator.</dd>
<dt><tt>saved_mean</tt> (optional, non-differentiable) : T</dt>
<dd>Saved mean used during training to speed up gradient computation.</dd>
<dt><tt>saved_var</tt> (optional, non-differentiable) : T</dt>
<dd>Saved variance used during training to speed up gradient computation.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Cast-9"></a>**Cast-9**</a>

  The operator casts the elements of a given input tensor to a data type
  specified by the 'to' argument and returns an output tensor of the same size in
  the converted type. The 'to' argument must be one of the data types specified
  in the 'DataType' enum field in the TensorProto message.

  Casting from string tensor in plain (e.g., "3.14" and "1000") and scientific numeric representations
  (e.g., "1e-5" and "1E8") to float types is supported. For example, converting string "100.5" to an integer may
  result 100. There are some string literals reserved for special floating-point values;
  "+INF" (and "INF"), "-INF", and "NaN" are positive infinity, negative infinity, and not-a-number, respectively.
  Any string which can exactly match "+INF" in a case-insensitive way would be mapped to positive infinite. Similarly,
  this case-insensitive rule is applied to "INF" and "NaN". When casting from numeric tensors
  to string tensors, plain floating-point representation (such as "314.15926") would be used.
  Converting non-numerical-literal string such as "Hello World!" is an undefined behavior. Cases
  of converting string representing floating-point arithmetic value, such as "2.718", to INT is an undefined behavior.

  Conversion from a numerical type to any numerical type is always allowed.
  User must be aware of precision loss and value change caused by range difference between two types.
  For example, a 64-bit float 3.1415926459 may be round to a 32-bit float 3.141592. Similarly, converting
  an integer 36 to Boolean may produce 1 because we truncate bits which can't be stored in the targeted type.

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>to</tt> : int (required)</dt>
<dd>The data type to which the elements of the input tensor are cast. Strictly must be one of the types from DataType enum in TensorProto</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T1</dt>
<dd>Input tensor to be cast.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T2</dt>
<dd>Output tensor with the same shape as input with type specified by the 'to' argument</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float16), tensor(float), tensor(double), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(bool), tensor(string)</dt>
<dd>Constrain input types. Casting from complex is not supported.</dd>
<dt><tt>T2</tt> : tensor(float16), tensor(float), tensor(double), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(bool), tensor(string)</dt>
<dd>Constrain output types. Casting to complex is not supported.</dd>
</dl>

### <a name="Compress-9"></a>**Compress-9**</a>

  Selects slices from an input tensor along a given axis where condition evaluates to True for each axis index.
      In case axis is not provided, input is flattened before elements are selected.
      Compress behaves like numpy.compress: https://docs.scipy.org/doc/numpy/reference/generated/numpy.compress.html


#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int</dt>
<dd>(Optional) Axis along which to take slices. If not specified, input is flattened before elements being selected.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>Tensor of rank r >= 1.</dd>
<dt><tt>condition</tt> : T1</dt>
<dd>Rank 1 tensor of booleans to indicate which slices or data elements to be selected. Its length can be less than the input length alone the axis or the flattened input size if axis is not specified. In such cases data slices or elements exceeding the condition length are discarded.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Tensor of rank r if axis is specified. Otherwise output is a Tensor of rank 1.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
<dt><tt>T1</tt> : tensor(bool)</dt>
<dd>Constrain to boolean tensors.</dd>
</dl>

### <a name="Constant-9"></a>**Constant-9**</a>

  A constant tensor.

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>value</tt> : tensor (required)</dt>
<dd>The value for the elements of the output tensor.</dd>
</dl>

#### Inputs


#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Output tensor containing the same value of the provided tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

### <a name="ConstantOfShape-9"></a>**ConstantOfShape-9**</a>

  Generate a tensor with given value and shape.

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>value</tt> : tensor</dt>
<dd>(Optional) The value of the output elements.Should be a one-element tensor. If not specified, it defaults to a tensor of value 0 and datatype float32</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T1</dt>
<dd>1D tensor. The shape of the expected output tensor. If empty tensor is given, the output would be a scalar. All values must be >= 0.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T2</dt>
<dd>Output tensor of shape specified by 'input'.If attribute 'value' is specified, the value and datatype of the output tensor is taken from 'value'.If attribute 'value' is not specified, the value in the output defaults to 0, and the datatype defaults to float32.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(int64)</dt>
<dd>Constrain input types.</dd>
<dt><tt>T2</tt> : tensor(float16), tensor(float), tensor(double), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(bool)</dt>
<dd>Constrain output types to be numerics.</dd>
</dl>

### <a name="Cosh-9"></a>**Cosh-9**</a>

  Calculates the hyperbolic cosine of the given input tensor element-wise.

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>The hyperbolic cosine values of the input tensor computed element-wise</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Erf-9"></a>**Erf-9**</a>

  Computes the error function of the given input tensor element-wise.

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>The error function of the input tensor computed element-wise. It has the same shape and type of the input.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to all numeric tensors.</dd>
</dl>

### <a name="EyeLike-9"></a>**EyeLike-9**</a>

  Generate a 2D tensor (matrix) with ones on the diagonal and zeros everywhere else. Only 2D
  tensors are supported, i.e. input T1 must be of rank 2. The shape of the output tensor is the
  same as the input tensor. The data type can be specified by the 'dtype' argument. If
  'dtype' is not specified, then the type of input tensor is used. By default, the main diagonal
  is populated with ones, but attribute 'k' can be used to populate upper or lower diagonals.
  The 'dtype' argument must be one of the data types specified in the 'DataType' enum field in the
  TensorProto message and be valid as an output type.

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>dtype</tt> : int</dt>
<dd>(Optional) The data type for the elements of the output tensor. If not specified,the data type of the input tensor T1 is used. If input tensor T1 is also notspecified, then type defaults to 'float'.</dd>
<dt><tt>k</tt> : int (default is 0)</dt>
<dd>(Optional) Index of the diagonal to be populated with ones. Default is 0. If T2 is the output, this op sets T2[i, i+k] = 1. k = 0 populates the main diagonal, k > 0 populates an upper diagonal,  and k < 0 populates a lower diagonal.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T1</dt>
<dd>2D input tensor to copy shape, and optionally, type information from.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T2</dt>
<dd>Output tensor, same shape as input tensor T1.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float16), tensor(float), tensor(double), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(bool)</dt>
<dd>Constrain input types. Strings and complex are not supported.</dd>
<dt><tt>T2</tt> : tensor(float16), tensor(float), tensor(double), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(bool)</dt>
<dd>Constrain output types. Strings and complex are not supported.</dd>
</dl>

### <a name="Flatten-9"></a>**Flatten-9**</a>

  Flattens the input tensor into a 2D matrix. If input tensor has shape
  (d_0, d_1, ... d_n) then the output will have shape
  (d_0 X d_1 ... d_(axis-1), d_axis X d_(axis+1) ... X dn).

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 1)</dt>
<dd>Indicate up to which input dimensions (exclusive) should be flattened to the outer dimension of the output. The value for axis must be in the range [0, R], where R is the rank of the input tensor. When axis = 0, the shape of the output tensor is (1, (d_0 X d_1 ... d_n), where the shape of the input tensor is (d_0, d_1, ... d_n). </dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>A tensor of rank >= axis.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>A 2D tensor with the contents of the input tensor, with input dimensions up to axis flattened to the outer dimension of the output and remaining input dimensions flattened into the inner dimension of the output.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output to all tensor types.</dd>
</dl>

### <a name="Gemm-9"></a>**Gemm-9**</a>

  General Matrix multiplication:
  https://en.wikipedia.org/wiki/Basic_Linear_Algebra_Subprograms#Level_3

  A' = transpose(A) if transA else A

  B' = transpose(B) if transB else B

  Compute Y = alpha * A' * B' + beta * C, where input tensor A has shape (M, K) or (K, M),
  input tensor B has shape (K, N) or (N, K), input tensor C is broadcastable to shape (M, N),
  and output tensor Y has shape (M, N). A will be transposed before doing the
  computation if attribute transA is non-zero, same for B and transB.
  This operator supports **unidirectional broadcasting** (tensor C should be unidirectional broadcastable to tensor A * B); for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float (default is 1.0)</dt>
<dd>Scalar multiplier for the product of input tensors A * B.</dd>
<dt><tt>beta</tt> : float (default is 1.0)</dt>
<dd>Scalar multiplier for input tensor C.</dd>
<dt><tt>transA</tt> : int (default is 0)</dt>
<dd>Whether A should be transposed</dd>
<dt><tt>transB</tt> : int (default is 0)</dt>
<dd>Whether B should be transposed</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>Input tensor A. The shape of A should be (M, K) if transA is 0, or (K, M) if transA is non-zero.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Input tensor B. The shape of B should be (K, N) if transB is 0, or (N, K) if transB is non-zero.</dd>
<dt><tt>C</tt> : T</dt>
<dd>Input tensor C. The shape of C should be unidirectional broadcastable to (M, N).</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor of shape (M, N).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(uint32), tensor(uint64), tensor(int32), tensor(int64)</dt>
<dd>Constrain input and output types to float/int tensors.</dd>
</dl>

### <a name="Greater-9"></a>**Greater-9**</a>

  Returns the tensor resulted from performing the `greater` logical operation
  elementwise on the input tensors `A` and `B` (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>First input operand for the logical operator.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Second input operand for the logical operator.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T1</dt>
<dd>Result tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input types to all numeric tensors.</dd>
<dt><tt>T1</tt> : tensor(bool)</dt>
<dd>Constrain output to boolean tensor.</dd>
</dl>

### <a name="IsNaN-9"></a>**IsNaN-9**</a>

  Returns which elements of the input are NaN.

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> : T1</dt>
<dd>input</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T2</dt>
<dd>output</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input types to float tensors.</dd>
<dt><tt>T2</tt> : tensor(bool)</dt>
<dd>Constrain output types to boolean tensors.</dd>
</dl>

### <a name="Less-9"></a>**Less-9**</a>

  Returns the tensor resulted from performing the `less` logical operation
  elementwise on the input tensors `A` and `B` (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>First input operand for the logical operator.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Second input operand for the logical operator.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T1</dt>
<dd>Result tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input types to all numeric tensors.</dd>
<dt><tt>T1</tt> : tensor(bool)</dt>
<dd>Constrain output to boolean tensor.</dd>
</dl>

### <a name="MatMul-9"></a>**MatMul-9**</a>

  Matrix product that behaves like numpy.matmul: https://docs.scipy.org/doc/numpy-1.13.0/reference/generated/numpy.matmul.html

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>N-dimensional matrix A</dd>
<dt><tt>B</tt> : T</dt>
<dd>N-dimensional matrix B</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Matrix multiply results from A * B</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(uint32), tensor(uint64), tensor(int32), tensor(int64)</dt>
<dd>Constrain input and output types to float/int tensors.</dd>
</dl>

### <a name="MaxUnpool-9"></a>**MaxUnpool-9**</a>

  MaxUnpool essentially computes the partial inverse of the MaxPool op.
   The input information to this op is typically the the output information from a MaxPool op. The first
   input tensor X is the tensor that needs to be unpooled, which is typically the pooled tensor (first output)
   from MaxPool. The second input tensor, I, contains the indices to the (locally maximal) elements corrsponding
   to the elements in the first input tensor X. Input tensor I is typically the second output of the MaxPool op.
   The third (optional) input is a tensor that specifies the output size of the unpooling operation.

  MaxUnpool is intended to do 'partial' inverse of the MaxPool op. 'Partial' because all the non-maximal
   values from the original input to MaxPool are set to zero in the output of the MaxUnpool op. Pooling
   the result of an unpooling operation should give back the original input to the unpooling op.

  MaxUnpool can produce the same output size for several input sizes, which makes unpooling op ambiguous.
   The third input argument, output_size, is meant to disambiguate the op and produce output tensor of
   known/predictable size.

  In addition to the inputs, MaxUnpool takes three attributes, namely kernel_shape, strides, and pads,
   which define the exact unpooling op. The attributes typically have the same values as the corrsponding
   pooling op that the unpooling op is trying to invert.

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>kernel_shape</tt> : list of ints (required)</dt>
<dd>The size of the kernel along each axis.</dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd>Padding for the beginning and ending along each spatial axis, it can take any value greater than or equal to 0. The value represent the number of pixels added to the beginning and end part of the corresponding axis. `pads` format should be as follow [x1_begin, x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels added at the beginning of axis `i` and xi_end, the number of pixels added at the end of axis `i`. This attribute cannot be used simultaneously with auto_pad attribute. If not present, the padding defaults to 0 along start and end of each spatial axis.</dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd>Stride along each spatial axis.</dd>
</dl>

#### Inputs (2 - 3)

<dl>
<dt><tt>X</tt> : T1</dt>
<dd>Input data tensor that has to be unpooled. This tensor is typically the first output of the MaxPool op.Dimensions for image case are (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data. For non-image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size. Optionally, if dimension denotation is in effect, the operation expects the input data tensor to arrive with the dimension denotation of [DATA_BATCH, DATA_CHANNEL, DATA_FEATURE, DATA_FEATURE ...].</dd>
<dt><tt>I</tt> : T2</dt>
<dd>Input data tensor containing the indices corresponding to elements in the first input tensor X.This tensor is typically the second output of the MaxPool op.Dimensions must be the same as input tensor X. The indices are linear, i.e. computed considering the tensor as flattened 1-D tensor, assuming row-major storage. Also, the linear indices should not consider padding. So the values in indices are in the range [0, N x C x D1 x ... x Dn).</dd>
<dt><tt>output_shape</tt> (optional) : T2</dt>
<dd>The shape of the output can be explicitly set which will cause pads values to be auto generated. If 'output_shape' is specified, 'pads' values are ignored.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T1</dt>
<dd>Output data tensor that contains the result of the unpooling.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T2</tt> : tensor(int64)</dt>
<dd>Constrain index tensor to int64</dd>
</dl>

### <a name="MeanVarianceNormalization-9"></a>**MeanVarianceNormalization-9**</a>

  A MeanVarianceNormalization Function: Perform mean variance normalization
        on the input tensor X using formula: <br/> ``` (X-EX)/sqrt(E(X-EX)^2) ```

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints (default is ['0', '2', '3'])</dt>
<dd>A list of integers, along which to reduce. The default is to caculate along axes [0,2,3] for calculating mean and variance along each channel. Two variables with the same C-coordinate are associated with the same mean and variance.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to all numeric tensors.</dd>
</dl>

### <a name="NonZero-9"></a>**NonZero-9**</a>

  Returns the indices of the elements that are non-zero
      (in row-major order - by dimension).
      NonZero behaves similar to numpy.nonzero:
      https://docs.scipy.org/doc/numpy/reference/generated/numpy.nonzero.html,
      but for scalar input, NonZero produces output shape (0, N) instead of (1, N), which is different from Numpy's behavior.

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>input</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : tensor(int64)</dt>
<dd>output</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain to all tensor types.</dd>
</dl>

### <a name="OneHot-9"></a>**OneHot-9**</a>

  Produces a one-hot tensor based on inputs.
      The locations represented by the index values in the 'indices' input tensor will have 'on_value'
      and the other locations will have 'off_value' in the output tensor, where 'on_value' and 'off_value'
      are specified as part of required input argument 'values', which is a two-element tensor of format
      [off_value, on_value]. The rank of the output tensor will be one greater than the rank of the
      input tensor. The additional dimension is for one-hot representation. The additional dimension will
      be inserted at the position specified by 'axis'. If 'axis' is not specified then then additional
      dimension will be inserted as the innermost dimension, i.e. axis=-1. The size of the additional
      dimension is specified by required scalar input 'depth'. The type of the output tensor is the same
      as the type of the 'values' input. Any entries in the 'indices' input tensor with values outside
      the range [0, depth) will result in one-hot representation with all 'off_value' values in the
      output tensor.

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is -1)</dt>
<dd>(Optional) Axis along which one-hot representation in added. Default: axis=-1. axis=-1 means that the additional dimension will be inserted as the innermost/last dimension in the output tensor.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>indices</tt> : T1</dt>
<dd>Input tensor containing indices. The values must be non-negative integers. Any entries in the 'indices' input tensor with values outside the range [0, depth) will result in one-hot representation with all 'off_value' values in the output tensor.In case 'indices' is of non-integer type, the values will be casted to int64 before use.</dd>
<dt><tt>depth</tt> : T2</dt>
<dd>Scalar specifying the number of classes in one-hot tensor. This is also the size of the one-hot dimension (specified by 'axis' attribute) added on in the output tensor. The values in the 'indices' input tensor are expected to be in the range [0, depth). In case 'depth' is of non-integer type, it will be casted to int64 before use.</dd>
<dt><tt>values</tt> : T3</dt>
<dd>Rank 1 tensor containing exactly two elements, in the format [off_value, on_value], where 'on_value' is the value used for filling locations specified in 'indices' input tensor, and 'off_value' is the value used for filling locations other than those specified in 'indices' input tensor. </dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T3</dt>
<dd>Tensor of rank one greater than input tensor 'indices', i.e. rank(output) = rank(indices) + 1. The data type for the elements of the output tensor is the same as the type of input 'values' is used.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input to only numeric types.</dd>
<dt><tt>T2</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input to only numeric types.</dd>
<dt><tt>T3</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain to any tensor type.</dd>
</dl>

### <a name="PRelu-9"></a>**PRelu-9**</a>

  PRelu takes input data (Tensor<T>) and slope tensor as input, and produces one
  output data (Tensor<T>) where the function `f(x) = slope * x for x < 0`,
  `f(x) = x for x >= 0`., is applied to the data tensor elementwise.
  This operator supports **unidirectional broadcasting** (tensor slope should be unidirectional broadcastable to input tensor X); for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
<dt><tt>slope</tt> (differentiable) : T</dt>
<dd>Slope tensor. The shape of slope can be smaller then first input X; if so, its shape must be unidirectional broadcastable to X</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output tensor (same size as X)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(uint32), tensor(uint64), tensor(int32), tensor(int64)</dt>
<dd>Constrain input and output types to float/int tensors.</dd>
</dl>

### <a name="Scan-9"></a>**Scan-9**</a>

  Scan can be used to iterate over one or more scan_input tensors,
  constructing zero or more scan_output tensors. It combines ideas from general recurrences,
  functional programming constructs such as scan, fold, map, and zip, and is intended to enable
  generalizations of RNN-like constructs for sequence-to-sequence processing.
  Other tensors (referred to as state_variables here) can be used to carry a state
  when iterating from one element to another (similar to hidden-state in RNNs, also referred
  to as loop-carried dependences in the context of loops).
  Many common usages involve a single scan_input tensor (where functionality
  similar to scan, fold and map can be obtained). When more than one scan_input is used,
  a behavior similar to zip is obtained.

  The attribute body must be a graph, specifying the computation to be performed in
  every iteration. It takes as input the current values of the state_variables and
  the current iterated element of the scan_inputs. It must return the (updated) values
  of the state_variables and zero or more scan_output_element tensors. The values of the
  scan_output_element tensors are concatenated over all the iterations to produce the
  scan_output values of the scan construct (similar to the concatenated intermediate
  hidden-state values of RNN-like constructs). All the output tensors (state_variables as
  well as scan_output_element tensors) are required to have the same shape in each iteration
  of the loop (a restriction imposed to enable efficient memory allocation).

  Note that the iterated element passed to the body subgraph does not have a sequence
  axis. It will have a rank one less than the rank of the corresponding scan_input.

  The scan operation returns the final values of the state_variables as well as the
  scan_outputs.

  The optional attribute scan_input_directions specifies the direction (forward or backward)
  for each scan input. If this attribute is omitted, all sequences are scanned in the forward
  direction. A bidirectional scan may be performed by specifying the same tensor input twice
  in the scan_inputs, once with a forward direction, and once with a backward direction.

  The scan_output of the operation is produced by concatenating the scan_output_element
  values produced by the body in each iteration.  The optional attribute scan_output_directions
  specifies the direction in which scan_output is constructed (by appending or prepending the
  scan_output_element to scan_output in each iteration) for each scan_output. If this attribute
  is omitted, the scan_output_element is appended to the scan_output in each iteration.

  The optional attribute scan_input_axes specifies the axis to be scanned for each scan_input.
  If omitted, every scan_input will be scanned in axis 0. For example, if axis 0 is the
  batch axis and axis 1 is the time axis (to be scanned), specify an axis value of 1.
  Note that scanning a non-zero axis may be less efficient than scanning axis zero.

  The optional attribute scan_output_axes specifies the axis along which the scan_outputs
  are accumulated for each scan_output. For example, if axis 1 is the time axis (to be
  scanned) for both inputs and outputs, specify a scan_input axis and scan_output axis
  value of 1.

  Note that because of the ONNX restriction that only the last parameter of an operator can
  be variadic, the initial-states and scan-inputs are listed together as one input parameter.
  Similarly, the final-states and scan-outputs are listed together as one output parameter.
  The attribute num_scan_inputs indicates the number M of scan-inputs.

  The behavior of

      Scan <
          num_scan_inputs = m,
          body = loop-body,
          scan_input_axes = [axis_1, ..., axis_m]
      > (init_1, ..., init_n, scan_1, ..., scan_m)

  is equivalent to the following pseudo-code:

      // scan_i.shape[axis_i] denotes the (max) sequence-length of scan_i
      // scan_i.shape[axis_i] is required to be equal to scan_j.shape[axis_j] for all i,j.
      sequence_length = scan_1.shape[axis_1];

      // initialize state-variables
      st_1 = init_1; ... st_n = init_n;
      // initialize scan-output variables: [] denotes an empty tensor
      scan_out_1 = []; ...; scan_out_k = [];
      // identify number of iterations:

      // execute loop
      for (int t = 0; t < sequence_length; ++t) {
          // generate the scan-input elements: the notation T<axis=k>[t] indicates the sub-tensor
          // of rank one less than T obtained by indexing T at position t along axis k.
          si_1 = scan_1<axis=axis_1>[t];
          ... ;
          si_m = scan_m<axis=axis_m>[t];
          // execute loop-body
          st_1, ..., st_n, so_1, ..., so_k = loop-body(st_1, ..., st_n, si_1, ..., si_m)
          // accumulate the scan-output elements
          scan_out_1 = Concat<axis=0>(scan_out_1, so_1); ... ; scan_out_k = Concat<axis=0>(scan_out_k, so_k);
      }

      return st_1, ..., st_n, scan_out_1, ..., scan_out_k;

  *Sample usage: Encoding RNN using a Scan*

  The following example shows how a simple RNN over an input tensor %X, with weight tensor %Wi,
  recurrence weight tensor %Ri, bias tensors %Wbi and %Rbi, and initial hidden-state %H_0 can
  be encoded as a ScanLoop. Note that the loop-body is a nested graph, and it directly computes
  %Wi, %Ri, %Wbi, and %Rbi (typically constants or initializers in the body graph). If these
  values are computed in the outer graph, they need to be passed in as extra state_variables.

      graph rnn-encoding {
        %H_0 = ...
        %X = ...
        %Y_h, %Y = Scan[body = <graph rnn-cell-1>, num_scan_inputs=1](%H_0, %X)
        return %Y, %Y_h
      }

      graph rnn-cell-1 (
        %H_tminus1[FLOAT, tensor]
        %X_t[FLOAT, tensor]
      ) {
        %Wi = ...
        %Ri = ...
        %Wbi = ...
        %Rbi = ...
        %t1 = X_t * (Wi^T)
        %t2 = H_tminus1*(Ri^T)
        %t3 = Add(%t1, %t2)
        %t4 = Add(%t3, %Wbi)
        %t5 = Add(%t4, %Rbi)
        %Ht = Tanh(%t5)
        %Accumulate = Identity(%Ht)
        return %Ht, %Accumulate
      }


#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>body</tt> : graph (required)</dt>
<dd>The graph run each iteration. It has N+M inputs: (loop state variables..., scan_input_elts...). It has N+K outputs: (loop state variables..., scan_output_elts...). Each scan_output is created by concatenating the value of the specified scan_output_elt value at the end of each iteration of the loop. It is an error if the dimensions of these values change across loop iterations.</dd>
<dt><tt>num_scan_inputs</tt> : int (required)</dt>
<dd>An attribute specifying the number of scan_inputs M. </dd>
<dt><tt>scan_input_axes</tt> : list of ints</dt>
<dd>An optional list of M flags. The i-th element of the list specifies the axis to be scanned (the sequence axis) for the i-th scan_input. If omitted, 0 will be used as the scan axis for every scan_input.</dd>
<dt><tt>scan_input_directions</tt> : list of ints</dt>
<dd>An optional list of M flags. The i-th element of the list specifies the direction to be scanned for the i-th scan_input tensor: 0 indicates forward direction and 1 indicates reverse direction. If omitted, all scan_input tensors will be scanned in the forward direction.</dd>
<dt><tt>scan_output_axes</tt> : list of ints</dt>
<dd>An optional list of K flags. The i-th element of the list specifies the axis for the i-th scan_output. The scan outputs are accumulated along the specified axis. If omitted, 0 will be used as the scan axis for every scan_output.</dd>
<dt><tt>scan_output_directions</tt> : list of ints</dt>
<dd>An optional list of K flags, one for each scan_output. The i-th element of the list specifies whether the i-th scan_output should be constructed by appending or prepending a new value in each iteration: 0 indicates appending and 1 indicates prepending. If omitted, all scan_output tensors will be produced by appending a value in each iteration.</dd>
</dl>

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>initial_state_and_scan_inputs</tt> (variadic, heterogeneous) : V</dt>
<dd>Initial values of the loop's N state variables followed by M scan_inputs</dd>
</dl>

#### Outputs (1 - &#8734;)

<dl>
<dt><tt>final_state_and_scan_outputs</tt> (variadic, heterogeneous) : V</dt>
<dd>Final values of the loop's N state variables followed by K scan_outputs</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>V</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>All Tensor types</dd>
</dl>

### <a name="Scatter-9"></a>**Scatter-9**</a>

  Given `data`, `updates` and `indices` input tensors of rank r >= 1, write the values provided by `updates`
  into the first input, `data`, along `axis` dimension of `data` (by default outer-most one as axis=0) at corresponding `indices`.
  For each entry in `updates`, the target index in `data` is specified by corresponding entry in `indices`
  for dimension = axis, and index in source for dimension != axis. For instance, in a 2-D tensor case,
  data[indices[i][j]][j] = updates[i][j] if axis = 0, or data[i][indices[i][j]] = updates[i][j] if axis = 1,
  where i and j are loop counters from 0 up to the respective size in `updates` - 1.
  Example 1:
    data = [
        [0.0, 0.0, 0.0],
        [0.0, 0.0, 0.0],
        [0.0, 0.0, 0.0],
    ]
    indices = [
        [1, 0, 2],
        [0, 2, 1],
    ]
    updates = [
        [1.0, 1.1, 1.2],
        [2.0, 2.1, 2.2],
    ]
    output = [
        [2.0, 1.1, 0.0]
        [1.0, 0.0, 2.2]
        [0.0, 2.1, 1.2]
    ]
  Example 2:
    data = [[1.0, 2.0, 3.0, 4.0, 5.0]]
    indices = [[1, 3]]
    updates = [[1.1, 2.1]]
    axis = 1
    output = [[1.0, 1.1, 3.0, 2.1, 5.0]]

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 0)</dt>
<dd>Which axis to scatter on. Negative value means counting dimensions from the back. Accepted range is [-r, r-1]</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>Tensor of rank r >= 1.</dd>
<dt><tt>indices</tt> : Tind</dt>
<dd>Tensor of int32/int64 indices, of r >= 1 (same rank as input).</dd>
<dt><tt>updates</tt> : T</dt>
<dd>Tensor of rank r >=1 (same rank and shape as indices)</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Tensor of rank r >= 1 (same rank as input).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Input and output types can be of any tensor type.</dd>
<dt><tt>Tind</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain indices to integer types</dd>
</dl>

### <a name="Shrink-9"></a>**Shrink-9**</a>

  Shrink takes one input data (Tensor<numeric>) and produces one Tensor output,
  having same datatype and shape with input. It has two attributes, lambd and
  bias. The formula of this operator is: If x < -lambd, y = x + bias;
  If x > lambd, y = x - bias; Otherwise, y = 0.

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>bias</tt> : float (default is 0.0)</dt>
<dd>The bias value added to output. Default is 0.</dd>
<dt><tt>lambd</tt> : float (default is 0.5)</dt>
<dd>The lambd value for the Shrink formulation. Default is 0.5.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>The input data as Tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>The output.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input to only numeric types.</dd>
</dl>

### <a name="Sign-9"></a>**Sign-9**</a>

  Calculate the sign of the given input tensor element-wise.
  If input > 0, output 1. if input < 0, output -1. if input == 0, output 0.

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>The sign of the input tensor computed element-wise. It has the same shape and type of the input.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to all numeric tensors.</dd>
</dl>

### <a name="Sinh-9"></a>**Sinh-9**</a>

  Calculates the hyperbolic sine of the given input tensor element-wise.

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>The hyperbolic sine values of the input tensor computed element-wise</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="TfIdfVectorizer-9"></a>**TfIdfVectorizer-9**</a>

  This transform extracts n-grams from the input sequence and save them as a vector. Input can
  be either a 1-D or 2-D tensor. For 1-D input, output is the n-gram representation of that input.
  For 2-D input, the output is also a  2-D tensor whose i-th row is the n-gram representation of the i-th input row.
  More specifically, if input shape is [C], the corresponding output shape would be [max(ngram_indexes) + 1].
  If input shape is [N, C], this operator produces a [N, max(ngram_indexes) + 1]-tensor.

  In contrast to standard n-gram extraction, here, the indexes of extracting an n-gram from the original
  sequence are not necessarily consecutive numbers. The discontinuity between indexes are controlled by the number of skips.
  If the number of skips is 2, we should skip two tokens when scanning through the original sequence.
  Let's consider an example. Assume that input sequence is [94, 17, 36, 12, 28] and the number of skips is 2.
  The associated 2-grams are [94, 12] and [17, 28] respectively indexed by [0, 3] and [1, 4].
  If the number of skips becomes 0, the 2-grams generated are [94, 17], [17, 36], [36, 12], [12, 28]
  indexed by [0, 1], [1, 2], [2, 3], [3, 4], respectively.

  The output vector (denoted by Y) stores the count of each n-gram;
  Y[ngram_indexes[i]] indicates the times that the i-th n-gram is found. The attribute ngram_indexes is used to determine the mapping
  between index i and the corresponding n-gram's output coordinate. If pool_int64s is [94, 17, 17, 36], ngram_indexes is [1, 0],
  ngram_counts=[0, 0], then the Y[0] (first element in Y) and Y[1] (second element in Y) are the counts of [17, 36] and [94, 17],
  respectively. An n-gram which cannot be found in pool_strings/pool_int64s should be ignored and has no effect on the output.
  Note that we may consider all skips up to S when generating the n-grams.

  The examples used above are true if mode is "TF". If mode is "IDF", all the counts larger than 1 would be truncated to 1 and
  the i-th element in weights would be used to scale (by multiplication) the count of the i-th n-gram in pool. If mode is "TFIDF",
  this operator first computes the counts of all n-grams and then scale them by the associated values in the weights attribute.

  Only one of pool_strings and pool_int64s can be set. If pool_int64s is set, the input should be an integer tensor.
  If pool_strings is set, the input must be a string tensor.

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>max_gram_length</tt> : int (required)</dt>
<dd>Maximum n-gram length. If this value is 3, 3-grams will be used to generate the output.</dd>
<dt><tt>max_skip_count</tt> : int (required)</dt>
<dd>Maximum number of items (integers/strings) to be skipped when constructing an n-gram from X. If max_skip_count=1, min_gram_length=2, max_gram_length=3, this operator may generate 2-grams with skip_count=0 and skip_count=1, and 3-grams with skip_count=0 and skip_count=1</dd>
<dt><tt>min_gram_length</tt> : int (required)</dt>
<dd>Minimum n-gram length. If this value is 2 and max_gram_length is 3, output may contain counts of 2-grams and 3-grams.</dd>
<dt><tt>mode</tt> : string (required)</dt>
<dd>The weighting criteria. It can be one of "TF" (term frequency), "IDF" (inverse document frequency), and "TFIDF" (the combination of TF and IDF)</dd>
<dt><tt>ngram_counts</tt> : list of ints (required)</dt>
<dd>The starting indexes of 1-grams, 2-grams, and so on in pool. It is useful when determining the boundary between two consecutive collections of n-grams. For example, if ngram_counts is [0, 17, 36], the first index (zero-based) of 1-gram/2-gram/3-gram in pool are 0/17/36. This format is essentially identical to CSR (or CSC) sparse matrix format, and we choose to use this due to its popularity.</dd>
<dt><tt>ngram_indexes</tt> : list of ints (required)</dt>
<dd>list of int64s (type: AttributeProto::INTS). This list is parallel to the specified 'pool_*' attribute. The i-th element in ngram_indexes indicate the coordinate of the i-th n-gram in the output tensor.</dd>
<dt><tt>pool_int64s</tt> : list of ints</dt>
<dd>List of int64 n-grams learned from the training set. Either this or pool_strings attributes must be present but not both. It's an 1-D tensor starting with the collections of all 1-grams and ending with the collections of n-grams. The i-th element in pool stores the n-gram that should be mapped to coordinate ngram_indexes[i] in the output vector.</dd>
<dt><tt>pool_strings</tt> : list of strings</dt>
<dd>List of strings n-grams learned from the training set. Either this or pool_int64s attributes must be present but not both. It's an 1-D tensor starting with the collections of all 1-grams and ending with the collections of n-grams. The i-th element in pool stores the n-gram that should be mapped to coordinate ngram_indexes[i] in the output vector.</dd>
<dt><tt>weights</tt> : list of floats</dt>
<dd>list of floats. This attribute stores the weight of each n-gram in pool. The i-th element in weights is the weight of the i-th n-gram in pool. Its length equals to the size of ngram_indexes. By default, weights is an all-one tensor.This attribute is used when mode is "IDF" or "TFIDF" to scale the associated word counts.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> (non-differentiable) : T</dt>
<dd>Input for n-gram extraction</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (non-differentiable) : T1</dt>
<dd>Ngram results</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(string), tensor(int32), tensor(int64)</dt>
<dd>Input is ether string UTF-8 or int32/int64</dd>
<dt><tt>T1</tt> : tensor(float)</dt>
<dd>1-D tensor of floats</dd>
</dl>

### <a name="Upsample-9"></a>**Upsample-9**</a>

  Upsample the input tensor.
  Each dimension value of the output tensor is:
    output_dimension = floor(input_dimension * scale).

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>mode</tt> : string (default is nearest)</dt>
<dd>Two interpolation modes: nearest (default), and linear (including bilinear, trilinear, etc)</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>N-D tensor</dd>
<dt><tt>scales</tt> : tensor(float)</dt>
<dd>The scale array along each dimension. It takes value greater than or equal to 1. The number of elements of 'scales' should be the same as the rank of input 'X'.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>N-D tensor after resizing</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input 'X' and output 'Y' to all tensor types.</dd>
</dl>

### <a name="Where-9"></a>**Where-9**</a>

  Return elements, either from X or Y, depending on condition.
  Where behaves like
  [numpy.where](https://docs.scipy.org/doc/numpy/reference/generated/numpy.where.html)
  with three parameters.

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 9 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>condition</tt> (non-differentiable) : B</dt>
<dd>When True (nonzero), yield X, otherwise yield Y</dd>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>values selected at indices where condition is True</dd>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>values selected at indices where condition is False</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>Tensor of shape equal to the broadcasted shape of condition, X, and Y.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>B</tt> : tensor(bool)</dt>
<dd>Constrain to boolean tensors.</dd>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

## Version 10 of the default ONNX operator set
### <a name="AveragePool-10"></a>**AveragePool-10**</a>

  AveragePool consumes an input tensor X and applies average pooling across
   the tensor according to kernel sizes, stride sizes, and pad lengths.
   average pooling consisting of computing the average on all values of a
   subset of the input tensor according to the kernel size and downsampling the
   data into the output tensor Y for further processing. The output spatial shape will be following:
   ```
   output_spatial_shape[i] = floor((input_spatial_shape[i] + pad_shape[i] - kernel_spatial_shape[i]) / strides_spatial_shape[i] + 1)
   ```
   or
   ```
   output_spatial_shape[i] = ceil((input_spatial_shape[i] + pad_shape[i] - kernel_spatial_shape[i]) / strides_spatial_shape[i] + 1)
   ```
   if ceil_mode is enabled

   ```
   * pad_shape[i] is sum of pads along axis i
   ```

   `auto_pad` is a DEPRECATED attribute. If you are using them currently, the output spatial shape will be following:
   ```
   VALID: output_spatial_shape[i] = ceil((input_spatial_shape[i] - kernel_spatial_shape[i] + 1) / strides_spatial_shape[i])
   SAME_UPPER or SAME_LOWER: output_spatial_shape[i] = ceil(input_spatial_shape[i] / strides_spatial_shape[i])
   ```
   And pad shape will be following if `SAME_UPPER` or `SAME_LOWER`:
   ```
   pad_shape[i] = (output_spatial_shape[i] - 1) * strides_spatial_shape[i] + kernel_spatial_shape[i] - input_spatial_shape[i]
   ```
   The output of each pooling window is divided by the number of elements (exclude pad when attribute count_include_pad is zero).


#### Version

This version of the operator has been available since version 10 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>auto_pad</tt> : string (default is NOTSET)</dt>
<dd>auto_pad must be either NOTSET, SAME_UPPER, SAME_LOWER or VALID. Where default value is NOTSET, which means explicit padding is used. SAME_UPPER or SAME_LOWER mean pad the input so that the output spatial size match the input.In case of odd number add the extra padding at the end for SAME_UPPER and at the beginning for SAME_LOWER. VALID mean no padding.</dd>
<dt><tt>ceil_mode</tt> : int (default is 0)</dt>
<dd>Whether to use ceil or floor (default) to compute the output shape.</dd>
<dt><tt>count_include_pad</tt> : int (default is 0)</dt>
<dd>Whether include pad pixels when calculating values for the edges. Default is 0, doesn't count include pad.</dd>
<dt><tt>kernel_shape</tt> : list of ints (required)</dt>
<dd>The size of the kernel along each axis.</dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd>Padding for the beginning and ending along each spatial axis, it can take any value greater than or equal to 0. The value represent the number of pixels added to the beginning and end part of the corresponding axis. `pads` format should be as follow [x1_begin, x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels added at the beginning of axis `i` and xi_end, the number of pixels added at the end of axis `i`. This attribute cannot be used simultaneously with auto_pad attribute. If not present, the padding defaults to 0 along start and end of each spatial axis.</dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd>Stride along each spatial axis.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input data tensor from the previous operator; dimensions for image case are (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data. For non image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size. Optionally, if dimension denotation is in effect, the operation expects the input data tensor to arrive with the dimension denotation of [DATA_BATCH, DATA_CHANNEL, DATA_FEATURE, DATA_FEATURE ...].</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output data tensor from average or max pooling across the input tensor. Dimensions will vary based on various kernel, stride, and pad sizes. Floor value of the dimension is used</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="ConvInteger-10"></a>**ConvInteger-10**</a>

  The integer convolution operator consumes an input tensor, its zero-point, a filter, and its zero-point,
  and computes the output. The production MUST never overflow. The accumulation may overflow if and only if in 32 bits.

#### Version

This version of the operator has been available since version 10 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>auto_pad</tt> : string (default is NOTSET)</dt>
<dd>auto_pad must be either NOTSET, SAME_UPPER, SAME_LOWER or VALID. Where default value is NOTSET, which means explicit padding is used. SAME_UPPER or SAME_LOWER mean pad the input so that `output_shape[i] = ceil(input_shape[i] / strides[i])` for each axis `i`. The padding is split between the two sides equally or almost equally (depending on whether it is even or odd). In case the padding is an odd number, the extra padding is added at the end for SAME_UPPER and at the beginning for SAME_LOWER.</dd>
<dt><tt>dilations</tt> : list of ints</dt>
<dd>dilation value along each spatial axis of the filter. If not present, the dilation defaults to 1 along each axis.</dd>
<dt><tt>group</tt> : int (default is 1)</dt>
<dd>number of groups input channels and output channels are divided into. default is 1.</dd>
<dt><tt>kernel_shape</tt> : list of ints</dt>
<dd>The shape of the convolution kernel. If not present, should be inferred from input 'w'.</dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd>Padding for the beginning and ending along each spatial axis, it can take any value greater than or equal to 0.The value represent the number of pixels added to the beginning and end part of the corresponding axis.`pads` format should be as follow [x1_begin, x2_begin...x1_end, x2_end,...], where xi_begin the number ofpixels added at the beginning of axis `i` and xi_end, the number of pixels added at the end of axis `i`.This attribute cannot be used simultaneously with auto_pad attribute. If not present, the padding defaultsto 0 along start and end of each spatial axis.</dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd>Stride along each spatial axis. If not present, the stride defaults to 1 along each axis.</dd>
</dl>

#### Inputs (2 - 4)

<dl>
<dt><tt>x</tt> : T1</dt>
<dd>Input data tensor from previous layer; has size (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and width. Note that this is for the 2D image. Otherwise the size is (N x C x D1 x D2 ... x Dn). Optionally, if dimension denotation is in effect, the operation expects input data tensor to arrive with the dimension denotation of [DATA_BATCH, DATA_CHANNEL, DATA_FEATURE, DATA_FEATURE ...].</dd>
<dt><tt>w</tt> : T2</dt>
<dd>The weight tensor that will be used in the convolutions; has size (M x C/group x kH x kW), where C is the number of channels, and kH and kW are the height and width of the kernel, and M is the number of feature maps. For more than 2 dimensions, the kernel shape will be (M x C/group x k1 x k2 x ... x kn), where (k1 x k2 x ... kn) is the dimension of the kernel. Optionally, if dimension denotation is in effect, the operation expects the weight tensor to arrive with the dimension denotation of [FILTER_OUT_CHANNEL, FILTER_IN_CHANNEL, FILTER_SPATIAL, FILTER_SPATIAL ...]. X.shape[1] == (W.shape[1] * group) == C (assuming zero based indices for the shape array). Or in other words FILTER_IN_CHANNEL should be equal to DATA_CHANNEL. </dd>
<dt><tt>x_zero_point</tt> (optional) : T1</dt>
<dd>Zero point tensor for input 'x'. It's optional and default value is 0. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>w_zero_point</tt> (optional) : T2</dt>
<dd>Zero point tensor for input 'w'. It's optional and default value is 0.  It could be a scalar or a 1-D tensor, which means a per-tensor/layer or per output channel quantization. If it's a 1-D tensor, its number of elements should be equal to the number of output channels (M)</dd>
</dl>

#### Outputs

<dl>
<dt><tt>y</tt> : T3</dt>
<dd>Output data tensor that contains the result of the convolution. The output dimensions are functions of the kernel size, stride size, and pad lengths.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(int8), tensor(uint8)</dt>
<dd>Constrain input x and its zero point data type to 8-bit integer tensor.</dd>
<dt><tt>T2</tt> : tensor(int8), tensor(uint8)</dt>
<dd>Constrain input w and its zero point data type to 8-bit integer tensor.</dd>
<dt><tt>T3</tt> : tensor(int32)</dt>
<dd>Constrain output y data type to 32-bit integer tensor.</dd>
</dl>

### <a name="DequantizeLinear-10"></a>**DequantizeLinear-10**</a>

  The linear dequantization operator. It consumes a quantized tensor, a scale, a zero point to compute the full precision tensor.
  The dequantization formula is y = (x - x_zero_point) * x_scale. 'x_scale' and 'x_zero_point' are both scalars.
  'x_zero_point' and 'x' must have same type. 'x' and 'y' must have same shape. In the case of dequantizing int32,
  there's no zero point (zero point is supposed to be 0).

#### Version

This version of the operator has been available since version 10 of the default ONNX operator set.

#### Inputs (2 - 3)

<dl>
<dt><tt>x</tt> : T</dt>
<dd>N-D quantized input tensor to be de-quantized.</dd>
<dt><tt>x_scale</tt> : tensor(float)</dt>
<dd>Scale for input 'x'. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>x_zero_point</tt> (optional) : T</dt>
<dd>Zero point for input 'x'. It's a scalar, which means a per-tensor/layer quantization. It's optional. 0 is the default value when it's not specified.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>y</tt> : tensor(float)</dt>
<dd>N-D full precision output tensor. It has same shape as input 'x'.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(int8), tensor(uint8), tensor(int32)</dt>
<dd>Constrain 'x_zero_point' and 'x' to 8-bit/32-bit integer tensor.</dd>
</dl>

### <a name="Dropout-10"></a>**Dropout-10**</a>

  Dropout takes one input floating tensor and produces two tensor outputs,
  output (floating tensor) and mask (`Tensor<bool>`). Depending on whether it is
  in test mode or not, the output Y will either be a random dropout, or a simple
  copy of the input. Note that our implementation of Dropout does scaling in
  the training phase, so during testing nothing needs to be done.
  This operator has **optional** inputs/outputs. See [the doc](IR.md) for more details about the representation of optional arguments. An empty string may be used in the place of an actual argument's name to indicate a missing argument. Trailing optional arguments (those not followed by an argument that is present) may also be simply omitted.

#### Version

This version of the operator has been available since version 10 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>ratio</tt> : float (default is 0.5)</dt>
<dd>The ratio of random dropout</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>The input data as Tensor.</dd>
</dl>

#### Outputs (1 - 2)

<dl>
<dt><tt>output</tt> : T</dt>
<dd>The output.</dd>
<dt><tt>mask</tt> (optional) : T1</dt>
<dd>The output mask.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T1</tt> : tensor(bool)</dt>
<dd>Constrain output mask types to boolean tensors.</dd>
</dl>

### <a name="IsInf-10"></a>**IsInf-10**</a>

  Map infinity to true and other values to false.

#### Version

This version of the operator has been available since version 10 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>detect_negative</tt> : int (default is 1)</dt>
<dd>(Optional) Whether map negative infinity to true. Default to 1 so that negative infinity induces true. Set this attribute to 0 if negative infinity should be mapped to false.</dd>
<dt><tt>detect_positive</tt> : int (default is 1)</dt>
<dd>(Optional) Whether map positive infinity to true. Default to 1 so that positive infinity induces true. Set this attribute to 0 if positive infinity should be mapped to false.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> (non-differentiable) : T1</dt>
<dd>input</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (non-differentiable) : T2</dt>
<dd>output</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float), tensor(double)</dt>
<dd>Constrain input types to float tensors.</dd>
<dt><tt>T2</tt> : tensor(bool)</dt>
<dd>Constrain output types to boolean tensors.</dd>
</dl>

### <a name="MatMulInteger-10"></a>**MatMulInteger-10**</a>

  Matrix product that behaves like numpy.matmul: https://docs.scipy.org/doc/numpy-1.13.0/reference/generated/numpy.matmul.html.
  The production MUST never overflow. The accumulation may overflow if and only if in 32 bits.

#### Version

This version of the operator has been available since version 10 of the default ONNX operator set.

#### Inputs (2 - 4)

<dl>
<dt><tt>A</tt> (non-differentiable) : T1</dt>
<dd>N-dimensional matrix A</dd>
<dt><tt>B</tt> (non-differentiable) : T2</dt>
<dd>N-dimensional matrix B</dd>
<dt><tt>a_zero_point</tt> (optional, non-differentiable) : T1</dt>
<dd>Zero point tensor for input 'A'. It's optional and default value is 0. It could be a scalar or N-D tensor. Scalar refers to per tensor quantization whereas N-D refers to per row quantization. If the input is 2D of shape [M, K] then zero point tensor may be an M element vector [zp_1, zp_2, ..., zp_M]. If the input is N-D tensor with shape [D1, D2, M, K] then zero point tensor may have shape [D1, D2, M, 1]. </dd>
<dt><tt>b_zero_point</tt> (optional, non-differentiable) : T2</dt>
<dd>Zero point tensor for input 'B'. It's optional and default value is 0. It could be a scalar or a N-D tensor, Scalar refers to per tensor quantization whereas N-D refers to per col quantization. If the input is 2D of shape [K, N] then zero point tensor may be an N element vector [zp_1, zp_2, ..., zp_N]. If the input is N-D tensor with shape [D1, D2, K, N] then zero point tensor may have shape [D1, D2, 1, N]. </dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (non-differentiable) : T3</dt>
<dd>Matrix multiply results from A * B</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(int8), tensor(uint8)</dt>
<dd>Constrain input A data type to 8-bit integer tensor.</dd>
<dt><tt>T2</tt> : tensor(int8), tensor(uint8)</dt>
<dd>Constrain input B data type to 8-bit integer tensor.</dd>
<dt><tt>T3</tt> : tensor(int32)</dt>
<dd>Constrain output Y data type as 32-bit integer tensor.</dd>
</dl>

### <a name="MaxPool-10"></a>**MaxPool-10**</a>

  MaxPool consumes an input tensor X and applies max pooling across
   the tensor according to kernel sizes, stride sizes, and pad lengths.
   max pooling consisting of computing the max on all values of a
   subset of the input tensor according to the kernel size and downsampling the
   data into the output tensor Y for further processing. The output spatial shape will be following:
   ```
   output_spatial_shape[i] = floor((input_spatial_shape[i] + pad_shape[i] - ((kernel_spatial_shape[i] - 1) * dilations[i] + 1)) / strides_spatial_shape[i] + 1)
   ```
   or
   ```
   output_spatial_shape[i] = ceil((input_spatial_shape[i] + pad_shape[i] - ((kernel_spatial_shape[i] - 1) * dilations[i] + 1)) / strides_spatial_shape[i] + 1)
   ```
   if ceil_mode is enabled

   ```
   * pad_shape[i] is sum of pads along axis i
   ```

   `auto_pad` is a DEPRECATED attribute. If you are using them currently, the output spatial shape will be following:
   ```
   VALID: output_spatial_shape[i] = ceil((input_spatial_shape[i] - ((kernel_spatial_shape[i] - 1) * dilations[i] + 1) + 1) / strides_spatial_shape[i])
   SAME_UPPER or SAME_LOWER: output_spatial_shape[i] = ceil(input_spatial_shape[i] / strides_spatial_shape[i])
   ```
   And pad shape will be following if `SAME_UPPER` or `SAME_LOWER`:
   ```
   pad_shape[i] = (output_spatial_shape[i] - 1) * strides_spatial_shape[i] + ((kernel_spatial_shape[i] - 1) * dilations[i] + 1) - input_spatial_shape[i]
   ```
   The output of each pooling window is maximum number of elements exclude pad.


#### Version

This version of the operator has been available since version 10 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>auto_pad</tt> : string (default is NOTSET)</dt>
<dd>auto_pad must be either NOTSET, SAME_UPPER, SAME_LOWER or VALID. Where default value is NOTSET, which means explicit padding is used. SAME_UPPER or SAME_LOWER mean pad the input so that the output spatial size match the input.In case of odd number add the extra padding at the end for SAME_UPPER and at the beginning for SAME_LOWER. VALID mean no padding.</dd>
<dt><tt>ceil_mode</tt> : int (default is 0)</dt>
<dd>Whether to use ceil or floor (default) to compute the output shape.</dd>
<dt><tt>dilations</tt> : list of ints</dt>
<dd>Dilation value along each spatial axis of filter.</dd>
<dt><tt>kernel_shape</tt> : list of ints (required)</dt>
<dd>The size of the kernel along each axis.</dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd>Padding for the beginning and ending along each spatial axis, it can take any value greater than or equal to 0. The value represent the number of pixels added to the beginning and end part of the corresponding axis. `pads` format should be as follow [x1_begin, x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels added at the beginning of axis `i` and xi_end, the number of pixels added at the end of axis `i`. This attribute cannot be used simultaneously with auto_pad attribute. If not present, the padding defaults to 0 along start and end of each spatial axis.</dd>
<dt><tt>storage_order</tt> : int (default is 0)</dt>
<dd>The storage order of the tensor. 0 is row major, and 1 is column major.</dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd>Stride along each spatial axis.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input data tensor from the previous operator; dimensions for image case are (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data. For non image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size. Optionally, if dimension denotation is in effect, the operation expects the input data tensor to arrive with the dimension denotation of [DATA_BATCH, DATA_CHANNEL, DATA_FEATURE, DATA_FEATURE ...].</dd>
</dl>

#### Outputs (1 - 2)

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output data tensor from average or max pooling across the input tensor. Dimensions will vary based on various kernel, stride, and pad sizes. Floor value of the dimension is used</dd>
<dt><tt>Indices</tt> (optional) : I</dt>
<dd>Indices tensor from max pooling across the input tensor. The dimensions of indices are the same as output tensor. The values in indices of are the indices of the selected values during pooling. The indices are computed as flatten 1-D tensor, and the indices do not consider padding. So the values in indices are in [0, N x C x D1 x ... x Dn).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>I</tt> : tensor(int64)</dt>
<dd>Constrain index tensor to int64</dd>
</dl>

### <a name="Mod-10"></a>**Mod-10**</a>

  Performs element-wise binary modulus (with Numpy-style broadcasting support).
      The sign of the remainder is the same as that of the Divisor.

      Mod operator can also behave like C fmod() or numpy.fmod. In this case, the sign of the remainder however, will be the same as the Dividend
      (in contrast to integer mod). To force a behavior like numpy.fmod() an 'fmod' Attribute is provided.
      This attribute is set to 0 by default causing the behavior to be like integer mod.
      Setting this attribute to 1 causes the remainder to be calculated similar to that of numpy.fmod().

      If the input type is floating point, then `fmod` attribute must be set to 1.

      In case of dividend being zero, the results will be platform dependent.

    This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 10 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>fmod</tt> : int (default is 0)</dt>
<dd>Whether the operator should behave like fmod (default=0 meaning it will do integer mods); Set this to 1 to force fmod treatment</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>Dividend tensor</dd>
<dt><tt>B</tt> : T</dt>
<dd>Divisor tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T</dt>
<dd>Remainder tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="NonMaxSuppression-10"></a>**NonMaxSuppression-10**</a>

  Filter out boxes that have high intersection-over-union (IOU) overlap with previously selected boxes.
  Bounding boxes with score less than score_threshold are removed. Bounding box format is indicated by attribute center_point_box.
  Note that this algorithm is agnostic to where the origin is in the coordinate system and more generally is invariant to
  orthogonal transformations and translations of the coordinate system; thus translating or reflections of the coordinate system
  result in the same boxes being selected by the algorithm.
  The selected_indices output is a set of integers indexing into the input collection of bounding boxes representing the selected boxes.
  The bounding box coordinates corresponding to the selected indices can then be obtained using the Gather or GatherND operation.

#### Version

This version of the operator has been available since version 10 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>center_point_box</tt> : int (default is 0)</dt>
<dd>Integer indicate the format of the box data. The default is 0. 0 - the box data is supplied as [y1, x1, y2, x2] where (y1, x1) and (y2, x2) are the coordinates of any diagonal pair of box corners and the coordinates can be provided as normalized (i.e., lying in the interval [0, 1]) or absolute. Mostly used for TF models. 1 - the box data is supplied as [x_center, y_center, width, height]. Mostly used for Pytorch models.</dd>
</dl>

#### Inputs (2 - 5)

<dl>
<dt><tt>boxes</tt> : tensor(float)</dt>
<dd>An input tensor with shape [num_batches, spatial_dimension, 4]. The single box data format is indicated by center_point_box.</dd>
<dt><tt>scores</tt> : tensor(float)</dt>
<dd>An input tensor with shape [num_batches, num_classes, spatial_dimension]</dd>
<dt><tt>max_output_boxes_per_class</tt> (optional) : tensor(int64)</dt>
<dd>Integer representing the maximum number of boxes to be selected per batch per class. It is a scalar. Default to 0, which means no output.</dd>
<dt><tt>iou_threshold</tt> (optional) : tensor(float)</dt>
<dd>Float representing the threshold for deciding whether boxes overlap too much with respect to IOU. It is scalar. Value range [0, 1]. Default to 0.</dd>
<dt><tt>score_threshold</tt> (optional) : tensor(float)</dt>
<dd>Float representing the threshold for deciding when to remove boxes based on score. It is a scalar.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>selected_indices</tt> : tensor(int64)</dt>
<dd>selected indices from the boxes tensor. [num_selected_indices, 3], the selected index format is [batch_index, class_index, box_index].</dd>
</dl>

#### Type Constraints


### <a name="QLinearConv-10"></a>**QLinearConv-10**</a>

  The convolution operator consumes a quantized input tensor, its scale and zero point,
  a quantized filter, its scale and zero point, and output's scale and zero point,
  and computes the quantized output. Each scale and zero-point pair must have same shape.
  It means they must be either scalars (per tensor) or 1-D tensors (per output channel).
  Each input or output and its related zero point must have same type.
  When bias is present it must be quantized using scale = input scale * weight scale and
  zero point as 0.

#### Version

This version of the operator has been available since version 10 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>auto_pad</tt> : string (default is NOTSET)</dt>
<dd>auto_pad must be either NOTSET, SAME_UPPER, SAME_LOWER or VALID. Where default value is NOTSET, which means explicit padding is used. SAME_UPPER or SAME_LOWER mean pad the input so that `output_shape[i] = ceil(input_shape[i] / strides[i])` for each axis `i`. The padding is split between the two sides equally or almost equally (depending on whether it is even or odd). In case the padding is an odd number, the extra padding is added at the end for SAME_UPPER and at the beginning for SAME_LOWER.</dd>
<dt><tt>dilations</tt> : list of ints</dt>
<dd>dilation value along each spatial axis of the filter. If not present, the dilation defaults to 1 along each spatial axis.</dd>
<dt><tt>group</tt> : int (default is 1)</dt>
<dd>number of groups input channels and output channels are divided into. default is 1.</dd>
<dt><tt>kernel_shape</tt> : list of ints</dt>
<dd>The shape of the convolution kernel. If not present, should be inferred from input 'w'.</dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd>Padding for the beginning and ending along each spatial axis, it can take any value greater than or equal to 0.The value represent the number of pixels added to the beginning and end part of the corresponding axis.`pads` format should be as follow [x1_begin, x2_begin...x1_end, x2_end,...], where xi_begin the number ofpixels added at the beginning of axis `i` and xi_end, the number of pixels added at the end of axis `i`.This attribute cannot be used simultaneously with auto_pad attribute. If not present, the padding defaultsto 0 along start and end of each spatial axis.</dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd>Stride along each spatial axis. If not present, the stride defaults to 1 along each spatial axis.</dd>
</dl>

#### Inputs (8 - 9)

<dl>
<dt><tt>x</tt> : T1</dt>
<dd>Input data tensor from previous layer; has size (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and width. Note that this is for the 2D image. Otherwise the size is (N x C x D1 x D2 ... x Dn). Optionally, if dimension denotation is in effect, the operation expects input data tensor to arrive with the dimension denotation of [DATA_BATCH, DATA_CHANNEL, DATA_FEATURE, DATA_FEATURE ...].</dd>
<dt><tt>x_scale</tt> : tensor(float)</dt>
<dd>Scale tensor for input 'x'. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>x_zero_point</tt> : T1</dt>
<dd>Zero point tensor for input 'x'. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>w</tt> : T2</dt>
<dd>The weight tensor that will be used in the convolutions; has size (M x C/group x kH x kW), where C is the number of channels, and kH and kW are the height and width of the kernel, and M is the number of feature maps. For more than 2 dimensions, the kernel shape will be (M x C/group x k1 x k2 x ... x kn), where (k1 x k2 x ... kn) is the dimension of the kernel. Optionally, if dimension denotation is in effect, the operation expects the weight tensor to arrive with the dimension denotation of [FILTER_OUT_CHANNEL, FILTER_IN_CHANNEL, FILTER_SPATIAL, FILTER_SPATIAL ...]. X.shape[1] == (W.shape[1] * group) == C (assuming zero based indices for the shape array). Or in other words FILTER_IN_CHANNEL should be equal to DATA_CHANNEL. </dd>
<dt><tt>w_scale</tt> : tensor(float)</dt>
<dd>Scale tensor for input 'w'. It could be a scalar or a 1-D tensor, which means a per-tensor/layer or per output channel quantization. If it's a 1-D tensor, its number of elements should be equal to the number of output channels (M).</dd>
<dt><tt>w_zero_point</tt> : T2</dt>
<dd>Zero point tensor for input 'w'. It could be a scalar or a 1-D tensor, which means a per-tensor/layer or per output channel quantization. If it's a 1-D tensor, its number of elements should be equal to the number of output channels (M).</dd>
<dt><tt>y_scale</tt> : tensor(float)</dt>
<dd>Scale tensor for output 'y'. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>y_zero_point</tt> : T3</dt>
<dd>Zero point tensor for output 'y'. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>B</tt> (optional) : T4</dt>
<dd>Optional 1D bias to be added to the convolution, has size of M. Bias must be quantized using scale = x_scale * w_scale and zero_point = 0</dd>
</dl>

#### Outputs

<dl>
<dt><tt>y</tt> : T3</dt>
<dd>Output data tensor that contains the result of the convolution. The output dimensions are functions of the kernel size, stride size, and pad lengths.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(int8), tensor(uint8)</dt>
<dd>Constrain input type to 8-bit integer tensor.</dd>
<dt><tt>T2</tt> : tensor(int8), tensor(uint8)</dt>
<dd>Constrain filter type to 8-bit integer tensor.</dd>
<dt><tt>T3</tt> : tensor(int8), tensor(uint8)</dt>
<dd>Constrain output type to 8-bit integer tensor.</dd>
<dt><tt>T4</tt> : tensor(int32)</dt>
<dd>Constrain bias type to 32-bit integer tensor.</dd>
</dl>

### <a name="QLinearMatMul-10"></a>**QLinearMatMul-10**</a>

  Matrix product that behaves like numpy.matmul: https://docs.scipy.org/doc/numpy-1.13.0/reference/generated/numpy.matmul.html.
  It consumes two quantized input tensors, their scales and zero points, scale and zero point of output,
  and computes the quantized output. The quantization formula is y = saturate((x / y_scale) + y_zero_point).
  For (x / y_scale), it is rounding to nearest ties to even. Refer to https://en.wikipedia.org/wiki/Rounding for details.
  Scale and zero point must have same shape. They must be either scalar (per tensor) or N-D tensor
  (per row for 'a' and per column for 'b'). Scalar refers to per tensor quantization whereas N-D refers to per row
  or per column quantization. If the input is 2D of shape [M, K] then zero point and scale tensor may be
  an M element vector [v_1, v_2, ..., v_M] for per row quantization and K element vector of shape [v_1, v_2, ..., v_K]
  for per column quantization. If the input is N-D tensor with shape [D1, D2, M, K] then zero point and scale tensor may
  have shape [D1, D2, M, 1] for per row quantization and shape [D1, D2, 1, K] for per column quantization.
  Production must never overflow, and accumulation may overflow if and only if in 32 bits.

#### Version

This version of the operator has been available since version 10 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>a</tt> (non-differentiable) : T1</dt>
<dd>N-dimensional quantized matrix a</dd>
<dt><tt>a_scale</tt> (non-differentiable) : tensor(float)</dt>
<dd>scale of quantized input a</dd>
<dt><tt>a_zero_point</tt> (non-differentiable) : T1</dt>
<dd>zero point of quantized input a</dd>
<dt><tt>b</tt> (non-differentiable) : T2</dt>
<dd>N-dimensional quantized matrix b</dd>
<dt><tt>b_scale</tt> (non-differentiable) : tensor(float)</dt>
<dd>scale of quantized input b</dd>
<dt><tt>b_zero_point</tt> (non-differentiable) : T2</dt>
<dd>zero point of quantized input b</dd>
<dt><tt>y_scale</tt> (non-differentiable) : tensor(float)</dt>
<dd>scale of quantized output y</dd>
<dt><tt>y_zero_point</tt> (non-differentiable) : T3</dt>
<dd>zero point of quantized output y</dd>
</dl>

#### Outputs

<dl>
<dt><tt>y</tt> (non-differentiable) : T3</dt>
<dd>Quantized matrix multiply results from a * b</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(int8), tensor(uint8)</dt>
<dd>Constrain input a and its zero point data type to 8-bit integer tensor.</dd>
<dt><tt>T2</tt> : tensor(int8), tensor(uint8)</dt>
<dd>Constrain input b and its zero point data type to 8-bit integer tensor.</dd>
<dt><tt>T3</tt> : tensor(int8), tensor(uint8)</dt>
<dd>Constrain output y and its zero point data type to 8-bit integer tensor.</dd>
</dl>

### <a name="QuantizeLinear-10"></a>**QuantizeLinear-10**</a>

  The linear per-tensor/layer quantization operator. It consumes a high precision tensor, a scale, a zero point to compute the low precision / quantized tensor.
  The quantization formula is y = saturate ((x / y_scale) + y_zero_point). For saturation, it saturates to [0, 255] if it's uint8, or [-128, 127] if it's int8.
  For (x / y_scale), it's rounding to nearest ties to even. Refer to https://en.wikipedia.org/wiki/Rounding for details. 'y_zero_point' and 'y' must have same type.

#### Version

This version of the operator has been available since version 10 of the default ONNX operator set.

#### Inputs (2 - 3)

<dl>
<dt><tt>x</tt> : T1</dt>
<dd>N-D full precision Input tensor to be quantized.</dd>
<dt><tt>y_scale</tt> : tensor(float)</dt>
<dd>Scale for doing quantization to get 'y'. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>y_zero_point</tt> (optional) : T2</dt>
<dd>Zero point for doing quantization to get 'y'. It's a scalar, which means a per-tensor/layer quantization. Default value is uint8 typed 0 if it's not specified.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>y</tt> : T2</dt>
<dd>N-D quantized output tensor. It has same shape as input 'x'.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float), tensor(int32)</dt>
<dd>Constrain 'x' to float or int32 tensor.</dd>
<dt><tt>T2</tt> : tensor(int8), tensor(uint8)</dt>
<dd>Constrain 'y_zero_point' and 'y' to 8-bit integer tensor.</dd>
</dl>

### <a name="Resize-10"></a>**Resize-10**</a>

  Resize the input tensor.
  Each dimension value of the output tensor is:
    output_dimension = floor(input_dimension * scale).

#### Version

This version of the operator has been available since version 10 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>mode</tt> : string (default is nearest)</dt>
<dd>Two interpolation modes: nearest (default), and linear (including bilinear, trilinear, etc)</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>N-D tensor</dd>
<dt><tt>scales</tt> : tensor(float)</dt>
<dd>The scale array along each dimension. It takes value greater than 0. If it's less than 1, it's sampling down, otherwise, it's upsampling. The number of elements of 'scales' should be the same as the rank of input 'X'.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>N-D tensor after resizing</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input 'X' and output 'Y' to all tensor types.</dd>
</dl>

### <a name="ReverseSequence-10"></a>**ReverseSequence-10**</a>

  Reverse batch of sequences having different lengths specified by `sequence_lens`.

  For each slice i iterating on batch axis, the operator reverses the first sequence_lens[i] elements on time axis,
  and copies elements whose index's beyond sequence_lens[i] to the output. So the output slice i contains reversed
  sequences on the first sequence_lens[i] elements, then have original values copied for the other elements.

  Example 1:
    input = [[0.0, 4.0, 8.0,  12.0],
             [1.0, 5.0, 9.0,  13.0],
             [2.0, 6.0, 10.0, 14.0],
             [3.0, 7.0, 11.0, 15.0]]
    sequence_lens = [4, 3, 2, 1]
    time_axis = 0
    batch_axis = 1

    output = [[3.0, 6.0, 9.0,  12.0],
              [2.0, 5.0, 8.0,  13.0],
              [1.0, 4.0, 10.0, 14.0],
              [0.0, 7.0, 11.0, 15.0]]

  Example 2:
    input = [[0.0,  1.0,  2.0,  3.0 ],
             [4.0,  5.0,  6.0,  7.0 ],
             [8.0,  9.0,  10.0, 11.0],
             [12.0, 13.0, 14.0, 15.0]]
    sequence_lens = [1, 2, 3, 4]
    time_axis = 1
    batch_axis = 0

    output = [[0.0,  1.0,  2.0,  3.0 ],
              [5.0,  4.0,  6.0,  7.0 ],
              [10.0, 9.0,  8.0,  11.0],
              [15.0, 14.0, 13.0, 12.0]]

#### Version

This version of the operator has been available since version 10 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>batch_axis</tt> : int (default is 1)</dt>
<dd>(Optional) Specify which axis is batch axis. Must be one of 1 (default), or 0.</dd>
<dt><tt>time_axis</tt> : int (default is 0)</dt>
<dd>(Optional) Specify which axis is time axis. Must be one of 0 (default), or 1.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>Tensor of rank r >= 2.</dd>
<dt><tt>sequence_lens</tt> : tensor(int64)</dt>
<dd>Tensor specifying lengths of the sequences in a batch. It has shape `[batch_size]`.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Tensor with same shape of input.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Input and output types can be of any tensor type.</dd>
</dl>

### <a name="RoiAlign-10"></a>**RoiAlign-10**</a>

  Region of Interest (RoI) align operation described in the
  [Mask R-CNN paper](https://arxiv.org/abs/1703.06870).
  RoiAlign consumes an input tensor X and region of interests (rois)
  to apply pooling across each RoI; it produces a 4-D tensor of shape
  (num_rois, C, output_height, output_width).

  RoiAlign is proposed to avoid the misalignment by removing
  quantizations while converting from original image into feature
  map and from feature map into RoI feature; in each ROI bin,
  the value of the sampled locations are computed directly
  through bilinear interpolation.

#### Version

This version of the operator has been available since version 10 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>mode</tt> : string (default is avg)</dt>
<dd>The pooling method. Two modes are supported: 'avg' and 'max'. Default is 'avg'.</dd>
<dt><tt>output_height</tt> : int (default is 1)</dt>
<dd>default 1; Pooled output Y's height.</dd>
<dt><tt>output_width</tt> : int (default is 1)</dt>
<dd>default 1; Pooled output Y's width.</dd>
<dt><tt>sampling_ratio</tt> : int (default is 0)</dt>
<dd>Number of sampling points in the interpolation grid used to compute the output value of each pooled output bin. If > 0, then exactly sampling_ratio x sampling_ratio grid points are used. If == 0, then an adaptive number of grid points are used (computed as ceil(roi_width / output_width), and likewise for height). Default is 0.</dd>
<dt><tt>spatial_scale</tt> : float (default is 1.0)</dt>
<dd>Multiplicative spatial scale factor to translate ROI coordinates from their input spatial scale to the scale used when pooling, i.e., spatial scale of the input feature map X relative to the input image. E.g.; default is 1.0f. </dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T1</dt>
<dd>Input data tensor from the previous operator; 4-D feature map of shape (N, C, H, W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data.</dd>
<dt><tt>rois</tt> : T1</dt>
<dd>RoIs (Regions of Interest) to pool over; rois is 2-D input of shape (num_rois, 4) given as [[x1, y1, x2, y2], ...]. The RoIs' coordinates are in the coordinate system of the input image. Each coordinate set has a 1:1 correspondence with the 'batch_indices' input.</dd>
<dt><tt>batch_indices</tt> : T2</dt>
<dd>1-D tensor of shape (num_rois,) with each element denoting the index of the corresponding image in the batch.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T1</dt>
<dd>RoI pooled output, 4-D tensor of shape (num_rois, C, output_height, output_width). The r-th batch element Y[r-1] is a pooled feature map corresponding to the r-th RoI X[r-1].</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain types to float tensors.</dd>
<dt><tt>T2</tt> : tensor(int64)</dt>
<dd>Constrain types to int tensors.</dd>
</dl>

### <a name="Slice-10"></a>**Slice-10**</a>

  Produces a slice of the input tensor along multiple axes. Similar to numpy:
  https://docs.scipy.org/doc/numpy/reference/arrays.indexing.html
  Slices uses `starts`, `ends`, `axes` and `steps` inputs to specify the start and end
  dimension and step for each axis in the list of axes, it uses this information to
  slice the input `data` tensor. If a negative value is passed for any of the
  start or end indices, it represent number of elements before the end of that
  dimension. If the value passed to start or end is larger than the `n` (the
  number of elements in this dimension), it represents `n`. For slicing to the
  end of a dimension with unknown size, it is recommended to pass in `INT_MAX`.
  If a negative value is passed for step, it represents slicing backward.
  If `axes` are omitted, they are set to `[0, ..., ndim-1]`.
  If `steps` are omitted, they are set to `[1, ..., 1]` of length `len(starts)`
  Example 1:
    data = [
        [1, 2, 3, 4],
        [5, 6, 7, 8],
    ]
    axes = [0, 1]
    starts = [1, 0]
    ends = [2, 3]
    steps = [1, 2]
    result = [
        [5, 7],
    ]
  Example 2:
    data = [
        [1, 2, 3, 4],
        [5, 6, 7, 8],
    ]
    starts = [0, 1]
    ends = [-1, 1000]
    result = [
        [2, 3, 4],
    ]

#### Version

This version of the operator has been available since version 10 of the default ONNX operator set.

#### Inputs (3 - 5)

<dl>
<dt><tt>data</tt> : T</dt>
<dd>Tensor of data to extract slices from.</dd>
<dt><tt>starts</tt> : Tind</dt>
<dd>1-D tensor of starting indices of corresponding axis in `axes`</dd>
<dt><tt>ends</tt> : Tind</dt>
<dd>1-D tensor of ending indices (exclusive) of corresponding axis in `axes`</dd>
<dt><tt>axes</tt> (optional) : Tind</dt>
<dd>1-D tensor of axes that `starts` and `ends` apply to.</dd>
<dt><tt>steps</tt> (optional) : Tind</dt>
<dd>1-D tensor of slice step of corresponding axis in `axes`. Default to 1. </dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Sliced data tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
<dt><tt>Tind</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain indices to integer types</dd>
</dl>

### <a name="StringNormalizer-10"></a>**StringNormalizer-10**</a>

  StringNormalization performs string operations for basic cleaning.
  This operator has only one input (denoted by X) and only one output
  (denoted by Y). This operator first examines the elements in the X,
  and removes elements specified in "stopwords" attribute.
  After removing stop words, the intermediate result can be further lowercased,
  uppercased, or just returned depending the "case_change_action" attribute.
  This operator only accepts [C]- and [1, C]-tensor.
  If all elements in X are dropped, the output will be the empty value of string tensor with shape [1]
  if input shape is [C] and shape [1, 1] if input shape is [1, C].

#### Version

This version of the operator has been available since version 10 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>case_change_action</tt> : string (default is NONE)</dt>
<dd>string enum that cases output to be lowercased/uppercases/unchanged. Valid values are "LOWER", "UPPER", "NONE". Default is "NONE"</dd>
<dt><tt>is_case_sensitive</tt> : int (default is 0)</dt>
<dd>Boolean. Whether the identification of stop words in X is case-sensitive. Default is false</dd>
<dt><tt>locale</tt> : string</dt>
<dd>Environment dependent string that denotes the locale according to which output strings needs to be upper/lowercased.Default en_US or platform specific equivalent as decided by the implementation.</dd>
<dt><tt>stopwords</tt> : list of strings</dt>
<dd>List of stop words. If not set, no word would be removed from X.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : tensor(string)</dt>
<dd>UTF-8 strings to normalize</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : tensor(string)</dt>
<dd>UTF-8 Normalized strings</dd>
</dl>

#### Type Constraints


### <a name="ThresholdedRelu-10"></a>**ThresholdedRelu-10**</a>

  ThresholdedRelu takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the rectified linear function, y = x for x > alpha, y = 0 otherwise,
  is applied to the tensor elementwise.

#### Version

This version of the operator has been available since version 10 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float (default is 1.0)</dt>
<dd>Threshold value</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="TopK-10"></a>**TopK-10**</a>

  Retrieve the top-K elements along a specified axis. Given an input tensor of
  shape [a_1, a_2, ..., a_n, r] and integer argument k, return two outputs:
    -Value tensor of shape [a_1, a_2, ..., a_{axis-1}, k, a_{axis+1}, ... a_n]
      which contains the values of the top k elements along the specified axis
    -Index tensor of shape [a_1, a_2, ..., a_{axis-1}, k, a_{axis+1}, ... a_n] which
     contains the indices of the top k elements (original indices from the input
     tensor).

  Given two equivalent values, this operator uses the indices along the axis  as
   a tiebreaker. That is, the element with the lower index will appear first.

#### Version

This version of the operator has been available since version 10 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is -1)</dt>
<dd>Dimension on which to do the sort.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Tensor of shape [a_1, a_2, ..., a_n, r]</dd>
<dt><tt>K</tt> : tensor(int64)</dt>
<dd>A 1-D tensor containing a single positive value corresponding to the number of top elements to retrieve</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Values</tt> : T</dt>
<dd>Tensor of shape [a_1, a_2, ..., a_{axis-1}, k, a_{axis+1}, ... a_n] containing top K values from the input tensor</dd>
<dt><tt>Indices</tt> : I</dt>
<dd>Tensor of shape [a_1, a_2, ..., a_{axis-1}, k, a_{axis+1}, ... a_n] containing the corresponding input tensor indices for the top K values.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>I</tt> : tensor(int64)</dt>
<dd>Constrain index tensor to int64</dd>
</dl>

### <a name="Upsample-10"></a>**Upsample-10** (deprecated)</a>

  Upsample the input tensor.
  Each dimension value of the output tensor is:
    output_dimension = floor(input_dimension * scale).

#### Version

This version of the operator has been deprecated since version 10 of the default ONNX operator set.

## Version 11 of the default ONNX operator set
### <a name="ArgMax-11"></a>**ArgMax-11**</a>

  Computes the indices of the max elements of the input tensor's element along the
  provided axis. The resulting tensor has the same rank as the input if keepdims equals 1.
  If keepdims equal 0, then the resulting tensor has the reduced dimension pruned.
  The type of the output tensor is integer.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 0)</dt>
<dd>The axis in which to compute the arg indices. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : tensor(int64)</dt>
<dd>Reduced output tensor with integer data type.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to all numeric tensors.</dd>
</dl>

### <a name="ArgMin-11"></a>**ArgMin-11**</a>

  Computes the indices of the min elements of the input tensor's element along the
  provided axis. The resulting tensor has the same rank as the input if keepdims equals 1.
  If keepdims equal 0, then the resulting tensor has the reduced dimension pruned.
  The type of the output tensor is integer.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 0)</dt>
<dd>The axis in which to compute the arg indices. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : tensor(int64)</dt>
<dd>Reduced output tensor with integer data type.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to all numeric tensors.</dd>
</dl>

### <a name="AveragePool-11"></a>**AveragePool-11**</a>

  AveragePool consumes an input tensor X and applies average pooling across
   the tensor according to kernel sizes, stride sizes, and pad lengths.
   average pooling consisting of computing the average on all values of a
   subset of the input tensor according to the kernel size and downsampling the
   data into the output tensor Y for further processing. The output spatial shape will be following:
   ```
   output_spatial_shape[i] = floor((input_spatial_shape[i] + pad_shape[i] - kernel_spatial_shape[i]) / strides_spatial_shape[i] + 1)
   ```
   or
   ```
   output_spatial_shape[i] = ceil((input_spatial_shape[i] + pad_shape[i] - kernel_spatial_shape[i]) / strides_spatial_shape[i] + 1)
   ```
   if ceil_mode is enabled

   ```
   * pad_shape[i] is sum of pads along axis i
   ```

   `auto_pad` is a DEPRECATED attribute. If you are using them currently, the output spatial shape will be following:
   ```
   VALID: output_spatial_shape[i] = ceil((input_spatial_shape[i] - kernel_spatial_shape[i] + 1) / strides_spatial_shape[i])
   SAME_UPPER or SAME_LOWER: output_spatial_shape[i] = ceil(input_spatial_shape[i] / strides_spatial_shape[i])
   ```
   And pad shape will be following if `SAME_UPPER` or `SAME_LOWER`:
   ```
   pad_shape[i] = (output_spatial_shape[i] - 1) * strides_spatial_shape[i] + kernel_spatial_shape[i] - input_spatial_shape[i]
   ```
   The output of each pooling window is divided by the number of elements (exclude pad when attribute count_include_pad is zero).


#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>auto_pad</tt> : string (default is NOTSET)</dt>
<dd>auto_pad must be either NOTSET, SAME_UPPER, SAME_LOWER or VALID. Where default value is NOTSET, which means explicit padding is used. SAME_UPPER or SAME_LOWER mean pad the input so that `output_shape[i] = ceil(input_shape[i] / strides[i])` for each axis `i`. The padding is split between the two sides equally or almost equally (depending on whether it is even or odd). In case the padding is an odd number, the extra padding is added at the end for SAME_UPPER and at the beginning for SAME_LOWER.</dd>
<dt><tt>ceil_mode</tt> : int (default is 0)</dt>
<dd>Whether to use ceil or floor (default) to compute the output shape.</dd>
<dt><tt>count_include_pad</tt> : int (default is 0)</dt>
<dd>Whether include pad pixels when calculating values for the edges. Default is 0, doesn't count include pad.</dd>
<dt><tt>kernel_shape</tt> : list of ints (required)</dt>
<dd>The size of the kernel along each axis.</dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd>Padding for the beginning and ending along each spatial axis, it can take any value greater than or equal to 0. The value represent the number of pixels added to the beginning and end part of the corresponding axis. `pads` format should be as follow [x1_begin, x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels added at the beginning of axis `i` and xi_end, the number of pixels added at the end of axis `i`. This attribute cannot be used simultaneously with auto_pad attribute. If not present, the padding defaults to 0 along start and end of each spatial axis.</dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd>Stride along each spatial axis. If not present, the stride defaults to 1 along each spatial axis.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input data tensor from the previous operator; dimensions for image case are (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data. For non image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size. Optionally, if dimension denotation is in effect, the operation expects the input data tensor to arrive with the dimension denotation of [DATA_BATCH, DATA_CHANNEL, DATA_FEATURE, DATA_FEATURE ...].</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output data tensor from average or max pooling across the input tensor. Dimensions will vary based on various kernel, stride, and pad sizes. Floor value of the dimension is used</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="BitShift-11"></a>**BitShift-11**</a>

  Bitwise shift operator performs element-wise operation. For each input element, if the
   attribute "direction" is "RIGHT", this operator moves its binary representation toward
   the right side so that the input value is effectively decreased. If the attribute "direction"
   is "LEFT", bits of binary representation moves toward the left side, which results the
   increase of its actual value. The input X is the tensor to be shifted and another input
   Y specifies the amounts of shifting. For example, if "direction" is "Right", X is [1, 4],
   and S is [1, 1], the corresponding output Z would be [0, 2]. If "direction" is "LEFT" with
   X=[1, 2] and S=[1, 2], the corresponding output Y would be [2, 8].

   Because this operator supports Numpy-style broadcasting, X's and Y's shapes are
   not necessarily identical.
  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>direction</tt> : string (required)</dt>
<dd>Direction of moving bits. It can be either "RIGHT" (for right shift) or "LEFT" (for left shift).</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> (non-differentiable) : T</dt>
<dd>First operand, input to be shifted.</dd>
<dt><tt>Y</tt> (non-differentiable) : T</dt>
<dd>Second operand, amounts of shift.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Z</tt> (non-differentiable) : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64)</dt>
<dd>Constrain input and output types to integer tensors.</dd>
</dl>

### <a name="Clip-11"></a>**Clip-11**</a>

  Clip operator limits the given input within an interval. The interval is
  specified by the inputs 'min' and 'max'. They default to
  numeric_limits::lowest() and numeric_limits::max(), respectively.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Inputs (1 - 3)

<dl>
<dt><tt>input</tt> : T</dt>
<dd>Input tensor whose elements to be clipped</dd>
<dt><tt>min</tt> (optional) : T</dt>
<dd>Minimum value, under which element is replaced by min. It must be a scalar(tensor of empty shape).</dd>
<dt><tt>max</tt> (optional) : T</dt>
<dd>Maximum value, above which element is replaced by max. It must be a scalar(tensor of empty shape).</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Output tensor with clipped input elements</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Compress-11"></a>**Compress-11**</a>

  Selects slices from an input tensor along a given axis where condition evaluates to True for each axis index.
      In case axis is not provided, input is flattened before elements are selected.
      Compress behaves like numpy.compress: https://docs.scipy.org/doc/numpy/reference/generated/numpy.compress.html


#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int</dt>
<dd>(Optional) Axis along which to take slices. If not specified, input is flattened before elements being selected. Negative value means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(input).</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Tensor of rank r >= 1.</dd>
<dt><tt>condition</tt> (non-differentiable) : T1</dt>
<dd>Rank 1 tensor of booleans to indicate which slices or data elements to be selected. Its length can be less than the input length along the axis or the flattened input size if axis is not specified. In such cases data slices or elements exceeding the condition length are discarded.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>Tensor of rank r if axis is specified. Otherwise output is a Tensor of rank 1.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
<dt><tt>T1</tt> : tensor(bool)</dt>
<dd>Constrain to boolean tensors.</dd>
</dl>

### <a name="Concat-11"></a>**Concat-11**</a>

  Concatenate a list of tensors into a single tensor. All input tensors must have the same shape, except for the dimension size of the axis to concatenate on.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (required)</dt>
<dd>Which axis to concat on. A negative value means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(inputs)..</dd>
</dl>

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>inputs</tt> (variadic) : T</dt>
<dd>List of tensors for concatenation</dd>
</dl>

#### Outputs

<dl>
<dt><tt>concat_result</tt> : T</dt>
<dd>Concatenated tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain output types to any tensor type.</dd>
</dl>

### <a name="ConcatFromSequence-11"></a>**ConcatFromSequence-11**</a>

  Concatenate a sequence of tensors into a single tensor.
  All input tensors must have the same shape, except for the dimension size of the axis to concatenate on.
  By default 'new_axis' is 0, the behavior is similar to numpy.concatenate.
  When 'new_axis' is 1, the behavior is similar to numpy.stack.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (required)</dt>
<dd>Which axis to concat on. Accepted range in `[-r, r - 1]`, where `r` is the rank of input tensors. When `new_axis` is 1, accepted range is `[-r - 1, r]`. </dd>
<dt><tt>new_axis</tt> : int (default is 0)</dt>
<dd>Insert and concatenate on a new axis or not, default 0 means do not insert new axis.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input_sequence</tt> : S</dt>
<dd>Sequence of tensors for concatenation</dd>
</dl>

#### Outputs

<dl>
<dt><tt>concat_result</tt> : T</dt>
<dd>Concatenated tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>S</tt> : seq(tensor(uint8)), seq(tensor(uint16)), seq(tensor(uint32)), seq(tensor(uint64)), seq(tensor(int8)), seq(tensor(int16)), seq(tensor(int32)), seq(tensor(int64)), seq(tensor(float16)), seq(tensor(float)), seq(tensor(double)), seq(tensor(string)), seq(tensor(bool)), seq(tensor(complex64)), seq(tensor(complex128))</dt>
<dd>Constrain input types to any tensor type.</dd>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain output types to any tensor type.</dd>
</dl>

### <a name="Constant-11"></a>**Constant-11**</a>

  A constant tensor. Exactly one of the two attributes, either value or sparse_value,
  must be specified.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>sparse_value</tt> : sparse_tensor</dt>
<dd>The value for the elements of the output tensor in sparse format.</dd>
<dt><tt>value</tt> : tensor</dt>
<dd>The value for the elements of the output tensor.</dd>
</dl>

#### Inputs


#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Output tensor containing the same value of the provided tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

### <a name="Conv-11"></a>**Conv-11**</a>

  The convolution operator consumes an input tensor and a filter, and
  computes the output.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>auto_pad</tt> : string (default is NOTSET)</dt>
<dd>auto_pad must be either NOTSET, SAME_UPPER, SAME_LOWER or VALID. Where default value is NOTSET, which means explicit padding is used. SAME_UPPER or SAME_LOWER mean pad the input so that `output_shape[i] = ceil(input_shape[i] / strides[i])` for each axis `i`. The padding is split between the two sides equally or almost equally (depending on whether it is even or odd). In case the padding is an odd number, the extra padding is added at the end for SAME_UPPER and at the beginning for SAME_LOWER.</dd>
<dt><tt>dilations</tt> : list of ints</dt>
<dd>dilation value along each spatial axis of the filter. If not present, the dilation defaults is 1 along each spatial axis.</dd>
<dt><tt>group</tt> : int (default is 1)</dt>
<dd>number of groups input channels and output channels are divided into.</dd>
<dt><tt>kernel_shape</tt> : list of ints</dt>
<dd>The shape of the convolution kernel. If not present, should be inferred from input W.</dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd>Padding for the beginning and ending along each spatial axis, it can take any value greater than or equal to 0. The value represent the number of pixels added to the beginning and end part of the corresponding axis. `pads` format should be as follow [x1_begin, x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels added at the beginning of axis `i` and xi_end, the number of pixels added at the end of axis `i`. This attribute cannot be used simultaneously with auto_pad attribute. If not present, the padding defaults to 0 along start and end of each spatial axis.</dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd>Stride along each spatial axis. If not present, the stride defaults is 1 along each spatial axis.</dd>
</dl>

#### Inputs (2 - 3)

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input data tensor from previous layer; has size (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and width. Note that this is for the 2D image. Otherwise the size is (N x C x D1 x D2 ... x Dn). Optionally, if dimension denotation is in effect, the operation expects input data tensor to arrive with the dimension denotation of [DATA_BATCH, DATA_CHANNEL, DATA_FEATURE, DATA_FEATURE ...].</dd>
<dt><tt>W</tt> (differentiable) : T</dt>
<dd>The weight tensor that will be used in the convolutions; has size (M x C/group x kH x kW), where C is the number of channels, and kH and kW are the height and width of the kernel, and M is the number of feature maps. For more than 2 dimensions, the kernel shape will be (M x C/group x k1 x k2 x ... x kn), where (k1 x k2 x ... kn) is the dimension of the kernel. Optionally, if dimension denotation is in effect, the operation expects the weight tensor to arrive with the dimension denotation of [FILTER_OUT_CHANNEL, FILTER_IN_CHANNEL, FILTER_SPATIAL, FILTER_SPATIAL ...]. Assuming zero based indices for the shape array, X.shape[1] == (W.shape[1] * group) == C and W.shape[0] mod G == 0. Or in other words FILTER_IN_CHANNEL multiplied by the number of groups should be equal to DATA_CHANNEL and the number of feature maps M should be a multiple of the number of groups G.</dd>
<dt><tt>B</tt> (optional, differentiable) : T</dt>
<dd>Optional 1D bias to be added to the convolution, has size of M.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output data tensor that contains the result of the convolution. The output dimensions are functions of the kernel size, stride size, and pad lengths.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="ConvTranspose-11"></a>**ConvTranspose-11**</a>

  The convolution transpose operator consumes an input tensor and a filter,
  and computes the output.

  If the pads parameter is provided the shape of the output is calculated via the following equation:

    output_shape[i] = stride[i] * (input_size[i] - 1) + output_padding[i] + ((kernel_shape[i] - 1) * dilations[i] + 1) - pads[start_i] - pads[end_i]

  output_shape can also be explicitly specified in which case pads values are auto generated using these equations:

    total_padding[i] = stride[i] * (input_size[i] - 1) + output_padding[i] + ((kernel_shape[i] - 1) * dilations[i] + 1) - output_shape[i]
    If (auto_pads == SAME_UPPER): pads[start_i] = total_padding[i]/2; pads[end_i] = total_padding[i] - (total_padding[i]/2)
    Else: pads[start_i] = total_padding[i] - (total_padding[i]/2); pads[end_i] = (total_padding[i]/2).



#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>auto_pad</tt> : string (default is NOTSET)</dt>
<dd>auto_pad must be either NOTSET, SAME_UPPER, SAME_LOWER or VALID. Where default value is NOTSET, which means explicit padding is used. SAME_UPPER or SAME_LOWER mean pad the input so that `output_shape[i] = input_shape[i] * strides[i]` for each axis `i`. The padding is split between the two sides equally or almost equally (depending on whether it is even or odd). In case the padding is an odd number, the extra padding is added at the end for SAME_UPPER and at the beginning for SAME_LOWER.</dd>
<dt><tt>dilations</tt> : list of ints</dt>
<dd>dilation value along each spatial axis of the filter. If not present, the dilation defaults to 1 along each spatial axis.</dd>
<dt><tt>group</tt> : int (default is 1)</dt>
<dd>number of groups input channels and output channels are divided into.</dd>
<dt><tt>kernel_shape</tt> : list of ints</dt>
<dd>The shape of the convolution kernel. If not present, should be inferred from input W.</dd>
<dt><tt>output_padding</tt> : list of ints</dt>
<dd>Additional elements added to the side with higher coordinate indices in the output. Each padding value in "output_padding" must be less than the corresponding stride/dilation dimension. By default, this attribute is a zero vector. Note that this attribute doesn't directly affect the computed output values. It only controls the selection of the computed values, so changing this attribute only adds or removes output elements. If "output_shape" is explicitly provided, "output_padding" does not contribute additional size to "output_shape" but participates in the computation of the needed padding amount. This is also called adjs or adjustment in some frameworks.</dd>
<dt><tt>output_shape</tt> : list of ints</dt>
<dd>The shape of the output can be explicitly set which will cause pads values to be auto generated. If output_shape is specified pads values are ignored. See doc for details for equations to generate pads</dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd>Padding for the beginning and ending along each spatial axis, it can take any value greater than or equal to 0. The value represent the number of pixels added to the beginning and end part of the corresponding axis. `pads` format should be as follow [x1_begin, x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels added at the beginning of axis `i` and xi_end, the number of pixels added at the end of axis `i`. This attribute cannot be used simultaneously with auto_pad attribute. If not present, the padding defaults to 0 along start and end of each spatial axis.</dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd>Stride along each spatial axis. If not present, the stride defaults to 1 along each spatial axis.</dd>
</dl>

#### Inputs (2 - 3)

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input data tensor from previous layer; has size (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and width. Note that this is for the 2D image. Otherwise the size is (N x C x D1 x D2 ... x Dn)</dd>
<dt><tt>W</tt> (differentiable) : T</dt>
<dd>The weight tensor that will be used in the convolutions; has size (C x M/group x kH x kW), where C is the number of channels, and kH and kW are the height and width of the kernel, and M is the number of feature maps. For more than 2 dimensions, the weight shape will be (C x M/group x k1 x k2 x ... x kn), where (k1 x k2 x ... x kn) is the dimension of the kernel. The number of channels in the output should be equal to W.shape[1] * group (assuming zero based indices of the shape array)</dd>
<dt><tt>B</tt> (optional, differentiable) : T</dt>
<dd>Optional 1D bias to be added to the convolution, has size of M.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output data tensor that contains the result of the convolution. The output dimensions are functions of the kernel size, stride size, pad lengths and group count. The number of channels in the output should be equal to W.shape[1] * group (assuming zero based indices of the shape array)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="CumSum-11"></a>**CumSum-11**</a>

  Performs cumulative sum of the input elements along the given axis.
  By default, it will do the sum inclusively meaning the first element is copied as is.
  Through an `exclusive` attribute, this behavior can change to exclude the first element.
  It can also perform summation in the opposite direction of the axis. For that, set `reverse` attribute to 1.

  Example:
  ```
  input_x = [1, 2, 3]
  axis=0
  output = [1, 3, 6]
  exclusive=1
  output = [0, 1, 3]
  exclusive=0
  reverse=1
  output = [6, 5, 3]
  exclusive=1
  reverse=1
  output = [5, 3, 0]
  ```


#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>exclusive</tt> : int (default is 0)</dt>
<dd>If set to 1 will return exclusive sum in which the top element is not included. In other terms, if set to 1, the j-th output element would be the sum of the first (j-1) elements. Otherwise, it would be the sum of the first j elements.</dd>
<dt><tt>reverse</tt> : int (default is 0)</dt>
<dd>If set to 1 will perform the sums in reverse direction.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>x</tt> (differentiable) : T</dt>
<dd>An input tensor that is to be processed.</dd>
<dt><tt>axis</tt> (non-differentiable) : T2</dt>
<dd>A 0-D tensor. Must be in the range [-rank(x), rank(x)-1]. Negative value means counting dimensions from the back.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>y</tt> (differentiable) : T</dt>
<dd>Output tensor of the same type as 'x' with cumulative sums of the x's elements</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float), tensor(double)</dt>
<dd>Input can be of any tensor type.</dd>
<dt><tt>T2</tt> : tensor(int32), tensor(int64)</dt>
<dd>axis tensor can be int32 or int64 only</dd>
</dl>

### <a name="DepthToSpace-11"></a>**DepthToSpace-11**</a>

  DepthToSpace rearranges (permutes) data from depth into blocks of spatial data.
  This is the reverse transformation of SpaceToDepth. More specifically, this op outputs a copy of
  the input tensor where values from the depth dimension are moved in spatial blocks to the height
  and width dimensions. By default, `mode` = `DCR`.
  In the DCR mode, elements along the depth dimension from the input tensor are rearranged in the
  following order: depth, column, and then row. The output y is computed from the input x as below:

  b, c, h, w = x.shape

  tmp = np.reshape(x, [b, blocksize, blocksize, c // (blocksize**2), h, w])

  tmp = np.transpose(tmp, [0, 3, 4, 1, 5, 2])

  y = np.reshape(tmp, [b, c // (blocksize**2), h * blocksize, w * blocksize])


  In the CRD mode, elements along the depth dimension from the input tensor are rearranged in the
  following order: column, row, and the depth. The output y is computed from the input x as below:

  b, c, h, w = x.shape

  tmp = np.reshape(x, [b, c // (blocksize ** 2), blocksize, blocksize, h, w])

  tmp = np.transpose(tmp, [0, 1, 4, 2, 5, 3])

  y = np.reshape(tmp, [b, c // (blocksize ** 2), h * blocksize, w * blocksize])


#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>blocksize</tt> : int (required)</dt>
<dd>Blocks of [blocksize, blocksize] are moved.</dd>
<dt><tt>mode</tt> : string (default is DCR)</dt>
<dd>DCR (default) for depth-column-row order re-arrangement. Use CRD for column-row-depth order.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>Input tensor of [N,C,H,W], where N is the batch axis, C is the channel or depth, H is the height and W is the width.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Output tensor of [N, C/(blocksize * blocksize), H * blocksize, W * blocksize].</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

### <a name="Det-11"></a>**Det-11**</a>

  Det calculates determinant of a square matrix or batches of square matrices.
  Det takes one input tensor of shape `[*, M, M]`, where `*` is zero or more batch dimensions,
  and the inner-most 2 dimensions form square matrices.
  The output is a tensor of shape `[*]`, containing the determinants of all input submatrices.
  e.g., When the input is 2-D, the output is a scalar(shape is empty: `[]`).

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to floating-point tensors.</dd>
</dl>

### <a name="DynamicQuantizeLinear-11"></a>**DynamicQuantizeLinear-11**</a>

  A Function to fuse calculation for Scale, Zero Point and FP32->8Bit convertion of FP32 Input data.
  Outputs Scale, ZeroPoint and Quantized Input for a given FP32 Input.
  Scale is calculated as:
  ```
   y_scale = (max(x) - min(x))/(qmax - qmin)
   * where qmax and qmin are max and min values for quantization range .i.e [0, 255] in case of uint8
   * data range is adjusted to include 0.
  ```
  Zero point is calculated as:
  ```
  intermediate_zero_point = qmin - min(x)/y_scale
  y_zero_point = cast(round(saturate(itermediate_zero_point)))
  * where qmax and qmin are max and min values for quantization range .i.e [0, 255] in case of uint8
  * for saturation, it saturates to [0, 255] if it's uint8, or [-127, 127] if it's int8. Right now only uint8 is supported.
  * rounding to nearest ties to even.
  ```
  Data quantization formula is:
  ```
  y = saturate (round (x / y_scale) + y_zero_point)
  * for saturation, it saturates to [0, 255] if it's uint8, or [-127, 127] if it's int8. Right now only uint8 is supported.
  * rounding to nearest ties to even.
  ```

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>x</tt> : T1</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>y</tt> : T2</dt>
<dd>Quantized output tensor</dd>
<dt><tt>y_scale</tt> : tensor(float)</dt>
<dd>Output scale. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>y_zero_point</tt> : T2</dt>
<dd>Output zero point. It's a scalar, which means a per-tensor/layer quantization.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float)</dt>
<dd>Constrain 'x' to float tensor.</dd>
<dt><tt>T2</tt> : tensor(uint8)</dt>
<dd>Constrain 'y_zero_point' and 'y' to 8-bit unsigned integer tensor.</dd>
</dl>

### <a name="Equal-11"></a>**Equal-11**</a>

  Returns the tensor resulted from performing the `equal` logical operation
  elementwise on the input tensors `A` and `B` (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>First input operand for the logical operator.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Second input operand for the logical operator.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T1</dt>
<dd>Result tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(bool), tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input types to all numeric tensors.</dd>
<dt><tt>T1</tt> : tensor(bool)</dt>
<dd>Constrain output to boolean tensor.</dd>
</dl>

### <a name="Flatten-11"></a>**Flatten-11**</a>

  Flattens the input tensor into a 2D matrix. If input tensor has shape
  (d_0, d_1, ... d_n) then the output will have shape
  (d_0 X d_1 ... d_(axis-1), d_axis X d_(axis+1) ... X dn).

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 1)</dt>
<dd>Indicate up to which input dimensions (exclusive) should be flattened to the outer dimension of the output. The value for axis must be in the range [-r, r], where r is the rank of the input tensor. Negative value means counting dimensions from the back. When axis = 0, the shape of the output tensor is (1, (d_0 X d_1 ... d_n), where the shape of the input tensor is (d_0, d_1, ... d_n). </dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>A tensor of rank >= axis.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>A 2D tensor with the contents of the input tensor, with input dimensions up to axis flattened to the outer dimension of the output and remaining input dimensions flattened into the inner dimension of the output.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output to all tensor types.</dd>
</dl>

### <a name="Gather-11"></a>**Gather-11**</a>

  Given `data` tensor of rank r >= 1, and `indices` tensor of rank q, gather
  entries of the axis dimension of `data` (by default outer-most one as axis=0) indexed by `indices`, and concatenates
  them in an output tensor of rank q + (r - 1).

  axis = 0 :

  Let
  k = indices[i_{0}, ..., i_{q-1}]
  Then
  output[i_{0}, ..., i_{q-1}, j_{0}, ..., j_{r-2}] = input[k , j_{0}, ..., j_{r-2}]

  ```
    data = [
        [1.0, 1.2],
        [2.3, 3.4],
        [4.5, 5.7],
    ]
    indices = [
        [0, 1],
        [1, 2],
    ]
    output = [
        [
            [1.0, 1.2],
            [2.3, 3.4],
        ],
        [
            [2.3, 3.4],
            [4.5, 5.7],
        ],
    ]
  ```
  axis = 1 :

  Let
  k = indices[i_{0}, ..., i_{q-1}]
  Then
  output[i_{0}, ..., i_{q-1}, j_{0}, ..., j_{r-2}] = input[j_{0}, k, j_{1}, ..., j_{r-2}]

  ```
    data = [
        [1.0, 1.2, 1.9],
        [2.3, 3.4, 3.9],
        [4.5, 5.7, 5.9],
    ]
    indices = [
        [0, 2],
    ]
    axis = 1,
    output = [
        [
            [1.0, 1.9],
            [2.3, 3.9],
            [4.5, 5.9],
        ],
    ]
  ```

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 0)</dt>
<dd>Which axis to gather on. Negative value means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(data).</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>Tensor of rank r >= 1.</dd>
<dt><tt>indices</tt> : Tind</dt>
<dd>Tensor of int32/int64 indices, of any rank q. All index values are expected to be within bounds [-s, s-1] along axis of size s. It is an error if any of the index values are out of bounds.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Tensor of rank q + (r - 1).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to any tensor type.</dd>
<dt><tt>Tind</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain indices to integer types</dd>
</dl>

### <a name="GatherElements-11"></a>**GatherElements-11**</a>

  GatherElements takes two inputs `data` and `indices` of the same rank r >= 1
  and an optional attribute `axis` that identifies an axis of `data`
  (by default, the outer-most axis, that is axis 0). It is an indexing operation
  that produces its output by indexing into the input data tensor at index
  positions determined by elements of the `indices` tensor.
  Its output shape is the same as the shape of `indices` and consists of one value
  (gathered from the `data`) for each element in `indices`.

  For instance, in the 3-D case (r = 3), the output produced is determined
  by the following equations:
  ```
    out[i][j][k] = input[index[i][j][k]][j][k] if axis = 0,
    out[i][j][k] = input[i][index[i][j][k]][k] if axis = 1,
    out[i][j][k] = input[i][j][index[i][j][k]] if axis = 2,
  ```

  This operator is also the inverse of ScatterElements. It is similar to Torch's gather operation.

  Example 1:
  ```
    data = [
        [1, 2],
        [3, 4],
    ]
    indices = [
        [0, 0],
        [1, 0],
    ]
    axis = 1
    output = [
        [
          [1, 1],
          [4, 3],
        ],
    ]
  ```
  Example 2:
  ```
    data = [
        [1, 2, 3],
        [4, 5, 6],
        [7, 8, 9],
    ]
    indices = [
        [1, 2, 0],
        [2, 0, 0],
    ]
    axis = 0
    output = [
        [
          [4, 8, 3],
          [7, 2, 3],
        ],
    ]
  ```

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 0)</dt>
<dd>Which axis to gather on. Negative value means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(data).</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>Tensor of rank r >= 1.</dd>
<dt><tt>indices</tt> : Tind</dt>
<dd>Tensor of int32/int64 indices, with the same rank r as the input. All index values are expected to be within bounds [-s, s-1] along axis of size s. It is an error if any of the index values are out of bounds.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Tensor of the same shape as indices.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to any tensor type.</dd>
<dt><tt>Tind</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain indices to integer types</dd>
</dl>

### <a name="GatherND-11"></a>**GatherND-11**</a>

  Given `data` tensor of rank `r` >= 1, and `indices` tensor of rank `q` >= 1, this operator gathers
  slices of `data` into an output tensor of rank `q + r - indices_shape[-1] - 1`.

  `indices` is an q-dimensional integer tensor, best thought of as a `(q-1)`-dimensional tensor of index-tuples into `data`,
  where each element defines a slice of `data`

  Some salient points about the inputs' rank and shape:

  1) r >= 1 and q >= 1 are to be honored. There is no dependency condition to be met between ranks `r` and `q`

  2) The `indices_shape[-1]` should have a value between 1 (inclusive) and rank `r` (inclusive)

  3) All values in `indices` are expected to be within bounds [-s, s-1] along axis of size `s` (i.e.) `-data_shape[i] <= indices[...,i] <= data_shape[i] - 1`.
     It is an error if any of the index values are out of bounds.

  The output is computed as follows:

  The output tensor is obtained by mapping each index-tuple in the `indices` tensor to the corresponding slice of the input `data`.

  1) If `indices_shape[-1] > r` => error condition

  2) If `indices_shape[-1] == r`, since the rank of `indices` is `q`, `indices` can be thought of as a `(q-1)`-dimensional tensor
     containing 1-D tensors of dimension `r`. Let us think of each such `r` ranked tensor as `indices_slice`.
     Each *scalar value* corresponding to `data[indices_slice]` is filled into the corresponding location of the `(q-1)`-dimensional tensor
     to form the `output` tensor (Example 1 below)

  3) If `indices_shape[-1] < r`, since the rank of `indices` is `q`, `indices` can be thought of as a `(q-1)`-dimensional tensor
     containing 1-D tensors of dimension `< r`. Let us think of each such tensors as `indices_slice`.
     Each *tensor slice* corresponding to `data[indices_slice , :]` is filled into the corresponding location of the `(q-1)`-dimensional tensor
     to form the `output` tensor (Examples 2, 3, and 4 below)

  This operator is the inverse of `ScatterND`.

  `Example 1`

    data    = [[0,1],[2,3]]   # data_shape = [2, 2]

    indices = [[0,0],[1,1]]   # indices_shape = [2, 2]

    output  = [0,3]           # output_shape = [2]

  `Example 2`

    data    = [[0,1],[2,3]]  # data_shape = [2, 2]

    indices = [[1],[0]]      # indices_shape = [2, 1]

    output  = [[2,3],[0,1]]  # output_shape = [2, 2]

  `Example 3`

    data    = [[[0,1],[2,3]],[[4,5],[6,7]]] # data_shape = [2, 2, 2]

    indices = [[0,1],[1,0]]                 # indices_shape = [2, 2]

    output  = [[2,3],[4,5]]                 # output_shape = [2, 2]

  `Example 4`

    data    = [[[0,1],[2,3]],[[4,5],[6,7]]] # data_shape = [2, 2, 2]

    indices = [[[0,1]],[[1,0]]]             # indices_shape = [2, 1, 2]

    output  = [[[2,3]],[[4,5]]]             # output_shape = [2, 1, 2]


#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>Tensor of rank r >= 1.</dd>
<dt><tt>indices</tt> : tensor(int64)</dt>
<dd>Tensor of rank q >= 1. All index values are expected to be within bounds [-s, s-1] along axis of size s. It is an error if any of the index values are out of bounds.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Tensor of rank q + r - indices_shape[-1] - 1.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to any tensor type.</dd>
</dl>

### <a name="Gemm-11"></a>**Gemm-11**</a>

  General Matrix multiplication:
  https://en.wikipedia.org/wiki/Basic_Linear_Algebra_Subprograms#Level_3

  A' = transpose(A) if transA else A

  B' = transpose(B) if transB else B

  Compute Y = alpha * A' * B' + beta * C, where input tensor A has shape (M, K) or (K, M),
  input tensor B has shape (K, N) or (N, K), input tensor C is broadcastable to shape (M, N),
  and output tensor Y has shape (M, N). A will be transposed before doing the
  computation if attribute transA is non-zero, same for B and transB.
  This operator supports **unidirectional broadcasting** (tensor C should be unidirectional broadcastable to tensor A * B); for more details please check [the doc](Broadcasting.md).
  This operator has **optional** inputs/outputs. See [the doc](IR.md) for more details about the representation of optional arguments. An empty string may be used in the place of an actual argument's name to indicate a missing argument. Trailing optional arguments (those not followed by an argument that is present) may also be simply omitted.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float (default is 1.0)</dt>
<dd>Scalar multiplier for the product of input tensors A * B.</dd>
<dt><tt>beta</tt> : float (default is 1.0)</dt>
<dd>Scalar multiplier for input tensor C.</dd>
<dt><tt>transA</tt> : int (default is 0)</dt>
<dd>Whether A should be transposed</dd>
<dt><tt>transB</tt> : int (default is 0)</dt>
<dd>Whether B should be transposed</dd>
</dl>

#### Inputs (2 - 3)

<dl>
<dt><tt>A</tt> : T</dt>
<dd>Input tensor A. The shape of A should be (M, K) if transA is 0, or (K, M) if transA is non-zero.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Input tensor B. The shape of B should be (K, N) if transB is 0, or (N, K) if transB is non-zero.</dd>
<dt><tt>C</tt> (optional) : T</dt>
<dd>Optional input tensor C. If not specified, the computation is done as if C is a scalar 0. The shape of C should be unidirectional broadcastable to (M, N).</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor of shape (M, N).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(uint32), tensor(uint64), tensor(int32), tensor(int64)</dt>
<dd>Constrain input and output types to float/int tensors.</dd>
</dl>

### <a name="Hardmax-11"></a>**Hardmax-11**</a>

  The operator computes the hardmax (1 for the first maximum value, and 0 for all others) values for each layer in the batch
   of the given input.

  The input does not need to explicitly be a 2D vector; rather, it will be
  coerced into one. For an arbitrary n-dimensional tensor
  input \in [a_0, a_1, ..., a_{k-1}, a_k, ..., a_{n-1}] and k is
  the axis provided, then input will be coerced into a 2-dimensional tensor with
  dimensions [a_0 * ... * a_{k-1}, a_k * ... * a_{n-1}]. For the default
  case where axis=1, this means the input tensor will be coerced into a 2D tensor
  of dimensions [a_0, a_1 * ... * a_{n-1}], where a_0 is often the batch size.
  In this situation, we must have a_0 = N and a_1 * ... * a_{n-1} = D.
  Each of these dimensions must be matched correctly, or else the operator
  will throw errors. The output tensor has the same shape
  and contains the hardmax values of the corresponding input.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 1)</dt>
<dd>Describes the axis of the inputs when coerced to 2D; defaults to one because the 0th axis most likely describes the batch_size. Negative value means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(input).</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>The input tensor that's coerced into a 2D matrix of size (NxD) as described above.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>The output values with the same shape as input tensor (the original size without coercion).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="If-11"></a>**If-11**</a>

  If conditional

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>else_branch</tt> : graph (required)</dt>
<dd>Graph to run if condition is false. Has N outputs: values you wish to be live-out to the enclosing scope. The number of outputs must match the number of outputs in the then_branch.</dd>
<dt><tt>then_branch</tt> : graph (required)</dt>
<dd>Graph to run if condition is true. Has N outputs: values you wish to be live-out to the enclosing scope. The number of outputs must match the number of outputs in the else_branch.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>cond</tt> : B</dt>
<dd>Condition for the if</dd>
</dl>

#### Outputs (1 - &#8734;)

<dl>
<dt><tt>outputs</tt> (variadic, heterogeneous) : V</dt>
<dd>Values that are live-out to the enclosing scope. The return values in the `then_branch` and `else_branch` must be of the same data type. The `then_branch` and `else_branch` may produce tensors with the same element type and different shapes. If corresponding outputs from the then-branch and the else-branch have static shapes S1 and S2, then the shape of the corresponding output variable of the if-node (if present) must be compatible with both S1 and S2 as it represents the union of both possible shapes.For example, if in a model file, the the first output of `then_branch` is typed float tensor with shape [2] and the first output of `else_branch` is another float tensor with shape [3], If's first output should have (a) no shape set, or (b) a shape of rank 1 with neither `dim_value` nor `dim_param` set, or (c) a shape of rank 1 with a unique `dim_param`. In contrast, the first output cannot have the shape [2] since [2] and [3] are not compatible.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>V</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>All Tensor types</dd>
<dt><tt>B</tt> : tensor(bool)</dt>
<dd>Only bool</dd>
</dl>

### <a name="LogSoftmax-11"></a>**LogSoftmax-11**</a>

  The operator computes the logsoftmax (log of softmax) values for each layer in the batch
   of the given input.

  The input does not need to explicitly be a 2D vector; rather, it will be
  coerced into one. For an arbitrary n-dimensional tensor
  input \in [a_0, a_1, ..., a_{k-1}, a_k, ..., a_{n-1}] and k is
  the axis provided, then input will be coerced into a 2-dimensional tensor with
  dimensions [a_0 * ... * a_{k-1}, a_k * ... * a_{n-1}]. For the default
  case where axis=1, this means the input tensor will be coerced into a 2D tensor
  of dimensions [a_0, a_1 * ... * a_{n-1}], where a_0 is often the batch size.
  In this situation, we must have a_0 = N and a_1 * ... * a_{n-1} = D.
  Each of these dimensions must be matched correctly, or else the operator
  will throw errors. The output tensor has the same shape
  and contains the logsoftmax values of the corresponding input.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 1)</dt>
<dd>Describes the axis of the inputs when coerced to 2D; defaults to one because the 0th axis most likely describes the batch_size. Negative value means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(input).</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>The input tensor that's coerced into a 2D matrix of size (NxD) as described above.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>The output values with the same shape as input tensor (the original size without coercion).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Loop-11"></a>**Loop-11**</a>

  Generic Looping construct. This loop has multiple termination conditions:

  1) Trip count. Iteration count specified at runtime. Set by
     specifying the input M. Optional. Set to empty string to omit.
     Note that a static trip count (specified at graph construction time) can be
     specified by passing in a constant node for input M.
  2) Loop termination condition. This is an input to the op that determines
     whether to run the first iteration and also a loop-carried dependency for
     the body graph. The body graph must yield a value for the condition variable,
     whether this input is provided or not.

  This table summarizes the operating modes of this operator with equivalent
  C-style code:

      Operator inputs defined as (max_trip_count, condition_var).

      input ("", ""):
          for (int i=0; ; ++i) {
            cond = ... // Note this value is ignored, but is required in the body
          }

      input ("", cond) // Note this is analogous to a while loop
          bool cond = ...;
          for (int i=0; cond; ++i) {
            cond = ...;
          }

      input ("", 1) // Note this is analogous to a do-while loop
          bool cond = true
          for (int i=0; cond; ++i) {
            cond = ...;
          }

      input (trip_count, "") // Note this is analogous to a for loop
          int trip_count = ...
          for (int i=0; i < trip_count; ++i) {
            cond = ...; // ignored
          }

      input (trip_count, cond)
          int trip_count = ...;
          bool cond = ...;
          for (int i=0; i < trip_count && cond; ++i) {
            cond = ...;
          }


  *Sample usage - cond as well as trip count*

      graph predict-net {
        %a = Constant[value = <Scalar Tensor [3]>]()
        %b = Constant[value = <Scalar Tensor [6]>]()
        %keepgoing = Constant[value = <Scalar Tensor [1]>]()
        %max_trip_count = Constant[value = <Scalar Tensor [10]>]()
        %keepgoing_out, %b_out, %user_defined_vals = Loop[body = <graph body-net>](%max_trip_count, %keepgoing, %b)
        return
      }

      graph body-net (
        %i[INT32, scalar]           // iteration number
        %keepgoing_in[BOOL, scalar] // incoming loop-termination-condition; not used
        %b_in[INT32, scalar]        // incoming value of loop-carried-dependency b
      ) {
        %my_local = Add(%a, %b_in)
        %b_out = Sub(%a, %b_in) // outgoing value of loop-carried-dependency b
        %keepgoing_out = Greater(%my_local, %b_out) // outgoing loop-termination-condition
        %user_defined_val = Add(%b_in, %b_in) // scan-output value to be accumulated
        return %keepgoing_out, %b_out, %user_defined_val
      }

  *Sample equivalent C code*

      {
        /* User-defined code (enclosing scope) */
        int a = 3, b = 6;
        bool keepgoing = true; // Analogous to input cond
        /* End user-defined code */

        /* Implicitly-defined code */
        const int max_trip_count = 10; // Analogous to input M
        int user_defined_vals[]; // Imagine this is resizable
        /* End implicitly-defined code */
        /* initialize loop-carried variables and scan-output variables */
        bool keepgoing_out = keepgoing
        int b_out = b

        for (int i=0; i < max_trip_count && keepgoing_out; ++i) {
          /* Implicitly-defined code: bind actual parameter values
             to formal parameter variables of loop-body */
          bool keepgoing_in = keepgoing_out;
          bool b_in = b_out;

          /* User-defined code (loop body) */
          int my_local = a + b_in; // Reading value "a" from the enclosing scope is fine
          b_out = a - b_in;
          keepgoing_out = my_local > b_out;
          user_defined_val = b_in + b_in; // b_in and b_out are different variables
          /* End user-defined code */

          /* Implicitly defined-code */
          user_defined_vals[i] = user_defined_val // accumulate scan-output values
        }
        // int t = my_local; // Can't do this. my_local is not accessible here.

        // The values below are bound to the output variables of the loop and therefore accessible
        // b_out; user_defined_vals; keepgoing_out;
      }

  There are several things of note in this code snippet:

  1) Values from the enclosing scope (i.e. variable "a" here) are in scope and can
     be referenced in the inputs of the loop.
  2) Any values computed in the loop body that needs to be used in a subsequent
     iteration or after the loop are modelled using a pair of variables in the loop-body,
     consisting of an input variable (eg., b_in) and an output variable (eg., b_out).
     These are referred to as loop-carried dependences. The loop operation node
     supplies the input value of the input variable for the first iteration, and
     returns the output value of the output variable produced by the final
     iteration.
  3) Scan_output variables are used to implicitly concatenate values computed across
     all the iterations. In the above example, the value of user_defined_val computed
     over all iterations are concatenated and returned as the value of user_defined_vals
     after the loop.
  4) Values created in the body cannot be accessed in the enclosing scope,
     except using the mechanism described above.

  Note that the semantics of this op support "diagonal" or "wavefront" execution.
  (See Step 3 here for an example:
  https://devblogs.nvidia.com/optimizing-recurrent-neural-networks-cudnn-5/).
  Frontends should emit multi-layer RNNs as a series of While operators (with
  time being the inner looping dimension), with each successive layer consuming
  the scan_outputs from the previous layer, possibly going through several
  point-wise operators (e.g. dropout, residual connections, linear layer).

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>body</tt> : graph (required)</dt>
<dd>The graph run each iteration. It has 2+N inputs: (iteration_num, condition, loop carried dependencies...). It has 1+N+K outputs: (condition, loop carried dependencies..., scan_outputs...). Each scan_output is created by concatenating the value of the specified output value at the end of each iteration of the loop. It is an error if the dimensions or data type of these scan_outputs change across loop iterations.</dd>
</dl>

#### Inputs (2 - &#8734;)

<dl>
<dt><tt>M</tt> (optional) : I</dt>
<dd>A maximum trip-count for the loop specified at runtime. Optional. Pass empty string to skip.</dd>
<dt><tt>cond</tt> (optional) : B</dt>
<dd>A boolean termination condition. Optional. Pass empty string to skip.</dd>
<dt><tt>v_initial</tt> (variadic, heterogeneous) : V</dt>
<dd>The initial values of any loop-carried dependencies (values that change across loop iterations)</dd>
</dl>

#### Outputs (1 - &#8734;)

<dl>
<dt><tt>v_final_and_scan_outputs</tt> (variadic, heterogeneous) : V</dt>
<dd>Final N loop carried dependency values then K scan_outputs</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>V</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>All Tensor types</dd>
<dt><tt>I</tt> : tensor(int64)</dt>
<dd>tensor of int64, which should be a scalar.</dd>
<dt><tt>B</tt> : tensor(bool)</dt>
<dd>tensor of bool, which should be a scalar.</dd>
</dl>

### <a name="LpPool-11"></a>**LpPool-11**</a>

  LpPool consumes an input tensor X and applies Lp pooling across
   the tensor according to kernel sizes, stride sizes, and pad lengths.
   Lp pooling consisting of computing the Lp norm on all values of a subset
   of the input tensor according to the kernel size and downsampling the
   data into the output tensor Y for further processing.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>auto_pad</tt> : string (default is NOTSET)</dt>
<dd>auto_pad must be either NOTSET, SAME_UPPER, SAME_LOWER or VALID. Where default value is NOTSET, which means explicit padding is used. SAME_UPPER or SAME_LOWER mean pad the input so that `output_shape[i] = ceil(input_shape[i] / strides[i])` for each axis `i`. The padding is split between the two sides equally or almost equally (depending on whether it is even or odd). In case the padding is an odd number, the extra padding is added at the end for SAME_UPPER and at the beginning for SAME_LOWER.</dd>
<dt><tt>kernel_shape</tt> : list of ints (required)</dt>
<dd>The size of the kernel along each axis.</dd>
<dt><tt>p</tt> : int (default is 2)</dt>
<dd>p value of the Lp norm used to pool over the input data.</dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd>Padding for the beginning and ending along each spatial axis, it can take any value greater than or equal to 0. The value represent the number of pixels added to the beginning and end part of the corresponding axis. `pads` format should be as follow [x1_begin, x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels added at the beginning of axis `i` and xi_end, the number of pixels added at the end of axis `i`. This attribute cannot be used simultaneously with auto_pad attribute. If not present, the padding defaults to 0 along start and end of each spatial axis.</dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd>Stride along each spatial axis. If not present, the stride defaults to 1 along each spatial axis.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input data tensor from the previous operator; dimensions for image case are (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data. For non image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output data tensor from Lp pooling across the input tensor. Dimensions will vary based on various kernel, stride, and pad sizes.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="MaxPool-11"></a>**MaxPool-11**</a>

  MaxPool consumes an input tensor X and applies max pooling across
   the tensor according to kernel sizes, stride sizes, and pad lengths.
   max pooling consisting of computing the max on all values of a
   subset of the input tensor according to the kernel size and downsampling the
   data into the output tensor Y for further processing. The output spatial shape will be following:
   ```
   output_spatial_shape[i] = floor((input_spatial_shape[i] + pad_shape[i] - ((kernel_spatial_shape[i] - 1) * dilations[i] + 1)) / strides_spatial_shape[i] + 1)
   ```
   or
   ```
   output_spatial_shape[i] = ceil((input_spatial_shape[i] + pad_shape[i] - ((kernel_spatial_shape[i] - 1) * dilations[i] + 1)) / strides_spatial_shape[i] + 1)
   ```
   if ceil_mode is enabled

   ```
   * pad_shape[i] is sum of pads along axis i
   ```

   `auto_pad` is a DEPRECATED attribute. If you are using them currently, the output spatial shape will be following:
   ```
   VALID: output_spatial_shape[i] = ceil((input_spatial_shape[i] - ((kernel_spatial_shape[i] - 1) * dilations[i] + 1) + 1) / strides_spatial_shape[i])
   SAME_UPPER or SAME_LOWER: output_spatial_shape[i] = ceil(input_spatial_shape[i] / strides_spatial_shape[i])
   ```
   And pad shape will be following if `SAME_UPPER` or `SAME_LOWER`:
   ```
   pad_shape[i] = (output_spatial_shape[i] - 1) * strides_spatial_shape[i] + ((kernel_spatial_shape[i] - 1) * dilations[i] + 1) - input_spatial_shape[i]
   ```
   The output of each pooling window is maximum number of elements exclude pad.


#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>auto_pad</tt> : string (default is NOTSET)</dt>
<dd>auto_pad must be either NOTSET, SAME_UPPER, SAME_LOWER or VALID. Where default value is NOTSET, which means explicit padding is used. SAME_UPPER or SAME_LOWER mean pad the input so that the output spatial size match the input.In case of odd number add the extra padding at the end for SAME_UPPER and at the beginning for SAME_LOWER. VALID mean no padding.</dd>
<dt><tt>ceil_mode</tt> : int (default is 0)</dt>
<dd>Whether to use ceil or floor (default) to compute the output shape.</dd>
<dt><tt>dilations</tt> : list of ints</dt>
<dd>Dilation value along each spatial axis of filter. If not present, the dilation defaults to 1 along each spatial axis.</dd>
<dt><tt>kernel_shape</tt> : list of ints (required)</dt>
<dd>The size of the kernel along each axis.</dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd>Padding for the beginning and ending along each spatial axis, it can take any value greater than or equal to 0. The value represent the number of pixels added to the beginning and end part of the corresponding axis. `pads` format should be as follow [x1_begin, x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels added at the beginning of axis `i` and xi_end, the number of pixels added at the end of axis `i`. This attribute cannot be used simultaneously with auto_pad attribute. If not present, the padding defaults to 0 along start and end of each spatial axis.</dd>
<dt><tt>storage_order</tt> : int (default is 0)</dt>
<dd>The storage order of the tensor. 0 is row major, and 1 is column major.</dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd>Stride along each spatial axis. If not present, the stride defaults to 1 along each spatial axis.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input data tensor from the previous operator; dimensions for image case are (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data. For non image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size. Optionally, if dimension denotation is in effect, the operation expects the input data tensor to arrive with the dimension denotation of [DATA_BATCH, DATA_CHANNEL, DATA_FEATURE, DATA_FEATURE ...].</dd>
</dl>

#### Outputs (1 - 2)

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output data tensor from average or max pooling across the input tensor. Dimensions will vary based on various kernel, stride, and pad sizes. Floor value of the dimension is used</dd>
<dt><tt>Indices</tt> (optional) : I</dt>
<dd>Indices tensor from max pooling across the input tensor. The dimensions of indices are the same as output tensor. The values in indices of are the indices of the selected values during pooling. The indices are computed as flatten 1-D tensor, and the indices do not consider padding. So the values in indices are in [0, N x C x D1 x ... x Dn).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>I</tt> : tensor(int64)</dt>
<dd>Constrain index tensor to int64</dd>
</dl>

### <a name="MaxUnpool-11"></a>**MaxUnpool-11**</a>

  MaxUnpool essentially computes the partial inverse of the MaxPool op.
   The input information to this op is typically the the output information from a MaxPool op. The first
   input tensor X is the tensor that needs to be unpooled, which is typically the pooled tensor (first output)
   from MaxPool. The second input tensor, I, contains the indices to the (locally maximal) elements corrsponding
   to the elements in the first input tensor X. Input tensor I is typically the second output of the MaxPool op.
   The third (optional) input is a tensor that specifies the output size of the unpooling operation.

  MaxUnpool is intended to do 'partial' inverse of the MaxPool op. 'Partial' because all the non-maximal
   values from the original input to MaxPool are set to zero in the output of the MaxUnpool op. Pooling
   the result of an unpooling operation should give back the original input to the unpooling op.

  MaxUnpool can produce the same output size for several input sizes, which makes unpooling op ambiguous.
   The third input argument, output_size, is meant to disambiguate the op and produce output tensor of
   known/predictable size.

  In addition to the inputs, MaxUnpool takes three attributes, namely kernel_shape, strides, and pads,
   which define the exact unpooling op. The attributes typically have the same values as the corrsponding
   pooling op that the unpooling op is trying to invert.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>kernel_shape</tt> : list of ints (required)</dt>
<dd>The size of the kernel along each axis.</dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd>Padding for the beginning and ending along each spatial axis, it can take any value greater than or equal to 0. The value represent the number of pixels added to the beginning and end part of the corresponding axis. `pads` format should be as follow [x1_begin, x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels added at the beginning of axis `i` and xi_end, the number of pixels added at the end of axis `i`. This attribute cannot be used simultaneously with auto_pad attribute. If not present, the padding defaults to 0 along start and end of each spatial axis.</dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd>Stride along each spatial axis. If not present, the stride defaults to 1 along each spatial axis.</dd>
</dl>

#### Inputs (2 - 3)

<dl>
<dt><tt>X</tt> (differentiable) : T1</dt>
<dd>Input data tensor that has to be unpooled. This tensor is typically the first output of the MaxPool op.Dimensions for image case are (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data. For non-image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size. Optionally, if dimension denotation is in effect, the operation expects the input data tensor to arrive with the dimension denotation of [DATA_BATCH, DATA_CHANNEL, DATA_FEATURE, DATA_FEATURE ...].</dd>
<dt><tt>I</tt> (non-differentiable) : T2</dt>
<dd>Input data tensor containing the indices corresponding to elements in the first input tensor X.This tensor is typically the second output of the MaxPool op.Dimensions must be the same as input tensor X. The indices are linear, i.e. computed considering the tensor as flattened 1-D tensor, assuming row-major storage. Also, the linear indices should not consider padding. So the values in indices are in the range [0, N x C x D1 x ... x Dn).</dd>
<dt><tt>output_shape</tt> (optional, non-differentiable) : T2</dt>
<dd>The shape of the output can be explicitly set which will cause pads values to be auto generated. If 'output_shape' is specified, 'pads' values are ignored.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T1</dt>
<dd>Output data tensor that contains the result of the unpooling.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T2</tt> : tensor(int64)</dt>
<dd>Constrain index tensor to int64</dd>
</dl>

### <a name="NonMaxSuppression-11"></a>**NonMaxSuppression-11**</a>

  Filter out boxes that have high intersection-over-union (IOU) overlap with previously selected boxes.
  Bounding boxes with score less than score_threshold are removed. Bounding box format is indicated by attribute center_point_box.
  Note that this algorithm is agnostic to where the origin is in the coordinate system and more generally is invariant to
  orthogonal transformations and translations of the coordinate system; thus translating or reflections of the coordinate system
  result in the same boxes being selected by the algorithm.
  The selected_indices output is a set of integers indexing into the input collection of bounding boxes representing the selected boxes.
  The bounding box coordinates corresponding to the selected indices can then be obtained using the Gather or GatherND operation.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>center_point_box</tt> : int (default is 0)</dt>
<dd>Integer indicate the format of the box data. The default is 0. 0 - the box data is supplied as [y1, x1, y2, x2] where (y1, x1) and (y2, x2) are the coordinates of any diagonal pair of box corners and the coordinates can be provided as normalized (i.e., lying in the interval [0, 1]) or absolute. Mostly used for TF models. 1 - the box data is supplied as [x_center, y_center, width, height]. Mostly used for Pytorch models.</dd>
</dl>

#### Inputs (2 - 5)

<dl>
<dt><tt>boxes</tt> : tensor(float)</dt>
<dd>An input tensor with shape [num_batches, spatial_dimension, 4]. The single box data format is indicated by center_point_box.</dd>
<dt><tt>scores</tt> : tensor(float)</dt>
<dd>An input tensor with shape [num_batches, num_classes, spatial_dimension]</dd>
<dt><tt>max_output_boxes_per_class</tt> (optional) : tensor(int64)</dt>
<dd>Integer representing the maximum number of boxes to be selected per batch per class. It is a scalar. Default to 0, which means no output.</dd>
<dt><tt>iou_threshold</tt> (optional) : tensor(float)</dt>
<dd>Float representing the threshold for deciding whether boxes overlap too much with respect to IOU. It is scalar. Value range [0, 1]. Default to 0.</dd>
<dt><tt>score_threshold</tt> (optional) : tensor(float)</dt>
<dd>Float representing the threshold for deciding when to remove boxes based on score. It is a scalar.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>selected_indices</tt> : tensor(int64)</dt>
<dd>selected indices from the boxes tensor. [num_selected_indices, 3], the selected index format is [batch_index, class_index, box_index].</dd>
</dl>

#### Type Constraints


### <a name="OneHot-11"></a>**OneHot-11**</a>

  Produces a one-hot tensor based on inputs.
      The locations represented by the index values in the 'indices' input tensor will have 'on_value'
      and the other locations will have 'off_value' in the output tensor, where 'on_value' and 'off_value'
      are specified as part of required input argument 'values', which is a two-element tensor of format
      [off_value, on_value]. The rank of the output tensor will be one greater than the rank of the
      input tensor. The additional dimension is for one-hot representation. The additional dimension will
      be inserted at the position specified by 'axis'. If 'axis' is not specified then then additional
      dimension will be inserted as the innermost dimension, i.e. axis=-1. The size of the additional
      dimension is specified by required scalar input 'depth'. The type of the output tensor is the same
      as the type of the 'values' input. Any entries in the 'indices' input tensor with values outside
      the range [-depth, depth-1] will result in one-hot representation with all 'off_value' values in the
      output tensor.

      when axis = 0:
      output[input[i, j, k], i, j, k] = 1 for all i, j, k and 0 otherwise.

      when axis = -1:
      output[i, j, k, input[i, j, k]] = 1 for all i, j, k and 0 otherwise.


#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is -1)</dt>
<dd>(Optional) Axis along which one-hot representation in added. Default: axis=-1. axis=-1 means that the additional dimension will be inserted as the innermost/last dimension in the output tensor. Negative value means counting dimensions from the back. Accepted range is [-r-1, r] where r = rank(indices).</dd>
</dl>

#### Inputs

<dl>
<dt><tt>indices</tt> (non-differentiable) : T1</dt>
<dd>Input tensor containing indices. Any entries in the 'indices' input tensor with values outside the range [-depth, depth-1] will result in one-hot representation with all 'off_value' values in the output tensor.In case 'indices' is of non-integer type, the values will be casted to int64 before use.</dd>
<dt><tt>depth</tt> (non-differentiable) : T2</dt>
<dd>Scalar specifying the number of classes in one-hot tensor. This is also the size of the one-hot dimension (specified by 'axis' attribute) added on in the output tensor. The values in the 'indices' input tensor are expected to be in the range [-depth, depth-1]. In case 'depth' is of non-integer type, it will be casted to int64 before use.</dd>
<dt><tt>values</tt> (non-differentiable) : T3</dt>
<dd>Rank 1 tensor containing exactly two elements, in the format [off_value, on_value], where 'on_value' is the value used for filling locations specified in 'indices' input tensor, and 'off_value' is the value used for filling locations other than those specified in 'indices' input tensor. </dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (non-differentiable) : T3</dt>
<dd>Tensor of rank one greater than input tensor 'indices', i.e. rank(output) = rank(indices) + 1. The data type for the elements of the output tensor is the same as the type of input 'values' is used.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input to only numeric types.</dd>
<dt><tt>T2</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input to only numeric types.</dd>
<dt><tt>T3</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain to any tensor type.</dd>
</dl>

### <a name="Pad-11"></a>**Pad-11**</a>

  Given a tensor containing the data to be padded (`data`), a tensor containing the number of start and end pad values for axis (`pads`), (optionally) a `mode`, and (optionally) `constant_value`,
  a padded tensor (`output`) is generated.

  The three supported `modes` are (similar to corresponding modes supported by `numpy.pad`):

  1) `constant`(default) - pads with a given constant value as specified by `constant_value` (which defaults to 0)

  2) `reflect` - pads with the reflection of the vector mirrored on the first and last values of the vector along each axis

  3) `edge` - pads with the edge values of array


  Example 1 (`constant` mode):
    Insert 0 pads to the beginning of the second dimension.

    data =
    [
        [1.0, 1.2],
        [2.3, 3.4],
        [4.5, 5.7],
    ]

    pads = [0, 2, 0, 0]

    mode = 'constant'

    constant_value = 0.0

    output =
    [
        [0.0, 0.0, 1.0, 1.2],
        [0.0, 0.0, 2.3, 3.4],
        [0.0, 0.0, 4.5, 5.7],
    ]


  Example 2 (`reflect` mode):
    data =
    [
        [1.0, 1.2],
        [2.3, 3.4],
        [4.5, 5.7],
    ]

    pads = [0, 2, 0, 0]

    mode = 'reflect'

    output =
    [
        [1.0, 1.2, 1.0, 1.2],
        [2.3, 3.4, 2.3, 3.4],
        [4.5, 5.7, 4.5, 5.7],
    ]


  Example 3 (`edge` mode):
    data =
    [
        [1.0, 1.2],
        [2.3, 3.4],
        [4.5, 5.7],
    ]

    pads = [0, 2, 0, 0]

    mode = 'edge'

    output =
    [
        [1.0, 1.0, 1.0, 1.2],
        [2.3, 2.3, 2.3, 3.4],
        [4.5, 4.5, 4.5, 5.7],
    ]


#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>mode</tt> : string (default is constant)</dt>
<dd>Supported modes: `constant`(default), `reflect`, `edge`</dd>
</dl>

#### Inputs (2 - 3)

<dl>
<dt><tt>data</tt> : T</dt>
<dd>Input tensor.</dd>
<dt><tt>pads</tt> : tensor(int64)</dt>
<dd>Tensor of integers indicating the number of padding elements to add or remove (if negative) at the beginning and end of each axis. For 2D input tensor, it is the number of pixels. `pads` should be a 1D tensor of shape [2 * input_rank]. `pads` format should be: [x1_begin, x2_begin,...,x1_end, x2_end,...], where xi_begin is the number of pad values added at the beginning of axis `i` and xi_end, the number of pad values added at the end of axis `i`.</dd>
<dt><tt>constant_value</tt> (optional) : T</dt>
<dd>(Optional) A scalar value to be used if the mode chosen is `constant` (by default it is 0).</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Tensor after padding.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output to only numeric types.</dd>
</dl>

### <a name="Range-11"></a>**Range-11**</a>

  Generate a tensor containing a sequence of numbers that begin at `start` and extends by increments of `delta`
  up to `limit` (exclusive).

  The number of elements in the output of range is computed as below-

  `number_of_elements = max( ceil( (limit - start) / delta ) , 0 )`

  The pseudocode determining the contents of the output is shown below-

  `for(int i=0; i<number_of_elements; ++i)`

  `{`

  `    output[i] =  start + (i * delta);  `

  `}`

  `Example 1`
  Inputs: start = 3, limit = 9, delta = 3
  Output: [3, 6]

  `Example 2`
  Inputs: start = 10, limit = 4, delta = -2
  Output: [10, 8, 6]


#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>start</tt> : T</dt>
<dd>Scalar. First entry for the range of output values.</dd>
<dt><tt>limit</tt> : T</dt>
<dd>Scalar. Exclusive upper limit for the range of output values.</dd>
<dt><tt>delta</tt> : T</dt>
<dd>Scalar. Value to step by.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>A 1-D tensor with same type as the inputs containing generated range of values.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(double), tensor(int16), tensor(int32), tensor(int64)</dt>
<dd>Constrain input types to common numeric type tensors.</dd>
</dl>

### <a name="ReduceL1-11"></a>**ReduceL1-11**</a>

  Computes the L1 norm of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
  the resulted tensor have the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="ReduceL2-11"></a>**ReduceL2-11**</a>

  Computes the L2 norm of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
  the resulted tensor have the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="ReduceLogSum-11"></a>**ReduceLogSum-11**</a>

  Computes the log sum of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
  the resulted tensor have the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="ReduceLogSumExp-11"></a>**ReduceLogSumExp-11**</a>

  Computes the log sum exponent of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
  the resulted tensor have the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="ReduceMax-11"></a>**ReduceMax-11**</a>

  Computes the max of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
  the resulted tensor have the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="ReduceMean-11"></a>**ReduceMean-11**</a>

  Computes the mean of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
  the resulted tensor have the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="ReduceMin-11"></a>**ReduceMin-11**</a>

  Computes the min of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
  the resulted tensor have the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="ReduceProd-11"></a>**ReduceProd-11**</a>

  Computes the product of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
  the resulted tensor have the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="ReduceSum-11"></a>**ReduceSum-11**</a>

  Computes the sum of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
  the resulted tensor have the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="ReduceSumSquare-11"></a>**ReduceSumSquare-11**</a>

  Computes the sum square of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
  the resulted tensor have the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="Resize-11"></a>**Resize-11**</a>

  Resize the input tensor. In general, it calculates every value in the output tensor as a weighted average of neighborhood (a.k.a. sampling locations) in the input tensor.
  Each dimension value of the output tensor is:
    output_dimension = floor(input_dimension * (roi_end - roi_start) * scale) if input \"sizes\" is not specified.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>coordinate_transformation_mode</tt> : string (default is half_pixel)</dt>
<dd>
This attribute describes how to transform the coordinate in the resized tensor to the coordinate in the original tensor. <br/>

The coordinate of each dimension is transformed individually. Let's describe a case using axis x as an example.
Denote x_resized as the coordinate of axis x in the resized tensor, x_original as the coordinate of axis x in the original tensor, length_original as the length of the original tensor in axis x, length_resized as the length of the resized tensor in axis x, roi_x = (start_x, end_x) of the axis x in input "roi", scale = length_resized / length_original, <br/>

if coordinate_transformation_mode is "half_pixel", <br/>
x_original = (x_resized + 0.5) / scale - 0.5, <br/>

if coordinate_transformation_mode is "pytorch_half_pixel", <br/>
x_original = length_resized > 1 ? (x_resized + 0.5) / scale - 0.5 : 0, <br/>

if coordinate_transformation_mode is "align_corners", <br/>
x_original = x_resized * (length_original - 1) / (length_resized - 1), <br/>

if coordinate_transformation_mode is "asymmetric", <br/>
x_original = x_resized / scale, <br/>

if coordinate_transformation_mode is "tf_half_pixel_for_nn", <br/>
x_original = (x_resized + 0.5) / scale, <br/>

if coordinate_transformation_mode is "tf_crop_and_resize", <br/>
x_original = length_resized > 1 ? start_x * (length_original - 1) + x_resized * (end_x - start_x) * (length_original - 1) / (length_resized - 1) : 0.5 * (start_x + end_x) * (length_original - 1).</dd>
<dt><tt>cubic_coeff_a</tt> : float (default is -0.75)</dt>
<dd>The coefficient 'a' used in cubic interpolation. Two common choice are -0.5 (in some cases of TensorFlow) and -0.75 (in PyTorch). Check out Equation (4) in https://ieeexplore.ieee.org/document/1163711 for the details. This attribute is valid only if "mode" is "cubic".</dd>
<dt><tt>exclude_outside</tt> : int (default is 0)</dt>
<dd>If set to 1, the weight of sampling locations outside the tensor will be set to 0 and the weight will be renormalized so that their sum is 1.0. The default value is 0.</dd>
<dt><tt>extrapolation_value</tt> : float (default is 0.0)</dt>
<dd>When coordinate_transformation_mode is "tf_crop_and_resize" and x_original is outside the range [0, length_original - 1], this value is used as the corresponding output value. Default is 0.0f.</dd>
<dt><tt>mode</tt> : string (default is nearest)</dt>
<dd>Three interpolation modes: nearest (default), linear and cubic. The "linear" mode includes linear interpolation for 1D tensor and N-linear interpolation for N-D tensor (for example, bilinear interpolation for 2D tensor). The "cubic" mode includes cubic interpolation for 1D tensor and N-cubic interpolation for N-D tensor (for example, bicubic interpolation for 2D tensor).</dd>
<dt><tt>nearest_mode</tt> : string (default is round_prefer_floor)</dt>
<dd>Four modes: round_prefer_floor (default, as known as round half down), round_prefer_ceil (as known as round half up), floor, ceil. Only used by nearest interpolation. It indicates how to get "nearest" pixel in input tensor from x_original, so this attribute is valid only if "mode" is "nearest".</dd>
</dl>

#### Inputs (3 - 4)

<dl>
<dt><tt>X</tt> : T1</dt>
<dd>N-D tensor</dd>
<dt><tt>roi</tt> : T2</dt>
<dd>1-D tensor given as [start1, ..., startN, end1, ..., endN], where N is the rank of X. The RoIs' coordinates are normalized in the coordinate system of the input image. It only takes effect when coordinate_transformation_mode is "tf_crop_and_resize"</dd>
<dt><tt>scales</tt> : tensor(float)</dt>
<dd>The scale array along each dimension. It takes value greater than 0. If it's less than 1, it's sampling down, otherwise, it's upsampling. The number of elements of 'scales' should be the same as the rank of input 'X'. If 'size' is needed, the user must set 'scales' to an empty tensor.</dd>
<dt><tt>sizes</tt> (optional) : tensor(int64)</dt>
<dd>The size of the output tensor. The number of elements of 'sizes' should be the same as the rank of input 'X'. May only be set if 'scales' is set to an empty tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T1</dt>
<dd>N-D tensor after resizing</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input 'X' and output 'Y' to all tensor types.</dd>
<dt><tt>T2</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain roi type to float or double.</dd>
</dl>

### <a name="Round-11"></a>**Round-11**</a>

  Round takes one input Tensor and rounds the values, element-wise, meaning
  it finds the nearest integer for each value.
  In case of halfs, the rule is to round them to the nearest even integer.
  The output tensor has the same shape and type as the input.

  Examples:
  ```
  round([0.9]) = [1.0]
  round([2.5]) = [2.0]
  round([2.3]) = [2.0]
  round([1.5]) = [2.0]
  round([-4.5]) = [-4.0]
  ```

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> (non-differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (non-differentiable) : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Scan-11"></a>**Scan-11**</a>

  Scan can be used to iterate over one or more scan_input tensors,
  constructing zero or more scan_output tensors. It combines ideas from general recurrences,
  functional programming constructs such as scan, fold, map, and zip, and is intended to enable
  generalizations of RNN-like constructs for sequence-to-sequence processing.
  Other tensors (referred to as state_variables here) can be used to carry a state
  when iterating from one element to another (similar to hidden-state in RNNs, also referred
  to as loop-carried dependences in the context of loops).
  Many common usages involve a single scan_input tensor (where functionality
  similar to scan, fold and map can be obtained). When more than one scan_input is used,
  a behavior similar to zip is obtained.

  The attribute body must be a graph, specifying the computation to be performed in
  every iteration. It takes as input the current values of the state_variables and
  the current iterated element of the scan_inputs. It must return the (updated) values
  of the state_variables and zero or more scan_output_element tensors. The values of the
  scan_output_element tensors are concatenated over all the iterations to produce the
  scan_output values of the scan construct (similar to the concatenated intermediate
  hidden-state values of RNN-like constructs). All the output tensors (state_variables as
  well as scan_output_element tensors) are required to have the same shape in each iteration
  of the loop (a restriction imposed to enable efficient memory allocation).

  Note that the iterated element passed to the body subgraph does not have a sequence
  axis. It will have a rank one less than the rank of the corresponding scan_input.

  The scan operation returns the final values of the state_variables as well as the
  scan_outputs.

  The optional attribute scan_input_directions specifies the direction (forward or backward)
  for each scan input. If this attribute is omitted, all sequences are scanned in the forward
  direction. A bidirectional scan may be performed by specifying the same tensor input twice
  in the scan_inputs, once with a forward direction, and once with a backward direction.

  The scan_output of the operation is produced by concatenating the scan_output_element
  values produced by the body in each iteration.  The optional attribute scan_output_directions
  specifies the direction in which scan_output is constructed (by appending or prepending the
  scan_output_element to scan_output in each iteration) for each scan_output. If this attribute
  is omitted, the scan_output_element is appended to the scan_output in each iteration.

  The optional attribute scan_input_axes specifies the axis to be scanned for each scan_input.
  If omitted, every scan_input will be scanned in axis 0. For example, if axis 0 is the
  batch axis and axis 1 is the time axis (to be scanned), specify an axis value of 1.
  Note that scanning a non-zero axis may be less efficient than scanning axis zero.

  The optional attribute scan_output_axes specifies the axis along which the scan_outputs
  are accumulated for each scan_output. For example, if axis 1 is the time axis (to be
  scanned) for both inputs and outputs, specify a scan_input axis and scan_output axis
  value of 1.

  Note that because of the ONNX restriction that only the last parameter of an operator can
  be variadic, the initial-states and scan-inputs are listed together as one input parameter.
  Similarly, the final-states and scan-outputs are listed together as one output parameter.
  The attribute num_scan_inputs indicates the number M of scan-inputs.

  The behavior of

      Scan <
          num_scan_inputs = m,
          body = loop-body,
          scan_input_axes = [axis_1, ..., axis_m]
      > (init_1, ..., init_n, scan_1, ..., scan_m)

  is equivalent to the following pseudo-code:

      // scan_i.shape[axis_i] denotes the (max) sequence-length of scan_i
      // scan_i.shape[axis_i] is required to be equal to scan_j.shape[axis_j] for all i,j.
      sequence_length = scan_1.shape[axis_1];

      // initialize state-variables
      st_1 = init_1; ... st_n = init_n;
      // initialize scan-output variables: [] denotes an empty tensor
      scan_out_1 = []; ...; scan_out_k = [];
      // identify number of iterations:

      // execute loop
      for (int t = 0; t < sequence_length; ++t) {
          // generate the scan-input elements: the notation T<axis=k>[t] indicates the sub-tensor
          // of rank one less than T obtained by indexing T at position t along axis k.
          si_1 = scan_1<axis=axis_1>[t];
          ... ;
          si_m = scan_m<axis=axis_m>[t];
          // execute loop-body
          st_1, ..., st_n, so_1, ..., so_k = loop-body(st_1, ..., st_n, si_1, ..., si_m)
          // accumulate the scan-output elements
          scan_out_1 = Concat<axis=0>(scan_out_1, so_1); ... ; scan_out_k = Concat<axis=0>(scan_out_k, so_k);
      }

      return st_1, ..., st_n, scan_out_1, ..., scan_out_k;

  *Sample usage: Encoding RNN using a Scan*

  The following example shows how a simple RNN over an input tensor %X, with weight tensor %Wi,
  recurrence weight tensor %Ri, bias tensors %Wbi and %Rbi, and initial hidden-state %H_0 can
  be encoded as a ScanLoop. Note that the loop-body is a nested graph, and it directly computes
  %Wi, %Ri, %Wbi, and %Rbi (typically constants or initializers in the body graph). If these
  values are computed in the outer graph, they need to be passed in as extra state_variables.

      graph rnn-encoding {
        %H_0 = ...
        %X = ...
        %Y_h, %Y = Scan[body = <graph rnn-cell-1>, num_scan_inputs=1](%H_0, %X)
        return %Y, %Y_h
      }

      graph rnn-cell-1 (
        %H_tminus1[FLOAT, tensor]
        %X_t[FLOAT, tensor]
      ) {
        %Wi = ...
        %Ri = ...
        %Wbi = ...
        %Rbi = ...
        %t1 = X_t * (Wi^T)
        %t2 = H_tminus1*(Ri^T)
        %t3 = Add(%t1, %t2)
        %t4 = Add(%t3, %Wbi)
        %t5 = Add(%t4, %Rbi)
        %Ht = Tanh(%t5)
        %Accumulate = Identity(%Ht)
        return %Ht, %Accumulate
      }


#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>body</tt> : graph (required)</dt>
<dd>The graph run each iteration. It has N+M inputs: (loop state variables..., scan_input_elts...). It has N+K outputs: (loop state variables..., scan_output_elts...). Each scan_output is created by concatenating the value of the specified scan_output_elt value at the end of each iteration of the loop. It is an error if the dimensions of these values change across loop iterations.</dd>
<dt><tt>num_scan_inputs</tt> : int (required)</dt>
<dd>An attribute specifying the number of scan_inputs M. </dd>
<dt><tt>scan_input_axes</tt> : list of ints</dt>
<dd>An optional list of M flags. The i-th element of the list specifies the axis to be scanned (the sequence axis) for the i-th scan_input. If omitted, 0 will be used as the scan axis for every scan_input. Negative value for an axis means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(input).</dd>
<dt><tt>scan_input_directions</tt> : list of ints</dt>
<dd>An optional list of M flags. The i-th element of the list specifies the direction to be scanned for the i-th scan_input tensor: 0 indicates forward direction and 1 indicates reverse direction. If omitted, all scan_input tensors will be scanned in the forward direction.</dd>
<dt><tt>scan_output_axes</tt> : list of ints</dt>
<dd>An optional list of K flags. The i-th element of the list specifies the axis for the i-th scan_output. The scan outputs are accumulated along the specified axis. If omitted, 0 will be used as the scan axis for every scan_output. Negative value for an axis means counting dimensions from the back. Accepted range is [-r, r-1].</dd>
<dt><tt>scan_output_directions</tt> : list of ints</dt>
<dd>An optional list of K flags, one for each scan_output. The i-th element of the list specifies whether the i-th scan_output should be constructed by appending or prepending a new value in each iteration: 0 indicates appending and 1 indicates prepending. If omitted, all scan_output tensors will be produced by appending a value in each iteration.</dd>
</dl>

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>initial_state_and_scan_inputs</tt> (variadic, heterogeneous) : V</dt>
<dd>Initial values of the loop's N state variables followed by M scan_inputs</dd>
</dl>

#### Outputs (1 - &#8734;)

<dl>
<dt><tt>final_state_and_scan_outputs</tt> (variadic, heterogeneous) : V</dt>
<dd>Final values of the loop's N state variables followed by K scan_outputs</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>V</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>All Tensor types</dd>
</dl>

### <a name="Scatter-11"></a>**Scatter-11** (deprecated)</a>

  This operator is deprecated. Please use ScatterElements, which provides the same functionality.

  Scatter takes three inputs `data`, `updates`, and `indices` of the same
  rank r >= 1 and an optional attribute axis that identifies an axis of `data`
  (by default, the outer-most axis, that is axis 0). The output of the operation
  is produced by creating a copy of the input `data`, and then updating its value
  to values specified by `updates` at specific index positions specified by
  `indices`. Its output shape is the same as the shape of `data`.

  For each entry in `updates`, the target index in `data` is obtained by combining
  the corresponding entry in `indices` with the index of the entry itself: the
  index-value for dimension = axis is obtained from the value of the corresponding
  entry in `indices` and the index-value for dimension != axis is obtained from the
  index of the entry itself.

  For instance, in a 2-D tensor case, the update corresponding to the [i][j] entry
  is performed as below:
  ```
    output[indices[i][j]][j] = updates[i][j] if axis = 0,
    output[i][indices[i][j]] = updates[i][j] if axis = 1,
  ```

  This operator is the inverse of GatherElements. It is similar to Torch's Scatter operation.

  Example 1:
  ```
    data = [
        [0.0, 0.0, 0.0],
        [0.0, 0.0, 0.0],
        [0.0, 0.0, 0.0],
    ]
    indices = [
        [1, 0, 2],
        [0, 2, 1],
    ]
    updates = [
        [1.0, 1.1, 1.2],
        [2.0, 2.1, 2.2],
    ]
    output = [
        [2.0, 1.1, 0.0]
        [1.0, 0.0, 2.2]
        [0.0, 2.1, 1.2]
    ]
  ```
  Example 2:
  ```
    data = [[1.0, 2.0, 3.0, 4.0, 5.0]]
    indices = [[1, 3]]
    updates = [[1.1, 2.1]]
    axis = 1
    output = [[1.0, 1.1, 3.0, 2.1, 5.0]]
  ```

#### Version

This version of the operator has been deprecated since version 11 of the default ONNX operator set.

### <a name="ScatterElements-11"></a>**ScatterElements-11**</a>

  ScatterElements takes three inputs `data`, `updates`, and `indices` of the same
  rank r >= 1 and an optional attribute axis that identifies an axis of `data`
  (by default, the outer-most axis, that is axis 0). The output of the operation
  is produced by creating a copy of the input `data`, and then updating its value
  to values specified by `updates` at specific index positions specified by
  `indices`. Its output shape is the same as the shape of `data`.

  For each entry in `updates`, the target index in `data` is obtained by combining
  the corresponding entry in `indices` with the index of the entry itself: the
  index-value for dimension = axis is obtained from the value of the corresponding
  entry in `indices` and the index-value for dimension != axis is obtained from the
  index of the entry itself.

  For instance, in a 2-D tensor case, the update corresponding to the [i][j] entry
  is performed as below:
  ```
    output[indices[i][j]][j] = updates[i][j] if axis = 0,
    output[i][indices[i][j]] = updates[i][j] if axis = 1,
  ```

  This operator is the inverse of GatherElements. It is similar to Torch's Scatter operation.

  Example 1:
  ```
    data = [
        [0.0, 0.0, 0.0],
        [0.0, 0.0, 0.0],
        [0.0, 0.0, 0.0],
    ]
    indices = [
        [1, 0, 2],
        [0, 2, 1],
    ]
    updates = [
        [1.0, 1.1, 1.2],
        [2.0, 2.1, 2.2],
    ]
    output = [
        [2.0, 1.1, 0.0]
        [1.0, 0.0, 2.2]
        [0.0, 2.1, 1.2]
    ]
  ```
  Example 2:
  ```
    data = [[1.0, 2.0, 3.0, 4.0, 5.0]]
    indices = [[1, 3]]
    updates = [[1.1, 2.1]]
    axis = 1
    output = [[1.0, 1.1, 3.0, 2.1, 5.0]]
  ```

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 0)</dt>
<dd>Which axis to scatter on. Negative value means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(data).</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>Tensor of rank r >= 1.</dd>
<dt><tt>indices</tt> : Tind</dt>
<dd>Tensor of int32/int64 indices, of r >= 1 (same rank as input). All index values are expected to be within bounds [-s, s-1] along axis of size s. It is an error if any of the index values are out of bounds.</dd>
<dt><tt>updates</tt> : T</dt>
<dd>Tensor of rank r >=1 (same rank and shape as indices)</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Tensor of rank r >= 1 (same rank as input).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Input and output types can be of any tensor type.</dd>
<dt><tt>Tind</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain indices to integer types</dd>
</dl>

### <a name="ScatterND-11"></a>**ScatterND-11**</a>

  ScatterND takes three inputs `data` tensor of rank r >= 1, `indices` tensor of rank q >= 1,
  and `updates` tensor of rank q + r - indices.shape[-1] - 1. The output of the operation
  is produced by creating a copy of the input `data`, and then updating its value to values
  specified by `updates` at specific index positions specified by `indices`. Its output shape
  is the same as the shape of `data`. Note that `indices` should not have duplicate entries.
  That is, two or more `updates` for the same index-location is not supported.

  `indices` is an integer tensor. Let k denote indices.shape[-1], the last dimension in the shape of `indices`.
   `indices` is treated as a (q-1)-dimensional tensor of k-tuples, where each k-tuple is a partial-index into `data`.
  Hence, k can be a value at most the rank of `data`. When k equals rank(data), each update entry specifies an
  update to a single element of the tensor. When k is less than rank(data) each update entry specifies an
  update to a slice of the tensor.

  `updates` is treated as a (q-1)-dimensional tensor of replacement-slice-values. Thus, the
  first (q-1) dimensions of updates.shape must match the first (q-1) dimensions of indices.shape.
  The remaining dimensions of `updates` correspond to the dimensions of the
  replacement-slice-values. Each replacement-slice-value is a (r-k) dimensional tensor,
  corresponding to the trailing (r-k) dimensions of `data`.  Thus, the shape of `updates`
  must equal indices.shape[0:q-1] ++ data.shape[k:r-1], where ++ denotes the concatenation
  of shapes.

  The `output` is calculated via the following equation:

      output = np.copy(data)
      update_indices = indices.shape[:-1]
      for idx in np.ndindex(update_indices):
          output[indices[idx]] = updates[idx]

  The order of iteration in the above loop is not specified.
  In particular, indices should not have duplicate entries: that is, if idx1 != idx2, then indices[idx1] != indices[idx2].
  This ensures that the output value does not depend on the iteration order.

  This operator is the inverse of GatherND.

  Example 1:
  ```
    data    = [1, 2, 3, 4, 5, 6, 7, 8]
    indices = [[4], [3], [1], [7]]
    updates = [9, 10, 11, 12]
    output  = [1, 11, 3, 10, 9, 6, 7, 12]
  ```

  Example 2:
  ```
    data    = [[[1, 2, 3, 4], [5, 6, 7, 8], [8, 7, 6, 5], [4, 3, 2, 1]],
               [[1, 2, 3, 4], [5, 6, 7, 8], [8, 7, 6, 5], [4, 3, 2, 1]],
               [[8, 7, 6, 5], [4, 3, 2, 1], [1, 2, 3, 4], [5, 6, 7, 8]],
               [[8, 7, 6, 5], [4, 3, 2, 1], [1, 2, 3, 4], [5, 6, 7, 8]]]
    indices = [[0], [2]]
    updates = [[[5, 5, 5, 5], [6, 6, 6, 6], [7, 7, 7, 7], [8, 8, 8, 8]],
               [[1, 1, 1, 1], [2, 2, 2, 2], [3, 3, 3, 3], [4, 4, 4, 4]]]
    output  = [[[5, 5, 5, 5], [6, 6, 6, 6], [7, 7, 7, 7], [8, 8, 8, 8]],
               [[1, 2, 3, 4], [5, 6, 7, 8], [8, 7, 6, 5], [4, 3, 2, 1]],
               [[1, 1, 1, 1], [2, 2, 2, 2], [3, 3, 3, 3], [4, 4, 4, 4]],
               [[8, 7, 6, 5], [4, 3, 2, 1], [1, 2, 3, 4], [5, 6, 7, 8]]]
  ```

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>Tensor of rank r >= 1.</dd>
<dt><tt>indices</tt> : tensor(int64)</dt>
<dd>Tensor of rank q >= 1.</dd>
<dt><tt>updates</tt> : T</dt>
<dd>Tensor of rank q + r - indices_shape[-1] - 1.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Tensor of rank r >= 1.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to any tensor type.</dd>
</dl>

### <a name="SequenceAt-11"></a>**SequenceAt-11**</a>

  Outputs a tensor copy from the tensor at 'position' in 'input_sequence'.
  Accepted range for 'position' is in `[-n, n - 1]`, where `n` is the number of tensors in 'input_sequence'.
  Negative value means counting positions from the back.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input_sequence</tt> : S</dt>
<dd>Input sequence.</dd>
<dt><tt>position</tt> : I</dt>
<dd>Position of the tensor in the sequence. Negative value means counting positions from the back. Accepted range in `[-n, n - 1]`, where `n` is the number of tensors in 'input_sequence'. It is an error if any of the index values are out of bounds. It must be a scalar(tensor of empty shape).</dd>
</dl>

#### Outputs

<dl>
<dt><tt>tensor</tt> : T</dt>
<dd>Output tensor at the specified position in the input sequence.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>S</tt> : seq(tensor(uint8)), seq(tensor(uint16)), seq(tensor(uint32)), seq(tensor(uint64)), seq(tensor(int8)), seq(tensor(int16)), seq(tensor(int32)), seq(tensor(int64)), seq(tensor(float16)), seq(tensor(float)), seq(tensor(double)), seq(tensor(string)), seq(tensor(bool)), seq(tensor(complex64)), seq(tensor(complex128))</dt>
<dd>Constrain to any tensor type.</dd>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain to any tensor type.</dd>
<dt><tt>I</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain position to integral tensor. It must be a scalar(tensor of empty shape).</dd>
</dl>

### <a name="SequenceConstruct-11"></a>**SequenceConstruct-11**</a>

  Construct a tensor sequence containing 'inputs' tensors.
  All tensors in 'inputs' must have the same data type.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>inputs</tt> (variadic) : T</dt>
<dd>Tensors.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output_sequence</tt> : S</dt>
<dd>Sequence enclosing the input tensors.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input types to any tensor type.</dd>
<dt><tt>S</tt> : seq(tensor(uint8)), seq(tensor(uint16)), seq(tensor(uint32)), seq(tensor(uint64)), seq(tensor(int8)), seq(tensor(int16)), seq(tensor(int32)), seq(tensor(int64)), seq(tensor(float16)), seq(tensor(float)), seq(tensor(double)), seq(tensor(string)), seq(tensor(bool)), seq(tensor(complex64)), seq(tensor(complex128))</dt>
<dd>Constrain output types to any tensor type.</dd>
</dl>

### <a name="SequenceEmpty-11"></a>**SequenceEmpty-11**</a>

  Construct an empty tensor sequence, with given data type.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>dtype</tt> : int</dt>
<dd>(Optional) The data type of the tensors in the output sequence. The default type is 'float'.</dd>
</dl>

#### Inputs


#### Outputs

<dl>
<dt><tt>output</tt> : S</dt>
<dd>Empty sequence.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>S</tt> : seq(tensor(uint8)), seq(tensor(uint16)), seq(tensor(uint32)), seq(tensor(uint64)), seq(tensor(int8)), seq(tensor(int16)), seq(tensor(int32)), seq(tensor(int64)), seq(tensor(float16)), seq(tensor(float)), seq(tensor(double)), seq(tensor(string)), seq(tensor(bool)), seq(tensor(complex64)), seq(tensor(complex128))</dt>
<dd>Constrain output types to any tensor type.</dd>
</dl>

### <a name="SequenceErase-11"></a>**SequenceErase-11**</a>

  Outputs a tensor sequence that removes the tensor at 'position' from 'input_sequence'.
  Accepted range for 'position' is in `[-n, n - 1]`, where `n` is the number of tensors in 'input_sequence'.
  Negative value means counting positions from the back.
  'position' is optional, by default it erases the last tensor from 'input_sequence'.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Inputs (1 - 2)

<dl>
<dt><tt>input_sequence</tt> : S</dt>
<dd>Input sequence.</dd>
<dt><tt>position</tt> (optional) : I</dt>
<dd>Position of the tensor in the sequence. Negative value means counting positions from the back. Accepted range in `[-n, n - 1]`, where `n` is the number of tensors in 'input_sequence'. It is an error if any of the index values are out of bounds. It must be a scalar(tensor of empty shape).</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output_sequence</tt> : S</dt>
<dd>Output sequence that has the tensor at the specified position removed.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>S</tt> : seq(tensor(uint8)), seq(tensor(uint16)), seq(tensor(uint32)), seq(tensor(uint64)), seq(tensor(int8)), seq(tensor(int16)), seq(tensor(int32)), seq(tensor(int64)), seq(tensor(float16)), seq(tensor(float)), seq(tensor(double)), seq(tensor(string)), seq(tensor(bool)), seq(tensor(complex64)), seq(tensor(complex128))</dt>
<dd>Constrain to any tensor type.</dd>
<dt><tt>I</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain position to integral tensor. It must be a scalar(tensor of empty shape).</dd>
</dl>

### <a name="SequenceInsert-11"></a>**SequenceInsert-11**</a>

  Outputs a tensor sequence that inserts 'tensor' into 'input_sequence' at 'position'.
  'tensor' must have the same data type as 'input_sequence'.
  Accepted range for 'position' is in `[-n, n]`, where `n` is the number of tensors in 'input_sequence'.
  Negative value means counting positions from the back.
  'position' is optional, by default it inserts 'tensor' to the back of 'input_sequence'.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Inputs (2 - 3)

<dl>
<dt><tt>input_sequence</tt> : S</dt>
<dd>Input sequence.</dd>
<dt><tt>tensor</tt> : T</dt>
<dd>Input tensor to be inserted into the input sequence.</dd>
<dt><tt>position</tt> (optional) : I</dt>
<dd>Position in the sequence where the new tensor is inserted. It is optional and default is to insert to the back of the sequence. Negative value means counting positions from the back. Accepted range in `[-n, n]`, where `n` is the number of tensors in 'input_sequence'. It is an error if any of the index values are out of bounds. It must be a scalar(tensor of empty shape).</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output_sequence</tt> : S</dt>
<dd>Output sequence that contains the inserted tensor at given position.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain to any tensor type.</dd>
<dt><tt>S</tt> : seq(tensor(uint8)), seq(tensor(uint16)), seq(tensor(uint32)), seq(tensor(uint64)), seq(tensor(int8)), seq(tensor(int16)), seq(tensor(int32)), seq(tensor(int64)), seq(tensor(float16)), seq(tensor(float)), seq(tensor(double)), seq(tensor(string)), seq(tensor(bool)), seq(tensor(complex64)), seq(tensor(complex128))</dt>
<dd>Constrain to any tensor type.</dd>
<dt><tt>I</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain position to integral tensor. It must be a scalar(tensor of empty shape).</dd>
</dl>

### <a name="SequenceLength-11"></a>**SequenceLength-11**</a>

  Produces a scalar(tensor of empty shape) containing the number of tensors in 'input_sequence'.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input_sequence</tt> : S</dt>
<dd>Input sequence.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>length</tt> : I</dt>
<dd>Length of input sequence. It must be a scalar(tensor of empty shape).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>S</tt> : seq(tensor(uint8)), seq(tensor(uint16)), seq(tensor(uint32)), seq(tensor(uint64)), seq(tensor(int8)), seq(tensor(int16)), seq(tensor(int32)), seq(tensor(int64)), seq(tensor(float16)), seq(tensor(float)), seq(tensor(double)), seq(tensor(string)), seq(tensor(bool)), seq(tensor(complex64)), seq(tensor(complex128))</dt>
<dd>Constrain to any tensor type.</dd>
<dt><tt>I</tt> : tensor(int64)</dt>
<dd>Constrain output to integral tensor. It must be a scalar(tensor of empty shape).</dd>
</dl>

### <a name="Slice-11"></a>**Slice-11**</a>

  Produces a slice of the input tensor along multiple axes. Similar to numpy:
  https://docs.scipy.org/doc/numpy/reference/arrays.indexing.html
  Slices uses `starts`, `ends`, `axes` and `steps` inputs to specify the start and end
  dimension and step for each axis in the list of axes, it uses this information to
  slice the input `data` tensor. If a negative value is passed for any of the
  start or end indices, it represents number of elements before the end of that
  dimension. If the value passed to start or end is larger than the `n` (the
  number of elements in this dimension), it represents `n`. For slicing to the
  end of a dimension with unknown size, it is recommended to pass in `INT_MAX`
  when sclicing forward and 'INT_MIN' when slicing backward.
  If a negative value is passed for step, it represents slicing backward.
  However step value cannot be 0.
  If `axes` are omitted, they are set to `[0, ..., ndim-1]`.
  If `steps` are omitted, they are set to `[1, ..., 1]` of length `len(starts)`
  Example 1:
    data = [
        [1, 2, 3, 4],
        [5, 6, 7, 8],
    ]
    axes = [0, 1]
    starts = [1, 0]
    ends = [2, 3]
    steps = [1, 2]
    result = [
        [5, 7],
    ]
  Example 2:
    data = [
        [1, 2, 3, 4],
        [5, 6, 7, 8],
    ]
    starts = [0, 1]
    ends = [-1, 1000]
    result = [
        [2, 3, 4],
    ]

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Inputs (3 - 5)

<dl>
<dt><tt>data</tt> : T</dt>
<dd>Tensor of data to extract slices from.</dd>
<dt><tt>starts</tt> : Tind</dt>
<dd>1-D tensor of starting indices of corresponding axis in `axes`</dd>
<dt><tt>ends</tt> : Tind</dt>
<dd>1-D tensor of ending indices (exclusive) of corresponding axis in `axes`</dd>
<dt><tt>axes</tt> (optional) : Tind</dt>
<dd>1-D tensor of axes that `starts` and `ends` apply to. Negative value means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>steps</tt> (optional) : Tind</dt>
<dd>1-D tensor of slice step of corresponding axis in `axes`. Negative value means slicing backward. 'steps' cannot be 0. Defaults to 1.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Sliced data tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
<dt><tt>Tind</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain indices to integer types</dd>
</dl>

### <a name="Softmax-11"></a>**Softmax-11**</a>

  The operator computes the softmax (normalized exponential) values for each layer in the batch
   of the given input.

  The input does not need to explicitly be a 2D vector; rather, it will be
  coerced into one. For an arbitrary n-dimensional tensor
  input \in [a_0, a_1, ..., a_{k-1}, a_k, ..., a_{n-1}] and k is
  the axis provided, then input will be coerced into a 2-dimensional tensor with
  dimensions [a_0 * ... * a_{k-1}, a_k * ... * a_{n-1}]. For the default
  case where axis=1, this means the input tensor will be coerced into a 2D tensor
  of dimensions [a_0, a_1 * ... * a_{n-1}], where a_0 is often the batch size.
  In this situation, we must have a_0 = N and a_1 * ... * a_{n-1} = D.
  Each of these dimensions must be matched correctly, or else the operator
  will throw errors. The output tensor has the same shape
  and contains the softmax values of the corresponding input.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 1)</dt>
<dd>Describes the axis of the inputs when coerced to 2D; defaults to one because the 0th axis most likely describes the batch_size. Negative value means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(input).</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>The input tensor that's coerced into a 2D matrix of size (NxD) as described above.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>The output values with the same shape as input tensor (the original size without coercion).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Split-11"></a>**Split-11**</a>

  Split a tensor into a list of tensors, along the specified
  'axis'. Lengths of the parts can be specified using argument 'split'.
  Otherwise, the tensor is split to equal sized parts.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 0)</dt>
<dd>Which axis to split on. A negative value means counting dimensions from the back. Accepted range is [-rank, rank-1] where r = rank(input).</dd>
<dt><tt>split</tt> : list of ints</dt>
<dd>length of each output. Values should be >= 0.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>The tensor to split</dd>
</dl>

#### Outputs (1 - &#8734;)

<dl>
<dt><tt>outputs</tt> (variadic) : T</dt>
<dd>One or more outputs forming list of tensors after splitting</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

### <a name="SplitToSequence-11"></a>**SplitToSequence-11**</a>

  Split a tensor into a sequence of tensors, along the specified
  'axis'. Lengths of the parts can be specified using argument 'split'.
  'split' must contain only positive numbers.
  'split' is either a scalar (tensor of empty shape), or a 1-D tensor.
  If 'split' is a scalar, then 'input' will be split into equally sized chunks(if possible).
  Last chunk will be smaller if the 'input' size along the given axis 'axis' is not divisible
  by 'split'.
  Otherwise, the tensor is split into 'size(split)' chunks, with lengths of the parts on 'axis'
  specified in 'split'. In this scenario, the sum of entries in 'split' must be equal to the
  dimension size of input tensor on 'axis'.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 0)</dt>
<dd>Which axis to split on. A negative value means counting dimensions from the back. Accepted range is [-rank, rank-1].</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the split dimension or not. Default 1, which means we keep split dimension. If input 'split' is specified, this attribute is ignored.</dd>
</dl>

#### Inputs (1 - 2)

<dl>
<dt><tt>input</tt> : T</dt>
<dd>The tensor to split</dd>
<dt><tt>split</tt> (optional) : I</dt>
<dd>Length of each output. It can be either a scalar(tensor of empty shape), or a 1-D tensor. All values must be >= 0. </dd>
</dl>

#### Outputs

<dl>
<dt><tt>output_sequence</tt> : S</dt>
<dd>One or more outputs forming a sequence of tensors after splitting</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input types to all tensor types.</dd>
<dt><tt>I</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain split size to integral tensor.</dd>
<dt><tt>S</tt> : seq(tensor(uint8)), seq(tensor(uint16)), seq(tensor(uint32)), seq(tensor(uint64)), seq(tensor(int8)), seq(tensor(int16)), seq(tensor(int32)), seq(tensor(int64)), seq(tensor(float16)), seq(tensor(float)), seq(tensor(double)), seq(tensor(string)), seq(tensor(bool)), seq(tensor(complex64)), seq(tensor(complex128))</dt>
<dd>Constrain output types to all tensor types.</dd>
</dl>

### <a name="Squeeze-11"></a>**Squeeze-11**</a>

  Remove single-dimensional entries from the shape of a tensor.
  Takes a  parameter `axes` with a list of axes to squeeze.
  If `axes` is not provided, all the single dimensions will be removed from
  the shape. If an axis is selected with shape entry not equal to one, an error is raised.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>List of integers indicating the dimensions to squeeze. Negative value means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(data).</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>Tensors with at least max(dims) dimensions.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>squeezed</tt> : T</dt>
<dd>Reshaped tensor with same data as input.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

### <a name="TopK-11"></a>**TopK-11**</a>

  Retrieve the top-K largest or smallest elements along a specified axis. Given an input tensor of
  shape [a_1, a_2, ..., a_n, r] and integer argument k, return two outputs:
    -Value tensor of shape [a_1, a_2, ..., a_{axis-1}, k, a_{axis+1}, ... a_n]
      which contains the values of the top k elements along the specified axis
    -Index tensor of shape [a_1, a_2, ..., a_{axis-1}, k, a_{axis+1}, ... a_n] which
     contains the indices of the top k elements (original indices from the input
     tensor).

  If "largest" is 1 (the default value) then the k largest elements are returned.
  If "sorted" is 1 (the default value) then the resulting k elements will be sorted.
  If "sorted" is 0, order of returned 'Values' and 'Indices' are undefined.

  Given two equivalent values, this operator uses the indices along the axis as
   a tiebreaker. That is, the element with the lower index will appear first.

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is -1)</dt>
<dd>Dimension on which to do the sort. Negative value means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(input).</dd>
<dt><tt>largest</tt> : int (default is 1)</dt>
<dd>Whether to return the top-K largest or smallest elements.</dd>
<dt><tt>sorted</tt> : int (default is 1)</dt>
<dd>Whether to return the elements in sorted order.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Tensor of shape [a_1, a_2, ..., a_n, r]</dd>
<dt><tt>K</tt> (non-differentiable) : tensor(int64)</dt>
<dd>A 1-D tensor containing a single positive value corresponding to the number of top elements to retrieve</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Values</tt> (differentiable) : T</dt>
<dd>Tensor of shape [a_1, a_2, ..., a_{axis-1}, k, a_{axis+1}, ... a_n] containing top K values from the input tensor</dd>
<dt><tt>Indices</tt> (non-differentiable) : I</dt>
<dd>Tensor of shape [a_1, a_2, ..., a_{axis-1}, k, a_{axis+1}, ... a_n] containing the corresponding input tensor indices for the top K values.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to numeric tensors.</dd>
<dt><tt>I</tt> : tensor(int64)</dt>
<dd>Constrain index tensor to int64</dd>
</dl>

### <a name="Unique-11"></a>**Unique-11**</a>

  Find the unique elements of a tensor. When an optional attribute 'axis' is provided, unique subtensors sliced along the 'axis' are returned.
  Otherwise the input tensor is flattened and unique values of the flattened tensor are returned.

  This operator returns the unique values or sliced unique subtensors of the input tensor and three optional outputs.
  The first output tensor 'Y' contains all unique values or subtensors of the input.
  The second optional output tensor 'indices' contains indices of 'Y' elements' first occurance in 'X'..
  The third optional output tensor 'inverse_indices' contains, for elements of 'X', its corresponding indices in 'Y'. ".
  The fourth optional output tensor 'counts' contains the count of each element of 'Y' in the input.

  Outputs are either sorted in ascending order or optionally in the order of the first occurrence of the values in the input.

  https://docs.scipy.org/doc/numpy/reference/generated/numpy.unique.html

  Example 1:
    input_X = [2, 1, 1, 3, 4, 3]
    attribute_sorted = 0
    attribute_axis = None
    output_Y = [2, 1, 3, 4]
    output_indices = [0, 1, 3, 4]
    output_inverse_indices = [0, 1, 1, 2, 3, 2]
    output_counts = [1, 2, 2, 1]

  Example 2:
    input_X = [[1, 3], [2, 3]]
    attribute_sorted = 1
    attribute_axis = None
    output_Y = [1, 2, 3]
    output_indices = [0, 2, 1]
    output_inverse_indices = [0, 2, 1, 2]
    output_counts = [1, 1, 2]

  Example 3:
    input_X = [[1, 0, 0], [1, 0, 0], [2, 3, 4]]
    attribute_sorted = 1
    attribute_axis = 0
    output_Y = [[1, 0, 0], [2, 3, 4]]
    output_indices = [0, 2]
    output_inverse_indices = [0, 0, 1]
    output_counts = [2, 1]

  Example 4:
    input_x = [[[1., 1.], [0., 1.], [2., 1.], [0., 1.]],
               [[1., 1.], [0., 1.], [2., 1.], [0., 1.]]]
    attribute_sorted = 1
    attribute_axis = 1

    intermediate data are presented below for better understanding:

    there are 4 subtensors sliced along axis 1 of input_x (shape = (2, 4, 2)):
    A: [[1, 1], [1, 1]],
       [[0, 1], [0, 1]],
       [[2, 1], [2, 1]],
       [[0, 1], [0, 1]].

    there are 3 unique subtensors:
    [[1, 1], [1, 1]],
    [[0, 1], [0, 1]],
    [[2, 1], [2, 1]].

    sorted unique subtensors:
    B: [[0, 1], [0, 1]],
       [[1, 1], [1, 1]],
       [[2, 1], [2, 1]].

    output_Y is constructed from B:
    [[[0. 1.], [1. 1.], [2. 1.]],
     [[0. 1.], [1. 1.], [2. 1.]]]

    output_indices is to map from B to A:
    [1, 0, 2]

    output_inverse_indices is to map from A to B:
    [1, 0, 2, 0]

    output_counts = [2 1 1]

#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int</dt>
<dd>(Optional) The dimension to apply unique. If not specified, the unique elements of the flattened input are returned. Negative value means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(input).</dd>
<dt><tt>sorted</tt> : int (default is 1)</dt>
<dd>(Optional) Whether to sort the unique elements in ascending order before returning as output. Must be one of 0, or 1 (default).</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> (non-differentiable) : T</dt>
<dd>A N-D input tensor that is to be processed.</dd>
</dl>

#### Outputs (1 - 4)

<dl>
<dt><tt>Y</tt> (non-differentiable) : T</dt>
<dd>A tensor of the same type as 'X' containing all the unique values or subtensors sliced along a provided 'axis' in 'X', either sorted or maintained in the same order they occur in input 'X'</dd>
<dt><tt>indices</tt> (optional, non-differentiable) : tensor(int64)</dt>
<dd>A 1-D INT64 tensor containing indices of 'Y' elements' first occurance in 'X'. When 'axis' is provided, it contains indices to subtensors in input 'X' on the 'axis'. When 'axis' is not provided, it contains indices to values in the flattened input tensor. </dd>
<dt><tt>inverse_indices</tt> (optional, non-differentiable) : tensor(int64)</dt>
<dd>A 1-D INT64 tensor containing, for elements of 'X', its corresponding indices in 'Y'. When 'axis' is provided, it contains indices to subtensors in output 'Y' on the 'axis'. When 'axis' is not provided, it contains indices to values in output 'Y'. </dd>
<dt><tt>counts</tt> (optional, non-differentiable) : tensor(int64)</dt>
<dd>A 1-D INT64 tensor containing the count of each element of 'Y' in input 'X'</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Input can be of any tensor type.</dd>
</dl>

### <a name="Unsqueeze-11"></a>**Unsqueeze-11**</a>

  Insert single-dimensional entries to the shape of an input tensor (`data`).
  Takes one required argument `axes` - which contains a list of dimension indices and this operator will insert a dimension of value `1` into the corresponding index of the output tensor (`expanded`).

  For example:
    Given an input tensor (`data`) of shape [3, 4, 5], then
    Unsqueeze(data, axes=[0, 4]) outputs a tensor (`expanded`) containing same data as `data` but with shape [1, 3, 4, 5, 1].

  The attribute `axes` should not contain any duplicate entries. It is an error if it contains duplicates.
  The rank of the output tensor (`output_rank`) is the rank of the input tensor (`data`) plus the number of values in `axes`.
  Each value in `axes` should be within the (inclusive) range [-output_rank , output_rank - 1].
  The order of values in `axes` does not matter and can come in any order.


#### Version

This version of the operator has been available since version 11 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints (required)</dt>
<dd>List of integers indicating the dimensions to be inserted. Negative value means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(expanded).</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>Original tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>expanded</tt> : T</dt>
<dd>Reshaped tensor with same data as input.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

## Version 12 of the default ONNX operator set
### <a name="ArgMax-12"></a>**ArgMax-12**</a>

  Computes the indices of the max elements of the input tensor's element along the
  provided axis. The resulting tensor has the same rank as the input if keepdims equals 1.
  If keepdims equal 0, then the resulting tensor has the reduced dimension pruned.
  If select_last_index is True (default False), the index of the last occurrence of the max
  is selected if the max appears more than once in the input. Otherwise the index of the
  first occurrence is selected.
  The type of the output tensor is integer.

#### Version

This version of the operator has been available since version 12 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 0)</dt>
<dd>The axis in which to compute the arg indices. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
<dt><tt>select_last_index</tt> : int (default is 0)</dt>
<dd>Whether to select the last index or the first index if the {name} appears in multiple indices, default is False (first index).</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : tensor(int64)</dt>
<dd>Reduced output tensor with integer data type.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to all numeric tensors.</dd>
</dl>

### <a name="ArgMin-12"></a>**ArgMin-12**</a>

  Computes the indices of the min elements of the input tensor's element along the
  provided axis. The resulting tensor has the same rank as the input if keepdims equals 1.
  If keepdims equal 0, then the resulting tensor has the reduced dimension pruned.
  If select_last_index is True (default False), the index of the last occurrence of the min
  is selected if the min appears more than once in the input. Otherwise the index of the
  first occurrence is selected.
  The type of the output tensor is integer.

#### Version

This version of the operator has been available since version 12 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 0)</dt>
<dd>The axis in which to compute the arg indices. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
<dt><tt>select_last_index</tt> : int (default is 0)</dt>
<dd>Whether to select the last index or the first index if the {name} appears in multiple indices, default is False (first index).</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : tensor(int64)</dt>
<dd>Reduced output tensor with integer data type.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to all numeric tensors.</dd>
</dl>

### <a name="Celu-12"></a>**Celu-12**</a>

  Continuously Differentiable Exponential Linear Units:
  Perform the linear unit element-wise on the input tensor X
  using formula:

  ```
  max(0,x) + min(0,alpha*(exp(x/alpha)-1))
  ```

#### Version

This version of the operator has been available since version 12 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float (default is 1.0)</dt>
<dd>The Alpha value in Celu formula which control the shape of the unit. The default value is 1.0.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float)</dt>
<dd>Constrain input and output types to float32 tensors.</dd>
</dl>

### <a name="Clip-12"></a>**Clip-12**</a>

  Clip operator limits the given input within an interval. The interval is
  specified by the inputs 'min' and 'max'. They default to
  numeric_limits::lowest() and numeric_limits::max(), respectively.

#### Version

This version of the operator has been available since version 12 of the default ONNX operator set.

#### Inputs (1 - 3)

<dl>
<dt><tt>input</tt> : T</dt>
<dd>Input tensor whose elements to be clipped</dd>
<dt><tt>min</tt> (optional) : T</dt>
<dd>Minimum value, under which element is replaced by min. It must be a scalar(tensor of empty shape).</dd>
<dt><tt>max</tt> (optional) : T</dt>
<dd>Maximum value, above which element is replaced by max. It must be a scalar(tensor of empty shape).</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Output tensor with clipped input elements</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to all numeric tensors.</dd>
</dl>

### <a name="Constant-12"></a>**Constant-12**</a>

  This operator produces a constant tensor. Exactly one of the provided attributes, either value, sparse_value,
  or value_* must be specified.

#### Version

This version of the operator has been available since version 12 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>sparse_value</tt> : sparse_tensor</dt>
<dd>The value for the elements of the output tensor in sparse format.</dd>
<dt><tt>value</tt> : tensor</dt>
<dd>The value for the elements of the output tensor.</dd>
<dt><tt>value_float</tt> : float</dt>
<dd>The value for the sole element for the scalar, float32, output tensor.</dd>
<dt><tt>value_floats</tt> : list of floats</dt>
<dd>The values for the elements for the 1D, float32, output tensor.</dd>
<dt><tt>value_int</tt> : int</dt>
<dd>The value for the sole element for the scalar, int64, output tensor.</dd>
<dt><tt>value_ints</tt> : list of ints</dt>
<dd>The values for the elements for the 1D, int64, output tensor.</dd>
<dt><tt>value_string</tt> : string</dt>
<dd>The value for the sole element for the scalar, UTF-8 string, output tensor.</dd>
<dt><tt>value_strings</tt> : list of strings</dt>
<dd>The values for the elements for the 1D, UTF-8 string, output tensor.</dd>
</dl>

#### Inputs


#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Output tensor containing the same value of the provided tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

### <a name="Dropout-12"></a>**Dropout-12**</a>

  Dropout takes an input floating-point tensor, an optional input ratio (floating-point scalar) and an optional input training_mode (boolean scalar). It produces two tensor outputs,
  output (floating-point tensor) and mask (optional `Tensor<bool>`). If `training_mode` is true then the output Y will be a random dropout;
  Note that this Dropout scales the masked input data by the following equation, so to convert the trained model into inference mode,
  the user can simply not pass `training_mode` input or set it to false.
  ```
  output = scale * data * mask,
  ```
  where
  ```
  scale = 1. / (1. - ratio).
  ```
  This operator has **optional** inputs/outputs. See [the doc](IR.md) for more details about the representation of optional arguments. An empty string may be used in the place of an actual argument's name to indicate a missing argument. Trailing optional arguments (those not followed by an argument that is present) may also be simply omitted.

#### Version

This version of the operator has been available since version 12 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>seed</tt> : int</dt>
<dd>(Optional) Seed to the random generator, if not specified we will auto generate one.</dd>
</dl>

#### Inputs (1 - 3)

<dl>
<dt><tt>data</tt> : T</dt>
<dd>The input data as Tensor.</dd>
<dt><tt>ratio</tt> (optional) : T1</dt>
<dd>The ratio of random dropout, with value in [0, 1). If this input was not set, or if it was set to 0, the output would be a simple copy of the input. If it's non-zero, output will be a random dropout of the scaled input, which is typically the case during training. It is an optional value, if not specified it will default to 0.5.</dd>
<dt><tt>training_mode</tt> (optional) : T2</dt>
<dd>If set to true then it indicates dropout is being used for training. It is an optional value hence unless specified explicitly, it is false. If it is false, ratio is ignored and the operation mimics inference mode where nothing will be dropped from the input data and if mask is requested as output it will contain all ones.</dd>
</dl>

#### Outputs (1 - 2)

<dl>
<dt><tt>output</tt> : T</dt>
<dd>The output.</dd>
<dt><tt>mask</tt> (optional) : T2</dt>
<dd>The output mask.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T1</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input 'ratio' types to float tensors.</dd>
<dt><tt>T2</tt> : tensor(bool)</dt>
<dd>Constrain output 'mask' types to boolean tensors.</dd>
</dl>

### <a name="Einsum-12"></a>**Einsum-12**</a>

  An einsum of the form ```term1, term2 -> output-term``` produces an output tensor using the following equation

  ```output[output-term] = reduce-sum( input1[term1] * input2[term] )```

  where the reduce-sum performs a summation over all the indices occurring in the input terms (term1, term2)
  that do not occur in the output-term.

  The Einsum operator evaluates algebraic tensor operations on a sequence of tensors, using the Einstein summation
  convention. The equation string contains a comma-separated sequence of lower case letters. Each term corresponds to
  an operand tensor, and the characters within the terms correspond to operands dimensions.

  This sequence may be followed by "->" to separate the left and right hand side of the equation.
  If the equation contains "->" followed by the right-hand side, the explicit (not classical) form of the Einstein
  summation is performed, and the right-hand side indices indicate output tensor dimensions. In other cases,
  output indices are (implicitly) set to the alphabetically sorted sequence of indices appearing exactly once in the
  equation.

  When a dimension character is repeated in the left-hand side, it represents summation along the dimension.

  The equation may contain ellipsis ("...") to enable broadcasting. Ellipsis must indicate a fixed number of dimensions.
  Specifically, every occurrence of ellipsis in the equation must represent the same number of dimensions.
  The right-hand side may contain exactly one ellipsis. In implicit mode, the ellipsis dimensions are set to the
  beginning of the output. The equation string may contain space (U+0020) character.

#### Version

This version of the operator has been available since version 12 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>equation</tt> : string (required)</dt>
<dd>Einsum expression string.</dd>
</dl>

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>Inputs</tt> (variadic, differentiable) : T</dt>
<dd>Operands</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Output</tt> (differentiable) : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to all numerical tensor types.</dd>
</dl>

### <a name="GatherND-12"></a>**GatherND-12**</a>

  Given `data` tensor of rank `r` >= 1, `indices` tensor of rank `q` >= 1, and `batch_dims` integer `b`, this operator gathers
  slices of `data` into an output tensor of rank `q + r - indices_shape[-1] - 1 - b`.

  `indices` is an q-dimensional integer tensor, best thought of as a `(q-1)`-dimensional tensor of index-tuples into `data`,
  where each element defines a slice of `data`

  `batch_dims` (denoted as `b`) is an integer indicating the number of batch dimensions, i.e the leading `b` number of dimensions of
  `data` tensor and `indices` are representing the batches, and the gather starts from the `b+1` dimension.

  Some salient points about the inputs' rank and shape:

  1) r >= 1 and q >= 1 are to be honored. There is no dependency condition to be met between ranks `r` and `q`

  2) The first `b` dimensions of the shape of `indices` tensor and `data` tensor must be equal.

  3) b < min(q, r) is to be honored.

  4) The `indices_shape[-1]` should have a value between 1 (inclusive) and rank `r-b` (inclusive)

  5) All values in `indices` are expected to be within bounds [-s, s-1] along axis of size `s` (i.e.) `-data_shape[i] <= indices[...,i] <= data_shape[i] - 1`.
     It is an error if any of the index values are out of bounds.

  The output is computed as follows:

  The output tensor is obtained by mapping each index-tuple in the `indices` tensor to the corresponding slice of the input `data`.

  1) If `indices_shape[-1] > r-b` => error condition

  2) If `indices_shape[-1] == r-b`, since the rank of `indices` is `q`, `indices` can be thought of as `N` `(q-b-1)`-dimensional tensors
     containing 1-D tensors of dimension `r-b`, where `N` is an integer equals to the product of 1 and all the elements in the batch dimensions
     of the indices_shape. Let us think of each such `r-b` ranked tensor as `indices_slice`. Each *scalar value* corresponding to `data[0:b-1,indices_slice]`
     is filled into the corresponding location of the `(q-b-1)`-dimensional tensor to form the `output` tensor (Example 1 below)

  3) If `indices_shape[-1] < r-b`, since the rank of `indices` is `q`, `indices` can be thought of as `N` `(q-b-1)`-dimensional tensor
     containing 1-D tensors of dimension `< r-b`. Let us think of each such tensors as `indices_slice`. Each *tensor slice* corresponding
     to `data[0:b-1, indices_slice , :]` is filled into the corresponding location of the `(q-b-1)`-dimensional tensor
     to form the `output` tensor (Examples 2, 3, 4 and 5 below)

  This operator is the inverse of `ScatterND`.

  `Example 1`

    batch_dims = 0

    data    = [[0,1],[2,3]]   # data_shape = [2, 2]

    indices = [[0,0],[1,1]]   # indices_shape = [2, 2]

    output  = [0,3]           # output_shape = [2]

  `Example 2`

    batch_dims = 0

    data    = [[0,1],[2,3]]  # data_shape = [2, 2]

    indices = [[1],[0]]      # indices_shape = [2, 1]

    output  = [[2,3],[0,1]]  # output_shape = [2, 2]

  `Example 3`

    batch_dims = 0

    data    = [[[0,1],[2,3]],[[4,5],[6,7]]] # data_shape = [2, 2, 2]

    indices = [[0,1],[1,0]]                 # indices_shape = [2, 2]

    output  = [[2,3],[4,5]]                 # output_shape = [2, 2]

  `Example 4`

    batch_dims = 0

    data    = [[[0,1],[2,3]],[[4,5],[6,7]]] # data_shape = [2, 2, 2]

    indices = [[[0,1]],[[1,0]]]             # indices_shape = [2, 1, 2]

    output  = [[[2,3]],[[4,5]]]             # output_shape = [2, 1, 2]

  `Example 5`

    batch_dims = 1

    data    = [[[0,1],[2,3]],[[4,5],[6,7]]] # data_shape = [2, 2, 2]

    indices = [[1],[0]]             # indices_shape = [2, 1]

    output  = [[2,3],[4,5]]             # output_shape = [2, 2]



#### Version

This version of the operator has been available since version 12 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>batch_dims</tt> : int (default is 0)</dt>
<dd>The number of batch dimensions. The gather of indexing starts from dimension of data[batch_dims:]</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>Tensor of rank r >= 1.</dd>
<dt><tt>indices</tt> : tensor(int64)</dt>
<dd>Tensor of rank q >= 1. All index values are expected to be within bounds [-s, s-1] along axis of size s. It is an error if any of the index values are out of bounds.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Tensor of rank q + r - indices_shape[-1] - 1.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to any tensor type.</dd>
</dl>

### <a name="GreaterOrEqual-12"></a>**GreaterOrEqual-12**</a>

  Returns the tensor resulted from performing the `greater_equal` logical operation
  elementwise on the input tensors `A` and `B` (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 12 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> (non-differentiable) : T</dt>
<dd>First input operand for the logical operator.</dd>
<dt><tt>B</tt> (non-differentiable) : T</dt>
<dd>Second input operand for the logical operator.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> (non-differentiable) : T1</dt>
<dd>Result tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input types to all numeric tensors.</dd>
<dt><tt>T1</tt> : tensor(bool)</dt>
<dd>Constrain output to boolean tensor.</dd>
</dl>

### <a name="LessOrEqual-12"></a>**LessOrEqual-12**</a>

  Returns the tensor resulted from performing the `less_equal` logical operation
  elementwise on the input tensors `A` and `B` (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 12 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> (non-differentiable) : T</dt>
<dd>First input operand for the logical operator.</dd>
<dt><tt>B</tt> (non-differentiable) : T</dt>
<dd>Second input operand for the logical operator.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> (non-differentiable) : T1</dt>
<dd>Result tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input types to all numeric tensors.</dd>
<dt><tt>T1</tt> : tensor(bool)</dt>
<dd>Constrain output to boolean tensor.</dd>
</dl>

### <a name="Max-12"></a>**Max-12**</a>

  Element-wise max of each of the input tensors (with Numpy-style broadcasting support).
  All inputs and outputs must have the same data type.
  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 12 of the default ONNX operator set.

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>data_0</tt> (variadic) : T</dt>
<dd>List of tensors for max.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>max</tt> : T</dt>
<dd>Output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to numeric tensors.</dd>
</dl>

### <a name="MaxPool-12"></a>**MaxPool-12**</a>

  MaxPool consumes an input tensor X and applies max pooling across
   the tensor according to kernel sizes, stride sizes, and pad lengths.
   max pooling consisting of computing the max on all values of a
   subset of the input tensor according to the kernel size and downsampling the
   data into the output tensor Y for further processing. The output spatial shape will be following:
   ```
   output_spatial_shape[i] = floor((input_spatial_shape[i] + pad_shape[i] - ((kernel_spatial_shape[i] - 1) * dilations[i] + 1)) / strides_spatial_shape[i] + 1)
   ```
   or
   ```
   output_spatial_shape[i] = ceil((input_spatial_shape[i] + pad_shape[i] - ((kernel_spatial_shape[i] - 1) * dilations[i] + 1)) / strides_spatial_shape[i] + 1)
   ```
   if ceil_mode is enabled

   ```
   * pad_shape[i] is sum of pads along axis i
   ```

   `auto_pad` is a DEPRECATED attribute. If you are using them currently, the output spatial shape will be following:
   ```
   VALID: output_spatial_shape[i] = ceil((input_spatial_shape[i] - ((kernel_spatial_shape[i] - 1) * dilations[i] + 1) + 1) / strides_spatial_shape[i])
   SAME_UPPER or SAME_LOWER: output_spatial_shape[i] = ceil(input_spatial_shape[i] / strides_spatial_shape[i])
   ```
   And pad shape will be following if `SAME_UPPER` or `SAME_LOWER`:
   ```
   pad_shape[i] = (output_spatial_shape[i] - 1) * strides_spatial_shape[i] + ((kernel_spatial_shape[i] - 1) * dilations[i] + 1) - input_spatial_shape[i]
   ```
   The output of each pooling window is maximum number of elements exclude pad.


#### Version

This version of the operator has been available since version 12 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>auto_pad</tt> : string (default is NOTSET)</dt>
<dd>auto_pad must be either NOTSET, SAME_UPPER, SAME_LOWER or VALID. Where default value is NOTSET, which means explicit padding is used. SAME_UPPER or SAME_LOWER mean pad the input so that `output_shape[i] = ceil(input_shape[i] / strides[i])` for each axis `i`. The padding is split between the two sides equally or almost equally (depending on whether it is even or odd). In case the padding is an odd number, the extra padding is added at the end for SAME_UPPER and at the beginning for SAME_LOWER.</dd>
<dt><tt>ceil_mode</tt> : int (default is 0)</dt>
<dd>Whether to use ceil or floor (default) to compute the output shape.</dd>
<dt><tt>dilations</tt> : list of ints</dt>
<dd>Dilation value along each spatial axis of filter. If not present, the dilation defaults to 1 along each spatial axis.</dd>
<dt><tt>kernel_shape</tt> : list of ints (required)</dt>
<dd>The size of the kernel along each axis.</dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd>Padding for the beginning and ending along each spatial axis, it can take any value greater than or equal to 0. The value represent the number of pixels added to the beginning and end part of the corresponding axis. `pads` format should be as follow [x1_begin, x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels added at the beginning of axis `i` and xi_end, the number of pixels added at the end of axis `i`. This attribute cannot be used simultaneously with auto_pad attribute. If not present, the padding defaults to 0 along start and end of each spatial axis.</dd>
<dt><tt>storage_order</tt> : int (default is 0)</dt>
<dd>The storage order of the tensor. 0 is row major, and 1 is column major.</dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd>Stride along each spatial axis. If not present, the stride defaults to 1 along each spatial axis.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input data tensor from the previous operator; dimensions for image case are (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data. For non image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size. Optionally, if dimension denotation is in effect, the operation expects the input data tensor to arrive with the dimension denotation of [DATA_BATCH, DATA_CHANNEL, DATA_FEATURE, DATA_FEATURE ...].</dd>
</dl>

#### Outputs (1 - 2)

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output data tensor from average or max pooling across the input tensor. Dimensions will vary based on various kernel, stride, and pad sizes. Floor value of the dimension is used</dd>
<dt><tt>Indices</tt> (optional, non-differentiable) : I</dt>
<dd>Indices tensor from max pooling across the input tensor. The dimensions of indices are the same as output tensor. The values in indices of are the indices of the selected values during pooling. The indices are computed as flatten 1-D tensor, and the indices do not consider padding. So the values in indices are in [0, N x C x D1 x ... x Dn).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(int8), tensor(uint8)</dt>
<dd>Constrain input and output types to float and 8 bit tensors.</dd>
<dt><tt>I</tt> : tensor(int64)</dt>
<dd>Constrain index tensor to int64</dd>
</dl>

### <a name="Min-12"></a>**Min-12**</a>

  Element-wise min of each of the input tensors (with Numpy-style broadcasting support).
  All inputs and outputs must have the same data type.
  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 12 of the default ONNX operator set.

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>data_0</tt> (variadic) : T</dt>
<dd>List of tensors for min.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>min</tt> : T</dt>
<dd>Output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to numeric tensors.</dd>
</dl>

### <a name="NegativeLogLikelihoodLoss-12"></a>**NegativeLogLikelihoodLoss-12**</a>

  A NegativeLogLikelihoodLoss operator computes (weighted) negative log likelihood loss.
  Its "input" tensor has the shape of (N, C, d1, d2, ..., dk) where k >= 0.
  The "input" tensor contains log-probabilities for input[n, :, d_1, d_2,..., d_k] being in a class of [0, C).
  The operator's "target" input tensor has the shape of (N, d1, d2, ..., dk). It encodes class labels (one of C classes)
  or it may contain a special value (indicated by an attribute ignore_index) for N x d1 x d2 x ... x dk samples.
  The loss value for input[n, :, d_1, d_2,...d_k] being classified as class c = target[n][d_1][d_2]...[d_k] is computed as:
      loss[n][d_1][d_2]...[d_k] = -input[n][c][d_1][d_2]...[d_k].
  When an optional "weight" is provided, the sample loss is calculated as:
      loss[n][d_1][d_2]...[d_k] = -input[n][c][d_1][d_2]...[d_k] * weight[c].
  loss is zero for the case when target-value equals ignore_index.

      loss[n][d_1][d_2]...[d_k] = 0, when target[n][d_1][d_2]...[d_k] = ignore_index
  If "reduction" attribute is set to "none", the operator's output will be the above loss with shape (N, d1, d2, ..., dk).
  If "reduction" attribute is set to "mean" (the default attribute value), the output loss is (weight) averaged:
      mean(loss), if "weight" is not provided,
  or if weight is provided,
      sum(loss) / sum(weight[target[n][d_1][d_2]...[d_k]]]), for all samples.
  If "reduction" attribute is set to "sum", the output is a scalar:
      sum(loss).
  See also https://pytorch.org/docs/stable/nn.html#torch.nn.NLLLoss.
  Example 1:
      // negative log likelihood loss, "none" reduction
      N, C, d1 = 2, 3, 2
      input = [[[1.0, 2.0], [2.0, 2.0], [3.0, 2.0]],
               [[0.0, 1.0], [2.0, 2.0], [1.0, 2]]]
      target = [[2, 1], [0, 2]]
      loss = np.zeros((N, d1))
      for n in range(N):
          for d_1 in range(d1):
              c = target[n][d_1]
              loss[n][d_1] = -input[n][c][d_1]
      // print(loss)
      // [[-3. -2.]
      //  [-0. -2.]]
  Example 2:
      // weighted negative log likelihood loss, sum reduction
      N, C, d1 = 2, 3, 2
      input = [[[1.0, 2.0], [2.0, 2.0], [3.0, 2.0]],
              [[0.0, 1.0], [2.0, 2.0], [1.0, 2]]]
      target = [[2, 1], [0, 2]]
      weight = [0.2, 0.3, 0.1]
      loss = np.zeros((N, d1))
      for n in range(N):
          for d_1 in range(d1):
              c = target[n][d_1]
              loss[n][d_1] = -input[n][c][d_1] * weight[c]
      loss = np.sum(loss)
      // print(loss)
      // -1.1
  Example 3:
      // weighted negative log likelihood loss, mean reduction
      N, C, d1 = 2, 3, 2
      input = [[[1.0, 2.0], [2.0, 2.0], [3.0, 2.0]],
              [[0.0, 1.0], [2.0, 2.0], [1.0, 2]]]
      target = [[2, 1], [0, 2]]
      weight = [0.2, 0.3, 0.1]
      loss = np.zeros((N, d1))
      weight_total = 0
      for n in range(N):
          for d_1 in range(d1):
              c = target[n][d_1]
              loss[n][d_1] = -input[n][c][d_1] * weight[c]
              weight_total = weight_total + weight[c]
      loss = np.sum(loss) / weight_total
      // print(loss)
      // -1.57

#### Version

This version of the operator has been available since version 12 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>ignore_index</tt> : int</dt>
<dd>Specifies a target value that is ignored and does not contribute to the input gradient. It's an optional value.</dd>
<dt><tt>reduction</tt> : string (default is mean)</dt>
<dd>Type of reduction to apply to loss: none, sum, mean (default). 'none': the output is the loss for each sample. 'sum': the output will be summed. 'mean': the sum of the output will be divided by the sum of applied weights.</dd>
</dl>

#### Inputs (2 - 3)

<dl>
<dt><tt>input</tt> : T</dt>
<dd>Input tensor of shape (N, C) or (N, C, d1, d2, ..., dk).</dd>
<dt><tt>target</tt> : Tind</dt>
<dd>Target tensor of shape (N) or (N, d1, d2, ..., dk). Target element value shall be in range of [0, C). If ignore_index is specified, it may have a value outside [0, C) and the target values should either be in the range [0, C) or have the value ignore_index.</dd>
<dt><tt>weight</tt> (optional) : T</dt>
<dd>Optional rescaling weight tensor. If given, it has to be a tensor of size C. Otherwise, it is treated as if having all ones.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>loss</tt> : T</dt>
<dd>The negative log likelihood loss</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input, weight, and output types to floating-point tensors.</dd>
<dt><tt>Tind</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain target to integer types</dd>
</dl>

### <a name="Pow-12"></a>**Pow-12**</a>

  Pow takes input data (Tensor<T>) and exponent Tensor, and
  produces one output data (Tensor<T>) where the function `f(x) = x^exponent`,
  is applied to the data tensor elementwise.
  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 12 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>First operand, base of the exponent.</dd>
<dt><tt>Y</tt> : T1</dt>
<dd>Second operand, power of the exponent.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Z</tt> : T</dt>
<dd>Output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input X and output types to float/int tensors.</dd>
<dt><tt>T1</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input Y types to float/int tensors.</dd>
</dl>

### <a name="ReduceMax-12"></a>**ReduceMax-12**</a>

  Computes the max of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
  the resulted tensor have the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 12 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(uint8), tensor(int8)</dt>
<dd>Constrain input and output types to high-precision and 8 bit numeric tensors.</dd>
</dl>

### <a name="ReduceMin-12"></a>**ReduceMin-12**</a>

  Computes the min of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equal 0, then
  the resulted tensor have the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 12 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(uint8), tensor(int8)</dt>
<dd>Constrain input and output types to high-precision and 8 bit numeric tensors.</dd>
</dl>

### <a name="SoftmaxCrossEntropyLoss-12"></a>**SoftmaxCrossEntropyLoss-12**</a>

  Loss function that measures the softmax cross entropy
  between 'scores' and 'labels'.
  This operator first computes a loss tensor whose shape is identical to the labels input.
  If the input is 2-D with shape (N, C), the loss tensor may be a N-element vector L = (l_1, l_2, ..., l_N).
  If the input is N-D tensor with shape (N, C, D1, D2, ..., Dk),
  the loss tensor L may have (N, D1, D2, ..., Dk) as its shape and L[i,][j_1][j_2]...[j_k] denotes a scalar element in L.
  After L is available, this operator can optionally do a reduction operator.

  shape(scores): (N, C) where C is the number of classes, or (N, C, D1, D2,..., Dk),
          with K >= 1 in case of K-dimensional loss.
  shape(labels): (N) where each value is 0 <= labels[i] <= C-1, or (N, D1, D2,..., Dk),
          with K >= 1 in case of K-dimensional loss.

  The loss for one sample, l_i, can caculated as follows:
      l[i][d1][d2]...[dk] = -y[i][c][d1][d2]..[dk], where i is the index of classes.
  or
      l[i][d1][d2]...[dk] = -y[i][c][d1][d2]..[dk] * weights[c], if 'weights' is provided.

  loss is zero for the case when label-value equals ignore_index.
      l[i][d1][d2]...[dk]  = 0, when labels[n][d1][d2]...[dk] = ignore_index

  where:
      p = Softmax(scores)
      y = Log(p)
      c = labels[i][d1][d2]...[dk]

  Finally, L is optionally reduced:
  If reduction = 'none', the output is L with shape (N, D1, D2, ..., Dk).
  If reduction = 'sum', the output is scalar: Sum(L).
  If reduction = 'mean', the output is scalar: ReduceMean(L), or if weight is provided: ReduceSum(L) / ReduceSum(W),
  where tensor W is of shape (N, D1, D2, ..., Dk) and W[n][d1][d2]...[dk] = weights[labels[i][d1][d2]...[dk]].

#### Version

This version of the operator has been available since version 12 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>ignore_index</tt> : int</dt>
<dd>Specifies a target value that is ignored and does not contribute to the input gradient. It's an optional value.</dd>
<dt><tt>reduction</tt> : string (default is mean)</dt>
<dd>Type of reduction to apply to loss: none, sum, mean(default). 'none': no reduction will be applied, 'sum': the output will be summed. 'mean': the sum of the output will be divided by the number of elements in the output.</dd>
</dl>

#### Inputs (2 - 3)

<dl>
<dt><tt>scores</tt> : T</dt>
<dd>The predicted outputs with shape [batch_size, class_size], or [batch_size, class_size, D1, D2 , ..., Dk], where K is the number of dimensions.</dd>
<dt><tt>labels</tt> : Tind</dt>
<dd>The ground truth output tensor, with shape [batch_size], or [batch_size, D1, D2, ..., Dk], where K is the number of dimensions. Labels element value shall be in range of [0, C). If ignore_index is specified, it may have a value outside [0, C) and the label values should either be in the range [0, C) or have the value ignore_index.</dd>
<dt><tt>weights</tt> (optional) : T</dt>
<dd>A manual rescaling weight given to each class. If given, it has to be a 1D Tensor assigning weight to each of the classes. Otherwise, it is treated as if having all ones.</dd>
</dl>

#### Outputs (1 - 2)

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Weighted loss float Tensor. If reduction is 'none', this has the shape of [batch_size], or [batch_size, D1, D2, ..., Dk] in case of K-dimensional loss. Otherwise, it is a scalar.</dd>
<dt><tt>log_prob</tt> (optional) : T</dt>
<dd>Log probability tensor. If the output of softmax is prob, its value is log(prob).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>Tind</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain target to integer types</dd>
</dl>

## Version 13 of the default ONNX operator set
### <a name="Abs-13"></a>**Abs-13**</a>

  Absolute takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the absolute is, y = abs(x), is applied to
  the tensor elementwise.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to all numeric tensors.</dd>
</dl>

### <a name="Add-13"></a>**Add-13**</a>

  Performs element-wise binary addition (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> (differentiable) : T</dt>
<dd>First operand.</dd>
<dt><tt>B</tt> (differentiable) : T</dt>
<dd>Second operand.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> (differentiable) : T</dt>
<dd>Result, has same element type as two inputs</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="ArgMax-13"></a>**ArgMax-13**</a>

  Computes the indices of the max elements of the input tensor's element along the
  provided axis. The resulting tensor has the same rank as the input if keepdims equals 1.
  If keepdims equals 0, then the resulting tensor has the reduced dimension pruned.
  If select_last_index is True (default False), the index of the last occurrence of the max
  is selected if the max appears more than once in the input. Otherwise the index of the
  first occurrence is selected.
  The type of the output tensor is integer.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 0)</dt>
<dd>The axis in which to compute the arg indices. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
<dt><tt>select_last_index</tt> : int (default is 0)</dt>
<dd>Whether to select the last index or the first index if the {name} appears in multiple indices, default is False (first index).</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> (non-differentiable) : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> (non-differentiable) : tensor(int64)</dt>
<dd>Reduced output tensor with integer data type.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to all numeric tensors.</dd>
</dl>

### <a name="ArgMin-13"></a>**ArgMin-13**</a>

  Computes the indices of the min elements of the input tensor's element along the
  provided axis. The resulting tensor has the same rank as the input if keepdims equals 1.
  If keepdims equals 0, then the resulting tensor has the reduced dimension pruned.
  If select_last_index is True (default False), the index of the last occurrence of the min
  is selected if the min appears more than once in the input. Otherwise the index of the
  first occurrence is selected.
  The type of the output tensor is integer.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 0)</dt>
<dd>The axis in which to compute the arg indices. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
<dt><tt>select_last_index</tt> : int (default is 0)</dt>
<dd>Whether to select the last index or the first index if the {name} appears in multiple indices, default is False (first index).</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> (non-differentiable) : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> (non-differentiable) : tensor(int64)</dt>
<dd>Reduced output tensor with integer data type.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to all numeric tensors.</dd>
</dl>

### <a name="Cast-13"></a>**Cast-13**</a>

  The operator casts the elements of a given input tensor to a data type
  specified by the 'to' argument and returns an output tensor of the same size in
  the converted type. The 'to' argument must be one of the data types specified
  in the 'DataType' enum field in the TensorProto message.

  Casting from string tensor in plain (e.g., "3.14" and "1000") and scientific numeric representations
  (e.g., "1e-5" and "1E8") to float types is supported. For example, converting string "100.5" to an integer may
  result 100. There are some string literals reserved for special floating-point values;
  "+INF" (and "INF"), "-INF", and "NaN" are positive infinity, negative infinity, and not-a-number, respectively.
  Any string which can exactly match "+INF" in a case-insensitive way would be mapped to positive infinite. Similarly,
  this case-insensitive rule is applied to "INF" and "NaN". When casting from numeric tensors
  to string tensors, plain floating-point representation (such as "314.15926") would be used.
  Converting non-numerical-literal string such as "Hello World!" is an undefined behavior. Cases
  of converting string representing floating-point arithmetic value, such as "2.718", to INT is an undefined behavior.

  Conversion from a numerical type to any numerical type is always allowed.
  User must be aware of precision loss and value change caused by range difference between two types.
  For example, a 64-bit float 3.1415926459 may be round to a 32-bit float 3.141592. Similarly, converting
  an integer 36 to Boolean may produce 1 because we truncate bits which can't be stored in the targeted type.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>to</tt> : int (required)</dt>
<dd>The data type to which the elements of the input tensor are cast. Strictly must be one of the types from DataType enum in TensorProto</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T1</dt>
<dd>Input tensor to be cast.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T2</dt>
<dd>Output tensor with the same shape as input with type specified by the 'to' argument</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float16), tensor(float), tensor(double), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(bool), tensor(string), tensor(bfloat16)</dt>
<dd>Constrain input types. Casting from complex is not supported.</dd>
<dt><tt>T2</tt> : tensor(float16), tensor(float), tensor(double), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(bool), tensor(string), tensor(bfloat16)</dt>
<dd>Constrain output types. Casting to complex is not supported.</dd>
</dl>

### <a name="Ceil-13"></a>**Ceil-13**</a>

  Ceil takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the ceil is, y = ceil(x), is applied to
  the tensor elementwise.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> (non-differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (non-differentiable) : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Clip-13"></a>**Clip-13**</a>

  Clip operator limits the given input within an interval. The interval is
  specified by the inputs 'min' and 'max'. They default to
  numeric_limits::lowest() and numeric_limits::max(), respectively.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs (1 - 3)

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Input tensor whose elements to be clipped</dd>
<dt><tt>min</tt> (optional, non-differentiable) : T</dt>
<dd>Minimum value, under which element is replaced by min. It must be a scalar(tensor of empty shape).</dd>
<dt><tt>max</tt> (optional, non-differentiable) : T</dt>
<dd>Maximum value, above which element is replaced by max. It must be a scalar(tensor of empty shape).</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>Output tensor with clipped input elements</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to all numeric tensors.</dd>
</dl>

### <a name="Concat-13"></a>**Concat-13**</a>

  Concatenate a list of tensors into a single tensor. All input tensors must have the same shape, except for the dimension size of the axis to concatenate on.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (required)</dt>
<dd>Which axis to concat on. A negative value means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(inputs)..</dd>
</dl>

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>inputs</tt> (variadic, differentiable) : T</dt>
<dd>List of tensors for concatenation</dd>
</dl>

#### Outputs

<dl>
<dt><tt>concat_result</tt> (differentiable) : T</dt>
<dd>Concatenated tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain output types to any tensor type.</dd>
</dl>

### <a name="Constant-13"></a>**Constant-13**</a>

  This operator produces a constant tensor. Exactly one of the provided attributes, either value, sparse_value,
  or value_* must be specified.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>sparse_value</tt> : sparse_tensor</dt>
<dd>The value for the elements of the output tensor in sparse format.</dd>
<dt><tt>value</tt> : tensor</dt>
<dd>The value for the elements of the output tensor.</dd>
<dt><tt>value_float</tt> : float</dt>
<dd>The value for the sole element for the scalar, float32, output tensor.</dd>
<dt><tt>value_floats</tt> : list of floats</dt>
<dd>The values for the elements for the 1D, float32, output tensor.</dd>
<dt><tt>value_int</tt> : int</dt>
<dd>The value for the sole element for the scalar, int64, output tensor.</dd>
<dt><tt>value_ints</tt> : list of ints</dt>
<dd>The values for the elements for the 1D, int64, output tensor.</dd>
<dt><tt>value_string</tt> : string</dt>
<dd>The value for the sole element for the scalar, UTF-8 string, output tensor.</dd>
<dt><tt>value_strings</tt> : list of strings</dt>
<dd>The values for the elements for the 1D, UTF-8 string, output tensor.</dd>
</dl>

#### Inputs


#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Output tensor containing the same value of the provided tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

### <a name="DepthToSpace-13"></a>**DepthToSpace-13**</a>

  DepthToSpace rearranges (permutes) data from depth into blocks of spatial data.
  This is the reverse transformation of SpaceToDepth. More specifically, this op outputs a copy of
  the input tensor where values from the depth dimension are moved in spatial blocks to the height
  and width dimensions. By default, `mode` = `DCR`.
  In the DCR mode, elements along the depth dimension from the input tensor are rearranged in the
  following order: depth, column, and then row. The output y is computed from the input x as below:

  b, c, h, w = x.shape

  tmp = np.reshape(x, [b, blocksize, blocksize, c // (blocksize**2), h, w])

  tmp = np.transpose(tmp, [0, 3, 4, 1, 5, 2])

  y = np.reshape(tmp, [b, c // (blocksize**2), h * blocksize, w * blocksize])


  In the CRD mode, elements along the depth dimension from the input tensor are rearranged in the
  following order: column, row, and the depth. The output y is computed from the input x as below:

  b, c, h, w = x.shape

  tmp = np.reshape(x, [b, c // (blocksize ** 2), blocksize, blocksize, h, w])

  tmp = np.transpose(tmp, [0, 1, 4, 2, 5, 3])

  y = np.reshape(tmp, [b, c // (blocksize ** 2), h * blocksize, w * blocksize])


#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>blocksize</tt> : int (required)</dt>
<dd>Blocks of [blocksize, blocksize] are moved.</dd>
<dt><tt>mode</tt> : string (default is DCR)</dt>
<dd>DCR (default) for depth-column-row order re-arrangement. Use CRD for column-row-depth order.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Input tensor of [N,C,H,W], where N is the batch axis, C is the channel or depth, H is the height and W is the width.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>Output tensor of [N, C/(blocksize * blocksize), H * blocksize, W * blocksize].</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

### <a name="DequantizeLinear-13"></a>**DequantizeLinear-13**</a>

  The linear dequantization operator. It consumes a quantized tensor, a scale, and a zero point to compute the full precision tensor.
  The dequantization formula is y = (x - x_zero_point) * x_scale. 'x_scale' and 'x_zero_point' must have same shape, and can be either a scalar
  for per-tensor / per layer quantization, or a 1-D tensor for per-axis quantization.
  'x_zero_point' and 'x' must have same type. 'x' and 'y' must have same shape. In the case of dequantizing int32,
  there's no zero point (zero point is supposed to be 0).

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 1)</dt>
<dd>(Optional) The axis of the dequantizing dimension of the input tensor. Ignored for per-tensor quantization. Negative value means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(input).</dd>
</dl>

#### Inputs (2 - 3)

<dl>
<dt><tt>x</tt> : T</dt>
<dd>N-D quantized input tensor to be de-quantized.</dd>
<dt><tt>x_scale</tt> : tensor(float)</dt>
<dd>Scale for input 'x'. It can be a scalar, which means a per-tensor/layer dequantization, or a 1-D tensor for per-axis dequantization.</dd>
<dt><tt>x_zero_point</tt> (optional) : T</dt>
<dd>Zero point for input 'x'. Shape must match x_scale. It's optional. Zero point is 0 when it's not specified.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>y</tt> : tensor(float)</dt>
<dd>N-D full precision output tensor. It has same shape as input 'x'.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(int8), tensor(uint8), tensor(int32)</dt>
<dd>Constrain 'x_zero_point' and 'x' to 8-bit/32-bit integer tensor.</dd>
</dl>

### <a name="Div-13"></a>**Div-13**</a>

  Performs element-wise binary division (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> (differentiable) : T</dt>
<dd>First operand.</dd>
<dt><tt>B</tt> (differentiable) : T</dt>
<dd>Second operand.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> (differentiable) : T</dt>
<dd>Result, has same element type as two inputs</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="Dropout-13"></a>**Dropout-13**</a>

  Dropout takes an input floating-point tensor, an optional input ratio (floating-point scalar) and an optional input training_mode (boolean scalar). It produces two tensor outputs,
  output (floating-point tensor) and mask (optional `Tensor<bool>`). If `training_mode` is true then the output Y will be a random dropout;
  Note that this Dropout scales the masked input data by the following equation, so to convert the trained model into inference mode,
  the user can simply not pass `training_mode` input or set it to false.
  ```
  output = scale * data * mask,
  ```
  where
  ```
  scale = 1. / (1. - ratio).
  ```
  This operator has **optional** inputs/outputs. See [the doc](IR.md) for more details about the representation of optional arguments. An empty string may be used in the place of an actual argument's name to indicate a missing argument. Trailing optional arguments (those not followed by an argument that is present) may also be simply omitted.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>seed</tt> : int</dt>
<dd>(Optional) Seed to the random generator, if not specified we will auto generate one.</dd>
</dl>

#### Inputs (1 - 3)

<dl>
<dt><tt>data</tt> (differentiable) : T</dt>
<dd>The input data as Tensor.</dd>
<dt><tt>ratio</tt> (optional, non-differentiable) : T1</dt>
<dd>The ratio of random dropout, with value in [0, 1). If this input was not set, or if it was set to 0, the output would be a simple copy of the input. If it's non-zero, output will be a random dropout of the scaled input, which is typically the case during training. It is an optional value, if not specified it will default to 0.5.</dd>
<dt><tt>training_mode</tt> (optional, non-differentiable) : T2</dt>
<dd>If set to true then it indicates dropout is being used for training. It is an optional value hence unless specified explicitly, it is false. If it is false, ratio is ignored and the operation mimics inference mode where nothing will be dropped from the input data and if mask is requested as output it will contain all ones.</dd>
</dl>

#### Outputs (1 - 2)

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>The output.</dd>
<dt><tt>mask</tt> (optional, non-differentiable) : T2</dt>
<dd>The output mask.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T1</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input 'ratio' types to float tensors.</dd>
<dt><tt>T2</tt> : tensor(bool)</dt>
<dd>Constrain output 'mask' types to boolean tensors.</dd>
</dl>

### <a name="Equal-13"></a>**Equal-13**</a>

  Returns the tensor resulted from performing the `equal` logical operation
  elementwise on the input tensors `A` and `B` (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> (non-differentiable) : T</dt>
<dd>First input operand for the logical operator.</dd>
<dt><tt>B</tt> (non-differentiable) : T</dt>
<dd>Second input operand for the logical operator.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> (non-differentiable) : T1</dt>
<dd>Result tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(bool), tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input types to all numeric tensors.</dd>
<dt><tt>T1</tt> : tensor(bool)</dt>
<dd>Constrain output to boolean tensor.</dd>
</dl>

### <a name="Erf-13"></a>**Erf-13**</a>

  Computes the error function of the given input tensor element-wise.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>The error function of the input tensor computed element-wise. It has the same shape and type of the input.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to all numeric tensors.</dd>
</dl>

### <a name="Exp-13"></a>**Exp-13**</a>

  Calculates the exponential of the given input tensor, element-wise.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>The exponential of the input tensor computed element-wise</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Expand-13"></a>**Expand-13**</a>

  Broadcast the input tensor following the given shape and the broadcast rule.
  The broadcast rule is similar to numpy.array(input) * numpy.ones(shape):
  Dimensions are right alignment;
  Two corresponding dimensions must have the same value, or one of them is equal to 1.
  Also, this operator is similar to numpy.broadcast_to(input, shape),
  but the major difference is numpy.broadcast_to() does not allow shape to be smaller than input.size().
  It is possible that the output.shape is not equal to shape, when some dimensions in shape is equal to 1,
  or the shape.ndim < input.shape.ndim.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
<dt><tt>shape</tt> (non-differentiable) : tensor(int64)</dt>
<dd>A 1-D tensor indicates the shape you want to expand to, following the broadcast rule</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensors.</dd>
</dl>

### <a name="Flatten-13"></a>**Flatten-13**</a>

  Flattens the input tensor into a 2D matrix. If input tensor has shape
  (d_0, d_1, ... d_n) then the output will have shape
  (d_0 X d_1 ... d_(axis-1), d_axis X d_(axis+1) ... X dn).

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 1)</dt>
<dd>Indicate up to which input dimensions (exclusive) should be flattened to the outer dimension of the output. The value for axis must be in the range [-r, r], where r is the rank of the input tensor. Negative value means counting dimensions from the back. When axis = 0, the shape of the output tensor is (1, (d_0 X d_1 ... d_n), where the shape of the input tensor is (d_0, d_1, ... d_n). </dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>A tensor of rank >= axis.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>A 2D tensor with the contents of the input tensor, with input dimensions up to axis flattened to the outer dimension of the output and remaining input dimensions flattened into the inner dimension of the output.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output to all tensor types.</dd>
</dl>

### <a name="Floor-13"></a>**Floor-13**</a>

  Floor takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the floor is, y = floor(x), is applied to
  the tensor elementwise.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> (non-differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (non-differentiable) : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Gather-13"></a>**Gather-13**</a>

  Given `data` tensor of rank r >= 1, and `indices` tensor of rank q, gather
  entries of the axis dimension of `data` (by default outer-most one as axis=0) indexed by `indices`, and concatenates
  them in an output tensor of rank q + (r - 1).

  axis = 0 :

  Let
  k = indices[i_{0}, ..., i_{q-1}]
  Then
  output[i_{0}, ..., i_{q-1}, j_{0}, ..., j_{r-2}] = input[k , j_{0}, ..., j_{r-2}]

  ```
    data = [
        [1.0, 1.2],
        [2.3, 3.4],
        [4.5, 5.7],
    ]
    indices = [
        [0, 1],
        [1, 2],
    ]
    output = [
        [
            [1.0, 1.2],
            [2.3, 3.4],
        ],
        [
            [2.3, 3.4],
            [4.5, 5.7],
        ],
    ]
  ```
  axis = 1 :

  Let
  k = indices[i_{0}, ..., i_{q-1}]
  Then
  output[j_{0}, i_{0}, ..., i_{q-1}, j_{1}, ..., j_{r-2}] = input[j_{0}, k, j_{1}, ..., j_{r-2}]

  ```
    data = [
        [1.0, 1.2, 1.9],
        [2.3, 3.4, 3.9],
        [4.5, 5.7, 5.9],
    ]
    indices = [
        [0, 2],
    ]
    axis = 1,
    output = [
            [[1.0, 1.9]],
            [[2.3, 3.9]],
            [[4.5, 5.9]],
    ]
  ```

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 0)</dt>
<dd>Which axis to gather on. Negative value means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(data).</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> (differentiable) : T</dt>
<dd>Tensor of rank r >= 1.</dd>
<dt><tt>indices</tt> (non-differentiable) : Tind</dt>
<dd>Tensor of int32/int64 indices, of any rank q. All index values are expected to be within bounds [-s, s-1] along axis of size s. It is an error if any of the index values are out of bounds.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>Tensor of rank q + (r - 1).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to any tensor type.</dd>
<dt><tt>Tind</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain indices to integer types</dd>
</dl>

### <a name="GatherElements-13"></a>**GatherElements-13**</a>

  GatherElements takes two inputs `data` and `indices` of the same rank r >= 1
  and an optional attribute `axis` that identifies an axis of `data`
  (by default, the outer-most axis, that is axis 0). It is an indexing operation
  that produces its output by indexing into the input data tensor at index
  positions determined by elements of the `indices` tensor.
  Its output shape is the same as the shape of `indices` and consists of one value
  (gathered from the `data`) for each element in `indices`.

  For instance, in the 3-D case (r = 3), the output produced is determined
  by the following equations:
  ```
    out[i][j][k] = input[index[i][j][k]][j][k] if axis = 0,
    out[i][j][k] = input[i][index[i][j][k]][k] if axis = 1,
    out[i][j][k] = input[i][j][index[i][j][k]] if axis = 2,
  ```

  This operator is also the inverse of ScatterElements. It is similar to Torch's gather operation.

  Example 1:
  ```
    data = [
        [1, 2],
        [3, 4],
    ]
    indices = [
        [0, 0],
        [1, 0],
    ]
    axis = 1
    output = [
        [1, 1],
        [4, 3],
    ]
  ```
  Example 2:
  ```
    data = [
        [1, 2, 3],
        [4, 5, 6],
        [7, 8, 9],
    ]
    indices = [
        [1, 2, 0],
        [2, 0, 0],
    ]
    axis = 0
    output = [
        [4, 8, 3],
        [7, 2, 3],
    ]
  ```

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 0)</dt>
<dd>Which axis to gather on. Negative value means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(data).</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> (differentiable) : T</dt>
<dd>Tensor of rank r >= 1.</dd>
<dt><tt>indices</tt> (non-differentiable) : Tind</dt>
<dd>Tensor of int32/int64 indices, with the same rank r as the input. All index values are expected to be within bounds [-s, s-1] along axis of size s. It is an error if any of the index values are out of bounds.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>Tensor of the same shape as indices.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to any tensor type.</dd>
<dt><tt>Tind</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain indices to integer types</dd>
</dl>

### <a name="GatherND-13"></a>**GatherND-13**</a>

  Given `data` tensor of rank `r` >= 1, `indices` tensor of rank `q` >= 1, and `batch_dims` integer `b`, this operator gathers
  slices of `data` into an output tensor of rank `q + r - indices_shape[-1] - 1 - b`.

  `indices` is an q-dimensional integer tensor, best thought of as a `(q-1)`-dimensional tensor of index-tuples into `data`,
  where each element defines a slice of `data`

  `batch_dims` (denoted as `b`) is an integer indicating the number of batch dimensions, i.e the leading `b` number of dimensions of
  `data` tensor and `indices` are representing the batches, and the gather starts from the `b+1` dimension.

  Some salient points about the inputs' rank and shape:

  1) r >= 1 and q >= 1 are to be honored. There is no dependency condition to be met between ranks `r` and `q`

  2) The first `b` dimensions of the shape of `indices` tensor and `data` tensor must be equal.

  3) b < min(q, r) is to be honored.

  4) The `indices_shape[-1]` should have a value between 1 (inclusive) and rank `r-b` (inclusive)

  5) All values in `indices` are expected to be within bounds [-s, s-1] along axis of size `s` (i.e.) `-data_shape[i] <= indices[...,i] <= data_shape[i] - 1`.
     It is an error if any of the index values are out of bounds.

  The output is computed as follows:

  The output tensor is obtained by mapping each index-tuple in the `indices` tensor to the corresponding slice of the input `data`.

  1) If `indices_shape[-1] > r-b` => error condition

  2) If `indices_shape[-1] == r-b`, since the rank of `indices` is `q`, `indices` can be thought of as `N` `(q-b-1)`-dimensional tensors
     containing 1-D tensors of dimension `r-b`, where `N` is an integer equals to the product of 1 and all the elements in the batch dimensions
     of the indices_shape. Let us think of each such `r-b` ranked tensor as `indices_slice`. Each *scalar value* corresponding to `data[0:b-1,indices_slice]`
     is filled into the corresponding location of the `(q-b-1)`-dimensional tensor to form the `output` tensor (Example 1 below)

  3) If `indices_shape[-1] < r-b`, since the rank of `indices` is `q`, `indices` can be thought of as `N` `(q-b-1)`-dimensional tensor
     containing 1-D tensors of dimension `< r-b`. Let us think of each such tensors as `indices_slice`. Each *tensor slice* corresponding
     to `data[0:b-1, indices_slice , :]` is filled into the corresponding location of the `(q-b-1)`-dimensional tensor
     to form the `output` tensor (Examples 2, 3, 4 and 5 below)

  This operator is the inverse of `ScatterND`.

  `Example 1`

    batch_dims = 0

    data    = [[0,1],[2,3]]   # data_shape = [2, 2]

    indices = [[0,0],[1,1]]   # indices_shape = [2, 2]

    output  = [0,3]           # output_shape = [2]

  `Example 2`

    batch_dims = 0

    data    = [[0,1],[2,3]]  # data_shape = [2, 2]

    indices = [[1],[0]]      # indices_shape = [2, 1]

    output  = [[2,3],[0,1]]  # output_shape = [2, 2]

  `Example 3`

    batch_dims = 0

    data    = [[[0,1],[2,3]],[[4,5],[6,7]]] # data_shape = [2, 2, 2]

    indices = [[0,1],[1,0]]                 # indices_shape = [2, 2]

    output  = [[2,3],[4,5]]                 # output_shape = [2, 2]

  `Example 4`

    batch_dims = 0

    data    = [[[0,1],[2,3]],[[4,5],[6,7]]] # data_shape = [2, 2, 2]

    indices = [[[0,1]],[[1,0]]]             # indices_shape = [2, 1, 2]

    output  = [[[2,3]],[[4,5]]]             # output_shape = [2, 1, 2]

  `Example 5`

    batch_dims = 1

    data    = [[[0,1],[2,3]],[[4,5],[6,7]]] # data_shape = [2, 2, 2]

    indices = [[1],[0]]             # indices_shape = [2, 1]

    output  = [[2,3],[4,5]]             # output_shape = [2, 2]



#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>batch_dims</tt> : int (default is 0)</dt>
<dd>The number of batch dimensions. The gather of indexing starts from dimension of data[batch_dims:]</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> (differentiable) : T</dt>
<dd>Tensor of rank r >= 1.</dd>
<dt><tt>indices</tt> (non-differentiable) : tensor(int64)</dt>
<dd>Tensor of rank q >= 1. All index values are expected to be within bounds [-s, s-1] along axis of size s. It is an error if any of the index values are out of bounds.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>Tensor of rank q + r - indices_shape[-1] - 1.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to any tensor type.</dd>
</dl>

### <a name="Gemm-13"></a>**Gemm-13**</a>

  General Matrix multiplication:
  https://en.wikipedia.org/wiki/Basic_Linear_Algebra_Subprograms#Level_3

  A' = transpose(A) if transA else A

  B' = transpose(B) if transB else B

  Compute Y = alpha * A' * B' + beta * C, where input tensor A has shape (M, K) or (K, M),
  input tensor B has shape (K, N) or (N, K), input tensor C is broadcastable to shape (M, N),
  and output tensor Y has shape (M, N). A will be transposed before doing the
  computation if attribute transA is non-zero, same for B and transB.
  This operator supports **unidirectional broadcasting** (tensor C should be unidirectional broadcastable to tensor A * B); for more details please check [the doc](Broadcasting.md).
  This operator has **optional** inputs/outputs. See [the doc](IR.md) for more details about the representation of optional arguments. An empty string may be used in the place of an actual argument's name to indicate a missing argument. Trailing optional arguments (those not followed by an argument that is present) may also be simply omitted.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float (default is 1.0)</dt>
<dd>Scalar multiplier for the product of input tensors A * B.</dd>
<dt><tt>beta</tt> : float (default is 1.0)</dt>
<dd>Scalar multiplier for input tensor C.</dd>
<dt><tt>transA</tt> : int (default is 0)</dt>
<dd>Whether A should be transposed</dd>
<dt><tt>transB</tt> : int (default is 0)</dt>
<dd>Whether B should be transposed</dd>
</dl>

#### Inputs (2 - 3)

<dl>
<dt><tt>A</tt> (differentiable) : T</dt>
<dd>Input tensor A. The shape of A should be (M, K) if transA is 0, or (K, M) if transA is non-zero.</dd>
<dt><tt>B</tt> (differentiable) : T</dt>
<dd>Input tensor B. The shape of B should be (K, N) if transB is 0, or (N, K) if transB is non-zero.</dd>
<dt><tt>C</tt> (optional, differentiable) : T</dt>
<dd>Optional input tensor C. If not specified, the computation is done as if C is a scalar 0. The shape of C should be unidirectional broadcastable to (M, N).</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output tensor of shape (M, N).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float/int tensors.</dd>
</dl>

### <a name="Greater-13"></a>**Greater-13**</a>

  Returns the tensor resulted from performing the `greater` logical operation
  elementwise on the input tensors `A` and `B` (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> (non-differentiable) : T</dt>
<dd>First input operand for the logical operator.</dd>
<dt><tt>B</tt> (non-differentiable) : T</dt>
<dd>Second input operand for the logical operator.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> (non-differentiable) : T1</dt>
<dd>Result tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input types to all numeric tensors.</dd>
<dt><tt>T1</tt> : tensor(bool)</dt>
<dd>Constrain output to boolean tensor.</dd>
</dl>

### <a name="Hardmax-13"></a>**Hardmax-13**</a>

  The operator computes the hardmax values for the given input:

   Hardmax(element in input, axis) = 1 if the element is the first maximum value along the specified axis, 0 otherwise

  The "axis" attribute indicates the dimension along which Hardmax
  will be performed. The output tensor has the same shape
  and contains the Hardmax values of the corresponding input.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is -1)</dt>
<dd>
Describes the dimension Hardmax will be performed on.
Negative value means counting dimensions
from the back. Accepted range is [-r, r-1] where r = rank(input).
</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>The input tensor of rank >= axis.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>The output values with the same shape as the input tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Identity-13"></a>**Identity-13**</a>

  Identity operator

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>Tensor to copy input into.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

### <a name="If-13"></a>**If-13**</a>

  If conditional

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>else_branch</tt> : graph (required)</dt>
<dd>Graph to run if condition is false. Has N outputs: values you wish to be live-out to the enclosing scope. The number of outputs must match the number of outputs in the then_branch.</dd>
<dt><tt>then_branch</tt> : graph (required)</dt>
<dd>Graph to run if condition is true. Has N outputs: values you wish to be live-out to the enclosing scope. The number of outputs must match the number of outputs in the else_branch.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>cond</tt> : B</dt>
<dd>Condition for the if</dd>
</dl>

#### Outputs (1 - &#8734;)

<dl>
<dt><tt>outputs</tt> (variadic, heterogeneous) : V</dt>
<dd>Values that are live-out to the enclosing scope. The return values in the `then_branch` and `else_branch` must be of the same data type. The `then_branch` and `else_branch` may produce tensors with the same element type and different shapes. If corresponding outputs from the then-branch and the else-branch have static shapes S1 and S2, then the shape of the corresponding output variable of the if-node (if present) must be compatible with both S1 and S2 as it represents the union of both possible shapes.For example, if in a model file, the the first output of `then_branch` is typed float tensor with shape [2] and the first output of `else_branch` is another float tensor with shape [3], If's first output should have (a) no shape set, or (b) a shape of rank 1 with neither `dim_value` nor `dim_param` set, or (c) a shape of rank 1 with a unique `dim_param`. In contrast, the first output cannot have the shape [2] since [2] and [3] are not compatible.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>V</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128), seq(tensor(uint8)), seq(tensor(uint16)), seq(tensor(uint32)), seq(tensor(uint64)), seq(tensor(int8)), seq(tensor(int16)), seq(tensor(int32)), seq(tensor(int64)), seq(tensor(float16)), seq(tensor(float)), seq(tensor(double)), seq(tensor(string)), seq(tensor(bool)), seq(tensor(complex64)), seq(tensor(complex128))</dt>
<dd>All Tensor and Sequence types</dd>
<dt><tt>B</tt> : tensor(bool)</dt>
<dd>Only bool</dd>
</dl>

### <a name="IsNaN-13"></a>**IsNaN-13**</a>

  Returns which elements of the input are NaN.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> (non-differentiable) : T1</dt>
<dd>input</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (non-differentiable) : T2</dt>
<dd>output</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input types to float tensors.</dd>
<dt><tt>T2</tt> : tensor(bool)</dt>
<dd>Constrain output types to boolean tensors.</dd>
</dl>

### <a name="LRN-13"></a>**LRN-13**</a>

  Local Response Normalization proposed in the [AlexNet paper](https://papers.nips.cc/paper/4824-imagenet-classification-with-deep-convolutional-neural-networks.pdf).
  It normalizes over local input regions.
  The local region is defined across the channels. For an element X[n, c, d1, ..., dk] in a tensor
  of shape (N x C x D1 x D2, ..., Dk), its region is
  {X[n, i, d1, ..., dk] | max(0, c - floor((size - 1) / 2)) <= i <= min(C - 1, c + ceil((size - 1) / 2))}.

  square_sum[n, c, d1, ..., dk] = sum(X[n, i, d1, ..., dk] ^ 2),
  where max(0, c - floor((size - 1) / 2)) <= i <= min(C - 1, c + ceil((size - 1) / 2)).

  Y[n, c, d1, ..., dk] = X[n, c, d1, ..., dk] / (bias + alpha / size * square_sum[n, c, d1, ..., dk] ) ^ beta

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float (default is 0.0001)</dt>
<dd>Scaling parameter.</dd>
<dt><tt>beta</tt> : float (default is 0.75)</dt>
<dd>The exponent.</dd>
<dt><tt>bias</tt> : float (default is 1.0)</dt>
<dd></dd>
<dt><tt>size</tt> : int (required)</dt>
<dd>The number of channels to sum over</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input data tensor from the previous operator; dimensions for image case are (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data. For non image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size. Optionally, if dimension denotation is in effect, the operation expects the input data tensor to arrive with the dimension denotation of [DATA_BATCH, DATA_CHANNEL, DATA_FEATURE, DATA_FEATURE ...].</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output tensor, which has the shape and type as input tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output  types to float tensors.</dd>
</dl>

### <a name="Less-13"></a>**Less-13**</a>

  Returns the tensor resulted from performing the `less` logical operation
  elementwise on the input tensors `A` and `B` (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> (non-differentiable) : T</dt>
<dd>First input operand for the logical operator.</dd>
<dt><tt>B</tt> (non-differentiable) : T</dt>
<dd>Second input operand for the logical operator.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> (non-differentiable) : T1</dt>
<dd>Result tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input types to all numeric tensors.</dd>
<dt><tt>T1</tt> : tensor(bool)</dt>
<dd>Constrain output to boolean tensor.</dd>
</dl>

### <a name="Log-13"></a>**Log-13**</a>

  Calculates the natural log of the given input tensor, element-wise.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>The natural log of the input tensor computed element-wise</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="LogSoftmax-13"></a>**LogSoftmax-13**</a>

  The operator computes the log of softmax values for the given input:

   LogSoftmax(input, axis) = Log(Softmax(input, axis=axis))

  The "axis" attribute indicates the dimension along which LogSoftmax
  will be performed. The output tensor has the same shape
  and contains the LogSoftmax values of the corresponding input.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is -1)</dt>
<dd>
Describes the dimension LogSoftmax will be performed on.
Negative value means counting dimensions
from the back. Accepted range is [-r, r-1] where r = rank(input).
</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>The input tensor of rank >= axis.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>The output values with the same shape as the input tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Loop-13"></a>**Loop-13**</a>

  Generic Looping construct. This loop has multiple termination conditions:

  1) Trip count. Iteration count specified at runtime. Set by
     specifying the input M. Optional. Set to empty string to omit.
     Note that a static trip count (specified at graph construction time) can be
     specified by passing in a constant node for input M.
  2) Loop termination condition. This is an input to the op that determines
     whether to run the first iteration and also a loop-carried dependency for
     the body graph. The body graph must yield a value for the condition variable,
     whether this input is provided or not.

  This table summarizes the operating modes of this operator with equivalent
  C-style code:

      Operator inputs defined as (max_trip_count, condition_var).

      input ("", ""):
          for (int i=0; ; ++i) {
            cond = ... // Note this value is ignored, but is required in the body
          }

      input ("", cond) // Note this is analogous to a while loop
          bool cond = ...;
          for (int i=0; cond; ++i) {
            cond = ...;
          }

      input ("", 1) // Note this is analogous to a do-while loop
          bool cond = true
          for (int i=0; cond; ++i) {
            cond = ...;
          }

      input (trip_count, "") // Note this is analogous to a for loop
          int trip_count = ...
          for (int i=0; i < trip_count; ++i) {
            cond = ...; // ignored
          }

      input (trip_count, cond)
          int trip_count = ...;
          bool cond = ...;
          for (int i=0; i < trip_count && cond; ++i) {
            cond = ...;
          }


  *Sample usage - cond as well as trip count*

      graph predict-net {
        %a = Constant[value = <Scalar Tensor [3]>]()
        %b = Constant[value = <Scalar Tensor [6]>]()
        %keepgoing = Constant[value = <Scalar Tensor [1]>]()
        %max_trip_count = Constant[value = <Scalar Tensor [10]>]()
        %keepgoing_out, %b_out, %user_defined_vals = Loop[body = <graph body-net>](%max_trip_count, %keepgoing, %b)
        return
      }

      graph body-net (
        %i[INT32, scalar]           // iteration number
        %keepgoing_in[BOOL, scalar] // incoming loop-termination-condition; not used
        %b_in[INT32, scalar]        // incoming value of loop-carried-dependency b
      ) {
        %my_local = Add(%a, %b_in)
        %b_out = Sub(%a, %b_in) // outgoing value of loop-carried-dependency b
        %keepgoing_out = Greater(%my_local, %b_out) // outgoing loop-termination-condition
        %user_defined_val = Add(%b_in, %b_in) // scan-output value to be accumulated
        return %keepgoing_out, %b_out, %user_defined_val
      }

  *Sample equivalent C code*

      {
        /* User-defined code (enclosing scope) */
        int a = 3, b = 6;
        bool keepgoing = true; // Analogous to input cond
        /* End user-defined code */

        /* Implicitly-defined code */
        const int max_trip_count = 10; // Analogous to input M
        int user_defined_vals[]; // Imagine this is resizable
        /* End implicitly-defined code */
        /* initialize loop-carried variables and scan-output variables */
        bool keepgoing_out = keepgoing
        int b_out = b

        for (int i=0; i < max_trip_count && keepgoing_out; ++i) {
          /* Implicitly-defined code: bind actual parameter values
             to formal parameter variables of loop-body */
          bool keepgoing_in = keepgoing_out;
          bool b_in = b_out;

          /* User-defined code (loop body) */
          int my_local = a + b_in; // Reading value "a" from the enclosing scope is fine
          b_out = a - b_in;
          keepgoing_out = my_local > b_out;
          user_defined_val = b_in + b_in; // b_in and b_out are different variables
          /* End user-defined code */

          /* Implicitly defined-code */
          user_defined_vals[i] = user_defined_val // accumulate scan-output values
        }
        // int t = my_local; // Can't do this. my_local is not accessible here.

        // The values below are bound to the output variables of the loop and therefore accessible
        // b_out; user_defined_vals; keepgoing_out;
      }

  There are several things of note in this code snippet:

  1) Values from the enclosing scope (i.e. variable "a" here) are in scope and can
     be referenced in the inputs of the loop.
  2) Any values computed in the loop body that needs to be used in a subsequent
     iteration or after the loop are modelled using a pair of variables in the loop-body,
     consisting of an input variable (eg., b_in) and an output variable (eg., b_out).
     These are referred to as loop-carried dependences. The loop operation node
     supplies the input value of the input variable for the first iteration, and
     returns the output value of the output variable produced by the final
     iteration.
  3) Scan_output variables are used to implicitly concatenate values computed across
     all the iterations. In the above example, the value of user_defined_val computed
     over all iterations are concatenated and returned as the value of user_defined_vals
     after the loop.
  4) Values created in the body cannot be accessed in the enclosing scope,
     except using the mechanism described above.

  Note that the semantics of this op support "diagonal" or "wavefront" execution.
  (See Step 3 here for an example:
  https://devblogs.nvidia.com/optimizing-recurrent-neural-networks-cudnn-5/).
  Frontends should emit multi-layer RNNs as a series of While operators (with
  time being the inner looping dimension), with each successive layer consuming
  the scan_outputs from the previous layer, possibly going through several
  point-wise operators (e.g. dropout, residual connections, linear layer).

  The input/output of subgraph (produced by loop node) matching is based on order instead of name. The implementation will figure out the names based on this order.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>body</tt> : graph (required)</dt>
<dd>The graph run each iteration. It has 2+N inputs: (iteration_num, condition, loop carried dependencies...). It has 1+N+K outputs: (condition, loop carried dependencies..., scan_outputs...). Each scan_output is created by concatenating the value of the specified output value at the end of each iteration of the loop. It is an error if the dimensions or data type of these scan_outputs change across loop iterations.</dd>
</dl>

#### Inputs (2 - &#8734;)

<dl>
<dt><tt>M</tt> (optional) : I</dt>
<dd>A maximum trip-count for the loop specified at runtime. Optional. Pass empty string to skip.</dd>
<dt><tt>cond</tt> (optional) : B</dt>
<dd>A boolean termination condition. Optional. Pass empty string to skip.</dd>
<dt><tt>v_initial</tt> (variadic, heterogeneous) : V</dt>
<dd>The initial values of any loop-carried dependencies (values that change across loop iterations)</dd>
</dl>

#### Outputs (1 - &#8734;)

<dl>
<dt><tt>v_final_and_scan_outputs</tt> (variadic, heterogeneous) : V</dt>
<dd>Final N loop carried dependency values then K scan_outputs. Scan outputs must be Tensors.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>V</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128), seq(tensor(uint8)), seq(tensor(uint16)), seq(tensor(uint32)), seq(tensor(uint64)), seq(tensor(int8)), seq(tensor(int16)), seq(tensor(int32)), seq(tensor(int64)), seq(tensor(float16)), seq(tensor(float)), seq(tensor(double)), seq(tensor(string)), seq(tensor(bool)), seq(tensor(complex64)), seq(tensor(complex128))</dt>
<dd>All Tensor and Sequence types</dd>
<dt><tt>I</tt> : tensor(int64)</dt>
<dd>tensor of int64, which should be a scalar.</dd>
<dt><tt>B</tt> : tensor(bool)</dt>
<dd>tensor of bool, which should be a scalar.</dd>
</dl>

### <a name="MatMul-13"></a>**MatMul-13**</a>

  Matrix product that behaves like numpy.matmul: https://docs.scipy.org/doc/numpy-1.13.0/reference/generated/numpy.matmul.html

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> (differentiable) : T</dt>
<dd>N-dimensional matrix A</dd>
<dt><tt>B</tt> (differentiable) : T</dt>
<dd>N-dimensional matrix B</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Matrix multiply results from A * B</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float/int tensors.</dd>
</dl>

### <a name="Max-13"></a>**Max-13**</a>

  Element-wise max of each of the input tensors (with Numpy-style broadcasting support).
  All inputs and outputs must have the same data type.
  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>data_0</tt> (variadic, differentiable) : T</dt>
<dd>List of tensors for max.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>max</tt> (differentiable) : T</dt>
<dd>Output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to numeric tensors.</dd>
</dl>

### <a name="Mean-13"></a>**Mean-13**</a>

  Element-wise mean of each of the input tensors (with Numpy-style broadcasting support).
  All inputs and outputs must have the same data type.
  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>data_0</tt> (variadic, differentiable) : T</dt>
<dd>List of tensors for mean.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>mean</tt> (differentiable) : T</dt>
<dd>Output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="MeanVarianceNormalization-13"></a>**MeanVarianceNormalization-13**</a>

  A MeanVarianceNormalization Function: Perform mean variance normalization
        on the input tensor X using formula: <br/> ``` (X-EX)/sqrt(E(X-EX)^2) ```

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints (default is ['0', '2', '3'])</dt>
<dd>A list of integers, along which to reduce. The default is to caculate along axes [0,2,3] for calculating mean and variance along each channel. Two variables with the same C-coordinate are associated with the same mean and variance.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to all numeric tensors.</dd>
</dl>

### <a name="Min-13"></a>**Min-13**</a>

  Element-wise min of each of the input tensors (with Numpy-style broadcasting support).
  All inputs and outputs must have the same data type.
  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>data_0</tt> (variadic, differentiable) : T</dt>
<dd>List of tensors for min.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>min</tt> (differentiable) : T</dt>
<dd>Output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to numeric tensors.</dd>
</dl>

### <a name="Mod-13"></a>**Mod-13**</a>

  Performs element-wise binary modulus (with Numpy-style broadcasting support).
      The sign of the remainder is the same as that of the Divisor.

      Mod operator can also behave like C fmod() or numpy.fmod. In this case, the sign of the remainder however, will be the same as the Dividend
      (in contrast to integer mod). To force a behavior like numpy.fmod() an 'fmod' Attribute is provided.
      This attribute is set to 0 by default causing the behavior to be like integer mod.
      Setting this attribute to 1 causes the remainder to be calculated similar to that of numpy.fmod().

      If the input type is floating point, then `fmod` attribute must be set to 1.

      In case of dividend being zero, the results will be platform dependent.

    This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>fmod</tt> : int (default is 0)</dt>
<dd>Whether the operator should behave like fmod (default=0 meaning it will do integer mods); Set this to 1 to force fmod treatment</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> (differentiable) : T</dt>
<dd>Dividend tensor</dd>
<dt><tt>B</tt> (non-differentiable) : T</dt>
<dd>Divisor tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> (differentiable) : T</dt>
<dd>Remainder tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="Mul-13"></a>**Mul-13**</a>

  Performs element-wise binary multiplication (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> (differentiable) : T</dt>
<dd>First operand.</dd>
<dt><tt>B</tt> (differentiable) : T</dt>
<dd>Second operand.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> (differentiable) : T</dt>
<dd>Result, has same element type as two inputs</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="Neg-13"></a>**Neg-13**</a>

  Neg takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where each element flipped sign, y = -x, is applied to
  the tensor elementwise.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(int32), tensor(int8), tensor(int16), tensor(int64), tensor(float16), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to signed numeric tensors.</dd>
</dl>

### <a name="NegativeLogLikelihoodLoss-13"></a>**NegativeLogLikelihoodLoss-13**</a>

  A NegativeLogLikelihoodLoss operator computes (weighted) negative log likelihood loss.
  Its "input" tensor has the shape of (N, C, d1, d2, ..., dk) where k >= 0.
  The "input" tensor contains log-probabilities for input[n, :, d_1, d_2,..., d_k] being in a class of [0, C).
  The operator's "target" input tensor has the shape of (N, d1, d2, ..., dk). It encodes class labels (one of C classes)
  or it may contain a special value (indicated by an attribute ignore_index) for N x d1 x d2 x ... x dk samples.
  The loss value for input[n, :, d_1, d_2,...d_k] being classified as class c = target[n][d_1][d_2]...[d_k] is computed as:

      loss[n][d_1][d_2]...[d_k] = -input[n][c][d_1][d_2]...[d_k].

  When an optional "weight" is provided, the sample loss is calculated as:

      loss[n][d_1][d_2]...[d_k] = -input[n][c][d_1][d_2]...[d_k] * weight[c].

  loss is zero for the case when target-value equals ignore_index.

      loss[n][d_1][d_2]...[d_k] = 0, when target[n][d_1][d_2]...[d_k] = ignore_index

  If "reduction" attribute is set to "none", the operator's output will be the above loss with shape (N, d1, d2, ..., dk).
  If "reduction" attribute is set to "mean" (the default attribute value), the output loss is (weight) averaged:

      mean(loss), if "weight" is not provided,

  or if weight is provided,

      sum(loss) / sum(weight[target[n][d_1][d_2]...[d_k]]]), for all samples.

  If "reduction" attribute is set to "sum", the output is a scalar:
      sum(loss).

  See also https://pytorch.org/docs/stable/nn.html#torch.nn.NLLLoss.

  Example 1:

      // negative log likelihood loss, "none" reduction
      N, C, d1 = 2, 3, 2
      input = [[[1.0, 2.0], [2.0, 2.0], [3.0, 2.0]],
               [[0.0, 1.0], [2.0, 2.0], [1.0, 2]]]
      target = [[2, 1], [0, 2]]

      loss = np.zeros((N, d1))
      for n in range(N):
          for d_1 in range(d1):
              c = target[n][d_1]
              loss[n][d_1] = -input[n][c][d_1]

      // print(loss)
      // [[-3. -2.]
      //  [-0. -2.]]

  Example 2:

      // weighted negative log likelihood loss, sum reduction
      N, C, d1 = 2, 3, 2
      input = [[[1.0, 2.0], [2.0, 2.0], [3.0, 2.0]],
              [[0.0, 1.0], [2.0, 2.0], [1.0, 2]]]
      target = [[2, 1], [0, 2]]
      weight = [0.2, 0.3, 0.1]
      loss = np.zeros((N, d1))
      for n in range(N):
          for d_1 in range(d1):
              c = target[n][d_1]
              loss[n][d_1] = -input[n][c][d_1] * weight[c]

      loss = np.sum(loss)
      // print(loss)
      // -1.1

  Example 3:

      // weighted negative log likelihood loss, mean reduction
      N, C, d1 = 2, 3, 2
      input = [[[1.0, 2.0], [2.0, 2.0], [3.0, 2.0]],
              [[0.0, 1.0], [2.0, 2.0], [1.0, 2]]]
      target = [[2, 1], [0, 2]]
      weight = [0.2, 0.3, 0.1]
      loss = np.zeros((N, d1))
      weight_total = 0
      for n in range(N):
          for d_1 in range(d1):
              c = target[n][d_1]
              loss[n][d_1] = -input[n][c][d_1] * weight[c]
              weight_total = weight_total + weight[c]

      loss = np.sum(loss) / weight_total
      // print(loss)
      // -1.57

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>ignore_index</tt> : int</dt>
<dd>Specifies a target value that is ignored and does not contribute to the input gradient. It's an optional value.</dd>
<dt><tt>reduction</tt> : string (default is mean)</dt>
<dd>Type of reduction to apply to loss: none, sum, mean (default). 'none': the output is the loss for each sample. 'sum': the output will be summed. 'mean': the sum of the output will be divided by the sum of applied weights.</dd>
</dl>

#### Inputs (2 - 3)

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Input tensor of shape (N, C) or (N, C, d1, d2, ..., dk).</dd>
<dt><tt>target</tt> (non-differentiable) : Tind</dt>
<dd>Target tensor of shape (N) or (N, d1, d2, ..., dk). Target element value shall be in range of [0, C). If ignore_index is specified, it may have a value outside [0, C) and the target values should either be in the range [0, C) or have the value ignore_index.</dd>
<dt><tt>weight</tt> (optional, non-differentiable) : T</dt>
<dd>Optional rescaling weight tensor. If given, it has to be a tensor of size C. Otherwise, it is treated as if having all ones.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>loss</tt> (differentiable) : T</dt>
<dd>The negative log likelihood loss</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input, weight, and output types to floating-point tensors.</dd>
<dt><tt>Tind</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain target to integer types</dd>
</dl>

### <a name="NonZero-13"></a>**NonZero-13**</a>

  Returns the indices of the elements that are non-zero
      (in row-major order - by dimension).
      NonZero behaves similar to numpy.nonzero:
      https://docs.scipy.org/doc/numpy/reference/generated/numpy.nonzero.html,
      but for scalar input, NonZero produces output shape (0, N) instead of (1, N), which is different from Numpy's behavior.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> (non-differentiable) : T</dt>
<dd>input</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (non-differentiable) : tensor(int64)</dt>
<dd>output</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain to all tensor types.</dd>
</dl>

### <a name="Pad-13"></a>**Pad-13**</a>

  Given a tensor containing the data to be padded (`data`), a tensor containing the number of start and end pad values for axis (`pads`), (optionally) a `mode`, and (optionally) `constant_value`,
  a padded tensor (`output`) is generated.

  The three supported `modes` are (similar to corresponding modes supported by `numpy.pad`):

  1) `constant`(default) - pads with a given constant value as specified by `constant_value` (which defaults to 0, empty string, or False)

  2) `reflect` - pads with the reflection of the vector mirrored on the first and last values of the vector along each axis

  3) `edge` - pads with the edge values of array


  Example 1 (`constant` mode):
    Insert 0 pads to the beginning of the second dimension.

    data =
    [
        [1.0, 1.2],
        [2.3, 3.4],
        [4.5, 5.7],
    ]

    pads = [0, 2, 0, 0]

    mode = 'constant'

    constant_value = 0.0

    output =
    [
        [0.0, 0.0, 1.0, 1.2],
        [0.0, 0.0, 2.3, 3.4],
        [0.0, 0.0, 4.5, 5.7],
    ]


  Example 2 (`reflect` mode):
    data =
    [
        [1.0, 1.2],
        [2.3, 3.4],
        [4.5, 5.7],
    ]

    pads = [0, 2, 0, 0]

    mode = 'reflect'

    output =
    [
        [1.0, 1.2, 1.0, 1.2],
        [2.3, 3.4, 2.3, 3.4],
        [4.5, 5.7, 4.5, 5.7],
    ]


  Example 3 (`edge` mode):
    data =
    [
        [1.0, 1.2],
        [2.3, 3.4],
        [4.5, 5.7],
    ]

    pads = [0, 2, 0, 0]

    mode = 'edge'

    output =
    [
        [1.0, 1.0, 1.0, 1.2],
        [2.3, 2.3, 2.3, 3.4],
        [4.5, 4.5, 4.5, 5.7],
    ]


#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>mode</tt> : string (default is constant)</dt>
<dd>Supported modes: `constant`(default), `reflect`, `edge`</dd>
</dl>

#### Inputs (2 - 3)

<dl>
<dt><tt>data</tt> (differentiable) : T</dt>
<dd>Input tensor.</dd>
<dt><tt>pads</tt> (non-differentiable) : tensor(int64)</dt>
<dd>Tensor of integers indicating the number of padding elements to add or remove (if negative) at the beginning and end of each axis. For 2D input tensor, it is the number of pixels. `pads` should be a 1D tensor of shape [2 * input_rank]. `pads` format should be: [x1_begin, x2_begin,...,x1_end, x2_end,...], where xi_begin is the number of pad values added at the beginning of axis `i` and xi_end, the number of pad values added at the end of axis `i`.</dd>
<dt><tt>constant_value</tt> (optional, non-differentiable) : T</dt>
<dd>(Optional) A scalar value to be used if the mode chosen is `constant` (by default it is 0, empty string or False).</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>Tensor after padding.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

### <a name="Pow-13"></a>**Pow-13**</a>

  Pow takes input data (Tensor<T>) and exponent Tensor, and
  produces one output data (Tensor<T>) where the function `f(x) = x^exponent`,
  is applied to the data tensor elementwise.
  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>First operand, base of the exponent.</dd>
<dt><tt>Y</tt> (differentiable) : T1</dt>
<dd>Second operand, power of the exponent.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Z</tt> (differentiable) : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input X and output types to float/int tensors.</dd>
<dt><tt>T1</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input Y types to float/int tensors.</dd>
</dl>

### <a name="QuantizeLinear-13"></a>**QuantizeLinear-13**</a>

  The linear quantization operator. It consumes a high precision tensor, a scale, and a zero point to compute the low precision / quantized tensor.
  The scale factor and zero point must have same shape, and can be either a scalar for per-tensor / per layer quantization, or a 1-D tensor for per-axis quantization.
  The quantization formula is y = saturate ((x / y_scale) + y_zero_point).
  For saturation, it saturates to [0, 255] if it's uint8, or [-128, 127] if it's int8.
  For (x / y_scale), it's rounding to nearest ties to even. Refer to https://en.wikipedia.org/wiki/Rounding for details. 'y_zero_point' and 'y' must have same type.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 1)</dt>
<dd>(Optional) The axis of the quantization dimension of the input tensor. Ignored for per-tensor quantization. Negative value means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(input).</dd>
</dl>

#### Inputs (2 - 3)

<dl>
<dt><tt>x</tt> : T1</dt>
<dd>N-D full precision Input tensor to be quantized.</dd>
<dt><tt>y_scale</tt> : tensor(float)</dt>
<dd>Scale for doing quantization to get 'y'. It can be a scalar, which means per-tensor/layer quantization, or a 1-D Tensor for per-axis quantization.</dd>
<dt><tt>y_zero_point</tt> (optional) : T2</dt>
<dd>Zero point for doing quantization to get 'y'. Shape must match y_scale. Default is uint8 with zero point of 0 if it's not specified.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>y</tt> : T2</dt>
<dd>N-D quantized output tensor. It has same shape as input 'x'.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float), tensor(int32)</dt>
<dd>Constrain 'x' to float or int32 tensor.</dd>
<dt><tt>T2</tt> : tensor(int8), tensor(uint8)</dt>
<dd>Constrain 'y_zero_point' and 'y' to 8-bit integer tensor.</dd>
</dl>

### <a name="Reciprocal-13"></a>**Reciprocal-13**</a>

  Reciprocal takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the reciprocal is, y = 1/x, is applied to
  the tensor elementwise.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="ReduceL1-13"></a>**ReduceL1-13**</a>

  Computes the L1 norm of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equals 0, then
  the resulting tensor has the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> (differentiable) : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> (differentiable) : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="ReduceL2-13"></a>**ReduceL2-13**</a>

  Computes the L2 norm of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equals 0, then
  the resulting tensor has the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> (differentiable) : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> (differentiable) : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="ReduceLogSum-13"></a>**ReduceLogSum-13**</a>

  Computes the log sum of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equals 0, then
  the resulting tensor has the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> (differentiable) : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> (differentiable) : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="ReduceLogSumExp-13"></a>**ReduceLogSumExp-13**</a>

  Computes the log sum exponent of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equals 0, then
  the resulting tensor has the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> (differentiable) : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> (differentiable) : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="ReduceMax-13"></a>**ReduceMax-13**</a>

  Computes the max of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equals 0, then
  the resulting tensor has the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> (differentiable) : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> (differentiable) : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16), tensor(uint8), tensor(int8)</dt>
<dd>Constrain input and output types to high-precision and 8 bit numeric tensors.</dd>
</dl>

### <a name="ReduceMean-13"></a>**ReduceMean-13**</a>

  Computes the mean of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equals 0, then
  the resulting tensor has the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> (differentiable) : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> (differentiable) : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="ReduceMin-13"></a>**ReduceMin-13**</a>

  Computes the min of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equals 0, then
  the resulting tensor has the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> (differentiable) : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> (differentiable) : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16), tensor(uint8), tensor(int8)</dt>
<dd>Constrain input and output types to high-precision and 8 bit numeric tensors.</dd>
</dl>

### <a name="ReduceProd-13"></a>**ReduceProd-13**</a>

  Computes the product of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equals 0, then
  the resulting tensor has the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> (differentiable) : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> (differentiable) : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="ReduceSum-13"></a>**ReduceSum-13**</a>

  Computes the sum of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equals 0, then
  the resulting tensor has the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
<dt><tt>noop_with_empty_axes</tt> : int (default is 0)</dt>
<dd>Defines behaviour if 'axes' is empty. Default behaviour with 'false' is to reduce all axes. When axes is empty and this attribute is set to true, input tensor will not be reduced,and the output tensor would be equivalent to input tensor.</dd>
</dl>

#### Inputs (1 - 2)

<dl>
<dt><tt>data</tt> (differentiable) : T</dt>
<dd>An input tensor.</dd>
<dt><tt>axes</tt> (optional, non-differentiable) : tensor(int64)</dt>
<dd>Optional input list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor if 'noop_with_empty_axes' is false, else act as an Identity op when 'noop_with_empty_axes' is true. Accepted range is [-r, r-1] where r = rank(data).</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> (differentiable) : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="ReduceSumSquare-13"></a>**ReduceSumSquare-13**</a>

  Computes the sum square of the input tensor's element along the provided axes. The resulting
  tensor has the same rank as the input if keepdims equals 1. If keepdims equals 0, then
  the resulting tensor has the reduced dimension pruned.

  The above behavior is similar to numpy, with the exception that numpy defaults keepdims to
  False instead of True.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>keepdims</tt> : int (default is 1)</dt>
<dd>Keep the reduced dimension or not, default 1 means keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> (differentiable) : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> (differentiable) : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="Relu-13"></a>**Relu-13**</a>

  Relu takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the rectified linear function, y = max(0, x), is applied to
  the tensor elementwise.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Reshape-13"></a>**Reshape-13**</a>

  Reshape the input tensor similar to numpy.reshape.
  First input is the data tensor, second input is a shape tensor which specifies the output shape. It outputs the reshaped tensor.
  At most one dimension of the new shape can be -1. In this case, the value is
  inferred from the size of the tensor and the remaining dimensions. A dimension
  could also be 0, in which case the actual dimension value is unchanged (i.e. taken
  from the input tensor). Shape (second input) could be an empty shape, which means converting to a scalar.
  The input tensor's shape and the output tensor's shape are required to have the same number of elements.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>data</tt> (differentiable) : T</dt>
<dd>An input tensor.</dd>
<dt><tt>shape</tt> (non-differentiable) : tensor(int64)</dt>
<dd>Specified shape for output.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reshaped</tt> (differentiable) : T</dt>
<dd>Reshaped data.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

### <a name="Resize-13"></a>**Resize-13**</a>

  Resize the input tensor. In general, it calculates every value in the output tensor as a weighted average of neighborhood (a.k.a. sampling locations) in the input tensor.
  Each dimension value of the output tensor is:
    output_dimension = floor(input_dimension * (roi_end - roi_start) * scale) if input \"sizes\" is not specified.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>coordinate_transformation_mode</tt> : string (default is half_pixel)</dt>
<dd>
This attribute describes how to transform the coordinate in the resized tensor to the coordinate in the original tensor. <br/>

The coordinate of each dimension is transformed individually. Let's describe a case using axis x as an example.
Denote x_resized as the coordinate of axis x in the resized tensor, x_original as the coordinate of axis x in the original tensor, length_original as the length of the original tensor in axis x, length_resized as the length of the resized tensor in axis x, roi_x = (start_x, end_x) of the axis x in input "roi", scale = length_resized / length_original, <br/>

if coordinate_transformation_mode is "half_pixel", <br/>
x_original = (x_resized + 0.5) / scale - 0.5, <br/>

if coordinate_transformation_mode is "pytorch_half_pixel", <br/>
x_original = length_resized > 1 ? (x_resized + 0.5) / scale - 0.5 : 0, <br/>

if coordinate_transformation_mode is "align_corners", <br/>
x_original = x_resized * (length_original - 1) / (length_resized - 1), <br/>

if coordinate_transformation_mode is "asymmetric", <br/>
x_original = x_resized / scale, <br/>

if coordinate_transformation_mode is "tf_crop_and_resize", <br/>
x_original = length_resized > 1 ? start_x * (length_original - 1) + x_resized * (end_x - start_x) * (length_original - 1) / (length_resized - 1) : 0.5 * (start_x + end_x) * (length_original - 1).</dd>
<dt><tt>cubic_coeff_a</tt> : float (default is -0.75)</dt>
<dd>The coefficient 'a' used in cubic interpolation. Two common choice are -0.5 (in some cases of TensorFlow) and -0.75 (in PyTorch). Check out Equation (4) in https://ieeexplore.ieee.org/document/1163711 for the details. This attribute is valid only if "mode" is "cubic".</dd>
<dt><tt>exclude_outside</tt> : int (default is 0)</dt>
<dd>If set to 1, the weight of sampling locations outside the tensor will be set to 0 and the weight will be renormalized so that their sum is 1.0. The default value is 0.</dd>
<dt><tt>extrapolation_value</tt> : float (default is 0.0)</dt>
<dd>When coordinate_transformation_mode is "tf_crop_and_resize" and x_original is outside the range [0, length_original - 1], this value is used as the corresponding output value. Default is 0.0f.</dd>
<dt><tt>mode</tt> : string (default is nearest)</dt>
<dd>Three interpolation modes: nearest (default), linear and cubic. The "linear" mode includes linear interpolation for 1D tensor and N-linear interpolation for N-D tensor (for example, bilinear interpolation for 2D tensor). The "cubic" mode includes cubic interpolation for 1D tensor and N-cubic interpolation for N-D tensor (for example, bicubic interpolation for 2D tensor).</dd>
<dt><tt>nearest_mode</tt> : string (default is round_prefer_floor)</dt>
<dd>Four modes: round_prefer_floor (default, as known as round half down), round_prefer_ceil (as known as round half up), floor, ceil. Only used by nearest interpolation. It indicates how to get "nearest" pixel in input tensor from x_original, so this attribute is valid only if "mode" is "nearest".</dd>
</dl>

#### Inputs (1 - 4)

<dl>
<dt><tt>X</tt> (differentiable) : T1</dt>
<dd>N-D tensor</dd>
<dt><tt>roi</tt> (optional, non-differentiable) : T2</dt>
<dd>1-D tensor given as [start1, ..., startN, end1, ..., endN], where N is the rank of X. The RoIs' coordinates are normalized in the coordinate system of the input image. It only takes effect when coordinate_transformation_mode is "tf_crop_and_resize"</dd>
<dt><tt>scales</tt> (optional, non-differentiable) : tensor(float)</dt>
<dd>The scale array along each dimension. It takes value greater than 0. If it's less than 1, it's sampling down, otherwise, it's upsampling. The number of elements of 'scales' should be the same as the rank of input 'X'. One of 'scales' and 'sizes' MUST be specified and it is an error if both are specified. If 'sizes' is needed, the user can use an empty string as the name of 'scales' in this operator's input list.</dd>
<dt><tt>sizes</tt> (optional, non-differentiable) : tensor(int64)</dt>
<dd>The size of the output tensor. The number of elements of 'sizes' should be the same as the rank of input 'X'. Only one of 'scales' and 'sizes' can be specified.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T1</dt>
<dd>N-D tensor after resizing</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input 'X' and output 'Y' to all tensor types.</dd>
<dt><tt>T2</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain roi type to float or double.</dd>
</dl>

### <a name="ScatterElements-13"></a>**ScatterElements-13**</a>

  ScatterElements takes three inputs `data`, `updates`, and `indices` of the same
  rank r >= 1 and an optional attribute axis that identifies an axis of `data`
  (by default, the outer-most axis, that is axis 0). The output of the operation
  is produced by creating a copy of the input `data`, and then updating its value
  to values specified by `updates` at specific index positions specified by
  `indices`. Its output shape is the same as the shape of `data`.

  For each entry in `updates`, the target index in `data` is obtained by combining
  the corresponding entry in `indices` with the index of the entry itself: the
  index-value for dimension = axis is obtained from the value of the corresponding
  entry in `indices` and the index-value for dimension != axis is obtained from the
  index of the entry itself.

  For instance, in a 2-D tensor case, the update corresponding to the [i][j] entry
  is performed as below:
  ```
    output[indices[i][j]][j] = updates[i][j] if axis = 0,
    output[i][indices[i][j]] = updates[i][j] if axis = 1,
  ```

  This operator is the inverse of GatherElements. It is similar to Torch's Scatter operation.

  Example 1:
  ```
    data = [
        [0.0, 0.0, 0.0],
        [0.0, 0.0, 0.0],
        [0.0, 0.0, 0.0],
    ]
    indices = [
        [1, 0, 2],
        [0, 2, 1],
    ]
    updates = [
        [1.0, 1.1, 1.2],
        [2.0, 2.1, 2.2],
    ]
    output = [
        [2.0, 1.1, 0.0]
        [1.0, 0.0, 2.2]
        [0.0, 2.1, 1.2]
    ]
  ```
  Example 2:
  ```
    data = [[1.0, 2.0, 3.0, 4.0, 5.0]]
    indices = [[1, 3]]
    updates = [[1.1, 2.1]]
    axis = 1
    output = [[1.0, 1.1, 3.0, 2.1, 5.0]]
  ```

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 0)</dt>
<dd>Which axis to scatter on. Negative value means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(data).</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> (differentiable) : T</dt>
<dd>Tensor of rank r >= 1.</dd>
<dt><tt>indices</tt> (non-differentiable) : Tind</dt>
<dd>Tensor of int32/int64 indices, of r >= 1 (same rank as input). All index values are expected to be within bounds [-s, s-1] along axis of size s. It is an error if any of the index values are out of bounds.</dd>
<dt><tt>updates</tt> (differentiable) : T</dt>
<dd>Tensor of rank r >=1 (same rank and shape as indices)</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>Tensor of rank r >= 1 (same rank as input).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Input and output types can be of any tensor type.</dd>
<dt><tt>Tind</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain indices to integer types</dd>
</dl>

### <a name="ScatterND-13"></a>**ScatterND-13**</a>

  ScatterND takes three inputs `data` tensor of rank r >= 1, `indices` tensor of rank q >= 1,
  and `updates` tensor of rank q + r - indices.shape[-1] - 1. The output of the operation
  is produced by creating a copy of the input `data`, and then updating its value to values
  specified by `updates` at specific index positions specified by `indices`. Its output shape
  is the same as the shape of `data`. Note that `indices` should not have duplicate entries.
  That is, two or more `updates` for the same index-location is not supported.

  `indices` is an integer tensor. Let k denote indices.shape[-1], the last dimension in the shape of `indices`.
   `indices` is treated as a (q-1)-dimensional tensor of k-tuples, where each k-tuple is a partial-index into `data`.
  Hence, k can be a value at most the rank of `data`. When k equals rank(data), each update entry specifies an
  update to a single element of the tensor. When k is less than rank(data) each update entry specifies an
  update to a slice of the tensor.

  `updates` is treated as a (q-1)-dimensional tensor of replacement-slice-values. Thus, the
  first (q-1) dimensions of updates.shape must match the first (q-1) dimensions of indices.shape.
  The remaining dimensions of `updates` correspond to the dimensions of the
  replacement-slice-values. Each replacement-slice-value is a (r-k) dimensional tensor,
  corresponding to the trailing (r-k) dimensions of `data`.  Thus, the shape of `updates`
  must equal indices.shape[0:q-1] ++ data.shape[k:r-1], where ++ denotes the concatenation
  of shapes.

  The `output` is calculated via the following equation:

      output = np.copy(data)
      update_indices = indices.shape[:-1]
      for idx in np.ndindex(update_indices):
          output[indices[idx]] = updates[idx]

  The order of iteration in the above loop is not specified.
  In particular, indices should not have duplicate entries: that is, if idx1 != idx2, then indices[idx1] != indices[idx2].
  This ensures that the output value does not depend on the iteration order.

  This operator is the inverse of GatherND.

  Example 1:
  ```
    data    = [1, 2, 3, 4, 5, 6, 7, 8]
    indices = [[4], [3], [1], [7]]
    updates = [9, 10, 11, 12]
    output  = [1, 11, 3, 10, 9, 6, 7, 12]
  ```

  Example 2:
  ```
    data    = [[[1, 2, 3, 4], [5, 6, 7, 8], [8, 7, 6, 5], [4, 3, 2, 1]],
               [[1, 2, 3, 4], [5, 6, 7, 8], [8, 7, 6, 5], [4, 3, 2, 1]],
               [[8, 7, 6, 5], [4, 3, 2, 1], [1, 2, 3, 4], [5, 6, 7, 8]],
               [[8, 7, 6, 5], [4, 3, 2, 1], [1, 2, 3, 4], [5, 6, 7, 8]]]
    indices = [[0], [2]]
    updates = [[[5, 5, 5, 5], [6, 6, 6, 6], [7, 7, 7, 7], [8, 8, 8, 8]],
               [[1, 1, 1, 1], [2, 2, 2, 2], [3, 3, 3, 3], [4, 4, 4, 4]]]
    output  = [[[5, 5, 5, 5], [6, 6, 6, 6], [7, 7, 7, 7], [8, 8, 8, 8]],
               [[1, 2, 3, 4], [5, 6, 7, 8], [8, 7, 6, 5], [4, 3, 2, 1]],
               [[1, 1, 1, 1], [2, 2, 2, 2], [3, 3, 3, 3], [4, 4, 4, 4]],
               [[8, 7, 6, 5], [4, 3, 2, 1], [1, 2, 3, 4], [5, 6, 7, 8]]]
  ```

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>data</tt> (differentiable) : T</dt>
<dd>Tensor of rank r >= 1.</dd>
<dt><tt>indices</tt> (non-differentiable) : tensor(int64)</dt>
<dd>Tensor of rank q >= 1.</dd>
<dt><tt>updates</tt> (differentiable) : T</dt>
<dd>Tensor of rank q + r - indices_shape[-1] - 1.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>Tensor of rank r >= 1.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to any tensor type.</dd>
</dl>

### <a name="Shape-13"></a>**Shape-13**</a>

  Takes a tensor as input and outputs an 1D int64 tensor containing the shape of the input tensor.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>data</tt> (non-differentiable) : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>shape</tt> (non-differentiable) : T1</dt>
<dd>Shape of the input tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Input tensor can be of arbitrary type.</dd>
<dt><tt>T1</tt> : tensor(int64)</dt>
<dd>Constrain output to int64 tensor.</dd>
</dl>

### <a name="Sigmoid-13"></a>**Sigmoid-13**</a>

  Sigmoid takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the sigmoid function, y = 1 / (1 + exp(-x)), is applied to the
  tensor elementwise.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Sign-13"></a>**Sign-13**</a>

  Calculate the sign of the given input tensor element-wise.
  If input > 0, output 1. if input < 0, output -1. if input == 0, output 0.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> (non-differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (non-differentiable) : T</dt>
<dd>The sign of the input tensor computed element-wise. It has the same shape and type of the input.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to all numeric tensors.</dd>
</dl>

### <a name="Size-13"></a>**Size-13**</a>

  Takes a tensor as input and outputs a int64 scalar that equals to the total number of elements of the input tensor.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>data</tt> (non-differentiable) : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>size</tt> (non-differentiable) : T1</dt>
<dd>Total number of elements of the input tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Input tensor can be of arbitrary type.</dd>
<dt><tt>T1</tt> : tensor(int64)</dt>
<dd>Constrain output to int64 tensor, which should be a scalar though.</dd>
</dl>

### <a name="Slice-13"></a>**Slice-13**</a>

  Produces a slice of the input tensor along multiple axes. Similar to numpy:
  https://numpy.org/doc/stable/user/basics.indexing.html?highlight=slice#slicing-and-striding

  Slice uses the `starts`, `ends`, `axes` and `steps` inputs to select a sub-tensor
  of its input `data` tensor.

  An effective `start[i]`, `end[i]`, and `step[i]` must be computed for each `i`
  in `[0, ... r-1]` where `r = rank(input)` as follows:

  If `axes` are omitted, they are set to `[0, ..., r-1]`.
  If `steps` are omitted, they are set to `[1, ..., 1]` of length `len(starts)`

  The effective values are initialized as `start[i] = 0`, `end[i] = dims[i]` where
  `dims` are the dimensions of `input` and `step[i] = `1.

  All negative elements of `axes` are made non-negatve by adding `r` to them, where
  `r =rank(input)`.

  All negative values in `starts[i]` and `ends[i]` have `dims[axes[i]]` added to them,
  where `dims` are the dimensions of `input`. Then `start[axes[i]]` is the adjusted
  `starts[i]` is clamped into the range `[0, dims[axes[i]]]` for positive stepping
  and `[0, dims[axes[i]]-1]` for negative stepping.

  The clamping for the adjusted `ends[i]` depends on the sign of `steps[i]` and must
  accommodate copying 0 through `dims[axes[i]]` elements, so for positive stepping
  `end[axes[i]]` is clamped to `[0, dims[axes[i]]]`, while for negative stepping it
  is clamped to `[-1, dims[axes[i]]-1]`.

  Finally, `step[axes[i]] = steps[i]`.

  For slicing to the end of a dimension with unknown size, it is recommended to pass
  in `INT_MAX` when slicing forward and 'INT_MIN' when slicing backward.

  Example 1:
    data = [
        [1, 2, 3, 4],
        [5, 6, 7, 8],
    ]
    axes = [0, 1]
    starts = [1, 0]
    ends = [2, 3]
    steps = [1, 2]
    result = [
        [5, 7],
    ]
  Example 2:
    data = [
        [1, 2, 3, 4],
        [5, 6, 7, 8],
    ]
    starts = [0, 1]
    ends = [-1, 1000]
    result = [
        [2, 3, 4],
    ]

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs (3 - 5)

<dl>
<dt><tt>data</tt> (differentiable) : T</dt>
<dd>Tensor of data to extract slices from.</dd>
<dt><tt>starts</tt> (non-differentiable) : Tind</dt>
<dd>1-D tensor of starting indices of corresponding axis in `axes`</dd>
<dt><tt>ends</tt> (non-differentiable) : Tind</dt>
<dd>1-D tensor of ending indices (exclusive) of corresponding axis in `axes`</dd>
<dt><tt>axes</tt> (optional, non-differentiable) : Tind</dt>
<dd>1-D tensor of axes that `starts` and `ends` apply to. Negative value means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(data). Behavior is undefined if an axis is repeated.</dd>
<dt><tt>steps</tt> (optional, non-differentiable) : Tind</dt>
<dd>1-D tensor of slice step of corresponding axis in `axes`. Negative value means slicing backward. 'steps' cannot be 0. Defaults to 1s.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>Sliced data tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
<dt><tt>Tind</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain indices to integer types</dd>
</dl>

### <a name="Softmax-13"></a>**Softmax-13**</a>

  The operator computes the normalized exponential values for the given input:

   Softmax(input, axis) = Exp(input) / ReduceSum(Exp(input), axis=axis, keepdims=1)

  The "axis" attribute indicates the dimension along which Softmax
  will be performed. The output tensor has the same shape
  and contains the Softmax values of the corresponding input.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is -1)</dt>
<dd>
Describes the dimension Softmax will be performed on.
Negative value means counting dimensions
from the back. Accepted range is [-r, r-1] where r = rank(input).
</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>The input tensor of rank >= axis.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>The output values with the same shape as the input tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="SoftmaxCrossEntropyLoss-13"></a>**SoftmaxCrossEntropyLoss-13**</a>

  Loss function that measures the softmax cross entropy
  between 'scores' and 'labels'.
  This operator first computes a loss tensor whose shape is identical to the labels input.
  If the input is 2-D with shape (N, C), the loss tensor may be a N-element vector L = (l_1, l_2, ..., l_N).
  If the input is N-D tensor with shape (N, C, D1, D2, ..., Dk),
  the loss tensor L may have (N, D1, D2, ..., Dk) as its shape and L[i,][j_1][j_2]...[j_k] denotes a scalar element in L.
  After L is available, this operator can optionally do a reduction operator.

  shape(scores): (N, C) where C is the number of classes, or (N, C, D1, D2,..., Dk),
          with K >= 1 in case of K-dimensional loss.
  shape(labels): (N) where each value is 0 <= labels[i] <= C-1, or (N, D1, D2,..., Dk),
          with K >= 1 in case of K-dimensional loss.

  The loss for one sample, l_i, can caculated as follows:
      l[i][d1][d2]...[dk] = -y[i][c][d1][d2]..[dk], where i is the index of classes.
  or
      l[i][d1][d2]...[dk] = -y[i][c][d1][d2]..[dk] * weights[c], if 'weights' is provided.

  loss is zero for the case when label-value equals ignore_index.
      l[i][d1][d2]...[dk]  = 0, when labels[n][d1][d2]...[dk] = ignore_index

  where:
      p = Softmax(scores)
      y = Log(p)
      c = labels[i][d1][d2]...[dk]

  Finally, L is optionally reduced:
  If reduction = 'none', the output is L with shape (N, D1, D2, ..., Dk).
  If reduction = 'sum', the output is scalar: Sum(L).
  If reduction = 'mean', the output is scalar: ReduceMean(L), or if weight is provided: ReduceSum(L) / ReduceSum(W),
  where tensor W is of shape (N, D1, D2, ..., Dk) and W[n][d1][d2]...[dk] = weights[labels[i][d1][d2]...[dk]].

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>ignore_index</tt> : int</dt>
<dd>Specifies a target value that is ignored and does not contribute to the input gradient. It's an optional value.</dd>
<dt><tt>reduction</tt> : string (default is mean)</dt>
<dd>Type of reduction to apply to loss: none, sum, mean(default). 'none': no reduction will be applied, 'sum': the output will be summed. 'mean': the sum of the output will be divided by the number of elements in the output.</dd>
</dl>

#### Inputs (2 - 3)

<dl>
<dt><tt>scores</tt> (differentiable) : T</dt>
<dd>The predicted outputs with shape [batch_size, class_size], or [batch_size, class_size, D1, D2 , ..., Dk], where K is the number of dimensions.</dd>
<dt><tt>labels</tt> (non-differentiable) : Tind</dt>
<dd>The ground truth output tensor, with shape [batch_size], or [batch_size, D1, D2, ..., Dk], where K is the number of dimensions. Labels element value shall be in range of [0, C). If ignore_index is specified, it may have a value outside [0, C) and the label values should either be in the range [0, C) or have the value ignore_index.</dd>
<dt><tt>weights</tt> (optional, non-differentiable) : T</dt>
<dd>A manual rescaling weight given to each class. If given, it has to be a 1D Tensor assigning weight to each of the classes. Otherwise, it is treated as if having all ones.</dd>
</dl>

#### Outputs (1 - 2)

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>Weighted loss float Tensor. If reduction is 'none', this has the shape of [batch_size], or [batch_size, D1, D2, ..., Dk] in case of K-dimensional loss. Otherwise, it is a scalar.</dd>
<dt><tt>log_prob</tt> (optional, differentiable) : T</dt>
<dd>Log probability tensor. If the output of softmax is prob, its value is log(prob).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>Tind</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain target to integer types</dd>
</dl>

### <a name="SpaceToDepth-13"></a>**SpaceToDepth-13**</a>

  SpaceToDepth rearranges blocks of spatial data into depth. More specifically,
  this op outputs a copy of the input tensor where values from the height and width dimensions
  are moved to the depth dimension.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>blocksize</tt> : int (required)</dt>
<dd>Blocks of [blocksize, blocksize] are moved.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Input tensor of [N,C,H,W], where N is the batch axis, C is the channel or depth, H is the height and W is the width.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>Output tensor of [N, C * blocksize * blocksize, H/blocksize, W/blocksize].</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

### <a name="Split-13"></a>**Split-13**</a>

  Split a tensor into a list of tensors, along the specified
  'axis'. Lengths of the parts can be specified using input 'split'.
  Otherwise, the tensor is split to equal sized parts.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 0)</dt>
<dd>Which axis to split on. A negative value means counting dimensions from the back. Accepted range is [-rank, rank-1] where r = rank(input).</dd>
</dl>

#### Inputs (1 - 2)

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>The tensor to split</dd>
<dt><tt>split</tt> (optional, non-differentiable) : tensor(int64)</dt>
<dd>Optional length of each output. Values should be >= 0.Sum of the values must be equal to the dim value at 'axis' specified.</dd>
</dl>

#### Outputs (1 - &#8734;)

<dl>
<dt><tt>outputs</tt> (variadic, differentiable) : T</dt>
<dd>One or more outputs forming list of tensors after splitting</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

### <a name="Sqrt-13"></a>**Sqrt-13**</a>

  Square root takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the square root is, y = x^0.5, is applied to
  the tensor elementwise. If x is negative, then it will return NaN.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Squeeze-13"></a>**Squeeze-13**</a>

  Remove single-dimensional entries from the shape of a tensor.
  Takes an input `axes` with a list of axes to squeeze.
  If `axes` is not provided, all the single dimensions will be removed from
  the shape. If an axis is selected with shape entry not equal to one, an error is raised.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs (1 - 2)

<dl>
<dt><tt>data</tt> (differentiable) : T</dt>
<dd>Tensors with at least max(dims) dimensions.</dd>
<dt><tt>axes</tt> (optional, non-differentiable) : tensor(int64)</dt>
<dd>List of integers indicating the dimensions to squeeze. Negative value means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(data).</dd>
</dl>

#### Outputs

<dl>
<dt><tt>squeezed</tt> (differentiable) : T</dt>
<dd>Reshaped tensor with same data as input.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

### <a name="Sub-13"></a>**Sub-13**</a>

  Performs element-wise binary subtraction (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> (differentiable) : T</dt>
<dd>First operand.</dd>
<dt><tt>B</tt> (differentiable) : T</dt>
<dd>Second operand.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> (differentiable) : T</dt>
<dd>Result, has same element type as two inputs</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
</dl>

### <a name="Sum-13"></a>**Sum-13**</a>

  Element-wise sum of each of the input tensors (with Numpy-style broadcasting support).
  All inputs and outputs must have the same data type.
  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>data_0</tt> (variadic, differentiable) : T</dt>
<dd>List of tensors for sum.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>sum</tt> (differentiable) : T</dt>
<dd>Output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Tanh-13"></a>**Tanh-13**</a>

  Calculates the hyperbolic tangent of the given input tensor element-wise.

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>The hyperbolic tangent values of the input tensor computed element-wise</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Tile-13"></a>**Tile-13**</a>

  Constructs a tensor by tiling a given tensor.
  This is the same as function `tile` in Numpy, but no broadcast.
  For example A = [[1, 2], [3, 4]], B = [1, 2], tile(A, B) = [[1, 2, 1, 2], [3, 4, 3, 4]]

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Input tensor of any shape.</dd>
<dt><tt>repeats</tt> (non-differentiable) : T1</dt>
<dd>1D int64 tensor of the same length as input's dimension number, includes numbers of repeated copies along input's dimensions.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>Output tensor of the same dimensions and type as tensor input. output_dim[i] = input_dim[i] * repeats[i]</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
<dt><tt>T1</tt> : tensor(int64)</dt>
<dd>Constrain repeat's type to int64 tensors.</dd>
</dl>

### <a name="Transpose-13"></a>**Transpose-13**</a>

  Transpose the input tensor similar to numpy.transpose. For example, when
  perm=(1, 0, 2), given an input tensor of shape (1, 2, 3), the output shape
  will be (2, 1, 3).

#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>perm</tt> : list of ints</dt>
<dd>A list of integers. By default, reverse the dimensions, otherwise permute the axes according to the values given.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> (differentiable) : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>transposed</tt> (differentiable) : T</dt>
<dd>Transposed output.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

### <a name="Unsqueeze-13"></a>**Unsqueeze-13**</a>

  Insert single-dimensional entries to the shape of an input tensor (`data`).
  Takes one required input `axes` - which contains a list of dimension indices and this operator will insert a dimension of value `1` into the corresponding index of the output tensor (`expanded`).

  For example:
    Given an input tensor (`data`) of shape [3, 4, 5], then
    Unsqueeze(data, axes=[0, 4]) outputs a tensor (`expanded`) containing same data as `data` but with shape [1, 3, 4, 5, 1].

  The input `axes` should not contain any duplicate entries. It is an error if it contains duplicates.
  The rank of the output tensor (`output_rank`) is the rank of the input tensor (`data`) plus the number of values in `axes`.
  Each value in `axes` should be within the (inclusive) range [-output_rank , output_rank - 1].
  The order of values in `axes` does not matter and can come in any order.


#### Version

This version of the operator has been available since version 13 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>data</tt> (differentiable) : T</dt>
<dd>Original tensor</dd>
<dt><tt>axes</tt> (non-differentiable) : tensor(int64)</dt>
<dd>List of integers indicating the dimensions to be inserted. Negative value means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(expanded).</dd>
</dl>

#### Outputs

<dl>
<dt><tt>expanded</tt> (differentiable) : T</dt>
<dd>Reshaped tensor with same data as input.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

## Version 14 of the default ONNX operator set
### <a name="Add-14"></a>**Add-14**</a>

  Performs element-wise binary addition (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

  (Opset 14 change): Extend supported types to include uint8, int8, uint16, and int16.

#### Version

This version of the operator has been available since version 14 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> (differentiable) : T</dt>
<dd>First operand.</dd>
<dt><tt>B</tt> (differentiable) : T</dt>
<dd>Second operand.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> (differentiable) : T</dt>
<dd>Result, has same element type as two inputs</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to all numeric tensors.</dd>
</dl>

### <a name="BatchNormalization-14"></a>**BatchNormalization-14**</a>

  Carries out batch normalization as described in the paper
  https://arxiv.org/abs/1502.03167. Depending on the mode it is being run,
  There are five required inputs 'X', 'scale', 'B', 'input_mean' and
  'input_var'.
  Note that 'input_mean' and 'input_var' are expected to be the estimated
  statistics in inference mode (training_mode=False, default),
  and the running statistics in training mode (training_mode=True).
  There are multiple cases for the number of outputs, which we list below:

  Output case #1: Y, running_mean, running_var (training_mode=True)
  Output case #2: Y (training_mode=False)

  When training_mode=False, extra outputs are invalid.
  The outputs are updated as follows when training_mode=True:
  ```
  running_mean = input_mean * momentum + current_mean * (1 - momentum)
  running_var = input_var * momentum + current_var * (1 - momentum)

  Y = (X - current_mean) / sqrt(current_var + epsilon) * scale + B

  where:

  current_mean = ReduceMean(X, axis=all_except_channel_index)
  current_var =  ReduceVar(X, axis=all_except_channel_index)

  Notice that ReduceVar refers to the population variance, and it equals to
  sum(sqrd(x_i - x_avg)) / N
  where N is the population size (this formula does not use sample size N - 1).

  ```

  When training_mode=False:
  ```
  Y = (X - input_mean) / sqrt(input_var + epsilon) * scale + B
  ```

  For previous (depreciated) non-spatial cases, implementors are suggested
  to flatten the input shape to (N x C * D1 * D2 * ... * Dn) before a BatchNormalization Op.
  This operator has **optional** inputs/outputs. See [the doc](IR.md) for more details about the representation of optional arguments. An empty string may be used in the place of an actual argument's name to indicate a missing argument. Trailing optional arguments (those not followed by an argument that is present) may also be simply omitted.

#### Version

This version of the operator has been available since version 14 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>epsilon</tt> : float (default is 1e-05)</dt>
<dd>The epsilon value to use to avoid division by zero.</dd>
<dt><tt>momentum</tt> : float (default is 0.9)</dt>
<dd>Factor used in computing the running mean and variance.e.g., running_mean = running_mean * momentum + mean * (1 - momentum).</dd>
<dt><tt>training_mode</tt> : int (default is 0)</dt>
<dd>If set to true, it indicates BatchNormalization is being used for training, and outputs 1, 2, 3, and 4 would be populated.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input data tensor from the previous operator; dimensions are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size, C is the number of channels. Statistics are computed for every channel of C over N and D1 to Dn dimensions. For image data, input dimensions become (N x C x H x W). The op also accepts single dimension input of size N in which case C is assumed to be 1</dd>
<dt><tt>scale</tt> (differentiable) : T</dt>
<dd>Scale tensor of shape (C).</dd>
<dt><tt>B</tt> (differentiable) : T</dt>
<dd>Bias tensor of shape (C).</dd>
<dt><tt>input_mean</tt> (differentiable) : U</dt>
<dd>running (training) or estimated (testing) mean tensor of shape (C).</dd>
<dt><tt>input_var</tt> (differentiable) : U</dt>
<dd>running (training) or estimated (testing) variance tensor of shape (C).</dd>
</dl>

#### Outputs (1 - 3)

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>The output tensor of the same shape as X</dd>
<dt><tt>running_mean</tt> (optional, non-differentiable) : U</dt>
<dd>The running mean after the BatchNormalization operator.</dd>
<dt><tt>running_var</tt> (optional, non-differentiable) : U</dt>
<dd>The running variance after the BatchNormalization operator. This op uses the population size (N) for calculating variance, and not the sample size N-1.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>U</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain mean and variance types to float tensors. It allows all float type for U.</dd>
</dl>

### <a name="CumSum-14"></a>**CumSum-14**</a>

  Performs cumulative sum of the input elements along the given axis.
  By default, it will do the sum inclusively meaning the first element is copied as is.
  Through an `exclusive` attribute, this behavior can change to exclude the first element.
  It can also perform summation in the opposite direction of the axis. For that, set `reverse` attribute to 1.

  Example:
  ```
  input_x = [1, 2, 3]
  axis=0
  output = [1, 3, 6]
  exclusive=1
  output = [0, 1, 3]
  exclusive=0
  reverse=1
  output = [6, 5, 3]
  exclusive=1
  reverse=1
  output = [5, 3, 0]
  ```


#### Version

This version of the operator has been available since version 14 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>exclusive</tt> : int (default is 0)</dt>
<dd>If set to 1 will return exclusive sum in which the top element is not included. In other terms, if set to 1, the j-th output element would be the sum of the first (j-1) elements. Otherwise, it would be the sum of the first j elements.</dd>
<dt><tt>reverse</tt> : int (default is 0)</dt>
<dd>If set to 1 will perform the sums in reverse direction.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>x</tt> (differentiable) : T</dt>
<dd>An input tensor that is to be processed.</dd>
<dt><tt>axis</tt> (non-differentiable) : T2</dt>
<dd>A 0-D tensor. Must be in the range [-rank(x), rank(x)-1]. Negative value means counting dimensions from the back.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>y</tt> (differentiable) : T</dt>
<dd>Output tensor of the same type as 'x' with cumulative sums of the x's elements</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to high-precision numeric tensors.</dd>
<dt><tt>T2</tt> : tensor(int32), tensor(int64)</dt>
<dd>axis tensor can be int32 or int64 only</dd>
</dl>

### <a name="Div-14"></a>**Div-14**</a>

  Performs element-wise binary division (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

  (Opset 14 change): Extend supported types to include uint8, int8, uint16, and int16.

#### Version

This version of the operator has been available since version 14 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> (differentiable) : T</dt>
<dd>First operand.</dd>
<dt><tt>B</tt> (differentiable) : T</dt>
<dd>Second operand.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> (differentiable) : T</dt>
<dd>Result, has same element type as two inputs</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to all numeric tensors.</dd>
</dl>

### <a name="GRU-14"></a>**GRU-14**</a>

  Computes an one-layer GRU. This operator is usually supported via some custom
  implementation such as CuDNN.

  Notations:

  `X` - input tensor

  `z` - update gate

  `r` - reset gate

  `h` - hidden gate

  `t` - time step (t-1 means previous time step)

  `W[zrh]` - W parameter weight matrix for update, reset, and hidden gates

  `R[zrh]` - R recurrence weight matrix for update, reset, and hidden gates

  `Wb[zrh]` - W bias vectors for update, reset, and hidden gates

  `Rb[zrh]` - R bias vectors for update, reset, and hidden gates

  `WB[zrh]` - W parameter weight matrix for backward update, reset, and hidden gates

  `RB[zrh]` - R recurrence weight matrix for backward update, reset, and hidden gates

  `WBb[zrh]` - W bias vectors for backward update, reset, and hidden gates

  `RBb[zrh]` - R bias vectors for backward update, reset, and hidden gates

  `H` - Hidden state

  `num_directions` - 2 if direction == bidirectional else 1

  Activation functions:

    Relu(x)                - max(0, x)

    Tanh(x)                - (1 - e^{-2x})/(1 + e^{-2x})

    Sigmoid(x)             - 1/(1 + e^{-x})

    (NOTE: Below are optional)

    Affine(x)              - alpha*x + beta

    LeakyRelu(x)           - x if x >= 0 else alpha * x

    ThresholdedRelu(x)     - x if x >= alpha else 0

    ScaledTanh(x)          - alpha*Tanh(beta*x)

    HardSigmoid(x)         - min(max(alpha*x + beta, 0), 1)

    Elu(x)                 - x if x >= 0 else alpha*(e^x - 1)

    Softsign(x)            - x/(1 + |x|)

    Softplus(x)            - log(1 + e^x)

  Equations (Default: f=Sigmoid, g=Tanh):

    - zt = f(Xt*(Wz^T) + Ht-1*(Rz^T) + Wbz + Rbz)

    - rt = f(Xt*(Wr^T) + Ht-1*(Rr^T) + Wbr + Rbr)

    - ht = g(Xt*(Wh^T) + (rt (.) Ht-1)*(Rh^T) + Rbh + Wbh) # default, when linear_before_reset = 0

    - ht = g(Xt*(Wh^T) + (rt (.) (Ht-1*(Rh^T) + Rbh)) + Wbh) # when linear_before_reset != 0

    - Ht = (1 - zt) (.) ht + zt (.) Ht-1
  This operator has **optional** inputs/outputs. See [the doc](IR.md) for more details about the representation of optional arguments. An empty string may be used in the place of an actual argument's name to indicate a missing argument. Trailing optional arguments (those not followed by an argument that is present) may also be simply omitted.

#### Version

This version of the operator has been available since version 14 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>activation_alpha</tt> : list of floats</dt>
<dd>Optional scaling values used by some activation functions. The values are consumed in the order of activation functions, for example (f, g, h) in LSTM. Default values are the same as of corresponding ONNX operators.For example with LeakyRelu, the default alpha is 0.01.</dd>
<dt><tt>activation_beta</tt> : list of floats</dt>
<dd>Optional scaling values used by some activation functions. The values are consumed in the order of activation functions, for example (f, g, h) in LSTM. Default values are the same as of corresponding ONNX operators.</dd>
<dt><tt>activations</tt> : list of strings</dt>
<dd>A list of 2 (or 4 if bidirectional) activation functions for update, reset, and hidden gates. The activation functions must be one of the activation functions specified above. Optional: See the equations for default if not specified.</dd>
<dt><tt>clip</tt> : float</dt>
<dd>Cell clip threshold. Clipping bounds the elements of a tensor in the range of [-threshold, +threshold] and is applied to the input of activations. No clip if not specified.</dd>
<dt><tt>direction</tt> : string (default is forward)</dt>
<dd>Specify if the RNN is forward, reverse, or bidirectional. Must be one of forward (default), reverse, or bidirectional.</dd>
<dt><tt>hidden_size</tt> : int</dt>
<dd>Number of neurons in the hidden layer</dd>
<dt><tt>layout</tt> : int (default is 0)</dt>
<dd>The shape format of inputs X, initial_h and outputs Y, Y_h. If 0, the following shapes are expected: X.shape = [seq_length, batch_size, input_size], Y.shape = [seq_length, num_directions, batch_size, hidden_size], initial_h.shape = Y_h.shape = [num_directions, batch_size, hidden_size]. If 1, the following shapes are expected: X.shape = [batch_size, seq_length, input_size], Y.shape = [batch_size, seq_length, num_directions, hidden_size], initial_h.shape = Y_h.shape = [batch_size, num_directions, hidden_size].</dd>
<dt><tt>linear_before_reset</tt> : int (default is 0)</dt>
<dd>When computing the output of the hidden gate, apply the linear transformation before multiplying by the output of the reset gate.</dd>
</dl>

#### Inputs (3 - 6)

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>The input sequences packed (and potentially padded) into one 3-D tensor with the shape of `[seq_length, batch_size, input_size]`.</dd>
<dt><tt>W</tt> (differentiable) : T</dt>
<dd>The weight tensor for the gates. Concatenation of `W[zrh]` and `WB[zrh]` (if bidirectional) along dimension 0. This tensor has shape `[num_directions, 3*hidden_size, input_size]`.</dd>
<dt><tt>R</tt> (differentiable) : T</dt>
<dd>The recurrence weight tensor. Concatenation of `R[zrh]` and `RB[zrh]` (if bidirectional) along dimension 0. This tensor has shape `[num_directions, 3*hidden_size, hidden_size]`.</dd>
<dt><tt>B</tt> (optional, differentiable) : T</dt>
<dd>The bias tensor for the gates. Concatenation of `[Wb[zrh], Rb[zrh]]` and `[WBb[zrh], RBb[zrh]]` (if bidirectional) along dimension 0. This tensor has shape `[num_directions, 6*hidden_size]`. Optional: If not specified - assumed to be 0</dd>
<dt><tt>sequence_lens</tt> (optional, non-differentiable) : T1</dt>
<dd>Optional tensor specifying lengths of the sequences in a batch. If not specified - assumed all sequences in the batch to have length `seq_length`. It has shape `[batch_size]`.</dd>
<dt><tt>initial_h</tt> (optional, non-differentiable) : T</dt>
<dd>Optional initial value of the hidden. If not specified - assumed to be 0. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
</dl>

#### Outputs (0 - 2)

<dl>
<dt><tt>Y</tt> (optional, differentiable) : T</dt>
<dd>A tensor that concats all the intermediate output values of the hidden. It has shape `[seq_length, num_directions, batch_size, hidden_size]`. </dd>
<dt><tt>Y_h</tt> (optional, differentiable) : T</dt>
<dd>The last output value of the hidden. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T1</tt> : tensor(int32)</dt>
<dd>Constrain seq_lens to integer tensor.</dd>
</dl>

### <a name="HardSwish-14"></a>**HardSwish-14**</a>

  HardSwish takes one input data (Tensor<T>) and produces one output data (Tensor<T>) where
  the HardSwish function, y = x * max(0, min(1, alpha * x + beta)) = x * HardSigmoid<alpha, beta>(x),
  where alpha = 1/6 and beta = 0.5, is applied to the tensor elementwise.

#### Version

This version of the operator has been available since version 14 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="Identity-14"></a>**Identity-14**</a>

  Identity operator

#### Version

This version of the operator has been available since version 14 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : V</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : V</dt>
<dd>Tensor to copy input into.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>V</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128), seq(tensor(uint8)), seq(tensor(uint16)), seq(tensor(uint32)), seq(tensor(uint64)), seq(tensor(int8)), seq(tensor(int16)), seq(tensor(int32)), seq(tensor(int64)), seq(tensor(float16)), seq(tensor(float)), seq(tensor(double)), seq(tensor(string)), seq(tensor(bool)), seq(tensor(complex64)), seq(tensor(complex128))</dt>
<dd>Constrain input and output types to all tensor and sequence types.</dd>
</dl>

### <a name="LSTM-14"></a>**LSTM-14**</a>

  Computes an one-layer LSTM. This operator is usually supported via some
  custom implementation such as CuDNN.

  Notations:

  `X` - input tensor

  `i` - input gate

  `o` - output gate

  `f` - forget gate

  `c` - cell gate

  `t` - time step (t-1 means previous time step)

  `W[iofc]` - W parameter weight matrix for input, output, forget, and cell gates

  `R[iofc]` - R recurrence weight matrix for input, output, forget, and cell gates

  `Wb[iofc]` - W bias vectors for input, output, forget, and cell gates

  `Rb[iofc]` - R bias vectors for input, output, forget, and cell gates

  `P[iof]`  - P peephole weight vector for input, output, and forget gates

  `WB[iofc]` - W parameter weight matrix for backward input, output, forget, and cell gates

  `RB[iofc]` - R recurrence weight matrix for backward input, output, forget, and cell gates

  `WBb[iofc]` - W bias vectors for backward input, output, forget, and cell gates

  `RBb[iofc]` - R bias vectors for backward input, output, forget, and cell gates

  `PB[iof]`  - P peephole weight vector for backward input, output, and forget gates

  `H` - Hidden state

  `num_directions` - 2 if direction == bidirectional else 1

  Activation functions:

    Relu(x)                - max(0, x)

    Tanh(x)                - (1 - e^{-2x})/(1 + e^{-2x})

    Sigmoid(x)             - 1/(1 + e^{-x})

    (NOTE: Below are optional)

    Affine(x)              - alpha*x + beta

    LeakyRelu(x)           - x if x >= 0 else alpha * x

    ThresholdedRelu(x)     - x if x >= alpha else 0

    ScaledTanh(x)          - alpha*Tanh(beta*x)

    HardSigmoid(x)         - min(max(alpha*x + beta, 0), 1)

    Elu(x)                 - x if x >= 0 else alpha*(e^x - 1)

    Softsign(x)            - x/(1 + |x|)

    Softplus(x)            - log(1 + e^x)

  Equations (Default: f=Sigmoid, g=Tanh, h=Tanh):

    - it = f(Xt*(Wi^T) + Ht-1*(Ri^T) + Pi (.) Ct-1 + Wbi + Rbi)

    - ft = f(Xt*(Wf^T) + Ht-1*(Rf^T) + Pf (.) Ct-1 + Wbf + Rbf)

    - ct = g(Xt*(Wc^T) + Ht-1*(Rc^T) + Wbc + Rbc)

    - Ct = ft (.) Ct-1 + it (.) ct

    - ot = f(Xt*(Wo^T) + Ht-1*(Ro^T) + Po (.) Ct + Wbo + Rbo)

    - Ht = ot (.) h(Ct)
  This operator has **optional** inputs/outputs. See [the doc](IR.md) for more details about the representation of optional arguments. An empty string may be used in the place of an actual argument's name to indicate a missing argument. Trailing optional arguments (those not followed by an argument that is present) may also be simply omitted.

#### Version

This version of the operator has been available since version 14 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>activation_alpha</tt> : list of floats</dt>
<dd>Optional scaling values used by some activation functions. The values are consumed in the order of activation functions, for example (f, g, h) in LSTM. Default values are the same as of corresponding ONNX operators.For example with LeakyRelu, the default alpha is 0.01.</dd>
<dt><tt>activation_beta</tt> : list of floats</dt>
<dd>Optional scaling values used by some activation functions. The values are consumed in the order of activation functions, for example (f, g, h) in LSTM. Default values are the same as of corresponding ONNX operators.</dd>
<dt><tt>activations</tt> : list of strings</dt>
<dd>A list of 3 (or 6 if bidirectional) activation functions for input, output, forget, cell, and hidden. The activation functions must be one of the activation functions specified above. Optional: See the equations for default if not specified.</dd>
<dt><tt>clip</tt> : float</dt>
<dd>Cell clip threshold. Clipping bounds the elements of a tensor in the range of [-threshold, +threshold] and is applied to the input of activations. No clip if not specified.</dd>
<dt><tt>direction</tt> : string (default is forward)</dt>
<dd>Specify if the RNN is forward, reverse, or bidirectional. Must be one of forward (default), reverse, or bidirectional.</dd>
<dt><tt>hidden_size</tt> : int</dt>
<dd>Number of neurons in the hidden layer</dd>
<dt><tt>input_forget</tt> : int (default is 0)</dt>
<dd>Couple the input and forget gates if 1.</dd>
<dt><tt>layout</tt> : int (default is 0)</dt>
<dd>The shape format of inputs X, initial_h, initial_c and outputs Y, Y_h, Y_c. If 0, the following shapes are expected: X.shape = [seq_length, batch_size, input_size], Y.shape = [seq_length, num_directions, batch_size, hidden_size], initial_h.shape = Y_h.shape = initial_c.shape = Y_c.shape = [num_directions, batch_size, hidden_size]. If 1, the following shapes are expected: X.shape = [batch_size, seq_length, input_size], Y.shape = [batch_size, seq_length, num_directions, hidden_size], initial_h.shape = Y_h.shape = initial_c.shape = Y_c.shape = [batch_size, num_directions, hidden_size].</dd>
</dl>

#### Inputs (3 - 8)

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>The input sequences packed (and potentially padded) into one 3-D tensor with the shape of `[seq_length, batch_size, input_size]`.</dd>
<dt><tt>W</tt> (differentiable) : T</dt>
<dd>The weight tensor for the gates. Concatenation of `W[iofc]` and `WB[iofc]` (if bidirectional) along dimension 0. The tensor has shape `[num_directions, 4*hidden_size, input_size]`.</dd>
<dt><tt>R</tt> (differentiable) : T</dt>
<dd>The recurrence weight tensor. Concatenation of `R[iofc]` and `RB[iofc]` (if bidirectional) along dimension 0. This tensor has shape `[num_directions, 4*hidden_size, hidden_size]`.</dd>
<dt><tt>B</tt> (optional, differentiable) : T</dt>
<dd>The bias tensor for input gate. Concatenation of `[Wb[iofc], Rb[iofc]]`, and `[WBb[iofc], RBb[iofc]]` (if bidirectional) along dimension 0. This tensor has shape `[num_directions, 8*hidden_size]`. Optional: If not specified - assumed to be 0.</dd>
<dt><tt>sequence_lens</tt> (optional, non-differentiable) : T1</dt>
<dd>Optional tensor specifying lengths of the sequences in a batch. If not specified - assumed all sequences in the batch to have length `seq_length`. It has shape `[batch_size]`.</dd>
<dt><tt>initial_h</tt> (optional, non-differentiable) : T</dt>
<dd>Optional initial value of the hidden. If not specified - assumed to be 0. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
<dt><tt>initial_c</tt> (optional, non-differentiable) : T</dt>
<dd>Optional initial value of the cell. If not specified - assumed to be 0. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
<dt><tt>P</tt> (optional, differentiable) : T</dt>
<dd>The weight tensor for peepholes. Concatenation of `P[iof]` and `PB[iof]` (if bidirectional) along dimension 0. It has shape `[num_directions, 3*hidde_size]`. Optional: If not specified - assumed to be 0.</dd>
</dl>

#### Outputs (0 - 3)

<dl>
<dt><tt>Y</tt> (optional, differentiable) : T</dt>
<dd>A tensor that concats all the intermediate output values of the hidden. It has shape `[seq_length, num_directions, batch_size, hidden_size]`. </dd>
<dt><tt>Y_h</tt> (optional, differentiable) : T</dt>
<dd>The last output value of the hidden. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
<dt><tt>Y_c</tt> (optional, differentiable) : T</dt>
<dd>The last output value of the cell. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T1</tt> : tensor(int32)</dt>
<dd>Constrain seq_lens to integer tensor.</dd>
</dl>

### <a name="Mul-14"></a>**Mul-14**</a>

  Performs element-wise binary multiplication (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

  (Opset 14 change): Extend supported types to include uint8, int8, uint16, and int16.

#### Version

This version of the operator has been available since version 14 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> (differentiable) : T</dt>
<dd>First operand.</dd>
<dt><tt>B</tt> (differentiable) : T</dt>
<dd>Second operand.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> (differentiable) : T</dt>
<dd>Result, has same element type as two inputs</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to all numeric tensors.</dd>
</dl>

### <a name="RNN-14"></a>**RNN-14**</a>

  Computes an one-layer simple RNN. This operator is usually supported
  via some custom implementation such as CuDNN.

  Notations:

  `X` - input tensor

  `i` - input gate

  `t` - time step (t-1 means previous time step)

  `Wi` - W parameter weight matrix for input gate

  `Ri` - R recurrence weight matrix for input gate

  `Wbi` - W parameter bias vector for input gate

  `Rbi` - R parameter bias vector for input gate

  `WBi` - W parameter weight matrix for backward input gate

  `RBi` - R recurrence weight matrix for backward input gate

  `WBbi` - WR bias vectors for backward input gate

  `RBbi` - RR bias vectors for backward input gate

  `H` - Hidden state

  `num_directions` - 2 if direction == bidirectional else 1

  Activation functions:

    Relu(x)                - max(0, x)

    Tanh(x)                - (1 - e^{-2x})/(1 + e^{-2x})

    Sigmoid(x)             - 1/(1 + e^{-x})

    (NOTE: Below are optional)

    Affine(x)              - alpha*x + beta

    LeakyRelu(x)           - x if x >= 0 else alpha * x

    ThresholdedRelu(x)     - x if x >= alpha else 0

    ScaledTanh(x)          - alpha*Tanh(beta*x)

    HardSigmoid(x)         - min(max(alpha*x + beta, 0), 1)

    Elu(x)                 - x if x >= 0 else alpha*(e^x - 1)

    Softsign(x)            - x/(1 + |x|)

    Softplus(x)            - log(1 + e^x)

  Equations (Default: f=Tanh):

    - Ht = f(Xt*(Wi^T) + Ht-1*(Ri^T) + Wbi + Rbi)
  This operator has **optional** inputs/outputs. See [the doc](IR.md) for more details about the representation of optional arguments. An empty string may be used in the place of an actual argument's name to indicate a missing argument. Trailing optional arguments (those not followed by an argument that is present) may also be simply omitted.

#### Version

This version of the operator has been available since version 14 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>activation_alpha</tt> : list of floats</dt>
<dd>Optional scaling values used by some activation functions. The values are consumed in the order of activation functions, for example (f, g, h) in LSTM. Default values are the same as of corresponding ONNX operators.For example with LeakyRelu, the default alpha is 0.01.</dd>
<dt><tt>activation_beta</tt> : list of floats</dt>
<dd>Optional scaling values used by some activation functions. The values are consumed in the order of activation functions, for example (f, g, h) in LSTM. Default values are the same as of corresponding ONNX operators.</dd>
<dt><tt>activations</tt> : list of strings (default is ['Tanh', 'Tanh'])</dt>
<dd>One (or two if bidirectional) activation function for input gate. The activation function must be one of the activation functions specified above. Optional: Default `Tanh` if not specified.</dd>
<dt><tt>clip</tt> : float</dt>
<dd>Cell clip threshold. Clipping bounds the elements of a tensor in the range of [-threshold, +threshold] and is applied to the input of activations. No clip if not specified.</dd>
<dt><tt>direction</tt> : string (default is forward)</dt>
<dd>Specify if the RNN is forward, reverse, or bidirectional. Must be one of forward (default), reverse, or bidirectional.</dd>
<dt><tt>hidden_size</tt> : int</dt>
<dd>Number of neurons in the hidden layer</dd>
<dt><tt>layout</tt> : int (default is 0)</dt>
<dd>The shape format of inputs X, initial_h and outputs Y, Y_h. If 0, the following shapes are expected: X.shape = [seq_length, batch_size, input_size], Y.shape = [seq_length, num_directions, batch_size, hidden_size], initial_h.shape = Y_h.shape = [num_directions, batch_size, hidden_size]. If 1, the following shapes are expected: X.shape = [batch_size, seq_length, input_size], Y.shape = [batch_size, seq_length, num_directions, hidden_size], initial_h.shape = Y_h.shape = [batch_size, num_directions, hidden_size].</dd>
</dl>

#### Inputs (3 - 6)

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>The input sequences packed (and potentially padded) into one 3-D tensor with the shape of `[seq_length, batch_size, input_size]`.</dd>
<dt><tt>W</tt> (differentiable) : T</dt>
<dd>The weight tensor for input gate. Concatenation of `Wi` and `WBi` (if bidirectional). The tensor has shape `[num_directions, hidden_size, input_size]`.</dd>
<dt><tt>R</tt> (differentiable) : T</dt>
<dd>The recurrence weight tensor. Concatenation of `Ri` and `RBi` (if bidirectional). The tensor has shape `[num_directions, hidden_size, hidden_size]`.</dd>
<dt><tt>B</tt> (optional, differentiable) : T</dt>
<dd>The bias tensor for input gate. Concatenation of `[Wbi, Rbi]` and `[WBbi, RBbi]` (if bidirectional). The tensor has shape `[num_directions, 2*hidden_size]`. Optional: If not specified - assumed to be 0.</dd>
<dt><tt>sequence_lens</tt> (optional, non-differentiable) : T1</dt>
<dd>Optional tensor specifying lengths of the sequences in a batch. If not specified - assumed all sequences in the batch to have length `seq_length`. It has shape `[batch_size]`.</dd>
<dt><tt>initial_h</tt> (optional, non-differentiable) : T</dt>
<dd>Optional initial value of the hidden. If not specified - assumed to be 0. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
</dl>

#### Outputs (0 - 2)

<dl>
<dt><tt>Y</tt> (optional, differentiable) : T</dt>
<dd>A tensor that concats all the intermediate output values of the hidden. It has shape `[seq_length, num_directions, batch_size, hidden_size]`. </dd>
<dt><tt>Y_h</tt> (optional, differentiable) : T</dt>
<dd>The last output value of the hidden. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T1</tt> : tensor(int32)</dt>
<dd>Constrain seq_lens to integer tensor.</dd>
</dl>

### <a name="Relu-14"></a>**Relu-14**</a>

  Relu takes one input data (Tensor<T>) and produces one output data
  (Tensor<T>) where the rectified linear function, y = max(0, x), is applied to
  the tensor elementwise.

#### Version

This version of the operator has been available since version 14 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(int32), tensor(int8), tensor(int16), tensor(int64), tensor(float16), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to signed numeric tensors.</dd>
</dl>

### <a name="Reshape-14"></a>**Reshape-14**</a>

  Reshape the input tensor similar to numpy.reshape.
  First input is the data tensor, second input is a shape tensor which specifies the output shape. It outputs the reshaped tensor.
  At most one dimension of the new shape can be -1. In this case, the value is
  inferred from the size of the tensor and the remaining dimensions. A dimension
  could also be 0, in which case the actual dimension value is unchanged (i.e. taken
  from the input tensor). If 'allowzero' is set, and the new shape includes 0, the
  dimension will be set explicitly to zero (i.e. not taken from input tensor).
  Shape (second input) could be an empty shape, which means converting to a scalar.
  The input tensor's shape and the output tensor's shape are required to have the same number of elements.

#### Version

This version of the operator has been available since version 14 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>allowzero</tt> : int (default is 0)</dt>
<dd>(Optional) By default, when any value in the 'shape' input is equal to zero the corresponding dimension value is copied from the input tensor dynamically. allowzero=1 indicates that if any value in the 'shape' input is set to zero, the zero value is honored, similar to NumPy.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> (differentiable) : T</dt>
<dd>An input tensor.</dd>
<dt><tt>shape</tt> (non-differentiable) : tensor(int64)</dt>
<dd>Specified shape for output.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reshaped</tt> (differentiable) : T</dt>
<dd>Reshaped data.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

### <a name="Sub-14"></a>**Sub-14**</a>

  Performs element-wise binary subtraction (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

  (Opset 14 change): Extend supported types to include uint8, int8, uint16, and int16.

#### Version

This version of the operator has been available since version 14 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> (differentiable) : T</dt>
<dd>First operand.</dd>
<dt><tt>B</tt> (differentiable) : T</dt>
<dd>Second operand.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> (differentiable) : T</dt>
<dd>Result, has same element type as two inputs</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to all numeric tensors.</dd>
</dl>

### <a name="Trilu-14"></a>**Trilu-14**</a>

  Given a 2-D matrix or batches of 2-D matrices, returns the upper or lower triangular part of the tensor(s).
  The attribute "upper" determines whether the upper or lower part is retained. If set to true,
  the upper triangular matrix is retained. Lower triangular matrix is retained otherwise.
  Default value for the "upper" attribute is true.
  Trilu takes one input tensor of shape [*, N, M], where * is zero or more batch dimensions. The upper triangular part consists
  of the elements on and above the given diagonal (k). The lower triangular part consists of elements on and below the diagonal.
  All other elements in the matrix are set to zero.
  If k = 0, the triangular part on and above/below the main diagonal is retained.
  If upper is set to true, a positive k retains the upper triangular matrix excluding the main diagonal and (k-1) diagonals above it.
  A negative k value retains the main diagonal and |k| diagonals below it.
  If upper is set to false, a positive k retains the lower triangular matrix including the main diagonal and k diagonals above it.
  A negative k value excludes the main diagonal and (|k|-1) diagonals below it.

#### Version

This version of the operator has been available since version 14 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>upper</tt> : int (default is 1)</dt>
<dd>Boolean. Indicates whether upper or lower part of matrix is retained. Default is true.</dd>
</dl>

#### Inputs (1 - 2)

<dl>
<dt><tt>input</tt> (differentiable) : T</dt>
<dd>Input tensor of rank 2 or higher.</dd>
<dt><tt>k</tt> (optional, non-differentiable) : tensor(int64)</dt>
<dd>A 0-D tensor containing a single value corresponding to the number diagonals above or below the main diagonal to exclude or include. Default value is 0 if it's not specified.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>Output tensor of the same type and shape as the input tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types.</dd>
</dl>

## Version 15 of the default ONNX operator set
### <a name="BatchNormalization-15"></a>**BatchNormalization-15**</a>

  Carries out batch normalization as described in the paper
  https://arxiv.org/abs/1502.03167. Depending on the mode it is being run,
  There are five required inputs 'X', 'scale', 'B', 'input_mean' and
  'input_var'.
  Note that 'input_mean' and 'input_var' are expected to be the estimated
  statistics in inference mode (training_mode=False, default),
  and the running statistics in training mode (training_mode=True).
  There are multiple cases for the number of outputs, which we list below:

  Output case #1: Y, running_mean, running_var (training_mode=True)
  Output case #2: Y (training_mode=False)

  When training_mode=False, extra outputs are invalid.
  The outputs are updated as follows when training_mode=True:
  ```
  running_mean = input_mean * momentum + current_mean * (1 - momentum)
  running_var = input_var * momentum + current_var * (1 - momentum)

  Y = (X - current_mean) / sqrt(current_var + epsilon) * scale + B

  where:

  current_mean = ReduceMean(X, axis=all_except_channel_index)
  current_var =  ReduceVar(X, axis=all_except_channel_index)

  Notice that ReduceVar refers to the population variance, and it equals to
  sum(sqrd(x_i - x_avg)) / N
  where N is the population size (this formula does not use sample size N - 1).

  ```

  The computation of ReduceMean and ReduceVar uses float to avoid overflow for float16 inputs.

  When training_mode=False:
  ```
  Y = (X - input_mean) / sqrt(input_var + epsilon) * scale + B
  ```

  For previous (depreciated) non-spatial cases, implementors are suggested
  to flatten the input shape to (N x C * D1 * D2 * ... * Dn) before a BatchNormalization Op.
  This operator has **optional** inputs/outputs. See [the doc](IR.md) for more details about the representation of optional arguments. An empty string may be used in the place of an actual argument's name to indicate a missing argument. Trailing optional arguments (those not followed by an argument that is present) may also be simply omitted.

#### Version

This version of the operator has been available since version 15 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>epsilon</tt> : float (default is 1e-05)</dt>
<dd>The epsilon value to use to avoid division by zero.</dd>
<dt><tt>momentum</tt> : float (default is 0.9)</dt>
<dd>Factor used in computing the running mean and variance.e.g., running_mean = running_mean * momentum + mean * (1 - momentum).</dd>
<dt><tt>training_mode</tt> : int (default is 0)</dt>
<dd>If set to true, it indicates BatchNormalization is being used for training, and outputs 1, 2, 3, and 4 would be populated.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input data tensor from the previous operator; dimensions are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size, C is the number of channels. Statistics are computed for every channel of C over N and D1 to Dn dimensions. For image data, input dimensions become (N x C x H x W). The op also accepts single dimension input of size N in which case C is assumed to be 1</dd>
<dt><tt>scale</tt> (differentiable) : T1</dt>
<dd>Scale tensor of shape (C).</dd>
<dt><tt>B</tt> (differentiable) : T1</dt>
<dd>Bias tensor of shape (C).</dd>
<dt><tt>input_mean</tt> (differentiable) : T2</dt>
<dd>running (training) or estimated (testing) mean tensor of shape (C).</dd>
<dt><tt>input_var</tt> (differentiable) : T2</dt>
<dd>running (training) or estimated (testing) variance tensor of shape (C).</dd>
</dl>

#### Outputs (1 - 3)

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>The output tensor of the same shape as X</dd>
<dt><tt>running_mean</tt> (optional, non-differentiable) : T2</dt>
<dd>The running mean after the BatchNormalization operator.</dd>
<dt><tt>running_var</tt> (optional, non-differentiable) : T2</dt>
<dd>The running variance after the BatchNormalization operator. This op uses the population size (N) for calculating variance, and not the sample size N-1.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T1</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain scale and bias types to float tensors.</dd>
<dt><tt>T2</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain mean and variance types to float tensors.</dd>
</dl>

### <a name="Bernoulli-15"></a>**Bernoulli-15**</a>

  Draws binary random numbers (0 or 1) from a Bernoulli distribution. The input tensor should be a tensor
  containing probabilities p (a value in the range [0,1]) to be used for drawing the binary random number,
  where an output of 1 is produced with probability p and an output of 0 is produced with probability (1-p).

  This operator is non-deterministic and may not produce the same values in different
  implementations (even if a seed is specified).

#### Version

This version of the operator has been available since version 15 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>dtype</tt> : int</dt>
<dd>The data type for the elements of the output tensor. if not specified, we will use the data type of the input tensor.</dd>
<dt><tt>seed</tt> : float</dt>
<dd>(Optional) Seed to the random generator, if not specified we will auto generate one.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T1</dt>
<dd>All values in input have to be in the range:[0, 1].</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T2</dt>
<dd>The returned output tensor only has values 0 or 1, same shape as input tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input types to float tensors.</dd>
<dt><tt>T2</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16), tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bool)</dt>
<dd>Constrain output types to all numeric tensors and bool tensors.</dd>
</dl>

### <a name="CastLike-15"></a>**CastLike-15**</a>

  The operator casts the elements of a given input tensor (the first input) to
  the same data type as the elements of the second input tensor.
  See documentation of the Cast operator for further details.

#### Version

This version of the operator has been available since version 15 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : T1</dt>
<dd>Input tensor to be cast.</dd>
<dt><tt>target_type</tt> (non-differentiable) : T2</dt>
<dd>The (first) input tensor will be cast to produce a tensor of the same type as this (second input) tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T2</dt>
<dd>Output tensor produced by casting the first input tensor to have the same type as the second input tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float16), tensor(float), tensor(double), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(bool), tensor(string), tensor(bfloat16)</dt>
<dd>Constrain input types. Casting from complex is not supported.</dd>
<dt><tt>T2</tt> : tensor(float16), tensor(float), tensor(double), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(bool), tensor(string), tensor(bfloat16)</dt>
<dd>Constrain output types. Casting to complex is not supported.</dd>
</dl>

### <a name="Optional-15"></a>**Optional-15**</a>

  Constructs an optional-type value containing either an empty optional of a certain type specified by the attribute,
  or a non-empty value containing the input element.

#### Version

This version of the operator has been available since version 15 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>type</tt> : type_proto</dt>
<dd>Type of the element in the optional output</dd>
</dl>

#### Inputs (0 - 1)

<dl>
<dt><tt>input</tt> (optional) : V</dt>
<dd>The input element.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : O</dt>
<dd>The optional output enclosing the input element.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>V</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128), seq(tensor(uint8)), seq(tensor(uint16)), seq(tensor(uint32)), seq(tensor(uint64)), seq(tensor(int8)), seq(tensor(int16)), seq(tensor(int32)), seq(tensor(int64)), seq(tensor(float16)), seq(tensor(float)), seq(tensor(double)), seq(tensor(string)), seq(tensor(bool)), seq(tensor(complex64)), seq(tensor(complex128))</dt>
<dd>Constrain input type to all tensor and sequence types.</dd>
<dt><tt>O</tt> : optional(seq(tensor(uint8))), optional(seq(tensor(uint16))), optional(seq(tensor(uint32))), optional(seq(tensor(uint64))), optional(seq(tensor(int8))), optional(seq(tensor(int16))), optional(seq(tensor(int32))), optional(seq(tensor(int64))), optional(seq(tensor(float16))), optional(seq(tensor(float))), optional(seq(tensor(double))), optional(seq(tensor(string))), optional(seq(tensor(bool))), optional(seq(tensor(complex64))), optional(seq(tensor(complex128))), optional(tensor(uint8)), optional(tensor(uint16)), optional(tensor(uint32)), optional(tensor(uint64)), optional(tensor(int8)), optional(tensor(int16)), optional(tensor(int32)), optional(tensor(int64)), optional(tensor(float16)), optional(tensor(float)), optional(tensor(double)), optional(tensor(string)), optional(tensor(bool)), optional(tensor(complex64)), optional(tensor(complex128))</dt>
<dd>Constrain output type to all optional tensor or optional sequence types.</dd>
</dl>

### <a name="OptionalGetElement-15"></a>**OptionalGetElement-15**</a>

  Outputs the element in the optional-type input. It is an error if the input value does not have an element
  and the behavior is undefined in this case.

#### Version

This version of the operator has been available since version 15 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> : O</dt>
<dd>The optional input.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : V</dt>
<dd>Output element in the optional input.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>O</tt> : optional(seq(tensor(uint8))), optional(seq(tensor(uint16))), optional(seq(tensor(uint32))), optional(seq(tensor(uint64))), optional(seq(tensor(int8))), optional(seq(tensor(int16))), optional(seq(tensor(int32))), optional(seq(tensor(int64))), optional(seq(tensor(float16))), optional(seq(tensor(float))), optional(seq(tensor(double))), optional(seq(tensor(string))), optional(seq(tensor(bool))), optional(seq(tensor(complex64))), optional(seq(tensor(complex128))), optional(tensor(uint8)), optional(tensor(uint16)), optional(tensor(uint32)), optional(tensor(uint64)), optional(tensor(int8)), optional(tensor(int16)), optional(tensor(int32)), optional(tensor(int64)), optional(tensor(float16)), optional(tensor(float)), optional(tensor(double)), optional(tensor(string)), optional(tensor(bool)), optional(tensor(complex64)), optional(tensor(complex128))</dt>
<dd>Constrain input type to optional tensor and optional sequence types.</dd>
<dt><tt>V</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128), seq(tensor(uint8)), seq(tensor(uint16)), seq(tensor(uint32)), seq(tensor(uint64)), seq(tensor(int8)), seq(tensor(int16)), seq(tensor(int32)), seq(tensor(int64)), seq(tensor(float16)), seq(tensor(float)), seq(tensor(double)), seq(tensor(string)), seq(tensor(bool)), seq(tensor(complex64)), seq(tensor(complex128))</dt>
<dd>Constrain output type to all tensor or sequence types.</dd>
</dl>

### <a name="OptionalHasElement-15"></a>**OptionalHasElement-15**</a>

  Returns true if the optional-type input contains an element. If it is an empty optional-type, this op returns false.

#### Version

This version of the operator has been available since version 15 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> : O</dt>
<dd>The optional input.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : B</dt>
<dd>A scalar boolean tensor. If true, it indicates that optional-type input contains an element. Otherwise, it is empty.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>O</tt> : optional(seq(tensor(uint8))), optional(seq(tensor(uint16))), optional(seq(tensor(uint32))), optional(seq(tensor(uint64))), optional(seq(tensor(int8))), optional(seq(tensor(int16))), optional(seq(tensor(int32))), optional(seq(tensor(int64))), optional(seq(tensor(float16))), optional(seq(tensor(float))), optional(seq(tensor(double))), optional(seq(tensor(string))), optional(seq(tensor(bool))), optional(seq(tensor(complex64))), optional(seq(tensor(complex128))), optional(tensor(uint8)), optional(tensor(uint16)), optional(tensor(uint32)), optional(tensor(uint64)), optional(tensor(int8)), optional(tensor(int16)), optional(tensor(int32)), optional(tensor(int64)), optional(tensor(float16)), optional(tensor(float)), optional(tensor(double)), optional(tensor(string)), optional(tensor(bool)), optional(tensor(complex64)), optional(tensor(complex128))</dt>
<dd>Constrain input type to optional tensor and optional sequence types.</dd>
<dt><tt>B</tt> : tensor(bool)</dt>
<dd>Constrain output to a boolean tensor.</dd>
</dl>

### <a name="Pow-15"></a>**Pow-15**</a>

  Pow takes input data (Tensor<T>) and exponent Tensor, and
  produces one output data (Tensor<T>) where the function `f(x) = x^exponent`,
  is applied to the data tensor elementwise.
  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 15 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>First operand, base of the exponent.</dd>
<dt><tt>Y</tt> (differentiable) : T1</dt>
<dd>Second operand, power of the exponent.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Z</tt> (differentiable) : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input X and output types to float/int tensors.</dd>
<dt><tt>T1</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input Y types to float/int tensors.</dd>
</dl>

### <a name="Shape-15"></a>**Shape-15**</a>

  Takes a tensor as input and outputs an 1D int64 tensor containing the shape of the input tensor.
  Optional attributes start and end can be used to compute a slice of the input tensor's shape.
  If start axis is omitted, the slice starts from axis 0.
  The end axis, if specified, is exclusive (and the returned value will not include the size of that axis).
  If the end axis is omitted, the axes upto the last one will be included.
  Negative axes indicate counting back from the last axis.
  Note that axes will be clamped to the range [0, r-1], where r is the
  rank of the input tensor if they are out-of-range (after adding r in the case of
  negative axis). Thus, specifying any end value > r is equivalent to specifying an end
  value of r, and specifying any start value < -r is equivalent to specifying a start
  value of 0.

  For example:
  Input tensor with shape: [2, 3, 4]
  No attributes specified.
  Output: [2, 3, 4]

  Input tensor with shape: [2, 3, 4]
  start: -1
  Output: [4]

  Input tensor with shape: [2, 3, 4]
  end: -1
  Output: [2, 3]

  Input tensor with shape: [2, 3, 4]
  start: 1
  end: 2
  Output: [3]

#### Version

This version of the operator has been available since version 15 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>end</tt> : int</dt>
<dd>(Optional) Ending axis for slicing the shape. Negative value means counting dimensions from the back. If omitted, sizes of all axes upto (including) the last one will be included.</dd>
<dt><tt>start</tt> : int (default is 0)</dt>
<dd>(Optional) Starting axis for slicing the shape. Default value is 0.Negative value means counting dimensions from the back.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> (non-differentiable) : T</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>shape</tt> (non-differentiable) : T1</dt>
<dd>Shape of the input tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Input tensor can be of arbitrary type.</dd>
<dt><tt>T1</tt> : tensor(int64)</dt>
<dd>Constrain output to int64 tensor.</dd>
</dl>

## Version 16 of the default ONNX operator set
### <a name="GreaterOrEqual-16"></a>**GreaterOrEqual-16**</a>

  Returns the tensor resulted from performing the `greater_equal` logical operation
  elementwise on the input tensors `A` and `B` (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 16 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> (non-differentiable) : T</dt>
<dd>First input operand for the logical operator.</dd>
<dt><tt>B</tt> (non-differentiable) : T</dt>
<dd>Second input operand for the logical operator.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> (non-differentiable) : T1</dt>
<dd>Result tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input types to all numeric tensors.</dd>
<dt><tt>T1</tt> : tensor(bool)</dt>
<dd>Constrain output to boolean tensor.</dd>
</dl>

### <a name="GridSample-16"></a>**GridSample-16**</a>

  Given an `input` and a flow-field `grid`, computes the `output` using `input` values and pixel locations from `grid`.
  Currently, only spatial (4-D) inputs are supported. For `input` with shape (N, C, H, W) and `grid` with shape (N, H_out, W_out, 2),
  the `output` will have shape (N, C, H_out, W_out).
  For each output location `output[N, C, H_out, W_out]`, the size-2 vector `grid[N, H_out, W_out]` specifies `input` pixel locations `x` and `y`,
  which are used to interpolate the output value `output[N, C, H_out, W_out]`.

  The GridSample operator is often used in doing grid generator and sampler in the [Spatial Transformer Networks](https://arxiv.org/abs/1506.02025).
  See also in [torch.nn.functional.grid_sample](https://pytorch.org/docs/master/generated/torch.nn.functional.grid_sample.html#torch-nn-functional-grid-sample).

#### Version

This version of the operator has been available since version 16 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>align_corners</tt> : int (default is 0)</dt>
<dd>If align_corners=1, the extrema (-1 and 1) are considered as referring to the center points of the input's corner pixels. If align_corners=0, they are instead considered as referring to the corner points of the input's corner pixels, making the sampling more resolution agnostic.</dd>
<dt><tt>mode</tt> : string (default is bilinear)</dt>
<dd>Three interpolation modes: bilinear (default), nearest and bicubic.</dd>
<dt><tt>padding_mode</tt> : string (default is zeros)</dt>
<dd>Support padding modes for outside grid values: `zeros`(default), `border`, `reflection`. zeros: use 0 for out-of-bound grid locations, border: use border values for out-of-bound grid locations, reflection: use values at locations reflected by the border for out-of-bound grid locations. If index 0 represents the margin pixel, the reflected value at index -1 will be the same as the value at index 1. For location far away from the border, it will keep being reflected until becoming in bound. If pixel location x = -3.5 reflects by border -1 and becomes x' = 1.5, then reflects by border 1 and becomes x'' = 0.5.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T1</dt>
<dd>4-D tensor of shape (N, C, H, W), where N is the batch size, C is the numbers of channels, H and W are the height and width of the input data.</dd>
<dt><tt>grid</tt> (non-differentiable) : T1</dt>
<dd>Input offset, 4-D tensor of shape (N, H_out, W_out, 2), where H_out and W_out are the height and width of grid and output, Grid specifies the sampling pixel locations normalized by the input spatial dimensions. Therefore, it should have most values in the range of [-1, 1]. If grid has values outside the range of [-1, 1], the corresponding outputs will be handled as defined by padding_mode.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T2</dt>
<dd>4-D tensor of shape (N, C, H_out, W_out).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input types to all tensor types.</dd>
<dt><tt>T2</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain output types to float tensors.</dd>
</dl>

### <a name="Identity-16"></a>**Identity-16**</a>

  Identity operator

#### Version

This version of the operator has been available since version 16 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>input</tt> (differentiable) : V</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : V</dt>
<dd>Tensor to copy input into.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>V</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128), seq(tensor(uint8)), seq(tensor(uint16)), seq(tensor(uint32)), seq(tensor(uint64)), seq(tensor(int8)), seq(tensor(int16)), seq(tensor(int32)), seq(tensor(int64)), seq(tensor(float16)), seq(tensor(float)), seq(tensor(double)), seq(tensor(string)), seq(tensor(bool)), seq(tensor(complex64)), seq(tensor(complex128)), optional(seq(tensor(uint8))), optional(seq(tensor(uint16))), optional(seq(tensor(uint32))), optional(seq(tensor(uint64))), optional(seq(tensor(int8))), optional(seq(tensor(int16))), optional(seq(tensor(int32))), optional(seq(tensor(int64))), optional(seq(tensor(float16))), optional(seq(tensor(float))), optional(seq(tensor(double))), optional(seq(tensor(string))), optional(seq(tensor(bool))), optional(seq(tensor(complex64))), optional(seq(tensor(complex128))), optional(tensor(uint8)), optional(tensor(uint16)), optional(tensor(uint32)), optional(tensor(uint64)), optional(tensor(int8)), optional(tensor(int16)), optional(tensor(int32)), optional(tensor(int64)), optional(tensor(float16)), optional(tensor(float)), optional(tensor(double)), optional(tensor(string)), optional(tensor(bool)), optional(tensor(complex64)), optional(tensor(complex128))</dt>
<dd>Constrain input and output types to all tensor, sequence, and optional types.</dd>
</dl>

### <a name="If-16"></a>**If-16**</a>

  If conditional

#### Version

This version of the operator has been available since version 16 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>else_branch</tt> : graph (required)</dt>
<dd>Graph to run if condition is false. Has N outputs: values you wish to be live-out to the enclosing scope. The number of outputs must match the number of outputs in the then_branch.</dd>
<dt><tt>then_branch</tt> : graph (required)</dt>
<dd>Graph to run if condition is true. Has N outputs: values you wish to be live-out to the enclosing scope. The number of outputs must match the number of outputs in the else_branch.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>cond</tt> : B</dt>
<dd>Condition for the if</dd>
</dl>

#### Outputs (1 - &#8734;)

<dl>
<dt><tt>outputs</tt> (variadic, heterogeneous) : V</dt>
<dd>Values that are live-out to the enclosing scope. The return values in the `then_branch` and `else_branch` must be of the same data type. The `then_branch` and `else_branch` may produce tensors with the same element type and different shapes. If corresponding outputs from the then-branch and the else-branch have static shapes S1 and S2, then the shape of the corresponding output variable of the if-node (if present) must be compatible with both S1 and S2 as it represents the union of both possible shapes.For example, if in a model file, the the first output of `then_branch` is typed float tensor with shape [2] and the first output of `else_branch` is another float tensor with shape [3], If's first output should have (a) no shape set, or (b) a shape of rank 1 with neither `dim_value` nor `dim_param` set, or (c) a shape of rank 1 with a unique `dim_param`. In contrast, the first output cannot have the shape [2] since [2] and [3] are not compatible.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>V</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128), seq(tensor(uint8)), seq(tensor(uint16)), seq(tensor(uint32)), seq(tensor(uint64)), seq(tensor(int8)), seq(tensor(int16)), seq(tensor(int32)), seq(tensor(int64)), seq(tensor(bfloat16)), seq(tensor(float16)), seq(tensor(float)), seq(tensor(double)), seq(tensor(string)), seq(tensor(bool)), seq(tensor(complex64)), seq(tensor(complex128)), optional(seq(tensor(uint8))), optional(seq(tensor(uint16))), optional(seq(tensor(uint32))), optional(seq(tensor(uint64))), optional(seq(tensor(int8))), optional(seq(tensor(int16))), optional(seq(tensor(int32))), optional(seq(tensor(int64))), optional(seq(tensor(bfloat16))), optional(seq(tensor(float16))), optional(seq(tensor(float))), optional(seq(tensor(double))), optional(seq(tensor(string))), optional(seq(tensor(bool))), optional(seq(tensor(complex64))), optional(seq(tensor(complex128))), optional(tensor(uint8)), optional(tensor(uint16)), optional(tensor(uint32)), optional(tensor(uint64)), optional(tensor(int8)), optional(tensor(int16)), optional(tensor(int32)), optional(tensor(int64)), optional(tensor(bfloat16)), optional(tensor(float16)), optional(tensor(float)), optional(tensor(double)), optional(tensor(string)), optional(tensor(bool)), optional(tensor(complex64)), optional(tensor(complex128))</dt>
<dd>All Tensor, Sequence(Tensor), Optional(Tensor), and Optional(Sequence(Tensor)) types</dd>
<dt><tt>B</tt> : tensor(bool)</dt>
<dd>Only bool</dd>
</dl>

### <a name="LeakyRelu-16"></a>**LeakyRelu-16**</a>

  LeakyRelu takes input data (Tensor<T>) and an argument alpha, and produces one
  output data (Tensor<T>) where the function `f(x) = alpha * x for x < 0`,
  `f(x) = x for x >= 0`, is applied to the data tensor elementwise.

  **History**
  - Version 16 adds bfloat16 to the types allowed.

#### Version

This version of the operator has been available since version 16 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float (default is 0.01)</dt>
<dd>Coefficient of leakage.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(bfloat16), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="LessOrEqual-16"></a>**LessOrEqual-16**</a>

  Returns the tensor resulted from performing the `less_equal` logical operation
  elementwise on the input tensors `A` and `B` (with Numpy-style broadcasting support).

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 16 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>A</tt> (non-differentiable) : T</dt>
<dd>First input operand for the logical operator.</dd>
<dt><tt>B</tt> (non-differentiable) : T</dt>
<dd>Second input operand for the logical operator.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> (non-differentiable) : T1</dt>
<dd>Result tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input types to all numeric tensors.</dd>
<dt><tt>T1</tt> : tensor(bool)</dt>
<dd>Constrain output to boolean tensor.</dd>
</dl>

### <a name="Loop-16"></a>**Loop-16**</a>

  Generic Looping construct. This loop has multiple termination conditions:

  1) Trip count. Iteration count specified at runtime. Set by
     specifying the input M. Optional. Set to empty string to omit.
     Note that a static trip count (specified at graph construction time) can be
     specified by passing in a constant node for input M.
  2) Loop termination condition. This is an input to the op that determines
     whether to run the first iteration and also a loop-carried dependency for
     the body graph. The body graph must yield a value for the condition variable,
     whether this input is provided or not.

  This table summarizes the operating modes of this operator with equivalent
  C-style code:

      Operator inputs defined as (max_trip_count, condition_var).

      input ("", ""):
          for (int i=0; ; ++i) {
            cond = ... // Note this value is ignored, but is required in the body
          }

      input ("", cond) // Note this is analogous to a while loop
          bool cond = ...;
          for (int i=0; cond; ++i) {
            cond = ...;
          }

      input ("", 1) // Note this is analogous to a do-while loop
          bool cond = true
          for (int i=0; cond; ++i) {
            cond = ...;
          }

      input (trip_count, "") // Note this is analogous to a for loop
          int trip_count = ...
          for (int i=0; i < trip_count; ++i) {
            cond = ...; // ignored
          }

      input (trip_count, cond)
          int trip_count = ...;
          bool cond = ...;
          for (int i=0; i < trip_count && cond; ++i) {
            cond = ...;
          }


  *Sample usage - cond as well as trip count*

      graph predict-net {
        %a = Constant[value = <Scalar Tensor [3]>]()
        %b = Constant[value = <Scalar Tensor [6]>]()
        %keepgoing = Constant[value = <Scalar Tensor [1]>]()
        %max_trip_count = Constant[value = <Scalar Tensor [10]>]()
        %keepgoing_out, %b_out, %user_defined_vals = Loop[body = <graph body-net>](%max_trip_count, %keepgoing, %b)
        return
      }

      graph body-net (
        %i[INT32, scalar]           // iteration number
        %keepgoing_in[BOOL, scalar] // incoming loop-termination-condition; not used
        %b_in[INT32, scalar]        // incoming value of loop-carried-dependency b
      ) {
        %my_local = Add(%a, %b_in)
        %b_out = Sub(%a, %b_in) // outgoing value of loop-carried-dependency b
        %keepgoing_out = Greater(%my_local, %b_out) // outgoing loop-termination-condition
        %user_defined_val = Add(%b_in, %b_in) // scan-output value to be accumulated
        return %keepgoing_out, %b_out, %user_defined_val
      }

  *Sample equivalent C code*

      {
        /* User-defined code (enclosing scope) */
        int a = 3, b = 6;
        bool keepgoing = true; // Analogous to input cond
        /* End user-defined code */

        /* Implicitly-defined code */
        const int max_trip_count = 10; // Analogous to input M
        int user_defined_vals[]; // Imagine this is resizable
        /* End implicitly-defined code */
        /* initialize loop-carried variables and scan-output variables */
        bool keepgoing_out = keepgoing
        int b_out = b

        for (int i=0; i < max_trip_count && keepgoing_out; ++i) {
          /* Implicitly-defined code: bind actual parameter values
             to formal parameter variables of loop-body */
          bool keepgoing_in = keepgoing_out;
          bool b_in = b_out;

          /* User-defined code (loop body) */
          int my_local = a + b_in; // Reading value "a" from the enclosing scope is fine
          b_out = a - b_in;
          keepgoing_out = my_local > b_out;
          user_defined_val = b_in + b_in; // b_in and b_out are different variables
          /* End user-defined code */

          /* Implicitly defined-code */
          user_defined_vals[i] = user_defined_val // accumulate scan-output values
        }
        // int t = my_local; // Can't do this. my_local is not accessible here.

        // The values below are bound to the output variables of the loop and therefore accessible
        // b_out; user_defined_vals; keepgoing_out;
      }

  There are several things of note in this code snippet:

  1) Values from the enclosing scope (i.e. variable "a" here) are in scope and can
     be referenced in the inputs of the loop.
  2) Any values computed in the loop body that needs to be used in a subsequent
     iteration or after the loop are modelled using a pair of variables in the loop-body,
     consisting of an input variable (eg., b_in) and an output variable (eg., b_out).
     These are referred to as loop-carried dependences. The loop operation node
     supplies the input value of the input variable for the first iteration, and
     returns the output value of the output variable produced by the final
     iteration.
  3) Scan_output variables are used to implicitly concatenate values computed across
     all the iterations. In the above example, the value of user_defined_val computed
     over all iterations are concatenated and returned as the value of user_defined_vals
     after the loop.
  4) Values created in the body cannot be accessed in the enclosing scope,
     except using the mechanism described above.

  Note that the semantics of this op support "diagonal" or "wavefront" execution.
  (See Step 3 here for an example:
  https://devblogs.nvidia.com/optimizing-recurrent-neural-networks-cudnn-5/).
  Frontends should emit multi-layer RNNs as a series of While operators (with
  time being the inner looping dimension), with each successive layer consuming
  the scan_outputs from the previous layer, possibly going through several
  point-wise operators (e.g. dropout, residual connections, linear layer).

  The input/output of subgraph (produced by loop node) matching is based on order instead of name. The implementation will figure out the names based on this order.

#### Version

This version of the operator has been available since version 16 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>body</tt> : graph (required)</dt>
<dd>The graph run each iteration. It has 2+N inputs: (iteration_num, condition, loop carried dependencies...). It has 1+N+K outputs: (condition, loop carried dependencies..., scan_outputs...). Each scan_output is created by concatenating the value of the specified output value at the end of each iteration of the loop. It is an error if the dimensions or data type of these scan_outputs change across loop iterations.</dd>
</dl>

#### Inputs (2 - &#8734;)

<dl>
<dt><tt>M</tt> (optional) : I</dt>
<dd>A maximum trip-count for the loop specified at runtime. Optional. Pass empty string to skip.</dd>
<dt><tt>cond</tt> (optional) : B</dt>
<dd>A boolean termination condition. Optional. Pass empty string to skip.</dd>
<dt><tt>v_initial</tt> (variadic, heterogeneous) : V</dt>
<dd>The initial values of any loop-carried dependencies (values that change across loop iterations)</dd>
</dl>

#### Outputs (1 - &#8734;)

<dl>
<dt><tt>v_final_and_scan_outputs</tt> (variadic, heterogeneous) : V</dt>
<dd>Final N loop carried dependency values then K scan_outputs. Scan outputs must be Tensors.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>V</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128), seq(tensor(uint8)), seq(tensor(uint16)), seq(tensor(uint32)), seq(tensor(uint64)), seq(tensor(int8)), seq(tensor(int16)), seq(tensor(int32)), seq(tensor(int64)), seq(tensor(bfloat16)), seq(tensor(float16)), seq(tensor(float)), seq(tensor(double)), seq(tensor(string)), seq(tensor(bool)), seq(tensor(complex64)), seq(tensor(complex128)), optional(seq(tensor(uint8))), optional(seq(tensor(uint16))), optional(seq(tensor(uint32))), optional(seq(tensor(uint64))), optional(seq(tensor(int8))), optional(seq(tensor(int16))), optional(seq(tensor(int32))), optional(seq(tensor(int64))), optional(seq(tensor(bfloat16))), optional(seq(tensor(float16))), optional(seq(tensor(float))), optional(seq(tensor(double))), optional(seq(tensor(string))), optional(seq(tensor(bool))), optional(seq(tensor(complex64))), optional(seq(tensor(complex128))), optional(tensor(uint8)), optional(tensor(uint16)), optional(tensor(uint32)), optional(tensor(uint64)), optional(tensor(int8)), optional(tensor(int16)), optional(tensor(int32)), optional(tensor(int64)), optional(tensor(bfloat16)), optional(tensor(float16)), optional(tensor(float)), optional(tensor(double)), optional(tensor(string)), optional(tensor(bool)), optional(tensor(complex64)), optional(tensor(complex128))</dt>
<dd>All Tensor, Sequence(Tensor), Optional(Tensor), and Optional(Sequence(Tensor)) types</dd>
<dt><tt>I</tt> : tensor(int64)</dt>
<dd>tensor of int64, which should be a scalar.</dd>
<dt><tt>B</tt> : tensor(bool)</dt>
<dd>tensor of bool, which should be a scalar.</dd>
</dl>

### <a name="PRelu-16"></a>**PRelu-16**</a>

  PRelu takes input data (Tensor<T>) and slope tensor as input, and produces one
  output data (Tensor<T>) where the function `f(x) = slope * x for x < 0`,
  `f(x) = x for x >= 0`., is applied to the data tensor elementwise.

  **History**
  - Version 16 adds bfloat16 to the types allowed.
  This operator supports **unidirectional broadcasting** (tensor slope should be unidirectional broadcastable to input tensor X); for more details please check [the doc](Broadcasting.md).

#### Version

This version of the operator has been available since version 16 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>Input tensor</dd>
<dt><tt>slope</tt> (differentiable) : T</dt>
<dd>Slope tensor. The shape of slope can be smaller then first input X; if so, its shape must be unidirectional broadcastable to X</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>Output tensor (same size as X)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(uint32), tensor(uint64), tensor(int32), tensor(int64)</dt>
<dd>Constrain input and output types to float/int tensors.</dd>
</dl>

### <a name="RoiAlign-16"></a>**RoiAlign-16**</a>

  Region of Interest (RoI) align operation described in the
  [Mask R-CNN paper](https://arxiv.org/abs/1703.06870).
  RoiAlign consumes an input tensor X and region of interests (rois)
  to apply pooling across each RoI; it produces a 4-D tensor of shape
  (num_rois, C, output_height, output_width).

  RoiAlign is proposed to avoid the misalignment by removing
  quantizations while converting from original image into feature
  map and from feature map into RoI feature; in each ROI bin,
  the value of the sampled locations are computed directly
  through bilinear interpolation.

#### Version

This version of the operator has been available since version 16 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>coordinate_transformation_mode</tt> : string (default is half_pixel)</dt>
<dd>Allowed values are 'half_pixel' and 'output_half_pixel'. Use the value 'half_pixel' to pixel shift the input coordinates by -0.5 (the recommended behavior). Use the value 'output_half_pixel' to omit the pixel shift for the input (use this for a backward-compatible behavior).</dd>
<dt><tt>mode</tt> : string (default is avg)</dt>
<dd>The pooling method. Two modes are supported: 'avg' and 'max'. Default is 'avg'.</dd>
<dt><tt>output_height</tt> : int (default is 1)</dt>
<dd>default 1; Pooled output Y's height.</dd>
<dt><tt>output_width</tt> : int (default is 1)</dt>
<dd>default 1; Pooled output Y's width.</dd>
<dt><tt>sampling_ratio</tt> : int (default is 0)</dt>
<dd>Number of sampling points in the interpolation grid used to compute the output value of each pooled output bin. If > 0, then exactly sampling_ratio x sampling_ratio grid points are used. If == 0, then an adaptive number of grid points are used (computed as ceil(roi_width / output_width), and likewise for height). Default is 0.</dd>
<dt><tt>spatial_scale</tt> : float (default is 1.0)</dt>
<dd>Multiplicative spatial scale factor to translate ROI coordinates from their input spatial scale to the scale used when pooling, i.e., spatial scale of the input feature map X relative to the input image. E.g.; default is 1.0f. </dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T1</dt>
<dd>Input data tensor from the previous operator; 4-D feature map of shape (N, C, H, W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data.</dd>
<dt><tt>rois</tt> : T1</dt>
<dd>RoIs (Regions of Interest) to pool over; rois is 2-D input of shape (num_rois, 4) given as [[x1, y1, x2, y2], ...]. The RoIs' coordinates are in the coordinate system of the input image. Each coordinate set has a 1:1 correspondence with the 'batch_indices' input.</dd>
<dt><tt>batch_indices</tt> : T2</dt>
<dd>1-D tensor of shape (num_rois,) with each element denoting the index of the corresponding image in the batch.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T1</dt>
<dd>RoI pooled output, 4-D tensor of shape (num_rois, C, output_height, output_width). The r-th batch element Y[r-1] is a pooled feature map corresponding to the r-th RoI X[r-1].</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain types to float tensors.</dd>
<dt><tt>T2</tt> : tensor(int64)</dt>
<dd>Constrain types to int tensors.</dd>
</dl>

### <a name="Scan-16"></a>**Scan-16**</a>

  Scan can be used to iterate over one or more scan_input tensors,
  constructing zero or more scan_output tensors. It combines ideas from general recurrences,
  functional programming constructs such as scan, fold, map, and zip, and is intended to enable
  generalizations of RNN-like constructs for sequence-to-sequence processing.
  Other tensors (referred to as state_variables here) can be used to carry a state
  when iterating from one element to another (similar to hidden-state in RNNs, also referred
  to as loop-carried dependences in the context of loops).
  Many common usages involve a single scan_input tensor (where functionality
  similar to scan, fold and map can be obtained). When more than one scan_input is used,
  a behavior similar to zip is obtained.

  The attribute body must be a graph, specifying the computation to be performed in
  every iteration. It takes as input the current values of the state_variables and
  the current iterated element of the scan_inputs. It must return the (updated) values
  of the state_variables and zero or more scan_output_element tensors. The values of the
  scan_output_element tensors are concatenated over all the iterations to produce the
  scan_output values of the scan construct (similar to the concatenated intermediate
  hidden-state values of RNN-like constructs). All the output tensors (state_variables as
  well as scan_output_element tensors) are required to have the same shape in each iteration
  of the loop (a restriction imposed to enable efficient memory allocation).

  Note that the iterated element passed to the body subgraph does not have a sequence
  axis. It will have a rank one less than the rank of the corresponding scan_input.

  The scan operation returns the final values of the state_variables as well as the
  scan_outputs.

  The optional attribute scan_input_directions specifies the direction (forward or backward)
  for each scan input. If this attribute is omitted, all sequences are scanned in the forward
  direction. A bidirectional scan may be performed by specifying the same tensor input twice
  in the scan_inputs, once with a forward direction, and once with a backward direction.

  The scan_output of the operation is produced by concatenating the scan_output_element
  values produced by the body in each iteration.  The optional attribute scan_output_directions
  specifies the direction in which scan_output is constructed (by appending or prepending the
  scan_output_element to scan_output in each iteration) for each scan_output. If this attribute
  is omitted, the scan_output_element is appended to the scan_output in each iteration.

  The optional attribute scan_input_axes specifies the axis to be scanned for each scan_input.
  If omitted, every scan_input will be scanned in axis 0. For example, if axis 0 is the
  batch axis and axis 1 is the time axis (to be scanned), specify an axis value of 1.
  Note that scanning a non-zero axis may be less efficient than scanning axis zero.

  The optional attribute scan_output_axes specifies the axis along which the scan_outputs
  are accumulated for each scan_output. For example, if axis 1 is the time axis (to be
  scanned) for both inputs and outputs, specify a scan_input axis and scan_output axis
  value of 1.

  Note that because of the ONNX restriction that only the last parameter of an operator can
  be variadic, the initial-states and scan-inputs are listed together as one input parameter.
  Similarly, the final-states and scan-outputs are listed together as one output parameter.
  The attribute num_scan_inputs indicates the number M of scan-inputs.

  The behavior of

      Scan <
          num_scan_inputs = m,
          body = loop-body,
          scan_input_axes = [axis_1, ..., axis_m]
      > (init_1, ..., init_n, scan_1, ..., scan_m)

  is equivalent to the following pseudo-code:

      // scan_i.shape[axis_i] denotes the (max) sequence-length of scan_i
      // scan_i.shape[axis_i] is required to be equal to scan_j.shape[axis_j] for all i,j.
      sequence_length = scan_1.shape[axis_1];

      // initialize state-variables
      st_1 = init_1; ... st_n = init_n;
      // initialize scan-output variables: [] denotes an empty tensor
      scan_out_1 = []; ...; scan_out_k = [];
      // identify number of iterations:

      // execute loop
      for (int t = 0; t < sequence_length; ++t) {
          // generate the scan-input elements: the notation T<axis=k>[t] indicates the sub-tensor
          // of rank one less than T obtained by indexing T at position t along axis k.
          si_1 = scan_1<axis=axis_1>[t];
          ... ;
          si_m = scan_m<axis=axis_m>[t];
          // execute loop-body
          st_1, ..., st_n, so_1, ..., so_k = loop-body(st_1, ..., st_n, si_1, ..., si_m)
          // accumulate the scan-output elements
          scan_out_1 = Concat<axis=0>(scan_out_1, so_1); ... ; scan_out_k = Concat<axis=0>(scan_out_k, so_k);
      }

      return st_1, ..., st_n, scan_out_1, ..., scan_out_k;

  *Sample usage: Encoding RNN using a Scan*

  The following example shows how a simple RNN over an input tensor %X, with weight tensor %Wi,
  recurrence weight tensor %Ri, bias tensors %Wbi and %Rbi, and initial hidden-state %H_0 can
  be encoded as a ScanLoop. Note that the loop-body is a nested graph, and it directly computes
  %Wi, %Ri, %Wbi, and %Rbi (typically constants or initializers in the body graph). If these
  values are computed in the outer graph, they need to be passed in as extra state_variables.

      graph rnn-encoding {
        %H_0 = ...
        %X = ...
        %Y_h, %Y = Scan[body = <graph rnn-cell-1>, num_scan_inputs=1](%H_0, %X)
        return %Y, %Y_h
      }

      graph rnn-cell-1 (
        %H_tminus1[FLOAT, tensor]
        %X_t[FLOAT, tensor]
      ) {
        %Wi = ...
        %Ri = ...
        %Wbi = ...
        %Rbi = ...
        %t1 = X_t * (Wi^T)
        %t2 = H_tminus1*(Ri^T)
        %t3 = Add(%t1, %t2)
        %t4 = Add(%t3, %Wbi)
        %t5 = Add(%t4, %Rbi)
        %Ht = Tanh(%t5)
        %Accumulate = Identity(%Ht)
        return %Ht, %Accumulate
      }


#### Version

This version of the operator has been available since version 16 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>body</tt> : graph (required)</dt>
<dd>The graph run each iteration. It has N+M inputs: (loop state variables..., scan_input_elts...). It has N+K outputs: (loop state variables..., scan_output_elts...). Each scan_output is created by concatenating the value of the specified scan_output_elt value at the end of each iteration of the loop. It is an error if the dimensions of these values change across loop iterations.</dd>
<dt><tt>num_scan_inputs</tt> : int (required)</dt>
<dd>An attribute specifying the number of scan_inputs M. </dd>
<dt><tt>scan_input_axes</tt> : list of ints</dt>
<dd>An optional list of M flags. The i-th element of the list specifies the axis to be scanned (the sequence axis) for the i-th scan_input. If omitted, 0 will be used as the scan axis for every scan_input. Negative value for an axis means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(input).</dd>
<dt><tt>scan_input_directions</tt> : list of ints</dt>
<dd>An optional list of M flags. The i-th element of the list specifies the direction to be scanned for the i-th scan_input tensor: 0 indicates forward direction and 1 indicates reverse direction. If omitted, all scan_input tensors will be scanned in the forward direction.</dd>
<dt><tt>scan_output_axes</tt> : list of ints</dt>
<dd>An optional list of K flags. The i-th element of the list specifies the axis for the i-th scan_output. The scan outputs are accumulated along the specified axis. If omitted, 0 will be used as the scan axis for every scan_output. Negative value for an axis means counting dimensions from the back. Accepted range is [-r, r-1].</dd>
<dt><tt>scan_output_directions</tt> : list of ints</dt>
<dd>An optional list of K flags, one for each scan_output. The i-th element of the list specifies whether the i-th scan_output should be constructed by appending or prepending a new value in each iteration: 0 indicates appending and 1 indicates prepending. If omitted, all scan_output tensors will be produced by appending a value in each iteration.</dd>
</dl>

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>initial_state_and_scan_inputs</tt> (variadic, heterogeneous) : V</dt>
<dd>Initial values of the loop's N state variables followed by M scan_inputs</dd>
</dl>

#### Outputs (1 - &#8734;)

<dl>
<dt><tt>final_state_and_scan_outputs</tt> (variadic, heterogeneous) : V</dt>
<dd>Final values of the loop's N state variables followed by K scan_outputs</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>V</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>All Tensor types</dd>
</dl>

### <a name="ScatterElements-16"></a>**ScatterElements-16**</a>

  ScatterElements takes three inputs `data`, `updates`, and `indices` of the same
  rank r >= 1 and an optional attribute axis that identifies an axis of `data`
  (by default, the outer-most axis, that is axis 0). The output of the operation
  is produced by creating a copy of the input `data`, and then updating its value
  to values specified by `updates` at specific index positions specified by
  `indices`. Its output shape is the same as the shape of `data`.

  For each entry in `updates`, the target index in `data` is obtained by combining
  the corresponding entry in `indices` with the index of the entry itself: the
  index-value for dimension = axis is obtained from the value of the corresponding
  entry in `indices` and the index-value for dimension != axis is obtained from the
  index of the entry itself.

  `reduction` allows specification of an optional reduction operation, which is applied to all values in `updates`
  tensor into `output` at the specified `indices`.
  In cases where `reduction` is set to "none", indices should not have duplicate entries: that is, if idx1 != idx2,
  then indices[idx1] != indices[idx2]. For instance, in a 2-D tensor case, the update
  corresponding to the [i][j] entry is performed as below:
  ```
    output[indices[i][j]][j] = updates[i][j] if axis = 0,
    output[i][indices[i][j]] = updates[i][j] if axis = 1,
  ```
  When `reduction` is set to "add", the update corresponding to the [i][j] entry is performed as below:
  ```
    output[indices[i][j]][j] += updates[i][j] if axis = 0,
    output[i][indices[i][j]] += updates[i][j] if axis = 1,
  ```
  When `reduction` is set to "mul", the update corresponding to the [i][j] entry is performed as below:
  ```
    output[indices[i][j]][j] *= updates[i][j] if axis = 0,
    output[i][indices[i][j]] *= updates[i][j] if axis = 1,
  ```

  This operator is the inverse of GatherElements. It is similar to Torch's Scatter operation.

  Example 1:
  ```
    data = [
        [0.0, 0.0, 0.0],
        [0.0, 0.0, 0.0],
        [0.0, 0.0, 0.0],
    ]
    indices = [
        [1, 0, 2],
        [0, 2, 1],
    ]
    updates = [
        [1.0, 1.1, 1.2],
        [2.0, 2.1, 2.2],
    ]
    output = [
        [2.0, 1.1, 0.0]
        [1.0, 0.0, 2.2]
        [0.0, 2.1, 1.2]
    ]
  ```
  Example 2:
  ```
    data = [[1.0, 2.0, 3.0, 4.0, 5.0]]
    indices = [[1, 3]]
    updates = [[1.1, 2.1]]
    axis = 1
    output = [[1.0, 1.1, 3.0, 2.1, 5.0]]
  ```

#### Version

This version of the operator has been available since version 16 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 0)</dt>
<dd>Which axis to scatter on. Negative value means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>reduction</tt> : string (default is none)</dt>
<dd>Type of reduction to apply: none (default), add, mul. 'none': no reduction applied. 'add':  reduction using the addition operation. 'mul': reduction using the multiplication operation.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> (differentiable) : T</dt>
<dd>Tensor of rank r >= 1.</dd>
<dt><tt>indices</tt> (non-differentiable) : Tind</dt>
<dd>Tensor of int32/int64 indices, of r >= 1 (same rank as input). All index values are expected to be within bounds [-s, s-1] along axis of size s. It is an error if any of the index values are out of bounds.</dd>
<dt><tt>updates</tt> (differentiable) : T</dt>
<dd>Tensor of rank r >=1 (same rank and shape as indices)</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>Tensor of rank r >= 1 (same rank as input).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Input and output types can be of any tensor type.</dd>
<dt><tt>Tind</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain indices to integer types</dd>
</dl>

### <a name="ScatterND-16"></a>**ScatterND-16**</a>

  ScatterND takes three inputs `data` tensor of rank r >= 1, `indices` tensor of rank q >= 1,
  and `updates` tensor of rank q + r - indices.shape[-1] - 1. The output of the operation
  is produced by creating a copy of the input `data`, and then updating its value to values
  specified by `updates` at specific index positions specified by `indices`. Its output shape
  is the same as the shape of `data`. Note that `indices` should not have duplicate entries.
  That is, two or more `updates` for the same index-location is not supported.

  `indices` is an integer tensor. Let k denote indices.shape[-1], the last dimension in the shape of `indices`.
   `indices` is treated as a (q-1)-dimensional tensor of k-tuples, where each k-tuple is a partial-index into `data`.
  Hence, k can be a value at most the rank of `data`. When k equals rank(data), each update entry specifies an
  update to a single element of the tensor. When k is less than rank(data) each update entry specifies an
  update to a slice of the tensor.

  `updates` is treated as a (q-1)-dimensional tensor of replacement-slice-values. Thus, the
  first (q-1) dimensions of updates.shape must match the first (q-1) dimensions of indices.shape.
  The remaining dimensions of `updates` correspond to the dimensions of the
  replacement-slice-values. Each replacement-slice-value is a (r-k) dimensional tensor,
  corresponding to the trailing (r-k) dimensions of `data`.  Thus, the shape of `updates`
  must equal indices.shape[0:q-1] ++ data.shape[k:r-1], where ++ denotes the concatenation
  of shapes.

  The `output` is calculated via the following equation:

      output = np.copy(data)
      update_indices = indices.shape[:-1]
      for idx in np.ndindex(update_indices):
          output[indices[idx]] = updates[idx]

  The order of iteration in the above loop is not specified.
  In particular, indices should not have duplicate entries: that is, if idx1 != idx2, then indices[idx1] != indices[idx2].
  This ensures that the output value does not depend on the iteration order.

  `reduction` allows specification of an optional reduction operation, which is applied to all values in `updates`
  tensor into `output` at the specified `indices`.
  In cases where `reduction` is set to "none", indices should not have duplicate entries: that is, if idx1 != idx2,
  then indices[idx1] != indices[idx2]. This ensures that the output value does not depend on the iteration order.
  When `reduction` is set to "add", `output` is calculated as follows:

      output = np.copy(data)
      update_indices = indices.shape[:-1]
      for idx in np.ndindex(update_indices):
          output[indices[idx]] += updates[idx]

  When `reduction` is set to "mul", `output` is calculated as follows:

      output = np.copy(data)
      update_indices = indices.shape[:-1]
      for idx in np.ndindex(update_indices):
          output[indices[idx]] *= updates[idx]

  This operator is the inverse of GatherND.

  Example 1:
  ```
    data    = [1, 2, 3, 4, 5, 6, 7, 8]
    indices = [[4], [3], [1], [7]]
    updates = [9, 10, 11, 12]
    output  = [1, 11, 3, 10, 9, 6, 7, 12]
  ```

  Example 2:
  ```
    data    = [[[1, 2, 3, 4], [5, 6, 7, 8], [8, 7, 6, 5], [4, 3, 2, 1]],
               [[1, 2, 3, 4], [5, 6, 7, 8], [8, 7, 6, 5], [4, 3, 2, 1]],
               [[8, 7, 6, 5], [4, 3, 2, 1], [1, 2, 3, 4], [5, 6, 7, 8]],
               [[8, 7, 6, 5], [4, 3, 2, 1], [1, 2, 3, 4], [5, 6, 7, 8]]]
    indices = [[0], [2]]
    updates = [[[5, 5, 5, 5], [6, 6, 6, 6], [7, 7, 7, 7], [8, 8, 8, 8]],
               [[1, 1, 1, 1], [2, 2, 2, 2], [3, 3, 3, 3], [4, 4, 4, 4]]]
    output  = [[[5, 5, 5, 5], [6, 6, 6, 6], [7, 7, 7, 7], [8, 8, 8, 8]],
               [[1, 2, 3, 4], [5, 6, 7, 8], [8, 7, 6, 5], [4, 3, 2, 1]],
               [[1, 1, 1, 1], [2, 2, 2, 2], [3, 3, 3, 3], [4, 4, 4, 4]],
               [[8, 7, 6, 5], [4, 3, 2, 1], [1, 2, 3, 4], [5, 6, 7, 8]]]
  ```

#### Version

This version of the operator has been available since version 16 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>reduction</tt> : string (default is none)</dt>
<dd>Type of reduction to apply: none (default), add, mul. 'none': no reduction applied. 'add':  reduction using the addition operation. 'mul': reduction using the multiplication operation.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> (differentiable) : T</dt>
<dd>Tensor of rank r >= 1.</dd>
<dt><tt>indices</tt> (non-differentiable) : tensor(int64)</dt>
<dd>Tensor of rank q >= 1.</dd>
<dt><tt>updates</tt> (differentiable) : T</dt>
<dd>Tensor of rank q + r - indices_shape[-1] - 1.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>Tensor of rank r >= 1.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to any tensor type.</dd>
</dl>

### <a name="Where-16"></a>**Where-16**</a>

  Return elements, either from X or Y, depending on condition.
  Where behaves like
  [numpy.where](https://docs.scipy.org/doc/numpy/reference/generated/numpy.where.html)
  with three parameters.

  This operator supports **multidirectional (i.e., Numpy-style) broadcasting**; for more details please check [the doc](Broadcasting.md).

  **History**
  - Version 16 adds bfloat16 to the types allowed (for the second and third parameter).

#### Version

This version of the operator has been available since version 16 of the default ONNX operator set.

#### Inputs

<dl>
<dt><tt>condition</tt> (non-differentiable) : B</dt>
<dd>When True (nonzero), yield X, otherwise yield Y</dd>
<dt><tt>X</tt> (differentiable) : T</dt>
<dd>values selected at indices where condition is True</dd>
<dt><tt>Y</tt> (differentiable) : T</dt>
<dd>values selected at indices where condition is False</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (differentiable) : T</dt>
<dd>Tensor of shape equal to the broadcasted shape of condition, X, and Y.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>B</tt> : tensor(bool)</dt>
<dd>Constrain to boolean tensors.</dd>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to all tensor types (including bfloat).</dd>
</dl>

## Version 17 of the default ONNX operator set
### <a name="BlackmanWindow-17"></a>**BlackmanWindow-17**</a>

  Generates a Blackman window as described in the paper https://ieeexplore.ieee.org/document/1455106.

#### Version

This version of the operator has been available since version 17 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>output_datatype</tt> : int (default is 1)</dt>
<dd>The data type of the output tensor. Strictly must be one of the values from DataType enum in TensorProto whose values correspond to T2. The default value is 1 = FLOAT. </dd>
<dt><tt>periodic</tt> : int (default is 1)</dt>
<dd>If 1, returns a window to be used as periodic function. If 0, return a symmetric window. When 'periodic' is specified, hann computes a window of length size + 1 and returns the first size points. The default value is 1. </dd>
</dl>

#### Inputs

<dl>
<dt><tt>size</tt> (non-differentiable) : T1</dt>
<dd>A scalar value indicating the length of the window.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (non-differentiable) : T2</dt>
<dd>A Blackman window with length: size. The output has the shape: [size].</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain the input size to int64_t.</dd>
<dt><tt>T2</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain output types to numeric tensors.</dd>
</dl>

### <a name="DFT-17"></a>**DFT-17**</a>

  Computes the discrete Fourier transform of input.

#### Version

This version of the operator has been available since version 17 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is 1)</dt>
<dd>The axis on which to perform the DFT. By default this value is set to 1, which corresponds to the first dimension after the batch index.</dd>
<dt><tt>inverse</tt> : int (default is 0)</dt>
<dd>Whether to perform the inverse discrete fourier transform. By default this value is set to 0, which corresponds to false.</dd>
<dt><tt>onesided</tt> : int (default is 0)</dt>
<dd>If onesided is 1, only values for w in [0, 1, 2, ..., floor(n_fft/2) + 1] are returned because the real-to-complex Fourier transform satisfies the conjugate symmetry, i.e., X[m, w] = X[m,w]=X[m,n_fft-w]*. Note if the input or window tensors are complex, then onesided output is not possible. Enabling onesided with real inputs performs a Real-valued fast Fourier transform (RFFT). When invoked with real or complex valued input, the default value is 0. Values can be 0 or 1.</dd>
</dl>

#### Inputs (1 - 2)

<dl>
<dt><tt>input</tt> (non-differentiable) : T1</dt>
<dd>For real input, the following shape is expected: [batch_idx][signal_dim1][signal_dim2]...[signal_dimN][1]. For complex input, the following shape is expected: [batch_idx][signal_dim1][signal_dim2]...[signal_dimN][2]. The first dimension is the batch dimension. The following N dimentions correspond to the signal's dimensions. The final dimension represents the real and imaginary parts of the value in that order.</dd>
<dt><tt>dft_length</tt> (optional, non-differentiable) : T2</dt>
<dd>The length of the signal.If greater than the axis dimension, the signal will be zero-padded up to dft_length. If less than the axis dimension, only the first dft_length values will be used as the signal. It's an optional value. </dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T1</dt>
<dd>The Fourier Transform of the input vector.If onesided is 0, the following shape is expected: [batch_idx][signal_dim1][signal_dim2]...[signal_dimN][2]. If axis=0 and onesided is 1, the following shape is expected: [batch_idx][floor(signal_dim1/2)+1][signal_dim2]...[signal_dimN][2]. If axis=1 and onesided is 1, the following shape is expected: [batch_idx][signal_dim1][floor(signal_dim2/2)+1]...[signal_dimN][2]. If axis=N-1 and onesided is 1, the following shape is expected: [batch_idx][signal_dim1][signal_dim2]...[floor(signal_dimN/2)+1][2]. The signal_dim at the specified axis is equal to the dft_length.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T2</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain scalar length types to int64_t.</dd>
</dl>

### <a name="HammingWindow-17"></a>**HammingWindow-17**</a>

  Generates a Hamming window as described in the paper https://ieeexplore.ieee.org/document/1455106.

#### Version

This version of the operator has been available since version 17 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>output_datatype</tt> : int (default is 1)</dt>
<dd>The data type of the output tensor. Strictly must be one of the values from DataType enum in TensorProto whose values correspond to T2. The default value is 1 = FLOAT. </dd>
<dt><tt>periodic</tt> : int (default is 1)</dt>
<dd>If 1, returns a window to be used as periodic function. If 0, return a symmetric window. When 'periodic' is specified, hann computes a window of length size + 1 and returns the first size points. The default value is 1. </dd>
</dl>

#### Inputs

<dl>
<dt><tt>size</tt> (non-differentiable) : T1</dt>
<dd>A scalar value indicating the length of the window.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (non-differentiable) : T2</dt>
<dd>A Hamming window with length: size. The output has the shape: [size].</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain the input size to int64_t.</dd>
<dt><tt>T2</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain output types to numeric tensors.</dd>
</dl>

### <a name="HannWindow-17"></a>**HannWindow-17**</a>

  Generates a Hann window as described in the paper https://ieeexplore.ieee.org/document/1455106.

#### Version

This version of the operator has been available since version 17 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>output_datatype</tt> : int (default is 1)</dt>
<dd>The data type of the output tensor. Strictly must be one of the values from DataType enum in TensorProto whose values correspond to T2. The default value is 1 = FLOAT. </dd>
<dt><tt>periodic</tt> : int (default is 1)</dt>
<dd>If 1, returns a window to be used as periodic function. If 0, return a symmetric window. When 'periodic' is specified, hann computes a window of length size + 1 and returns the first size points. The default value is 1. </dd>
</dl>

#### Inputs

<dl>
<dt><tt>size</tt> (non-differentiable) : T1</dt>
<dd>A scalar value indicating the length of the window.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (non-differentiable) : T2</dt>
<dd>A Hann window with length: size. The output has the shape: [size].</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain the input size to int64_t.</dd>
<dt><tt>T2</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain output types to numeric tensors.</dd>
</dl>

### <a name="LayerNormalization-17"></a>**LayerNormalization-17**</a>

  This is layer normalization defined in ONNX as function.
        The overall computation can be split into two stages.
        The first stage is standardization, which makes the
        normalized elements have zero mean and unit variances.
        The computation required by standardization can be
        described by the following equations.
        ```
        Mean = ReduceMean<axes=normalized_axes>(X)
        D = Sub(X, Mean)
        DD = Mul(Diff, Diff)
        Var = ReduceMean<axes=normalized_axes>(DD)
        VarEps = Add(Var, epsilon)
        StdDev = Sqrt(VarEps)
        InvStdDev = Reciprocal(StdDev)
        Normalized = Mul(D, InvStdDev)
        ```
        where `normalized_axes` is `[axis, ..., rank of X - 1]`.
        The variables `Var` and `StdDev` stand for variance and
        standard deviation, respectively. The second output is
        `Mean` and the last one is `InvStdDev`.
        Depending on `stash_type` attribute, the actual computation
        must happen in different floating-point precision.
        For example, if `stash_type` is 1, this operator casts
        all input variables to 32-bit float, perform the computation, and
        finally cast `Normalized` back to the original type of `X`.
        The second stage then scales and shifts the outcome of the
        first stage using
        ```
        NormalizedScaled = Mul(Normalized, Scale)
        Y = Add(NormalizedScaled, B)
        ```
        The second stage doesn't depends on `stash_type`.
        All equations are in [this syntax](https://github.com/onnx/onnx/blob/main/docs/Syntax.md).
        The same variable (i.e., input, output, and attribute) uses
        the same name in the equations above and this operator's definition.
        Let `d[i]` indicate the i-th dimension of `X`.
        If `X`'s shape is `[d[0], ..., d[axis-1], d[axis], ..., d[rank-1]]`,
        the shape of `Mean` and `InvStdDev` is `[d[0], ..., d[axis-1], 1, ..., 1]`.
        `Y` and `X` have the same shape.

#### Version

This version of the operator has been available since version 17 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (default is -1)</dt>
<dd>The first normalization dimension. If rank(X) is r, axis' allowed range is [-r, r]. Negative value means counting dimensions from the back.</dd>
<dt><tt>epsilon</tt> : float (default is 1e-05)</dt>
<dd>The epsilon value to use to avoid division by zero.</dd>
<dt><tt>stash_type</tt> : int (default is 1)</dt>
<dd>Type of Mean and InvStdDev. This also specifies stage one's computation precision.</dd>
</dl>

#### Inputs (2 - 3)

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Tensor to be normalized.</dd>
<dt><tt>Scale</tt> : T</dt>
<dd>Scale tensor.</dd>
<dt><tt>B</tt> (optional) : T</dt>
<dd>Bias tensor.</dd>
</dl>

#### Outputs (1 - 3)

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Normalized tensor.</dd>
<dt><tt>Mean</tt> (optional) : U</dt>
<dd>Saved mean used during training to speed up gradient computation</dd>
<dt><tt>InvStdDev</tt> (optional) : U</dt>
<dd>Saved inverse standard deviation used during training to speed up gradient computation.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input types and output Y type to float tensors.</dd>
<dt><tt>U</tt> : tensor(float), tensor(bfloat16)</dt>
<dd>Type of Mean and InvStdDev tensors.</dd>
</dl>

### <a name="MelWeightMatrix-17"></a>**MelWeightMatrix-17**</a>

  Generate a MelWeightMatrix that can be used to re-weight a Tensor containing a linearly sampled frequency spectra (from DFT or STFT) into num_mel_bins frequency information based on the [lower_edge_hertz, upper_edge_hertz] range on the mel scale.
  This function defines the mel scale in terms of a frequency in hertz according to the following formula:

      mel(f) = 2595 * log10(1 + f/700)

  In the returned matrix, all the triangles (filterbanks) have a peak value of 1.0.

  The returned MelWeightMatrix can be used to right-multiply a spectrogram S of shape [frames, num_spectrogram_bins] of linear scale spectrum values (e.g. STFT magnitudes) to generate a "mel spectrogram" M of shape [frames, num_mel_bins].

#### Version

This version of the operator has been available since version 17 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>output_datatype</tt> : int (default is 1)</dt>
<dd>The data type of the output tensor. Strictly must be one of the values from DataType enum in TensorProto whose values correspond to T3. The default value is 1 = FLOAT. </dd>
</dl>

#### Inputs

<dl>
<dt><tt>num_mel_bins</tt> (non-differentiable) : T1</dt>
<dd>The number of bands in the mel spectrum.</dd>
<dt><tt>dft_length</tt> (non-differentiable) : T1</dt>
<dd>The size of the original DFT. The size of the original DFT is used to infer the size of the onesided DFT, which is understood to be floor(dft_length/2) + 1, i.e. the spectrogram only contains the nonredundant DFT bins.</dd>
<dt><tt>sample_rate</tt> (non-differentiable) : T1</dt>
<dd>Samples per second of the input signal used to create the spectrogram. Used to figure out the frequencies corresponding to each spectrogram bin, which dictates how they are mapped into the mel scale.</dd>
<dt><tt>lower_edge_hertz</tt> (non-differentiable) : T2</dt>
<dd>Lower bound on the frequencies to be included in the mel spectrum. This corresponds to the lower edge of the lowest triangular band.</dd>
<dt><tt>upper_edge_hertz</tt> (non-differentiable) : T2</dt>
<dd>The desired top edge of the highest frequency band.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (non-differentiable) : T3</dt>
<dd>The Mel Weight Matrix. The output has the shape: [floor(dft_length/2) + 1][num_mel_bins].</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain to integer tensors.</dd>
<dt><tt>T2</tt> : tensor(float), tensor(float16), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain to float tensors</dd>
<dt><tt>T3</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain to any numerical types.</dd>
</dl>

### <a name="STFT-17"></a>**STFT-17**</a>

  Computes the Short-time Fourier Transform of the signal.

#### Version

This version of the operator has been available since version 17 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>onesided</tt> : int (default is 1)</dt>
<dd>If onesided is 1, only values for w in [0, 1, 2, ..., floor(n_fft/2) + 1] are returned because the real-to-complex Fourier transform satisfies the conjugate symmetry, i.e., X[m, w] = X[m,w]=X[m,n_fft-w]*. Note if the input or window tensors are complex, then onesided output is not possible. Enabling onesided with real inputs performs a Real-valued fast Fourier transform (RFFT).When invoked with real or complex valued input, the default value is 1. Values can be 0 or 1.</dd>
</dl>

#### Inputs (2 - 4)

<dl>
<dt><tt>signal</tt> (non-differentiable) : T1</dt>
<dd>Input tensor representing a real or complex valued signal. For real input, the following shape is expected: [batch_size][signal_length][1]. For complex input, the following shape is expected: [batch_size][signal_length][2], where [batch_size][signal_length][0] represents the real component and [batch_size][signal_length][1] represents the imaginary component of the signal.</dd>
<dt><tt>frame_step</tt> (non-differentiable) : T2</dt>
<dd>The number of samples to step between successive DFTs.</dd>
<dt><tt>window</tt> (optional, non-differentiable) : T1</dt>
<dd>A tensor representing the window that will be slid over the signal.The window must have rank 1 with shape: [window_shape]. It's an optional value. </dd>
<dt><tt>frame_length</tt> (optional, non-differentiable) : T2</dt>
<dd>A scalar representing the size of the DFT. It's an optional value.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> (non-differentiable) : T1</dt>
<dd>The Short-time Fourier Transform of the signals.If onesided is 1, the output has the shape: [batch_size][frames][dft_unique_bins][2], where dft_unique_bins is frame_length // 2 + 1 (the unique components of the DFT) If onesided is 0, the output has the shape: [batch_size][frames][frame_length][2], where frame_length is the length of the DFT.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float), tensor(float16), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain signal and output to float tensors.</dd>
<dt><tt>T2</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain scalar length types to int64_t.</dd>
</dl>

### <a name="SequenceMap-17"></a>**SequenceMap-17**</a>

  Applies a sub-graph to each sample in the input sequence(s).

  Inputs can be either tensors or sequences, with the exception of the first input which must
  be a sequence. The length of the first input sequence will determine the number of samples in the
  outputs. Any other sequence inputs should have the same number of samples. The number of inputs
  and outputs, should match the one of the subgraph.

  For each i-th element in the output, a sample will be extracted from the input sequence(s) at
  the i-th position and the sub-graph will be applied to it.
  The outputs will contain the outputs of the sub-graph for each sample, in the same order as in
  the input.

  This operator assumes that processing each sample is independent and could executed in parallel
  or in any order. Users cannot expect any specific ordering in which each subgraph is computed.

#### Version

This version of the operator has been available since version 17 of the default ONNX operator set.

#### Attributes

<dl>
<dt><tt>body</tt> : graph (required)</dt>
<dd>The graph to be run for each sample in the sequence(s). It should have as many inputs and outputs as inputs and outputs to the SequenceMap function.</dd>
</dl>

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>input_sequence</tt> : S</dt>
<dd>Input sequence.</dd>
<dt><tt>additional_inputs</tt> (variadic, heterogeneous) : V</dt>
<dd>Additional inputs to the graph</dd>
</dl>

#### Outputs (1 - &#8734;)

<dl>
<dt><tt>out_sequence</tt> (variadic, heterogeneous) : S</dt>
<dd>Output sequence(s)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>S</tt> : seq(tensor(uint8)), seq(tensor(uint16)), seq(tensor(uint32)), seq(tensor(uint64)), seq(tensor(int8)), seq(tensor(int16)), seq(tensor(int32)), seq(tensor(int64)), seq(tensor(float16)), seq(tensor(float)), seq(tensor(double)), seq(tensor(string)), seq(tensor(bool)), seq(tensor(complex64)), seq(tensor(complex128))</dt>
<dd>Constrain input types to any sequence type.</dd>
<dt><tt>V</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128), seq(tensor(uint8)), seq(tensor(uint16)), seq(tensor(uint32)), seq(tensor(uint64)), seq(tensor(int8)), seq(tensor(int16)), seq(tensor(int32)), seq(tensor(int64)), seq(tensor(float16)), seq(tensor(float)), seq(tensor(double)), seq(tensor(string)), seq(tensor(bool)), seq(tensor(complex64)), seq(tensor(complex128))</dt>
<dd>Constrain to any tensor or sequence type.</dd>
</dl>

# ai.onnx.preview.training
## Version 1 of the 'ai.onnx.preview.training' operator set
### <a name="ai.onnx.preview.training.Adagrad-1"></a>**ai.onnx.preview.training.Adagrad-1**</a>

  Compute one iteration of ADAGRAD, a stochastic gradient based optimization
      algorithm. This operator can conduct the optimization of multiple tensor variables.

      Let's define the behavior of this operator. As you can imagine, ADAGRAD requires
      some parameters:

       - The initial learning-rate "R".
       - The update count "T". That is, the number of training iterations conducted.
       - A L2-norm regularization coefficient "norm_coefficient".
       - A learning-rate decay factor "decay_factor".
       - A small constant "epsilon" to avoid dividing-by-zero.

      At each ADAGRAD iteration, the optimized tensors are moved along a direction
      computed based on their estimated gradient and accumulated squared gradient. Assume
      that only a single tensor "X" is updated by this operator. We need the value of "X",
      its gradient "G", and its accumulated squared gradient "H". Therefore, variables in
      this operator's input list are sequentially "R", "T", "X", "G", and "H". Other
      parameters are given as attributes because they are usually constants. Also, the
      corresponding output tensors are the new value of "X" (called "X_new"), and then
      the new accumulated squared gradient (called "H_new"). Those outputs are computed
      from the given inputs following the pseudo code below.

      Let "+", "-", "*", and "/" are all element-wise arithmetic operations with
      numpy-style broadcasting support. The pseudo code to compute those outputs is:

        // Compute a scalar learning-rate factor. At the first update of X, T is generally
        // 0 (0-based update index) or 1 (1-based update index).
        r = R / (1 + T * decay_factor);

        // Add gradient of 0.5 * norm_coefficient * ||X||_2^2, where ||X||_2 is the 2-norm.
        G_regularized = norm_coefficient * X + G;

        // Compute new accumulated squared gradient.
        H_new = H + G_regularized * G_regularized;

        // Compute the adaptive part of per-coordinate learning rate. Note that Sqrt(...)
        // computes element-wise square-root.
        H_adaptive = Sqrt(H_new) + epsilon

        // Compute the new value of "X".
        X_new = X - r * G_regularized / H_adaptive;

      If one assign this operators to optimize multiple inputs, for example, "X_1" and "X_2", the same
      pseudo code may be extended to handle all tensors jointly. More specifically, we can view "X" as a
      concatenation of "X_1" and "X_2" (of course, their gradient and accumulate gradient should
      be concatenated too) and then just reuse the entire pseudo code.

      Note that ADAGRAD was first proposed in http://jmlr.org/papers/volume12/duchi11a/duchi11a.pdf.
      In that reference paper, this operator is a special case of the Figure 1's composite mirror
      descent update.

#### Version

This version of the operator has been available since version 1 of the 'ai.onnx.preview.training' operator set.

#### Attributes

<dl>
<dt><tt>decay_factor</tt> : float (default is 0.0)</dt>
<dd>The decay factor of learning rate after one update.The effective learning rate is computed by r = R / (1 + T * decay_factor). Default to 0 so that increasing update counts doesn't reduce the learning rate.</dd>
<dt><tt>epsilon</tt> : float (default is 0.0)</dt>
<dd>Small scalar to avoid dividing by zero.</dd>
<dt><tt>norm_coefficient</tt> : float (default is 0.0)</dt>
<dd>Regularization coefficient in 0.5 * norm_coefficient * ||X||_2^2. Default to 0, which means no regularization.</dd>
</dl>

#### Inputs (3 - &#8734;)

<dl>
<dt><tt>R</tt> : T1</dt>
<dd>The initial learning rate.</dd>
<dt><tt>T</tt> : T2</dt>
<dd>The update count of "X". It should be a scalar.</dd>
<dt><tt>inputs</tt> (variadic, heterogeneous) : T3</dt>
<dd>The current values of optimized tensors, followed by their respective gradients, followed by their respective accumulated squared gradients.For example, if two tensor "X_1" and "X_2" are optimized, The input list would be ["X_1", "X_2", gradient of "X_1", gradient of "X_2", accumulated squared gradient of "X_1", accumulated squared gradient of "X_2"].</dd>
</dl>

#### Outputs (1 - &#8734;)

<dl>
<dt><tt>outputs</tt> (variadic, heterogeneous) : T3</dt>
<dd>Updated values of optimized tensors, followed by their updated values of accumulated squared gradients. For example, if two tensor "X_1" and "X_2" are optimized, the output list would be [new value of "X_1," new value of "X_2" new accumulated squared gradient of "X_1", new accumulated squared gradient of "X_2"].</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float), tensor(double)</dt>
<dd>Constrain input types to float scalars.</dd>
<dt><tt>T2</tt> : tensor(int64)</dt>
<dd>Constrain input types to 64-bit integer scalars.</dd>
<dt><tt>T3</tt> : tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="ai.onnx.preview.training.Adam-1"></a>**ai.onnx.preview.training.Adam-1**</a>

  Compute one iteration of Adam, a stochastic gradient based optimization
      algorithm. This operator can conduct the optimization of multiple tensor variables.

      Let's define the behavior of this operator. First of all, Adam requires
      some parameters:

       - The learning-rate "R".
       - The update count "T". That is, the number of training iterations conducted.
       - A L2-norm regularization coefficient "norm_coefficient".
       - A small constant "epsilon" to avoid dividing-by-zero.
       - Two coefficients, "alpha" and "beta".

      At each Adam iteration, the optimized tensors are moved along a direction
      computed based on their exponentially-averaged historical gradient and
      exponentially-averaged historical squared gradient. Assume that only a tensor
      "X" is being optimized. The rest of required information is

       - the value of "X",
       - "X"'s gradient (denoted by "G"),
       - "X"'s exponentially-averaged historical gradient (denoted by "V"), and
       - "X"'s exponentially-averaged historical squared gradient (denoted by "H").

      Some of those parameters are passed into this operator as input tensors and others
      are stored as this operator's attributes. Specifically, this operator's input tensor
      list is ["R", "T", "X", "G", "V", "H"]. That is, "R" is the first input, "T" is
      the second input, and so on. Other parameters are given as attributes because they
      are constants. Moreover, the corresponding output tensors are

       - the new value of "X" (called "X_new"),
       - the new exponentially-averaged historical gradient (denoted by "V_new"), and
       - the new exponentially-averaged historical squared gradient (denoted by "H_new").

      Those outputs are computed following the pseudo code below.

      Let "+", "-", "*", and "/" are all element-wise arithmetic operations with
      numpy-style broadcasting support. The pseudo code to compute those outputs is:

        // Add gradient of 0.5 * norm_coefficient * ||X||_2^2, where ||X||_2 is the 2-norm.
        G_regularized = norm_coefficient * X + G

        // Update exponentially-averaged historical gradient.
        V_new = alpha * V + (1 - alpha) * G_regularized

        // Update exponentially-averaged historical squared gradient.
        H_new = beta * H + (1 - beta) * G_regularized * G_regularized

        // Compute the element-wise square-root of H_new. V_new will be element-wisely
        // divided by H_sqrt for a better update direction.
        H_sqrt = Sqrt(H_new) + epsilon

        // Compute learning-rate. Note that "alpha**T"/"beta**T" is alpha's/beta's T-th power.
        R_adjusted = T > 0 ? R * Sqrt(1 - beta**T) / (1 - alpha**T) : R

        // Compute new value of "X".
        X_new = X - R_adjusted * V_new / H_sqrt

        // Post-update regularization.
        X_final = (1 - norm_coefficient_post) * X_new

      If there are multiple inputs to be optimized, the pseudo code will be applied
      independently to each of them.

#### Version

This version of the operator has been available since version 1 of the 'ai.onnx.preview.training' operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float (default is 0.9)</dt>
<dd>Coefficient of previously accumulated gradient in running average. Default to 0.9.</dd>
<dt><tt>beta</tt> : float (default is 0.999)</dt>
<dd>Coefficient of previously accumulated squared-gradient in running average. Default to 0.999.</dd>
<dt><tt>epsilon</tt> : float (default is 0.0)</dt>
<dd>Small scalar to avoid dividing by zero.</dd>
<dt><tt>norm_coefficient</tt> : float (default is 0.0)</dt>
<dd>Regularization coefficient of 0.5 * norm_coefficient * ||X||_2^2. Default to 0, which means no regularization.</dd>
<dt><tt>norm_coefficient_post</tt> : float (default is 0.0)</dt>
<dd>Regularization coefficient of 0.5 * norm_coefficient * ||X||_2^2. Default to 0, which means no regularization.</dd>
</dl>

#### Inputs (3 - &#8734;)

<dl>
<dt><tt>R</tt> : T1</dt>
<dd>The initial learning rate.</dd>
<dt><tt>T</tt> : T2</dt>
<dd>The update count of "X". It should be a scalar.</dd>
<dt><tt>inputs</tt> (variadic, heterogeneous) : T3</dt>
<dd>The tensors to be optimized, followed by their respective gradients, followed by their respective accumulated gradients (aka momentum), followed by their respective accumulated squared gradients. For example, to optimize tensors "X_1" and "X_2,", the input list would be ["X_1", "X_2", gradient of "X_1", gradient of "X_2", accumulated gradient of "X_1", accumulated gradient of "X_2", accumulated squared gradient of "X_1", accumulated squared gradient of "X_2"].</dd>
</dl>

#### Outputs (1 - &#8734;)

<dl>
<dt><tt>outputs</tt> (variadic, heterogeneous) : T3</dt>
<dd>New values of optimized tensors, followed by their respective new accumulated gradients, followed by their respective new accumulated squared gradients. For example, if two tensors "X_1" and "X_2" are optimized, the outputs list would be [new value of "X_1", new value of "X_2", new accumulated gradient of "X_1", new accumulated gradient of "X_2", new accumulated squared gradient of "X_1", new accumulated squared gradient of "X_2"].</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float), tensor(double)</dt>
<dd>Constrain input types to float scalars.</dd>
<dt><tt>T2</tt> : tensor(int64)</dt>
<dd>Constrain input types to 64-bit integer scalars.</dd>
<dt><tt>T3</tt> : tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>

### <a name="ai.onnx.preview.training.Gradient-1"></a>**ai.onnx.preview.training.Gradient-1**</a>

  Gradient operator computes the partial derivatives of a specific tensor w.r.t.
  some other tensors. This operator is widely used in gradient-based training
  algorithms. To illustrate its use, let's consider a computation graph,

  ```
  X -----.
         |
         v
  W --> Conv --> H --> Gemm --> Y
                        ^
                        |
                        Z
  ```

  , where W and Z are trainable tensors. Note that operators' attributes are
  omitted for the sake of simplicity. Let dY/dW (dY/dZ) be the gradient of
  Y with respect to W (Z). The user can compute gradient by inserting Gradient
  operator to form another graph shown below.

  ```
  W --> Conv --> H --> Gemm --> Y
  |      ^              ^
  |      |              |
  |      X              Z
  |      |              |
  |      |   .----------'
  |      |   |  (W/Z/X is the 1st/2nd/3rd input of Gradient as shown in
  |      |   |   "xs" followed by "zs")
  |      v   v
  '---> Gradient(xs=["W", "Z"], zs=["X"], y="Y")
         |   |
         |   '-----------------------------------> dY/dW (1st output of Gradient)
         |
         '---------------------------------------> dY/dZ (2nd output of Gradient)
  ```

  By definition, the tensor "y" is a function of independent variables in "xs"
  and "zs". Since we only compute the gradient of "y" w.r.t. the differentiable
  variables in "xs", this Gradient only outputs dY/dW and dY/dZ. Note that "H"
  cannot appear in "xs" and "zs". The reason is that "H" can be determined by
  tensors "W" and "X" and therefore "H" is not an independent variable.

  All outputs are optional. If needed, for example, user can assign an empty
  string to the 1st output name of that Gradient to skip the generation of dY/dW.
  Note that the concept of optional outputs can also be found in ONNX's RNN, GRU,
  and LSTM.

  Gradient operator can compute derivative against intermediate tensors. For
  example, the gradient of Y with respect to H can be done via

  ```
  W --> Conv --> H --> Gemm --> Y
         ^       |      ^
         |       |      |
         X       |      Z
         .-------'      |
         |   .----------'
         |   | (H/Z is the 1st/2nd input of Gradient as shown in "xs")
         v   v
        Gradient(xs=["H", "Z"], y="Y")
         |   |
         |   '-----------------------------------> dY/dH (1st output of Gradient)
         |
         '---------------------------------------> dY/dZ (2nd output of Gradient)
  ```

  It is possible to represent high-order differentiation using Gradient operators.
  For example, given the following linear model:

  ```
  W --> Gemm --> Y --> Loss --> O
         ^              ^
         |              |
         X              L
  ```

  To compute the 2nd order derivative of O with respect to W (denoted by
  d^2O/dW^2), one can do

  ```
  W --> Gemm --> Y --> Loss --> O
  |      ^              ^
  |      |              |
  |      X .------------L
  |      | |            |
  |      | |            v
  +------+-+> Gradient(xs=["X", "W"], zs=["L"], y="O") ---> dO/dX (1st output of Gradient)
  |      | |    |
  |      | |    '---> dO/dW (2nd output of Gradient)
  |      v v
  '---> Gradient(xs=["X", "W"], zs=["L"], y="dO/dW") ---> d(dO/dW)dX (1st output of
         |                                                  Gradient)
         |
         |
         '---> d^2O/dW^2 (2nd output of Gradient)
  ```

  The tensors named in attributes "xs", "zs", and "y" define the differentiated
  computation graph, and the inputs to Gradient node define the values at
  which the gradient is computed. We can feed different tensors to the identified
  graph. For example, one can compute the gradient of Y with respect to H at
  a specific value of H, H_1, by providing that value as an input to the Gradient
  node.

  ```
  W --> Conv --> H --> Gemm --> Y
         ^              ^
         |              |
         X              Z

            Z_1 (2nd input of Gradient)
             |
             v
  H_1 --> Gradient(xs=["H", "Z"], y="Y") ---> dY/dH when H = H_1 and Y = Y_1.
             |
             '------------------------------> dY/dZ (2nd output of Gradient)
  ```

  When the inputs of Gradient are the tensors named in "xs" and "zs", the
  computation can be optimized. More specifically, intermediate variables in
  forward pass can be reused if the gradient is computed via reverse-mode
  auto-differentiation.


#### Version

This version of the operator has been available since version 1 of the 'ai.onnx.preview.training' operator set.

#### Attributes

<dl>
<dt><tt>xs</tt> : list of strings (required)</dt>
<dd>Input tensor names of the differentiated sub-graph. It contains only the necessary differentiated inputs of a (sub-)graph. Variables (usually called intermediate variables) that can be generated from inputs cannot be included in this attribute.</dd>
<dt><tt>y</tt> : string (required)</dt>
<dd>The targeted tensor. It can be viewed as the output of the differentiated function. The attribute "xs" and attribute "zs" are the minimal independent variable set that determines the value of "y".</dd>
<dt><tt>zs</tt> : list of strings</dt>
<dd>Input tensor names of the differentiated sub-graph. It contains only the necessary non-differentiated inputs of a (sub-)graph. Variables (usually called intermediate variables) that can be generated from inputs cannot be included in this attribute.</dd>
</dl>

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>Inputs</tt> (variadic, heterogeneous) : T1</dt>
<dd>The values fed into graph identified by the attributes. The i-th input is the value of the i-th tensor specified in the concatenated list of the attribute "xs" and the attribute  "zs". For example, if xs=["A", "B"] and zs=["C"], the first input is used as the value of symbol "A" and the 3rd input is substituted for all the occurrences of "C".</dd>
</dl>

#### Outputs (1 - &#8734;)

<dl>
<dt><tt>Outputs</tt> (variadic, heterogeneous) : T2</dt>
<dd>The gradient of the tensor specified by the attribute "y" with respect to each of tensors specified in the attribute "xs". The i-th output is the gradient of "y" with respect to the i-th tensor specified in the attribute "xs".</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Allow outputs to be any kind of tensor.</dd>
<dt><tt>T2</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Allow inputs to be any kind of floating-point tensor.</dd>
</dl>

### <a name="ai.onnx.preview.training.Momentum-1"></a>**ai.onnx.preview.training.Momentum-1**</a>

  Compute one iteration of stochastic gradient update with momentum.
      This operator can conduct the optimization of multiple tensor variables.

      Let's define the behavior of this operator. As you can imagine, SG with momentum requires
      several parameters:

       - The learning-rate "R".
       - The update count "T". That is, the number of conducted training iterations. It should
         be zero in the first training iteration.
       - A L2-norm regularization coefficient "norm_coefficient".
       - A decay coefficient of previous accumulated gradient (i.e., momentum) "alpha".
       - The scaling coefficient of current gradient "beta".
       - An attribute to choose either standard momentum or Nesterov's momentum "mode" should
         be used.

      For the sake of simplicity, assume that there is only one tensor (called "X") to be optimized.
      Other necessary inputs are "X"'s gradient (called "G") and "X"'s momentum (called "V"). This
      Momentum operator maps all these inputs to the new value of "X" (called "X_new") and its new
      momentum (called "V_new").

      This operator supports two different momentum algorithms. Set the attribute "mode" to
      "nesterov" if Nesterov's momentum is desired. Otherwise, set the attribute "model" to
      "standard" to use standard momentum. Computation details are described subsequently.

      Let "+", "-", "*", and "/" are all element-wise operations with numpy-style broadcasting.

      Pseudo code for SG with standard momentum:

        // Add gradient of 0.5 * norm_coefficient * ||X||^2, where ||X|| is the sum of squared
        // values of all elements in X.
        G_regularized = norm_coefficient * X + G

        // In the first training iteration, beta should always be 1.
        beta_adjusted = T > 0 ? beta : 1

        // Compute the current momentum based on previous momentum and the current gradient.
        V_new = alpha * V + beta_adjusted * G_regularized

        // Update X.
        X_new = X - R * V_new

      Pseudo code for SG with Nesterov's momentum:

        // Add gradient of 0.5 * norm_coefficient * ||X||^2, where ||X|| is the sum of squared
        // values of all elements in X.
        G_regularized = norm_coefficient * X + G;

        // In the first training iteration, beta should always be 1.
        beta_adjusted = T > 0 ? beta : 1

        // Compute the current momentum based on previous momentum and the current gradient.
        V_new = alpha * V + beta_adjusted * G_regularized;

        // Compute final update direction and then update X.
        X_new = X - R * (G_regularized + alpha * V_new)

      If one assign this operators to optimize multiple inputs, for example, "X_1" and "X_2". The same
      pseudo code would be extended to handle all tensors jointly. More specifically, we can view "X" as a
      concatenation of "X_1" and "X_2" (of course, their gradient and accumulate gradient should
      be concatenated too) and then our pseudo code becomes applicable.

#### Version

This version of the operator has been available since version 1 of the 'ai.onnx.preview.training' operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float (required)</dt>
<dd>The decay factor of momentum. It should be a scalar.</dd>
<dt><tt>beta</tt> : float (required)</dt>
<dd>The coefficient of gradient in computing new momentum. It should be a scalar.</dd>
<dt><tt>mode</tt> : string (required)</dt>
<dd>Its value should be either "nesterov" or "standard". The value "nesterov" leads to the use of Nesterov's momentum while "standard" invokes stochastic gradient method using standard momentum</dd>
<dt><tt>norm_coefficient</tt> : float (required)</dt>
<dd>Coefficient of 0.5 * norm_coefficient * ||X||^2.</dd>
</dl>

#### Inputs (3 - &#8734;)

<dl>
<dt><tt>R</tt> : T1</dt>
<dd>The learning rate.</dd>
<dt><tt>T</tt> : T2</dt>
<dd>Update count of "X". It should be a scalar.</dd>
<dt><tt>inputs</tt> (variadic, heterogeneous) : T3</dt>
<dd>It sequentially contains the current values of optimized tensors, then their gradient tensors, and finally their momentum tensors. For example, if two tensors "X_1" and "X_2" are optimized, The expected input list would be ["X_1", "X_2", gradient of "X_1", gradient of "X_2", momentum of "X_1", momentum of "X_2"].</dd>
</dl>

#### Outputs (1 - &#8734;)

<dl>
<dt><tt>outputs</tt> (variadic, heterogeneous) : T3</dt>
<dd>It sequentially contains the new values of optimized tensors and then the new values of their momentum tensors. For example, if two tensors "X_1" and "X_2" are optimized, the output list would be [new value of "X_1," new value of "X_2" new momentum of "X_1", new momentum of "X_2"].</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float), tensor(double)</dt>
<dd>Constrain input types to float scalars.</dd>
<dt><tt>T2</tt> : tensor(int64)</dt>
<dd>Constrain input types to 64-bit integer scalars.</dd>
<dt><tt>T3</tt> : tensor(float), tensor(double)</dt>
<dd>Constrain input types to float tensors.</dd>
</dl>

