/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.core.ExportPackage;
import org.apache.ivy.osgi.util.Version;

public final class BundleInfo {
    public static final Version DEFAULT_VERSION = new Version(1, 0, 0, null);
    private String symbolicName;
    private Version version;
    private Set requirements = new LinkedHashSet();
    private Set capabilities = new LinkedHashSet();
    private List executionEnvironments = Collections.EMPTY_LIST;
    private URI uri;

    public BundleInfo(String string, Version version) {
        this.symbolicName = string;
        this.version = version;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BundleInfo [executionEnvironments=");
        stringBuffer.append(this.executionEnvironments);
        stringBuffer.append(", capabilities=");
        stringBuffer.append(this.capabilities);
        stringBuffer.append(", requirements=");
        stringBuffer.append(this.requirements);
        stringBuffer.append(", symbolicName=");
        stringBuffer.append(this.symbolicName);
        stringBuffer.append(", version=");
        stringBuffer.append(this.version);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public final String getSymbolicName() {
        return this.symbolicName;
    }

    public final Version getVersion() {
        if (this.version == null) {
            return DEFAULT_VERSION;
        }
        return this.version;
    }

    public final void setUri(URI uRI) {
        this.uri = uRI;
    }

    public final URI getUri() {
        return this.uri;
    }

    public final void addRequirement(BundleRequirement bundleRequirement) {
        this.requirements.add(bundleRequirement);
    }

    public final Set getRequirements() {
        return this.requirements;
    }

    public final void addCapability(BundleCapability bundleCapability) {
        this.capabilities.add(bundleCapability);
    }

    public final void setExecutionEnvironments(List list) {
        this.executionEnvironments = list;
    }

    public final int hashCode() {
        int n = 31 + (this.capabilities == null ? 0 : ((Object)this.capabilities).hashCode());
        n = n * 31 + (this.requirements == null ? 0 : ((Object)this.requirements).hashCode());
        n = n * 31 + (this.symbolicName == null ? 0 : this.symbolicName.hashCode());
        n = n * 31 + (this.version == null ? 0 : this.version.hashCode());
        return n * 31 + (this.executionEnvironments == null ? 0 : ((Object)this.executionEnvironments).hashCode());
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof BundleInfo)) {
            return false;
        }
        BundleInfo bundleInfo = (BundleInfo)object;
        if (this.capabilities == null ? bundleInfo.capabilities != null : !((Object)this.capabilities).equals(bundleInfo.capabilities)) {
            return false;
        }
        if (this.requirements == null ? bundleInfo.requirements != null : !((Object)this.requirements).equals(bundleInfo.requirements)) {
            return false;
        }
        if (this.symbolicName == null ? bundleInfo.symbolicName != null : !this.symbolicName.equals(bundleInfo.symbolicName)) {
            return false;
        }
        if (this.version == null ? bundleInfo.version != null : !this.version.equals(bundleInfo.version)) {
            return false;
        }
        return !(this.executionEnvironments == null ? bundleInfo.executionEnvironments != null : !((Object)this.executionEnvironments).equals(bundleInfo.executionEnvironments));
    }

    public final Set getExports() {
        LinkedHashSet<ExportPackage> linkedHashSet = new LinkedHashSet<ExportPackage>();
        Iterator iterator = this.capabilities.iterator();
        while (iterator.hasNext()) {
            BundleCapability bundleCapability = (BundleCapability)iterator.next();
            if (!"package".equals(bundleCapability.getType())) continue;
            linkedHashSet.add((ExportPackage)bundleCapability);
        }
        return linkedHashSet;
    }
}

