/*################################################################################
# Linux Management Providers (LMP), DHCP provider package
# Copyright (C) 2009 Khahramon NURIDDINOV, qahramon0786@gmail.com,TUIT
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
################################################################################*/

#include "cmpiOpenDRIM_DHCPSettingData.h"

CMPIObjectPath* DHCP_OpenDRIM_DHCPSettingData_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_DHCPSettingData& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_DHCPSettingData_classnames[0], OpenDRIM_DHCPSettingData_NAMESPACE);

	if (!instance.InstanceID_isNULL)
		op.addKey("InstanceID", instance.InstanceID);

	_L_;
	return op.getHdl();
}

CMPIInstance* DHCP_OpenDRIM_DHCPSettingData_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_DHCPSettingData& instance) {
	_E_;
	Objectpath op(broker, DHCP_OpenDRIM_DHCPSettingData_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.AddressOrigin_isNULL)
		ci.setProperty("AddressOrigin", instance.AddressOrigin);

	if (!instance.RequestedIPv4Address_isNULL)
		ci.setProperty("RequestedIPv4Address", instance.RequestedIPv4Address);

	if (!instance.RequestedLeaseTime_isNULL)
		ci.setProperty("RequestedLeaseTime", instance.RequestedLeaseTime);

	if (!instance.ClientIdentifier_isNULL)
		ci.setProperty("ClientIdentifier", instance.ClientIdentifier);

	if (!instance.VendorClassIdentifier_isNULL)
		ci.setProperty("VendorClassIdentifier", instance.VendorClassIdentifier);

	if (!instance.RequestedOptions_isNULL)
		ci.setProperty("RequestedOptions", instance.RequestedOptions);

	if (!instance.RequiredOptions_isNULL)
		ci.setProperty("RequiredOptions", instance.RequiredOptions);

	_L_;
	return ci.getHdl();
}

void DHCP_OpenDRIM_DHCPSettingData_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_DHCPSettingData& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	_L_;
}

void DHCP_OpenDRIM_DHCPSettingData_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_DHCPSettingData& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getProperty("AddressOrigin", instance.AddressOrigin) == OK)
		instance.AddressOrigin_isNULL = false;

	if (inst.getProperty("RequestedIPv4Address", instance.RequestedIPv4Address) == OK)
		instance.RequestedIPv4Address_isNULL = false;

	if (inst.getProperty("RequestedLeaseTime", instance.RequestedLeaseTime) == OK)
		instance.RequestedLeaseTime_isNULL = false;

	if (inst.getProperty("ClientIdentifier", instance.ClientIdentifier) == OK)
		instance.ClientIdentifier_isNULL = false;

	if (inst.getProperty("VendorClassIdentifier", instance.VendorClassIdentifier) == OK)
		instance.VendorClassIdentifier_isNULL = false;

	if (inst.getProperty("RequestedOptions", instance.RequestedOptions) == OK)
		instance.RequestedOptions_isNULL = false;

	if (inst.getProperty("RequiredOptions", instance.RequiredOptions) == OK)
		instance.RequiredOptions_isNULL = false;

	_L_;
}

