/*###############################################################################
# Linux Management Providers (LMP), OS provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#ifndef OPENDRIM_OPERATINGSYSTEMACCESS_H_
#define OPENDRIM_OPERATINGSYSTEMACCESS_H_

#include "OS_Common.h"

#include "OpenDRIM_OperatingSystem.h"

int OS_OpenDRIM_OperatingSystem_load(const CMPIBroker* broker, string& errorMessage);

int OS_OpenDRIM_OperatingSystem_unload(string& errorMessage);

int OS_OpenDRIM_OperatingSystem_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_OperatingSystem>& instances, const char** properties, string& errorMessage, const string& discriminant);

int OS_OpenDRIM_OperatingSystem_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_OperatingSystem& instance, const char** properties, string& errorMessage);

int OS_OpenDRIM_OperatingSystem_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OperatingSystem& newInstance, const OpenDRIM_OperatingSystem& oldInstance, const char** properties, string& errorMessage);

int OS_OpenDRIM_OperatingSystem_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OperatingSystem& instance, string& errorMessage);

int OS_OpenDRIM_OperatingSystem_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OperatingSystem& instance, string& errorMessage);

int OS_OpenDRIM_OperatingSystem_RequestStateChange(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OperatingSystem& instance, unsigned int& returnValue, const OpenDRIM_OperatingSystem_RequestStateChange_In& in, OpenDRIM_OperatingSystem_RequestStateChange_Out& out, string& errorMessage);

int OS_OpenDRIM_OperatingSystem_Shutdown(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OperatingSystem& instance, unsigned int& returnValue, string& errorMessage);

int OS_OpenDRIM_OperatingSystem_Reboot(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OperatingSystem& instance, unsigned int& returnValue, string& errorMessage);

int OS_OpenDRIM_OperatingSystem_populate(OpenDRIM_OperatingSystem& instance, string& errorMessage);

int OS_OpenDRIM_OperatingSystem_getOperatingSystemInfo(OpenDRIM_OperatingSystem& instance, string& errorMessage);

int OS_OpenDRIM_OperatingSystem_getVersion(string& Version, string& errorMessage);

int OS_OpenDRIM_OperatingSystem_getLastBootUpTime(string& LastBootUpTime, string& errorMessage);

int OS_OpenDRIM_OperatingSystem_getNumberOfUsers(unsigned long& NumberOfUsers, string& errorMessage);

int OS_OpenDRIM_OperatingSystem_getNumberOfProcesses(unsigned long& NumberOfProcesses, string& errorMessage);

int OS_OpenDRIM_OperatingSystem_getMaxNumberOfProcesses(unsigned long& MaxNumberOfProcesses, string& errorMessage);

int OS_OpenDRIM_OperatingSystem_getMaxProcessMemorySize(unsigned long& MaxProcessMemorySize, string& errorMessage);

int OS_OpenDRIM_OperatingSystem_getMaxProcessPerUser(unsigned long& MaxProcessPerUser, string& errorMessage);

int OS_OpenDRIM_OperatingSystem_getElementName(string& ElementName, string& errorMessage);

int OS_OpenDRIM_OperatingSystem_getDateOfInstallation(unsigned long& DateOfInstallation, string& errorMessage);

int OS_OpenDRIM_OperatingSystem_isShuttingDown(bool& shutting_down, string& errorMessage);

int OS_OpenDRIM_OperatingSystem_isRebooting(bool& rebooting, string& errorMessage);

int OS_OpenDRIM_OperatingSystem_isStressed(bool& stressed, string& errorMessage);

int OS_OpenDRIM_OperatingSystem_getNumberOfLogicalCPU(unsigned long& NumberOfLogicalCPU, string& errorMessage);

int OS_OpenDRIM_OperatingSystem_getMemoryInfo(OpenDRIM_OperatingSystem& instance, string& errorMessage);

#endif /*OPENDRIM_OPERATINGSYSTEMACCESS_H_*/
