---
id: uploading
title: Uploading edits to Wikibase
sidebar_label: Uploading edits
---

This page explains how to upload your edits to the target Wikibase. It assumes you already have a created a Wikibase schema in your OpenRefine project.

## Uploading with OpenRefine {#uploading-with-openrefine}

* Click <span class="menuItems">Wikidata</span> → <span class="menuItems">Upload edits to Wikidata</span>.
* Log in with your personal account or your bot account depending on which account you want to use to make the edits. It is a good practice to use a [bot password](https://www.mediawiki.org/wiki/Manual:Bot_passwords). 
* Supply a meaningful edit summary. This is especially important because OpenRefine condenses all your changes on the same item as one edit: if you are making multiple changes, the edit summary generated by Wikibase will not indicate clearly what sort of change you made. If you are making atomic changes, such as adding a single alias or statement, the automatic edit summaries will be more meaningful. If supported by your Wikibase instance, OpenRefine will append a link to the [EditGroups](https://editgroups.toolforge.org/) tool, which lets you track and analyze your edit batch after upload.
* Click <span class="buttonLabels">Perform edits</span> and wait for the operation to complete. You can watch your edits being made by checking your wiki contributions or the EditGroups tool.

Because performing edits in OpenRefine counts as an operation, you can extract this operation and reapply it to other projects. If you do so, you should also include the operation that saves the schema (only the last one is required), and make sure that the column names in the schema match those of the OpenRefine project where you are applying the operation.

## Uploading with QuickStatements {#uploading-with-quickstatements}

This requires that the Wikibase site has an associated [QuickStatements](https://meta.wikimedia.org/wiki/QuickStatements) tool.

* Click <span class="menuItems">Wikibase</span> → <span class="menuItems">Export to QuickStatements</span> and copy the contents of the file;
* Go to QuickStatements (for Wikidata it can be found at https://quickstatements.toolforge.org/) and login to authorize the tool to use your account;
* Click <span class="buttonLabels">Version 1 format</span>;
* Paste the generated changes in the text area;
* Perform the edits with <span class="buttonLabels">Run</span> or <span class="buttonLabels">Run in background</span>.

## Notable differences between the two methods {#notable-differences-between-the-two-methods}

### Merging strategy for terms and statements {#merging-strategy-for-terms-and-statements}

OpenRefine offers various merging strategies for terms and statements. QuickStatements only supports one non-configurable merging strategy. Therefore, the merging strategies specified by the user in the schema are ignored when exporting to QuickStatements,
which can result in unintended changes.

### New item creation {#new-item-creation}

OpenRefine supports creating new items with arbitrary relations between them.

QuickStatements supports creating new items with the <code>CREATE</code> instruction, and subsequent instructions can use the <code>LAST</code> placeholder to use the Qid of the last created item. When generating QuickStatements instructions, OpenRefine reorders your edits so that this syntax can be used. In rare cases, such as when a statement links two newly-created items, it is impossible to use QuickStatements to perform the edit. In this case, no QuickStatements script will be generated.

### Speed and number of edits {#speed-and-number-of-edits}

OpenRefine generally performs one edit per item touched by an edit batch and at most two in general (in the case where new items contain links between them). This was chosen to minimize server load, speed up the upload and keep item histories compact. The downside is that the edit summaries can be less meaningful - it is therefore important that users supply informative summaries when uploading their batches. OpenRefine asymptotically edits at the rate of 60 edits per minute (so, usually 60 items per minute). The first edits are made more quickly, which is convenient for small batches.

QuickStatements performs incremental edits (for instance, when adding a statement with a qualifier and a reference, it will make three edits). That generally means lower speed, but more explicit item histories.

