char volume_vert[] = "#version 110\n"
                     "varying vec4 cameraPos;\n"
                     "varying vec4 vertexPos;\n"
                     "varying vec3 lightDirection;\n"
                     "varying mat4 texgen;\n"
                     "varying vec4 baseColor;\n"
                     "\n"
                     "void main(void)\n"
                     "{\n"
                     "        gl_Position = ftransform();\n"
                     "\n"
                     "        cameraPos = gl_ModelViewMatrixInverse * vec4(0,0,0,1);\n"
                     "        vertexPos = gl_Vertex;\n"
                     "        baseColor = gl_FrontMaterial.diffuse;\n"
                     "\n"
                     "        vec4 lightPosition = gl_ModelViewMatrixInverse * gl_LightSource[0].position;\n"
                     "        if (lightPosition[3]==0.0)\n"
                     "        {\n"
                     "            // directional light source\n"
                     "            lightDirection = -normalize(lightPosition.xyz);\n"
                     "        }\n"
                     "        else\n"
                     "        {\n"
                     "            // positional light source\n"
                     "            lightDirection = normalize((lightPosition-vertexPos).xyz);\n"
                     "        }\n"
                     "\n"
                     "\n"
                     "        texgen = mat4(gl_ObjectPlaneS[0], \n"
                     "                      gl_ObjectPlaneT[0],\n"
                     "                      gl_ObjectPlaneR[0],\n"
                     "                      gl_ObjectPlaneQ[0]);\n"
                     "}\n"
                     "\n";
