/**********************************************************************
 *
 *    FILE:            ShadeModel.cpp
 *
 *    DESCRIPTION:    Read/Write osg::ShadeModel in binary format to disk.
 *
 *    CREATED BY:        Auto generated by iveGenerator
 *                    and later modified by Rune Schmidt Jensen.
 *
 *    HISTORY:        Created 27.3.2003
 *
 *    Copyright 2003 VR-C
 **********************************************************************/

#include "Exception.h"
#include "ShadeModel.h"
#include "Object.h"

using namespace ive;

void ShadeModel::write(DataOutputStream* out){
    // Write CullFace's identification.
    out->writeInt(IVESHADEMODEL);
    // If the osg class is inherited by any other class we should also write this to file.
    osg::Object*  obj = dynamic_cast<osg::Object*>(this);
    if(obj){
        ((ive::Object*)(obj))->write(out);
    }
    else
        out_THROW_EXCEPTION("ShadeModel::write(): Could not cast this osg::ShadeModel to an osg::Object.");
    // Write ShadeModel's properties.
    out->writeInt(getMode());
}

void ShadeModel::read(DataInputStream* in){
    // Peek on ShadeModel's identification.
    int id = in->peekInt();
    if(id == IVESHADEMODEL){
        // Read ShadeModel's identification.
        id = in->readInt();
        // If the osg class is inherited by any other class we should also read this from file.
        osg::Object*  obj = dynamic_cast<osg::Object*>(this);
        if(obj){
            ((ive::Object*)(obj))->read(in);
        }
        else
            in_THROW_EXCEPTION("ShadeModel::read(): Could not cast this osg::ShadeModel to an osg::Object.");
        // Read ShadeModel's properties
        setMode((Mode)in->readInt());
    }
    else{
        in_THROW_EXCEPTION("ShadeModel::read(): Expected ShadeModel identification.");
    }
}
