# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1080-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56834);
 script_bugtraq_id(17961);
 script_cve_id("CVE-2006-2414");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 1080-1 (dovecot)";
 script_name(name);

 desc = "The remote host is missing an update to dovecot
announced via advisory DSA 1080-1.

A problem has been discovered in the IMAP component of Dovecot, a
secure mail server that supports mbox and maildir mailboxes, which can
lead to information disclosure via directory traversal by
authenticated users.

The old stable distribution (woody) is not affected by this problem.

For the stable distribution (sarge) this problem has been fixed in
version 0.99.14-1sarge0.

For the unstable distribution (sid) this problem has been fixed in
version 1.0beta8-1.

We recommend that you upgrade your dovecot-imapd package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201080-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1080-1 (dovecot)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"dovecot", ver:"0.99.14-1sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dovecot-common", ver:"0.99.14-1sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dovecot-imapd", ver:"0.99.14-1sarge0", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"dovecot-pop3d", ver:"0.99.14-1sarge0", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
