# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 595-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53285);
 script_bugtraq_id(11647);
 script_cve_id("CVE-2004-1052");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 595-1 (bnc)";
 script_name(name);

 desc = "The remote host is missing an update to bnc
announced via advisory DSA 595-1.

Leon Juranic discovered that BNC, an IRC session bouncing proxy, does
not always protect buffers from being overwritten.  This could
exploited by a malicious IRC server to overflow a buffer of limited
size and execute arbitrary code on the client host.

For the stable distribution (woody) this problem has been fixed in
version 2.6.4-3.3.

This package does not exist in the testing or unstable distributions.

We recommend that you upgrade your bnc package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20595-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 595-1 (bnc)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"bnc", ver:"2.6.4-3.3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
