# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 980-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56320);
 script_cve_id("CVE-2004-2161", "CVE-2004-2162");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 980-1 (tutos)";
 script_name(name);

 desc = "The remote host is missing an update to tutos
announced via advisory DSA 980-1.

Joxean Koret discovered several security problems in tutos, a web-based
team organization software. The Common Vulnerabilities and Exposures Project
identifies the following problems:

CVE-2004-2161

An SQL injection vulnerability allows the execution of SQL commands
through the link_id parameter in file_overview.php.

CVE-2004-2162

Cross-Site-Scripting vulnerabilities in the search function of the
address book and in app_new.php allow the execution of web script
code.

The old stable distribution (woody) does not contain tutos packages.

For the stable distribution (sarge) these problems have been fixed in
version 1.1.20031017-2+1sarge1.

The unstable distribution (sid) does no longer contain tutos packages.

We recommend that you upgrade your tutos package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20980-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 980-1 (tutos)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"tutos", ver:"1.1.20031017-2+1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
