#
#VID da185955-5738-11de-b857-000f20797ede
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID da185955-5738-11de-b857-000f20797ede
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64204);
 script_cve_id("CVE-2009-1392", "CVE-2009-1832", "CVE-2009-1833", "CVE-2009-1834", "CVE-2009-1835", "CVE-2009-1836", "CVE-2009-1837", "CVE-2009-1838", "CVE-2009-1839", "CVE-2009-1840", "CVE-2009-1841");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "FreeBSD Ports: firefox";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   firefox
   linux-firefox
   linux-firefox-devel
   firefox3
   thunderbird
   linux-thunderbird
   seamonkey
   linux-seamonkey

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.mozilla.org/security/announce/2009/mfsa2009-24.html
http://www.mozilla.org/security/announce/2009/mfsa2009-25.html
http://www.mozilla.org/security/announce/2009/mfsa2009-26.html
http://www.mozilla.org/security/announce/2009/mfsa2009-27.html
http://www.mozilla.org/security/announce/2009/mfsa2009-28.html
http://www.mozilla.org/security/announce/2009/mfsa2009-29.html
http://www.mozilla.org/security/announce/2009/mfsa2009-30.html
http://www.mozilla.org/security/announce/2009/mfsa2009-31.html
http://www.mozilla.org/security/announce/2009/mfsa2009-32.html
http://secunia.com/advisories/35331/
http://www.vuxml.org/freebsd/da185955-5738-11de-b857-000f20797ede.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: firefox";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"firefox");
if(!isnull(bver) && revcomp(a:bver, b:"2.0.0.20_8,1")<0) {
    security_note(0, data:"Package firefox version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-firefox");
if(!isnull(bver) && revcomp(a:bver, b:"0")>0) {
    security_note(0, data:"Package linux-firefox version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-firefox-devel");
if(!isnull(bver) && revcomp(a:bver, b:"0")>0) {
    security_note(0, data:"Package linux-firefox-devel version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"firefox3");
if(!isnull(bver) && revcomp(a:bver, b:"3.0.11")<0) {
    security_note(0, data:"Package firefox3 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"thunderbird");
if(!isnull(bver) && revcomp(a:bver, b:"2.0.0.22")<0) {
    security_note(0, data:"Package thunderbird version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-thunderbird");
if(!isnull(bver) && revcomp(a:bver, b:"2.0.0.22")<0) {
    security_note(0, data:"Package linux-thunderbird version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"seamonkey");
if(!isnull(bver) && revcomp(a:bver, b:"1.1.17")<0) {
    security_note(0, data:"Package seamonkey version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-seamonkey");
if(!isnull(bver) && revcomp(a:bver, b:"1.1.17")<0) {
    security_note(0, data:"Package linux-seamonkey version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
