#
#VID 9d3020e4-a2c4-11dd-a9f9-0030843d3802
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 9d3020e4-a2c4-11dd-a9f9-0030843d3802
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61798);
 script_cve_id("CVE-2007-6461", "CVE-2008-1165", "CVE-2008-1166");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Ports: flyspray";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: flyspray

CVE-2007-6461
Multiple cross-site scripting (XSS) vulnerabilities in index.php in
Flyspray 0.9.9 through 0.9.9.3 allow remote attackers to inject
arbitrary web script or HTML via (1) the query string in an index
action, related to the savesearch JavaScript function; and (2) the
details parameter in a details action, related to the History tab and
the getHistory JavaScript function.

CVE-2008-1165
Multiple cross-site scripting (XSS) vulnerabilities in Flyspray 0.9.9
through 0.9.9.4 allow remote attackers to inject arbitrary web script
or HTML via (1) a forced SQL error message or (2) old_value and
new_value database fields in task summaries, related to the
item_summary parameter in a details action in index.php.  NOTE: some of
these details are obtained from third party information.

CVE-2008-1166
Flyspray 0.9.9.4 generates different error messages depending on
whether the username is valid or invalid, which allows remote
attackers to enumerate usernames.  NOTE: the provenance of this
information is unknown; the details are obtained solely from third
party information.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/29215
http://www.vuxml.org/freebsd/9d3020e4-a2c4-11dd-a9f9-0030843d3802.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: flyspray";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"flyspray");
if(!isnull(bver) && revcomp(a:bver, b:"0.9.9.5.1")<0) {
    security_note(0, data:"Package flyspray version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
