#
#VID 2001103a-6bbd-11d9-851d-000a95bc6fae
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52220);
 script_cve_id("CVE-2004-1025", "CVE-2004-1026");
 script_bugtraq_id(11830);
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "FreeBSD Ports: imlib";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   imlib
   imlib2

CVE-2004-1025
Multiple heap-based buffer overflows in imlib 1.9.14 and earlier,
which is used by gkrellm and several window managers, allow remote
attackers to cause a denial of service (application crash) and execute
arbitrary code via certain image files.

CVE-2004-1026
Multiple integer overflows in the image handler for imlib 1.9.14 and
earlier, which is used by gkrellm and several window managers, allow
remote attackers to cause a denial of service (application crash) and
execute arbitrary code via certain image files.

Solution:
Update your system with the appropriate patches or
software upgrades.

https://bugzilla.fedora.us/show_bug.cgi?id=2051#c11
https://bugzilla.redhat.com/bugzilla/show_bug.cgi?id=138516
http://cvs.sourceforge.net/viewcvs.py/enlightenment/e17/libs/imlib2/src/modules/loaders/loader_xpm.c#rev1.3
http://www.vuxml.org/freebsd/2001103a-6bbd-11d9-851d-000a95bc6fae.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: imlib";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"imlib");
if(!isnull(bver) && revcomp(a:bver, b:"1.9.15_2")<0) {
    security_note(0, data:"Package imlib version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"imlib2");
if(!isnull(bver) && revcomp(a:bver, b:"1.1.2_1")<0) {
    security_note(0, data:"Package imlib2 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
