###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_backuppc_detect.nasl 5063 2009-10-06 16:05:29Z oct $
#
# BackupPC Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801106);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("BackupPC Version Detection");
  desc = "
  Overview: This script detects the installed version of BackupPC and
  sets the reuslt in KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Set KB for the version of BackupPC");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

backupSock = ssh_login_or_reuse_connection();
if(!backupSock){
  exit(0);
}

backupName = find_bin(prog_name:"BackupPC", sock:backupSock);
foreach binName (backupName)
{
  backupVer = get_bin_version(full_prog_name:"cat", version_argv:binName,
                               ver_pattern:"Version ([0-9]\.[0-9]\.[0-9]+"+
                               "(beta[0-9])?)", sock:backupSock);
  if(backupVer[1] != NULL)
  {
    set_kb_item(name:"BackupPC/Ver", value:backupVer[1]);
    security_note(data:"Backup PC version " + backupVer[1] + " running at" +
                       " location " + binName +  " was detected on the host");
  }
}
ssh_close_connection();
