###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_cpcreator_detect.nasl 4962 2009-10-05 16:25:36Z oct $
#
# cP Creator Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801005);
  script_version("$Revision: 1.0$");
  script_tag(name:"risk_factor", value:"None");
  script_name("cP Creator Version Detection");
  desc = "
  Overview: This script finds the installed cP Creator version and saves
  the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Set the version of cP Creator in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

cpcreatPort = get_http_port(default:80);
if(!cpcreatPort){
  exit(0);
}

foreach path (make_list("/", "/cPcreator", "/cp", cgi_dirs()))
{
  sndReq = http_get(item:string(path, "/index.php"), port:cpcreatPort);
  rcvRes = http_send_recv(port:cpcreatPort, data:sndReq);
  if("cP Creator" >< rcvRes)
  {
    cpcreatVer = eregmatch(pattern:"[V|v]([0-9.]+)", string:rcvRes);
    if(cpcreatVer[1] != NULL)
    {
      set_kb_item(name:"www/" + cpcreatPort + "/cPCreator",
                  value:cpcreatVer[1] + " under " + path);
      security_note(data:"Cp Creator version " + cpcreatVer[1] + " running at" + 
                         " location " + path + " was detected on the host");
    }
  }
}
