###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for wget FEDORA-2007-043
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861583);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "FEDORA", value: "2007-043");
  script_cve_id("CVE-2006-6719");
  script_name( "Fedora Update for wget FEDORA-2007-043");
  desc = "

  Vulnerability Insight:
  GNU Wget is a file retrieval utility which can use either the HTTP or
  FTP protocols. Wget features include the ability to work in the
  background while you are logged out, recursive retrieval of
  directories, file name wildcard matching, remote file timestamp
  storage and comparison, use of Rest with FTP servers and Range with
  HTTP servers to retrieve files over slow or unstable connections,
  support for Proxy servers, and configurability


  Affected Software/OS:
  wget on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-January/msg00056.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of wget");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"wget", rpm:"wget~1.10.2~8.fc6.1", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/wget-debuginfo", rpm:"x86_64/debug/wget-debuginfo~1.10.2~8.fc6.1", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/wget", rpm:"x86_64/wget~1.10.2~8.fc6.1", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/wget-debuginfo", rpm:"i386/debug/wget-debuginfo~1.10.2~8.fc6.1", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/wget", rpm:"i386/wget~1.10.2~8.fc6.1", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}